import{s as Dt,a as qt,o as Pt,n as At}from"../chunks/scheduler.56725da7.js";import{S as Ot,i as Kt,e as s,s as a,c as r,h as en,a as o,d as n,b as i,f as N,g as m,j as f,k as h,l as ye,m as l,n as p,t as u,o as d,p as c}from"../chunks/index.18a26576.js";import{T as tn}from"../chunks/Tip.5b941656.js";import{D as ve}from"../chunks/Docstring.185d8bd7.js";import{C as Je}from"../chunks/CodeBlock.e59f1853.js";import{H as M}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d7e7b6b3.js";function nn($e){let g,$="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){g=s("p"),g.textContent=$},l(b){g=o(b,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1323ut2"&&(g.textContent=$)},m(b,Te){l(b,g,Te)},p:At,d(b){b&&n(g)}}}function ln($e){let g,$,b,Te,Z,Ze,j,vt='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-xl-txt2img.ipynb" rel="nofollow">here</a></em>.',je,I,Ie,W,Nt="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",We,X,$t="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",Xe,C,Ce,G,Zt="To deploy SDXL models, we will start by compiling the models. We support the export of following components in the pipeline to boost the speed:",Ge,S,jt="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",Se,x,It="You can either compile and export a Stable Diffusion XL Checkpoint via CLI or <code>NeuronStableDiffusionXLPipeline</code> class.",xe,B,Be,V,Wt="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",Ve,k,ke,U,Xt="<p>We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.</p>",Le,L,Re,R,Ct="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",He,H,ze,z,Qe,Q,Gt="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",Ye,Y,Ee,y,St,Fe,E,qe,F,xt="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",De,q,Pe,D,Bt='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',Ae,P,Oe,A,Vt="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",Ke,O,et,K,kt='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',tt,ee,nt,te,Lt='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',lt,ne,Rt="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",at,le,it,ae,st,J,Ht,ot,ie,rt,se,mt,oe,zt='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',pt,v,ut,re,dt,T,me,wt,we,pe,ct,ue,ft,w,de,_t,_e,ce,gt,fe,ht,_,ge,Ut,Ue,he,Mt,Me,Qt='Are there any other diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',bt,Ne,yt;return Z=new M({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),I=new M({props:{title:"Overview",local:"overview",headingTag:"h2"}}),C=new M({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),B=new M({props:{title:"Option 1: CLI",local:"option-1-cli",headingTag:"h3"}}),k=new Je({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMC0taGVpZ2h0JTIwMTAyNCUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLXdpZHRoJTIwMTAyNCUyMCU2MCUyMyUyMHdpZHRoJTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNzY4JTJDJTIwMTAyNCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbl94bCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 1 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),L=new M({props:{title:"Option 2: Python API",local:"option-2-python-api",headingTag:"h3"}}),H=new Je({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

&lt;CopyLLMTxtMenu containerStyle=<span class="hljs-string">&quot;float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;&quot;</span>&gt;&lt;/CopyLLMTxtMenu&gt;

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),z=new M({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h2"}}),Y=new Je({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),E=new M({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h2"}}),q=new Je({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),P=new M({props:{title:"Inpaint",local:"inpaint",headingTag:"h2"}}),O=new Je({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ee=new M({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h2"}}),le=new M({props:{title:"Base + Refiner Model",local:"base--refiner-model",headingTag:"h3"}}),ae=new Je({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHJlZmluZXIoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0YXJ0JTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ie=new M({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h3"}}),se=new Je({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),v=new tn({props:{$$slots:{default:[nn]},$$scope:{ctx:$e}}}),re=new M({props:{title:"NeuronStableDiffusionXLPipeline",local:"optimum.neuron.NeuronStableDiffusionXLPipeline",headingTag:"h2"}}),me=new ve({props:{name:"class optimum.neuron.NeuronStableDiffusionXLPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.1/optimum/neuron/modeling_diffusion.py#L1597"}}),pe=new ve({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.1/optimum/neuron/modeling_diffusion.py#L1106"}}),ue=new M({props:{title:"NeuronStableDiffusionXLImg2ImgPipeline",local:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",headingTag:"h2"}}),de=new ve({props:{name:"class optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.1/optimum/neuron/modeling_diffusion.py#L1610"}}),ce=new ve({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.1/optimum/neuron/modeling_diffusion.py#L1106"}}),fe=new M({props:{title:"NeuronStableDiffusionXLInpaintPipeline",local:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",headingTag:"h2"}}),ge=new ve({props:{name:"class optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.1/optimum/neuron/modeling_diffusion.py#L1617"}}),he=new ve({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.1/optimum/neuron/modeling_diffusion.py#L1106"}}),{c(){g=s("meta"),$=a(),b=s("p"),Te=a(),r(Z.$$.fragment),Ze=a(),j=s("p"),j.innerHTML=vt,je=a(),r(I.$$.fragment),Ie=a(),W=s("p"),W.textContent=Nt,We=a(),X=s("p"),X.innerHTML=$t,Xe=a(),r(C.$$.fragment),Ce=a(),G=s("p"),G.textContent=Zt,Ge=a(),S=s("ul"),S.innerHTML=jt,Se=a(),x=s("p"),x.innerHTML=It,xe=a(),r(B.$$.fragment),Be=a(),V=s("p"),V.innerHTML=Wt,Ve=a(),r(k.$$.fragment),ke=a(),U=s("blockquote"),U.innerHTML=Xt,Le=a(),r(L.$$.fragment),Re=a(),R=s("p"),R.innerHTML=Ct,He=a(),r(H.$$.fragment),ze=a(),r(z.$$.fragment),Qe=a(),Q=s("p"),Q.textContent=Gt,Ye=a(),r(Y.$$.fragment),Ee=a(),y=s("img"),Fe=a(),r(E.$$.fragment),qe=a(),F=s("p"),F.innerHTML=xt,De=a(),r(q.$$.fragment),Pe=a(),D=s("table"),D.innerHTML=Bt,Ae=a(),r(P.$$.fragment),Oe=a(),A=s("p"),A.innerHTML=Vt,Ke=a(),r(O.$$.fragment),et=a(),K=s("table"),K.innerHTML=kt,tt=a(),r(ee.$$.fragment),nt=a(),te=s("p"),te.innerHTML=Lt,lt=a(),ne=s("ol"),ne.innerHTML=Rt,at=a(),r(le.$$.fragment),it=a(),r(ae.$$.fragment),st=a(),J=s("img"),ot=a(),r(ie.$$.fragment),rt=a(),r(se.$$.fragment),mt=a(),oe=s("table"),oe.innerHTML=zt,pt=a(),r(v.$$.fragment),ut=a(),r(re.$$.fragment),dt=a(),T=s("div"),r(me.$$.fragment),wt=a(),we=s("div"),r(pe.$$.fragment),ct=a(),r(ue.$$.fragment),ft=a(),w=s("div"),r(de.$$.fragment),_t=a(),_e=s("div"),r(ce.$$.fragment),gt=a(),r(fe.$$.fragment),ht=a(),_=s("div"),r(ge.$$.fragment),Ut=a(),Ue=s("div"),r(he.$$.fragment),Mt=a(),Me=s("p"),Me.innerHTML=Qt,bt=a(),Ne=s("p"),this.h()},l(e){const t=en("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(n),$=i(e),b=o(e,"P",{}),N(b).forEach(n),Te=i(e),m(Z.$$.fragment,e),Ze=i(e),j=o(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-1q6nuso"&&(j.innerHTML=vt),je=i(e),m(I.$$.fragment,e),Ie=i(e),W=o(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-7xctqf"&&(W.textContent=Nt),We=i(e),X=o(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1g87d8z"&&(X.innerHTML=$t),Xe=i(e),m(C.$$.fragment,e),Ce=i(e),G=o(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-kgotmp"&&(G.textContent=Zt),Ge=i(e),S=o(e,"UL",{"data-svelte-h":!0}),f(S)!=="svelte-17e9k9s"&&(S.innerHTML=jt),Se=i(e),x=o(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-luqtn4"&&(x.innerHTML=It),xe=i(e),m(B.$$.fragment,e),Be=i(e),V=o(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-9niqj3"&&(V.innerHTML=Wt),Ve=i(e),m(k.$$.fragment,e),ke=i(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(U)!=="svelte-6gfoqi"&&(U.innerHTML=Xt),Le=i(e),m(L.$$.fragment,e),Re=i(e),R=o(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-17tzr0c"&&(R.innerHTML=Ct),He=i(e),m(H.$$.fragment,e),ze=i(e),m(z.$$.fragment,e),Qe=i(e),Q=o(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-8q3qyn"&&(Q.textContent=Gt),Ye=i(e),m(Y.$$.fragment,e),Ee=i(e),y=o(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Fe=i(e),m(E.$$.fragment,e),qe=i(e),F=o(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-luub4o"&&(F.innerHTML=xt),De=i(e),m(q.$$.fragment,e),Pe=i(e),D=o(e,"TABLE",{"data-svelte-h":!0}),f(D)!=="svelte-1s0d0pv"&&(D.innerHTML=Bt),Ae=i(e),m(P.$$.fragment,e),Oe=i(e),A=o(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-11fbw00"&&(A.innerHTML=Vt),Ke=i(e),m(O.$$.fragment,e),et=i(e),K=o(e,"TABLE",{"data-svelte-h":!0}),f(K)!=="svelte-18741xe"&&(K.innerHTML=kt),tt=i(e),m(ee.$$.fragment,e),nt=i(e),te=o(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-1usq821"&&(te.innerHTML=Lt),lt=i(e),ne=o(e,"OL",{"data-svelte-h":!0}),f(ne)!=="svelte-6p4eqi"&&(ne.innerHTML=Rt),at=i(e),m(le.$$.fragment,e),it=i(e),m(ae.$$.fragment,e),st=i(e),J=o(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),ot=i(e),m(ie.$$.fragment,e),rt=i(e),m(se.$$.fragment,e),mt=i(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),f(oe)!=="svelte-1s7g03c"&&(oe.innerHTML=zt),pt=i(e),m(v.$$.fragment,e),ut=i(e),m(re.$$.fragment,e),dt=i(e),T=o(e,"DIV",{class:!0});var be=N(T);m(me.$$.fragment,be),wt=i(be),we=o(be,"DIV",{class:!0});var Yt=N(we);m(pe.$$.fragment,Yt),Yt.forEach(n),be.forEach(n),ct=i(e),m(ue.$$.fragment,e),ft=i(e),w=o(e,"DIV",{class:!0});var Jt=N(w);m(de.$$.fragment,Jt),_t=i(Jt),_e=o(Jt,"DIV",{class:!0});var Et=N(_e);m(ce.$$.fragment,Et),Et.forEach(n),Jt.forEach(n),gt=i(e),m(fe.$$.fragment,e),ht=i(e),_=o(e,"DIV",{class:!0});var Tt=N(_);m(ge.$$.fragment,Tt),Ut=i(Tt),Ue=o(Tt,"DIV",{class:!0});var Ft=N(Ue);m(he.$$.fragment,Ft),Ft.forEach(n),Tt.forEach(n),Mt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1wos5lv"&&(Me.innerHTML=Qt),bt=i(e),Ne=o(e,"P",{}),N(Ne).forEach(n),this.h()},h(){h(g,"name","hf:doc:metadata"),h(g,"content",an),h(U,"class","tip"),qt(y.src,St="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||h(y,"src",St),h(y,"width","256"),h(y,"height","256"),h(y,"alt","sdxl generated image"),qt(J.src,Ht="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||h(J,"src",Ht),h(J,"width","256"),h(J,"height","256"),h(J,"alt","sdxl base + refiner"),h(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),h(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){ye(document.head,g),l(e,$,t),l(e,b,t),l(e,Te,t),p(Z,e,t),l(e,Ze,t),l(e,j,t),l(e,je,t),p(I,e,t),l(e,Ie,t),l(e,W,t),l(e,We,t),l(e,X,t),l(e,Xe,t),p(C,e,t),l(e,Ce,t),l(e,G,t),l(e,Ge,t),l(e,S,t),l(e,Se,t),l(e,x,t),l(e,xe,t),p(B,e,t),l(e,Be,t),l(e,V,t),l(e,Ve,t),p(k,e,t),l(e,ke,t),l(e,U,t),l(e,Le,t),p(L,e,t),l(e,Re,t),l(e,R,t),l(e,He,t),p(H,e,t),l(e,ze,t),p(z,e,t),l(e,Qe,t),l(e,Q,t),l(e,Ye,t),p(Y,e,t),l(e,Ee,t),l(e,y,t),l(e,Fe,t),p(E,e,t),l(e,qe,t),l(e,F,t),l(e,De,t),p(q,e,t),l(e,Pe,t),l(e,D,t),l(e,Ae,t),p(P,e,t),l(e,Oe,t),l(e,A,t),l(e,Ke,t),p(O,e,t),l(e,et,t),l(e,K,t),l(e,tt,t),p(ee,e,t),l(e,nt,t),l(e,te,t),l(e,lt,t),l(e,ne,t),l(e,at,t),p(le,e,t),l(e,it,t),p(ae,e,t),l(e,st,t),l(e,J,t),l(e,ot,t),p(ie,e,t),l(e,rt,t),p(se,e,t),l(e,mt,t),l(e,oe,t),l(e,pt,t),p(v,e,t),l(e,ut,t),p(re,e,t),l(e,dt,t),l(e,T,t),p(me,T,null),ye(T,wt),ye(T,we),p(pe,we,null),l(e,ct,t),p(ue,e,t),l(e,ft,t),l(e,w,t),p(de,w,null),ye(w,_t),ye(w,_e),p(ce,_e,null),l(e,gt,t),p(fe,e,t),l(e,ht,t),l(e,_,t),p(ge,_,null),ye(_,Ut),ye(_,Ue),p(he,Ue,null),l(e,Mt,t),l(e,Me,t),l(e,bt,t),l(e,Ne,t),yt=!0},p(e,[t]){const be={};t&2&&(be.$$scope={dirty:t,ctx:e}),v.$set(be)},i(e){yt||(u(Z.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(k.$$.fragment,e),u(L.$$.fragment,e),u(H.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(v.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),yt=!0)},o(e){d(Z.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(k.$$.fragment,e),d(L.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(se.$$.fragment,e),d(v.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(he.$$.fragment,e),yt=!1},d(e){e&&(n($),n(b),n(Te),n(Ze),n(j),n(je),n(Ie),n(W),n(We),n(X),n(Xe),n(Ce),n(G),n(Ge),n(S),n(Se),n(x),n(xe),n(Be),n(V),n(Ve),n(ke),n(U),n(Le),n(Re),n(R),n(He),n(ze),n(Qe),n(Q),n(Ye),n(Ee),n(y),n(Fe),n(qe),n(F),n(De),n(Pe),n(D),n(Ae),n(Oe),n(A),n(Ke),n(et),n(K),n(tt),n(nt),n(te),n(lt),n(ne),n(at),n(it),n(st),n(J),n(ot),n(rt),n(mt),n(oe),n(pt),n(ut),n(dt),n(T),n(ct),n(ft),n(w),n(gt),n(ht),n(_),n(Mt),n(Me),n(bt),n(Ne)),n(g),c(Z,e),c(I,e),c(C,e),c(B,e),c(k,e),c(L,e),c(H,e),c(z,e),c(Y,e),c(E,e),c(q,e),c(P,e),c(O,e),c(ee,e),c(le,e),c(ae,e),c(ie,e),c(se,e),c(v,e),c(re,e),c(me),c(pe),c(ue,e),c(de),c(ce),c(fe,e),c(ge),c(he)}}}const an='{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2}';function sn($e){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Ot{constructor(g){super(),Kt(this,g,sn,ln,Dt,{})}}export{cn as component};
