import{s as Ne,n as He,o as Le}from"../chunks/scheduler.78382b47.js";import{S as Se,i as Ye,e as i,s,c as p,h as ze,a as o,d as l,b as n,f as Qe,g as m,j as d,k as ge,l as Pe,m as a,n as r,t as c,o as M,p as f}from"../chunks/index.6dd35eb6.js";import{C as De,H as Y,E as Ke}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8d7e60c0.js";import{C as H}from"../chunks/CodeBlock.4d4112a9.js";function qe(Ce){let h,z,L,P,T,D,w,K,y,Ze="With PEFT, you can inject trainable adapters into any <code>torch</code> module which allows you to use adapter methods without relying on the modeling classes in PEFT. This works for all adapters except for those based on prompt learning (e.g. prefix tuning or p-tuning).",q,_,ke="Check the table below to see when you should inject adapters.",O,J,Ie="<thead><tr><th>Pros</th> <th>Cons</th></tr></thead> <tbody><tr><td>the model is modified inplace, keeping all the original attributes and methods</td> <td>manually write the <code>from_pretrained</code> and <code>save_pretrained</code> utility functions from Hugging Face to save and load adapters</td></tr> <tr><td>works for any <code>torch</code> module and modality</td> <td>doesn’t work with any of the utility methods provided by <code>PeftModel</code> such as disabling and merging adapters</td></tr></tbody>",ee,b,te,j,We='To perform the adapter injection, use the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> method. This method takes 3 arguments, the PEFT config, the model, and an optional adapter name. You can also attach multiple adapters to the model if you call <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> multiple times with different adapter names.',le,U,Ee="For example, to inject LoRA adapters into the <code>linear</code> submodule of the <code>DummyModel</code> module:",ae,g,se,C,Be="Print the model to see that the adapters have been correctly injected.",ne,Z,ie,k,oe,I,$e='Sometimes, it is possible that there is a PEFT adapter checkpoint but the corresponding PEFT config is not known for whatever reason. To inject the PEFT layers for this checkpoint, you would usually have to reverse-engineer the corresponding PEFT config, most notably the <code>target_modules</code> argument, based on the <code>state_dict</code> from the checkpoint. This can be cumbersome and error prone. To avoid this, it is also possible to call <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> and pass the loaded <code>state_dict</code> as an argument:',de,W,pe,E,ve="In this case, PEFT will use the <code>state_dict</code> as reference for which layers to target instead of using the PEFT config. As a user, you don’t have to set the exact <code>target_modules</code> of the PEFT config for this to work. However, you should still pass a PEFT config of the right type, in this example <code>LoraConfig</code>, you can leave the <code>target_modules</code> as <code>None</code>.",me,B,Ge='Be aware that this still only creates the uninitialized PEFT layers, the values from the <code>state_dict</code> are not used to populate the model weights. To populate the weights, proceed with calling <a href="/docs/peft/v0.18.0.rc0/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a> as described below.',re,$,Ve="⚠️ Note that if there is a mismatch between what is configured in the PEFT config and what is found in the <code>state_dict</code>, PEFT will warn you about this. You can ignore the warning if you know that the PEFT config is not correctly specified.",ce,u,Fe="<p>If the original PEFT adapters was using <code>target_parameters</code> instead of <code>target_modules</code>, injecting from a <code>state_dict</code> will not work correctly. In this case, it is mandatory to use the correct PEFT config for injection.</p>",Me,v,fe,G,Re='To only save the adapter, use the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.get_peft_model_state_dict">get_peft_model_state_dict()</a> function:',he,V,ue,F,Xe="Otherwise, <code>model.state_dict()</code> returns the full state dict of the model.",Te,R,we,X,xe='After loading the saved <code>state_dict</code>, it can be applied using the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a> function:',ye,x,_e,A,Ae='If injecting the adapter is slow or you need to load a large number of adapters, you may use an optimization that allows to create an “empty” adapter on meta device and only fills the weights with real weights when the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a> is called. To do this, pass <code>low_cpu_mem_usage=True</code> to both <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> and <a href="/docs/peft/v0.18.0.rc0/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a>.',Je,Q,be,N,je,S,Ue;return T=new De({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Y({props:{title:"Adapter injection",local:"adapter-injection",headingTag:"h1"}}),b=new Y({props:{title:"Creating a new PEFT model",local:"creating-a-new-peft-model",headingTag:"h2"}}),g=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkZGluZyUyMCUzRCUyMHRvcmNoLm5uLkVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sbV9oZWFkJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaW5wdXRfaWRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmVtYmVkZGluZyhpbnB1dF9pZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubGluZWFyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubG1faGVhZCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwciUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmxpbmVhciUyMiU1RCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMER1bW15TW9kZWwoKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCklMEElMEFkdW1teV9pbnB1dHMlMjAlM0QlMjB0b3JjaC5Mb25nVGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTVEJTVEKSUwQWR1bW15X291dHB1dHMlMjAlM0QlMjBtb2RlbChkdW1teV9pbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> inject_adapter_in_model, LoraConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embedding = torch.nn.Embedding(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.linear = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.lm_head = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, input_ids</span>):
        x = self.embedding(input_ids)
        x = self.linear(x)
        x = self.lm_head(x)
        <span class="hljs-keyword">return</span> x


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=[<span class="hljs-string">&quot;linear&quot;</span>],
)

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)

dummy_inputs = torch.LongTensor([[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>]])
dummy_outputs = model(dummy_inputs)`,wrap:!1}}),Z=new H({props:{code:"RHVtbXlNb2RlbCglMEElMjAlMjAoZW1iZWRkaW5nKSUzQSUyMEVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMChsaW5lYXIpJTNBJTIwTGluZWFyKCUwQSUyMCUyMCUyMCUyMGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKGxvcmFfZHJvcG91dCklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMERyb3BvdXQocCUzRDAuMSUyQyUyMGlucGxhY2UlM0RGYWxzZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwKGxvcmFfQSklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNENjQlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMChsb3JhX0IpJTNBJTIwTW9kdWxlRGljdCglMEElMjAlMjAlMjAlMjAlMjAlMjAoZGVmYXVsdCklM0ElMjBMaW5lYXIoaW5fZmVhdHVyZXMlM0Q2NCUyQyUyMG91dF9mZWF0dXJlcyUzRDEwJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQSklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQiklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjApJTBBJTIwJTIwKGxtX2hlYWQpJTNBJTIwTGluZWFyKGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlKSUwQSk=",highlighted:`DummyModel(
  (embedding): Embedding(10, 10)
  (linear): Linear(
    in_features=10, out_features=10, bias=True
    (lora_dropout): ModuleDict(
      (default): Dropout(p=0.1, inplace=False)
    )
    (lora_A): ModuleDict(
      (default): Linear(in_features=10, out_features=64, bias=False)
    )
    (lora_B): ModuleDict(
      (default): Linear(in_features=64, out_features=10, bias=False)
    )
    (lora_embedding_A): ParameterDict()
    (lora_embedding_B): ParameterDict()
  )
  (lm_head): Linear(in_features=10, out_features=10, bias=True)
)`,wrap:!1}}),k=new Y({props:{title:"Injection based on a state_dict",local:"injection-based-on-a-statedict",headingTag:"h3"}}),W=new H({props:{code:"ZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwbG9hZF9maWxlJTBBJTBBbW9kZWwlMjAlM0QlMjAuLi4lMEFzdGF0ZV9kaWN0JTIwJTNEJTIwbG9hZF9maWxlKCUzQ3BhdGgtdG8tc2FmZXRlbnNvcnMtZmlsZSUzRSklMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCUyQyUyMHN0YXRlX2RpY3QlM0RzdGF0ZV9kaWN0KQ==",highlighted:`<span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_file

model = ...
state_dict = load_file(&lt;path-to-safetensors-file&gt;)
lora_config = LoraConfig(...)
model = inject_adapter_in_model(lora_config, model, state_dict=state_dict)`,wrap:!1}}),v=new Y({props:{title:"Saving the model",local:"saving-the-model",headingTag:"h2"}}),V=new H({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBcGVmdF9zdGF0ZV9kaWN0JTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdChtb2RlbCklMEFwcmludChwZWZ0X3N0YXRlX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model_state_dict

peft_state_dict = get_peft_model_state_dict(model)
<span class="hljs-built_in">print</span>(peft_state_dict)`,wrap:!1}}),R=new Y({props:{title:"Loading the model",local:"loading-the-model",headingTag:"h2"}}),x=new H({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBbW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwpJTBBb3V0Y29tZSUyMCUzRCUyMHNldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QobW9kZWwlMkMlMjBwZWZ0X3N0YXRlX2RpY3QpJTBBJTIzJTIwY2hlY2slMjB0aGF0JTIwdGhlcmUlMjB3ZXJlJTIwbm8lMjB3cm9uZyUyMGtleXMlMEFwcmludChvdXRjb21lLnVuZXhwZWN0ZWRfa2V5cyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> set_peft_model_state_dict

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)
outcome = set_peft_model_state_dict(model, peft_state_dict)
<span class="hljs-comment"># check that there were no wrong keys</span>
<span class="hljs-built_in">print</span>(outcome.unexpected_keys)`,wrap:!1}}),Q=new H({props:{code:"bW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUpJTBBJTBBcHJpbnQobW9kZWwubGluZWFyLmxvcmFfQSU1QiUyMmRlZmF1bHQlMjIlNUQud2VpZ2h0LmRldmljZS50eXBlJTIwJTNEJTNEJTIwJTIybWV0YSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWUlMEFzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0KG1vZGVsJTJDJTIwcGVmdF9zdGF0ZV9kaWN0JTJDJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RUcnVlKSUwQXByaW50KG1vZGVsLmxpbmVhci5sb3JhX0ElNUIlMjJkZWZhdWx0JTIyJTVELndlaWdodC5kZXZpY2UudHlwZSUyMCUzRCUzRCUyMCUyMmNwdSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWU=",highlighted:`model = DummyModel()
model = inject_adapter_in_model(lora_config, model, low_cpu_mem_usage=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;meta&quot;</span>)  <span class="hljs-comment"># should be True</span>
set_peft_model_state_dict(model, peft_state_dict, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;cpu&quot;</span>)  <span class="hljs-comment"># should be True</span>`,wrap:!1}}),N=new Ke({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/low_level_api.md"}}),{c(){h=i("meta"),z=s(),L=i("p"),P=s(),p(T.$$.fragment),D=s(),p(w.$$.fragment),K=s(),y=i("p"),y.innerHTML=Ze,q=s(),_=i("p"),_.textContent=ke,O=s(),J=i("table"),J.innerHTML=Ie,ee=s(),p(b.$$.fragment),te=s(),j=i("p"),j.innerHTML=We,le=s(),U=i("p"),U.innerHTML=Ee,ae=s(),p(g.$$.fragment),se=s(),C=i("p"),C.textContent=Be,ne=s(),p(Z.$$.fragment),ie=s(),p(k.$$.fragment),oe=s(),I=i("p"),I.innerHTML=$e,de=s(),p(W.$$.fragment),pe=s(),E=i("p"),E.innerHTML=ve,me=s(),B=i("p"),B.innerHTML=Ge,re=s(),$=i("p"),$.innerHTML=Ve,ce=s(),u=i("blockquote"),u.innerHTML=Fe,Me=s(),p(v.$$.fragment),fe=s(),G=i("p"),G.innerHTML=Re,he=s(),p(V.$$.fragment),ue=s(),F=i("p"),F.innerHTML=Xe,Te=s(),p(R.$$.fragment),we=s(),X=i("p"),X.innerHTML=xe,ye=s(),p(x.$$.fragment),_e=s(),A=i("p"),A.innerHTML=Ae,Je=s(),p(Q.$$.fragment),be=s(),p(N.$$.fragment),je=s(),S=i("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),z=n(e),L=o(e,"P",{}),Qe(L).forEach(l),P=n(e),m(T.$$.fragment,e),D=n(e),m(w.$$.fragment,e),K=n(e),y=o(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-9e5cx8"&&(y.innerHTML=Ze),q=n(e),_=o(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-mj4045"&&(_.textContent=ke),O=n(e),J=o(e,"TABLE",{"data-svelte-h":!0}),d(J)!=="svelte-j2tc6m"&&(J.innerHTML=Ie),ee=n(e),m(b.$$.fragment,e),te=n(e),j=o(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-751122"&&(j.innerHTML=We),le=n(e),U=o(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-tifeyo"&&(U.innerHTML=Ee),ae=n(e),m(g.$$.fragment,e),se=n(e),C=o(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-3xa704"&&(C.textContent=Be),ne=n(e),m(Z.$$.fragment,e),ie=n(e),m(k.$$.fragment,e),oe=n(e),I=o(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1r91xsp"&&(I.innerHTML=$e),de=n(e),m(W.$$.fragment,e),pe=n(e),E=o(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-aqktpe"&&(E.innerHTML=ve),me=n(e),B=o(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1oc5p1i"&&(B.innerHTML=Ge),re=n(e),$=o(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-sc7gea"&&($.innerHTML=Ve),ce=n(e),u=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(u)!=="svelte-pvc8g0"&&(u.innerHTML=Fe),Me=n(e),m(v.$$.fragment,e),fe=n(e),G=o(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1xs77ng"&&(G.innerHTML=Re),he=n(e),m(V.$$.fragment,e),ue=n(e),F=o(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1hk759o"&&(F.innerHTML=Xe),Te=n(e),m(R.$$.fragment,e),we=n(e),X=o(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1hos71z"&&(X.innerHTML=xe),ye=n(e),m(x.$$.fragment,e),_e=n(e),A=o(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1aajr0m"&&(A.innerHTML=Ae),Je=n(e),m(Q.$$.fragment,e),be=n(e),m(N.$$.fragment,e),je=n(e),S=o(e,"P",{}),Qe(S).forEach(l),this.h()},h(){ge(h,"name","hf:doc:metadata"),ge(h,"content",Oe),ge(u,"class","warning")},m(e,t){Pe(document.head,h),a(e,z,t),a(e,L,t),a(e,P,t),r(T,e,t),a(e,D,t),r(w,e,t),a(e,K,t),a(e,y,t),a(e,q,t),a(e,_,t),a(e,O,t),a(e,J,t),a(e,ee,t),r(b,e,t),a(e,te,t),a(e,j,t),a(e,le,t),a(e,U,t),a(e,ae,t),r(g,e,t),a(e,se,t),a(e,C,t),a(e,ne,t),r(Z,e,t),a(e,ie,t),r(k,e,t),a(e,oe,t),a(e,I,t),a(e,de,t),r(W,e,t),a(e,pe,t),a(e,E,t),a(e,me,t),a(e,B,t),a(e,re,t),a(e,$,t),a(e,ce,t),a(e,u,t),a(e,Me,t),r(v,e,t),a(e,fe,t),a(e,G,t),a(e,he,t),r(V,e,t),a(e,ue,t),a(e,F,t),a(e,Te,t),r(R,e,t),a(e,we,t),a(e,X,t),a(e,ye,t),r(x,e,t),a(e,_e,t),a(e,A,t),a(e,Je,t),r(Q,e,t),a(e,be,t),r(N,e,t),a(e,je,t),a(e,S,t),Ue=!0},p:He,i(e){Ue||(c(T.$$.fragment,e),c(w.$$.fragment,e),c(b.$$.fragment,e),c(g.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(v.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(x.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),Ue=!0)},o(e){M(T.$$.fragment,e),M(w.$$.fragment,e),M(b.$$.fragment,e),M(g.$$.fragment,e),M(Z.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(v.$$.fragment,e),M(V.$$.fragment,e),M(R.$$.fragment,e),M(x.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),Ue=!1},d(e){e&&(l(z),l(L),l(P),l(D),l(K),l(y),l(q),l(_),l(O),l(J),l(ee),l(te),l(j),l(le),l(U),l(ae),l(se),l(C),l(ne),l(ie),l(oe),l(I),l(de),l(pe),l(E),l(me),l(B),l(re),l($),l(ce),l(u),l(Me),l(fe),l(G),l(he),l(ue),l(F),l(Te),l(we),l(X),l(ye),l(_e),l(A),l(Je),l(be),l(je),l(S)),l(h),f(T,e),f(w,e),f(b,e),f(g,e),f(Z,e),f(k,e),f(W,e),f(v,e),f(V,e),f(R,e),f(x,e),f(Q,e),f(N,e)}}}const Oe='{"title":"Adapter injection","local":"adapter-injection","sections":[{"title":"Creating a new PEFT model","local":"creating-a-new-peft-model","sections":[{"title":"Injection based on a state_dict","local":"injection-based-on-a-statedict","sections":[],"depth":3}],"depth":2},{"title":"Saving the model","local":"saving-the-model","sections":[],"depth":2},{"title":"Loading the model","local":"loading-the-model","sections":[],"depth":2}],"depth":1}';function et(Ce){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Se{constructor(h){super(),Ye(this,h,et,qe,Ne,{})}}export{nt as component};
