import{s as El,n as Gl,o as Sl}from"../chunks/scheduler.78382b47.js";import{S as Cl,i as vl,e as p,s as e,c,h as Yl,a as i,d as a,b as n,f as Nl,g as o,j as r,k as il,l as Ll,m as t,n as M,t as h,o as m,p as d}from"../chunks/index.6dd35eb6.js";import{C as $l,H as f,E as xl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8d7e60c0.js";import{C as j}from"../chunks/CodeBlock.4d4112a9.js";function Hl(rl){let u,hs,os,ms,J,ds,y,fs,_,cl='<a href="https://pytorch.org/docs/stable/fsdp.html" rel="nofollow">Fully sharded data parallel</a> (FSDP) is developed for distributed training of large pretrained models up to 1T parameters. FSDP achieves this by sharding the model parameters, gradients, and optimizer states across data parallel processes and it can also offload sharded model parameters to a CPU. The memory efficiency afforded by FSDP allows you to scale training to larger batch or model sizes.',us,g,ol="Both of these features are supported in 🤗 Accelerate, and you can use them with 🤗 PEFT.",Ts,b,ws,U,Ml='This section of guide will help you learn how to use our DeepSpeed <a href="https://github.com/huggingface/peft/blob/main/examples/sft/train.py" rel="nofollow">training script</a> for performing SFT. You’ll configure the script to do SFT (supervised fine-tuning) of Llama-70B model with LoRA and FSDP on 8xH100 80GB GPUs on a single machine. You can configure it to scale to multiple machines by changing the accelerate config.',js,I,Js,A,hl='Start by running the following command to <a href="https://huggingface.co/docs/accelerate/quicktour#launching-your-distributed-script" rel="nofollow">create a FSDP configuration file</a> with 🤗 Accelerate. The <code>--config_file</code> flag allows you to save the configuration file to a specific location, otherwise it is saved as a <code>default_config.yaml</code> file in the 🤗 Accelerate cache.',ys,F,ml="The configuration file is used to set the default options when you launch the training script.",_s,W,gs,Z,dl="You’ll be asked a few questions about your setup, and configure the following arguments. In this example, you’ll answer the questionnaire as shown in the image below.",bs,T,fl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/fsdp-peft-config.png"/>',Us,B,ul="Creating Accelerate's config to use FSDP",Is,V,Tl='Once this is done, the corresponding config should look like below and you can find it in config folder at <a href="https://github.com/huggingface/peft/blob/main/examples/sft/configs/fsdp_config.yaml" rel="nofollow">fsdp_config.yaml</a>:',As,X,Fs,R,Ws,N,wl='The launch command is available at <a href="https://github.com/huggingface/peft/blob/main/examples/sft/run_peft_fsdp.sh" rel="nofollow">run_peft_fsdp.sh</a> and it is also shown below:',Zs,E,Bs,G,jl='Notice that we are using LoRA with  rank=8, alpha=16 and targeting all linear layers. We are passing the FSDP config file and finetuning the 70B Llama model on a subset of the <a href="https://huggingface.co/datasets/HuggingFaceH4/ultrachat_200k" rel="nofollow">ultrachat dataset</a>.',Vs,S,Xs,C,Jl="Let’s dive a little deeper into the script so you can see what’s going on, and understand how it works.",Rs,v,yl='The first thing to know is that the script uses FSDP for distributed training as the FSDP config has been passed. The <a href="https://huggingface.co/docs/trl/v0.24.0/en/sft_trainer#trl.SFTTrainer" rel="nofollow">SFTTrainer</a> class handles all the heavy lifting of creating PEFT model using the peft config that is passed. After that when you call <code>trainer.train()</code>, Trainer internally uses 🤗 Accelerate to prepare model, optimizer and trainer using the FSDP config to create FSDP wrapped model which is then trained. The main code snippet is below:',Ns,Y,Es,L,_l="Here, one main thing to note currently when using FSDP with PEFT is that <code>use_orig_params</code> needs to be <code>False</code> to realize GPU memory savings. Due to <code>use_orig_params=False</code>, the auto wrap policy for FSDP needs to change so that trainable and non-trainable parameters are wrapped separately. This is done by the code snippt below which uses the util function <code>fsdp_auto_wrap_policy</code> from PEFT:",Gs,$,Ss,x,Cs,H,gl="In the above example, the memory consumed per GPU is  72-80 GB (90-98%) as seen in the screenshot below. The slight increase in GPU memory at the end is when saving the model using <code>FULL_STATE_DICT</code> state dict type instead of the <code>SHARDED_STATE_DICT</code> so that the model has adapter weights that can be loaded normally with <code>from_pretrained</code> method during inference:",vs,w,bl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/peft_fsdp_mem_usage.png"/>',Ys,k,Ul="GPU memory usage for the training run",Ls,Q,$s,z,Il='In this section, we will look at how to use QLoRA and FSDP for finetuning 70B llama model on 2X24GB GPUs. <a href="https://www.answer.ai/" rel="nofollow">Answer.AI</a> in collaboration with bitsandbytes and Hugging Face 🤗 open sourced code enabling the usage of FSDP+QLoRA and explained the whole process in their insightful blogpost <a href="https://www.answer.ai/posts/2024-03-06-fsdp-qlora.html" rel="nofollow">You can now train a 70b language model at home</a>. This is now integrated in Hugging Face ecosystem.',xs,q,Al='For this, we first need <code>bitsandbytes&gt;=0.43.3</code>, <code>accelerate&gt;=1.0.1</code>, <code>transformers&gt;4.44.2</code>, <code>trl&gt;0.11.4</code> and <code>peft&gt;0.13.0</code>. We need to set <code>fsdp_cpu_ram_efficient_loading=true</code>, <code>fsdp_use_orig_params=false</code> and <code>fsdp_offload_params=true</code>(cpu offloading) when using Accelerate config. When not using accelerate launcher, you can alternately set the environment variable <code>export FSDP_CPU_RAM_EFFICIENT_LOADING=true</code>.  Here, we will be using accelerate config and below is the config which can be found at <a href="https://github.com/huggingface/peft/blob/main/examples/sft/configs/fsdp_config_qlora.yaml" rel="nofollow">fsdp_config_qlora.yaml</a>:',Hs,D,ks,P,Fl='Launch command is given below which is available at <a href="https://github.com/huggingface/peft/blob/main/examples/sft/run_peft_qlora_fsdp.sh" rel="nofollow">run_peft_qlora_fsdp.sh</a>:',Qs,K,zs,O,Wl="Notice the new argument being passed, <code>bnb_4bit_quant_storage_dtype</code>, which denotes the data type for packing the 4-bit parameters. For example, when it is set to <code>bfloat16</code>, <strong>16/4 = 4</strong> 4-bit params are packed together post quantization. When using mixed precision training with <code>bfloat16</code>, <code>bnb_4bit_quant_storage_dtype</code> can be either <code>bfloat16</code> for pure <code>bfloat16</code> finetuning, or <code>float32</code> for automatic mixed precision (this consumes more GPU memory). When using mixed precision training with <code>float16</code>, <code>bnb_4bit_quant_storage_dtype</code> should be set to <code>float32</code> for stable automatic mixed precision training.",qs,ss,Zl="In terms of training code, the important code changes are:",Ds,ls,Ps,as,Bl="Notice that <code>dtype</code> for <code>AutoModelForCausalLM</code> is same as the <code>bnb_4bit_quant_storage</code> data type. That’s it. Everything else is handled by Trainer and TRL.",Ks,ts,Os,es,Vl="In the above example, the memory consumed per GPU is <strong>19.6 GB</strong> while CPU RAM usage is around <strong>107 GB</strong>. When disabling CPU offloading, the GPU memory usage is  <strong>35.6 GB/ GPU</strong>. Therefore, what took 16X80GB GPUs for full finetuning, 8X80GB GPUs with FSDP+LoRA, and a couple of 80GB GPUs with DDP+QLoRA, now requires 2X24GB GPUs. This makes finetuning of large models more accessible.",sl,ns,ll,ps,Xl='You can also refer the <a href="https://github.com/facebookresearch/llama-recipes/?tab=readme-ov-file#fine-tuning" rel="nofollow">llama-recipes</a> repo and <a href="https://llama.meta.com/get-started/#fine-tuning" rel="nofollow">Getting started with Llama</a> guide on how to finetune using FSDP and PEFT.',al,is,tl,rs,Rl="<li>Merging when using PEFT and FSDP is currently unsupported and will raise error.</li> <li>Passing <code>modules_to_save</code> config parameter to is untested at present.</li> <li>GPU Memory saving when using CPU Offloading is untested at present.</li> <li>When using FSDP+QLoRA, <code>paged_adamw_8bit</code> currently results in an error when saving a checkpoint.</li> <li>DoRA training with FSDP should work (albeit at lower speed than LoRA). If combined with bitsandbytes (QDoRA), 4-bit quantization should also work, but 8-bit quantization has known issues and is not recommended.</li>",el,cs,nl,Ms,pl;return J=new $l({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new f({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),b=new f({props:{title:"Use PEFT and FSDP",local:"use-peft-and-fsdp",headingTag:"h1"}}),I=new f({props:{title:"Configuration",local:"configuration",headingTag:"h2"}}),W=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMC0tY29uZmlnX2ZpbGUlMjBmc2RwX2NvbmZpZy55YW1s",highlighted:"accelerate config --config_file fsdp_config.yaml",wrap:!1}}),X=new j({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2glM0ElMjBCQUNLV0FSRF9QUkUlMEElMjAlMjBmc2RwX2NwdV9yYW1fZWZmaWNpZW50X2xvYWRpbmclM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9mb3J3YXJkX3ByZWZldGNoJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX29mZmxvYWRfcGFyYW1zJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX3NoYXJkaW5nX3N0cmF0ZWd5JTNBJTIwRlVMTF9TSEFSRCUwQSUyMCUyMGZzZHBfc3RhdGVfZGljdF90eXBlJTNBJTIwU0hBUkRFRF9TVEFURV9ESUNUJTBBJTIwJTIwZnNkcF9zeW5jX21vZHVsZV9zdGF0ZXMlM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF91c2Vfb3JpZ19wYXJhbXMlM0ElMjBmYWxzZSUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDglMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-string">FULL_SHARD</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">8</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),R=new f({props:{title:"Launch command",local:"launch-command",headingTag:"h2"}}),E=new j({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjAlMjJjb25maWdzJTJGZnNkcF9jb25maWcueWFtbCUyMiUyMCUyMHRyYWluLnB5JTIwJTVDJTBBLS1zZWVkJTIwMTAwJTIwJTVDJTBBLS1tb2RlbF9uYW1lX29yX3BhdGglMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03MGItaGYlMjIlMjAlNUMlMEEtLWRhdGFzZXRfbmFtZSUyMCUyMnNtYW5ncnVsJTJGdWx0cmFjaGF0LTEway1jaGF0bWwlMjIlMjAlNUMlMEEtLWNoYXRfdGVtcGxhdGVfZm9ybWF0JTIwJTIyY2hhdG1sJTIyJTIwJTVDJTBBLS1hZGRfc3BlY2lhbF90b2tlbnMlMjBGYWxzZSUyMCU1QyUwQS0tYXBwZW5kX2NvbmNhdF90b2tlbiUyMEZhbHNlJTIwJTVDJTBBLS1zcGxpdHMlMjAlMjJ0cmFpbiUyQ3Rlc3QlMjIlMjAlNUMlMEEtLW1heF9zZXFfbGVuJTIwMjA0OCUyMCU1QyUwQS0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEEtLWxvZ2dpbmdfc3RlcHMlMjA1JTIwJTVDJTBBLS1sb2dfbGV2ZWwlMjAlMjJpbmZvJTIyJTIwJTVDJTBBLS1sb2dnaW5nX3N0cmF0ZWd5JTIwJTIyc3RlcHMlMjIlMjAlNUMlMEEtLWV2YWxfc3RyYXRlZ3klMjAlMjJlcG9jaCUyMiUyMCU1QyUwQS0tc2F2ZV9zdHJhdGVneSUyMCUyMmVwb2NoJTIyJTIwJTVDJTBBLS1wdXNoX3RvX2h1YiUyMCU1QyUwQS0taHViX3ByaXZhdGVfcmVwbyUyMFRydWUlMjAlNUMlMEEtLWh1Yl9zdHJhdGVneSUyMCUyMmV2ZXJ5X3NhdmUlMjIlMjAlNUMlMEEtLWJmMTYlMjBUcnVlJTIwJTVDJTBBLS1wYWNraW5nJTIwVHJ1ZSUyMCU1QyUwQS0tbGVhcm5pbmdfcmF0ZSUyMDFlLTQlMjAlNUMlMEEtLWxyX3NjaGVkdWxlcl90eXBlJTIwJTIyY29zaW5lJTIyJTIwJTVDJTBBLS13ZWlnaHRfZGVjYXklMjAxZS00JTIwJTVDJTBBLS13YXJtdXBfcmF0aW8lMjAwLjAlMjAlNUMlMEEtLW1heF9ncmFkX25vcm0lMjAxLjAlMjAlNUMlMEEtLW91dHB1dF9kaXIlMjAlMjJsbGFtYS1zZnQtbG9yYS1mc2RwJTIyJTIwJTVDJTBBLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjA4JTIwJTVDJTBBLS1wZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUyMDglMjAlNUMlMEEtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDQlMjAlNUMlMEEtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBUcnVlJTIwJTVDJTBBLS11c2VfcmVlbnRyYW50JTIwRmFsc2UlMjAlNUMlMEEtLWRhdGFzZXRfdGV4dF9maWVsZCUyMCUyMmNvbnRlbnQlMjIlMjAlNUMlMEEtLXVzZV9mbGFzaF9hdHRuJTIwVHJ1ZSUyMCU1QyUwQS0tdXNlX3BlZnRfbG9yYSUyMFRydWUlMjAlNUMlMEEtLWxvcmFfciUyMDglMjAlNUMlMEEtLWxvcmFfYWxwaGElMjAxNiUyMCU1QyUwQS0tbG9yYV9kcm9wb3V0JTIwMC4xJTIwJTVDJTBBLS1sb3JhX3RhcmdldF9tb2R1bGVzJTIwJTIyYWxsLWxpbmVhciUyMiUyMCU1QyUwQS0tdXNlXzRiaXRfcXVhbnRpemF0aW9uJTIwRmFsc2U=",highlighted:`accelerate launch --config_file <span class="hljs-string">&quot;configs/fsdp_config.yaml&quot;</span>  train.py \\
--seed 100 \\
--model_name_or_path <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;smangrul/ultrachat-10k-chatml&quot;</span> \\
--chat_template_format <span class="hljs-string">&quot;chatml&quot;</span> \\
--add_special_tokens False \\
--append_concat_token False \\
--splits <span class="hljs-string">&quot;train,test&quot;</span> \\
--max_seq_len 2048 \\
--num_train_epochs 1 \\
--logging_steps 5 \\
--log_level <span class="hljs-string">&quot;info&quot;</span> \\
--logging_strategy <span class="hljs-string">&quot;steps&quot;</span> \\
--eval_strategy <span class="hljs-string">&quot;epoch&quot;</span> \\
--save_strategy <span class="hljs-string">&quot;epoch&quot;</span> \\
--push_to_hub \\
--hub_private_repo True \\
--hub_strategy <span class="hljs-string">&quot;every_save&quot;</span> \\
--bf16 True \\
--packing True \\
--learning_rate 1e-4 \\
--lr_scheduler_type <span class="hljs-string">&quot;cosine&quot;</span> \\
--weight_decay 1e-4 \\
--warmup_ratio 0.0 \\
--max_grad_norm 1.0 \\
--output_dir <span class="hljs-string">&quot;llama-sft-lora-fsdp&quot;</span> \\
--per_device_train_batch_size 8 \\
--per_device_eval_batch_size 8 \\
--gradient_accumulation_steps 4 \\
--gradient_checkpointing True \\
--use_reentrant False \\
--dataset_text_field <span class="hljs-string">&quot;content&quot;</span> \\
--use_flash_attn True \\
--use_peft_lora True \\
--lora_r 8 \\
--lora_alpha 16 \\
--lora_dropout 0.1 \\
--lora_target_modules <span class="hljs-string">&quot;all-linear&quot;</span> \\
--use_4bit_quantization False`,wrap:!1}}),S=new f({props:{title:"The important parts",local:"the-important-parts",headingTag:"h2"}}),Y=new j({props:{code:"JTIzJTIwdHJhaW5lciUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMkMlMEEpJTBBdHJhaW5lci5hY2NlbGVyYXRvci5wcmludChmJTIyJTdCdHJhaW5lci5tb2RlbCU3RCUyMiklMEFpZiUyMG1vZGVsX2FyZ3MudXNlX3BlZnRfbG9yYSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGhhbmRsZSUyMFBFRlQlMkJGU0RQJTIwY2FzZSUwQSUyMCUyMCUyMCUyMHRyYWluZXIubW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMCUyMCUyMCUyMGlmJTIwZ2V0YXR0cih0cmFpbmVyLmFjY2VsZXJhdG9yLnN0YXRlJTJDJTIwJTIyZnNkcF9wbHVnaW4lMjIlMkMlMjBOb25lKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyb20lMjBwZWZ0LnV0aWxzLm90aGVyJTIwaW1wb3J0JTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnNkcF9wbHVnaW4lMjAlM0QlMjB0cmFpbmVyLmFjY2VsZXJhdG9yLnN0YXRlLmZzZHBfcGx1Z2luJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnNkcF9wbHVnaW4uYXV0b193cmFwX3BvbGljeSUyMCUzRCUyMGZzZHBfYXV0b193cmFwX3BvbGljeSh0cmFpbmVyLm1vZGVsKSUwQSUwQSUyMyUyMHRyYWluJTBBY2hlY2twb2ludCUyMCUzRCUyME5vbmUlMEFpZiUyMHRyYWluaW5nX2FyZ3MucmVzdW1lX2Zyb21fY2hlY2twb2ludCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGNoZWNrcG9pbnQlMjAlM0QlMjB0cmFpbmluZ19hcmdzLnJlc3VtZV9mcm9tX2NoZWNrcG9pbnQlMEF0cmFpbmVyLnRyYWluKHJlc3VtZV9mcm9tX2NoZWNrcG9pbnQlM0RjaGVja3BvaW50KSUwQSUwQSUyMyUyMHNhdmluZyUyMGZpbmFsJTIwbW9kZWwlMEFpZiUyMHRyYWluZXIuaXNfZnNkcF9lbmFibGVkJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5lci5hY2NlbGVyYXRvci5zdGF0ZS5mc2RwX3BsdWdpbi5zZXRfc3RhdGVfZGljdF90eXBlKCUyMkZVTExfU1RBVEVfRElDVCUyMiklMEF0cmFpbmVyLnNhdmVfbW9kZWwoKQ==",highlighted:`<span class="hljs-comment"># trainer</span>
trainer = SFTTrainer(
    model=model,
    processing_class=tokenizer,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    peft_config=peft_config,
)
trainer.accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{trainer.model}</span>&quot;</span>)
<span class="hljs-keyword">if</span> model_args.use_peft_lora:
    <span class="hljs-comment"># handle PEFT+FSDP case</span>
    trainer.model.print_trainable_parameters()
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">getattr</span>(trainer.accelerator.state, <span class="hljs-string">&quot;fsdp_plugin&quot;</span>, <span class="hljs-literal">None</span>):
        <span class="hljs-keyword">from</span> peft.utils.other <span class="hljs-keyword">import</span> fsdp_auto_wrap_policy

        fsdp_plugin = trainer.accelerator.state.fsdp_plugin
        fsdp_plugin.auto_wrap_policy = fsdp_auto_wrap_policy(trainer.model)

<span class="hljs-comment"># train</span>
checkpoint = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> training_args.resume_from_checkpoint <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    checkpoint = training_args.resume_from_checkpoint
trainer.train(resume_from_checkpoint=checkpoint)

<span class="hljs-comment"># saving final model</span>
<span class="hljs-keyword">if</span> trainer.is_fsdp_enabled:
    trainer.accelerator.state.fsdp_plugin.set_state_dict_type(<span class="hljs-string">&quot;FULL_STATE_DICT&quot;</span>)
trainer.save_model()`,wrap:!1}}),$=new j({props:{code:"aWYlMjBnZXRhdHRyKHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUlMkMlMjAlMjJmc2RwX3BsdWdpbiUyMiUyQyUyME5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHBlZnQudXRpbHMub3RoZXIlMjBpbXBvcnQlMjBmc2RwX2F1dG9fd3JhcF9wb2xpY3klMEElMEElMjAlMjAlMjAlMjBmc2RwX3BsdWdpbiUyMCUzRCUyMHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZnNkcF9wbHVnaW4lMEElMjAlMjAlMjAlMjBmc2RwX3BsdWdpbi5hdXRvX3dyYXBfcG9saWN5JTIwJTNEJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5KHRyYWluZXIubW9kZWwp",highlighted:`if getattr(trainer.accelerator.<span class="hljs-keyword">state</span>, <span class="hljs-string">&quot;fsdp_plugin&quot;</span>, None):
    <span class="hljs-keyword">from</span> peft.utils.other import fsdp_auto_wrap_policy

    fsdp_plugin = trainer.accelerator.<span class="hljs-keyword">state</span>.fsdp_plugin
    fsdp_plugin.auto_wrap_policy = fsdp_auto_wrap_policy(trainer.model)`,wrap:!1}}),x=new f({props:{title:"Memory usage",local:"memory-usage",headingTag:"h2"}}),Q=new f({props:{title:"Use PEFT QLoRA and FSDP for finetuning large models on multiple GPUs",local:"use-peft-qlora-and-fsdp-for-finetuning-large-models-on-multiple-gpus",headingTag:"h1"}}),D=new j({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEFkZWJ1ZyUzQSUyMGZhbHNlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2glM0ElMjBCQUNLV0FSRF9QUkUlMEElMjAlMjBmc2RwX2NwdV9yYW1fZWZmaWNpZW50X2xvYWRpbmclM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9mb3J3YXJkX3ByZWZldGNoJTNBJTIwZmFsc2UlMEElMjAlMjBmc2RwX29mZmxvYWRfcGFyYW1zJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfc2hhcmRpbmdfc3RyYXRlZ3klM0ElMjBGVUxMX1NIQVJEJTBBJTIwJTIwZnNkcF9zdGF0ZV9kaWN0X3R5cGUlM0ElMjBTSEFSREVEX1NUQVRFX0RJQ1QlMEElMjAlMjBmc2RwX3N5bmNfbW9kdWxlX3N0YXRlcyUzQSUyMHRydWUlMEElMjAlMjBmc2RwX3VzZV9vcmlnX3BhcmFtcyUzQSUyMGZhbHNlJTBBbWFjaGluZV9yYW5rJTNBJTIwMCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbWl4ZWRfcHJlY2lzaW9uJTNBJTIwJ25vJyUwQW51bV9tYWNoaW5lcyUzQSUyMDElMEFudW1fcHJvY2Vzc2VzJTNBJTIwMiUwQXJkenZfYmFja2VuZCUzQSUyMHN0YXRpYyUwQXNhbWVfbmV0d29yayUzQSUyMHRydWUlMEF0cHVfZW52JTNBJTIwJTVCJTVEJTBBdHB1X3VzZV9jbHVzdGVyJTNBJTIwZmFsc2UlMEF0cHVfdXNlX3N1ZG8lM0ElMjBmYWxzZSUwQXVzZV9jcHUlM0ElMjBmYWxzZQ==",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>                                                                                                                                           
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>                                                                                                                                                                 
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-string">FULL_SHARD</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),K=new j({props:{code:"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",highlighted:`accelerate launch <span class="hljs-attr">--config_file</span> <span class="hljs-string">&quot;configs/fsdp_config_qlora.yaml&quot;</span>  train<span class="hljs-selector-class">.py</span> \\
<span class="hljs-attr">--seed</span> <span class="hljs-number">100</span> \\
<span class="hljs-attr">--model_name_or_path</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span> \\
<span class="hljs-attr">--dataset_name</span> <span class="hljs-string">&quot;smangrul/ultrachat-10k-chatml&quot;</span> \\
<span class="hljs-attr">--chat_template_format</span> <span class="hljs-string">&quot;chatml&quot;</span> \\
<span class="hljs-attr">--add_special_tokens</span> False \\
<span class="hljs-attr">--append_concat_token</span> False \\
<span class="hljs-attr">--splits</span> <span class="hljs-string">&quot;train,test&quot;</span> \\
<span class="hljs-attr">--max_seq_len</span> <span class="hljs-number">2048</span> \\
<span class="hljs-attr">--num_train_epochs</span> <span class="hljs-number">1</span> \\
<span class="hljs-attr">--logging_steps</span> <span class="hljs-number">5</span> \\
<span class="hljs-attr">--log_level</span> <span class="hljs-string">&quot;info&quot;</span> \\
<span class="hljs-attr">--logging_strategy</span> <span class="hljs-string">&quot;steps&quot;</span> \\
<span class="hljs-attr">--eval_strategy</span> <span class="hljs-string">&quot;epoch&quot;</span> \\
<span class="hljs-attr">--save_strategy</span> <span class="hljs-string">&quot;epoch&quot;</span> \\
<span class="hljs-attr">--push_to_hub</span> \\
<span class="hljs-attr">--hub_private_repo</span> True \\
<span class="hljs-attr">--hub_strategy</span> <span class="hljs-string">&quot;every_save&quot;</span> \\
<span class="hljs-attr">--bf16</span> True \\
<span class="hljs-attr">--packing</span> True \\
<span class="hljs-attr">--learning_rate</span> <span class="hljs-number">1</span>e-<span class="hljs-number">4</span> \\
<span class="hljs-attr">--lr_scheduler_type</span> <span class="hljs-string">&quot;cosine&quot;</span> \\
<span class="hljs-attr">--weight_decay</span> <span class="hljs-number">1</span>e-<span class="hljs-number">4</span> \\
<span class="hljs-attr">--warmup_ratio</span> <span class="hljs-number">0.0</span> \\
<span class="hljs-attr">--max_grad_norm</span> <span class="hljs-number">1.0</span> \\
<span class="hljs-attr">--output_dir</span> <span class="hljs-string">&quot;llama-sft-qlora-fsdp&quot;</span> \\
<span class="hljs-attr">--per_device_train_batch_size</span> <span class="hljs-number">2</span> \\
<span class="hljs-attr">--per_device_eval_batch_size</span> <span class="hljs-number">2</span> \\
<span class="hljs-attr">--gradient_accumulation_steps</span> <span class="hljs-number">2</span> \\
<span class="hljs-attr">--gradient_checkpointing</span> True \\
<span class="hljs-attr">--use_reentrant</span> True \\
<span class="hljs-attr">--dataset_text_field</span> <span class="hljs-string">&quot;content&quot;</span> \\
<span class="hljs-attr">--use_flash_attn</span> True \\
<span class="hljs-attr">--use_peft_lora</span> True \\
<span class="hljs-attr">--lora_r</span> <span class="hljs-number">8</span> \\
<span class="hljs-attr">--lora_alpha</span> <span class="hljs-number">16</span> \\
<span class="hljs-attr">--lora_dropout</span> <span class="hljs-number">0.1</span> \\
<span class="hljs-attr">--lora_target_modules</span> <span class="hljs-string">&quot;all-linear&quot;</span> \\
<span class="hljs-attr">--use_4bit_quantization</span> True \\
<span class="hljs-attr">--use_nested_quant</span> True \\
<span class="hljs-attr">--bnb_4bit_compute_dtype</span> <span class="hljs-string">&quot;bfloat16&quot;</span> \\
<span class="hljs-attr">--bnb_4bit_quant_storage_dtype</span> <span class="hljs-string">&quot;bfloat16&quot;</span>`,wrap:!1}}),ls=new j({props:{code:"JTBBJTBB",highlighted:`...

bnb_config = BitsAndBytesConfig(
    load_in_4bit=args.use_4bit_quantization,
    bnb_4bit_quant_type=args.bnb_4bit_quant_type,
    bnb_4bit_compute_dtype=compute_dtype,
    bnb_4bit_use_double_quant=args.use_nested_quant,
<span class="hljs-addition">+   bnb_4bit_quant_storage=quant_storage_dtype,</span>
)

...

model = AutoModelForCausalLM.from_pretrained(
    args.model_name_or_path,
    quantization_config=bnb_config,
    trust_remote_code=True,
    attn_implementation=&quot;flash_attention_2&quot; if args.use_flash_attn else &quot;eager&quot;,
<span class="hljs-addition">+   dtype=quant_storage_dtype or torch.float32,</span>
)`,wrap:!1}}),ts=new f({props:{title:"Memory usage",local:"memory-usage",headingTag:"h2"}}),ns=new f({props:{title:"More resources",local:"more-resources",headingTag:"h2"}}),is=new f({props:{title:"Caveats",local:"caveats",headingTag:"h2"}}),cs=new xl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/accelerate/fsdp.md"}}),{c(){u=p("meta"),hs=e(),os=p("p"),ms=e(),c(J.$$.fragment),ds=e(),c(y.$$.fragment),fs=e(),_=p("p"),_.innerHTML=cl,us=e(),g=p("p"),g.textContent=ol,Ts=e(),c(b.$$.fragment),ws=e(),U=p("p"),U.innerHTML=Ml,js=e(),c(I.$$.fragment),Js=e(),A=p("p"),A.innerHTML=hl,ys=e(),F=p("p"),F.textContent=ml,_s=e(),c(W.$$.fragment),gs=e(),Z=p("p"),Z.textContent=dl,bs=e(),T=p("div"),T.innerHTML=fl,Us=e(),B=p("small"),B.textContent=ul,Is=e(),V=p("p"),V.innerHTML=Tl,As=e(),c(X.$$.fragment),Fs=e(),c(R.$$.fragment),Ws=e(),N=p("p"),N.innerHTML=wl,Zs=e(),c(E.$$.fragment),Bs=e(),G=p("p"),G.innerHTML=jl,Vs=e(),c(S.$$.fragment),Xs=e(),C=p("p"),C.textContent=Jl,Rs=e(),v=p("p"),v.innerHTML=yl,Ns=e(),c(Y.$$.fragment),Es=e(),L=p("p"),L.innerHTML=_l,Gs=e(),c($.$$.fragment),Ss=e(),c(x.$$.fragment),Cs=e(),H=p("p"),H.innerHTML=gl,vs=e(),w=p("div"),w.innerHTML=bl,Ys=e(),k=p("small"),k.textContent=Ul,Ls=e(),c(Q.$$.fragment),$s=e(),z=p("p"),z.innerHTML=Il,xs=e(),q=p("p"),q.innerHTML=Al,Hs=e(),c(D.$$.fragment),ks=e(),P=p("p"),P.innerHTML=Fl,Qs=e(),c(K.$$.fragment),zs=e(),O=p("p"),O.innerHTML=Wl,qs=e(),ss=p("p"),ss.textContent=Zl,Ds=e(),c(ls.$$.fragment),Ps=e(),as=p("p"),as.innerHTML=Bl,Ks=e(),c(ts.$$.fragment),Os=e(),es=p("p"),es.innerHTML=Vl,sl=e(),c(ns.$$.fragment),ll=e(),ps=p("p"),ps.innerHTML=Xl,al=e(),c(is.$$.fragment),tl=e(),rs=p("ol"),rs.innerHTML=Rl,el=e(),c(cs.$$.fragment),nl=e(),Ms=p("p"),this.h()},l(s){const l=Yl("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(a),hs=n(s),os=i(s,"P",{}),Nl(os).forEach(a),ms=n(s),o(J.$$.fragment,s),ds=n(s),o(y.$$.fragment,s),fs=n(s),_=i(s,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1552p1b"&&(_.innerHTML=cl),us=n(s),g=i(s,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1o8k4c8"&&(g.textContent=ol),Ts=n(s),o(b.$$.fragment,s),ws=n(s),U=i(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14llqsi"&&(U.innerHTML=Ml),js=n(s),o(I.$$.fragment,s),Js=n(s),A=i(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-zjx7c1"&&(A.innerHTML=hl),ys=n(s),F=i(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1oar51z"&&(F.textContent=ml),_s=n(s),o(W.$$.fragment,s),gs=n(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1dbl6fp"&&(Z.textContent=dl),bs=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-j046au"&&(T.innerHTML=fl),Us=n(s),B=i(s,"SMALL",{"data-svelte-h":!0}),r(B)!=="svelte-rynbwn"&&(B.textContent=ul),Is=n(s),V=i(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1iebck7"&&(V.innerHTML=Tl),As=n(s),o(X.$$.fragment,s),Fs=n(s),o(R.$$.fragment,s),Ws=n(s),N=i(s,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1vkau4u"&&(N.innerHTML=wl),Zs=n(s),o(E.$$.fragment,s),Bs=n(s),G=i(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ymw855"&&(G.innerHTML=jl),Vs=n(s),o(S.$$.fragment,s),Xs=n(s),C=i(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-y7jq4k"&&(C.textContent=Jl),Rs=n(s),v=i(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1h0n4u5"&&(v.innerHTML=yl),Ns=n(s),o(Y.$$.fragment,s),Es=n(s),L=i(s,"P",{"data-svelte-h":!0}),r(L)!=="svelte-w1wqr8"&&(L.innerHTML=_l),Gs=n(s),o($.$$.fragment,s),Ss=n(s),o(x.$$.fragment,s),Cs=n(s),H=i(s,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1l81qml"&&(H.innerHTML=gl),vs=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1w1ze4b"&&(w.innerHTML=bl),Ys=n(s),k=i(s,"SMALL",{"data-svelte-h":!0}),r(k)!=="svelte-8v78s3"&&(k.textContent=Ul),Ls=n(s),o(Q.$$.fragment,s),$s=n(s),z=i(s,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1idfuez"&&(z.innerHTML=Il),xs=n(s),q=i(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nmznmj"&&(q.innerHTML=Al),Hs=n(s),o(D.$$.fragment,s),ks=n(s),P=i(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-afuz8n"&&(P.innerHTML=Fl),Qs=n(s),o(K.$$.fragment,s),zs=n(s),O=i(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1t3rorv"&&(O.innerHTML=Wl),qs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-19s9lyl"&&(ss.textContent=Zl),Ds=n(s),o(ls.$$.fragment,s),Ps=n(s),as=i(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-46tfpq"&&(as.innerHTML=Bl),Ks=n(s),o(ts.$$.fragment,s),Os=n(s),es=i(s,"P",{"data-svelte-h":!0}),r(es)!=="svelte-1e2ovrm"&&(es.innerHTML=Vl),sl=n(s),o(ns.$$.fragment,s),ll=n(s),ps=i(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-yjfr5u"&&(ps.innerHTML=Xl),al=n(s),o(is.$$.fragment,s),tl=n(s),rs=i(s,"OL",{"data-svelte-h":!0}),r(rs)!=="svelte-1tvr0x6"&&(rs.innerHTML=Rl),el=n(s),o(cs.$$.fragment,s),nl=n(s),Ms=i(s,"P",{}),Nl(Ms).forEach(a),this.h()},h(){il(u,"name","hf:doc:metadata"),il(u,"content",kl),il(T,"class","flex justify-center"),il(w,"class","flex justify-center")},m(s,l){Ll(document.head,u),t(s,hs,l),t(s,os,l),t(s,ms,l),M(J,s,l),t(s,ds,l),M(y,s,l),t(s,fs,l),t(s,_,l),t(s,us,l),t(s,g,l),t(s,Ts,l),M(b,s,l),t(s,ws,l),t(s,U,l),t(s,js,l),M(I,s,l),t(s,Js,l),t(s,A,l),t(s,ys,l),t(s,F,l),t(s,_s,l),M(W,s,l),t(s,gs,l),t(s,Z,l),t(s,bs,l),t(s,T,l),t(s,Us,l),t(s,B,l),t(s,Is,l),t(s,V,l),t(s,As,l),M(X,s,l),t(s,Fs,l),M(R,s,l),t(s,Ws,l),t(s,N,l),t(s,Zs,l),M(E,s,l),t(s,Bs,l),t(s,G,l),t(s,Vs,l),M(S,s,l),t(s,Xs,l),t(s,C,l),t(s,Rs,l),t(s,v,l),t(s,Ns,l),M(Y,s,l),t(s,Es,l),t(s,L,l),t(s,Gs,l),M($,s,l),t(s,Ss,l),M(x,s,l),t(s,Cs,l),t(s,H,l),t(s,vs,l),t(s,w,l),t(s,Ys,l),t(s,k,l),t(s,Ls,l),M(Q,s,l),t(s,$s,l),t(s,z,l),t(s,xs,l),t(s,q,l),t(s,Hs,l),M(D,s,l),t(s,ks,l),t(s,P,l),t(s,Qs,l),M(K,s,l),t(s,zs,l),t(s,O,l),t(s,qs,l),t(s,ss,l),t(s,Ds,l),M(ls,s,l),t(s,Ps,l),t(s,as,l),t(s,Ks,l),M(ts,s,l),t(s,Os,l),t(s,es,l),t(s,sl,l),M(ns,s,l),t(s,ll,l),t(s,ps,l),t(s,al,l),M(is,s,l),t(s,tl,l),t(s,rs,l),t(s,el,l),M(cs,s,l),t(s,nl,l),t(s,Ms,l),pl=!0},p:Gl,i(s){pl||(h(J.$$.fragment,s),h(y.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h(W.$$.fragment,s),h(X.$$.fragment,s),h(R.$$.fragment,s),h(E.$$.fragment,s),h(S.$$.fragment,s),h(Y.$$.fragment,s),h($.$$.fragment,s),h(x.$$.fragment,s),h(Q.$$.fragment,s),h(D.$$.fragment,s),h(K.$$.fragment,s),h(ls.$$.fragment,s),h(ts.$$.fragment,s),h(ns.$$.fragment,s),h(is.$$.fragment,s),h(cs.$$.fragment,s),pl=!0)},o(s){m(J.$$.fragment,s),m(y.$$.fragment,s),m(b.$$.fragment,s),m(I.$$.fragment,s),m(W.$$.fragment,s),m(X.$$.fragment,s),m(R.$$.fragment,s),m(E.$$.fragment,s),m(S.$$.fragment,s),m(Y.$$.fragment,s),m($.$$.fragment,s),m(x.$$.fragment,s),m(Q.$$.fragment,s),m(D.$$.fragment,s),m(K.$$.fragment,s),m(ls.$$.fragment,s),m(ts.$$.fragment,s),m(ns.$$.fragment,s),m(is.$$.fragment,s),m(cs.$$.fragment,s),pl=!1},d(s){s&&(a(hs),a(os),a(ms),a(ds),a(fs),a(_),a(us),a(g),a(Ts),a(ws),a(U),a(js),a(Js),a(A),a(ys),a(F),a(_s),a(gs),a(Z),a(bs),a(T),a(Us),a(B),a(Is),a(V),a(As),a(Fs),a(Ws),a(N),a(Zs),a(Bs),a(G),a(Vs),a(Xs),a(C),a(Rs),a(v),a(Ns),a(Es),a(L),a(Gs),a(Ss),a(Cs),a(H),a(vs),a(w),a(Ys),a(k),a(Ls),a($s),a(z),a(xs),a(q),a(Hs),a(ks),a(P),a(Qs),a(zs),a(O),a(qs),a(ss),a(Ds),a(Ps),a(as),a(Ks),a(Os),a(es),a(sl),a(ll),a(ps),a(al),a(tl),a(rs),a(el),a(nl),a(Ms)),a(u),d(J,s),d(y,s),d(b,s),d(I,s),d(W,s),d(X,s),d(R,s),d(E,s),d(S,s),d(Y,s),d($,s),d(x,s),d(Q,s),d(D,s),d(K,s),d(ls,s),d(ts,s),d(ns,s),d(is,s),d(cs,s)}}}const kl='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[],"depth":1}';function Ql(rl){return Sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends Cl{constructor(u){super(),vl(this,u,Ql,Hl,El,{})}}export{Kl as component};
