# C3A: Parameter-Efficient Fine-Tuning via Circular Convolution

[C3A](https://huggingface.co/papers/2407.19342) is a parameter-efficient fine-tuning technique that leverages Circular Convolution to achieve high rank adaptation within reasonable resource limits.

Note that you should use a much larger learning rate (LR) for C3A than for other methods. For example, a LR of 1e-1 for C3A is a good starting point. Besides, a much smaller weight decay should be used. You can refer to the `method_comparison` folder for more details.

For the `block_size`, it affects tunable parameters and performance. To start with, you can choose a $\mathrm{gcd}(d_1,d_2)$ near $\frac{\sqrt{d_1\times d_2}}{r}$, where $r$ is the rank for LoRA you would use for this task.

C3A currently has the following constraints:

- Only `nn.Linear` layers are supported.
- Quantized layers are not supported.
- The block size should be a common divisor of both the input and output sizes of target layers. 

If these constraints don't work for your use case, consider other methods instead.

The abstract from the paper is:

> Low-Rank Adaptation (LoRA) has gained popularity for fine-tuning large foundation models, leveraging low-rank matrices $\mathbf{A}$ and $\mathbf{B}$ to represent weight changes (i.e., $\Delta \mathbf{W} = \mathbf{B} \mathbf{A}$). This method reduces trainable parameters and mitigates heavy memory consumption associated with full delta matrices by sequentially multiplying $\mathbf{A}$ and $\mathbf{B}$ with the activation. Despite its success, the intrinsic low-rank characteristic may limit its performance. Although several variants have been proposed to address this issue, they often overlook the crucial computational and memory efficiency brought by LoRA. In this paper, we propose Circular Convolution Adaptation (C3A), which not only achieves high-rank adaptation with enhanced performance but also excels in both computational power and memory utilization. Extensive experiments demonstrate that C3A consistently outperforms LoRA and its variants across various fine-tuning tasks. 

## C3AConfig[[peft.C3AConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.C3AConfig</name><anchor>peft.C3AConfig</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/c3a/config.py#L25</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}, {"name": "block_size", "val": ": int = 256"}, {"name": "target_modules", "val": ": Optional[Union[list[str], str]] = None"}, {"name": "bias", "val": ": str = 'none'"}, {"name": "modules_to_save", "val": ": Optional[list[str]] = None"}, {"name": "layers_to_transform", "val": ": Optional[Union[list[int], int]] = None"}, {"name": "layers_pattern", "val": ": Optional[Union[list[str], str]] = None"}, {"name": "block_size_pattern", "val": ": Optional[dict] = <factory>"}, {"name": "init_weights", "val": ": Optional[Union[bool, Literal['gaussian', 'kaiming_uniform', 'xavier_uniform']]] = 'xavier_uniform'"}]</parameters><paramsdesc>- **block_size** (`int`) --
  block size for C3A, must be divisible by both the input size and the output size of the target layer. If
  you have no idea what block_size you should use, set it to the greatest common divisor of all input &
  output sizes of your target layers. Increasing this would result in less parameters.
- **target_modules** (`Union[list[str],str]`) -- The names of the modules to apply C3A to.
- **bias** (`str`) -- Bias type for C3A. Can be 'none', 'all' or 'c3a_only'. If 'all' or 'c3a_only', the
  corresponding biases will be updated during training. Be aware that this means that, even when disabling
  the adapters, the model will not produce the same output as the base model would have without adaptation.
- **modules_to_save** (`list[str]`) --list of modules apart from C3A layers to be set as trainable
  and saved in the final checkpoint.
- **layers_to_transform** (`Union[list[int],int]`) --
  The layer indexes to transform, if this argument is specified, it will apply C3A on the layer indexes that
  are specified in this list. If a single integer is passed, it will apply C3A on the layer at this index.
- **layers_pattern** (`str`) --
  The layer pattern name, used only if `layers_to_transform` is different from `None` and if the layer
  pattern is not in the common layers pattern.
- **block_size_pattern** (`dict`) --
  The mapping from layer names or regexp expression to block_size which are different from the default
  specified. For example, `{"model.decoder.layers.0.encoder_attn.k_proj": 1280`}
- **init_weights** (`Union[bool, Literal["gaussian", "kaiming_uniform", "xavier_uniform"]]`) --
  Defaults to 'xavier_uniform'. Setting this to `False` also uses 'xavier_uniform'. To set the weights to
  zeros (thus making C3A a no-op), set the value to `True`.</paramsdesc><paramgroups>0</paramgroups></docstring>
This is the configuration class to store the configuration of a [C3AModel](/docs/peft/v0.18.0.rc0/en/package_reference/c3a#peft.C3AModel).




</div>

## C3AModel[[peft.C3AModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.C3AModel</name><anchor>peft.C3AModel</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/c3a/model.py#L29</source><parameters>[{"name": "model", "val": ""}, {"name": "peft_config", "val": ": Union[PeftConfig, dict[str, PeftConfig]]"}, {"name": "adapter_name", "val": ": str"}, {"name": "low_cpu_mem_usage", "val": ": bool = False"}, {"name": "state_dict", "val": ": Optional[dict[str, torch.Tensor]] = None"}]</parameters><paramsdesc>- **model** (`torch.nn.Module`) -- The model to be adapted.
- **config** ([C3AConfig](/docs/peft/v0.18.0.rc0/en/package_reference/c3a#peft.C3AConfig)) -- The configuration of the C3A model.
- **adapter_name** (`str`) -- The name of the adapter, defaults to `"default"`.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.nn.Module`</rettype><retdesc>The C3A model.</retdesc></docstring>

Creates C3A model from a pretrained transformers model.

The method is described in detail in https://huggingface.co/papers/2407.19342.







**Attributes**:
- **model** ([PreTrainedModel](https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/model#transformers.PreTrainedModel)) -- The model to be adapted.
- **peft_config** ([C3AConfig](/docs/peft/v0.18.0.rc0/en/package_reference/c3a#peft.C3AConfig)): The configuration of the C3A model.


</div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/c3a.md" />