import{s as Ys,a as As,n as zs,o as Ls}from"../chunks/scheduler.3d32dc09.js";import{S as Ps,i as Ds,e as a,s as o,c as M,h as Ks,a as i,d as l,b as n,f as Fs,g as p,j as r,k as U,l as Os,m as s,n as u,t as c,o as d,p as y}from"../chunks/index.f9718211.js";import{C as to,H as h,E as eo}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.70a1e6b5.js";import{C as m}from"../chunks/CodeBlock.d4b513b9.js";import{D as lo}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function so(Xl){let b,se,ee,oe,f,ne,g,ae,C,ie,v,Sl="Here, we’re going to see advanced tool usage.",re,w,ql='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',Me,I,pe,Z,Al="A tool is mostly a function that an LLM can use in an agentic system.",ue,B,Fl="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",ce,W,Yl="So it cannot be only a function. It should be a class.",de,G,zl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",ye,k,Ll="Here’s how it looks:",me,Q,he,H,Pl='The custom tool subclasses <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',be,R,Dl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>[&quot;string&quot;, &quot;boolean&quot;,&quot;integer&quot;, &quot;number&quot;, &quot;image&quot;, &quot;audio&quot;, &quot;array&quot;, &quot;object&quot;, &quot;any&quot;, &quot;null&quot;]</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',we,V,Kl="And that’s all it needs to be used in an agent!",Te,_,Ol='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/main/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Je,$,ts='In this case, you can build your tool by subclassing <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> as described above.',je,x,Ue,N,es='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',fe,E,ge,X,ls="For the push to Hub to work, your tool will need to respect some rules:",Ce,S,ss='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',ve,q,os='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',Ie,A,ns='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',Ze,F,as=`Then you can load the tool with <a href="/docs/smolagents/main/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,Be,Y,We,z,Ge,L,is="Our <code>MCPClient</code> allows you to load tools from an MCP server, and gives you full control over the connection and tool management:",ke,P,rs="For stdio-based MCP servers:",Qe,D,He,K,Ms="For Streamable HTTP-based MCP servers:",Re,O,Ve,tt,ps="You can also manually manage the connection lifecycle with the try…finally pattern:",_e,et,$e,lt,us="You can also connect to multiple MCP servers at once by passing a list of server parameters:",xe,st,Ne,T,cs=`<p><strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:</p> <ul><li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li></ul>`,Ee,ot,Xe,nt,ds='The latest <a href="https://modelcontextprotocol.io/specification/2025-06-18/server/tools#structured-content" rel="nofollow">MCP specifications (2025-06-18+)</a> include support for <code>outputSchema</code>, which enables tools to return structured data with defined schemas. <code>smolagents</code> takes advantage of these structured output capabilities, allowing agents to work with tools that return complex data structures, JSON objects, and other structured formats. With this feature, the agent’s LLMs can “see” the structure of the tool output before calling a tool, enabling more intelligent and context-aware interactions.',Se,at,ys="To enable structured output support, pass <code>structured_output=True</code> when initializing the <code>MCPClient</code>:",qe,it,Ae,rt,ms="When <code>structured_output=True</code>, the following features are enabled:",Fe,Mt,hs="<li><strong>Output Schema Support</strong>: Tools can define JSON schemas for their outputs</li> <li><strong>Structured Content Handling</strong>: Support for <code>structuredContent</code> in MCP responses</li> <li><strong>JSON Parsing</strong>: Automatic parsing of structured data from tool responses</li>",Ye,pt,bs="Here’s an example using a weather MCP server with structured output:",ze,ut,Le,ct,ws="Agent using output schema and structured output:",Pe,dt,De,yt,Ts="When structured output is enabled, the <code>CodeAgent</code> system prompt is enhanced to include JSON schema information for tools, helping the agent understand the expected structure of tool outputs and access the data appropriately.",Ke,mt,Js="<strong>Backwards Compatibility</strong>: The <code>structured_output</code> parameter currently defaults to <code>False</code> to maintain backwards compatibility. Existing code will continue to work without changes, receiving simple text outputs as before.",Oe,ht,js="<strong>Future Change</strong>: In a future release, the default value of <code>structured_output</code> will change from <code>False</code> to <code>True</code>. It is recommended to explicitly set <code>structured_output=True</code> to opt into the enhanced functionality, which provides better tool output handling and improved agent performance. Use <code>structured_output=False</code> only if you specifically need to maintain the current text-only behavior.",tl,bt,el,wt,Us='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',ll,Tt,fs='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',sl,Jt,gs='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',ol,jt,nl,Ut,Cs="And voilà, here’s your image! 🏖️",al,Ot,vs,il,ft,Is="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",rl,gt,Ml,Ct,pl,te,Zs,ul,vt,Bs="How cool is this? 🤩",cl,It,dl,Zt,Ws=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,yl,Bt,Gs=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,ml,Wt,hl,Gt,bl,kt,ks="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",wl,Qt,Qs="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",Tl,Ht,Jl,Rt,Hs="Now we can leverage the new tool:",jl,Vt,Ul,J,Rs="<p>Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.</p>",fl,_t,gl,$t,Vs='You can leverage tool collections by using <a href="/docs/smolagents/main/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Cl,xt,vl,Nt,_s='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Il,Et,$s='The MCP servers tools can be loaded with <a href="/docs/smolagents/main/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Zl,j,xs=`<p><strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:</p> <ul><li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li></ul>`,Bl,Xt,Ns="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Wl,St,Gl,qt,Es="To enable structured output support with ToolCollection, add the <code>structured_output=True</code> parameter:",kl,At,Ql,Ft,Xs="For Streamable HTTP-based MCP servers, simply pass a dict with parameters to <code>mcp.client.streamable_http.streamablehttp_client</code> and add the key <code>transport</code> with the value <code>&quot;streamable-http&quot;</code>:",Hl,Yt,Rl,zt,Vl,Lt,Ss=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,_l,Pt,$l,Dt,qs="To speed up the start, tools are loaded only if called by the agent.",xl,Kt,Nl,le,El;return f=new to({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new lo({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),C=new h({props:{title:"Tools",local:"tools",headingTag:"h1"}}),I=new h({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),Q=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),x=new h({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),E=new m({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),Y=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),z=new h({props:{title:"Use tools from an MCP server",local:"use-tools-from-an-mcp-server",headingTag:"h3"}}),D=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),O=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGbWNwJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3RyZWFtYWJsZS1odHRwJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),et=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),st=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),ot=new h({props:{title:"Structured Output and Output Schema Support",local:"structured-output-and-output-schema-support",headingTag:"h4"}}),it=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBFbmFibGUlMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTIwc3VwcG9ydCUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBQYXJpcyUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Enable structured output support</span>
<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Get weather information for Paris&quot;</span>)`,wrap:!1}}),ut=new m({props:{code:"JTIzJTIwZGVtbyUyRndlYXRoZXIucHklMjAtJTIwRXhhbXBsZSUyME1DUCUyMHNlcnZlciUyMHdpdGglMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTBBZnJvbSUyMHB5ZGFudGljJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTJDJTIwRmllbGQlMEFmcm9tJTIwbWNwLnNlcnZlci5mYXN0bWNwJTIwaW1wb3J0JTIwRmFzdE1DUCUwQSUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyV2VhdGhlciUyMFNlcnZpY2UlMjIpJTBBJTBBY2xhc3MlMjBXZWF0aGVySW5mbyhCYXNlTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0ElMjBzdHIlMjAlM0QlMjBGaWVsZChkZXNjcmlwdGlvbiUzRCUyMlRoZSUyMGxvY2F0aW9uJTIwbmFtZSUyMiklMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMGZsb2F0JTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJUZW1wZXJhdHVyZSUyMGluJTIwQ2Vsc2l1cyUyMiklMEElMjAlMjAlMjAlMjBjb25kaXRpb25zJTNBJTIwc3RyJTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJXZWF0aGVyJTIwY29uZGl0aW9ucyUyMiklMEElMjAlMjAlMjAlMjBodW1pZGl0eSUzQSUyMGludCUyMCUzRCUyMEZpZWxkKGRlc2NyaXB0aW9uJTNEJTIySHVtaWRpdHklMjBwZXJjZW50YWdlJTIyJTJDJTIwZ2UlM0QwJTJDJTIwbGUlM0QxMDApJTBBJTBBJTQwbWNwLnRvb2woJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmdldF93ZWF0aGVyX2luZm8lMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdldCUyMHdlYXRoZXIlMjBpbmZvcm1hdGlvbiUyMGZvciUyMGElMjBsb2NhdGlvbiUyMGFzJTIwc3RydWN0dXJlZCUyMGRhdGEuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlJTIwaXMlMjBlbmFibGVkJTIwYnklMjBkZWZhdWx0JTIwaW4lMjBGYXN0TUNQJTBBKSUwQWRlZiUyMGdldF93ZWF0aGVyX2luZm8oY2l0eSUzQSUyMHN0ciklMjAtJTNFJTIwV2VhdGhlckluZm8lM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBhJTIwY2l0eS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBXZWF0aGVySW5mbyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzRGNpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDIyLjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25kaXRpb25zJTNEJTIycGFydGx5JTIwY2xvdWR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHVtaWRpdHklM0Q2NSUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-comment"># demo/weather.py - Example MCP server with structured output</span>
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, Field
<span class="hljs-keyword">from</span> mcp.server.fastmcp <span class="hljs-keyword">import</span> FastMCP

mcp = FastMCP(<span class="hljs-string">&quot;Weather Service&quot;</span>)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WeatherInfo</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;The location name&quot;</span>)
    temperature: <span class="hljs-built_in">float</span> = Field(description=<span class="hljs-string">&quot;Temperature in Celsius&quot;</span>)
    conditions: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;Weather conditions&quot;</span>)
    humidity: <span class="hljs-built_in">int</span> = Field(description=<span class="hljs-string">&quot;Humidity percentage&quot;</span>, ge=<span class="hljs-number">0</span>, le=<span class="hljs-number">100</span>)

<span class="hljs-meta">@mcp.tool(<span class="hljs-params">
    name=<span class="hljs-string">&quot;get_weather_info&quot;</span>,
    description=<span class="hljs-string">&quot;Get weather information for a location as structured data.&quot;</span>,
    <span class="hljs-comment"># structured_output=True is enabled by default in FastMCP</span>
</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_info</span>(<span class="hljs-params">city: <span class="hljs-built_in">str</span></span>) -&gt; WeatherInfo:
    <span class="hljs-string">&quot;&quot;&quot;Get weather information for a city.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> WeatherInfo(
        location=city,
        temperature=<span class="hljs-number">22.5</span>,
        conditions=<span class="hljs-string">&quot;partly cloudy&quot;</span>,
        humidity=<span class="hljs-number">65</span>
    )`,wrap:!1}}),dt=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBVc2luZyUyMHRoZSUyMHdlYXRoZXIlMjBzZXJ2ZXIlMjB3aXRoJTIwc3RydWN0dXJlZCUyMG91dHB1dCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMmRlbW8lMkZ3ZWF0aGVyLnB5JTIyJTVEJTBBKSUwQSUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjB0ZW1wZXJhdHVyZSUyMGluJTIwVG9reW8lMjBpbiUyMEZhaHJlbmhlaXQlM0YlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Using the weather server with structured output</span>
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;python&quot;</span>,
    args=[<span class="hljs-string">&quot;demo/weather.py&quot;</span>]
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model)
    result = agent.run(<span class="hljs-string">&quot;What is the temperature in Tokyo in Fahrenheit?&quot;</span>)
    <span class="hljs-built_in">print</span>(result)`,wrap:!1}}),bt=new h({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),jt=new m({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),gt=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjMtTmV4dC04MEItQTNCLVRoaW5raW5nJTIyKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen3-Next-80B-A3B-Thinking&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),Ct=new m({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),It=new h({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),Wt=new m({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),Gt=new h({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),Ht=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjMtTmV4dC04MEItQTNCLVRoaW5raW5nJTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEFhZ2VudC50b29scyU1Qm1vZGVsX2Rvd25sb2FkX3Rvb2wubmFtZSU1RCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX3Rvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen3-Next-80B-A3B-Thinking&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),Vt=new m({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),_t=new h({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),xt=new h({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),St=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),At=new m({props:{code:"d2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Yt=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRm1jcCUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnN0cmVhbWFibGUtaHR0cCUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),zt=new h({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),Pt=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),Kt=new eo({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){b=a("meta"),se=o(),ee=a("p"),oe=o(),M(f.$$.fragment),ne=o(),M(g.$$.fragment),ae=o(),M(C.$$.fragment),ie=o(),v=a("p"),v.textContent=Sl,re=o(),w=a("blockquote"),w.innerHTML=ql,Me=o(),M(I.$$.fragment),pe=o(),Z=a("p"),Z.textContent=Al,ue=o(),B=a("p"),B.textContent=Fl,ce=o(),W=a("p"),W.textContent=Yl,de=o(),G=a("p"),G.textContent=zl,ye=o(),k=a("p"),k.textContent=Ll,me=o(),M(Q.$$.fragment),he=o(),H=a("p"),H.innerHTML=Pl,be=o(),R=a("ul"),R.innerHTML=Dl,we=o(),V=a("p"),V.textContent=Kl,Te=o(),_=a("p"),_.innerHTML=Ol,Je=o(),$=a("p"),$.innerHTML=ts,je=o(),M(x.$$.fragment),Ue=o(),N=a("p"),N.innerHTML=es,fe=o(),M(E.$$.fragment),ge=o(),X=a("p"),X.textContent=ls,Ce=o(),S=a("ul"),S.innerHTML=ss,ve=o(),q=a("p"),q.innerHTML=os,Ie=o(),A=a("p"),A.innerHTML=ns,Ze=o(),F=a("p"),F.innerHTML=as,Be=o(),M(Y.$$.fragment),We=o(),M(z.$$.fragment),Ge=o(),L=a("p"),L.innerHTML=is,ke=o(),P=a("p"),P.textContent=rs,Qe=o(),M(D.$$.fragment),He=o(),K=a("p"),K.textContent=Ms,Re=o(),M(O.$$.fragment),Ve=o(),tt=a("p"),tt.textContent=ps,_e=o(),M(et.$$.fragment),$e=o(),lt=a("p"),lt.textContent=us,xe=o(),M(st.$$.fragment),Ne=o(),T=a("blockquote"),T.innerHTML=cs,Ee=o(),M(ot.$$.fragment),Xe=o(),nt=a("p"),nt.innerHTML=ds,Se=o(),at=a("p"),at.innerHTML=ys,qe=o(),M(it.$$.fragment),Ae=o(),rt=a("p"),rt.innerHTML=ms,Fe=o(),Mt=a("ul"),Mt.innerHTML=hs,Ye=o(),pt=a("p"),pt.textContent=bs,ze=o(),M(ut.$$.fragment),Le=o(),ct=a("p"),ct.textContent=ws,Pe=o(),M(dt.$$.fragment),De=o(),yt=a("p"),yt.innerHTML=Ts,Ke=o(),mt=a("p"),mt.innerHTML=Js,Oe=o(),ht=a("p"),ht.innerHTML=js,tl=o(),M(bt.$$.fragment),el=o(),wt=a("p"),wt.innerHTML=Us,ll=o(),Tt=a("p"),Tt.innerHTML=fs,sl=o(),Jt=a("p"),Jt.innerHTML=gs,ol=o(),M(jt.$$.fragment),nl=o(),Ut=a("p"),Ut.textContent=Cs,al=o(),Ot=a("img"),il=o(),ft=a("p"),ft.innerHTML=Is,rl=o(),M(gt.$$.fragment),Ml=o(),M(Ct.$$.fragment),pl=o(),te=a("img"),ul=o(),vt=a("p"),vt.textContent=Bs,cl=o(),M(It.$$.fragment),dl=o(),Zt=a("p"),Zt.innerHTML=Ws,yl=o(),Bt=a("p"),Bt.innerHTML=Gs,ml=o(),M(Wt.$$.fragment),hl=o(),M(Gt.$$.fragment),bl=o(),kt=a("p"),kt.innerHTML=ks,wl=o(),Qt=a("p"),Qt.innerHTML=Qs,Tl=o(),M(Ht.$$.fragment),Jl=o(),Rt=a("p"),Rt.textContent=Hs,jl=o(),M(Vt.$$.fragment),Ul=o(),J=a("blockquote"),J.innerHTML=Rs,fl=o(),M(_t.$$.fragment),gl=o(),$t=a("p"),$t.innerHTML=Vs,Cl=o(),M(xt.$$.fragment),vl=o(),Nt=a("p"),Nt.innerHTML=_s,Il=o(),Et=a("p"),Et.innerHTML=$s,Zl=o(),j=a("blockquote"),j.innerHTML=xs,Bl=o(),Xt=a("p"),Xt.innerHTML=Ns,Wl=o(),M(St.$$.fragment),Gl=o(),qt=a("p"),qt.innerHTML=Es,kl=o(),M(At.$$.fragment),Ql=o(),Ft=a("p"),Ft.innerHTML=Xs,Hl=o(),M(Yt.$$.fragment),Rl=o(),M(zt.$$.fragment),Vl=o(),Lt=a("p"),Lt.textContent=Ss,_l=o(),M(Pt.$$.fragment),$l=o(),Dt=a("p"),Dt.textContent=qs,xl=o(),M(Kt.$$.fragment),Nl=o(),le=a("p"),this.h()},l(t){const e=Ks("svelte-u9bgzb",document.head);b=i(e,"META",{name:!0,content:!0}),e.forEach(l),se=n(t),ee=i(t,"P",{}),Fs(ee).forEach(l),oe=n(t),p(f.$$.fragment,t),ne=n(t),p(g.$$.fragment,t),ae=n(t),p(C.$$.fragment,t),ie=n(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-8951oz"&&(v.textContent=Sl),re=n(t),w=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1eo9frz"&&(w.innerHTML=ql),Me=n(t),p(I.$$.fragment,t),pe=n(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-50z9h0"&&(Z.textContent=Al),ue=n(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1llqfcr"&&(B.textContent=Fl),ce=n(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-eilpgu"&&(W.textContent=Yl),de=n(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-suz7fy"&&(G.textContent=zl),ye=n(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-x18ywb"&&(k.textContent=Ll),me=n(t),p(Q.$$.fragment,t),he=n(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-prn7f3"&&(H.innerHTML=Pl),be=n(t),R=i(t,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-129ni6r"&&(R.innerHTML=Dl),we=n(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-220ayw"&&(V.textContent=Kl),Te=n(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-13idprj"&&(_.innerHTML=Ol),Je=n(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1lot62h"&&($.innerHTML=ts),je=n(t),p(x.$$.fragment,t),Ue=n(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4kwync"&&(N.innerHTML=es),fe=n(t),p(E.$$.fragment,t),ge=n(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-hoocvd"&&(X.textContent=ls),Ce=n(t),S=i(t,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-cqj6gr"&&(S.innerHTML=ss),ve=n(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-4n5s3c"&&(q.innerHTML=os),Ie=n(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1knl8v8"&&(A.innerHTML=ns),Ze=n(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1skw0cc"&&(F.innerHTML=as),Be=n(t),p(Y.$$.fragment,t),We=n(t),p(z.$$.fragment,t),Ge=n(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-eofyyc"&&(L.innerHTML=is),ke=n(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1en3ihe"&&(P.textContent=rs),Qe=n(t),p(D.$$.fragment,t),He=n(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ro6hjz"&&(K.textContent=Ms),Re=n(t),p(O.$$.fragment,t),Ve=n(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1and4a8"&&(tt.textContent=ps),_e=n(t),p(et.$$.fragment,t),$e=n(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-7q6kbi"&&(lt.textContent=us),xe=n(t),p(st.$$.fragment,t),Ne=n(t),T=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-kwg2aw"&&(T.innerHTML=cs),Ee=n(t),p(ot.$$.fragment,t),Xe=n(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1ku5522"&&(nt.innerHTML=ds),Se=n(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-10wjig9"&&(at.innerHTML=ys),qe=n(t),p(it.$$.fragment,t),Ae=n(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-rntkgd"&&(rt.innerHTML=ms),Fe=n(t),Mt=i(t,"UL",{"data-svelte-h":!0}),r(Mt)!=="svelte-745dbc"&&(Mt.innerHTML=hs),Ye=n(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1e0rvyj"&&(pt.textContent=bs),ze=n(t),p(ut.$$.fragment,t),Le=n(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-xhsky2"&&(ct.textContent=ws),Pe=n(t),p(dt.$$.fragment,t),De=n(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1dbhry6"&&(yt.innerHTML=Ts),Ke=n(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-shyg20"&&(mt.innerHTML=Js),Oe=n(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-g6qlg5"&&(ht.innerHTML=js),tl=n(t),p(bt.$$.fragment,t),el=n(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1p3gfeb"&&(wt.innerHTML=Us),ll=n(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-17wa58l"&&(Tt.innerHTML=fs),sl=n(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1gucs20"&&(Jt.innerHTML=gs),ol=n(t),p(jt.$$.fragment,t),nl=n(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-sgspwr"&&(Ut.textContent=Cs),al=n(t),Ot=i(t,"IMG",{src:!0}),il=n(t),ft=i(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1y8rl57"&&(ft.innerHTML=Is),rl=n(t),p(gt.$$.fragment,t),Ml=n(t),p(Ct.$$.fragment,t),pl=n(t),te=i(t,"IMG",{src:!0}),ul=n(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-i5dtbz"&&(vt.textContent=Bs),cl=n(t),p(It.$$.fragment,t),dl=n(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1rq40pf"&&(Zt.innerHTML=Ws),yl=n(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1g7jkvd"&&(Bt.innerHTML=Gs),ml=n(t),p(Wt.$$.fragment,t),hl=n(t),p(Gt.$$.fragment,t),bl=n(t),kt=i(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-69p3x"&&(kt.innerHTML=ks),wl=n(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-ocb8u2"&&(Qt.innerHTML=Qs),Tl=n(t),p(Ht.$$.fragment,t),Jl=n(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-o3ledg"&&(Rt.textContent=Hs),jl=n(t),p(Vt.$$.fragment,t),Ul=n(t),J=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1xyjnip"&&(J.innerHTML=Rs),fl=n(t),p(_t.$$.fragment,t),gl=n(t),$t=i(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-w4ihv0"&&($t.innerHTML=Vs),Cl=n(t),p(xt.$$.fragment,t),vl=n(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1q39vf"&&(Nt.innerHTML=_s),Il=n(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-v7rocy"&&(Et.innerHTML=$s),Zl=n(t),j=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-kwg2aw"&&(j.innerHTML=xs),Bl=n(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-s0gh2b"&&(Xt.innerHTML=Ns),Wl=n(t),p(St.$$.fragment,t),Gl=n(t),qt=i(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-17z5hjh"&&(qt.innerHTML=Es),kl=n(t),p(At.$$.fragment,t),Ql=n(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-j0i0xh"&&(Ft.innerHTML=Xs),Hl=n(t),p(Yt.$$.fragment,t),Rl=n(t),p(zt.$$.fragment,t),Vl=n(t),Lt=i(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-qubpc6"&&(Lt.textContent=Ss),_l=n(t),p(Pt.$$.fragment,t),$l=n(t),Dt=i(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-6r1jgt"&&(Dt.textContent=qs),xl=n(t),p(Kt.$$.fragment,t),Nl=n(t),le=i(t,"P",{}),Fs(le).forEach(l),this.h()},h(){U(b,"name","hf:doc:metadata"),U(b,"content",oo),U(w,"class","tip"),U(T,"class","warning"),As(Ot.src,vs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||U(Ot,"src",vs),As(te.src,Zs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||U(te,"src",Zs),U(J,"class","tip"),U(j,"class","warning")},m(t,e){Os(document.head,b),s(t,se,e),s(t,ee,e),s(t,oe,e),u(f,t,e),s(t,ne,e),u(g,t,e),s(t,ae,e),u(C,t,e),s(t,ie,e),s(t,v,e),s(t,re,e),s(t,w,e),s(t,Me,e),u(I,t,e),s(t,pe,e),s(t,Z,e),s(t,ue,e),s(t,B,e),s(t,ce,e),s(t,W,e),s(t,de,e),s(t,G,e),s(t,ye,e),s(t,k,e),s(t,me,e),u(Q,t,e),s(t,he,e),s(t,H,e),s(t,be,e),s(t,R,e),s(t,we,e),s(t,V,e),s(t,Te,e),s(t,_,e),s(t,Je,e),s(t,$,e),s(t,je,e),u(x,t,e),s(t,Ue,e),s(t,N,e),s(t,fe,e),u(E,t,e),s(t,ge,e),s(t,X,e),s(t,Ce,e),s(t,S,e),s(t,ve,e),s(t,q,e),s(t,Ie,e),s(t,A,e),s(t,Ze,e),s(t,F,e),s(t,Be,e),u(Y,t,e),s(t,We,e),u(z,t,e),s(t,Ge,e),s(t,L,e),s(t,ke,e),s(t,P,e),s(t,Qe,e),u(D,t,e),s(t,He,e),s(t,K,e),s(t,Re,e),u(O,t,e),s(t,Ve,e),s(t,tt,e),s(t,_e,e),u(et,t,e),s(t,$e,e),s(t,lt,e),s(t,xe,e),u(st,t,e),s(t,Ne,e),s(t,T,e),s(t,Ee,e),u(ot,t,e),s(t,Xe,e),s(t,nt,e),s(t,Se,e),s(t,at,e),s(t,qe,e),u(it,t,e),s(t,Ae,e),s(t,rt,e),s(t,Fe,e),s(t,Mt,e),s(t,Ye,e),s(t,pt,e),s(t,ze,e),u(ut,t,e),s(t,Le,e),s(t,ct,e),s(t,Pe,e),u(dt,t,e),s(t,De,e),s(t,yt,e),s(t,Ke,e),s(t,mt,e),s(t,Oe,e),s(t,ht,e),s(t,tl,e),u(bt,t,e),s(t,el,e),s(t,wt,e),s(t,ll,e),s(t,Tt,e),s(t,sl,e),s(t,Jt,e),s(t,ol,e),u(jt,t,e),s(t,nl,e),s(t,Ut,e),s(t,al,e),s(t,Ot,e),s(t,il,e),s(t,ft,e),s(t,rl,e),u(gt,t,e),s(t,Ml,e),u(Ct,t,e),s(t,pl,e),s(t,te,e),s(t,ul,e),s(t,vt,e),s(t,cl,e),u(It,t,e),s(t,dl,e),s(t,Zt,e),s(t,yl,e),s(t,Bt,e),s(t,ml,e),u(Wt,t,e),s(t,hl,e),u(Gt,t,e),s(t,bl,e),s(t,kt,e),s(t,wl,e),s(t,Qt,e),s(t,Tl,e),u(Ht,t,e),s(t,Jl,e),s(t,Rt,e),s(t,jl,e),u(Vt,t,e),s(t,Ul,e),s(t,J,e),s(t,fl,e),u(_t,t,e),s(t,gl,e),s(t,$t,e),s(t,Cl,e),u(xt,t,e),s(t,vl,e),s(t,Nt,e),s(t,Il,e),s(t,Et,e),s(t,Zl,e),s(t,j,e),s(t,Bl,e),s(t,Xt,e),s(t,Wl,e),u(St,t,e),s(t,Gl,e),s(t,qt,e),s(t,kl,e),u(At,t,e),s(t,Ql,e),s(t,Ft,e),s(t,Hl,e),u(Yt,t,e),s(t,Rl,e),u(zt,t,e),s(t,Vl,e),s(t,Lt,e),s(t,_l,e),u(Pt,t,e),s(t,$l,e),s(t,Dt,e),s(t,xl,e),u(Kt,t,e),s(t,Nl,e),s(t,le,e),El=!0},p:zs,i(t){El||(c(f.$$.fragment,t),c(g.$$.fragment,t),c(C.$$.fragment,t),c(I.$$.fragment,t),c(Q.$$.fragment,t),c(x.$$.fragment,t),c(E.$$.fragment,t),c(Y.$$.fragment,t),c(z.$$.fragment,t),c(D.$$.fragment,t),c(O.$$.fragment,t),c(et.$$.fragment,t),c(st.$$.fragment,t),c(ot.$$.fragment,t),c(it.$$.fragment,t),c(ut.$$.fragment,t),c(dt.$$.fragment,t),c(bt.$$.fragment,t),c(jt.$$.fragment,t),c(gt.$$.fragment,t),c(Ct.$$.fragment,t),c(It.$$.fragment,t),c(Wt.$$.fragment,t),c(Gt.$$.fragment,t),c(Ht.$$.fragment,t),c(Vt.$$.fragment,t),c(_t.$$.fragment,t),c(xt.$$.fragment,t),c(St.$$.fragment,t),c(At.$$.fragment,t),c(Yt.$$.fragment,t),c(zt.$$.fragment,t),c(Pt.$$.fragment,t),c(Kt.$$.fragment,t),El=!0)},o(t){d(f.$$.fragment,t),d(g.$$.fragment,t),d(C.$$.fragment,t),d(I.$$.fragment,t),d(Q.$$.fragment,t),d(x.$$.fragment,t),d(E.$$.fragment,t),d(Y.$$.fragment,t),d(z.$$.fragment,t),d(D.$$.fragment,t),d(O.$$.fragment,t),d(et.$$.fragment,t),d(st.$$.fragment,t),d(ot.$$.fragment,t),d(it.$$.fragment,t),d(ut.$$.fragment,t),d(dt.$$.fragment,t),d(bt.$$.fragment,t),d(jt.$$.fragment,t),d(gt.$$.fragment,t),d(Ct.$$.fragment,t),d(It.$$.fragment,t),d(Wt.$$.fragment,t),d(Gt.$$.fragment,t),d(Ht.$$.fragment,t),d(Vt.$$.fragment,t),d(_t.$$.fragment,t),d(xt.$$.fragment,t),d(St.$$.fragment,t),d(At.$$.fragment,t),d(Yt.$$.fragment,t),d(zt.$$.fragment,t),d(Pt.$$.fragment,t),d(Kt.$$.fragment,t),El=!1},d(t){t&&(l(se),l(ee),l(oe),l(ne),l(ae),l(ie),l(v),l(re),l(w),l(Me),l(pe),l(Z),l(ue),l(B),l(ce),l(W),l(de),l(G),l(ye),l(k),l(me),l(he),l(H),l(be),l(R),l(we),l(V),l(Te),l(_),l(Je),l($),l(je),l(Ue),l(N),l(fe),l(ge),l(X),l(Ce),l(S),l(ve),l(q),l(Ie),l(A),l(Ze),l(F),l(Be),l(We),l(Ge),l(L),l(ke),l(P),l(Qe),l(He),l(K),l(Re),l(Ve),l(tt),l(_e),l($e),l(lt),l(xe),l(Ne),l(T),l(Ee),l(Xe),l(nt),l(Se),l(at),l(qe),l(Ae),l(rt),l(Fe),l(Mt),l(Ye),l(pt),l(ze),l(Le),l(ct),l(Pe),l(De),l(yt),l(Ke),l(mt),l(Oe),l(ht),l(tl),l(el),l(wt),l(ll),l(Tt),l(sl),l(Jt),l(ol),l(nl),l(Ut),l(al),l(Ot),l(il),l(ft),l(rl),l(Ml),l(pl),l(te),l(ul),l(vt),l(cl),l(dl),l(Zt),l(yl),l(Bt),l(ml),l(hl),l(bl),l(kt),l(wl),l(Qt),l(Tl),l(Jl),l(Rt),l(jl),l(Ul),l(J),l(fl),l(gl),l($t),l(Cl),l(vl),l(Nt),l(Il),l(Et),l(Zl),l(j),l(Bl),l(Xt),l(Wl),l(Gl),l(qt),l(kl),l(Ql),l(Ft),l(Hl),l(Rl),l(Vl),l(Lt),l(_l),l($l),l(Dt),l(xl),l(Nl),l(le)),l(b),y(f,t),y(g,t),y(C,t),y(I,t),y(Q,t),y(x,t),y(E,t),y(Y,t),y(z,t),y(D,t),y(O,t),y(et,t),y(st,t),y(ot,t),y(it,t),y(ut,t),y(dt,t),y(bt,t),y(jt,t),y(gt,t),y(Ct,t),y(It,t),y(Wt,t),y(Gt,t),y(Ht,t),y(Vt,t),y(_t,t),y(xt,t),y(St,t),y(At,t),y(Yt,t),y(zt,t),y(Pt,t),y(Kt,t)}}}const oo='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Use tools from an MCP server","local":"use-tools-from-an-mcp-server","sections":[{"title":"Structured Output and Output Schema Support","local":"structured-output-and-output-schema-support","sections":[],"depth":4}],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4},{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4}],"depth":3}],"depth":1}';function no(Xl){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class uo extends Ps{constructor(b){super(),Ds(this,b,no,so,Ys,{})}}export{uo as component};
