import{s as st,n as nt,o as ot}from"../chunks/scheduler.3d32dc09.js";import{S as it,i as at,e as i,s as n,c as m,h as mt,a,d as l,b as o,f as tt,g as p,j as r,k as lt,l as pt,m as s,n as d,t as f,o as M,p as g}from"../chunks/index.f9718211.js";import{C as rt,H as K,E as dt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.70a1e6b5.js";import{C as u}from"../chunks/CodeBlock.d4b513b9.js";import{D as ft}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function Mt(je){let T,ee,q,te,c,le,w,se,b,ne,J,Se=`<code>smolagents</code> provides a flexible framework that allows you to use various language models from different providers.
This guide will show you how to use different model types with your agents.`,oe,y,ie,I,Ge="<code>smolagents</code> supports several model types out of the box:",ae,U,Pe='<li><a href="/docs/smolagents/main/en/reference/models#smolagents.InferenceClientModel">InferenceClientModel</a>: Uses Hugging Face’s Inference API to access models</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.TransformersModel">TransformersModel</a>: Runs models locally using the Transformers library</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.VLLMModel">VLLMModel</a>: Uses vLLM for fast inference with optimized serving</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.MLXModel">MLXModel</a>: Optimized for Apple Silicon devices using MLX</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMModel">LiteLLMModel</a>: Provides access to hundreds of LLMs through LiteLLM</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMRouterModel">LiteLLMRouterModel</a>: Distributes requests among multiple models</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIModel">OpenAIModel</a>: Provides access to any provider that implements an OpenAI-compatible API</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.AzureOpenAIModel">AzureOpenAIModel</a>: Uses Azure’s OpenAI service</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.AmazonBedrockModel">AmazonBedrockModel</a>: Connects to AWS Bedrock’s API</li>',me,h,Fe=`All model classes support passing additional keyword arguments (like <code>temperature</code>, <code>max_tokens</code>, <code>top_p</code>, etc.) directly at instantiation time.
These parameters are automatically forwarded to the underlying model’s completion calls, allowing you to configure model behavior such as creativity, response length, and sampling strategies.`,pe,$,re,v,We=`As explained in the Google Gemini API documentation (<a href="https://ai.google.dev/gemini-api/docs/openai" rel="nofollow">https://ai.google.dev/gemini-api/docs/openai</a>),
Google provides an OpenAI-compatible API for Gemini models, allowing you to use the <a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIModel">OpenAIModel</a>
with Gemini models by setting the appropriate base URL.`,de,k,He="First, install the required dependencies:",fe,R,Me,L,Oe='Then, <a href="https://ai.google.dev/gemini-api/docs/api-key" rel="nofollow">get a Gemini API key</a> and set it in your code:',ge,B,Te,A,Qe=`Now, you can initialize the Gemini model using the <code>OpenAIModel</code> class
and setting the <code>api_base</code> parameter to the Gemini API base URL:`,ue,_,ce,V,we,E,ze=`OpenRouter provides access to a wide variety of language models through a unified OpenAI-compatible API.
You can use the <a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIModel">OpenAIModel</a> to connect to OpenRouter by setting the appropriate base URL.`,be,x,Ze="First, install the required dependencies:",Je,C,ye,j,Ne='Then, <a href="https://openrouter.ai/keys" rel="nofollow">get an OpenRouter API key</a> and set it in your code:',Ie,S,Ue,G,Xe="Now, you can initialize any model available on OpenRouter using the <code>OpenAIModel</code> class:",he,P,$e,F,ve,W,Ye='xAI’s Grok models can be accessed through <a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMModel">LiteLLMModel</a>.',ke,H,qe=`Some models (such as “grok-4” and “grok-3-mini”) don’t support the <code>stop</code> parameter, so you’ll need to use
<code>REMOVE_PARAMETER</code> to exclude it from API calls.`,Re,O,De="First, install the required dependencies:",Le,Q,Be,z,Ke='Then, <a href="https://console.x.ai/" rel="nofollow">get an xAI API key</a> and set it in your code:',Ae,Z,_e,N,et="Now, you can initialize Grok models using the <code>LiteLLMModel</code> class and remove the <code>stop</code> parameter if applicable:",Ve,X,Ee,Y,xe,D,Ce;return c=new rt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/using_different_models.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/using_different_models.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/using_different_models.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/using_different_models.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/using_different_models.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/using_different_models.ipynb"}]}}),b=new K({props:{title:"Using different models",local:"using-different-models",headingTag:"h1"}}),y=new K({props:{title:"Available model types",local:"available-model-types",headingTag:"h2"}}),$=new K({props:{title:"Using Google Gemini Models",local:"using-google-gemini-models",headingTag:"h2"}}),R=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCb3BlbmFpJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[openai]&#x27;</span>',wrap:!1}}),B=new u({props:{code:"R0VNSU5JX0FQSV9LRVklMjAlM0QlMjAlM0NZT1VSLUdFTUlOSS1BUEktS0VZJTNF",highlighted:"GEMINI_API_KEY = &lt;YOUR-GEMINI-API-KEY&gt;",wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBPcGVuQUlNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJnZW1pbmktMi4wLWZsYXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwR29vZ2xlJTIwR2VtaW5pJTIwT3BlbkFJLWNvbXBhdGlibGUlMjBBUEklMjBiYXNlJTIwVVJMJTBBJTIwJTIwJTIwJTIwYXBpX2Jhc2UlM0QlMjJodHRwcyUzQSUyRiUyRmdlbmVyYXRpdmVsYW5ndWFnZS5nb29nbGVhcGlzLmNvbSUyRnYxYmV0YSUyRm9wZW5haSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RHRU1JTklfQVBJX0tFWSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIModel

model = OpenAIModel(
    model_id=<span class="hljs-string">&quot;gemini-2.0-flash&quot;</span>,
    <span class="hljs-comment"># Google Gemini OpenAI-compatible API base URL</span>
    api_base=<span class="hljs-string">&quot;https://generativelanguage.googleapis.com/v1beta/openai/&quot;</span>,
    api_key=GEMINI_API_KEY,
)`,wrap:!1}}),V=new K({props:{title:"Using OpenRouter Models",local:"using-openrouter-models",headingTag:"h2"}}),C=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCb3BlbmFpJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[openai]&#x27;</span>',wrap:!1}}),S=new u({props:{code:"T1BFTlJPVVRFUl9BUElfS0VZJTIwJTNEJTIwJTNDWU9VUi1PUEVOUk9VVEVSLUFQSS1LRVklM0U=",highlighted:"OPENROUTER_API_KEY = &lt;YOUR-OPENROUTER-API-KEY&gt;",wrap:!1}}),P=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBPcGVuQUlNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJTW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwdXNlJTIwYW55JTIwbW9kZWwlMjBJRCUyMGF2YWlsYWJsZSUyMG9uJTIwT3BlblJvdXRlciUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJTIyb3BlbmFpJTJGZ3B0LTRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3BlblJvdXRlciUyMEFQSSUyMGJhc2UlMjBVUkwlMEElMjAlMjAlMjAlMjBhcGlfYmFzZSUzRCUyMmh0dHBzJTNBJTJGJTJGb3BlbnJvdXRlci5haSUyRmFwaSUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRE9QRU5ST1VURVJfQVBJX0tFWSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIModel

model = OpenAIModel(
    <span class="hljs-comment"># You can use any model ID available on OpenRouter</span>
    model_id=<span class="hljs-string">&quot;openai/gpt-4o&quot;</span>,
    <span class="hljs-comment"># OpenRouter API base URL</span>
    api_base=<span class="hljs-string">&quot;https://openrouter.ai/api/v1&quot;</span>,
    api_key=OPENROUTER_API_KEY,
)`,wrap:!1}}),F=new K({props:{title:"Using xAI’s Grok Models",local:"using-xais-grok-models",headingTag:"h2"}}),Q=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlNUJsaXRlbGxtJTVE",highlighted:"pip install smolagents[litellm]",wrap:!1}}),Z=new u({props:{code:"WEFJX0FQSV9LRVklMjAlM0QlMjAlM0NZT1VSLVhBSS1BUEktS0VZJTNF",highlighted:"XAI_API_KEY = &lt;YOUR-XAI-API-KEY&gt;",wrap:!1}}),X=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBMaXRlTExNTW9kZWwlMkMlMjBSRU1PVkVfUEFSQU1FVEVSJTBBJTBBJTIzJTIwVXNpbmclMjBHcm9rLTQlMEFtb2RlbCUyMCUzRCUyMExpdGVMTE1Nb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMnhhaSUyRmdyb2stNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RYQUlfQVBJX0tFWSUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0RSRU1PVkVfUEFSQU1FVEVSJTJDJTIwJTIwJTIzJTIwUmVtb3ZlJTIwc3RvcCUyMHBhcmFtZXRlciUyMGFzJTIwZ3Jvay00JTIwbW9kZWwlMjBkb2Vzbid0JTIwc3VwcG9ydCUyMGl0JTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMEEpJTBBJTBBJTIzJTIwT3IlMjB1c2luZyUyMEdyb2stMy1taW5pJTBBbW9kZWxfbWluaSUyMCUzRCUyMExpdGVMTE1Nb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMnhhaSUyRmdyb2stMy1taW5pJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRFhBSV9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwc3RvcCUzRFJFTU9WRV9QQVJBTUVURVIlMkMlMjAlMjAlMjMlMjBSZW1vdmUlMjBzdG9wJTIwcGFyYW1ldGVyJTIwYXMlMjBncm9rLTMtbWluaSUyMG1vZGVsJTIwZG9lc24ndCUyMHN1cHBvcnQlMjBpdCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDAwJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMModel, REMOVE_PARAMETER

<span class="hljs-comment"># Using Grok-4</span>
model = LiteLLMModel(
    model_id=<span class="hljs-string">&quot;xai/grok-4&quot;</span>,
    api_key=XAI_API_KEY,
    stop=REMOVE_PARAMETER,  <span class="hljs-comment"># Remove stop parameter as grok-4 model doesn&#x27;t support it</span>
    temperature=<span class="hljs-number">0.7</span>
)

<span class="hljs-comment"># Or using Grok-3-mini</span>
model_mini = LiteLLMModel(
    model_id=<span class="hljs-string">&quot;xai/grok-3-mini&quot;</span>,
    api_key=XAI_API_KEY,
    stop=REMOVE_PARAMETER,  <span class="hljs-comment"># Remove stop parameter as grok-3-mini model doesn&#x27;t support it</span>
    max_tokens=<span class="hljs-number">1000</span>
)`,wrap:!1}}),Y=new dt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/using_different_models.md"}}),{c(){T=i("meta"),ee=n(),q=i("p"),te=n(),m(c.$$.fragment),le=n(),m(w.$$.fragment),se=n(),m(b.$$.fragment),ne=n(),J=i("p"),J.innerHTML=Se,oe=n(),m(y.$$.fragment),ie=n(),I=i("p"),I.innerHTML=Ge,ae=n(),U=i("ol"),U.innerHTML=Pe,me=n(),h=i("p"),h.innerHTML=Fe,pe=n(),m($.$$.fragment),re=n(),v=i("p"),v.innerHTML=We,de=n(),k=i("p"),k.textContent=He,fe=n(),m(R.$$.fragment),Me=n(),L=i("p"),L.innerHTML=Oe,ge=n(),m(B.$$.fragment),Te=n(),A=i("p"),A.innerHTML=Qe,ue=n(),m(_.$$.fragment),ce=n(),m(V.$$.fragment),we=n(),E=i("p"),E.innerHTML=ze,be=n(),x=i("p"),x.textContent=Ze,Je=n(),m(C.$$.fragment),ye=n(),j=i("p"),j.innerHTML=Ne,Ie=n(),m(S.$$.fragment),Ue=n(),G=i("p"),G.innerHTML=Xe,he=n(),m(P.$$.fragment),$e=n(),m(F.$$.fragment),ve=n(),W=i("p"),W.innerHTML=Ye,ke=n(),H=i("p"),H.innerHTML=qe,Re=n(),O=i("p"),O.textContent=De,Le=n(),m(Q.$$.fragment),Be=n(),z=i("p"),z.innerHTML=Ke,Ae=n(),m(Z.$$.fragment),_e=n(),N=i("p"),N.innerHTML=et,Ve=n(),m(X.$$.fragment),Ee=n(),m(Y.$$.fragment),xe=n(),D=i("p"),this.h()},l(e){const t=mt("svelte-u9bgzb",document.head);T=a(t,"META",{name:!0,content:!0}),t.forEach(l),ee=o(e),q=a(e,"P",{}),tt(q).forEach(l),te=o(e),p(c.$$.fragment,e),le=o(e),p(w.$$.fragment,e),se=o(e),p(b.$$.fragment,e),ne=o(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-nqa3ku"&&(J.innerHTML=Se),oe=o(e),p(y.$$.fragment,e),ie=o(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-z7j4in"&&(I.innerHTML=Ge),ae=o(e),U=a(e,"OL",{"data-svelte-h":!0}),r(U)!=="svelte-1pm0ywt"&&(U.innerHTML=Pe),me=o(e),h=a(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-zqae9j"&&(h.innerHTML=Fe),pe=o(e),p($.$$.fragment,e),re=o(e),v=a(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1xzmmxg"&&(v.innerHTML=We),de=o(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1f3oki6"&&(k.textContent=He),fe=o(e),p(R.$$.fragment,e),Me=o(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1scf5a3"&&(L.innerHTML=Oe),ge=o(e),p(B.$$.fragment,e),Te=o(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-wudpny"&&(A.innerHTML=Qe),ue=o(e),p(_.$$.fragment,e),ce=o(e),p(V.$$.fragment,e),we=o(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ba9kal"&&(E.innerHTML=ze),be=o(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1f3oki6"&&(x.textContent=Ze),Je=o(e),p(C.$$.fragment,e),ye=o(e),j=a(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-co5fkh"&&(j.innerHTML=Ne),Ie=o(e),p(S.$$.fragment,e),Ue=o(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-n1uwug"&&(G.innerHTML=Xe),he=o(e),p(P.$$.fragment,e),$e=o(e),p(F.$$.fragment,e),ve=o(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1qlxq5o"&&(W.innerHTML=Ye),ke=o(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1iunuuy"&&(H.innerHTML=qe),Re=o(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1f3oki6"&&(O.textContent=De),Le=o(e),p(Q.$$.fragment,e),Be=o(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-180jkec"&&(z.innerHTML=Ke),Ae=o(e),p(Z.$$.fragment,e),_e=o(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ffid4g"&&(N.innerHTML=et),Ve=o(e),p(X.$$.fragment,e),Ee=o(e),p(Y.$$.fragment,e),xe=o(e),D=a(e,"P",{}),tt(D).forEach(l),this.h()},h(){lt(T,"name","hf:doc:metadata"),lt(T,"content",gt)},m(e,t){pt(document.head,T),s(e,ee,t),s(e,q,t),s(e,te,t),d(c,e,t),s(e,le,t),d(w,e,t),s(e,se,t),d(b,e,t),s(e,ne,t),s(e,J,t),s(e,oe,t),d(y,e,t),s(e,ie,t),s(e,I,t),s(e,ae,t),s(e,U,t),s(e,me,t),s(e,h,t),s(e,pe,t),d($,e,t),s(e,re,t),s(e,v,t),s(e,de,t),s(e,k,t),s(e,fe,t),d(R,e,t),s(e,Me,t),s(e,L,t),s(e,ge,t),d(B,e,t),s(e,Te,t),s(e,A,t),s(e,ue,t),d(_,e,t),s(e,ce,t),d(V,e,t),s(e,we,t),s(e,E,t),s(e,be,t),s(e,x,t),s(e,Je,t),d(C,e,t),s(e,ye,t),s(e,j,t),s(e,Ie,t),d(S,e,t),s(e,Ue,t),s(e,G,t),s(e,he,t),d(P,e,t),s(e,$e,t),d(F,e,t),s(e,ve,t),s(e,W,t),s(e,ke,t),s(e,H,t),s(e,Re,t),s(e,O,t),s(e,Le,t),d(Q,e,t),s(e,Be,t),s(e,z,t),s(e,Ae,t),d(Z,e,t),s(e,_e,t),s(e,N,t),s(e,Ve,t),d(X,e,t),s(e,Ee,t),d(Y,e,t),s(e,xe,t),s(e,D,t),Ce=!0},p:nt,i(e){Ce||(f(c.$$.fragment,e),f(w.$$.fragment,e),f(b.$$.fragment,e),f(y.$$.fragment,e),f($.$$.fragment,e),f(R.$$.fragment,e),f(B.$$.fragment,e),f(_.$$.fragment,e),f(V.$$.fragment,e),f(C.$$.fragment,e),f(S.$$.fragment,e),f(P.$$.fragment,e),f(F.$$.fragment,e),f(Q.$$.fragment,e),f(Z.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),Ce=!0)},o(e){M(c.$$.fragment,e),M(w.$$.fragment,e),M(b.$$.fragment,e),M(y.$$.fragment,e),M($.$$.fragment,e),M(R.$$.fragment,e),M(B.$$.fragment,e),M(_.$$.fragment,e),M(V.$$.fragment,e),M(C.$$.fragment,e),M(S.$$.fragment,e),M(P.$$.fragment,e),M(F.$$.fragment,e),M(Q.$$.fragment,e),M(Z.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),Ce=!1},d(e){e&&(l(ee),l(q),l(te),l(le),l(se),l(ne),l(J),l(oe),l(ie),l(I),l(ae),l(U),l(me),l(h),l(pe),l(re),l(v),l(de),l(k),l(fe),l(Me),l(L),l(ge),l(Te),l(A),l(ue),l(ce),l(we),l(E),l(be),l(x),l(Je),l(ye),l(j),l(Ie),l(Ue),l(G),l(he),l($e),l(ve),l(W),l(ke),l(H),l(Re),l(O),l(Le),l(Be),l(z),l(Ae),l(_e),l(N),l(Ve),l(Ee),l(xe),l(D)),l(T),g(c,e),g(w,e),g(b,e),g(y,e),g($,e),g(R,e),g(B,e),g(_,e),g(V,e),g(C,e),g(S,e),g(P,e),g(F,e),g(Q,e),g(Z,e),g(X,e),g(Y,e)}}}const gt='{"title":"Using different models","local":"using-different-models","sections":[{"title":"Available model types","local":"available-model-types","sections":[],"depth":2},{"title":"Using Google Gemini Models","local":"using-google-gemini-models","sections":[],"depth":2},{"title":"Using OpenRouter Models","local":"using-openrouter-models","sections":[],"depth":2},{"title":"Using xAI’s Grok Models","local":"using-xais-grok-models","sections":[],"depth":2}],"depth":1}';function Tt(je){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends it{constructor(T){super(),at(this,T,Tt,Mt,st,{})}}export{yt as component};
