import{s as ml,f as al,o as ul,n as Ml}from"../chunks/scheduler.f6319a2a.js";import{S as dl,i as bl,g as a,s as n,r as m,A as rl,h as i,f as l,c as o,j as il,u,x as p,k as jt,y as cl,a as s,v as d,d as b,t as r,w as c}from"../chunks/index.85aa684c.js";import{T as pl}from"../chunks/Tip.3d397a88.js";import{C as y}from"../chunks/CodeBlock.3400fc53.js";import{D as fl}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as ye,E as hl}from"../chunks/getInferenceSnippets.74d2db76.js";function yl(ge){let M,h='如果你是构建 agent 的新手，请确保先阅读 <a href="../conceptual_guides/intro_agents">agent 介绍</a> 和 <a href="../guided_tour">smolagents 导览</a>。';return{c(){M=a("p"),M.innerHTML=h},l(f){M=i(f,"P",{"data-svelte-h":!0}),p(M)!=="svelte-14gbuyi"&&(M.innerHTML=h)},m(f,g){s(f,M,g)},p:Ml,d(f){f&&l(M)}}}function gl(ge){let M,h="注意不要向 agent 添加太多工具：这可能会让较弱的 LLM 引擎不堪重负。";return{c(){M=a("p"),M.textContent=h},l(f){M=i(f,"P",{"data-svelte-h":!0}),p(M)!=="svelte-198uno3"&&(M.textContent=h)},m(f,g){s(f,M,g)},p:Ml,d(f){f&&l(M)}}}function Ul(ge){let M,h,f,g,T,Je,J,je,j,Ct="在这里，我们将学习高级工具的使用。",Ce,U,ve,C,vt='<li><a href="#%E5%B7%A5%E5%85%B7">工具</a><ul><li><a href="#%E4%BB%80%E4%B9%88%E6%98%AF%E5%B7%A5%E5%85%B7%E5%A6%82%E4%BD%95%E6%9E%84%E5%BB%BA%E4%B8%80%E4%B8%AA%E5%B7%A5%E5%85%B7">什么是工具，如何构建一个工具？</a></li> <li><a href="#%E5%B0%86%E4%BD%A0%E7%9A%84%E5%B7%A5%E5%85%B7%E5%88%86%E4%BA%AB%E5%88%B0-hub">将你的工具分享到 Hub</a></li> <li><a href="#%E5%B0%86-space-%E5%AF%BC%E5%85%A5%E4%B8%BA%E5%B7%A5%E5%85%B7">将 Space 导入为工具</a></li> <li><a href="#%E4%BD%BF%E7%94%A8-langchain-%E5%B7%A5%E5%85%B7">使用 LangChain 工具</a></li> <li><a href="#%E7%AE%A1%E7%90%86%E4%BD%A0%E7%9A%84-agent-%E5%B7%A5%E5%85%B7%E7%AE%B1">管理你的 agent 工具箱</a></li> <li><a href="#%E4%BD%BF%E7%94%A8%E5%B7%A5%E5%85%B7%E9%9B%86%E5%90%88">使用工具集合</a></li></ul></li>',$e,v,_e,$,$t="工具主要是 LLM 可以在 agent 系统中使用的函数。",Ie,_,_t="但要使用它，LLM 需要被提供一个 API：名称、工具描述、输入类型和描述、输出类型。",Be,I,It="所以它不能仅仅是一个函数。它应该是一个类。",Ze,B,Bt="因此，核心上，工具是一个类，它包装了一个函数，并带有帮助 LLM 理解如何使用它的元数据。",Ge,Z,Zt="以下是它的结构：",He,G,Ee,H,Gt='自定义工具继承 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.Tool">Tool</a> 以继承有用的方法。子类还定义了：',xe,E,Ht='<li>一个属性 <code>name</code>，对应于工具本身的名称。名称通常描述工具的功能。由于代码返回任务中下载量最多的模型，我们将其命名为 <code>model_download_counter</code>。</li> <li>一个属性 <code>description</code>，用于填充 agent 的系统提示。</li> <li>一个 <code>inputs</code> 属性，它是一个带有键 <code>&quot;type&quot;</code> 和 <code>&quot;description&quot;</code> 的字典。它包含帮助 Python 解释器对输入做出明智选择的信息。</li> <li>一个 <code>output_type</code> 属性，指定输出类型。<code>inputs</code> 和 <code>output_type</code> 的类型应为 <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic 格式</a>，它们可以是以下之一：<code>~AUTHORIZED_TYPES()</code>。</li> <li>一个 <code>forward</code> 方法，包含要执行的推理代码。</li>',We,x,Et="这就是它在 agent 中使用所需的全部内容！",ke,W,xt='还有另一种构建工具的方法。在 <a href="../guided_tour">guided_tour</a> 中，我们使用 <code>@tool</code> 装饰器实现了一个工具。<a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.tool">tool()</a> 装饰器是定义简单工具的推荐方式，但有时你需要更多：在类中使用多个方法以获得更清晰的代码，或使用额外的类属性。',Re,k,Wt='在这种情况下，你可以通过如上所述继承 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.Tool">Tool</a> 来构建你的工具。',Qe,R,Ae,Q,kt='你可以通过调用 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> 将你的自定义工具分享到 Hub。确保你已经在 Hub 上为其创建了一个仓库，并且使用的是具有读取权限的 token。',Ve,A,Se,V,Rt="为了使推送到 Hub 正常工作，你的工具需要遵守一些规则：",Ne,S,Qt='<li>所有方法都是自包含的，例如使用来自其参数中的变量。</li> <li>根据上述要点，<strong>所有导入应直接在工具的函数中定义</strong>，否则在尝试使用 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.Tool.save">save()</a> 或 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> 调用你的自定义工具时会出现错误。</li> <li>如果你继承了 <code>__init__</code> 方法，除了 <code>self</code> 之外，你不能给它任何其他参数。这是因为在特定工具实例初始化期间设置的参数很难跟踪，这阻碍了将它们正确分享到 Hub。无论如何，创建特定类的想法是你已经可以为任何需要硬编码的内容设置类属性（只需在 <code>class YourTool(Tool):</code> 行下直接设置 <code>your_variable=(...)</code>）。当然，你仍然可以通过将内容分配给 <code>self.your_variable</code> 在代码中的任何地方创建类属性。</li>',ze,N,At='一旦你的工具被推送到 Hub，你就可以查看它。<a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">这里</a> 是我推送的 <code>model_downloads_tool</code>。它有一个漂亮的 gradio 界面。',Le,z,Vt='在深入工具文件时，你可以发现所有工具的逻辑都在 <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a> 下。这是你可以检查其他人分享的工具的地方。',Fe,L,St=`然后你可以使用 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.load_tool">load_tool()</a> 加载工具或使用 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.Tool.from_hub">from_hub()</a> 创建它，并将其传递给 agent 中的 <code>tools</code> 参数。
由于运行工具意味着运行自定义代码，你需要确保你信任该仓库，因此我们需要传递 <code>trust_remote_code=True</code> 来从 Hub 加载工具。`,qe,F,Ye,q,Xe,Y,Nt='你可以使用 <a href="/docs/smolagents/v1.21.2/zh/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> 方法直接从 Hub 导入一个 Space 作为工具！',Pe,X,zt='你只需要提供 Hub 上 Space 的 id、它的名称和一个帮助你的 agent 理解工具功能的描述。在底层，这将使用 <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> 库来调用 Space。',De,P,Lt='例如，让我们从 Hub 导入 <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space 并使用它生成一张图片。',Ke,D,Oe,K,Ft="瞧，这是你的图片！🏖️",et,Ue,qt,tt,O,Yt="然后你可以像使用任何其他工具一样使用这个工具。例如，让我们改进提示 <code>A rabbit wearing a space suit</code> 并生成它的图片。",lt,ee,st,te,nt,we,Xt,ot,le,Pt="这得有多酷？🤩",at,se,it,ne,Dt=`我们喜欢 Langchain，并认为它有一套非常吸引人的工具。
要从 LangChain 导入工具，请使用 <code>from_langchain()</code> 方法。`,pt,oe,Kt=`以下是如何使用它来重现介绍中的搜索结果，使用 LangChain 的 web 搜索工具。
这个工具需要 <code>pip install langchain google-search-results -q</code> 才能正常工作。`,Mt,ae,mt,ie,ut,pe,Ot="你可以通过添加或替换工具来管理 agent 的工具箱。",dt,Me,el="让我们将 <code>model_download_tool</code> 添加到一个仅使用默认工具箱初始化的现有 agent 中。",bt,me,rt,ue,tl="现在我们可以利用新工具：",ct,de,ft,w,ht,be,yt,re,ll=`你可以通过使用 ToolCollection 对象来利用工具集合，使用你想要使用的集合的 slug。
然后将它们作为列表传递给 agent 初始化，并开始使用它们！`,gt,ce,Ut,fe,sl="为了加快启动速度，工具仅在 agent 调用时加载。",wt,he,Tt,Te,Jt;return T=new ye({props:{title:"工具",local:"工具",headingTag:"h1"}}),J=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/tools.ipynb"}]}}),U=new pl({props:{warning:!1,$$slots:{default:[yl]},$$scope:{ctx:ge}}}),v=new ye({props:{title:"什么是工具，如何构建一个工具？",local:"什么是工具如何构建一个工具",headingTag:"h3"}}),G=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),R=new ye({props:{title:"将你的工具分享到 Hub",local:"将你的工具分享到-hub",headingTag:"h3"}}),A=new y({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),F=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),q=new ye({props:{title:"将 Space 导入为工具",local:"将-space-导入为工具",headingTag:"h3"}}),D=new y({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ee=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),te=new y({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),se=new ye({props:{title:"使用 LangChain 工具",local:"使用-langchain-工具",headingTag:"h3"}}),ae=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),ie=new ye({props:{title:"管理你的 agent 工具箱",local:"管理你的-agent-工具箱",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),de=new y({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),w=new pl({props:{warning:!1,$$slots:{default:[gl]},$$scope:{ctx:ge}}}),be=new ye({props:{title:"使用工具集合",local:"使用工具集合",headingTag:"h3"}}),ce=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),he=new hl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/tutorials/tools.md"}}),{c(){M=a("meta"),h=n(),f=a("p"),g=n(),m(T.$$.fragment),Je=n(),m(J.$$.fragment),je=n(),j=a("p"),j.textContent=Ct,Ce=n(),m(U.$$.fragment),ve=n(),C=a("ul"),C.innerHTML=vt,$e=n(),m(v.$$.fragment),_e=n(),$=a("p"),$.textContent=$t,Ie=n(),_=a("p"),_.textContent=_t,Be=n(),I=a("p"),I.textContent=It,Ze=n(),B=a("p"),B.textContent=Bt,Ge=n(),Z=a("p"),Z.textContent=Zt,He=n(),m(G.$$.fragment),Ee=n(),H=a("p"),H.innerHTML=Gt,xe=n(),E=a("ul"),E.innerHTML=Ht,We=n(),x=a("p"),x.textContent=Et,ke=n(),W=a("p"),W.innerHTML=xt,Re=n(),k=a("p"),k.innerHTML=Wt,Qe=n(),m(R.$$.fragment),Ae=n(),Q=a("p"),Q.innerHTML=kt,Ve=n(),m(A.$$.fragment),Se=n(),V=a("p"),V.textContent=Rt,Ne=n(),S=a("ul"),S.innerHTML=Qt,ze=n(),N=a("p"),N.innerHTML=At,Le=n(),z=a("p"),z.innerHTML=Vt,Fe=n(),L=a("p"),L.innerHTML=St,qe=n(),m(F.$$.fragment),Ye=n(),m(q.$$.fragment),Xe=n(),Y=a("p"),Y.innerHTML=Nt,Pe=n(),X=a("p"),X.innerHTML=zt,De=n(),P=a("p"),P.innerHTML=Lt,Ke=n(),m(D.$$.fragment),Oe=n(),K=a("p"),K.textContent=Ft,et=n(),Ue=a("img"),tt=n(),O=a("p"),O.innerHTML=Yt,lt=n(),m(ee.$$.fragment),st=n(),m(te.$$.fragment),nt=n(),we=a("img"),ot=n(),le=a("p"),le.textContent=Pt,at=n(),m(se.$$.fragment),it=n(),ne=a("p"),ne.innerHTML=Dt,pt=n(),oe=a("p"),oe.innerHTML=Kt,Mt=n(),m(ae.$$.fragment),mt=n(),m(ie.$$.fragment),ut=n(),pe=a("p"),pe.textContent=Ot,dt=n(),Me=a("p"),Me.innerHTML=el,bt=n(),m(me.$$.fragment),rt=n(),ue=a("p"),ue.textContent=tl,ct=n(),m(de.$$.fragment),ft=n(),m(w.$$.fragment),ht=n(),m(be.$$.fragment),yt=n(),re=a("p"),re.textContent=ll,gt=n(),m(ce.$$.fragment),Ut=n(),fe=a("p"),fe.textContent=sl,wt=n(),m(he.$$.fragment),Tt=n(),Te=a("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),h=o(e),f=i(e,"P",{}),il(f).forEach(l),g=o(e),u(T.$$.fragment,e),Je=o(e),u(J.$$.fragment,e),je=o(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-143y1x4"&&(j.textContent=Ct),Ce=o(e),u(U.$$.fragment,e),ve=o(e),C=i(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-1ob3z02"&&(C.innerHTML=vt),$e=o(e),u(v.$$.fragment,e),_e=o(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-tzzqok"&&($.textContent=$t),Ie=o(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-mmees0"&&(_.textContent=_t),Be=o(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-8tjsnw"&&(I.textContent=It),Ze=o(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1marvpp"&&(B.textContent=Bt),Ge=o(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1ezxif7"&&(Z.textContent=Zt),He=o(e),u(G.$$.fragment,e),Ee=o(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-16vk7ji"&&(H.innerHTML=Gt),xe=o(e),E=i(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-114q23d"&&(E.innerHTML=Ht),We=o(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-150sce8"&&(x.textContent=Et),ke=o(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-13s674c"&&(W.innerHTML=xt),Re=o(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-eu2a8u"&&(k.innerHTML=Wt),Qe=o(e),u(R.$$.fragment,e),Ae=o(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-v5zirk"&&(Q.innerHTML=kt),Ve=o(e),u(A.$$.fragment,e),Se=o(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-f7adnf"&&(V.textContent=Rt),Ne=o(e),S=i(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-e6qjd7"&&(S.innerHTML=Qt),ze=o(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-ek1m24"&&(N.innerHTML=At),Le=o(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-15ghlir"&&(z.innerHTML=Vt),Fe=o(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-13gs73n"&&(L.innerHTML=St),qe=o(e),u(F.$$.fragment,e),Ye=o(e),u(q.$$.fragment,e),Xe=o(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-4ey9z1"&&(Y.innerHTML=Nt),Pe=o(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-4qew2a"&&(X.innerHTML=zt),De=o(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1tvwij"&&(P.innerHTML=Lt),Ke=o(e),u(D.$$.fragment,e),Oe=o(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1ubl722"&&(K.textContent=Ft),et=o(e),Ue=i(e,"IMG",{src:!0}),tt=o(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-ecwb7g"&&(O.innerHTML=Yt),lt=o(e),u(ee.$$.fragment,e),st=o(e),u(te.$$.fragment,e),nt=o(e),we=i(e,"IMG",{src:!0}),ot=o(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-frli2c"&&(le.textContent=Pt),at=o(e),u(se.$$.fragment,e),it=o(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-m1ii5p"&&(ne.innerHTML=Dt),pt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-17sjd0f"&&(oe.innerHTML=Kt),Mt=o(e),u(ae.$$.fragment,e),mt=o(e),u(ie.$$.fragment,e),ut=o(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-p6yc33"&&(pe.textContent=Ot),dt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-u6gh5x"&&(Me.innerHTML=el),bt=o(e),u(me.$$.fragment,e),rt=o(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1dm2bi"&&(ue.textContent=tl),ct=o(e),u(de.$$.fragment,e),ft=o(e),u(w.$$.fragment,e),ht=o(e),u(be.$$.fragment,e),yt=o(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-17n2ifn"&&(re.textContent=ll),gt=o(e),u(ce.$$.fragment,e),Ut=o(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-nvusln"&&(fe.textContent=sl),wt=o(e),u(he.$$.fragment,e),Tt=o(e),Te=i(e,"P",{}),il(Te).forEach(l),this.h()},h(){jt(M,"name","hf:doc:metadata"),jt(M,"content",wl),al(Ue.src,qt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||jt(Ue,"src",qt),al(we.src,Xt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||jt(we,"src",Xt)},m(e,t){cl(document.head,M),s(e,h,t),s(e,f,t),s(e,g,t),d(T,e,t),s(e,Je,t),d(J,e,t),s(e,je,t),s(e,j,t),s(e,Ce,t),d(U,e,t),s(e,ve,t),s(e,C,t),s(e,$e,t),d(v,e,t),s(e,_e,t),s(e,$,t),s(e,Ie,t),s(e,_,t),s(e,Be,t),s(e,I,t),s(e,Ze,t),s(e,B,t),s(e,Ge,t),s(e,Z,t),s(e,He,t),d(G,e,t),s(e,Ee,t),s(e,H,t),s(e,xe,t),s(e,E,t),s(e,We,t),s(e,x,t),s(e,ke,t),s(e,W,t),s(e,Re,t),s(e,k,t),s(e,Qe,t),d(R,e,t),s(e,Ae,t),s(e,Q,t),s(e,Ve,t),d(A,e,t),s(e,Se,t),s(e,V,t),s(e,Ne,t),s(e,S,t),s(e,ze,t),s(e,N,t),s(e,Le,t),s(e,z,t),s(e,Fe,t),s(e,L,t),s(e,qe,t),d(F,e,t),s(e,Ye,t),d(q,e,t),s(e,Xe,t),s(e,Y,t),s(e,Pe,t),s(e,X,t),s(e,De,t),s(e,P,t),s(e,Ke,t),d(D,e,t),s(e,Oe,t),s(e,K,t),s(e,et,t),s(e,Ue,t),s(e,tt,t),s(e,O,t),s(e,lt,t),d(ee,e,t),s(e,st,t),d(te,e,t),s(e,nt,t),s(e,we,t),s(e,ot,t),s(e,le,t),s(e,at,t),d(se,e,t),s(e,it,t),s(e,ne,t),s(e,pt,t),s(e,oe,t),s(e,Mt,t),d(ae,e,t),s(e,mt,t),d(ie,e,t),s(e,ut,t),s(e,pe,t),s(e,dt,t),s(e,Me,t),s(e,bt,t),d(me,e,t),s(e,rt,t),s(e,ue,t),s(e,ct,t),d(de,e,t),s(e,ft,t),d(w,e,t),s(e,ht,t),d(be,e,t),s(e,yt,t),s(e,re,t),s(e,gt,t),d(ce,e,t),s(e,Ut,t),s(e,fe,t),s(e,wt,t),d(he,e,t),s(e,Tt,t),s(e,Te,t),Jt=!0},p(e,[t]){const nl={};t&2&&(nl.$$scope={dirty:t,ctx:e}),U.$set(nl);const ol={};t&2&&(ol.$$scope={dirty:t,ctx:e}),w.$set(ol)},i(e){Jt||(b(T.$$.fragment,e),b(J.$$.fragment,e),b(U.$$.fragment,e),b(v.$$.fragment,e),b(G.$$.fragment,e),b(R.$$.fragment,e),b(A.$$.fragment,e),b(F.$$.fragment,e),b(q.$$.fragment,e),b(D.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(ie.$$.fragment,e),b(me.$$.fragment,e),b(de.$$.fragment,e),b(w.$$.fragment,e),b(be.$$.fragment,e),b(ce.$$.fragment,e),b(he.$$.fragment,e),Jt=!0)},o(e){r(T.$$.fragment,e),r(J.$$.fragment,e),r(U.$$.fragment,e),r(v.$$.fragment,e),r(G.$$.fragment,e),r(R.$$.fragment,e),r(A.$$.fragment,e),r(F.$$.fragment,e),r(q.$$.fragment,e),r(D.$$.fragment,e),r(ee.$$.fragment,e),r(te.$$.fragment,e),r(se.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(me.$$.fragment,e),r(de.$$.fragment,e),r(w.$$.fragment,e),r(be.$$.fragment,e),r(ce.$$.fragment,e),r(he.$$.fragment,e),Jt=!1},d(e){e&&(l(h),l(f),l(g),l(Je),l(je),l(j),l(Ce),l(ve),l(C),l($e),l(_e),l($),l(Ie),l(_),l(Be),l(I),l(Ze),l(B),l(Ge),l(Z),l(He),l(Ee),l(H),l(xe),l(E),l(We),l(x),l(ke),l(W),l(Re),l(k),l(Qe),l(Ae),l(Q),l(Ve),l(Se),l(V),l(Ne),l(S),l(ze),l(N),l(Le),l(z),l(Fe),l(L),l(qe),l(Ye),l(Xe),l(Y),l(Pe),l(X),l(De),l(P),l(Ke),l(Oe),l(K),l(et),l(Ue),l(tt),l(O),l(lt),l(st),l(nt),l(we),l(ot),l(le),l(at),l(it),l(ne),l(pt),l(oe),l(Mt),l(mt),l(ut),l(pe),l(dt),l(Me),l(bt),l(rt),l(ue),l(ct),l(ft),l(ht),l(yt),l(re),l(gt),l(Ut),l(fe),l(wt),l(Tt),l(Te)),l(M),c(T,e),c(J,e),c(U,e),c(v,e),c(G,e),c(R,e),c(A,e),c(F,e),c(q,e),c(D,e),c(ee,e),c(te,e),c(se,e),c(ae,e),c(ie,e),c(me,e),c(de,e),c(w,e),c(be,e),c(ce,e),c(he,e)}}}const wl='{"title":"工具","local":"工具","sections":[{"title":"什么是工具，如何构建一个工具？","local":"什么是工具如何构建一个工具","sections":[],"depth":3},{"title":"将你的工具分享到 Hub","local":"将你的工具分享到-hub","sections":[],"depth":3},{"title":"将 Space 导入为工具","local":"将-space-导入为工具","sections":[],"depth":3},{"title":"使用 LangChain 工具","local":"使用-langchain-工具","sections":[],"depth":3},{"title":"管理你的 agent 工具箱","local":"管理你的-agent-工具箱","sections":[],"depth":3},{"title":"使用工具集合","local":"使用工具集合","sections":[],"depth":3}],"depth":1}';function Tl(ge){return ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends dl{constructor(M){super(),bl(this,M,Tl,Ul,ml,{})}}export{Il as component};
