import{s as wa,n as Ua,o as Ca}from"../chunks/scheduler.85c25b89.js";import{S as $a,i as xa,g as i,s as n,r as p,A as Oa,h as s,f as t,c as o,j as v,u as _,x as m,k as b,y as l,a as r,v as g,d as u,t as h,w as f}from"../chunks/index.c142fe32.js";import{D as T}from"../chunks/Docstring.d3e0bcd1.js";import{C as Qt}from"../chunks/CodeBlock.a5e95a57.js";import{H as ue,E as Ja}from"../chunks/EditOnGithub.a592e7aa.js";function ja(St){let C,Le,Ke,qe,N,De,A,Zt=`TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for aligning language models with binary feedback data (e.g., upvote/downvote), as described in the <a href="https://huggingface.co/papers/2402.01306" rel="nofollow">paper</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.
For a full example have a look at  <code>examples/scripts/kto.py</code>.`,He,F,Rt=`Depending on how good your base model is, you may or may not need to do SFT before KTO.
This is different from standard RLHF and DPO, which always require SFT.`,Pe,K,ze,E,Xt="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",We,L,Gt="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",Be,q,Vt="for example:",Qe,D,Se,H,Yt=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays. It is required that the dataset contains at least one desirable and one undesirable completion.`,Ze,P,Re,z,ea="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Xe,W,Ge,B,ta="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",Ve,Q,aa="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Ye,S,na=`The <code>desirable_weight</code> and <code>undesirable_weight</code> refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (<code>desirable_weight</code> <em>number of positives) to (<code>undesirable_weight</code></em> number of negatives) is in the range 1:1 to 4:3.`,et,Z,tt,R,oa="After this one can then call:",at,X,nt,G,ot,V,la=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,lt,Y,ra=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,rt,ee,it,d,te,Tt,he,ia="Initialize KTOTrainer.",Mt,$,ae,yt,fe,sa="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",wt,y,ne,Ut,ve,da=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Ct,be,ma="Works both with or without labels.",$t,x,oe,xt,Te,ca="Compute the log probabilities of the given labels under the given logits.",Ot,O,le,Jt,Me,pa="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",jt,J,re,It,ye,_a="Generate samples from the model and reference model for the given batch of inputs.",kt,w,ie,Nt,we,ga="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",At,Ue,ua="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Ft,U,se,Kt,Ce,ha="Returns the training <code>~torch.utils.data.DataLoader</code>.",Et,$e,fa="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Lt,j,de,qt,xe,va="Compute the KTO loss for a batch of policy and reference model log probabilities.",Dt,I,me,Ht,Oe,ba="Log <code>logs</code> on the various objects watching training, including stored metrics.",Pt,k,ce,zt,Je,Ta="Context manager for handling null reference model (that is, peft adapter manipulation).",st,pe,dt,M,_e,Wt,je,Ma='KTOConfig collects all training arguments related to the <a href="/docs/trl/main/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> class.',Bt,Ie,ya=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,mt,ge,ct,Ee,pt;return N=new ue({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),K=new ue({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),D=new Qt({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),P=new ue({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),W=new ue({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),Z=new Qt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMHVuZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSklMEElMEFrdG9fdHJhaW5lciUyMCUzRCUyMEtUT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByZWZfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
    desirable_weight=<span class="hljs-number">1.0</span>,
    undesirable_weight=<span class="hljs-number">1.0</span>,
)

kto_trainer = KTOTrainer(
    model,
    ref_model,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),X=new Qt({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),G=new ue({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),ee=new ue({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),te=new T({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L256"}}),ae=new T({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L850"}}),ne=new T({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1294"}}),oe=new T({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L922",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),le=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1091"}}),re=new T({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1208"}}),ie=new T({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L797"}}),se=new T({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L756"}}),de=new T({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1038",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),me=new T({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1350"}}),ce=new T({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L744"}}),pe=new ue({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),_e=new T({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_config.py#L20"}}),ge=new Ja({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/kto_trainer.mdx"}}),{c(){C=i("meta"),Le=n(),Ke=i("p"),qe=n(),p(N.$$.fragment),De=n(),A=i("p"),A.innerHTML=Zt,He=n(),F=i("p"),F.textContent=Rt,Pe=n(),p(K.$$.fragment),ze=n(),E=i("p"),E.textContent=Xt,We=n(),L=i("ul"),L.innerHTML=Gt,Be=n(),q=i("p"),q.textContent=Vt,Qe=n(),p(D.$$.fragment),Se=n(),H=i("p"),H.innerHTML=Yt,Ze=n(),p(P.$$.fragment),Re=n(),z=i("p"),z.innerHTML=ea,Xe=n(),p(W.$$.fragment),Ge=n(),B=i("p"),B.innerHTML=ta,Ve=n(),Q=i("p"),Q.innerHTML=aa,Ye=n(),S=i("p"),S.innerHTML=na,et=n(),p(Z.$$.fragment),tt=n(),R=i("p"),R.textContent=oa,at=n(),p(X.$$.fragment),nt=n(),p(G.$$.fragment),ot=n(),V=i("p"),V.innerHTML=la,lt=n(),Y=i("p"),Y.innerHTML=ra,rt=n(),p(ee.$$.fragment),it=n(),d=i("div"),p(te.$$.fragment),Tt=n(),he=i("p"),he.textContent=ia,Mt=n(),$=i("div"),p(ae.$$.fragment),yt=n(),fe=i("p"),fe.textContent=sa,wt=n(),y=i("div"),p(ne.$$.fragment),Ut=n(),ve=i("p"),ve.innerHTML=da,Ct=n(),be=i("p"),be.textContent=ma,$t=n(),x=i("div"),p(oe.$$.fragment),xt=n(),Te=i("p"),Te.textContent=ca,Ot=n(),O=i("div"),p(le.$$.fragment),Jt=n(),Me=i("p"),Me.textContent=pa,jt=n(),J=i("div"),p(re.$$.fragment),It=n(),ye=i("p"),ye.textContent=_a,kt=n(),w=i("div"),p(ie.$$.fragment),Nt=n(),we=i("p"),we.innerHTML=ga,At=n(),Ue=i("p"),Ue.innerHTML=ua,Ft=n(),U=i("div"),p(se.$$.fragment),Kt=n(),Ce=i("p"),Ce.innerHTML=ha,Et=n(),$e=i("p"),$e.innerHTML=fa,Lt=n(),j=i("div"),p(de.$$.fragment),qt=n(),xe=i("p"),xe.textContent=va,Dt=n(),I=i("div"),p(me.$$.fragment),Ht=n(),Oe=i("p"),Oe.innerHTML=ba,Pt=n(),k=i("div"),p(ce.$$.fragment),zt=n(),Je=i("p"),Je.textContent=Ta,st=n(),p(pe.$$.fragment),dt=n(),M=i("div"),p(_e.$$.fragment),Wt=n(),je=i("p"),je.innerHTML=Ma,Bt=n(),Ie=i("p"),Ie.innerHTML=ya,mt=n(),p(ge.$$.fragment),ct=n(),Ee=i("p"),this.h()},l(e){const a=Oa("svelte-u9bgzb",document.head);C=s(a,"META",{name:!0,content:!0}),a.forEach(t),Le=o(e),Ke=s(e,"P",{}),v(Ke).forEach(t),qe=o(e),_(N.$$.fragment,e),De=o(e),A=s(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1itwvry"&&(A.innerHTML=Zt),He=o(e),F=s(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-z1e9ri"&&(F.textContent=Rt),Pe=o(e),_(K.$$.fragment,e),ze=o(e),E=s(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1792bye"&&(E.textContent=Xt),We=o(e),L=s(e,"UL",{"data-svelte-h":!0}),m(L)!=="svelte-1bk1n3o"&&(L.innerHTML=Gt),Be=o(e),q=s(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1gl9mvz"&&(q.textContent=Vt),Qe=o(e),_(D.$$.fragment,e),Se=o(e),H=s(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1yefqq4"&&(H.innerHTML=Yt),Ze=o(e),_(P.$$.fragment,e),Re=o(e),z=s(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-znx0uh"&&(z.innerHTML=ea),Xe=o(e),_(W.$$.fragment,e),Ge=o(e),B=s(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-6k9bp8"&&(B.innerHTML=ta),Ve=o(e),Q=s(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1eil2tw"&&(Q.innerHTML=aa),Ye=o(e),S=s(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-ad0vsu"&&(S.innerHTML=na),et=o(e),_(Z.$$.fragment,e),tt=o(e),R=s(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1lg6q1l"&&(R.textContent=oa),at=o(e),_(X.$$.fragment,e),nt=o(e),_(G.$$.fragment,e),ot=o(e),V=s(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-3kfva2"&&(V.innerHTML=la),lt=o(e),Y=s(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1c01yo3"&&(Y.innerHTML=ra),rt=o(e),_(ee.$$.fragment,e),it=o(e),d=s(e,"DIV",{class:!0});var c=v(d);_(te.$$.fragment,c),Tt=o(c),he=s(c,"P",{"data-svelte-h":!0}),m(he)!=="svelte-hyhzxp"&&(he.textContent=ia),Mt=o(c),$=s(c,"DIV",{class:!0});var _t=v($);_(ae.$$.fragment,_t),yt=o(_t),fe=s(_t,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-pt6g01"&&(fe.textContent=sa),_t.forEach(t),wt=o(c),y=s(c,"DIV",{class:!0});var ke=v(y);_(ne.$$.fragment,ke),Ut=o(ke),ve=s(ke,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-8qlty5"&&(ve.innerHTML=da),Ct=o(ke),be=s(ke,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1tyo99t"&&(be.textContent=ma),ke.forEach(t),$t=o(c),x=s(c,"DIV",{class:!0});var gt=v(x);_(oe.$$.fragment,gt),xt=o(gt),Te=s(gt,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-4nmimv"&&(Te.textContent=ca),gt.forEach(t),Ot=o(c),O=s(c,"DIV",{class:!0});var ut=v(O);_(le.$$.fragment,ut),Jt=o(ut),Me=s(ut,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-db7iek"&&(Me.textContent=pa),ut.forEach(t),jt=o(c),J=s(c,"DIV",{class:!0});var ht=v(J);_(re.$$.fragment,ht),It=o(ht),ye=s(ht,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-18uwvbi"&&(ye.textContent=_a),ht.forEach(t),kt=o(c),w=s(c,"DIV",{class:!0});var Ne=v(w);_(ie.$$.fragment,Ne),Nt=o(Ne),we=s(Ne,"P",{"data-svelte-h":!0}),m(we)!=="svelte-xesobz"&&(we.innerHTML=ga),At=o(Ne),Ue=s(Ne,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-qg43tm"&&(Ue.innerHTML=ua),Ne.forEach(t),Ft=o(c),U=s(c,"DIV",{class:!0});var Ae=v(U);_(se.$$.fragment,Ae),Kt=o(Ae),Ce=s(Ae,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-dkae9b"&&(Ce.innerHTML=ha),Et=o(Ae),$e=s(Ae,"P",{"data-svelte-h":!0}),m($e)!=="svelte-hmd5cw"&&($e.innerHTML=fa),Ae.forEach(t),Lt=o(c),j=s(c,"DIV",{class:!0});var ft=v(j);_(de.$$.fragment,ft),qt=o(ft),xe=s(ft,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-svckwe"&&(xe.textContent=va),ft.forEach(t),Dt=o(c),I=s(c,"DIV",{class:!0});var vt=v(I);_(me.$$.fragment,vt),Ht=o(vt),Oe=s(vt,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-nqksfz"&&(Oe.innerHTML=ba),vt.forEach(t),Pt=o(c),k=s(c,"DIV",{class:!0});var bt=v(k);_(ce.$$.fragment,bt),zt=o(bt),Je=s(bt,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-17kjsy4"&&(Je.textContent=Ta),bt.forEach(t),c.forEach(t),st=o(e),_(pe.$$.fragment,e),dt=o(e),M=s(e,"DIV",{class:!0});var Fe=v(M);_(_e.$$.fragment,Fe),Wt=o(Fe),je=s(Fe,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1i1r5fd"&&(je.innerHTML=Ma),Bt=o(Fe),Ie=s(Fe,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1xl7jqc"&&(Ie.innerHTML=ya),Fe.forEach(t),mt=o(e),_(ge.$$.fragment,e),ct=o(e),Ee=s(e,"P",{}),v(Ee).forEach(t),this.h()},h(){b(C,"name","hf:doc:metadata"),b(C,"content",Ia),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){l(document.head,C),r(e,Le,a),r(e,Ke,a),r(e,qe,a),g(N,e,a),r(e,De,a),r(e,A,a),r(e,He,a),r(e,F,a),r(e,Pe,a),g(K,e,a),r(e,ze,a),r(e,E,a),r(e,We,a),r(e,L,a),r(e,Be,a),r(e,q,a),r(e,Qe,a),g(D,e,a),r(e,Se,a),r(e,H,a),r(e,Ze,a),g(P,e,a),r(e,Re,a),r(e,z,a),r(e,Xe,a),g(W,e,a),r(e,Ge,a),r(e,B,a),r(e,Ve,a),r(e,Q,a),r(e,Ye,a),r(e,S,a),r(e,et,a),g(Z,e,a),r(e,tt,a),r(e,R,a),r(e,at,a),g(X,e,a),r(e,nt,a),g(G,e,a),r(e,ot,a),r(e,V,a),r(e,lt,a),r(e,Y,a),r(e,rt,a),g(ee,e,a),r(e,it,a),r(e,d,a),g(te,d,null),l(d,Tt),l(d,he),l(d,Mt),l(d,$),g(ae,$,null),l($,yt),l($,fe),l(d,wt),l(d,y),g(ne,y,null),l(y,Ut),l(y,ve),l(y,Ct),l(y,be),l(d,$t),l(d,x),g(oe,x,null),l(x,xt),l(x,Te),l(d,Ot),l(d,O),g(le,O,null),l(O,Jt),l(O,Me),l(d,jt),l(d,J),g(re,J,null),l(J,It),l(J,ye),l(d,kt),l(d,w),g(ie,w,null),l(w,Nt),l(w,we),l(w,At),l(w,Ue),l(d,Ft),l(d,U),g(se,U,null),l(U,Kt),l(U,Ce),l(U,Et),l(U,$e),l(d,Lt),l(d,j),g(de,j,null),l(j,qt),l(j,xe),l(d,Dt),l(d,I),g(me,I,null),l(I,Ht),l(I,Oe),l(d,Pt),l(d,k),g(ce,k,null),l(k,zt),l(k,Je),r(e,st,a),g(pe,e,a),r(e,dt,a),r(e,M,a),g(_e,M,null),l(M,Wt),l(M,je),l(M,Bt),l(M,Ie),r(e,mt,a),g(ge,e,a),r(e,ct,a),r(e,Ee,a),pt=!0},p:Ua,i(e){pt||(u(N.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(P.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(_e.$$.fragment,e),u(ge.$$.fragment,e),pt=!0)},o(e){h(N.$$.fragment,e),h(K.$$.fragment,e),h(D.$$.fragment,e),h(P.$$.fragment,e),h(W.$$.fragment,e),h(Z.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(_e.$$.fragment,e),h(ge.$$.fragment,e),pt=!1},d(e){e&&(t(Le),t(Ke),t(qe),t(De),t(A),t(He),t(F),t(Pe),t(ze),t(E),t(We),t(L),t(Be),t(q),t(Qe),t(Se),t(H),t(Ze),t(Re),t(z),t(Xe),t(Ge),t(B),t(Ve),t(Q),t(Ye),t(S),t(et),t(tt),t(R),t(at),t(nt),t(ot),t(V),t(lt),t(Y),t(rt),t(it),t(d),t(st),t(dt),t(M),t(mt),t(ct),t(Ee)),t(C),f(N,e),f(K,e),f(D,e),f(P,e),f(W,e),f(Z,e),f(X,e),f(G,e),f(ee,e),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(ie),f(se),f(de),f(me),f(ce),f(pe,e),f(_e),f(ge,e)}}}const Ia='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function ka(St){return Ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class La extends $a{constructor(C){super(),xa(this,C,ka,ja,wa,{})}}export{La as component};
