import{s as Tl,n as yl,o as Jl}from"../chunks/scheduler.85c25b89.js";import{S as Il,i as wl,g as I,s as y,r as j,A as Cl,h as w,f as U,c as J,j as ll,u as e,x as C,k as Ul,y as jl,a as T,v as s,d as A,t as a,w as t}from"../chunks/index.c142fe32.js";import{C as $}from"../chunks/CodeBlock.a5e95a57.js";import{H as z,E as el}from"../chunks/EditOnGithub.a592e7aa.js";function sl(GM){let n,K,P,MM,i,lM,o,NM='TRL supports training LLMs with online DPO (<a href="https://huggingface.co/papers/2402.04792" rel="nofollow">Guo et al., 2024</a>) with a reward model (RM). The idea of online DPO is to generate completions based on prompts and either have an RM or a LLM judge to rank the responses. Then the model is updated with the ranked responses using the DPO loss.',UM,p,DM='While <a href="https://huggingface.co/papers/2402.04792" rel="nofollow">Guo et al. (2024)</a> used a LLM judge, in this implementation we just used a RM.',TM,d,yM,c,fM="The basic API looks as follows:",JM,r,IM,m,EM="To just run the online DPO script to make sure the trainer can run, you can run the following command to train an online DPO model with a dummy reward model.",wM,h,CM,O,jM,k,WM='The logged metrics are as follows. Here is an example <a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">tracked run at Weights and Biases</a>',eM,R,XM="<li><code>eps</code>: Tracks the number of episodes per second.</li> <li><code>objective/kl</code>: The mean Kullback-Leibler (KL) divergence between the current model and reference model.</li> <li><code>objective/entropy</code>: The mean entropy of the model, indicating the randomness of the actions chosen by the model.</li> <li><code>objective/non_score_reward</code>: The mean reward from non-score-related sources, basically <code>beta * kl.sum(1)</code>, where <code>beta</code> is the KL penalty coefficient and <code>kl</code> is the per-token KL divergence.</li> <li><code>objective/rlhf_reward</code>: The mean RLHF reward, which is <code>score - non_score_reward</code>.</li> <li><code>objective/scores</code>: The mean scores returned by the reward model / environment.</li> <li><code>objective/scores_margin</code>: The mean score margin (according to the external reward model) between the chosen and rejected completions.</li> <li><code>rewards/accuracies</code>: The accuracies of the online DPO’s implicit reward model.</li> <li><code>rewards/chosen</code>: The mean reward (according to online DPO’s implicit reward model)of the chosen completions.</li> <li><code>rewards/rejected</code>: The mean reward (according to online DPO’s implicit reward model) of the rejected completions.</li> <li><code>rewards/margins</code>: The mean reward margin (according to online DPO’s implicit reward model) between the chosen and rejected completions.</li> <li><code>logps/chosen</code>: The mean log probabilities of the chosen completions.</li> <li><code>logps/rejected</code>: The mean log probabilities of the rejected completions.</li> <li><code>val/num_eos_tokens</code>: The number of end-of-sequence (EOS) tokens generated, which can indicate the number of complete responses.</li> <li><code>lr</code>: lr: The current learning rate used by the optimizer.</li> <li><code>episode</code>: episode: The current global step or episode count in the training process.</li>",sM,b,AM,Q,xM="<li>Debugging TIP: <code>objective/rlhf_reward</code>: this is the ultimate objective of the RLHF training. If training works as intended, this metric should keep going up.</li> <li>Memory TIP: If you are running out of memory, you can try to reduce the <code>--per_device_train_batch_size</code> or increase the <code>--gradient_accumulation_steps</code> to reduce the memory footprint.</li> <li>Memory TIP: If you have multiple GPUs, you can also run training with DeepSpeed stage 3 to reduce the memory footprint <code>accelerate launch --config_file examples/accelerate_configs/deepspeed_zero3.yaml</code>.</li> <li>Usage TIP: We recommend to use the “EOS trick” via <code>--non_eos_penalty --stop_token eos</code>, which replaces the score of completions that do not end with an EOS token with a static scalar penalty <code>--penalty_reward_value</code>. This can help the model learn to generate more coherent completions.</li>",aM,V,tM,u,_M='To help you understand what your model is doing, we periodically log some sample completions from the model. Here is an example of a completion. In an example <a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">tracked run at Weights and Biases</a>, it looks like the following, allowing you to see the model’s response at different stages of training. By default we generate <code>--num_sample_generations 10</code> during training, but you can customize the number of generations.',nM,g,SM='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/ppov2_completions.gif"/>',iM,B,vM="In the logs the sampled generations look like",oM,F,pM,Z,dM,G,HM='Many online implementation details are borrowed from the PPOv2Trainer, which is itself based on the <a href="https://huggingface.co/papers/2403.17031" rel="nofollow">The N+ Implementation Details of RLHF with PPO: A Case Study on TL;DR Summarization</a>. Here are some additional implementation details:',cM,N,YM="<li>When we turn on the EOS trick (i.e., replacing the score of completions that do not end with an EOS token with a scalar penalty score like <code>-1</code>) via <code>--non_eos_penalty --stop_token eos</code>, it’s possible that the chosen and rejected completions have the same score. In this case, we will naively select the completion with the lower index and the chosen completion.</li>",rM,D,mM,f,LM='To validate the online DPO implementation works, we ran experiments on the 1B and 6.9B models. Here are the commands we used to run the experiments. We take the SFT / RM models directly from <a href="https://huggingface.co/papers/2403.17031" rel="nofollow">The N+ Implementation Details of RLHF with PPO: A Case Study on TL;DR Summarization</a>.',hM,E,OM,W,zM="Checkpoints and experiment tracking are available at:",kM,X,$M='<li><a href="https://huggingface.co/vwxyzjn/ppo_tldr" rel="nofollow">🤗 Model checkpoint</a></li> <li><a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">🐝 Tracked experiment</a></li>',RM,x,PM=`To evaluate, we use <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a> to load the checkpoints and GPT-4o mini as a judge model to evaluate the generated TL;DR against the reference TL;DR.
For more information on how to use judges, see <a href="judges">Judges</a>.`,bM,_,QM,S,qM="We can then plot the RLHF scaling chart.",VM,v,uM,H,KM='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/online_dpo_scaling.png"/>',gM,Y,Ml="The online DPO checkpoint gets increasingly more win rate as we scale up the model sizes. This is a good sign that the online DPO implementation is working as intended.",BM,L,FM,q,ZM;return i=new z({props:{title:"Online DPO Trainer",local:"online-dpo-trainer",headingTag:"h1"}}),d=new z({props:{title:"Get started",local:"get-started",headingTag:"h2"}}),r=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> OnlineDPOConfig, OnlineDPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoModelForCausalLM,
    AutoModelForSequenceClassification,
    AutoTokenizer,
)
NUM_DUMMY_SAMPLES = <span class="hljs-number">100</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)
tok.add_special_tokens({<span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;[PAD]&quot;</span>})
<span class="hljs-comment"># The model to optimise</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)
ref_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>)
<span class="hljs-comment"># The model to score completions with. In practice, you will need a fine-tuned reward model. See Reward Bench for some good ones: https://huggingface.co/spaces/allenai/reward-bench</span>
reward_model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM-135M-Instruct&quot;</span>, num_labels=<span class="hljs-number">1</span>)
train_dataset = Dataset.from_dict(
    {<span class="hljs-string">&quot;input_ids&quot;</span>: [tok.encode(<span class="hljs-string">&quot;Q: Hi how are you? A:&quot;</span>)] * NUM_DUMMY_SAMPLES})
eval_dataset = Dataset.from_dict(
    {<span class="hljs-string">&quot;input_ids&quot;</span>: [tok.encode(<span class="hljs-string">&quot;Q: What do you like to eat A:&quot;</span>)] * NUM_DUMMY_SAMPLES})
trainer = OnlineDPOTrainer(
    OnlineDPOConfig(
        output_dir=<span class="hljs-string">&quot;online-dpo-model&quot;</span>,
    ),
    model=model,
    ref_model=ref_model,
    reward_model=reward_model,
    tokenizer=tok,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)
trainer.train()`,wrap:!1}}),h=new $({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGb25saW5lX2Rwby5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWludGVybmFsLXRlc3RpbmclMkZ0bGRyLXByZWZlcmVuY2Utc2Z0LXRybC1zdHlsZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDNlLTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBtb2RlbHMlMkZtaW5pbWFsJTJGb25saW5lX2RwbyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwNjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRvdGFsX2VwaXNvZGVzJTIwMzAwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMEVsZXV0aGVyQUklMkZweXRoaWEtMTRtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zZnRfbW9kZWxfcGF0aCUyMEVsZXV0aGVyQUklMkZweXRoaWEtMTRtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXdhcmRfbW9kZWxfcGF0aCUyMEVsZXV0aGVyQUklMkZweXRoaWEtMTRtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ub25fZW9zX3BlbmFsdHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXN0b3BfdG9rZW4lMjBlb3MlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlc3BvbnNlX2xlbmd0aCUyMDUzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zYW5pdHlfY2hlY2s=",highlighted:`python examples/scripts/online_dpo.py \\
    --dataset_name trl-internal-testing/tldr-preference-sft-trl-style \\
    --learning_rate 3e-6 \\
    --output_dir models/minimal/online_dpo \\
    --per_device_train_batch_size 1 \\
    --gradient_accumulation_steps 64 \\
    --total_episodes 30000 \\
    --model_name_or_path EleutherAI/pythia-14m \\
    --sft_model_path EleutherAI/pythia-14m \\
    --reward_model_path EleutherAI/pythia-14m \\
    --non_eos_penalty \\
    --stop_token eos \\
    --response_length 53 \\
    --sanity_check`,wrap:!1}}),O=new z({props:{title:"Explanation of the logged metrics",local:"explanation-of-the-logged-metrics",headingTag:"h2"}}),b=new z({props:{title:"Cookbook",local:"cookbook",headingTag:"h2"}}),V=new z({props:{title:"What is my model doing exactly?",local:"what-is-my-model-doing-exactly",headingTag:"h2"}}),F=new $({props:{code:"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",highlighted:`┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━┓
┃ query                           ┃ model response                  ┃ score    ┃
┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━┩
│  SUBREDDIT: r/AskReddit         │  I&#x27;m <span class="hljs-keyword">in</span> love <span class="hljs-keyword">with</span> a friend, <span class="hljs-keyword">and</span> │ <span class="hljs-number">3.921875</span> │
│                                 │ I don&#x27;t know how <span class="hljs-keyword">to</span> <span class="hljs-keyword">get</span> rid <span class="hljs-keyword">of</span>  │          │
│ TITLE: How do you <span class="hljs-keyword">get</span> someone   │ those feelings. I&#x27;m             │          │
│ <span class="hljs-keyword">out of</span> your head?               │ desperate.&lt;|endoftext|&gt;[PAD][P… │          │
│                                 │                                 │          │
│ POST: Hi,                       │                                 │          │
│ I&#x27;m <span class="hljs-number">22</span>, <span class="hljs-keyword">and</span> I have been <span class="hljs-keyword">with</span> <span class="hljs-keyword">my</span> │                                 │          │
│ girlfriend <span class="hljs-keyword">for</span> <span class="hljs-number">5</span> years now. We  │                                 │          │
│ recently moved together. We&#x27;ve  │                                 │          │
│ always loved each other         │                                 │          │
│ intensely.                      │                                 │          │
│                                 │                                 │          │
│ Problem, I recently started <span class="hljs-keyword">to</span>  │                                 │          │
│ have feelings <span class="hljs-keyword">for</span> an other      │                                 │          │
│ person (a friend). This person  │                                 │          │
│ has had a boyfriend <span class="hljs-keyword">for</span> now <span class="hljs-number">3</span>   │                                 │          │
│ years, <span class="hljs-keyword">and</span> has absolutely no    │                                 │          │
│ ideas. Those feelings were so   │                                 │          │
│ strong, <span class="hljs-keyword">it</span> was hard <span class="hljs-keyword">to</span> hide     │                                 │          │
│ them. After <span class="hljs-number">2</span> months <span class="hljs-keyword">of</span> <span class="hljs-keyword">me</span>      │                                 │          │
│ being distant <span class="hljs-keyword">and</span> really sad,   │                                 │          │
│ <span class="hljs-keyword">my</span> girlfriend forced <span class="hljs-keyword">me</span> <span class="hljs-keyword">to</span> <span class="hljs-built_in">say</span>  │                                 │          │
│ what was bothering <span class="hljs-keyword">me</span>. I&#x27;m <span class="hljs-keyword">not</span>  │                                 │          │
│ a good liar, <span class="hljs-keyword">and</span> now she knows. │                                 │          │
│                                 │                                 │          │
│ We decided <span class="hljs-keyword">to</span> give us a week    │                                 │          │
│ alone, I went <span class="hljs-keyword">to</span> <span class="hljs-keyword">my</span> parents.    │                                 │          │
│                                 │                                 │          │
│ Now, I&#x27;m completely lost. I     │                                 │          │
│ keep <span class="hljs-keyword">on</span> thinking <span class="hljs-keyword">about</span> this     │                                 │          │
│ person, <span class="hljs-keyword">and</span> I hate <span class="hljs-keyword">that</span>. I      │                                 │          │
│ would like <span class="hljs-keyword">for</span> those feelings   │                                 │          │
│ <span class="hljs-keyword">to</span> go away, <span class="hljs-keyword">to</span> leave <span class="hljs-keyword">me</span> alone.  │                                 │          │
│ But I can&#x27;t.                    │                                 │          │
│                                 │                                 │          │
│ What do I do? It&#x27;s been <span class="hljs-number">3</span>       │                                 │          │
│ months now, <span class="hljs-keyword">and</span> I&#x27;m just        │                                 │          │
│ desperate.                      │                                 │          │
│                                 │                                 │          │
│ TL;DR:                          │                                 │          │
├─────────────────────────────────┼─────────────────────────────────┼──────────┤
│  SUBREDDIT: r/pettyrevenge      │  My mom woke <span class="hljs-keyword">me</span> up <span class="hljs-keyword">with</span> a loud  │ <span class="hljs-number">6.84375</span>  │
│                                 │ TV. I blasted Gangnam Style <span class="hljs-keyword">on</span>  │          │
│ TITLE: So, <span class="hljs-keyword">my</span> mom woke <span class="hljs-keyword">me</span> up    │ <span class="hljs-keyword">repeat</span>, <span class="hljs-keyword">with</span> <span class="hljs-keyword">the</span> bass cranked   │          │
│ <span class="hljs-keyword">with</span> a loud TV.                 │ up <span class="hljs-keyword">as</span> high <span class="hljs-keyword">as</span> <span class="hljs-keyword">it</span> could          │          │
│                                 │ go.&lt;|endoftext|&gt;[PAD][PAD][PAD… │          │
│ POST: She was <span class="hljs-keyword">in</span> her living     │                                 │          │
│ room, watching TV. This was <span class="hljs-keyword">at</span>  │                                 │          │
│ <span class="hljs-keyword">about</span> <span class="hljs-number">8</span>:<span class="hljs-number">30</span> <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> morning, <span class="hljs-keyword">and</span>  │                                 │          │
│ she was exercising. She turned  │                                 │          │
│ <span class="hljs-keyword">the</span> TV up extra loud <span class="hljs-keyword">to</span> hear <span class="hljs-keyword">it</span> │                                 │          │
│ <span class="hljs-keyword">over</span> her excercycle, <span class="hljs-keyword">and</span> woke   │                                 │          │
│ <span class="hljs-keyword">me</span> up. I went <span class="hljs-keyword">in</span> there asking   │                                 │          │
│ <span class="hljs-keyword">for</span> her <span class="hljs-keyword">to</span> turn <span class="hljs-keyword">it</span> down. She    │                                 │          │
│ said she didn&#x27;t have <span class="hljs-keyword">to</span>; I      │                                 │          │
│ explained <span class="hljs-keyword">that</span> I always used    │                                 │          │
│ headphones so she didn&#x27;t have   │                                 │          │
│ <span class="hljs-keyword">to</span> deal <span class="hljs-keyword">with</span> <span class="hljs-keyword">my</span> noise <span class="hljs-keyword">and</span> <span class="hljs-keyword">that</span>  │                                 │          │
│ she should give <span class="hljs-keyword">me</span> a little     │                                 │          │
│ more respect, <span class="hljs-keyword">given</span> <span class="hljs-keyword">that</span> I paid │                                 │          │
│ rent <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">time</span>.               │                                 │          │
│                                 │                                 │          │
│ She disagreed. I went <span class="hljs-keyword">back</span> <span class="hljs-keyword">to</span>   │                                 │          │
│ <span class="hljs-keyword">my</span> room, rather pissed off <span class="hljs-keyword">at</span>   │                                 │          │
│ <span class="hljs-keyword">the</span> lack <span class="hljs-keyword">of</span> equality. I had no  │                                 │          │
│ lock <span class="hljs-keyword">on</span> <span class="hljs-keyword">my</span> door; <span class="hljs-keyword">but</span> I had a    │                                 │          │
│ dresser right next <span class="hljs-keyword">to</span> <span class="hljs-keyword">it</span>, so I  │                                 │          │
│ pulled one <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> drawers out   │                                 │          │
│ enough so <span class="hljs-keyword">that</span> <span class="hljs-keyword">it</span> caused <span class="hljs-keyword">the</span>    │                                 │          │
│ door <span class="hljs-keyword">to</span> <span class="hljs-keyword">not</span> be openable. Then,  │                                 │          │
│ I turned <span class="hljs-keyword">my</span> speakers up really  │                                 │          │
│ loud <span class="hljs-keyword">and</span> blasted Gangnam Style  │                                 │          │
│ <span class="hljs-keyword">on</span> <span class="hljs-keyword">repeat</span>, <span class="hljs-keyword">with</span> <span class="hljs-keyword">the</span> bass        │                                 │          │
│ cranked up <span class="hljs-keyword">as</span> high <span class="hljs-keyword">as</span> <span class="hljs-keyword">it</span> could  │                                 │          │
│ go.                             │                                 │          │
│                                 │                                 │          │
│ If you hate Gangnam Style <span class="hljs-keyword">for</span>   │                                 │          │
│ being overplayed, you will see  │                                 │          │
│ why I chose <span class="hljs-keyword">that</span> particular     │                                 │          │
│ song. I personally don&#x27;t mind   │                                 │          │
│ <span class="hljs-keyword">it</span>. But here&#x27;s <span class="hljs-keyword">the</span> thing <span class="hljs-keyword">about</span>  │                                 │          │
│ <span class="hljs-keyword">my</span> bass; <span class="hljs-keyword">it</span> vibrates <span class="hljs-keyword">the</span> walls, │                                 │          │
│ making one hell <span class="hljs-keyword">of</span> a lot <span class="hljs-keyword">of</span>     │                                 │          │
│ noise. Needless <span class="hljs-keyword">to</span> <span class="hljs-built_in">say</span>, <span class="hljs-keyword">my</span> mom  │                                 │          │
│ was <span class="hljs-keyword">not</span> pleased <span class="hljs-keyword">and</span> shut off    │                                 │          │
│ <span class="hljs-keyword">the</span> internet. But <span class="hljs-keyword">it</span> was oh so  │                                 │          │
│ worth <span class="hljs-keyword">it</span>.                       │                                 │          │
│                                 │                                 │          │
│ TL;DR:                          │                                 │          │
└─────────────────────────────────┴─────────────────────────────────┴──────────┘`,wrap:!1}}),Z=new z({props:{title:"Implementation details",local:"implementation-details",headingTag:"h2"}}),D=new z({props:{title:"Benchmark experiments",local:"benchmark-experiments",headingTag:"h2"}}),E=new $({props:{code:"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",highlighted:`<span class="hljs-comment"># 1B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero2.yaml \\</span>
    examples/scripts/online_dpo.py \\
    <span class="hljs-comment">--dataset_name trl-internal-testing/tldr-preference-sft-trl-style \\</span>
    <span class="hljs-comment">--learning_rate 3e-6 \\</span>
    <span class="hljs-comment">--output_dir models/minimal/online_dpo_tldr \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 16 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 4 \\</span>
    <span class="hljs-comment">--local_rollout_forward_batch_size 32 \\</span>
    <span class="hljs-comment">--num_epochs 1 \\</span>
    <span class="hljs-comment">--num_mini_batches 1 \\</span>
    <span class="hljs-comment">--total_episodes 1000000 \\</span>
    <span class="hljs-comment">--model_name_or_path cleanrl/EleutherAI_pythia-1b-deduped__sft__tldr  \\</span>
    <span class="hljs-comment">--sft_model_path cleanrl/EleutherAI_pythia-1b-deduped__sft__tldr \\</span>
    <span class="hljs-comment">--reward_model_path cleanrl/EleutherAI_pythia-1b-deduped__reward__tldr \\</span>
    <span class="hljs-comment">--save_strategy no \\</span>
    <span class="hljs-comment">--non_eos_penalty \\</span>
    <span class="hljs-comment">--stop_token eos \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--response_length 53 \\</span>
    <span class="hljs-comment">--push_to_hub</span>

<span class="hljs-comment"># 6.9B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero3.yaml \\</span>
    examples/scripts/online_dpo.py \\
    <span class="hljs-comment">--dataset_name trl-internal-testing/tldr-preference-sft-trl-style \\</span>
    <span class="hljs-comment">--learning_rate 3e-6 \\</span>
    <span class="hljs-comment">--output_dir models/minimal/online_dpo_tldr_6.9b \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 4 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 16 \\</span>
    <span class="hljs-comment">--local_rollout_forward_batch_size 8 \\</span>
    <span class="hljs-comment">--num_epochs 1 \\</span>
    <span class="hljs-comment">--num_mini_batches 1 \\</span>
    <span class="hljs-comment">--total_episodes 1000000 \\</span>
    <span class="hljs-comment">--model_name_or_path EleutherAI/pythia-6.9b-deduped \\</span>
    <span class="hljs-comment">--sft_model_path cleanrl/EleutherAI_pythia-6.9b-deduped__sft__tldr \\</span>
    <span class="hljs-comment">--reward_model_path cleanrl/EleutherAI_pythia-6.9b-deduped__reward__tldr \\</span>
    <span class="hljs-comment">--save_strategy no \\</span>
    <span class="hljs-comment">--non_eos_penalty \\</span>
    <span class="hljs-comment">--stop_token eos \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--response_length 53 \\</span>
    <span class="hljs-comment">--push_to_hub</span>`,wrap:!1}}),_=new $({props:{code:"JTI0JTIwcHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZXZhbHMlMkZqdWRnZV90bGRyLnB5JTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBjbGVhbnJsJTJGRWxldXRoZXJBSV9weXRoaWEtMWItZGVkdXBlZF9fc2Z0X190bGRyJTIwLS1qdWRnZV9tb2RlbCUyMGdwdC00by1taW5pJTIwLS1udW1fZXhhbXBsZXMlMjAxMDAwJTBBTW9kZWwlMjB3aW4lMjByYXRlJTNBJTIwMzMuMDAlMjUlMEFweXRob24lMjBleGFtcGxlcyUyRnNjcmlwdHMlMkZldmFscyUyRmp1ZGdlX3RsZHIucHklMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMGNsZWFucmwlMkZFbGV1dGhlckFJX3B5dGhpYS02LjliLWRlZHVwZWRfX3NmdF9fdGxkciUyMC0tanVkZ2VfbW9kZWwlMjBncHQtNG8tbWluaSUyMC0tbnVtX2V4YW1wbGVzJTIwMTAwMCUwQU1vZGVsJTIwd2luJTIwcmF0ZSUzQSUyMDQxLjUwJTI1JTBBcHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZXZhbHMlMkZqdWRnZV90bGRyLnB5JTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjB2d3h5empuJTJGb25saW5lX2Rwb190bGRyJTIwLS1qdWRnZV9tb2RlbCUyMGdwdC00by1taW5pJTIwLS1udW1fZXhhbXBsZXMlMjAxMDAwJTBBTW9kZWwlMjB3aW4lMjByYXRlJTNBJTIwNjIuNjAlMjUlMEFweXRob24lMjBleGFtcGxlcyUyRnNjcmlwdHMlMkZldmFscyUyRmp1ZGdlX3RsZHIucHklMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMHZ3eHl6am4lMkZvbmxpbmVfZHBvX3RsZHJfNi45YiUyMC0tanVkZ2VfbW9kZWwlMjBncHQtNG8tbWluaSUyMC0tbnVtX2V4YW1wbGVzJTIwMTAwMCUwQU1vZGVsJTIwd2luJTIwcmF0ZSUzQSUyMDc0LjIwJTI1",highlighted:`$ python examples/scripts/evals/judge_tldr.py --model_name_or_path cleanrl/EleutherAI_pythia-1b-deduped__sft__tldr --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 33.00%
python examples/scripts/evals/judge_tldr.py --model_name_or_path cleanrl/EleutherAI_pythia-6.9b-deduped__sft__tldr --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 41.50%
python examples/scripts/evals/judge_tldr.py --model_name_or_path vwxyzjn/online_dpo_tldr --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 62.60%
python examples/scripts/evals/judge_tldr.py --model_name_or_path vwxyzjn/online_dpo_tldr_6.9b --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 74.20%`,wrap:!1}}),v=new $({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTRlQlMjIlM0ElMjAlNUIlNUIxZTklMkMlMjA2LjllOSU1RCUyQyUyMCU1QjAuMzMlMkMlMjAwLjQxNSU1RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMk9ubGluZSUyMERQTyUyMiUzQSUyMCU1QiU1QjFlOSUyQyUyMDYuOWU5JTVEJTJDJTIwJTVCMC42MjYlMkMlMjAwLjc0MiU1RCU1RCUyQyUwQSU3RCUwQWZvciUyMG1vZGVsJTJDJTIwKHglMkMlMjB5KSUyMGluJTIwZGF0YS5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwcGx0LnNjYXR0ZXIoeCUyQyUyMHklMkMlMjBsYWJlbCUzRG1vZGVsKSUwQSUwQXBsdC5heGhsaW5lKHklM0QwLjUlMkMlMjBjb2xvciUzRCUyMmJsYWNrJTIyJTJDJTIwbGluZXN0eWxlJTNEJTIyLS4lMjIlMkMlMjBsYWJlbCUzRCUyMkh1bWFuJTIwcmVmZXJlbmNlJTIwc3VtbWFyeSUyMiklMEFwbHQudGl0bGUoJTIyUkxIRiUyMHNjYWxpbmclMjBieSUyMG1vZGVsJTIwc2l6ZSUyMiklMEFwbHQueGxhYmVsKCUyMk1vZGVsJTIwc2l6ZSUyMiklMEFwbHQueWxhYmVsKCUyMldpbiUyMHJhdGUlMjBhZ2FpbnN0JTIwcmVmZXJlbmNlJTIwc3VtbWFyaWVzJTVDbihhY2NvcmRpbmclMjB0byUyMEdQVC00byUyMG1pbmkpJTIyKSUwQXBsdC54c2NhbGUoJTIybG9nJTIyKSUwQXBsdC54bGltKDVlOCUyQyUyMDEuMmUxMCklMEFwbHQueHRpY2tzKCU1QjFlOSUyQyUyMDFlMTAlNUQlMkMlMjAlNUIlMjIxQiUyMiUyQyUyMCUyMjEwQiUyMiU1RCklMEFwbHQubGVnZW5kKCklMEFwbHQuZ3JpZChUcnVlJTJDJTIwd2hpY2glM0QlMjJib3RoJTIyJTJDJTIwbHMlM0QlMjItLSUyMiUyQyUyMGMlM0QlMjIwLjclMjIpJTBBcGx0LnRpZ2h0X2xheW91dCgpJTBBcGx0LnNhdmVmaWcoJTIycGxvdC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

data = {
    <span class="hljs-string">&quot;SFT&quot;</span>: [[<span class="hljs-number">1e9</span>, <span class="hljs-number">6.9e9</span>], [<span class="hljs-number">0.33</span>, <span class="hljs-number">0.415</span>]],
    <span class="hljs-string">&quot;Online DPO&quot;</span>: [[<span class="hljs-number">1e9</span>, <span class="hljs-number">6.9e9</span>], [<span class="hljs-number">0.626</span>, <span class="hljs-number">0.742</span>]],
}
<span class="hljs-keyword">for</span> model, (x, y) <span class="hljs-keyword">in</span> data.items():
    plt.scatter(x, y, label=model)

plt.axhline(y=<span class="hljs-number">0.5</span>, color=<span class="hljs-string">&quot;black&quot;</span>, linestyle=<span class="hljs-string">&quot;-.&quot;</span>, label=<span class="hljs-string">&quot;Human reference summary&quot;</span>)
plt.title(<span class="hljs-string">&quot;RLHF scaling by model size&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Model size&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Win rate against reference summaries\\n(according to GPT-4o mini)&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)
plt.xlim(<span class="hljs-number">5e8</span>, <span class="hljs-number">1.2e10</span>)
plt.xticks([<span class="hljs-number">1e9</span>, <span class="hljs-number">1e10</span>], [<span class="hljs-string">&quot;1B&quot;</span>, <span class="hljs-string">&quot;10B&quot;</span>])
plt.legend()
plt.grid(<span class="hljs-literal">True</span>, which=<span class="hljs-string">&quot;both&quot;</span>, ls=<span class="hljs-string">&quot;--&quot;</span>, c=<span class="hljs-string">&quot;0.7&quot;</span>)
plt.tight_layout()
plt.savefig(<span class="hljs-string">&quot;plot.png&quot;</span>)`,wrap:!1}}),L=new el({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/online_dpo_trainer.md"}}),{c(){n=I("meta"),K=y(),P=I("p"),MM=y(),j(i.$$.fragment),lM=y(),o=I("p"),o.innerHTML=NM,UM=y(),p=I("p"),p.innerHTML=DM,TM=y(),j(d.$$.fragment),yM=y(),c=I("p"),c.textContent=fM,JM=y(),j(r.$$.fragment),IM=y(),m=I("p"),m.textContent=EM,wM=y(),j(h.$$.fragment),CM=y(),j(O.$$.fragment),jM=y(),k=I("p"),k.innerHTML=WM,eM=y(),R=I("ul"),R.innerHTML=XM,sM=y(),j(b.$$.fragment),AM=y(),Q=I("ul"),Q.innerHTML=xM,aM=y(),j(V.$$.fragment),tM=y(),u=I("p"),u.innerHTML=_M,nM=y(),g=I("p"),g.innerHTML=SM,iM=y(),B=I("p"),B.textContent=vM,oM=y(),j(F.$$.fragment),pM=y(),j(Z.$$.fragment),dM=y(),G=I("p"),G.innerHTML=HM,cM=y(),N=I("ol"),N.innerHTML=YM,rM=y(),j(D.$$.fragment),mM=y(),f=I("p"),f.innerHTML=LM,hM=y(),j(E.$$.fragment),OM=y(),W=I("p"),W.textContent=zM,kM=y(),X=I("ul"),X.innerHTML=$M,RM=y(),x=I("p"),x.innerHTML=PM,bM=y(),j(_.$$.fragment),QM=y(),S=I("p"),S.textContent=qM,VM=y(),j(v.$$.fragment),uM=y(),H=I("p"),H.innerHTML=KM,gM=y(),Y=I("p"),Y.textContent=Ml,BM=y(),j(L.$$.fragment),FM=y(),q=I("p"),this.h()},l(M){const l=Cl("svelte-u9bgzb",document.head);n=w(l,"META",{name:!0,content:!0}),l.forEach(U),K=J(M),P=w(M,"P",{}),ll(P).forEach(U),MM=J(M),e(i.$$.fragment,M),lM=J(M),o=w(M,"P",{"data-svelte-h":!0}),C(o)!=="svelte-r85etu"&&(o.innerHTML=NM),UM=J(M),p=w(M,"P",{"data-svelte-h":!0}),C(p)!=="svelte-1aa0pa2"&&(p.innerHTML=DM),TM=J(M),e(d.$$.fragment,M),yM=J(M),c=w(M,"P",{"data-svelte-h":!0}),C(c)!=="svelte-j414yp"&&(c.textContent=fM),JM=J(M),e(r.$$.fragment,M),IM=J(M),m=w(M,"P",{"data-svelte-h":!0}),C(m)!=="svelte-17vlgaa"&&(m.textContent=EM),wM=J(M),e(h.$$.fragment,M),CM=J(M),e(O.$$.fragment,M),jM=J(M),k=w(M,"P",{"data-svelte-h":!0}),C(k)!=="svelte-1i6oul1"&&(k.innerHTML=WM),eM=J(M),R=w(M,"UL",{"data-svelte-h":!0}),C(R)!=="svelte-1d0bybt"&&(R.innerHTML=XM),sM=J(M),e(b.$$.fragment,M),AM=J(M),Q=w(M,"UL",{"data-svelte-h":!0}),C(Q)!=="svelte-1r52mll"&&(Q.innerHTML=xM),aM=J(M),e(V.$$.fragment,M),tM=J(M),u=w(M,"P",{"data-svelte-h":!0}),C(u)!=="svelte-16ylva"&&(u.innerHTML=_M),nM=J(M),g=w(M,"P",{"data-svelte-h":!0}),C(g)!=="svelte-15f99oh"&&(g.innerHTML=SM),iM=J(M),B=w(M,"P",{"data-svelte-h":!0}),C(B)!=="svelte-98m2ov"&&(B.textContent=vM),oM=J(M),e(F.$$.fragment,M),pM=J(M),e(Z.$$.fragment,M),dM=J(M),G=w(M,"P",{"data-svelte-h":!0}),C(G)!=="svelte-au0bvi"&&(G.innerHTML=HM),cM=J(M),N=w(M,"OL",{"data-svelte-h":!0}),C(N)!=="svelte-17mbhvc"&&(N.innerHTML=YM),rM=J(M),e(D.$$.fragment,M),mM=J(M),f=w(M,"P",{"data-svelte-h":!0}),C(f)!=="svelte-w28lzn"&&(f.innerHTML=LM),hM=J(M),e(E.$$.fragment,M),OM=J(M),W=w(M,"P",{"data-svelte-h":!0}),C(W)!=="svelte-yl0uf2"&&(W.textContent=zM),kM=J(M),X=w(M,"UL",{"data-svelte-h":!0}),C(X)!=="svelte-15mt1c0"&&(X.innerHTML=$M),RM=J(M),x=w(M,"P",{"data-svelte-h":!0}),C(x)!=="svelte-19n72p9"&&(x.innerHTML=PM),bM=J(M),e(_.$$.fragment,M),QM=J(M),S=w(M,"P",{"data-svelte-h":!0}),C(S)!=="svelte-unx6we"&&(S.textContent=qM),VM=J(M),e(v.$$.fragment,M),uM=J(M),H=w(M,"P",{"data-svelte-h":!0}),C(H)!=="svelte-1suobbe"&&(H.innerHTML=KM),gM=J(M),Y=w(M,"P",{"data-svelte-h":!0}),C(Y)!=="svelte-1fufp5p"&&(Y.textContent=Ml),BM=J(M),e(L.$$.fragment,M),FM=J(M),q=w(M,"P",{}),ll(q).forEach(U),this.h()},h(){Ul(n,"name","hf:doc:metadata"),Ul(n,"content",Al)},m(M,l){jl(document.head,n),T(M,K,l),T(M,P,l),T(M,MM,l),s(i,M,l),T(M,lM,l),T(M,o,l),T(M,UM,l),T(M,p,l),T(M,TM,l),s(d,M,l),T(M,yM,l),T(M,c,l),T(M,JM,l),s(r,M,l),T(M,IM,l),T(M,m,l),T(M,wM,l),s(h,M,l),T(M,CM,l),s(O,M,l),T(M,jM,l),T(M,k,l),T(M,eM,l),T(M,R,l),T(M,sM,l),s(b,M,l),T(M,AM,l),T(M,Q,l),T(M,aM,l),s(V,M,l),T(M,tM,l),T(M,u,l),T(M,nM,l),T(M,g,l),T(M,iM,l),T(M,B,l),T(M,oM,l),s(F,M,l),T(M,pM,l),s(Z,M,l),T(M,dM,l),T(M,G,l),T(M,cM,l),T(M,N,l),T(M,rM,l),s(D,M,l),T(M,mM,l),T(M,f,l),T(M,hM,l),s(E,M,l),T(M,OM,l),T(M,W,l),T(M,kM,l),T(M,X,l),T(M,RM,l),T(M,x,l),T(M,bM,l),s(_,M,l),T(M,QM,l),T(M,S,l),T(M,VM,l),s(v,M,l),T(M,uM,l),T(M,H,l),T(M,gM,l),T(M,Y,l),T(M,BM,l),s(L,M,l),T(M,FM,l),T(M,q,l),ZM=!0},p:yl,i(M){ZM||(A(i.$$.fragment,M),A(d.$$.fragment,M),A(r.$$.fragment,M),A(h.$$.fragment,M),A(O.$$.fragment,M),A(b.$$.fragment,M),A(V.$$.fragment,M),A(F.$$.fragment,M),A(Z.$$.fragment,M),A(D.$$.fragment,M),A(E.$$.fragment,M),A(_.$$.fragment,M),A(v.$$.fragment,M),A(L.$$.fragment,M),ZM=!0)},o(M){a(i.$$.fragment,M),a(d.$$.fragment,M),a(r.$$.fragment,M),a(h.$$.fragment,M),a(O.$$.fragment,M),a(b.$$.fragment,M),a(V.$$.fragment,M),a(F.$$.fragment,M),a(Z.$$.fragment,M),a(D.$$.fragment,M),a(E.$$.fragment,M),a(_.$$.fragment,M),a(v.$$.fragment,M),a(L.$$.fragment,M),ZM=!1},d(M){M&&(U(K),U(P),U(MM),U(lM),U(o),U(UM),U(p),U(TM),U(yM),U(c),U(JM),U(IM),U(m),U(wM),U(CM),U(jM),U(k),U(eM),U(R),U(sM),U(AM),U(Q),U(aM),U(tM),U(u),U(nM),U(g),U(iM),U(B),U(oM),U(pM),U(dM),U(G),U(cM),U(N),U(rM),U(mM),U(f),U(hM),U(OM),U(W),U(kM),U(X),U(RM),U(x),U(bM),U(QM),U(S),U(VM),U(uM),U(H),U(gM),U(Y),U(BM),U(FM),U(q)),U(n),t(i,M),t(d,M),t(r,M),t(h,M),t(O,M),t(b,M),t(V,M),t(F,M),t(Z,M),t(D,M),t(E,M),t(_,M),t(v,M),t(L,M)}}}const Al='{"title":"Online DPO Trainer","local":"online-dpo-trainer","sections":[{"title":"Get started","local":"get-started","sections":[],"depth":2},{"title":"Explanation of the logged metrics","local":"explanation-of-the-logged-metrics","sections":[],"depth":2},{"title":"Cookbook","local":"cookbook","sections":[],"depth":2},{"title":"What is my model doing exactly?","local":"what-is-my-model-doing-exactly","sections":[],"depth":2},{"title":"Implementation details","local":"implementation-details","sections":[],"depth":2},{"title":"Benchmark experiments","local":"benchmark-experiments","sections":[],"depth":2}],"depth":1}';function al(GM){return Jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pl extends Il{constructor(n){super(),wl(this,n,al,sl,Tl,{})}}export{pl as component};
