import{s as In,n as zn,o as Cn}from"../chunks/scheduler.de5597d1.js";import{S as Hn,i as Xn,e as g,s as i,c as a,h as xn,a as h,d as n,b as l,f as Un,g as r,j as u,k as Kt,l as Bn,m as s,n as p,t as o,o as m,p as d}from"../chunks/index.bf1177c2.js";import{C as Ln,H as c,E as Yn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.7c37555a.js";import{C as f}from"../chunks/CodeBlock.af63e669.js";function qn(At){let y,ze,Ue,Ce,b,He,M,Xe,w,Ot='Das Hugging Face Hub besteht aus einer Sammlung von Git-Repositories. <a href="https://git-scm.com/" rel="nofollow">Git</a> ist ein in der Softwareentwicklung weit verbreitetes Tool, um Projekte bei der Zusammenarbeit einfach zu versionieren. Dieser Leitfaden zeigt Ihnen, wie Sie mit den Repositories auf dem Hub interagieren, insbesondere:',xe,v,en="<li>Ein Repository erstellen und löschen.</li> <li>Zweige (Branches) und Tags verwalten.</li> <li>Ihr Repository umbenennen.</li> <li>Die Sichtbarkeit Ihres Repositories aktualisieren.</li> <li>Eine lokale Kopie Ihres Repositories verwalten.</li>",Be,$,tn='<p>Wenn Sie es gewohnt sind, mit Plattformen wie GitLab/GitHub/Bitbucket zu arbeiten, könnte Ihr erster Instinkt sein, die <code>git</code> CLI zu verwenden, um Ihr Repo zu klonen (<code>git clone</code>), Änderungen zu übernehmen (<code>git add</code>, <code>git commit</code>) und diese hochzuladen (<code>git push</code>). Dies ist beim Verwenden des Hugging Face Hubs gültig. Softwareentwicklung und maschinelles Lernen haben jedoch nicht dieselben Anforderungen und Arbeitsabläufe. Modell-Repositories könnten große Modellgewichtsdateien für verschiedene Frameworks und Tools beinhalten, sodass das Klonen des Repositories dazu führen kann, dass Sie große lokale Ordner mit massiven Größen pflegen. Daher kann es effizienter sein, unsere benutzerdefinierten HTTP-Methoden zu verwenden. Sie können unsere <a href="../concepts/git_vs_http">Git vs HTTP Paradigma</a> Erklärungsseite für weitere Details lesen.</p>',Le,k,nn='Wenn Sie ein Repository auf dem Hub erstellen und verwalten möchten, muss Ihr Computer angemeldet sein. Wenn Sie es nicht sind, beziehen Sie sich bitte auf <a href="../quick-start#login">diesen Abschnitt</a>. Im Rest dieses Leitfadens gehen wir davon aus, dass Ihr Computer angemeldet ist.',Ye,T,qe,j,sn="Der erste Schritt besteht darin, zu wissen, wie man Repositories erstellt und löscht. Sie können nur Repositories verwalten, die Ihnen gehören (unter Ihrem Benutzernamensraum) oder von Organisationen, in denen Sie Schreibberechtigungen haben.",Fe,J,We,R,ln="Erstellen Sie ein leeres Repository mit <code>create_repo()</code> und geben Sie ihm mit dem Parameter <code>repo_id</code> einen Namen. Die <code>repo_id</code> ist Ihr Namensraum gefolgt vom Repository-Namen: <code>username_or_org/repo_name</code>.",Ne,_,Ve,G,an="Standardmäßig erstellt <code>create_repo()</code> ein Modellrepository. Sie können jedoch den Parameter <code>repo_type</code> verwenden, um einen anderen Repository-Typ anzugeben. Wenn Sie beispielsweise ein Dataset-Repository erstellen möchten:",Ee,Z,Pe,S,rn="Wenn Sie ein Repository erstellen, können Sie mit dem Parameter <code>private</code> die Sichtbarkeit Ihres Repositories festlegen.",Qe,U,De,I,pn="Wenn Sie die Sichtbarkeit des Repositories zu einem späteren Zeitpunkt ändern möchten, können Sie die Funktion <code>update_repo_settings()</code> verwenden.",Ke,z,Ae,C,on="Löschen Sie ein Repository mit <code>delete_repo()</code>. Stellen Sie sicher, dass Sie ein Repository löschen möchten, da dieser Vorgang unwiderruflich ist!",Oe,H,mn="Geben Sie die <code>repo_id</code> des Repositories an, das Sie löschen möchten:",et,X,tt,x,nt,B,dn=`In einigen Fällen möchten Sie möglicherweise das Repo von jemand anderem kopieren, um es an Ihren Anwendungsfall anzupassen. Dies ist für Spaces mit der Methode <code>duplicate_space()</code> möglich. Es wird das gesamte Repository dupliziert.
Sie müssen jedoch noch Ihre eigenen Einstellungen konfigurieren (Hardware, Schlafzeit, Speicher, Variablen und Geheimnisse). Weitere Informationen finden Sie in unserem Leitfaden <a href="./manage-spaces">Verwalten Ihres Spaces</a>.`,st,L,it,Y,lt,q,gn="Jetzt, wo Sie Ihr Repository erstellt haben, möchten Sie Änderungen daran vornehmen und Dateien daraus herunterladen.",at,F,hn='Diese 2 Themen verdienen ihre eigenen Leitfäden. Bitte beziehen Sie sich auf die <a href="./upload">Hochladen</a> und die <a href="./download">Herunterladen</a> Leitfäden, um zu erfahren, wie Sie Ihr Repository verwenden können.',rt,W,pt,N,un=`Git-Repositories verwenden oft Branches, um verschiedene Versionen eines gleichen Repositories zu speichern.
Tags können auch verwendet werden, um einen bestimmten Zustand Ihres Repositories zu kennzeichnen, z. B. bei der Veröffentlichung einer Version.
Allgemeiner gesagt, werden Branches und Tags als <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References" rel="nofollow">git-Referenzen</a> bezeichnet.`,ot,V,mt,E,cn="Sie können neue Branches und Tags mit <code>create_branch()</code> und <code>create_tag()</code> erstellen:",dt,P,gt,Q,fn="Sie können die Funktionen <code>delete_branch()</code> und <code>delete_tag()</code> auf die gleiche Weise verwenden, um einen Branch oder einen Tag zu löschen.",ht,D,ut,K,yn="Sie können auch die vorhandenen git-Referenzen von einem Repository mit <code>list_repo_refs()</code> auflisten:",ct,A,ft,O,yt,ee,$n="Repositories verfügen über einige Einstellungen, die Sie konfigurieren können. Die meiste Zeit möchten Sie dies manuell auf der Repo-Einstellungsseite in Ihrem Browser tun. Sie müssen Schreibzugriff auf ein Repo haben, um es zu konfigurieren (entweder besitzen oder Teil einer Organisation sein). In diesem Abschnitt werden wir die Einstellungen sehen, die Sie auch programmgesteuert mit <code>huggingface_hub</code> konfigurieren können.",$t,te,bn='Einige Einstellungen sind spezifisch für Spaces (Hardware, Umgebungsvariablen,…). Um diese zu konfigurieren, lesen Sie bitte unseren <a href="../guides/manage-spaces">Verwalten Ihres Spaces</a> Leitfaden.',bt,ne,Mt,se,Mn="Ein Repository kann öffentlich oder privat sein. Ein privates Repository ist nur für Sie oder die Mitglieder der Organisation sichtbar, in der das Repository sich befindet. Ändern Sie ein Repository wie im Folgenden gezeigt in ein privates:",wt,ie,vt,le,kt,ae,wn='Sie können Ihr Repository auf dem Hub mit [`move_repo] umbenennen. Mit dieser Methode können Sie das Repo auch von einem Benutzer zu einer Organisation verschieben. Dabei gibt es <a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">einige Einschränkungen</a>, die Sie beachten sollten. Zum Beispiel können Sie Ihr Repo nicht an einen anderen Benutzer übertragen.',Tt,re,jt,pe,Jt,oe,vn="Alle oben beschriebenen Aktionen können mit HTTP-Anfragen durchgeführt werden. In einigen Fällen möchten Sie jedoch vielleicht eine lokale Kopie Ihres Repositories haben und damit interagieren, indem Sie die Git-Befehle verwenden, die Sie kennen.",Rt,me,kn='Die <code>Repository</code> Klasse ermöglicht es Ihnen, mit Dateien und Repositories auf dem Hub mit Funktionen zu interagieren, die Git-Befehlen ähneln. Es ist ein Wrapper über Git und Git-LFS-Methoden, um die Git-Befehle zu verwenden, die Sie bereits kennen und lieben. Stellen Sie vor dem Start sicher, dass Sie Git-LFS installiert haben (siehe <a href="https://git-lfs.github.com/" rel="nofollow">hier</a> für Installationsanweisungen).',_t,de,Gt,ge,Tn="Instanziieren Sie ein <code>Repository</code> Objekt mit einem Pfad zu einem lokalen Repository:",Zt,he,St,ue,Ut,ce,jn="Der <code>clone_from</code> Parameter klont ein Repository von einer Hugging Face Repository-ID in ein lokales Verzeichnis, das durch das Argument <code>local_dir</code> angegeben wird:",It,fe,zt,ye,Jn="<code>clone_from</code> kann auch ein Repository mit einer URL klonen:",Ct,$e,Ht,be,Rn="Sie können den <code>clone_from</code> Parameter mit <code>create_repo()</code> kombinieren, um ein Repository zu erstellen und zu klonen:",Xt,Me,xt,we,_n="Sie können auch einen Git-Benutzernamen und eine E-Mail zu einem geklonten Repository konfigurieren, indem Sie die Parameter <code>git_user</code> und <code>git_email</code> beim Klonen eines Repositories angeben. Wenn Benutzer Änderungen in diesem Repository committen, wird Git über den Autor des Commits informiert sein.",Bt,ve,Lt,ke,Yt,Te,Gn="Branches sind wichtig für die Zusammenarbeit und das Experimentieren, ohne Ihre aktuellen Dateien und Codes zu beeinflussen. Wechseln Sie zwischen den Branches mit <code>~Repository.git_checkout</code>. Wenn Sie beispielsweise von <code>branch1</code> zu <code>branch2</code> wechseln möchten:",qt,je,Ft,Je,Wt,Re,Zn="Mit <code>~Repository.git_pull</code> können Sie eine aktuelle lokale Branch mit Änderungen aus einem Remote-Repository aktualisieren:",Nt,_e,Vt,Ge,Sn="Setzen Sie <code>rebase=True</code>, wenn Sie möchten, dass Ihre lokalen Commits nach dem Aktualisieren Ihres Zweigs mit den neuen Commits aus dem Remote erfolgen:",Et,Ze,Pt,Se,Qt,Ie,Dt;return b=new Ln({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new c({props:{title:"Ein Repository erstellen und verwalten",local:"ein-repository-erstellen-und-verwalten",headingTag:"h1"}}),T=new c({props:{title:"Erstellung und Löschung von Repos",local:"erstellung-und-löschung-von-repos",headingTag:"h2"}}),J=new c({props:{title:"Ein Repository erstellen",local:"ein-repository-erstellen",headingTag:"h3"}}),_=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),Z=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/datasets/lysandre/test-dataset&#x27;</span>`,wrap:!1}}),U=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-private&quot;</span>, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),z=new c({props:{title:"Ein Repository löschen",local:"ein-repository-löschen",headingTag:"h3"}}),X=new f({props:{code:"ZGVsZXRlX3JlcG8ocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGbXktY29ycnVwdGVkLWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>delete_repo(repo_id=<span class="hljs-string">&quot;lysandre/my-corrupted-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)',wrap:!1}}),x=new c({props:{title:"Ein Repository duplizieren (nur für Spaces)",local:"ein-repository-duplizieren-nur-für-spaces",headingTag:"h3"}}),L=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiUyQyUyMHByaXZhdGUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, private=<span class="hljs-literal">False</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)`,wrap:!1}}),Y=new c({props:{title:"Dateien hochladen und herunterladen",local:"dateien-hochladen-und-herunterladen",headingTag:"h2"}}),W=new c({props:{title:"Branches und Tags",local:"branches-und-tags",headingTag:"h2"}}),V=new c({props:{title:"Branches und Tags erstellen",local:"branches-und-tags-erstellen",headingTag:"h3"}}),P=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9icmFuY2glMkMlMjBjcmVhdGVfdGFnJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJNYXR0aGlqcyUyRnNwZWVjaHQ1LXR0cy1kZW1vJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjBicmFuY2glM0QlMjJoYW5kbGUtZG9nLXNwZWFrZXIlMjIpJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjAuMS1yZWxlYXNlJTIyJTJDJTIwdGFnJTNEJTIydjAuMS4xJTIyJTJDJTIwdGFnX21lc3NhZ2UlM0QlMjJCdW1wJTIwcmVsZWFzZSUyMHZlcnNpb24uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_branch, create_tag

<span class="hljs-comment"># Erstellen Sie einen Branch auf einem Space-Repo vom \`main\` Branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;Matthijs/speecht5-tts-demo&quot;</span>, repo_type=<span class="hljs-string">&quot;space&quot;</span>, branch=<span class="hljs-string">&quot;handle-dog-speaker&quot;</span>)

<span class="hljs-comment"># Erstellen Sie einen Tag auf einem Dataset-Repo vom \`v0.1-release\` Branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, revision=<span class="hljs-string">&quot;v0.1-release&quot;</span>, tag=<span class="hljs-string">&quot;v0.1.1&quot;</span>, tag_message=<span class="hljs-string">&quot;Bump release version.&quot;</span>)`,wrap:!1}}),D=new c({props:{title:"Alle Branches und Tags auflisten",local:"alle-branches-und-tags-auflisten",headingTag:"h3"}}),A=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb19yZWZzJTBBbGlzdF9yZXBvX3JlZnMoJTIyYmlnY29kZSUyRnRoZS1zdGFjayUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_refs
<span class="hljs-meta">&gt;&gt;&gt; </span>list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
GitRefs(
   branches=[
         GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
   ],
   converts=[],
   tags=[
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
   ]
)`,wrap:!1}}),O=new c({props:{title:"Repository-Einstellungen ändern",local:"repository-einstellungen-ändern",headingTag:"h2"}}),ne=new c({props:{title:"Sichtbarkeit aktualisieren",local:"sichtbarkeit-aktualisieren",headingTag:"h3"}}),ie=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9yZXBvX3NldHRpbmdzJTBBdXBkYXRlX3JlcG9fc2V0dGluZ3MocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_repo_settings
<span class="hljs-meta">&gt;&gt;&gt; </span>update_repo_settings(repo_id=repo_id, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),le=new c({props:{title:"Benennen Sie Ihr Repository um",local:"benennen-sie-ihr-repository-um",headingTag:"h3"}}),re=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1vdmVfcmVwbyUwQW1vdmVfcmVwbyhmcm9tX2lkJTNEJTIyV2F1cGxpbiUyRmNvb2wtbW9kZWwlMjIlMkMlMjB0b19pZCUzRCUyMmh1Z2dpbmdmYWNlJTJGY29vbC1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> move_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>move_repo(from_id=<span class="hljs-string">&quot;Wauplin/cool-model&quot;</span>, to_id=<span class="hljs-string">&quot;huggingface/cool-model&quot;</span>)`,wrap:!1}}),pe=new c({props:{title:"Verwalten Sie eine lokale Kopie Ihres Repositories",local:"verwalten-sie-eine-lokale-kopie-ihres-repositories",headingTag:"h2"}}),de=new c({props:{title:"Verwenden eines lokalen Repositories",local:"verwenden-eines-lokalen-repositories",headingTag:"h3"}}),he=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjIlM0NwYXRoJTNFJTJGJTNDdG8lM0UlMkYlM0Nmb2xkZXIlM0UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;&lt;path&gt;/&lt;to&gt;/&lt;folder&gt;&quot;</span>)`,wrap:!1}}),ue=new c({props:{title:"Klonen",local:"klonen",headingTag:"h3"}}),fe=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ3MnYyJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;w2v2&quot;</span>, clone_from=<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)`,wrap:!1}}),$e=new f({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkobG9jYWxfZGlyJTNEJTIyaHVnZ2luZ2ZhY2UtaHViJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;https://huggingface.co/facebook/wav2vec2-large-960h-lv60&quot;</span>)',wrap:!1}}),Me=new f({props:{code:"cmVwb191cmwlMjAlM0QlMjBjcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIycmVwb19uYW1lJTIyKSUwQXJlcG8lMjAlM0QlMjBSZXBvc2l0b3J5KGxvY2FsX2RpciUzRCUyMnJlcG9fbG9jYWxfcGF0aCUyMiUyQyUyMGNsb25lX2Zyb20lM0RyZXBvX3VybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo_url = create_repo(repo_id=<span class="hljs-string">&quot;repo_name&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;repo_local_path&quot;</span>, clone_from=repo_url)`,wrap:!1}}),ve=new f({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIybXktZGF0YXNldCUyMiUyQyUwQSUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGJTNDZGF0YXNldF9pZCUzRSUyMiUyQyUwQSUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjBnaXRfdXNlciUzRCUyMk15TmFtZSUyMiUyQyUwQSUyMCUyMGdpdF9lbWFpbCUzRCUyMm1lJTQwY29vbC5tYWlsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;my-dataset&quot;</span>,
<span class="hljs-meta">... </span>  clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>,
<span class="hljs-meta">... </span>  token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>  git_user=<span class="hljs-string">&quot;MyName&quot;</span>,
<span class="hljs-meta">... </span>  git_email=<span class="hljs-string">&quot;me@cool.mail&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ke=new c({props:{title:"Branch",local:"branch",headingTag:"h3"}}),je=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJodWdnaW5nZmFjZS1odWIlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRiUzQ2RhdGFzZXRfaWQlM0UlMjIlMkMlMjByZXZpc2lvbiUzRCdicmFuY2gxJyklMEFyZXBvLmdpdF9jaGVja291dCglMjJicmFuY2gyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>, revision=<span class="hljs-string">&#x27;branch1&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_checkout(<span class="hljs-string">&quot;branch2&quot;</span>)`,wrap:!1}}),Je=new c({props:{title:"Pull",local:"pull",headingTag:"h3"}}),_e=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvLmdpdF9wdWxsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()`,wrap:!1}}),Ze=new f({props:{code:"cmVwby5naXRfcHVsbChyZWJhc2UlM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull(rebase=<span class="hljs-literal">True</span>)',wrap:!1}}),Se=new Yn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/repository.md"}}),{c(){y=g("meta"),ze=i(),Ue=g("p"),Ce=i(),a(b.$$.fragment),He=i(),a(M.$$.fragment),Xe=i(),w=g("p"),w.innerHTML=Ot,xe=i(),v=g("ul"),v.innerHTML=en,Be=i(),$=g("blockquote"),$.innerHTML=tn,Le=i(),k=g("p"),k.innerHTML=nn,Ye=i(),a(T.$$.fragment),qe=i(),j=g("p"),j.textContent=sn,Fe=i(),a(J.$$.fragment),We=i(),R=g("p"),R.innerHTML=ln,Ne=i(),a(_.$$.fragment),Ve=i(),G=g("p"),G.innerHTML=an,Ee=i(),a(Z.$$.fragment),Pe=i(),S=g("p"),S.innerHTML=rn,Qe=i(),a(U.$$.fragment),De=i(),I=g("p"),I.innerHTML=pn,Ke=i(),a(z.$$.fragment),Ae=i(),C=g("p"),C.innerHTML=on,Oe=i(),H=g("p"),H.innerHTML=mn,et=i(),a(X.$$.fragment),tt=i(),a(x.$$.fragment),nt=i(),B=g("p"),B.innerHTML=dn,st=i(),a(L.$$.fragment),it=i(),a(Y.$$.fragment),lt=i(),q=g("p"),q.textContent=gn,at=i(),F=g("p"),F.innerHTML=hn,rt=i(),a(W.$$.fragment),pt=i(),N=g("p"),N.innerHTML=un,ot=i(),a(V.$$.fragment),mt=i(),E=g("p"),E.innerHTML=cn,dt=i(),a(P.$$.fragment),gt=i(),Q=g("p"),Q.innerHTML=fn,ht=i(),a(D.$$.fragment),ut=i(),K=g("p"),K.innerHTML=yn,ct=i(),a(A.$$.fragment),ft=i(),a(O.$$.fragment),yt=i(),ee=g("p"),ee.innerHTML=$n,$t=i(),te=g("p"),te.innerHTML=bn,bt=i(),a(ne.$$.fragment),Mt=i(),se=g("p"),se.textContent=Mn,wt=i(),a(ie.$$.fragment),vt=i(),a(le.$$.fragment),kt=i(),ae=g("p"),ae.innerHTML=wn,Tt=i(),a(re.$$.fragment),jt=i(),a(pe.$$.fragment),Jt=i(),oe=g("p"),oe.textContent=vn,Rt=i(),me=g("p"),me.innerHTML=kn,_t=i(),a(de.$$.fragment),Gt=i(),ge=g("p"),ge.innerHTML=Tn,Zt=i(),a(he.$$.fragment),St=i(),a(ue.$$.fragment),Ut=i(),ce=g("p"),ce.innerHTML=jn,It=i(),a(fe.$$.fragment),zt=i(),ye=g("p"),ye.innerHTML=Jn,Ct=i(),a($e.$$.fragment),Ht=i(),be=g("p"),be.innerHTML=Rn,Xt=i(),a(Me.$$.fragment),xt=i(),we=g("p"),we.innerHTML=_n,Bt=i(),a(ve.$$.fragment),Lt=i(),a(ke.$$.fragment),Yt=i(),Te=g("p"),Te.innerHTML=Gn,qt=i(),a(je.$$.fragment),Ft=i(),a(Je.$$.fragment),Wt=i(),Re=g("p"),Re.innerHTML=Zn,Nt=i(),a(_e.$$.fragment),Vt=i(),Ge=g("p"),Ge.innerHTML=Sn,Et=i(),a(Ze.$$.fragment),Pt=i(),a(Se.$$.fragment),Qt=i(),Ie=g("p"),this.h()},l(e){const t=xn("svelte-u9bgzb",document.head);y=h(t,"META",{name:!0,content:!0}),t.forEach(n),ze=l(e),Ue=h(e,"P",{}),Un(Ue).forEach(n),Ce=l(e),r(b.$$.fragment,e),He=l(e),r(M.$$.fragment,e),Xe=l(e),w=h(e,"P",{"data-svelte-h":!0}),u(w)!=="svelte-1yyzsag"&&(w.innerHTML=Ot),xe=l(e),v=h(e,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-sqn2sa"&&(v.innerHTML=en),Be=l(e),$=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u($)!=="svelte-175l78b"&&($.innerHTML=tn),Le=l(e),k=h(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-rdzptl"&&(k.innerHTML=nn),Ye=l(e),r(T.$$.fragment,e),qe=l(e),j=h(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1z0tv5i"&&(j.textContent=sn),Fe=l(e),r(J.$$.fragment,e),We=l(e),R=h(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1hgmn6f"&&(R.innerHTML=ln),Ne=l(e),r(_.$$.fragment,e),Ve=l(e),G=h(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-fllp17"&&(G.innerHTML=an),Ee=l(e),r(Z.$$.fragment,e),Pe=l(e),S=h(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-5ihxzc"&&(S.innerHTML=rn),Qe=l(e),r(U.$$.fragment,e),De=l(e),I=h(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-105zhyn"&&(I.innerHTML=pn),Ke=l(e),r(z.$$.fragment,e),Ae=l(e),C=h(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-me7cb9"&&(C.innerHTML=on),Oe=l(e),H=h(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1g3j115"&&(H.innerHTML=mn),et=l(e),r(X.$$.fragment,e),tt=l(e),r(x.$$.fragment,e),nt=l(e),B=h(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1pdw2g6"&&(B.innerHTML=dn),st=l(e),r(L.$$.fragment,e),it=l(e),r(Y.$$.fragment,e),lt=l(e),q=h(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-qj5vha"&&(q.textContent=gn),at=l(e),F=h(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-uqpnt2"&&(F.innerHTML=hn),rt=l(e),r(W.$$.fragment,e),pt=l(e),N=h(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1hws6dh"&&(N.innerHTML=un),ot=l(e),r(V.$$.fragment,e),mt=l(e),E=h(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1didjjj"&&(E.innerHTML=cn),dt=l(e),r(P.$$.fragment,e),gt=l(e),Q=h(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1p2asnn"&&(Q.innerHTML=fn),ht=l(e),r(D.$$.fragment,e),ut=l(e),K=h(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-10sfcrj"&&(K.innerHTML=yn),ct=l(e),r(A.$$.fragment,e),ft=l(e),r(O.$$.fragment,e),yt=l(e),ee=h(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1brg7na"&&(ee.innerHTML=$n),$t=l(e),te=h(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1umobvh"&&(te.innerHTML=bn),bt=l(e),r(ne.$$.fragment,e),Mt=l(e),se=h(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-1moe27y"&&(se.textContent=Mn),wt=l(e),r(ie.$$.fragment,e),vt=l(e),r(le.$$.fragment,e),kt=l(e),ae=h(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1gufg09"&&(ae.innerHTML=wn),Tt=l(e),r(re.$$.fragment,e),jt=l(e),r(pe.$$.fragment,e),Jt=l(e),oe=h(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-9eyag"&&(oe.textContent=vn),Rt=l(e),me=h(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1keapud"&&(me.innerHTML=kn),_t=l(e),r(de.$$.fragment,e),Gt=l(e),ge=h(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-rpxbz6"&&(ge.innerHTML=Tn),Zt=l(e),r(he.$$.fragment,e),St=l(e),r(ue.$$.fragment,e),Ut=l(e),ce=h(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1aiqy6u"&&(ce.innerHTML=jn),It=l(e),r(fe.$$.fragment,e),zt=l(e),ye=h(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-hm7kpl"&&(ye.innerHTML=Jn),Ct=l(e),r($e.$$.fragment,e),Ht=l(e),be=h(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-19pfeu4"&&(be.innerHTML=Rn),Xt=l(e),r(Me.$$.fragment,e),xt=l(e),we=h(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-dpqex0"&&(we.innerHTML=_n),Bt=l(e),r(ve.$$.fragment,e),Lt=l(e),r(ke.$$.fragment,e),Yt=l(e),Te=h(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-fcwggy"&&(Te.innerHTML=Gn),qt=l(e),r(je.$$.fragment,e),Ft=l(e),r(Je.$$.fragment,e),Wt=l(e),Re=h(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-12w4g9x"&&(Re.innerHTML=Zn),Nt=l(e),r(_e.$$.fragment,e),Vt=l(e),Ge=h(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-1kuf0pv"&&(Ge.innerHTML=Sn),Et=l(e),r(Ze.$$.fragment,e),Pt=l(e),r(Se.$$.fragment,e),Qt=l(e),Ie=h(e,"P",{}),Un(Ie).forEach(n),this.h()},h(){Kt(y,"name","hf:doc:metadata"),Kt(y,"content",Fn),Kt($,"class","warning")},m(e,t){Bn(document.head,y),s(e,ze,t),s(e,Ue,t),s(e,Ce,t),p(b,e,t),s(e,He,t),p(M,e,t),s(e,Xe,t),s(e,w,t),s(e,xe,t),s(e,v,t),s(e,Be,t),s(e,$,t),s(e,Le,t),s(e,k,t),s(e,Ye,t),p(T,e,t),s(e,qe,t),s(e,j,t),s(e,Fe,t),p(J,e,t),s(e,We,t),s(e,R,t),s(e,Ne,t),p(_,e,t),s(e,Ve,t),s(e,G,t),s(e,Ee,t),p(Z,e,t),s(e,Pe,t),s(e,S,t),s(e,Qe,t),p(U,e,t),s(e,De,t),s(e,I,t),s(e,Ke,t),p(z,e,t),s(e,Ae,t),s(e,C,t),s(e,Oe,t),s(e,H,t),s(e,et,t),p(X,e,t),s(e,tt,t),p(x,e,t),s(e,nt,t),s(e,B,t),s(e,st,t),p(L,e,t),s(e,it,t),p(Y,e,t),s(e,lt,t),s(e,q,t),s(e,at,t),s(e,F,t),s(e,rt,t),p(W,e,t),s(e,pt,t),s(e,N,t),s(e,ot,t),p(V,e,t),s(e,mt,t),s(e,E,t),s(e,dt,t),p(P,e,t),s(e,gt,t),s(e,Q,t),s(e,ht,t),p(D,e,t),s(e,ut,t),s(e,K,t),s(e,ct,t),p(A,e,t),s(e,ft,t),p(O,e,t),s(e,yt,t),s(e,ee,t),s(e,$t,t),s(e,te,t),s(e,bt,t),p(ne,e,t),s(e,Mt,t),s(e,se,t),s(e,wt,t),p(ie,e,t),s(e,vt,t),p(le,e,t),s(e,kt,t),s(e,ae,t),s(e,Tt,t),p(re,e,t),s(e,jt,t),p(pe,e,t),s(e,Jt,t),s(e,oe,t),s(e,Rt,t),s(e,me,t),s(e,_t,t),p(de,e,t),s(e,Gt,t),s(e,ge,t),s(e,Zt,t),p(he,e,t),s(e,St,t),p(ue,e,t),s(e,Ut,t),s(e,ce,t),s(e,It,t),p(fe,e,t),s(e,zt,t),s(e,ye,t),s(e,Ct,t),p($e,e,t),s(e,Ht,t),s(e,be,t),s(e,Xt,t),p(Me,e,t),s(e,xt,t),s(e,we,t),s(e,Bt,t),p(ve,e,t),s(e,Lt,t),p(ke,e,t),s(e,Yt,t),s(e,Te,t),s(e,qt,t),p(je,e,t),s(e,Ft,t),p(Je,e,t),s(e,Wt,t),s(e,Re,t),s(e,Nt,t),p(_e,e,t),s(e,Vt,t),s(e,Ge,t),s(e,Et,t),p(Ze,e,t),s(e,Pt,t),p(Se,e,t),s(e,Qt,t),s(e,Ie,t),Dt=!0},p:zn,i(e){Dt||(o(b.$$.fragment,e),o(M.$$.fragment,e),o(T.$$.fragment,e),o(J.$$.fragment,e),o(_.$$.fragment,e),o(Z.$$.fragment,e),o(U.$$.fragment,e),o(z.$$.fragment,e),o(X.$$.fragment,e),o(x.$$.fragment,e),o(L.$$.fragment,e),o(Y.$$.fragment,e),o(W.$$.fragment,e),o(V.$$.fragment,e),o(P.$$.fragment,e),o(D.$$.fragment,e),o(A.$$.fragment,e),o(O.$$.fragment,e),o(ne.$$.fragment,e),o(ie.$$.fragment,e),o(le.$$.fragment,e),o(re.$$.fragment,e),o(pe.$$.fragment,e),o(de.$$.fragment,e),o(he.$$.fragment,e),o(ue.$$.fragment,e),o(fe.$$.fragment,e),o($e.$$.fragment,e),o(Me.$$.fragment,e),o(ve.$$.fragment,e),o(ke.$$.fragment,e),o(je.$$.fragment,e),o(Je.$$.fragment,e),o(_e.$$.fragment,e),o(Ze.$$.fragment,e),o(Se.$$.fragment,e),Dt=!0)},o(e){m(b.$$.fragment,e),m(M.$$.fragment,e),m(T.$$.fragment,e),m(J.$$.fragment,e),m(_.$$.fragment,e),m(Z.$$.fragment,e),m(U.$$.fragment,e),m(z.$$.fragment,e),m(X.$$.fragment,e),m(x.$$.fragment,e),m(L.$$.fragment,e),m(Y.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(A.$$.fragment,e),m(O.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(le.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m($e.$$.fragment,e),m(Me.$$.fragment,e),m(ve.$$.fragment,e),m(ke.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(_e.$$.fragment,e),m(Ze.$$.fragment,e),m(Se.$$.fragment,e),Dt=!1},d(e){e&&(n(ze),n(Ue),n(Ce),n(He),n(Xe),n(w),n(xe),n(v),n(Be),n($),n(Le),n(k),n(Ye),n(qe),n(j),n(Fe),n(We),n(R),n(Ne),n(Ve),n(G),n(Ee),n(Pe),n(S),n(Qe),n(De),n(I),n(Ke),n(Ae),n(C),n(Oe),n(H),n(et),n(tt),n(nt),n(B),n(st),n(it),n(lt),n(q),n(at),n(F),n(rt),n(pt),n(N),n(ot),n(mt),n(E),n(dt),n(gt),n(Q),n(ht),n(ut),n(K),n(ct),n(ft),n(yt),n(ee),n($t),n(te),n(bt),n(Mt),n(se),n(wt),n(vt),n(kt),n(ae),n(Tt),n(jt),n(Jt),n(oe),n(Rt),n(me),n(_t),n(Gt),n(ge),n(Zt),n(St),n(Ut),n(ce),n(It),n(zt),n(ye),n(Ct),n(Ht),n(be),n(Xt),n(xt),n(we),n(Bt),n(Lt),n(Yt),n(Te),n(qt),n(Ft),n(Wt),n(Re),n(Nt),n(Vt),n(Ge),n(Et),n(Pt),n(Qt),n(Ie)),n(y),d(b,e),d(M,e),d(T,e),d(J,e),d(_,e),d(Z,e),d(U,e),d(z,e),d(X,e),d(x,e),d(L,e),d(Y,e),d(W,e),d(V,e),d(P,e),d(D,e),d(A,e),d(O,e),d(ne,e),d(ie,e),d(le,e),d(re,e),d(pe,e),d(de,e),d(he,e),d(ue,e),d(fe,e),d($e,e),d(Me,e),d(ve,e),d(ke,e),d(je,e),d(Je,e),d(_e,e),d(Ze,e),d(Se,e)}}}const Fn='{"title":"Ein Repository erstellen und verwalten","local":"ein-repository-erstellen-und-verwalten","sections":[{"title":"Erstellung und Löschung von Repos","local":"erstellung-und-löschung-von-repos","sections":[{"title":"Ein Repository erstellen","local":"ein-repository-erstellen","sections":[],"depth":3},{"title":"Ein Repository löschen","local":"ein-repository-löschen","sections":[],"depth":3},{"title":"Ein Repository duplizieren (nur für Spaces)","local":"ein-repository-duplizieren-nur-für-spaces","sections":[],"depth":3}],"depth":2},{"title":"Dateien hochladen und herunterladen","local":"dateien-hochladen-und-herunterladen","sections":[],"depth":2},{"title":"Branches und Tags","local":"branches-und-tags","sections":[{"title":"Branches und Tags erstellen","local":"branches-und-tags-erstellen","sections":[],"depth":3},{"title":"Alle Branches und Tags auflisten","local":"alle-branches-und-tags-auflisten","sections":[],"depth":3}],"depth":2},{"title":"Repository-Einstellungen ändern","local":"repository-einstellungen-ändern","sections":[{"title":"Sichtbarkeit aktualisieren","local":"sichtbarkeit-aktualisieren","sections":[],"depth":3},{"title":"Benennen Sie Ihr Repository um","local":"benennen-sie-ihr-repository-um","sections":[],"depth":3}],"depth":2},{"title":"Verwalten Sie eine lokale Kopie Ihres Repositories","local":"verwalten-sie-eine-lokale-kopie-ihres-repositories","sections":[{"title":"Verwenden eines lokalen Repositories","local":"verwenden-eines-lokalen-repositories","sections":[],"depth":3},{"title":"Klonen","local":"klonen","sections":[],"depth":3},{"title":"Branch","local":"branch","sections":[],"depth":3},{"title":"Pull","local":"pull","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wn(At){return Cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qn extends Hn{constructor(y){super(),Xn(this,y,Wn,qn,In,{})}}export{Qn as component};
