import{s as pn,n as hn,o as un}from"../chunks/scheduler.de5597d1.js";import{S as mn,i as cn,e as a,s as i,c as d,h as bn,a as r,d as t,b as l,f as dn,g as p,j as o,k as O,l as wn,m as s,n as h,t as u,o as m,p as c}from"../chunks/index.bf1177c2.js";import{C as Mn,H as q,E as yn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.7c37555a.js";import{C as ne}from"../chunks/CodeBlock.af63e669.js";function fn(Re){let b,te,K,se,k,ie,g,le,U,Fe='Webhooks sind ein Grundpfeiler für MLOps-bezogene Funktionen. Sie ermöglichen es Ihnen, auf neue Änderungen in bestimmten Repos oder auf alle Repos, die bestimmten Benutzern/Organisationen gehören, die Sie interessieren, zu hören. Dieser Leitfaden erklärt, wie Sie den <code>huggingface_hub</code> nutzen können, um einen Server zu erstellen, der auf Webhooks hört und ihn in einen Space zu implementieren. Es wird davon ausgegangen, dass Sie mit dem Konzept der Webhooks auf dem Huggingface Hub vertraut sind. Um mehr über Webhooks selbst zu erfahren, können Sie zuerst diesen <a href="https://huggingface.co/docs/hub/webhooks" rel="nofollow">Leitfaden</a> lesen.',ae,J,_e="Die Basis-Klasse, die wir in diesem Leitfaden verwenden werden, ist der <code>WebhooksServer()</code>. Es handelt sich um eine Klasse, mit der sich ein Server leicht konfigurieren lässt, der Webhooks vom Huggingface Hub empfangen kann. Der Server basiert auf einer Gradio-App. Er verfügt über eine Benutzeroberfläche zur Anzeige von Anweisungen für Sie oder Ihre Benutzer und eine API zum Hören auf Webhooks.",re,w,Qe='<p>Um ein Beispiel eines laufenden Webhook-Servers zu sehen, werfen Sie einen Blick auf den <a href="https://huggingface.co/spaces/spaces-ci-bot/webhook" rel="nofollow">Spaces CI Bot</a>. Es handelt sich um einen Space, der kurzlebige Umgebungen startet, wenn ein PR in einem Space geöffnet wird.</p>',oe,M,Le='<p>Dies ist ein <a href="../package_reference/environment_variables#hfhubdisableexperimentalwarning">experimentelles Feature</a>. Das bedeutet, dass wir noch daran arbeiten, die API zu verbessern. Es könnten in der Zukunft ohne vorherige Ankündigung Änderungen vorgenommen werden. Stellen Sie sicher, dass Sie die Version des <code>huggingface_hub</code> in Ihren Anforderungen festlegen.</p>',de,T,pe,S,Xe="Das Implementieren eines Webhook-Endpunkts ist so einfach wie das Dekorieren einer Funktion. Lassen Sie uns ein erstes Beispiel betrachten, um die Hauptkonzepte zu erklären:",he,j,ue,W,Ne="Speichern Sie diesen Ausschnitt in einer Datei namens <code>&#39;app.py&#39;</code> und führen Sie ihn mit <code>&#39;python app.py&#39;</code> aus. Sie sollten eine Nachricht wie diese sehen:",me,I,ce,v,xe="Gute Arbeit! Sie haben gerade einen Webhook-Server gestartet! Lassen Sie uns genau aufschlüsseln, was passiert ist:",be,B,De='<li>Durch das Dekorieren einer Funktion mit <code>webhook_endpoint()</code> wurde im Hintergrund ein <code>WebhooksServer()</code>-Objekt erstellt. Wie Sie sehen können, handelt es sich bei diesem Server um eine Gradio-App, die unter <a href="http://127.0.0.1:7860" rel="nofollow">http://127.0.0.1:7860</a> läuft. Wenn Sie diese URL in Ihrem Browser öffnen, sehen Sie eine Landing Page mit Anweisungen zu den registrierten Webhooks.</li> <li>Eine Gradio-App ist im Kern ein FastAPI-Server. Eine neue POST-Route <code>/webhooks/trigger_training</code> wurde hinzugefügt. Dies ist die Route, die auf Webhooks hört und die Funktion <code>trigger_training</code> ausführt, wenn sie ausgelöst wird. FastAPI wird das Payload automatisch parsen und es der Funktion als <code>WebhookPayload</code>-Objekt übergeben. Dies ist ein <code>pydantisches</code> Objekt, das alle Informationen über das Ereignis enthält, das den Webhook ausgelöst hat.</li> <li>Die Gradio-App hat auch einen Tunnel geöffnet, um Anfragen aus dem Internet zu empfangen. Das Interessante daran ist: Sie können einen Webhook auf <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a> konfigurieren, der auf Ihren lokalen Rechner zeigt. Dies ist nützlich zum Debuggen Ihres Webhook-Servers und zum schnellen Iterieren, bevor Sie ihn in einem Space bereitstellen.</li> <li>Schließlich teilen Ihnen die Logs auch mit, dass Ihr Server derzeit nicht durch ein Geheimnis gesichert ist. Dies ist für das lokale Debuggen nicht problematisch, sollte aber für später berücksichtigt werden.</li>',we,y,Pe="<p>Standardmäßig wird der Server am Ende Ihres Skripts gestartet. Wenn Sie es in einem Notizbuch ausführen, können Sie den Server manuell starten, indem Sie <code>decorated_function.run()</code> aufrufen. Da ein einzigartiger Server verwendet wird, müssen Sie den Server nur einmal starten, auch wenn Sie mehrere Endpunkte haben.</p>",Me,Z,ye,z,Ae=`Jetzt, da Sie einen Webhook-Server am Laufen haben, möchten Sie einen Webhook konfigurieren, um Nachrichten zu empfangen.
Gehen Sie zu <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>, klicken Sie auf “Add a new webhook” und konfigurieren Sie Ihren Webhook. Legen Sie die Ziel-Repositories fest, die Sie beobachten möchten, und die Webhook-URL, hier <code>https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training</code>.`,fe,f,qe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/configure_webhook.png"/>',ke,C,Oe="Und das war’s! Sie können den Webhook jetzt auslösen, indem Sie das Ziel-Repository aktualisieren (z.B. einen Commit pushen). Überprüfen Sie den Aktivitäts-Tab Ihres Webhooks, um die ausgelösten Ereignisse zu sehen. Jetzt, wo Sie eine funktionierende Einrichtung haben, können Sie sie testen und schnell iterieren. Wenn Sie Ihren Code ändern und den Server neu starten, könnte sich Ihre öffentliche URL ändern. Stellen Sie sicher, dass Sie die Webhook-Konfiguration im Hub bei Bedarf aktualisieren.",ge,G,Ue,H,Ke='Jetzt, da Sie einen funktionierenden Webhook-Server haben, ist das Ziel, ihn in einem Space bereitzustellen. Gehen Sie zu <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>, um einen Space zu erstellen. Geben Sie ihm einen Namen, wählen Sie das Gradio SDK und klicken Sie auf “Create Space”. Laden Sie Ihren Code in den Space in einer Datei namens <code>app.py</code> hoch. Ihr Space wird automatisch gestartet! Für weitere Informationen zu Spaces lesen Sie bitte diesen <a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">Leitfaden</a>.',Je,$,en='Ihr Webhook-Server läuft nun auf einem öffentlichen Space. In den meisten Fällen möchten Sie ihn mit einem Geheimnis absichern. Gehen Sie zu Ihren Space-Einstellungen &gt; Abschnitt “Repository secrets” &gt; “Add a secret”. Setzen Sie die Umgebungsvariable <code>WEBHOOK_SECRET</code> auf den von Ihnen gewählten Wert. Gehen Sie zurück zu den <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Webhook-Einstellungen</a> und setzen Sie das Geheimnis in der Webhook-Konfiguration. Jetzt werden von Ihrem Server nur Anfragen mit dem korrekten Geheimnis akzeptiert.',Te,Y,nn='Und das war’s! Ihr Space ist nun bereit, Webhooks vom Hub zu empfangen. Bitte beachten Sie, dass wenn Sie den Space auf einer kostenlosen ‘cpu-basic’ Hardware ausführen, er nach 48 Stunden Inaktivität heruntergefahren wird. Wenn Sie einen permanenten Space benötigen, sollten Sie in Erwägung ziehen, auf eine <a href="https://huggingface.co/docs/hub/spaces-gpus#hardware-specs" rel="nofollow">upgraded hardware</a> umzustellen.',Se,E,je,V,tn="Der obenstehende Leitfaden erklärte den schnellsten Weg, einen <code>WebhooksServer()</code> einzurichten. In diesem Abschnitt werden wir sehen, wie man ihn weiter anpassen kann.",We,R,Ie,F,sn="Sie können mehrere Endpunkte auf demselben Server registrieren. Beispielsweise möchten Sie vielleicht einen Endpunkt haben, um einen Trainingsjob auszulösen und einen anderen, um eine Modellevaluierung auszulösen. Dies können Sie tun, indem Sie mehrere <code>@webhook_endpoint</code>-Dekorateure hinzufügen:",ve,_,Be,Q,ln="Dies wird zwei Endpunkte erstellen:",Ze,L,ze,X,Ce,N,an='Um mehr Flexibilität zu erhalten, können Sie auch direkt ein <code>WebhooksServer()</code> Objekt erstellen. Dies ist nützlich, wenn Sie die Startseite Ihres Servers anpassen möchten. Sie können dies tun, indem Sie eine <a href="https://gradio.app/docs/#blocks" rel="nofollow">Gradio UI</a> übergeben, die die Standard-UI überschreibt. Zum Beispiel können Sie Anweisungen für Ihre Benutzer hinzufügen oder ein Formular zur manuellen Auslösung der Webhooks hinzufügen. Bei der Erstellung eines <code>WebhooksServer()</code> können Sie mit dem Dekorateur <code>add_webhook()</code> neue Webhooks registrieren.',Ge,x,rn="Hier ist ein vollständiges Beispiel:",He,D,$e,P,on="<li>Wir definieren eine benutzerdefinierte UI mit Gradio-Blöcken. Diese UI wird auf der Startseite des Servers angezeigt.</li> <li>Wir erstellen ein <code>WebhooksServer()</code>-Objekt mit einer benutzerdefinierten UI und einem Geheimnis. Das Geheimnis ist optional und kann mit der <code>WEBHOOK_SECRET</code> Umgebungsvariable gesetzt werden.</li> <li>Wir registrieren einen Webhook mit einem expliziten Namen. Dies wird einen Endpunkt unter <code>/webhooks/say_hello</code> erstellen.</li> <li>Wir registrieren einen Webhook mit einem impliziten Namen. Dies wird einen Endpunkt unter <code>/webhooks/goodbye</code> erstellen.</li> <li>Wir starten den Server. Dies ist optional, da Ihr Server automatisch am Ende des Skripts gestartet wird.</li>",Ye,A,Ee,ee,Ve;return k=new Mn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new q({props:{title:"Webhooks Server",local:"webhooks-server",headingTag:"h1"}}),T=new q({props:{title:"Einen Endpunkt erstellen",local:"einen-endpunkt-erstellen",headingTag:"h2"}}),j=new ne({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEVpbmVuJTIwVHJhaW5pbmdzam9iJTIwYXVzbCVDMyVCNnNlbiUyQyUyMHdlbm4lMjBlaW4lMjBEYXRlbnNhdHolMjBha3R1YWxpc2llcnQlMjB3aXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Einen Trainingsjob auslösen, wenn ein Datensatz aktualisiert wird</span>
        ...`,wrap:!1}}),I=new ne({props:{code:"V2ViaG9vayUyMHNlY3JldCUyMGlzJTIwbm90JTIwZGVmaW5lZC4lMjBUaGlzJTIwbWVhbnMlMjB5b3VyJTIwd2ViaG9vayUyMGVuZHBvaW50cyUyMHdpbGwlMjBiZSUyMG9wZW4lMjB0byUyMGV2ZXJ5b25lLiUwQVRvJTIwYWRkJTIwYSUyMHNlY3JldCUyQyUyMHNldCUyMCU2MFdFQkhPT0tfU0VDUkVUJTYwJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwb3IlMjBwYXNzJTIwaXQlMjBhdCUyMGluaXRpYWxpemF0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTYwYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIod2ViaG9va19zZWNyZXQlM0QnbXlfc2VjcmV0JyUyQyUyMC4uLiklNjAlMEFGb3IlMjBtb3JlJTIwZGV0YWlscyUyMGFib3V0JTIwd2ViaG9vayUyMHNlY3JldHMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZ3ZWJob29rcyUyM3dlYmhvb2stc2VjcmV0LiUwQVJ1bm5pbmclMjBvbiUyMGxvY2FsJTIwVVJMJTNBJTIwJTIwaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTc4NjAlMEFSdW5uaW5nJTIwb24lMjBwdWJsaWMlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRjFmYWRiMGY1MmQ4YmY4MjVmYy5ncmFkaW8ubGl2ZSUwQSUwQVRoaXMlMjBzaGFyZSUyMGxpbmslMjBleHBpcmVzJTIwaW4lMjA3MiUyMGhvdXJzLiUyMEZvciUyMGZyZWUlMjBwZXJtYW5lbnQlMjBob3N0aW5nJTIwYW5kJTIwR1BVJTIwdXBncmFkZXMlMjAoTkVXISklMkMlMjBjaGVjayUyMG91dCUyMFNwYWNlcyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMEElMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEFHbyUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGd2ViaG9va3MlMjB0byUyMHNldHVwJTIweW91ciUyMHdlYmhvb2tzLg==",highlighted:`Webhook secret is not defined. This means your webhook endpoints will be open to everyone.
To add a secret, set \`WEBHOOK_SECRET\` as environment variable or pass it at initialization:
        \`app = WebhooksServer(webhook_secret=&#x27;my_secret&#x27;, ...)\`
For more details about webhook secrets, please refer to https://huggingface.co/docs/hub/webhooks#webhook-secret.
Running on local URL:  http://127.0.0.1:7860
Running on public URL: https://1fadb0f52d8bf825fc.gradio.live

This share link expires in 72 hours. For free permanent hosting and GPU upgrades (NEW!), check out Spaces: https://huggingface.co/spaces

Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
Go to https://huggingface.co/settings/webhooks to setup your webhooks.`,wrap:!1}}),Z=new q({props:{title:"Konfigurieren eines Webhook",local:"konfigurieren-eines-webhook",headingTag:"h2"}}),G=new q({props:{title:"Bereitstellung in einem Space",local:"bereitstellung-in-einem-space",headingTag:"h2"}}),E=new q({props:{title:"Erweiterte Nutzung",local:"erweiterte-nutzung",headingTag:"h2"}}),R=new q({props:{title:"Mehrere Endpunkte",local:"mehrere-endpunkte",headingTag:"h3"}}),_=new ne({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEVpbmVuJTIwVHJhaW5pbmdzam9iJTIwYXVzbCVDMyVCNnNlbiUyQyUyMHdlbm4lMjBlaW4lMjBEYXRlbnNhdHolMjBha3R1YWxpc2llcnQlMjB3aXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTQwd2ViaG9va19lbmRwb2ludCUwQWFzeW5jJTIwZGVmJTIwdHJpZ2dlcl9ldmFsdWF0aW9uKHBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGF5bG9hZC5yZXBvLnR5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUyMGFuZCUyMHBheWxvYWQuZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTIwJTIydXBkYXRlJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRWluZW4lMjBFdmFsdWllcnVuZ3NhdWZ0cmFnJTIwYXVzbCVDMyVCNnNlbiUyQyUyMHdlbm4lMjBlaW4lMjBNb2RlbGwlMjBha3R1YWxpc2llcnQlMjB3aXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Einen Trainingsjob auslösen, wenn ein Datensatz aktualisiert wird</span>
        ...

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_evaluation</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Einen Evaluierungsauftrag auslösen, wenn ein Modell aktualisiert wird</span>
        ...`,wrap:!1}}),L=new ne({props:{code:"KC4uLiklMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEElMjAlMjAtJTIwUE9TVCUyMGh0dHBzJTNBJTJGJTJGMWZhZGIwZjUyZDhiZjgyNWZjLmdyYWRpby5saXZlJTJGd2ViaG9va3MlMkZ0cmlnZ2VyX2V2YWx1YXRpb24=",highlighted:`(...)
Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_evaluation`,wrap:!1}}),X=new q({props:{title:"Benutzerdefinierter Server",local:"benutzerdefinierter-server",headingTag:"h3"}}),D=new ne({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBXZWJob29rc1NlcnZlciUyQyUyMFdlYmhvb2tQYXlsb2FkJTBBJTBBJTIzJTIwMS4lMjBCZW51dHplcmRlZmluaWVydGUlMjBVSSUyMGRlZmluaWVyZW4lMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMHVpJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTIzJTIwMi4lMjBFcnN0ZWxsZW4lMjBlaW5lcyUyMFdlYmhvb2tzU2VydmVyJTIwbWl0JTIwYmVudXR6ZXJkZWZpbmllcnRlciUyMFVJJTIwdW5kJTIwR2VoZWltbmlzJTBBYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIodWklM0R1aSUyQyUyMHdlYmhvb2tfc2VjcmV0JTNEJTIybXlfc2VjcmV0X2tleSUyMiklMEElMEElMjMlMjAzLiUyMFdlYmhvb2slMjBtaXQlMjBleHBsaXppdGVtJTIwTmFtZW4lMjByZWdpc3RyaWVyZW4lMEElNDBhcHAuYWRkX3dlYmhvb2soJTIyJTJGc2F5X2hlbGxvJTIyKSUwQWFzeW5jJTIwZGVmJTIwaGVsbG8ocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJoZWxsbyUyMiU3RCUwQSUwQSUyMyUyMDQuJTIwV2ViaG9vayUyMG1pdCUyMGltcGxpeml0ZW0lMjBOYW1lbiUyMHJlZ2lzdHJpZXJlbmUlMEElNDBhcHAuYWRkX3dlYmhvb2slMEFhc3luYyUyMGRlZiUyMGdvb2RieWUocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJnb29kYnllJTIyJTdEJTBBJTBBJTIzJTIwNS4lMjBTZXJ2ZXIlMjBzdGFydGVuJTIwKG9wdGlvbmFsKSUwQWFwcC5ydW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> WebhooksServer, WebhookPayload

<span class="hljs-comment"># 1. Benutzerdefinierte UI definieren</span>
<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> ui:
    ...

<span class="hljs-comment"># 2. Erstellen eines WebhooksServer mit benutzerdefinierter UI und Geheimnis</span>
app = WebhooksServer(ui=ui, webhook_secret=<span class="hljs-string">&quot;my_secret_key&quot;</span>)

<span class="hljs-comment"># 3. Webhook mit explizitem Namen registrieren</span>
<span class="hljs-meta">@app.add_webhook(<span class="hljs-params"><span class="hljs-string">&quot;/say_hello&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">hello</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;hello&quot;</span>}

<span class="hljs-comment"># 4. Webhook mit implizitem Namen registrierene</span>
<span class="hljs-meta">@app.add_webhook</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">goodbye</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;goodbye&quot;</span>}

<span class="hljs-comment"># 5. Server starten (optional)</span>
app.run()`,wrap:!1}}),A=new yn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/webhooks_server.md"}}),{c(){b=a("meta"),te=i(),K=a("p"),se=i(),d(k.$$.fragment),ie=i(),d(g.$$.fragment),le=i(),U=a("p"),U.innerHTML=Fe,ae=i(),J=a("p"),J.innerHTML=_e,re=i(),w=a("blockquote"),w.innerHTML=Qe,oe=i(),M=a("blockquote"),M.innerHTML=Le,de=i(),d(T.$$.fragment),pe=i(),S=a("p"),S.textContent=Xe,he=i(),d(j.$$.fragment),ue=i(),W=a("p"),W.innerHTML=Ne,me=i(),d(I.$$.fragment),ce=i(),v=a("p"),v.textContent=xe,be=i(),B=a("ol"),B.innerHTML=De,we=i(),y=a("blockquote"),y.innerHTML=Pe,Me=i(),d(Z.$$.fragment),ye=i(),z=a("p"),z.innerHTML=Ae,fe=i(),f=a("div"),f.innerHTML=qe,ke=i(),C=a("p"),C.textContent=Oe,ge=i(),d(G.$$.fragment),Ue=i(),H=a("p"),H.innerHTML=Ke,Je=i(),$=a("p"),$.innerHTML=en,Te=i(),Y=a("p"),Y.innerHTML=nn,Se=i(),d(E.$$.fragment),je=i(),V=a("p"),V.innerHTML=tn,We=i(),d(R.$$.fragment),Ie=i(),F=a("p"),F.innerHTML=sn,ve=i(),d(_.$$.fragment),Be=i(),Q=a("p"),Q.textContent=ln,Ze=i(),d(L.$$.fragment),ze=i(),d(X.$$.fragment),Ce=i(),N=a("p"),N.innerHTML=an,Ge=i(),x=a("p"),x.textContent=rn,He=i(),d(D.$$.fragment),$e=i(),P=a("ol"),P.innerHTML=on,Ye=i(),d(A.$$.fragment),Ee=i(),ee=a("p"),this.h()},l(e){const n=bn("svelte-u9bgzb",document.head);b=r(n,"META",{name:!0,content:!0}),n.forEach(t),te=l(e),K=r(e,"P",{}),dn(K).forEach(t),se=l(e),p(k.$$.fragment,e),ie=l(e),p(g.$$.fragment,e),le=l(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-syi17b"&&(U.innerHTML=Fe),ae=l(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-16brqny"&&(J.innerHTML=_e),re=l(e),w=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-iqtm77"&&(w.innerHTML=Qe),oe=l(e),M=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(M)!=="svelte-f7fpc7"&&(M.innerHTML=Le),de=l(e),p(T.$$.fragment,e),pe=l(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-dy9hz4"&&(S.textContent=Xe),he=l(e),p(j.$$.fragment,e),ue=l(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1udi1nb"&&(W.innerHTML=Ne),me=l(e),p(I.$$.fragment,e),ce=l(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1tlyxs6"&&(v.textContent=xe),be=l(e),B=r(e,"OL",{"data-svelte-h":!0}),o(B)!=="svelte-wf7tf8"&&(B.innerHTML=De),we=l(e),y=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-qsm983"&&(y.innerHTML=Pe),Me=l(e),p(Z.$$.fragment,e),ye=l(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-celrz4"&&(z.innerHTML=Ae),fe=l(e),f=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-9ld38f"&&(f.innerHTML=qe),ke=l(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-l7w1xv"&&(C.textContent=Oe),ge=l(e),p(G.$$.fragment,e),Ue=l(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1ncmk3a"&&(H.innerHTML=Ke),Je=l(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1nxol3z"&&($.innerHTML=en),Te=l(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1e7nrwh"&&(Y.innerHTML=nn),Se=l(e),p(E.$$.fragment,e),je=l(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-8cnaqu"&&(V.innerHTML=tn),We=l(e),p(R.$$.fragment,e),Ie=l(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1kzmtha"&&(F.innerHTML=sn),ve=l(e),p(_.$$.fragment,e),Be=l(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-biux1g"&&(Q.textContent=ln),Ze=l(e),p(L.$$.fragment,e),ze=l(e),p(X.$$.fragment,e),Ce=l(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-5oiksx"&&(N.innerHTML=an),Ge=l(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-qjuq0f"&&(x.textContent=rn),He=l(e),p(D.$$.fragment,e),$e=l(e),P=r(e,"OL",{"data-svelte-h":!0}),o(P)!=="svelte-styu22"&&(P.innerHTML=on),Ye=l(e),p(A.$$.fragment,e),Ee=l(e),ee=r(e,"P",{}),dn(ee).forEach(t),this.h()},h(){O(b,"name","hf:doc:metadata"),O(b,"content",kn),O(w,"class","tip"),O(M,"class","warning"),O(y,"class","warning"),O(f,"class","flex justify-center")},m(e,n){wn(document.head,b),s(e,te,n),s(e,K,n),s(e,se,n),h(k,e,n),s(e,ie,n),h(g,e,n),s(e,le,n),s(e,U,n),s(e,ae,n),s(e,J,n),s(e,re,n),s(e,w,n),s(e,oe,n),s(e,M,n),s(e,de,n),h(T,e,n),s(e,pe,n),s(e,S,n),s(e,he,n),h(j,e,n),s(e,ue,n),s(e,W,n),s(e,me,n),h(I,e,n),s(e,ce,n),s(e,v,n),s(e,be,n),s(e,B,n),s(e,we,n),s(e,y,n),s(e,Me,n),h(Z,e,n),s(e,ye,n),s(e,z,n),s(e,fe,n),s(e,f,n),s(e,ke,n),s(e,C,n),s(e,ge,n),h(G,e,n),s(e,Ue,n),s(e,H,n),s(e,Je,n),s(e,$,n),s(e,Te,n),s(e,Y,n),s(e,Se,n),h(E,e,n),s(e,je,n),s(e,V,n),s(e,We,n),h(R,e,n),s(e,Ie,n),s(e,F,n),s(e,ve,n),h(_,e,n),s(e,Be,n),s(e,Q,n),s(e,Ze,n),h(L,e,n),s(e,ze,n),h(X,e,n),s(e,Ce,n),s(e,N,n),s(e,Ge,n),s(e,x,n),s(e,He,n),h(D,e,n),s(e,$e,n),s(e,P,n),s(e,Ye,n),h(A,e,n),s(e,Ee,n),s(e,ee,n),Ve=!0},p:hn,i(e){Ve||(u(k.$$.fragment,e),u(g.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(I.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(E.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),u(L.$$.fragment,e),u(X.$$.fragment,e),u(D.$$.fragment,e),u(A.$$.fragment,e),Ve=!0)},o(e){m(k.$$.fragment,e),m(g.$$.fragment,e),m(T.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m(_.$$.fragment,e),m(L.$$.fragment,e),m(X.$$.fragment,e),m(D.$$.fragment,e),m(A.$$.fragment,e),Ve=!1},d(e){e&&(t(te),t(K),t(se),t(ie),t(le),t(U),t(ae),t(J),t(re),t(w),t(oe),t(M),t(de),t(pe),t(S),t(he),t(ue),t(W),t(me),t(ce),t(v),t(be),t(B),t(we),t(y),t(Me),t(ye),t(z),t(fe),t(f),t(ke),t(C),t(ge),t(Ue),t(H),t(Je),t($),t(Te),t(Y),t(Se),t(je),t(V),t(We),t(Ie),t(F),t(ve),t(Be),t(Q),t(Ze),t(ze),t(Ce),t(N),t(Ge),t(x),t(He),t($e),t(P),t(Ye),t(Ee),t(ee)),t(b),c(k,e),c(g,e),c(T,e),c(j,e),c(I,e),c(Z,e),c(G,e),c(E,e),c(R,e),c(_,e),c(L,e),c(X,e),c(D,e),c(A,e)}}}const kn='{"title":"Webhooks Server","local":"webhooks-server","sections":[{"title":"Einen Endpunkt erstellen","local":"einen-endpunkt-erstellen","sections":[],"depth":2},{"title":"Konfigurieren eines Webhook","local":"konfigurieren-eines-webhook","sections":[],"depth":2},{"title":"Bereitstellung in einem Space","local":"bereitstellung-in-einem-space","sections":[],"depth":2},{"title":"Erweiterte Nutzung","local":"erweiterte-nutzung","sections":[{"title":"Mehrere Endpunkte","local":"mehrere-endpunkte","sections":[],"depth":3},{"title":"Benutzerdefinierter Server","local":"benutzerdefinierter-server","sections":[],"depth":3}],"depth":2}],"depth":1}';function gn(Re){return un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jn extends mn{constructor(b){super(),cn(this,b,gn,fn,pn,{})}}export{jn as component};
