import{s as xe,n as qe,o as Le}from"../chunks/scheduler.de5597d1.js";import{S as Qe,i as Ne,e as i,s as n,c,h as Ae,a as p,d as t,b as l,f as N,g as o,j as r,k as _e,l as m,m as a,n as d,t as h,o as u,p as y}from"../chunks/index.bf1177c2.js";import{C as De,H as we,E as Pe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.7c37555a.js";import{C as A}from"../chunks/CodeBlock.af63e669.js";function Ke(Ie){let g,K,D,O,j,ee,J,se,b,$e='Zusätzlich zur <code>HfApi</code> bietet die <code>huggingface_hub</code> Bibliothek <code>HfFileSystem</code>, eine pythonische, <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-kompatible</a> Dateischnittstelle zum Hugging Face Hub. Das <code>HfFileSystem</code> basiert auf der <code>HfApi</code> und bietet typische Dateisystemoperationen wie <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, und <code>put_file</code>.',te,w,ae,U,ne,T,ve="Das optionale Argument <code>revision</code> kann übergeben werden, um eine Operation von einem spezifischen Commit auszuführen, wie z.B. einem Branch, Tag-Namen oder einem Commit-Hash.",le,Z,ze="Anders als bei Pythons eingebautem <code>open</code>, ist der Standardmodus von <code>fsspec</code>’s <code>open</code> binär, <code>&quot;rb&quot;</code>. Das bedeutet, dass Sie den Modus explizit auf <code>&quot;r&quot;</code> zum Lesen und <code>&quot;w&quot;</code> zum Schreiben im Textmodus setzen müssen. Das Anhängen an eine Datei (Modi <code>&quot;a&quot;</code> und <code>&quot;ab&quot;</code>) wird noch nicht unterstützt.",ie,G,pe,k,Se="Das <code>HfFileSystem</code> kann mit jeder Bibliothek verwendet werden, die <code>fsspec</code> integriert, vorausgesetzt die URL folgt dem Schema:",me,R,re,I,We="Der <code>repo_type_prefix</code> ist <code>datasets/</code> für Datensätze, <code>spaces/</code> für Spaces, und Modelle benötigen kein Präfix in der URL.",ce,$,Xe="Einige interessante Integrationen, bei denen <code>HfFileSystem</code> die Interaktion mit dem Hub vereinfacht, sind unten aufgeführt:",oe,M,f,C,Ee='Lesen/Schreiben eines <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame aus/in ein Hub-Repository:',Ue,v,Te,_,Fe='Der gleiche Arbeitsablauf kann auch für  <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> und <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> verwendet werden.',Ze,z,x,Ve='Abfrage von (entfernten) Hub-Dateien mit  <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',Ge,S,ke,W,q,He='Verwendung des Hub als Array-Speicher mit <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Re,X,de,E,he,F,Ye='In vielen Fällen müssen Sie mit einem Hugging Face-Konto angemeldet sein, um mit dem Hub zu interagieren. Lesen Sie den <a href="../quick-start#login">Login</a>-Abschnitt der Dokumentation, um mehr über Authentifizierungsmethoden auf dem Hub zu erfahren.',ue,V,Be="Es ist auch möglich, sich programmatisch anzumelden, indem Sie Ihr <code>token</code> als Argument an <code>HfFileSystem</code> übergeben:",ye,H,Me,Y,Ce="Wenn Sie sich auf diese Weise anmelden, seien Sie vorsichtig, das Token nicht versehentlich zu veröffentlichen, wenn Sie Ihren Quellcode teilen!",ge,B,fe,P,je;return j=new De({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new we({props:{title:"Interagieren mit dem Hub über die Filesystem API",local:"interagieren-mit-dem-hub-über-die-filesystem-api",headingTag:"h1"}}),w=new we({props:{title:"Verwendung",local:"verwendung",headingTag:"h2"}}),U=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBBbGxlJTIwRGF0ZWllbiUyMGluJTIwZWluZW0lMjBWZXJ6ZWljaG5pcyUyMGF1Zmxpc3RlbiUwQWZzLmxzKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTIyJTJDJTIwZGV0YWlsJTNERmFsc2UpJTBBJTBBJTIzJTIwQWxsZSUyMCUyMi5jc3YlMjItRGF0ZWllbiUyMGluJTIwZWluZW0lMjBSZXBvJTIwYXVmbGlzdGVuJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiouY3N2JTIyKSUwQSUwQSUyMyUyMEVpbmUlMjBlbnRmZXJudGUlMjBEYXRlaSUyMGxlc2VuJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGElMjAlM0QlMjBmLnJlYWRsaW5lcygpJTBBJTBBJTIzJTIwRGVuJTIwSW5oYWx0JTIwZWluZXIlMjBlbnRmZXJudGVuJTIwRGF0ZWklMjBhbHMlMjBaZWljaGVua2V0dGUlMjAlMkYlMjBTdHJpbmclMjBsZXNlbiUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjBFaW5lJTIwZW50ZmVybnRlJTIwRGF0ZWklMjBzY2hyZWliZW4lMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnZhbGlkYXRpb24uY3N2JTIyJTJDJTIwJTIydyUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnRleHQlMkNsYWJlbCUyMiklMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMkZhbnRhc3RpYyUyMG1vdmllISUyQ2dvb2QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Alle Dateien in einem Verzeichnis auflisten</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Alle &quot;.csv&quot;-Dateien in einem Repo auflisten</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Den Inhalt einer entfernten Datei als Zeichenkette / String lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),G=new we({props:{title:"Integrationen",local:"integrationen",headingTag:"h2"}}),R=new A({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGZhZCUyRmltJTJGcmVwbyUzRQ==",highlighted:'hf://[<span class="hljs-attribute">&lt;repo_type_prefix&gt;</span>]<span class="hljs-attribute">&lt;repo_id&gt;</span>[@<span class="hljs-attribute">&lt;revision&gt;</span>]/<span class="hljs-attribute">&lt;pfad/im/repo&gt;</span>',wrap:!1}}),v=new A({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMEVpbmUlMjBlbnRmZXJudGUlMjBDU1YtRGF0ZWklMjBpbiUyMGVpbmVuJTIwRGF0YUZyYW1lJTIwbGVzZW4lMEFkZiUyMCUzRCUyMHBkLnJlYWRfY3N2KCUyMmhmJTNBJTJGJTJGZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRnRyYWluLmNzdiUyMiklMEElMEElMjMlMjBFaW5lbiUyMERhdGFGcmFtZSUyMGluJTIwZWluZSUyMGVudGZlcm50ZSUyMENTVi1EYXRlaSUyMHNjaHJlaWJlbiUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte CSV-Datei in einen DataFrame lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Einen DataFrame in eine entfernte CSV-Datei schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),S=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBFaW5lJTIwZW50ZmVybnRlJTIwRGF0ZWklMjBhYmZyYWdlbiUyMHVuZCUyMGRhcyUyMEVyZ2VibmlzJTIwYWxzJTIwRGF0YUZyYW1lJTIwenVyJUMzJUJDY2tiZWtvbW1lbiUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei abfragen und das Ergebnis als DataFrame zurückbekommen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),X=new A({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBFaW4lMjBBcnJheSUyMGluJTIwZWluJTIwUmVwbyUyMHNjaHJlaWJlbiUwQXdpdGglMjB6YXJyLm9wZW5fZ3JvdXAoJTIyaGYlM0ElMkYlMkZteS11c2VybmFtZSUyRm15LW1vZGVsLXJlcG8lMkZhcnJheS1zdG9yZSUyMiUyQyUyMG1vZGUlM0QlMjJ3JTIyKSUyMGFzJTIwcm9vdCUzQSUwQSUyMCUyMCUyMGZvbyUyMCUzRCUyMHJvb3QuY3JlYXRlX2dyb3VwKCUyMmVtYmVkZGluZ3MlMjIpJTBBJTIwJTIwJTIwZm9vYmFyJTIwJTNEJTIwZm9vLnplcm9zKCdleHBlcmltZW50XzAnJTJDJTIwc2hhcGUlM0QoNTAwMDAlMkMlMjAxMDAwKSUyQyUyMGNodW5rcyUzRCgxMDAwMCUyQyUyMDEwMDApJTJDJTIwZHR5cGUlM0QnZjQnKSUwQSUyMCUyMCUyMGZvb2JhciU1QiUzQSU1RCUyMCUzRCUyMGVtYmVkZGluZ3MlMEElMEElMjMlMjBFaW4lMjBBcnJheSUyMGF1cyUyMGVpbmVtJTIwUmVwbyUyMGxlc2VuJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Ein Array in ein Repo schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Ein Array aus einem Repo lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),E=new we({props:{title:"Authentifizierung",local:"authentifizierung",headingTag:"h2"}}),H=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),B=new Pe({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/hf_file_system.md"}}),{c(){g=i("meta"),K=n(),D=i("p"),O=n(),c(j.$$.fragment),ee=n(),c(J.$$.fragment),se=n(),b=i("p"),b.innerHTML=$e,te=n(),c(w.$$.fragment),ae=n(),c(U.$$.fragment),ne=n(),T=i("p"),T.innerHTML=ve,le=n(),Z=i("p"),Z.innerHTML=ze,ie=n(),c(G.$$.fragment),pe=n(),k=i("p"),k.innerHTML=Se,me=n(),c(R.$$.fragment),re=n(),I=i("p"),I.innerHTML=We,ce=n(),$=i("p"),$.innerHTML=Xe,oe=n(),M=i("ul"),f=i("li"),C=i("p"),C.innerHTML=Ee,Ue=n(),c(v.$$.fragment),Te=n(),_=i("p"),_.innerHTML=Fe,Ze=n(),z=i("li"),x=i("p"),x.innerHTML=Ve,Ge=n(),c(S.$$.fragment),ke=n(),W=i("li"),q=i("p"),q.innerHTML=He,Re=n(),c(X.$$.fragment),de=n(),c(E.$$.fragment),he=n(),F=i("p"),F.innerHTML=Ye,ue=n(),V=i("p"),V.innerHTML=Be,ye=n(),c(H.$$.fragment),Me=n(),Y=i("p"),Y.textContent=Ce,ge=n(),c(B.$$.fragment),fe=n(),P=i("p"),this.h()},l(e){const s=Ae("svelte-u9bgzb",document.head);g=p(s,"META",{name:!0,content:!0}),s.forEach(t),K=l(e),D=p(e,"P",{}),N(D).forEach(t),O=l(e),o(j.$$.fragment,e),ee=l(e),o(J.$$.fragment,e),se=l(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-18w92na"&&(b.innerHTML=$e),te=l(e),o(w.$$.fragment,e),ae=l(e),o(U.$$.fragment,e),ne=l(e),T=p(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-3z26mg"&&(T.innerHTML=ve),le=l(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-tbpook"&&(Z.innerHTML=ze),ie=l(e),o(G.$$.fragment,e),pe=l(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-eeqd0a"&&(k.innerHTML=Se),me=l(e),o(R.$$.fragment,e),re=l(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-967d81"&&(I.innerHTML=We),ce=l(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-wufznp"&&($.innerHTML=Xe),oe=l(e),M=p(e,"UL",{});var L=N(M);f=p(L,"LI",{});var Q=N(f);C=p(Q,"P",{"data-svelte-h":!0}),r(C)!=="svelte-5rmyjs"&&(C.innerHTML=Ee),Ue=l(Q),o(v.$$.fragment,Q),Te=l(Q),_=p(Q,"P",{"data-svelte-h":!0}),r(_)!=="svelte-11g4kom"&&(_.innerHTML=Fe),Q.forEach(t),Ze=l(L),z=p(L,"LI",{});var Je=N(z);x=p(Je,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1j784ud"&&(x.innerHTML=Ve),Ge=l(Je),o(S.$$.fragment,Je),Je.forEach(t),ke=l(L),W=p(L,"LI",{});var be=N(W);q=p(be,"P",{"data-svelte-h":!0}),r(q)!=="svelte-guwc20"&&(q.innerHTML=He),Re=l(be),o(X.$$.fragment,be),be.forEach(t),L.forEach(t),de=l(e),o(E.$$.fragment,e),he=l(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-aphqiq"&&(F.innerHTML=Ye),ue=l(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1enyw3z"&&(V.innerHTML=Be),ye=l(e),o(H.$$.fragment,e),Me=l(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-16usaea"&&(Y.textContent=Ce),ge=l(e),o(B.$$.fragment,e),fe=l(e),P=p(e,"P",{}),N(P).forEach(t),this.h()},h(){_e(g,"name","hf:doc:metadata"),_e(g,"content",Oe)},m(e,s){m(document.head,g),a(e,K,s),a(e,D,s),a(e,O,s),d(j,e,s),a(e,ee,s),d(J,e,s),a(e,se,s),a(e,b,s),a(e,te,s),d(w,e,s),a(e,ae,s),d(U,e,s),a(e,ne,s),a(e,T,s),a(e,le,s),a(e,Z,s),a(e,ie,s),d(G,e,s),a(e,pe,s),a(e,k,s),a(e,me,s),d(R,e,s),a(e,re,s),a(e,I,s),a(e,ce,s),a(e,$,s),a(e,oe,s),a(e,M,s),m(M,f),m(f,C),m(f,Ue),d(v,f,null),m(f,Te),m(f,_),m(M,Ze),m(M,z),m(z,x),m(z,Ge),d(S,z,null),m(M,ke),m(M,W),m(W,q),m(W,Re),d(X,W,null),a(e,de,s),d(E,e,s),a(e,he,s),a(e,F,s),a(e,ue,s),a(e,V,s),a(e,ye,s),d(H,e,s),a(e,Me,s),a(e,Y,s),a(e,ge,s),d(B,e,s),a(e,fe,s),a(e,P,s),je=!0},p:qe,i(e){je||(h(j.$$.fragment,e),h(J.$$.fragment,e),h(w.$$.fragment,e),h(U.$$.fragment,e),h(G.$$.fragment,e),h(R.$$.fragment,e),h(v.$$.fragment,e),h(S.$$.fragment,e),h(X.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(B.$$.fragment,e),je=!0)},o(e){u(j.$$.fragment,e),u(J.$$.fragment,e),u(w.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(R.$$.fragment,e),u(v.$$.fragment,e),u(S.$$.fragment,e),u(X.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(B.$$.fragment,e),je=!1},d(e){e&&(t(K),t(D),t(O),t(ee),t(se),t(b),t(te),t(ae),t(ne),t(T),t(le),t(Z),t(ie),t(pe),t(k),t(me),t(re),t(I),t(ce),t($),t(oe),t(M),t(de),t(he),t(F),t(ue),t(V),t(ye),t(Me),t(Y),t(ge),t(fe),t(P)),t(g),y(j,e),y(J,e),y(w,e),y(U,e),y(G,e),y(R,e),y(v),y(S),y(X),y(E,e),y(H,e),y(B,e)}}}const Oe='{"title":"Interagieren mit dem Hub über die Filesystem API","local":"interagieren-mit-dem-hub-über-die-filesystem-api","sections":[{"title":"Verwendung","local":"verwendung","sections":[],"depth":2},{"title":"Integrationen","local":"integrationen","sections":[],"depth":2},{"title":"Authentifizierung","local":"authentifizierung","sections":[],"depth":2}],"depth":1}';function es(Ie){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Qe{constructor(g){super(),Ne(this,g,es,Ke,xe,{})}}export{ls as component};
