import{s as vt,n as Zt,o as It}from"../chunks/scheduler.de5597d1.js";import{S as Ut,i as Wt,e as a,s as i,c as o,h as St,a as r,d as n,b as l,f as Tt,g as c,j as d,k as re,l as _t,m as s,n as u,t as g,o as h,p as f}from"../chunks/index.bf1177c2.js";import{C as xt,H as p,E as Jt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.7c37555a.js";import{C as $}from"../chunks/CodeBlock.af63e669.js";function Gt(nt){let m,ce,de,ue,C,ge,z,he,j,st="Inferenz ist der Prozess, bei dem ein trainiertes Modell verwendet wird, um Vorhersagen für neue Daten zu treffen. Da dieser Prozess rechenintensiv sein kann, kann die Ausführung auf einem dedizierten Server eine interessante Option sein. Die <code>huggingface_hub</code> Bibliothek bietet eine einfache Möglichkeit, einen Dienst aufzurufen, der die Inferenz für gehostete Modelle durchführt. Es gibt mehrere Dienste, mit denen Sie sich verbinden können:",fe,T,it='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inferenz API</a>: ein Service, der Ihnen ermöglicht, beschleunigte Inferenz auf der Infrastruktur von Hugging Face kostenlos auszuführen. Dieser Service ist eine schnelle Möglichkeit, um anzufangen, verschiedene Modelle zu testen und AI-Produkte zu prototypisieren.</li> <li><a href="https://huggingface.co/inference-endpoints/index" rel="nofollow">Inferenz Endpunkte</a>: ein Produkt zur einfachen Bereitstellung von Modellen im Produktivbetrieb. Die Inferenz wird von Hugging Face in einer dedizierten, vollständig verwalteten Infrastruktur auf einem Cloud-Anbieter Ihrer Wahl durchgeführt.</li>',pe,b,lt='<p><code>InferenceClient</code> ist ein Python-Client, der HTTP-Anfragen an unsere APIs stellt. Wenn Sie die HTTP-Anfragen direkt mit Ihrem bevorzugten Tool (curl, postman,…) durchführen möchten, lesen Sie bitte die Dokumentationsseiten der <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inferenz API</a> oder der <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inferenz Endpunkte</a>.</p> <p>Für die Webentwicklung wurde ein <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS-Client</a> veröffentlicht. Wenn Sie sich für die Spieleentwicklung interessieren, sollten Sie einen Blick auf unser <a href="https://github.com/huggingface/unity-api" rel="nofollow">C#-Projekt</a> werfen.</p>',me,v,be,Z,at="Los geht’s mit einer Text-zu-Bild-Aufgabe:",we,I,Me,U,rt='Wir haben einen <code>InferenceClient</code> mit den Standardparametern initialisiert. Das Einzige, was Sie wissen müssen, ist die <a href="#unterst%C3%BCtzte-aufgaben">Aufgabe</a>, die Sie ausführen möchten. Standardmäßig wird der Client sich mit der Inferenz API verbinden und ein Modell auswählen, um die Aufgabe abzuschließen. In unserem Beispiel haben wir ein Bild aus einem Textprompt generiert. Der zurückgegebene Wert ist ein <code>PIL.Image</code>-Objekt, das in eine Datei gespeichert werden kann.',ye,w,dt='<p>Die API ist darauf ausgelegt, einfach zu sein. Nicht alle Parameter und Optionen sind für den Endbenutzer verfügbar oder beschrieben. Schauen Sie auf <a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">dieser Seite</a> nach, wenn Sie mehr über alle verfügbaren Parameter für jede Aufgabe erfahren möchten.</p>',ke,W,$e,S,ot="Was ist, wenn Sie ein bestimmtes Modell verwenden möchten? Sie können es entweder als Parameter angeben oder direkt auf Instanzebene spezifizieren:",Ce,_,ze,M,ct='<p>Es gibt mehr als 200k Modelle im Hugging Face Hub! Jede Aufgabe im <code>InferenceClient</code> kommt mit einem empfohlenen Modell. Beachten Sie, dass die HF-Empfehlung sich im Laufe der Zeit ohne vorherige Ankündigung ändern kann. Daher ist es am besten, ein Modell explizit festzulegen, sobald Sie sich entschieden haben. In den meisten Fällen werden Sie daran interessiert sein, ein Modell zu finden, das speziell auf <em>Ihre</em> Bedürfnisse zugeschnitten ist. Besuchen Sie die <a href="https://huggingface.co/models" rel="nofollow">Modelle</a>-Seite im Hub, um Ihre Möglichkeiten zu erkunden.</p>',je,x,Te,J,ut='Die oben gesehenen Beispiele nutzen die kostenfrei gehostete Inferenz API. Dies erweist sich als sehr nützlich für Prototyping und schnelles Testen. Wenn Sie bereit sind, Ihr Modell in die Produktion zu übernehmen, müssen Sie eine dedizierte Infrastruktur verwenden. Hier kommen <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inferenz Endpunkte</a> ins Spiel. Es ermöglicht Ihnen, jedes Modell zu implementieren und als private API freizugeben. Nach der Implementierung erhalten Sie eine URL, zu der Sie mit genau dem gleichen Code wie zuvor eine Verbindung herstellen können, wobei nur der <code>Modell</code>-Parameter geändert wird:',ve,G,Ze,L,Ie,E,gt='Aufrufe, die mit dem <code>InferenceClient</code> gemacht werden, können mit einem <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a> authentifiziert werden. Standardmäßig wird das auf Ihrem Computer gespeicherte Token verwendet, wenn Sie angemeldet sind (sehen Sie hier, <a href="https://huggingface.co/docs/huggingface_hub/quick-start#login" rel="nofollow">wie Sie sich anmelden können</a>). Wenn Sie nicht angemeldet sind, können Sie Ihr Token als Instanzparameter übergeben:',Ue,V,We,y,ht="<p>Die Authentifizierung ist NICHT zwingend erforderlich, wenn Sie die Inferenz API verwenden. Authentifizierte Benutzer erhalten jedoch ein höheres kostenloses Kontingent, um mit dem Service zu arbeiten. Ein Token ist auch zwingend erforderlich, wenn Sie Inferenz auf Ihren privaten Modellen oder auf privaten Endpunkten ausführen möchten.</p>",Se,A,_e,B,ft="Das Ziel von <code>InferenceClient</code> ist es, die einfachste Schnittstelle zum Ausführen von Inferenzen auf Hugging Face-Modellen bereitzustellen. Es verfügt über eine einfache API, die die gebräuchlichsten Aufgaben unterstützt. Hier ist eine Liste der derzeit unterstützten Aufgaben:",xe,H,pt='<thead><tr><th>Domäne</th> <th>Aufgabe</th> <th>Unterstützt</th> <th>Dokumentation</th></tr></thead> <tbody><tr><td>Audio</td> <td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td>✅</td> <td><code>audio_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td>✅</td> <td><code>automatic_speech_recognition()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td>✅</td> <td><code>text_to_speech()</code></td></tr> <tr><td>Computer Vision</td> <td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td>✅</td> <td><code>image_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td>✅</td> <td><code>image_segmentation()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td>✅</td> <td><code>image_to_image()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td>✅</td> <td><code>image_to_text()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td>✅</td> <td><code>object_detection()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td>✅</td> <td><code>text_to_image()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot-Image-Classification</a></td> <td>✅</td> <td><code>zero_shot_image_classification()</code></td></tr> <tr><td>Multimodal</td> <td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Documentation Question Answering</a></td> <td>✅</td> <td><code>document_question_answering()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td>✅</td> <td><code>visual_question_answering()</code></td></tr> <tr><td>NLP</td> <td><a href="https://huggingface.co/tasks/conversational" rel="nofollow">Conversational</a></td> <td>✅</td> <td><code>~InferenceClient.conversational</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td>✅</td> <td><code>feature_extraction()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill Mask</a></td> <td>✅</td> <td><code>fill_mask()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td>✅</td> <td><code>question_answering()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td>✅</td> <td><code>sentence_similarity()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td>✅</td> <td><code>summarization()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td>✅</td> <td><code>table_question_answering()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td>✅</td> <td><code>text_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/text-generation" rel="nofollow">Text Generation</a></td> <td>✅</td> <td><code>text_generation()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td>✅</td> <td><code>token_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td>✅</td> <td><code>translation()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero Shot Classification</a></td> <td>✅</td> <td><code>zero_shot_classification()</code></td></tr> <tr><td>Tabular</td> <td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>✅</td> <td><code>tabular_classification()</code></td></tr> <tr><td></td> <td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>✅</td> <td><code>tabular_regression()</code></td></tr></tbody>',Je,k,mt='<p>Schauen Sie sich die <a href="https://huggingface.co/tasks" rel="nofollow">Aufgaben</a>-Seite an, um mehr über jede Aufgabe zu erfahren, wie man sie verwendet und die beliebtesten Modelle für jede Aufgabe.</p>',Ge,q,Le,N,bt="Eine asynchrone Version des Clients wird ebenfalls bereitgestellt, basierend auf <code>asyncio</code> und <code>aiohttp</code>. Sie können entweder <code>aiohttp</code> direkt installieren oder das <code>[inference]</code> Extra verwenden:",Ee,P,Ve,F,wt="Nach der Installation sind alle asynchronen API-Endpunkte über <code>AsyncInferenceClient</code> verfügbar. Seine Initialisierung und APIs sind genau gleich wie die synchronisierte Version.",Ae,Q,Be,R,Mt='Für weitere Informationen zum <code>asyncio</code>-Modul konsultieren Sie bitte die <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">offizielle Dokumentation</a>.',He,Y,qe,D,yt="Im obigen Abschnitt haben wir die Hauptaspekte von <code>InferenceClient</code> betrachtet. Lassen Sie uns in einige fortgeschrittene Tipps eintauchen.",Ne,X,Pe,K,kt="Bei der Inferenz gibt es zwei Hauptursachen für eine Zeitüberschreitung:",Fe,O,$t="<li>Der Inferenzprozess dauert lange, um abgeschlossen zu werden.</li> <li>Das Modell ist nicht verfügbar, beispielsweise wenn die Inferenz API es zum ersten Mal lädt.</li>",Qe,ee,Ct="Der <code>InferenceClient</code> verfügt über einen globalen Zeitüberschreitungsparameter (<code>timeout</code>), um diese beiden Aspekte zu behandeln. Standardmäßig ist er auf <code>None</code> gesetzt, was bedeutet, dass der Client unendlich lange auf den Abschluss der Inferenz warten wird. Wenn Sie mehr Kontrolle in Ihrem Arbeitsablauf wünschen, können Sie ihn auf einen bestimmten Wert in Sekunden setzen. Wenn die Zeitüberschreitungsverzögerung abläuft, wird ein <code>InferenceTimeoutError</code> ausgelöst. Sie können diesen Fehler abfangen und in Ihrem Code behandeln:",Re,te,Ye,ne,De,se,zt="Einige Aufgaben erfordern binäre Eingaben, zum Beispiel bei der Arbeit mit Bildern oder Audiodateien. In diesem Fall versucht der [`InferenceClient] so permissiv wie möglich zu sein und akzeptiert verschiedene Typen:",Xe,ie,jt="<li>rohe <code>Bytes</code></li> <li>ein Datei-ähnliches Objekt, geöffnet als Binär (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>ein Pfad (<code>str</code> oder <code>Path</code>) zu einer lokalen Datei</li> <li>eine URL (<code>str</code>) zu einer entfernten Datei (z.B. <code>https://...</code>). In diesem Fall wird die Datei lokal heruntergeladen, bevor sie an die Inferenz API gesendet wird.</li>",Ke,le,Oe,ae,et,oe,tt;return C=new xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),z=new p({props:{title:"Inferenz auf Servern ausführen",local:"inferenz-auf-servern-ausführen",headingTag:"h1"}}),v=new p({props:{title:"Erste Schritte",local:"erste-schritte",headingTag:"h2"}}),I=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),W=new p({props:{title:"Verwendung eines spezifischen Modells",local:"verwendung-eines-spezifischen-modells",headingTag:"h3"}}),_=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Client für ein spezifisches Modell initialisieren</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Oder nutzen Sie einen generischen Client, geben aber Ihr Modell als Argument an</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),x=new p({props:{title:"Verwendung einer spezifischen URL",local:"verwendung-einer-spezifischen-url",headingTag:"h3"}}),G=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># oder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),L=new p({props:{title:"Authentifizierung",local:"authentifizierung",headingTag:"h3"}}),V=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),A=new p({props:{title:"Unterstützte Aufgaben",local:"unterstützte-aufgaben",headingTag:"h2"}}),q=new p({props:{title:"Asynchroner Client",local:"asynchroner-client",headingTag:"h2"}}),P=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFpb2h0dHAlMEElMjMlMjBvZGVyJTBBcGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RA==",highlighted:`pip install aiohttp
<span class="hljs-comment"># oder</span>
pip install --upgrade huggingface_hub[inference]`,wrap:!1}}),Q=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Der Code muss in einem asyncio-konkurrenten Kontext ausgeführt werden.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),Y=new p({props:{title:"Fortgeschrittene Tipps",local:"fortgeschrittene-tipps",headingTag:"h2"}}),X=new p({props:{title:"Zeitüberschreitung",local:"zeitüberschreitung",headingTag:"h3"}}),te=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),ne=new p({props:{title:"Binäre Eingaben",local:"binäre-eingaben",headingTag:"h3"}}),le=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),ae=new Jt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/inference.md"}}),{c(){m=a("meta"),ce=i(),de=a("p"),ue=i(),o(C.$$.fragment),ge=i(),o(z.$$.fragment),he=i(),j=a("p"),j.innerHTML=st,fe=i(),T=a("ul"),T.innerHTML=it,pe=i(),b=a("blockquote"),b.innerHTML=lt,me=i(),o(v.$$.fragment),be=i(),Z=a("p"),Z.textContent=at,we=i(),o(I.$$.fragment),Me=i(),U=a("p"),U.innerHTML=rt,ye=i(),w=a("blockquote"),w.innerHTML=dt,ke=i(),o(W.$$.fragment),$e=i(),S=a("p"),S.textContent=ot,Ce=i(),o(_.$$.fragment),ze=i(),M=a("blockquote"),M.innerHTML=ct,je=i(),o(x.$$.fragment),Te=i(),J=a("p"),J.innerHTML=ut,ve=i(),o(G.$$.fragment),Ze=i(),o(L.$$.fragment),Ie=i(),E=a("p"),E.innerHTML=gt,Ue=i(),o(V.$$.fragment),We=i(),y=a("blockquote"),y.innerHTML=ht,Se=i(),o(A.$$.fragment),_e=i(),B=a("p"),B.innerHTML=ft,xe=i(),H=a("table"),H.innerHTML=pt,Je=i(),k=a("blockquote"),k.innerHTML=mt,Ge=i(),o(q.$$.fragment),Le=i(),N=a("p"),N.innerHTML=bt,Ee=i(),o(P.$$.fragment),Ve=i(),F=a("p"),F.innerHTML=wt,Ae=i(),o(Q.$$.fragment),Be=i(),R=a("p"),R.innerHTML=Mt,He=i(),o(Y.$$.fragment),qe=i(),D=a("p"),D.innerHTML=yt,Ne=i(),o(X.$$.fragment),Pe=i(),K=a("p"),K.textContent=kt,Fe=i(),O=a("ul"),O.innerHTML=$t,Qe=i(),ee=a("p"),ee.innerHTML=Ct,Re=i(),o(te.$$.fragment),Ye=i(),o(ne.$$.fragment),De=i(),se=a("p"),se.textContent=zt,Xe=i(),ie=a("ul"),ie.innerHTML=jt,Ke=i(),o(le.$$.fragment),Oe=i(),o(ae.$$.fragment),et=i(),oe=a("p"),this.h()},l(e){const t=St("svelte-u9bgzb",document.head);m=r(t,"META",{name:!0,content:!0}),t.forEach(n),ce=l(e),de=r(e,"P",{}),Tt(de).forEach(n),ue=l(e),c(C.$$.fragment,e),ge=l(e),c(z.$$.fragment,e),he=l(e),j=r(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1bojokl"&&(j.innerHTML=st),fe=l(e),T=r(e,"UL",{"data-svelte-h":!0}),d(T)!=="svelte-84e5ix"&&(T.innerHTML=it),pe=l(e),b=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(b)!=="svelte-1d25fer"&&(b.innerHTML=lt),me=l(e),c(v.$$.fragment,e),be=l(e),Z=r(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1gpybzo"&&(Z.textContent=at),we=l(e),c(I.$$.fragment,e),Me=l(e),U=r(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1b1prmn"&&(U.innerHTML=rt),ye=l(e),w=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(w)!=="svelte-9hnuv5"&&(w.innerHTML=dt),ke=l(e),c(W.$$.fragment,e),$e=l(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1g51yx8"&&(S.textContent=ot),Ce=l(e),c(_.$$.fragment,e),ze=l(e),M=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(M)!=="svelte-h5swk6"&&(M.innerHTML=ct),je=l(e),c(x.$$.fragment,e),Te=l(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1hopevd"&&(J.innerHTML=ut),ve=l(e),c(G.$$.fragment,e),Ze=l(e),c(L.$$.fragment,e),Ie=l(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-vhl0ai"&&(E.innerHTML=gt),Ue=l(e),c(V.$$.fragment,e),We=l(e),y=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(y)!=="svelte-104n3m8"&&(y.innerHTML=ht),Se=l(e),c(A.$$.fragment,e),_e=l(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-phq0nn"&&(B.innerHTML=ft),xe=l(e),H=r(e,"TABLE",{"data-svelte-h":!0}),d(H)!=="svelte-1ukwk10"&&(H.innerHTML=pt),Je=l(e),k=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(k)!=="svelte-a8bd9o"&&(k.innerHTML=mt),Ge=l(e),c(q.$$.fragment,e),Le=l(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-gx6vyx"&&(N.innerHTML=bt),Ee=l(e),c(P.$$.fragment,e),Ve=l(e),F=r(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1wz2uft"&&(F.innerHTML=wt),Ae=l(e),c(Q.$$.fragment,e),Be=l(e),R=r(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-fcvx1r"&&(R.innerHTML=Mt),He=l(e),c(Y.$$.fragment,e),qe=l(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1ezsyvc"&&(D.innerHTML=yt),Ne=l(e),c(X.$$.fragment,e),Pe=l(e),K=r(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-ixt41k"&&(K.textContent=kt),Fe=l(e),O=r(e,"UL",{"data-svelte-h":!0}),d(O)!=="svelte-im1zdg"&&(O.innerHTML=$t),Qe=l(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1ughh2"&&(ee.innerHTML=Ct),Re=l(e),c(te.$$.fragment,e),Ye=l(e),c(ne.$$.fragment,e),De=l(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1m17crh"&&(se.textContent=zt),Xe=l(e),ie=r(e,"UL",{"data-svelte-h":!0}),d(ie)!=="svelte-tga9hr"&&(ie.innerHTML=jt),Ke=l(e),c(le.$$.fragment,e),Oe=l(e),c(ae.$$.fragment,e),et=l(e),oe=r(e,"P",{}),Tt(oe).forEach(n),this.h()},h(){re(m,"name","hf:doc:metadata"),re(m,"content",Lt),re(b,"class","tip"),re(w,"class","warning"),re(M,"class","tip"),re(y,"class","tip"),re(k,"class","tip")},m(e,t){_t(document.head,m),s(e,ce,t),s(e,de,t),s(e,ue,t),u(C,e,t),s(e,ge,t),u(z,e,t),s(e,he,t),s(e,j,t),s(e,fe,t),s(e,T,t),s(e,pe,t),s(e,b,t),s(e,me,t),u(v,e,t),s(e,be,t),s(e,Z,t),s(e,we,t),u(I,e,t),s(e,Me,t),s(e,U,t),s(e,ye,t),s(e,w,t),s(e,ke,t),u(W,e,t),s(e,$e,t),s(e,S,t),s(e,Ce,t),u(_,e,t),s(e,ze,t),s(e,M,t),s(e,je,t),u(x,e,t),s(e,Te,t),s(e,J,t),s(e,ve,t),u(G,e,t),s(e,Ze,t),u(L,e,t),s(e,Ie,t),s(e,E,t),s(e,Ue,t),u(V,e,t),s(e,We,t),s(e,y,t),s(e,Se,t),u(A,e,t),s(e,_e,t),s(e,B,t),s(e,xe,t),s(e,H,t),s(e,Je,t),s(e,k,t),s(e,Ge,t),u(q,e,t),s(e,Le,t),s(e,N,t),s(e,Ee,t),u(P,e,t),s(e,Ve,t),s(e,F,t),s(e,Ae,t),u(Q,e,t),s(e,Be,t),s(e,R,t),s(e,He,t),u(Y,e,t),s(e,qe,t),s(e,D,t),s(e,Ne,t),u(X,e,t),s(e,Pe,t),s(e,K,t),s(e,Fe,t),s(e,O,t),s(e,Qe,t),s(e,ee,t),s(e,Re,t),u(te,e,t),s(e,Ye,t),u(ne,e,t),s(e,De,t),s(e,se,t),s(e,Xe,t),s(e,ie,t),s(e,Ke,t),u(le,e,t),s(e,Oe,t),u(ae,e,t),s(e,et,t),s(e,oe,t),tt=!0},p:Zt,i(e){tt||(g(C.$$.fragment,e),g(z.$$.fragment,e),g(v.$$.fragment,e),g(I.$$.fragment,e),g(W.$$.fragment,e),g(_.$$.fragment,e),g(x.$$.fragment,e),g(G.$$.fragment,e),g(L.$$.fragment,e),g(V.$$.fragment,e),g(A.$$.fragment,e),g(q.$$.fragment,e),g(P.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(X.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),tt=!0)},o(e){h(C.$$.fragment,e),h(z.$$.fragment,e),h(v.$$.fragment,e),h(I.$$.fragment,e),h(W.$$.fragment,e),h(_.$$.fragment,e),h(x.$$.fragment,e),h(G.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),h(A.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(X.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),tt=!1},d(e){e&&(n(ce),n(de),n(ue),n(ge),n(he),n(j),n(fe),n(T),n(pe),n(b),n(me),n(be),n(Z),n(we),n(Me),n(U),n(ye),n(w),n(ke),n($e),n(S),n(Ce),n(ze),n(M),n(je),n(Te),n(J),n(ve),n(Ze),n(Ie),n(E),n(Ue),n(We),n(y),n(Se),n(_e),n(B),n(xe),n(H),n(Je),n(k),n(Ge),n(Le),n(N),n(Ee),n(Ve),n(F),n(Ae),n(Be),n(R),n(He),n(qe),n(D),n(Ne),n(Pe),n(K),n(Fe),n(O),n(Qe),n(ee),n(Re),n(Ye),n(De),n(se),n(Xe),n(ie),n(Ke),n(Oe),n(et),n(oe)),n(m),f(C,e),f(z,e),f(v,e),f(I,e),f(W,e),f(_,e),f(x,e),f(G,e),f(L,e),f(V,e),f(A,e),f(q,e),f(P,e),f(Q,e),f(Y,e),f(X,e),f(te,e),f(ne,e),f(le,e),f(ae,e)}}}const Lt='{"title":"Inferenz auf Servern ausführen","local":"inferenz-auf-servern-ausführen","sections":[{"title":"Erste Schritte","local":"erste-schritte","sections":[{"title":"Verwendung eines spezifischen Modells","local":"verwendung-eines-spezifischen-modells","sections":[],"depth":3},{"title":"Verwendung einer spezifischen URL","local":"verwendung-einer-spezifischen-url","sections":[],"depth":3},{"title":"Authentifizierung","local":"authentifizierung","sections":[],"depth":3}],"depth":2},{"title":"Unterstützte Aufgaben","local":"unterstützte-aufgaben","sections":[],"depth":2},{"title":"Asynchroner Client","local":"asynchroner-client","sections":[],"depth":2},{"title":"Fortgeschrittene Tipps","local":"fortgeschrittene-tipps","sections":[{"title":"Zeitüberschreitung","local":"zeitüberschreitung","sections":[],"depth":3},{"title":"Binäre Eingaben","local":"binäre-eingaben","sections":[],"depth":3}],"depth":2}],"depth":1}';function Et(nt){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends Ut{constructor(m){super(),Wt(this,m,Et,Gt,vt,{})}}export{qt as component};
