import{s as vl,n as Ql,o as Hl}from"../chunks/scheduler.de5597d1.js";import{S as Fl,i as Yl,e as p,s as a,c as M,h as ql,a as i,d as l,b as n,f as Wl,g as c,j as r,k as Ge,l as xl,m as t,n as u,t as d,o as h,p as m}from"../chunks/index.bf1177c2.js";import{C as Dl,H as Xe,E as Ll}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.7c37555a.js";import{C as y}from"../chunks/CodeBlock.af63e669.js";function Pl(el){let w,$e,Ee,Ve,o,Ne,f,Ae,g,sl=`In diesem Leitfaden werden wir sehen, wie man den Laufzeitbereich eines Space
(<a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">Geheimnisse (Secrets)</a>,
<a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">Hardware</a> und Speicher (Storage)) mit <code>huggingface_hub</code> verwaltet.`,ze,I,We,C,ll="Hier ist ein End-to-End-Beispiel, um einen Space auf dem Hub zu erstellen und einzurichten.",ve,k,tl="<strong>1. Einen Space auf dem Hub erstellen.</strong>",Qe,Z,He,b,al="<strong>1. (bis) Duplizieren eines Space.</strong>",Fe,B,nl=`Das kann nützlich sein, wenn Sie auf einem bestehenden Space aufbauen möchten, anstatt von Grund auf neu zu beginnen.
Es ist auch nützlich, wenn Sie die Kontrolle über die Konfiguration/Einstellungen eines öffentlichen Space haben möchten. Siehe <code>duplicate_space()</code> für weitere Details.`,Ye,_,qe,S,pl="<strong>2. Code mit bevorzugter Lösung hochladen.</strong>",xe,G,il="Hier ist ein Beispiel, wie man den lokalen Ordner <code>src/</code> von Ihrem Computer in Ihren Space hochlädt:",De,E,Le,R,rl=`In diesem Schritt sollte Ihre App bereits kostenlos auf dem Hub laufen!
Möglicherweise möchten Sie sie jedoch weiterhin mit Geheimnissen und aufgerüsteter Hardware konfigurieren.`,Pe,X,Ml="<strong>3. Konfigurieren von Geheimnissen und Variablen</strong>",Ke,$,cl=`Ihr Space könnte einige geheime Schlüssel, Tokens oder Variablen benötigen, um zu funktionieren.
Siehe <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">Dokumentation</a> für weitere Details.
Zum Beispiel ein HF-Token, um einen Bilddatensatz auf den Hub hochzuladen, sobald er aus Ihrem Space generiert wurde.`,Oe,V,es,N,ul="Geheimnisse und Variablen können auch gelöscht werden:",ss,A,ls,J,dl=`<p>Innerhalb Ihres Space sind Geheimnisse als Umgebungsvariablen verfügbar (oder
Streamlit Secrets Management, wenn Streamlit verwendet wird). Keine Notwendigkeit, sie über die API abzurufen!</p>`,ts,U,hl="<p>Jede Änderung in der Konfiguration Ihres Space (Geheimnisse oder Hardware) wird einen Neustart Ihrer App auslösen.</p>",as,z,ml="<strong>Bonus: Geheimnisse und Variablen beim Erstellen oder Duplizieren des Space festlegen!</strong>",ns,W,yl="Geheimnisse und Variablen können beim Erstellen oder Duplizieren eines Space gesetzt werden:",ps,v,is,Q,rs,H,wl="<strong>4. Konfigurieren von Hardware</strong>",Ms,F,Jl=`Standardmäßig wird Ihr Space kostenlos in einer CPU-Umgebung ausgeführt. Sie können die Hardware
aktualisieren, um sie auf GPUs laufen zu lassen. Eine Zahlungskarte oder ein Community-Grant wird benötigt, um Ihren
Space zu aktualisieren. Siehe <a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">Dokumentation</a> für weitere Details.`,cs,Y,us,q,Ul=`Hardware-Aktualisierungen erfolgen nicht sofort, da Ihr Space auf unseren Servern neu geladen werden muss.
Jederzeit können Sie überprüfen, auf welcher Hardware Ihr Space läuft, um zu sehen, ob Ihre Anfrage
erfüllt wurde.`,ds,x,hs,D,jl=`Sie verfügen jetzt über einen vollständig konfigurierten Space. Stellen Sie sicher, dass Sie Ihren Space wieder auf “cpu-classic”
zurückstufen, wenn Sie ihn nicht mehr verwenden.`,ms,L,Tl="<strong>Bonus: Hardware beim Erstellen oder Duplizieren des Space anfordern!</strong>",ys,P,ol="Aktualisierte Hardware wird Ihrem Space automatisch zugewiesen, sobald er erstellt wurde.",ws,K,Js,O,Us,ee,fl="<strong>5. Pausieren und Neustarten des Spaces</strong>",js,se,gl=`Standardmäßig, wenn Ihr Space auf augewerteter Hardware läuft, wird er nie angehalten. Um jedoch zu vermeiden, dass Ihnen Gebühren berechnet werden,
möchten Sie ihn möglicherweise anhalten, wenn Sie ihn nicht verwenden. Dies ist mit <code>pause_space()</code> möglich. Ein pausierter Space bleibt
inaktiv, bis der Besitzer des Space ihn entweder über die Benutzeroberfläche oder über die API mit <code>restart_space()</code> neu startet.
Weitere Informationen zum Pausenmodus finden Sie in <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">diesem Abschnitt</a>.`,Ts,le,os,te,Il=`Eine weitere Möglichkeit besteht darin, für Ihren Space einen Timeout festzulegen. Wenn Ihr Space länger als die Timeout-Dauer inaktiv ist,
wird er in den Schlafmodus versetzt. Jeder Besucher, der auf Ihren Space zugreift, wird ihn wieder starten. Sie können ein Timeout mit
<code>set_space_sleep_time()</code> festlegen. Weitere Informationen zum Schlafmodus finden Sie in <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">diesem Abschnitt</a>.`,fs,ae,gs,ne,Cl=`Hinweis: Wenn Sie eine ‘cpu-basic’ Hardware verwenden, können Sie keine benutzerdefinierte Schlafzeit konfigurieren. Ihr Space wird automatisch
nach 48h Inaktivität pausiert.`,Is,pe,kl="<strong>Bonus: Schlafzeit festlegen, während der Hardwareanforderung</strong>",Cs,ie,Zl="Aufgewertete Hardware wird Ihrem Space automatisch zugewiesen, sobald er erstellt wurde.",ks,re,Zs,Me,bl="<strong>Bonus: Schlafzeit beim Erstellen oder Duplizieren des Space festlegen!</strong>",bs,ce,Bs,ue,_s,de,Bl="<strong>6. Dem Space dauerhaften Speicherplatz hinzufügen</strong>",Ss,he,_l='Sie können den Speicher-Tier Ihrer Wahl auswählen, um auf Festplattenspeicher zuzugreifen, der Neustarts Ihres Space überdauert. Dies bedeutet, dass Sie von der Festplatte lesen und darauf schreiben können, wie Sie es von einer herkömmlichen Festplatte gewöhnt sind. Weitere Informationen finden Sie in der <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">Dokumentation</a> .',Gs,me,Es,ye,Sl="Sie können auch Ihren Speicher löschen und dabei alle Daten dauerhaft verlieren.",Rs,we,Xs,Je,Gl="Hinweis: Nachdem Ihnen ein Speicher-Tier zugewiesen wurde, können Sie diesen nicht mehr herabsetzen. Um dies zu tun, müssen Sie zuerst den Speicher löschen und dann den gewünschten Tier anfordern.",$s,Ue,El="<strong>Bonus: Speicher beim Erstellen oder Duplizieren des Space anfordern!</strong>",Vs,je,Ns,Te,As,oe,zs,fe,Rl=`Spaces ermöglichen viele verschiedene Einsatzmöglichkeiten. Manchmal möchten Sie vielleicht einen Space vorübergehend auf einer
bestimmten Hardware ausführen, etwas tun und ihn dann herunterfahren. In diesem Abschnitt werden wir untersuchen, wie Sie die
Vorteile von Spaces nutzen können, um ein Modell auf Abruf zu finetunen. Dies ist nur eine Möglichkeit, dieses spezielle Problem zu
lösen. Es sollte als Vorschlag betrachtet und an Ihren Anwendungsfall angepasst werden.`,Ws,ge,Xl=`Nehmen wir an, wir haben einen Space, um ein Modell zu finetunen.
Es handelt sich um eine Gradio-App, die ein Modell-Id und eine Dataset-Id als Eingabe nimmt. Der Ablauf sieht folgendermaßen aus:`,vs,j,$l="<li>(Den Benutzer nach einem Modell und einem Datensatz auffordern)</li> <li>Das Modell aus dem Hub laden.</li> <li>Den Datensatz aus dem Hub laden.</li> <li>Das Modell mit dem Datensatz finetunen.</li> <li>Das neue Modell auf den Hub hochladen.</li>",Qs,Ie,Vl=`Schritt 3 erfordert eine spezielle Hardware, aber Sie möchten nicht, dass Ihr Space die ganze Zeit
auf einer kostenpflichtigen GPU läuft. Eine Lösung besteht darin, dynamisch Hardware für das Training
anzufordern und es anschließend herunterzufahren. Da das Anfordern von Hardware Ihren Space neu startet,
muss sich Ihre App irgendwie die aktuelle Aufgabe “merken”, die sie ausführt.
Es gibt mehrere Möglichkeiten, dies zu tun. In diesem Leitfaden sehen wir eine Lösung,
bei der ein Datensatz als “Aufgabenplaner (task scheduler)” verwendet wird.`,Hs,Ce,Fs,ke,Nl=`So würde Ihre App aussehen. Beim Start überprüfen, ob eine Aufgabe geplant ist und ob ja,
führen Sie sie auf der richtigen Hardware aus. Ist die Aufgabe erledigt,
setzen Sie die Hardware zurück auf den kostenlosen CPU-Plan und fordern den Benutzer auf,
eine neue Aufgabe anzufordern.`,Ys,T,Al=`<p>Ein solcher Workflow unterstützt keinen gleichzeitigen Zugriff wie normale Demos.
Insbesondere wird die Schnittstelle deaktiviert, wenn das Training stattfindet.
Es ist vorzuziehen, Ihr Repo auf privat zu setzen, um sicherzustellen, dass Sie der einzige Benutzer sind.</p>`,qs,Ze,xs,be,Ds,Be,zl=`Das Planen von Aufgaben kann auf viele Arten erfolgen. Hier ist ein Beispiel,
wie es mit einer einfachen CSV gemacht werden könnte, die als Datensatz gespeichert ist.`,Ls,_e,Ps,Se,Ks,Re,Os;return o=new Dl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new Xe({props:{title:"Verwalten Ihres Spaces (Bereiches)",local:"verwalten-ihres-spaces-bereiches",headingTag:"h1"}}),I=new Xe({props:{title:"Ein einfaches Beispiel: Konfigurieren von Geheimnissen und Hardware",local:"ein-einfaches-beispiel-konfigurieren-von-geheimnissen-und-hardware",headingTag:"h2"}}),Z=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBcmVwb19pZCUyMCUzRCUyMCUyMldhdXBsaW4lMkZteS1jb29sLXRyYWluaW5nLXNwYWNlJTIyJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwc3BhY2Vfc2RrJTNEJTIyZ3JhZGlvJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;Wauplin/my-cool-training-space&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Zum Beispiel mit einem Gradio SDK</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>)`,wrap:!1}}),_=new y({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)',wrap:!1}}),E=new y({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyc3JjJTJGJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, folder_path=<span class="hljs-string">&quot;src/&quot;</span>)',wrap:!1}}),V=new y({props:{code:"YXBpLmFkZF9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiUyQyUyMHZhbHVlJTNEJTIyaGZfYXBpXyoqKiUyMiklMEFhcGkuYWRkX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMiUyQyUyMHZhbHVlJTNEJTIydXNlciUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, value=<span class="hljs-string">&quot;hf_api_***&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, value=<span class="hljs-string">&quot;user/repo&quot;</span>)`,wrap:!1}}),A=new y({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiklMEFhcGkuZGVsZXRlX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>)`,wrap:!1}}),v=new y({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZWNyZXRzJTNEJTVCJTdCJTIya2V5JTIyJTNEJTIySEZfVE9LRU4lMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMmhmX2FwaV8qKiolMjIlN0QlMkMlMjAuLi4lNUQlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV92YXJpYWJsZXMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJNT0RFTF9SRVBPX0lEJTIyJTJDJTIwJTIydmFsdWUlMjIlM0QlMjJ1c2VyJTJGcmVwbyUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>,
<span class="hljs-meta">... </span>    space_secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    space_variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new y({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJIRl9UT0tFTiUyMiUyQyUyMCUyMnZhbHVlJTIyJTNEJTIyaGZfYXBpXyoqKiUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhYmxlcyUzRCU1QiU3QiUyMmtleSUyMiUzRCUyMk1PREVMX1JFUE9fSUQlMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMnVzZXIlMkZyZXBvJTIyJTdEJTJDJTIwLi4uJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlSGFyZHdhcmUlMEFhcGkucmVxdWVzdF9zcGFjZV9oYXJkd2FyZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0pJTBBJTBBYXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMik=",highlighted:`<span class="hljs-comment"># Verwenden von \`SpaceHardware\` Enum</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceHardware
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM)

<span class="hljs-comment"># Oder einfach einen String-Wert angeben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>)`,wrap:!1}}),x=new y({props:{code:"cnVudGltZSUyMCUzRCUyMGFwaS5nZXRfc3BhY2VfcnVudGltZShyZXBvX2lkJTNEcmVwb19pZCklMEFydW50aW1lLnN0YWdlJTBBcnVudGltZS5oYXJkd2FyZSUwQXJ1bnRpbWUucmVxdWVzdGVkX2hhcmR3YXJl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>runtime = api.get_space_runtime(repo_id=repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.stage
<span class="hljs-string">&quot;RUNNING_BUILDING&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.hardware
<span class="hljs-string">&quot;cpu-basic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.requested_hardware
<span class="hljs-string">&quot;t4-medium&quot;</span>`,wrap:!1}}),K=new y({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMmNwdS11cGdyYWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc3RvcmFnZSUzRCUyMnNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc2xlZXBfdGltZSUzRCUyMjcyMDAlMjIlMkMlMjAlMjMlMjAyJTIwaG91cnMlMjBpbiUyMHNlY3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new y({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIyY3B1LXVwZ3JhZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBzdG9yYWdlJTNEJTIyc21hbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBzbGVlcF90aW1lJTNEJTIyNzIwMCUyMiUyQyUyMCUyMyUyMDIlMjBob3VycyUyMGluJTIwc2VjcyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),le=new y({props:{code:"YXBpLnBhdXNlX3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKSUwQWFwaS5yZXN0YXJ0X3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-comment"># Pausieren des Space, um Gebühren zu vermeiden</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.pause_space(repo_id=repo_id)
<span class="hljs-comment"># (...)</span>
<span class="hljs-comment"># Erneut starten, wenn benötigt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.restart_space(repo_id=repo_id)`,wrap:!1}}),ae=new y({props:{code:"YXBpLnNldF9zcGFjZV9zbGVlcF90aW1lKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:`<span class="hljs-comment"># Setzen den Space nach 1h Inaktivität in den Schlafmodus</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.set_space_sleep_time(repo_id=repo_id, sleep_time=<span class="hljs-number">3600</span>)`,wrap:!1}}),re=new y({props:{code:"YXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRFNwYWNlSGFyZHdhcmUuVDRfTUVESVVNJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM, sleep_time=<span class="hljs-number">3600</span>)',wrap:!1}}),ce=new y({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwYWNlX3NsZWVwX3RpbWUlM0QlMjIzNjAwJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ue=new y({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIydDQtbWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2xlZXBfdGltZSUzRCUyMjM2MDAlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),me=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlU3RvcmFnZSUwQWFwaS5yZXF1ZXN0X3NwYWNlX3N0b3JhZ2UocmVwb19pZCUzRHJlcG9faWQlMkMlMjBzdG9yYWdlJTNEU3BhY2VTdG9yYWdlLkxBUkdFKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceStorage
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_storage(repo_id=repo_id, storage=SpaceStorage.LARGE)`,wrap:!1}}),we=new y({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zdG9yYWdlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_storage(repo_id=repo_id)',wrap:!1}}),je=new y({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9zdG9yYWdlJTNEJTIybGFyZ2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Te=new y({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2UlM0QlMjJsYXJnZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),oe=new Xe({props:{title:"Fortgeschritten: Temporäres Space Upgrade",local:"fortgeschritten-temporäres-space-upgrade",headingTag:"h2"}}),Ce=new Xe({props:{title:"App-Grundgerüst",local:"app-grundgerüst",headingTag:"h3"}}),Ze=new y({props:{code:"JTIzJTIwRiVDMyVCQ3IlMjBkZW4lMjBTcGFjZSUyMHdpcmQlMjBJaHIlMjBUb2tlbiUyMGJlbiVDMyVCNnRpZ3QlMkMlMjB1bSUyMEhhcmR3YXJlJTIwYW56dWZvcmRlcm4lM0ElMjBMZWdlbiUyMFNpZSUyMGVzJTIwYWxzJTIwR2VoZWltbmlzJTIwZmVzdCElMEFIRl9UT0tFTiUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkhGX1RPS0VOJTIyKSUwQSUwQSUyMyUyMEVpZ2VuZSUyMHJlcG9faWQlMjBkZXMlMjBTcGFjZSUwQVRSQUlOSU5HX1NQQUNFX0lEJTIwJTNEJTIwJTIyV2F1cGxpbiUyRmRyZWFtYm9vdGgtdHJhaW5pbmclMjIlMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSGZBcGklMkMlMjBTcGFjZUhhcmR3YXJlJTBBYXBpJTIwJTNEJTIwSGZBcGkodG9rZW4lM0RIRl9UT0tFTiklMEElMEElMjMlMjBCZWltJTIwU3RhcnQlMjBkZXMlMjBTcGFjZSUyMCVDMyVCQ2JlcnByJUMzJUJDZmVuJTJDJTIwb2IlMjBlaW5lJTIwQXVmZ2FiZSUyMGdlcGxhbnQlMjBpc3QuJTIwV2VubiUyMGphJTJDJTIwZmluZXR1bmVuJTIwU2llJTIwZGFzJTIwTW9kZWxsLiUwQSUyMyUyMFdlbm4lMjBuaWNodCUyQyUyMHplaWdlbiUyMFNpZSUyMGVpbmUlMjBTY2huaXR0c3RlbGxlJTIwYW4lMkMlMjB1bSUyMGVpbmUlMjBuZXVlJTIwQXVmZ2FiZSUyMGFuenVmb3JkZXJuLiUwQXRhc2slMjAlM0QlMjBnZXRfdGFzaygpJTBBaWYlMjB0YXNrJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU3RhcnRlbiUyMGRlciUyMEdyYWRpby1BcHAlMEElMjAlMjAlMjAlMjBkZWYlMjBncmFkaW9fZm4odGFzayklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBCZWklMjBCZW51dHplcmFuZnJhZ2UlMkMlMjBBdWZnYWJlJTIwaGluenVmJUMzJUJDZ2VuJTIwdW5kJTIwSGFyZHdhcmUlMjBhbmZvcmRlcm4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhZGRfdGFzayh0YXNrKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaS5yZXF1ZXN0X3NwYWNlX2hhcmR3YXJlKHJlcG9faWQlM0RUUkFJTklOR19TUEFDRV9JRCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0pJTBBJTBBJTIwJTIwJTIwJTIwZ3IuSW50ZXJmYWNlKGZuJTNEZ3JhZGlvX2ZuJTJDJTIwLi4uKS5sYXVuY2goKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBydW50aW1lJTIwJTNEJTIwYXBpLmdldF9zcGFjZV9ydW50aW1lKHJlcG9faWQlM0RUUkFJTklOR19TUEFDRV9JRCklMEElMjAlMjAlMjAlMjAlMjMlMjAlQzMlOUNiZXJwciVDMyVCQ2ZlbiUyQyUyMG9iJTIwZGVyJTIwU3BhY2UlMjBtaXQlMjBlaW5lciUyMEdQVSUyMGdlbGFkZW4lMjBpc3QuJTBBJTIwJTIwJTIwJTIwaWYlMjBydW50aW1lLmhhcmR3YXJlJTIwJTNEJTNEJTIwU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBXZW5uJTIwamElMkMlMjBmaW5ldHVuZW4lMjBkZXMlMjBCYXNpc21vZGVsbHMlMjBhdWYlMjBkZW4lMjBEYXRlbnNhdHohJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fYW5kX3VwbG9hZCh0YXNrKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERhbm4lMjBkaWUlMjBBdWZnYWJlJTIwYWxzJTIwJTIyRE9ORSUyMCUyRiUyMEVSTEVESUdUJTIyJTIwbWFya2llcmVuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWFya19hc19kb25lKHRhc2spJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTklDSFQlMjBWRVJHRVNTRU4lM0ElMjBDUFUtSGFyZHdhcmUlMjB6dXIlQzMlQkNjayUyMHNldHplbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaS5yZXF1ZXN0X3NwYWNlX2hhcmR3YXJlKHJlcG9faWQlM0RUUkFJTklOR19TUEFDRV9JRCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5DUFVfQkFTSUMpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaS5yZXF1ZXN0X3NwYWNlX2hhcmR3YXJlKHJlcG9faWQlM0RUUkFJTklOR19TUEFDRV9JRCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0p",highlighted:`<span class="hljs-comment"># Für den Space wird Ihr Token benötigt, um Hardware anzufordern: Legen Sie es als Geheimnis fest!</span>
HF_TOKEN = os.environ.get(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Eigene repo_id des Space</span>
TRAINING_SPACE_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-training&quot;</span>

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, SpaceHardware
api = HfApi(token=HF_TOKEN)

<span class="hljs-comment"># Beim Start des Space überprüfen, ob eine Aufgabe geplant ist. Wenn ja, finetunen Sie das Modell.</span>
<span class="hljs-comment"># Wenn nicht, zeigen Sie eine Schnittstelle an, um eine neue Aufgabe anzufordern.</span>
task = get_task()
<span class="hljs-keyword">if</span> task <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># Starten der Gradio-App</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">gradio_fn</span>(<span class="hljs-params">task</span>):
        <span class="hljs-comment"># Bei Benutzeranfrage, Aufgabe hinzufügen und Hardware anfordern</span>
        add_task(task)
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)

    gr.Interface(fn=gradio_fn, ...).launch()
<span class="hljs-keyword">else</span>:
    runtime = api.get_space_runtime(repo_id=TRAINING_SPACE_ID)
    <span class="hljs-comment"># Überprüfen, ob der Space mit einer GPU geladen ist.</span>
    <span class="hljs-keyword">if</span> runtime.hardware == SpaceHardware.T4_MEDIUM:
        <span class="hljs-comment"># Wenn ja, finetunen des Basismodells auf den Datensatz!</span>
        train_and_upload(task)

        <span class="hljs-comment"># Dann die Aufgabe als &quot;DONE / ERLEDIGT&quot; markieren</span>
        mark_as_done(task)

        <span class="hljs-comment"># NICHT VERGESSEN: CPU-Hardware zurück setzen</span>
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.CPU_BASIC)
    <span class="hljs-keyword">else</span>:
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)`,wrap:!1}}),be=new Xe({props:{title:"Aufgabenplaner (Task scheduler)",local:"aufgabenplaner-task-scheduler",headingTag:"h3"}}),_e=new y({props:{code:"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",highlighted:`<span class="hljs-comment"># Dataset-ID, in der eine \`tasks.csv\` Datei die auszuführenden Aufgaben enthält.</span>
<span class="hljs-comment"># Hier ist ein einfaches Beispiel für \`tasks.csv\`, das Eingaben (Basis-Modell und Datensatz)</span>
<span class="hljs-comment"># und Status (PENDING / AUSSTEHEND oder DONE / ERLEDIGT) enthält.</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-1,DONE</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-2,PENDING</span>
TASK_DATASET_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-task-scheduler&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_get_csv_file</span>():
    <span class="hljs-keyword">return</span> hf_hub_download(repo_id=TASK_DATASET_ID, filename=<span class="hljs-string">&quot;tasks.csv&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, token=HF_TOKEN)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_task</span>():
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        csv_reader = csv.reader(csv_file, delimiter=<span class="hljs-string">&#x27;,&#x27;</span>)
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> csv_reader:
            <span class="hljs-keyword">if</span> row[<span class="hljs-number">2</span>] == <span class="hljs-string">&quot;PENDING&quot;</span>:
                <span class="hljs-keyword">return</span> row[<span class="hljs-number">0</span>], row[<span class="hljs-number">1</span>] <span class="hljs-comment"># model_id, dataset_id</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_task</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Schnelle und einfache Möglichkeit, eine Aufgabe hinzuzufügen</span>
        path_or_fileobj=(tasks + <span class="hljs-string">f&quot;\\n<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>).encode()
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">mark_as_done</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Schnelle und einfache Möglichkeit, die Aufgabe als DONE / ERLEDIGT zu markieren</span>
        path_or_fileobj=tasks.replace(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>,
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,DONE&quot;</span>
        ).encode()
    )`,wrap:!1}}),Se=new Ll({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/manage-spaces.md"}}),{c(){w=p("meta"),$e=a(),Ee=p("p"),Ve=a(),M(o.$$.fragment),Ne=a(),M(f.$$.fragment),Ae=a(),g=p("p"),g.innerHTML=sl,ze=a(),M(I.$$.fragment),We=a(),C=p("p"),C.textContent=ll,ve=a(),k=p("p"),k.innerHTML=tl,Qe=a(),M(Z.$$.fragment),He=a(),b=p("p"),b.innerHTML=al,Fe=a(),B=p("p"),B.innerHTML=nl,Ye=a(),M(_.$$.fragment),qe=a(),S=p("p"),S.innerHTML=pl,xe=a(),G=p("p"),G.innerHTML=il,De=a(),M(E.$$.fragment),Le=a(),R=p("p"),R.textContent=rl,Pe=a(),X=p("p"),X.innerHTML=Ml,Ke=a(),$=p("p"),$.innerHTML=cl,Oe=a(),M(V.$$.fragment),es=a(),N=p("p"),N.textContent=ul,ss=a(),M(A.$$.fragment),ls=a(),J=p("blockquote"),J.innerHTML=dl,ts=a(),U=p("blockquote"),U.innerHTML=hl,as=a(),z=p("p"),z.innerHTML=ml,ns=a(),W=p("p"),W.textContent=yl,ps=a(),M(v.$$.fragment),is=a(),M(Q.$$.fragment),rs=a(),H=p("p"),H.innerHTML=wl,Ms=a(),F=p("p"),F.innerHTML=Jl,cs=a(),M(Y.$$.fragment),us=a(),q=p("p"),q.textContent=Ul,ds=a(),M(x.$$.fragment),hs=a(),D=p("p"),D.textContent=jl,ms=a(),L=p("p"),L.innerHTML=Tl,ys=a(),P=p("p"),P.textContent=ol,ws=a(),M(K.$$.fragment),Js=a(),M(O.$$.fragment),Us=a(),ee=p("p"),ee.innerHTML=fl,js=a(),se=p("p"),se.innerHTML=gl,Ts=a(),M(le.$$.fragment),os=a(),te=p("p"),te.innerHTML=Il,fs=a(),M(ae.$$.fragment),gs=a(),ne=p("p"),ne.textContent=Cl,Is=a(),pe=p("p"),pe.innerHTML=kl,Cs=a(),ie=p("p"),ie.textContent=Zl,ks=a(),M(re.$$.fragment),Zs=a(),Me=p("p"),Me.innerHTML=bl,bs=a(),M(ce.$$.fragment),Bs=a(),M(ue.$$.fragment),_s=a(),de=p("p"),de.innerHTML=Bl,Ss=a(),he=p("p"),he.innerHTML=_l,Gs=a(),M(me.$$.fragment),Es=a(),ye=p("p"),ye.textContent=Sl,Rs=a(),M(we.$$.fragment),Xs=a(),Je=p("p"),Je.textContent=Gl,$s=a(),Ue=p("p"),Ue.innerHTML=El,Vs=a(),M(je.$$.fragment),Ns=a(),M(Te.$$.fragment),As=a(),M(oe.$$.fragment),zs=a(),fe=p("p"),fe.textContent=Rl,Ws=a(),ge=p("p"),ge.textContent=Xl,vs=a(),j=p("ol"),j.innerHTML=$l,Qs=a(),Ie=p("p"),Ie.textContent=Vl,Hs=a(),M(Ce.$$.fragment),Fs=a(),ke=p("p"),ke.textContent=Nl,Ys=a(),T=p("blockquote"),T.innerHTML=Al,qs=a(),M(Ze.$$.fragment),xs=a(),M(be.$$.fragment),Ds=a(),Be=p("p"),Be.textContent=zl,Ls=a(),M(_e.$$.fragment),Ps=a(),M(Se.$$.fragment),Ks=a(),Re=p("p"),this.h()},l(e){const s=ql("svelte-u9bgzb",document.head);w=i(s,"META",{name:!0,content:!0}),s.forEach(l),$e=n(e),Ee=i(e,"P",{}),Wl(Ee).forEach(l),Ve=n(e),c(o.$$.fragment,e),Ne=n(e),c(f.$$.fragment,e),Ae=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-us3de"&&(g.innerHTML=sl),ze=n(e),c(I.$$.fragment,e),We=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-r2gx4b"&&(C.textContent=ll),ve=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10miwyu"&&(k.innerHTML=tl),Qe=n(e),c(Z.$$.fragment,e),He=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-7t6vwa"&&(b.innerHTML=al),Fe=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-bc8bvv"&&(B.innerHTML=nl),Ye=n(e),c(_.$$.fragment,e),qe=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-15be2my"&&(S.innerHTML=pl),xe=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-buimsf"&&(G.innerHTML=il),De=n(e),c(E.$$.fragment,e),Le=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1qq62ek"&&(R.textContent=rl),Pe=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-rds4pt"&&(X.innerHTML=Ml),Ke=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-16wtgcf"&&($.innerHTML=cl),Oe=n(e),c(V.$$.fragment,e),es=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-snvqha"&&(N.textContent=ul),ss=n(e),c(A.$$.fragment,e),ls=n(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1kxa1le"&&(J.innerHTML=dl),ts=n(e),U=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-pu2ytx"&&(U.innerHTML=hl),as=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1j17h92"&&(z.innerHTML=ml),ns=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-39hest"&&(W.textContent=yl),ps=n(e),c(v.$$.fragment,e),is=n(e),c(Q.$$.fragment,e),rs=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1xzfeii"&&(H.innerHTML=wl),Ms=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1gmhrv2"&&(F.innerHTML=Jl),cs=n(e),c(Y.$$.fragment,e),us=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1rmrvr7"&&(q.textContent=Ul),ds=n(e),c(x.$$.fragment,e),hs=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-uymhqh"&&(D.textContent=jl),ms=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1rpe9lo"&&(L.innerHTML=Tl),ys=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1wi53p0"&&(P.textContent=ol),ws=n(e),c(K.$$.fragment,e),Js=n(e),c(O.$$.fragment,e),Us=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1fd7ttv"&&(ee.innerHTML=fl),js=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-19lj65j"&&(se.innerHTML=gl),Ts=n(e),c(le.$$.fragment,e),os=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1crhh47"&&(te.innerHTML=Il),fs=n(e),c(ae.$$.fragment,e),gs=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1arj812"&&(ne.textContent=Cl),Is=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1hg2vfa"&&(pe.innerHTML=kl),Cs=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1pqtdd"&&(ie.textContent=Zl),ks=n(e),c(re.$$.fragment,e),Zs=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1l4dq39"&&(Me.innerHTML=bl),bs=n(e),c(ce.$$.fragment,e),Bs=n(e),c(ue.$$.fragment,e),_s=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1mlq83k"&&(de.innerHTML=Bl),Ss=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-c7bcjv"&&(he.innerHTML=_l),Gs=n(e),c(me.$$.fragment,e),Es=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1xwrelw"&&(ye.textContent=Sl),Rs=n(e),c(we.$$.fragment,e),Xs=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1zc0ay"&&(Je.textContent=Gl),$s=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-7dgy29"&&(Ue.innerHTML=El),Vs=n(e),c(je.$$.fragment,e),Ns=n(e),c(Te.$$.fragment,e),As=n(e),c(oe.$$.fragment,e),zs=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-5dtsf6"&&(fe.textContent=Rl),Ws=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1xxdvtk"&&(ge.textContent=Xl),vs=n(e),j=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-xen2u6"&&(j.innerHTML=$l),Qs=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-kg4vyv"&&(Ie.textContent=Vl),Hs=n(e),c(Ce.$$.fragment,e),Fs=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1mgf6nf"&&(ke.textContent=Nl),Ys=n(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1sdd9q9"&&(T.innerHTML=Al),qs=n(e),c(Ze.$$.fragment,e),xs=n(e),c(be.$$.fragment,e),Ds=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-egh43o"&&(Be.textContent=zl),Ls=n(e),c(_e.$$.fragment,e),Ps=n(e),c(Se.$$.fragment,e),Ks=n(e),Re=i(e,"P",{}),Wl(Re).forEach(l),this.h()},h(){Ge(w,"name","hf:doc:metadata"),Ge(w,"content",Kl),Ge(J,"class","tip"),Ge(U,"class","warning"),Ge(j,"start","0"),Ge(T,"class","warning")},m(e,s){xl(document.head,w),t(e,$e,s),t(e,Ee,s),t(e,Ve,s),u(o,e,s),t(e,Ne,s),u(f,e,s),t(e,Ae,s),t(e,g,s),t(e,ze,s),u(I,e,s),t(e,We,s),t(e,C,s),t(e,ve,s),t(e,k,s),t(e,Qe,s),u(Z,e,s),t(e,He,s),t(e,b,s),t(e,Fe,s),t(e,B,s),t(e,Ye,s),u(_,e,s),t(e,qe,s),t(e,S,s),t(e,xe,s),t(e,G,s),t(e,De,s),u(E,e,s),t(e,Le,s),t(e,R,s),t(e,Pe,s),t(e,X,s),t(e,Ke,s),t(e,$,s),t(e,Oe,s),u(V,e,s),t(e,es,s),t(e,N,s),t(e,ss,s),u(A,e,s),t(e,ls,s),t(e,J,s),t(e,ts,s),t(e,U,s),t(e,as,s),t(e,z,s),t(e,ns,s),t(e,W,s),t(e,ps,s),u(v,e,s),t(e,is,s),u(Q,e,s),t(e,rs,s),t(e,H,s),t(e,Ms,s),t(e,F,s),t(e,cs,s),u(Y,e,s),t(e,us,s),t(e,q,s),t(e,ds,s),u(x,e,s),t(e,hs,s),t(e,D,s),t(e,ms,s),t(e,L,s),t(e,ys,s),t(e,P,s),t(e,ws,s),u(K,e,s),t(e,Js,s),u(O,e,s),t(e,Us,s),t(e,ee,s),t(e,js,s),t(e,se,s),t(e,Ts,s),u(le,e,s),t(e,os,s),t(e,te,s),t(e,fs,s),u(ae,e,s),t(e,gs,s),t(e,ne,s),t(e,Is,s),t(e,pe,s),t(e,Cs,s),t(e,ie,s),t(e,ks,s),u(re,e,s),t(e,Zs,s),t(e,Me,s),t(e,bs,s),u(ce,e,s),t(e,Bs,s),u(ue,e,s),t(e,_s,s),t(e,de,s),t(e,Ss,s),t(e,he,s),t(e,Gs,s),u(me,e,s),t(e,Es,s),t(e,ye,s),t(e,Rs,s),u(we,e,s),t(e,Xs,s),t(e,Je,s),t(e,$s,s),t(e,Ue,s),t(e,Vs,s),u(je,e,s),t(e,Ns,s),u(Te,e,s),t(e,As,s),u(oe,e,s),t(e,zs,s),t(e,fe,s),t(e,Ws,s),t(e,ge,s),t(e,vs,s),t(e,j,s),t(e,Qs,s),t(e,Ie,s),t(e,Hs,s),u(Ce,e,s),t(e,Fs,s),t(e,ke,s),t(e,Ys,s),t(e,T,s),t(e,qs,s),u(Ze,e,s),t(e,xs,s),u(be,e,s),t(e,Ds,s),t(e,Be,s),t(e,Ls,s),u(_e,e,s),t(e,Ps,s),u(Se,e,s),t(e,Ks,s),t(e,Re,s),Os=!0},p:Ql,i(e){Os||(d(o.$$.fragment,e),d(f.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(_.$$.fragment,e),d(E.$$.fragment,e),d(V.$$.fragment,e),d(A.$$.fragment,e),d(v.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(x.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(oe.$$.fragment,e),d(Ce.$$.fragment,e),d(Ze.$$.fragment,e),d(be.$$.fragment,e),d(_e.$$.fragment,e),d(Se.$$.fragment,e),Os=!0)},o(e){h(o.$$.fragment,e),h(f.$$.fragment,e),h(I.$$.fragment,e),h(Z.$$.fragment,e),h(_.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(A.$$.fragment,e),h(v.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(x.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(me.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(Te.$$.fragment,e),h(oe.$$.fragment,e),h(Ce.$$.fragment,e),h(Ze.$$.fragment,e),h(be.$$.fragment,e),h(_e.$$.fragment,e),h(Se.$$.fragment,e),Os=!1},d(e){e&&(l($e),l(Ee),l(Ve),l(Ne),l(Ae),l(g),l(ze),l(We),l(C),l(ve),l(k),l(Qe),l(He),l(b),l(Fe),l(B),l(Ye),l(qe),l(S),l(xe),l(G),l(De),l(Le),l(R),l(Pe),l(X),l(Ke),l($),l(Oe),l(es),l(N),l(ss),l(ls),l(J),l(ts),l(U),l(as),l(z),l(ns),l(W),l(ps),l(is),l(rs),l(H),l(Ms),l(F),l(cs),l(us),l(q),l(ds),l(hs),l(D),l(ms),l(L),l(ys),l(P),l(ws),l(Js),l(Us),l(ee),l(js),l(se),l(Ts),l(os),l(te),l(fs),l(gs),l(ne),l(Is),l(pe),l(Cs),l(ie),l(ks),l(Zs),l(Me),l(bs),l(Bs),l(_s),l(de),l(Ss),l(he),l(Gs),l(Es),l(ye),l(Rs),l(Xs),l(Je),l($s),l(Ue),l(Vs),l(Ns),l(As),l(zs),l(fe),l(Ws),l(ge),l(vs),l(j),l(Qs),l(Ie),l(Hs),l(Fs),l(ke),l(Ys),l(T),l(qs),l(xs),l(Ds),l(Be),l(Ls),l(Ps),l(Ks),l(Re)),l(w),m(o,e),m(f,e),m(I,e),m(Z,e),m(_,e),m(E,e),m(V,e),m(A,e),m(v,e),m(Q,e),m(Y,e),m(x,e),m(K,e),m(O,e),m(le,e),m(ae,e),m(re,e),m(ce,e),m(ue,e),m(me,e),m(we,e),m(je,e),m(Te,e),m(oe,e),m(Ce,e),m(Ze,e),m(be,e),m(_e,e),m(Se,e)}}}const Kl='{"title":"Verwalten Ihres Spaces (Bereiches)","local":"verwalten-ihres-spaces-bereiches","sections":[{"title":"Ein einfaches Beispiel: Konfigurieren von Geheimnissen und Hardware","local":"ein-einfaches-beispiel-konfigurieren-von-geheimnissen-und-hardware","sections":[],"depth":2},{"title":"Fortgeschritten: Temporäres Space Upgrade","local":"fortgeschritten-temporäres-space-upgrade","sections":[{"title":"App-Grundgerüst","local":"app-grundgerüst","sections":[],"depth":3},{"title":"Aufgabenplaner (Task scheduler)","local":"aufgabenplaner-task-scheduler","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ol(el){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class at extends Fl{constructor(w){super(),Yl(this,w,Ol,Pl,vl,{})}}export{at as component};
