import{s as as,n as ls,o as is}from"../chunks/scheduler.0cf4ef2e.js";import{S as ps,i as cs,e as i,s as a,c as o,h as os,a as p,d as s,b as l,f as ts,g as r,j as c,k as Me,l as rs,m as t,n as g,t as u,o as h,p as f}from"../chunks/index.abc433bf.js";import{C as gs}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as d}from"../chunks/CodeBlock.18a16f91.js";import{H as m,E as us}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function hs($n){let j,we,_e,Ue,w,xe,U,Ie,x,kn=`Inference Endpoints provides a secure production solution to easily deploy any <code>transformers</code>, <code>sentence-transformers</code>, and <code>diffusers</code> models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>.
In this guide, we will learn how to programmatically manage Inference Endpoints with <code>huggingface_hub</code>. For more information about the Inference Endpoints product itself, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.`,Te,I,En='This guide assumes <code>huggingface_hub</code> is correctly installed and that your machine is logged in. Check out the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">Quick Start guide</a> if that’s not the case yet. The minimal version supporting Inference Endpoints API is <code>v0.19.0</code>.',$e,y,Cn='<p><strong>New:</strong> it is now possible to deploy an Inference Endpoint from the <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">HF model catalog</a> with a simple API call. The catalog is a carefully curated list of models that can be deployed with optimized settings. You don’t need to configure anything, we take all the heavy stuff on us! All models and settings are guaranteed to have been tested to provide best cost/performance balance.  <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> works the same as <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>, with much less parameters to pass. You can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_catalog">list_inference_catalog()</a> to programmatically retrieve the catalog.</p> <p>Note that this is still an experimental feature. Let us know what you think if you use it!</p>',ke,T,Ee,$,Jn='The first step is to create an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>:',Ce,k,Je,E,vn='In this example, we created a <code>protected</code> Inference Endpoint named <code>&quot;my-endpoint-name&quot;</code>, to serve <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> for <code>text-generation</code>. A <code>protected</code> Inference Endpoint means your token is required to access the API. We also need to provide additional information to configure the hardware requirements, such as vendor, region, accelerator, instance type, and size. You can check out the list of available resources <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">here</a>. Alternatively, you can create an Inference Endpoint manually using the <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">Web interface</a> for convenience. Refer to this <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">guide</a> for details on advanced settings and their usage.',ve,C,Wn='The value returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a> is an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object:',We,J,Ze,v,Zn="It’s a dataclass that holds information about the endpoint. You can access important attributes such as <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code>, etc. If you need it, you can also access the raw response from the server with <code>endpoint.raw</code>.",qe,W,qn='Once your Inference Endpoint is created, you can find it on your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">personal dashboard</a>.',He,Z,Hn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',Ae,q,Qe,H,An='By default the Inference Endpoint is built from a docker image provided by Hugging Face. However, it is possible to specify any docker image using the <code>custom_image</code> parameter. A common use case is to run LLMs using the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> framework. This can be done like this:',Be,A,Le,Q,Qn='The value to pass as <code>custom_image</code> is a dictionary containing a url to the docker container and configuration to run it. For more details about it, checkout the <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aendpoint/create_endpoint" rel="nofollow">Swagger documentation</a>.',Ve,B,Ge,L,Bn='In some cases, you might need to manage Inference Endpoints you created previously. If you know the name, you can fetch it using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>, which returns an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object. Alternatively, you can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to retrieve a list of all Inference Endpoints. Both methods accept an optional <code>namespace</code> parameter. You can set the <code>namespace</code> to any organization you are a part of. Otherwise, it defaults to your username.',Xe,V,Ye,G,Ne,X,Ln='In the rest of this guide, we will assume that we have a <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object called <code>endpoint</code>. You might have noticed that the endpoint has a <code>status</code> attribute of type <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>. When the Inference Endpoint is deployed and accessible, the status should be <code>&quot;running&quot;</code> and the <code>url</code> attribute is set:',Re,Y,ze,N,Vn='Before reaching a <code>&quot;running&quot;</code> state, the Inference Endpoint typically goes through an <code>&quot;initializing&quot;</code> or <code>&quot;pending&quot;</code> phase. You can fetch the new state of the endpoint by running <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>. Like every other method from <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> that makes a request to the server, the internal attributes of <code>endpoint</code> are mutated in place:',Se,R,Fe,z,Gn='Instead of fetching the Inference Endpoint status while waiting for it to run, you can directly call <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>. This helper takes as input a <code>timeout</code> and a <code>fetch_every</code> parameter (in seconds) and will block the thread until the Inference Endpoint is deployed. Default values are respectively <code>None</code> (no timeout) and <code>5</code> seconds.',Pe,S,Ke,F,Xn="If <code>timeout</code> is set and the Inference Endpoint takes too much time to load, a <code>InferenceEndpointTimeoutError</code> timeout error is raised.",Oe,P,De,K,Yn="Once your Inference Endpoint is up and running, you can finally run inference on it!",en,O,Nn='<a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> has two properties <code>client</code> and <code>async_client</code> returning respectively an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> objects.',nn,D,sn,ee,Rn='If the Inference Endpoint is not running, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> exception is raised:',tn,ne,an,se,zn='For more details about how to use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>, check out the <a href="../guides/inference">Inference guide</a>.',ln,te,pn,ae,Sn="Now that we saw how to create an Inference Endpoint and run inference on it, let’s see how to manage its lifecycle.",cn,M,Fn='<p>In this section, we will see methods like <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a>. All of those methods are aliases added to <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> for convenience. If you prefer, you can also use the generic methods defined in <code>HfApi</code>: <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a>, and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>.</p>',on,le,rn,ie,Pn='To reduce costs when your Inference Endpoint is not in use, you can choose to either pause it using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a> or scale it to zero using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>.',gn,_,Kn='<p>An Inference Endpoint that is <em>paused</em> or <em>scaled to zero</em> doesn’t cost anything. The difference between those two is that a <em>paused</em> endpoint needs to be explicitly <em>resumed</em> using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>. On the contrary, a <em>scaled to zero</em> endpoint will automatically start if an inference call is made to it, with an additional cold start delay. An Inference Endpoint can also be configured to scale to zero automatically after a certain period of inactivity.</p>',un,pe,hn,ce,fn,oe,On='In some cases, you might also want to update your Inference Endpoint without creating a new one. You can either update the hosted model or the hardware requirements to run the model. You can do this using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>:',dn,re,mn,ge,jn,ue,Dn="Finally if you won’t use the Inference Endpoint anymore, you can simply call <code>~InferenceEndpoint.delete()</code>.",yn,b,es="<p>This is a non-revertible action that will completely remove the endpoint, including its configuration, logs and usage metrics. You cannot restore a deleted Inference Endpoint.</p>",Mn,he,_n,fe,ns="A typical use case of Inference Endpoints is to process a batch of jobs at once to limit the infrastructure costs. You can automate this process using what we saw in this guide:",bn,de,wn,me,ss="Or if your Inference Endpoint already exists and is paused:",Un,je,xn,ye,In,be,Tn;return w=new gs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new m({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),T=new m({props:{title:"Create an Inference Endpoint",local:"create-an-inference-endpoint",headingTag:"h2"}}),k=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),J=new d({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),q=new m({props:{title:"Using a custom image",local:"using-a-custom-image",headingTag:"h4"}}),A=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new m({props:{title:"Get or list existing Inference Endpoints",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),V=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># Get one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># List all endpoints from an organization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># List all endpoints from all organizations the user belongs to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),G=new m({props:{title:"Check deployment status",local:"check-deployment-status",headingTag:"h2"}}),Y=new d({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),R=new d({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),S=new d({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># Pending endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Wait 10s =&gt; raises a InferenceEndpointTimeoutError</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># Wait more</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),P=new m({props:{title:"Run inference",local:"run-inference",headingTag:"h2"}}),D=new d({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># Run text_generation task:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># Or in an asyncio context:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),ne=new d({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),te=new m({props:{title:"Manage lifecycle",local:"manage-lifecycle",headingTag:"h2"}}),le=new m({props:{title:"Pause or scale to zero",local:"pause-or-scale-to-zero",headingTag:"h3"}}),pe=new d({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># Pause and resume endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># Scale to zero</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># Endpoint is not &#x27;running&#x27; but still has a URL and will restart on first call.</span>`,wrap:!1}}),ce=new m({props:{title:"Update model or hardware requirements",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),re=new d({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMng0JTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMik=",highlighted:`<span class="hljs-comment"># Change target model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update number of replicas</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update to larger instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;x4&quot;</span>, instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),ge=new m({props:{title:"Delete the endpoint",local:"delete-the-endpoint",headingTag:"h3"}}),he=new m({props:{title:"An end-to-end example",local:"an-end-to-end-example",headingTag:"h2"}}),de=new d({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># Start endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># Or with asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),je=new d({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># Get endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),ye=new us({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference_endpoints.md"}}),{c(){j=i("meta"),we=a(),_e=i("p"),Ue=a(),o(w.$$.fragment),xe=a(),o(U.$$.fragment),Ie=a(),x=i("p"),x.innerHTML=kn,Te=a(),I=i("p"),I.innerHTML=En,$e=a(),y=i("blockquote"),y.innerHTML=Cn,ke=a(),o(T.$$.fragment),Ee=a(),$=i("p"),$.innerHTML=Jn,Ce=a(),o(k.$$.fragment),Je=a(),E=i("p"),E.innerHTML=vn,ve=a(),C=i("p"),C.innerHTML=Wn,We=a(),o(J.$$.fragment),Ze=a(),v=i("p"),v.innerHTML=Zn,qe=a(),W=i("p"),W.innerHTML=qn,He=a(),Z=i("p"),Z.innerHTML=Hn,Ae=a(),o(q.$$.fragment),Qe=a(),H=i("p"),H.innerHTML=An,Be=a(),o(A.$$.fragment),Le=a(),Q=i("p"),Q.innerHTML=Qn,Ve=a(),o(B.$$.fragment),Ge=a(),L=i("p"),L.innerHTML=Bn,Xe=a(),o(V.$$.fragment),Ye=a(),o(G.$$.fragment),Ne=a(),X=i("p"),X.innerHTML=Ln,Re=a(),o(Y.$$.fragment),ze=a(),N=i("p"),N.innerHTML=Vn,Se=a(),o(R.$$.fragment),Fe=a(),z=i("p"),z.innerHTML=Gn,Pe=a(),o(S.$$.fragment),Ke=a(),F=i("p"),F.innerHTML=Xn,Oe=a(),o(P.$$.fragment),De=a(),K=i("p"),K.textContent=Yn,en=a(),O=i("p"),O.innerHTML=Nn,nn=a(),o(D.$$.fragment),sn=a(),ee=i("p"),ee.innerHTML=Rn,tn=a(),o(ne.$$.fragment),an=a(),se=i("p"),se.innerHTML=zn,ln=a(),o(te.$$.fragment),pn=a(),ae=i("p"),ae.textContent=Sn,cn=a(),M=i("blockquote"),M.innerHTML=Fn,on=a(),o(le.$$.fragment),rn=a(),ie=i("p"),ie.innerHTML=Pn,gn=a(),_=i("blockquote"),_.innerHTML=Kn,un=a(),o(pe.$$.fragment),hn=a(),o(ce.$$.fragment),fn=a(),oe=i("p"),oe.innerHTML=On,dn=a(),o(re.$$.fragment),mn=a(),o(ge.$$.fragment),jn=a(),ue=i("p"),ue.innerHTML=Dn,yn=a(),b=i("blockquote"),b.innerHTML=es,Mn=a(),o(he.$$.fragment),_n=a(),fe=i("p"),fe.textContent=ns,bn=a(),o(de.$$.fragment),wn=a(),me=i("p"),me.textContent=ss,Un=a(),o(je.$$.fragment),xn=a(),o(ye.$$.fragment),In=a(),be=i("p"),this.h()},l(e){const n=os("svelte-u9bgzb",document.head);j=p(n,"META",{name:!0,content:!0}),n.forEach(s),we=l(e),_e=p(e,"P",{}),ts(_e).forEach(s),Ue=l(e),r(w.$$.fragment,e),xe=l(e),r(U.$$.fragment,e),Ie=l(e),x=p(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-188e6gz"&&(x.innerHTML=kn),Te=l(e),I=p(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1ds3okp"&&(I.innerHTML=En),$e=l(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(y)!=="svelte-15rzt9v"&&(y.innerHTML=Cn),ke=l(e),r(T.$$.fragment,e),Ee=l(e),$=p(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-cqit0a"&&($.innerHTML=Jn),Ce=l(e),r(k.$$.fragment,e),Je=l(e),E=p(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1stw0yf"&&(E.innerHTML=vn),ve=l(e),C=p(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1v18sfy"&&(C.innerHTML=Wn),We=l(e),r(J.$$.fragment,e),Ze=l(e),v=p(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-dxdc75"&&(v.innerHTML=Zn),qe=l(e),W=p(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1tjw294"&&(W.innerHTML=qn),He=l(e),Z=p(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1tajtyl"&&(Z.innerHTML=Hn),Ae=l(e),r(q.$$.fragment,e),Qe=l(e),H=p(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-j6tvxe"&&(H.innerHTML=An),Be=l(e),r(A.$$.fragment,e),Le=l(e),Q=p(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-33b9op"&&(Q.innerHTML=Qn),Ve=l(e),r(B.$$.fragment,e),Ge=l(e),L=p(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1w1xfgf"&&(L.innerHTML=Bn),Xe=l(e),r(V.$$.fragment,e),Ye=l(e),r(G.$$.fragment,e),Ne=l(e),X=p(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-y5xy0k"&&(X.innerHTML=Ln),Re=l(e),r(Y.$$.fragment,e),ze=l(e),N=p(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-13dlhqv"&&(N.innerHTML=Vn),Se=l(e),r(R.$$.fragment,e),Fe=l(e),z=p(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-qtkg7n"&&(z.innerHTML=Gn),Pe=l(e),r(S.$$.fragment,e),Ke=l(e),F=p(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1g2lxsg"&&(F.innerHTML=Xn),Oe=l(e),r(P.$$.fragment,e),De=l(e),K=p(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-un9pgy"&&(K.textContent=Yn),en=l(e),O=p(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-kz23iw"&&(O.innerHTML=Nn),nn=l(e),r(D.$$.fragment,e),sn=l(e),ee=p(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1p192s5"&&(ee.innerHTML=Rn),tn=l(e),r(ne.$$.fragment,e),an=l(e),se=p(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-ruirtr"&&(se.innerHTML=zn),ln=l(e),r(te.$$.fragment,e),pn=l(e),ae=p(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-16mqpnz"&&(ae.textContent=Sn),cn=l(e),M=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-xds5cz"&&(M.innerHTML=Fn),on=l(e),r(le.$$.fragment,e),rn=l(e),ie=p(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-iiep7b"&&(ie.innerHTML=Pn),gn=l(e),_=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-qqf1d4"&&(_.innerHTML=Kn),un=l(e),r(pe.$$.fragment,e),hn=l(e),r(ce.$$.fragment,e),fn=l(e),oe=p(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1s19g4k"&&(oe.innerHTML=On),dn=l(e),r(re.$$.fragment,e),mn=l(e),r(ge.$$.fragment,e),jn=l(e),ue=p(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1j2n6pp"&&(ue.innerHTML=Dn),yn=l(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(b)!=="svelte-1xzlwcl"&&(b.innerHTML=es),Mn=l(e),r(he.$$.fragment,e),_n=l(e),fe=p(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-r11tzs"&&(fe.textContent=ns),bn=l(e),r(de.$$.fragment,e),wn=l(e),me=p(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-u5cd5i"&&(me.textContent=ss),Un=l(e),r(je.$$.fragment,e),xn=l(e),r(ye.$$.fragment,e),In=l(e),be=p(e,"P",{}),ts(be).forEach(s),this.h()},h(){Me(j,"name","hf:doc:metadata"),Me(j,"content",fs),Me(y,"class","tip"),Me(M,"class","tip"),Me(_,"class","tip"),Me(b,"class","warning")},m(e,n){rs(document.head,j),t(e,we,n),t(e,_e,n),t(e,Ue,n),g(w,e,n),t(e,xe,n),g(U,e,n),t(e,Ie,n),t(e,x,n),t(e,Te,n),t(e,I,n),t(e,$e,n),t(e,y,n),t(e,ke,n),g(T,e,n),t(e,Ee,n),t(e,$,n),t(e,Ce,n),g(k,e,n),t(e,Je,n),t(e,E,n),t(e,ve,n),t(e,C,n),t(e,We,n),g(J,e,n),t(e,Ze,n),t(e,v,n),t(e,qe,n),t(e,W,n),t(e,He,n),t(e,Z,n),t(e,Ae,n),g(q,e,n),t(e,Qe,n),t(e,H,n),t(e,Be,n),g(A,e,n),t(e,Le,n),t(e,Q,n),t(e,Ve,n),g(B,e,n),t(e,Ge,n),t(e,L,n),t(e,Xe,n),g(V,e,n),t(e,Ye,n),g(G,e,n),t(e,Ne,n),t(e,X,n),t(e,Re,n),g(Y,e,n),t(e,ze,n),t(e,N,n),t(e,Se,n),g(R,e,n),t(e,Fe,n),t(e,z,n),t(e,Pe,n),g(S,e,n),t(e,Ke,n),t(e,F,n),t(e,Oe,n),g(P,e,n),t(e,De,n),t(e,K,n),t(e,en,n),t(e,O,n),t(e,nn,n),g(D,e,n),t(e,sn,n),t(e,ee,n),t(e,tn,n),g(ne,e,n),t(e,an,n),t(e,se,n),t(e,ln,n),g(te,e,n),t(e,pn,n),t(e,ae,n),t(e,cn,n),t(e,M,n),t(e,on,n),g(le,e,n),t(e,rn,n),t(e,ie,n),t(e,gn,n),t(e,_,n),t(e,un,n),g(pe,e,n),t(e,hn,n),g(ce,e,n),t(e,fn,n),t(e,oe,n),t(e,dn,n),g(re,e,n),t(e,mn,n),g(ge,e,n),t(e,jn,n),t(e,ue,n),t(e,yn,n),t(e,b,n),t(e,Mn,n),g(he,e,n),t(e,_n,n),t(e,fe,n),t(e,bn,n),g(de,e,n),t(e,wn,n),t(e,me,n),t(e,Un,n),g(je,e,n),t(e,xn,n),g(ye,e,n),t(e,In,n),t(e,be,n),Tn=!0},p:ls,i(e){Tn||(u(w.$$.fragment,e),u(U.$$.fragment,e),u(T.$$.fragment,e),u(k.$$.fragment,e),u(J.$$.fragment,e),u(q.$$.fragment,e),u(A.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(R.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(ne.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(re.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(de.$$.fragment,e),u(je.$$.fragment,e),u(ye.$$.fragment,e),Tn=!0)},o(e){h(w.$$.fragment,e),h(U.$$.fragment,e),h(T.$$.fragment,e),h(k.$$.fragment,e),h(J.$$.fragment,e),h(q.$$.fragment,e),h(A.$$.fragment,e),h(B.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(re.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(je.$$.fragment,e),h(ye.$$.fragment,e),Tn=!1},d(e){e&&(s(we),s(_e),s(Ue),s(xe),s(Ie),s(x),s(Te),s(I),s($e),s(y),s(ke),s(Ee),s($),s(Ce),s(Je),s(E),s(ve),s(C),s(We),s(Ze),s(v),s(qe),s(W),s(He),s(Z),s(Ae),s(Qe),s(H),s(Be),s(Le),s(Q),s(Ve),s(Ge),s(L),s(Xe),s(Ye),s(Ne),s(X),s(Re),s(ze),s(N),s(Se),s(Fe),s(z),s(Pe),s(Ke),s(F),s(Oe),s(De),s(K),s(en),s(O),s(nn),s(sn),s(ee),s(tn),s(an),s(se),s(ln),s(pn),s(ae),s(cn),s(M),s(on),s(rn),s(ie),s(gn),s(_),s(un),s(hn),s(fn),s(oe),s(dn),s(mn),s(jn),s(ue),s(yn),s(b),s(Mn),s(_n),s(fe),s(bn),s(wn),s(me),s(Un),s(xn),s(In),s(be)),s(j),f(w,e),f(U,e),f(T,e),f(k,e),f(J,e),f(q,e),f(A,e),f(B,e),f(V,e),f(G,e),f(Y,e),f(R,e),f(S,e),f(P,e),f(D,e),f(ne,e),f(te,e),f(le,e),f(pe,e),f(ce,e),f(re,e),f(ge,e),f(he,e),f(de,e),f(je,e),f(ye,e)}}}const fs='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Create an Inference Endpoint","local":"create-an-inference-endpoint","sections":[{"title":"Using a custom image","local":"using-a-custom-image","sections":[],"depth":4},{"title":"Get or list existing Inference Endpoints","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Check deployment status","local":"check-deployment-status","sections":[],"depth":2},{"title":"Run inference","local":"run-inference","sections":[],"depth":2},{"title":"Manage lifecycle","local":"manage-lifecycle","sections":[{"title":"Pause or scale to zero","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"Update model or hardware requirements","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"Delete the endpoint","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"An end-to-end example","local":"an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function ds($n){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ps{constructor(j){super(),cs(this,j,ds,hs,as,{})}}export{bs as component};
