import{s as Ya,n as Ra,o as Va}from"../chunks/scheduler.0cf4ef2e.js";import{S as La,i as Sa,e as p,s as l,c,h as Xa,a as i,d as e,b as n,f as Qa,g as u,j as o,k as d,l as Aa,m as a,n as h,t as r,o as m,p as j}from"../chunks/index.abc433bf.js";import{C as za}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as g}from"../chunks/CodeBlock.18a16f91.js";import{H as y,E as Fa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function Pa(Qe){let M,et,st,at,_,lt,C,nt,v,Ye=`The Hugging Face Hub provides compute for AI and data workflows via Jobs.
A job runs on Hugging Face infrastructure and are defined with a command to run (e.g. a python command), a Docker Image from Hugging Face Spaces or Docker Hub, and a hardware flavor (CPU, GPU, TPU). This guide will show you how to interact with Jobs on the Hub, especially:`,pt,k,Re="<li>Run a job.</li> <li>Check job status.</li> <li>Select the hardware.</li> <li>Configure environment variables and secrets.</li> <li>Run UV scripts.</li>",it,q,Ve=`If you want to run and manage a job on the Hub, your machine must be logged in. If you are not, please refer to
<a href="../quick-start#authentication">this section</a>. In the rest of this guide, we will assume that your machine is logged in.`,ot,b,Le='<p><strong>Hugging Face Jobs</strong> are available only to <a href="https://huggingface.co/pro" rel="nofollow">Pro users</a> and <a href="https://huggingface.co/enterprise" rel="nofollow">Team or Enterprise organizations</a>. Upgrade your plan to get started!</p>',ct,$,ut,G,Se='Use the <a href="./cli#hf-jobs"><code>hf jobs</code> CLI</a> to run Jobs from the command line, and pass <code>--flavor</code> to specify your hardware.',ht,W,Xe="<code>hf jobs run</code> runs Jobs with a Docker image and a command with a familiar Docker-like interface. Think <code>docker run</code>, but for running code on any hardware:",rt,Z,mt,B,Ae="Use <code>hf jobs uv run</code> to run local or remote UV scripts:",jt,x,gt,H,ze='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax defined in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',yt,E,Fe=`Now the rest of this guide will show you the python API.
If you would like to view all the available <code>hf jobs</code> commands and options instead, check out the <a href="./cli#hf-jobs">guide on the <code>hf jobs</code> command line interface</a>.`,Mt,N,dt,Q,Pe="Run compute Jobs defined with a command and a Docker Image on Hugging Face infrastructure (including GPUs and TPUs).",bt,Y,De=`You can only manage Jobs that you own (under your username namespace) or from organizations in which you have write permissions.
This feature is pay-as-you-go: you only pay for the seconds you use.`,ft,R,Ke='<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> lets you run any command on Hugging Face’s infrastructure:',Jt,V,Tt,f,Oe='<p><strong>Important</strong>: Jobs have a default timeout (30 minutes), after which they will automatically stop. For long-running tasks like model training, make sure to set a custom timeout using the <code>timeout</code> parameter. See <a href="#configure-job-timeout">Configure Job Timeout</a> for details.</p>',wt,L,sa=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> returns the <a href="/docs/huggingface_hub/main/en/package_reference/jobs#huggingface_hub.JobInfo">JobInfo</a> which has the URL of the Job on Hugging Face, where you can see the Job status and the logs.
Save the Job ID from <a href="/docs/huggingface_hub/main/en/package_reference/jobs#huggingface_hub.JobInfo">JobInfo</a> to manage the job:`,Ut,S,It,X,ta='Jobs run in the background. The next section guides you through <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_job">inspect_job()</a> to know a jobs’ status and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.fetch_job_logs">fetch_job_logs()</a> to view the logs.',_t,A,Ct,z,vt,F,ea='Check the status of multiple jobs to know when they’re all finished using a loop and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_job">inspect_job()</a>:',kt,P,qt,D,$t,K,aa="There are numerous cases where running Jobs on GPUs are useful:",Gt,O,la="<li><strong>Model Training</strong>: Fine-tune or train models on GPUs (T4, A10G, A100) without managing infrastructure</li> <li><strong>Synthetic Data Generation</strong>: Generate large-scale datasets using LLMs on powerful hardware</li> <li><strong>Data Processing</strong>: Process massive datasets with high-CPU configurations for parallel workloads</li> <li><strong>Batch Inference</strong>: Run offline inference on thousands of samples using optimized GPU setups</li> <li><strong>Experiments &amp; Benchmarks</strong>: Run ML experiments on consistent hardware for reproducible results</li> <li><strong>Development &amp; Debugging</strong>: Test GPU code without local CUDA setup</li>",Wt,ss,na="Run jobs on GPUs or TPUs with the <code>flavor</code> argument. For example, to run a PyTorch job on an A10G GPU:",Zt,ts,Bt,es,pa="Running this will show the following output!",xt,as,Ht,ls,ia='Use this to run a fine tuning script like <a href="https://github.com/huggingface/trl/blob/main/trl/scripts/sft.py" rel="nofollow">trl/scripts/sft.py</a> with UV:',Et,ns,Nt,J,oa='<p>For comprehensive guidance on running model training jobs with TRL on Hugging Face infrastructure, check out the <a href="https://huggingface.co/docs/trl/main/en/jobs_training" rel="nofollow">TRL Jobs Training documentation</a>. It covers fine-tuning recipes, hardware selection, and best practices for training models efficiently.</p>',Qt,ps,ca="Available <code>flavor</code> options:",Yt,is,ua="<li>CPU: <code>cpu-basic</code>, <code>cpu-upgrade</code></li> <li>GPU: <code>t4-small</code>, <code>t4-medium</code>, <code>l4x1</code>, <code>l4x4</code>, <code>a10g-small</code>, <code>a10g-large</code>, <code>a10g-largex2</code>, <code>a10g-largex4</code>,<code>a100-large</code></li> <li>TPU: <code>v5e-1x1</code>, <code>v5e-2x2</code>, <code>v5e-2x4</code></li>",Rt,os,ha='(updated in 07/2025 from Hugging Face <a href="https://huggingface.co/docs/hub/en/spaces-config-reference" rel="nofollow">suggested_hardware docs</a>)',Vt,cs,ra="That’s it! You’re now running code on Hugging Face’s infrastructure.",Lt,us,St,hs,ma="Jobs have a default timeout (30 minutes), after which they will automatically stop. This is important to know when running long-running tasks like model training.",Xt,rs,At,ms,ja="You can specify a custom timeout value using the <code>timeout</code> parameter when running a job. The timeout can be specified in two ways:",zt,js,ga="<li><strong>As a number</strong> (interpreted as seconds):</li>",Ft,gs,Pt,T,ya="<li><strong>As a string with time units</strong>:</li>",Dt,ys,Kt,Ms,Ma="Supported time units:",Ot,ds,da="<li><code>s</code> - seconds</li> <li><code>m</code> - minutes</li> <li><code>h</code> - hours</li> <li><code>d</code> - days</li>",se,bs,te,fs,ba="For UV jobs, you can also specify the timeout:",ee,Js,ae,w,fa="<p>If you don’t specify a timeout, a default timeout will be applied to your job. For long-running tasks like model training that may take hours, make sure to set an appropriate timeout to avoid unexpected job terminations.</p>",le,Ts,ne,ws,Ja="When running long tasks, it’s good practice to:",pe,Us,Ta="<li>Estimate your job’s expected duration and set a timeout with some buffer</li> <li>Monitor your job’s progress through the logs</li> <li>Check the job status to ensure it hasn’t timed out</li>",ie,Is,oe,_s,wa='For more details about the timeout parameter, see the <a href="https://huggingface.co/docs/huggingface_hub/package_reference/hf_api#huggingface_hub.HfApi.run_job.timeout" rel="nofollow"><code>run_job</code> API reference</a>.',ce,Cs,ue,vs,Ua="You can pass environment variables to your job using <code>env</code> and <code>secrets</code>:",he,ks,re,qs,me,$s,je,U,Ia='<p>Looking for ready-to-use UV scripts? Check out the <a href="https://huggingface.co/uv-scripts" rel="nofollow">uv-scripts organization</a> on the Hugging Face Hub, which offers a community collection of UV scripts for tasks like model training, synthetic data generation, data processing, and more.</p>',ge,Gs,_a="Run UV scripts (Python scripts with inline dependencies) on HF infrastructure:",ye,Ws,Me,Zs,Ca='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax. This makes them perfect for self-contained tasks that don’t require complex project setups. Learn more about UV scripts in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',de,Bs,be,xs,va="While UV scripts can specify their dependencies inline, ML workloads often have complex dependencies. Using pre-built Docker images with these libraries already installed can significantly speed up job startup and avoid dependency issues.",fe,Hs,ka="By default, when you run <code>hf jobs uv run</code> the <code>astral-sh/uv:python3.12-bookworm</code> image is used. This image is based on the Python 3.12 Bookworm distribution with uv pre-installed.",Je,Es,qa="You can specify a different image using the <code>--image</code> flag:",Te,Ns,we,Qs,$a="The above command will run using the <code>vllm/vllm-openai:latest</code> image. This approach could be useful if you are using vLLM for synthetic data generation.",Ue,I,Ga="<p>Many inference frameworks provide optimized docker images. As uv is increasingly adopted in the Python ecosystem more of these will also have uv pre-installed meaning they will work when using hf jobs uv run.</p>",Ie,Ys,_e,Rs,Wa="Schedule and manage jobs that will run on HF infrastructure.",Ce,Vs,Za='Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_scheduled_job">create_scheduled_job()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_scheduled_uv_job">create_scheduled_uv_job()</a> with a schedule of <code>@annually</code>, <code>@yearly</code>, <code>@monthly</code>, <code>@weekly</code>, <code>@daily</code>, <code>@hourly</code>, or a CRON schedule expression (e.g., <code>&quot;0 9 * * 1&quot;</code> for 9 AM every Monday):',ve,Ls,ke,Ss,Ba='Use the same parameters as <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job">run_job()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_uv_job">run_uv_job()</a> to pass environment variables, secrets, timeout, etc.',qe,Xs,xa='Manage scheduled jobs using <code>list_scheduled_jobs</code>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_scheduled_job">inspect_scheduled_job()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.suspend_scheduled_job">suspend_scheduled_job()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_scheduled_job">resume_scheduled_job()</a>, and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_scheduled_job">delete_scheduled_job()</a>:',$e,As,Ge,zs,We,Fs,Ha="Webhooks allow you to listen for new changes on specific repos or to all repos belonging to particular set of users/organizations (not just your repos, but any repo).",Ze,Ps,Ea='Use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_webhook">create_webhook()</a> to create a webhook that triggers a Job when a change happens in a Hugging Face repository:',Be,Ds,xe,Ks,Na=`The webhook triggers the Job with the webhook payload in the environment variable <code>WEBHOOK_PAYLOAD</code>.
You can find more information on webhooks in the <a href="./webhooks">Webhooks documentation</a>.`,He,Os,Ee,tt,Ne;return _=new za({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new y({props:{title:"Run and manage Jobs",local:"run-and-manage-jobs",headingTag:"h1"}}),$=new y({props:{title:"Jobs Command Line Interface",local:"jobs-command-line-interface",headingTag:"h2"}}),Z=new g({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJTIycHJpbnQoJ0hlbGxvJTIwd29ybGQhJyklMjIlMEFoZiUyMGpvYnMlMjBydW4lMjAtLWZsYXZvciUyMGExMGctc21hbGwlMjBweXRvcmNoJTJGcHl0b3JjaCUzQTIuNi4wLWN1ZGExMi40LWN1ZG5uOS1kZXZlbCUyMHB5dGhvbiUyMC1jJTIwJTIyaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludCh0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgpKSUyMg==",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run python:3.12 python -c <span class="hljs-string">&quot;print(&#x27;Hello world!&#x27;)&quot;</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>`,wrap:!1}}),x=new g({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjBteV9zY3JpcHQucHklMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMC0tZmxhdm9yJTIwYTEwZy1zbWFsbCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJsJTJGbWFpbiUyRnRybCUyRnNjcmlwdHMlMkZzZnQucHklMjIlMjA=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run --flavor a10g-small <span class="hljs-string">&quot;https://raw.githubusercontent.com/huggingface/trl/main/trl/scripts/sft.py&quot;</span> `,wrap:!1}}),N=new y({props:{title:"Run a Job",local:"run-a-job",headingTag:"h2"}}),V=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdIZWxsbyUyMGZyb20lMjB0aGUlMjBjbG91ZCEnKSUyMiU1RCUyQyUwQSklMEElMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KHRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCkpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSklMEElMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdSdW5uaW5nJTIwaW4lMjBhbiUyMG9yZyUyMGFjY291bnQnKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG5hbWVzcGFjZSUzRCUyMm15LW9yZy1uYW1lJTIyJTJDJTBBKSUwQSUwQXJ1bl9qb2IoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJoZi5jbyUyRnNwYWNlcyUyRmxob2VzdHElMkZkdWNrZGIlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIyZHVja2RiJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJzZWxlY3QlMjAnaGVsbG8lMjB3b3JsZCclMjIlNUQlMkMlMEEpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMik=",highlighted:`<span class="hljs-comment"># Directly run Python code</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Use GPUs without any setup</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run in an organization account</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Running in an org account&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    namespace=<span class="hljs-string">&quot;my-org-name&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run from Hugging Face Spaces</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;hf.co/spaces/lhoestq/duckdb&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;duckdb&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;select &#x27;hello world&#x27;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Run a Python script with \`uv\` (experimental)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>)`,wrap:!1}}),S=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFqb2IlMjAlM0QlMjBydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMnByaW50KCdIZWxsbyUyMGZyb20lMjB0aGUlMjBjbG91ZCEnKSUyMiU1RCUwQSklMEFqb2IudXJsJTBBam9iLmlk",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>job.url
https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a
<span class="hljs-meta">&gt;&gt;&gt; </span>job.<span class="hljs-built_in">id</span>
687f911eaea852de79c4a50a`,wrap:!1}}),A=new y({props:{title:"Check Job status",local:"check-job-status",headingTag:"h2"}}),z=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfam9icyUwQWpvYnMlMjAlM0QlMjBsaXN0X2pvYnMoKSUwQWpvYnMlNUIwJTVEJTBBJTBBcnVubmluZ19qb2JzJTIwJTNEJTIwJTVCam9iJTIwZm9yJTIwam9iJTIwaW4lMjBsaXN0X2pvYnMoKSUyMGlmJTIwam9iLnN0YXR1cy5zdGFnZSUyMCUzRCUzRCUyMCUyMlJVTk5JTkclMjIlNUQlMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwaW5zcGVjdF9qb2IlMEFpbnNwZWN0X2pvYihqb2JfaWQlM0Rqb2JfaWQpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGZldGNoX2pvYl9sb2dzJTBBZm9yJTIwbG9nJTIwaW4lMjBmZXRjaF9qb2JfbG9ncyhqb2JfaWQlM0Rqb2JfaWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobG9nKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjYW5jZWxfam9iJTBBY2FuY2VsX2pvYihqb2JfaWQlM0Rqb2JfaWQp",highlighted:`<span class="hljs-comment"># List your jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_jobs
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs = list_jobs()
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs[<span class="hljs-number">0</span>]
JobInfo(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;687f911eaea852de79c4a50a&#x27;</span>, created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">22</span>, <span class="hljs-number">13</span>, <span class="hljs-number">24</span>, <span class="hljs-number">46</span>, <span class="hljs-number">909000</span>, tzinfo=datetime.timezone.utc), docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>, space_id=<span class="hljs-literal">None</span>, command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>], arguments=[], environment={}, secrets={}, flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>, status=JobStatus(stage=<span class="hljs-string">&#x27;COMPLETED&#x27;</span>, message=<span class="hljs-literal">None</span>), owner=JobOwner(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;5e9ecfc04957053f60648a3e&#x27;</span>, name=<span class="hljs-string">&#x27;lhoestq&#x27;</span>), endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, url=<span class="hljs-string">&#x27;https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a&#x27;</span>)

<span class="hljs-comment"># List your running jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>running_jobs = [job <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> list_jobs() <span class="hljs-keyword">if</span> job.status.stage == <span class="hljs-string">&quot;RUNNING&quot;</span>]

<span class="hljs-comment"># Inspect the status of a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_job(job_id=job_id)
JobInfo(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;687f911eaea852de79c4a50a&#x27;</span>, created_at=datetime.datetime(<span class="hljs-number">2025</span>, <span class="hljs-number">7</span>, <span class="hljs-number">22</span>, <span class="hljs-number">13</span>, <span class="hljs-number">24</span>, <span class="hljs-number">46</span>, <span class="hljs-number">909000</span>, tzinfo=datetime.timezone.utc), docker_image=<span class="hljs-string">&#x27;python:3.12&#x27;</span>, space_id=<span class="hljs-literal">None</span>, command=[<span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;-c&#x27;</span>, <span class="hljs-string">&quot;print(&#x27;Hello from the cloud!&#x27;)&quot;</span>], arguments=[], environment={}, secrets={}, flavor=<span class="hljs-string">&#x27;cpu-basic&#x27;</span>, status=JobStatus(stage=<span class="hljs-string">&#x27;COMPLETED&#x27;</span>, message=<span class="hljs-literal">None</span>), owner=JobOwner(<span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;5e9ecfc04957053f60648a3e&#x27;</span>, name=<span class="hljs-string">&#x27;lhoestq&#x27;</span>), endpoint=<span class="hljs-string">&#x27;https://huggingface.co&#x27;</span>, url=<span class="hljs-string">&#x27;https://huggingface.co/jobs/lhoestq/687f911eaea852de79c4a50a&#x27;</span>)

<span class="hljs-comment"># View logs from a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> fetch_job_logs
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job_id=job_id):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(log)
Hello <span class="hljs-keyword">from</span> the cloud!

<span class="hljs-comment"># Cancel a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cancel_job
<span class="hljs-meta">&gt;&gt;&gt; </span>cancel_job(job_id=job_id)`,wrap:!1}}),P=new g({props:{code:"aW1wb3J0JTIwdGltZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBpbnNwZWN0X2pvYiUyQyUyMHJ1bl9qb2IlMEFqb2JzJTIwJTNEJTIwJTVCcnVuX2pvYihpbWFnZSUzRGltYWdlJTJDJTIwY29tbWFuZCUzRGNvbW1hbmQpJTIwZm9yJTIwY29tbWFuZCUyMGluJTIwY29tbWFuZHMlNUQlMEFmb3IlMjBqb2IlMjBpbiUyMGpvYnMlM0ElMEElMjAlMjAlMjAlMjB3aGlsZSUyMGluc3BlY3Rfam9iKGpvYl9pZCUzRGpvYi5pZCkuc3RhdHVzLnN0YWdlJTIwbm90JTIwaW4lMjAoJTIyQ09NUExFVEVEJTIyJTJDJTIwJTIyRVJST1IlMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZS5zbGVlcCgxMCk=",highlighted:`<span class="hljs-comment"># Run multiple jobs in parallel and wait for their completions</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>jobs = [run_job(image=image, command=command) <span class="hljs-keyword">for</span> command <span class="hljs-keyword">in</span> commands]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">while</span> inspect_job(job_id=job.<span class="hljs-built_in">id</span>).status.stage <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> (<span class="hljs-string">&quot;COMPLETED&quot;</span>, <span class="hljs-string">&quot;ERROR&quot;</span>):
<span class="hljs-meta">... </span>        time.sleep(<span class="hljs-number">10</span>)`,wrap:!1}}),D=new y({props:{title:"Select the hardware",local:"select-the-hardware",headingTag:"h2"}}),ts=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIyLWMlMjIlMkMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KGYnVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCcpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Use an A10G GPU to check PyTorch CUDA</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import torch; print(f&#x27;This code ran with the following GPU: {torch.cuda.get_device_name()}&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),as=new g({props:{code:"VGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwTlZJRElBJTIwQTEwRw==",highlighted:"This code ran with the following GPU: NVIDIA A10G",wrap:!1}}),ns=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUwQSUyMCUyMCUyMCUyMCUyMnNmdC5weSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjcmlwdF9hcmdzJTNEJTVCJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjAlMjJRd2VuJTJGUXdlbjItMC41QiUyMiUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRlcGVuZGVuY2llcyUzRCU1QiUyMnRybCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMkhGX1RPS0VOJTIyJTNBJTIwLi4uJTdEJTJDJTBBJTIwJTIwJTIwJTIwZmxhdm9yJTNEJTIyYTEwZy1zbWFsbCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sft.py&quot;</span>,
<span class="hljs-meta">... </span>    script_args=[<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-string">&quot;Qwen/Qwen2-0.5B&quot;</span>, ...],
<span class="hljs-meta">... </span>    dependencies=[<span class="hljs-string">&quot;trl&quot;</span>],
<span class="hljs-meta">... </span>    env={<span class="hljs-string">&quot;HF_TOKEN&quot;</span>: ...},
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),us=new y({props:{title:"Configure Job Timeout",local:"configure-job-timeout",headingTag:"h2"}}),rs=new y({props:{title:"Setting a custom timeout",local:"setting-a-custom-timeout",headingTag:"h3"}}),gs=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFqb2IlMjAlM0QlMjBydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIydHJhaW5fbW9kZWwucHklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmbGF2b3IlM0QlMjJhMTBnLWxhcmdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGltZW91dCUzRDcyMDAlMkMlMjAlMjAlMjMlMjAyJTIwaG91cnMlMjBpbiUyMHNlY29uZHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;train_model.py&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-large&quot;</span>,
<span class="hljs-meta">... </span>    timeout=<span class="hljs-number">7200</span>,  <span class="hljs-comment"># 2 hours in seconds</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ys=new g({props:{code:"JTIzJTIwVXNpbmclMjBkaWZmZXJlbnQlMjB0aW1lJTIwdW5pdHMlMEFqb2IlMjAlM0QlMjBydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIydHJhaW5fbW9kZWwucHklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmbGF2b3IlM0QlMjJhMTBnLWxhcmdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGltZW91dCUzRCUyMjJoJTIyJTJDJTIwJTIwJTIzJTIwMiUyMGhvdXJzJTBBKSUwQSUwQSUyMyUyME90aGVyJTIwZXhhbXBsZXMlM0ElMEElMjMlMjB0aW1lb3V0JTNEJTIyMzBtJTIyJTIwJTIwJTIwJTIwJTIzJTIwMzAlMjBtaW51dGVzJTBBJTIzJTIwdGltZW91dCUzRCUyMjEuNWglMjIlMjAlMjAlMjAlMjMlMjAxLjUlMjBob3VycyUwQSUyMyUyMHRpbWVvdXQlM0QlMjIxZCUyMiUyMCUyMCUyMCUyMCUyMCUyMyUyMDElMjBkYXklMEElMjMlMjB0aW1lb3V0JTNEJTIyMzYwMHMlMjIlMjAlMjAlMjMlMjAzNjAwJTIwc2Vjb25kcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using different time units</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;train_model.py&quot;</span>],
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-large&quot;</span>,
<span class="hljs-meta">... </span>    timeout=<span class="hljs-string">&quot;2h&quot;</span>,  <span class="hljs-comment"># 2 hours</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Other examples:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;30m&quot;    # 30 minutes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;1.5h&quot;   # 1.5 hours</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;1d&quot;     # 1 day</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># timeout=&quot;3600s&quot;  # 3600 seconds</span>`,wrap:!1}}),bs=new y({props:{title:"Using timeout with UV jobs",local:"using-timeout-with-uv-jobs",headingTag:"h3"}}),Js=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFqb2IlMjAlM0QlMjBydW5fdXZfam9iKCUwQSUyMCUyMCUyMCUyMCUyMnRyYWluaW5nX3NjcmlwdC5weSUyMiUyQyUwQSUyMCUyMCUyMCUyMGZsYXZvciUzRCUyMmExMGctbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0aW1lb3V0JTNEJTIyOTBtJTIyJTJDJTIwJTIwJTIzJTIwOTAlMjBtaW51dGVzJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>job = run_uv_job(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;training_script.py&quot;</span>,
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-large&quot;</span>,
<span class="hljs-meta">... </span>    timeout=<span class="hljs-string">&quot;90m&quot;</span>,  <span class="hljs-comment"># 90 minutes</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ts=new y({props:{title:"Monitoring job duration",local:"monitoring-job-duration",headingTag:"h3"}}),Is=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGluc3BlY3Rfam9iJTJDJTIwZmV0Y2hfam9iX2xvZ3MlMEElMjMlMjBDaGVjayUyMGpvYiUyMHN0YXR1cyUwQWpvYl9pbmZvJTIwJTNEJTIwaW5zcGVjdF9qb2Ioam9iX2lkJTNEam9iLmlkKSUwQWlmJTIwam9iX2luZm8uc3RhdHVzLnN0YWdlJTIwJTNEJTNEJTIwJTIyRVJST1IlMjIlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIySm9iJTIwZmFpbGVkJTNBJTIwJTdCam9iX2luZm8uc3RhdHVzLm1lc3NhZ2UlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2hlY2slMjBsb2dzJTIwZm9yJTIwbW9yZSUyMGRldGFpbHMlMEElMjAlMjAlMjAlMjBmb3IlMjBsb2clMjBpbiUyMGZldGNoX2pvYl9sb2dzKGpvYl9pZCUzRGpvYi5pZCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChsb2cp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_job, fetch_job_logs
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Check job status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>job_info = inspect_job(job_id=job.<span class="hljs-built_in">id</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> job_info.status.stage == <span class="hljs-string">&quot;ERROR&quot;</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Job failed: <span class="hljs-subst">{job_info.status.message}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Check logs for more details</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> fetch_job_logs(job_id=job.<span class="hljs-built_in">id</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(log)`,wrap:!1}}),Cs=new y({props:{title:"Pass Environment variables and Secrets",local:"pass-environment-variables-and-secrets",headingTag:"h2"}}),ks=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidGT08nJTVEJTJDJTIwb3MuZW52aXJvbiU1QidCQVInJTVEKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMkZPTyUyMiUzQSUyMCUyMmZvbyUyMiUyQyUyMCUyMkJBUiUyMiUzQSUyMCUyMmJhciUyMiU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Pass environment variables</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import os; print(os.environ[&#x27;FOO&#x27;], os.environ[&#x27;BAR&#x27;])&quot;</span>],
<span class="hljs-meta">... </span>    env={<span class="hljs-string">&quot;FOO&quot;</span>: <span class="hljs-string">&quot;foo&quot;</span>, <span class="hljs-string">&quot;BAR&quot;</span>: <span class="hljs-string">&quot;bar&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),qs=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl9qb2IlMEFydW5fam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0aG9uJTNBMy4xMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlNUIlMjJweXRob24lMjIlMkMlMjAlMjItYyUyMiUyQyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidNWV9TRUNSRVQnJTVEKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlN0IlMjJNWV9TRUNSRVQlMjIlM0ElMjAlMjJwc3N3cmQlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-comment"># Pass secrets - they will be encrypted server side</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import os; print(os.environ[&#x27;MY_SECRET&#x27;])&quot;</span>],
<span class="hljs-meta">... </span>    secrets={<span class="hljs-string">&quot;MY_SECRET&quot;</span>: <span class="hljs-string">&quot;psswrd&quot;</span>},
<span class="hljs-meta">... </span>)`,wrap:!1}}),$s=new y({props:{title:"UV Scripts (Experimental)",local:"uv-scripts-experimental",headingTag:"h3"}}),Ws=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHJ1bl91dl9qb2IlMEFydW5fdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMiklMEElMEFydW5fdXZfam9iKCUyMm1sX3RyYWluaW5nLnB5JTIyJTJDJTIwZmxhdm9yJTNEJTIyZ3B1LXQ0LXNtYWxsJTIyKSUwQSUwQXJ1bl91dl9qb2IoJTIyaW5mZXJlbmNlLnB5JTIyJTJDJTIwZGVwZW5kZW5jaWVzJTNEJTVCJTIydHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIydG9yY2glMjIlNUQpJTBBJTBBcnVuX3V2X2pvYiglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZ1c2VybmFtZSUyRnNjcmlwdHMlMkZyZXNvbHZlJTJGbWFpbiUyRmV4YW1wbGUucHklMjIpJTBBJTBBcnVuX3V2X2pvYiglMjJweXRob24lMjIlMkMlMjBzY3JpcHRfYXJncyUzRCU1QiUyMi1jJTIyJTJDJTIwJTIyaW1wb3J0JTIwbGlnaHRldmFsJTIyJTVEJTJDJTIwZGVwZW5kZW5jaWVzJTNEJTVCJTIybGlnaHRldmFsJTIyJTVEKQ==",highlighted:`<span class="hljs-comment"># Run a UV script (creates temporary repo)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> run_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>)

<span class="hljs-comment"># Run with GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;ml_training.py&quot;</span>, flavor=<span class="hljs-string">&quot;gpu-t4-small&quot;</span>)

<span class="hljs-comment"># Run with dependencies</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;inference.py&quot;</span>, dependencies=[<span class="hljs-string">&quot;transformers&quot;</span>, <span class="hljs-string">&quot;torch&quot;</span>])

<span class="hljs-comment"># Run a script directly from a URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;https://huggingface.co/datasets/username/scripts/resolve/main/example.py&quot;</span>)

<span class="hljs-comment"># Run a command</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>run_uv_job(<span class="hljs-string">&quot;python&quot;</span>, script_args=[<span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;import lighteval&quot;</span>], dependencies=[<span class="hljs-string">&quot;lighteval&quot;</span>])`,wrap:!1}}),Bs=new y({props:{title:"Docker Images for UV Scripts",local:"docker-images-for-uv-scripts",headingTag:"h4"}}),Ns=new g({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjAlNUMlMEElMjAtLWZsYXZvciUyMGExMGctbGFyZ2UlMjAlNUMlMEElMjAtLWltYWdlJTIwdmxsbSUyRnZsbG0tb3BlbmFpJTNBbGF0ZXN0JTIwJTVDJTBBLi4u",highlighted:`hf <span class="hljs-built_in">jobs</span> uv run \\
 --flavor a10g-large \\
 --image vllm/vllm-openai:latest \\
...`,wrap:!1}}),Ys=new y({props:{title:"Scheduled Jobs",local:"scheduled-jobs",headingTag:"h3"}}),Ls=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9zY2hlZHVsZWRfam9iJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ1RoaXMlMjBydW5zJTIwZXZlcnklMjBob3VyIScpJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGUlM0QlMjIlNDBob3VybHklMjIlMEEpJTBBJTBBY3JlYXRlX3NjaGVkdWxlZF9qb2IoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJweXRob24lM0EzLjEyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ1RoaXMlMjBydW5zJTIwZXZlcnklMjA1JTIwbWludXRlcyEnKSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlJTNEJTIyKiUyRjUlMjAqJTIwKiUyMColMjAqJTIyJTBBKSUwQSUwQWNyZWF0ZV9zY2hlZHVsZWRfam9iKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEJTIycHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTVCJTIycHl0aG9uJTIyJTJDJTIwJTIwJTIyLWMlMjIlMkMlMjAnaW1wb3J0JTIwdG9yY2glM0IlMjBwcmludChmJTIyVGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCUyMiknJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGUlM0QlMjIlNDBob3VybHklMjIlMkMlMEElMjAlMjAlMjAlMjBmbGF2b3IlM0QlMjJhMTBnLXNtYWxsJTIyJTJDJTBBKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfc2NoZWR1bGVkX3V2X2pvYiUwQWNyZWF0ZV9zY2hlZHVsZWRfdXZfam9iKCUyMm15X3NjcmlwdC5weSUyMiUyQyUyMHNjaGVkdWxlJTNEJTIyJTQwaG91cmx5JTIyKQ==",highlighted:`<span class="hljs-comment"># Schedule a job that runs every hour</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>,  <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;This runs every hour!&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    schedule=<span class="hljs-string">&quot;@hourly&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Use the CRON syntax</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;python:3.12&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>,  <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;This runs every 5 minutes!&#x27;)&quot;</span>],
<span class="hljs-meta">... </span>    schedule=<span class="hljs-string">&quot;*/5 * * * *&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Schedule with GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_job(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel&quot;</span>,
<span class="hljs-meta">... </span>    command=[<span class="hljs-string">&quot;python&quot;</span>,  <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&#x27;import torch; print(f&quot;This code ran with the following GPU: {torch.cuda.get_device_name()}&quot;)&#x27;</span>],
<span class="hljs-meta">... </span>    schedule=<span class="hljs-string">&quot;@hourly&quot;</span>,
<span class="hljs-meta">... </span>    flavor=<span class="hljs-string">&quot;a10g-small&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Schedule a UV script</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_scheduled_uv_job
<span class="hljs-meta">&gt;&gt;&gt; </span>create_scheduled_uv_job(<span class="hljs-string">&quot;my_script.py&quot;</span>, schedule=<span class="hljs-string">&quot;@hourly&quot;</span>)`,wrap:!1}}),As=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3Rfc2NoZWR1bGVkX2pvYnMlMEFsaXN0X3NjaGVkdWxlZF9qb2JzKCklMEElMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwaW5zcGVjdF9zY2hlZHVsZWRfam9iJTBBaW5zcGVjdF9zY2hlZHVsZWRfam9iKHNjaGVkdWxlZF9qb2JfaWQpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHN1c3BlbmRfc2NoZWR1bGVkX2pvYiUwQXN1c3BlbmRfc2NoZWR1bGVkX2pvYihzY2hlZHVsZWRfam9iX2lkKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjByZXN1bWVfc2NoZWR1bGVkX2pvYiUwQXJlc3VtZV9zY2hlZHVsZWRfam9iKHNjaGVkdWxlZF9qb2JfaWQpJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGRlbGV0ZV9zY2hlZHVsZWRfam9iJTBBZGVsZXRlX3NjaGVkdWxlZF9qb2Ioc2NoZWR1bGVkX2pvYl9pZCk=",highlighted:`<span class="hljs-comment"># List your active scheduled jobs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_scheduled_jobs
<span class="hljs-meta">&gt;&gt;&gt; </span>list_scheduled_jobs()

<span class="hljs-comment"># Inspect the status of a job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> inspect_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>inspect_scheduled_job(scheduled_job_id)

<span class="hljs-comment"># Suspend (pause) a scheduled job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> suspend_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>suspend_scheduled_job(scheduled_job_id)

<span class="hljs-comment"># Resume a scheduled job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> resume_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>resume_scheduled_job(scheduled_job_id)

<span class="hljs-comment"># Delete a scheduled job</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> delete_scheduled_job
<span class="hljs-meta">&gt;&gt;&gt; </span>delete_scheduled_job(scheduled_job_id)`,wrap:!1}}),zs=new y({props:{title:"Trigger Jobs with webhooks",local:"trigger-jobs-with-webhooks",headingTag:"h3"}}),Ds=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV93ZWJob29rJTBBJTBBJTIzJTIwRXhhbXBsZSUzQSUyMENyZWF0aW5nJTIwYSUyMHdlYmhvb2slMjB0aGF0JTIwdHJpZ2dlcnMlMjBhJTIwSm9iJTBBd2ViaG9vayUyMCUzRCUyMGNyZWF0ZV93ZWJob29rKCUwQSUyMCUyMCUyMCUyMGpvYl9pZCUzRGpvYl9pZCUyQyUwQSUyMCUyMCUyMCUyMHdhdGNoZWQlM0QlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJ5b3VyLXVzZXJuYW1lJTIyJTdEJTJDJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMm9yZyUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJ5b3VyLW9yZy1uYW1lJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwZG9tYWlucyUzRCU1QiUyMnJlcG8lMjIlMkMlMjAlMjJkaXNjdXNzaW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2VjcmV0JTNEJTIyeW91ci1zZWNyZXQlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_webhook

<span class="hljs-comment"># Example: Creating a webhook that triggers a Job</span>
webhook = create_webhook(
    job_id=job_id,
    watched=[{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-username&quot;</span>}, {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;org&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;your-org-name&quot;</span>}],
    domains=[<span class="hljs-string">&quot;repo&quot;</span>, <span class="hljs-string">&quot;discussion&quot;</span>],
    secret=<span class="hljs-string">&quot;your-secret&quot;</span>
)`,wrap:!1}}),Os=new Fa({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/jobs.md"}}),{c(){M=p("meta"),et=l(),st=p("p"),at=l(),c(_.$$.fragment),lt=l(),c(C.$$.fragment),nt=l(),v=p("p"),v.textContent=Ye,pt=l(),k=p("ul"),k.innerHTML=Re,it=l(),q=p("p"),q.innerHTML=Ve,ot=l(),b=p("blockquote"),b.innerHTML=Le,ct=l(),c($.$$.fragment),ut=l(),G=p("p"),G.innerHTML=Se,ht=l(),W=p("p"),W.innerHTML=Xe,rt=l(),c(Z.$$.fragment),mt=l(),B=p("p"),B.innerHTML=Ae,jt=l(),c(x.$$.fragment),gt=l(),H=p("p"),H.innerHTML=ze,yt=l(),E=p("p"),E.innerHTML=Fe,Mt=l(),c(N.$$.fragment),dt=l(),Q=p("p"),Q.textContent=Pe,bt=l(),Y=p("p"),Y.textContent=De,ft=l(),R=p("p"),R.innerHTML=Ke,Jt=l(),c(V.$$.fragment),Tt=l(),f=p("blockquote"),f.innerHTML=Oe,wt=l(),L=p("p"),L.innerHTML=sa,Ut=l(),c(S.$$.fragment),It=l(),X=p("p"),X.innerHTML=ta,_t=l(),c(A.$$.fragment),Ct=l(),c(z.$$.fragment),vt=l(),F=p("p"),F.innerHTML=ea,kt=l(),c(P.$$.fragment),qt=l(),c(D.$$.fragment),$t=l(),K=p("p"),K.textContent=aa,Gt=l(),O=p("ul"),O.innerHTML=la,Wt=l(),ss=p("p"),ss.innerHTML=na,Zt=l(),c(ts.$$.fragment),Bt=l(),es=p("p"),es.textContent=pa,xt=l(),c(as.$$.fragment),Ht=l(),ls=p("p"),ls.innerHTML=ia,Et=l(),c(ns.$$.fragment),Nt=l(),J=p("blockquote"),J.innerHTML=oa,Qt=l(),ps=p("p"),ps.innerHTML=ca,Yt=l(),is=p("ul"),is.innerHTML=ua,Rt=l(),os=p("p"),os.innerHTML=ha,Vt=l(),cs=p("p"),cs.textContent=ra,Lt=l(),c(us.$$.fragment),St=l(),hs=p("p"),hs.textContent=ma,Xt=l(),c(rs.$$.fragment),At=l(),ms=p("p"),ms.innerHTML=ja,zt=l(),js=p("ol"),js.innerHTML=ga,Ft=l(),c(gs.$$.fragment),Pt=l(),T=p("ol"),T.innerHTML=ya,Dt=l(),c(ys.$$.fragment),Kt=l(),Ms=p("p"),Ms.textContent=Ma,Ot=l(),ds=p("ul"),ds.innerHTML=da,se=l(),c(bs.$$.fragment),te=l(),fs=p("p"),fs.textContent=ba,ee=l(),c(Js.$$.fragment),ae=l(),w=p("blockquote"),w.innerHTML=fa,le=l(),c(Ts.$$.fragment),ne=l(),ws=p("p"),ws.textContent=Ja,pe=l(),Us=p("ul"),Us.innerHTML=Ta,ie=l(),c(Is.$$.fragment),oe=l(),_s=p("p"),_s.innerHTML=wa,ce=l(),c(Cs.$$.fragment),ue=l(),vs=p("p"),vs.innerHTML=Ua,he=l(),c(ks.$$.fragment),re=l(),c(qs.$$.fragment),me=l(),c($s.$$.fragment),je=l(),U=p("blockquote"),U.innerHTML=Ia,ge=l(),Gs=p("p"),Gs.textContent=_a,ye=l(),c(Ws.$$.fragment),Me=l(),Zs=p("p"),Zs.innerHTML=Ca,de=l(),c(Bs.$$.fragment),be=l(),xs=p("p"),xs.textContent=va,fe=l(),Hs=p("p"),Hs.innerHTML=ka,Je=l(),Es=p("p"),Es.innerHTML=qa,Te=l(),c(Ns.$$.fragment),we=l(),Qs=p("p"),Qs.innerHTML=$a,Ue=l(),I=p("blockquote"),I.innerHTML=Ga,Ie=l(),c(Ys.$$.fragment),_e=l(),Rs=p("p"),Rs.textContent=Wa,Ce=l(),Vs=p("p"),Vs.innerHTML=Za,ve=l(),c(Ls.$$.fragment),ke=l(),Ss=p("p"),Ss.innerHTML=Ba,qe=l(),Xs=p("p"),Xs.innerHTML=xa,$e=l(),c(As.$$.fragment),Ge=l(),c(zs.$$.fragment),We=l(),Fs=p("p"),Fs.textContent=Ha,Ze=l(),Ps=p("p"),Ps.innerHTML=Ea,Be=l(),c(Ds.$$.fragment),xe=l(),Ks=p("p"),Ks.innerHTML=Na,He=l(),c(Os.$$.fragment),Ee=l(),tt=p("p"),this.h()},l(s){const t=Xa("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(e),et=n(s),st=i(s,"P",{}),Qa(st).forEach(e),at=n(s),u(_.$$.fragment,s),lt=n(s),u(C.$$.fragment,s),nt=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-t6wsly"&&(v.textContent=Ye),pt=n(s),k=i(s,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-q7wdvs"&&(k.innerHTML=Re),it=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-7cmlg1"&&(q.innerHTML=Ve),ot=n(s),b=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-686p08"&&(b.innerHTML=Le),ct=n(s),u($.$$.fragment,s),ut=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-nb89vp"&&(G.innerHTML=Se),ht=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-khpb9d"&&(W.innerHTML=Xe),rt=n(s),u(Z.$$.fragment,s),mt=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-2oc699"&&(B.innerHTML=Ae),jt=n(s),u(x.$$.fragment,s),gt=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1jtgrvk"&&(H.innerHTML=ze),yt=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-o9zjjm"&&(E.innerHTML=Fe),Mt=n(s),u(N.$$.fragment,s),dt=n(s),Q=i(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-q7l5as"&&(Q.textContent=Pe),bt=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1rskhba"&&(Y.textContent=De),ft=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1t6shks"&&(R.innerHTML=Ke),Jt=n(s),u(V.$$.fragment,s),Tt=n(s),f=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-tdvi3f"&&(f.innerHTML=Oe),wt=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-pv8bt6"&&(L.innerHTML=sa),Ut=n(s),u(S.$$.fragment,s),It=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-amrg6a"&&(X.innerHTML=ta),_t=n(s),u(A.$$.fragment,s),Ct=n(s),u(z.$$.fragment,s),vt=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-7qiidc"&&(F.innerHTML=ea),kt=n(s),u(P.$$.fragment,s),qt=n(s),u(D.$$.fragment,s),$t=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1egj941"&&(K.textContent=aa),Gt=n(s),O=i(s,"UL",{"data-svelte-h":!0}),o(O)!=="svelte-6zsta5"&&(O.innerHTML=la),Wt=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-14jm2jm"&&(ss.innerHTML=na),Zt=n(s),u(ts.$$.fragment,s),Bt=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-130z5ko"&&(es.textContent=pa),xt=n(s),u(as.$$.fragment,s),Ht=n(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-s6s8yx"&&(ls.innerHTML=ia),Et=n(s),u(ns.$$.fragment,s),Nt=n(s),J=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-94ky9t"&&(J.innerHTML=oa),Qt=n(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-1hwnt8u"&&(ps.innerHTML=ca),Yt=n(s),is=i(s,"UL",{"data-svelte-h":!0}),o(is)!=="svelte-13lveum"&&(is.innerHTML=ua),Rt=n(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-2bse8c"&&(os.innerHTML=ha),Vt=n(s),cs=i(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-u6u7ww"&&(cs.textContent=ra),Lt=n(s),u(us.$$.fragment,s),St=n(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-2n3lu1"&&(hs.textContent=ma),Xt=n(s),u(rs.$$.fragment,s),At=n(s),ms=i(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-1fvqz69"&&(ms.innerHTML=ja),zt=n(s),js=i(s,"OL",{"data-svelte-h":!0}),o(js)!=="svelte-g0lq88"&&(js.innerHTML=ga),Ft=n(s),u(gs.$$.fragment,s),Pt=n(s),T=i(s,"OL",{start:!0,"data-svelte-h":!0}),o(T)!=="svelte-11ooz1t"&&(T.innerHTML=ya),Dt=n(s),u(ys.$$.fragment,s),Kt=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-100e3nu"&&(Ms.textContent=Ma),Ot=n(s),ds=i(s,"UL",{"data-svelte-h":!0}),o(ds)!=="svelte-198b1xe"&&(ds.innerHTML=da),se=n(s),u(bs.$$.fragment,s),te=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-xy3irb"&&(fs.textContent=ba),ee=n(s),u(Js.$$.fragment,s),ae=n(s),w=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1etk62u"&&(w.innerHTML=fa),le=n(s),u(Ts.$$.fragment,s),ne=n(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-yr7qor"&&(ws.textContent=Ja),pe=n(s),Us=i(s,"UL",{"data-svelte-h":!0}),o(Us)!=="svelte-17h393k"&&(Us.innerHTML=Ta),ie=n(s),u(Is.$$.fragment,s),oe=n(s),_s=i(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-1llwhls"&&(_s.innerHTML=wa),ce=n(s),u(Cs.$$.fragment,s),ue=n(s),vs=i(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-cxmn16"&&(vs.innerHTML=Ua),he=n(s),u(ks.$$.fragment,s),re=n(s),u(qs.$$.fragment,s),me=n(s),u($s.$$.fragment,s),je=n(s),U=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-hzmd33"&&(U.innerHTML=Ia),ge=n(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-qbe5en"&&(Gs.textContent=_a),ye=n(s),u(Ws.$$.fragment,s),Me=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-1dnltsa"&&(Zs.innerHTML=Ca),de=n(s),u(Bs.$$.fragment,s),be=n(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-140dfaq"&&(xs.textContent=va),fe=n(s),Hs=i(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-1koilcc"&&(Hs.innerHTML=ka),Je=n(s),Es=i(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-jmg8xs"&&(Es.innerHTML=qa),Te=n(s),u(Ns.$$.fragment,s),we=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1fornbv"&&(Qs.innerHTML=$a),Ue=n(s),I=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-1mw567x"&&(I.innerHTML=Ga),Ie=n(s),u(Ys.$$.fragment,s),_e=n(s),Rs=i(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-1hrxwrr"&&(Rs.textContent=Wa),Ce=n(s),Vs=i(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-3nauxd"&&(Vs.innerHTML=Za),ve=n(s),u(Ls.$$.fragment,s),ke=n(s),Ss=i(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-oorag5"&&(Ss.innerHTML=Ba),qe=n(s),Xs=i(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-d80cwp"&&(Xs.innerHTML=xa),$e=n(s),u(As.$$.fragment,s),Ge=n(s),u(zs.$$.fragment,s),We=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-1cywn1k"&&(Fs.textContent=Ha),Ze=n(s),Ps=i(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-99juyj"&&(Ps.innerHTML=Ea),Be=n(s),u(Ds.$$.fragment,s),xe=n(s),Ks=i(s,"P",{"data-svelte-h":!0}),o(Ks)!=="svelte-1gdy8i7"&&(Ks.innerHTML=Na),He=n(s),u(Os.$$.fragment,s),Ee=n(s),tt=i(s,"P",{}),Qa(tt).forEach(e),this.h()},h(){d(M,"name","hf:doc:metadata"),d(M,"content",Da),d(b,"class","tip"),d(f,"class","warning"),d(J,"class","tip"),d(T,"start","2"),d(w,"class","warning"),d(U,"class","tip"),d(I,"class","tip")},m(s,t){Aa(document.head,M),a(s,et,t),a(s,st,t),a(s,at,t),h(_,s,t),a(s,lt,t),h(C,s,t),a(s,nt,t),a(s,v,t),a(s,pt,t),a(s,k,t),a(s,it,t),a(s,q,t),a(s,ot,t),a(s,b,t),a(s,ct,t),h($,s,t),a(s,ut,t),a(s,G,t),a(s,ht,t),a(s,W,t),a(s,rt,t),h(Z,s,t),a(s,mt,t),a(s,B,t),a(s,jt,t),h(x,s,t),a(s,gt,t),a(s,H,t),a(s,yt,t),a(s,E,t),a(s,Mt,t),h(N,s,t),a(s,dt,t),a(s,Q,t),a(s,bt,t),a(s,Y,t),a(s,ft,t),a(s,R,t),a(s,Jt,t),h(V,s,t),a(s,Tt,t),a(s,f,t),a(s,wt,t),a(s,L,t),a(s,Ut,t),h(S,s,t),a(s,It,t),a(s,X,t),a(s,_t,t),h(A,s,t),a(s,Ct,t),h(z,s,t),a(s,vt,t),a(s,F,t),a(s,kt,t),h(P,s,t),a(s,qt,t),h(D,s,t),a(s,$t,t),a(s,K,t),a(s,Gt,t),a(s,O,t),a(s,Wt,t),a(s,ss,t),a(s,Zt,t),h(ts,s,t),a(s,Bt,t),a(s,es,t),a(s,xt,t),h(as,s,t),a(s,Ht,t),a(s,ls,t),a(s,Et,t),h(ns,s,t),a(s,Nt,t),a(s,J,t),a(s,Qt,t),a(s,ps,t),a(s,Yt,t),a(s,is,t),a(s,Rt,t),a(s,os,t),a(s,Vt,t),a(s,cs,t),a(s,Lt,t),h(us,s,t),a(s,St,t),a(s,hs,t),a(s,Xt,t),h(rs,s,t),a(s,At,t),a(s,ms,t),a(s,zt,t),a(s,js,t),a(s,Ft,t),h(gs,s,t),a(s,Pt,t),a(s,T,t),a(s,Dt,t),h(ys,s,t),a(s,Kt,t),a(s,Ms,t),a(s,Ot,t),a(s,ds,t),a(s,se,t),h(bs,s,t),a(s,te,t),a(s,fs,t),a(s,ee,t),h(Js,s,t),a(s,ae,t),a(s,w,t),a(s,le,t),h(Ts,s,t),a(s,ne,t),a(s,ws,t),a(s,pe,t),a(s,Us,t),a(s,ie,t),h(Is,s,t),a(s,oe,t),a(s,_s,t),a(s,ce,t),h(Cs,s,t),a(s,ue,t),a(s,vs,t),a(s,he,t),h(ks,s,t),a(s,re,t),h(qs,s,t),a(s,me,t),h($s,s,t),a(s,je,t),a(s,U,t),a(s,ge,t),a(s,Gs,t),a(s,ye,t),h(Ws,s,t),a(s,Me,t),a(s,Zs,t),a(s,de,t),h(Bs,s,t),a(s,be,t),a(s,xs,t),a(s,fe,t),a(s,Hs,t),a(s,Je,t),a(s,Es,t),a(s,Te,t),h(Ns,s,t),a(s,we,t),a(s,Qs,t),a(s,Ue,t),a(s,I,t),a(s,Ie,t),h(Ys,s,t),a(s,_e,t),a(s,Rs,t),a(s,Ce,t),a(s,Vs,t),a(s,ve,t),h(Ls,s,t),a(s,ke,t),a(s,Ss,t),a(s,qe,t),a(s,Xs,t),a(s,$e,t),h(As,s,t),a(s,Ge,t),h(zs,s,t),a(s,We,t),a(s,Fs,t),a(s,Ze,t),a(s,Ps,t),a(s,Be,t),h(Ds,s,t),a(s,xe,t),a(s,Ks,t),a(s,He,t),h(Os,s,t),a(s,Ee,t),a(s,tt,t),Ne=!0},p:Ra,i(s){Ne||(r(_.$$.fragment,s),r(C.$$.fragment,s),r($.$$.fragment,s),r(Z.$$.fragment,s),r(x.$$.fragment,s),r(N.$$.fragment,s),r(V.$$.fragment,s),r(S.$$.fragment,s),r(A.$$.fragment,s),r(z.$$.fragment,s),r(P.$$.fragment,s),r(D.$$.fragment,s),r(ts.$$.fragment,s),r(as.$$.fragment,s),r(ns.$$.fragment,s),r(us.$$.fragment,s),r(rs.$$.fragment,s),r(gs.$$.fragment,s),r(ys.$$.fragment,s),r(bs.$$.fragment,s),r(Js.$$.fragment,s),r(Ts.$$.fragment,s),r(Is.$$.fragment,s),r(Cs.$$.fragment,s),r(ks.$$.fragment,s),r(qs.$$.fragment,s),r($s.$$.fragment,s),r(Ws.$$.fragment,s),r(Bs.$$.fragment,s),r(Ns.$$.fragment,s),r(Ys.$$.fragment,s),r(Ls.$$.fragment,s),r(As.$$.fragment,s),r(zs.$$.fragment,s),r(Ds.$$.fragment,s),r(Os.$$.fragment,s),Ne=!0)},o(s){m(_.$$.fragment,s),m(C.$$.fragment,s),m($.$$.fragment,s),m(Z.$$.fragment,s),m(x.$$.fragment,s),m(N.$$.fragment,s),m(V.$$.fragment,s),m(S.$$.fragment,s),m(A.$$.fragment,s),m(z.$$.fragment,s),m(P.$$.fragment,s),m(D.$$.fragment,s),m(ts.$$.fragment,s),m(as.$$.fragment,s),m(ns.$$.fragment,s),m(us.$$.fragment,s),m(rs.$$.fragment,s),m(gs.$$.fragment,s),m(ys.$$.fragment,s),m(bs.$$.fragment,s),m(Js.$$.fragment,s),m(Ts.$$.fragment,s),m(Is.$$.fragment,s),m(Cs.$$.fragment,s),m(ks.$$.fragment,s),m(qs.$$.fragment,s),m($s.$$.fragment,s),m(Ws.$$.fragment,s),m(Bs.$$.fragment,s),m(Ns.$$.fragment,s),m(Ys.$$.fragment,s),m(Ls.$$.fragment,s),m(As.$$.fragment,s),m(zs.$$.fragment,s),m(Ds.$$.fragment,s),m(Os.$$.fragment,s),Ne=!1},d(s){s&&(e(et),e(st),e(at),e(lt),e(nt),e(v),e(pt),e(k),e(it),e(q),e(ot),e(b),e(ct),e(ut),e(G),e(ht),e(W),e(rt),e(mt),e(B),e(jt),e(gt),e(H),e(yt),e(E),e(Mt),e(dt),e(Q),e(bt),e(Y),e(ft),e(R),e(Jt),e(Tt),e(f),e(wt),e(L),e(Ut),e(It),e(X),e(_t),e(Ct),e(vt),e(F),e(kt),e(qt),e($t),e(K),e(Gt),e(O),e(Wt),e(ss),e(Zt),e(Bt),e(es),e(xt),e(Ht),e(ls),e(Et),e(Nt),e(J),e(Qt),e(ps),e(Yt),e(is),e(Rt),e(os),e(Vt),e(cs),e(Lt),e(St),e(hs),e(Xt),e(At),e(ms),e(zt),e(js),e(Ft),e(Pt),e(T),e(Dt),e(Kt),e(Ms),e(Ot),e(ds),e(se),e(te),e(fs),e(ee),e(ae),e(w),e(le),e(ne),e(ws),e(pe),e(Us),e(ie),e(oe),e(_s),e(ce),e(ue),e(vs),e(he),e(re),e(me),e(je),e(U),e(ge),e(Gs),e(ye),e(Me),e(Zs),e(de),e(be),e(xs),e(fe),e(Hs),e(Je),e(Es),e(Te),e(we),e(Qs),e(Ue),e(I),e(Ie),e(_e),e(Rs),e(Ce),e(Vs),e(ve),e(ke),e(Ss),e(qe),e(Xs),e($e),e(Ge),e(We),e(Fs),e(Ze),e(Ps),e(Be),e(xe),e(Ks),e(He),e(Ee),e(tt)),e(M),j(_,s),j(C,s),j($,s),j(Z,s),j(x,s),j(N,s),j(V,s),j(S,s),j(A,s),j(z,s),j(P,s),j(D,s),j(ts,s),j(as,s),j(ns,s),j(us,s),j(rs,s),j(gs,s),j(ys,s),j(bs,s),j(Js,s),j(Ts,s),j(Is,s),j(Cs,s),j(ks,s),j(qs,s),j($s,s),j(Ws,s),j(Bs,s),j(Ns,s),j(Ys,s),j(Ls,s),j(As,s),j(zs,s),j(Ds,s),j(Os,s)}}}const Da='{"title":"Run and manage Jobs","local":"run-and-manage-jobs","sections":[{"title":"Jobs Command Line Interface","local":"jobs-command-line-interface","sections":[],"depth":2},{"title":"Run a Job","local":"run-a-job","sections":[],"depth":2},{"title":"Check Job status","local":"check-job-status","sections":[],"depth":2},{"title":"Select the hardware","local":"select-the-hardware","sections":[],"depth":2},{"title":"Configure Job Timeout","local":"configure-job-timeout","sections":[{"title":"Setting a custom timeout","local":"setting-a-custom-timeout","sections":[],"depth":3},{"title":"Using timeout with UV jobs","local":"using-timeout-with-uv-jobs","sections":[],"depth":3},{"title":"Monitoring job duration","local":"monitoring-job-duration","sections":[],"depth":3}],"depth":2},{"title":"Pass Environment variables and Secrets","local":"pass-environment-variables-and-secrets","sections":[{"title":"UV Scripts (Experimental)","local":"uv-scripts-experimental","sections":[{"title":"Docker Images for UV Scripts","local":"docker-images-for-uv-scripts","sections":[],"depth":4}],"depth":3},{"title":"Scheduled Jobs","local":"scheduled-jobs","sections":[],"depth":3},{"title":"Trigger Jobs with webhooks","local":"trigger-jobs-with-webhooks","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ka(Qe){return Va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ll extends La{constructor(M){super(),Sa(this,M,Ka,Pa,Ya,{})}}export{ll as component};
