import{s as $n,n as Rn,o as On}from"../chunks/scheduler.0cf4ef2e.js";import{S as Fn,i as Dn,e as i,s as a,c,h as Yn,a as T,d as t,b as n,f as _n,g as o,j as M,k as sa,l as Ln,m as s,n as d,t as h,o as J,p as r}from"../chunks/index.abc433bf.js";import{C as Bn}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as U}from"../chunks/CodeBlock.18a16f91.js";import{H as p,E as Gn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function En(aa){let y,Ol,$l,Fl,m,Dl,I,Yl,j,na="<code>huggingface_hub</code> utilizes the local disk as two caches, which avoid re-downloading items again. The first cache is a file-based cache, which caches individual files downloaded from the Hub and ensures that the same file is not downloaded again when a repo gets updated. The second cache is a chunk cache, where each chunk represents a byte range from a file and ensures that chunks that are shared across files are only downloaded once.",Ll,u,Bl,C,ia=`The Hugging Face Hub cache-system is designed to be the central cache shared across libraries
that depend on the Hub. It has been updated in v0.8.0 to prevent re-downloading same files
between revisions.`,Gl,g,Ta="The caching system is designed as follows:",El,b,Vl,A,Ma="The default <code>&lt;CACHE_DIR&gt;</code> is <code>~/.cache/huggingface/hub</code>. However, it is customizable with the <code>cache_dir</code> argument on all methods, or by specifying either <code>HF_HOME</code> or <code>HF_HUB_CACHE</code> environment variable.",Wl,k,ca=`Models, datasets and spaces share a common root. Each of these repositories contains the
repository type, the namespace (organization or username) if it exists and the
repository name:`,Sl,N,Hl,v,oa=`It is within these folders that all files will now be downloaded from the Hub. Caching ensures that
a file isn’t downloaded twice if it already exists and wasn’t updated; but if it was updated,
and you’re asking for the latest file, then it will download the latest file (while keeping
the previous file intact in case you need it again).`,zl,Z,da="In order to achieve this, all folders contain the same skeleton:",Xl,Q,Pl,x,ha="Each folder is designed to contain the following:",ql,_,Kl,$,Ja=`The <code>refs</code> folder contains files which indicates the latest revision of the given reference. For example,
if we have previously fetched a file from the <code>main</code> branch of a repository, the <code>refs</code>
folder will contain a file named <code>main</code>, which will itself contain the commit identifier of the current head.`,et,R,ra="If the latest commit of <code>main</code> has <code>aaaaaa</code> as identifier, then it will contain <code>aaaaaa</code>.",lt,O,Ua=`If that same branch gets updated with a new commit, that has <code>bbbbbb</code> as an identifier, then
re-downloading a file from that reference will update the <code>refs/main</code> file to contain <code>bbbbbb</code>.`,tt,F,st,D,pa="The <code>blobs</code> folder contains the actual files that we have downloaded. The name of each file is their hash.",at,Y,nt,L,ya=`The <code>snapshots</code> folder contains symlinks to the blobs mentioned above. It is itself made up of several folders:
one per known revision!`,it,B,wa=`In the explanation above, we had initially fetched a file from the <code>aaaaaa</code> revision, before fetching a file from
the <code>bbbbbb</code> revision. In this situation, we would now have two folders in the <code>snapshots</code> folder: <code>aaaaaa</code>
and <code>bbbbbb</code>.`,Tt,G,fa=`In each of these folders, live symlinks that have the names of the files that we have downloaded. For example,
if we had downloaded the <code>README.md</code> file at revision <code>aaaaaa</code>, we would have the following path:`,Mt,E,ct,V,ma="That <code>README.md</code> file is actually a symlink linking to the blob that has the hash of the file.",ot,W,Ia=`By creating the skeleton this way we open the mechanism to file sharing: if the same file was fetched in
revision <code>bbbbbb</code>, it would have the same hash and the file would not need to be re-downloaded.`,dt,S,ht,H,ja=`In addition to the <code>blobs</code>, <code>refs</code> and <code>snapshots</code> folders, you might also find a <code>.no_exist</code> folder
in your cache. This folder keeps track of files that you’ve tried to download once but don’t exist
on the Hub. Its structure is the same as the <code>snapshots</code> folder with 1 subfolder per known revision:`,Jt,z,rt,X,ua=`Unlike the <code>snapshots</code> folder, files are simple empty files (no symlinks). In this example,
the file <code>&quot;config_that_does_not_exist.json&quot;</code> does not exist on the Hub for the revision <code>&quot;aaaaaa&quot;</code>.
As it only stores empty files, this folder is neglectable in term of disk usage.`,Ut,P,Ca=`So now you might wonder, why is this information even relevant?
In some cases, a framework tries to load optional files for a model. Saving the non-existence
of optional files makes it faster to load a model as it saves 1 HTTP call per possible optional file.
This is for example the case in <code>transformers</code> where each tokenizer can support additional files.
The first time you load the tokenizer on your machine, it will cache which optional files exist (and
which doesn’t) to make the loading time faster for the next initializations.`,pt,q,ga=`To test if a file is cached locally (without making any HTTP request), you can use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.try_to_load_from_cache">try_to_load_from_cache()</a>
helper. It will either return the filepath (if exists and cached), the object <code>_CACHED_NO_EXIST</code> (if non-existence
is cached) or <code>None</code> (if we don’t know).`,yt,K,wt,ee,ft,le,ba="In practice, your cache should look like the following tree:",mt,te,It,se,jt,ae,Aa=`In order to have an efficient cache-system, <code>huggingface-hub</code> uses symlinks. However,
symlinks are not supported on all machines. This is a known limitation especially on
Windows. When this is the case, <code>huggingface_hub</code> do not use the <code>blobs/</code> directory but
directly stores the files in the <code>snapshots/</code> directory instead. This workaround allows
users to download and cache files from the Hub exactly the same way. Tools to inspect
and delete the cache (see below) are also supported. However, the cache-system is less
efficient as a single file might be downloaded several times if multiple revisions of
the same repo is downloaded.`,ut,ne,ka=`If you want to benefit from the symlink-based cache-system on a Windows machine, you
either need to <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">activate Developer Mode</a>
or to run Python as an administrator.`,Ct,ie,Na=`When symlinks are not supported, a warning message is displayed to the user to alert
them they are using a degraded version of the cache-system. This warning can be disabled
by setting the <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> environment variable to true.`,gt,Te,bt,Me,va='To provide more efficient file transfers, <code>hf_xet</code> adds a <code>xet</code> directory to the existing <code>huggingface_hub</code> cache, creating additional caching layer to enable chunk-based deduplication. This cache holds chunks (immutable byte ranges of files ~64KB in size) and shards (a data structure that maps files to chunks). For more information on the Xet Storage system, see this <a href="https://huggingface.co/docs/hub/xet/index" rel="nofollow">section</a>.',At,ce,Za="The <code>xet</code> directory, located at <code>~/.cache/huggingface/xet</code> by default, contains two caches, utilized for uploads and downloads. It has the following structure:",kt,oe,Nt,de,Qa='The <code>environment_identifier</code> directory is an encoded string (it may appear on your machine as <code>https___cas_serv-tGqkUaZf_CBPHQ6h</code>). This is used during development allowing for local and production versions of the cache to exist alongside each other simultaneously. It is also used when downloading from repositories that reside in different <a href="https://huggingface.co/docs/hub/storage-regions" rel="nofollow">storage regions</a>. You may see multiple such entries in the <code>xet</code> directory, each corresponding to a different environment, but their internal structure is the same.',vt,he,xa="The internal directories serve the following purposes:",Zt,Je,_a="<li><code>chunk-cache</code> contains cached data chunks that are used to speed up downloads.</li> <li><code>shard-cache</code> contains cached shards that are utilized on the upload path.</li> <li><code>staging</code> is a workspace designed to support resumable uploads.</li>",Qt,re,$a="These are documented below.",xt,Ue,Ra="Note that the <code>xet</code> caching system, like the rest of <code>hf_xet</code> is fully integrated with <code>huggingface_hub</code>.  If you use the existing APIs for interacting with cached assets, there is no need to update your workflow. The <code>xet</code> caches are built as an optimization layer on top of the existing <code>hf_xet</code> chunk-based deduplication and <code>huggingface_hub</code> cache system.",_t,pe,$t,ye,Oa="This cache is used on the download path. The cache directory structure is based on a base-64 encoded hash from the content-addressed store (CAS) that backs each Xet-enabled repository. A CAS hash serves as the key to lookup the offsets of where the data is stored. Note: as of <code>hf_xet</code> 1.2.0 the chunk_cache is disabled by default. To enable it, set the <code>HF_XET_CHUNK_CACHE_SIZE_BYTES</code> environment variable to the appropriate size prior to launching the Python process.",Rt,we,Fa="At the topmost level, the first two letters of the base 64 encoded CAS hash are used to create a subdirectory in the <code>chunk_cache</code> (keys that share these first two letters are grouped here).  The inner levels are comprised of subdirectories with the full key as the directory name. At the base are the cache items which are ranges of blocks that contain the cached chunks.",Ot,fe,Ft,me,Da="When requesting a file, the first thing <code>hf_xet</code> does is communicate with Xet storage’s content addressed store (CAS) for reconstruction information. The reconstruction information contains information about the CAS keys required to download the file in its entirety.",Dt,Ie,Ya="Before executing the requests for the CAS keys, the <code>chunk_cache</code> is consulted. If a key in the cache matches a CAS key, then there is no reason to issue a request for that content. <code>hf_xet</code> uses the chunks stored in the directory instead.",Yt,je,La="As the <code>chunk_cache</code> is purely an optimization, not a guarantee, <code>hf_xet</code> utilizes a computationally efficient eviction policy. When the <code>chunk_cache</code> is full (see <code>Limits and Limitations</code> below), <code>hf_xet</code> implements a random eviction policy when selecting an eviction candidate. This significantly reduces the overhead of managing a robust caching system (e.g., LRU) while still providing most of the benefits of caching chunks.",Lt,ue,Bt,Ce,Ba="This cache is used when uploading content to the Hub. The directory is flat, comprising only of shard files, each using an ID for the shard name.",Gt,ge,Et,be,Ga="The <code>shard_cache</code> contains shards that are:",Vt,Ae,Ea="<li>Locally generated and successfully uploaded to the CAS</li> <li>Downloaded from CAS as part of the global deduplication algorithm</li>",Wt,ke,Va="Shards provide a mapping between files and chunks. During uploads, each file is chunked and the hash of the chunk is saved. Every shard in the cache is then consulted. If a shard contains a chunk hash that is present in the local file being uploaded, then that chunk can be discarded as it is already stored in CAS.",St,Ne,Wa="All shards have an expiration date of 3-4 weeks from when they are downloaded. Shards that are expired are not loaded during upload and are deleted one week after expiration.",Ht,ve,zt,Ze,Sa="When an upload terminates before the new content has been committed to the repository, you will need to resume the file transfer. However, it is possible that some chunks were successfully uploaded prior to the interruption.",Xt,Qe,Ha="So that you do not have to restart from the beginning, the <code>staging</code> directory acts as a workspace during uploads, storing metadata for successfully uploaded chunks. The <code>staging</code> directory has the following shape:",Pt,xe,qt,_e,za="As files are processed and chunks successfully uploaded, their metadata is stored in <code>xorb-metadata</code> as a shard. Upon resuming an upload session, each file is processed again and the shards in this directory are consulted. Any content that was successfully uploaded is skipped, and any new content is uploaded (and its metadata saved).",Kt,$e,Xa="Meanwhile, <code>shard-session</code> stores file and chunk information for processed files. On successful completion of an upload, the content from these shards is moved to the more persistent <code>shard-cache</code>.",es,Re,ls,Oe,Pa="The <code>chunk_cache</code> is limited to 10GB in size while the <code>shard_cache</code> has a soft limit of 4GB.  By design, both caches are without high-level APIs, although their size is configurable through the <code>HF_XET_CHUNK_CACHE_SIZE_BYTES</code> and <code>HF_XET_SHARD_CACHE_SIZE_LIMIT</code> environment variables.",ts,Fe,qa='These caches are used primarily to facilitate the reconstruction (download) or upload of a file. To interact with the assets themselves, it’s recommended that you use the <a href="https://huggingface.co/docs/huggingface_hub/guides/manage-cache" rel="nofollow"><code>huggingface_hub</code> cache system APIs</a>.',ss,De,Ka="If you need to reclaim the space utilized by either cache or need to debug any potential cache-related issues, simply remove the <code>xet</code> cache entirely by running <code>rm -rf ~/&lt;cache_dir&gt;/xet</code> where <code>&lt;cache_dir&gt;</code> is the location of your Hugging Face cache, typically <code>~/.cache/huggingface</code>",as,Ye,en="Example full <code>xet</code>cache directory tree:",ns,Le,is,Be,ln='To learn more about Xet Storage, see this <a href="https://huggingface.co/docs/hub/xet/index" rel="nofollow">section</a>.',Ts,Ge,Ms,Ee,tn=`In addition to caching files from the Hub, downstream libraries often requires to cache
other files related to HF but not handled directly by <code>huggingface_hub</code> (example: file
downloaded from GitHub, preprocessed data, logs,…). In order to cache those files,
called <code>assets</code>, one can use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a>. This small helper generates paths
in the HF cache in a unified way based on the name of the library requesting it and
optionally on a namespace and a subfolder name. The goal is to let every downstream
libraries manage its assets its own way (e.g. no rule on the structure) as long as it
stays in the right assets folder. Those libraries can then leverage tools from
<code>huggingface_hub</code> to manage the cache, in particular scanning and deleting parts of the
assets from a CLI command.`,cs,Ve,os,We,sn=`<p>[!TIP][cached_assets_path()](/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path) is the recommended way to store assets but is not mandatory. If
your library already uses its own cache, feel free to use it!</p>`,ds,Se,hs,He,an="In practice, your assets cache should look like the following tree:",Js,ze,rs,Xe,Us,Pe,ps,qe,nn=`At the moment, cached files are never deleted from your local directory: when you download
a new revision of a branch, previous files are kept in case you need them again.
Therefore it can be useful to inspect your cache directory in order to know which repos
and revisions are taking the most disk space. <code>huggingface_hub</code> provides helpers you can
use from the <code>hf</code> CLI or from Python.`,ys,Ke,Tn="<strong>Inspect cache from the terminal</strong>",ws,el,Mn=`Run <code>hf cache ls</code> to explore what is stored locally. By default the command aggregates
information by repository:`,fs,ll,ms,tl,cn=`Add <code>--revisions</code> to list every cached snapshot and chain filters to focus on what
matters. Filters understand human-friendly sizes and durations, so expressions such as
<code>size&gt;1GB</code> or <code>accessed&gt;30d</code> work out of the box:`,Is,sl,js,al,on=`Need machine-friendly output? Use <code>--format json</code> to get structured objects or
<code>--format csv</code> for spreadsheets. Alternatively <code>--quiet</code> prints only identifiers (one
per line) so you can pipe them into other tooling. Combine these options with
<code>--cache-dir</code> when you need to inspect a cache stored outside of <code>HF_HOME</code>.`,us,nl,dn="<strong>Filter with common shell tools</strong>",Cs,il,hn=`Tabular output means you can keep using the tooling you already know. For instance, the
snippet below finds every cached revision related to <code>t5-small</code>:`,gs,Tl,bs,Ml,Jn="<strong>Inspect cache from Python</strong>",As,cl,rn=`For a more advanced usage, use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a> which is the python utility called by
the CLI tool.`,ks,ol,Un="You can use it to get a detailed report structured around 4 dataclasses:",Ns,dl,pn='<li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a>: complete report returned by <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a></li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRepoInfo">CachedRepoInfo</a>: information about a cached repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRevisionInfo">CachedRevisionInfo</a>: information about a cached revision (e.g. “snapshot”) inside a repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedFileInfo">CachedFileInfo</a>: information about a cached file in a snapshot</li>',vs,hl,yn="Here is a simple usage example. See reference for details.",Zs,Jl,Qs,rl,xs,Ul,wn=`Scanning your cache is interesting but what you really want to do next is usually to
delete some portions to free up some space on your drive. This is possible using the
<code>hf cache rm</code> and <code>hf cache prune</code> CLI commands. One can also programmatically use the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> helper from the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a> object returned when
scanning the cache.`,_s,pl,fn="<strong>Delete strategy</strong>",$s,yl,mn=`To delete some cache, you need to pass a list of revisions to delete. The tool will
define a strategy to free up the space based on this list. It returns a
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object that describes which files and folders will be deleted.
The <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> allows give you how much space is expected to be freed.
Once you agree with the deletion, you must execute it to make the deletion effective. In
order to avoid discrepancies, you cannot edit a strategy object manually.`,Rs,wl,In="The strategy to delete revisions is the following:",Os,fl,jn="<li>the <code>snapshot</code> folder containing the revision symlinks is deleted.</li> <li>blobs files that are targeted only by revisions to be deleted are deleted as well.</li> <li>if a revision is linked to 1 or more <code>refs</code>, references are deleted.</li> <li>if all revisions from a repo are deleted, the entire cached repository is deleted.</li>",Fs,w,un=`<p>Revision hashes are unique across all repositories. <code>hf cache rm</code> therefore accepts either
a repo identifier (for example <code>model/bert-base-uncased</code>) or a bare revision hash; when
passing a hash you don’t need to specify the repo separately.</p>`,Ds,f,Cn=`<p>If a revision is not found in the cache, it will be silently ignored. Besides, if a file
or folder cannot be found while trying to delete it, a warning will be logged but no
error is thrown. The deletion continues for other paths contained in the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object.</p>`,Ys,ml,gn="<strong>Clean cache from the terminal</strong>",Ls,Il,bn=`Use <code>hf cache rm</code> to permanently delete repositories or revisions from your cache. Pass
one or more repo identifiers (for example <code>model/bert-base-uncased</code>) or revision hashes:`,Bs,jl,Gs,ul,An="You can also use <code>hf cache rm</code> in combination with <code>hf cache ls --quiet</code> to bulk-delete entries identified by a filter:",Es,Cl,Vs,gl,kn=`Mix repositories and revisions in the same call. Add <code>--dry-run</code> to preview the impact,
or <code>--yes</code> to skip the confirmation prompt when scripting:`,Ws,bl,Ss,Al,Nn=`When working outside the default cache location, pair the command with
<code>--cache-dir PATH</code>.`,Hs,kl,vn=`To clean up detached snapshots in bulk, run <code>hf cache prune</code>. It automatically selects
revisions that are no longer referenced by a branch or tag:`,zs,Nl,Xs,vl,Zn=`Both commands support <code>--dry-run</code>, <code>--yes</code>, and <code>--cache-dir</code> so you can preview, automate,
and target alternate cache directories as needed.`,Ps,Zl,Qn="<strong>Clean cache from Python</strong>",qs,Ql,xn=`For more flexibility, you can also use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> method
programmatically. Here is a simple example. See reference for details.`,Ks,xl,ea,_l,la,Rl,ta;return m=new Bn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new p({props:{title:"Understand caching",local:"understand-caching",headingTag:"h1"}}),u=new p({props:{title:"File-based caching",local:"file-based-caching",headingTag:"h2"}}),b=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`,wrap:!1}}),N=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`,wrap:!1}}),Q=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`,wrap:!1}}),_=new p({props:{title:"Refs",local:"refs",headingTag:"h3"}}),F=new p({props:{title:"Blobs",local:"blobs",headingTag:"h3"}}),Y=new p({props:{title:"Snapshots",local:"snapshots",headingTag:"h3"}}),E=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md',wrap:!1}}),S=new p({props:{title:".no_exist (advanced)",local:"noexist-advanced",headingTag:"h3"}}),z=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json',wrap:!1}}),K=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`,wrap:!1}}),ee=new p({props:{title:"In practice",local:"in-practice",headingTag:"h3"}}),te=new U({props:{code:"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",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),se=new p({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),Te=new p({props:{title:"Chunk-based caching (Xet)",local:"chunk-based-caching-xet",headingTag:"h2"}}),oe=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwZW52aXJvbm1lbnRfaWRlbnRpZmllciUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMGNodW5rX2NhY2hlJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzdGFnaW5n",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ environment_identifier
│  │  ├─ chunk_cache
│  │  ├─ shard_cache
│  │  ├─ staging`,wrap:!1}}),pe=new p({props:{title:"chunk_cache",local:"chunkcache",headingTag:"h3"}}),fe=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEExR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQQ==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ A1
│  │  │  ├─ A1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
`,wrap:!1}}),ue=new p({props:{title:"shard_cache",local:"shardcache",headingTag:"h3"}}),ge=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjAxZmU0ZmZkNWNmMGMzMzc1ZjFlZjlhZWM1MDE2Y2Y3NzNjY2M1Y2EyOTQyOTNkM2Y5MmQ5Mjc3MWRhY2ZjMTVkLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDkwNmVlMTg0ZGMxY2QwNjE1MTY0YTg5ZWQ2NGU4MTQ3YjNmZGNjZDExNjNkODBkNzk0YzY2ODE0YjNiMDk5OTIubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2VlZWI3ZWE0Y2Y2YzBhOGQzOTVhMmNmOWMwODg3MTIxMWZiYmQxN2I5YjVkYzEwMDU4MTE4NDUzMDdlNmI4Zi5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBlODUzNTE1NWIxYjExZWJkODk0YzkwOGU5MWExZTE0ZTM0NjFkZGRkMTM5MjY5NWRkYzkwYWU1NGE1NDhkOGIyLm1kYg==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb`,wrap:!1}}),ve=new p({props:{title:"staging",local:"staging",headingTag:"h3"}}),xe=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc3RhZ2luZyUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMHNoYXJkLXNlc3Npb24lMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjA5MDZlZTE4NGRjMWNkMDYxNTE2NGE4OWVkNjRlODE0N2IzZmRjY2QxMTYzZDgwZDc5NGM2NjgxNGIzYjA5OTkyLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMHhvcmItbWV0YWRhdGElMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjAxZmU0ZmZkNWNmMGMzMzc1ZjFlZjlhZWM1MDE2Y2Y3NzNjY2M1Y2EyOTQyOTNkM2Y5MmQ5Mjc3MWRhY2ZjMTVkLm1kYg==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ <span class="hljs-number">906</span>ee<span class="hljs-number">184</span>dc<span class="hljs-number">1</span>cd<span class="hljs-number">0615164</span>a<span class="hljs-number">89</span>ed<span class="hljs-number">64e8147</span>b<span class="hljs-number">3</span>fdccd<span class="hljs-number">1163</span>d<span class="hljs-number">80</span>d<span class="hljs-number">794</span><span class="hljs-keyword">c</span><span class="hljs-number">66814</span>b<span class="hljs-number">3</span>b<span class="hljs-number">09992</span>.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ <span class="hljs-number">1</span>fe<span class="hljs-number">4</span>ffd<span class="hljs-number">5</span>cf<span class="hljs-number">0</span><span class="hljs-keyword">c</span><span class="hljs-number">3375</span>f<span class="hljs-number">1</span>ef<span class="hljs-number">9</span>aec<span class="hljs-number">5016</span>cf<span class="hljs-number">773</span><span class="hljs-keyword">ccc</span><span class="hljs-number">5</span>ca<span class="hljs-number">294293</span>d<span class="hljs-number">3</span>f<span class="hljs-number">92</span>d<span class="hljs-number">92771</span>dacfc<span class="hljs-number">15</span>d.mdb`,wrap:!1}}),Re=new p({props:{title:"Limits and Limitations",local:"limits-and-limitations",headingTag:"h3"}}),Le=new U({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBMMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEwxR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMHNoYXJkX2NhY2hlJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwMWZlNGZmZDVjZjBjMzM3NWYxZWY5YWVjNTAxNmNmNzczY2NjNWNhMjk0MjkzZDNmOTJkOTI3NzFkYWNmYzE1ZC5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjA5MDZlZTE4NGRjMWNkMDYxNTE2NGE4OWVkNjRlODE0N2IzZmRjY2QxMTYzZDgwZDc5NGM2NjgxNGIzYjA5OTkyLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMGNlZWViN2VhNGNmNmMwYThkMzk1YTJjZjljMDg4NzEyMTFmYmJkMTdiOWI1ZGMxMDA1ODExODQ1MzA3ZTZiOGYubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwZTg1MzUxNTViMWIxMWViZDg5NGM5MDhlOTFhMWUxNGUzNDYxZGRkZDEzOTI2OTVkZGM5MGFlNTRhNTQ4ZDhiMi5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzdGFnaW5nJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmQtc2Vzc2lvbiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDkwNmVlMTg0ZGMxY2QwNjE1MTY0YTg5ZWQ2NGU4MTQ3YjNmZGNjZDExNjNkODBkNzk0YzY2ODE0YjNiMDk5OTIubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIweG9yYi1tZXRhZGF0YSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDFmZTRmZmQ1Y2YwYzMzNzVmMWVmOWFlYzUwMTZjZjc3M2NjYzVjYTI5NDI5M2QzZjkyZDkyNzcxZGFjZmMxNWQubWRi",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ L1
│  │  │  ├─ L1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb
│  ├─ staging
│  │  ├─ shard-session
│  │  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  │  ├─ xorb-metadata
│  │  │  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb`,wrap:!1}}),Ge=new p({props:{title:"Caching assets",local:"caching-assets",headingTag:"h2"}}),Ve=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBEbyUyMGFueXRoaW5nJTIweW91JTIwbGlrZSUyMGluJTIweW91ciUyMGFzc2V0cyUyMGZvbGRlciUyMCE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Do anything you like in your assets folder !</span>`,wrap:!1}}),Se=new p({props:{title:"Assets in practice",local:"assets-in-practice",headingTag:"h3"}}),ze=new U({props:{code:"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",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`,wrap:!1}}),Xe=new p({props:{title:"Manage your file-based cache",local:"manage-your-file-based-cache",headingTag:"h2"}}),Pe=new p({props:{title:"Inspect your cache",local:"inspect-your-cache",headingTag:"h3"}}),ll=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMGxzJTBBSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTSVpFJTIwJTIwJTIwTEFTVF9BQ0NFU1NFRCUyMExBU1RfTU9ESUZJRUQlMjBSRUZTJTBBLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTIwLS0tLS0tLSUyMC0tLS0tLS0tLS0tLS0lMjAtLS0tLS0tLS0tLS0tJTIwLS0tLS0tLS0tLS0tLS0tLS0tLSUwQWRhdGFzZXQlMkZnbHVlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTE2LjNLJTIwNCUyMGRheXMlMjBhZ28lMjAlMjAlMjAlMjAlMjA0JTIwZGF5cyUyMGFnbyUyMCUyMCUyMCUyMCUyMDIuNC4wJTIwbWFpbiUyMDEuMTcuMCUwQWRhdGFzZXQlMkZnb29nbGUlMkZmbGV1cnMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA2NC45TSUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwJTIwMSUyMHdlZWslMjBhZ28lMjAlMjAlMjAlMjAlMjBtYWluJTIwcmVmcyUyRnByJTJGMSUwQW1vZGVsJTJGSmVhbi1CYXB0aXN0ZSUyRmNhbWVtYmVydC1uZXIlMjAlMjAlMjAlMjA0NDEuME0lMjAyJTIwd2Vla3MlMjBhZ28lMjAlMjAlMjAlMjAxNiUyMGhvdXJzJTIwYWdvJTIwJTIwJTIwbWFpbiUwQW1vZGVsJTJGYmVydC1iYXNlLWNhc2VkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45RyUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwJTIwMiUyMHllYXJzJTIwYWdvJTBBbW9kZWwlMkZ0NS1iYXNlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAuMUslMjAzJTIwbW9udGhzJTIwYWdvJTIwJTIwJTIwMyUyMG1vbnRocyUyMGFnbyUyMCUyMCUyMG1haW4lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOTcwLjdNJTIwMyUyMGRheXMlMjBhZ28lMjAlMjAlMjAlMjAlMjAzJTIwZGF5cyUyMGFnbyUyMCUyMCUyMCUyMCUyMG1haW4lMjByZWZzJTJGcHIlMkYxJTBBJTBBRm91bmQlMjA2JTIwcmVwbyhzKSUyMGZvciUyMGElMjB0b3RhbCUyMG9mJTIwMTIlMjByZXZpc2lvbihzKSUyMGFuZCUyMDMuNEclMjBvbiUyMGRpc2su",highlighted:`➜ hf cache ls
ID                                   SIZE   LAST_ACCESSED LAST_MODIFIED REFS
------------------------------------ ------- ------------- ------------- -------------------
dataset/glue                         116.3K 4 days ago     4 days ago     2.4.0 main 1.17.0
dataset/google/fleurs                 64.9M 1 week ago     1 week ago     main refs/pr/1
model/Jean-Baptiste/camembert-ner    441.0M 2 weeks ago    16 hours ago   main
model/bert-base-cased                  1.9G 1 week ago     2 years ago
model/t5-base                          10.1K 3 months ago   3 months ago   main
model/t5-small                        970.7M 3 days ago     3 days ago     main refs/pr/1

Found 6 repo(s) for a total of 12 revision(s) and 3.4G on disk.`,wrap:!1}}),sl=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMGxzJTIwLS1yZXZpc2lvbnMlMjAtLWZpbHRlciUyMCUyMnNpemUlM0UxR0IlMjIlMjAtLWZpbHRlciUyMCUyMmFjY2Vzc2VkJTNFMzBkJTIyJTBBSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSRVZJU0lPTiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNJWkUlMjAlMjAlMjBMQVNUX01PRElGSUVEJTIwUkVGUyUwQS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyMC0tLS0tLS0tLS0tLS0tLS0tLSUyMC0tLS0tLS0lMjAtLS0tLS0tLS0tLS0tJTIwLS0tLS0tLS0tLS0tLS0tLS0tLSUwQW1vZGVsJTJGYmVydC1iYXNlLWNhc2VkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNmQxZDdhMWEyYTZjZjRjMiUyMCUyMCUyMCUyMDEuOUclMjAlMjAyJTIweWVhcnMlMjBhZ28lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMWM2MTBmNmIzZjVlN2Q4YSUyMCUyMCUyMCUyMDEuMUclMjAlMjAzJTIwbW9udGhzJTIwYWdvJTIwJTIwbWFpbiUwQSUwQUZvdW5kJTIwMiUyMHJlcG8ocyklMjBmb3IlMjBhJTIwdG90YWwlMjBvZiUyMDIlMjByZXZpc2lvbihzKSUyMGFuZCUyMDMuMEclMjBvbiUyMGRpc2su",highlighted:`➜ hf cache ls --revisions --filter &quot;size&gt;1GB&quot; --filter &quot;accessed&gt;30d&quot;
ID                                   REVISION            SIZE   LAST_MODIFIED REFS
------------------------------------ ------------------ ------- ------------- -------------------
model/bert-base-cased                6d1d7a1a2a6cf4c2    1.9G  2 years ago
model/t5-small                       1c610f6b3f5e7d8a    1.1G  3 months ago  main

Found 2 repo(s) for a total of 2 revision(s) and 3.0G on disk.`,wrap:!1}}),Tl=new U({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmhmJTIwY2FjaGUlMjBscyUyMC0tcmV2aXNpb25zJTIyJTIwJTdDJTIwZ3JlcCUyMCUyMnQ1LXNtYWxsJTIyJTBBbW9kZWwlMkZ0NS1zbWFsbCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDFjNjEwZjZiM2Y1ZTdkOGElMjAlMjAlMjAlMjAxLjFHJTIwJTIwMyUyMG1vbnRocyUyMGFnbyUyMCUyMG1haW4lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOGYzYWQxYzkwZmVkN2E2MiUyMCUyMCUyMCUyMDgyMC4xTSUyMDIlMjB3ZWVrcyUyMGFnbyUyMCUyMCUyMHJlZnMlMkZwciUyRjE=",highlighted:`➜ eval &quot;hf cache ls --revisions&quot; | grep &quot;t5-small&quot;
model/t5-small                       1c610f6b3f5e7d8a    1.1G  3 months ago  main
model/t5-small                       8f3ad1c90fed7a62    820.1M 2 weeks ago   refs/pr/1`,wrap:!1}}),Jl=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`,wrap:!1}}),rl=new p({props:{title:"Clean your cache",local:"clean-your-cache",headingTag:"h3"}}),jl=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZiZXJ0LWJhc2UtY2FzZWQlMEFBYm91dCUyMHRvJTIwZGVsZXRlJTIwMSUyMHJlcG8ocyklMjB0b3RhbGxpbmclMjAxLjlHLiUwQSUyMCUyMC0lMjBtb2RlbCUyRmJlcnQtYmFzZS1jYXNlZCUyMChlbnRpcmUlMjByZXBvKSUwQVByb2NlZWQlMjB3aXRoJTIwZGVsZXRpb24lM0YlMjAlNUJ5JTJGTiU1RCUzQSUyMHklMEFEZWxldGVkJTIwMSUyMHJlcG8ocyklMjBhbmQlMjAxJTIwcmV2aXNpb24ocyklM0IlMjBmcmVlZCUyMDEuOUcu",highlighted:`➜ hf cache rm model/bert-base-cased
About to delete 1 repo(s) totalling 1.9G.
  - model/bert-base-cased (entire repo)
Proceed with deletion? [y/N]: y
Deleted 1 repo(s) and 1 revision(s); freed 1.9G.`,wrap:!1}}),Cl=new U({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwJTI0KGhmJTIwY2FjaGUlMjBscyUyMC0tZmlsdGVyJTIwJTIyYWNjZXNzZWQlM0UxeSUyMiUyMC1xKSUyMC15",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> $(hf cache <span class="hljs-built_in">ls</span> --filter <span class="hljs-string">&quot;accessed&gt;1y&quot;</span> -q) -y
About to delete 2 repo(s) totalling 5.31G.
  - model/meta-llama/Llama-3.2-1B-Instruct (entire repo)
  - model/hexgrad/Kokoro-82M (entire repo)
Delete repo: ~/.cache/huggingface/hub/models--meta-llama--Llama-3.2-1B-Instruct
Delete repo: ~/.cache/huggingface/hub/models--hexgrad--Kokoro-82M
Cache deletion <span class="hljs-keyword">done</span>. Saved 5.31G.
Deleted 2 repo(s) and 2 revision(s); freed 5.31G.`,wrap:!1}}),bl=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZ0NS1zbWFsbCUyMDhmM2FkMWMlMjAtLWRyeS1ydW4lMEFBYm91dCUyMHRvJTIwZGVsZXRlJTIwMSUyMHJlcG8ocyklMjBhbmQlMjAxJTIwcmV2aXNpb24ocyklMjB0b3RhbGxpbmclMjAxLjFHLiUwQSUyMCUyMC0lMjBtb2RlbCUyRnQ1LXNtYWxsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwOGYzYWQxYyUyMCU1Qm1haW4lNUQlMjAxLjFHJTBBRHJ5JTIwcnVuJTNBJTIwbm8lMjBmaWxlcyUyMHdlcmUlMjBkZWxldGVkLg==",highlighted:`➜ hf cache rm model/t5-small 8f3ad1c --dry-run
About to delete 1 repo(s) and 1 revision(s) totalling 1.1G.
  - model/t5-small:
      8f3ad1c [main] 1.1G
Dry run: no files were deleted.`,wrap:!1}}),Nl=new U({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHBydW5lJTBBQWJvdXQlMjB0byUyMGRlbGV0ZSUyMDMlMjB1bnJlZmVyZW5jZWQlMjByZXZpc2lvbihzKSUyMCgyLjRHJTIwdG90YWwpLiUwQSUyMCUyMC0lMjBtb2RlbCUyRnQ1LXNtYWxsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwMWM2MTBmNmIlMjAlNUJyZWZzJTJGcHIlMkYxJTVEJTIwODIwLjFNJTBBJTIwJTIwJTIwJTIwJTIwJTIwZDRlYzliNzIlMjAlNUIoZGV0YWNoZWQpJTVEJTIwNjQwLjVNJTBBJTIwJTIwLSUyMGRhdGFzZXQlMkZnb29nbGUlMkZmbGV1cnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAyYjkxYzhkZCUyMCU1QihkZXRhY2hlZCklNUQlMjA5MzcuNk0lMEFQcm9jZWVkJTNGJTIwJTVCeSUyRk4lNUQlM0ElMjB5JTBBRGVsZXRlZCUyMDMlMjB1bnJlZmVyZW5jZWQlMjByZXZpc2lvbihzKSUzQiUyMGZyZWVkJTIwMi40Ry4=",highlighted:`➜ hf cache prune
About to delete 3 unreferenced revision(s) (2.4G total).
  - model/t5-small:
      1c610f6b [refs/pr/1] 820.1M
      d4ec9b72 [(detached)] 640.5M
  - dataset/google/fleurs:
      2b91c8dd [(detached)] 937.6M
Proceed? [y/N]: y
Deleted 3 unreferenced revision(s); freed 2.4G.`,wrap:!1}}),xl=new U({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`,wrap:!1}}),_l=new Gn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/manage-cache.md"}}),{c(){y=i("meta"),Ol=a(),$l=i("p"),Fl=a(),c(m.$$.fragment),Dl=a(),c(I.$$.fragment),Yl=a(),j=i("p"),j.innerHTML=na,Ll=a(),c(u.$$.fragment),Bl=a(),C=i("p"),C.textContent=ia,Gl=a(),g=i("p"),g.textContent=Ta,El=a(),c(b.$$.fragment),Vl=a(),A=i("p"),A.innerHTML=Ma,Wl=a(),k=i("p"),k.textContent=ca,Sl=a(),c(N.$$.fragment),Hl=a(),v=i("p"),v.textContent=oa,zl=a(),Z=i("p"),Z.textContent=da,Xl=a(),c(Q.$$.fragment),Pl=a(),x=i("p"),x.textContent=ha,ql=a(),c(_.$$.fragment),Kl=a(),$=i("p"),$.innerHTML=Ja,et=a(),R=i("p"),R.innerHTML=ra,lt=a(),O=i("p"),O.innerHTML=Ua,tt=a(),c(F.$$.fragment),st=a(),D=i("p"),D.innerHTML=pa,at=a(),c(Y.$$.fragment),nt=a(),L=i("p"),L.innerHTML=ya,it=a(),B=i("p"),B.innerHTML=wa,Tt=a(),G=i("p"),G.innerHTML=fa,Mt=a(),c(E.$$.fragment),ct=a(),V=i("p"),V.innerHTML=ma,ot=a(),W=i("p"),W.innerHTML=Ia,dt=a(),c(S.$$.fragment),ht=a(),H=i("p"),H.innerHTML=ja,Jt=a(),c(z.$$.fragment),rt=a(),X=i("p"),X.innerHTML=ua,Ut=a(),P=i("p"),P.innerHTML=Ca,pt=a(),q=i("p"),q.innerHTML=ga,yt=a(),c(K.$$.fragment),wt=a(),c(ee.$$.fragment),ft=a(),le=i("p"),le.textContent=ba,mt=a(),c(te.$$.fragment),It=a(),c(se.$$.fragment),jt=a(),ae=i("p"),ae.innerHTML=Aa,ut=a(),ne=i("p"),ne.innerHTML=ka,Ct=a(),ie=i("p"),ie.innerHTML=Na,gt=a(),c(Te.$$.fragment),bt=a(),Me=i("p"),Me.innerHTML=va,At=a(),ce=i("p"),ce.innerHTML=Za,kt=a(),c(oe.$$.fragment),Nt=a(),de=i("p"),de.innerHTML=Qa,vt=a(),he=i("p"),he.textContent=xa,Zt=a(),Je=i("ul"),Je.innerHTML=_a,Qt=a(),re=i("p"),re.textContent=$a,xt=a(),Ue=i("p"),Ue.innerHTML=Ra,_t=a(),c(pe.$$.fragment),$t=a(),ye=i("p"),ye.innerHTML=Oa,Rt=a(),we=i("p"),we.innerHTML=Fa,Ot=a(),c(fe.$$.fragment),Ft=a(),me=i("p"),me.innerHTML=Da,Dt=a(),Ie=i("p"),Ie.innerHTML=Ya,Yt=a(),je=i("p"),je.innerHTML=La,Lt=a(),c(ue.$$.fragment),Bt=a(),Ce=i("p"),Ce.textContent=Ba,Gt=a(),c(ge.$$.fragment),Et=a(),be=i("p"),be.innerHTML=Ga,Vt=a(),Ae=i("ul"),Ae.innerHTML=Ea,Wt=a(),ke=i("p"),ke.textContent=Va,St=a(),Ne=i("p"),Ne.textContent=Wa,Ht=a(),c(ve.$$.fragment),zt=a(),Ze=i("p"),Ze.textContent=Sa,Xt=a(),Qe=i("p"),Qe.innerHTML=Ha,Pt=a(),c(xe.$$.fragment),qt=a(),_e=i("p"),_e.innerHTML=za,Kt=a(),$e=i("p"),$e.innerHTML=Xa,es=a(),c(Re.$$.fragment),ls=a(),Oe=i("p"),Oe.innerHTML=Pa,ts=a(),Fe=i("p"),Fe.innerHTML=qa,ss=a(),De=i("p"),De.innerHTML=Ka,as=a(),Ye=i("p"),Ye.innerHTML=en,ns=a(),c(Le.$$.fragment),is=a(),Be=i("p"),Be.innerHTML=ln,Ts=a(),c(Ge.$$.fragment),Ms=a(),Ee=i("p"),Ee.innerHTML=tn,cs=a(),c(Ve.$$.fragment),os=a(),We=i("blockquote"),We.innerHTML=sn,ds=a(),c(Se.$$.fragment),hs=a(),He=i("p"),He.textContent=an,Js=a(),c(ze.$$.fragment),rs=a(),c(Xe.$$.fragment),Us=a(),c(Pe.$$.fragment),ps=a(),qe=i("p"),qe.innerHTML=nn,ys=a(),Ke=i("p"),Ke.innerHTML=Tn,ws=a(),el=i("p"),el.innerHTML=Mn,fs=a(),c(ll.$$.fragment),ms=a(),tl=i("p"),tl.innerHTML=cn,Is=a(),c(sl.$$.fragment),js=a(),al=i("p"),al.innerHTML=on,us=a(),nl=i("p"),nl.innerHTML=dn,Cs=a(),il=i("p"),il.innerHTML=hn,gs=a(),c(Tl.$$.fragment),bs=a(),Ml=i("p"),Ml.innerHTML=Jn,As=a(),cl=i("p"),cl.innerHTML=rn,ks=a(),ol=i("p"),ol.textContent=Un,Ns=a(),dl=i("ul"),dl.innerHTML=pn,vs=a(),hl=i("p"),hl.textContent=yn,Zs=a(),c(Jl.$$.fragment),Qs=a(),c(rl.$$.fragment),xs=a(),Ul=i("p"),Ul.innerHTML=wn,_s=a(),pl=i("p"),pl.innerHTML=fn,$s=a(),yl=i("p"),yl.innerHTML=mn,Rs=a(),wl=i("p"),wl.textContent=In,Os=a(),fl=i("ul"),fl.innerHTML=jn,Fs=a(),w=i("blockquote"),w.innerHTML=un,Ds=a(),f=i("blockquote"),f.innerHTML=Cn,Ys=a(),ml=i("p"),ml.innerHTML=gn,Ls=a(),Il=i("p"),Il.innerHTML=bn,Bs=a(),c(jl.$$.fragment),Gs=a(),ul=i("p"),ul.innerHTML=An,Es=a(),c(Cl.$$.fragment),Vs=a(),gl=i("p"),gl.innerHTML=kn,Ws=a(),c(bl.$$.fragment),Ss=a(),Al=i("p"),Al.innerHTML=Nn,Hs=a(),kl=i("p"),kl.innerHTML=vn,zs=a(),c(Nl.$$.fragment),Xs=a(),vl=i("p"),vl.innerHTML=Zn,Ps=a(),Zl=i("p"),Zl.innerHTML=Qn,qs=a(),Ql=i("p"),Ql.innerHTML=xn,Ks=a(),c(xl.$$.fragment),ea=a(),c(_l.$$.fragment),la=a(),Rl=i("p"),this.h()},l(e){const l=Yn("svelte-u9bgzb",document.head);y=T(l,"META",{name:!0,content:!0}),l.forEach(t),Ol=n(e),$l=T(e,"P",{}),_n($l).forEach(t),Fl=n(e),o(m.$$.fragment,e),Dl=n(e),o(I.$$.fragment,e),Yl=n(e),j=T(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1s3yler"&&(j.innerHTML=na),Ll=n(e),o(u.$$.fragment,e),Bl=n(e),C=T(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-7434pt"&&(C.textContent=ia),Gl=n(e),g=T(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-bm5pxs"&&(g.textContent=Ta),El=n(e),o(b.$$.fragment,e),Vl=n(e),A=T(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-lw0yzm"&&(A.innerHTML=Ma),Wl=n(e),k=T(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1xsylbb"&&(k.textContent=ca),Sl=n(e),o(N.$$.fragment,e),Hl=n(e),v=T(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-smirw4"&&(v.textContent=oa),zl=n(e),Z=T(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-hxzvg9"&&(Z.textContent=da),Xl=n(e),o(Q.$$.fragment,e),Pl=n(e),x=T(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1o80jr1"&&(x.textContent=ha),ql=n(e),o(_.$$.fragment,e),Kl=n(e),$=T(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-z6cr2z"&&($.innerHTML=Ja),et=n(e),R=T(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-15cx8ge"&&(R.innerHTML=ra),lt=n(e),O=T(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1u7b6sn"&&(O.innerHTML=Ua),tt=n(e),o(F.$$.fragment,e),st=n(e),D=T(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-9jec47"&&(D.innerHTML=pa),at=n(e),o(Y.$$.fragment,e),nt=n(e),L=T(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1mswky"&&(L.innerHTML=ya),it=n(e),B=T(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1f9g1u2"&&(B.innerHTML=wa),Tt=n(e),G=T(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1ezxfdw"&&(G.innerHTML=fa),Mt=n(e),o(E.$$.fragment,e),ct=n(e),V=T(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-7nae39"&&(V.innerHTML=ma),ot=n(e),W=T(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-sjd8l1"&&(W.innerHTML=Ia),dt=n(e),o(S.$$.fragment,e),ht=n(e),H=T(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-dxew1x"&&(H.innerHTML=ja),Jt=n(e),o(z.$$.fragment,e),rt=n(e),X=T(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-f64xkc"&&(X.innerHTML=ua),Ut=n(e),P=T(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-178rlr8"&&(P.innerHTML=Ca),pt=n(e),q=T(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-lua08t"&&(q.innerHTML=ga),yt=n(e),o(K.$$.fragment,e),wt=n(e),o(ee.$$.fragment,e),ft=n(e),le=T(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1cw24ss"&&(le.textContent=ba),mt=n(e),o(te.$$.fragment,e),It=n(e),o(se.$$.fragment,e),jt=n(e),ae=T(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1foktgq"&&(ae.innerHTML=Aa),ut=n(e),ne=T(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-x8ev9q"&&(ne.innerHTML=ka),Ct=n(e),ie=T(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1ue61z6"&&(ie.innerHTML=Na),gt=n(e),o(Te.$$.fragment,e),bt=n(e),Me=T(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-ewtcly"&&(Me.innerHTML=va),At=n(e),ce=T(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-o7am1f"&&(ce.innerHTML=Za),kt=n(e),o(oe.$$.fragment,e),Nt=n(e),de=T(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-15i0o7a"&&(de.innerHTML=Qa),vt=n(e),he=T(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-nj5twx"&&(he.textContent=xa),Zt=n(e),Je=T(e,"UL",{"data-svelte-h":!0}),M(Je)!=="svelte-15a5775"&&(Je.innerHTML=_a),Qt=n(e),re=T(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-68d6zk"&&(re.textContent=$a),xt=n(e),Ue=T(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1fqunt1"&&(Ue.innerHTML=Ra),_t=n(e),o(pe.$$.fragment,e),$t=n(e),ye=T(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-hgwq07"&&(ye.innerHTML=Oa),Rt=n(e),we=T(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-im7pgk"&&(we.innerHTML=Fa),Ot=n(e),o(fe.$$.fragment,e),Ft=n(e),me=T(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-gkyc1z"&&(me.innerHTML=Da),Dt=n(e),Ie=T(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-16gi99u"&&(Ie.innerHTML=Ya),Yt=n(e),je=T(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-1nna80w"&&(je.innerHTML=La),Lt=n(e),o(ue.$$.fragment,e),Bt=n(e),Ce=T(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1shtud2"&&(Ce.textContent=Ba),Gt=n(e),o(ge.$$.fragment,e),Et=n(e),be=T(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-h63bo"&&(be.innerHTML=Ga),Vt=n(e),Ae=T(e,"UL",{"data-svelte-h":!0}),M(Ae)!=="svelte-1sf7fpu"&&(Ae.innerHTML=Ea),Wt=n(e),ke=T(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-5htz2c"&&(ke.textContent=Va),St=n(e),Ne=T(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-imyi1b"&&(Ne.textContent=Wa),Ht=n(e),o(ve.$$.fragment,e),zt=n(e),Ze=T(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1gjzgfe"&&(Ze.textContent=Sa),Xt=n(e),Qe=T(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1ced4p2"&&(Qe.innerHTML=Ha),Pt=n(e),o(xe.$$.fragment,e),qt=n(e),_e=T(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-wvh9oo"&&(_e.innerHTML=za),Kt=n(e),$e=T(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-o4afuj"&&($e.innerHTML=Xa),es=n(e),o(Re.$$.fragment,e),ls=n(e),Oe=T(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-1ki79zi"&&(Oe.innerHTML=Pa),ts=n(e),Fe=T(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-1qzo8xt"&&(Fe.innerHTML=qa),ss=n(e),De=T(e,"P",{"data-svelte-h":!0}),M(De)!=="svelte-yngdyh"&&(De.innerHTML=Ka),as=n(e),Ye=T(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-er0a1o"&&(Ye.innerHTML=en),ns=n(e),o(Le.$$.fragment,e),is=n(e),Be=T(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-p22kya"&&(Be.innerHTML=ln),Ts=n(e),o(Ge.$$.fragment,e),Ms=n(e),Ee=T(e,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1r0ndhn"&&(Ee.innerHTML=tn),cs=n(e),o(Ve.$$.fragment,e),os=n(e),We=T(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(We)!=="svelte-1capgup"&&(We.innerHTML=sn),ds=n(e),o(Se.$$.fragment,e),hs=n(e),He=T(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-1lsljsl"&&(He.textContent=an),Js=n(e),o(ze.$$.fragment,e),rs=n(e),o(Xe.$$.fragment,e),Us=n(e),o(Pe.$$.fragment,e),ps=n(e),qe=T(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-1n21pft"&&(qe.innerHTML=nn),ys=n(e),Ke=T(e,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-2a98ae"&&(Ke.innerHTML=Tn),ws=n(e),el=T(e,"P",{"data-svelte-h":!0}),M(el)!=="svelte-fyocup"&&(el.innerHTML=Mn),fs=n(e),o(ll.$$.fragment,e),ms=n(e),tl=T(e,"P",{"data-svelte-h":!0}),M(tl)!=="svelte-13i0bg7"&&(tl.innerHTML=cn),Is=n(e),o(sl.$$.fragment,e),js=n(e),al=T(e,"P",{"data-svelte-h":!0}),M(al)!=="svelte-1wdn9st"&&(al.innerHTML=on),us=n(e),nl=T(e,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-9g91kr"&&(nl.innerHTML=dn),Cs=n(e),il=T(e,"P",{"data-svelte-h":!0}),M(il)!=="svelte-1jgwyig"&&(il.innerHTML=hn),gs=n(e),o(Tl.$$.fragment,e),bs=n(e),Ml=T(e,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-nzo9gl"&&(Ml.innerHTML=Jn),As=n(e),cl=T(e,"P",{"data-svelte-h":!0}),M(cl)!=="svelte-1bx4n8u"&&(cl.innerHTML=rn),ks=n(e),ol=T(e,"P",{"data-svelte-h":!0}),M(ol)!=="svelte-83019z"&&(ol.textContent=Un),Ns=n(e),dl=T(e,"UL",{"data-svelte-h":!0}),M(dl)!=="svelte-qwuhrl"&&(dl.innerHTML=pn),vs=n(e),hl=T(e,"P",{"data-svelte-h":!0}),M(hl)!=="svelte-xp69b3"&&(hl.textContent=yn),Zs=n(e),o(Jl.$$.fragment,e),Qs=n(e),o(rl.$$.fragment,e),xs=n(e),Ul=T(e,"P",{"data-svelte-h":!0}),M(Ul)!=="svelte-3oea8m"&&(Ul.innerHTML=wn),_s=n(e),pl=T(e,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-s9tc9t"&&(pl.innerHTML=fn),$s=n(e),yl=T(e,"P",{"data-svelte-h":!0}),M(yl)!=="svelte-1wode1b"&&(yl.innerHTML=mn),Rs=n(e),wl=T(e,"P",{"data-svelte-h":!0}),M(wl)!=="svelte-19y0r7c"&&(wl.textContent=In),Os=n(e),fl=T(e,"UL",{"data-svelte-h":!0}),M(fl)!=="svelte-o7nsmh"&&(fl.innerHTML=jn),Fs=n(e),w=T(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(w)!=="svelte-1ve8ddd"&&(w.innerHTML=un),Ds=n(e),f=T(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(f)!=="svelte-p3c4og"&&(f.innerHTML=Cn),Ys=n(e),ml=T(e,"P",{"data-svelte-h":!0}),M(ml)!=="svelte-13xgrrb"&&(ml.innerHTML=gn),Ls=n(e),Il=T(e,"P",{"data-svelte-h":!0}),M(Il)!=="svelte-581am3"&&(Il.innerHTML=bn),Bs=n(e),o(jl.$$.fragment,e),Gs=n(e),ul=T(e,"P",{"data-svelte-h":!0}),M(ul)!=="svelte-x93r3r"&&(ul.innerHTML=An),Es=n(e),o(Cl.$$.fragment,e),Vs=n(e),gl=T(e,"P",{"data-svelte-h":!0}),M(gl)!=="svelte-1m1mjoy"&&(gl.innerHTML=kn),Ws=n(e),o(bl.$$.fragment,e),Ss=n(e),Al=T(e,"P",{"data-svelte-h":!0}),M(Al)!=="svelte-r7ky4r"&&(Al.innerHTML=Nn),Hs=n(e),kl=T(e,"P",{"data-svelte-h":!0}),M(kl)!=="svelte-naqyn5"&&(kl.innerHTML=vn),zs=n(e),o(Nl.$$.fragment,e),Xs=n(e),vl=T(e,"P",{"data-svelte-h":!0}),M(vl)!=="svelte-46np3h"&&(vl.innerHTML=Zn),Ps=n(e),Zl=T(e,"P",{"data-svelte-h":!0}),M(Zl)!=="svelte-1ayyols"&&(Zl.innerHTML=Qn),qs=n(e),Ql=T(e,"P",{"data-svelte-h":!0}),M(Ql)!=="svelte-qm6d3g"&&(Ql.innerHTML=xn),Ks=n(e),o(xl.$$.fragment,e),ea=n(e),o(_l.$$.fragment,e),la=n(e),Rl=T(e,"P",{}),_n(Rl).forEach(t),this.h()},h(){sa(y,"name","hf:doc:metadata"),sa(y,"content",Vn),sa(w,"class","tip"),sa(f,"class","warning")},m(e,l){Ln(document.head,y),s(e,Ol,l),s(e,$l,l),s(e,Fl,l),d(m,e,l),s(e,Dl,l),d(I,e,l),s(e,Yl,l),s(e,j,l),s(e,Ll,l),d(u,e,l),s(e,Bl,l),s(e,C,l),s(e,Gl,l),s(e,g,l),s(e,El,l),d(b,e,l),s(e,Vl,l),s(e,A,l),s(e,Wl,l),s(e,k,l),s(e,Sl,l),d(N,e,l),s(e,Hl,l),s(e,v,l),s(e,zl,l),s(e,Z,l),s(e,Xl,l),d(Q,e,l),s(e,Pl,l),s(e,x,l),s(e,ql,l),d(_,e,l),s(e,Kl,l),s(e,$,l),s(e,et,l),s(e,R,l),s(e,lt,l),s(e,O,l),s(e,tt,l),d(F,e,l),s(e,st,l),s(e,D,l),s(e,at,l),d(Y,e,l),s(e,nt,l),s(e,L,l),s(e,it,l),s(e,B,l),s(e,Tt,l),s(e,G,l),s(e,Mt,l),d(E,e,l),s(e,ct,l),s(e,V,l),s(e,ot,l),s(e,W,l),s(e,dt,l),d(S,e,l),s(e,ht,l),s(e,H,l),s(e,Jt,l),d(z,e,l),s(e,rt,l),s(e,X,l),s(e,Ut,l),s(e,P,l),s(e,pt,l),s(e,q,l),s(e,yt,l),d(K,e,l),s(e,wt,l),d(ee,e,l),s(e,ft,l),s(e,le,l),s(e,mt,l),d(te,e,l),s(e,It,l),d(se,e,l),s(e,jt,l),s(e,ae,l),s(e,ut,l),s(e,ne,l),s(e,Ct,l),s(e,ie,l),s(e,gt,l),d(Te,e,l),s(e,bt,l),s(e,Me,l),s(e,At,l),s(e,ce,l),s(e,kt,l),d(oe,e,l),s(e,Nt,l),s(e,de,l),s(e,vt,l),s(e,he,l),s(e,Zt,l),s(e,Je,l),s(e,Qt,l),s(e,re,l),s(e,xt,l),s(e,Ue,l),s(e,_t,l),d(pe,e,l),s(e,$t,l),s(e,ye,l),s(e,Rt,l),s(e,we,l),s(e,Ot,l),d(fe,e,l),s(e,Ft,l),s(e,me,l),s(e,Dt,l),s(e,Ie,l),s(e,Yt,l),s(e,je,l),s(e,Lt,l),d(ue,e,l),s(e,Bt,l),s(e,Ce,l),s(e,Gt,l),d(ge,e,l),s(e,Et,l),s(e,be,l),s(e,Vt,l),s(e,Ae,l),s(e,Wt,l),s(e,ke,l),s(e,St,l),s(e,Ne,l),s(e,Ht,l),d(ve,e,l),s(e,zt,l),s(e,Ze,l),s(e,Xt,l),s(e,Qe,l),s(e,Pt,l),d(xe,e,l),s(e,qt,l),s(e,_e,l),s(e,Kt,l),s(e,$e,l),s(e,es,l),d(Re,e,l),s(e,ls,l),s(e,Oe,l),s(e,ts,l),s(e,Fe,l),s(e,ss,l),s(e,De,l),s(e,as,l),s(e,Ye,l),s(e,ns,l),d(Le,e,l),s(e,is,l),s(e,Be,l),s(e,Ts,l),d(Ge,e,l),s(e,Ms,l),s(e,Ee,l),s(e,cs,l),d(Ve,e,l),s(e,os,l),s(e,We,l),s(e,ds,l),d(Se,e,l),s(e,hs,l),s(e,He,l),s(e,Js,l),d(ze,e,l),s(e,rs,l),d(Xe,e,l),s(e,Us,l),d(Pe,e,l),s(e,ps,l),s(e,qe,l),s(e,ys,l),s(e,Ke,l),s(e,ws,l),s(e,el,l),s(e,fs,l),d(ll,e,l),s(e,ms,l),s(e,tl,l),s(e,Is,l),d(sl,e,l),s(e,js,l),s(e,al,l),s(e,us,l),s(e,nl,l),s(e,Cs,l),s(e,il,l),s(e,gs,l),d(Tl,e,l),s(e,bs,l),s(e,Ml,l),s(e,As,l),s(e,cl,l),s(e,ks,l),s(e,ol,l),s(e,Ns,l),s(e,dl,l),s(e,vs,l),s(e,hl,l),s(e,Zs,l),d(Jl,e,l),s(e,Qs,l),d(rl,e,l),s(e,xs,l),s(e,Ul,l),s(e,_s,l),s(e,pl,l),s(e,$s,l),s(e,yl,l),s(e,Rs,l),s(e,wl,l),s(e,Os,l),s(e,fl,l),s(e,Fs,l),s(e,w,l),s(e,Ds,l),s(e,f,l),s(e,Ys,l),s(e,ml,l),s(e,Ls,l),s(e,Il,l),s(e,Bs,l),d(jl,e,l),s(e,Gs,l),s(e,ul,l),s(e,Es,l),d(Cl,e,l),s(e,Vs,l),s(e,gl,l),s(e,Ws,l),d(bl,e,l),s(e,Ss,l),s(e,Al,l),s(e,Hs,l),s(e,kl,l),s(e,zs,l),d(Nl,e,l),s(e,Xs,l),s(e,vl,l),s(e,Ps,l),s(e,Zl,l),s(e,qs,l),s(e,Ql,l),s(e,Ks,l),d(xl,e,l),s(e,ea,l),d(_l,e,l),s(e,la,l),s(e,Rl,l),ta=!0},p:Rn,i(e){ta||(h(m.$$.fragment,e),h(I.$$.fragment,e),h(u.$$.fragment,e),h(b.$$.fragment,e),h(N.$$.fragment,e),h(Q.$$.fragment,e),h(_.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(Te.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(Re.$$.fragment,e),h(Le.$$.fragment,e),h(Ge.$$.fragment,e),h(Ve.$$.fragment,e),h(Se.$$.fragment,e),h(ze.$$.fragment,e),h(Xe.$$.fragment,e),h(Pe.$$.fragment,e),h(ll.$$.fragment,e),h(sl.$$.fragment,e),h(Tl.$$.fragment,e),h(Jl.$$.fragment,e),h(rl.$$.fragment,e),h(jl.$$.fragment,e),h(Cl.$$.fragment,e),h(bl.$$.fragment,e),h(Nl.$$.fragment,e),h(xl.$$.fragment,e),h(_l.$$.fragment,e),ta=!0)},o(e){J(m.$$.fragment,e),J(I.$$.fragment,e),J(u.$$.fragment,e),J(b.$$.fragment,e),J(N.$$.fragment,e),J(Q.$$.fragment,e),J(_.$$.fragment,e),J(F.$$.fragment,e),J(Y.$$.fragment,e),J(E.$$.fragment,e),J(S.$$.fragment,e),J(z.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(te.$$.fragment,e),J(se.$$.fragment,e),J(Te.$$.fragment,e),J(oe.$$.fragment,e),J(pe.$$.fragment,e),J(fe.$$.fragment,e),J(ue.$$.fragment,e),J(ge.$$.fragment,e),J(ve.$$.fragment,e),J(xe.$$.fragment,e),J(Re.$$.fragment,e),J(Le.$$.fragment,e),J(Ge.$$.fragment,e),J(Ve.$$.fragment,e),J(Se.$$.fragment,e),J(ze.$$.fragment,e),J(Xe.$$.fragment,e),J(Pe.$$.fragment,e),J(ll.$$.fragment,e),J(sl.$$.fragment,e),J(Tl.$$.fragment,e),J(Jl.$$.fragment,e),J(rl.$$.fragment,e),J(jl.$$.fragment,e),J(Cl.$$.fragment,e),J(bl.$$.fragment,e),J(Nl.$$.fragment,e),J(xl.$$.fragment,e),J(_l.$$.fragment,e),ta=!1},d(e){e&&(t(Ol),t($l),t(Fl),t(Dl),t(Yl),t(j),t(Ll),t(Bl),t(C),t(Gl),t(g),t(El),t(Vl),t(A),t(Wl),t(k),t(Sl),t(Hl),t(v),t(zl),t(Z),t(Xl),t(Pl),t(x),t(ql),t(Kl),t($),t(et),t(R),t(lt),t(O),t(tt),t(st),t(D),t(at),t(nt),t(L),t(it),t(B),t(Tt),t(G),t(Mt),t(ct),t(V),t(ot),t(W),t(dt),t(ht),t(H),t(Jt),t(rt),t(X),t(Ut),t(P),t(pt),t(q),t(yt),t(wt),t(ft),t(le),t(mt),t(It),t(jt),t(ae),t(ut),t(ne),t(Ct),t(ie),t(gt),t(bt),t(Me),t(At),t(ce),t(kt),t(Nt),t(de),t(vt),t(he),t(Zt),t(Je),t(Qt),t(re),t(xt),t(Ue),t(_t),t($t),t(ye),t(Rt),t(we),t(Ot),t(Ft),t(me),t(Dt),t(Ie),t(Yt),t(je),t(Lt),t(Bt),t(Ce),t(Gt),t(Et),t(be),t(Vt),t(Ae),t(Wt),t(ke),t(St),t(Ne),t(Ht),t(zt),t(Ze),t(Xt),t(Qe),t(Pt),t(qt),t(_e),t(Kt),t($e),t(es),t(ls),t(Oe),t(ts),t(Fe),t(ss),t(De),t(as),t(Ye),t(ns),t(is),t(Be),t(Ts),t(Ms),t(Ee),t(cs),t(os),t(We),t(ds),t(hs),t(He),t(Js),t(rs),t(Us),t(ps),t(qe),t(ys),t(Ke),t(ws),t(el),t(fs),t(ms),t(tl),t(Is),t(js),t(al),t(us),t(nl),t(Cs),t(il),t(gs),t(bs),t(Ml),t(As),t(cl),t(ks),t(ol),t(Ns),t(dl),t(vs),t(hl),t(Zs),t(Qs),t(xs),t(Ul),t(_s),t(pl),t($s),t(yl),t(Rs),t(wl),t(Os),t(fl),t(Fs),t(w),t(Ds),t(f),t(Ys),t(ml),t(Ls),t(Il),t(Bs),t(Gs),t(ul),t(Es),t(Vs),t(gl),t(Ws),t(Ss),t(Al),t(Hs),t(kl),t(zs),t(Xs),t(vl),t(Ps),t(Zl),t(qs),t(Ql),t(Ks),t(ea),t(la),t(Rl)),t(y),r(m,e),r(I,e),r(u,e),r(b,e),r(N,e),r(Q,e),r(_,e),r(F,e),r(Y,e),r(E,e),r(S,e),r(z,e),r(K,e),r(ee,e),r(te,e),r(se,e),r(Te,e),r(oe,e),r(pe,e),r(fe,e),r(ue,e),r(ge,e),r(ve,e),r(xe,e),r(Re,e),r(Le,e),r(Ge,e),r(Ve,e),r(Se,e),r(ze,e),r(Xe,e),r(Pe,e),r(ll,e),r(sl,e),r(Tl,e),r(Jl,e),r(rl,e),r(jl,e),r(Cl,e),r(bl,e),r(Nl,e),r(xl,e),r(_l,e)}}}const Vn='{"title":"Understand caching","local":"understand-caching","sections":[{"title":"File-based caching","local":"file-based-caching","sections":[{"title":"Refs","local":"refs","sections":[],"depth":3},{"title":"Blobs","local":"blobs","sections":[],"depth":3},{"title":"Snapshots","local":"snapshots","sections":[],"depth":3},{"title":".no_exist (advanced)","local":"noexist-advanced","sections":[],"depth":3},{"title":"In practice","local":"in-practice","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Chunk-based caching (Xet)","local":"chunk-based-caching-xet","sections":[{"title":"chunk_cache","local":"chunkcache","sections":[],"depth":3},{"title":"shard_cache","local":"shardcache","sections":[],"depth":3},{"title":"staging","local":"staging","sections":[],"depth":3},{"title":"Limits and Limitations","local":"limits-and-limitations","sections":[],"depth":3}],"depth":2},{"title":"Caching assets","local":"caching-assets","sections":[{"title":"Assets in practice","local":"assets-in-practice","sections":[],"depth":3}],"depth":2},{"title":"Manage your file-based cache","local":"manage-your-file-based-cache","sections":[{"title":"Inspect your cache","local":"inspect-your-cache","sections":[],"depth":3},{"title":"Clean your cache","local":"clean-your-cache","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wn(aa){return On(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qn extends Fn{constructor(y){super(),Dn(this,y,Wn,En,$n,{})}}export{qn as component};
