import{s as Vl,n as Ql,o as ql}from"../chunks/scheduler.0cf4ef2e.js";import{S as Hl,i as Wl,e as p,s as a,c as r,h as xl,a as i,d as l,b as n,f as Yl,g as c,j as M,k as Xe,l as zl,m as t,n as o,t as y,o as u,p as j}from"../chunks/index.abc433bf.js";import{C as Ll}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as m}from"../chunks/CodeBlock.18a16f91.js";import{H as Se,E as Dl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function Pl(el){let h,$e,Ee,Ne,U,ve,f,Re,g,sl=`In this guide, we will see how to manage your Space runtime
(<a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">secrets</a>,
<a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">hardware</a>, and <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">storage</a>) using <code>huggingface_hub</code>.`,Fe,I,Ye,_,ll="Here is an end-to-end example to create and setup a Space on the Hub.",Ve,k,tl="<strong>1. Create a Space on the Hub.</strong>",Qe,C,qe,B,al="<strong>1. (bis) Duplicate a Space.</strong>",He,Z,nl=`This can prove useful if you want to build up from an existing Space instead of starting from scratch.
It is also useful is you want control over the configuration/settings of a public Space. See <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space">duplicate_space()</a> for more details.`,We,G,xe,b,pl="<strong>2. Upload your code using your preferred solution.</strong>",ze,X,il="Here is an example to upload the local folder <code>src/</code> from your machine to your Space:",Le,E,De,A,Ml=`At this step, your app should already be running on the Hub for free !
However, you might want to configure it further with secrets and upgraded hardware.`,Pe,S,rl="<strong>3. Configure secrets and variables</strong>",Ke,$,cl=`Your Space might require some secret keys, token or variables to work.
See <a href="https://huggingface.co/docs/hub/spaces-overview#managing-secrets" rel="nofollow">docs</a> for more details.
For example, an HF token to upload an image dataset to the Hub once generated from your Space.`,Oe,N,es,v,ol="Secrets and variables can be deleted as well:",ss,R,ls,d,yl=`<p>From within your Space, secrets are available as environment variables (or
Streamlit Secrets Management if using Streamlit). No need to fetch them via the API!</p>`,ts,w,ul="<p>Any change in your Space configuration (secrets or hardware) will trigger a restart of your app.</p>",as,F,jl="<strong>Bonus: set secrets and variables when creating or duplicating the Space!</strong>",ns,Y,ml="Secrets and variables can be set when creating or duplicating a space:",ps,V,is,Q,Ms,q,hl="<strong>4. Configure the hardware</strong>",rs,H,dl=`By default, your Space will run on a CPU environment for free. You can upgrade the hardware
to run it on GPUs. A payment card or a community grant is required to access upgrade your
Space. See <a href="https://huggingface.co/docs/hub/spaces-gpus" rel="nofollow">docs</a> for more details.`,cs,W,os,x,wl=`Hardware updates are not done immediately as your Space has to be reloaded on our servers.
At any time, you can check on which hardware your Space is running to see if your request
has been met.`,ys,z,us,L,Jl=`You now have a Space fully configured. Make sure to downgrade your Space back to “cpu-classic”
when you are done using it.`,js,D,Tl="<strong>Bonus: request hardware when creating or duplicating the Space!</strong>",ms,P,Ul="Upgraded hardware will be automatically assigned to your Space once it’s built.",hs,K,ds,O,ws,ee,fl="<strong>5. Pause and restart your Space</strong>",Js,se,gl=`By default if your Space is running on an upgraded hardware, it will never be stopped. However to avoid getting billed,
you might want to pause it when you are not using it. This is possible using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_space">pause_space()</a>. A paused Space will be
inactive until the owner of the Space restarts it, either with the UI or via API using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.restart_space">restart_space()</a>.
For more details about paused mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#pause" rel="nofollow">this section</a>`,Ts,le,Us,te,Il=`Another possibility is to set a timeout for your Space. If your Space is inactive for more than the timeout duration,
it will go to sleep. Any visitor landing on your Space will start it back up. You can set a timeout using
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.set_space_sleep_time">set_space_sleep_time()</a>. For more details about sleeping mode, please refer to <a href="https://huggingface.co/docs/hub/spaces-gpus#sleep-time" rel="nofollow">this section</a>.`,fs,ae,gs,ne,_l=`Note: if you are using a ‘cpu-basic’ hardware, you cannot configure a custom sleep time. Your Space will automatically
be paused after 48h of inactivity.`,Is,pe,kl="<strong>Bonus: set a sleep time while requesting hardware</strong>",_s,ie,Cl="Upgraded hardware will be automatically assigned to your Space once it’s built.",ks,Me,Cs,re,Bl="<strong>Bonus: set a sleep time when creating or duplicating the Space!</strong>",Bs,ce,Zs,oe,Gs,ye,Zl="<strong>6. Add persistent storage to your Space</strong>",bs,ue,Gl='You can choose the storage tier of your choice to access disk space that persists across restarts of your Space. This means you can read and write from disk like you would with a traditional hard drive. See <a href="https://huggingface.co/docs/hub/spaces-storage#persistent-storage" rel="nofollow">docs</a> for more details.',Xs,je,Es,me,bl="You can also delete your storage, losing all the data permanently.",As,he,Ss,de,Xl=`Note: You cannot decrease the storage tier of your space once it’s been granted. To do so,
you must delete the storage first then request the new desired tier.`,$s,we,El="<strong>Bonus: request storage when creating or duplicating the Space!</strong>",Ns,Je,vs,Te,Rs,Ue,Fs,fe,Al=`Spaces allow for a lot of different use cases. Sometimes, you might want
to temporarily run a Space on a specific hardware, do something and then shut it down. In
this section, we will explore how to benefit from Spaces to finetune a model on demand.
This is only one way of solving this particular problem. It has to be taken as a suggestion
and adapted to your use case.`,Ys,ge,Sl=`Let’s assume we have a Space to finetune a model. It is a Gradio app that takes as input
a model id and a dataset id. The workflow is as follows:`,Vs,J,$l="<li>(Prompt the user for a model and a dataset)</li> <li>Load the model from the Hub.</li> <li>Load the dataset from the Hub.</li> <li>Finetune the model on the dataset.</li> <li>Upload the new model to the Hub.</li>",Qs,Ie,Nl=`Step 3. requires a custom hardware but you don’t want your Space to be running all the time on a paid
GPU. A solution is to dynamically request hardware for the training and shut it
down afterwards. Since requesting hardware restarts your Space, your app must somehow “remember”
the current task it is performing. There are multiple ways of doing this. In this guide
we will see one solution using a Dataset as “task scheduler”.`,qs,_e,Hs,ke,vl=`Here is what your app would look like. On startup, check if a task is scheduled and if yes,
run it on the correct hardware. Once done, set back hardware to the free-plan CPU and
prompt the user for a new task.`,Ws,T,Rl=`<p>Such a workflow does not support concurrent access as normal demos.
In particular, the interface will be disabled when training occurs.
It is preferable to set your repo as private to ensure you are the only user.</p>`,xs,Ce,zs,Be,Ls,Ze,Fl=`Scheduling tasks can be done in many ways. Here is an example how it could be done using
a simple CSV stored as a Dataset.`,Ds,Ge,Ps,be,Ks,Ae,Os;return U=new Ll({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new Se({props:{title:"Manage your Space",local:"manage-your-space",headingTag:"h1"}}),I=new Se({props:{title:"A simple example: configure secrets and hardware.",local:"a-simple-example-configure-secrets-and-hardware",headingTag:"h2"}}),C=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBcmVwb19pZCUyMCUzRCUyMCUyMldhdXBsaW4lMkZteS1jb29sLXRyYWluaW5nLXNwYWNlJTIyJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwc3BhY2Vfc2RrJTNEJTIyZ3JhZGlvJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;Wauplin/my-cool-training-space&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># For example with a Gradio SDK</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>)`,wrap:!1}}),G=new m({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>)',wrap:!1}}),E=new m({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUyMGZvbGRlcl9wYXRoJTNEJTIyc3JjJTJGJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;space&quot;</span>, folder_path=<span class="hljs-string">&quot;src/&quot;</span>)',wrap:!1}}),N=new m({props:{code:"YXBpLmFkZF9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiUyQyUyMHZhbHVlJTNEJTIyaGZfYXBpXyoqKiUyMiklMEFhcGkuYWRkX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMiUyQyUyMHZhbHVlJTNEJTIydXNlciUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, value=<span class="hljs-string">&quot;hf_api_***&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.add_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, value=<span class="hljs-string">&quot;user/repo&quot;</span>)`,wrap:!1}}),R=new m({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zZWNyZXQocmVwb19pZCUzRHJlcG9faWQlMkMlMjBrZXklM0QlMjJIRl9UT0tFTiUyMiklMEFhcGkuZGVsZXRlX3NwYWNlX3ZhcmlhYmxlKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwa2V5JTNEJTIyTU9ERUxfUkVQT19JRCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_secret(repo_id=repo_id, key=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_variable(repo_id=repo_id, key=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>)`,wrap:!1}}),V=new m({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZWNyZXRzJTNEJTVCJTdCJTIya2V5JTIyJTNEJTIySEZfVE9LRU4lMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMmhmX2FwaV8qKiolMjIlN0QlMkMlMjAuLi4lNUQlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV92YXJpYWJsZXMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJNT0RFTF9SRVBPX0lEJTIyJTJDJTIwJTIydmFsdWUlMjIlM0QlMjJ1c2VyJTJGcmVwbyUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>,
<span class="hljs-meta">... </span>    space_secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    space_variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new m({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHNlY3JldHMlM0QlNUIlN0IlMjJrZXklMjIlM0QlMjJIRl9UT0tFTiUyMiUyQyUyMCUyMnZhbHVlJTIyJTNEJTIyaGZfYXBpXyoqKiUyMiU3RCUyQyUyMC4uLiU1RCUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhYmxlcyUzRCU1QiU3QiUyMmtleSUyMiUzRCUyMk1PREVMX1JFUE9fSUQlMjIlMkMlMjAlMjJ2YWx1ZSUyMiUzRCUyMnVzZXIlMkZyZXBvJTIyJTdEJTJDJTIwLi4uJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    secrets=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;HF_TOKEN&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;hf_api_***&quot;</span>}, ...],
<span class="hljs-meta">... </span>    variables=[{<span class="hljs-string">&quot;key&quot;</span>=<span class="hljs-string">&quot;MODEL_REPO_ID&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>=<span class="hljs-string">&quot;user/repo&quot;</span>}, ...],
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlSGFyZHdhcmUlMEFhcGkucmVxdWVzdF9zcGFjZV9oYXJkd2FyZShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGhhcmR3YXJlJTNEU3BhY2VIYXJkd2FyZS5UNF9NRURJVU0pJTBBJTBBYXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMik=",highlighted:`<span class="hljs-comment"># Use \`SpaceHardware\` enum</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceHardware
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM)

<span class="hljs-comment"># Or simply pass a string value</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>)`,wrap:!1}}),z=new m({props:{code:"cnVudGltZSUyMCUzRCUyMGFwaS5nZXRfc3BhY2VfcnVudGltZShyZXBvX2lkJTNEcmVwb19pZCklMEFydW50aW1lLnN0YWdlJTBBcnVudGltZS5oYXJkd2FyZSUwQXJ1bnRpbWUucmVxdWVzdGVkX2hhcmR3YXJl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>runtime = api.get_space_runtime(repo_id=repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.stage
<span class="hljs-string">&quot;RUNNING_BUILDING&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.hardware
<span class="hljs-string">&quot;cpu-basic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>runtime.requested_hardware
<span class="hljs-string">&quot;t4-medium&quot;</span>`,wrap:!1}}),K=new m({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMmNwdS11cGdyYWRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc3RvcmFnZSUzRCUyMnNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BhY2Vfc2xlZXBfdGltZSUzRCUyMjcyMDAlMjIlMkMlMjAlMjMlMjAyJTIwaG91cnMlMjBpbiUyMHNlY3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new m({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIyY3B1LXVwZ3JhZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBzdG9yYWdlJTNEJTIyc21hbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBzbGVlcF90aW1lJTNEJTIyNzIwMCUyMiUyQyUyMCUyMyUyMDIlMjBob3VycyUyMGluJTIwc2VjcyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;cpu-upgrade&quot;</span>,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;small&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;7200&quot;</span>, <span class="hljs-comment"># 2 hours in secs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),le=new m({props:{code:"YXBpLnBhdXNlX3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKSUwQWFwaS5yZXN0YXJ0X3NwYWNlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:`<span class="hljs-comment"># Pause your Space to avoid getting billed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.pause_space(repo_id=repo_id)
<span class="hljs-comment"># (...)</span>
<span class="hljs-comment"># Restart it when you need it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.restart_space(repo_id=repo_id)`,wrap:!1}}),ae=new m({props:{code:"YXBpLnNldF9zcGFjZV9zbGVlcF90aW1lKHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:`<span class="hljs-comment"># Put your Space to sleep after 1h of inactivity</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.set_space_sleep_time(repo_id=repo_id, sleep_time=<span class="hljs-number">3600</span>)`,wrap:!1}}),Me=new m({props:{code:"YXBpLnJlcXVlc3Rfc3BhY2VfaGFyZHdhcmUocmVwb19pZCUzRHJlcG9faWQlMkMlMjBoYXJkd2FyZSUzRFNwYWNlSGFyZHdhcmUuVDRfTUVESVVNJTJDJTIwc2xlZXBfdGltZSUzRDM2MDAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_hardware(repo_id=repo_id, hardware=SpaceHardware.T4_MEDIUM, sleep_time=<span class="hljs-number">3600</span>)',wrap:!1}}),ce=new m({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9oYXJkd2FyZSUzRCUyMnQ0LW1lZGl1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwYWNlX3NsZWVwX3RpbWUlM0QlMjIzNjAwJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    space_sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),oe=new m({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMGhhcmR3YXJlJTNEJTIydDQtbWVkaXVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2xlZXBfdGltZSUzRCUyMjM2MDAlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    hardware=<span class="hljs-string">&quot;t4-medium&quot;</span>,
<span class="hljs-meta">... </span>    sleep_time=<span class="hljs-string">&quot;3600&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),je=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlU3RvcmFnZSUwQWFwaS5yZXF1ZXN0X3NwYWNlX3N0b3JhZ2UocmVwb19pZCUzRHJlcG9faWQlMkMlMjBzdG9yYWdlJTNEU3BhY2VTdG9yYWdlLkxBUkdFKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceStorage
<span class="hljs-meta">&gt;&gt;&gt; </span>api.request_space_storage(repo_id=repo_id, storage=SpaceStorage.LARGE)`,wrap:!1}}),he=new m({props:{code:"YXBpLmRlbGV0ZV9zcGFjZV9zdG9yYWdlKHJlcG9faWQlM0RyZXBvX2lkKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>api.delete_space_storage(repo_id=repo_id)',wrap:!1}}),Je=new m({props:{code:"YXBpLmNyZWF0ZV9yZXBvKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBzcGFjZV9zZGslM0QlMjJncmFkaW8lMjIlMEElMjAlMjAlMjAlMjBzcGFjZV9zdG9yYWdlJTNEJTIybGFyZ2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_repo(
<span class="hljs-meta">... </span>    repo_id=repo_id,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>    space_sdk=<span class="hljs-string">&quot;gradio&quot;</span>
<span class="hljs-meta">... </span>    space_storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Te=new m({props:{code:"YXBpLmR1cGxpY2F0ZV9zcGFjZSglMEElMjAlMjAlMjAlMjBmcm9tX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHN0b3JhZ2UlM0QlMjJsYXJnZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.duplicate_space(
<span class="hljs-meta">... </span>    from_id=repo_id,
<span class="hljs-meta">... </span>    storage=<span class="hljs-string">&quot;large&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ue=new Se({props:{title:"More advanced: temporarily upgrade your Space !",local:"more-advanced-temporarily-upgrade-your-space-",headingTag:"h2"}}),_e=new Se({props:{title:"App skeleton",local:"app-skeleton",headingTag:"h3"}}),Ce=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># Space will need your token to request hardware: set it as a Secret !</span>
HF_TOKEN = os.environ.get(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Space own repo_id</span>
TRAINING_SPACE_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-training&quot;</span>

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, SpaceHardware
api = HfApi(token=HF_TOKEN)

<span class="hljs-comment"># On Space startup, check if a task is scheduled. If yes, finetune the model. If not,</span>
<span class="hljs-comment"># display an interface to request a new task.</span>
task = get_task()
<span class="hljs-keyword">if</span> task <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># Start Gradio app</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">gradio_fn</span>(<span class="hljs-params">task</span>):
        <span class="hljs-comment"># On user request, add task and request hardware</span>
        add_task(task)
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)

    gr.Interface(fn=gradio_fn, ...).launch()
<span class="hljs-keyword">else</span>:
    runtime = api.get_space_runtime(repo_id=TRAINING_SPACE_ID)
    <span class="hljs-comment"># Check if Space is loaded with a GPU.</span>
    <span class="hljs-keyword">if</span> runtime.hardware == SpaceHardware.T4_MEDIUM:
        <span class="hljs-comment"># If yes, finetune base model on dataset !</span>
        train_and_upload(task)

        <span class="hljs-comment"># Then, mark the task as &quot;DONE&quot;</span>
        mark_as_done(task)

        <span class="hljs-comment"># DO NOT FORGET: set back CPU hardware</span>
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.CPU_BASIC)
    <span class="hljs-keyword">else</span>:
        api.request_space_hardware(repo_id=TRAINING_SPACE_ID, hardware=SpaceHardware.T4_MEDIUM)`,wrap:!1}}),Be=new Se({props:{title:"Task scheduler",local:"task-scheduler",headingTag:"h3"}}),Ge=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># Dataset ID in which a \`tasks.csv\` file contains the tasks to perform.</span>
<span class="hljs-comment"># Here is a basic example for \`tasks.csv\` containing inputs (base model and dataset)</span>
<span class="hljs-comment"># and status (PENDING or DONE).</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-1,DONE</span>
<span class="hljs-comment">#     multimodalart/sd-fine-tunable,Wauplin/concept-2,PENDING</span>
TASK_DATASET_ID = <span class="hljs-string">&quot;Wauplin/dreambooth-task-scheduler&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">_get_csv_file</span>():
    <span class="hljs-keyword">return</span> hf_hub_download(repo_id=TASK_DATASET_ID, filename=<span class="hljs-string">&quot;tasks.csv&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, token=HF_TOKEN)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_task</span>():
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        csv_reader = csv.reader(csv_file, delimiter=<span class="hljs-string">&#x27;,&#x27;</span>)
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> csv_reader:
            <span class="hljs-keyword">if</span> row[<span class="hljs-number">2</span>] == <span class="hljs-string">&quot;PENDING&quot;</span>:
                <span class="hljs-keyword">return</span> row[<span class="hljs-number">0</span>], row[<span class="hljs-number">1</span>] <span class="hljs-comment"># model_id, dataset_id</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_task</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to add a task</span>
        path_or_fileobj=(tasks + <span class="hljs-string">f&quot;\\n<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>).encode()
    )

<span class="hljs-keyword">def</span> <span class="hljs-title function_">mark_as_done</span>(<span class="hljs-params">task</span>):
    model_id, dataset_id = task
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(_get_csv_file()) <span class="hljs-keyword">as</span> csv_file:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(csv_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
            tasks = f.read()

    api.upload_file(
        repo_id=repo_id,
        repo_type=repo_type,
        path_in_repo=<span class="hljs-string">&quot;tasks.csv&quot;</span>,
        <span class="hljs-comment"># Quick and dirty way to set the task as DONE</span>
        path_or_fileobj=tasks.replace(
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,PENDING&quot;</span>,
            <span class="hljs-string">f&quot;<span class="hljs-subst">{model_id}</span>,<span class="hljs-subst">{dataset_id}</span>,DONE&quot;</span>
        ).encode()
    )`,wrap:!1}}),be=new Dl({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/manage-spaces.md"}}),{c(){h=p("meta"),$e=a(),Ee=p("p"),Ne=a(),r(U.$$.fragment),ve=a(),r(f.$$.fragment),Re=a(),g=p("p"),g.innerHTML=sl,Fe=a(),r(I.$$.fragment),Ye=a(),_=p("p"),_.textContent=ll,Ve=a(),k=p("p"),k.innerHTML=tl,Qe=a(),r(C.$$.fragment),qe=a(),B=p("p"),B.innerHTML=al,He=a(),Z=p("p"),Z.innerHTML=nl,We=a(),r(G.$$.fragment),xe=a(),b=p("p"),b.innerHTML=pl,ze=a(),X=p("p"),X.innerHTML=il,Le=a(),r(E.$$.fragment),De=a(),A=p("p"),A.textContent=Ml,Pe=a(),S=p("p"),S.innerHTML=rl,Ke=a(),$=p("p"),$.innerHTML=cl,Oe=a(),r(N.$$.fragment),es=a(),v=p("p"),v.textContent=ol,ss=a(),r(R.$$.fragment),ls=a(),d=p("blockquote"),d.innerHTML=yl,ts=a(),w=p("blockquote"),w.innerHTML=ul,as=a(),F=p("p"),F.innerHTML=jl,ns=a(),Y=p("p"),Y.textContent=ml,ps=a(),r(V.$$.fragment),is=a(),r(Q.$$.fragment),Ms=a(),q=p("p"),q.innerHTML=hl,rs=a(),H=p("p"),H.innerHTML=dl,cs=a(),r(W.$$.fragment),os=a(),x=p("p"),x.textContent=wl,ys=a(),r(z.$$.fragment),us=a(),L=p("p"),L.textContent=Jl,js=a(),D=p("p"),D.innerHTML=Tl,ms=a(),P=p("p"),P.textContent=Ul,hs=a(),r(K.$$.fragment),ds=a(),r(O.$$.fragment),ws=a(),ee=p("p"),ee.innerHTML=fl,Js=a(),se=p("p"),se.innerHTML=gl,Ts=a(),r(le.$$.fragment),Us=a(),te=p("p"),te.innerHTML=Il,fs=a(),r(ae.$$.fragment),gs=a(),ne=p("p"),ne.textContent=_l,Is=a(),pe=p("p"),pe.innerHTML=kl,_s=a(),ie=p("p"),ie.textContent=Cl,ks=a(),r(Me.$$.fragment),Cs=a(),re=p("p"),re.innerHTML=Bl,Bs=a(),r(ce.$$.fragment),Zs=a(),r(oe.$$.fragment),Gs=a(),ye=p("p"),ye.innerHTML=Zl,bs=a(),ue=p("p"),ue.innerHTML=Gl,Xs=a(),r(je.$$.fragment),Es=a(),me=p("p"),me.textContent=bl,As=a(),r(he.$$.fragment),Ss=a(),de=p("p"),de.textContent=Xl,$s=a(),we=p("p"),we.innerHTML=El,Ns=a(),r(Je.$$.fragment),vs=a(),r(Te.$$.fragment),Rs=a(),r(Ue.$$.fragment),Fs=a(),fe=p("p"),fe.textContent=Al,Ys=a(),ge=p("p"),ge.textContent=Sl,Vs=a(),J=p("ol"),J.innerHTML=$l,Qs=a(),Ie=p("p"),Ie.textContent=Nl,qs=a(),r(_e.$$.fragment),Hs=a(),ke=p("p"),ke.textContent=vl,Ws=a(),T=p("blockquote"),T.innerHTML=Rl,xs=a(),r(Ce.$$.fragment),zs=a(),r(Be.$$.fragment),Ls=a(),Ze=p("p"),Ze.textContent=Fl,Ds=a(),r(Ge.$$.fragment),Ps=a(),r(be.$$.fragment),Ks=a(),Ae=p("p"),this.h()},l(e){const s=xl("svelte-u9bgzb",document.head);h=i(s,"META",{name:!0,content:!0}),s.forEach(l),$e=n(e),Ee=i(e,"P",{}),Yl(Ee).forEach(l),Ne=n(e),c(U.$$.fragment,e),ve=n(e),c(f.$$.fragment,e),Re=n(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1ppnonz"&&(g.innerHTML=sl),Fe=n(e),c(I.$$.fragment,e),Ye=n(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-16uv4iz"&&(_.textContent=ll),Ve=n(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-ntfke8"&&(k.innerHTML=tl),Qe=n(e),c(C.$$.fragment,e),qe=n(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-18k6wu9"&&(B.innerHTML=al),He=n(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1gaojpz"&&(Z.innerHTML=nl),We=n(e),c(G.$$.fragment,e),xe=n(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-hnqkcz"&&(b.innerHTML=pl),ze=n(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-8mheo9"&&(X.innerHTML=il),Le=n(e),c(E.$$.fragment,e),De=n(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1z3goh"&&(A.textContent=Ml),Pe=n(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1sfgan5"&&(S.innerHTML=rl),Ke=n(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1704hn0"&&($.innerHTML=cl),Oe=n(e),c(N.$$.fragment,e),es=n(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-65kjzl"&&(v.textContent=ol),ss=n(e),c(R.$$.fragment,e),ls=n(e),d=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(d)!=="svelte-12qe2u4"&&(d.innerHTML=yl),ts=n(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(w)!=="svelte-104j5w6"&&(w.innerHTML=ul),as=n(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-poxyid"&&(F.innerHTML=jl),ns=n(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1rmjpll"&&(Y.textContent=ml),ps=n(e),c(V.$$.fragment,e),is=n(e),c(Q.$$.fragment,e),Ms=n(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-vobpqe"&&(q.innerHTML=hl),rs=n(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1ctsnq4"&&(H.innerHTML=dl),cs=n(e),c(W.$$.fragment,e),os=n(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-aczhvz"&&(x.textContent=wl),ys=n(e),c(z.$$.fragment,e),us=n(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-c540cm"&&(L.textContent=Jl),js=n(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-jbzoo9"&&(D.innerHTML=Tl),ms=n(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-4tl7ie"&&(P.textContent=Ul),hs=n(e),c(K.$$.fragment,e),ds=n(e),c(O.$$.fragment,e),ws=n(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1i0f4op"&&(ee.innerHTML=fl),Js=n(e),se=i(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1ral3em"&&(se.innerHTML=gl),Ts=n(e),c(le.$$.fragment,e),Us=n(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-i61a5x"&&(te.innerHTML=Il),fs=n(e),c(ae.$$.fragment,e),gs=n(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-97ry2r"&&(ne.textContent=_l),Is=n(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1lxv1bl"&&(pe.innerHTML=kl),_s=n(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-4tl7ie"&&(ie.textContent=Cl),ks=n(e),c(Me.$$.fragment,e),Cs=n(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-5hjx5j"&&(re.innerHTML=Bl),Bs=n(e),c(ce.$$.fragment,e),Zs=n(e),c(oe.$$.fragment,e),Gs=n(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-pvw90y"&&(ye.innerHTML=Zl),bs=n(e),ue=i(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-2qrjmq"&&(ue.innerHTML=Gl),Xs=n(e),c(je.$$.fragment,e),Es=n(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-1u6d0ko"&&(me.textContent=bl),As=n(e),c(he.$$.fragment,e),Ss=n(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-m35g6d"&&(de.textContent=Xl),$s=n(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1mxuks2"&&(we.innerHTML=El),Ns=n(e),c(Je.$$.fragment,e),vs=n(e),c(Te.$$.fragment,e),Rs=n(e),c(Ue.$$.fragment,e),Fs=n(e),fe=i(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1gmpxen"&&(fe.textContent=Al),Ys=n(e),ge=i(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-10q1pgf"&&(ge.textContent=Sl),Vs=n(e),J=i(e,"OL",{start:!0,"data-svelte-h":!0}),M(J)!=="svelte-1guz9nt"&&(J.innerHTML=$l),Qs=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-14y67eb"&&(Ie.textContent=Nl),qs=n(e),c(_e.$$.fragment,e),Hs=n(e),ke=i(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-16rgffk"&&(ke.textContent=vl),Ws=n(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-ejau2q"&&(T.innerHTML=Rl),xs=n(e),c(Ce.$$.fragment,e),zs=n(e),c(Be.$$.fragment,e),Ls=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1fps41q"&&(Ze.textContent=Fl),Ds=n(e),c(Ge.$$.fragment,e),Ps=n(e),c(be.$$.fragment,e),Ks=n(e),Ae=i(e,"P",{}),Yl(Ae).forEach(l),this.h()},h(){Xe(h,"name","hf:doc:metadata"),Xe(h,"content",Kl),Xe(d,"class","tip"),Xe(w,"class","warning"),Xe(J,"start","0"),Xe(T,"class","warning")},m(e,s){zl(document.head,h),t(e,$e,s),t(e,Ee,s),t(e,Ne,s),o(U,e,s),t(e,ve,s),o(f,e,s),t(e,Re,s),t(e,g,s),t(e,Fe,s),o(I,e,s),t(e,Ye,s),t(e,_,s),t(e,Ve,s),t(e,k,s),t(e,Qe,s),o(C,e,s),t(e,qe,s),t(e,B,s),t(e,He,s),t(e,Z,s),t(e,We,s),o(G,e,s),t(e,xe,s),t(e,b,s),t(e,ze,s),t(e,X,s),t(e,Le,s),o(E,e,s),t(e,De,s),t(e,A,s),t(e,Pe,s),t(e,S,s),t(e,Ke,s),t(e,$,s),t(e,Oe,s),o(N,e,s),t(e,es,s),t(e,v,s),t(e,ss,s),o(R,e,s),t(e,ls,s),t(e,d,s),t(e,ts,s),t(e,w,s),t(e,as,s),t(e,F,s),t(e,ns,s),t(e,Y,s),t(e,ps,s),o(V,e,s),t(e,is,s),o(Q,e,s),t(e,Ms,s),t(e,q,s),t(e,rs,s),t(e,H,s),t(e,cs,s),o(W,e,s),t(e,os,s),t(e,x,s),t(e,ys,s),o(z,e,s),t(e,us,s),t(e,L,s),t(e,js,s),t(e,D,s),t(e,ms,s),t(e,P,s),t(e,hs,s),o(K,e,s),t(e,ds,s),o(O,e,s),t(e,ws,s),t(e,ee,s),t(e,Js,s),t(e,se,s),t(e,Ts,s),o(le,e,s),t(e,Us,s),t(e,te,s),t(e,fs,s),o(ae,e,s),t(e,gs,s),t(e,ne,s),t(e,Is,s),t(e,pe,s),t(e,_s,s),t(e,ie,s),t(e,ks,s),o(Me,e,s),t(e,Cs,s),t(e,re,s),t(e,Bs,s),o(ce,e,s),t(e,Zs,s),o(oe,e,s),t(e,Gs,s),t(e,ye,s),t(e,bs,s),t(e,ue,s),t(e,Xs,s),o(je,e,s),t(e,Es,s),t(e,me,s),t(e,As,s),o(he,e,s),t(e,Ss,s),t(e,de,s),t(e,$s,s),t(e,we,s),t(e,Ns,s),o(Je,e,s),t(e,vs,s),o(Te,e,s),t(e,Rs,s),o(Ue,e,s),t(e,Fs,s),t(e,fe,s),t(e,Ys,s),t(e,ge,s),t(e,Vs,s),t(e,J,s),t(e,Qs,s),t(e,Ie,s),t(e,qs,s),o(_e,e,s),t(e,Hs,s),t(e,ke,s),t(e,Ws,s),t(e,T,s),t(e,xs,s),o(Ce,e,s),t(e,zs,s),o(Be,e,s),t(e,Ls,s),t(e,Ze,s),t(e,Ds,s),o(Ge,e,s),t(e,Ps,s),o(be,e,s),t(e,Ks,s),t(e,Ae,s),Os=!0},p:Ql,i(e){Os||(y(U.$$.fragment,e),y(f.$$.fragment,e),y(I.$$.fragment,e),y(C.$$.fragment,e),y(G.$$.fragment,e),y(E.$$.fragment,e),y(N.$$.fragment,e),y(R.$$.fragment,e),y(V.$$.fragment,e),y(Q.$$.fragment,e),y(W.$$.fragment,e),y(z.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(oe.$$.fragment,e),y(je.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(Te.$$.fragment,e),y(Ue.$$.fragment,e),y(_e.$$.fragment,e),y(Ce.$$.fragment,e),y(Be.$$.fragment,e),y(Ge.$$.fragment,e),y(be.$$.fragment,e),Os=!0)},o(e){u(U.$$.fragment,e),u(f.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(G.$$.fragment,e),u(E.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(W.$$.fragment,e),u(z.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(Me.$$.fragment,e),u(ce.$$.fragment,e),u(oe.$$.fragment,e),u(je.$$.fragment,e),u(he.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(_e.$$.fragment,e),u(Ce.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(be.$$.fragment,e),Os=!1},d(e){e&&(l($e),l(Ee),l(Ne),l(ve),l(Re),l(g),l(Fe),l(Ye),l(_),l(Ve),l(k),l(Qe),l(qe),l(B),l(He),l(Z),l(We),l(xe),l(b),l(ze),l(X),l(Le),l(De),l(A),l(Pe),l(S),l(Ke),l($),l(Oe),l(es),l(v),l(ss),l(ls),l(d),l(ts),l(w),l(as),l(F),l(ns),l(Y),l(ps),l(is),l(Ms),l(q),l(rs),l(H),l(cs),l(os),l(x),l(ys),l(us),l(L),l(js),l(D),l(ms),l(P),l(hs),l(ds),l(ws),l(ee),l(Js),l(se),l(Ts),l(Us),l(te),l(fs),l(gs),l(ne),l(Is),l(pe),l(_s),l(ie),l(ks),l(Cs),l(re),l(Bs),l(Zs),l(Gs),l(ye),l(bs),l(ue),l(Xs),l(Es),l(me),l(As),l(Ss),l(de),l($s),l(we),l(Ns),l(vs),l(Rs),l(Fs),l(fe),l(Ys),l(ge),l(Vs),l(J),l(Qs),l(Ie),l(qs),l(Hs),l(ke),l(Ws),l(T),l(xs),l(zs),l(Ls),l(Ze),l(Ds),l(Ps),l(Ks),l(Ae)),l(h),j(U,e),j(f,e),j(I,e),j(C,e),j(G,e),j(E,e),j(N,e),j(R,e),j(V,e),j(Q,e),j(W,e),j(z,e),j(K,e),j(O,e),j(le,e),j(ae,e),j(Me,e),j(ce,e),j(oe,e),j(je,e),j(he,e),j(Je,e),j(Te,e),j(Ue,e),j(_e,e),j(Ce,e),j(Be,e),j(Ge,e),j(be,e)}}}const Kl='{"title":"Manage your Space","local":"manage-your-space","sections":[{"title":"A simple example: configure secrets and hardware.","local":"a-simple-example-configure-secrets-and-hardware","sections":[],"depth":2},{"title":"More advanced: temporarily upgrade your Space !","local":"more-advanced-temporarily-upgrade-your-space-","sections":[{"title":"App skeleton","local":"app-skeleton","sections":[],"depth":3},{"title":"Task scheduler","local":"task-scheduler","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ol(el){return ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Hl{constructor(h){super(),Wl(this,h,Ol,Pl,Vl,{})}}export{nt as component};
