import{s as ka,n as Ca,o as Xa}from"../chunks/scheduler.0cf4ef2e.js";import{S as xa,i as Ha,e as i,s as l,c as p,h as Ua,a as r,d as a,b as n,f as Ga,g as o,j as g,k as Pt,l as Ya,m as s,n as c,t as f,o as h,p as m}from"../chunks/index.abc433bf.js";import{C as Ba}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as u}from"../chunks/CodeBlock.18a16f91.js";import{H as d,E as La}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function Ia(Qt){let y,xe,Ce,He,w,Ue,M,Ye,_,At=`The Hugging Face Hub is a collection of git repositories. <a href="https://git-scm.com/" rel="nofollow">Git</a> is a widely used tool in software
development to easily version projects when working collaboratively. This guide will show you how to interact with the
repositories on the Hub, especially:`,Be,v,Et="<li>Create and delete a repository.</li> <li>Manage branches and tags.</li> <li>Rename your repository.</li> <li>Update your repository visibility.</li> <li>Manage a local copy of your repository.</li>",Le,$,Ot=`<p>If you are used to working with platforms such as GitLab/GitHub/Bitbucket, your first instinct
might be to use <code>git</code> CLI to clone your repo (<code>git clone</code>), commit changes (<code>git add, git commit</code>) and push them
(<code>git push</code>). This is valid when using the Hugging Face Hub. However, software engineering and machine learning do
not share the same requirements and workflows. Model repositories might maintain large model weight files for different
frameworks and tools, so cloning the repository can lead to you maintaining large local folders with massive sizes. As
a result, it may be more efficient to use our custom HTTP methods. You can read our <a href="../concepts/git_vs_http">Git vs HTTP paradigm</a>
explanation page for more details.</p>`,Ie,T,Dt=`If you want to create and manage a repository on the Hub, your machine must be logged in. If you are not, please refer to
<a href="../quick-start#authentication">this section</a>. In the rest of this guide, we will assume that your machine is logged in.`,Re,j,We,Z,Kt=`The first step is to know how to create and delete repositories. You can only manage repositories that you own (under
your username namespace) or from organizations in which you have write permissions.`,qe,J,ze,G,ea='Create an empty repository with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> and give it a name with the <code>repo_id</code> parameter. The <code>repo_id</code> is your namespace followed by the repository name: <code>username_or_org/repo_name</code>.',Se,k,Ve,C,ta="Or via CLI:",Ne,X,Fe,x,aa='By default, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> creates a model repository. But you can use the <code>repo_type</code> parameter to specify another repository type. For example, if you want to create a dataset repository:',Pe,H,Qe,U,sa="Or via CLI:",Ae,Y,Ee,B,la="When you create a repository, you can set your repository visibility with the <code>private</code> parameter.",Oe,L,De,I,na="Or via CLI:",Ke,R,et,W,ia='If you want to change the repository visibility at a later time, you can use the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_repo_settings">update_repo_settings()</a> function.',tt,b,ra='<p>If you are part of an organization with an Enterprise plan, you can create a repo in a specific resource group by passing <code>resource_group_id</code> as parameter to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>. Resource groups are a security feature to control which members from your org can access a given resource. You can get the resource group ID by copying it from your org settings page url on the Hub (e.g. <code>&quot;https://huggingface.co/organizations/huggingface/settings/resource-groups/66670e5163145ca562cb1988&quot;</code> =&gt; <code>&quot;66670e5163145ca562cb1988&quot;</code>). For more details about resource group, check out this <a href="https://huggingface.co/docs/hub/en/security-resource-groups" rel="nofollow">guide</a>.</p>',at,q,st,z,pa='Delete a repository with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_repo">delete_repo()</a>. Make sure you want to delete a repository because this is an irreversible process!',lt,S,oa="Specify the <code>repo_id</code> of the repository you want to delete:",nt,V,it,N,ga="Or via CLI:",rt,F,pt,P,ot,Q,ca=`In some cases, you want to copy someone else’s repo to adapt it to your use case.
This is possible for Spaces using the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space">duplicate_space()</a> method. It will duplicate the whole repository.
You will still need to configure your own settings (hardware, sleep-time, storage, variables and secrets). Check out our <a href="./manage-spaces">Manage your Space</a> guide for more details.`,gt,A,ct,E,ft,O,fa="Now that you have created your repository, you are interested in pushing changes to it and downloading files from it.",ht,D,ha=`These 2 topics deserve their own guides. Please refer to the <a href="./upload">upload</a> and the <a href="./download">download</a> guides
to learn how to use your repository.`,mt,K,ut,ee,ma=`Git repositories often make use of branches to store different versions of a same repository.
Tags can also be used to flag a specific state of your repository, for example, when releasing a version.
More generally, branches and tags are referred as <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References" rel="nofollow">git references</a>.`,dt,te,yt,ae,ua='You can create new branch and tags using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_branch">create_branch()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_tag">create_tag()</a>:',$t,se,bt,le,da="Or via CLI:",wt,ne,Mt,ie,ya='You can use the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_branch">delete_branch()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_tag">delete_tag()</a> functions in the same way to delete a branch or a tag, or <code>hf repo branch delete</code> and <code>hf repo tag delete</code> respectively in CLI.',_t,re,vt,pe,$a='You can also list the existing git refs from a repository using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>:',Tt,oe,jt,ge,Zt,ce,ba=`Repositories come with some settings that you can configure. Most of the time, you will want to do that manually in the
repo settings page in your browser. You must have write access to a repo to configure it (either own it or being part of
an organization). In this section, we will see the settings that you can also configure programmatically using <code>huggingface_hub</code>.`,Jt,fe,wa='Some settings are specific to Spaces (hardware, environment variables,…). To configure those, please refer to our <a href="../guides/manage-spaces">Manage your Spaces</a> guide.',Gt,he,kt,me,Ma="A repository can be public or private. A private repository is only visible to you or members of the organization in which the repository is located. Change a repository to private as shown in the following:",Ct,ue,Xt,de,_a="Or via CLI:",xt,ye,Ht,$e,Ut,be,va="To give more control over how repos are used, the Hub allows repo authors to enable <strong>access requests</strong> for their repos. User must agree to share their contact information (username and email address) with the repo authors to access the files when enabled. A repo with access requests enabled is called a <strong>gated repo</strong>.",Yt,we,Ta='You can set a repo as gated using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_repo_settings">update_repo_settings()</a>:',Bt,Me,Lt,_e,ja="Or via CLI:",It,ve,Rt,Te,Wt,je,Za=`You can rename your repository on the Hub using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.move_repo">move_repo()</a>. Using this method, you can also move the repo from a user to
an organization. When doing so, there are a <a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">few limitations</a>
that you should be aware of. For example, you can’t transfer your repo to another user.`,qt,Ze,zt,Je,Ja="Or via CLI:",St,Ge,Vt,ke,Nt,Xe,Ft;return w=new Ba({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new d({props:{title:"Create and manage a repository",local:"create-and-manage-a-repository",headingTag:"h1"}}),j=new d({props:{title:"Repo creation and deletion",local:"repo-creation-and-deletion",headingTag:"h2"}}),J=new d({props:{title:"Create a repository",local:"create-a-repository",headingTag:"h3"}}),k=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),X=new u({props:{code:"aGYlMjByZXBvJTIwY3JlYXRlJTIwbHlzYW5kcmUlMkZ0ZXN0LW1vZGVs",highlighted:`&gt;&gt;&gt; hf repo create lysandre/test-model
Successfully created lysandre/test-model on the Hub.
Your repo is now available at https://huggingface.co/lysandre/test-model`,wrap:!1}}),H=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/datasets/lysandre/test-dataset&#x27;</span>`,wrap:!1}}),Y=new u({props:{code:"aGYlMjByZXBvJTIwY3JlYXRlJTIwbHlzYW5kcmUlMkZ0ZXN0LWRhdGFzZXQlMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQ=",highlighted:"&gt;&gt;&gt; hf repo create lysandre/test-dataset --repo-type dataset",wrap:!1}}),L=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-private&quot;</span>, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),R=new u({props:{code:"aGYlMjByZXBvJTIwY3JlYXRlJTIwbHlzYW5kcmUlMkZ0ZXN0LXByaXZhdGUlMjAtLXByaXZhdGU=",highlighted:"&gt;&gt;&gt; hf repo create lysandre/test-private --private",wrap:!1}}),q=new d({props:{title:"Delete a repository",local:"delete-a-repository",headingTag:"h3"}}),V=new u({props:{code:"ZGVsZXRlX3JlcG8ocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGbXktY29ycnVwdGVkLWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>delete_repo(repo_id=<span class="hljs-string">&quot;lysandre/my-corrupted-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)',wrap:!1}}),F=new u({props:{code:"aGYlMjByZXBvJTIwZGVsZXRlJTIwbHlzYW5kcmUlMkZteS1jb3JydXB0ZWQtZGF0YXNldCUyMC0tcmVwby10eXBlJTIwZGF0YXNldA==",highlighted:"&gt;&gt;&gt; hf repo delete lysandre/my-corrupted-dataset --repo-type dataset",wrap:!1}}),P=new d({props:{title:"Duplicate a repository (only for Spaces)",local:"duplicate-a-repository-only-for-spaces",headingTag:"h3"}}),A=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiUyQyUyMHByaXZhdGUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, private=<span class="hljs-literal">False</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)`,wrap:!1}}),E=new d({props:{title:"Upload and download files",local:"upload-and-download-files",headingTag:"h2"}}),K=new d({props:{title:"Branches and tags",local:"branches-and-tags",headingTag:"h2"}}),te=new d({props:{title:"Create branches and tags",local:"create-branches-and-tags",headingTag:"h3"}}),se=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9icmFuY2glMkMlMjBjcmVhdGVfdGFnJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJNYXR0aGlqcyUyRnNwZWVjaHQ1LXR0cy1kZW1vJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjBicmFuY2glM0QlMjJoYW5kbGUtZG9nLXNwZWFrZXIlMjIpJTBBJTBBY3JlYXRlX3RhZyglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjAuMS1yZWxlYXNlJTIyJTJDJTIwdGFnJTNEJTIydjAuMS4xJTIyJTJDJTIwdGFnX21lc3NhZ2UlM0QlMjJCdW1wJTIwcmVsZWFzZSUyMHZlcnNpb24uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_branch, create_tag

<span class="hljs-comment"># Create a branch on a Space repo from \`main\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;Matthijs/speecht5-tts-demo&quot;</span>, repo_type=<span class="hljs-string">&quot;space&quot;</span>, branch=<span class="hljs-string">&quot;handle-dog-speaker&quot;</span>)

<span class="hljs-comment"># Create a tag on a Dataset repo from \`v0.1-release\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_tag(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, revision=<span class="hljs-string">&quot;v0.1-release&quot;</span>, tag=<span class="hljs-string">&quot;v0.1.1&quot;</span>, tag_message=<span class="hljs-string">&quot;Bump release version.&quot;</span>)`,wrap:!1}}),ne=new u({props:{code:"aGYlMjByZXBvJTIwYnJhbmNoJTIwY3JlYXRlJTIwTWF0dGhpanMlMkZzcGVlY2h0NS10dHMtZGVtbyUyMGhhbmRsZS1kb2ctc3BlYWtlciUyMC0tcmVwby10eXBlJTIwc3BhY2UlMEFoZiUyMHJlcG8lMjB0YWclMjBjcmVhdGUlMjBiaWdjb2RlJTJGdGhlLXN0YWNrJTIwdjAuMS4xJTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTIwLS1yZXZpc2lvbiUyMHYwLjEtcmVsZWFzZSUyMC1tJTIwJTIyQnVtcCUyMHJlbGVhc2UlMjB2ZXJzaW9uLiUyMg==",highlighted:`&gt;&gt;&gt; hf repo branch create Matthijs/speecht5-tts-demo handle-dog-speaker --repo-type space
&gt;&gt;&gt; hf repo tag create bigcode/the-stack v0.1.1 --repo-type dataset --revision v0.1-release -m <span class="hljs-string">&quot;Bump release version.&quot;</span>`,wrap:!1}}),re=new d({props:{title:"List all branches and tags",local:"list-all-branches-and-tags",headingTag:"h3"}}),oe=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb19yZWZzJTBBbGlzdF9yZXBvX3JlZnMoJTIyYmlnY29kZSUyRnRoZS1zdGFjayUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_refs
<span class="hljs-meta">&gt;&gt;&gt; </span>list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
GitRefs(
   branches=[
         GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
   ],
   converts=[],
   tags=[
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
   ]
)`,wrap:!1}}),ge=new d({props:{title:"Change repository settings",local:"change-repository-settings",headingTag:"h2"}}),he=new d({props:{title:"Update visibility",local:"update-visibility",headingTag:"h3"}}),ue=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9yZXBvX3NldHRpbmdzJTBBdXBkYXRlX3JlcG9fc2V0dGluZ3MocmVwb19pZCUzRHJlcG9faWQlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_repo_settings
<span class="hljs-meta">&gt;&gt;&gt; </span>update_repo_settings(repo_id=repo_id, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),ye=new u({props:{code:"aGYlMjByZXBvJTIwc2V0dGluZ3MlMjBseXNhbmRyZSUyRnRlc3QtcHJpdmF0ZSUyMC0tcHJpdmF0ZSUyMHRydWU=",highlighted:'&gt;&gt;&gt; hf repo settings lysandre/test-private --private <span class="hljs-literal">true</span>',wrap:!1}}),$e=new d({props:{title:"Setup gated access",local:"setup-gated-access",headingTag:"h3"}}),Me=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGRhdGVfcmVwb19zZXR0aW5ncyhyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGdhdGVkJTNEJTIyYXV0byUyMiklMjAlMjAlMjMlMjBTZXQlMjBhdXRvbWF0aWMlMjBnYXRpbmclMjBmb3IlMjBhJTIwbW9kZWw=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.update_repo_settings(repo_id=repo_id, gated=<span class="hljs-string">&quot;auto&quot;</span>)  <span class="hljs-comment"># Set automatic gating for a model</span>`,wrap:!1}}),ve=new u({props:{code:"aGYlMjByZXBvJTIwc2V0dGluZ3MlMjBseXNhbmRyZSUyRnRlc3QtcHJpdmF0ZSUyMC0tZ2F0ZWQlMjBhdXRv",highlighted:"&gt;&gt;&gt; hf repo settings lysandre/test-private --gated auto",wrap:!1}}),Te=new d({props:{title:"Rename your repository",local:"rename-your-repository",headingTag:"h3"}}),Ze=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1vdmVfcmVwbyUwQW1vdmVfcmVwbyhmcm9tX2lkJTNEJTIyV2F1cGxpbiUyRmNvb2wtbW9kZWwlMjIlMkMlMjB0b19pZCUzRCUyMmh1Z2dpbmdmYWNlJTJGY29vbC1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> move_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>move_repo(from_id=<span class="hljs-string">&quot;Wauplin/cool-model&quot;</span>, to_id=<span class="hljs-string">&quot;huggingface/cool-model&quot;</span>)`,wrap:!1}}),Ge=new u({props:{code:"aGYlMjByZXBvJTIwbW92ZSUyMFdhdXBsaW4lMkZjb29sLW1vZGVsJTIwaHVnZ2luZ2ZhY2UlMkZjb29sLW1vZGVs",highlighted:"&gt;&gt;&gt; hf repo move Wauplin/cool-model huggingface/cool-model",wrap:!1}}),ke=new La({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/repository.md"}}),{c(){y=i("meta"),xe=l(),Ce=i("p"),He=l(),p(w.$$.fragment),Ue=l(),p(M.$$.fragment),Ye=l(),_=i("p"),_.innerHTML=At,Be=l(),v=i("ul"),v.innerHTML=Et,Le=l(),$=i("blockquote"),$.innerHTML=Ot,Ie=l(),T=i("p"),T.innerHTML=Dt,Re=l(),p(j.$$.fragment),We=l(),Z=i("p"),Z.textContent=Kt,qe=l(),p(J.$$.fragment),ze=l(),G=i("p"),G.innerHTML=ea,Se=l(),p(k.$$.fragment),Ve=l(),C=i("p"),C.textContent=ta,Ne=l(),p(X.$$.fragment),Fe=l(),x=i("p"),x.innerHTML=aa,Pe=l(),p(H.$$.fragment),Qe=l(),U=i("p"),U.textContent=sa,Ae=l(),p(Y.$$.fragment),Ee=l(),B=i("p"),B.innerHTML=la,Oe=l(),p(L.$$.fragment),De=l(),I=i("p"),I.textContent=na,Ke=l(),p(R.$$.fragment),et=l(),W=i("p"),W.innerHTML=ia,tt=l(),b=i("blockquote"),b.innerHTML=ra,at=l(),p(q.$$.fragment),st=l(),z=i("p"),z.innerHTML=pa,lt=l(),S=i("p"),S.innerHTML=oa,nt=l(),p(V.$$.fragment),it=l(),N=i("p"),N.textContent=ga,rt=l(),p(F.$$.fragment),pt=l(),p(P.$$.fragment),ot=l(),Q=i("p"),Q.innerHTML=ca,gt=l(),p(A.$$.fragment),ct=l(),p(E.$$.fragment),ft=l(),O=i("p"),O.textContent=fa,ht=l(),D=i("p"),D.innerHTML=ha,mt=l(),p(K.$$.fragment),ut=l(),ee=i("p"),ee.innerHTML=ma,dt=l(),p(te.$$.fragment),yt=l(),ae=i("p"),ae.innerHTML=ua,$t=l(),p(se.$$.fragment),bt=l(),le=i("p"),le.textContent=da,wt=l(),p(ne.$$.fragment),Mt=l(),ie=i("p"),ie.innerHTML=ya,_t=l(),p(re.$$.fragment),vt=l(),pe=i("p"),pe.innerHTML=$a,Tt=l(),p(oe.$$.fragment),jt=l(),p(ge.$$.fragment),Zt=l(),ce=i("p"),ce.innerHTML=ba,Jt=l(),fe=i("p"),fe.innerHTML=wa,Gt=l(),p(he.$$.fragment),kt=l(),me=i("p"),me.textContent=Ma,Ct=l(),p(ue.$$.fragment),Xt=l(),de=i("p"),de.textContent=_a,xt=l(),p(ye.$$.fragment),Ht=l(),p($e.$$.fragment),Ut=l(),be=i("p"),be.innerHTML=va,Yt=l(),we=i("p"),we.innerHTML=Ta,Bt=l(),p(Me.$$.fragment),Lt=l(),_e=i("p"),_e.textContent=ja,It=l(),p(ve.$$.fragment),Rt=l(),p(Te.$$.fragment),Wt=l(),je=i("p"),je.innerHTML=Za,qt=l(),p(Ze.$$.fragment),zt=l(),Je=i("p"),Je.textContent=Ja,St=l(),p(Ge.$$.fragment),Vt=l(),p(ke.$$.fragment),Nt=l(),Xe=i("p"),this.h()},l(e){const t=Ua("svelte-u9bgzb",document.head);y=r(t,"META",{name:!0,content:!0}),t.forEach(a),xe=n(e),Ce=r(e,"P",{}),Ga(Ce).forEach(a),He=n(e),o(w.$$.fragment,e),Ue=n(e),o(M.$$.fragment,e),Ye=n(e),_=r(e,"P",{"data-svelte-h":!0}),g(_)!=="svelte-15r6soe"&&(_.innerHTML=At),Be=n(e),v=r(e,"UL",{"data-svelte-h":!0}),g(v)!=="svelte-jzhbqw"&&(v.innerHTML=Et),Le=n(e),$=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),g($)!=="svelte-1c4uawz"&&($.innerHTML=Ot),Ie=n(e),T=r(e,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1u5cce3"&&(T.innerHTML=Dt),Re=n(e),o(j.$$.fragment,e),We=n(e),Z=r(e,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1yl5xsc"&&(Z.textContent=Kt),qe=n(e),o(J.$$.fragment,e),ze=n(e),G=r(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-lwdt4f"&&(G.innerHTML=ea),Se=n(e),o(k.$$.fragment,e),Ve=n(e),C=r(e,"P",{"data-svelte-h":!0}),g(C)!=="svelte-zihpvf"&&(C.textContent=ta),Ne=n(e),o(X.$$.fragment,e),Fe=n(e),x=r(e,"P",{"data-svelte-h":!0}),g(x)!=="svelte-thoypj"&&(x.innerHTML=aa),Pe=n(e),o(H.$$.fragment,e),Qe=n(e),U=r(e,"P",{"data-svelte-h":!0}),g(U)!=="svelte-zihpvf"&&(U.textContent=sa),Ae=n(e),o(Y.$$.fragment,e),Ee=n(e),B=r(e,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1lhlim8"&&(B.innerHTML=la),Oe=n(e),o(L.$$.fragment,e),De=n(e),I=r(e,"P",{"data-svelte-h":!0}),g(I)!=="svelte-zihpvf"&&(I.textContent=na),Ke=n(e),o(R.$$.fragment,e),et=n(e),W=r(e,"P",{"data-svelte-h":!0}),g(W)!=="svelte-meq751"&&(W.innerHTML=ia),tt=n(e),b=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),g(b)!=="svelte-g1df66"&&(b.innerHTML=ra),at=n(e),o(q.$$.fragment,e),st=n(e),z=r(e,"P",{"data-svelte-h":!0}),g(z)!=="svelte-wzuy4v"&&(z.innerHTML=pa),lt=n(e),S=r(e,"P",{"data-svelte-h":!0}),g(S)!=="svelte-130g6n6"&&(S.innerHTML=oa),nt=n(e),o(V.$$.fragment,e),it=n(e),N=r(e,"P",{"data-svelte-h":!0}),g(N)!=="svelte-zihpvf"&&(N.textContent=ga),rt=n(e),o(F.$$.fragment,e),pt=n(e),o(P.$$.fragment,e),ot=n(e),Q=r(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-1mzmozw"&&(Q.innerHTML=ca),gt=n(e),o(A.$$.fragment,e),ct=n(e),o(E.$$.fragment,e),ft=n(e),O=r(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-1sdwkqa"&&(O.textContent=fa),ht=n(e),D=r(e,"P",{"data-svelte-h":!0}),g(D)!=="svelte-1sqatlx"&&(D.innerHTML=ha),mt=n(e),o(K.$$.fragment,e),ut=n(e),ee=r(e,"P",{"data-svelte-h":!0}),g(ee)!=="svelte-1rc0mjs"&&(ee.innerHTML=ma),dt=n(e),o(te.$$.fragment,e),yt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),g(ae)!=="svelte-gzsa62"&&(ae.innerHTML=ua),$t=n(e),o(se.$$.fragment,e),bt=n(e),le=r(e,"P",{"data-svelte-h":!0}),g(le)!=="svelte-zihpvf"&&(le.textContent=da),wt=n(e),o(ne.$$.fragment,e),Mt=n(e),ie=r(e,"P",{"data-svelte-h":!0}),g(ie)!=="svelte-1pdoh7n"&&(ie.innerHTML=ya),_t=n(e),o(re.$$.fragment,e),vt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-1jcko64"&&(pe.innerHTML=$a),Tt=n(e),o(oe.$$.fragment,e),jt=n(e),o(ge.$$.fragment,e),Zt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),g(ce)!=="svelte-1nx84sp"&&(ce.innerHTML=ba),Jt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-16vpsz9"&&(fe.innerHTML=wa),Gt=n(e),o(he.$$.fragment,e),kt=n(e),me=r(e,"P",{"data-svelte-h":!0}),g(me)!=="svelte-17yd1o0"&&(me.textContent=Ma),Ct=n(e),o(ue.$$.fragment,e),Xt=n(e),de=r(e,"P",{"data-svelte-h":!0}),g(de)!=="svelte-zihpvf"&&(de.textContent=_a),xt=n(e),o(ye.$$.fragment,e),Ht=n(e),o($e.$$.fragment,e),Ut=n(e),be=r(e,"P",{"data-svelte-h":!0}),g(be)!=="svelte-6r9wzi"&&(be.innerHTML=va),Yt=n(e),we=r(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-iyml60"&&(we.innerHTML=Ta),Bt=n(e),o(Me.$$.fragment,e),Lt=n(e),_e=r(e,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-zihpvf"&&(_e.textContent=ja),It=n(e),o(ve.$$.fragment,e),Rt=n(e),o(Te.$$.fragment,e),Wt=n(e),je=r(e,"P",{"data-svelte-h":!0}),g(je)!=="svelte-1cnzwe6"&&(je.innerHTML=Za),qt=n(e),o(Ze.$$.fragment,e),zt=n(e),Je=r(e,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-zihpvf"&&(Je.textContent=Ja),St=n(e),o(Ge.$$.fragment,e),Vt=n(e),o(ke.$$.fragment,e),Nt=n(e),Xe=r(e,"P",{}),Ga(Xe).forEach(a),this.h()},h(){Pt(y,"name","hf:doc:metadata"),Pt(y,"content",Ra),Pt($,"class","warning"),Pt(b,"class","tip")},m(e,t){Ya(document.head,y),s(e,xe,t),s(e,Ce,t),s(e,He,t),c(w,e,t),s(e,Ue,t),c(M,e,t),s(e,Ye,t),s(e,_,t),s(e,Be,t),s(e,v,t),s(e,Le,t),s(e,$,t),s(e,Ie,t),s(e,T,t),s(e,Re,t),c(j,e,t),s(e,We,t),s(e,Z,t),s(e,qe,t),c(J,e,t),s(e,ze,t),s(e,G,t),s(e,Se,t),c(k,e,t),s(e,Ve,t),s(e,C,t),s(e,Ne,t),c(X,e,t),s(e,Fe,t),s(e,x,t),s(e,Pe,t),c(H,e,t),s(e,Qe,t),s(e,U,t),s(e,Ae,t),c(Y,e,t),s(e,Ee,t),s(e,B,t),s(e,Oe,t),c(L,e,t),s(e,De,t),s(e,I,t),s(e,Ke,t),c(R,e,t),s(e,et,t),s(e,W,t),s(e,tt,t),s(e,b,t),s(e,at,t),c(q,e,t),s(e,st,t),s(e,z,t),s(e,lt,t),s(e,S,t),s(e,nt,t),c(V,e,t),s(e,it,t),s(e,N,t),s(e,rt,t),c(F,e,t),s(e,pt,t),c(P,e,t),s(e,ot,t),s(e,Q,t),s(e,gt,t),c(A,e,t),s(e,ct,t),c(E,e,t),s(e,ft,t),s(e,O,t),s(e,ht,t),s(e,D,t),s(e,mt,t),c(K,e,t),s(e,ut,t),s(e,ee,t),s(e,dt,t),c(te,e,t),s(e,yt,t),s(e,ae,t),s(e,$t,t),c(se,e,t),s(e,bt,t),s(e,le,t),s(e,wt,t),c(ne,e,t),s(e,Mt,t),s(e,ie,t),s(e,_t,t),c(re,e,t),s(e,vt,t),s(e,pe,t),s(e,Tt,t),c(oe,e,t),s(e,jt,t),c(ge,e,t),s(e,Zt,t),s(e,ce,t),s(e,Jt,t),s(e,fe,t),s(e,Gt,t),c(he,e,t),s(e,kt,t),s(e,me,t),s(e,Ct,t),c(ue,e,t),s(e,Xt,t),s(e,de,t),s(e,xt,t),c(ye,e,t),s(e,Ht,t),c($e,e,t),s(e,Ut,t),s(e,be,t),s(e,Yt,t),s(e,we,t),s(e,Bt,t),c(Me,e,t),s(e,Lt,t),s(e,_e,t),s(e,It,t),c(ve,e,t),s(e,Rt,t),c(Te,e,t),s(e,Wt,t),s(e,je,t),s(e,qt,t),c(Ze,e,t),s(e,zt,t),s(e,Je,t),s(e,St,t),c(Ge,e,t),s(e,Vt,t),c(ke,e,t),s(e,Nt,t),s(e,Xe,t),Ft=!0},p:Ca,i(e){Ft||(f(w.$$.fragment,e),f(M.$$.fragment,e),f(j.$$.fragment,e),f(J.$$.fragment,e),f(k.$$.fragment,e),f(X.$$.fragment,e),f(H.$$.fragment,e),f(Y.$$.fragment,e),f(L.$$.fragment,e),f(R.$$.fragment,e),f(q.$$.fragment,e),f(V.$$.fragment,e),f(F.$$.fragment,e),f(P.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(re.$$.fragment,e),f(oe.$$.fragment,e),f(ge.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f($e.$$.fragment,e),f(Me.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(Ze.$$.fragment,e),f(Ge.$$.fragment,e),f(ke.$$.fragment,e),Ft=!0)},o(e){h(w.$$.fragment,e),h(M.$$.fragment,e),h(j.$$.fragment,e),h(J.$$.fragment,e),h(k.$$.fragment,e),h(X.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(L.$$.fragment,e),h(R.$$.fragment,e),h(q.$$.fragment,e),h(V.$$.fragment,e),h(F.$$.fragment,e),h(P.$$.fragment,e),h(A.$$.fragment,e),h(E.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(ye.$$.fragment,e),h($e.$$.fragment,e),h(Me.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(Ze.$$.fragment,e),h(Ge.$$.fragment,e),h(ke.$$.fragment,e),Ft=!1},d(e){e&&(a(xe),a(Ce),a(He),a(Ue),a(Ye),a(_),a(Be),a(v),a(Le),a($),a(Ie),a(T),a(Re),a(We),a(Z),a(qe),a(ze),a(G),a(Se),a(Ve),a(C),a(Ne),a(Fe),a(x),a(Pe),a(Qe),a(U),a(Ae),a(Ee),a(B),a(Oe),a(De),a(I),a(Ke),a(et),a(W),a(tt),a(b),a(at),a(st),a(z),a(lt),a(S),a(nt),a(it),a(N),a(rt),a(pt),a(ot),a(Q),a(gt),a(ct),a(ft),a(O),a(ht),a(D),a(mt),a(ut),a(ee),a(dt),a(yt),a(ae),a($t),a(bt),a(le),a(wt),a(Mt),a(ie),a(_t),a(vt),a(pe),a(Tt),a(jt),a(Zt),a(ce),a(Jt),a(fe),a(Gt),a(kt),a(me),a(Ct),a(Xt),a(de),a(xt),a(Ht),a(Ut),a(be),a(Yt),a(we),a(Bt),a(Lt),a(_e),a(It),a(Rt),a(Wt),a(je),a(qt),a(zt),a(Je),a(St),a(Vt),a(Nt),a(Xe)),a(y),m(w,e),m(M,e),m(j,e),m(J,e),m(k,e),m(X,e),m(H,e),m(Y,e),m(L,e),m(R,e),m(q,e),m(V,e),m(F,e),m(P,e),m(A,e),m(E,e),m(K,e),m(te,e),m(se,e),m(ne,e),m(re,e),m(oe,e),m(ge,e),m(he,e),m(ue,e),m(ye,e),m($e,e),m(Me,e),m(ve,e),m(Te,e),m(Ze,e),m(Ge,e),m(ke,e)}}}const Ra='{"title":"Create and manage a repository","local":"create-and-manage-a-repository","sections":[{"title":"Repo creation and deletion","local":"repo-creation-and-deletion","sections":[{"title":"Create a repository","local":"create-a-repository","sections":[],"depth":3},{"title":"Delete a repository","local":"delete-a-repository","sections":[],"depth":3},{"title":"Duplicate a repository (only for Spaces)","local":"duplicate-a-repository-only-for-spaces","sections":[],"depth":3}],"depth":2},{"title":"Upload and download files","local":"upload-and-download-files","sections":[],"depth":2},{"title":"Branches and tags","local":"branches-and-tags","sections":[{"title":"Create branches and tags","local":"create-branches-and-tags","sections":[],"depth":3},{"title":"List all branches and tags","local":"list-all-branches-and-tags","sections":[],"depth":3}],"depth":2},{"title":"Change repository settings","local":"change-repository-settings","sections":[{"title":"Update visibility","local":"update-visibility","sections":[],"depth":3},{"title":"Setup gated access","local":"setup-gated-access","sections":[],"depth":3},{"title":"Rename your repository","local":"rename-your-repository","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wa(Qt){return Xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends xa{constructor(y){super(),Ha(this,y,Wa,Ia,ka,{})}}export{Fa as component};
