import{s as ps,n as rs,o as cs}from"../chunks/scheduler.0cf4ef2e.js";import{S as hs,i as us,e as i,s,c as r,h as ds,a as o,d as a,b as n,f as os,g as c,j as p,k as j,l as fs,m as l,n as h,t as u,o as d,p as f}from"../chunks/index.abc433bf.js";import{C as ms}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as m}from"../chunks/CodeBlock.18a16f91.js";import{H as g,E as gs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function ys(Oa){let y,pt,it,rt,U,ct,k,ht,C,Ka="Sharing your files and work is an important aspect of the Hub. The <code>huggingface_hub</code> offers several options for uploading your files to the Hub. You can use these functions independently or integrate them into your library, making it more convenient for your users to interact with the Hub.",ut,v,el='Whenever you want to upload files to the Hub, you need to log in to your Hugging Face account. For more details about authentication, check out <a href="../quick-start#authentication">this section</a>.',dt,I,ft,Z,tl='Once you’ve created a repository with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>, you can upload a file to your repository using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>.',mt,G,al="Specify the path of the file to upload, where you want to upload the file to in the repository, and the name of the repository you want to add the file to. Depending on your repository type, you can optionally set the repository type as a <code>dataset</code>, <code>model</code>, or <code>space</code>.",gt,H,yt,B,Mt,$,ll=`Use the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> function to upload a local folder to an existing repository. Specify the path of the local folder
to upload, where you want to upload the folder to in the repository, and the name of the repository you want to add the
folder to. Depending on your repository type, you can optionally set the repository type as a <code>dataset</code>, <code>model</code>, or <code>space</code>.`,wt,A,Tt,x,sl="By default, the <code>.gitignore</code> file will be taken into account to know which files should be committed or not. By default we check if a <code>.gitignore</code> file is present in a commit, and if not, we check if it exists on the Hub. Please be aware that only a <code>.gitignore</code> file present at the root of the directory will be used. We do not check for <code>.gitignore</code> files in subdirectories.",bt,X,nl='If you don’t want to use an hardcoded <code>.gitignore</code> file, you can use the <code>allow_patterns</code> and <code>ignore_patterns</code> arguments to filter which files to upload. These parameters accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. If both <code>allow_patterns</code> and <code>ignore_patterns</code> are provided, both constraints apply.',Jt,S,il="Beside the <code>.gitignore</code> file and allow/ignore patterns, any <code>.git/</code> folder present in any subdirectory will be ignored.",_t,L,jt,R,ol=`You can also use the <code>delete_patterns</code> argument to specify files you want to delete from the repo in the same commit.
This can prove useful if you want to clean a remote folder before pushing files in it and you don’t know which files
already exists.`,Ut,W,pl=`The example below uploads the local <code>./logs</code> folder to the remote <code>/experiment/logs/</code> folder. Only txt files are uploaded
but before that, all previous logs on the repo on deleted. All of this in a single commit.`,kt,Y,Ct,E,vt,F,rl='You can use the <code>hf upload</code> command from the terminal to directly upload files to the Hub. Internally it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> helpers described above.',It,Q,cl="You can either upload a single file or an entire folder:",Zt,V,Gt,q,hl=`<code>local_path</code> and <code>path_in_repo</code> are optional and can be implicitly inferred. If <code>local_path</code> is not set, the tool will
check if a local folder or file has the same name as the <code>repo_id</code>. If that’s the case, its content will be uploaded.
Otherwise, an exception is raised asking the user to explicitly set <code>local_path</code>. In any case, if <code>path_in_repo</code> is not
set, files are uploaded at the root of the repo.`,Ht,N,ul='For more details about the CLI upload command, please refer to the <a href="./cli#hf-upload">CLI guide</a>.',Bt,z,$t,P,dl='In most cases, the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> method and <code>hf upload</code> command should be the go-to solutions to upload files to the Hub. They ensure a single commit will be made, handle a lot of use cases, and fail explicitly when something wrong happens. However, when dealing with a large amount of data, you will usually prefer a resilient process even if it leads to more commits or requires more CPU usage. The <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> method has been implemented in that spirit:',At,D,fl="<li>it is resumable: the upload process is split into many small tasks (hashing files, pre-uploading them, and committing them). Each time a task is completed, the result is cached locally in a <code>./cache/huggingface</code> folder inside the folder you are trying to upload. By doing so, restarting the process after an interruption will resume all completed tasks.</li> <li>it is multi-threaded: hashing large files and pre-uploading them benefits a lot from multithreading if your machine allows it.</li> <li>it is resilient to errors: a high-level retry-mechanism has been added to retry each independent task indefinitely until it passes (no matter if it’s a OSError, ConnectionError, PermissionError, etc.). This mechanism is double-edged. If transient errors happen, the process will continue and retry. If permanent errors happen (e.g. permission denied), it will retry indefinitely without solving the root cause.</li>",xt,O,ml='If you want more technical details about how <code>upload_large_folder</code> is implemented under the hood, please have a look to the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> package reference.',Xt,K,gl='Here is how to use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> in a script. The method signature is very similar to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>:',St,ee,Lt,te,yl="You will see the following output in your terminal:",Rt,ae,Wt,le,Ml="First, the repo is created if it didn’t exist before. Then, the local folder is scanned for files to upload. For each file, we try to recover metadata information (from a previously interrupted upload). From there, it is able to launch workers and print an update status every 1 minute. Here, we can see that 5 files have already been hashed but not pre-uploaded. 5 workers are pre-uploading files while the 11 others are waiting for a task.",Yt,se,wl="A command line is also provided. You can define the number of workers and the level of verbosity in the terminal:",Et,ne,Ft,M,Tl="<p>For large uploads, you have to set <code>repo_type=&quot;model&quot;</code> or <code>--repo-type=model</code> explicitly. Usually, this information is implicit in all other <code>HfApi</code> methods. This is to avoid having data uploaded to a repository with a wrong type. If that’s the case, you’ll have to re-upload everything.</p>",Qt,w,bl='<p>While being much more robust to upload large folders, <code>upload_large_folder</code> is more limited than <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> feature-wise. In practice:</p> <ul><li>you cannot set a custom <code>path_in_repo</code>. If you want to upload to a subfolder, you need to set the proper structure locally.</li> <li>you cannot set a custom <code>commit_message</code> and <code>commit_description</code> since multiple commits are created.</li> <li>you cannot delete from the repo while uploading. Please make a separate commit first.</li> <li>you cannot create a PR directly. Please create a PR first (from the UI or using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_pull_request">create_pull_request()</a>) and then commit to it by passing <code>revision</code>.</li></ul>',Vt,ie,qt,oe,Jl="There are some limitations to be aware of when dealing with a large amount of data in your repo. Given the time it takes to stream the data, getting an upload/push to fail at the end of the process or encountering a degraded experience, be it on hf.co or when working locally, can be very annoying.",Nt,pe,_l='Check out our <a href="https://huggingface.co/docs/hub/repositories-recommendations" rel="nofollow">Repository limitations and recommendations</a> guide for best practices on how to structure your repositories on the Hub. Let’s move on with some practical tips to make your upload process as smooth as possible.',zt,re,jl='<li><strong>Start small</strong>: We recommend starting with a small amount of data to test your upload script. It’s easier to iterate on a script when failing takes only a little time.</li> <li><strong>Expect failures</strong>: Streaming large amounts of data is challenging. You don’t know what can happen, but it’s always best to consider that something will fail at least once -no matter if it’s due to your machine, your connection, or our servers. For example, if you plan to upload a large number of files, it’s best to keep track locally of which files you already uploaded before uploading the next batch. You are ensured that an LFS file that is already committed will never be re-uploaded twice but checking it client-side can still save some time. This is what <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a> does for you.</li> <li><strong>Use <code>hf_xet</code></strong>: this leverages the new storage backend for the Hub, is written in Rust, and is now available for everyone to use. In fact, <code>hf_xet</code> is already enabled by default when using <code>huggingface_hub</code>! For maximum performance, set <a href="../package_reference/environment_variables.md#hf_xet_high_performance"><code>HF_XET_HIGH_PERFORMANCE=1</code></a> as an environment variable. Be aware that when high performance mode is enabled, the tool will try to use all available bandwidth and CPU cores.</li>',Pt,ce,Dt,he,Ul=`In most cases, you won’t need more than <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> to upload your files to the Hub.
However, <code>huggingface_hub</code> has more advanced features to make things easier. Let’s have a look at them!`,Ot,ue,Kt,de,kl='Take advantage of faster uploads through <code>hf_xet</code>, the Python binding to the <a href="https://github.com/huggingface/xet-core" rel="nofollow"><code>xet-core</code></a> library that enables chunk-based deduplication for faster uploads and downloads. <code>hf_xet</code> integrates seamlessly with <code>huggingface_hub</code>, but uses the Rust <code>xet-core</code> library and Xet storage instead of LFS.',ea,fe,Cl="<code>hf_xet</code> uses the Xet storage system, which breaks files down into immutable chunks, storing collections of these chunks (called blocks or xorbs) remotely and retrieving them to reassemble the file when requested. When uploading, after confirming the user is authorized to write to this repo, <code>hf_xet</code> will scan the files, breaking them down into their chunks and collecting those chunks into xorbs (and deduplicating across known chunks), and then will be upload these xorbs to the Xet content-addressable service (CAS), which will verify the integrity of the xorbs, register the xorb metadata along with the LFS SHA256 hash (to support lookup/download), and write the xorbs to remote storage.",ta,me,vl="To enable it, simply install the latest version of <code>huggingface_hub</code>:",aa,ge,la,ye,Il="As of <code>huggingface_hub</code> 0.32.0, this will also install <code>hf_xet</code>.",sa,Me,Zl='All other <code>huggingface_hub</code> APIs will continue to work without any modification. To learn more about the benefits of Xet storage and <code>hf_xet</code>, refer to this <a href="https://huggingface.co/docs/hub/xet/index" rel="nofollow">section</a>.',na,we,Gl="<strong>Cluster / Distributed Filesystem Upload Considerations</strong>",ia,Te,Hl='When uploading from a cluster, the files being uploaded often reside on a distributed or networked filesystem (NFS, EBS, Lustre, Fsx, etc). Xet storage will chunk those files and write them into blocks (also called xorbs) locally, and once the block is completed will upload them. For better performance when uploading from a distributed filesystem, make sure to set <a href="../package_reference/environment_variables#hfxetcache"><code>HF_XET_CACHE</code></a> to a directory that is on a local disk (ex. a local NVMe or SSD disk). The default location for the Xet cache is under <code>HF_HOME</code> at (<code>~/.cache/huggingface/xet</code>) and this being in the user’s home directory is often also located on the distributed filesystem.',oa,be,pa,Je,Bl=`In some cases, you want to push data without blocking your main thread. This is particularly useful to upload logs and
artifacts while continuing a training. To do so, you can use the <code>run_as_future</code> argument in both <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>. This will return a <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow"><code>concurrent.futures.Future</code></a>
object that you can use to check the status of the upload.`,ra,_e,ca,T,$l=`<p>Background jobs are queued when using <code>run_as_future=True</code>. This means that you are guaranteed that the jobs will be
executed in the correct order.</p>`,ha,je,Al=`Even though background jobs are mostly useful to upload data/create commits, you can queue any method you like using
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_as_future">run_as_future()</a>. For instance, you can use it to create a repo and then upload data to it in the background. The
built-in <code>run_as_future</code> argument in upload methods is just an alias around it.`,ua,Ue,da,ke,fa,Ce,xl=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> makes it easy to upload an entire folder to the Hub. However, for large folders (thousands of files or
hundreds of GB), we recommend using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_large_folder">upload_large_folder()</a>, which splits the upload into multiple commits. See the <a href="#upload-a-large-folder">Upload a large folder</a> section for more details.`,ma,ve,ga,Ie,Xl=`The Hugging Face Hub makes it easy to save and version data. However, there are some limitations when updating the same file thousands of times. For instance, you might want to save logs of a training process or user
feedback on a deployed Space. In these cases, uploading the data as a dataset on the Hub makes sense, but it can be hard to do properly. The main reason is that you don’t want to version every update of your data because it’ll make the git repository unusable. The <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> class offers a solution to this problem.`,ya,Ze,Sl=`The idea is to run a background job that regularly pushes a local folder to the Hub. Let’s assume you have a
Gradio Space that takes as input some text and generates two translations of it. Then, the user can select their preferred translation. For each run, you want to save the input, output, and user preference to analyze the results. This is a
perfect use case for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>; you want to save data to the Hub (potentially millions of user feedback), but
you don’t <em>need</em> to save in real-time each user’s input. Instead, you can save the data locally in a JSON file and
upload it every 10 minutes. For example:`,Ma,Ge,wa,He,Ll=`And that’s it! User input/outputs and feedback will be available as a dataset on the Hub. By using a unique JSON file name, you are guaranteed you won’t overwrite data from a previous run or data from another
Spaces/replicas pushing concurrently to the same repository.`,Ta,Be,Rl='For more details about the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>, here is what you need to know:',ba,$e,Wl=`<li><strong>append-only:</strong>
It is assumed that you will only add content to the folder. You must only append data to existing files or create
new files. Deleting or overwriting a file might corrupt your repository.</li> <li><strong>git history</strong>:
The scheduler will commit the folder every <code>every</code> minutes. To avoid polluting the git repository too much, it is
recommended to set a minimal value of 5 minutes. Besides, the scheduler is designed to avoid empty commits. If no
new content is detected in the folder, the scheduled commit is dropped.</li> <li><strong>errors:</strong>
The scheduler run as background thread. It is started when you instantiate the class and never stops. In particular,
if an error occurs during the upload (example: connection issue), the scheduler will silently ignore it and retry
at the next scheduled commit.</li> <li><strong>thread-safety:</strong>
In most cases it is safe to assume that you can write to a file without having to worry about a lock file. The
scheduler will not crash or be corrupted if you write content to the folder while it’s uploading. In practice,
<em>it is possible</em> that concurrency issues happen for heavy-loaded apps. In this case, we advice to use the
<code>scheduler.lock</code> lock to ensure thread-safety. The lock is blocked only when the scheduler scans the folder for
changes, not when it uploads data. You can safely assume that it will not affect the user experience on your Space.</li>`,Ja,Ae,_a,xe,Yl=`Persisting data from a Space to a Dataset on the Hub is the main use case for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>. Depending on the use
case, you might want to structure your data differently. The structure has to be robust to concurrent users and
restarts which often implies generating UUIDs. Besides robustness, you should upload data in a format readable by the 🤗 Datasets library for later reuse. We created a <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">Space</a>
that demonstrates how to save several different data formats (you may need to adapt it for your own specific needs).`,ja,Xe,Ua,Se,El=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> assumes your data is append-only and should be uploading “as is”. However, you
might want to customize the way data is uploaded. You can do that by creating a class inheriting from <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a>
and overwrite the <code>push_to_hub</code> method (feel free to overwrite it any way you want). You are guaranteed it will
be called every <code>every</code> minutes in a background thread. You don’t have to worry about concurrency and errors but you
must be careful about other aspects, such as pushing empty commits or duplicated data.`,ka,Le,Fl=`In the (simplified) example below, we overwrite <code>push_to_hub</code> to zip all PNG files in a single archive to avoid
overloading the repo on the Hub:`,Ca,Re,va,We,Ql='When you overwrite <code>push_to_hub</code>, you have access to the attributes of <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitScheduler">CommitScheduler</a> and especially:',Ia,Ye,Vl='<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> client: <code>api</code></li> <li>Folder parameters: <code>folder_path</code> and <code>path_in_repo</code></li> <li>Repo parameters: <code>repo_id</code>, <code>repo_type</code>, <code>revision</code></li> <li>The thread lock: <code>lock</code></li>',Za,b,ql=`<p>For more examples of custom schedulers, check out our <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">demo Space</a>
containing different implementations depending on your use cases.</p>`,Ga,Ee,Ha,Fe,Nl=`The <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> functions are high-level APIs that are generally convenient to use. We recommend
trying these functions first if you don’t need to work at a lower level. However, if you want to work at a commit-level,
you can use the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> function directly.`,Ba,Qe,zl='There are three types of operations supported by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:',$a,Ve,Pl='<li><p><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> uploads a file to the Hub. If the file already exists, the file contents are overwritten. This operation accepts two arguments:</p> <ul><li><code>path_in_repo</code>: the repository path to upload a file to.</li> <li><code>path_or_fileobj</code>: either a path to a file on your filesystem or a file-like object. This is the content of the file to upload to the Hub.</li></ul></li> <li><p><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationDelete">CommitOperationDelete</a> removes a file or a folder from a repository. This operation accepts <code>path_in_repo</code> as an argument.</p></li> <li><p><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationCopy">CommitOperationCopy</a> copies a file within a repository. This operation accepts three arguments:</p> <ul><li><code>src_path_in_repo</code>: the repository path of the file to copy.</li> <li><code>path_in_repo</code>: the repository path where the file should be copied.</li> <li><code>src_revision</code>: optional - the revision of the file to copy if your want to copy a file from a different branch/revision.</li></ul></li>',Aa,qe,Dl="For example, if you want to upload two files and delete a file in a Hub repository:",xa,Ne,Ol="<li>Use the appropriate <code>CommitOperation</code> to add or delete a file and to delete a folder:</li>",Xa,ze,Sa,J,Kl='<li>Pass your operations to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>:</li>',La,Pe,Ra,De,es='In addition to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a>, the following functions also use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> under the hood:',Wa,Oe,ts='<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_file">delete_file()</a> deletes a single file from a repository on the Hub.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_folder">delete_folder()</a> deletes an entire folder from a repository on the Hub.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cards#huggingface_hub.metadata_update">metadata_update()</a> updates a repository’s metadata.</li>',Ya,Ke,as='For more detailed information, take a look at the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> reference.',Ea,et,Fa,tt,ls=`In some cases, you might want to upload huge files to S3 <strong>before</strong> making the commit call. For example, if you are
committing a dataset in several shards that are generated in-memory, you would need to upload the shards one by one
to avoid an out-of-memory issue. A solution is to upload each shard as a separate commit on the repo. While being
perfectly valid, this solution has the drawback of potentially messing the git history by generating tens of commits.
To overcome this issue, you can upload your files one by one to S3 and then create a single commit at the end. This
is possible using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> in combination with <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>.`,Qa,_,ss=`<p>This is a power-user method. Directly using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> or <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a> instead of handling
the low-level logic of pre-uploading files is the way to go in the vast majority of cases. The main caveat of
<a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> is that until the commit is actually made, the upload files are not accessible on the repo on
the Hub. If you have a question, feel free to ping us on our Discord or in a GitHub issue.</p>`,Va,at,ns="Here is a simple example illustrating how to pre-upload files:",qa,lt,Na,st,is=`First, we create the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.CommitOperationAdd">CommitOperationAdd</a> objects one by one. In a real-world example, those would contain the
generated shards. Each file is uploaded before generating the next one. During the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.preupload_lfs_files">preupload_lfs_files()</a> step, <strong>the
<code>CommitOperationAdd</code> object is mutated</strong>. You should only use it to pass it directly to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. The main
update of the object is that <strong>the binary content is removed</strong> from it, meaning that it will be garbage-collected if
you don’t store another reference to it. This is expected as we don’t want to keep in memory the content that is
already uploaded. Finally we create the commit by passing all the operations to <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_commit">create_commit()</a>. You can pass
additional operations (add, delete or copy) that have not been processed yet and they will be handled correctly.`,za,nt,Pa,ot,Da;return U=new ms({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),k=new g({props:{title:"Upload files to the Hub",local:"upload-files-to-the-hub",headingTag:"h1"}}),I=new g({props:{title:"Upload a file",local:"upload-a-file",headingTag:"h2"}}),H=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnRlc3QtZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;/path/to/local/folder/README.md&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new g({props:{title:"Upload a folder",local:"upload-a-folder",headingTag:"h2"}}),A=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyJTJGcGF0aCUyRnRvJTJGbG9jYWwlMkZzcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LWNvb2wtc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Upload all the content from the local folder to your remote Space.</span>
<span class="hljs-comment"># By default, files are uploaded at the root of the repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/space&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-cool-space&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),L=new m({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMm15LWRhdGFzZXQlMkZ0cmFpbiUyMiUyQyUyMCUyMyUyMFVwbG9hZCUyMHRvJTIwYSUyMHNwZWNpZmljJTIwZm9sZGVyJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGdGVzdC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9wYXR0ZXJucyUzRCUyMioqJTJGbG9ncyUyRioudHh0JTIyJTJDJTIwJTIzJTIwSWdub3JlJTIwYWxsJTIwdGV4dCUyMGxvZ3MlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;my-dataset/train&quot;</span>, <span class="hljs-comment"># Upload to a specific folder</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>, <span class="hljs-comment"># Ignore all text logs</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Y=new m({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRmxvZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZ0cmFpbmVkLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZXhwZXJpbWVudCUyRmxvZ3MlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19wYXR0ZXJucyUzRCUyMioudHh0JTIyJTJDJTIwJTIzJTIwVXBsb2FkJTIwYWxsJTIwbG9jYWwlMjB0ZXh0JTIwZmlsZXMlMEElMjAlMjAlMjAlMjBkZWxldGVfcGF0dGVybnMlM0QlMjIqLnR4dCUyMiUyQyUyMCUyMyUyMERlbGV0ZSUyMGFsbCUyMHJlbW90ZSUyMHRleHQlMjBmaWxlcyUyMGJlZm9yZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder/logs&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/trained-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;experiment/logs/&quot;</span>,
<span class="hljs-meta">... </span>    allow_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Upload all local text files</span>
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Delete all remote text files before</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),E=new g({props:{title:"Upload from the CLI",local:"upload-from-the-cli",headingTag:"h2"}}),V=new m({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMkZtb2RlbC5zYWZldGVuc29ycyUyMG1vZGVsLnNhZmV0ZW5zb3JzJTBBJTBBaGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMjAu",highlighted:`<span class="hljs-comment"># Usage:  hf upload [repo_id] [local_path] [path_in_repo]</span>
&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models/model.safetensors model.safetensors
https://huggingface.co/Wauplin/my-cool-model/blob/main/model.safetensors

&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models .
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),z=new g({props:{title:"Upload a large folder",local:"upload-a-large-folder",headingTag:"h2"}}),ee=new m({props:{code:"YXBpLnVwbG9hZF9sYXJnZV9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMkh1Z2dpbmdGYWNlTTQlMkZEb2NtYXRpeCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMiUyRnBhdGglMkZ0byUyRmxvY2FsJTJGZG9jbWF0aXglMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_large_folder(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;HuggingFaceM4/Docmatix&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/docmatix&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ae=new m({props:{code:"UmVwbyUyMGNyZWF0ZWQlM0ElMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZIdWdnaW5nRmFjZU00JTJGRG9jbWF0aXglMEFGb3VuZCUyMDUlMjBjYW5kaWRhdGUlMjBmaWxlcyUyMHRvJTIwdXBsb2FkJTBBUmVjb3ZlcmluZyUyMGZyb20lMjBtZXRhZGF0YSUyMGZpbGVzJTNBJTIwMTAwJTI1JTdDJUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JUUyJTk2JTg4JTdDJTIwNSUyRjUlMjAlNUIwMCUzQTAwJTNDMDAlM0EwMCUyQyUyMDU0Mi42Nml0JTJGcyU1RCUwQSUwQS0tLS0tLS0tLS0lMjAyMDI0LTA3LTIyJTIwMTclM0EyMyUzQTE3JTIwKDAlM0EwMCUzQTAwKSUyMC0tLS0tLS0tLS0lMEFGaWxlcyUzQSUyMCUyMCUyMGhhc2hlZCUyMDUlMkY1JTIwKDUuMEclMkY1LjBHKSUyMCU3QyUyMHByZS11cGxvYWRlZCUzQSUyMDAlMkY1JTIwKDAuMCUyRjUuMEcpJTIwJTdDJTIwY29tbWl0dGVkJTNBJTIwMCUyRjUlMjAoMC4wJTJGNS4wRyklMjAlN0MlMjBpZ25vcmVkJTNBJTIwMCUwQVdvcmtlcnMlM0ElMjBoYXNoaW5nJTNBJTIwMCUyMCU3QyUyMGdldCUyMHVwbG9hZCUyMG1vZGUlM0ElMjAwJTIwJTdDJTIwcHJlLXVwbG9hZGluZyUzQSUyMDUlMjAlN0MlMjBjb21taXR0aW5nJTNBJTIwMCUyMCU3QyUyMHdhaXRpbmclM0ElMjAxMSUwQS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLQ==",highlighted:`<span class="hljs-attr">Repo created:</span> <span class="hljs-string">https://huggingface.co/datasets/HuggingFaceM4/Docmatix</span>
<span class="hljs-string">Found</span> <span class="hljs-number">5</span> <span class="hljs-string">candidate</span> <span class="hljs-string">files</span> <span class="hljs-string">to</span> <span class="hljs-string">upload</span>
<span class="hljs-attr">Recovering from metadata files:</span> <span class="hljs-number">100</span><span class="hljs-string">%|█████████████████████████████████████|</span> <span class="hljs-number">5</span><span class="hljs-string">/5</span> [<span class="hljs-number">00</span><span class="hljs-string">:00&lt;00:00</span>, <span class="hljs-number">542.</span><span class="hljs-string">66it/s</span>]

<span class="hljs-string">----------</span> <span class="hljs-number">2024-07-22 17:23:17</span> <span class="hljs-string">(0:00:00)</span> <span class="hljs-string">----------</span>
<span class="hljs-attr">Files:</span>   <span class="hljs-string">hashed</span> <span class="hljs-number">5</span><span class="hljs-string">/5</span> <span class="hljs-string">(5.0G/5.0G)</span> <span class="hljs-string">|</span> <span class="hljs-attr">pre-uploaded:</span> <span class="hljs-number">0</span><span class="hljs-string">/5</span> <span class="hljs-string">(0.0/5.0G)</span> <span class="hljs-string">|</span> <span class="hljs-attr">committed:</span> <span class="hljs-number">0</span><span class="hljs-string">/5</span> <span class="hljs-string">(0.0/5.0G)</span> <span class="hljs-string">|</span> <span class="hljs-attr">ignored:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">Workers: hashing:</span> <span class="hljs-number">0</span> <span class="hljs-string">|</span> <span class="hljs-attr">get upload mode:</span> <span class="hljs-number">0</span> <span class="hljs-string">|</span> <span class="hljs-attr">pre-uploading:</span> <span class="hljs-number">5</span> <span class="hljs-string">|</span> <span class="hljs-attr">committing:</span> <span class="hljs-number">0</span> <span class="hljs-string">|</span> <span class="hljs-attr">waiting:</span> <span class="hljs-number">11</span>
<span class="hljs-string">---------------------------------------------------</span>`,wrap:!1}}),ne=new m({props:{code:"aGYlMjB1cGxvYWQtbGFyZ2UtZm9sZGVyJTIwSHVnZ2luZ0ZhY2VNNCUyRkRvY21hdGl4JTIwLS1yZXBvLXR5cGUlM0RkYXRhc2V0JTIwJTJGcGF0aCUyRnRvJTJGbG9jYWwlMkZkb2NtYXRpeCUyMC0tbnVtLXdvcmtlcnMlM0QxNg==",highlighted:"hf upload-large-folder HuggingFaceM4/Docmatix --repo-type=dataset /path/to/local/docmatix --num-workers=16",wrap:!1}}),ie=new g({props:{title:"Tips and tricks for large uploads",local:"tips-and-tricks-for-large-uploads",headingTag:"h3"}}),ce=new g({props:{title:"Advanced features",local:"advanced-features",headingTag:"h2"}}),ue=new g({props:{title:"Faster Uploads",local:"faster-uploads",headingTag:"h3"}}),ge=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwJTIyaHVnZ2luZ2ZhY2VfaHViJTIy",highlighted:'pip install -U <span class="hljs-string">&quot;huggingface_hub&quot;</span>',wrap:!1}}),be=new g({props:{title:"Non-blocking uploads",local:"non-blocking-uploads",headingTag:"h3"}}),_e=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS51cGxvYWRfZm9sZGVyKCUyMCUyMyUyMFVwbG9hZCUyMGluJTIwdGhlJTIwYmFja2dyb3VuZCUyMChub24tYmxvY2tpbmclMjBhY3Rpb24pJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmNoZWNrcG9pbnRzLTAwMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJ1bl9hc19mdXR1cmUlM0RUcnVlJTJDJTBBKSUwQWZ1dHVyZSUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjBXYWl0JTIwZm9yJTIwdGhlJTIwdXBsb2FkJTIwdG8lMjBjb21wbGV0ZSUyMChibG9ja2luZyUyMGFjdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.upload_folder( <span class="hljs-comment"># Upload in the background (non-blocking action)</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;checkpoints-001&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>future
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># Wait for the upload to complete (blocking action)</span>
...`,wrap:!1}}),Ue=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5ydW5fYXNfZnV0dXJlKGFwaS5jcmVhdGVfcmVwbyUyQyUyMCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMjBleGlzdHNfb2slM0RUcnVlKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMmZpbGUudHh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEYiUyMmZpbGUlMjBjb250ZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwcnVuX2FzX2Z1dHVyZSUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.run_as_future(api.create_repo, <span class="hljs-string">&quot;username/my-model&quot;</span>, exists_ok=<span class="hljs-literal">True</span>)
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>,
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">b&quot;file content&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
Future(...)`,wrap:!1}}),ke=new g({props:{title:"Upload a folder by chunks",local:"upload-a-folder-by-chunks",headingTag:"h3"}}),ve=new g({props:{title:"Scheduled uploads",local:"scheduled-uploads",headingTag:"h3"}}),Ge=new m({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHV1aWQlMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWZlZWRiYWNrX2ZpbGUlMjAlM0QlMjBQYXRoKCUyMnVzZXJfZmVlZGJhY2slMkYlMjIpJTIwJTJGJTIwZiUyMmRhdGFfJTdCdXVpZC51dWlkNCgpJTdELmpzb24lMjIlMEFmZWVkYmFja19mb2xkZXIlMjAlM0QlMjBmZWVkYmFja19maWxlLnBhcmVudCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMENvbW1pdFNjaGVkdWxlciglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIycmVwb3J0LXRyYW5zbGF0aW9uLWZlZWRiYWNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZmVlZGJhY2tfZm9sZGVyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZGF0YSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2ZXJ5JTNEMTAlMkMlMEEpJTBBJTBBZGVmJTIwc2F2ZV9mZWVkYmFjayhpbnB1dF90ZXh0JTNBc3RyJTJDJTIwb3V0cHV0XzElM0ElMjBzdHIlMkMlMjBvdXRwdXRfMiUzQXN0ciUyQyUyMHVzZXJfY2hvaWNlJTNBJTIwaW50KSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQXBwZW5kJTIwaW5wdXQlMkZvdXRwdXRzJTIwYW5kJTIwdXNlciUyMGZlZWRiYWNrJTIwdG8lMjBhJTIwSlNPTiUyMExpbmVzJTIwZmlsZSUyMHVzaW5nJTIwYSUyMHRocmVhZCUyMGxvY2slMjB0byUyMGF2b2lkJTIwY29uY3VycmVudCUyMHdyaXRlcyUyMGZyb20lMjBkaWZmZXJlbnQlMjB1c2Vycy4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwc2NoZWR1bGVyLmxvY2slM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwZmVlZGJhY2tfZmlsZS5vcGVuKCUyMmElMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmlucHV0JTIyJTNBJTIwaW5wdXRfdGV4dCUyQyUyMCUyMm91dHB1dF8xJTIyJTNBJTIwb3V0cHV0XzElMkMlMjAlMjJvdXRwdXRfMiUyMiUzQSUyMG91dHB1dF8yJTJDJTIwJTIydXNlcl9jaG9pY2UlMjIlM0ElMjB1c2VyX2Nob2ljZSU3RCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZSglMjIlNUNuJTIyKSUwQSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwZGVtbyUzQSUwQSUyMCUyMCUyMCUyMC4uLiUyMCUyMyUyMGRlZmluZSUyMEdyYWRpbyUyMGRlbW8lMjAlMkIlMjB1c2UlMjAlNjBzYXZlX2ZlZWRiYWNrJTYwJTBBZGVtby5sYXVuY2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> uuid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Define the file where to save the data. Use UUID to make sure not to overwrite existing data from a previous run.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_file = Path(<span class="hljs-string">&quot;user_feedback/&quot;</span>) / <span class="hljs-string">f&quot;data_<span class="hljs-subst">{uuid.uuid4()}</span>.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_folder = feedback_file.parent

<span class="hljs-comment"># Schedule regular uploads. Remote repo and local folder are created if they don&#x27;t already exist.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = CommitScheduler(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;report-translation-feedback&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=feedback_folder,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;data&quot;</span>,
<span class="hljs-meta">... </span>    every=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Define the function that will be called when the user submits its feedback (to be called in Gradio)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_feedback</span>(<span class="hljs-params">input_text:<span class="hljs-built_in">str</span>, output_1: <span class="hljs-built_in">str</span>, output_2:<span class="hljs-built_in">str</span>, user_choice: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Append input/outputs and user feedback to a JSON Lines file using a thread lock to avoid concurrent writes from different users.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> scheduler.lock:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> feedback_file.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>            f.write(json.dumps({<span class="hljs-string">&quot;input&quot;</span>: input_text, <span class="hljs-string">&quot;output_1&quot;</span>: output_1, <span class="hljs-string">&quot;output_2&quot;</span>: output_2, <span class="hljs-string">&quot;user_choice&quot;</span>: user_choice}))
<span class="hljs-meta">... </span>            f.write(<span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># Start Gradio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
<span class="hljs-meta">&gt;&gt;&gt; </span>    ... <span class="hljs-comment"># define Gradio demo + use \`save_feedback\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>demo.launch()`,wrap:!1}}),Ae=new g({props:{title:"Space persistence demo",local:"space-persistence-demo",headingTag:"h4"}}),Xe=new g({props:{title:"Custom uploads",local:"custom-uploads",headingTag:"h4"}}),Re=new m({props:{code:"Y2xhc3MlMjBaaXBTY2hlZHVsZXIoQ29tbWl0U2NoZWR1bGVyKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHB1c2hfdG9faHViKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwMS4lMjBMaXN0JTIwUE5HJTIwZmlsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbmdfZmlsZXMlMjAlM0QlMjBsaXN0KHNlbGYuZm9sZGVyX3BhdGguZ2xvYiglMjIqLnBuZyUyMikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG5nX2ZpbGVzKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTIwJTIwJTIzJTIwcmV0dXJuJTIwZWFybHklMjBpZiUyMG5vdGhpbmclMjB0byUyMGNvbW1pdCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDIuJTIwWmlwJTIwcG5nJTIwZmlsZXMlMjBpbiUyMGElMjBzaW5nbGUlMjBhcmNoaXZlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRlbXBmaWxlLlRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlX3BhdGglMjAlM0QlMjBQYXRoKHRtcGRpciklMjAlMkYlMjAlMjJ0cmFpbi56aXAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwemlwZmlsZS5aaXBGaWxlKGFyY2hpdmVfcGF0aCUyQyUyMCUyMnclMjIlMkMlMjB6aXBmaWxlLlpJUF9ERUZMQVRFRCklMjBhcyUyMHppcCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBuZ19maWxlJTIwaW4lMjBwbmdfZmlsZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB6aXAud3JpdGUoZmlsZW5hbWUlM0RwbmdfZmlsZSUyQyUyMGFyY25hbWUlM0RwbmdfZmlsZS5uYW1lKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDMuJTIwVXBsb2FkJTIwYXJjaGl2ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYXBpLnVwbG9hZF9maWxlKC4uLiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGFyY2hpdmVfcGF0aCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA0LiUyMERlbGV0ZSUyMGxvY2FsJTIwcG5nJTIwZmlsZXMlMjB0byUyMGF2b2lkJTIwcmUtdXBsb2FkaW5nJTIwdGhlbSUyMGxhdGVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwcG5nX2ZpbGUlMjBpbiUyMHBuZ19maWxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBuZ19maWxlLnVubGluaygp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ZipScheduler</span>(<span class="hljs-title class_ inherited__">CommitScheduler</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># 1. List PNG files</span>
          png_files = <span class="hljs-built_in">list</span>(self.folder_path.glob(<span class="hljs-string">&quot;*.png&quot;</span>))
          <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(png_files) == <span class="hljs-number">0</span>:
              <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>  <span class="hljs-comment"># return early if nothing to commit</span>

        <span class="hljs-comment"># 2. Zip png files in a single archive</span>
        <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
            archive_path = Path(tmpdir) / <span class="hljs-string">&quot;train.zip&quot;</span>
            <span class="hljs-keyword">with</span> zipfile.ZipFile(archive_path, <span class="hljs-string">&quot;w&quot;</span>, zipfile.ZIP_DEFLATED) <span class="hljs-keyword">as</span> <span class="hljs-built_in">zip</span>:
                <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
                    <span class="hljs-built_in">zip</span>.write(filename=png_file, arcname=png_file.name)

            <span class="hljs-comment"># 3. Upload archive</span>
            self.api.upload_file(..., path_or_fileobj=archive_path)

        <span class="hljs-comment"># 4. Delete local png files to avoid re-uploading them later</span>
        <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
            png_file.unlink()`,wrap:!1}}),Ee=new g({props:{title:"create_commit",local:"createcommit",headingTag:"h3"}}),ze=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwQ29tbWl0T3BlcmF0aW9uQWRkJTJDJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQW9wZXJhdGlvbnMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyTElDRU5TRS5tZCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGTElDRU5TRS5tZCUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyd2VpZ2h0cy5oNSUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGd2VpZ2h0cy1maW5hbC5oNSUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25EZWxldGUocGF0aF9pbl9yZXBvJTNEJTIyb2xkLXdlaWdodHMuaDUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlKHBhdGhfaW5fcmVwbyUzRCUyMmxvZ3MlMkYlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uQ29weShzcmNfcGF0aF9pbl9yZXBvJTNEJTIyaW1hZ2UucG5nJTIyJTJDJTIwcGF0aF9pbl9yZXBvJTNEJTIyZHVwbGljYXRlX2ltYWdlLnBuZyUyMiklMkMlMEElNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, CommitOperationAdd, CommitOperationDelete
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;LICENSE.md&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/LICENSE.md&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;weights.h5&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/weights-final.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;old-weights.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;logs/&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationCopy(src_path_in_repo=<span class="hljs-string">&quot;image.png&quot;</span>, path_in_repo=<span class="hljs-string">&quot;duplicate_image.png&quot;</span>),
<span class="hljs-meta">... </span>]`,wrap:!1}}),Pe=new m({props:{code:"YXBpLmNyZWF0ZV9jb21taXQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGdGVzdC1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJVcGxvYWQlMjBteSUyMG1vZGVsJTIwd2VpZ2h0cyUyMGFuZCUyMGxpY2Vuc2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_commit(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>,
<span class="hljs-meta">... </span>    operations=operations,
<span class="hljs-meta">... </span>    commit_message=<span class="hljs-string">&quot;Upload my model weights and license&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),et=new g({props:{title:"Preupload LFS files before commit",local:"preupload-lfs-files-before-commit",headingTag:"h3"}}),lt=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdE9wZXJhdGlvbkFkZCUyQyUyMHByZXVwbG9hZF9sZnNfZmlsZXMlMkMlMjBjcmVhdGVfY29tbWl0JTJDJTIwY3JlYXRlX3JlcG8lMEElMEFyZXBvX2lkJTIwJTNEJTIwY3JlYXRlX3JlcG8oJTIydGVzdF9wcmV1cGxvYWQlMjIpLnJlcG9faWQlMEElMEFvcGVyYXRpb25zJTIwJTNEJTIwJTVCJTVEJTIwJTIzJTIwTGlzdCUyMG9mJTIwYWxsJTIwJTYwQ29tbWl0T3BlcmF0aW9uQWRkJTYwJTIwb2JqZWN0cyUyMHRoYXQlMjB3aWxsJTIwYmUlMjBnZW5lcmF0ZWQlMEFmb3IlMjBpJTIwaW4lMjByYW5nZSg1KSUzQSUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlMjAlM0QlMjAuLi4lMjAlMjMlMjBnZW5lcmF0ZSUyMGJpbmFyeSUyMGNvbnRlbnQlMEElMjAlMjAlMjAlMjBhZGRpdGlvbiUyMCUzRCUyMENvbW1pdE9wZXJhdGlvbkFkZChwYXRoX2luX3JlcG8lM0RmJTIyc2hhcmRfJTdCaSU3RF9vZl81LmJpbiUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRGNvbnRlbnQpJTBBJTIwJTIwJTIwJTIwcHJldXBsb2FkX2xmc19maWxlcyhyZXBvX2lkJTJDJTIwYWRkaXRpb25zJTNEJTVCYWRkaXRpb24lNUQpJTBBJTIwJTIwJTIwJTIwb3BlcmF0aW9ucy5hcHBlbmQoYWRkaXRpb24pJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY29tbWl0JTBBY3JlYXRlX2NvbW1pdChyZXBvX2lkJTJDJTIwb3BlcmF0aW9ucyUzRG9wZXJhdGlvbnMlMkMlMjBjb21taXRfbWVzc2FnZSUzRCUyMkNvbW1pdCUyMGFsbCUyMHNoYXJkcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd, preupload_lfs_files, create_commit, create_repo

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = create_repo(<span class="hljs-string">&quot;test_preupload&quot;</span>).repo_id

<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [] <span class="hljs-comment"># List of all \`CommitOperationAdd\` objects that will be generated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
<span class="hljs-meta">... </span>    content = ... <span class="hljs-comment"># generate binary content</span>
<span class="hljs-meta">... </span>    addition = CommitOperationAdd(path_in_repo=<span class="hljs-string">f&quot;shard_<span class="hljs-subst">{i}</span>_of_5.bin&quot;</span>, path_or_fileobj=content)
<span class="hljs-meta">... </span>    preupload_lfs_files(repo_id, additions=[addition])
<span class="hljs-meta">... </span>    operations.append(addition)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create commit</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_commit(repo_id, operations=operations, commit_message=<span class="hljs-string">&quot;Commit all shards&quot;</span>)`,wrap:!1}}),nt=new gs({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/upload.md"}}),{c(){y=i("meta"),pt=s(),it=i("p"),rt=s(),r(U.$$.fragment),ct=s(),r(k.$$.fragment),ht=s(),C=i("p"),C.innerHTML=Ka,ut=s(),v=i("p"),v.innerHTML=el,dt=s(),r(I.$$.fragment),ft=s(),Z=i("p"),Z.innerHTML=tl,mt=s(),G=i("p"),G.innerHTML=al,gt=s(),r(H.$$.fragment),yt=s(),r(B.$$.fragment),Mt=s(),$=i("p"),$.innerHTML=ll,wt=s(),r(A.$$.fragment),Tt=s(),x=i("p"),x.innerHTML=sl,bt=s(),X=i("p"),X.innerHTML=nl,Jt=s(),S=i("p"),S.innerHTML=il,_t=s(),r(L.$$.fragment),jt=s(),R=i("p"),R.innerHTML=ol,Ut=s(),W=i("p"),W.innerHTML=pl,kt=s(),r(Y.$$.fragment),Ct=s(),r(E.$$.fragment),vt=s(),F=i("p"),F.innerHTML=rl,It=s(),Q=i("p"),Q.textContent=cl,Zt=s(),r(V.$$.fragment),Gt=s(),q=i("p"),q.innerHTML=hl,Ht=s(),N=i("p"),N.innerHTML=ul,Bt=s(),r(z.$$.fragment),$t=s(),P=i("p"),P.innerHTML=dl,At=s(),D=i("ul"),D.innerHTML=fl,xt=s(),O=i("p"),O.innerHTML=ml,Xt=s(),K=i("p"),K.innerHTML=gl,St=s(),r(ee.$$.fragment),Lt=s(),te=i("p"),te.textContent=yl,Rt=s(),r(ae.$$.fragment),Wt=s(),le=i("p"),le.textContent=Ml,Yt=s(),se=i("p"),se.textContent=wl,Et=s(),r(ne.$$.fragment),Ft=s(),M=i("blockquote"),M.innerHTML=Tl,Qt=s(),w=i("blockquote"),w.innerHTML=bl,Vt=s(),r(ie.$$.fragment),qt=s(),oe=i("p"),oe.textContent=Jl,Nt=s(),pe=i("p"),pe.innerHTML=_l,zt=s(),re=i("ul"),re.innerHTML=jl,Pt=s(),r(ce.$$.fragment),Dt=s(),he=i("p"),he.innerHTML=Ul,Ot=s(),r(ue.$$.fragment),Kt=s(),de=i("p"),de.innerHTML=kl,ea=s(),fe=i("p"),fe.innerHTML=Cl,ta=s(),me=i("p"),me.innerHTML=vl,aa=s(),r(ge.$$.fragment),la=s(),ye=i("p"),ye.innerHTML=Il,sa=s(),Me=i("p"),Me.innerHTML=Zl,na=s(),we=i("p"),we.innerHTML=Gl,ia=s(),Te=i("p"),Te.innerHTML=Hl,oa=s(),r(be.$$.fragment),pa=s(),Je=i("p"),Je.innerHTML=Bl,ra=s(),r(_e.$$.fragment),ca=s(),T=i("blockquote"),T.innerHTML=$l,ha=s(),je=i("p"),je.innerHTML=Al,ua=s(),r(Ue.$$.fragment),da=s(),r(ke.$$.fragment),fa=s(),Ce=i("p"),Ce.innerHTML=xl,ma=s(),r(ve.$$.fragment),ga=s(),Ie=i("p"),Ie.innerHTML=Xl,ya=s(),Ze=i("p"),Ze.innerHTML=Sl,Ma=s(),r(Ge.$$.fragment),wa=s(),He=i("p"),He.textContent=Ll,Ta=s(),Be=i("p"),Be.innerHTML=Rl,ba=s(),$e=i("ul"),$e.innerHTML=Wl,Ja=s(),r(Ae.$$.fragment),_a=s(),xe=i("p"),xe.innerHTML=Yl,ja=s(),r(Xe.$$.fragment),Ua=s(),Se=i("p"),Se.innerHTML=El,ka=s(),Le=i("p"),Le.innerHTML=Fl,Ca=s(),r(Re.$$.fragment),va=s(),We=i("p"),We.innerHTML=Ql,Ia=s(),Ye=i("ul"),Ye.innerHTML=Vl,Za=s(),b=i("blockquote"),b.innerHTML=ql,Ga=s(),r(Ee.$$.fragment),Ha=s(),Fe=i("p"),Fe.innerHTML=Nl,Ba=s(),Qe=i("p"),Qe.innerHTML=zl,$a=s(),Ve=i("ul"),Ve.innerHTML=Pl,Aa=s(),qe=i("p"),qe.textContent=Dl,xa=s(),Ne=i("ol"),Ne.innerHTML=Ol,Xa=s(),r(ze.$$.fragment),Sa=s(),J=i("ol"),J.innerHTML=Kl,La=s(),r(Pe.$$.fragment),Ra=s(),De=i("p"),De.innerHTML=es,Wa=s(),Oe=i("ul"),Oe.innerHTML=ts,Ya=s(),Ke=i("p"),Ke.innerHTML=as,Ea=s(),r(et.$$.fragment),Fa=s(),tt=i("p"),tt.innerHTML=ls,Qa=s(),_=i("blockquote"),_.innerHTML=ss,Va=s(),at=i("p"),at.textContent=ns,qa=s(),r(lt.$$.fragment),Na=s(),st=i("p"),st.innerHTML=is,za=s(),r(nt.$$.fragment),Pa=s(),ot=i("p"),this.h()},l(e){const t=ds("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(a),pt=n(e),it=o(e,"P",{}),os(it).forEach(a),rt=n(e),c(U.$$.fragment,e),ct=n(e),c(k.$$.fragment,e),ht=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-18dtgjw"&&(C.innerHTML=Ka),ut=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-6kh510"&&(v.innerHTML=el),dt=n(e),c(I.$$.fragment,e),ft=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1vxvyei"&&(Z.innerHTML=tl),mt=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-weizha"&&(G.innerHTML=al),gt=n(e),c(H.$$.fragment,e),yt=n(e),c(B.$$.fragment,e),Mt=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1cqxrmv"&&($.innerHTML=ll),wt=n(e),c(A.$$.fragment,e),Tt=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-137jm6p"&&(x.innerHTML=sl),bt=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1v7onvy"&&(X.innerHTML=nl),Jt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1nus7g8"&&(S.innerHTML=il),_t=n(e),c(L.$$.fragment,e),jt=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1jdk3x1"&&(R.innerHTML=ol),Ut=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-j2fnkr"&&(W.innerHTML=pl),kt=n(e),c(Y.$$.fragment,e),Ct=n(e),c(E.$$.fragment,e),vt=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-4njx53"&&(F.innerHTML=rl),It=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-sxpkdv"&&(Q.textContent=cl),Zt=n(e),c(V.$$.fragment,e),Gt=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1whpdih"&&(q.innerHTML=hl),Ht=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-141tm4n"&&(N.innerHTML=ul),Bt=n(e),c(z.$$.fragment,e),$t=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-38udrk"&&(P.innerHTML=dl),At=n(e),D=o(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-eysscy"&&(D.innerHTML=fl),xt=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1kufxm5"&&(O.innerHTML=ml),Xt=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-t3dye5"&&(K.innerHTML=gl),St=n(e),c(ee.$$.fragment,e),Lt=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1let5f"&&(te.textContent=yl),Rt=n(e),c(ae.$$.fragment,e),Wt=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-10zd3ei"&&(le.textContent=Ml),Yt=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1j2m1uw"&&(se.textContent=wl),Et=n(e),c(ne.$$.fragment,e),Ft=n(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-vm4oxz"&&(M.innerHTML=Tl),Qt=n(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1xsgady"&&(w.innerHTML=bl),Vt=n(e),c(ie.$$.fragment,e),qt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-ikji1t"&&(oe.textContent=Jl),Nt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1oh0qkj"&&(pe.innerHTML=_l),zt=n(e),re=o(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-52tshe"&&(re.innerHTML=jl),Pt=n(e),c(ce.$$.fragment,e),Dt=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-6iufhk"&&(he.innerHTML=Ul),Ot=n(e),c(ue.$$.fragment,e),Kt=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-14l3er3"&&(de.innerHTML=kl),ea=n(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-duujfq"&&(fe.innerHTML=Cl),ta=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1ocnvge"&&(me.innerHTML=vl),aa=n(e),c(ge.$$.fragment,e),la=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1wg4yq4"&&(ye.innerHTML=Il),sa=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1wkire6"&&(Me.innerHTML=Zl),na=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-iku6lk"&&(we.innerHTML=Gl),ia=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-r1irmw"&&(Te.innerHTML=Hl),oa=n(e),c(be.$$.fragment,e),pa=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-fskkzk"&&(Je.innerHTML=Bl),ra=n(e),c(_e.$$.fragment,e),ca=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-1k5bi9y"&&(T.innerHTML=$l),ha=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-2z3ua0"&&(je.innerHTML=Al),ua=n(e),c(Ue.$$.fragment,e),da=n(e),c(ke.$$.fragment,e),fa=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1wxvbzm"&&(Ce.innerHTML=xl),ma=n(e),c(ve.$$.fragment,e),ga=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-lk6dse"&&(Ie.innerHTML=Xl),ya=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-7pxeh0"&&(Ze.innerHTML=Sl),Ma=n(e),c(Ge.$$.fragment,e),wa=n(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-bk7nho"&&(He.textContent=Ll),Ta=n(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1m9dg79"&&(Be.innerHTML=Rl),ba=n(e),$e=o(e,"UL",{"data-svelte-h":!0}),p($e)!=="svelte-1md1dub"&&($e.innerHTML=Wl),Ja=n(e),c(Ae.$$.fragment,e),_a=n(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1sxi3j0"&&(xe.innerHTML=Yl),ja=n(e),c(Xe.$$.fragment,e),Ua=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-addoqn"&&(Se.innerHTML=El),ka=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-2fhb7l"&&(Le.innerHTML=Fl),Ca=n(e),c(Re.$$.fragment,e),va=n(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1334rbm"&&(We.innerHTML=Ql),Ia=n(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-1r6n3gu"&&(Ye.innerHTML=Vl),Za=n(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-7gklvc"&&(b.innerHTML=ql),Ga=n(e),c(Ee.$$.fragment,e),Ha=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1th5sp0"&&(Fe.innerHTML=Nl),Ba=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-5at25s"&&(Qe.innerHTML=zl),$a=n(e),Ve=o(e,"UL",{"data-svelte-h":!0}),p(Ve)!=="svelte-rz04ky"&&(Ve.innerHTML=Pl),Aa=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-12aa4hm"&&(qe.textContent=Dl),xa=n(e),Ne=o(e,"OL",{"data-svelte-h":!0}),p(Ne)!=="svelte-fvcpkg"&&(Ne.innerHTML=Ol),Xa=n(e),c(ze.$$.fragment,e),Sa=n(e),J=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(J)!=="svelte-vqa2me"&&(J.innerHTML=Kl),La=n(e),c(Pe.$$.fragment,e),Ra=n(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-tghilk"&&(De.innerHTML=es),Wa=n(e),Oe=o(e,"UL",{"data-svelte-h":!0}),p(Oe)!=="svelte-v1ujs5"&&(Oe.innerHTML=ts),Ya=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-1nr3g7w"&&(Ke.innerHTML=as),Ea=n(e),c(et.$$.fragment,e),Fa=n(e),tt=o(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-xdqqo1"&&(tt.innerHTML=ls),Qa=n(e),_=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-ibytsa"&&(_.innerHTML=ss),Va=n(e),at=o(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1mshy2g"&&(at.textContent=ns),qa=n(e),c(lt.$$.fragment,e),Na=n(e),st=o(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-e0yo9e"&&(st.innerHTML=is),za=n(e),c(nt.$$.fragment,e),Pa=n(e),ot=o(e,"P",{}),os(ot).forEach(a),this.h()},h(){j(y,"name","hf:doc:metadata"),j(y,"content",Ms),j(M,"class","tip"),j(w,"class","warning"),j(T,"class","tip"),j(b,"class","tip"),j(J,"start","2"),j(_,"class","warning")},m(e,t){fs(document.head,y),l(e,pt,t),l(e,it,t),l(e,rt,t),h(U,e,t),l(e,ct,t),h(k,e,t),l(e,ht,t),l(e,C,t),l(e,ut,t),l(e,v,t),l(e,dt,t),h(I,e,t),l(e,ft,t),l(e,Z,t),l(e,mt,t),l(e,G,t),l(e,gt,t),h(H,e,t),l(e,yt,t),h(B,e,t),l(e,Mt,t),l(e,$,t),l(e,wt,t),h(A,e,t),l(e,Tt,t),l(e,x,t),l(e,bt,t),l(e,X,t),l(e,Jt,t),l(e,S,t),l(e,_t,t),h(L,e,t),l(e,jt,t),l(e,R,t),l(e,Ut,t),l(e,W,t),l(e,kt,t),h(Y,e,t),l(e,Ct,t),h(E,e,t),l(e,vt,t),l(e,F,t),l(e,It,t),l(e,Q,t),l(e,Zt,t),h(V,e,t),l(e,Gt,t),l(e,q,t),l(e,Ht,t),l(e,N,t),l(e,Bt,t),h(z,e,t),l(e,$t,t),l(e,P,t),l(e,At,t),l(e,D,t),l(e,xt,t),l(e,O,t),l(e,Xt,t),l(e,K,t),l(e,St,t),h(ee,e,t),l(e,Lt,t),l(e,te,t),l(e,Rt,t),h(ae,e,t),l(e,Wt,t),l(e,le,t),l(e,Yt,t),l(e,se,t),l(e,Et,t),h(ne,e,t),l(e,Ft,t),l(e,M,t),l(e,Qt,t),l(e,w,t),l(e,Vt,t),h(ie,e,t),l(e,qt,t),l(e,oe,t),l(e,Nt,t),l(e,pe,t),l(e,zt,t),l(e,re,t),l(e,Pt,t),h(ce,e,t),l(e,Dt,t),l(e,he,t),l(e,Ot,t),h(ue,e,t),l(e,Kt,t),l(e,de,t),l(e,ea,t),l(e,fe,t),l(e,ta,t),l(e,me,t),l(e,aa,t),h(ge,e,t),l(e,la,t),l(e,ye,t),l(e,sa,t),l(e,Me,t),l(e,na,t),l(e,we,t),l(e,ia,t),l(e,Te,t),l(e,oa,t),h(be,e,t),l(e,pa,t),l(e,Je,t),l(e,ra,t),h(_e,e,t),l(e,ca,t),l(e,T,t),l(e,ha,t),l(e,je,t),l(e,ua,t),h(Ue,e,t),l(e,da,t),h(ke,e,t),l(e,fa,t),l(e,Ce,t),l(e,ma,t),h(ve,e,t),l(e,ga,t),l(e,Ie,t),l(e,ya,t),l(e,Ze,t),l(e,Ma,t),h(Ge,e,t),l(e,wa,t),l(e,He,t),l(e,Ta,t),l(e,Be,t),l(e,ba,t),l(e,$e,t),l(e,Ja,t),h(Ae,e,t),l(e,_a,t),l(e,xe,t),l(e,ja,t),h(Xe,e,t),l(e,Ua,t),l(e,Se,t),l(e,ka,t),l(e,Le,t),l(e,Ca,t),h(Re,e,t),l(e,va,t),l(e,We,t),l(e,Ia,t),l(e,Ye,t),l(e,Za,t),l(e,b,t),l(e,Ga,t),h(Ee,e,t),l(e,Ha,t),l(e,Fe,t),l(e,Ba,t),l(e,Qe,t),l(e,$a,t),l(e,Ve,t),l(e,Aa,t),l(e,qe,t),l(e,xa,t),l(e,Ne,t),l(e,Xa,t),h(ze,e,t),l(e,Sa,t),l(e,J,t),l(e,La,t),h(Pe,e,t),l(e,Ra,t),l(e,De,t),l(e,Wa,t),l(e,Oe,t),l(e,Ya,t),l(e,Ke,t),l(e,Ea,t),h(et,e,t),l(e,Fa,t),l(e,tt,t),l(e,Qa,t),l(e,_,t),l(e,Va,t),l(e,at,t),l(e,qa,t),h(lt,e,t),l(e,Na,t),l(e,st,t),l(e,za,t),h(nt,e,t),l(e,Pa,t),l(e,ot,t),Da=!0},p:rs,i(e){Da||(u(U.$$.fragment,e),u(k.$$.fragment,e),u(I.$$.fragment,e),u(H.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(L.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(V.$$.fragment,e),u(z.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(_e.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(ve.$$.fragment,e),u(Ge.$$.fragment,e),u(Ae.$$.fragment,e),u(Xe.$$.fragment,e),u(Re.$$.fragment,e),u(Ee.$$.fragment,e),u(ze.$$.fragment,e),u(Pe.$$.fragment,e),u(et.$$.fragment,e),u(lt.$$.fragment,e),u(nt.$$.fragment,e),Da=!0)},o(e){d(U.$$.fragment,e),d(k.$$.fragment,e),d(I.$$.fragment,e),d(H.$$.fragment,e),d(B.$$.fragment,e),d(A.$$.fragment,e),d(L.$$.fragment,e),d(Y.$$.fragment,e),d(E.$$.fragment,e),d(V.$$.fragment,e),d(z.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(be.$$.fragment,e),d(_e.$$.fragment,e),d(Ue.$$.fragment,e),d(ke.$$.fragment,e),d(ve.$$.fragment,e),d(Ge.$$.fragment,e),d(Ae.$$.fragment,e),d(Xe.$$.fragment,e),d(Re.$$.fragment,e),d(Ee.$$.fragment,e),d(ze.$$.fragment,e),d(Pe.$$.fragment,e),d(et.$$.fragment,e),d(lt.$$.fragment,e),d(nt.$$.fragment,e),Da=!1},d(e){e&&(a(pt),a(it),a(rt),a(ct),a(ht),a(C),a(ut),a(v),a(dt),a(ft),a(Z),a(mt),a(G),a(gt),a(yt),a(Mt),a($),a(wt),a(Tt),a(x),a(bt),a(X),a(Jt),a(S),a(_t),a(jt),a(R),a(Ut),a(W),a(kt),a(Ct),a(vt),a(F),a(It),a(Q),a(Zt),a(Gt),a(q),a(Ht),a(N),a(Bt),a($t),a(P),a(At),a(D),a(xt),a(O),a(Xt),a(K),a(St),a(Lt),a(te),a(Rt),a(Wt),a(le),a(Yt),a(se),a(Et),a(Ft),a(M),a(Qt),a(w),a(Vt),a(qt),a(oe),a(Nt),a(pe),a(zt),a(re),a(Pt),a(Dt),a(he),a(Ot),a(Kt),a(de),a(ea),a(fe),a(ta),a(me),a(aa),a(la),a(ye),a(sa),a(Me),a(na),a(we),a(ia),a(Te),a(oa),a(pa),a(Je),a(ra),a(ca),a(T),a(ha),a(je),a(ua),a(da),a(fa),a(Ce),a(ma),a(ga),a(Ie),a(ya),a(Ze),a(Ma),a(wa),a(He),a(Ta),a(Be),a(ba),a($e),a(Ja),a(_a),a(xe),a(ja),a(Ua),a(Se),a(ka),a(Le),a(Ca),a(va),a(We),a(Ia),a(Ye),a(Za),a(b),a(Ga),a(Ha),a(Fe),a(Ba),a(Qe),a($a),a(Ve),a(Aa),a(qe),a(xa),a(Ne),a(Xa),a(Sa),a(J),a(La),a(Ra),a(De),a(Wa),a(Oe),a(Ya),a(Ke),a(Ea),a(Fa),a(tt),a(Qa),a(_),a(Va),a(at),a(qa),a(Na),a(st),a(za),a(Pa),a(ot)),a(y),f(U,e),f(k,e),f(I,e),f(H,e),f(B,e),f(A,e),f(L,e),f(Y,e),f(E,e),f(V,e),f(z,e),f(ee,e),f(ae,e),f(ne,e),f(ie,e),f(ce,e),f(ue,e),f(ge,e),f(be,e),f(_e,e),f(Ue,e),f(ke,e),f(ve,e),f(Ge,e),f(Ae,e),f(Xe,e),f(Re,e),f(Ee,e),f(ze,e),f(Pe,e),f(et,e),f(lt,e),f(nt,e)}}}const Ms='{"title":"Upload files to the Hub","local":"upload-files-to-the-hub","sections":[{"title":"Upload a file","local":"upload-a-file","sections":[],"depth":2},{"title":"Upload a folder","local":"upload-a-folder","sections":[],"depth":2},{"title":"Upload from the CLI","local":"upload-from-the-cli","sections":[],"depth":2},{"title":"Upload a large folder","local":"upload-a-large-folder","sections":[{"title":"Tips and tricks for large uploads","local":"tips-and-tricks-for-large-uploads","sections":[],"depth":3}],"depth":2},{"title":"Advanced features","local":"advanced-features","sections":[{"title":"Faster Uploads","local":"faster-uploads","sections":[],"depth":3},{"title":"Non-blocking uploads","local":"non-blocking-uploads","sections":[],"depth":3},{"title":"Upload a folder by chunks","local":"upload-a-folder-by-chunks","sections":[],"depth":3},{"title":"Scheduled uploads","local":"scheduled-uploads","sections":[{"title":"Space persistence demo","local":"space-persistence-demo","sections":[],"depth":4},{"title":"Custom uploads","local":"custom-uploads","sections":[],"depth":4}],"depth":3},{"title":"create_commit","local":"createcommit","sections":[],"depth":3},{"title":"Preupload LFS files before commit","local":"preupload-lfs-files-before-commit","sections":[],"depth":3}],"depth":2}],"depth":1}';function ws(Oa){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends hs{constructor(y){super(),us(this,y,ws,ys,ps,{})}}export{Us as component};
