import{s as oe,o as he,n as de}from"../chunks/scheduler.0cf4ef2e.js";import{S as me,i as ue,e as i,s as l,c,h as ge,a as p,d as t,b as n,f as N,g as d,j as r,k as I,l as y,m as e,n as o,t as h,o as m,p as u}from"../chunks/index.abc433bf.js";import{C as ye}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{D as Ss}from"../chunks/Docstring.6b022b23.js";import{C as Z}from"../chunks/CodeBlock.18a16f91.js";import{E as ce}from"../chunks/ExampleCodeBlock.c018d600.js";import{H as w,E as fe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function Me(zs){let f,C="Example:",T,M,j;return M=new Z({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMGFzX3ZhbGlkYXRlZF9maWVsZCUyQyUyMHN0cmljdCUyQyUyMHZhbGlkYXRlZF9maWVsZCUwQSUwQSU0MGFzX3ZhbGlkYXRlZF9maWVsZCUwQWRlZiUyMHBvc2l0aXZlX2ludCh2YWx1ZSUzQSUyMGludCklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHZhbHVlJTIwJTNFJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyVmFsdWUlMjBtdXN0JTIwYmUlMjBwb3NpdGl2ZSUyQyUyMGdvdCUyMCU3QnZhbHVlJTdEJTIyKSUwQSUwQSU0MHN0cmljdChhY2NlcHRfa3dhcmdzJTNEVHJ1ZSklMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVzZXIlM0ElMEElMjAlMjAlMjAlMjBuYW1lJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwYWdlJTNBJTIwaW50JTIwJTNEJTIwcG9zaXRpdmVfaW50KGRlZmF1bHQlM0QxMCklMEElMEFVc2VyKG5hbWUlM0QlMjJKb2huJTIyKSUwQSUwQVVzZXIobmFtZSUzRCUyMkpvaG4lMjIlMkMlMjBhZ2UlM0QzMCUyQyUyMGxhc3RuYW1lJTNEJTIyRG9lJTIyKSUwQSUwQVVzZXIobmFtZSUzRCUyMkpvaG4lMjIlMkMlMjBhZ2UlM0QlMjIzMCUyMiklMEElMEFVc2VyKG5hbWUlM0QlMjJKb2huJTIyJTJDJTIwYWdlJTNELTEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> as_validated_field, strict, validated_field

<span class="hljs-meta">&gt;&gt;&gt; </span>@as_validated_field
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">positive_int</span>(<span class="hljs-params">value: <span class="hljs-built_in">int</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> value &gt;= <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Value must be positive, got <span class="hljs-subst">{value}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>@strict(accept_kwargs=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">User</span>:
<span class="hljs-meta">... </span>    name: <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>    age: <span class="hljs-built_in">int</span> = positive_int(default=<span class="hljs-number">10</span>)

<span class="hljs-comment"># Initialize</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>)
User(name=<span class="hljs-string">&#x27;John&#x27;</span>, age=<span class="hljs-number">10</span>)

<span class="hljs-comment"># Extra kwargs are accepted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>, age=<span class="hljs-number">30</span>, lastname=<span class="hljs-string">&quot;Doe&quot;</span>)
User(name=<span class="hljs-string">&#x27;John&#x27;</span>, age=<span class="hljs-number">30</span>, *lastname=<span class="hljs-string">&#x27;Doe&#x27;</span>)

<span class="hljs-comment"># Invalid type =&gt; raises</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>, age=<span class="hljs-string">&quot;30&quot;</span>)
huggingface_hub.errors.StrictDataclassFieldValidationError: Validation error <span class="hljs-keyword">for</span> field <span class="hljs-string">&#x27;age&#x27;</span>:
    TypeError: Field <span class="hljs-string">&#x27;age&#x27;</span> expected <span class="hljs-built_in">int</span>, got <span class="hljs-built_in">str</span> (value: <span class="hljs-string">&#x27;30&#x27;</span>)

<span class="hljs-comment"># Invalid value =&gt; raises</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>User(name=<span class="hljs-string">&quot;John&quot;</span>, age=-<span class="hljs-number">1</span>)
huggingface_hub.errors.StrictDataclassFieldValidationError: Validation error <span class="hljs-keyword">for</span> field <span class="hljs-string">&#x27;age&#x27;</span>:
    ValueError: Value must be positive, got -<span class="hljs-number">1</span>`,wrap:!1}}),{c(){f=i("p"),f.textContent=C,T=l(),c(M.$$.fragment)},l(g){f=p(g,"P",{"data-svelte-h":!0}),r(f)!=="svelte-11lpom8"&&(f.textContent=C),T=n(g),d(M.$$.fragment,g)},m(g,v){e(g,f,v),e(g,T,v),o(M,g,v),j=!0},p:de,i(g){j||(h(M.$$.fragment,g),j=!0)},o(g){m(M.$$.fragment,g),j=!1},d(g){g&&(t(f),t(T)),u(M,g)}}}function je(zs){let f,C="Example:",T,M,j;return M=new Z({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMEFubm90YXRlZCUyQyUyMFR5cGVkRGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIuZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjB2YWxpZGF0ZV90eXBlZF9kaWN0JTBBJTBBZGVmJTIwcG9zaXRpdmVfaW50KHZhbHVlJTNBJTIwaW50KSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbm90JTIwdmFsdWUlMjAlM0UlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKGYlMjJWYWx1ZSUyMG11c3QlMjBiZSUyMHBvc2l0aXZlJTJDJTIwZ290JTIwJTdCdmFsdWUlN0QlMjIpJTBBJTBBY2xhc3MlMjBVc2VyKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjBuYW1lJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwYWdlJTNBJTIwQW5ub3RhdGVkJTVCaW50JTJDJTIwcG9zaXRpdmVfaW50JTVEJTBBJTBBJTIzJTIwVmFsaWQlMjBkYXRhJTBBdmFsaWRhdGVfdHlwZWRfZGljdChVc2VyJTJDJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMkpvaG4lMjIlMkMlMjAlMjJhZ2UlMjIlM0ElMjAzMCU3RCklMEElMEElMjMlMjBJbnZhbGlkJTIwdHlwZSUyMGZvciUyMGFnZSUwQXZhbGlkYXRlX3R5cGVkX2RpY3QoVXNlciUyQyUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJKb2huJTIyJTJDJTIwJTIyYWdlJTIyJTNBJTIwJTIyMzAlMjIlN0QpJTBBJTBBJTIzJTIwSW52YWxpZCUyMHZhbHVlJTIwZm9yJTIwYWdlJTBBdmFsaWRhdGVfdHlwZWRfZGljdChVc2VyJTJDJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMkpvaG4lMjIlMkMlMjAlMjJhZ2UlMjIlM0ElMjAtMSU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> Annotated, TypedDict
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> validate_typed_dict

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">positive_int</span>(<span class="hljs-params">value: <span class="hljs-built_in">int</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> value &gt;= <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Value must be positive, got <span class="hljs-subst">{value}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">User</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
<span class="hljs-meta">... </span>    name: <span class="hljs-built_in">str</span>
<span class="hljs-meta">... </span>    age: Annotated[<span class="hljs-built_in">int</span>, positive_int]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Valid data</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>validate_typed_dict(User, {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;John&quot;</span>, <span class="hljs-string">&quot;age&quot;</span>: <span class="hljs-number">30</span>})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Invalid type for age</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>validate_typed_dict(User, {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;John&quot;</span>, <span class="hljs-string">&quot;age&quot;</span>: <span class="hljs-string">&quot;30&quot;</span>})
huggingface_hub.errors.StrictDataclassFieldValidationError: Validation error <span class="hljs-keyword">for</span> field <span class="hljs-string">&#x27;age&#x27;</span>:
    TypeError: Field <span class="hljs-string">&#x27;age&#x27;</span> expected <span class="hljs-built_in">int</span>, got <span class="hljs-built_in">str</span> (value: <span class="hljs-string">&#x27;30&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Invalid value for age</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>validate_typed_dict(User, {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;John&quot;</span>, <span class="hljs-string">&quot;age&quot;</span>: -<span class="hljs-number">1</span>})
huggingface_hub.errors.StrictDataclassFieldValidationError: Validation error <span class="hljs-keyword">for</span> field <span class="hljs-string">&#x27;age&#x27;</span>:
    ValueError: Value must be positive, got -<span class="hljs-number">1</span>`,wrap:!1}}),{c(){f=i("p"),f.textContent=C,T=l(),c(M.$$.fragment)},l(g){f=p(g,"P",{"data-svelte-h":!0}),r(f)!=="svelte-11lpom8"&&(f.textContent=C),T=n(g),d(M.$$.fragment,g)},m(g,v){e(g,f,v),e(g,T,v),o(M,g,v),j=!0},p:de,i(g){j||(h(M.$$.fragment,g),j=!0)},o(g){m(M.$$.fragment,g),j=!1},d(g){g&&(t(f),t(T)),u(M,g)}}}function be(zs){let f,C,T,M,j,g,v,ea,Y,_t="The <code>huggingface_hub</code> package provides a utility to create <strong>strict dataclasses</strong>. These are enhanced versions of Python’s standard <code>dataclass</code> with additional validation features. Strict dataclasses ensure that fields are validated both during initialization and assignment, making them ideal for scenarios where data integrity is critical.",la,F,na,S,$t="Strict dataclasses are created using the <code>@strict</code> decorator. They extend the functionality of regular dataclasses by:",ia,z,Zt="<li>Validating field types based on type hints</li> <li>Supporting custom validators for additional checks</li> <li>Optionally allowing arbitrary keyword arguments in the constructor</li> <li>Validating fields both at initialization and during assignment</li>",pa,R,ra,X,Ct="<li><strong>Data Integrity</strong>: Ensures fields always contain valid data</li> <li><strong>Ease of Use</strong>: Integrates seamlessly with Python’s <code>dataclass</code> module</li> <li><strong>Flexibility</strong>: Supports custom validators for complex validation logic</li> <li><strong>Lightweight</strong>: Requires no additional dependencies such as Pydantic, attrs, or similar libraries</li>",ca,Q,da,H,oa,A,ha,D,It="Fields are validated during initialization:",ma,q,ua,L,xt="Consistency between fields is also validated during initialization (class-wise validation):",ga,P,ya,K,Gt="Fields are also validated during assignment:",fa,O,Ma,ss,kt="To re-run class-wide validation after assignment, you must call <code>.validate</code> explicitly:",ja,as,ba,ts,wa,es,Et="You can attach multiple custom validators to fields using <code>validated_field</code>. A validator is a callable that takes a single argument and raises an exception if the value is invalid.",Ta,ls,va,ns,Nt="In this example, both validators are applied to the <code>hidden_size</code> field.",Ja,is,Ua,ps,Wt="By default, strict dataclasses only accept fields defined in the class. You can allow additional keyword arguments by setting <code>accept_kwargs=True</code> in the <code>@strict</code> decorator.",_a,rs,$a,cs,Vt="Additional keyword arguments appear in the string representation of the dataclass but are prefixed with <code>*</code> to highlight that they are not validated.",Za,ds,Ca,os,Bt="Strict dataclasses respect type hints and validate them automatically. For example:",Ia,hs,xa,ms,Yt="Supported types include:",Ga,us,Ft="<li>Any</li> <li>Union</li> <li>Optional</li> <li>Literal</li> <li>List</li> <li>Dict</li> <li>Tuple</li> <li>Set</li>",ka,gs,St="And any combination of these types. If your need more complex type validation, you can do it through a custom validator.",Ea,ys,Na,fs,zt="Methods named <code>validate_xxx</code> are treated as class validators. These methods must only take <code>self</code> as an argument. Class validators are run once during initialization, right after <code>__post_init__</code>. You can define as many of them as needed—they’ll be executed sequentially in the order they appear.",Wa,Ms,Rt="Note that class validators are not automatically re-run when a field is updated after initialization. To manually re-validate the object, you need to call <code>obj.validate()</code>.",Va,js,Ba,W,Xt=`<p>Method <code>.validate()</code> is a reserved name on strict dataclasses.
To prevent unexpected behaviors, a <code>StrictDataclassDefinitionError</code> error will be raised if your class already defines one.</p>`,Ya,bs,Fa,ws,Sa,Ts,Qt="The <code>@strict</code> decorator enhances a dataclass with strict validation.",za,b,vs,ht,Rs,Ht="Decorator to add strict validation to a dataclass.",mt,Xs,At=`This decorator must be used on top of <code>@dataclass</code> to ensure IDEs and static typing tools
recognize the class as a dataclass.`,ut,Qs,Dt="Can be used with or without arguments:",gt,Hs,qt="<li><code>@strict</code></li> <li><code>@strict(accept_kwargs=True)</code></li>",yt,V,Ra,Js,Xa,Us,Lt="Method to validate that a dictionary conforms to the types defined in a <code>TypedDict</code> class.",Qa,_s,Pt="This is the equivalent to dataclass validation but for <code>TypedDict</code>s. Since typed dicts are never instantiated (only used by static type checkers), validation step must be manually called.",Ha,U,$s,ft,As,Kt="Validate that a dictionary conforms to the types defined in a TypedDict class.",Mt,Ds,Ot="Under the hood, the typed dict is converted to a strict dataclass and validated using the <code>@strict</code> decorator.",jt,B,Aa,Zs,Da,Cs,se="Decorator to create a <code>validated_field</code>. Recommended for fields with a single validator to avoid boilerplate code.",qa,x,Is,bt,qs,ae="Decorates a validator function as a <code>validated_field</code> (i.e. a dataclass field with a custom validator).",La,xs,Pa,Gs,te="Creates a dataclass field with custom validation.",Ka,_,ks,wt,Ls,ee="Create a dataclass field with a custom validator.",Tt,Ps,le="Useful to apply several checks to a field. If only applying one rule, check out the <code>as_validated_field</code> decorator.",Oa,Es,st,G,Ns,vt,Ks,ne="Base exception for strict dataclasses.",at,k,Ws,Jt,Os,ie="Exception thrown when a strict dataclass is defined incorrectly.",tt,E,Vs,Ut,sa,pe="Exception thrown when a strict dataclass fails validation for a given field.",et,Bs,lt,Ys,re='<li>See discussion in <a href="https://github.com/huggingface/transformers/issues/36329" rel="nofollow">https://github.com/huggingface/transformers/issues/36329</a> regarding adding Pydantic as a dependency. It would be a heavy addition and require careful logic to support both v1 and v2.</li> <li>We don’t need most of Pydantic’s features, especially those related to automatic casting, jsonschema, serialization, aliases, etc.</li> <li>We don’t need the ability to instantiate a class from a dictionary.</li> <li>We don’t want to mutate data. In <code>@strict</code>, “validation” means “checking if a value is valid.” In Pydantic, “validation” means “casting a value, possibly mutating it, and then checking if it’s valid.”</li> <li>We don’t need blazing-fast validation. <code>@strict</code> isn’t designed for heavy loads where performance is critical. Common use cases involve validating a model configuration (performed once and negligible compared to running a model). This allows us to keep the code minimal.</li>',nt,Fs,it,ta,pt;return j=new ye({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new w({props:{title:"Strict Dataclasses",local:"strict-dataclasses",headingTag:"h1"}}),F=new w({props:{title:"Overview",local:"overview",headingTag:"h2"}}),R=new w({props:{title:"Benefits",local:"benefits",headingTag:"h2"}}),Q=new w({props:{title:"Usage",local:"usage",headingTag:"h2"}}),H=new w({props:{title:"Basic Example",local:"basic-example",headingTag:"h3"}}),A=new Z({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUyQyUyMGFzX3ZhbGlkYXRlZF9maWVsZCUwQSUwQSUyMyUyMEN1c3RvbSUyMHZhbGlkYXRvciUyMHRvJTIwZW5zdXJlJTIwYSUyMHZhbHVlJTIwaXMlMjBwb3NpdGl2ZSUwQSU0MGFzX3ZhbGlkYXRlZF9maWVsZCUwQWRlZiUyMHBvc2l0aXZlX2ludCh2YWx1ZSUzQSUyMGludCklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHZhbHVlJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyVmFsdWUlMjBtdXN0JTIwYmUlMjBwb3NpdGl2ZSUyQyUyMGdvdCUyMCU3QnZhbHVlJTdEJTIyKSUwQSUwQSU0MHN0cmljdCUwQSU0MGRhdGFjbGFzcyUwQWNsYXNzJTIwQ29uZmlnJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfdHlwZSUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zaXplJTNBJTIwaW50JTIwJTNEJTIwcG9zaXRpdmVfaW50KGRlZmF1bHQlM0QxNiklMEElMjAlMjAlMjAlMjB2b2NhYl9zaXplJTNBJTIwaW50JTIwJTNEJTIwMzIlMjAlMjAlMjMlMjBEZWZhdWx0JTIwdmFsdWUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBNZXRob2RzJTIwbmFtZWQlMjAlNjB2YWxpZGF0ZV94eHglNjAlMjBhcmUlMjB0cmVhdGVkJTIwYXMlMjBjbGFzcy13aXNlJTIwdmFsaWRhdG9ycyUwQSUyMCUyMCUyMCUyMGRlZiUyMHZhbGlkYXRlX2JpZ19lbm91Z2hfdm9jYWIoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYudm9jYWJfc2l6ZSUyMCUzQyUyMHNlbGYuaGlkZGVuX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMFZhbHVlRXJyb3IoZiUyMnZvY2FiX3NpemUlMjAoJTdCc2VsZi52b2NhYl9zaXplJTdEKSUyMG11c3QlMjBiZSUyMGdyZWF0ZXIlMjB0aGFuJTIwaGlkZGVuX3NpemUlMjAoJTdCc2VsZi5oaWRkZW5fc2l6ZSU3RCklMjIp",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict, as_validated_field

<span class="hljs-comment"># Custom validator to ensure a value is positive</span>
<span class="hljs-meta">@as_validated_field</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">positive_int</span>(<span class="hljs-params">value: <span class="hljs-built_in">int</span></span>):
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> value &gt; <span class="hljs-number">0</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Value must be positive, got <span class="hljs-subst">{value}</span>&quot;</span>)

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    model_type: <span class="hljs-built_in">str</span>
    hidden_size: <span class="hljs-built_in">int</span> = positive_int(default=<span class="hljs-number">16</span>)
    vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">32</span>  <span class="hljs-comment"># Default value</span>

    <span class="hljs-comment"># Methods named \`validate_xxx\` are treated as class-wise validators</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_big_enough_vocab</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.vocab_size &lt; self.hidden_size:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;vocab_size (<span class="hljs-subst">{self.vocab_size}</span>) must be greater than hidden_size (<span class="hljs-subst">{self.hidden_size}</span>)&quot;</span>)`,wrap:!1}}),q=new Z({props:{code:"Y29uZmlnJTIwJTNEJTIwQ29uZmlnKG1vZGVsX3R5cGUlM0QlMjJiZXJ0JTIyJTJDJTIwaGlkZGVuX3NpemUlM0QyNCklMjAlMjAlMjAlMjMlMjBWYWxpZCUwQWNvbmZpZyUyMCUzRCUyMENvbmZpZyhtb2RlbF90eXBlJTNEJTIyYmVydCUyMiUyQyUyMGhpZGRlbl9zaXplJTNELTEpJTIwJTIwJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzRmllbGRWYWxpZGF0aW9uRXJyb3I=",highlighted:`config = Config(model_type=<span class="hljs-string">&quot;bert&quot;</span>, hidden_size=<span class="hljs-number">24</span>)   <span class="hljs-comment"># Valid</span>
config = Config(model_type=<span class="hljs-string">&quot;bert&quot;</span>, hidden_size=-<span class="hljs-number">1</span>)   <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),P=new Z({props:{code:"JTIzJTIwJTYwdm9jYWJfc2l6ZSU2MCUyMHRvbyUyMHNtYWxsJTIwY29tcGFyZWQlMjB0byUyMCU2MGhpZGRlbl9zaXplJTYwJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnKG1vZGVsX3R5cGUlM0QlMjJiZXJ0JTIyJTJDJTIwaGlkZGVuX3NpemUlM0QzMiUyQyUyMHZvY2FiX3NpemUlM0QxNiklMjAlMjAlMjAlMjMlMjBSYWlzZXMlMjBTdHJpY3REYXRhY2xhc3NDbGFzc1ZhbGlkYXRpb25FcnJvcg==",highlighted:'<span class="hljs-comment"># `vocab_size` too small compared to `hidden_size`</span>\nconfig = Config(model_type=<span class="hljs-string">&quot;bert&quot;</span>, hidden_size=<span class="hljs-number">32</span>, vocab_size=<span class="hljs-number">16</span>)   <span class="hljs-comment"># Raises StrictDataclassClassValidationError</span>',wrap:!1}}),O=new Z({props:{code:"Y29uZmlnLmhpZGRlbl9zaXplJTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwVmFsaWQlMEFjb25maWcuaGlkZGVuX3NpemUlMjAlM0QlMjAtMSUyMCUyMCUyMCUyMyUyMFJhaXNlcyUyMFN0cmljdERhdGFjbGFzc0ZpZWxkVmFsaWRhdGlvbkVycm9y",highlighted:`config.hidden_size = <span class="hljs-number">512</span>  <span class="hljs-comment"># Valid</span>
config.hidden_size = -<span class="hljs-number">1</span>   <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),as=new Z({props:{code:"Y29uZmlnLnZhbGlkYXRlKCklMjAlMjAlMjMlMjBSdW5zJTIwYWxsJTIwY2xhc3MlMjB2YWxpZGF0b3Jz",highlighted:'config.validate()  <span class="hljs-comment"># Runs all class validators</span>',wrap:!1}}),ts=new w({props:{title:"Custom Validators",local:"custom-validators",headingTag:"h3"}}),ls=new Z({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUyQyUyMHZhbGlkYXRlZF9maWVsZCUwQSUwQWRlZiUyMG11bHRpcGxlX29mXzY0KHZhbHVlJTNBJTIwaW50KSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwdmFsdWUlMjAlMjUlMjA2NCUyMCElM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKGYlMjJWYWx1ZSUyMG11c3QlMjBiZSUyMGElMjBtdWx0aXBsZSUyMG9mJTIwNjQlMkMlMjBnb3QlMjAlN0J2YWx1ZSU3RCUyMiklMEElMEElNDBzdHJpY3QlMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMENvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGhpZGRlbl9zaXplJTNBJTIwaW50JTIwJTNEJTIwdmFsaWRhdGVkX2ZpZWxkKHZhbGlkYXRvciUzRCU1QnBvc2l0aXZlX2ludCUyQyUyMG11bHRpcGxlX29mXzY0JTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict, validated_field

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiple_of_64</span>(<span class="hljs-params">value: <span class="hljs-built_in">int</span></span>):
    <span class="hljs-keyword">if</span> value % <span class="hljs-number">64</span> != <span class="hljs-number">0</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Value must be a multiple of 64, got <span class="hljs-subst">{value}</span>&quot;</span>)

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    hidden_size: <span class="hljs-built_in">int</span> = validated_field(validator=[positive_int, multiple_of_64])`,wrap:!1}}),is=new w({props:{title:"Additional Keyword Arguments",local:"additional-keyword-arguments",headingTag:"h3"}}),rs=new Z({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUwQSUwQSU0MHN0cmljdChhY2NlcHRfa3dhcmdzJTNEVHJ1ZSklMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMENvbmZpZ1dpdGhLd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjBtb2RlbF90eXBlJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDE2JTBBJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnV2l0aEt3YXJncyhtb2RlbF90eXBlJTNEJTIyYmVydCUyMiUyQyUyMHZvY2FiX3NpemUlM0QzMDAwMCUyQyUyMGV4dHJhX2ZpZWxkJTNEJTIyZXh0cmFfdmFsdWUlMjIpJTBBcHJpbnQoY29uZmlnKSUyMCUyMCUyMyUyMENvbmZpZ1dpdGhLd2FyZ3MobW9kZWxfdHlwZSUzRCdiZXJ0JyUyQyUyMHZvY2FiX3NpemUlM0QzMDAwMCUyQyUyMCpleHRyYV9maWVsZCUzRCdleHRyYV92YWx1ZScp",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict

<span class="hljs-meta">@strict(<span class="hljs-params">accept_kwargs=<span class="hljs-literal">True</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ConfigWithKwargs</span>:
    model_type: <span class="hljs-built_in">str</span>
    vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>

config = ConfigWithKwargs(model_type=<span class="hljs-string">&quot;bert&quot;</span>, vocab_size=<span class="hljs-number">30000</span>, extra_field=<span class="hljs-string">&quot;extra_value&quot;</span>)
<span class="hljs-built_in">print</span>(config)  <span class="hljs-comment"># ConfigWithKwargs(model_type=&#x27;bert&#x27;, vocab_size=30000, *extra_field=&#x27;extra_value&#x27;)</span>`,wrap:!1}}),ds=new w({props:{title:"Integration with Type Hints",local:"integration-with-type-hints",headingTag:"h3"}}),hs=new Z({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLmRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwc3RyaWN0JTBBJTBBJTQwc3RyaWN0JTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBDb25maWclM0ElMEElMjAlMjAlMjAlMjBsYXllcnMlM0ElMjBMaXN0JTVCaW50JTVEJTBBJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnKGxheWVycyUzRCU1QjY0JTJDJTIwMTI4JTVEKSUyMCUyMCUyMyUyMFZhbGlkJTBBY29uZmlnJTIwJTNEJTIwQ29uZmlnKGxheWVycyUzRCUyMm5vdF9hX2xpc3QlMjIpJTIwJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzRmllbGRWYWxpZGF0aW9uRXJyb3I=",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>]

config = Config(layers=[<span class="hljs-number">64</span>, <span class="hljs-number">128</span>])  <span class="hljs-comment"># Valid</span>
config = Config(layers=<span class="hljs-string">&quot;not_a_list&quot;</span>)  <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),ys=new w({props:{title:"Class validators",local:"class-validators",headingTag:"h3"}}),js=new Z({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5kYXRhY2xhc3NlcyUyMGltcG9ydCUyMHN0cmljdCUwQSUwQSU0MHN0cmljdCUwQSU0MGRhdGFjbGFzcyUwQWNsYXNzJTIwQ29uZmlnJTNBJTBBJTIwJTIwJTIwJTIwZm9vJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwZm9vX2xlbmd0aCUzQSUyMGludCUwQSUyMCUyMCUyMCUyMHVwcGVyX2Nhc2UlM0ElMjBib29sJTIwJTNEJTIwRmFsc2UlMEElMEElMjAlMjAlMjAlMjBkZWYlMjB2YWxpZGF0ZV9mb29fbGVuZ3RoKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc2VsZi5mb28pJTIwISUzRCUyMHNlbGYuZm9vX2xlbmd0aCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvcihmJTIyZm9vJTIwbXVzdCUyMGJlJTIwJTdCc2VsZi5mb29fbGVuZ3RoJTdEJTIwY2hhcmFjdGVycyUyMGxvbmclMkMlMjBnb3QlMjAlN0JsZW4oc2VsZi5mb28pJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHZhbGlkYXRlX2Zvb19jYXNpbmcoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNlbGYudXBwZXJfY2FzZSUyMGFuZCUyMHNlbGYuZm9vLnVwcGVyKCklMjAhJTNEJTIwc2VsZi5mb28lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMFZhbHVlRXJyb3IoZiUyMmZvbyUyMG11c3QlMjBiZSUyMHVwcGVyY2FzZSUyQyUyMGdvdCUyMCU3QnNlbGYuZm9vJTdEJTIyKSUwQSUwQWNvbmZpZyUyMCUzRCUyMENvbmZpZyhmb28lM0QlMjJiYXIlMjIlMkMlMjBmb29fbGVuZ3RoJTNEMyklMjAlMjMlMjBvayUwQSUwQWNvbmZpZy51cHBlcl9jYXNlJTIwJTNEJTIwVHJ1ZSUwQWNvbmZpZy52YWxpZGF0ZSgpJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzQ2xhc3NWYWxpZGF0aW9uRXJyb3IlMEElMEFDb25maWcoZm9vJTNEJTIyYWJjZCUyMiUyQyUyMGZvb19sZW5ndGglM0QzKSUyMCUyMyUyMFJhaXNlcyUyMFN0cmljdERhdGFjbGFzc0ZpZWxkVmFsaWRhdGlvbkVycm9yJTBBQ29uZmlnKGZvbyUzRCUyMkJhciUyMiUyQyUyMGZvb19sZW5ndGglM0QzJTJDJTIwdXBwZXJfY2FzZSUzRFRydWUpJTIwJTIzJTIwUmFpc2VzJTIwU3RyaWN0RGF0YWNsYXNzRmllbGRWYWxpZGF0aW9uRXJyb3I=",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> huggingface_hub.dataclasses <span class="hljs-keyword">import</span> strict

<span class="hljs-meta">@strict</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Config</span>:
    foo: <span class="hljs-built_in">str</span>
    foo_length: <span class="hljs-built_in">int</span>
    upper_case: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_foo_length</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(self.foo) != self.foo_length:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;foo must be <span class="hljs-subst">{self.foo_length}</span> characters long, got <span class="hljs-subst">{<span class="hljs-built_in">len</span>(self.foo)}</span>&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">validate_foo_casing</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.upper_case <span class="hljs-keyword">and</span> self.foo.upper() != self.foo:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;foo must be uppercase, got <span class="hljs-subst">{self.foo}</span>&quot;</span>)

config = Config(foo=<span class="hljs-string">&quot;bar&quot;</span>, foo_length=<span class="hljs-number">3</span>) <span class="hljs-comment"># ok</span>

config.upper_case = <span class="hljs-literal">True</span>
config.validate() <span class="hljs-comment"># Raises StrictDataclassClassValidationError</span>

Config(foo=<span class="hljs-string">&quot;abcd&quot;</span>, foo_length=<span class="hljs-number">3</span>) <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>
Config(foo=<span class="hljs-string">&quot;Bar&quot;</span>, foo_length=<span class="hljs-number">3</span>, upper_case=<span class="hljs-literal">True</span>) <span class="hljs-comment"># Raises StrictDataclassFieldValidationError</span>`,wrap:!1}}),bs=new w({props:{title:"API Reference",local:"api-reference",headingTag:"h2"}}),ws=new w({props:{title:"@strict",local:"huggingface_hub.dataclasses.strict",headingTag:"h3"}}),vs=new Ss({props:{name:"huggingface_hub.dataclasses.strict",anchor:"huggingface_hub.dataclasses.strict",parameters:[{name:"accept_kwargs",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.dataclasses.strict.cls",description:`<strong>cls</strong> &#x2014;
The class to convert to a strict dataclass.`,name:"cls"},{anchor:"huggingface_hub.dataclasses.strict.accept_kwargs",description:`<strong>accept_kwargs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, allows arbitrary keyword arguments in <code>__init__</code>. Defaults to False.`,name:"accept_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/dataclasses.py#L55",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The enhanced dataclass with strict validation on field assignment.</p>
`}}),V=new ce({props:{anchor:"huggingface_hub.dataclasses.strict.example",$$slots:{default:[Me]},$$scope:{ctx:zs}}}),Js=new w({props:{title:"validate_typed_dict",local:"huggingface_hub.dataclasses.validate_typed_dict",headingTag:"h3"}}),$s=new Ss({props:{name:"huggingface_hub.dataclasses.validate_typed_dict",anchor:"huggingface_hub.dataclasses.validate_typed_dict",parameters:[{name:"schema",val:": type"},{name:"data",val:": dict"}],parametersDescription:[{anchor:"huggingface_hub.dataclasses.validate_typed_dict.schema",description:`<strong>schema</strong> (<code>type[TypedDictType]</code>) &#x2014;
The TypedDict class defining the expected structure and types.`,name:"schema"},{anchor:"huggingface_hub.dataclasses.validate_typed_dict.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
The dictionary to validate.`,name:"data"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/dataclasses.py#L255",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>StrictDataclassFieldValidationError</code> —
If any field in the dictionary does not conform to the expected type.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StrictDataclassFieldValidationError</code></p>
`}}),B=new ce({props:{anchor:"huggingface_hub.dataclasses.validate_typed_dict.example",$$slots:{default:[je]},$$scope:{ctx:zs}}}),Zs=new w({props:{title:"as_validated_field",local:"huggingface_hub.dataclasses.as_validated_field",headingTag:"h3"}}),Is=new Ss({props:{name:"huggingface_hub.dataclasses.as_validated_field",anchor:"huggingface_hub.dataclasses.as_validated_field",parameters:[{name:"validator",val:": typing.Callable[[typing.Any], NoneType]"}],parametersDescription:[{anchor:"huggingface_hub.dataclasses.as_validated_field.validator",description:`<strong>validator</strong> (<code>Callable</code>) &#x2014;
A method that takes a value as input and raises ValueError/TypeError if the value is invalid.`,name:"validator"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/dataclasses.py#L395"}}),xs=new w({props:{title:"validated_field",local:"huggingface_hub.dataclasses.validated_field",headingTag:"h3"}}),ks=new Ss({props:{name:"huggingface_hub.dataclasses.validated_field",anchor:"huggingface_hub.dataclasses.validated_field",parameters:[{name:"validator",val:": typing.Union[list[typing.Callable[[typing.Any], NoneType]], typing.Callable[[typing.Any], NoneType]]"},{name:"default",val:": typing.Union[typing.Any, dataclasses._MISSING_TYPE] = <dataclasses._MISSING_TYPE object at 0x7fac63897610>"},{name:"default_factory",val:": typing.Union[typing.Callable[[], typing.Any], dataclasses._MISSING_TYPE] = <dataclasses._MISSING_TYPE object at 0x7fac63897610>"},{name:"init",val:": bool = True"},{name:"repr",val:": bool = True"},{name:"hash",val:": typing.Optional[bool] = None"},{name:"compare",val:": bool = True"},{name:"metadata",val:": typing.Optional[dict] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"huggingface_hub.dataclasses.validated_field.validator",description:`<strong>validator</strong> (<code>Callable</code> or <code>list[Callable]</code>) &#x2014;
A method that takes a value as input and raises ValueError/TypeError if the value is invalid.
Can be a list of validators to apply multiple checks.`,name:"validator"},{anchor:"huggingface_hub.dataclasses.validated_field.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional arguments to pass to <code>dataclasses.field()</code>.`,name:"*kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/dataclasses.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A field with the validator attached in metadata</p>
`}}),Es=new w({props:{title:"Errors",local:"huggingface_hub.errors.StrictDataclassError",headingTag:"h3"}}),Ns=new Ss({props:{name:"class huggingface_hub.errors.StrictDataclassError",anchor:"huggingface_hub.errors.StrictDataclassError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L352"}}),Ws=new Ss({props:{name:"class huggingface_hub.errors.StrictDataclassDefinitionError",anchor:"huggingface_hub.errors.StrictDataclassDefinitionError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L356"}}),Vs=new Ss({props:{name:"class huggingface_hub.errors.StrictDataclassFieldValidationError",anchor:"huggingface_hub.errors.StrictDataclassFieldValidationError",parameters:[{name:"field",val:": str"},{name:"cause",val:": Exception"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L360"}}),Bs=new w({props:{title:"Why Not Use pydantic ? (or attrs ? or marshmallow_dataclass ?)",local:"why-not-use-pydantic--or-attrs--or-marshmallowdataclass-",headingTag:"h2"}}),Fs=new fe({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/dataclasses.md"}}),{c(){f=i("meta"),C=l(),T=i("p"),M=l(),c(j.$$.fragment),g=l(),c(v.$$.fragment),ea=l(),Y=i("p"),Y.innerHTML=_t,la=l(),c(F.$$.fragment),na=l(),S=i("p"),S.innerHTML=$t,ia=l(),z=i("ul"),z.innerHTML=Zt,pa=l(),c(R.$$.fragment),ra=l(),X=i("ul"),X.innerHTML=Ct,ca=l(),c(Q.$$.fragment),da=l(),c(H.$$.fragment),oa=l(),c(A.$$.fragment),ha=l(),D=i("p"),D.textContent=It,ma=l(),c(q.$$.fragment),ua=l(),L=i("p"),L.textContent=xt,ga=l(),c(P.$$.fragment),ya=l(),K=i("p"),K.textContent=Gt,fa=l(),c(O.$$.fragment),Ma=l(),ss=i("p"),ss.innerHTML=kt,ja=l(),c(as.$$.fragment),ba=l(),c(ts.$$.fragment),wa=l(),es=i("p"),es.innerHTML=Et,Ta=l(),c(ls.$$.fragment),va=l(),ns=i("p"),ns.innerHTML=Nt,Ja=l(),c(is.$$.fragment),Ua=l(),ps=i("p"),ps.innerHTML=Wt,_a=l(),c(rs.$$.fragment),$a=l(),cs=i("p"),cs.innerHTML=Vt,Za=l(),c(ds.$$.fragment),Ca=l(),os=i("p"),os.textContent=Bt,Ia=l(),c(hs.$$.fragment),xa=l(),ms=i("p"),ms.textContent=Yt,Ga=l(),us=i("ul"),us.innerHTML=Ft,ka=l(),gs=i("p"),gs.textContent=St,Ea=l(),c(ys.$$.fragment),Na=l(),fs=i("p"),fs.innerHTML=zt,Wa=l(),Ms=i("p"),Ms.innerHTML=Rt,Va=l(),c(js.$$.fragment),Ba=l(),W=i("blockquote"),W.innerHTML=Xt,Ya=l(),c(bs.$$.fragment),Fa=l(),c(ws.$$.fragment),Sa=l(),Ts=i("p"),Ts.innerHTML=Qt,za=l(),b=i("div"),c(vs.$$.fragment),ht=l(),Rs=i("p"),Rs.textContent=Ht,mt=l(),Xs=i("p"),Xs.innerHTML=At,ut=l(),Qs=i("p"),Qs.textContent=Dt,gt=l(),Hs=i("ul"),Hs.innerHTML=qt,yt=l(),c(V.$$.fragment),Ra=l(),c(Js.$$.fragment),Xa=l(),Us=i("p"),Us.innerHTML=Lt,Qa=l(),_s=i("p"),_s.innerHTML=Pt,Ha=l(),U=i("div"),c($s.$$.fragment),ft=l(),As=i("p"),As.textContent=Kt,Mt=l(),Ds=i("p"),Ds.innerHTML=Ot,jt=l(),c(B.$$.fragment),Aa=l(),c(Zs.$$.fragment),Da=l(),Cs=i("p"),Cs.innerHTML=se,qa=l(),x=i("div"),c(Is.$$.fragment),bt=l(),qs=i("p"),qs.innerHTML=ae,La=l(),c(xs.$$.fragment),Pa=l(),Gs=i("p"),Gs.textContent=te,Ka=l(),_=i("div"),c(ks.$$.fragment),wt=l(),Ls=i("p"),Ls.textContent=ee,Tt=l(),Ps=i("p"),Ps.innerHTML=le,Oa=l(),c(Es.$$.fragment),st=l(),G=i("div"),c(Ns.$$.fragment),vt=l(),Ks=i("p"),Ks.textContent=ne,at=l(),k=i("div"),c(Ws.$$.fragment),Jt=l(),Os=i("p"),Os.textContent=ie,tt=l(),E=i("div"),c(Vs.$$.fragment),Ut=l(),sa=i("p"),sa.textContent=pe,et=l(),c(Bs.$$.fragment),lt=l(),Ys=i("ul"),Ys.innerHTML=re,nt=l(),c(Fs.$$.fragment),it=l(),ta=i("p"),this.h()},l(s){const a=ge("svelte-u9bgzb",document.head);f=p(a,"META",{name:!0,content:!0}),a.forEach(t),C=n(s),T=p(s,"P",{}),N(T).forEach(t),M=n(s),d(j.$$.fragment,s),g=n(s),d(v.$$.fragment,s),ea=n(s),Y=p(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-fulmd4"&&(Y.innerHTML=_t),la=n(s),d(F.$$.fragment,s),na=n(s),S=p(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-10vup0t"&&(S.innerHTML=$t),ia=n(s),z=p(s,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-16ihdp0"&&(z.innerHTML=Zt),pa=n(s),d(R.$$.fragment,s),ra=n(s),X=p(s,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-ot4c4r"&&(X.innerHTML=Ct),ca=n(s),d(Q.$$.fragment,s),da=n(s),d(H.$$.fragment,s),oa=n(s),d(A.$$.fragment,s),ha=n(s),D=p(s,"P",{"data-svelte-h":!0}),r(D)!=="svelte-15zq0bg"&&(D.textContent=It),ma=n(s),d(q.$$.fragment,s),ua=n(s),L=p(s,"P",{"data-svelte-h":!0}),r(L)!=="svelte-i9wly0"&&(L.textContent=xt),ga=n(s),d(P.$$.fragment,s),ya=n(s),K=p(s,"P",{"data-svelte-h":!0}),r(K)!=="svelte-qjvxzo"&&(K.textContent=Gt),fa=n(s),d(O.$$.fragment,s),Ma=n(s),ss=p(s,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-hrd6us"&&(ss.innerHTML=kt),ja=n(s),d(as.$$.fragment,s),ba=n(s),d(ts.$$.fragment,s),wa=n(s),es=p(s,"P",{"data-svelte-h":!0}),r(es)!=="svelte-1lyst51"&&(es.innerHTML=Et),Ta=n(s),d(ls.$$.fragment,s),va=n(s),ns=p(s,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1wuu5e1"&&(ns.innerHTML=Nt),Ja=n(s),d(is.$$.fragment,s),Ua=n(s),ps=p(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-4znjil"&&(ps.innerHTML=Wt),_a=n(s),d(rs.$$.fragment,s),$a=n(s),cs=p(s,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-1byxw61"&&(cs.innerHTML=Vt),Za=n(s),d(ds.$$.fragment,s),Ca=n(s),os=p(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-bve03k"&&(os.textContent=Bt),Ia=n(s),d(hs.$$.fragment,s),xa=n(s),ms=p(s,"P",{"data-svelte-h":!0}),r(ms)!=="svelte-n0jw9t"&&(ms.textContent=Yt),Ga=n(s),us=p(s,"UL",{"data-svelte-h":!0}),r(us)!=="svelte-1ha2ndo"&&(us.innerHTML=Ft),ka=n(s),gs=p(s,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-1ekf0af"&&(gs.textContent=St),Ea=n(s),d(ys.$$.fragment,s),Na=n(s),fs=p(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-1ekgjeq"&&(fs.innerHTML=zt),Wa=n(s),Ms=p(s,"P",{"data-svelte-h":!0}),r(Ms)!=="svelte-jqm6v0"&&(Ms.innerHTML=Rt),Va=n(s),d(js.$$.fragment,s),Ba=n(s),W=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(W)!=="svelte-1ohp30j"&&(W.innerHTML=Xt),Ya=n(s),d(bs.$$.fragment,s),Fa=n(s),d(ws.$$.fragment,s),Sa=n(s),Ts=p(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-ikv26"&&(Ts.innerHTML=Qt),za=n(s),b=p(s,"DIV",{class:!0});var J=N(b);d(vs.$$.fragment,J),ht=n(J),Rs=p(J,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-187aw77"&&(Rs.textContent=Ht),mt=n(J),Xs=p(J,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-u5v2s3"&&(Xs.innerHTML=At),ut=n(J),Qs=p(J,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-1bdscnj"&&(Qs.textContent=Dt),gt=n(J),Hs=p(J,"UL",{"data-svelte-h":!0}),r(Hs)!=="svelte-wwj3n0"&&(Hs.innerHTML=qt),yt=n(J),d(V.$$.fragment,J),J.forEach(t),Ra=n(s),d(Js.$$.fragment,s),Xa=n(s),Us=p(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-1sh2zrg"&&(Us.innerHTML=Lt),Qa=n(s),_s=p(s,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-6xfhp0"&&(_s.innerHTML=Pt),Ha=n(s),U=p(s,"DIV",{class:!0});var $=N(U);d($s.$$.fragment,$),ft=n($),As=p($,"P",{"data-svelte-h":!0}),r(As)!=="svelte-15c5prv"&&(As.textContent=Kt),Mt=n($),Ds=p($,"P",{"data-svelte-h":!0}),r(Ds)!=="svelte-1opa6eo"&&(Ds.innerHTML=Ot),jt=n($),d(B.$$.fragment,$),$.forEach(t),Aa=n(s),d(Zs.$$.fragment,s),Da=n(s),Cs=p(s,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-i7oli7"&&(Cs.innerHTML=se),qa=n(s),x=p(s,"DIV",{class:!0});var rt=N(x);d(Is.$$.fragment,rt),bt=n(rt),qs=p(rt,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-13ombpu"&&(qs.innerHTML=ae),rt.forEach(t),La=n(s),d(xs.$$.fragment,s),Pa=n(s),Gs=p(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-10d5lmm"&&(Gs.textContent=te),Ka=n(s),_=p(s,"DIV",{class:!0});var aa=N(_);d(ks.$$.fragment,aa),wt=n(aa),Ls=p(aa,"P",{"data-svelte-h":!0}),r(Ls)!=="svelte-9l09y7"&&(Ls.textContent=ee),Tt=n(aa),Ps=p(aa,"P",{"data-svelte-h":!0}),r(Ps)!=="svelte-1i7klwo"&&(Ps.innerHTML=le),aa.forEach(t),Oa=n(s),d(Es.$$.fragment,s),st=n(s),G=p(s,"DIV",{class:!0});var ct=N(G);d(Ns.$$.fragment,ct),vt=n(ct),Ks=p(ct,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-10cvrkm"&&(Ks.textContent=ne),ct.forEach(t),at=n(s),k=p(s,"DIV",{class:!0});var dt=N(k);d(Ws.$$.fragment,dt),Jt=n(dt),Os=p(dt,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-9fy9r4"&&(Os.textContent=ie),dt.forEach(t),tt=n(s),E=p(s,"DIV",{class:!0});var ot=N(E);d(Vs.$$.fragment,ot),Ut=n(ot),sa=p(ot,"P",{"data-svelte-h":!0}),r(sa)!=="svelte-6lkx6s"&&(sa.textContent=pe),ot.forEach(t),et=n(s),d(Bs.$$.fragment,s),lt=n(s),Ys=p(s,"UL",{"data-svelte-h":!0}),r(Ys)!=="svelte-tvk7gu"&&(Ys.innerHTML=re),nt=n(s),d(Fs.$$.fragment,s),it=n(s),ta=p(s,"P",{}),N(ta).forEach(t),this.h()},h(){I(f,"name","hf:doc:metadata"),I(f,"content",we),I(W,"class","warning"),I(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,a){y(document.head,f),e(s,C,a),e(s,T,a),e(s,M,a),o(j,s,a),e(s,g,a),o(v,s,a),e(s,ea,a),e(s,Y,a),e(s,la,a),o(F,s,a),e(s,na,a),e(s,S,a),e(s,ia,a),e(s,z,a),e(s,pa,a),o(R,s,a),e(s,ra,a),e(s,X,a),e(s,ca,a),o(Q,s,a),e(s,da,a),o(H,s,a),e(s,oa,a),o(A,s,a),e(s,ha,a),e(s,D,a),e(s,ma,a),o(q,s,a),e(s,ua,a),e(s,L,a),e(s,ga,a),o(P,s,a),e(s,ya,a),e(s,K,a),e(s,fa,a),o(O,s,a),e(s,Ma,a),e(s,ss,a),e(s,ja,a),o(as,s,a),e(s,ba,a),o(ts,s,a),e(s,wa,a),e(s,es,a),e(s,Ta,a),o(ls,s,a),e(s,va,a),e(s,ns,a),e(s,Ja,a),o(is,s,a),e(s,Ua,a),e(s,ps,a),e(s,_a,a),o(rs,s,a),e(s,$a,a),e(s,cs,a),e(s,Za,a),o(ds,s,a),e(s,Ca,a),e(s,os,a),e(s,Ia,a),o(hs,s,a),e(s,xa,a),e(s,ms,a),e(s,Ga,a),e(s,us,a),e(s,ka,a),e(s,gs,a),e(s,Ea,a),o(ys,s,a),e(s,Na,a),e(s,fs,a),e(s,Wa,a),e(s,Ms,a),e(s,Va,a),o(js,s,a),e(s,Ba,a),e(s,W,a),e(s,Ya,a),o(bs,s,a),e(s,Fa,a),o(ws,s,a),e(s,Sa,a),e(s,Ts,a),e(s,za,a),e(s,b,a),o(vs,b,null),y(b,ht),y(b,Rs),y(b,mt),y(b,Xs),y(b,ut),y(b,Qs),y(b,gt),y(b,Hs),y(b,yt),o(V,b,null),e(s,Ra,a),o(Js,s,a),e(s,Xa,a),e(s,Us,a),e(s,Qa,a),e(s,_s,a),e(s,Ha,a),e(s,U,a),o($s,U,null),y(U,ft),y(U,As),y(U,Mt),y(U,Ds),y(U,jt),o(B,U,null),e(s,Aa,a),o(Zs,s,a),e(s,Da,a),e(s,Cs,a),e(s,qa,a),e(s,x,a),o(Is,x,null),y(x,bt),y(x,qs),e(s,La,a),o(xs,s,a),e(s,Pa,a),e(s,Gs,a),e(s,Ka,a),e(s,_,a),o(ks,_,null),y(_,wt),y(_,Ls),y(_,Tt),y(_,Ps),e(s,Oa,a),o(Es,s,a),e(s,st,a),e(s,G,a),o(Ns,G,null),y(G,vt),y(G,Ks),e(s,at,a),e(s,k,a),o(Ws,k,null),y(k,Jt),y(k,Os),e(s,tt,a),e(s,E,a),o(Vs,E,null),y(E,Ut),y(E,sa),e(s,et,a),o(Bs,s,a),e(s,lt,a),e(s,Ys,a),e(s,nt,a),o(Fs,s,a),e(s,it,a),e(s,ta,a),pt=!0},p(s,[a]){const J={};a&2&&(J.$$scope={dirty:a,ctx:s}),V.$set(J);const $={};a&2&&($.$$scope={dirty:a,ctx:s}),B.$set($)},i(s){pt||(h(j.$$.fragment,s),h(v.$$.fragment,s),h(F.$$.fragment,s),h(R.$$.fragment,s),h(Q.$$.fragment,s),h(H.$$.fragment,s),h(A.$$.fragment,s),h(q.$$.fragment,s),h(P.$$.fragment,s),h(O.$$.fragment,s),h(as.$$.fragment,s),h(ts.$$.fragment,s),h(ls.$$.fragment,s),h(is.$$.fragment,s),h(rs.$$.fragment,s),h(ds.$$.fragment,s),h(hs.$$.fragment,s),h(ys.$$.fragment,s),h(js.$$.fragment,s),h(bs.$$.fragment,s),h(ws.$$.fragment,s),h(vs.$$.fragment,s),h(V.$$.fragment,s),h(Js.$$.fragment,s),h($s.$$.fragment,s),h(B.$$.fragment,s),h(Zs.$$.fragment,s),h(Is.$$.fragment,s),h(xs.$$.fragment,s),h(ks.$$.fragment,s),h(Es.$$.fragment,s),h(Ns.$$.fragment,s),h(Ws.$$.fragment,s),h(Vs.$$.fragment,s),h(Bs.$$.fragment,s),h(Fs.$$.fragment,s),pt=!0)},o(s){m(j.$$.fragment,s),m(v.$$.fragment,s),m(F.$$.fragment,s),m(R.$$.fragment,s),m(Q.$$.fragment,s),m(H.$$.fragment,s),m(A.$$.fragment,s),m(q.$$.fragment,s),m(P.$$.fragment,s),m(O.$$.fragment,s),m(as.$$.fragment,s),m(ts.$$.fragment,s),m(ls.$$.fragment,s),m(is.$$.fragment,s),m(rs.$$.fragment,s),m(ds.$$.fragment,s),m(hs.$$.fragment,s),m(ys.$$.fragment,s),m(js.$$.fragment,s),m(bs.$$.fragment,s),m(ws.$$.fragment,s),m(vs.$$.fragment,s),m(V.$$.fragment,s),m(Js.$$.fragment,s),m($s.$$.fragment,s),m(B.$$.fragment,s),m(Zs.$$.fragment,s),m(Is.$$.fragment,s),m(xs.$$.fragment,s),m(ks.$$.fragment,s),m(Es.$$.fragment,s),m(Ns.$$.fragment,s),m(Ws.$$.fragment,s),m(Vs.$$.fragment,s),m(Bs.$$.fragment,s),m(Fs.$$.fragment,s),pt=!1},d(s){s&&(t(C),t(T),t(M),t(g),t(ea),t(Y),t(la),t(na),t(S),t(ia),t(z),t(pa),t(ra),t(X),t(ca),t(da),t(oa),t(ha),t(D),t(ma),t(ua),t(L),t(ga),t(ya),t(K),t(fa),t(Ma),t(ss),t(ja),t(ba),t(wa),t(es),t(Ta),t(va),t(ns),t(Ja),t(Ua),t(ps),t(_a),t($a),t(cs),t(Za),t(Ca),t(os),t(Ia),t(xa),t(ms),t(Ga),t(us),t(ka),t(gs),t(Ea),t(Na),t(fs),t(Wa),t(Ms),t(Va),t(Ba),t(W),t(Ya),t(Fa),t(Sa),t(Ts),t(za),t(b),t(Ra),t(Xa),t(Us),t(Qa),t(_s),t(Ha),t(U),t(Aa),t(Da),t(Cs),t(qa),t(x),t(La),t(Pa),t(Gs),t(Ka),t(_),t(Oa),t(st),t(G),t(at),t(k),t(tt),t(E),t(et),t(lt),t(Ys),t(nt),t(it),t(ta)),t(f),u(j,s),u(v,s),u(F,s),u(R,s),u(Q,s),u(H,s),u(A,s),u(q,s),u(P,s),u(O,s),u(as,s),u(ts,s),u(ls,s),u(is,s),u(rs,s),u(ds,s),u(hs,s),u(ys,s),u(js,s),u(bs,s),u(ws,s),u(vs),u(V),u(Js,s),u($s),u(B),u(Zs,s),u(Is),u(xs,s),u(ks),u(Es,s),u(Ns),u(Ws),u(Vs),u(Bs,s),u(Fs,s)}}}const we='{"title":"Strict Dataclasses","local":"strict-dataclasses","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Benefits","local":"benefits","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Basic Example","local":"basic-example","sections":[],"depth":3},{"title":"Custom Validators","local":"custom-validators","sections":[],"depth":3},{"title":"Additional Keyword Arguments","local":"additional-keyword-arguments","sections":[],"depth":3},{"title":"Integration with Type Hints","local":"integration-with-type-hints","sections":[],"depth":3},{"title":"Class validators","local":"class-validators","sections":[],"depth":3}],"depth":2},{"title":"API Reference","local":"api-reference","sections":[{"title":"@strict","local":"huggingface_hub.dataclasses.strict","sections":[],"depth":3},{"title":"validate_typed_dict","local":"huggingface_hub.dataclasses.validate_typed_dict","sections":[],"depth":3},{"title":"as_validated_field","local":"huggingface_hub.dataclasses.as_validated_field","sections":[],"depth":3},{"title":"validated_field","local":"huggingface_hub.dataclasses.validated_field","sections":[],"depth":3},{"title":"Errors","local":"huggingface_hub.errors.StrictDataclassError","sections":[],"depth":3}],"depth":2},{"title":"Why Not Use pydantic ? (or attrs ? or marshmallow_dataclass ?)","local":"why-not-use-pydantic--or-attrs--or-marshmallowdataclass-","sections":[],"depth":2}],"depth":1}';function Te(zs){return he(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends me{constructor(f){super(),ue(this,f,Te,be,oe,{})}}export{Ie as component};
