import{s as tc,n as lc,o as sc}from"../chunks/scheduler.0cf4ef2e.js";import{S as ac,i as nc,e as m,s as a,c as i,h as ic,a as r,d as l,b as n,f as ec,g as o,j as h,k as y,l as oc,m as s,n as p,t as f,o as d,p as c}from"../chunks/index.abc433bf.js";import{C as pc}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as u}from"../chunks/CodeBlock.18a16f91.js";import{H as g,E as fc}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function dc(Ep){let $,na,sa,ia,C,oa,I,pa,G,zp="The <code>huggingface_hub</code> Python package comes with a built-in CLI called <code>hf</code>. This tool allows you to interact with the Hugging Face Hub directly from a terminal. For example, you can log in to your account, create a repository, upload and download files, etc. It also comes with handy features to configure your machine or manage your cache. In this guide, we will have a look at the main features of the CLI and how to use them.",fa,M,qp=`<p>This guide covers the most important features of the <code>hf</code> CLI.
For a complete reference of all commands and options, see the <a href="../package_reference/cli.md">CLI reference</a>.</p>`,da,_,ca,k,Dp="First of all, let’s install the CLI:",ma,B,ra,w,Op="<p>The CLI ships with the core <code>huggingface_hub</code> package.</p>",ha,x,Kp="Alternatively, you can install the <code>hf</code> CLI with a single command:",ua,H,ef="On macOS and Linux:",ga,L,ya,Z,tf="On Windows:",$a,Y,Ma,W,lf="Once installed, you can check that the CLI is correctly setup:",wa,X,ba,R,sf='If the CLI is correctly installed, you should see a list of all the options available in the CLI. If you get an error message such as <code>command not found: hf</code>, please refer to the <a href="../installation">Installation</a> guide.',Ta,b,af="<p>The <code>--help</code> option is very convenient for getting more details about a command. You can use it anytime to list all available options and their details. For example, <code>hf upload --help</code> provides more information on how to upload files using the CLI.</p>",ja,N,va,F,Ja,V,nf='You can install and run the <code>hf</code> CLI with <a href="https://docs.astral.sh/uv/" rel="nofollow">uv</a>.',Ua,S,of="Make sure uv is installed (adds <code>uv</code> and <code>uvx</code> to your PATH):",Ca,A,Ia,Q,pf="Then install the CLI globally and use it anywhere:",Ga,P,_a,E,ff="Alternatively, run the CLI ephemerally with <code>uvx</code> (no global install):",ka,z,Ba,q,xa,D,df='You can also install the CLI using <a href="https://brew.sh/" rel="nofollow">Homebrew</a>:',Ha,O,La,K,cf='Check out the Homebrew huggingface page <a href="https://formulae.brew.sh/formula/huggingface-cli" rel="nofollow">here</a> for more details.',Za,ee,Ya,te,mf='In many cases, you must be logged in to a Hugging Face account to interact with the Hub (download private repos, upload files, create PRs, etc.). To do so, you need a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a> from your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Settings page</a>. The User Access Token is used to authenticate your identity to the Hub. Make sure to set a token with write access if you want to upload or modify content.',Wa,le,rf="Once you have your token, run the following command in your terminal:",Xa,se,Ra,ae,hf="This command will prompt you for a token. Copy-paste yours and press <em>Enter</em>. Then, you’ll be asked if the token should also be saved as a git credential. Press <em>Enter</em> again (default to yes) if you plan to use <code>git</code> locally. Finally, it will call the Hub to check that your token is valid and save it locally.",Na,ne,Fa,ie,uf="Alternatively, if you want to log-in without being prompted, you can pass the token directly from the command line. To be more secure, we recommend passing your token as an environment variable to avoid pasting it in your command history.",Va,oe,Sa,pe,gf='For more details about authentication, check out <a href="../quick-start#authentication">this section</a>.',Aa,fe,Qa,de,yf="If you want to know if you are logged in, you can use <code>hf auth whoami</code>. This command doesn’t have any options and simply prints your username and the organizations you are a part of on the Hub:",Pa,ce,Ea,me,$f="If you are not logged in, an error message will be printed.",za,re,qa,he,Mf="This command logs you out. In practice, it will delete all tokens stored on your machine. If you want to remove a specific token, you can specify the token name as an argument.",Da,ue,wf='This command will not log you out if you are logged in using the <code>HF_TOKEN</code> environment variable (see <a href="../package_reference/environment_variables#hftoken">reference</a>). If that is the case, you must unset the environment variable in your machine configuration.',Oa,ge,Ka,ye,bf='Use the <code>hf download</code> command to download files from the Hub directly. Internally, it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described in the <a href="./download">Download</a> guide and prints the returned path to the terminal. In the examples below, we will walk through the most common use cases. For a full list of available options, you can run:',en,$e,tn,Me,ln,we,Tf="To download a single file from a repo, simply provide the repo_id and filename as follows:",sn,be,an,Te,jf="The command will always print on the last line the path to the file on your local machine.",nn,je,vf="To download a file located in a subdirectory of the repo, you should provide the path of the file in the repo in posix format like this:",on,ve,pn,Je,fn,Ue,Jf="In some cases, you just want to download all the files from a repository. This can be done by just specifying the repo id:",dn,Ce,cn,Ie,mn,Ge,Uf="You can also download a subset of the files from a repository with a single command. This can be done in two ways. If you already have a precise list of the files you want to download, you can simply provide them sequentially:",rn,_e,hn,ke,Cf='The other approach is to provide patterns to filter which files you want to download using <code>--include</code> and <code>--exclude</code>. For example, if you want to download all safetensors files from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>, except the files in FP16 precision:',un,Be,gn,xe,yn,He,If="The examples above show how to download from a model repository. To download a dataset or a Space, use the <code>--repo-type</code> option:",$n,Le,Mn,Ze,wn,Ye,Gf="The examples above show how to download from the latest commit on the main branch. To download from a specific revision (commit hash, branch name or tag), use the <code>--revision</code> option:",bn,We,Tn,Xe,jn,Re,_f="The recommended (and default) way to download files from the Hub is to use the cache-system. However, in some cases you want to download files and move them to a specific folder. This is useful to get a workflow closer to what git commands offer. You can do that using the <code>--local-dir</code> option.",vn,Ne,kf="A <code>.cache/huggingface/</code> folder is created at the root of your local directory containing metadata about the downloaded files. This prevents re-downloading files if they’re already up-to-date. If the metadata has changed, then the new file version is downloaded. This makes the <code>local-dir</code> optimized for pulling only the latest changes.",Jn,T,Bf='<p>For more details on how downloading to a local file works, check out the <a href="./download#download-files-to-a-local-folder">download</a> guide.</p>',Un,Fe,Cn,Ve,In,Se,xf="In some cases, you would like to check which files would be downloaded before actually downloading them. You can check this using the <code>--dry-run</code> parameter. It lists all files to download on the repo and checks whether they are already downloaded or not. This gives an idea of how many files have to be downloaded and their sizes.",Gn,Ae,_n,Qe,Hf='For more details, check out the <a href="./download.md#dry-run-mode">download guide</a>.',kn,Pe,Bn,Ee,Lf='If not using <code>--local-dir</code>, all files will be downloaded by default to the cache directory defined by the <code>HF_HOME</code> <a href="../package_reference/environment_variables#hfhome">environment variable</a>. You can specify a custom cache using <code>--cache-dir</code>:',xn,ze,Hn,qe,Ln,De,Zf="To access private or gated repositories, you must use a token. By default, the token saved locally (using <code>hf auth login</code>) will be used. If you want to authenticate explicitly, use the <code>--token</code> option:",Zn,Oe,Yn,Ke,Wn,et,Yf="By default, the <code>hf download</code> command will be verbose. It will print details such as warning messages, information about the downloaded files, and progress bars. If you want to silence all of this, use the <code>--quiet</code> option. Only the last line (i.e. the path to the downloaded files) is printed. This can prove useful if you want to pass the output to another command in a script.",Xn,tt,Rn,lt,Nn,st,Wf="On machines with slow connections, you might encounter timeout issues like this one:",Fn,at,Vn,nt,Xf="To mitigate this issue, you can set the <code>HF_HUB_DOWNLOAD_TIMEOUT</code> environment variable to a higher value (default is 10):",Sn,it,An,ot,Rf='For more details, check out the <a href="../package_reference/environment_variables#hfhubdownloadtimeout">environment variables reference</a>. And rerun your download command.',Qn,pt,Pn,ft,Nf='Use the <code>hf upload</code> command to upload files to the Hub directly. Internally, it uses the same <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file">upload_file()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder">upload_folder()</a> helpers described in the <a href="./upload">Upload</a> guide. In the examples below, we will walk through the most common use cases. For a full list of available options, you can run:',En,dt,zn,ct,qn,mt,Ff="The default usage for this command is:",Dn,rt,On,ht,Vf="To upload the current directory at the root of the repo, use:",Kn,ut,ei,j,Sf="<p>If the repo doesn’t exist yet, it will be created automatically.</p>",ti,gt,Af="You can also upload a specific folder:",li,yt,si,$t,Qf="Finally, you can upload a folder to a specific destination on the repo:",ai,Mt,ni,wt,ii,bt,Pf="You can also upload a single file by setting <code>local_path</code> to point to a file on your machine. If that’s the case, <code>path_in_repo</code> is optional and will default to the name of your local file:",oi,Tt,pi,jt,Ef="If you want to upload a single file to a specific directory, set <code>path_in_repo</code> accordingly:",fi,vt,di,Jt,ci,Ut,zf="To upload multiple files from a folder at once without uploading the entire folder, use the <code>--include</code> and <code>--exclude</code> patterns. It can also be combined with the <code>--delete</code> option to delete files on the repo while uploading new ones. In the example below, we sync the local Space by deleting remote files and uploading all files except the ones in <code>/logs</code>:",mi,Ct,ri,It,hi,Gt,qf="To upload to a dataset or a Space, use the <code>--repo-type</code> option:",ui,_t,gi,kt,yi,Bt,Df="To upload content to a repo owned by an organization instead of a personal repo, you must explicitly specify it in the <code>repo_id</code>:",$i,xt,Mi,Ht,wi,Lt,Of="By default, files are uploaded to the <code>main</code> branch. If you want to upload files to another branch or reference, use the <code>--revision</code> option:",bi,Zt,Ti,Yt,Kf="<strong>Note:</strong> if <code>revision</code> does not exist and <code>--create-pr</code> is not set, a branch will be created automatically from the <code>main</code> branch.",ji,Wt,vi,Xt,ed="If you don’t have the permission to push to a repo, you must open a PR and let the authors know about the changes you want to make. This can be done by setting the <code>--create-pr</code> option:",Ji,Rt,Ui,Nt,Ci,Ft,td="In some cases, you might want to push regular updates to a repo. For example, this is useful if you’re training a model and you want to upload the logs folder every 10 minutes. You can do this using the <code>--every</code> option:",Ii,Vt,Gi,St,_i,At,ld="Use the <code>--commit-message</code> and <code>--commit-description</code> to set a custom message and description for your commit instead of the default one",ki,Qt,Bi,Pt,xi,Et,sd="To upload files, you must use a token. By default, the token saved locally (using <code>hf auth login</code>) will be used. If you want to authenticate explicitly, use the <code>--token</code> option:",Hi,zt,Li,qt,Zi,Dt,ad="By default, the <code>hf upload</code> command will be verbose. It will print details such as warning messages, information about the uploaded files, and progress bars. If you want to silence all of this, use the <code>--quiet</code> option. Only the last line (i.e. the URL to the uploaded files) is printed. This can prove useful if you want to pass the output to another command in a script.",Yi,Ot,Wi,Kt,Xi,el,nd="<code>hf repo</code> lets you create, delete, move repositories and update their settings on the Hugging Face Hub. It also includes subcommands to manage branches and tags.",Ri,tl,Ni,ll,Fi,sl,id="Create a private dataset or a Space:",Vi,al,Si,nl,od="Use <code>--exist-ok</code> if the repo may already exist, and <code>--resource-group-id</code> to target an Enterprise resource group.",Ai,il,Qi,ol,Pi,pl,pd="Datasets and Spaces:",Ei,fl,zi,dl,qi,cl,Di,ml,Oi,rl,Ki,hl,fd="<li><code>--gated</code>: one of <code>auto</code>, <code>manual</code>, <code>false</code></li> <li><code>--private true|false</code>: set repository privacy</li>",eo,ul,to,gl,lo,v,dd="<p>All commands accept <code>--repo-type</code> (one of <code>model</code>, <code>dataset</code>, <code>space</code>) and <code>--token</code> if you need to authenticate explicitly. Use <code>--help</code> on any command to see all options.</p>",so,yl,ao,$l,cd="If you want to delete files from a Hugging Face repository, use the <code>hf repo-files</code> command.",no,Ml,io,wl,md="The <code>hf repo-files delete &lt;repo_id&gt;</code> sub-command allows you to delete files from a repository. Here are some usage examples.",oo,bl,rd="Delete a folder :",po,Tl,fo,jl,hd="Delete multiple files:",co,vl,mo,Jl,ud="Use Unix-style wildcards to delete sets of files:",ro,Ul,ho,Cl,uo,Il,gd="To delete files from a repo you must be authenticated and authorized. By default, the token saved locally (using <code>hf auth login</code>) will be used. If you want to authenticate explicitly, use the <code>--token</code> option:",go,Gl,yo,_l,$o,kl,yd="Use <code>hf cache ls</code> to inspect what is stored locally in your Hugging Face cache. By default it aggregates information by repository:",Mo,Bl,wo,xl,$d="Add <code>--revisions</code> to drill down to specific snapshots, and chain filters to focus on what matters:",bo,Hl,To,Ll,Md='The command supports several output formats for scripting: <code>--format json</code> prints structured objects, <code>--format csv</code> writes comma-separated rows, and <code>--quiet</code> prints only IDs. Combine these with <code>--cache-dir</code> to target alternative cache locations. See the <a href="./manage-cache">Manage your cache</a> guide for advanced workflows.',jo,Zl,wd="Delete cache entries selected with <code>hf cache ls --q</code> by piping the IDs into <code>hf cache rm</code>:",vo,Yl,Jo,Wl,Uo,Xl,bd="<code>hf cache rm</code> removes cached repositories or individual revisions. Pass one or more repo IDs (<code>model/bert-base-uncased</code>) or revision hashes:",Co,Rl,Io,Nl,Td="Mix repositories and specific revisions in the same call. Use <code>--dry-run</code> to preview the impact, or <code>--yes</code> to skip the confirmation prompt—handy in automated scripts:",Go,Fl,_o,Vl,jd="When working outside the default cache location, pair the command with <code>--cache-dir PATH</code>.",ko,Sl,Bo,Al,vd="<code>hf cache prune</code> is a convenience shortcut that deletes every detached (unreferenced) revision in your cache. This keeps only revisions that are still reachable through a branch or tag:",xo,Ql,Ho,Pl,Jd='As with the other cache commands, <code>--dry-run</code>, <code>--yes</code>, and <code>--cache-dir</code> are available. Refer to the <a href="./manage-cache">Manage your cache</a> guide for more examples.',Lo,El,Zo,zl,Ud="The <code>hf repo tag create</code> command allows you to tag, untag, and list tags for repositories.",Yo,ql,Wo,Dl,Cd="To tag a repo, you need to provide the <code>repo_id</code> and the <code>tag</code> name:",Xo,Ol,Ro,Kl,No,es,Id="If you want to tag a specific revision, you can use the <code>--revision</code> option. By default, the tag will be created on the <code>main</code> branch:",Fo,ts,Vo,ls,So,ss,Gd="If you want to tag a dataset or Space, you must specify the <code>--repo-type</code> option:",Ao,as,Qo,ns,Po,is,_d="To list all tags for a repository, use the <code>-l</code> or <code>--list</code> option:",Eo,os,zo,ps,qo,fs,kd="To delete a tag, use the <code>-d</code> or <code>--delete</code> option:",Do,ds,Oo,cs,Bd="You can also pass <code>-y</code> to skip the confirmation step.",Ko,ms,ep,rs,xd='The <code>hf env</code> command prints details about your machine setup. This is useful when you open an issue on <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">GitHub</a> to help the maintainers investigate your problem.',tp,hs,lp,us,sp,gs,Hd="Run compute jobs on Hugging Face infrastructure with a familiar Docker-like interface.",ap,ys,Ld="<code>hf jobs</code> is a command-line tool that lets you run anything on Hugging Face’s infrastructure (including GPUs and TPUs!) with simple commands. Think <code>docker run</code>, but for running code on A100s.",np,$s,ip,Ms,op,ws,Zd="<li>🐳 <strong>Docker-like CLI</strong>: Familiar commands (<code>run</code>, <code>ps</code>, <code>logs</code>, <code>inspect</code>) to run and manage jobs</li> <li>🔥 <strong>Any Hardware</strong>: From CPUs to A100 GPUs and TPU pods - switch with a simple flag</li> <li>📦 <strong>Run Anything</strong>: Use Docker images, HF Spaces, or your custom containers</li> <li>🔐 <strong>Simple Auth</strong>: Just use your HF token</li> <li>📊 <strong>Live Monitoring</strong>: Stream logs in real-time, just like running locally</li> <li>💰 <strong>Pay-as-you-go</strong>: Only pay for the seconds you use</li>",pp,J,Yd='<p><strong>Hugging Face Jobs</strong> are available only to <a href="https://huggingface.co/pro" rel="nofollow">Pro users</a> and <a href="https://huggingface.co/enterprise" rel="nofollow">Team or Enterprise organizations</a>. Upgrade your plan to get started!</p>',fp,bs,dp,Ts,cp,js,mp,vs,Wd="This command runs the job and shows the logs. You can pass <code>--detach</code> to run the Job in the background and only print the Job ID.",rp,Js,hp,Us,up,Cs,gp,Is,Xd="You can also run jobs on GPUs or TPUs with the <code>--flavor</code> option. For example, to run a PyTorch job on an A10G GPU:",yp,Gs,$p,_s,Rd="Running this will show the following output!",Mp,ks,wp,Bs,Nd="That’s it! You’re now running code on Hugging Face’s infrastructure.",bp,xs,Tp,Hs,Fd="<li><strong>Model Training</strong>: Fine-tune or train models on GPUs (T4, A10G, A100) without managing infrastructure</li> <li><strong>Synthetic Data Generation</strong>: Generate large-scale datasets using LLMs on powerful hardware</li> <li><strong>Data Processing</strong>: Process massive datasets with high-CPU configurations for parallel workloads</li> <li><strong>Batch Inference</strong>: Run offline inference on thousands of samples using optimized GPU setups</li> <li><strong>Experiments &amp; Benchmarks</strong>: Run ML experiments on consistent hardware for reproducible results</li> <li><strong>Development &amp; Debugging</strong>: Test GPU code without local CUDA setup</li>",jp,Ls,vp,Zs,Vd="You can pass environment variables to your job using",Jp,Ys,Up,Ws,Cp,Xs,Ip,Rs,Gp,U,Sd=`<p>Use <code>--secrets HF_TOKEN</code> to pass your local Hugging Face token implicitly.
With this syntax, the secret is retrieved from the environment variable.
For <code>HF_TOKEN</code>, it may read the token file located in the Hugging Face home folder if the environment variable is unset.</p>`,_p,Ns,kp,Fs,Ad="Available <code>--flavor</code> options:",Bp,Vs,Qd="<li>CPU: <code>cpu-basic</code>, <code>cpu-upgrade</code></li> <li>GPU: <code>t4-small</code>, <code>t4-medium</code>, <code>l4x1</code>, <code>l4x4</code>, <code>a10g-small</code>, <code>a10g-large</code>, <code>a10g-largex2</code>, <code>a10g-largex4</code>,<code>a100-large</code></li> <li>TPU: <code>v5e-1x1</code>, <code>v5e-2x2</code>, <code>v5e-2x4</code></li>",xp,Ss,Pd='(updated in 07/2025 from Hugging Face <a href="https://huggingface.co/docs/hub/en/spaces-config-reference" rel="nofollow">suggested_hardware docs</a>)',Hp,As,Lp,Qs,Ed="Run UV scripts (Python scripts with inline dependencies) on HF infrastructure:",Zp,Ps,Yp,Es,zd='UV scripts are Python scripts that include their dependencies directly in the file using a special comment syntax. This makes them perfect for self-contained tasks that don’t require complex project setups. Learn more about UV scripts in the <a href="https://docs.astral.sh/uv/guides/scripts/" rel="nofollow">UV documentation</a>.',Wp,zs,Xp,qs,qd="Schedule and manage jobs that will run on HF infrastructure.",Rp,Ds,Dd="The schedule should be one of <code>@annually</code>, <code>@yearly</code>, <code>@monthly</code>, <code>@weekly</code>, <code>@daily</code>, <code>@hourly</code>, or a CRON schedule expression (e.g., <code>&quot;0 9 * * 1&quot;</code> for 9 AM every Monday).",Np,Os,Fp,Ks,Od="Use the same parameters as <code>hf jobs run</code> to pass environment variables, secrets, timeout, etc.",Vp,ea,Kd="Manage scheduled jobs using",Sp,ta,Ap,la,Qp,aa,Pp;return C=new pc({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new g({props:{title:"Command Line Interface (CLI)",local:"command-line-interface-cli",headingTag:"h1"}}),_=new g({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),B=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwJTIyaHVnZ2luZ2ZhY2VfaHViJTIy",highlighted:'<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pip install -U <span class="hljs-string">&quot;huggingface_hub&quot;</span></span>',wrap:!1}}),L=new u({props:{code:"Y3VybCUyMC1Mc1NmJTIwaHR0cHMlM0ElMkYlMkZoZi5jbyUyRmNsaSUyRmluc3RhbGwuc2glMjAlN0MlMjBiYXNo",highlighted:"&gt;&gt;&gt; curl -LsSf https://hf.co/cli/install.sh | bash",wrap:!1}}),Y=new u({props:{code:"cG93ZXJzaGVsbCUyMC1FeGVjdXRpb25Qb2xpY3klMjBCeVBhc3MlMjAtYyUyMCUyMmlybSUyMGh0dHBzJTNBJTJGJTJGaGYuY28lMkZjbGklMkZpbnN0YWxsLnBzMSUyMCU3QyUyMGlleCUyMg==",highlighted:'&gt;&gt;&gt; powershell <span class="hljs-literal">-ExecutionPolicy</span> ByPass <span class="hljs-literal">-c</span> <span class="hljs-string">&quot;irm https://hf.co/cli/install.ps1 | iex&quot;</span>',wrap:!1}}),X=new u({props:{code:"aGYlMjAtLWhlbHAlMEElMEElMEE=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-comment">--help</span>
Usage: hf [OPTIONS] COMMAND [ARGS]...

  Hugging Face Hub CLI

Options:
  <span class="hljs-comment">--install-completion  Install completion for the current shell.</span>
  <span class="hljs-comment">--show-completion     Show completion for the current shell, to copy it or</span>
                        customize <span class="hljs-keyword">the</span> installation.
  <span class="hljs-comment">--help                Show this message and exit.</span>

Commands:
  auth                 Manage authentication (login, logout, etc.).
  cache                Manage <span class="hljs-built_in">local</span> cache <span class="hljs-built_in">directory</span>.
  download             Download <span class="hljs-built_in">files</span> <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> Hub.
  env                  Print information about <span class="hljs-keyword">the</span> environment.
  jobs                 Run <span class="hljs-keyword">and</span> manage Jobs <span class="hljs-keyword">on</span> <span class="hljs-title">the</span> <span class="hljs-title">Hub</span>.
  repo                 Manage repos <span class="hljs-keyword">on</span> <span class="hljs-title">the</span> <span class="hljs-title">Hub</span>.
  repo-<span class="hljs-built_in">files</span>           Manage <span class="hljs-built_in">files</span> <span class="hljs-keyword">in</span> <span class="hljs-keyword">a</span> repo <span class="hljs-keyword">on</span> <span class="hljs-title">the</span> <span class="hljs-title">Hub</span>.
  upload               Upload <span class="hljs-keyword">a</span> <span class="hljs-built_in">file</span> <span class="hljs-keyword">or</span> <span class="hljs-keyword">a</span> <span class="hljs-built_in">folder</span> <span class="hljs-built_in">to</span> <span class="hljs-keyword">the</span> Hub.
  upload-large-<span class="hljs-built_in">folder</span>  Upload <span class="hljs-keyword">a</span> large <span class="hljs-built_in">folder</span> <span class="hljs-built_in">to</span> <span class="hljs-keyword">the</span> Hub.
  <span class="hljs-built_in">version</span>              Print information about <span class="hljs-keyword">the</span> hf <span class="hljs-built_in">version</span>.`,wrap:!1}}),N=new g({props:{title:"Other installation methods",local:"other-installation-methods",headingTag:"h3"}}),F=new g({props:{title:"Using uv",local:"using-uv",headingTag:"h4"}}),A=new u({props:{code:"Y3VybCUyMC1Mc1NmJTIwaHR0cHMlM0ElMkYlMkZhc3RyYWwuc2glMkZ1diUyRmluc3RhbGwuc2glMjAlN0MlMjBzaA==",highlighted:"&gt;&gt;&gt; curl -LsSf https://astral.sh/uv/install.sh | sh",wrap:!1}}),P=new u({props:{code:"dXYlMjB0b29sJTIwaW5zdGFsbCUyMCUyMmh1Z2dpbmdmYWNlX2h1YiUyMiUwQWhmJTIwYXV0aCUyMHdob2FtaQ==",highlighted:`&gt;&gt;&gt; uv tool install <span class="hljs-string">&quot;huggingface_hub&quot;</span>
&gt;&gt;&gt; hf auth <span class="hljs-built_in">whoami</span>`,wrap:!1}}),z=new u({props:{code:"dXZ4JTIwLS1mcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaGYlMjBhdXRoJTIwd2hvYW1p",highlighted:'&gt;&gt;&gt; uvx --from huggingface_hub hf auth <span class="hljs-built_in">whoami</span>',wrap:!1}}),q=new g({props:{title:"Using Homebrew",local:"using-homebrew",headingTag:"h4"}}),O=new u({props:{code:"YnJldyUyMGluc3RhbGwlMjBodWdnaW5nZmFjZS1jbGk=",highlighted:"&gt;&gt;&gt; brew install huggingface-cli",wrap:!1}}),ee=new g({props:{title:"hf auth login",local:"hf-auth-login",headingTag:"h2"}}),se=new u({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:"&gt;&gt;&gt; hf auth login",wrap:!1}}),ne=new u({props:{code:"XyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQV8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMEFfJTdDXyU3Q18lN0NfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0MlMEFfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTBBXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUwQVRvJTIwbG9nJTIwaW4lMkMlMjAlNjBodWdnaW5nZmFjZV9odWIlNjAlMjByZXF1aXJlcyUyMGElMjB0b2tlbiUyMGdlbmVyYXRlZCUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMlMjAuJTBBRW50ZXIlMjB5b3VyJTIwdG9rZW4lMjAoaW5wdXQlMjB3aWxsJTIwbm90JTIwYmUlMjB2aXNpYmxlKSUzQSUwQUFkZCUyMHRva2VuJTIwYXMlMjBnaXQlMjBjcmVkZW50aWFsJTNGJTIwKFklMkZuKSUwQVRva2VuJTIwaXMlMjB2YWxpZCUyMChwZXJtaXNzaW9uJTNBJTIwd3JpdGUpLiUwQVlvdXIlMjB0b2tlbiUyMGhhcyUyMGJlZW4lMjBzYXZlZCUyMGluJTIweW91ciUyMGNvbmZpZ3VyZWQlMjBnaXQlMjBjcmVkZW50aWFsJTIwaGVscGVycyUyMChzdG9yZSkuJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZob21lJTJGd2F1cGxpbiUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGdG9rZW4lMEFMb2dpbiUyMHN1Y2Nlc3NmdWw=",highlighted:`<span class="hljs-keyword">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|          <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|            <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|
<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|      <span class="hljs-type">_</span>|        <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|    <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|  <span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|<span class="hljs-type">_</span>|

<span class="hljs-type">To</span> log <span class="hljs-built_in">in</span>, \`huggingface_hub\` requires a token generated from https://huggingface.co/settings/tokens .
Enter your token (input will not be visible):
<span class="hljs-keyword">Add</span> token <span class="hljs-built_in">as</span> git credential? (Y/n)
Token is valid (permission: write).
Your token has been saved <span class="hljs-built_in">in</span> your configured git credential helpers (store).
Your token has been saved to /home/wauplin/.cache/huggingface/token
Login successful`,wrap:!1}}),oe=new u({props:{code:"aGYlMjBhdXRoJTIwbG9naW4lMjAtLXRva2VuJTIwJTI0SEZfVE9LRU4lMjAtLWFkZC10by1naXQtY3JlZGVudGlhbA==",highlighted:`<span class="hljs-comment"># Or using an environment variable</span>
&gt;&gt;&gt; hf auth login --token <span class="hljs-variable">$HF_TOKEN</span> --add-to-git-credential
Token is valid (permission: write).
The token \`token_name\` has been saved to /home/wauplin/.cache/huggingface/stored_tokens
Your token has been saved <span class="hljs-keyword">in</span> your configured git credential helpers (store).
Your token has been saved to /home/wauplin/.cache/huggingface/token
Login successful
The current active token is: \`token_name\``,wrap:!1}}),fe=new g({props:{title:"hf auth whoami",local:"hf-auth-whoami",headingTag:"h2"}}),ce=new u({props:{code:"aGYlMjBhdXRoJTIwd2hvYW1pJTBBV2F1cGxpbiUwQW9yZ3MlM0ElMjAlMjBodWdnaW5nZmFjZSUyQ2V1LXRlc3QlMkNPQXV0aFRlc3RlcnMlMkNoZi1hY2NlbGVyYXRlJTJDSEZTbW9sQ2x1c3Rlcg==",highlighted:`hf auth <span class="hljs-built_in">whoami</span>
Wauplin
orgs:  huggingface,eu-test,OAuthTesters,hf-accelerate,HFSmolCluster`,wrap:!1}}),re=new g({props:{title:"hf auth logout",local:"hf-auth-logout",headingTag:"h2"}}),ge=new g({props:{title:"hf download",local:"hf-download",headingTag:"h2"}}),$e=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMC0taGVscA==",highlighted:'hf download --<span class="hljs-built_in">help</span>',wrap:!1}}),Me=new g({props:{title:"Download a single file",local:"download-a-single-file",headingTag:"h3"}}),be=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbg==",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json
downloading https://huggingface.co/gpt2/resolve/main/config.json to /home/wauplin/.cache/huggingface/hub/tmpwrq8dm5o
(…)ingface.co/gpt2/resolve/main/config.json: 100%|██████████████████████████████████| 665/665 [00:00&lt;00:00, 2.49MB/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),ve=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMEhpRHJlYW0tYWklMkZIaURyZWFtLUkxLUZ1bGwlMjB0ZXh0X2VuY29kZXIlMkZtb2RlbC5zYWZldGVuc29ycw==",highlighted:"&gt;&gt;&gt; hf download HiDream-ai/HiDream-I1-Full text_encoder/model.safetensors",wrap:!1}}),Je=new g({props:{title:"Download an entire repository",local:"download-an-entire-repository",headingTag:"h3"}}),Ce=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMEh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YQ==",highlighted:`&gt;&gt;&gt; hf download HuggingFaceH4/zephyr-7b-beta
Fetching 23 files:   0%|                                                | 0/23 [00:00&lt;?, ?it/s]
...
...
/home/wauplin/.cache/huggingface/hub/models--HuggingFaceH4--zephyr-7b-beta/snapshots/3bac358730f8806e5c3dc7c7e19eb36e045bf720`,wrap:!1}}),Ie=new g({props:{title:"Download multiple files",local:"download-multiple-files",headingTag:"h3"}}),_e=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMG1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json model.safetensors
Fetching 2 files:   0%|                                                                        | 0/2 [00:00&lt;?, ?it/s]
downloading https://huggingface.co/gpt2/resolve/11c5a3d5811f50298f278a704980280950aedb10/model.safetensors to /home/wauplin/.cache/huggingface/hub/tmpdachpl3o
(…)8f278a7049802950aedb10/model.safetensors: 100%|██████████████████████████████| 8.09k/8.09k [00:00&lt;00:00, 40.5MB/s]
Fetching 2 files: 100%|████████████████████████████████████████████████████████████████| 2/2 [00:00&lt;00:00,  3.76it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),Be=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMHN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMC0taW5jbHVkZSUyMCUyMiouc2FmZXRlbnNvcnMlMjIlMjAtLWV4Y2x1ZGUlMjAlMjIqLmZwMTYuKiUyMio=",highlighted:`&gt;&gt;&gt; hf download stabilityai/stable-diffusion-xl-base-1.0 --include <span class="hljs-string">&quot;*.safetensors&quot;</span> --exclude <span class="hljs-string">&quot;*.fp16.*&quot;</span>*
Fetching 8 files:   0%|                                                                         | 0/8 [00:00&lt;?, ?it/s]
...
...
Fetching 8 files: 100%|█████████████████████████████████████████████████████████████████████████| 8/8 (...)
/home/wauplin/.cache/huggingface/hub/models--stabilityai--stable-diffusion-xl-base-1.0/snapshots/462165984030d82259a11f4367a4eed129e94a7b`,wrap:!1}}),xe=new g({props:{title:"Download a dataset or a Space",local:"download-a-dataset-or-a-space",headingTag:"h3"}}),Le=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMEh1Z2dpbmdGYWNlSDQlMkZ1bHRyYWNoYXRfMjAwayUyMC0tcmVwby10eXBlJTIwZGF0YXNldCUwQSUwQWhmJTIwZG93bmxvYWQlMjBIdWdnaW5nRmFjZUg0JTJGemVwaHlyLWNoYXQlMjAtLXJlcG8tdHlwZSUyMHNwYWNlJTBB",highlighted:`<span class="hljs-comment"># https://huggingface.co/datasets/HuggingFaceH4/ultrachat_200k</span>
&gt;&gt;&gt; hf download HuggingFaceH4/ultrachat_200k --repo-type dataset

<span class="hljs-comment"># https://huggingface.co/spaces/HuggingFaceH4/zephyr-chat</span>
&gt;&gt;&gt; hf download HuggingFaceH4/zephyr-chat --repo-type space

...`,wrap:!1}}),Ze=new g({props:{title:"Download a specific revision",local:"download-a-specific-revision",headingTag:"h3"}}),We=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGJpZ2NvZGUlMkZ0aGUtc3RhY2slMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjAtLXJldmlzaW9uJTIwdjEuMQ==",highlighted:`&gt;&gt;&gt; hf download bigcode/the-stack --repo-type dataset --revision v1.1
...`,wrap:!1}}),Xe=new g({props:{title:"Download to a local folder",local:"download-to-a-local-folder",headingTag:"h3"}}),Fe=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGFkZXB0JTJGZnV5dS04YiUyMG1vZGVsLTAwMDAxLW9mLTAwMDAyLnNhZmV0ZW5zb3JzJTIwLS1sb2NhbC1kaXIlMjBmdXl1",highlighted:`&gt;&gt;&gt; hf download adept/fuyu-8b model-00001-of-00002.safetensors --local-dir fuyu
...
fuyu/model-00001-of-00002.safetensors`,wrap:!1}}),Ve=new g({props:{title:"Dry-run mode",local:"dry-run-mode",headingTag:"h3"}}),Ae=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwLS1kcnktcnVu",highlighted:`&gt;&gt;&gt; hf download openai-community/gpt2 --dry-run
[dry-run] Fetching 26 files: 100%|█████████████| 26/26 [00:04&lt;00:00,  6.26it/s]
[dry-run] Will download 11 files (out of 26) totalling 5.6G.
File                              Bytes to download
--------------------------------- -----------------
.gitattributes                    -
64-8bits.tflite                   125.2M
64-fp16.tflite                    248.3M
64.tflite                         495.8M
README.md                         -
config.json                       -
flax_model.msgpack                497.8M
generation_config.json            -
merges.txt                        -
model.safetensors                 548.1M
onnx/config.json                  -
onnx/decoder_model.onnx           653.7M
onnx/decoder_model_merged.onnx    655.2M
onnx/decoder_with_past_model.onnx 653.7M
onnx/generation_config.json       -
onnx/merges.txt                   -
onnx/special_tokens_map.json      -
onnx/tokenizer.json               -
onnx/tokenizer_config.json        -
onnx/vocab.json                   -
pytorch_model.bin                 548.1M
rust_model.ot                     702.5M
tf_model.h5                       497.9M
tokenizer.json                    -
tokenizer_config.json             -
vocab.json                        -`,wrap:!1}}),Pe=new g({props:{title:"Specify cache directory",local:"specify-cache-directory",headingTag:"h3"}}),ze=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGFkZXB0JTJGZnV5dS04YiUyMC0tY2FjaGUtZGlyJTIwLiUyRnBhdGglMkZ0byUyRmNhY2hl",highlighted:`&gt;&gt;&gt; hf download adept/fuyu-8b --cache-dir ./path/to/cache
...
./path/to/cache/models--adept--fuyu-8b/snapshots/ddcacbcf5fdf9cc59ff01f6be6d6662624d9c745`,wrap:!1}}),qe=new g({props:{title:"Specify a token",local:"specify-a-token",headingTag:"h3"}}),Oe=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMC0tdG9rZW4lM0RoZl8qKioq",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json --token=hf_****
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),Ke=new g({props:{title:"Quiet mode",local:"quiet-mode",headingTag:"h3"}}),tt=new u({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjAtLXF1aWV0",highlighted:`&gt;&gt;&gt; hf download gpt2 --quiet
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),lt=new g({props:{title:"Download timeout",local:"download-timeout",headingTag:"h3"}}),at=new u({props:{code:"JTYwaHR0cHguVGltZW91dEV4Y2VwdGlvbiUzQSUyMChUaW1lb3V0RXhjZXB0aW9uKCUyMkhUVFBTQ29ubmVjdGlvblBvb2woaG9zdCUzRCdjZG4tbGZzLXVzLTEuaHVnZ2luZ2ZhY2UuY28nJTJDJTIwcG9ydCUzRDQ0MyklM0ElMjBSZWFkJTIwdGltZWQlMjBvdXQuJTIwKHJlYWQlMjB0aW1lb3V0JTNEMTApJTIyKSUyQyUyMCcoUmVxdWVzdCUyMElEJTNBJTIwYTMzZDkxMGMtODRjNi00NTE0LTgzNjItYzcwNWUyMDM5ZDM4KScpJTYw",highlighted:'`httpx.TimeoutException: (TimeoutException(<span class="hljs-string">&quot;HTTPSConnectionPool(host=&#x27;cdn-lfs-us-1.huggingface.co&#x27;, port=443): Read timed out. (read timeout=10)&quot;</span>), <span class="hljs-string">&#x27;(Request ID: a33d910c-84c6-4514-8362-c705e2039d38)&#x27;</span>)`',wrap:!1}}),it=new u({props:{code:"ZXhwb3J0JTIwSEZfSFVCX0RPV05MT0FEX1RJTUVPVVQlM0QzMA==",highlighted:'<span class="hljs-built_in">export</span> HF_HUB_DOWNLOAD_TIMEOUT=30',wrap:!1}}),pt=new g({props:{title:"hf upload",local:"hf-upload",headingTag:"h2"}}),dt=new u({props:{code:"aGYlMjB1cGxvYWQlMjAtLWhlbHA=",highlighted:'&gt;&gt;&gt; hf upload --<span class="hljs-built_in">help</span>',wrap:!1}}),ct=new g({props:{title:"Upload an entire folder",local:"upload-an-entire-folder",headingTag:"h3"}}),rt=new u({props:{code:"JTIzJTIwVXNhZ2UlM0ElMjAlMjBoZiUyMHVwbG9hZCUyMCU1QnJlcG9faWQlNUQlMjAlNUJsb2NhbF9wYXRoJTVEJTIwJTVCcGF0aF9pbl9yZXBvJTVE",highlighted:'<span class="hljs-comment"># Usage:  hf upload [repo_id] [local_path] [path_in_repo]</span>',wrap:!1}}),ut=new u({props:{code:"aGYlMjB1cGxvYWQlMjBteS1jb29sLW1vZGVsJTIwLiUyMC4=",highlighted:`&gt;&gt;&gt; hf upload my-cool-model . .
https://huggingface.co/Wauplin/my-cool-model/tree/main/`,wrap:!1}}),yt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBteS1jb29sLW1vZGVsJTIwLiUyRm1vZGVscyUyMC4=",highlighted:`&gt;&gt;&gt; hf upload my-cool-model ./models .
https://huggingface.co/Wauplin/my-cool-model/tree/main/`,wrap:!1}}),Mt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBteS1jb29sLW1vZGVsJTIwLiUyRnBhdGglMkZ0byUyRmN1cmF0ZWQlMkZkYXRhJTIwJTJGZGF0YSUyRnRyYWlu",highlighted:`&gt;&gt;&gt; hf upload my-cool-model ./path/to/curated/data /data/train
https://huggingface.co/Wauplin/my-cool-model/tree/main/data/train`,wrap:!1}}),wt=new g({props:{title:"Upload a single file",local:"upload-a-single-file",headingTag:"h3"}}),Tt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMkZtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models/model.safetensors
https://huggingface.co/Wauplin/my-cool-model/blob/main/model.safetensors`,wrap:!1}}),vt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMkZtb2RlbC5zYWZldGVuc29ycyUyMCUyRnZhZSUyRm1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models/model.safetensors /vae/model.safetensors
https://huggingface.co/Wauplin/my-cool-model/blob/main/vae/model.safetensors`,wrap:!1}}),Jt=new g({props:{title:"Upload multiple files",local:"upload-multiple-files",headingTag:"h3"}}),Ct=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGc3BhY2UtZXhhbXBsZSUyMC0tcmVwby10eXBlJTNEc3BhY2UlMjAtLWV4Y2x1ZGUlM0QlMjIlMkZsb2dzJTJGKiUyMiUyMC0tZGVsZXRlJTNEJTIyKiUyMiUyMC0tY29tbWl0LW1lc3NhZ2UlM0QlMjJTeW5jJTIwbG9jYWwlMjBTcGFjZSUyMHdpdGglMjBIdWIlMjI=",highlighted:`<span class="hljs-comment"># Sync local Space with Hub (upload new files except from logs/, delete removed files)</span>
&gt;&gt;&gt; hf upload Wauplin/space-example --repo-type=space --exclude=<span class="hljs-string">&quot;/logs/*&quot;</span> --delete=<span class="hljs-string">&quot;*&quot;</span> --commit-message=<span class="hljs-string">&quot;Sync local Space with Hub&quot;</span>
...`,wrap:!1}}),It=new g({props:{title:"Upload to a dataset or Space",local:"upload-to-a-dataset-or-space",headingTag:"h3"}}),_t=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1kYXRhc2V0JTIwLiUyRmRhdGElMjAlMkZ0cmFpbiUyMC0tcmVwby10eXBlJTNEZGF0YXNldA==",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-dataset ./data /train --repo-type=dataset
...`,wrap:!1}}),kt=new g({props:{title:"Upload to an organization",local:"upload-to-an-organization",headingTag:"h3"}}),xt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBNeUNvb2xPcmdhbml6YXRpb24lMkZteS1jb29sLW1vZGVsJTIwLiUyMC4=",highlighted:`&gt;&gt;&gt; hf upload MyCoolOrganization/my-cool-model . .
https://huggingface.co/MyCoolOrganization/my-cool-model/tree/main/`,wrap:!1}}),Ht=new g({props:{title:"Upload to a specific revision",local:"upload-to-a-specific-revision",headingTag:"h3"}}),Zt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBiaWdjb2RlJTJGdGhlLXN0YWNrJTIwLiUyMC4lMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjAtLXJldmlzaW9uJTIwcmVmcyUyRnByJTJGMTA0",highlighted:`<span class="hljs-comment"># Upload files to a PR</span>
&gt;&gt;&gt; hf upload bigcode/the-stack . . --repo-type dataset --revision refs/pr/104
...`,wrap:!1}}),Wt=new g({props:{title:"Upload and create a PR",local:"upload-and-create-a-pr",headingTag:"h3"}}),Rt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBiaWdjb2RlJTJGdGhlLXN0YWNrJTIwLiUyMC4lMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQlMjAtLXJldmlzaW9uJTIwcmVmcyUyRnByJTJGMTA0",highlighted:`<span class="hljs-comment"># Create a PR and upload the files to it</span>
&gt;&gt;&gt; hf upload bigcode/the-stack . . --repo-type dataset --revision refs/pr/104
https://huggingface.co/datasets/bigcode/the-stack/blob/refs%2Fpr%2F104/`,wrap:!1}}),Nt=new g({props:{title:"Upload at regular intervals",local:"upload-at-regular-intervals",headingTag:"h3"}}),Vt=new u({props:{code:"JTIzJTIwVXBsb2FkJTIwbmV3JTIwbG9ncyUyMGV2ZXJ5JTIwMTAlMjBtaW51dGVzJTBBaGYlMjB1cGxvYWQlMjB0cmFpbmluZy1tb2RlbCUyMGxvZ3MlMkYlMjAtLWV2ZXJ5JTNEMTA=",highlighted:`<span class="hljs-comment"># Upload new logs every 10 minutes</span>
hf upload training-model logs/ --every=10`,wrap:!1}}),St=new g({props:{title:"Specify a commit message",local:"specify-a-commit-message",headingTag:"h3"}}),Qt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMjAuJTIwLS1jb21taXQtbWVzc2FnZSUzRCUyMkVwb2NoJTIwMzQlMkY1MCUyMiUyMC0tY29tbWl0LWRlc2NyaXB0aW9uJTNEJTIyVmFsJTIwYWNjdXJhY3klM0ElMjA2OCUyNS4lMjBDaGVjayUyMHRlbnNvcmJvYXJkJTIwZm9yJTIwbW9yZSUyMGRldGFpbHMuJTIy",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models . --commit-message=<span class="hljs-string">&quot;Epoch 34/50&quot;</span> --commit-description=<span class="hljs-string">&quot;Val accuracy: 68%. Check tensorboard for more details.&quot;</span>
...
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),Pt=new g({props:{title:"Specify a token",local:"specify-a-token",headingTag:"h3"}}),zt=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMjAuJTIwLS10b2tlbiUzRGhmXyoqKio=",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models . --token=hf_****
...
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),qt=new g({props:{title:"Quiet mode",local:"quiet-mode",headingTag:"h3"}}),Ot=new u({props:{code:"aGYlMjB1cGxvYWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC4lMkZtb2RlbHMlMjAuJTIwLS1xdWlldA==",highlighted:`&gt;&gt;&gt; hf upload Wauplin/my-cool-model ./models . --quiet
https://huggingface.co/Wauplin/my-cool-model/tree/main`,wrap:!1}}),Kt=new g({props:{title:"hf repo",local:"hf-repo",headingTag:"h2"}}),tl=new g({props:{title:"Create a repo",local:"create-a-repo",headingTag:"h3"}}),ll=new u({props:{code:"aGYlMjByZXBvJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWw=",highlighted:`&gt;&gt;&gt; hf repo create Wauplin/my-cool-model
Successfully created Wauplin/my-cool-model on the Hub.
Your repo is now available at https://huggingface.co/Wauplin/my-cool-model`,wrap:!1}}),al=new u({props:{code:"aGYlMjByZXBvJTIwY3JlYXRlJTIwbXktY29vbC1kYXRhc2V0JTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTIwLS1wcml2YXRlJTBBaGYlMjByZXBvJTIwY3JlYXRlJTIwbXktZ3JhZGlvLXNwYWNlJTIwLS1yZXBvLXR5cGUlMjBzcGFjZSUyMC0tc3BhY2Utc2RrJTIwZ3JhZGlv",highlighted:`&gt;&gt;&gt; hf repo create my-cool-dataset --repo-type dataset --private
&gt;&gt;&gt; hf repo create my-gradio-space --repo-type space --space-sdk gradio`,wrap:!1}}),il=new g({props:{title:"Delete a repo",local:"delete-a-repo",headingTag:"h3"}}),ol=new u({props:{code:"aGYlMjByZXBvJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWw=",highlighted:"&gt;&gt;&gt; hf repo delete Wauplin/my-cool-model",wrap:!1}}),fl=new u({props:{code:"aGYlMjByZXBvJTIwZGVsZXRlJTIwbXktY29vbC1kYXRhc2V0JTIwLS1yZXBvLXR5cGUlMjBkYXRhc2V0JTBBaGYlMjByZXBvJTIwZGVsZXRlJTIwbXktZ3JhZGlvLXNwYWNlJTIwLS1yZXBvLXR5cGUlMjBzcGFjZQ==",highlighted:`&gt;&gt;&gt; hf repo delete my-cool-dataset --repo-type dataset
&gt;&gt;&gt; hf repo delete my-gradio-space --repo-type space`,wrap:!1}}),dl=new g({props:{title:"Move a repo",local:"move-a-repo",headingTag:"h3"}}),cl=new u({props:{code:"aGYlMjByZXBvJTIwbW92ZSUyMG9sZC1uYW1lc3BhY2UlMkZteS1tb2RlbCUyMG5ldy1uYW1lc3BhY2UlMkZteS1tb2RlbA==",highlighted:"&gt;&gt;&gt; hf repo move old-namespace/my-model new-namespace/my-model",wrap:!1}}),ml=new g({props:{title:"Update repo settings",local:"update-repo-settings",headingTag:"h3"}}),rl=new u({props:{code:"aGYlMjByZXBvJTIwc2V0dGluZ3MlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC0tZ2F0ZWQlMjBhdXRvJTBBaGYlMjByZXBvJTIwc2V0dGluZ3MlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMC0tcHJpdmF0ZSUyMHRydWUlMEFoZiUyMHJlcG8lMjBzZXR0aW5ncyUyMFdhdXBsaW4lMkZteS1jb29sLW1vZGVsJTIwLS1wcml2YXRlJTIwZmFsc2U=",highlighted:`&gt;&gt;&gt; hf repo settings Wauplin/my-cool-model --gated auto
&gt;&gt;&gt; hf repo settings Wauplin/my-cool-model --private <span class="hljs-literal">true</span>
&gt;&gt;&gt; hf repo settings Wauplin/my-cool-model --private <span class="hljs-literal">false</span>`,wrap:!1}}),ul=new g({props:{title:"Manage branches",local:"manage-branches",headingTag:"h3"}}),gl=new u({props:{code:"aGYlMjByZXBvJTIwYnJhbmNoJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjBkZXYlMEFoZiUyMHJlcG8lMjBicmFuY2glMjBjcmVhdGUlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMHJlbGVhc2UtMSUyMC0tcmV2aXNpb24lMjByZWZzJTJGcHIlMkYxMDQlMEFoZiUyMHJlcG8lMjBicmFuY2glMjBkZWxldGUlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMGRldg==",highlighted:`&gt;&gt;&gt; hf repo branch create Wauplin/my-cool-model dev
&gt;&gt;&gt; hf repo branch create Wauplin/my-cool-model release-1 --revision refs/pr/104
&gt;&gt;&gt; hf repo branch delete Wauplin/my-cool-model dev`,wrap:!1}}),yl=new g({props:{title:"hf repo-files",local:"hf-repo-files",headingTag:"h2"}}),Ml=new g({props:{title:"Delete files",local:"delete-files",headingTag:"h3"}}),Tl=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjBmb2xkZXIlMkY=",highlighted:`&gt;&gt;&gt; hf repo-files delete Wauplin/my-cool-model folder/
Files correctly deleted from repo. Commit: https://huggingface.co/Wauplin/my-cool-mo...`,wrap:!1}}),vl=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjBmaWxlLnR4dCUyMGZvbGRlciUyRnB5dG9yY2hfbW9kZWwuYmlu",highlighted:`&gt;&gt;&gt; hf repo-files delete Wauplin/my-cool-model file.txt folder/pytorch_model.bin
Files correctly deleted from repo. Commit: https://huggingface.co/Wauplin/my-cool-mo...`,wrap:!1}}),Ul=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjAlMjIqLnR4dCUyMiUyMCUyMmZvbGRlciUyRiouYmluJTIy",highlighted:`&gt;&gt;&gt; hf repo-files delete Wauplin/my-cool-model <span class="hljs-string">&quot;*.txt&quot;</span> <span class="hljs-string">&quot;folder/*.bin&quot;</span>
Files correctly deleted from repo. Commit: https://huggingface.co/Wauplin/my-cool-mo...`,wrap:!1}}),Cl=new g({props:{title:"Specify a token",local:"specify-a-token",headingTag:"h3"}}),Gl=new u({props:{code:"aGYlMjByZXBvLWZpbGVzJTIwZGVsZXRlJTIwLS10b2tlbiUzRGhmXyoqKiolMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMGZpbGUudHh0",highlighted:"&gt;&gt;&gt; hf repo-files delete --token=hf_**** Wauplin/my-cool-model file.txt",wrap:!1}}),_l=new g({props:{title:"hf cache ls",local:"hf-cache-ls",headingTag:"h2"}}),Bl=new u({props:{code:"aGYlMjBjYWNoZSUyMGxzJTBB",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">ls</span>
ID                          SIZE     LAST_ACCESSED LAST_MODIFIED REFS        
--------------------------- -------- ------------- ------------- ----------- 
dataset/nyu-mll/glue          157.4M 2 days ago    2 days ago    main script 
model/LiquidAI/LFM2-VL-1.6B     3.2G 4 days ago    4 days ago    main        
model/microsoft/UserLM-8b      32.1G 4 days ago    4 days ago    main  

Found 3 repo(s) <span class="hljs-keyword">for</span> a total of 5 revision(s) and 35.5G on disk.`,wrap:!1}}),Hl=new u({props:{code:"aGYlMjBjYWNoZSUyMGxzJTIwLS1maWx0ZXIlMjAlMjJzaXplJTNFMzBnJTIyJTIwLS1yZXZpc2lvbnMlMEE=",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">ls</span> --filter <span class="hljs-string">&quot;size&gt;30g&quot;</span> --revisions
ID                        REVISION                                 SIZE     LAST_MODIFIED REFS 
------------------------- ---------------------------------------- -------- ------------- ---- 
model/microsoft/UserLM-8b be8f2069189bdf443e554c24e488ff3ff6952691    32.1G 4 days ago    main 

Found 1 repo(s) <span class="hljs-keyword">for</span> a total of 1 revision(s) and 32.1G on disk.`,wrap:!1}}),Yl=new u({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwJTI0KGhmJTIwY2FjaGUlMjBscyUyMC0tZmlsdGVyJTIwJTIyYWNjZXNzZWQlM0UxeSUyMiUyMC1xKSUyMC15",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> $(hf cache <span class="hljs-built_in">ls</span> --filter <span class="hljs-string">&quot;accessed&gt;1y&quot;</span> -q) -y
About to delete 2 repo(s) totalling 5.31G.
  - model/meta-llama/Llama-3.2-1B-Instruct (entire repo)
  - model/hexgrad/Kokoro-82M (entire repo)
Delete repo: ~/.cache/huggingface/hub/models--meta-llama--Llama-3.2-1B-Instruct
Delete repo: ~/.cache/huggingface/hub/models--hexgrad--Kokoro-82M
Cache deletion <span class="hljs-keyword">done</span>. Saved 5.31G.
Deleted 2 repo(s) and 2 revision(s); freed 5.31G.`,wrap:!1}}),Wl=new g({props:{title:"hf cache rm",local:"hf-cache-rm",headingTag:"h2"}}),Rl=new u({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZMaXF1aWRBSSUyRkxGTTItVkwtMS42Qg==",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> model/LiquidAI/LFM2-VL-1.6B
About to delete 1 repo(s) totalling 3.2G.
  - model/LiquidAI/LFM2-VL-1.6B (entire repo)
Proceed with deletion? [y/N]: y
Delete repo: ~/.cache/huggingface/hub/models--LiquidAI--LFM2-VL-1.6B
Cache deletion <span class="hljs-keyword">done</span>. Saved 3.2G.
Deleted 1 repo(s) and 2 revision(s); freed 3.2G.`,wrap:!1}}),Fl=new u({props:{code:"aGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZ0NS1zbWFsbCUyMDhmM2FkMWMlMjAtLWRyeS1ydW4=",highlighted:`&gt;&gt;&gt; hf cache <span class="hljs-built_in">rm</span> model/t5-small 8f3ad1c --dry-run
About to delete 1 repo(s) and 1 revision(s) totalling 1.1G.
  - model/t5-small:
      8f3ad1c [main] 1.1G
Dry run: no files were deleted.`,wrap:!1}}),Sl=new g({props:{title:"hf cache prune",local:"hf-cache-prune",headingTag:"h2"}}),Ql=new u({props:{code:"aGYlMjBjYWNoZSUyMHBydW5l",highlighted:`&gt;&gt;&gt; hf cache prune
About to delete 3 unreferenced revision(s) (2.4G total).
  - model/t5-small:
      1c610f6b [refs/pr/1] 820.1M
      d4ec9b72 [(detached)] 640.5M
  - dataset/google/fleurs:
      2b91c8dd [(detached)] 937.6M
Proceed? [y/N]: y
Deleted 3 unreferenced revision(s); freed 2.4G.`,wrap:!1}}),El=new g({props:{title:"hf repo tag create",local:"hf-repo-tag-create",headingTag:"h2"}}),ql=new g({props:{title:"Tag a model",local:"tag-a-model",headingTag:"h3"}}),Ol=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjB2MS4w",highlighted:`&gt;&gt;&gt; hf repo tag create Wauplin/my-cool-model v1.0
You are about to create tag v1.0 on model Wauplin/my-cool-model
Tag v1.0 created on Wauplin/my-cool-model`,wrap:!1}}),Kl=new g({props:{title:"Tag a model at a specific revision",local:"tag-a-model-at-a-specific-revision",headingTag:"h3"}}),ts=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwV2F1cGxpbiUyRm15LWNvb2wtbW9kZWwlMjB2MS4wJTIwLS1yZXZpc2lvbiUyMHJlZnMlMkZwciUyRjEwNA==",highlighted:`&gt;&gt;&gt; hf repo tag create Wauplin/my-cool-model v1.0 --revision refs/pr/104
You are about to create tag v1.0 on model Wauplin/my-cool-model
Tag v1.0 created on Wauplin/my-cool-model`,wrap:!1}}),ls=new g({props:{title:"Tag a dataset or a Space",local:"tag-a-dataset-or-a-space",headingTag:"h3"}}),as=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwYmlnY29kZSUyRnRoZS1zdGFjayUyMHYxLjAlMjAtLXJlcG8tdHlwZSUyMGRhdGFzZXQ=",highlighted:`&gt;&gt;&gt; hf repo tag create bigcode/the-stack v1.0 --repo-type dataset
You are about to create tag v1.0 on dataset bigcode/the-stack
Tag v1.0 created on bigcode/the-stack`,wrap:!1}}),ns=new g({props:{title:"List tags",local:"list-tags",headingTag:"h3"}}),os=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwV2F1cGxpbiUyRmdyYWRpby1zcGFjZS1jaSUyMC1sJTIwLS1yZXBvLXR5cGUlMjBzcGFjZQ==",highlighted:`&gt;&gt;&gt; hf repo tag create Wauplin/gradio-space-ci -l --repo-type space
Tags <span class="hljs-keyword">for</span> space Wauplin/gradio-space-ci:
0.2.2
0.2.1
0.2.0
0.1.2
0.0.2
0.0.1`,wrap:!1}}),ps=new g({props:{title:"Delete a tag",local:"delete-a-tag",headingTag:"h3"}}),ds=new u({props:{code:"aGYlMjByZXBvJTIwdGFnJTIwY3JlYXRlJTIwLWQlMjBXYXVwbGluJTJGbXktY29vbC1tb2RlbCUyMHYxLjA=",highlighted:`&gt;&gt;&gt; hf repo tag create -d Wauplin/my-cool-model v1.0
You are about to delete tag v1.0 on model Wauplin/my-cool-model
Proceed? [Y/n] y
Tag v1.0 deleted on Wauplin/my-cool-model`,wrap:!1}}),ms=new g({props:{title:"hf env",local:"hf-env",headingTag:"h2"}}),hs=new u({props:{code:"aGYlMjBlbnYlMEElMEE=",highlighted:`&gt;&gt;&gt; hf <span class="hljs-built_in">env</span>

Copy-and-paste the text below <span class="hljs-keyword">in</span> your GitHub issue.

- huggingface_hub version: 1.0.0.rc6
- Platform: Linux-6.8.0-85-generic-x86_64-with-glibc2.35
- Python version: 3.11.14
- Running <span class="hljs-keyword">in</span> iPython ?: No
- Running <span class="hljs-keyword">in</span> notebook ?: No
- Running <span class="hljs-keyword">in</span> Google Colab ?: No
- Running <span class="hljs-keyword">in</span> Google Colab Enterprise ?: No
- Token path ?: /home/wauplin/.cache/huggingface/token
- Has saved token ?: True
- Who am I ?: Wauplin
- Configured git credential helpers: store
- Installation method: unknown
- Torch: N/A
- httpx: 0.28.1
- hf_xet: 1.1.10
- gradio: 5.41.1
- tensorboard: N/A
- pydantic: 2.11.7
- ENDPOINT: https://huggingface.co
- HF_HUB_CACHE: /home/wauplin/.cache/huggingface/hub
- HF_ASSETS_CACHE: /home/wauplin/.cache/huggingface/assets
- HF_TOKEN_PATH: /home/wauplin/.cache/huggingface/token
- HF_STORED_TOKENS_PATH: /home/wauplin/.cache/huggingface/stored_tokens
- HF_HUB_OFFLINE: False
- HF_HUB_DISABLE_TELEMETRY: False
- HF_HUB_DISABLE_PROGRESS_BARS: None
- HF_HUB_DISABLE_SYMLINKS_WARNING: False
- HF_HUB_DISABLE_EXPERIMENTAL_WARNING: False
- HF_HUB_DISABLE_IMPLICIT_TOKEN: False
- HF_HUB_DISABLE_XET: False
- HF_HUB_ETAG_TIMEOUT: 10
- HF_HUB_DOWNLOAD_TIMEOUT: 10`,wrap:!1}}),us=new g({props:{title:"hf jobs",local:"hf-jobs",headingTag:"h2"}}),$s=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJ3ByaW50KCUyMkhlbGxvJTIwZnJvbSUyMHRoZSUyMGNsb3VkISUyMiknJTBBJTBBaGYlMjBqb2JzJTIwcnVuJTIwLS1mbGF2b3IlMjBhMTBnLXNtYWxsJTIwcHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjAlNUMlMEFweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMHRvcmNoJTNCJTIwcHJpbnQodG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSklMjIlMEElMEFoZiUyMGpvYnMlMjBydW4lMjAtLW5hbWVzcGFjZSUyMG15LW9yZy1uYW1lJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJTIycHJpbnQoJ1J1bm5pbmclMjBpbiUyMGFuJTIwb3JnJTIwYWNjb3VudCcpJTIyJTBBJTBBaGYlMjBqb2JzJTIwcnVuJTIwaGYuY28lMkZzcGFjZXMlMkZsaG9lc3RxJTJGZHVja2RiJTIwZHVja2RiJTIwLWMlMjAlMjJzZWxlY3QlMjAnaGVsbG8lMjB3b3JsZCclMjIlMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMG15X3NjcmlwdC5weQ==",highlighted:`<span class="hljs-comment"># Directly run Python code</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run python:3.12 python -c <span class="hljs-string">&#x27;print(&quot;Hello from the cloud!&quot;)&#x27;</span>

<span class="hljs-comment"># Use GPUs without any setup</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel \\
... python -c <span class="hljs-string">&quot;import torch; print(torch.cuda.get_device_name())&quot;</span>

<span class="hljs-comment"># Run in an organization account</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --namespace my-org-name python:3.12 python -c <span class="hljs-string">&quot;print(&#x27;Running in an org account&#x27;)&quot;</span>

<span class="hljs-comment"># Run from Hugging Face Spaces</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run hf.co/spaces/lhoestq/duckdb duckdb -c <span class="hljs-string">&quot;select &#x27;hello world&#x27;&quot;</span>

<span class="hljs-comment"># Run a Python script with \`uv\` (experimental)</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py`,wrap:!1}}),Ms=new g({props:{title:"✨ Key Features",local:"-key-features",headingTag:"h3"}}),bs=new g({props:{title:"Quick Start",local:"quick-start",headingTag:"h3"}}),Ts=new g({props:{title:"1. Run your first job",local:"1-run-your-first-job",headingTag:"h4"}}),js=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJTIycHJpbnQoJ0hlbGxvJTIwZnJvbSUyMEhGJTIwY29tcHV0ZSEnKSUyMg==",highlighted:`<span class="hljs-comment"># Run a simple Python script</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run python:3.12 python -c <span class="hljs-string">&quot;print(&#x27;Hello from HF compute!&#x27;)&quot;</span>`,wrap:!1}}),Js=new g({props:{title:"2. Check job status",local:"2-check-job-status",headingTag:"h4"}}),Us=new u({props:{code:"aGYlMjBqb2JzJTIwcHMlMEElMEFoZiUyMGpvYnMlMjBpbnNwZWN0JTIwJTNDam9iX2lkJTNFJTBBJTBBaGYlMjBqb2JzJTIwbG9ncyUyMCUzQ2pvYl9pZCUzRSUwQSUwQWhmJTIwam9icyUyMGNhbmNlbCUyMCUzQ2pvYl9pZCUzRQ==",highlighted:`<span class="hljs-comment"># List your running jobs</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> ps

<span class="hljs-comment"># Inspect the status of a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> inspect &lt;job_id&gt;

<span class="hljs-comment"># View logs from a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> logs &lt;job_id&gt;

<span class="hljs-comment"># Cancel a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> cancel &lt;job_id&gt;`,wrap:!1}}),Cs=new g({props:{title:"3. Run on GPU",local:"3-run-on-gpu",headingTag:"h4"}}),Gs=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLS1mbGF2b3IlMjBhMTBnLXNtYWxsJTIwcHl0b3JjaCUyRnB5dG9yY2glM0EyLjYuMC1jdWRhMTIuNC1jdWRubjktZGV2ZWwlMjAlNUMlMEFweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMHRvcmNoJTNCJTIwcHJpbnQoZiUyMlRoaXMlMjBjb2RlJTIwcmFuJTIwd2l0aCUyMHRoZSUyMGZvbGxvd2luZyUyMEdQVSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9uYW1lKCklN0QlMjIpJTIy",highlighted:`<span class="hljs-comment"># Use an A10G GPU to check PyTorch CUDA</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel \\
... python -c <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran with the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>`,wrap:!1}}),ks=new u({props:{code:"VGhpcyUyMGNvZGUlMjByYW4lMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwR1BVJTNBJTIwTlZJRElBJTIwQTEwRw==",highlighted:"This code ran with the following GPU: NVIDIA A10G",wrap:!1}}),xs=new g({props:{title:"Common Use Cases",local:"common-use-cases",headingTag:"h3"}}),Ls=new g({props:{title:"Pass Environment variables and Secrets",local:"pass-environment-variables-and-secrets",headingTag:"h3"}}),Ys=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLWUlMjBGT08lM0Rmb28lMjAtZSUyMEJBUiUzRGJhciUyMHB5dGhvbiUzQTMuMTIlMjBweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMG9zJTNCJTIwcHJpbnQob3MuZW52aXJvbiU1QidGT08nJTVEJTJDJTIwb3MuZW52aXJvbiU1QidCQVInJTVEKSUyMg==",highlighted:`<span class="hljs-comment"># Pass environment variables</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run -e FOO=foo -e BAR=bar python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;FOO&#x27;], os.environ[&#x27;BAR&#x27;])&quot;</span>`,wrap:!1}}),Ws=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLS1lbnYtZmlsZSUyMC5lbnYlMjBweXRob24lM0EzLjEyJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjBvcyUzQiUyMHByaW50KG9zLmVudmlyb24lNUInRk9PJyU1RCUyQyUyMG9zLmVudmlyb24lNUInQkFSJyU1RCklMjI=",highlighted:`<span class="hljs-comment"># Pass an environment from a local .env file</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --env-file .<span class="hljs-built_in">env</span> python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;FOO&#x27;], os.environ[&#x27;BAR&#x27;])&quot;</span>`,wrap:!1}}),Xs=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLXMlMjBNWV9TRUNSRVQlM0Rwc3N3cmQlMjBweXRob24lM0EzLjEyJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjBvcyUzQiUyMHByaW50KG9zLmVudmlyb24lNUInTVlfU0VDUkVUJyU1RCklMjI=",highlighted:`<span class="hljs-comment"># Pass secrets - they will be encrypted server side</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run -s MY_SECRET=psswrd python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;MY_SECRET&#x27;])&quot;</span>`,wrap:!1}}),Rs=new u({props:{code:"aGYlMjBqb2JzJTIwcnVuJTIwLS1zZWNyZXRzLWZpbGUlMjAuZW52LnNlY3JldHMlMjBweXRob24lM0EzLjEyJTIwcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjBvcyUzQiUyMHByaW50KG9zLmVudmlyb24lNUInTVlfU0VDUkVUJyU1RCklMjI=",highlighted:`<span class="hljs-comment"># Pass secrets from a local .env.secrets file - they will be encrypted server side</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> run --secrets-file .env.secrets python:3.12 python -c <span class="hljs-string">&quot;import os; print(os.environ[&#x27;MY_SECRET&#x27;])&quot;</span>`,wrap:!1}}),Ns=new g({props:{title:"Hardware",local:"hardware",headingTag:"h3"}}),As=new g({props:{title:"UV Scripts (Experimental)",local:"uv-scripts-experimental",headingTag:"h3"}}),Ps=new u({props:{code:"aGYlMjBqb2JzJTIwdXYlMjBydW4lMjBteV9zY3JpcHQucHklMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMG15X3NjcmlwdC5weSUyMC0tcmVwbyUyMG15LXV2LXNjcmlwdHMlMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMG1sX3RyYWluaW5nLnB5JTIwLS1mbGF2b3IlMjBncHUtdDQtc21hbGwlMEElMEFoZiUyMGpvYnMlMjB1diUyMHJ1biUyMHByb2Nlc3MucHklMjBpbnB1dC5jc3YlMjBvdXRwdXQucGFycXVldCUwQSUwQWhmJTIwam9icyUyMHV2JTIwcnVuJTIwLS13aXRoJTIwdHJhbnNmb3JtZXJzJTIwLS13aXRoJTIwdG9yY2glMjB0cmFpbi5weSUwQSUwQWhmJTIwam9icyUyMHV2JTIwcnVuJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZzY3JpcHRzJTJGcmVzb2x2ZSUyRm1haW4lMkZleGFtcGxlLnB5JTBBJTBBaGYlMjBqb2JzJTIwdXYlMjBydW4lMjAtLXdpdGglMjBsaWdodGV2YWwlMjBweXRob24lMjAtYyUyMCUyMmltcG9ydCUyMGxpZ2h0ZXZhbCUyMg==",highlighted:`<span class="hljs-comment"># Run a UV script (creates temporary repo)</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py

<span class="hljs-comment"># Run with persistent repo</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run my_script.py --repo my-uv-scripts

<span class="hljs-comment"># Run with GPU</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run ml_training.py --flavor gpu-t4-small

<span class="hljs-comment"># Pass arguments to script</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run process.py input.csv output.parquet

<span class="hljs-comment"># Add dependencies</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run --with transformers --with torch train.py

<span class="hljs-comment"># Run a script directly from a URL</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run https://huggingface.co/datasets/username/scripts/resolve/main/example.py

<span class="hljs-comment"># Run a command</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> uv run --with lighteval python -c <span class="hljs-string">&quot;import lighteval&quot;</span>`,wrap:!1}}),zs=new g({props:{title:"Scheduled Jobs",local:"scheduled-jobs",headingTag:"h3"}}),Os=new u({props:{code:"aGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcnVuJTIwJTQwaG91cmx5JTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJ3ByaW50KCUyMlRoaXMlMjBydW5zJTIwZXZlcnklMjBob3VyISUyMiknJTBBJTBBaGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcnVuJTIwJTIyKiUyRjUlMjAqJTIwKiUyMColMjAqJTIyJTIwcHl0aG9uJTNBMy4xMiUyMHB5dGhvbiUyMC1jJTIwJ3ByaW50KCUyMlRoaXMlMjBydW5zJTIwZXZlcnklMjA1JTIwbWludXRlcyElMjIpJyUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMHJ1biUyMCU0MGhvdXJseSUyMC0tZmxhdm9yJTIwYTEwZy1zbWFsbCUyMHB5dG9yY2glMkZweXRvcmNoJTNBMi42LjAtY3VkYTEyLjQtY3Vkbm45LWRldmVsJTIwJTVDJTBBcHl0aG9uJTIwLWMlMjAlMjJpbXBvcnQlMjB0b3JjaCUzQiUyMHByaW50KGYlMjJUaGlzJTIwY29kZSUyMHJhbiUyMHdpdGglMjB0aGUlMjBmb2xsb3dpbmclMjBHUFUlM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgpJTdEJTIyKSUyMiUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMHV2JTIwcnVuJTIwJTQwaG91cmx5JTIwbXlfc2NyaXB0LnB5",highlighted:`<span class="hljs-comment"># Schedule a job that runs every hour</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled run @hourly python:3.12 python -c <span class="hljs-string">&#x27;print(&quot;This runs every hour!&quot;)&#x27;</span>

<span class="hljs-comment"># Use the CRON syntax</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled run <span class="hljs-string">&quot;*/5 * * * *&quot;</span> python:3.12 python -c <span class="hljs-string">&#x27;print(&quot;This runs every 5 minutes!&quot;)&#x27;</span>

<span class="hljs-comment"># Schedule with GPU</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled run @hourly --flavor a10g-small pytorch/pytorch:2.6.0-cuda12.4-cudnn9-devel \\
... python -c <span class="hljs-string">&quot;import torch; print(f&quot;</span>This code ran with the following GPU: {torch.cuda.get_device_name()}<span class="hljs-string">&quot;)&quot;</span>

<span class="hljs-comment"># Schedule a UV script</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled uv run @hourly my_script.py`,wrap:!1}}),ta=new u({props:{code:"aGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcHMlMEElMEFoZiUyMGpvYnMlMjBzY2hlZHVsZWQlMjBpbnNwZWN0JTIwJTNDc2NoZWR1bGVkX2pvYl9pZCUzRSUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMHN1c3BlbmQlMjAlM0NzY2hlZHVsZWRfam9iX2lkJTNFJTBBJTBBaGYlMjBqb2JzJTIwc2NoZWR1bGVkJTIwcmVzdW1lJTIwJTNDc2NoZWR1bGVkX2pvYl9pZCUzRSUwQSUwQWhmJTIwam9icyUyMHNjaGVkdWxlZCUyMGRlbGV0ZSUyMCUzQ3NjaGVkdWxlZF9qb2JfaWQlM0U=",highlighted:`<span class="hljs-comment"># List your active scheduled jobs</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled ps

<span class="hljs-comment"># Inspect the status of a job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled inspect &lt;scheduled_job_id&gt;

<span class="hljs-comment"># Suspend (pause) a scheduled job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled <span class="hljs-built_in">suspend</span> &lt;scheduled_job_id&gt;

<span class="hljs-comment"># Resume a scheduled job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled resume &lt;scheduled_job_id&gt;

<span class="hljs-comment"># Delete a scheduled job</span>
&gt;&gt;&gt; hf <span class="hljs-built_in">jobs</span> scheduled delete &lt;scheduled_job_id&gt;`,wrap:!1}}),la=new fc({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/cli.md"}}),{c(){$=m("meta"),na=a(),sa=m("p"),ia=a(),i(C.$$.fragment),oa=a(),i(I.$$.fragment),pa=a(),G=m("p"),G.innerHTML=zp,fa=a(),M=m("blockquote"),M.innerHTML=qp,da=a(),i(_.$$.fragment),ca=a(),k=m("p"),k.textContent=Dp,ma=a(),i(B.$$.fragment),ra=a(),w=m("blockquote"),w.innerHTML=Op,ha=a(),x=m("p"),x.innerHTML=Kp,ua=a(),H=m("p"),H.textContent=ef,ga=a(),i(L.$$.fragment),ya=a(),Z=m("p"),Z.textContent=tf,$a=a(),i(Y.$$.fragment),Ma=a(),W=m("p"),W.textContent=lf,wa=a(),i(X.$$.fragment),ba=a(),R=m("p"),R.innerHTML=sf,Ta=a(),b=m("blockquote"),b.innerHTML=af,ja=a(),i(N.$$.fragment),va=a(),i(F.$$.fragment),Ja=a(),V=m("p"),V.innerHTML=nf,Ua=a(),S=m("p"),S.innerHTML=of,Ca=a(),i(A.$$.fragment),Ia=a(),Q=m("p"),Q.textContent=pf,Ga=a(),i(P.$$.fragment),_a=a(),E=m("p"),E.innerHTML=ff,ka=a(),i(z.$$.fragment),Ba=a(),i(q.$$.fragment),xa=a(),D=m("p"),D.innerHTML=df,Ha=a(),i(O.$$.fragment),La=a(),K=m("p"),K.innerHTML=cf,Za=a(),i(ee.$$.fragment),Ya=a(),te=m("p"),te.innerHTML=mf,Wa=a(),le=m("p"),le.textContent=rf,Xa=a(),i(se.$$.fragment),Ra=a(),ae=m("p"),ae.innerHTML=hf,Na=a(),i(ne.$$.fragment),Fa=a(),ie=m("p"),ie.textContent=uf,Va=a(),i(oe.$$.fragment),Sa=a(),pe=m("p"),pe.innerHTML=gf,Aa=a(),i(fe.$$.fragment),Qa=a(),de=m("p"),de.innerHTML=yf,Pa=a(),i(ce.$$.fragment),Ea=a(),me=m("p"),me.textContent=$f,za=a(),i(re.$$.fragment),qa=a(),he=m("p"),he.textContent=Mf,Da=a(),ue=m("p"),ue.innerHTML=wf,Oa=a(),i(ge.$$.fragment),Ka=a(),ye=m("p"),ye.innerHTML=bf,en=a(),i($e.$$.fragment),tn=a(),i(Me.$$.fragment),ln=a(),we=m("p"),we.textContent=Tf,sn=a(),i(be.$$.fragment),an=a(),Te=m("p"),Te.textContent=jf,nn=a(),je=m("p"),je.textContent=vf,on=a(),i(ve.$$.fragment),pn=a(),i(Je.$$.fragment),fn=a(),Ue=m("p"),Ue.textContent=Jf,dn=a(),i(Ce.$$.fragment),cn=a(),i(Ie.$$.fragment),mn=a(),Ge=m("p"),Ge.textContent=Uf,rn=a(),i(_e.$$.fragment),hn=a(),ke=m("p"),ke.innerHTML=Cf,un=a(),i(Be.$$.fragment),gn=a(),i(xe.$$.fragment),yn=a(),He=m("p"),He.innerHTML=If,$n=a(),i(Le.$$.fragment),Mn=a(),i(Ze.$$.fragment),wn=a(),Ye=m("p"),Ye.innerHTML=Gf,bn=a(),i(We.$$.fragment),Tn=a(),i(Xe.$$.fragment),jn=a(),Re=m("p"),Re.innerHTML=_f,vn=a(),Ne=m("p"),Ne.innerHTML=kf,Jn=a(),T=m("blockquote"),T.innerHTML=Bf,Un=a(),i(Fe.$$.fragment),Cn=a(),i(Ve.$$.fragment),In=a(),Se=m("p"),Se.innerHTML=xf,Gn=a(),i(Ae.$$.fragment),_n=a(),Qe=m("p"),Qe.innerHTML=Hf,kn=a(),i(Pe.$$.fragment),Bn=a(),Ee=m("p"),Ee.innerHTML=Lf,xn=a(),i(ze.$$.fragment),Hn=a(),i(qe.$$.fragment),Ln=a(),De=m("p"),De.innerHTML=Zf,Zn=a(),i(Oe.$$.fragment),Yn=a(),i(Ke.$$.fragment),Wn=a(),et=m("p"),et.innerHTML=Yf,Xn=a(),i(tt.$$.fragment),Rn=a(),i(lt.$$.fragment),Nn=a(),st=m("p"),st.textContent=Wf,Fn=a(),i(at.$$.fragment),Vn=a(),nt=m("p"),nt.innerHTML=Xf,Sn=a(),i(it.$$.fragment),An=a(),ot=m("p"),ot.innerHTML=Rf,Qn=a(),i(pt.$$.fragment),Pn=a(),ft=m("p"),ft.innerHTML=Nf,En=a(),i(dt.$$.fragment),zn=a(),i(ct.$$.fragment),qn=a(),mt=m("p"),mt.textContent=Ff,Dn=a(),i(rt.$$.fragment),On=a(),ht=m("p"),ht.textContent=Vf,Kn=a(),i(ut.$$.fragment),ei=a(),j=m("blockquote"),j.innerHTML=Sf,ti=a(),gt=m("p"),gt.textContent=Af,li=a(),i(yt.$$.fragment),si=a(),$t=m("p"),$t.textContent=Qf,ai=a(),i(Mt.$$.fragment),ni=a(),i(wt.$$.fragment),ii=a(),bt=m("p"),bt.innerHTML=Pf,oi=a(),i(Tt.$$.fragment),pi=a(),jt=m("p"),jt.innerHTML=Ef,fi=a(),i(vt.$$.fragment),di=a(),i(Jt.$$.fragment),ci=a(),Ut=m("p"),Ut.innerHTML=zf,mi=a(),i(Ct.$$.fragment),ri=a(),i(It.$$.fragment),hi=a(),Gt=m("p"),Gt.innerHTML=qf,ui=a(),i(_t.$$.fragment),gi=a(),i(kt.$$.fragment),yi=a(),Bt=m("p"),Bt.innerHTML=Df,$i=a(),i(xt.$$.fragment),Mi=a(),i(Ht.$$.fragment),wi=a(),Lt=m("p"),Lt.innerHTML=Of,bi=a(),i(Zt.$$.fragment),Ti=a(),Yt=m("p"),Yt.innerHTML=Kf,ji=a(),i(Wt.$$.fragment),vi=a(),Xt=m("p"),Xt.innerHTML=ed,Ji=a(),i(Rt.$$.fragment),Ui=a(),i(Nt.$$.fragment),Ci=a(),Ft=m("p"),Ft.innerHTML=td,Ii=a(),i(Vt.$$.fragment),Gi=a(),i(St.$$.fragment),_i=a(),At=m("p"),At.innerHTML=ld,ki=a(),i(Qt.$$.fragment),Bi=a(),i(Pt.$$.fragment),xi=a(),Et=m("p"),Et.innerHTML=sd,Hi=a(),i(zt.$$.fragment),Li=a(),i(qt.$$.fragment),Zi=a(),Dt=m("p"),Dt.innerHTML=ad,Yi=a(),i(Ot.$$.fragment),Wi=a(),i(Kt.$$.fragment),Xi=a(),el=m("p"),el.innerHTML=nd,Ri=a(),i(tl.$$.fragment),Ni=a(),i(ll.$$.fragment),Fi=a(),sl=m("p"),sl.textContent=id,Vi=a(),i(al.$$.fragment),Si=a(),nl=m("p"),nl.innerHTML=od,Ai=a(),i(il.$$.fragment),Qi=a(),i(ol.$$.fragment),Pi=a(),pl=m("p"),pl.textContent=pd,Ei=a(),i(fl.$$.fragment),zi=a(),i(dl.$$.fragment),qi=a(),i(cl.$$.fragment),Di=a(),i(ml.$$.fragment),Oi=a(),i(rl.$$.fragment),Ki=a(),hl=m("ul"),hl.innerHTML=fd,eo=a(),i(ul.$$.fragment),to=a(),i(gl.$$.fragment),lo=a(),v=m("blockquote"),v.innerHTML=dd,so=a(),i(yl.$$.fragment),ao=a(),$l=m("p"),$l.innerHTML=cd,no=a(),i(Ml.$$.fragment),io=a(),wl=m("p"),wl.innerHTML=md,oo=a(),bl=m("p"),bl.textContent=rd,po=a(),i(Tl.$$.fragment),fo=a(),jl=m("p"),jl.textContent=hd,co=a(),i(vl.$$.fragment),mo=a(),Jl=m("p"),Jl.textContent=ud,ro=a(),i(Ul.$$.fragment),ho=a(),i(Cl.$$.fragment),uo=a(),Il=m("p"),Il.innerHTML=gd,go=a(),i(Gl.$$.fragment),yo=a(),i(_l.$$.fragment),$o=a(),kl=m("p"),kl.innerHTML=yd,Mo=a(),i(Bl.$$.fragment),wo=a(),xl=m("p"),xl.innerHTML=$d,bo=a(),i(Hl.$$.fragment),To=a(),Ll=m("p"),Ll.innerHTML=Md,jo=a(),Zl=m("p"),Zl.innerHTML=wd,vo=a(),i(Yl.$$.fragment),Jo=a(),i(Wl.$$.fragment),Uo=a(),Xl=m("p"),Xl.innerHTML=bd,Co=a(),i(Rl.$$.fragment),Io=a(),Nl=m("p"),Nl.innerHTML=Td,Go=a(),i(Fl.$$.fragment),_o=a(),Vl=m("p"),Vl.innerHTML=jd,ko=a(),i(Sl.$$.fragment),Bo=a(),Al=m("p"),Al.innerHTML=vd,xo=a(),i(Ql.$$.fragment),Ho=a(),Pl=m("p"),Pl.innerHTML=Jd,Lo=a(),i(El.$$.fragment),Zo=a(),zl=m("p"),zl.innerHTML=Ud,Yo=a(),i(ql.$$.fragment),Wo=a(),Dl=m("p"),Dl.innerHTML=Cd,Xo=a(),i(Ol.$$.fragment),Ro=a(),i(Kl.$$.fragment),No=a(),es=m("p"),es.innerHTML=Id,Fo=a(),i(ts.$$.fragment),Vo=a(),i(ls.$$.fragment),So=a(),ss=m("p"),ss.innerHTML=Gd,Ao=a(),i(as.$$.fragment),Qo=a(),i(ns.$$.fragment),Po=a(),is=m("p"),is.innerHTML=_d,Eo=a(),i(os.$$.fragment),zo=a(),i(ps.$$.fragment),qo=a(),fs=m("p"),fs.innerHTML=kd,Do=a(),i(ds.$$.fragment),Oo=a(),cs=m("p"),cs.innerHTML=Bd,Ko=a(),i(ms.$$.fragment),ep=a(),rs=m("p"),rs.innerHTML=xd,tp=a(),i(hs.$$.fragment),lp=a(),i(us.$$.fragment),sp=a(),gs=m("p"),gs.textContent=Hd,ap=a(),ys=m("p"),ys.innerHTML=Ld,np=a(),i($s.$$.fragment),ip=a(),i(Ms.$$.fragment),op=a(),ws=m("ul"),ws.innerHTML=Zd,pp=a(),J=m("blockquote"),J.innerHTML=Yd,fp=a(),i(bs.$$.fragment),dp=a(),i(Ts.$$.fragment),cp=a(),i(js.$$.fragment),mp=a(),vs=m("p"),vs.innerHTML=Wd,rp=a(),i(Js.$$.fragment),hp=a(),i(Us.$$.fragment),up=a(),i(Cs.$$.fragment),gp=a(),Is=m("p"),Is.innerHTML=Xd,yp=a(),i(Gs.$$.fragment),$p=a(),_s=m("p"),_s.textContent=Rd,Mp=a(),i(ks.$$.fragment),wp=a(),Bs=m("p"),Bs.textContent=Nd,bp=a(),i(xs.$$.fragment),Tp=a(),Hs=m("ul"),Hs.innerHTML=Fd,jp=a(),i(Ls.$$.fragment),vp=a(),Zs=m("p"),Zs.textContent=Vd,Jp=a(),i(Ys.$$.fragment),Up=a(),i(Ws.$$.fragment),Cp=a(),i(Xs.$$.fragment),Ip=a(),i(Rs.$$.fragment),Gp=a(),U=m("blockquote"),U.innerHTML=Sd,_p=a(),i(Ns.$$.fragment),kp=a(),Fs=m("p"),Fs.innerHTML=Ad,Bp=a(),Vs=m("ul"),Vs.innerHTML=Qd,xp=a(),Ss=m("p"),Ss.innerHTML=Pd,Hp=a(),i(As.$$.fragment),Lp=a(),Qs=m("p"),Qs.textContent=Ed,Zp=a(),i(Ps.$$.fragment),Yp=a(),Es=m("p"),Es.innerHTML=zd,Wp=a(),i(zs.$$.fragment),Xp=a(),qs=m("p"),qs.textContent=qd,Rp=a(),Ds=m("p"),Ds.innerHTML=Dd,Np=a(),i(Os.$$.fragment),Fp=a(),Ks=m("p"),Ks.innerHTML=Od,Vp=a(),ea=m("p"),ea.textContent=Kd,Sp=a(),i(ta.$$.fragment),Ap=a(),i(la.$$.fragment),Qp=a(),aa=m("p"),this.h()},l(e){const t=ic("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),na=n(e),sa=r(e,"P",{}),ec(sa).forEach(l),ia=n(e),o(C.$$.fragment,e),oa=n(e),o(I.$$.fragment,e),pa=n(e),G=r(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1we55rn"&&(G.innerHTML=zp),fa=n(e),M=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(M)!=="svelte-6e9q8v"&&(M.innerHTML=qp),da=n(e),o(_.$$.fragment,e),ca=n(e),k=r(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-10zz5cd"&&(k.textContent=Dp),ma=n(e),o(B.$$.fragment,e),ra=n(e),w=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-1uvhxnq"&&(w.innerHTML=Op),ha=n(e),x=r(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-gjtl8q"&&(x.innerHTML=Kp),ua=n(e),H=r(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-qsqm1n"&&(H.textContent=ef),ga=n(e),o(L.$$.fragment,e),ya=n(e),Z=r(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-l29ize"&&(Z.textContent=tf),$a=n(e),o(Y.$$.fragment,e),Ma=n(e),W=r(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-d7tj5q"&&(W.textContent=lf),wa=n(e),o(X.$$.fragment,e),ba=n(e),R=r(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-y5heuv"&&(R.innerHTML=sf),Ta=n(e),b=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(b)!=="svelte-1lo81f3"&&(b.innerHTML=af),ja=n(e),o(N.$$.fragment,e),va=n(e),o(F.$$.fragment,e),Ja=n(e),V=r(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-181peu1"&&(V.innerHTML=nf),Ua=n(e),S=r(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1ago8fp"&&(S.innerHTML=of),Ca=n(e),o(A.$$.fragment,e),Ia=n(e),Q=r(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1sf0sf1"&&(Q.textContent=pf),Ga=n(e),o(P.$$.fragment,e),_a=n(e),E=r(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-kvynom"&&(E.innerHTML=ff),ka=n(e),o(z.$$.fragment,e),Ba=n(e),o(q.$$.fragment,e),xa=n(e),D=r(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-137ry2f"&&(D.innerHTML=df),Ha=n(e),o(O.$$.fragment,e),La=n(e),K=r(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-1psu2ck"&&(K.innerHTML=cf),Za=n(e),o(ee.$$.fragment,e),Ya=n(e),te=r(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-17ebf3s"&&(te.innerHTML=mf),Wa=n(e),le=r(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-mop55u"&&(le.textContent=rf),Xa=n(e),o(se.$$.fragment,e),Ra=n(e),ae=r(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1ytpaeb"&&(ae.innerHTML=hf),Na=n(e),o(ne.$$.fragment,e),Fa=n(e),ie=r(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-dukffe"&&(ie.textContent=uf),Va=n(e),o(oe.$$.fragment,e),Sa=n(e),pe=r(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-pa4dpn"&&(pe.innerHTML=gf),Aa=n(e),o(fe.$$.fragment,e),Qa=n(e),de=r(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-od6mgp"&&(de.innerHTML=yf),Pa=n(e),o(ce.$$.fragment,e),Ea=n(e),me=r(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1wtb0t3"&&(me.textContent=$f),za=n(e),o(re.$$.fragment,e),qa=n(e),he=r(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-1od3hyk"&&(he.textContent=Mf),Da=n(e),ue=r(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-nhbnel"&&(ue.innerHTML=wf),Oa=n(e),o(ge.$$.fragment,e),Ka=n(e),ye=r(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-1b0zk8b"&&(ye.innerHTML=bf),en=n(e),o($e.$$.fragment,e),tn=n(e),o(Me.$$.fragment,e),ln=n(e),we=r(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-w23prt"&&(we.textContent=Tf),sn=n(e),o(be.$$.fragment,e),an=n(e),Te=r(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-yyvpy"&&(Te.textContent=jf),nn=n(e),je=r(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1i2qcd2"&&(je.textContent=vf),on=n(e),o(ve.$$.fragment,e),pn=n(e),o(Je.$$.fragment,e),fn=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1bio1ld"&&(Ue.textContent=Jf),dn=n(e),o(Ce.$$.fragment,e),cn=n(e),o(Ie.$$.fragment,e),mn=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-9c54x0"&&(Ge.textContent=Uf),rn=n(e),o(_e.$$.fragment,e),hn=n(e),ke=r(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-vn835n"&&(ke.innerHTML=Cf),un=n(e),o(Be.$$.fragment,e),gn=n(e),o(xe.$$.fragment,e),yn=n(e),He=r(e,"P",{"data-svelte-h":!0}),h(He)!=="svelte-1ttrjh8"&&(He.innerHTML=If),$n=n(e),o(Le.$$.fragment,e),Mn=n(e),o(Ze.$$.fragment,e),wn=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-60zmht"&&(Ye.innerHTML=Gf),bn=n(e),o(We.$$.fragment,e),Tn=n(e),o(Xe.$$.fragment,e),jn=n(e),Re=r(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1el3i2v"&&(Re.innerHTML=_f),vn=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-i0s4w6"&&(Ne.innerHTML=kf),Jn=n(e),T=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(T)!=="svelte-qjt4ju"&&(T.innerHTML=Bf),Un=n(e),o(Fe.$$.fragment,e),Cn=n(e),o(Ve.$$.fragment,e),In=n(e),Se=r(e,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-qlsyc4"&&(Se.innerHTML=xf),Gn=n(e),o(Ae.$$.fragment,e),_n=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-l2ug5a"&&(Qe.innerHTML=Hf),kn=n(e),o(Pe.$$.fragment,e),Bn=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-13ae2or"&&(Ee.innerHTML=Lf),xn=n(e),o(ze.$$.fragment,e),Hn=n(e),o(qe.$$.fragment,e),Ln=n(e),De=r(e,"P",{"data-svelte-h":!0}),h(De)!=="svelte-1eocq9t"&&(De.innerHTML=Zf),Zn=n(e),o(Oe.$$.fragment,e),Yn=n(e),o(Ke.$$.fragment,e),Wn=n(e),et=r(e,"P",{"data-svelte-h":!0}),h(et)!=="svelte-ly469j"&&(et.innerHTML=Yf),Xn=n(e),o(tt.$$.fragment,e),Rn=n(e),o(lt.$$.fragment,e),Nn=n(e),st=r(e,"P",{"data-svelte-h":!0}),h(st)!=="svelte-19x7buo"&&(st.textContent=Wf),Fn=n(e),o(at.$$.fragment,e),Vn=n(e),nt=r(e,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-1fv8i0u"&&(nt.innerHTML=Xf),Sn=n(e),o(it.$$.fragment,e),An=n(e),ot=r(e,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-1r9xuva"&&(ot.innerHTML=Rf),Qn=n(e),o(pt.$$.fragment,e),Pn=n(e),ft=r(e,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-18scwa0"&&(ft.innerHTML=Nf),En=n(e),o(dt.$$.fragment,e),zn=n(e),o(ct.$$.fragment,e),qn=n(e),mt=r(e,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-1lf6ab7"&&(mt.textContent=Ff),Dn=n(e),o(rt.$$.fragment,e),On=n(e),ht=r(e,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-1qct02s"&&(ht.textContent=Vf),Kn=n(e),o(ut.$$.fragment,e),ei=n(e),j=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(j)!=="svelte-1v46bff"&&(j.innerHTML=Sf),ti=n(e),gt=r(e,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-m60jhs"&&(gt.textContent=Af),li=n(e),o(yt.$$.fragment,e),si=n(e),$t=r(e,"P",{"data-svelte-h":!0}),h($t)!=="svelte-kcq38o"&&($t.textContent=Qf),ai=n(e),o(Mt.$$.fragment,e),ni=n(e),o(wt.$$.fragment,e),ii=n(e),bt=r(e,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-1mpi1wt"&&(bt.innerHTML=Pf),oi=n(e),o(Tt.$$.fragment,e),pi=n(e),jt=r(e,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-1iulhrs"&&(jt.innerHTML=Ef),fi=n(e),o(vt.$$.fragment,e),di=n(e),o(Jt.$$.fragment,e),ci=n(e),Ut=r(e,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-1ywqnga"&&(Ut.innerHTML=zf),mi=n(e),o(Ct.$$.fragment,e),ri=n(e),o(It.$$.fragment,e),hi=n(e),Gt=r(e,"P",{"data-svelte-h":!0}),h(Gt)!=="svelte-txm5rx"&&(Gt.innerHTML=qf),ui=n(e),o(_t.$$.fragment,e),gi=n(e),o(kt.$$.fragment,e),yi=n(e),Bt=r(e,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-1xth5d1"&&(Bt.innerHTML=Df),$i=n(e),o(xt.$$.fragment,e),Mi=n(e),o(Ht.$$.fragment,e),wi=n(e),Lt=r(e,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-1l1ub93"&&(Lt.innerHTML=Of),bi=n(e),o(Zt.$$.fragment,e),Ti=n(e),Yt=r(e,"P",{"data-svelte-h":!0}),h(Yt)!=="svelte-1eodha9"&&(Yt.innerHTML=Kf),ji=n(e),o(Wt.$$.fragment,e),vi=n(e),Xt=r(e,"P",{"data-svelte-h":!0}),h(Xt)!=="svelte-1mne3q7"&&(Xt.innerHTML=ed),Ji=n(e),o(Rt.$$.fragment,e),Ui=n(e),o(Nt.$$.fragment,e),Ci=n(e),Ft=r(e,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-9drzqd"&&(Ft.innerHTML=td),Ii=n(e),o(Vt.$$.fragment,e),Gi=n(e),o(St.$$.fragment,e),_i=n(e),At=r(e,"P",{"data-svelte-h":!0}),h(At)!=="svelte-14b5hg3"&&(At.innerHTML=ld),ki=n(e),o(Qt.$$.fragment,e),Bi=n(e),o(Pt.$$.fragment,e),xi=n(e),Et=r(e,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-1vujg1i"&&(Et.innerHTML=sd),Hi=n(e),o(zt.$$.fragment,e),Li=n(e),o(qt.$$.fragment,e),Zi=n(e),Dt=r(e,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-11zzu90"&&(Dt.innerHTML=ad),Yi=n(e),o(Ot.$$.fragment,e),Wi=n(e),o(Kt.$$.fragment,e),Xi=n(e),el=r(e,"P",{"data-svelte-h":!0}),h(el)!=="svelte-1bknus5"&&(el.innerHTML=nd),Ri=n(e),o(tl.$$.fragment,e),Ni=n(e),o(ll.$$.fragment,e),Fi=n(e),sl=r(e,"P",{"data-svelte-h":!0}),h(sl)!=="svelte-ji1ygu"&&(sl.textContent=id),Vi=n(e),o(al.$$.fragment,e),Si=n(e),nl=r(e,"P",{"data-svelte-h":!0}),h(nl)!=="svelte-akzc6j"&&(nl.innerHTML=od),Ai=n(e),o(il.$$.fragment,e),Qi=n(e),o(ol.$$.fragment,e),Pi=n(e),pl=r(e,"P",{"data-svelte-h":!0}),h(pl)!=="svelte-rlqaq9"&&(pl.textContent=pd),Ei=n(e),o(fl.$$.fragment,e),zi=n(e),o(dl.$$.fragment,e),qi=n(e),o(cl.$$.fragment,e),Di=n(e),o(ml.$$.fragment,e),Oi=n(e),o(rl.$$.fragment,e),Ki=n(e),hl=r(e,"UL",{"data-svelte-h":!0}),h(hl)!=="svelte-9gpkzp"&&(hl.innerHTML=fd),eo=n(e),o(ul.$$.fragment,e),to=n(e),o(gl.$$.fragment,e),lo=n(e),v=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(v)!=="svelte-1aepcmc"&&(v.innerHTML=dd),so=n(e),o(yl.$$.fragment,e),ao=n(e),$l=r(e,"P",{"data-svelte-h":!0}),h($l)!=="svelte-7je92s"&&($l.innerHTML=cd),no=n(e),o(Ml.$$.fragment,e),io=n(e),wl=r(e,"P",{"data-svelte-h":!0}),h(wl)!=="svelte-1rlrd4r"&&(wl.innerHTML=md),oo=n(e),bl=r(e,"P",{"data-svelte-h":!0}),h(bl)!=="svelte-coq0se"&&(bl.textContent=rd),po=n(e),o(Tl.$$.fragment,e),fo=n(e),jl=r(e,"P",{"data-svelte-h":!0}),h(jl)!=="svelte-1c2af94"&&(jl.textContent=hd),co=n(e),o(vl.$$.fragment,e),mo=n(e),Jl=r(e,"P",{"data-svelte-h":!0}),h(Jl)!=="svelte-1ehfkwh"&&(Jl.textContent=ud),ro=n(e),o(Ul.$$.fragment,e),ho=n(e),o(Cl.$$.fragment,e),uo=n(e),Il=r(e,"P",{"data-svelte-h":!0}),h(Il)!=="svelte-di7lx0"&&(Il.innerHTML=gd),go=n(e),o(Gl.$$.fragment,e),yo=n(e),o(_l.$$.fragment,e),$o=n(e),kl=r(e,"P",{"data-svelte-h":!0}),h(kl)!=="svelte-12x038b"&&(kl.innerHTML=yd),Mo=n(e),o(Bl.$$.fragment,e),wo=n(e),xl=r(e,"P",{"data-svelte-h":!0}),h(xl)!=="svelte-1ujkuhn"&&(xl.innerHTML=$d),bo=n(e),o(Hl.$$.fragment,e),To=n(e),Ll=r(e,"P",{"data-svelte-h":!0}),h(Ll)!=="svelte-1295113"&&(Ll.innerHTML=Md),jo=n(e),Zl=r(e,"P",{"data-svelte-h":!0}),h(Zl)!=="svelte-h2s478"&&(Zl.innerHTML=wd),vo=n(e),o(Yl.$$.fragment,e),Jo=n(e),o(Wl.$$.fragment,e),Uo=n(e),Xl=r(e,"P",{"data-svelte-h":!0}),h(Xl)!=="svelte-1n112qz"&&(Xl.innerHTML=bd),Co=n(e),o(Rl.$$.fragment,e),Io=n(e),Nl=r(e,"P",{"data-svelte-h":!0}),h(Nl)!=="svelte-my607i"&&(Nl.innerHTML=Td),Go=n(e),o(Fl.$$.fragment,e),_o=n(e),Vl=r(e,"P",{"data-svelte-h":!0}),h(Vl)!=="svelte-5qqgdh"&&(Vl.innerHTML=jd),ko=n(e),o(Sl.$$.fragment,e),Bo=n(e),Al=r(e,"P",{"data-svelte-h":!0}),h(Al)!=="svelte-18cutgs"&&(Al.innerHTML=vd),xo=n(e),o(Ql.$$.fragment,e),Ho=n(e),Pl=r(e,"P",{"data-svelte-h":!0}),h(Pl)!=="svelte-8hn497"&&(Pl.innerHTML=Jd),Lo=n(e),o(El.$$.fragment,e),Zo=n(e),zl=r(e,"P",{"data-svelte-h":!0}),h(zl)!=="svelte-19enu7t"&&(zl.innerHTML=Ud),Yo=n(e),o(ql.$$.fragment,e),Wo=n(e),Dl=r(e,"P",{"data-svelte-h":!0}),h(Dl)!=="svelte-128u7bb"&&(Dl.innerHTML=Cd),Xo=n(e),o(Ol.$$.fragment,e),Ro=n(e),o(Kl.$$.fragment,e),No=n(e),es=r(e,"P",{"data-svelte-h":!0}),h(es)!=="svelte-1vhfxqv"&&(es.innerHTML=Id),Fo=n(e),o(ts.$$.fragment,e),Vo=n(e),o(ls.$$.fragment,e),So=n(e),ss=r(e,"P",{"data-svelte-h":!0}),h(ss)!=="svelte-10hqfbc"&&(ss.innerHTML=Gd),Ao=n(e),o(as.$$.fragment,e),Qo=n(e),o(ns.$$.fragment,e),Po=n(e),is=r(e,"P",{"data-svelte-h":!0}),h(is)!=="svelte-1hhwdda"&&(is.innerHTML=_d),Eo=n(e),o(os.$$.fragment,e),zo=n(e),o(ps.$$.fragment,e),qo=n(e),fs=r(e,"P",{"data-svelte-h":!0}),h(fs)!=="svelte-1lxlrp3"&&(fs.innerHTML=kd),Do=n(e),o(ds.$$.fragment,e),Oo=n(e),cs=r(e,"P",{"data-svelte-h":!0}),h(cs)!=="svelte-1j69va"&&(cs.innerHTML=Bd),Ko=n(e),o(ms.$$.fragment,e),ep=n(e),rs=r(e,"P",{"data-svelte-h":!0}),h(rs)!=="svelte-vjzrog"&&(rs.innerHTML=xd),tp=n(e),o(hs.$$.fragment,e),lp=n(e),o(us.$$.fragment,e),sp=n(e),gs=r(e,"P",{"data-svelte-h":!0}),h(gs)!=="svelte-bmrfz1"&&(gs.textContent=Hd),ap=n(e),ys=r(e,"P",{"data-svelte-h":!0}),h(ys)!=="svelte-10n6zcq"&&(ys.innerHTML=Ld),np=n(e),o($s.$$.fragment,e),ip=n(e),o(Ms.$$.fragment,e),op=n(e),ws=r(e,"UL",{"data-svelte-h":!0}),h(ws)!=="svelte-oddjsg"&&(ws.innerHTML=Zd),pp=n(e),J=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(J)!=="svelte-686p08"&&(J.innerHTML=Yd),fp=n(e),o(bs.$$.fragment,e),dp=n(e),o(Ts.$$.fragment,e),cp=n(e),o(js.$$.fragment,e),mp=n(e),vs=r(e,"P",{"data-svelte-h":!0}),h(vs)!=="svelte-7rpon3"&&(vs.innerHTML=Wd),rp=n(e),o(Js.$$.fragment,e),hp=n(e),o(Us.$$.fragment,e),up=n(e),o(Cs.$$.fragment,e),gp=n(e),Is=r(e,"P",{"data-svelte-h":!0}),h(Is)!=="svelte-stito2"&&(Is.innerHTML=Xd),yp=n(e),o(Gs.$$.fragment,e),$p=n(e),_s=r(e,"P",{"data-svelte-h":!0}),h(_s)!=="svelte-130z5ko"&&(_s.textContent=Rd),Mp=n(e),o(ks.$$.fragment,e),wp=n(e),Bs=r(e,"P",{"data-svelte-h":!0}),h(Bs)!=="svelte-u6u7ww"&&(Bs.textContent=Nd),bp=n(e),o(xs.$$.fragment,e),Tp=n(e),Hs=r(e,"UL",{"data-svelte-h":!0}),h(Hs)!=="svelte-6zsta5"&&(Hs.innerHTML=Fd),jp=n(e),o(Ls.$$.fragment,e),vp=n(e),Zs=r(e,"P",{"data-svelte-h":!0}),h(Zs)!=="svelte-1vsg713"&&(Zs.textContent=Vd),Jp=n(e),o(Ys.$$.fragment,e),Up=n(e),o(Ws.$$.fragment,e),Cp=n(e),o(Xs.$$.fragment,e),Ip=n(e),o(Rs.$$.fragment,e),Gp=n(e),U=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),h(U)!=="svelte-13grfj0"&&(U.innerHTML=Sd),_p=n(e),o(Ns.$$.fragment,e),kp=n(e),Fs=r(e,"P",{"data-svelte-h":!0}),h(Fs)!=="svelte-31jqx4"&&(Fs.innerHTML=Ad),Bp=n(e),Vs=r(e,"UL",{"data-svelte-h":!0}),h(Vs)!=="svelte-13lveum"&&(Vs.innerHTML=Qd),xp=n(e),Ss=r(e,"P",{"data-svelte-h":!0}),h(Ss)!=="svelte-2bse8c"&&(Ss.innerHTML=Pd),Hp=n(e),o(As.$$.fragment,e),Lp=n(e),Qs=r(e,"P",{"data-svelte-h":!0}),h(Qs)!=="svelte-qbe5en"&&(Qs.textContent=Ed),Zp=n(e),o(Ps.$$.fragment,e),Yp=n(e),Es=r(e,"P",{"data-svelte-h":!0}),h(Es)!=="svelte-1dnltsa"&&(Es.innerHTML=zd),Wp=n(e),o(zs.$$.fragment,e),Xp=n(e),qs=r(e,"P",{"data-svelte-h":!0}),h(qs)!=="svelte-1hrxwrr"&&(qs.textContent=qd),Rp=n(e),Ds=r(e,"P",{"data-svelte-h":!0}),h(Ds)!=="svelte-10ad6rn"&&(Ds.innerHTML=Dd),Np=n(e),o(Os.$$.fragment,e),Fp=n(e),Ks=r(e,"P",{"data-svelte-h":!0}),h(Ks)!=="svelte-5l4bl6"&&(Ks.innerHTML=Od),Vp=n(e),ea=r(e,"P",{"data-svelte-h":!0}),h(ea)!=="svelte-l9xue4"&&(ea.textContent=Kd),Sp=n(e),o(ta.$$.fragment,e),Ap=n(e),o(la.$$.fragment,e),Qp=n(e),aa=r(e,"P",{}),ec(aa).forEach(l),this.h()},h(){y($,"name","hf:doc:metadata"),y($,"content",cc),y(M,"class","tip"),y(w,"class","tip"),y(b,"class","tip"),y(T,"class","tip"),y(j,"class","tip"),y(v,"class","tip"),y(J,"class","tip"),y(U,"class","tip")},m(e,t){oc(document.head,$),s(e,na,t),s(e,sa,t),s(e,ia,t),p(C,e,t),s(e,oa,t),p(I,e,t),s(e,pa,t),s(e,G,t),s(e,fa,t),s(e,M,t),s(e,da,t),p(_,e,t),s(e,ca,t),s(e,k,t),s(e,ma,t),p(B,e,t),s(e,ra,t),s(e,w,t),s(e,ha,t),s(e,x,t),s(e,ua,t),s(e,H,t),s(e,ga,t),p(L,e,t),s(e,ya,t),s(e,Z,t),s(e,$a,t),p(Y,e,t),s(e,Ma,t),s(e,W,t),s(e,wa,t),p(X,e,t),s(e,ba,t),s(e,R,t),s(e,Ta,t),s(e,b,t),s(e,ja,t),p(N,e,t),s(e,va,t),p(F,e,t),s(e,Ja,t),s(e,V,t),s(e,Ua,t),s(e,S,t),s(e,Ca,t),p(A,e,t),s(e,Ia,t),s(e,Q,t),s(e,Ga,t),p(P,e,t),s(e,_a,t),s(e,E,t),s(e,ka,t),p(z,e,t),s(e,Ba,t),p(q,e,t),s(e,xa,t),s(e,D,t),s(e,Ha,t),p(O,e,t),s(e,La,t),s(e,K,t),s(e,Za,t),p(ee,e,t),s(e,Ya,t),s(e,te,t),s(e,Wa,t),s(e,le,t),s(e,Xa,t),p(se,e,t),s(e,Ra,t),s(e,ae,t),s(e,Na,t),p(ne,e,t),s(e,Fa,t),s(e,ie,t),s(e,Va,t),p(oe,e,t),s(e,Sa,t),s(e,pe,t),s(e,Aa,t),p(fe,e,t),s(e,Qa,t),s(e,de,t),s(e,Pa,t),p(ce,e,t),s(e,Ea,t),s(e,me,t),s(e,za,t),p(re,e,t),s(e,qa,t),s(e,he,t),s(e,Da,t),s(e,ue,t),s(e,Oa,t),p(ge,e,t),s(e,Ka,t),s(e,ye,t),s(e,en,t),p($e,e,t),s(e,tn,t),p(Me,e,t),s(e,ln,t),s(e,we,t),s(e,sn,t),p(be,e,t),s(e,an,t),s(e,Te,t),s(e,nn,t),s(e,je,t),s(e,on,t),p(ve,e,t),s(e,pn,t),p(Je,e,t),s(e,fn,t),s(e,Ue,t),s(e,dn,t),p(Ce,e,t),s(e,cn,t),p(Ie,e,t),s(e,mn,t),s(e,Ge,t),s(e,rn,t),p(_e,e,t),s(e,hn,t),s(e,ke,t),s(e,un,t),p(Be,e,t),s(e,gn,t),p(xe,e,t),s(e,yn,t),s(e,He,t),s(e,$n,t),p(Le,e,t),s(e,Mn,t),p(Ze,e,t),s(e,wn,t),s(e,Ye,t),s(e,bn,t),p(We,e,t),s(e,Tn,t),p(Xe,e,t),s(e,jn,t),s(e,Re,t),s(e,vn,t),s(e,Ne,t),s(e,Jn,t),s(e,T,t),s(e,Un,t),p(Fe,e,t),s(e,Cn,t),p(Ve,e,t),s(e,In,t),s(e,Se,t),s(e,Gn,t),p(Ae,e,t),s(e,_n,t),s(e,Qe,t),s(e,kn,t),p(Pe,e,t),s(e,Bn,t),s(e,Ee,t),s(e,xn,t),p(ze,e,t),s(e,Hn,t),p(qe,e,t),s(e,Ln,t),s(e,De,t),s(e,Zn,t),p(Oe,e,t),s(e,Yn,t),p(Ke,e,t),s(e,Wn,t),s(e,et,t),s(e,Xn,t),p(tt,e,t),s(e,Rn,t),p(lt,e,t),s(e,Nn,t),s(e,st,t),s(e,Fn,t),p(at,e,t),s(e,Vn,t),s(e,nt,t),s(e,Sn,t),p(it,e,t),s(e,An,t),s(e,ot,t),s(e,Qn,t),p(pt,e,t),s(e,Pn,t),s(e,ft,t),s(e,En,t),p(dt,e,t),s(e,zn,t),p(ct,e,t),s(e,qn,t),s(e,mt,t),s(e,Dn,t),p(rt,e,t),s(e,On,t),s(e,ht,t),s(e,Kn,t),p(ut,e,t),s(e,ei,t),s(e,j,t),s(e,ti,t),s(e,gt,t),s(e,li,t),p(yt,e,t),s(e,si,t),s(e,$t,t),s(e,ai,t),p(Mt,e,t),s(e,ni,t),p(wt,e,t),s(e,ii,t),s(e,bt,t),s(e,oi,t),p(Tt,e,t),s(e,pi,t),s(e,jt,t),s(e,fi,t),p(vt,e,t),s(e,di,t),p(Jt,e,t),s(e,ci,t),s(e,Ut,t),s(e,mi,t),p(Ct,e,t),s(e,ri,t),p(It,e,t),s(e,hi,t),s(e,Gt,t),s(e,ui,t),p(_t,e,t),s(e,gi,t),p(kt,e,t),s(e,yi,t),s(e,Bt,t),s(e,$i,t),p(xt,e,t),s(e,Mi,t),p(Ht,e,t),s(e,wi,t),s(e,Lt,t),s(e,bi,t),p(Zt,e,t),s(e,Ti,t),s(e,Yt,t),s(e,ji,t),p(Wt,e,t),s(e,vi,t),s(e,Xt,t),s(e,Ji,t),p(Rt,e,t),s(e,Ui,t),p(Nt,e,t),s(e,Ci,t),s(e,Ft,t),s(e,Ii,t),p(Vt,e,t),s(e,Gi,t),p(St,e,t),s(e,_i,t),s(e,At,t),s(e,ki,t),p(Qt,e,t),s(e,Bi,t),p(Pt,e,t),s(e,xi,t),s(e,Et,t),s(e,Hi,t),p(zt,e,t),s(e,Li,t),p(qt,e,t),s(e,Zi,t),s(e,Dt,t),s(e,Yi,t),p(Ot,e,t),s(e,Wi,t),p(Kt,e,t),s(e,Xi,t),s(e,el,t),s(e,Ri,t),p(tl,e,t),s(e,Ni,t),p(ll,e,t),s(e,Fi,t),s(e,sl,t),s(e,Vi,t),p(al,e,t),s(e,Si,t),s(e,nl,t),s(e,Ai,t),p(il,e,t),s(e,Qi,t),p(ol,e,t),s(e,Pi,t),s(e,pl,t),s(e,Ei,t),p(fl,e,t),s(e,zi,t),p(dl,e,t),s(e,qi,t),p(cl,e,t),s(e,Di,t),p(ml,e,t),s(e,Oi,t),p(rl,e,t),s(e,Ki,t),s(e,hl,t),s(e,eo,t),p(ul,e,t),s(e,to,t),p(gl,e,t),s(e,lo,t),s(e,v,t),s(e,so,t),p(yl,e,t),s(e,ao,t),s(e,$l,t),s(e,no,t),p(Ml,e,t),s(e,io,t),s(e,wl,t),s(e,oo,t),s(e,bl,t),s(e,po,t),p(Tl,e,t),s(e,fo,t),s(e,jl,t),s(e,co,t),p(vl,e,t),s(e,mo,t),s(e,Jl,t),s(e,ro,t),p(Ul,e,t),s(e,ho,t),p(Cl,e,t),s(e,uo,t),s(e,Il,t),s(e,go,t),p(Gl,e,t),s(e,yo,t),p(_l,e,t),s(e,$o,t),s(e,kl,t),s(e,Mo,t),p(Bl,e,t),s(e,wo,t),s(e,xl,t),s(e,bo,t),p(Hl,e,t),s(e,To,t),s(e,Ll,t),s(e,jo,t),s(e,Zl,t),s(e,vo,t),p(Yl,e,t),s(e,Jo,t),p(Wl,e,t),s(e,Uo,t),s(e,Xl,t),s(e,Co,t),p(Rl,e,t),s(e,Io,t),s(e,Nl,t),s(e,Go,t),p(Fl,e,t),s(e,_o,t),s(e,Vl,t),s(e,ko,t),p(Sl,e,t),s(e,Bo,t),s(e,Al,t),s(e,xo,t),p(Ql,e,t),s(e,Ho,t),s(e,Pl,t),s(e,Lo,t),p(El,e,t),s(e,Zo,t),s(e,zl,t),s(e,Yo,t),p(ql,e,t),s(e,Wo,t),s(e,Dl,t),s(e,Xo,t),p(Ol,e,t),s(e,Ro,t),p(Kl,e,t),s(e,No,t),s(e,es,t),s(e,Fo,t),p(ts,e,t),s(e,Vo,t),p(ls,e,t),s(e,So,t),s(e,ss,t),s(e,Ao,t),p(as,e,t),s(e,Qo,t),p(ns,e,t),s(e,Po,t),s(e,is,t),s(e,Eo,t),p(os,e,t),s(e,zo,t),p(ps,e,t),s(e,qo,t),s(e,fs,t),s(e,Do,t),p(ds,e,t),s(e,Oo,t),s(e,cs,t),s(e,Ko,t),p(ms,e,t),s(e,ep,t),s(e,rs,t),s(e,tp,t),p(hs,e,t),s(e,lp,t),p(us,e,t),s(e,sp,t),s(e,gs,t),s(e,ap,t),s(e,ys,t),s(e,np,t),p($s,e,t),s(e,ip,t),p(Ms,e,t),s(e,op,t),s(e,ws,t),s(e,pp,t),s(e,J,t),s(e,fp,t),p(bs,e,t),s(e,dp,t),p(Ts,e,t),s(e,cp,t),p(js,e,t),s(e,mp,t),s(e,vs,t),s(e,rp,t),p(Js,e,t),s(e,hp,t),p(Us,e,t),s(e,up,t),p(Cs,e,t),s(e,gp,t),s(e,Is,t),s(e,yp,t),p(Gs,e,t),s(e,$p,t),s(e,_s,t),s(e,Mp,t),p(ks,e,t),s(e,wp,t),s(e,Bs,t),s(e,bp,t),p(xs,e,t),s(e,Tp,t),s(e,Hs,t),s(e,jp,t),p(Ls,e,t),s(e,vp,t),s(e,Zs,t),s(e,Jp,t),p(Ys,e,t),s(e,Up,t),p(Ws,e,t),s(e,Cp,t),p(Xs,e,t),s(e,Ip,t),p(Rs,e,t),s(e,Gp,t),s(e,U,t),s(e,_p,t),p(Ns,e,t),s(e,kp,t),s(e,Fs,t),s(e,Bp,t),s(e,Vs,t),s(e,xp,t),s(e,Ss,t),s(e,Hp,t),p(As,e,t),s(e,Lp,t),s(e,Qs,t),s(e,Zp,t),p(Ps,e,t),s(e,Yp,t),s(e,Es,t),s(e,Wp,t),p(zs,e,t),s(e,Xp,t),s(e,qs,t),s(e,Rp,t),s(e,Ds,t),s(e,Np,t),p(Os,e,t),s(e,Fp,t),s(e,Ks,t),s(e,Vp,t),s(e,ea,t),s(e,Sp,t),p(ta,e,t),s(e,Ap,t),p(la,e,t),s(e,Qp,t),s(e,aa,t),Pp=!0},p:lc,i(e){Pp||(f(C.$$.fragment,e),f(I.$$.fragment,e),f(_.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(Y.$$.fragment,e),f(X.$$.fragment,e),f(N.$$.fragment,e),f(F.$$.fragment,e),f(A.$$.fragment,e),f(P.$$.fragment,e),f(z.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(fe.$$.fragment,e),f(ce.$$.fragment,e),f(re.$$.fragment,e),f(ge.$$.fragment,e),f($e.$$.fragment,e),f(Me.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(Je.$$.fragment,e),f(Ce.$$.fragment,e),f(Ie.$$.fragment,e),f(_e.$$.fragment,e),f(Be.$$.fragment,e),f(xe.$$.fragment,e),f(Le.$$.fragment,e),f(Ze.$$.fragment,e),f(We.$$.fragment,e),f(Xe.$$.fragment,e),f(Fe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ae.$$.fragment,e),f(Pe.$$.fragment,e),f(ze.$$.fragment,e),f(qe.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(tt.$$.fragment,e),f(lt.$$.fragment,e),f(at.$$.fragment,e),f(it.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(rt.$$.fragment,e),f(ut.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(wt.$$.fragment,e),f(Tt.$$.fragment,e),f(vt.$$.fragment,e),f(Jt.$$.fragment,e),f(Ct.$$.fragment,e),f(It.$$.fragment,e),f(_t.$$.fragment,e),f(kt.$$.fragment,e),f(xt.$$.fragment,e),f(Ht.$$.fragment,e),f(Zt.$$.fragment,e),f(Wt.$$.fragment,e),f(Rt.$$.fragment,e),f(Nt.$$.fragment,e),f(Vt.$$.fragment,e),f(St.$$.fragment,e),f(Qt.$$.fragment,e),f(Pt.$$.fragment,e),f(zt.$$.fragment,e),f(qt.$$.fragment,e),f(Ot.$$.fragment,e),f(Kt.$$.fragment,e),f(tl.$$.fragment,e),f(ll.$$.fragment,e),f(al.$$.fragment,e),f(il.$$.fragment,e),f(ol.$$.fragment,e),f(fl.$$.fragment,e),f(dl.$$.fragment,e),f(cl.$$.fragment,e),f(ml.$$.fragment,e),f(rl.$$.fragment,e),f(ul.$$.fragment,e),f(gl.$$.fragment,e),f(yl.$$.fragment,e),f(Ml.$$.fragment,e),f(Tl.$$.fragment,e),f(vl.$$.fragment,e),f(Ul.$$.fragment,e),f(Cl.$$.fragment,e),f(Gl.$$.fragment,e),f(_l.$$.fragment,e),f(Bl.$$.fragment,e),f(Hl.$$.fragment,e),f(Yl.$$.fragment,e),f(Wl.$$.fragment,e),f(Rl.$$.fragment,e),f(Fl.$$.fragment,e),f(Sl.$$.fragment,e),f(Ql.$$.fragment,e),f(El.$$.fragment,e),f(ql.$$.fragment,e),f(Ol.$$.fragment,e),f(Kl.$$.fragment,e),f(ts.$$.fragment,e),f(ls.$$.fragment,e),f(as.$$.fragment,e),f(ns.$$.fragment,e),f(os.$$.fragment,e),f(ps.$$.fragment,e),f(ds.$$.fragment,e),f(ms.$$.fragment,e),f(hs.$$.fragment,e),f(us.$$.fragment,e),f($s.$$.fragment,e),f(Ms.$$.fragment,e),f(bs.$$.fragment,e),f(Ts.$$.fragment,e),f(js.$$.fragment,e),f(Js.$$.fragment,e),f(Us.$$.fragment,e),f(Cs.$$.fragment,e),f(Gs.$$.fragment,e),f(ks.$$.fragment,e),f(xs.$$.fragment,e),f(Ls.$$.fragment,e),f(Ys.$$.fragment,e),f(Ws.$$.fragment,e),f(Xs.$$.fragment,e),f(Rs.$$.fragment,e),f(Ns.$$.fragment,e),f(As.$$.fragment,e),f(Ps.$$.fragment,e),f(zs.$$.fragment,e),f(Os.$$.fragment,e),f(ta.$$.fragment,e),f(la.$$.fragment,e),Pp=!0)},o(e){d(C.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(B.$$.fragment,e),d(L.$$.fragment,e),d(Y.$$.fragment,e),d(X.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(fe.$$.fragment,e),d(ce.$$.fragment,e),d(re.$$.fragment,e),d(ge.$$.fragment,e),d($e.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(ve.$$.fragment,e),d(Je.$$.fragment,e),d(Ce.$$.fragment,e),d(Ie.$$.fragment,e),d(_e.$$.fragment,e),d(Be.$$.fragment,e),d(xe.$$.fragment,e),d(Le.$$.fragment,e),d(Ze.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(Ve.$$.fragment,e),d(Ae.$$.fragment,e),d(Pe.$$.fragment,e),d(ze.$$.fragment,e),d(qe.$$.fragment,e),d(Oe.$$.fragment,e),d(Ke.$$.fragment,e),d(tt.$$.fragment,e),d(lt.$$.fragment,e),d(at.$$.fragment,e),d(it.$$.fragment,e),d(pt.$$.fragment,e),d(dt.$$.fragment,e),d(ct.$$.fragment,e),d(rt.$$.fragment,e),d(ut.$$.fragment,e),d(yt.$$.fragment,e),d(Mt.$$.fragment,e),d(wt.$$.fragment,e),d(Tt.$$.fragment,e),d(vt.$$.fragment,e),d(Jt.$$.fragment,e),d(Ct.$$.fragment,e),d(It.$$.fragment,e),d(_t.$$.fragment,e),d(kt.$$.fragment,e),d(xt.$$.fragment,e),d(Ht.$$.fragment,e),d(Zt.$$.fragment,e),d(Wt.$$.fragment,e),d(Rt.$$.fragment,e),d(Nt.$$.fragment,e),d(Vt.$$.fragment,e),d(St.$$.fragment,e),d(Qt.$$.fragment,e),d(Pt.$$.fragment,e),d(zt.$$.fragment,e),d(qt.$$.fragment,e),d(Ot.$$.fragment,e),d(Kt.$$.fragment,e),d(tl.$$.fragment,e),d(ll.$$.fragment,e),d(al.$$.fragment,e),d(il.$$.fragment,e),d(ol.$$.fragment,e),d(fl.$$.fragment,e),d(dl.$$.fragment,e),d(cl.$$.fragment,e),d(ml.$$.fragment,e),d(rl.$$.fragment,e),d(ul.$$.fragment,e),d(gl.$$.fragment,e),d(yl.$$.fragment,e),d(Ml.$$.fragment,e),d(Tl.$$.fragment,e),d(vl.$$.fragment,e),d(Ul.$$.fragment,e),d(Cl.$$.fragment,e),d(Gl.$$.fragment,e),d(_l.$$.fragment,e),d(Bl.$$.fragment,e),d(Hl.$$.fragment,e),d(Yl.$$.fragment,e),d(Wl.$$.fragment,e),d(Rl.$$.fragment,e),d(Fl.$$.fragment,e),d(Sl.$$.fragment,e),d(Ql.$$.fragment,e),d(El.$$.fragment,e),d(ql.$$.fragment,e),d(Ol.$$.fragment,e),d(Kl.$$.fragment,e),d(ts.$$.fragment,e),d(ls.$$.fragment,e),d(as.$$.fragment,e),d(ns.$$.fragment,e),d(os.$$.fragment,e),d(ps.$$.fragment,e),d(ds.$$.fragment,e),d(ms.$$.fragment,e),d(hs.$$.fragment,e),d(us.$$.fragment,e),d($s.$$.fragment,e),d(Ms.$$.fragment,e),d(bs.$$.fragment,e),d(Ts.$$.fragment,e),d(js.$$.fragment,e),d(Js.$$.fragment,e),d(Us.$$.fragment,e),d(Cs.$$.fragment,e),d(Gs.$$.fragment,e),d(ks.$$.fragment,e),d(xs.$$.fragment,e),d(Ls.$$.fragment,e),d(Ys.$$.fragment,e),d(Ws.$$.fragment,e),d(Xs.$$.fragment,e),d(Rs.$$.fragment,e),d(Ns.$$.fragment,e),d(As.$$.fragment,e),d(Ps.$$.fragment,e),d(zs.$$.fragment,e),d(Os.$$.fragment,e),d(ta.$$.fragment,e),d(la.$$.fragment,e),Pp=!1},d(e){e&&(l(na),l(sa),l(ia),l(oa),l(pa),l(G),l(fa),l(M),l(da),l(ca),l(k),l(ma),l(ra),l(w),l(ha),l(x),l(ua),l(H),l(ga),l(ya),l(Z),l($a),l(Ma),l(W),l(wa),l(ba),l(R),l(Ta),l(b),l(ja),l(va),l(Ja),l(V),l(Ua),l(S),l(Ca),l(Ia),l(Q),l(Ga),l(_a),l(E),l(ka),l(Ba),l(xa),l(D),l(Ha),l(La),l(K),l(Za),l(Ya),l(te),l(Wa),l(le),l(Xa),l(Ra),l(ae),l(Na),l(Fa),l(ie),l(Va),l(Sa),l(pe),l(Aa),l(Qa),l(de),l(Pa),l(Ea),l(me),l(za),l(qa),l(he),l(Da),l(ue),l(Oa),l(Ka),l(ye),l(en),l(tn),l(ln),l(we),l(sn),l(an),l(Te),l(nn),l(je),l(on),l(pn),l(fn),l(Ue),l(dn),l(cn),l(mn),l(Ge),l(rn),l(hn),l(ke),l(un),l(gn),l(yn),l(He),l($n),l(Mn),l(wn),l(Ye),l(bn),l(Tn),l(jn),l(Re),l(vn),l(Ne),l(Jn),l(T),l(Un),l(Cn),l(In),l(Se),l(Gn),l(_n),l(Qe),l(kn),l(Bn),l(Ee),l(xn),l(Hn),l(Ln),l(De),l(Zn),l(Yn),l(Wn),l(et),l(Xn),l(Rn),l(Nn),l(st),l(Fn),l(Vn),l(nt),l(Sn),l(An),l(ot),l(Qn),l(Pn),l(ft),l(En),l(zn),l(qn),l(mt),l(Dn),l(On),l(ht),l(Kn),l(ei),l(j),l(ti),l(gt),l(li),l(si),l($t),l(ai),l(ni),l(ii),l(bt),l(oi),l(pi),l(jt),l(fi),l(di),l(ci),l(Ut),l(mi),l(ri),l(hi),l(Gt),l(ui),l(gi),l(yi),l(Bt),l($i),l(Mi),l(wi),l(Lt),l(bi),l(Ti),l(Yt),l(ji),l(vi),l(Xt),l(Ji),l(Ui),l(Ci),l(Ft),l(Ii),l(Gi),l(_i),l(At),l(ki),l(Bi),l(xi),l(Et),l(Hi),l(Li),l(Zi),l(Dt),l(Yi),l(Wi),l(Xi),l(el),l(Ri),l(Ni),l(Fi),l(sl),l(Vi),l(Si),l(nl),l(Ai),l(Qi),l(Pi),l(pl),l(Ei),l(zi),l(qi),l(Di),l(Oi),l(Ki),l(hl),l(eo),l(to),l(lo),l(v),l(so),l(ao),l($l),l(no),l(io),l(wl),l(oo),l(bl),l(po),l(fo),l(jl),l(co),l(mo),l(Jl),l(ro),l(ho),l(uo),l(Il),l(go),l(yo),l($o),l(kl),l(Mo),l(wo),l(xl),l(bo),l(To),l(Ll),l(jo),l(Zl),l(vo),l(Jo),l(Uo),l(Xl),l(Co),l(Io),l(Nl),l(Go),l(_o),l(Vl),l(ko),l(Bo),l(Al),l(xo),l(Ho),l(Pl),l(Lo),l(Zo),l(zl),l(Yo),l(Wo),l(Dl),l(Xo),l(Ro),l(No),l(es),l(Fo),l(Vo),l(So),l(ss),l(Ao),l(Qo),l(Po),l(is),l(Eo),l(zo),l(qo),l(fs),l(Do),l(Oo),l(cs),l(Ko),l(ep),l(rs),l(tp),l(lp),l(sp),l(gs),l(ap),l(ys),l(np),l(ip),l(op),l(ws),l(pp),l(J),l(fp),l(dp),l(cp),l(mp),l(vs),l(rp),l(hp),l(up),l(gp),l(Is),l(yp),l($p),l(_s),l(Mp),l(wp),l(Bs),l(bp),l(Tp),l(Hs),l(jp),l(vp),l(Zs),l(Jp),l(Up),l(Cp),l(Ip),l(Gp),l(U),l(_p),l(kp),l(Fs),l(Bp),l(Vs),l(xp),l(Ss),l(Hp),l(Lp),l(Qs),l(Zp),l(Yp),l(Es),l(Wp),l(Xp),l(qs),l(Rp),l(Ds),l(Np),l(Fp),l(Ks),l(Vp),l(ea),l(Sp),l(Ap),l(Qp),l(aa)),l($),c(C,e),c(I,e),c(_,e),c(B,e),c(L,e),c(Y,e),c(X,e),c(N,e),c(F,e),c(A,e),c(P,e),c(z,e),c(q,e),c(O,e),c(ee,e),c(se,e),c(ne,e),c(oe,e),c(fe,e),c(ce,e),c(re,e),c(ge,e),c($e,e),c(Me,e),c(be,e),c(ve,e),c(Je,e),c(Ce,e),c(Ie,e),c(_e,e),c(Be,e),c(xe,e),c(Le,e),c(Ze,e),c(We,e),c(Xe,e),c(Fe,e),c(Ve,e),c(Ae,e),c(Pe,e),c(ze,e),c(qe,e),c(Oe,e),c(Ke,e),c(tt,e),c(lt,e),c(at,e),c(it,e),c(pt,e),c(dt,e),c(ct,e),c(rt,e),c(ut,e),c(yt,e),c(Mt,e),c(wt,e),c(Tt,e),c(vt,e),c(Jt,e),c(Ct,e),c(It,e),c(_t,e),c(kt,e),c(xt,e),c(Ht,e),c(Zt,e),c(Wt,e),c(Rt,e),c(Nt,e),c(Vt,e),c(St,e),c(Qt,e),c(Pt,e),c(zt,e),c(qt,e),c(Ot,e),c(Kt,e),c(tl,e),c(ll,e),c(al,e),c(il,e),c(ol,e),c(fl,e),c(dl,e),c(cl,e),c(ml,e),c(rl,e),c(ul,e),c(gl,e),c(yl,e),c(Ml,e),c(Tl,e),c(vl,e),c(Ul,e),c(Cl,e),c(Gl,e),c(_l,e),c(Bl,e),c(Hl,e),c(Yl,e),c(Wl,e),c(Rl,e),c(Fl,e),c(Sl,e),c(Ql,e),c(El,e),c(ql,e),c(Ol,e),c(Kl,e),c(ts,e),c(ls,e),c(as,e),c(ns,e),c(os,e),c(ps,e),c(ds,e),c(ms,e),c(hs,e),c(us,e),c($s,e),c(Ms,e),c(bs,e),c(Ts,e),c(js,e),c(Js,e),c(Us,e),c(Cs,e),c(Gs,e),c(ks,e),c(xs,e),c(Ls,e),c(Ys,e),c(Ws,e),c(Xs,e),c(Rs,e),c(Ns,e),c(As,e),c(Ps,e),c(zs,e),c(Os,e),c(ta,e),c(la,e)}}}const cc='{"title":"Command Line Interface (CLI)","local":"command-line-interface-cli","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Other installation methods","local":"other-installation-methods","sections":[{"title":"Using uv","local":"using-uv","sections":[],"depth":4},{"title":"Using Homebrew","local":"using-homebrew","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"hf auth login","local":"hf-auth-login","sections":[],"depth":2},{"title":"hf auth whoami","local":"hf-auth-whoami","sections":[],"depth":2},{"title":"hf auth logout","local":"hf-auth-logout","sections":[],"depth":2},{"title":"hf download","local":"hf-download","sections":[{"title":"Download a single file","local":"download-a-single-file","sections":[],"depth":3},{"title":"Download an entire repository","local":"download-an-entire-repository","sections":[],"depth":3},{"title":"Download multiple files","local":"download-multiple-files","sections":[],"depth":3},{"title":"Download a dataset or a Space","local":"download-a-dataset-or-a-space","sections":[],"depth":3},{"title":"Download a specific revision","local":"download-a-specific-revision","sections":[],"depth":3},{"title":"Download to a local folder","local":"download-to-a-local-folder","sections":[],"depth":3},{"title":"Dry-run mode","local":"dry-run-mode","sections":[],"depth":3},{"title":"Specify cache directory","local":"specify-cache-directory","sections":[],"depth":3},{"title":"Specify a token","local":"specify-a-token","sections":[],"depth":3},{"title":"Quiet mode","local":"quiet-mode","sections":[],"depth":3},{"title":"Download timeout","local":"download-timeout","sections":[],"depth":3}],"depth":2},{"title":"hf upload","local":"hf-upload","sections":[{"title":"Upload an entire folder","local":"upload-an-entire-folder","sections":[],"depth":3},{"title":"Upload a single file","local":"upload-a-single-file","sections":[],"depth":3},{"title":"Upload multiple files","local":"upload-multiple-files","sections":[],"depth":3},{"title":"Upload to a dataset or Space","local":"upload-to-a-dataset-or-space","sections":[],"depth":3},{"title":"Upload to an organization","local":"upload-to-an-organization","sections":[],"depth":3},{"title":"Upload to a specific revision","local":"upload-to-a-specific-revision","sections":[],"depth":3},{"title":"Upload and create a PR","local":"upload-and-create-a-pr","sections":[],"depth":3},{"title":"Upload at regular intervals","local":"upload-at-regular-intervals","sections":[],"depth":3},{"title":"Specify a commit message","local":"specify-a-commit-message","sections":[],"depth":3},{"title":"Specify a token","local":"specify-a-token","sections":[],"depth":3},{"title":"Quiet mode","local":"quiet-mode","sections":[],"depth":3}],"depth":2},{"title":"hf repo","local":"hf-repo","sections":[{"title":"Create a repo","local":"create-a-repo","sections":[],"depth":3},{"title":"Delete a repo","local":"delete-a-repo","sections":[],"depth":3},{"title":"Move a repo","local":"move-a-repo","sections":[],"depth":3},{"title":"Update repo settings","local":"update-repo-settings","sections":[],"depth":3},{"title":"Manage branches","local":"manage-branches","sections":[],"depth":3}],"depth":2},{"title":"hf repo-files","local":"hf-repo-files","sections":[{"title":"Delete files","local":"delete-files","sections":[],"depth":3},{"title":"Specify a token","local":"specify-a-token","sections":[],"depth":3}],"depth":2},{"title":"hf cache ls","local":"hf-cache-ls","sections":[],"depth":2},{"title":"hf cache rm","local":"hf-cache-rm","sections":[],"depth":2},{"title":"hf cache prune","local":"hf-cache-prune","sections":[],"depth":2},{"title":"hf repo tag create","local":"hf-repo-tag-create","sections":[{"title":"Tag a model","local":"tag-a-model","sections":[],"depth":3},{"title":"Tag a model at a specific revision","local":"tag-a-model-at-a-specific-revision","sections":[],"depth":3},{"title":"Tag a dataset or a Space","local":"tag-a-dataset-or-a-space","sections":[],"depth":3},{"title":"List tags","local":"list-tags","sections":[],"depth":3},{"title":"Delete a tag","local":"delete-a-tag","sections":[],"depth":3}],"depth":2},{"title":"hf env","local":"hf-env","sections":[],"depth":2},{"title":"hf jobs","local":"hf-jobs","sections":[{"title":"✨ Key Features","local":"-key-features","sections":[],"depth":3},{"title":"Quick Start","local":"quick-start","sections":[{"title":"1. Run your first job","local":"1-run-your-first-job","sections":[],"depth":4},{"title":"2. Check job status","local":"2-check-job-status","sections":[],"depth":4},{"title":"3. Run on GPU","local":"3-run-on-gpu","sections":[],"depth":4}],"depth":3},{"title":"Common Use Cases","local":"common-use-cases","sections":[],"depth":3},{"title":"Pass Environment variables and Secrets","local":"pass-environment-variables-and-secrets","sections":[],"depth":3},{"title":"Hardware","local":"hardware","sections":[],"depth":3},{"title":"UV Scripts (Experimental)","local":"uv-scripts-experimental","sections":[],"depth":3},{"title":"Scheduled Jobs","local":"scheduled-jobs","sections":[],"depth":3}],"depth":2}],"depth":1}';function mc(Ep){return sc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $c extends ac{constructor($){super(),nc(this,$,mc,dc,tc,{})}}export{$c as component};
