import{s as kl,n as ql,o as Wl}from"../chunks/scheduler.0cf4ef2e.js";import{S as $l,i as Bl,e as i,s,c,h as Gl,a as d,d as n,b as a,f as Zl,g as r,j as o,k as m,l as Nl,m as l,n as p,t as u,o as h,p as M}from"../chunks/index.abc433bf.js";import{C as Ql}from"../chunks/CopyLLMTxtMenu.e057ca62.js";import{C as g}from"../chunks/CodeBlock.18a16f91.js";import{H as f,E as El}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.43928862.js";function xl(Bn){let y,Dt,Ot,te,b,ee,_,ne,A,Gn=`Inference is the process of using a trained model to make predictions on new data. Because this process can be compute-intensive, running on a dedicated or external service can be an interesting option.
The <code>huggingface_hub</code> library provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:`,le,v,Nn='<li><a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a>: a streamlined, unified access to hundreds of machine learning models, powered by our serverless inference partners. This new approach builds on our previous Serverless Inference API, offering more models, improved performance, and greater reliability thanks to world-class providers. Refer to the <a href="https://huggingface.co/docs/inference-providers/index#partners" rel="nofollow">documentation</a> for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li> <li>Local endpoints: you can also run inference with local inference servers like <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://ollama.com/" rel="nofollow">Ollama</a>, <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a>, <a href="https://docs.litellm.ai/docs/simple_proxy" rel="nofollow">LiteLLM</a>, or <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a> by connecting the client to these local endpoints.</li>',se,Z,Qn=`<p>[!TIP][InferenceClient](/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient) is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference Providers</a> documentation
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.</p> <p>For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.</p>`,ae,k,ie,q,En="Let’s get started with a text-to-image task:",de,W,oe,$,xn=`In the example above, we initialized an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with a third-party provider, <a href="https://replicate.com/" rel="nofollow">Replicate</a>. When using a provider, you must specify the model you want to use. The model id must be the id of the model on the Hugging Face Hub, not the id of the model from the third-party provider.
In our example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a file. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a> documentation.`,ce,B,Sn='Let’s now see an example using the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> API. This task uses an LLM to generate a response from a list of messages:',re,G,pe,N,Vn='In the example above, we used a third-party provider (<a href="https://www.together.ai/" rel="nofollow">Together AI</a>) and specified which model we want to use (<code>&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</code>). We then gave a list of messages to complete (here, a single question) and passed an additional parameter to the API (<code>max_token=100</code>). The output is a <code>ChatCompletionOutput</code> object that follows the OpenAI specification. The generated content can be accessed with <code>output.choices[0].message.content</code>. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> documentation.',ue,J,Yn=`<p>The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.</p>`,he,Q,Me,E,Ln='If you want to use a specific provider, you can specify it when initializing the client. The default value is “auto” which will select the first of the providers available for the model, sorted by the user’s order in <a href="https://hf.co/settings/inference-providers" rel="nofollow">https://hf.co/settings/inference-providers</a>. Refer to the <a href="#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.',ge,x,fe,S,ye,V,Hn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",me,Y,Je,T,Xn=`<p>When using the “hf-inference” provider, each task comes with a recommended model from the 1M+ models available on the Hub.
However, this recommendation can change over time, so it’s best to explicitly set a model once you’ve decided which one to use.
For third-party providers, you must always specify a model that is compatible with that provider.</p> <p>Visit the <a href="https://huggingface.co/models?inference=warm" rel="nofollow">Models</a> page on the Hub to explore models available through Inference Providers.</p>`,Te,L,we,H,zn=`The examples we saw above use inference providers. While these prove to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,Ie,X,je,z,Rn="Note that you cannot specify both a URL and a provider - they are mutually exclusive. URLs are used to connect directly to deployed endpoints.",Ue,R,Ce,F,Fn='You can use <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> to run chat completion with local inference servers (llama.cpp, vllm, litellm server, TGI, mlx, etc.) running on your own machine. The API should be OpenAI API-compatible.',be,P,_e,w,Pn='<p>Similarly to the OpenAI Python client, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> can be used to run Chat Completion inference with any OpenAI REST API-compatible endpoint.</p>',Ae,O,ve,K,On="Authentication can be done in two ways:",Ze,D,Kn="<strong>Routed through Hugging Face</strong> : Use Hugging Face as a proxy to access third-party providers. The calls will be routed through Hugging Face’s infrastructure using our provider keys, and the usage will be billed directly to your Hugging Face account.",ke,tt,Dn='You can authenticate using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>. You can provide your Hugging Face token directly using the <code>api_key</code> parameter:',qe,et,We,nt,tl='If you <em>don’t</em> pass an <code>api_key</code>, the client will attempt to find and use a token stored locally on your machine. This typically happens if you’ve previously logged in. See the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">Authentication Guide</a> for details on login.',$e,lt,Be,st,el="<strong>Direct access to provider</strong>: Use your own API key to interact directly with the provider’s service:",Ge,at,Ne,it,nl='For more details, refer to the <a href="https://huggingface.co/docs/inference-providers/pricing#routed-requests-vs-direct-calls" rel="nofollow">Inference Providers pricing documentation</a>.',Qe,dt,Ee,ot,ll='<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models, on any provider. It has a simple API that supports the most common tasks. Here is a table showing which providers support which tasks:',xe,ct,sl='<thead><tr><th>Task</th> <th>Black Forest Labs</th> <th>Cerebras</th> <th>Clarifai</th> <th>Cohere</th> <th>fal-ai</th> <th>Featherless AI</th> <th>Fireworks AI</th> <th>Groq</th> <th>HF Inference</th> <th>Hyperbolic</th> <th>Nebius AI Studio</th> <th>Novita AI</th> <th>Nscale</th> <th>Public AI</th> <th>Replicate</th> <th>Sambanova</th> <th>Scaleway</th> <th>Together</th> <th>Wavespeed</th> <th>Zai</th></tr></thead> <tbody><tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_video">image_to_video()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_video">text_to_video()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr></tbody>',Se,I,al='<p>Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task.</p>',Ve,rt,Ye,pt,il='The <code>chat_completion</code> task follows <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI’s Python client</a> syntax. What does it mean for you? It means that if you are used to play with <code>OpenAI</code>’s APIs you will be able to switch to <code>huggingface_hub.InferenceClient</code> to work with open-source models by updating just 2 line of code!',Le,ut,He,ht,dl='And that’s it! The only required changes are to replace <code>from openai import OpenAI</code> by <code>from huggingface_hub import InferenceClient</code> and <code>client = OpenAI(...)</code> by <code>client = InferenceClient(...)</code>. You can choose any LLM model from the Hugging Face Hub by passing its model id as <code>model</code> parameter. <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;other=conversational,text-generation-inference&amp;sort=trending" rel="nofollow">Here is a list</a> of supported models. For authentication, you should pass a valid <a href="https://huggingface.co/settings/tokens" rel="nofollow">User Access Token</a> as <code>api_key</code> or authenticate using <code>huggingface_hub</code> (see the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">authentication guide</a>).',Xe,Mt,ol='All input parameters and output format are strictly the same. In particular, you can pass <code>stream=True</code> to receive tokens as they are generated. You can also use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to run inference using <code>asyncio</code>:',ze,gt,Re,ft,cl='You might wonder why using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> instead of OpenAI’s client? There are a few reasons for that:',Fe,yt,rl='<li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is configured for Hugging Face services. You don’t need to provide a <code>base_url</code> to run models with Inference Providers. You also don’t need to provide a <code>token</code> or <code>api_key</code> if your machine is already correctly logged in.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is tailored for both Text-Generation-Inference (TGI) and <code>transformers</code> frameworks, meaning you are assured it will always be on-par with the latest updates.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is integrated with our Inference Endpoints service, making it easier to launch an Inference Endpoint, check its status and run inference on it. Check out the <a href="./inference_endpoints.md">Inference Endpoints</a> guide for more details.</li>',Pe,j,pl='<p><code>InferenceClient.chat.completions.create</code> is simply an alias for <code>InferenceClient.chat_completion</code>. Check out the package reference of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> for more details. <code>base_url</code> and <code>api_key</code> parameters when instantiating the client are also aliases for <code>model</code> and <code>token</code>. These aliases have been defined to reduce friction when switching from <code>OpenAI</code> to <code>InferenceClient</code>.</p>',Oe,mt,Ke,Jt,ul=`Function calling allows LLMs to interact with external tools, such as defined functions or APIs. This enables users to easily build applications tailored to specific use cases and real-world tasks.
<code>InferenceClient</code> implements the same tool calling interface as the OpenAI Chat Completions API. Here is a simple example of tool calling using <a href="https://nebius.com/" rel="nofollow">Nebius</a> as the inference provider:`,De,Tt,tn,U,hl="<p>Please refer to the providers’ documentation to verify which models are supported by them for Function/Tool Calling.</p>",en,wt,nn,It,Ml="InferenceClient supports JSON mode for syntactically valid JSON responses and Structured Outputs for schema-enforced responses. JSON mode provides machine-readable data without strict structure, while Structured Outputs guarantee both valid JSON and adherence to a predefined schema for reliable downstream processing.",ln,jt,gl='We follow the OpenAI API specs for both JSON mode and Structured Outputs. You can enable them via the <code>response_format</code> argument. Here is an example of Structured Outputs using <a href="https://www.cerebras.ai/" rel="nofollow">Cerebras</a> as the inference provider:',sn,Ut,an,C,fl="<p>Please refer to the providers’ documentation to verify which models are supported by them for Structured Outputs and JSON Mode.</p>",dn,Ct,on,bt,yl='An async version of the client is also provided, based on <code>asyncio</code> and <code>httpx</code>. All async API endpoints are available via <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are strictly the same as the sync-only version.',cn,_t,rn,At,ml='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',pn,vt,un,Zt,Jl='The <code>huggingface_hub</code> library now includes an experimental <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a>, designed to empower Large Language Models (LLMs) with the ability to interact with external Tools via the <a href="https://modelcontextprotocol.io" rel="nofollow">Model Context Protocol</a> (MCP). This client extends an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to seamlessly integrate Tool usage.',hn,kt,Tl='The <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a> connects to MCP servers (either local <code>stdio</code> scripts or remote <code>http</code>/<code>sse</code> services) that expose tools. It feeds these tools to an LLM (via <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>). If the LLM decides to use a tool, <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a> manages the execution request to the MCP server and relays the Tool’s output back to the LLM, often streaming results in real-time.',Mn,qt,wl='In the following example, we use <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> model via <a href="https://nebius.com/" rel="nofollow">Nebius</a> inference provider. We then add a remote MCP server, in this case, an SSE server which made the Flux image generation tool available to the LLM.',gn,Wt,fn,$t,Il='For even simpler development, we offer a higher-level <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.Agent">Agent</a> class. This ‘Tiny Agent’ simplifies creating conversational Agents by managing the chat loop and state, essentially acting as a wrapper around <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a>. It’s designed to be a simple while loop built right on top of an <a href="/docs/huggingface_hub/main/en/package_reference/mcp#huggingface_hub.MCPClient">MCPClient</a>. You can run these Agents directly from the command line:',yn,Bt,mn,Gt,jl="When launched, the Agent will load, list the Tools it has discovered from its connected MCP servers, and then it’s ready for your prompts!",Jn,Nt,Tn,Qt,Ul='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',wn,Et,In,xt,Cl='As an HF user, you get monthly credits to run inference through various providers on the Hub. The amount of credits you get depends on your type of account (Free or PRO or Enterprise Hub). You get charged for every inference request, depending on the provider’s pricing table. By default, the requests are billed to your personal account. However, it is possible to set the billing so that requests are charged to an organization you are part of by simply passing <code>bill_to=&quot;&lt;your_org_name&gt;&quot;</code> to <code>InferenceClient</code>. For this to work, your organization must be subscribed to Enterprise Hub. For more details about billing, check out <a href="https://huggingface.co/docs/api-inference/pricing#features-using-inference-providers" rel="nofollow">this guide</a>.',jn,St,Un,Vt,bl="Note that it is NOT possible to charge another user or an organization you are not part of. If you want to grant someone else some credits, you must create a joint organization with them.",Cn,Yt,bn,Lt,_l='Inference calls can take a significant amount of time. By default, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will wait “indefinitely” until the inference complete. If you want more control in your workflow, you can set the <code>timeout</code> parameter to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised, which you can catch in your code:',_n,Ht,An,Xt,vn,zt,Al=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,Zn,Rt,vl=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
being sent to the API.</li>`,kn,Ft,qn,Pt,Wn,Kt,$n;return b=new Ql({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),_=new f({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),k=new f({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),W=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcGxpY2F0ZV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBcmVwbGljYXRlX2ltYWdlJTIwJTNEJTIwcmVwbGljYXRlX2NsaWVudC50ZXh0X3RvX2ltYWdlKCUwQXJlcGxpY2F0ZV9pbWFnZS5zYXZlKCUyMmZseWluZ19jYXIucG5nJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># Example with an external provider (e.g. replicate)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image = replicate_client.text_to_image(
    <span class="hljs-string">&quot;A flying car crossing a futuristic cityscape.&quot;</span>,
    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image.save(<span class="hljs-string">&quot;flying_car.png&quot;</span>)
`,wrap:!1}}),G=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQWNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
    }
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;together&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_together_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&quot;eos_token&quot;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&quot;assistant&quot;</span>, content=<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, name=<span class="hljs-literal">None</span>, tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>,
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&quot;text_completion&quot;</span>,
    system_fingerprint=<span class="hljs-string">&quot;2.0.4-sha-f426a33&quot;</span>,
    usage=ChatCompletionOutputUsage(completion_tokens=<span class="hljs-number">8</span>, prompt_tokens=<span class="hljs-number">17</span>, total_tokens=<span class="hljs-number">25</span>),
)`,wrap:!1}}),Q=new f({props:{title:"Using a specific provider",local:"using-a-specific-provider",headingTag:"h3"}}),x=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMGFwaV9rZXklM0QlMjJteV9yZXBsaWNhdGVfYXBpX2tleSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;replicate&quot;</span>, api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>)`,wrap:!1}}),S=new f({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),Y=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwbW9kZWwlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQocHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;together&quot;</span>, model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;together&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>)`,wrap:!1}}),L=new f({props:{title:"Using Inference Endpoints",local:"using-inference-endpoints",headingTag:"h3"}}),X=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),R=new f({props:{title:"Using local endpoints",local:"using-local-endpoints",headingTag:"h3"}}),P=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTIyKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMCUwQSklMEFwcmludChyZXNwb25zZS5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;http://localhost:8080&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">100</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),O=new f({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),et=new g({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token</span>
)`,wrap:!1}}),lt=new g({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    token=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token</span>
)`,wrap:!1}}),at=new g({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;r8_****&quot;</span>  <span class="hljs-comment"># Your Replicate API key</span>
)`,wrap:!1}}),dt=new f({props:{title:"Supported providers and tasks",local:"supported-providers-and-tasks",headingTag:"h2"}}),rt=new f({props:{title:"OpenAI compatibility",local:"openai-compatibility",headingTag:"h2"}}),ut=new g({props:{code:"LSUyMGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBLSUyMGNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMkIlMjBjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNELi4uJTJDJTBBKSUwQSUwQSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-deletion">- from openai import OpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import InferenceClient</span>

<span class="hljs-deletion">- client = OpenAI(</span>
<span class="hljs-addition">+ client = InferenceClient(</span>
    base_url=...,
    api_key=...,
)


output = client.chat.completions.create(
    model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
    messages=[
        {&quot;role&quot;: &quot;system&quot;, &quot;content&quot;: &quot;You are a helpful assistant.&quot;},
        {&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Count to 10&quot;},
    ],
    stream=True,
    max_tokens=1024,
)

for chunk in output:
    print(chunk.choices[0].delta.content)`,wrap:!1}}),gt=new g({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQS0lMjBmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwQXN5bmNPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEEtJTIwY2xpZW50JTIwJTNEJTIwQXN5bmNPcGVuQUkoKSUwQSUyQiUyMGNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCklMEElMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`import asyncio
<span class="hljs-deletion">- from openai import AsyncOpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import AsyncInferenceClient</span>

<span class="hljs-deletion">- client = AsyncOpenAI()</span>
<span class="hljs-addition">+ client = AsyncInferenceClient()</span>

async def main():
    stream = await client.chat.completions.create(
        model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
        messages=[{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Say this is a test&quot;}],
        stream=True,
    )
    async for chunk in stream:
        print(chunk.choices[0].delta.content or &quot;&quot;, end=&quot;&quot;)

asyncio.run(main())`,wrap:!1}}),mt=new f({props:{title:"Function Calling",local:"function-calling",headingTag:"h2"}}),Tt=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

tools = [
        {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
            <span class="hljs-string">&quot;function&quot;</span>: {
                <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
                <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get current temperature for a given location.&quot;</span>,
                <span class="hljs-string">&quot;parameters&quot;</span>: {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                    <span class="hljs-string">&quot;properties&quot;</span>: {
                        <span class="hljs-string">&quot;location&quot;</span>: {
                            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;City and country e.g. Paris, France&quot;</span>
                        }
                    },
                    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>],
                },
            }
        }
]

client = InferenceClient(provider=<span class="hljs-string">&quot;nebius&quot;</span>)

response = client.chat.completions.create(
    model=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
    messages=[
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in London, UK?&quot;</span>
    }
    ],
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
)

<span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function.arguments)
`,wrap:!1}}),wt=new f({props:{title:"Structured Outputs & JSON Mode",local:"structured-outputs--json-mode",headingTag:"h2"}}),Ut=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

json_schema = {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;book&quot;</span>,
    <span class="hljs-string">&quot;schema&quot;</span>: {
        <span class="hljs-string">&quot;properties&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: {
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Name&quot;</span>,
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            },
            <span class="hljs-string">&quot;authors&quot;</span>: {
                <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Authors&quot;</span>,
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>,
            },
        },
        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;name&quot;</span>, <span class="hljs-string">&quot;authors&quot;</span>],
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Book&quot;</span>,
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
    },
    <span class="hljs-string">&quot;strict&quot;</span>: <span class="hljs-literal">True</span>,
}

client = InferenceClient(provider=<span class="hljs-string">&quot;cerebras&quot;</span>)


completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;Qwen/Qwen3-32B&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Extract the books information.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I recently read &#x27;The Great Gatsby&#x27; by F. Scott Fitzgerald.&quot;</span>},
    ],
    response_format={
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json_schema&quot;</span>,
        <span class="hljs-string">&quot;json_schema&quot;</span>: json_schema,
    },
)

<span class="hljs-built_in">print</span>(completion.choices[<span class="hljs-number">0</span>].message)`,wrap:!1}}),Ct=new f({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),_t=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in an asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),vt=new f({props:{title:"MCP Client",local:"mcp-client",headingTag:"h2"}}),Wt=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ChatCompletionInputMessage, ChatCompletionStreamOutput, MCPClient


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> MCPClient(
        provider=<span class="hljs-string">&quot;nebius&quot;</span>,
        model=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>,
        api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>],
    ) <span class="hljs-keyword">as</span> client:
        <span class="hljs-keyword">await</span> client.add_mcp_server(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;sse&quot;</span>, url=<span class="hljs-string">&quot;https://evalstate-flux1-schnell.hf.space/gradio_api/mcp/sse&quot;</span>)

        messages = [
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Generate a picture of a cat on the moon&quot;</span>,
            }
        ]

        <span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> client.process_single_turn_with_tools(messages):
            <span class="hljs-comment"># Log messages</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(chunk, ChatCompletionStreamOutput):
                delta = chunk.choices[<span class="hljs-number">0</span>].delta
                <span class="hljs-keyword">if</span> delta.content:
                    <span class="hljs-built_in">print</span>(delta.content, end=<span class="hljs-string">&quot;&quot;</span>)

            <span class="hljs-comment"># Or tool calls</span>
            <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(chunk, ChatCompletionInputMessage):
                <span class="hljs-built_in">print</span>(
                    <span class="hljs-string">f&quot;\\nCalled tool &#x27;<span class="hljs-subst">{chunk.name}</span>&#x27;. Result: &#x27;<span class="hljs-subst">{chunk.content <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(chunk.content) &lt; <span class="hljs-number">1000</span> <span class="hljs-keyword">else</span> chunk.content[:<span class="hljs-number">1000</span>] + <span class="hljs-string">&#x27;...&#x27;</span>}</span>&#x27;&quot;</span>
                )


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-keyword">import</span> asyncio

    asyncio.run(main())`,wrap:!1}}),Bt=new g({props:{code:"JTIzJTIwaW5zdGFsbCUyMGxhdGVzdCUyMHZlcnNpb24lMjBvZiUyMGh1Z2dpbmdmYWNlX2h1YiUyMHdpdGglMjB0aGUlMjBtY3AlMjBleHRyYSUwQXBpcCUyMGluc3RhbGwlMjAtVSUyMGh1Z2dpbmdmYWNlX2h1YiU1Qm1jcCU1RCUwQSUyMyUyMFJ1biUyMGFuJTIwYWdlbnQlMjB0aGF0JTIwdXNlcyUyMHRoZSUyMEZsdXglMjBpbWFnZSUyMGdlbmVyYXRpb24lMjB0b29sJTBBdGlueS1hZ2VudHMlMjBydW4lMjBqdWxpZW4tYyUyRmZsdXgtc2NobmVsbC1nZW5lcmF0b3IlMEE=",highlighted:`<span class="hljs-comment"># install latest version of huggingface_hub with the mcp extra</span>
pip install -U huggingface_hub[mcp]
<span class="hljs-comment"># Run an agent that uses the Flux image generation tool</span>
tiny-agents run julien-c/flux-schnell-generator
`,wrap:!1}}),Nt=new f({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),Et=new f({props:{title:"Billing",local:"billing",headingTag:"h3"}}),St=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMGJpbGxfdG8lM0QlMjJvcGVuYWklMjIpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;fal-ai&quot;</span>, bill_to=<span class="hljs-string">&quot;openai&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),Yt=new f({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),Ht=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),Xt=new f({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),Ft=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),Pt=new El({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){y=i("meta"),Dt=s(),Ot=i("p"),te=s(),c(b.$$.fragment),ee=s(),c(_.$$.fragment),ne=s(),A=i("p"),A.innerHTML=Gn,le=s(),v=i("ol"),v.innerHTML=Nn,se=s(),Z=i("blockquote"),Z.innerHTML=Qn,ae=s(),c(k.$$.fragment),ie=s(),q=i("p"),q.textContent=En,de=s(),c(W.$$.fragment),oe=s(),$=i("p"),$.innerHTML=xn,ce=s(),B=i("p"),B.innerHTML=Sn,re=s(),c(G.$$.fragment),pe=s(),N=i("p"),N.innerHTML=Vn,ue=s(),J=i("blockquote"),J.innerHTML=Yn,he=s(),c(Q.$$.fragment),Me=s(),E=i("p"),E.innerHTML=Ln,ge=s(),c(x.$$.fragment),fe=s(),c(S.$$.fragment),ye=s(),V=i("p"),V.textContent=Hn,me=s(),c(Y.$$.fragment),Je=s(),T=i("blockquote"),T.innerHTML=Xn,Te=s(),c(L.$$.fragment),we=s(),H=i("p"),H.innerHTML=zn,Ie=s(),c(X.$$.fragment),je=s(),z=i("p"),z.textContent=Rn,Ue=s(),c(R.$$.fragment),Ce=s(),F=i("p"),F.innerHTML=Fn,be=s(),c(P.$$.fragment),_e=s(),w=i("blockquote"),w.innerHTML=Pn,Ae=s(),c(O.$$.fragment),ve=s(),K=i("p"),K.textContent=On,Ze=s(),D=i("p"),D.innerHTML=Kn,ke=s(),tt=i("p"),tt.innerHTML=Dn,qe=s(),c(et.$$.fragment),We=s(),nt=i("p"),nt.innerHTML=tl,$e=s(),c(lt.$$.fragment),Be=s(),st=i("p"),st.innerHTML=el,Ge=s(),c(at.$$.fragment),Ne=s(),it=i("p"),it.innerHTML=nl,Qe=s(),c(dt.$$.fragment),Ee=s(),ot=i("p"),ot.innerHTML=ll,xe=s(),ct=i("table"),ct.innerHTML=sl,Se=s(),I=i("blockquote"),I.innerHTML=al,Ve=s(),c(rt.$$.fragment),Ye=s(),pt=i("p"),pt.innerHTML=il,Le=s(),c(ut.$$.fragment),He=s(),ht=i("p"),ht.innerHTML=dl,Xe=s(),Mt=i("p"),Mt.innerHTML=ol,ze=s(),c(gt.$$.fragment),Re=s(),ft=i("p"),ft.innerHTML=cl,Fe=s(),yt=i("ol"),yt.innerHTML=rl,Pe=s(),j=i("blockquote"),j.innerHTML=pl,Oe=s(),c(mt.$$.fragment),Ke=s(),Jt=i("p"),Jt.innerHTML=ul,De=s(),c(Tt.$$.fragment),tn=s(),U=i("blockquote"),U.innerHTML=hl,en=s(),c(wt.$$.fragment),nn=s(),It=i("p"),It.textContent=Ml,ln=s(),jt=i("p"),jt.innerHTML=gl,sn=s(),c(Ut.$$.fragment),an=s(),C=i("blockquote"),C.innerHTML=fl,dn=s(),c(Ct.$$.fragment),on=s(),bt=i("p"),bt.innerHTML=yl,cn=s(),c(_t.$$.fragment),rn=s(),At=i("p"),At.innerHTML=ml,pn=s(),c(vt.$$.fragment),un=s(),Zt=i("p"),Zt.innerHTML=Jl,hn=s(),kt=i("p"),kt.innerHTML=Tl,Mn=s(),qt=i("p"),qt.innerHTML=wl,gn=s(),c(Wt.$$.fragment),fn=s(),$t=i("p"),$t.innerHTML=Il,yn=s(),c(Bt.$$.fragment),mn=s(),Gt=i("p"),Gt.textContent=jl,Jn=s(),c(Nt.$$.fragment),Tn=s(),Qt=i("p"),Qt.innerHTML=Ul,wn=s(),c(Et.$$.fragment),In=s(),xt=i("p"),xt.innerHTML=Cl,jn=s(),c(St.$$.fragment),Un=s(),Vt=i("p"),Vt.textContent=bl,Cn=s(),c(Yt.$$.fragment),bn=s(),Lt=i("p"),Lt.innerHTML=_l,_n=s(),c(Ht.$$.fragment),An=s(),c(Xt.$$.fragment),vn=s(),zt=i("p"),zt.innerHTML=Al,Zn=s(),Rt=i("ul"),Rt.innerHTML=vl,kn=s(),c(Ft.$$.fragment),qn=s(),c(Pt.$$.fragment),Wn=s(),Kt=i("p"),this.h()},l(t){const e=Gl("svelte-u9bgzb",document.head);y=d(e,"META",{name:!0,content:!0}),e.forEach(n),Dt=a(t),Ot=d(t,"P",{}),Zl(Ot).forEach(n),te=a(t),r(b.$$.fragment,t),ee=a(t),r(_.$$.fragment,t),ne=a(t),A=d(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-zsbuba"&&(A.innerHTML=Gn),le=a(t),v=d(t,"OL",{"data-svelte-h":!0}),o(v)!=="svelte-113kt9p"&&(v.innerHTML=Nn),se=a(t),Z=d(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Z)!=="svelte-1h6g06x"&&(Z.innerHTML=Qn),ae=a(t),r(k.$$.fragment,t),ie=a(t),q=d(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-8lplub"&&(q.textContent=En),de=a(t),r(W.$$.fragment,t),oe=a(t),$=d(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-181xjky"&&($.innerHTML=xn),ce=a(t),B=d(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1d6dn6"&&(B.innerHTML=Sn),re=a(t),r(G.$$.fragment,t),pe=a(t),N=d(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-19dgkah"&&(N.innerHTML=Vn),ue=a(t),J=d(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-1im02a2"&&(J.innerHTML=Yn),he=a(t),r(Q.$$.fragment,t),Me=a(t),E=d(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1uw3jfu"&&(E.innerHTML=Ln),ge=a(t),r(x.$$.fragment,t),fe=a(t),r(S.$$.fragment,t),ye=a(t),V=d(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1npu22n"&&(V.textContent=Hn),me=a(t),r(Y.$$.fragment,t),Je=a(t),T=d(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-8zte8z"&&(T.innerHTML=Xn),Te=a(t),r(L.$$.fragment,t),we=a(t),H=d(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-iygc0l"&&(H.innerHTML=zn),Ie=a(t),r(X.$$.fragment,t),je=a(t),z=d(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1yhw21f"&&(z.textContent=Rn),Ue=a(t),r(R.$$.fragment,t),Ce=a(t),F=d(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-76vbgt"&&(F.innerHTML=Fn),be=a(t),r(P.$$.fragment,t),_e=a(t),w=d(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1txgmcz"&&(w.innerHTML=Pn),Ae=a(t),r(O.$$.fragment,t),ve=a(t),K=d(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-ifnzw0"&&(K.textContent=On),Ze=a(t),D=d(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-6ufbtw"&&(D.innerHTML=Kn),ke=a(t),tt=d(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-vhv07e"&&(tt.innerHTML=Dn),qe=a(t),r(et.$$.fragment,t),We=a(t),nt=d(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-jlpf96"&&(nt.innerHTML=tl),$e=a(t),r(lt.$$.fragment,t),Be=a(t),st=d(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-zxs6jj"&&(st.innerHTML=el),Ge=a(t),r(at.$$.fragment,t),Ne=a(t),it=d(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1sxee5g"&&(it.innerHTML=nl),Qe=a(t),r(dt.$$.fragment,t),Ee=a(t),ot=d(t,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-qhknp8"&&(ot.innerHTML=ll),xe=a(t),ct=d(t,"TABLE",{"data-svelte-h":!0}),o(ct)!=="svelte-p9owas"&&(ct.innerHTML=sl),Se=a(t),I=d(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-md3cnz"&&(I.innerHTML=al),Ve=a(t),r(rt.$$.fragment,t),Ye=a(t),pt=d(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-bmxago"&&(pt.innerHTML=il),Le=a(t),r(ut.$$.fragment,t),He=a(t),ht=d(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-94ddrt"&&(ht.innerHTML=dl),Xe=a(t),Mt=d(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1wef96y"&&(Mt.innerHTML=ol),ze=a(t),r(gt.$$.fragment,t),Re=a(t),ft=d(t,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-u2g99k"&&(ft.innerHTML=cl),Fe=a(t),yt=d(t,"OL",{"data-svelte-h":!0}),o(yt)!=="svelte-zypjkb"&&(yt.innerHTML=rl),Pe=a(t),j=d(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-bljxn9"&&(j.innerHTML=pl),Oe=a(t),r(mt.$$.fragment,t),Ke=a(t),Jt=d(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1msz1zo"&&(Jt.innerHTML=ul),De=a(t),r(Tt.$$.fragment,t),tn=a(t),U=d(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1kcfjbk"&&(U.innerHTML=hl),en=a(t),r(wt.$$.fragment,t),nn=a(t),It=d(t,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1azpgbc"&&(It.textContent=Ml),ln=a(t),jt=d(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1s174wl"&&(jt.innerHTML=gl),sn=a(t),r(Ut.$$.fragment,t),an=a(t),C=d(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1it8zvg"&&(C.innerHTML=fl),dn=a(t),r(Ct.$$.fragment,t),on=a(t),bt=d(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1jfuh3p"&&(bt.innerHTML=yl),cn=a(t),r(_t.$$.fragment,t),rn=a(t),At=d(t,"P",{"data-svelte-h":!0}),o(At)!=="svelte-q492az"&&(At.innerHTML=ml),pn=a(t),r(vt.$$.fragment,t),un=a(t),Zt=d(t,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1th564v"&&(Zt.innerHTML=Jl),hn=a(t),kt=d(t,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-nzyq5x"&&(kt.innerHTML=Tl),Mn=a(t),qt=d(t,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-puwxdd"&&(qt.innerHTML=wl),gn=a(t),r(Wt.$$.fragment,t),fn=a(t),$t=d(t,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1epk0qj"&&($t.innerHTML=Il),yn=a(t),r(Bt.$$.fragment,t),mn=a(t),Gt=d(t,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-e0mc18"&&(Gt.textContent=jl),Jn=a(t),r(Nt.$$.fragment,t),Tn=a(t),Qt=d(t,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-2b1sa3"&&(Qt.innerHTML=Ul),wn=a(t),r(Et.$$.fragment,t),In=a(t),xt=d(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-6rcpvw"&&(xt.innerHTML=Cl),jn=a(t),r(St.$$.fragment,t),Un=a(t),Vt=d(t,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1hpvtqi"&&(Vt.textContent=bl),Cn=a(t),r(Yt.$$.fragment,t),bn=a(t),Lt=d(t,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-t8yvyu"&&(Lt.innerHTML=_l),_n=a(t),r(Ht.$$.fragment,t),An=a(t),r(Xt.$$.fragment,t),vn=a(t),zt=d(t,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-4hhs15"&&(zt.innerHTML=Al),Zn=a(t),Rt=d(t,"UL",{"data-svelte-h":!0}),o(Rt)!=="svelte-1o9a3e0"&&(Rt.innerHTML=vl),kn=a(t),r(Ft.$$.fragment,t),qn=a(t),r(Pt.$$.fragment,t),Wn=a(t),Kt=d(t,"P",{}),Zl(Kt).forEach(n),this.h()},h(){m(y,"name","hf:doc:metadata"),m(y,"content",Sl),m(J,"class","warning"),m(T,"class","tip"),m(w,"class","tip"),m(I,"class","tip"),m(j,"class","tip"),m(U,"class","tip"),m(C,"class","tip")},m(t,e){Nl(document.head,y),l(t,Dt,e),l(t,Ot,e),l(t,te,e),p(b,t,e),l(t,ee,e),p(_,t,e),l(t,ne,e),l(t,A,e),l(t,le,e),l(t,v,e),l(t,se,e),l(t,Z,e),l(t,ae,e),p(k,t,e),l(t,ie,e),l(t,q,e),l(t,de,e),p(W,t,e),l(t,oe,e),l(t,$,e),l(t,ce,e),l(t,B,e),l(t,re,e),p(G,t,e),l(t,pe,e),l(t,N,e),l(t,ue,e),l(t,J,e),l(t,he,e),p(Q,t,e),l(t,Me,e),l(t,E,e),l(t,ge,e),p(x,t,e),l(t,fe,e),p(S,t,e),l(t,ye,e),l(t,V,e),l(t,me,e),p(Y,t,e),l(t,Je,e),l(t,T,e),l(t,Te,e),p(L,t,e),l(t,we,e),l(t,H,e),l(t,Ie,e),p(X,t,e),l(t,je,e),l(t,z,e),l(t,Ue,e),p(R,t,e),l(t,Ce,e),l(t,F,e),l(t,be,e),p(P,t,e),l(t,_e,e),l(t,w,e),l(t,Ae,e),p(O,t,e),l(t,ve,e),l(t,K,e),l(t,Ze,e),l(t,D,e),l(t,ke,e),l(t,tt,e),l(t,qe,e),p(et,t,e),l(t,We,e),l(t,nt,e),l(t,$e,e),p(lt,t,e),l(t,Be,e),l(t,st,e),l(t,Ge,e),p(at,t,e),l(t,Ne,e),l(t,it,e),l(t,Qe,e),p(dt,t,e),l(t,Ee,e),l(t,ot,e),l(t,xe,e),l(t,ct,e),l(t,Se,e),l(t,I,e),l(t,Ve,e),p(rt,t,e),l(t,Ye,e),l(t,pt,e),l(t,Le,e),p(ut,t,e),l(t,He,e),l(t,ht,e),l(t,Xe,e),l(t,Mt,e),l(t,ze,e),p(gt,t,e),l(t,Re,e),l(t,ft,e),l(t,Fe,e),l(t,yt,e),l(t,Pe,e),l(t,j,e),l(t,Oe,e),p(mt,t,e),l(t,Ke,e),l(t,Jt,e),l(t,De,e),p(Tt,t,e),l(t,tn,e),l(t,U,e),l(t,en,e),p(wt,t,e),l(t,nn,e),l(t,It,e),l(t,ln,e),l(t,jt,e),l(t,sn,e),p(Ut,t,e),l(t,an,e),l(t,C,e),l(t,dn,e),p(Ct,t,e),l(t,on,e),l(t,bt,e),l(t,cn,e),p(_t,t,e),l(t,rn,e),l(t,At,e),l(t,pn,e),p(vt,t,e),l(t,un,e),l(t,Zt,e),l(t,hn,e),l(t,kt,e),l(t,Mn,e),l(t,qt,e),l(t,gn,e),p(Wt,t,e),l(t,fn,e),l(t,$t,e),l(t,yn,e),p(Bt,t,e),l(t,mn,e),l(t,Gt,e),l(t,Jn,e),p(Nt,t,e),l(t,Tn,e),l(t,Qt,e),l(t,wn,e),p(Et,t,e),l(t,In,e),l(t,xt,e),l(t,jn,e),p(St,t,e),l(t,Un,e),l(t,Vt,e),l(t,Cn,e),p(Yt,t,e),l(t,bn,e),l(t,Lt,e),l(t,_n,e),p(Ht,t,e),l(t,An,e),p(Xt,t,e),l(t,vn,e),l(t,zt,e),l(t,Zn,e),l(t,Rt,e),l(t,kn,e),p(Ft,t,e),l(t,qn,e),p(Pt,t,e),l(t,Wn,e),l(t,Kt,e),$n=!0},p:ql,i(t){$n||(u(b.$$.fragment,t),u(_.$$.fragment,t),u(k.$$.fragment,t),u(W.$$.fragment,t),u(G.$$.fragment,t),u(Q.$$.fragment,t),u(x.$$.fragment,t),u(S.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(X.$$.fragment,t),u(R.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(dt.$$.fragment,t),u(rt.$$.fragment,t),u(ut.$$.fragment,t),u(gt.$$.fragment,t),u(mt.$$.fragment,t),u(Tt.$$.fragment,t),u(wt.$$.fragment,t),u(Ut.$$.fragment,t),u(Ct.$$.fragment,t),u(_t.$$.fragment,t),u(vt.$$.fragment,t),u(Wt.$$.fragment,t),u(Bt.$$.fragment,t),u(Nt.$$.fragment,t),u(Et.$$.fragment,t),u(St.$$.fragment,t),u(Yt.$$.fragment,t),u(Ht.$$.fragment,t),u(Xt.$$.fragment,t),u(Ft.$$.fragment,t),u(Pt.$$.fragment,t),$n=!0)},o(t){h(b.$$.fragment,t),h(_.$$.fragment,t),h(k.$$.fragment,t),h(W.$$.fragment,t),h(G.$$.fragment,t),h(Q.$$.fragment,t),h(x.$$.fragment,t),h(S.$$.fragment,t),h(Y.$$.fragment,t),h(L.$$.fragment,t),h(X.$$.fragment,t),h(R.$$.fragment,t),h(P.$$.fragment,t),h(O.$$.fragment,t),h(et.$$.fragment,t),h(lt.$$.fragment,t),h(at.$$.fragment,t),h(dt.$$.fragment,t),h(rt.$$.fragment,t),h(ut.$$.fragment,t),h(gt.$$.fragment,t),h(mt.$$.fragment,t),h(Tt.$$.fragment,t),h(wt.$$.fragment,t),h(Ut.$$.fragment,t),h(Ct.$$.fragment,t),h(_t.$$.fragment,t),h(vt.$$.fragment,t),h(Wt.$$.fragment,t),h(Bt.$$.fragment,t),h(Nt.$$.fragment,t),h(Et.$$.fragment,t),h(St.$$.fragment,t),h(Yt.$$.fragment,t),h(Ht.$$.fragment,t),h(Xt.$$.fragment,t),h(Ft.$$.fragment,t),h(Pt.$$.fragment,t),$n=!1},d(t){t&&(n(Dt),n(Ot),n(te),n(ee),n(ne),n(A),n(le),n(v),n(se),n(Z),n(ae),n(ie),n(q),n(de),n(oe),n($),n(ce),n(B),n(re),n(pe),n(N),n(ue),n(J),n(he),n(Me),n(E),n(ge),n(fe),n(ye),n(V),n(me),n(Je),n(T),n(Te),n(we),n(H),n(Ie),n(je),n(z),n(Ue),n(Ce),n(F),n(be),n(_e),n(w),n(Ae),n(ve),n(K),n(Ze),n(D),n(ke),n(tt),n(qe),n(We),n(nt),n($e),n(Be),n(st),n(Ge),n(Ne),n(it),n(Qe),n(Ee),n(ot),n(xe),n(ct),n(Se),n(I),n(Ve),n(Ye),n(pt),n(Le),n(He),n(ht),n(Xe),n(Mt),n(ze),n(Re),n(ft),n(Fe),n(yt),n(Pe),n(j),n(Oe),n(Ke),n(Jt),n(De),n(tn),n(U),n(en),n(nn),n(It),n(ln),n(jt),n(sn),n(an),n(C),n(dn),n(on),n(bt),n(cn),n(rn),n(At),n(pn),n(un),n(Zt),n(hn),n(kt),n(Mn),n(qt),n(gn),n(fn),n($t),n(yn),n(mn),n(Gt),n(Jn),n(Tn),n(Qt),n(wn),n(In),n(xt),n(jn),n(Un),n(Vt),n(Cn),n(bn),n(Lt),n(_n),n(An),n(vn),n(zt),n(Zn),n(Rt),n(kn),n(qn),n(Wn),n(Kt)),n(y),M(b,t),M(_,t),M(k,t),M(W,t),M(G,t),M(Q,t),M(x,t),M(S,t),M(Y,t),M(L,t),M(X,t),M(R,t),M(P,t),M(O,t),M(et,t),M(lt,t),M(at,t),M(dt,t),M(rt,t),M(ut,t),M(gt,t),M(mt,t),M(Tt,t),M(wt,t),M(Ut,t),M(Ct,t),M(_t,t),M(vt,t),M(Wt,t),M(Bt,t),M(Nt,t),M(Et,t),M(St,t),M(Yt,t),M(Ht,t),M(Xt,t),M(Ft,t),M(Pt,t)}}}const Sl='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific provider","local":"using-a-specific-provider","sections":[],"depth":3},{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using Inference Endpoints","local":"using-inference-endpoints","sections":[],"depth":3},{"title":"Using local endpoints","local":"using-local-endpoints","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"Supported providers and tasks","local":"supported-providers-and-tasks","sections":[],"depth":2},{"title":"OpenAI compatibility","local":"openai-compatibility","sections":[],"depth":2},{"title":"Function Calling","local":"function-calling","sections":[],"depth":2},{"title":"Structured Outputs & JSON Mode","local":"structured-outputs--json-mode","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"MCP Client","local":"mcp-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Billing","local":"billing","sections":[],"depth":3},{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2}],"depth":1}';function Vl(Bn){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends $l{constructor(y){super(),Bl(this,y,Vl,xl,kl,{})}}export{Rl as component};
