# Authentication

The `huggingface_hub` library allows users to programmatically manage authentication to the Hub. This includes logging in, logging out, switching between tokens, and listing available tokens.

For more details about authentication, check out [this section](../quick-start#authentication).

## login[[huggingface_hub.login]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.login</name><anchor>huggingface_hub.login</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_login.py#L59</source><parameters>[{"name": "token", "val": ": typing.Optional[str] = None"}, {"name": "add_to_git_credential", "val": ": bool = False"}, {"name": "skip_if_logged_in", "val": ": bool = False"}]</parameters><paramsdesc>- **token** (`str`, *optional*) --
  User access token to generate from https://huggingface.co/settings/token.
- **add_to_git_credential** (`bool`, defaults to `False`) --
  If `True`, token will be set as git credential. If no git credential helper
  is configured, a warning will be displayed to the user. If `token` is `None`,
  the value of `add_to_git_credential` is ignored and will be prompted again
  to the end user.
- **skip_if_logged_in** (`bool`, defaults to `False`) --
  If `True`, do not prompt for token if user is already logged in.</paramsdesc><paramgroups>0</paramgroups><raises>- [`ValueError`](https://docs.python.org/3/library/exceptions.html#ValueError) -- 
  If an organization token is passed. Only personal account tokens are valid
  to log in.
- [`ValueError`](https://docs.python.org/3/library/exceptions.html#ValueError) -- 
  If token is invalid.
- [`ImportError`](https://docs.python.org/3/library/exceptions.html#ImportError) -- 
  If running in a notebook but `ipywidgets` is not installed.</raises><raisederrors>``ValueError`` or ``ImportError``</raisederrors></docstring>
Login the machine to access the Hub.

The `token` is persisted in cache and set as a git credential. Once done, the machine
is logged in and the access token will be available across all `huggingface_hub`
components. If `token` is not provided, it will be prompted to the user either with
a widget (in a notebook) or via the terminal.

To log in from outside of a script, one can also use `hf auth login` which is
a cli command that wraps [login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login).

> [!TIP]
> [login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login) is a drop-in replacement method for [notebook_login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.notebook_login) as it wraps and
> extends its capabilities.

> [!TIP]
> When the token is not passed, [login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login) will automatically detect if the script runs
> in a notebook or not. However, this detection might not be accurate due to the
> variety of notebooks that exists nowadays. If that is the case, you can always force
> the UI by using [notebook_login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.notebook_login) or [interpreter_login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.interpreter_login).








</div>

## interpreter_login[[huggingface_hub.interpreter_login]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.interpreter_login</name><anchor>huggingface_hub.interpreter_login</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_login.py#L231</source><parameters>[{"name": "skip_if_logged_in", "val": ": bool = False"}]</parameters><paramsdesc>- **skip_if_logged_in** (`bool`, defaults to `False`) --
  If `True`, do not prompt for token if user is already logged in.</paramsdesc><paramgroups>0</paramgroups></docstring>

Displays a prompt to log in to the HF website and store the token.

This is equivalent to [login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login) without passing a token when not run in a notebook.
[interpreter_login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.interpreter_login) is useful if you want to force the use of the terminal prompt
instead of a notebook widget.

For more details, see [login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login).




</div>

## notebook_login[[huggingface_hub.notebook_login]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.notebook_login</name><anchor>huggingface_hub.notebook_login</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_login.py#L293</source><parameters>[{"name": "skip_if_logged_in", "val": ": bool = False"}]</parameters><paramsdesc>- **skip_if_logged_in** (`bool`, defaults to `False`) --
  If `True`, do not prompt for token if user is already logged in.</paramsdesc><paramgroups>0</paramgroups></docstring>

Displays a widget to log in to the HF website and store the token.

This is equivalent to [login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login) without passing a token when run in a notebook.
[notebook_login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.notebook_login) is useful if you want to force the use of the notebook widget
instead of a prompt in the terminal.

For more details, see [login()](/docs/huggingface_hub/main/en/package_reference/authentication#huggingface_hub.login).




</div>

## logout[[huggingface_hub.logout]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.logout</name><anchor>huggingface_hub.logout</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_login.py#L119</source><parameters>[{"name": "token_name", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **token_name** (`str`, *optional*) --
  Name of the access token to logout from. If `None`, will log out from all saved access tokens.</paramsdesc><paramgroups>0</paramgroups><raises>- [`ValueError`](https://docs.python.org/3/library/exceptions.html#ValueError) -- 
  If the access token name is not found.</raises><raisederrors>``ValueError``</raisederrors></docstring>
Logout the machine from the Hub.

Token is deleted from the machine and removed from git credential.








</div>

## auth_switch[[huggingface_hub.auth_switch]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.auth_switch</name><anchor>huggingface_hub.auth_switch</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_login.py#L161</source><parameters>[{"name": "token_name", "val": ": str"}, {"name": "add_to_git_credential", "val": ": bool = False"}]</parameters><paramsdesc>- **token_name** (`str`) --
  Name of the access token to switch to.
- **add_to_git_credential** (`bool`, defaults to `False`) --
  If `True`, token will be set as git credential. If no git credential helper
  is configured, a warning will be displayed to the user. If `token` is `None`,
  the value of `add_to_git_credential` is ignored and will be prompted again
  to the end user.</paramsdesc><paramgroups>0</paramgroups><raises>- [`ValueError`](https://docs.python.org/3/library/exceptions.html#ValueError) -- 
  If the access token name is not found.</raises><raisederrors>``ValueError``</raisederrors></docstring>
Switch to a different access token.








</div>

## auth_list[[huggingface_hub.auth_list]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.auth_list</name><anchor>huggingface_hub.auth_list</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_login.py#L190</source><parameters>[]</parameters></docstring>
List all stored access tokens.

</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/authentication.md" />