# WARNING
# This entire file has been generated by Typer based on the `hf` CLI implementation.
# To re-generate the code, run `make style` or `python ./utils/generate_cli_reference.py --update`.
# WARNING
-->

# `hf`

Hugging Face Hub CLI

**Usage**:

```console
$ hf [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `auth`: Manage authentication (login, logout, etc.).
* `cache`: Manage local cache directory.
* `download`: Download files from the Hub.
* `env`: Print information about the environment.
* `jobs`: Run and manage Jobs on the Hub.
* `lfs-enable-largefiles`: Configure your repository to enable upload...
* `lfs-multipart-upload`: Upload large files to the Hub.
* `repo`: Manage repos on the Hub.
* `repo-files`: Manage files in a repo on the Hub.
* `upload`: Upload a file or a folder to the Hub.
* `upload-large-folder`: Upload a large folder to the Hub.
* `version`: Print information about the hf version.

## `hf auth`

Manage authentication (login, logout, etc.).

**Usage**:

```console
$ hf auth [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `list`: List all stored access tokens
* `login`: Login using a token from...
* `logout`: Logout from a specific token
* `switch`: Switch between access tokens
* `whoami`: Find out which huggingface.co account you...

### `hf auth list`

List all stored access tokens

**Usage**:

```console
$ hf auth list [OPTIONS]
```

**Options**:

* `--help`: Show this message and exit.

### `hf auth login`

Login using a token from huggingface.co/settings/tokens

**Usage**:

```console
$ hf auth login [OPTIONS]
```

**Options**:

* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--add-to-git-credential / --no-add-to-git-credential`: Save to git credential helper. Useful only if you plan to run git commands directly.  [default: no-add-to-git-credential]
* `--help`: Show this message and exit.

### `hf auth logout`

Logout from a specific token

**Usage**:

```console
$ hf auth logout [OPTIONS]
```

**Options**:

* `--token-name TEXT`: Name of token to logout
* `--help`: Show this message and exit.

### `hf auth switch`

Switch between access tokens

**Usage**:

```console
$ hf auth switch [OPTIONS]
```

**Options**:

* `--token-name TEXT`: Name of the token to switch to
* `--add-to-git-credential / --no-add-to-git-credential`: Save to git credential helper. Useful only if you plan to run git commands directly.  [default: no-add-to-git-credential]
* `--help`: Show this message and exit.

### `hf auth whoami`

Find out which huggingface.co account you are logged in as.

**Usage**:

```console
$ hf auth whoami [OPTIONS]
```

**Options**:

* `--help`: Show this message and exit.

## `hf cache`

Manage local cache directory.

**Usage**:

```console
$ hf cache [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `ls`: List cached repositories or revisions.
* `prune`: Remove detached revisions from the cache.
* `rm`: Remove cached repositories or revisions.

### `hf cache ls`

List cached repositories or revisions.

**Usage**:

```console
$ hf cache ls [OPTIONS]
```

**Options**:

* `--cache-dir TEXT`: Cache directory to scan (defaults to Hugging Face cache).
* `--revisions / --no-revisions`: Include revisions in the output instead of aggregated repositories.  [default: no-revisions]
* `-f, --filter TEXT`: Filter entries (e.g. 'size>1GB', 'type=model', 'accessed>7d'). Can be used multiple times.
* `--format [table|json|csv]`: Output format.  [default: table]
* `-q, --quiet`: Print only IDs (repo IDs or revision hashes).
* `--help`: Show this message and exit.

### `hf cache prune`

Remove detached revisions from the cache.

**Usage**:

```console
$ hf cache prune [OPTIONS]
```

**Options**:

* `--cache-dir TEXT`: Cache directory to scan (defaults to Hugging Face cache).
* `-y, --yes`: Skip confirmation prompt.
* `--dry-run / --no-dry-run`: Preview deletions without removing anything.  [default: no-dry-run]
* `--help`: Show this message and exit.

### `hf cache rm`

Remove cached repositories or revisions.

**Usage**:

```console
$ hf cache rm [OPTIONS] TARGETS...
```

**Arguments**:

* `TARGETS...`: One or more repo IDs (e.g. model/bert-base-uncased) or revision hashes to delete.  [required]

**Options**:

* `--cache-dir TEXT`: Cache directory to scan (defaults to Hugging Face cache).
* `-y, --yes`: Skip confirmation prompt.
* `--dry-run / --no-dry-run`: Preview deletions without removing anything.  [default: no-dry-run]
* `--help`: Show this message and exit.

## `hf download`

Download files from the Hub.

**Usage**:

```console
$ hf download [OPTIONS] REPO_ID [FILENAMES]...
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `[FILENAMES]...`: Files to download (e.g. `config.json`, `data/metadata.jsonl`).

**Options**:

* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--revision TEXT`: Git revision id which can be a branch name, a tag, or a commit hash.
* `--include TEXT`: Glob patterns to include from files to download. eg: *.json
* `--exclude TEXT`: Glob patterns to exclude from files to download.
* `--cache-dir TEXT`: Directory where to save files.
* `--local-dir TEXT`: If set, the downloaded file will be placed under this directory. Check out https://huggingface.co/docs/huggingface_hub/guides/download#download-files-to-local-folder for more details.
* `--force-download / --no-force-download`: If True, the files will be downloaded even if they are already cached.  [default: no-force-download]
* `--dry-run / --no-dry-run`: If True, perform a dry run without actually downloading the file.  [default: no-dry-run]
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--quiet / --no-quiet`: If True, progress bars are disabled and only the path to the download files is printed.  [default: no-quiet]
* `--max-workers INTEGER`: Maximum number of workers to use for downloading files. Default is 8.  [default: 8]
* `--help`: Show this message and exit.

## `hf env`

Print information about the environment.

**Usage**:

```console
$ hf env [OPTIONS]
```

**Options**:

* `--help`: Show this message and exit.

## `hf jobs`

Run and manage Jobs on the Hub.

**Usage**:

```console
$ hf jobs [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `cancel`: Cancel a Job
* `inspect`: Display detailed information on one or...
* `logs`: Fetch the logs of a Job
* `ps`: List Jobs
* `run`: Run a Job
* `scheduled`: Create and manage scheduled Jobs on the Hub.
* `uv`: Run UV scripts (Python with inline...

### `hf jobs cancel`

Cancel a Job

**Usage**:

```console
$ hf jobs cancel [OPTIONS] JOB_ID
```

**Arguments**:

* `JOB_ID`: Job ID  [required]

**Options**:

* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

### `hf jobs inspect`

Display detailed information on one or more Jobs

**Usage**:

```console
$ hf jobs inspect [OPTIONS] JOB_IDS...
```

**Arguments**:

* `JOB_IDS...`: The jobs to inspect  [required]

**Options**:

* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

### `hf jobs logs`

Fetch the logs of a Job

**Usage**:

```console
$ hf jobs logs [OPTIONS] JOB_ID
```

**Arguments**:

* `JOB_ID`: Job ID  [required]

**Options**:

* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

### `hf jobs ps`

List Jobs

**Usage**:

```console
$ hf jobs ps [OPTIONS]
```

**Options**:

* `-a, --all`: Show all Jobs (default shows just running)
* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `-f, --filter TEXT`: Filter output based on conditions provided (format: key=value)
* `--format TEXT`: Format output using a custom template
* `--help`: Show this message and exit.

### `hf jobs run`

Run a Job

**Usage**:

```console
$ hf jobs run [OPTIONS] IMAGE COMMAND...
```

**Arguments**:

* `IMAGE`: The Docker image to use.  [required]
* `COMMAND...`: The command to run.  [required]

**Options**:

* `-e, --env TEXT`: Set environment variables. E.g. --env ENV=value
* `-s, --secrets TEXT`: Set secret environment variables. E.g. --secrets SECRET=value or `--secrets HF_TOKEN` to pass your Hugging Face token.
* `--env-file TEXT`: Read in a file of environment variables.
* `--secrets-file TEXT`: Read in a file of secret environment variables.
* `--flavor [cpu-basic|cpu-upgrade|cpu-xl|zero-a10g|t4-small|t4-medium|l4x1|l4x4|l40sx1|l40sx4|l40sx8|a10g-small|a10g-large|a10g-largex2|a10g-largex4|a100-large|h100|h100x8]`: Flavor for the hardware, as in HF Spaces. Defaults to `cpu-basic`. Possible values: cpu-basic, cpu-upgrade, cpu-xl, t4-small, t4-medium, l4x1, l4x4, l40sx1, l40sx4, l40sx8, a10g-small, a10g-large, a10g-largex2, a10g-largex4, a100-large, h100, h100x8.
* `--timeout TEXT`: Max duration: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
* `-d, --detach`: Run the Job in the background and print the Job ID.
* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

### `hf jobs scheduled`

Create and manage scheduled Jobs on the Hub.

**Usage**:

```console
$ hf jobs scheduled [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `delete`: Delete a scheduled Job
* `inspect`: Display detailed information on one or...
* `ps`: List scheduled Jobs
* `resume`: Resume (unpause) a scheduled Job
* `run`: Schedule a Job
* `suspend`: Suspend (pause) a scheduled Job
* `uv`: Schedule UV scripts on HF infrastructure

#### `hf jobs scheduled delete`

Delete a scheduled Job

**Usage**:

```console
$ hf jobs scheduled delete [OPTIONS] SCHEDULED_JOB_ID
```

**Arguments**:

* `SCHEDULED_JOB_ID`: Scheduled Job ID  [required]

**Options**:

* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

#### `hf jobs scheduled inspect`

Display detailed information on one or more scheduled Jobs

**Usage**:

```console
$ hf jobs scheduled inspect [OPTIONS] SCHEDULED_JOB_IDS...
```

**Arguments**:

* `SCHEDULED_JOB_IDS...`: The scheduled jobs to inspect  [required]

**Options**:

* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

#### `hf jobs scheduled ps`

List scheduled Jobs

**Usage**:

```console
$ hf jobs scheduled ps [OPTIONS]
```

**Options**:

* `-a, --all`: Show all scheduled Jobs (default hides suspended)
* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `-f, --filter TEXT`: Filter output based on conditions provided (format: key=value)
* `--format TEXT`: Format output using a custom template
* `--help`: Show this message and exit.

#### `hf jobs scheduled resume`

Resume (unpause) a scheduled Job

**Usage**:

```console
$ hf jobs scheduled resume [OPTIONS] SCHEDULED_JOB_ID
```

**Arguments**:

* `SCHEDULED_JOB_ID`: Scheduled Job ID  [required]

**Options**:

* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

#### `hf jobs scheduled run`

Schedule a Job

**Usage**:

```console
$ hf jobs scheduled run [OPTIONS] SCHEDULE IMAGE COMMAND...
```

**Arguments**:

* `SCHEDULE`: One of annually, yearly, monthly, weekly, daily, hourly, or a CRON schedule expression.  [required]
* `IMAGE`: The Docker image to use.  [required]
* `COMMAND...`: The command to run.  [required]

**Options**:

* `--suspend / --no-suspend`: Suspend (pause) the scheduled Job
* `--concurrency / --no-concurrency`: Allow multiple instances of this Job to run concurrently
* `-e, --env TEXT`: Set environment variables. E.g. --env ENV=value
* `-s, --secrets TEXT`: Set secret environment variables. E.g. --secrets SECRET=value or `--secrets HF_TOKEN` to pass your Hugging Face token.
* `--env-file TEXT`: Read in a file of environment variables.
* `--secrets-file TEXT`: Read in a file of secret environment variables.
* `--flavor [cpu-basic|cpu-upgrade|cpu-xl|zero-a10g|t4-small|t4-medium|l4x1|l4x4|l40sx1|l40sx4|l40sx8|a10g-small|a10g-large|a10g-largex2|a10g-largex4|a100-large|h100|h100x8]`: Flavor for the hardware, as in HF Spaces. Defaults to `cpu-basic`. Possible values: cpu-basic, cpu-upgrade, cpu-xl, t4-small, t4-medium, l4x1, l4x4, l40sx1, l40sx4, l40sx8, a10g-small, a10g-large, a10g-largex2, a10g-largex4, a100-large, h100, h100x8.
* `--timeout TEXT`: Max duration: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

#### `hf jobs scheduled suspend`

Suspend (pause) a scheduled Job

**Usage**:

```console
$ hf jobs scheduled suspend [OPTIONS] SCHEDULED_JOB_ID
```

**Arguments**:

* `SCHEDULED_JOB_ID`: Scheduled Job ID  [required]

**Options**:

* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

#### `hf jobs scheduled uv`

Schedule UV scripts on HF infrastructure

**Usage**:

```console
$ hf jobs scheduled uv [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `run`: Run a UV script (local file or URL) on HF...

##### `hf jobs scheduled uv run`

Run a UV script (local file or URL) on HF infrastructure

**Usage**:

```console
$ hf jobs scheduled uv run [OPTIONS] SCHEDULE SCRIPT [SCRIPT_ARGS]...
```

**Arguments**:

* `SCHEDULE`: One of annually, yearly, monthly, weekly, daily, hourly, or a CRON schedule expression.  [required]
* `SCRIPT`: UV script to run (local file or URL)  [required]
* `[SCRIPT_ARGS]...`: Arguments for the script

**Options**:

* `--suspend / --no-suspend`: Suspend (pause) the scheduled Job
* `--concurrency / --no-concurrency`: Allow multiple instances of this Job to run concurrently
* `--image TEXT`: Use a custom Docker image with `uv` installed.
* `--repo TEXT`: Repository name for the script (creates ephemeral if not specified)
* `--flavor [cpu-basic|cpu-upgrade|cpu-xl|zero-a10g|t4-small|t4-medium|l4x1|l4x4|l40sx1|l40sx4|l40sx8|a10g-small|a10g-large|a10g-largex2|a10g-largex4|a100-large|h100|h100x8]`: Flavor for the hardware, as in HF Spaces. Defaults to `cpu-basic`. Possible values: cpu-basic, cpu-upgrade, cpu-xl, t4-small, t4-medium, l4x1, l4x4, l40sx1, l40sx4, l40sx8, a10g-small, a10g-large, a10g-largex2, a10g-largex4, a100-large, h100, h100x8.
* `-e, --env TEXT`: Set environment variables. E.g. --env ENV=value
* `-s, --secrets TEXT`: Set secret environment variables. E.g. --secrets SECRET=value or `--secrets HF_TOKEN` to pass your Hugging Face token.
* `--env-file TEXT`: Read in a file of environment variables.
* `--secrets-file TEXT`: Read in a file of secret environment variables.
* `--timeout TEXT`: Max duration: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--with TEXT`: Run with the given packages installed
* `-p, --python TEXT`: The Python interpreter to use for the run environment
* `--help`: Show this message and exit.

### `hf jobs uv`

Run UV scripts (Python with inline dependencies) on HF infrastructure

**Usage**:

```console
$ hf jobs uv [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `run`: Run a UV script (local file or URL) on HF...

#### `hf jobs uv run`

Run a UV script (local file or URL) on HF infrastructure

**Usage**:

```console
$ hf jobs uv run [OPTIONS] SCRIPT [SCRIPT_ARGS]...
```

**Arguments**:

* `SCRIPT`: UV script to run (local file or URL)  [required]
* `[SCRIPT_ARGS]...`: Arguments for the script

**Options**:

* `--image TEXT`: Use a custom Docker image with `uv` installed.
* `--repo TEXT`: Repository name for the script (creates ephemeral if not specified)
* `--flavor [cpu-basic|cpu-upgrade|cpu-xl|zero-a10g|t4-small|t4-medium|l4x1|l4x4|l40sx1|l40sx4|l40sx8|a10g-small|a10g-large|a10g-largex2|a10g-largex4|a100-large|h100|h100x8]`: Flavor for the hardware, as in HF Spaces. Defaults to `cpu-basic`. Possible values: cpu-basic, cpu-upgrade, cpu-xl, t4-small, t4-medium, l4x1, l4x4, l40sx1, l40sx4, l40sx8, a10g-small, a10g-large, a10g-largex2, a10g-largex4, a100-large, h100, h100x8.
* `-e, --env TEXT`: Set environment variables. E.g. --env ENV=value
* `-s, --secrets TEXT`: Set secret environment variables. E.g. --secrets SECRET=value or `--secrets HF_TOKEN` to pass your Hugging Face token.
* `--env-file TEXT`: Read in a file of environment variables.
* `--secrets-file TEXT`: Read in a file of secret environment variables.
* `--timeout TEXT`: Max duration: int/float with s (seconds, default), m (minutes), h (hours) or d (days).
* `-d, --detach`: Run the Job in the background and print the Job ID.
* `--namespace TEXT`: The namespace where the job will be running. Defaults to the current user's namespace.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--with TEXT`: Run with the given packages installed
* `-p, --python TEXT`: The Python interpreter to use for the run environment
* `--help`: Show this message and exit.

## `hf lfs-enable-largefiles`

Configure your repository to enable upload of files > 5GB.

**Usage**:

```console
$ hf lfs-enable-largefiles [OPTIONS] PATH
```

**Arguments**:

* `PATH`: Local path to repository you want to configure.  [required]

**Options**:

* `--help`: Show this message and exit.

## `hf lfs-multipart-upload`

Upload large files to the Hub.

**Usage**:

```console
$ hf lfs-multipart-upload [OPTIONS]
```

**Options**:

* `--help`: Show this message and exit.

## `hf repo`

Manage repos on the Hub.

**Usage**:

```console
$ hf repo [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `branch`: Manage branches for a repo on the Hub.
* `create`: Create a new repo on the Hub.
* `delete`: Delete a repo from the Hub.
* `move`: Move a repository from a namespace to...
* `settings`: Update the settings of a repository.
* `tag`: Manage tags for a repo on the Hub.

### `hf repo branch`

Manage branches for a repo on the Hub.

**Usage**:

```console
$ hf repo branch [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `create`: Create a new branch for a repo on the Hub.
* `delete`: Delete a branch from a repo on the Hub.

#### `hf repo branch create`

Create a new branch for a repo on the Hub.

**Usage**:

```console
$ hf repo branch create [OPTIONS] REPO_ID BRANCH
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `BRANCH`: The name of the branch to create.  [required]

**Options**:

* `--revision TEXT`: Git revision id which can be a branch name, a tag, or a commit hash.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--exist-ok / --no-exist-ok`: If set to True, do not raise an error if branch already exists.  [default: no-exist-ok]
* `--help`: Show this message and exit.

#### `hf repo branch delete`

Delete a branch from a repo on the Hub.

**Usage**:

```console
$ hf repo branch delete [OPTIONS] REPO_ID BRANCH
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `BRANCH`: The name of the branch to delete.  [required]

**Options**:

* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--help`: Show this message and exit.

### `hf repo create`

Create a new repo on the Hub.

**Usage**:

```console
$ hf repo create [OPTIONS] REPO_ID
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]

**Options**:

* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--space-sdk TEXT`: Hugging Face Spaces SDK type. Required when --type is set to 'space'.
* `--private / --no-private`: Whether to create a private repo if repo doesn't exist on the Hub. Ignored if the repo already exists.  [default: no-private]
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--exist-ok / --no-exist-ok`: Do not raise an error if repo already exists.  [default: no-exist-ok]
* `--resource-group-id TEXT`: Resource group in which to create the repo. Resource groups is only available for Enterprise Hub organizations.
* `--help`: Show this message and exit.

### `hf repo delete`

Delete a repo from the Hub. this is an irreversible operation.

**Usage**:

```console
$ hf repo delete [OPTIONS] REPO_ID
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]

**Options**:

* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--missing-ok / --no-missing-ok`: If set to True, do not raise an error if repo does not exist.  [default: no-missing-ok]
* `--help`: Show this message and exit.

### `hf repo move`

Move a repository from a namespace to another namespace.

**Usage**:

```console
$ hf repo move [OPTIONS] FROM_ID TO_ID
```

**Arguments**:

* `FROM_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `TO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]

**Options**:

* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--help`: Show this message and exit.

### `hf repo settings`

Update the settings of a repository.

**Usage**:

```console
$ hf repo settings [OPTIONS] REPO_ID
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]

**Options**:

* `--gated [auto|manual|false]`: The gated status for the repository.
* `--private / --no-private`: Whether the repository should be private.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--help`: Show this message and exit.

### `hf repo tag`

Manage tags for a repo on the Hub.

**Usage**:

```console
$ hf repo tag [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `create`: Create a tag for a repo.
* `delete`: Delete a tag for a repo.
* `list`: List tags for a repo.

#### `hf repo tag create`

Create a tag for a repo.

**Usage**:

```console
$ hf repo tag create [OPTIONS] REPO_ID TAG
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `TAG`: The name of the tag to create.  [required]

**Options**:

* `-m, --message TEXT`: The description of the tag to create.
* `--revision TEXT`: Git revision id which can be a branch name, a tag, or a commit hash.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--help`: Show this message and exit.

#### `hf repo tag delete`

Delete a tag for a repo.

**Usage**:

```console
$ hf repo tag delete [OPTIONS] REPO_ID TAG
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `TAG`: The name of the tag to delete.  [required]

**Options**:

* `-y, --yes`: Answer Yes to prompt automatically
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--help`: Show this message and exit.

#### `hf repo tag list`

List tags for a repo.

**Usage**:

```console
$ hf repo tag list [OPTIONS] REPO_ID
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]

**Options**:

* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--help`: Show this message and exit.

## `hf repo-files`

Manage files in a repo on the Hub.

**Usage**:

```console
$ hf repo-files [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--help`: Show this message and exit.

**Commands**:

* `delete`

### `hf repo-files delete`

**Usage**:

```console
$ hf repo-files delete [OPTIONS] REPO_ID PATTERNS...
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `PATTERNS...`: Glob patterns to match files to delete.  [required]

**Options**:

* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--revision TEXT`: Git revision id which can be a branch name, a tag, or a commit hash.
* `--commit-message TEXT`: The summary / title / first line of the generated commit.
* `--commit-description TEXT`: The description of the generated commit.
* `--create-pr / --no-create-pr`: Whether to create a new Pull Request for these changes.  [default: no-create-pr]
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--help`: Show this message and exit.

## `hf upload`

Upload a file or a folder to the Hub.

**Usage**:

```console
$ hf upload [OPTIONS] REPO_ID [LOCAL_PATH] [PATH_IN_REPO]
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `[LOCAL_PATH]`: Local path to the file or folder to upload. Wildcard patterns are supported. Defaults to current directory.
* `[PATH_IN_REPO]`: Path of the file or folder in the repo. Defaults to the relative path of the file or folder.

**Options**:

* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--revision TEXT`: Git revision id which can be a branch name, a tag, or a commit hash.
* `--private / --no-private`: Whether to create a private repo if repo doesn't exist on the Hub. Ignored if the repo already exists.  [default: no-private]
* `--include TEXT`: Glob patterns to match files to upload.
* `--exclude TEXT`: Glob patterns to exclude from files to upload.
* `--delete TEXT`: Glob patterns for file to be deleted from the repo while committing.
* `--commit-message TEXT`: The summary / title / first line of the generated commit.
* `--commit-description TEXT`: The description of the generated commit.
* `--create-pr / --no-create-pr`: Whether to upload content as a new Pull Request.  [default: no-create-pr]
* `--every FLOAT`: f set, a background job is scheduled to create commits every `every` minutes.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--quiet / --no-quiet`: Disable progress bars and warnings; print only the returned path.  [default: no-quiet]
* `--help`: Show this message and exit.

## `hf upload-large-folder`

Upload a large folder to the Hub. Recommended for resumable uploads.

**Usage**:

```console
$ hf upload-large-folder [OPTIONS] REPO_ID LOCAL_PATH
```

**Arguments**:

* `REPO_ID`: The ID of the repo (e.g. `username/repo-name`).  [required]
* `LOCAL_PATH`: Local path to the folder to upload.  [required]

**Options**:

* `--repo-type [model|dataset|space]`: The type of repository (model, dataset, or space).  [default: model]
* `--revision TEXT`: Git revision id which can be a branch name, a tag, or a commit hash.
* `--private / --no-private`: Whether to create a private repo if repo doesn't exist on the Hub. Ignored if the repo already exists.  [default: no-private]
* `--include TEXT`: Glob patterns to match files to upload.
* `--exclude TEXT`: Glob patterns to exclude from files to upload.
* `--token TEXT`: A User Access Token generated from https://huggingface.co/settings/tokens.
* `--num-workers INTEGER`: Number of workers to use to hash, upload and commit files.
* `--no-report / --no-no-report`: Whether to disable regular status report.  [default: no-no-report]
* `--no-bars / --no-no-bars`: Whether to disable progress bars.  [default: no-no-bars]
* `--help`: Show this message and exit.

## `hf version`

Print information about the hf version.

**Usage**:

```console
$ hf version [OPTIONS]
```

**Options**:

* `--help`: Show this message and exit.


<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/cli.md" />