# Inference types

This page lists the types (e.g. dataclasses) available for each task supported on the Hugging Face Hub.
Each task is specified using a JSON schema, and the types are generated from these schemas - with some customization
due to Python requirements.
Visit [@huggingface.js/tasks](https://github.com/huggingface/huggingface.js/tree/main/packages/tasks/src/tasks)
to find the JSON schemas for each task.

This part of the lib is still under development and will be improved in future releases.



## audio_classification[[huggingface_hub.AudioClassificationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AudioClassificationInput</name><anchor>huggingface_hub.AudioClassificationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/audio_classification.py#L25</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.audio_classification.AudioClassificationParameters] = None"}]</parameters></docstring>
Inputs for Audio Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AudioClassificationOutputElement</name><anchor>huggingface_hub.AudioClassificationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/audio_classification.py#L37</source><parameters>[{"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs for Audio Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AudioClassificationParameters</name><anchor>huggingface_hub.AudioClassificationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/audio_classification.py#L15</source><parameters>[{"name": "function_to_apply", "val": ": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Audio Classification

</div>

## audio_to_audio[[huggingface_hub.AudioToAudioInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AudioToAudioInput</name><anchor>huggingface_hub.AudioToAudioInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/audio_to_audio.py#L12</source><parameters>[{"name": "inputs", "val": ": typing.Any"}]</parameters></docstring>
Inputs for Audio to Audio inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AudioToAudioOutputElement</name><anchor>huggingface_hub.AudioToAudioOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/audio_to_audio.py#L20</source><parameters>[{"name": "blob", "val": ": typing.Any"}, {"name": "content_type", "val": ": str"}, {"name": "label", "val": ": str"}]</parameters></docstring>
Outputs of inference for the Audio To Audio task
A generated audio file with its label.


</div>

## automatic_speech_recognition[[huggingface_hub.AutomaticSpeechRecognitionGenerationParameters]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AutomaticSpeechRecognitionGenerationParameters</name><anchor>huggingface_hub.AutomaticSpeechRecognitionGenerationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/automatic_speech_recognition.py#L15</source><parameters>[{"name": "do_sample", "val": ": typing.Optional[bool] = None"}, {"name": "early_stopping", "val": ": typing.Union[bool, ForwardRef('AutomaticSpeechRecognitionEarlyStoppingEnum'), NoneType] = None"}, {"name": "epsilon_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "eta_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "max_length", "val": ": typing.Optional[int] = None"}, {"name": "max_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "min_length", "val": ": typing.Optional[int] = None"}, {"name": "min_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "num_beam_groups", "val": ": typing.Optional[int] = None"}, {"name": "num_beams", "val": ": typing.Optional[int] = None"}, {"name": "penalty_alpha", "val": ": typing.Optional[float] = None"}, {"name": "temperature", "val": ": typing.Optional[float] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}, {"name": "top_p", "val": ": typing.Optional[float] = None"}, {"name": "typical_p", "val": ": typing.Optional[float] = None"}, {"name": "use_cache", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Parametrization of the text generation process

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AutomaticSpeechRecognitionInput</name><anchor>huggingface_hub.AutomaticSpeechRecognitionInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/automatic_speech_recognition.py#L85</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.automatic_speech_recognition.AutomaticSpeechRecognitionParameters] = None"}]</parameters></docstring>
Inputs for Automatic Speech Recognition inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AutomaticSpeechRecognitionOutput</name><anchor>huggingface_hub.AutomaticSpeechRecognitionOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/automatic_speech_recognition.py#L105</source><parameters>[{"name": "text", "val": ": str"}, {"name": "chunks", "val": ": typing.Optional[list[huggingface_hub.inference._generated.types.automatic_speech_recognition.AutomaticSpeechRecognitionOutputChunk]] = None"}]</parameters></docstring>
Outputs of inference for the Automatic Speech Recognition task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AutomaticSpeechRecognitionOutputChunk</name><anchor>huggingface_hub.AutomaticSpeechRecognitionOutputChunk</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/automatic_speech_recognition.py#L97</source><parameters>[{"name": "text", "val": ": str"}, {"name": "timestamp", "val": ": list"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.AutomaticSpeechRecognitionParameters</name><anchor>huggingface_hub.AutomaticSpeechRecognitionParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/automatic_speech_recognition.py#L75</source><parameters>[{"name": "generation_parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.automatic_speech_recognition.AutomaticSpeechRecognitionGenerationParameters] = None"}, {"name": "return_timestamps", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Additional inference parameters for Automatic Speech Recognition

</div>

## chat_completion[[huggingface_hub.ChatCompletionInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInput</name><anchor>huggingface_hub.ChatCompletionInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L125</source><parameters>[{"name": "messages", "val": ": list"}, {"name": "frequency_penalty", "val": ": typing.Optional[float] = None"}, {"name": "logit_bias", "val": ": typing.Optional[list[float]] = None"}, {"name": "logprobs", "val": ": typing.Optional[bool] = None"}, {"name": "max_tokens", "val": ": typing.Optional[int] = None"}, {"name": "model", "val": ": typing.Optional[str] = None"}, {"name": "n", "val": ": typing.Optional[int] = None"}, {"name": "presence_penalty", "val": ": typing.Optional[float] = None"}, {"name": "response_format", "val": ": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatText, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONSchema, huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputResponseFormatJSONObject, NoneType] = None"}, {"name": "seed", "val": ": typing.Optional[int] = None"}, {"name": "stop", "val": ": typing.Optional[list[str]] = None"}, {"name": "stream", "val": ": typing.Optional[bool] = None"}, {"name": "stream_options", "val": ": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"}, {"name": "temperature", "val": ": typing.Optional[float] = None"}, {"name": "tool_choice", "val": ": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"}, {"name": "tool_prompt", "val": ": typing.Optional[str] = None"}, {"name": "tools", "val": ": typing.Optional[list[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"}, {"name": "top_logprobs", "val": ": typing.Optional[int] = None"}, {"name": "top_p", "val": ": typing.Optional[float] = None"}]</parameters></docstring>
Chat Completion Input.
Auto-generated from TGI specs.
For more details, check out
https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/scripts/inference-tgi-import.ts.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputFunctionDefinition</name><anchor>huggingface_hub.ChatCompletionInputFunctionDefinition</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L27</source><parameters>[{"name": "name", "val": ": str"}, {"name": "parameters", "val": ": typing.Any"}, {"name": "description", "val": ": typing.Optional[str] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputFunctionName</name><anchor>huggingface_hub.ChatCompletionInputFunctionName</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L106</source><parameters>[{"name": "name", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputJSONSchema</name><anchor>huggingface_hub.ChatCompletionInputJSONSchema</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L49</source><parameters>[{"name": "name", "val": ": str"}, {"name": "description", "val": ": typing.Optional[str] = None"}, {"name": "schema", "val": ": typing.Optional[dict[str, object]] = None"}, {"name": "strict", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputMessage</name><anchor>huggingface_hub.ChatCompletionInputMessage</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L41</source><parameters>[{"name": "role", "val": ": str"}, {"name": "content", "val": ": typing.Union[list[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputMessageChunk], str, NoneType] = None"}, {"name": "name", "val": ": typing.Optional[str] = None"}, {"name": "tool_calls", "val": ": typing.Optional[list[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolCall]] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputMessageChunk</name><anchor>huggingface_hub.ChatCompletionInputMessageChunk</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L20</source><parameters>[{"name": "type", "val": ": ChatCompletionInputMessageChunkType"}, {"name": "image_url", "val": ": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputURL] = None"}, {"name": "text", "val": ": typing.Optional[str] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputResponseFormatJSONObject</name><anchor>huggingface_hub.ChatCompletionInputResponseFormatJSONObject</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L84</source><parameters>[{"name": "type", "val": ": typing.Literal['json_object']"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputResponseFormatJSONSchema</name><anchor>huggingface_hub.ChatCompletionInputResponseFormatJSONSchema</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L78</source><parameters>[{"name": "type", "val": ": typing.Literal['json_schema']"}, {"name": "json_schema", "val": ": ChatCompletionInputJSONSchema"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputResponseFormatText</name><anchor>huggingface_hub.ChatCompletionInputResponseFormatText</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L73</source><parameters>[{"name": "type", "val": ": typing.Literal['text']"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputStreamOptions</name><anchor>huggingface_hub.ChatCompletionInputStreamOptions</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L96</source><parameters>[{"name": "include_usage", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputTool</name><anchor>huggingface_hub.ChatCompletionInputTool</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L119</source><parameters>[{"name": "function", "val": ": ChatCompletionInputFunctionDefinition"}, {"name": "type", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputToolCall</name><anchor>huggingface_hub.ChatCompletionInputToolCall</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L34</source><parameters>[{"name": "function", "val": ": ChatCompletionInputFunctionDefinition"}, {"name": "id", "val": ": str"}, {"name": "type", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputToolChoiceClass</name><anchor>huggingface_hub.ChatCompletionInputToolChoiceClass</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L111</source><parameters>[{"name": "function", "val": ": ChatCompletionInputFunctionName"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionInputURL</name><anchor>huggingface_hub.ChatCompletionInputURL</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L12</source><parameters>[{"name": "url", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutput</name><anchor>huggingface_hub.ChatCompletionOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L263</source><parameters>[{"name": "choices", "val": ": list"}, {"name": "created", "val": ": int"}, {"name": "id", "val": ": str"}, {"name": "model", "val": ": str"}, {"name": "system_fingerprint", "val": ": str"}, {"name": "usage", "val": ": ChatCompletionOutputUsage"}]</parameters></docstring>
Chat Completion Output.
Auto-generated from TGI specs.
For more details, check out
https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/scripts/inference-tgi-import.ts.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputComplete</name><anchor>huggingface_hub.ChatCompletionOutputComplete</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L248</source><parameters>[{"name": "finish_reason", "val": ": str"}, {"name": "index", "val": ": int"}, {"name": "message", "val": ": ChatCompletionOutputMessage"}, {"name": "logprobs", "val": ": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionOutputLogprobs] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputFunctionDefinition</name><anchor>huggingface_hub.ChatCompletionOutputFunctionDefinition</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L225</source><parameters>[{"name": "arguments", "val": ": str"}, {"name": "name", "val": ": str"}, {"name": "description", "val": ": typing.Optional[str] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputLogprob</name><anchor>huggingface_hub.ChatCompletionOutputLogprob</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L213</source><parameters>[{"name": "logprob", "val": ": float"}, {"name": "token", "val": ": str"}, {"name": "top_logprobs", "val": ": list"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputLogprobs</name><anchor>huggingface_hub.ChatCompletionOutputLogprobs</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L220</source><parameters>[{"name": "content", "val": ": list"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputMessage</name><anchor>huggingface_hub.ChatCompletionOutputMessage</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L239</source><parameters>[{"name": "role", "val": ": str"}, {"name": "content", "val": ": typing.Optional[str] = None"}, {"name": "reasoning", "val": ": typing.Optional[str] = None"}, {"name": "tool_call_id", "val": ": typing.Optional[str] = None"}, {"name": "tool_calls", "val": ": typing.Optional[list[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionOutputToolCall]] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputToolCall</name><anchor>huggingface_hub.ChatCompletionOutputToolCall</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L232</source><parameters>[{"name": "function", "val": ": ChatCompletionOutputFunctionDefinition"}, {"name": "id", "val": ": str"}, {"name": "type", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputTopLogprob</name><anchor>huggingface_hub.ChatCompletionOutputTopLogprob</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L207</source><parameters>[{"name": "logprob", "val": ": float"}, {"name": "token", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionOutputUsage</name><anchor>huggingface_hub.ChatCompletionOutputUsage</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L256</source><parameters>[{"name": "completion_tokens", "val": ": int"}, {"name": "prompt_tokens", "val": ": int"}, {"name": "total_tokens", "val": ": int"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutput</name><anchor>huggingface_hub.ChatCompletionStreamOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L335</source><parameters>[{"name": "choices", "val": ": list"}, {"name": "created", "val": ": int"}, {"name": "id", "val": ": str"}, {"name": "model", "val": ": str"}, {"name": "system_fingerprint", "val": ": str"}, {"name": "usage", "val": ": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionStreamOutputUsage] = None"}]</parameters></docstring>
Chat Completion Stream Output.
Auto-generated from TGI specs.
For more details, check out
https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/scripts/inference-tgi-import.ts.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputChoice</name><anchor>huggingface_hub.ChatCompletionStreamOutputChoice</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L320</source><parameters>[{"name": "delta", "val": ": ChatCompletionStreamOutputDelta"}, {"name": "index", "val": ": int"}, {"name": "finish_reason", "val": ": typing.Optional[str] = None"}, {"name": "logprobs", "val": ": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionStreamOutputLogprobs] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputDelta</name><anchor>huggingface_hub.ChatCompletionStreamOutputDelta</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L293</source><parameters>[{"name": "role", "val": ": str"}, {"name": "content", "val": ": typing.Optional[str] = None"}, {"name": "reasoning", "val": ": typing.Optional[str] = None"}, {"name": "tool_call_id", "val": ": typing.Optional[str] = None"}, {"name": "tool_calls", "val": ": typing.Optional[list[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionStreamOutputDeltaToolCall]] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputDeltaToolCall</name><anchor>huggingface_hub.ChatCompletionStreamOutputDeltaToolCall</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L285</source><parameters>[{"name": "function", "val": ": ChatCompletionStreamOutputFunction"}, {"name": "id", "val": ": str"}, {"name": "index", "val": ": int"}, {"name": "type", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputFunction</name><anchor>huggingface_hub.ChatCompletionStreamOutputFunction</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L279</source><parameters>[{"name": "arguments", "val": ": str"}, {"name": "name", "val": ": typing.Optional[str] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputLogprob</name><anchor>huggingface_hub.ChatCompletionStreamOutputLogprob</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L308</source><parameters>[{"name": "logprob", "val": ": float"}, {"name": "token", "val": ": str"}, {"name": "top_logprobs", "val": ": list"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputLogprobs</name><anchor>huggingface_hub.ChatCompletionStreamOutputLogprobs</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L315</source><parameters>[{"name": "content", "val": ": list"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputTopLogprob</name><anchor>huggingface_hub.ChatCompletionStreamOutputTopLogprob</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L302</source><parameters>[{"name": "logprob", "val": ": float"}, {"name": "token", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ChatCompletionStreamOutputUsage</name><anchor>huggingface_hub.ChatCompletionStreamOutputUsage</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/chat_completion.py#L328</source><parameters>[{"name": "completion_tokens", "val": ": int"}, {"name": "prompt_tokens", "val": ": int"}, {"name": "total_tokens", "val": ": int"}]</parameters></docstring>


</div>

## depth_estimation[[huggingface_hub.DepthEstimationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.DepthEstimationInput</name><anchor>huggingface_hub.DepthEstimationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/depth_estimation.py#L12</source><parameters>[{"name": "inputs", "val": ": typing.Any"}, {"name": "parameters", "val": ": typing.Optional[dict[str, typing.Any]] = None"}]</parameters></docstring>
Inputs for Depth Estimation inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.DepthEstimationOutput</name><anchor>huggingface_hub.DepthEstimationOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/depth_estimation.py#L22</source><parameters>[{"name": "depth", "val": ": typing.Any"}, {"name": "predicted_depth", "val": ": typing.Any"}]</parameters></docstring>
Outputs of inference for the Depth Estimation task

</div>

## document_question_answering[[huggingface_hub.DocumentQuestionAnsweringInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.DocumentQuestionAnsweringInput</name><anchor>huggingface_hub.DocumentQuestionAnsweringInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/document_question_answering.py#L56</source><parameters>[{"name": "inputs", "val": ": DocumentQuestionAnsweringInputData"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.document_question_answering.DocumentQuestionAnsweringParameters] = None"}]</parameters></docstring>
Inputs for Document Question Answering inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.DocumentQuestionAnsweringInputData</name><anchor>huggingface_hub.DocumentQuestionAnsweringInputData</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/document_question_answering.py#L12</source><parameters>[{"name": "image", "val": ": typing.Any"}, {"name": "question", "val": ": str"}]</parameters></docstring>
One (document, question) pair to answer

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.DocumentQuestionAnsweringOutputElement</name><anchor>huggingface_hub.DocumentQuestionAnsweringOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/document_question_answering.py#L66</source><parameters>[{"name": "answer", "val": ": str"}, {"name": "end", "val": ": int"}, {"name": "score", "val": ": float"}, {"name": "start", "val": ": int"}]</parameters></docstring>
Outputs of inference for the Document Question Answering task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.DocumentQuestionAnsweringParameters</name><anchor>huggingface_hub.DocumentQuestionAnsweringParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/document_question_answering.py#L22</source><parameters>[{"name": "doc_stride", "val": ": typing.Optional[int] = None"}, {"name": "handle_impossible_answer", "val": ": typing.Optional[bool] = None"}, {"name": "lang", "val": ": typing.Optional[str] = None"}, {"name": "max_answer_len", "val": ": typing.Optional[int] = None"}, {"name": "max_question_len", "val": ": typing.Optional[int] = None"}, {"name": "max_seq_len", "val": ": typing.Optional[int] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}, {"name": "word_boxes", "val": ": typing.Optional[list[typing.Union[list[float], str]]] = None"}]</parameters></docstring>
Additional inference parameters for Document Question Answering

</div>

## feature_extraction[[huggingface_hub.FeatureExtractionInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.FeatureExtractionInput</name><anchor>huggingface_hub.FeatureExtractionInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/feature_extraction.py#L15</source><parameters>[{"name": "inputs", "val": ": typing.Union[list[str], str]"}, {"name": "normalize", "val": ": typing.Optional[bool] = None"}, {"name": "prompt_name", "val": ": typing.Optional[str] = None"}, {"name": "truncate", "val": ": typing.Optional[bool] = None"}, {"name": "truncation_direction", "val": ": typing.Optional[ForwardRef('FeatureExtractionInputTruncationDirection')] = None"}]</parameters></docstring>
Feature Extraction Input.
Auto-generated from TEI specs.
For more details, check out
https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/scripts/inference-tei-import.ts.


</div>

## fill_mask[[huggingface_hub.FillMaskInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.FillMaskInput</name><anchor>huggingface_hub.FillMaskInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/fill_mask.py#L26</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.fill_mask.FillMaskParameters] = None"}]</parameters></docstring>
Inputs for Fill Mask inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.FillMaskOutputElement</name><anchor>huggingface_hub.FillMaskOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/fill_mask.py#L36</source><parameters>[{"name": "score", "val": ": float"}, {"name": "sequence", "val": ": str"}, {"name": "token", "val": ": int"}, {"name": "token_str", "val": ": typing.Any"}, {"name": "fill_mask_output_token_str", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Outputs of inference for the Fill Mask task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.FillMaskParameters</name><anchor>huggingface_hub.FillMaskParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/fill_mask.py#L12</source><parameters>[{"name": "targets", "val": ": typing.Optional[list[str]] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Fill Mask

</div>

## image_classification[[huggingface_hub.ImageClassificationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageClassificationInput</name><anchor>huggingface_hub.ImageClassificationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_classification.py#L25</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_classification.ImageClassificationParameters] = None"}]</parameters></docstring>
Inputs for Image Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageClassificationOutputElement</name><anchor>huggingface_hub.ImageClassificationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_classification.py#L37</source><parameters>[{"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Image Classification task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageClassificationParameters</name><anchor>huggingface_hub.ImageClassificationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_classification.py#L15</source><parameters>[{"name": "function_to_apply", "val": ": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Image Classification

</div>

## image_segmentation[[huggingface_hub.ImageSegmentationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageSegmentationInput</name><anchor>huggingface_hub.ImageSegmentationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_segmentation.py#L29</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_segmentation.ImageSegmentationParameters] = None"}]</parameters></docstring>
Inputs for Image Segmentation inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageSegmentationOutputElement</name><anchor>huggingface_hub.ImageSegmentationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_segmentation.py#L41</source><parameters>[{"name": "label", "val": ": str"}, {"name": "mask", "val": ": str"}, {"name": "score", "val": ": typing.Optional[float] = None"}]</parameters></docstring>
Outputs of inference for the Image Segmentation task
A predicted mask / segment


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageSegmentationParameters</name><anchor>huggingface_hub.ImageSegmentationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_segmentation.py#L15</source><parameters>[{"name": "mask_threshold", "val": ": typing.Optional[float] = None"}, {"name": "overlap_mask_area_threshold", "val": ": typing.Optional[float] = None"}, {"name": "subtask", "val": ": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"}, {"name": "threshold", "val": ": typing.Optional[float] = None"}]</parameters></docstring>
Additional inference parameters for Image Segmentation

</div>

## image_to_image[[huggingface_hub.ImageToImageInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToImageInput</name><anchor>huggingface_hub.ImageToImageInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_image.py#L44</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageParameters] = None"}]</parameters></docstring>
Inputs for Image To Image inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToImageOutput</name><anchor>huggingface_hub.ImageToImageOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_image.py#L56</source><parameters>[{"name": "image", "val": ": typing.Any"}]</parameters></docstring>
Outputs of inference for the Image To Image task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToImageParameters</name><anchor>huggingface_hub.ImageToImageParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_image.py#L22</source><parameters>[{"name": "guidance_scale", "val": ": typing.Optional[float] = None"}, {"name": "negative_prompt", "val": ": typing.Optional[str] = None"}, {"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "prompt", "val": ": typing.Optional[str] = None"}, {"name": "target_size", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"}]</parameters></docstring>
Additional inference parameters for Image To Image

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToImageTargetSize</name><anchor>huggingface_hub.ImageToImageTargetSize</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_image.py#L12</source><parameters>[{"name": "height", "val": ": int"}, {"name": "width", "val": ": int"}]</parameters></docstring>
The size in pixels of the output image. This parameter is only supported by some
providers and for specific models. It will be ignored when unsupported.


</div>

## image_to_text[[huggingface_hub.ImageToTextGenerationParameters]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToTextGenerationParameters</name><anchor>huggingface_hub.ImageToTextGenerationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_text.py#L15</source><parameters>[{"name": "do_sample", "val": ": typing.Optional[bool] = None"}, {"name": "early_stopping", "val": ": typing.Union[bool, ForwardRef('ImageToTextEarlyStoppingEnum'), NoneType] = None"}, {"name": "epsilon_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "eta_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "max_length", "val": ": typing.Optional[int] = None"}, {"name": "max_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "min_length", "val": ": typing.Optional[int] = None"}, {"name": "min_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "num_beam_groups", "val": ": typing.Optional[int] = None"}, {"name": "num_beams", "val": ": typing.Optional[int] = None"}, {"name": "penalty_alpha", "val": ": typing.Optional[float] = None"}, {"name": "temperature", "val": ": typing.Optional[float] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}, {"name": "top_p", "val": ": typing.Optional[float] = None"}, {"name": "typical_p", "val": ": typing.Optional[float] = None"}, {"name": "use_cache", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Parametrization of the text generation process

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToTextInput</name><anchor>huggingface_hub.ImageToTextInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_text.py#L85</source><parameters>[{"name": "inputs", "val": ": typing.Any"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_to_text.ImageToTextParameters] = None"}]</parameters></docstring>
Inputs for Image To Text inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToTextOutput</name><anchor>huggingface_hub.ImageToTextOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_text.py#L95</source><parameters>[{"name": "generated_text", "val": ": typing.Any"}, {"name": "image_to_text_output_generated_text", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Outputs of inference for the Image To Text task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToTextParameters</name><anchor>huggingface_hub.ImageToTextParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_text.py#L75</source><parameters>[{"name": "generation_parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_to_text.ImageToTextGenerationParameters] = None"}, {"name": "max_new_tokens", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Image To Text

</div>

## image_to_video[[huggingface_hub.ImageToVideoInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToVideoInput</name><anchor>huggingface_hub.ImageToVideoInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_video.py#L44</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_to_video.ImageToVideoParameters] = None"}]</parameters></docstring>
Inputs for Image To Video inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToVideoOutput</name><anchor>huggingface_hub.ImageToVideoOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_video.py#L56</source><parameters>[{"name": "video", "val": ": typing.Any"}]</parameters></docstring>
Outputs of inference for the Image To Video task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToVideoParameters</name><anchor>huggingface_hub.ImageToVideoParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_video.py#L20</source><parameters>[{"name": "guidance_scale", "val": ": typing.Optional[float] = None"}, {"name": "negative_prompt", "val": ": typing.Optional[str] = None"}, {"name": "num_frames", "val": ": typing.Optional[float] = None"}, {"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "prompt", "val": ": typing.Optional[str] = None"}, {"name": "seed", "val": ": typing.Optional[int] = None"}, {"name": "target_size", "val": ": typing.Optional[huggingface_hub.inference._generated.types.image_to_video.ImageToVideoTargetSize] = None"}]</parameters></docstring>
Additional inference parameters for Image To Video

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ImageToVideoTargetSize</name><anchor>huggingface_hub.ImageToVideoTargetSize</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/image_to_video.py#L12</source><parameters>[{"name": "height", "val": ": int"}, {"name": "width", "val": ": int"}]</parameters></docstring>
The size in pixel of the output video frames.

</div>

## object_detection[[huggingface_hub.ObjectDetectionBoundingBox]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ObjectDetectionBoundingBox</name><anchor>huggingface_hub.ObjectDetectionBoundingBox</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/object_detection.py#L32</source><parameters>[{"name": "xmax", "val": ": int"}, {"name": "xmin", "val": ": int"}, {"name": "ymax", "val": ": int"}, {"name": "ymin", "val": ": int"}]</parameters></docstring>
The predicted bounding box. Coordinates are relative to the top left corner of the input
image.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ObjectDetectionInput</name><anchor>huggingface_hub.ObjectDetectionInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/object_detection.py#L20</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.object_detection.ObjectDetectionParameters] = None"}]</parameters></docstring>
Inputs for Object Detection inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ObjectDetectionOutputElement</name><anchor>huggingface_hub.ObjectDetectionOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/object_detection.py#L48</source><parameters>[{"name": "box", "val": ": ObjectDetectionBoundingBox"}, {"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Object Detection task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ObjectDetectionParameters</name><anchor>huggingface_hub.ObjectDetectionParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/object_detection.py#L12</source><parameters>[{"name": "threshold", "val": ": typing.Optional[float] = None"}]</parameters></docstring>
Additional inference parameters for Object Detection

</div>

## question_answering[[huggingface_hub.QuestionAnsweringInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.QuestionAnsweringInput</name><anchor>huggingface_hub.QuestionAnsweringInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/question_answering.py#L54</source><parameters>[{"name": "inputs", "val": ": QuestionAnsweringInputData"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.question_answering.QuestionAnsweringParameters] = None"}]</parameters></docstring>
Inputs for Question Answering inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.QuestionAnsweringInputData</name><anchor>huggingface_hub.QuestionAnsweringInputData</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/question_answering.py#L12</source><parameters>[{"name": "context", "val": ": str"}, {"name": "question", "val": ": str"}]</parameters></docstring>
One (context, question) pair to answer

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.QuestionAnsweringOutputElement</name><anchor>huggingface_hub.QuestionAnsweringOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/question_answering.py#L64</source><parameters>[{"name": "answer", "val": ": str"}, {"name": "end", "val": ": int"}, {"name": "score", "val": ": float"}, {"name": "start", "val": ": int"}]</parameters></docstring>
Outputs of inference for the Question Answering task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.QuestionAnsweringParameters</name><anchor>huggingface_hub.QuestionAnsweringParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/question_answering.py#L22</source><parameters>[{"name": "align_to_words", "val": ": typing.Optional[bool] = None"}, {"name": "doc_stride", "val": ": typing.Optional[int] = None"}, {"name": "handle_impossible_answer", "val": ": typing.Optional[bool] = None"}, {"name": "max_answer_len", "val": ": typing.Optional[int] = None"}, {"name": "max_question_len", "val": ": typing.Optional[int] = None"}, {"name": "max_seq_len", "val": ": typing.Optional[int] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Question Answering

</div>

## sentence_similarity[[huggingface_hub.SentenceSimilarityInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SentenceSimilarityInput</name><anchor>huggingface_hub.SentenceSimilarityInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/sentence_similarity.py#L22</source><parameters>[{"name": "inputs", "val": ": SentenceSimilarityInputData"}, {"name": "parameters", "val": ": typing.Optional[dict[str, typing.Any]] = None"}]</parameters></docstring>
Inputs for Sentence similarity inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SentenceSimilarityInputData</name><anchor>huggingface_hub.SentenceSimilarityInputData</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/sentence_similarity.py#L12</source><parameters>[{"name": "sentences", "val": ": list"}, {"name": "source_sentence", "val": ": str"}]</parameters></docstring>


</div>

## summarization[[huggingface_hub.SummarizationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SummarizationInput</name><anchor>huggingface_hub.SummarizationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/summarization.py#L27</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.summarization.SummarizationParameters] = None"}]</parameters></docstring>
Inputs for Summarization inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SummarizationOutput</name><anchor>huggingface_hub.SummarizationOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/summarization.py#L37</source><parameters>[{"name": "summary_text", "val": ": str"}]</parameters></docstring>
Outputs of inference for the Summarization task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.SummarizationParameters</name><anchor>huggingface_hub.SummarizationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/summarization.py#L15</source><parameters>[{"name": "clean_up_tokenization_spaces", "val": ": typing.Optional[bool] = None"}, {"name": "generate_parameters", "val": ": typing.Optional[dict[str, typing.Any]] = None"}, {"name": "truncation", "val": ": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}]</parameters></docstring>
Additional inference parameters for summarization.

</div>

## table_question_answering[[huggingface_hub.TableQuestionAnsweringInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TableQuestionAnsweringInput</name><anchor>huggingface_hub.TableQuestionAnsweringInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/table_question_answering.py#L40</source><parameters>[{"name": "inputs", "val": ": TableQuestionAnsweringInputData"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.table_question_answering.TableQuestionAnsweringParameters] = None"}]</parameters></docstring>
Inputs for Table Question Answering inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TableQuestionAnsweringInputData</name><anchor>huggingface_hub.TableQuestionAnsweringInputData</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/table_question_answering.py#L12</source><parameters>[{"name": "question", "val": ": str"}, {"name": "table", "val": ": dict"}]</parameters></docstring>
One (table, question) pair to answer

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TableQuestionAnsweringOutputElement</name><anchor>huggingface_hub.TableQuestionAnsweringOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/table_question_answering.py#L50</source><parameters>[{"name": "answer", "val": ": str"}, {"name": "cells", "val": ": list"}, {"name": "coordinates", "val": ": list"}, {"name": "aggregator", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Outputs of inference for the Table Question Answering task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TableQuestionAnsweringParameters</name><anchor>huggingface_hub.TableQuestionAnsweringParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/table_question_answering.py#L25</source><parameters>[{"name": "padding", "val": ": typing.Optional[ForwardRef('Padding')] = None"}, {"name": "sequential", "val": ": typing.Optional[bool] = None"}, {"name": "truncation", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Additional inference parameters for Table Question Answering

</div>

## text2text_generation[[huggingface_hub.Text2TextGenerationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.Text2TextGenerationInput</name><anchor>huggingface_hub.Text2TextGenerationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text2text_generation.py#L27</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text2text_generation.Text2TextGenerationParameters] = None"}]</parameters></docstring>
Inputs for Text2text Generation inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.Text2TextGenerationOutput</name><anchor>huggingface_hub.Text2TextGenerationOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text2text_generation.py#L37</source><parameters>[{"name": "generated_text", "val": ": typing.Any"}, {"name": "text2_text_generation_output_generated_text", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Outputs of inference for the Text2text Generation task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.Text2TextGenerationParameters</name><anchor>huggingface_hub.Text2TextGenerationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text2text_generation.py#L15</source><parameters>[{"name": "clean_up_tokenization_spaces", "val": ": typing.Optional[bool] = None"}, {"name": "generate_parameters", "val": ": typing.Optional[dict[str, typing.Any]] = None"}, {"name": "truncation", "val": ": typing.Optional[ForwardRef('Text2TextGenerationTruncationStrategy')] = None"}]</parameters></docstring>
Additional inference parameters for Text2text Generation

</div>

## text_classification[[huggingface_hub.TextClassificationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextClassificationInput</name><anchor>huggingface_hub.TextClassificationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_classification.py#L25</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_classification.TextClassificationParameters] = None"}]</parameters></docstring>
Inputs for Text Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextClassificationOutputElement</name><anchor>huggingface_hub.TextClassificationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_classification.py#L35</source><parameters>[{"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Text Classification task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextClassificationParameters</name><anchor>huggingface_hub.TextClassificationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_classification.py#L15</source><parameters>[{"name": "function_to_apply", "val": ": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Text Classification

</div>

## text_generation[[huggingface_hub.TextGenerationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationInput</name><anchor>huggingface_hub.TextGenerationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L76</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGenerateParameters] = None"}, {"name": "stream", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Text Generation Input.
Auto-generated from TGI specs.
For more details, check out
https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/scripts/inference-tgi-import.ts.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationInputGenerateParameters</name><anchor>huggingface_hub.TextGenerationInputGenerateParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L25</source><parameters>[{"name": "adapter_id", "val": ": typing.Optional[str] = None"}, {"name": "best_of", "val": ": typing.Optional[int] = None"}, {"name": "decoder_input_details", "val": ": typing.Optional[bool] = None"}, {"name": "details", "val": ": typing.Optional[bool] = None"}, {"name": "do_sample", "val": ": typing.Optional[bool] = None"}, {"name": "frequency_penalty", "val": ": typing.Optional[float] = None"}, {"name": "grammar", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"}, {"name": "max_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "repetition_penalty", "val": ": typing.Optional[float] = None"}, {"name": "return_full_text", "val": ": typing.Optional[bool] = None"}, {"name": "seed", "val": ": typing.Optional[int] = None"}, {"name": "stop", "val": ": typing.Optional[list[str]] = None"}, {"name": "temperature", "val": ": typing.Optional[float] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}, {"name": "top_n_tokens", "val": ": typing.Optional[int] = None"}, {"name": "top_p", "val": ": typing.Optional[float] = None"}, {"name": "truncate", "val": ": typing.Optional[int] = None"}, {"name": "typical_p", "val": ": typing.Optional[float] = None"}, {"name": "watermark", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationInputGrammarType</name><anchor>huggingface_hub.TextGenerationInputGrammarType</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L15</source><parameters>[{"name": "type", "val": ": TypeEnum"}, {"name": "value", "val": ": typing.Any"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationOutput</name><anchor>huggingface_hub.TextGenerationOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L129</source><parameters>[{"name": "generated_text", "val": ": str"}, {"name": "details", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationOutputDetails] = None"}]</parameters></docstring>
Text Generation Output.
Auto-generated from TGI specs.
For more details, check out
https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/scripts/inference-tgi-import.ts.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationOutputBestOfSequence</name><anchor>huggingface_hub.TextGenerationOutputBestOfSequence</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L107</source><parameters>[{"name": "finish_reason", "val": ": TextGenerationOutputFinishReason"}, {"name": "generated_text", "val": ": str"}, {"name": "generated_tokens", "val": ": int"}, {"name": "prefill", "val": ": list"}, {"name": "tokens", "val": ": list"}, {"name": "seed", "val": ": typing.Optional[int] = None"}, {"name": "top_tokens", "val": ": typing.Optional[list[list[huggingface_hub.inference._generated.types.text_generation.TextGenerationOutputToken]]] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationOutputDetails</name><anchor>huggingface_hub.TextGenerationOutputDetails</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L118</source><parameters>[{"name": "finish_reason", "val": ": TextGenerationOutputFinishReason"}, {"name": "generated_tokens", "val": ": int"}, {"name": "prefill", "val": ": list"}, {"name": "tokens", "val": ": list"}, {"name": "best_of_sequences", "val": ": typing.Optional[list[huggingface_hub.inference._generated.types.text_generation.TextGenerationOutputBestOfSequence]] = None"}, {"name": "seed", "val": ": typing.Optional[int] = None"}, {"name": "top_tokens", "val": ": typing.Optional[list[list[huggingface_hub.inference._generated.types.text_generation.TextGenerationOutputToken]]] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationOutputPrefillToken</name><anchor>huggingface_hub.TextGenerationOutputPrefillToken</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L92</source><parameters>[{"name": "id", "val": ": int"}, {"name": "logprob", "val": ": float"}, {"name": "text", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationOutputToken</name><anchor>huggingface_hub.TextGenerationOutputToken</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L99</source><parameters>[{"name": "id", "val": ": int"}, {"name": "logprob", "val": ": float"}, {"name": "special", "val": ": bool"}, {"name": "text", "val": ": str"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationStreamOutput</name><anchor>huggingface_hub.TextGenerationStreamOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L157</source><parameters>[{"name": "index", "val": ": int"}, {"name": "token", "val": ": TextGenerationStreamOutputToken"}, {"name": "details", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationStreamOutputStreamDetails] = None"}, {"name": "generated_text", "val": ": typing.Optional[str] = None"}, {"name": "top_tokens", "val": ": typing.Optional[list[huggingface_hub.inference._generated.types.text_generation.TextGenerationStreamOutputToken]] = None"}]</parameters></docstring>
Text Generation Stream Output.
Auto-generated from TGI specs.
For more details, check out
https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/scripts/inference-tgi-import.ts.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationStreamOutputStreamDetails</name><anchor>huggingface_hub.TextGenerationStreamOutputStreamDetails</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L141</source><parameters>[{"name": "finish_reason", "val": ": TextGenerationOutputFinishReason"}, {"name": "generated_tokens", "val": ": int"}, {"name": "input_length", "val": ": int"}, {"name": "seed", "val": ": typing.Optional[int] = None"}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextGenerationStreamOutputToken</name><anchor>huggingface_hub.TextGenerationStreamOutputToken</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_generation.py#L149</source><parameters>[{"name": "id", "val": ": int"}, {"name": "logprob", "val": ": float"}, {"name": "special", "val": ": bool"}, {"name": "text", "val": ": str"}]</parameters></docstring>


</div>

## text_to_audio[[huggingface_hub.TextToAudioGenerationParameters]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToAudioGenerationParameters</name><anchor>huggingface_hub.TextToAudioGenerationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_audio.py#L15</source><parameters>[{"name": "do_sample", "val": ": typing.Optional[bool] = None"}, {"name": "early_stopping", "val": ": typing.Union[bool, ForwardRef('TextToAudioEarlyStoppingEnum'), NoneType] = None"}, {"name": "epsilon_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "eta_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "max_length", "val": ": typing.Optional[int] = None"}, {"name": "max_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "min_length", "val": ": typing.Optional[int] = None"}, {"name": "min_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "num_beam_groups", "val": ": typing.Optional[int] = None"}, {"name": "num_beams", "val": ": typing.Optional[int] = None"}, {"name": "penalty_alpha", "val": ": typing.Optional[float] = None"}, {"name": "temperature", "val": ": typing.Optional[float] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}, {"name": "top_p", "val": ": typing.Optional[float] = None"}, {"name": "typical_p", "val": ": typing.Optional[float] = None"}, {"name": "use_cache", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Parametrization of the text generation process

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToAudioInput</name><anchor>huggingface_hub.TextToAudioInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_audio.py#L83</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_to_audio.TextToAudioParameters] = None"}]</parameters></docstring>
Inputs for Text To Audio inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToAudioOutput</name><anchor>huggingface_hub.TextToAudioOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_audio.py#L93</source><parameters>[{"name": "audio", "val": ": typing.Any"}, {"name": "sampling_rate", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Text To Audio task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToAudioParameters</name><anchor>huggingface_hub.TextToAudioParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_audio.py#L75</source><parameters>[{"name": "generation_parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_to_audio.TextToAudioGenerationParameters] = None"}]</parameters></docstring>
Additional inference parameters for Text To Audio

</div>

## text_to_image[[huggingface_hub.TextToImageInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToImageInput</name><anchor>huggingface_hub.TextToImageInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_image.py#L36</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_to_image.TextToImageParameters] = None"}]</parameters></docstring>
Inputs for Text To Image inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToImageOutput</name><anchor>huggingface_hub.TextToImageOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_image.py#L46</source><parameters>[{"name": "image", "val": ": typing.Any"}]</parameters></docstring>
Outputs of inference for the Text To Image task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToImageParameters</name><anchor>huggingface_hub.TextToImageParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_image.py#L12</source><parameters>[{"name": "guidance_scale", "val": ": typing.Optional[float] = None"}, {"name": "height", "val": ": typing.Optional[int] = None"}, {"name": "negative_prompt", "val": ": typing.Optional[str] = None"}, {"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "scheduler", "val": ": typing.Optional[str] = None"}, {"name": "seed", "val": ": typing.Optional[int] = None"}, {"name": "width", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Text To Image

</div>

## text_to_speech[[huggingface_hub.TextToSpeechGenerationParameters]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToSpeechGenerationParameters</name><anchor>huggingface_hub.TextToSpeechGenerationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_speech.py#L15</source><parameters>[{"name": "do_sample", "val": ": typing.Optional[bool] = None"}, {"name": "early_stopping", "val": ": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"}, {"name": "epsilon_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "eta_cutoff", "val": ": typing.Optional[float] = None"}, {"name": "max_length", "val": ": typing.Optional[int] = None"}, {"name": "max_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "min_length", "val": ": typing.Optional[int] = None"}, {"name": "min_new_tokens", "val": ": typing.Optional[int] = None"}, {"name": "num_beam_groups", "val": ": typing.Optional[int] = None"}, {"name": "num_beams", "val": ": typing.Optional[int] = None"}, {"name": "penalty_alpha", "val": ": typing.Optional[float] = None"}, {"name": "temperature", "val": ": typing.Optional[float] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}, {"name": "top_p", "val": ": typing.Optional[float] = None"}, {"name": "typical_p", "val": ": typing.Optional[float] = None"}, {"name": "use_cache", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Parametrization of the text generation process

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToSpeechInput</name><anchor>huggingface_hub.TextToSpeechInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_speech.py#L83</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_to_speech.TextToSpeechParameters] = None"}]</parameters></docstring>
Inputs for Text To Speech inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToSpeechOutput</name><anchor>huggingface_hub.TextToSpeechOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_speech.py#L93</source><parameters>[{"name": "audio", "val": ": typing.Any"}, {"name": "sampling_rate", "val": ": typing.Optional[float] = None"}]</parameters></docstring>
Outputs of inference for the Text To Speech task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToSpeechParameters</name><anchor>huggingface_hub.TextToSpeechParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_speech.py#L75</source><parameters>[{"name": "generation_parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_to_speech.TextToSpeechGenerationParameters] = None"}]</parameters></docstring>
Additional inference parameters for Text To Speech

</div>

## text_to_video[[huggingface_hub.TextToVideoInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToVideoInput</name><anchor>huggingface_hub.TextToVideoInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_video.py#L32</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.text_to_video.TextToVideoParameters] = None"}]</parameters></docstring>
Inputs for Text To Video inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToVideoOutput</name><anchor>huggingface_hub.TextToVideoOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_video.py#L42</source><parameters>[{"name": "video", "val": ": typing.Any"}]</parameters></docstring>
Outputs of inference for the Text To Video task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TextToVideoParameters</name><anchor>huggingface_hub.TextToVideoParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/text_to_video.py#L12</source><parameters>[{"name": "guidance_scale", "val": ": typing.Optional[float] = None"}, {"name": "negative_prompt", "val": ": typing.Optional[list[str]] = None"}, {"name": "num_frames", "val": ": typing.Optional[float] = None"}, {"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "seed", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Text To Video

</div>

## token_classification[[huggingface_hub.TokenClassificationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TokenClassificationInput</name><anchor>huggingface_hub.TokenClassificationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/token_classification.py#L27</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.token_classification.TokenClassificationParameters] = None"}]</parameters></docstring>
Inputs for Token Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TokenClassificationOutputElement</name><anchor>huggingface_hub.TokenClassificationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/token_classification.py#L37</source><parameters>[{"name": "end", "val": ": int"}, {"name": "score", "val": ": float"}, {"name": "start", "val": ": int"}, {"name": "word", "val": ": str"}, {"name": "entity", "val": ": typing.Optional[str] = None"}, {"name": "entity_group", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Outputs of inference for the Token Classification task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TokenClassificationParameters</name><anchor>huggingface_hub.TokenClassificationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/token_classification.py#L15</source><parameters>[{"name": "aggregation_strategy", "val": ": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"}, {"name": "ignore_labels", "val": ": typing.Optional[list[str]] = None"}, {"name": "stride", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Token Classification

</div>

## translation[[huggingface_hub.TranslationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TranslationInput</name><anchor>huggingface_hub.TranslationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/translation.py#L35</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.translation.TranslationParameters] = None"}]</parameters></docstring>
Inputs for Translation inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TranslationOutput</name><anchor>huggingface_hub.TranslationOutput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/translation.py#L45</source><parameters>[{"name": "translation_text", "val": ": str"}]</parameters></docstring>
Outputs of inference for the Translation task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.TranslationParameters</name><anchor>huggingface_hub.TranslationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/translation.py#L15</source><parameters>[{"name": "clean_up_tokenization_spaces", "val": ": typing.Optional[bool] = None"}, {"name": "generate_parameters", "val": ": typing.Optional[dict[str, typing.Any]] = None"}, {"name": "src_lang", "val": ": typing.Optional[str] = None"}, {"name": "tgt_lang", "val": ": typing.Optional[str] = None"}, {"name": "truncation", "val": ": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"}]</parameters></docstring>
Additional inference parameters for Translation

</div>

## video_classification[[huggingface_hub.VideoClassificationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.VideoClassificationInput</name><anchor>huggingface_hub.VideoClassificationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/video_classification.py#L29</source><parameters>[{"name": "inputs", "val": ": typing.Any"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.video_classification.VideoClassificationParameters] = None"}]</parameters></docstring>
Inputs for Video Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.VideoClassificationOutputElement</name><anchor>huggingface_hub.VideoClassificationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/video_classification.py#L39</source><parameters>[{"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Video Classification task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.VideoClassificationParameters</name><anchor>huggingface_hub.VideoClassificationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/video_classification.py#L15</source><parameters>[{"name": "frame_sampling_rate", "val": ": typing.Optional[int] = None"}, {"name": "function_to_apply", "val": ": typing.Optional[ForwardRef('VideoClassificationOutputTransform')] = None"}, {"name": "num_frames", "val": ": typing.Optional[int] = None"}, {"name": "top_k", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Video Classification

</div>

## visual_question_answering[[huggingface_hub.VisualQuestionAnsweringInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.VisualQuestionAnsweringInput</name><anchor>huggingface_hub.VisualQuestionAnsweringInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/visual_question_answering.py#L33</source><parameters>[{"name": "inputs", "val": ": VisualQuestionAnsweringInputData"}, {"name": "parameters", "val": ": typing.Optional[huggingface_hub.inference._generated.types.visual_question_answering.VisualQuestionAnsweringParameters] = None"}]</parameters></docstring>
Inputs for Visual Question Answering inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.VisualQuestionAnsweringInputData</name><anchor>huggingface_hub.VisualQuestionAnsweringInputData</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/visual_question_answering.py#L12</source><parameters>[{"name": "image", "val": ": typing.Any"}, {"name": "question", "val": ": str"}]</parameters></docstring>
One (image, question) pair to answer

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.VisualQuestionAnsweringOutputElement</name><anchor>huggingface_hub.VisualQuestionAnsweringOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/visual_question_answering.py#L43</source><parameters>[{"name": "score", "val": ": float"}, {"name": "answer", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Outputs of inference for the Visual Question Answering task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.VisualQuestionAnsweringParameters</name><anchor>huggingface_hub.VisualQuestionAnsweringParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/visual_question_answering.py#L22</source><parameters>[{"name": "top_k", "val": ": typing.Optional[int] = None"}]</parameters></docstring>
Additional inference parameters for Visual Question Answering

</div>

## zero_shot_classification[[huggingface_hub.ZeroShotClassificationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotClassificationInput</name><anchor>huggingface_hub.ZeroShotClassificationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_classification.py#L29</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": ZeroShotClassificationParameters"}]</parameters></docstring>
Inputs for Zero Shot Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotClassificationOutputElement</name><anchor>huggingface_hub.ZeroShotClassificationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_classification.py#L39</source><parameters>[{"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Zero Shot Classification task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotClassificationParameters</name><anchor>huggingface_hub.ZeroShotClassificationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_classification.py#L12</source><parameters>[{"name": "candidate_labels", "val": ": list"}, {"name": "hypothesis_template", "val": ": typing.Optional[str] = None"}, {"name": "multi_label", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>
Additional inference parameters for Zero Shot Classification

</div>

## zero_shot_image_classification[[huggingface_hub.ZeroShotImageClassificationInput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotImageClassificationInput</name><anchor>huggingface_hub.ZeroShotImageClassificationInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_image_classification.py#L24</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": ZeroShotImageClassificationParameters"}]</parameters></docstring>
Inputs for Zero Shot Image Classification inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotImageClassificationOutputElement</name><anchor>huggingface_hub.ZeroShotImageClassificationOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_image_classification.py#L34</source><parameters>[{"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Zero Shot Image Classification task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotImageClassificationParameters</name><anchor>huggingface_hub.ZeroShotImageClassificationParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_image_classification.py#L12</source><parameters>[{"name": "candidate_labels", "val": ": list"}, {"name": "hypothesis_template", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Additional inference parameters for Zero Shot Image Classification

</div>

## zero_shot_object_detection[[huggingface_hub.ZeroShotObjectDetectionBoundingBox]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotObjectDetectionBoundingBox</name><anchor>huggingface_hub.ZeroShotObjectDetectionBoundingBox</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_object_detection.py#L28</source><parameters>[{"name": "xmax", "val": ": int"}, {"name": "xmin", "val": ": int"}, {"name": "ymax", "val": ": int"}, {"name": "ymin", "val": ": int"}]</parameters></docstring>
The predicted bounding box. Coordinates are relative to the top left corner of the input
image.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotObjectDetectionInput</name><anchor>huggingface_hub.ZeroShotObjectDetectionInput</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_object_detection.py#L18</source><parameters>[{"name": "inputs", "val": ": str"}, {"name": "parameters", "val": ": ZeroShotObjectDetectionParameters"}]</parameters></docstring>
Inputs for Zero Shot Object Detection inference

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotObjectDetectionOutputElement</name><anchor>huggingface_hub.ZeroShotObjectDetectionOutputElement</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_object_detection.py#L40</source><parameters>[{"name": "box", "val": ": ZeroShotObjectDetectionBoundingBox"}, {"name": "label", "val": ": str"}, {"name": "score", "val": ": float"}]</parameters></docstring>
Outputs of inference for the Zero Shot Object Detection task

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.ZeroShotObjectDetectionParameters</name><anchor>huggingface_hub.ZeroShotObjectDetectionParameters</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/types/zero_shot_object_detection.py#L10</source><parameters>[{"name": "candidate_labels", "val": ": list"}]</parameters></docstring>
Additional inference parameters for Zero Shot Object Detection

</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/inference_types.md" />