# Jobs

Check the [HfApi](/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi) documentation page for the reference of methods to manage your Jobs on the Hub.

- Run a Job: [run_job()](/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_job)
- Fetch logs: [fetch_job_logs()](/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.fetch_job_logs)
- Inspect Job: [inspect_job()](/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.inspect_job)
- List Jobs: [list_jobs()](/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_jobs)
- Cancel Job: [cancel_job()](/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.cancel_job)
- Run a UV Job: [run_uv_job()](/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.run_uv_job)

## Data structures

### JobInfo[[huggingface_hub.JobInfo]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.JobInfo</name><anchor>huggingface_hub.JobInfo</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_jobs_api.py#L59</source><parameters>[{"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **id** (`str`) --
  Job ID.
- **created_at** (`datetime` or `None`) --
  When the Job was created.
- **docker_image** (`str` or `None`) --
  The Docker image from Docker Hub used for the Job.
  Can be None if space_id is present instead.
- **space_id** (`str` or `None`) --
  The Docker image from Hugging Face Spaces used for the Job.
  Can be None if docker_image is present instead.
- **command** (`list[str]` or `None`) --
  Command of the Job, e.g. `["python", "-c", "print('hello world')"]`
- **arguments** (`list[str]` or `None`) --
  Arguments passed to the command
- **environment** (`dict[str]` or `None`) --
  Environment variables of the Job as a dictionary.
- **secrets** (`dict[str]` or `None`) --
  Secret environment variables of the Job (encrypted).
- **flavor** (`str` or `None`) --
  Flavor for the hardware, as in Hugging Face Spaces. See [SpaceHardware](/docs/huggingface_hub/main/en/package_reference/space_runtime#huggingface_hub.SpaceHardware) for possible values.
  E.g. `"cpu-basic"`.
- **status** -- (`JobStatus` or `None`):
  Status of the Job, e.g. `JobStatus(stage="RUNNING", message=None)`
  See [JobStage](/docs/huggingface_hub/main/en/package_reference/jobs#huggingface_hub.JobStage) for possible stage values.
- **owner** -- (`JobOwner` or `None`):
  Owner of the Job, e.g. `JobOwner(id="5e9ecfc04957053f60648a3e", name="lhoestq", type="user")`</paramsdesc><paramgroups>0</paramgroups></docstring>

Contains information about a Job.



<ExampleCodeBlock anchor="huggingface_hub.JobInfo.example">

Example:

```python
>>> from huggingface_hub import run_job
>>> job = run_job(
...     image="python:3.12",
...     command=["python", "-c", "print('Hello from the cloud!')"]
... )
>>> job
JobInfo(id='687fb701029421ae5549d998', created_at=datetime.datetime(2025, 7, 22, 16, 6, 25, 79000, tzinfo=datetime.timezone.utc), docker_image='python:3.12', space_id=None, command=['python', '-c', "print('Hello from the cloud!')"], arguments=[], environment={}, secrets={}, flavor='cpu-basic', status=JobStatus(stage='RUNNING', message=None), owner=JobOwner(id='5e9ecfc04957053f60648a3e', name='lhoestq', type='user'), endpoint='https://huggingface.co', url='https://huggingface.co/jobs/lhoestq/687fb701029421ae5549d998')
>>> job.id
'687fb701029421ae5549d998'
>>> job.url
'https://huggingface.co/jobs/lhoestq/687fb701029421ae5549d998'
>>> job.status.stage
'RUNNING'
```

</ExampleCodeBlock>


</div>

### JobOwner[[huggingface_hub.JobOwner]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.JobOwner</name><anchor>huggingface_hub.JobOwner</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_jobs_api.py#L52</source><parameters>[{"name": "id", "val": ": str"}, {"name": "name", "val": ": str"}, {"name": "type", "val": ": str"}]</parameters></docstring>


</div>

### JobStage[[huggingface_hub.JobStage]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.JobStage</name><anchor>huggingface_hub.JobStage</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_jobs_api.py#L25</source><parameters>[{"name": "value", "val": ""}, {"name": "names", "val": " = None"}, {"name": "module", "val": " = None"}, {"name": "qualname", "val": " = None"}, {"name": "type", "val": " = None"}, {"name": "start", "val": " = 1"}]</parameters></docstring>

Enumeration of possible stage of a Job on the Hub.

<ExampleCodeBlock anchor="huggingface_hub.JobStage.example">

Value can be compared to a string:
```py
assert JobStage.COMPLETED == "COMPLETED"
```

</ExampleCodeBlock>
Possible values are: `COMPLETED`, `CANCELED`, `ERROR`, `DELETED`, `RUNNING`.
Taken from https://github.com/huggingface/moon-landing/blob/main/server/job_types/JobInfo.ts#L61 (private url).


</div>

### JobStatus[[huggingface_hub.JobStatus]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.JobStatus</name><anchor>huggingface_hub.JobStatus</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_jobs_api.py#L46</source><parameters>[{"name": "stage", "val": ": JobStage"}, {"name": "message", "val": ": typing.Optional[str]"}]</parameters></docstring>


</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/jobs.md" />