# Un client Python pour le Hugging Face Hub 


La librairie `huggingface_hub` vous permet d'interagir avec le
[Hugging Face Hub](https://hf.co), une plateforme de machine learning
pour créer et collaborer. Découvrez des modèles pré-
entrainés et des datasets pour vos projets ou jouez avec des centraines
d'applications hébergées sur le Hub. Vous pouvez aussi
créer et partager vos propres modèles et datasets avec la communauté.
La librairie `huggingface_hub` offre une manière simple de faire toutes
ces choses avec Python.

Lisez le [guide d'introduction rapide](quick-start) pour vous lancer avec la librairie
`huggingface_hub`. Vous apprendrez à télécharger des fichiers depuis le Hub,
à créer un dépôt et upload des fichiers vers le Hub. Continuez à lire pour
apprendre le management de dépôt sur le Hub, comment interagir avec les discussions
ou même comment accéder à l'API d'inférence.

<div class="mt-10">
  <div class="w-full flex flex-col space-y-4 md:space-y-0 md:grid md:grid-cols-2 md:gap-y-4 md:gap-x-5">

    <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./guides/overview">
      <div class="w-full text-center bg-gradient-to-br from-indigo-400 to-indigo-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Vue d'ensemble</div>
      <p class="text-gray-700">Guides pratiques pour vous aider à atteindre un but en particulier. Lisez ces guides pour apprendre comment utiliser huggingface_hub pour résoudre des problèmes concrets.</p>
    </a>

    <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./package_reference/overview">
      <div class="w-full text-center bg-gradient-to-br from-purple-400 to-purple-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Références</div>
      <p class="text-gray-700">Description exhaustive des classes et méthodes présentes dans huggingface_hub.</p>
    </a>

    <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./concepts/git_vs_http">
      <div class="w-full text-center bg-gradient-to-br from-pink-400 to-pink-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Guides conceptuels</div>
      <p class="text-gray-700">Explications permettant d'avoir une meilleure compréhension de la philosophie derrière huggingface_hub.</p>
    </a>

  </div>
</div>

<!-- 
<a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./tutorials/overview"
  ><div class="w-full text-center bg-gradient-to-br from-blue-400 to-blue-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">Tutoriaux</div>
  <p class="text-gray-700">Apprenez les bases et familiarisez vous avec l'utilisation de huggingface_hub pour intéragir avec le Hub 🤗 depuis le code!</p>
</a> -->

## Contributions

Toutes les contributions au projet `huggingface_hub` sont les bienvenues et valorisées à la même hauteur.
🤗 En plus de l'ajout ou de la correction de bug dans le code, vous
pouvez également aider à améliorer la documentation en vérifiant qu'elle est exacte et
à jour, répondre à des questions sur des issues, et demander de nouvelles fonctionnalités
qui amélioreront la librairie. Regardez le [guide de contribution](https://github.com/huggingface/huggingface_hub/blob/main/CONTRIBUTING.md)
pour en savoir plus sur comment commencer à travailler sur une issue, comment faire une pull request et comment tester vos contributions pour
vérifier que vos modifications fonctionnent comme prévu.

Les contributeurs doivent aussi respecter notre [code de conduite](https://github.com/huggingface/huggingface_hub/blob/main/CODE_OF_CONDUCT.md) (en anglais) pour créer un espace collaboratif inclusif et bienveillant envers tout le monde.

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/fr/index.md" />