import{s as Ea,n as Ia,o as Ba}from"../chunks/scheduler.0cf4ef2e.js";import{S as $a,i as Za,e as p,s as e,c as i,h as Fa,a as M,d as a,b as n,f as Qa,g as U,j as J,k as vs,l as Ra,m as t,n as c,t as j,o as h,p as T}from"../chunks/index.abc433bf.js";import{C as ka,H as m,E as xa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f7de33ce.js";import{C as r}from"../chunks/CodeBlock.abc7ded2.js";function Na(Hs){let d,$l,Il,Zl,u,Fl,g,Rl,w,Ls='<code>huggingface_hub</code> 라이브러리는 모델 카드를 생성, 공유, 업데이트할 수 있는 파이썬 인터페이스를 제공합니다. Hub의 모델 카드가 무엇인지, 그리고 실제로 어떻게 작동하는지에 대한 자세한 내용을 확인하려면 <a href="https://huggingface.co/docs/hub/models-cards" rel="nofollow">전용 설명 페이지</a>를 방문하세요.',kl,o,Ds='<p>[!TIP][신규 (베타)! 우리의 실험적인 모델 카드 크리에이터 앱을 사용해 보세요](<a href="https://huggingface.co/spaces/huggingface/Model_Cards_Writing_Tool" rel="nofollow">https://huggingface.co/spaces/huggingface/Model_Cards_Writing_Tool</a>)</p>',xl,f,Nl,V,zs='Hub에서 기존 카드를 불러오려면 <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.RepoCard.load">ModelCard.load()</a> 기능을 사용하면 됩니다. 이 문서에서는 <a href="https://huggingface.co/nateraw/vit-base-beans" rel="nofollow"><code>nateraw/vit-base-beans</code></a>에서 카드를 불러오겠습니다.',Al,b,_l,Q,qs="이 카드에는 접근하거나 활용할 수 있는 몇 가지 유용한 속성이 있습니다:",Xl,E,Os='<li><code>card.data</code>: 모델 카드의 메타데이터와 함께 <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> 인스턴스를 반환합니다. 이 인스턴스에 <code>.to_dict()</code>를 호출하여 표현을 사전으로 가져옵니다.</li> <li><code>card.text</code>: <em>메타데이터 헤더를 제외</em>한 카드의 텍스트를 반환합니다.</li> <li><code>card.content</code>: <em>메타데이터 헤더를 포함</em>한 카드의 텍스트 콘텐츠를 반환합니다.</li>',Gl,I,Yl,B,Sl,$,Ps="텍스트로 모델 카드의 초기 내용을 설정하려면, 카드의 텍스트 내용을 초기화 시 <code>ModelCard</code>에 전달하면 됩니다.",Wl,Z,vl,F,Ks="이 작업을 수행하는 또 다른 방법은 f-strings를 사용하는 것입니다. 다음 예에서 우리는:",Hl,R,la='<li>모델 카드에 YAML 블록을 삽입할 수 있도록 <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.CardData.to_yaml">ModelCardData.to_yaml()</a>을 사용해서 우리가 정의한 메타데이터를 YAML로 변환합니다.</li> <li>Python f-strings를 통해 템플릿 변수를 사용할 방법을 보여줍니다.</li>',Ll,k,Dl,x,sa="위 예시는 다음과 같은 모습의 카드를 남깁니다:",zl,N,ql,A,Ol,_,aa="<code>Jinja2</code>가 설치되어 있으면, jinja 템플릿 파일에서 모델 카드를 만들 수 있습니다. 기본적인 예를 살펴보겠습니다:",Pl,X,Kl,G,ta="결과 카드의 마크다운은 다음과 같습니다:",ls,Y,ss,S,ea="카드 데이터를 업데이트하면 카드 자체에 반영됩니다.",as,W,ts,v,na="이제 보시다시피 메타데이터 헤더가 업데이트되었습니다:",es,H,ns,L,pa='카드 데이터를 업데이트할 때 <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.RepoCard.validate">ModelCard.validate()</a>를 불러와 Hub에 대해 카드가 여전히 유효한지 확인할 수 있습니다. 이렇게 하면 Hugging Face Hub에 설정된 모든 유효성 검사 규칙을 통과할 수 있습니다.',ps,D,Ms,z,Ma='자체 템플릿을 사용하는 대신에, 많은 섹션으로 구성된 기능이 풍부한 <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md" rel="nofollow">기본 템플릿</a>을 사용할 수도 있습니다. 내부적으론 <a href="https://jinja.palletsprojects.com/en/3.1.x/" rel="nofollow">Jinja2</a> 를 사용하여 템플릿 파일을 작성합니다.',Js,C,Ja="<p><code>from_template</code>를 사용하려면 jinja2를 설치해야 합니다. <code>pip install Jinja2</code>를 사용하면 됩니다.</p>",is,q,Us,O,cs,P,ia='Hugging Face Hub로 인증받은 경우(<code>hf auth login</code> 또는 <a href="/docs/huggingface_hub/main/ko/package_reference/login#huggingface_hub.login">login()</a> 사용) 간단히 <a href="/docs/huggingface_hub/main/ko/package_reference/cards#huggingface_hub.RepoCard.push_to_hub">ModelCard.push_to_hub()</a>를 호출하여 카드를 Hub에 푸시할 수 있습니다. 이를 수행하는 방법을 살펴보겠습니다.',js,K,Ua="먼저 인증된 사용자의 네임스페이스 아래에 ‘hf-hub-modelcards-pr-test’라는 새로운 레포지토리를 만듭니다:",hs,ll,Ts,sl,ca="그런 다음 기본 템플릿에서 카드를 만듭니다(위 섹션에서 정의한 것과 동일):",rs,al,ds,tl,ja="마지막으로 이를 Hub로 푸시하겠습니다.",ms,el,Cs,nl,ha='결과 카드는 <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/blob/main/README.md" rel="nofollow">여기</a>에서 확인할 수 있습니다.',ys,pl,Ta="PR로 카드를 푸시하고 싶다면 <code>push_to_hub</code>를 호출할 때 <code>create_pr=True</code>라고 지정하면 됩니다.",us,Ml,gs,Jl,ra='이 명령으로 생성된 결과 PR은 <a href="https://huggingface.co/nateraw/hf-hub-modelcards-pr-test/discussions/3" rel="nofollow">여기</a>에서 볼 수 있습니다.',ws,il,os,Ul,da="이 섹션에서는 레포 카드에 있는 메타데이터와 업데이트 방법을 확인합니다.",fs,cl,ma='<code>메타데이터</code>는 모델, 데이터 세트, Spaces에 대한 높은 수준의 정보를 제공하는 해시맵(또는 키 값) 컨텍스트를 말합니다. 모델의 <code>pipeline type</code>, <code>model_id</code> 또는 <code>model_desc</code> 설명 등의 정보가 포함될 수 있습니다. 자세한 내용은 <a href="https://huggingface.co/docs/hub/model-cards#model-card-metadata" rel="nofollow">모델 카드</a>, <a href="https://huggingface.co/docs/hub/datasets-cards#dataset-card-metadata" rel="nofollow">데이터 세트 카드</a> 및 <a href="https://huggingface.co/docs/hub/spaces-settings#spaces-settings" rel="nofollow">�Spaces 설정</a> 을 참조하세요. 이제 메타데이터를 업데이트하는 방법에 대한 몇 가지 예를 살펴보겠습니다.',Vs,jl,Ca="첫 번째 예부터 살펴보겠습니다:",bs,hl,Qs,Tl,ya="두 줄의 코드를 사용하면 메타데이터를 업데이트하여 새로운 <code>파이프라인_태그</code>를 설정할 수 있습니다.",Es,rl,ua="기본적으로 카드에 이미 존재하는 키는 업데이트할 수 없습니다. 그렇게 하려면 <code>overwrite=True</code>를 명시적으로 전달해야 합니다.",Is,dl,Bs,ml,ga="쓰기 권한이 없는 저장소에 일부 변경 사항을 제안하려는 경우가 종종 있습니다. 소유자가 귀하의 제안을 검토하고 병합할 수 있도록 해당 저장소에 PR을 생성하면 됩니다.",$s,Cl,Zs,yl,Fs,ul,wa='메타데이터 <code>모델-인덱스</code>에 평가 결과를 포함하려면 관련 평가 결과와 함께 [EvalResult] 또는 <code>EvalResult</code> 목록을 전달하면 됩니다. 내부적으론 <code>card.data.to _dict()</code>를 호출하면 <code>모델-인덱스</code>가 생성됩니다. 자세한 내용은 <a href="https://huggingface.co/docs/hub/models-cards#evaluation-results" rel="nofollow">Hub 문서의 이 섹션</a>을 참조하십시오.',Rs,y,oa="<p>이 기능을 사용하려면 [ModelCardData]에 <code>model_name</code> 속성을 포함해야 합니다.</p>",ks,gl,xs,wl,fa="결과 <code>card.data</code>는 다음과 같이 보여야 합니다:",Ns,ol,As,fl,Va="<code>EvalResult</code>: 공유하고 싶은 평가 결과가 둘 이상 있는 경우 <code>EvalResults</code> 목록을 전달하기만 하면 됩니다:",_s,Vl,Xs,bl,ba="그러면 다음 <code>card.data</code>가 남게 됩니다:",Gs,Ql,Ys,El,Ss,Bl,Ws;return u=new ka({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new m({props:{title:"모델 카드 생성 및 공유",local:"create-and-share-model-cards",headingTag:"h1"}}),f=new m({props:{title:"Hub에서 모델 카드 불러오기",local:"load-a-model-card-from-the-hub",headingTag:"h2"}}),b=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQubG9hZCgnbmF0ZXJhdyUyRnZpdC1iYXNlLWJlYW5zJyk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard

card = ModelCard.load(<span class="hljs-string">&#x27;nateraw/vit-base-beans&#x27;</span>)`,wrap:!1}}),I=new m({props:{title:"모델 카드 만들기",local:"create-model-cards",headingTag:"h2"}}),B=new m({props:{title:"텍스트에서 생성",local:"from-text",headingTag:"h3"}}),Z=new r({props:{code:"Y29udGVudCUyMCUzRCUyMCUyMiUyMiUyMiUwQS0tLSUwQWxhbmd1YWdlJTNBJTIwZW4lMEFsaWNlbnNlJTNBJTIwbWl0JTBBLS0tJTBBJTBBJTIzJTIwJUVCJTgyJUI0JTIwJUVCJUFBJUE4JUVCJThEJUI4JTIwJUVDJUI5JUI0JUVCJTkzJTlDJTBBJTIyJTIyJTIyJTBBJTBBY2FyZCUyMCUzRCUyME1vZGVsQ2FyZChjb250ZW50KSUwQWNhcmQuZGF0YS50b19kaWN0KCklMjAlM0QlM0QlMjAlN0InbGFuZ3VhZ2UnJTNBJTIwJ2VuJyUyQyUyMCdsaWNlbnNlJyUzQSUyMCdtaXQnJTdEJTIwJTIwJTIzJTIwVHJ1ZQ==",highlighted:`content = <span class="hljs-string">&quot;&quot;&quot;
---
language: en
license: mit
---

# 내 모델 카드
&quot;&quot;&quot;</span>

card = ModelCard(content)
card.data.to_dict() == {<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>}  <span class="hljs-comment"># True</span>`,wrap:!1}}),k=new r({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5JTNEJ3RpbW0nKSUwQSUwQWV4YW1wbGVfdGVtcGxhdGVfdmFyJTIwJTNEJTIwJ25hdGVyYXcnJTBBY29udGVudCUyMCUzRCUyMGYlMjIlMjIlMjIlMEEtLS0lMEElN0IlMjBjYXJkX2RhdGEudG9feWFtbCgpJTIwJTdEJTBBLS0tJTBBJTBBJTIzJTIwJUVCJTgyJUI0JTIwJUVCJUFBJUE4JUVCJThEJUI4JTIwJUVDJUI5JUI0JUVCJTkzJTlDJTBBJTBBJUVDJTlEJUI0JTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTlEJTgwJTIwJTVCJTQwJTdCZXhhbXBsZV90ZW1wbGF0ZV92YXIlN0QlNUQoaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGJTIwJTdCZXhhbXBsZV90ZW1wbGF0ZV92YXIlN0QpJUVDJTk3JTkwJTIwJUVDJTlEJTk4JUVEJTk1JUI0JTIwJUVDJTgzJTlEJUVDJTg0JUIxJUVCJTkwJTk4JUVDJTk3JTg4JUVDJThBJUI1JUVCJThCJTg4JUVCJThCJUE0JTBBJTIyJTIyJTIyJTBBJTBBY2FyZCUyMCUzRCUyME1vZGVsQ2FyZChjb250ZW50KSUwQXByaW50KGNhcmQp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library=<span class="hljs-string">&#x27;timm&#x27;</span>)

example_template_var = <span class="hljs-string">&#x27;nateraw&#x27;</span>
content = <span class="hljs-string">f&quot;&quot;&quot;
---
<span class="hljs-subst">{ card_data.to_yaml() }</span>
---

# 내 모델 카드

이 모델은 [@<span class="hljs-subst">{example_template_var}</span>](https://github.com/ <span class="hljs-subst">{example_template_var}</span>)에 의해 생성되었습니다
&quot;&quot;&quot;</span>

card = ModelCard(content)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),N=new r({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5JTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyMCVFQiU4MiVCNCUyMCVFQiVBQSVBOCVFQiU4RCVCOCUyMCVFQyVCOSVCNCVFQiU5MyU5QyUwQSUwQVRoaXMlMjBtb2RlbCUyMGNyZWF0ZWQlMjBieSUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGbmF0ZXJhdyk=",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># 내 모델 카드</span>

<span class="hljs-string">This</span> <span class="hljs-string">model</span> <span class="hljs-string">created</span> <span class="hljs-string">by</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://github.com/nateraw)</span>`,wrap:!1}}),A=new m({props:{title:"Jinja 템플릿으로부터",local:"from-a-jinja-template",headingTag:"h3"}}),X=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-comment"># jinja 템플릿 정의</span>
template_text = <span class="hljs-string">&quot;&quot;&quot;
---
{{ card_data }}
---

# MyCoolModel 모델용 모델 카드

이 모델은 이런 저런 것들을 합니다.

이 모델은 [[@{{ author }}](https://hf.co/{{author}})에 의해 생성되었습니다.
&quot;&quot;&quot;</span>.strip() 

<span class="hljs-comment"># 템플릿을 파일에 쓰기</span>
Path(<span class="hljs-string">&#x27;custom_template.md&#x27;</span>).write_text(template_text)

<span class="hljs-comment"># 카드 메타데이터 정의</span>
card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)

<span class="hljs-comment"># 템플릿에서 카드를 만들고 원하는 Jinja 템플릿 변수를 전달합니다.</span>
<span class="hljs-comment"># 우리의 경우에는 작성자를 전달하겠습니다.</span>
card = ModelCard.from_template(card_data, template_path=<span class="hljs-string">&#x27;custom_template.md&#x27;</span>, author=<span class="hljs-string">&#x27;nateraw&#x27;</span>)
card.save(<span class="hljs-string">&#x27;my_model_card_1.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),Y=new r({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFsaWJyYXJ5X25hbWUlM0ElMjBrZXJhcyUwQS0tLSUwQSUwQSUyMyUyME15Q29vbE1vZGVsJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTlBJUE5JTIwJUVCJUFBJUE4JUVCJThEJUI4JTIwJUVDJUI5JUI0JUVCJTkzJTlDJTBBJTBBJUVDJTlEJUI0JTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTlEJTgwJTIwJUVDJTlEJUI0JUVCJTlGJUIwJTIwJUVDJUEwJTgwJUVCJTlGJUIwJTIwJUVBJUIyJTgzJUVCJTkzJUE0JUVDJTlEJTg0JTIwJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQSUwQSVFQyU5RCVCNCUyMCVFQiVBQSVBOCVFQiU4RCVCOCVFQyU5RCU4MCUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpJUVDJTk3JTkwJTIwJUVDJTlEJTk4JUVEJTk1JUI0JTIwJUVDJTgzJTlEJUVDJTg0JUIxJUVCJTkwJTk4JUVDJTk3JTg4JUVDJThBJUI1JUVCJThCJTg4JUVCJThCJUE0Lg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">en</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">mit</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">keras</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># MyCoolModel 모델용 모델 카드</span>

<span class="hljs-string">이</span> <span class="hljs-string">모델은</span> <span class="hljs-string">이런</span> <span class="hljs-string">저런</span> <span class="hljs-string">것들을</span> <span class="hljs-string">합니다.</span>

<span class="hljs-string">이</span> <span class="hljs-string">모델은</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw)에</span> <span class="hljs-string">의해</span> <span class="hljs-string">생성되었습니다.</span>`,wrap:!1}}),W=new r({props:{code:"Y2FyZC5kYXRhLmxpYnJhcnlfbmFtZSUyMCUzRCUyMCd0aW1tJyUwQWNhcmQuZGF0YS5sYW5ndWFnZSUyMCUzRCUyMCdmciclMEFjYXJkLmRhdGEubGljZW5zZSUyMCUzRCUyMCdhcGFjaGUtMi4wJyUwQXByaW50KGNhcmQp",highlighted:`card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.library_name</span> = <span class="hljs-string">&#x27;timm&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.language</span> = <span class="hljs-string">&#x27;fr&#x27;</span>
card<span class="hljs-selector-class">.data</span><span class="hljs-selector-class">.license</span> = <span class="hljs-string">&#x27;apache-2.0&#x27;</span>
<span class="hljs-function"><span class="hljs-title">print</span><span class="hljs-params">(card)</span></span>`,wrap:!1}}),H=new r({props:{code:"LS0tJTBBbGFuZ3VhZ2UlM0ElMjBmciUwQWxpY2Vuc2UlM0ElMjBhcGFjaGUtMi4wJTBBbGlicmFyeV9uYW1lJTNBJTIwdGltbSUwQS0tLSUwQSUwQSUyMyUyME15Q29vbE1vZGVsJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTlBJUE5JTIwJUVCJUFBJUE4JUVCJThEJUI4JTIwJUVDJUI5JUI0JUVCJTkzJTlDJTBBJTBBJUVDJTlEJUI0JTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTlEJTgwJTIwJUVDJTlEJUI0JUVCJTlGJUIwJTIwJUVDJUEwJTgwJUVCJTlGJUIwJTIwJUVBJUIyJTgzJUVCJTkzJUE0JUVDJTlEJTg0JTIwJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQSUwQSVFQyU5RCVCNCUyMCVFQiVBQSVBOCVFQiU4RCVCOCVFQyU5RCU4MCUyMCU1QiU0MG5hdGVyYXclNUQoaHR0cHMlM0ElMkYlMkZoZi5jbyUyRm5hdGVyYXcpJUVDJTk3JTkwJTIwJUVDJTlEJTk4JUVEJTk1JUI0JTIwJUVDJTgzJTlEJUVDJTg0JUIxJUVCJTkwJTk4JUVDJTk3JTg4JUVDJThBJUI1JUVCJThCJTg4JUVCJThCJUE0Lg==",highlighted:`<span class="hljs-meta">---</span>
<span class="hljs-attr">language:</span> <span class="hljs-string">fr</span>
<span class="hljs-attr">license:</span> <span class="hljs-string">apache-2.0</span>
<span class="hljs-attr">library_name:</span> <span class="hljs-string">timm</span>
<span class="hljs-meta">---
</span>
<span class="hljs-comment"># MyCoolModel 모델용 모델 카드</span>

<span class="hljs-string">이</span> <span class="hljs-string">모델은</span> <span class="hljs-string">이런</span> <span class="hljs-string">저런</span> <span class="hljs-string">것들을</span> <span class="hljs-string">합니다.</span>

<span class="hljs-string">이</span> <span class="hljs-string">모델은</span> [<span class="hljs-string">@nateraw</span>]<span class="hljs-string">(https://hf.co/nateraw)에</span> <span class="hljs-string">의해</span> <span class="hljs-string">생성되었습니다.</span>`,wrap:!1}}),D=new m({props:{title:"기본 템플릿으로부터",local:"from-the-default-template",headingTag:"h3"}}),q=new r({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEpJTBBY2FyZC5zYXZlKCdteV9tb2RlbF9jYXJkXzIubWQnKSUwQXByaW50KGNhcmQp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)
card.save(<span class="hljs-string">&#x27;my_model_card_2.md&#x27;</span>)
<span class="hljs-built_in">print</span>(card)`,wrap:!1}}),O=new m({props:{title:"모델 카드 공유하기",local:"share-model-cards",headingTag:"h2"}}),ll=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdob2FtaSUyQyUyMGNyZWF0ZV9yZXBvJTBBJTBBdXNlciUyMCUzRCUyMHdob2FtaSgpJTVCJ25hbWUnJTVEJTBBcmVwb19pZCUyMCUzRCUyMGYnJTdCdXNlciU3RCUyRmhmLWh1Yi1tb2RlbGNhcmRzLXByLXRlc3QnJTBBdXJsJTIwJTNEJTIwY3JlYXRlX3JlcG8ocmVwb19pZCUyQyUyMGV4aXN0X29rJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> whoami, create_repo

user = whoami()[<span class="hljs-string">&#x27;name&#x27;</span>]
repo_id = <span class="hljs-string">f&#x27;<span class="hljs-subst">{user}</span>/hf-hub-modelcards-pr-test&#x27;</span>
url = create_repo(repo_id, exist_ok=<span class="hljs-literal">True</span>)`,wrap:!1}}),al=new r({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YShsYW5ndWFnZSUzRCdlbiclMkMlMjBsaWNlbnNlJTNEJ21pdCclMkMlMjBsaWJyYXJ5X25hbWUlM0Qna2VyYXMnKSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdteS1jb29sLW1vZGVsJyUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2Rlc2NyaXB0aW9uJTNEJTIydGhpcyUyMG1vZGVsJTIwZG9lcyUyMHRoaXMlMjBhbmQlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2ZWxvcGVycyUzRCUyMk5hdGUlMjBSYXclMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvJTNEJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWdnaW5nZmFjZV9odWIlMjIlMkMlMEEp",highlighted:`card_data = ModelCardData(language=<span class="hljs-string">&#x27;en&#x27;</span>, license=<span class="hljs-string">&#x27;mit&#x27;</span>, library_name=<span class="hljs-string">&#x27;keras&#x27;</span>)
card = ModelCard.from_template(
    card_data,
    model_id=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    model_description=<span class="hljs-string">&quot;this model does this and that&quot;</span>,
    developers=<span class="hljs-string">&quot;Nate Raw&quot;</span>,
    repo=<span class="hljs-string">&quot;https://github.com/huggingface/huggingface_hub&quot;</span>,
)`,wrap:!1}}),el=new r({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkKQ==",highlighted:"card.push_to_hub(repo_id)",wrap:!1}}),Ml=new r({props:{code:"Y2FyZC5wdXNoX3RvX2h1YihyZXBvX2lkJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:'card.push_to_hub(repo_id, create_pr=<span class="hljs-literal">True</span>)',wrap:!1}}),il=new m({props:{title:"메타데이터 업데이트",local:"update-metadata",headingTag:"h2"}}),hl=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiU3RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;image-classification&quot;</span>})`,wrap:!1}}),dl=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJ1c2VybmFtZSUyRm15LWNvb2wtbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlN0QlMkMlMjBvdmVyd3JpdGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;username/my-cool-model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-generation&quot;</span>}, overwrite=<span class="hljs-literal">True</span>)`,wrap:!1}}),Cl=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhX3VwZGF0ZSglMjJzb21lb25lJTJGbW9kZWwlMjIlMkMlMjAlN0IlMjJwaXBlbGluZV90YWclMjIlM0ElMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTdEJTJDJTIwY3JlYXRlX3ByJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata_update(<span class="hljs-string">&quot;someone/model&quot;</span>, {<span class="hljs-string">&quot;pipeline_tag&quot;</span>: <span class="hljs-string">&quot;text-classification&quot;</span>}, create_pr=<span class="hljs-literal">True</span>)`,wrap:!1}}),yl=new m({props:{title:"평가 결과 포함하기",local:"include-evaluation-results",headingTag:"h2"}}),gl=new r({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjApJTBBKSUwQSUwQWNhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZShjYXJkX2RhdGEpJTBBcHJpbnQoY2FyZC5kYXRhKQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = EvalResult(
        task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
        dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
        dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
        metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
        metric_value=<span class="hljs-number">0.7</span>
    )
)

card = ModelCard.from_template(card_data)
<span class="hljs-built_in">print</span>(card.data)`,wrap:!1}}),ol=new r({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>`,wrap:!1}}),Vl=new r({props:{code:"Y2FyZF9kYXRhJTIwJTNEJTIwTW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCdlbiclMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJ21pdCclMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJ215LWNvb2wtbW9kZWwnJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9yZXN1bHRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdhY2N1cmFjeSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRXZhbFJlc3VsdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QnaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF90eXBlJTNEJ2JlYW5zJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCdCZWFucyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdHlwZSUzRCdmMSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfdmFsdWUlM0QwLjY1JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEFjYXJkJTIwJTNEJTIwTW9kZWxDYXJkLmZyb21fdGVtcGxhdGUoY2FyZF9kYXRhKSUwQWNhcmQuZGF0YQ==",highlighted:`card_data = ModelCardData(
    language=<span class="hljs-string">&#x27;en&#x27;</span>,
    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
    eval_results = [
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
            metric_value=<span class="hljs-number">0.7</span>
        ),
        EvalResult(
            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
            metric_type=<span class="hljs-string">&#x27;f1&#x27;</span>,
            metric_value=<span class="hljs-number">0.65</span>
        )
    ]
)
card = ModelCard.from_template(card_data)
card.data`,wrap:!1}}),Ql=new r({props:{code:"bGFuZ3VhZ2UlM0ElMjBlbiUwQWxpY2Vuc2UlM0ElMjBtaXQlMEFtb2RlbC1pbmRleCUzQSUwQS0lMjBuYW1lJTNBJTIwbXktY29vbC1tb2RlbCUwQSUyMCUyMHJlc3VsdHMlM0ElMEElMjAlMjAtJTIwdGFzayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0ElMjBpbWFnZS1jbGFzc2lmaWNhdGlvbiUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwQmVhbnMlMEElMjAlMjAlMjAlMjAlMjAlMjB0eXBlJTNBJTIwYmVhbnMlMEElMjAlMjAlMjAlMjBtZXRyaWNzJTNBJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBhY2N1cmFjeSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC43JTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjBmMSUwQSUyMCUyMCUyMCUyMCUyMCUyMHZhbHVlJTNBJTIwMC42NQ==",highlighted:`<span class="hljs-attribute">language</span><span class="hljs-punctuation">:</span> <span class="hljs-string">en</span>
<span class="hljs-attribute">license</span><span class="hljs-punctuation">:</span> <span class="hljs-string">mit</span>
<span class="hljs-attribute">model-index</span><span class="hljs-punctuation">:</span>
<span class="hljs-bullet">-</span> <span class="hljs-string">name: my-cool-model</span>
  <span class="hljs-attribute">results</span><span class="hljs-punctuation">:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">task:</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">image-classification</span>
    <span class="hljs-attribute">dataset</span><span class="hljs-punctuation">:</span>
      <span class="hljs-attribute">name</span><span class="hljs-punctuation">:</span> <span class="hljs-string">Beans</span>
      <span class="hljs-attribute">type</span><span class="hljs-punctuation">:</span> <span class="hljs-string">beans</span>
    <span class="hljs-attribute">metrics</span><span class="hljs-punctuation">:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: accuracy</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.7</span>
    <span class="hljs-bullet">-</span> <span class="hljs-string">type: f1</span>
      <span class="hljs-attribute">value</span><span class="hljs-punctuation">:</span> <span class="hljs-string">0.65</span>`,wrap:!1}}),El=new xa({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/guides/model-cards.md"}}),{c(){d=p("meta"),$l=e(),Il=p("p"),Zl=e(),i(u.$$.fragment),Fl=e(),i(g.$$.fragment),Rl=e(),w=p("p"),w.innerHTML=Ls,kl=e(),o=p("blockquote"),o.innerHTML=Ds,xl=e(),i(f.$$.fragment),Nl=e(),V=p("p"),V.innerHTML=zs,Al=e(),i(b.$$.fragment),_l=e(),Q=p("p"),Q.textContent=qs,Xl=e(),E=p("ul"),E.innerHTML=Os,Gl=e(),i(I.$$.fragment),Yl=e(),i(B.$$.fragment),Sl=e(),$=p("p"),$.innerHTML=Ps,Wl=e(),i(Z.$$.fragment),vl=e(),F=p("p"),F.textContent=Ks,Hl=e(),R=p("ul"),R.innerHTML=la,Ll=e(),i(k.$$.fragment),Dl=e(),x=p("p"),x.textContent=sa,zl=e(),i(N.$$.fragment),ql=e(),i(A.$$.fragment),Ol=e(),_=p("p"),_.innerHTML=aa,Pl=e(),i(X.$$.fragment),Kl=e(),G=p("p"),G.textContent=ta,ls=e(),i(Y.$$.fragment),ss=e(),S=p("p"),S.textContent=ea,as=e(),i(W.$$.fragment),ts=e(),v=p("p"),v.textContent=na,es=e(),i(H.$$.fragment),ns=e(),L=p("p"),L.innerHTML=pa,ps=e(),i(D.$$.fragment),Ms=e(),z=p("p"),z.innerHTML=Ma,Js=e(),C=p("blockquote"),C.innerHTML=Ja,is=e(),i(q.$$.fragment),Us=e(),i(O.$$.fragment),cs=e(),P=p("p"),P.innerHTML=ia,js=e(),K=p("p"),K.textContent=Ua,hs=e(),i(ll.$$.fragment),Ts=e(),sl=p("p"),sl.textContent=ca,rs=e(),i(al.$$.fragment),ds=e(),tl=p("p"),tl.textContent=ja,ms=e(),i(el.$$.fragment),Cs=e(),nl=p("p"),nl.innerHTML=ha,ys=e(),pl=p("p"),pl.innerHTML=Ta,us=e(),i(Ml.$$.fragment),gs=e(),Jl=p("p"),Jl.innerHTML=ra,ws=e(),i(il.$$.fragment),os=e(),Ul=p("p"),Ul.textContent=da,fs=e(),cl=p("p"),cl.innerHTML=ma,Vs=e(),jl=p("p"),jl.textContent=Ca,bs=e(),i(hl.$$.fragment),Qs=e(),Tl=p("p"),Tl.innerHTML=ya,Es=e(),rl=p("p"),rl.innerHTML=ua,Is=e(),i(dl.$$.fragment),Bs=e(),ml=p("p"),ml.textContent=ga,$s=e(),i(Cl.$$.fragment),Zs=e(),i(yl.$$.fragment),Fs=e(),ul=p("p"),ul.innerHTML=wa,Rs=e(),y=p("blockquote"),y.innerHTML=oa,ks=e(),i(gl.$$.fragment),xs=e(),wl=p("p"),wl.innerHTML=fa,Ns=e(),i(ol.$$.fragment),As=e(),fl=p("p"),fl.innerHTML=Va,_s=e(),i(Vl.$$.fragment),Xs=e(),bl=p("p"),bl.innerHTML=ba,Gs=e(),i(Ql.$$.fragment),Ys=e(),i(El.$$.fragment),Ss=e(),Bl=p("p"),this.h()},l(l){const s=Fa("svelte-u9bgzb",document.head);d=M(s,"META",{name:!0,content:!0}),s.forEach(a),$l=n(l),Il=M(l,"P",{}),Qa(Il).forEach(a),Zl=n(l),U(u.$$.fragment,l),Fl=n(l),U(g.$$.fragment,l),Rl=n(l),w=M(l,"P",{"data-svelte-h":!0}),J(w)!=="svelte-9gdaew"&&(w.innerHTML=Ls),kl=n(l),o=M(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(o)!=="svelte-19gp9li"&&(o.innerHTML=Ds),xl=n(l),U(f.$$.fragment,l),Nl=n(l),V=M(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-9utbdg"&&(V.innerHTML=zs),Al=n(l),U(b.$$.fragment,l),_l=n(l),Q=M(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-5gwzo7"&&(Q.textContent=qs),Xl=n(l),E=M(l,"UL",{"data-svelte-h":!0}),J(E)!=="svelte-1y2f5lh"&&(E.innerHTML=Os),Gl=n(l),U(I.$$.fragment,l),Yl=n(l),U(B.$$.fragment,l),Sl=n(l),$=M(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-83r2no"&&($.innerHTML=Ps),Wl=n(l),U(Z.$$.fragment,l),vl=n(l),F=M(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1745c3j"&&(F.textContent=Ks),Hl=n(l),R=M(l,"UL",{"data-svelte-h":!0}),J(R)!=="svelte-fyhjjl"&&(R.innerHTML=la),Ll=n(l),U(k.$$.fragment,l),Dl=n(l),x=M(l,"P",{"data-svelte-h":!0}),J(x)!=="svelte-15wt07p"&&(x.textContent=sa),zl=n(l),U(N.$$.fragment,l),ql=n(l),U(A.$$.fragment,l),Ol=n(l),_=M(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-x9tkb1"&&(_.innerHTML=aa),Pl=n(l),U(X.$$.fragment,l),Kl=n(l),G=M(l,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1ugcu2s"&&(G.textContent=ta),ls=n(l),U(Y.$$.fragment,l),ss=n(l),S=M(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-ixoipv"&&(S.textContent=ea),as=n(l),U(W.$$.fragment,l),ts=n(l),v=M(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-qfwuy"&&(v.textContent=na),es=n(l),U(H.$$.fragment,l),ns=n(l),L=M(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-14xukwe"&&(L.innerHTML=pa),ps=n(l),U(D.$$.fragment,l),Ms=n(l),z=M(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1qxax1f"&&(z.innerHTML=Ma),Js=n(l),C=M(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(C)!=="svelte-1itg022"&&(C.innerHTML=Ja),is=n(l),U(q.$$.fragment,l),Us=n(l),U(O.$$.fragment,l),cs=n(l),P=M(l,"P",{"data-svelte-h":!0}),J(P)!=="svelte-3negwr"&&(P.innerHTML=ia),js=n(l),K=M(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1roeou9"&&(K.textContent=Ua),hs=n(l),U(ll.$$.fragment,l),Ts=n(l),sl=M(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1ml6r4v"&&(sl.textContent=ca),rs=n(l),U(al.$$.fragment,l),ds=n(l),tl=M(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-8ym3i3"&&(tl.textContent=ja),ms=n(l),U(el.$$.fragment,l),Cs=n(l),nl=M(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-1a2k2q7"&&(nl.innerHTML=ha),ys=n(l),pl=M(l,"P",{"data-svelte-h":!0}),J(pl)!=="svelte-vv5lj0"&&(pl.innerHTML=Ta),us=n(l),U(Ml.$$.fragment,l),gs=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-1jf4apg"&&(Jl.innerHTML=ra),ws=n(l),U(il.$$.fragment,l),os=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-1ylqaxm"&&(Ul.textContent=da),fs=n(l),cl=M(l,"P",{"data-svelte-h":!0}),J(cl)!=="svelte-17rnqrm"&&(cl.innerHTML=ma),Vs=n(l),jl=M(l,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-1to54tq"&&(jl.textContent=Ca),bs=n(l),U(hl.$$.fragment,l),Qs=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-1ka2wjq"&&(Tl.innerHTML=ya),Es=n(l),rl=M(l,"P",{"data-svelte-h":!0}),J(rl)!=="svelte-1wteaf8"&&(rl.innerHTML=ua),Is=n(l),U(dl.$$.fragment,l),Bs=n(l),ml=M(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-2yibo9"&&(ml.textContent=ga),$s=n(l),U(Cl.$$.fragment,l),Zs=n(l),U(yl.$$.fragment,l),Fs=n(l),ul=M(l,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-9hnnxl"&&(ul.innerHTML=wa),Rs=n(l),y=M(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(y)!=="svelte-a6w4oj"&&(y.innerHTML=oa),ks=n(l),U(gl.$$.fragment,l),xs=n(l),wl=M(l,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-1ajbhlr"&&(wl.innerHTML=fa),Ns=n(l),U(ol.$$.fragment,l),As=n(l),fl=M(l,"P",{"data-svelte-h":!0}),J(fl)!=="svelte-eht1z8"&&(fl.innerHTML=Va),_s=n(l),U(Vl.$$.fragment,l),Xs=n(l),bl=M(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-1x8slhe"&&(bl.innerHTML=ba),Gs=n(l),U(Ql.$$.fragment,l),Ys=n(l),U(El.$$.fragment,l),Ss=n(l),Bl=M(l,"P",{}),Qa(Bl).forEach(a),this.h()},h(){vs(d,"name","hf:doc:metadata"),vs(d,"content",Aa),vs(C,"class","tip"),vs(y,"class","tip")},m(l,s){Ra(document.head,d),t(l,$l,s),t(l,Il,s),t(l,Zl,s),c(u,l,s),t(l,Fl,s),c(g,l,s),t(l,Rl,s),t(l,w,s),t(l,kl,s),t(l,o,s),t(l,xl,s),c(f,l,s),t(l,Nl,s),t(l,V,s),t(l,Al,s),c(b,l,s),t(l,_l,s),t(l,Q,s),t(l,Xl,s),t(l,E,s),t(l,Gl,s),c(I,l,s),t(l,Yl,s),c(B,l,s),t(l,Sl,s),t(l,$,s),t(l,Wl,s),c(Z,l,s),t(l,vl,s),t(l,F,s),t(l,Hl,s),t(l,R,s),t(l,Ll,s),c(k,l,s),t(l,Dl,s),t(l,x,s),t(l,zl,s),c(N,l,s),t(l,ql,s),c(A,l,s),t(l,Ol,s),t(l,_,s),t(l,Pl,s),c(X,l,s),t(l,Kl,s),t(l,G,s),t(l,ls,s),c(Y,l,s),t(l,ss,s),t(l,S,s),t(l,as,s),c(W,l,s),t(l,ts,s),t(l,v,s),t(l,es,s),c(H,l,s),t(l,ns,s),t(l,L,s),t(l,ps,s),c(D,l,s),t(l,Ms,s),t(l,z,s),t(l,Js,s),t(l,C,s),t(l,is,s),c(q,l,s),t(l,Us,s),c(O,l,s),t(l,cs,s),t(l,P,s),t(l,js,s),t(l,K,s),t(l,hs,s),c(ll,l,s),t(l,Ts,s),t(l,sl,s),t(l,rs,s),c(al,l,s),t(l,ds,s),t(l,tl,s),t(l,ms,s),c(el,l,s),t(l,Cs,s),t(l,nl,s),t(l,ys,s),t(l,pl,s),t(l,us,s),c(Ml,l,s),t(l,gs,s),t(l,Jl,s),t(l,ws,s),c(il,l,s),t(l,os,s),t(l,Ul,s),t(l,fs,s),t(l,cl,s),t(l,Vs,s),t(l,jl,s),t(l,bs,s),c(hl,l,s),t(l,Qs,s),t(l,Tl,s),t(l,Es,s),t(l,rl,s),t(l,Is,s),c(dl,l,s),t(l,Bs,s),t(l,ml,s),t(l,$s,s),c(Cl,l,s),t(l,Zs,s),c(yl,l,s),t(l,Fs,s),t(l,ul,s),t(l,Rs,s),t(l,y,s),t(l,ks,s),c(gl,l,s),t(l,xs,s),t(l,wl,s),t(l,Ns,s),c(ol,l,s),t(l,As,s),t(l,fl,s),t(l,_s,s),c(Vl,l,s),t(l,Xs,s),t(l,bl,s),t(l,Gs,s),c(Ql,l,s),t(l,Ys,s),c(El,l,s),t(l,Ss,s),t(l,Bl,s),Ws=!0},p:Ia,i(l){Ws||(j(u.$$.fragment,l),j(g.$$.fragment,l),j(f.$$.fragment,l),j(b.$$.fragment,l),j(I.$$.fragment,l),j(B.$$.fragment,l),j(Z.$$.fragment,l),j(k.$$.fragment,l),j(N.$$.fragment,l),j(A.$$.fragment,l),j(X.$$.fragment,l),j(Y.$$.fragment,l),j(W.$$.fragment,l),j(H.$$.fragment,l),j(D.$$.fragment,l),j(q.$$.fragment,l),j(O.$$.fragment,l),j(ll.$$.fragment,l),j(al.$$.fragment,l),j(el.$$.fragment,l),j(Ml.$$.fragment,l),j(il.$$.fragment,l),j(hl.$$.fragment,l),j(dl.$$.fragment,l),j(Cl.$$.fragment,l),j(yl.$$.fragment,l),j(gl.$$.fragment,l),j(ol.$$.fragment,l),j(Vl.$$.fragment,l),j(Ql.$$.fragment,l),j(El.$$.fragment,l),Ws=!0)},o(l){h(u.$$.fragment,l),h(g.$$.fragment,l),h(f.$$.fragment,l),h(b.$$.fragment,l),h(I.$$.fragment,l),h(B.$$.fragment,l),h(Z.$$.fragment,l),h(k.$$.fragment,l),h(N.$$.fragment,l),h(A.$$.fragment,l),h(X.$$.fragment,l),h(Y.$$.fragment,l),h(W.$$.fragment,l),h(H.$$.fragment,l),h(D.$$.fragment,l),h(q.$$.fragment,l),h(O.$$.fragment,l),h(ll.$$.fragment,l),h(al.$$.fragment,l),h(el.$$.fragment,l),h(Ml.$$.fragment,l),h(il.$$.fragment,l),h(hl.$$.fragment,l),h(dl.$$.fragment,l),h(Cl.$$.fragment,l),h(yl.$$.fragment,l),h(gl.$$.fragment,l),h(ol.$$.fragment,l),h(Vl.$$.fragment,l),h(Ql.$$.fragment,l),h(El.$$.fragment,l),Ws=!1},d(l){l&&(a($l),a(Il),a(Zl),a(Fl),a(Rl),a(w),a(kl),a(o),a(xl),a(Nl),a(V),a(Al),a(_l),a(Q),a(Xl),a(E),a(Gl),a(Yl),a(Sl),a($),a(Wl),a(vl),a(F),a(Hl),a(R),a(Ll),a(Dl),a(x),a(zl),a(ql),a(Ol),a(_),a(Pl),a(Kl),a(G),a(ls),a(ss),a(S),a(as),a(ts),a(v),a(es),a(ns),a(L),a(ps),a(Ms),a(z),a(Js),a(C),a(is),a(Us),a(cs),a(P),a(js),a(K),a(hs),a(Ts),a(sl),a(rs),a(ds),a(tl),a(ms),a(Cs),a(nl),a(ys),a(pl),a(us),a(gs),a(Jl),a(ws),a(os),a(Ul),a(fs),a(cl),a(Vs),a(jl),a(bs),a(Qs),a(Tl),a(Es),a(rl),a(Is),a(Bs),a(ml),a($s),a(Zs),a(Fs),a(ul),a(Rs),a(y),a(ks),a(xs),a(wl),a(Ns),a(As),a(fl),a(_s),a(Xs),a(bl),a(Gs),a(Ys),a(Ss),a(Bl)),a(d),T(u,l),T(g,l),T(f,l),T(b,l),T(I,l),T(B,l),T(Z,l),T(k,l),T(N,l),T(A,l),T(X,l),T(Y,l),T(W,l),T(H,l),T(D,l),T(q,l),T(O,l),T(ll,l),T(al,l),T(el,l),T(Ml,l),T(il,l),T(hl,l),T(dl,l),T(Cl,l),T(yl,l),T(gl,l),T(ol,l),T(Vl,l),T(Ql,l),T(El,l)}}}const Aa='{"title":"모델 카드 생성 및 공유","local":"create-and-share-model-cards","sections":[{"title":"Hub에서 모델 카드 불러오기","local":"load-a-model-card-from-the-hub","sections":[],"depth":2},{"title":"모델 카드 만들기","local":"create-model-cards","sections":[{"title":"텍스트에서 생성","local":"from-text","sections":[],"depth":3},{"title":"Jinja 템플릿으로부터","local":"from-a-jinja-template","sections":[],"depth":3},{"title":"기본 템플릿으로부터","local":"from-the-default-template","sections":[],"depth":3}],"depth":2},{"title":"모델 카드 공유하기","local":"share-model-cards","sections":[],"depth":2},{"title":"메타데이터 업데이트","local":"update-metadata","sections":[],"depth":2},{"title":"평가 결과 포함하기","local":"include-evaluation-results","sections":[],"depth":2}],"depth":1}';function _a(Hs){return Ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends $a{constructor(d){super(),Za(this,d,_a,Na,Ea,{})}}export{Wa as component};
