import{s as qs,n as xs,o as zs}from"../chunks/scheduler.0cf4ef2e.js";import{S as Ds,i as Ls,e as p,s as a,c,h as Ws,a as i,d as t,b as n,f as A,g as U,j as m,k as Os,l as g,m as e,n as o,t as M,o as y,p as r}from"../chunks/index.abc433bf.js";import{C as Ps,H as ws,E as Ks}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f7de33ce.js";import{C as z}from"../chunks/CodeBlock.abc7ded2.js";function sl(Is){let h,W,D,P,d,K,u,ss,f,Fs='<code>huggingface_hub</code> 라이브러리는 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> 외에도 Hugging Face Hub에 대한 파이써닉한 <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> 파일 인터페이스인 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>을 제공합니다. <a href="/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>은 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>을 기반으로 구축되며, <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code> 및 <code>put_file</code>과 같은 일반적인 파일 시스템 스타일 작업을 제공합니다.',ls,T,ts,j,es,Q,Zs="선택적 <code>revision</code> 인수를 전달하여 브랜치, 태그 이름 또는 커밋 해시와 같은 특정 커밋에서 작업을 실행할 수 있습니다.",as,C,_s="파이썬에 내장된 <code>open</code>과 달리 <code>fsspec</code>의 <code>open</code>은 바이너리 모드 <code>&quot;rb&quot;</code>로 기본 설정됩니다. 이것은 텍스트 모드에서 읽기 위해 <code>&quot;r&quot;</code>, 쓰기 위해 <code>&quot;w&quot;</code>로 모드를 명시적으로 설정해야 함을 의미합니다. 파일에 추가하기(모드 <code>&quot;a&quot;</code> 및 <code>&quot;ab&quot;</code>)는 아직 지원되지 않습니다.",ns,w,ps,V,Es='<a href="/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>은 URL이 다음 구문을 따르는 경우 <code>fsspec</code>을 통합하는 모든 라이브러리에서 사용할 수 있습니다.',is,R,ms,k,Gs="여기서 <code>repo_type_prefix</code>는 Datasets의 경우 <code>datasets/</code>, Spaces의 경우 <code>spaces/</code>이며, 모델에는 URL에 접두사가 필요하지 않습니다.",cs,b,$s='<a href="/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>이 Hub와의 상호작용을 단순화하는 몇 가지 흥미로운 통합 사례는 다음과 같습니다:',Us,B,I,O,Ss='Hub 저장소에서 <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame 읽기/쓰기:',Vs,F,os,Z,Xs='동일한 워크플로우를 <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> 및 <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrame에도 사용할 수 있습니다.',Ms,J,_,q,vs='<a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>를 사용하여 (원격) Hub 파일 쿼리:',Rs,E,ks,G,x,Hs='<a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>를 사용하여 Hub를 배열 저장소로 사용:',bs,$,ys,S,rs,X,Ns='대부분의 경우 Hub와 상호작용하려면 Hugging Face 계정에 로그인해야 합니다. Hub에서 인증 방법에 대해 자세히 알아보려면 문서의 <a href="../quick-start#authentication">인증</a> 섹션을 참조하세요.',gs,v,Ys='또한 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>에 <code>token</code>을 인수로 전달하여 프로그래밍 방식으로 로그인할 수 있습니다:',hs,H,Js,N,As="이렇게 로그인하는 경우 소스 코드를 공유할 때 토큰이 실수로 누출되지 않도록 주의해야 합니다!",ds,Y,us,L,fs;return d=new Ps({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new ws({props:{title:"Hugging Face Hub에서 파일 시스템 API를 통해 상호작용하기",local:"interact-with-the-hub-through-the-filesystem-api",headingTag:"h1"}}),T=new ws({props:{title:"사용법",local:"usage",headingTag:"h2"}}),j=new z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjAlRUIlOTQlOTQlRUIlQTAlODklRUQlODQlQjAlRUIlQTYlQUMlRUMlOUQlOTglMjAlRUIlQUElQTglRUIlOTMlQTAlMjAlRUQlOEMlOEMlRUMlOUQlQkMlMjAlRUIlODIlOTglRUMlOTclQjQlRUQlOTUlOTglRUElQjglQjAlMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMCVFQyVBMCU4MCVFQyU5RSVBNSVFQyU4NiU4QyhyZXBvKSVFQyU5NyU5MCVFQyU4NCU5QyUyMCUyMi5jc3YlMjIlMjAlRUQlOEMlOEMlRUMlOUQlQkMlMjAlRUIlQUElQTglRUIlOTElOTAlMjAlRUIlODIlOTglRUMlOTclQjQlRUQlOTUlOTglRUElQjglQjAlMEFmcy5nbG9iKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkYqKi5jc3YlMjIpJTBBJTBBJTIzJTIwJUVDJTlCJTkwJUVBJUIyJUE5JTIwJUVEJThDJThDJUVDJTlEJUJDJTIwJUVDJTlEJUJEJUVBJUI4JUIwJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGElMjAlM0QlMjBmLnJlYWRsaW5lcygpJTBBJTBBJTIzJTIwJUVCJUFDJUI4JUVDJTlFJTkwJUVDJTk3JUI0JUVCJUExJTlDJTIwJUVDJTlCJTkwJUVBJUIyJUE5JTIwJUVEJThDJThDJUVDJTlEJUJDJUVDJTlEJTk4JTIwJUVCJTgyJUI0JUVDJTlBJUE5JTIwJUVDJTlEJUJEJUVBJUI4JUIwJTBBdHJhaW5fZGF0YSUyMCUzRCUyMGZzLnJlYWRfdGV4dCglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnRyYWluLmNzdiUyMiUyQyUyMHJldmlzaW9uJTNEJTIyZGV2JTIyKSUwQSUwQSUyMyUyMCVFQyU5QiU5MCVFQSVCMiVBOSUyMCVFRCU4QyU4QyVFQyU5RCVCQyUyMCVFQyU5MyVCMCVFQSVCOCVCMCUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdmFsaWRhdGlvbi5jc3YlMjIlMkMlMjAlMjJ3JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIydGV4dCUyQ2xhYmVsJTIyKSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIyRmFudGFzdGljJTIwbW92aWUhJTJDZ29vZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 디렉터리의 모든 파일 나열하기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 저장소(repo)에서 &quot;.csv&quot; 파일 모두 나열하기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 원격 파일 읽기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 문자열로 원격 파일의 내용 읽기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 원격 파일 쓰기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),w=new ws({props:{title:"통합",local:"integrations",headingTag:"h2"}}),R=new z({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),F=new z({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMCVFQyU5QiU5MCVFQSVCMiVBOSUyMENTViUyMCVFRCU4QyU4QyVFQyU5RCVCQyVFQyU5RCU4NCUyMCVFQiU4RCVCMCVFQyU5RCVCNCVFRCU4NCVCMCVFRCU5NCU4NCVFQiVBMCU4OCVFQyU5RSU4NCVFQyU5QyVCQyVFQiVBMSU5QyUyMCVFQyU5RCVCRCVFQSVCOCVCMCUwQWRmJTIwJTNEJTIwcGQucmVhZF9jc3YoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGdHJhaW4uY3N2JTIyKSUwQSUwQSUyMyUyMCVFQiU4RCVCMCVFQyU5RCVCNCVFRCU4NCVCMCVFRCU5NCU4NCVFQiVBMCU4OCVFQyU5RSU4NCVFQyU5RCU4NCUyMCVFQyU5QiU5MCVFQSVCMiVBOSUyMENTViUyMCVFRCU4QyU4QyVFQyU5RCVCQyVFQiVBMSU5QyUyMCVFQyU5MyVCMCVFQSVCOCVCMCUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 원격 CSV 파일을 데이터프레임으로 읽기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 데이터프레임을 원격 CSV 파일로 쓰기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),E=new z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjAlRUMlOUIlOTAlRUElQjIlQTklMjAlRUQlOEMlOEMlRUMlOUQlQkMlRUMlOUQlODQlMjAlRUMlQkYlQkMlRUIlQTYlQUMlRUQlOTUlOTglRUElQjMlQTAlMjAlRUElQjIlQjAlRUElQjMlQkMlRUIlQTUlQkMlMjAlRUIlOEQlQjAlRUMlOUQlQjQlRUQlODQlQjAlRUQlOTQlODQlRUIlQTAlODglRUMlOUUlODQlRUMlOUMlQkMlRUIlQTElOUMlMjAlRUElQjAlODAlRUMlQTAlQjglRUMlOTglQTQlRUElQjglQjAlMEFmc19xdWVyeV9maWxlJTIwJTNEJTIwJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YV9kaXIlMkZkYXRhLnBhcnF1ZXQlMjIlMEFkZiUyMCUzRCUyMGR1Y2tkYi5xdWVyeShmJTIyU0VMRUNUJTIwKiUyMEZST00lMjAnJTdCZnNfcXVlcnlfZmlsZSU3RCclMjBMSU1JVCUyMDEwJTIyKS5kZigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 원격 파일을 쿼리하고 결과를 데이터프레임으로 가져오기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),$=new z({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjAlRUMlQTAlODAlRUMlOUUlQTUlRUMlODYlOEMocmVwbyklRUMlOTclOTAlMjAlRUIlQjAlQjAlRUMlOTclQjQlMjAlRUMlOTMlQjAlRUElQjglQjAlMEF3aXRoJTIwemFyci5vcGVuX2dyb3VwKCUyMmhmJTNBJTJGJTJGbXktdXNlcm5hbWUlMkZteS1tb2RlbC1yZXBvJTJGYXJyYXktc3RvcmUlMjIlMkMlMjBtb2RlJTNEJTIydyUyMiklMjBhcyUyMHJvb3QlM0ElMEElMjAlMjAlMjBmb28lMjAlM0QlMjByb290LmNyZWF0ZV9ncm91cCglMjJlbWJlZGRpbmdzJTIyKSUwQSUyMCUyMCUyMGZvb2JhciUyMCUzRCUyMGZvby56ZXJvcygnZXhwZXJpbWVudF8wJyUyQyUyMHNoYXBlJTNEKDUwMDAwJTJDJTIwMTAwMCklMkMlMjBjaHVua3MlM0QoMTAwMDAlMkMlMjAxMDAwKSUyQyUyMGR0eXBlJTNEJ2Y0JyklMEElMjAlMjAlMjBmb29iYXIlNUIlM0ElNUQlMjAlM0QlMjBlbWJlZGRpbmdzJTBBJTBBJTIzJTIwJUVDJUEwJTgwJUVDJTlFJUE1JUVDJTg2JThDKHJlcG8pJUVDJTk3JTkwJUVDJTg0JTlDJTIwJUVCJUIwJUIwJUVDJTk3JUI0JTIwJUVDJTlEJUJEJUVBJUI4JUIwJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 저장소(repo)에 배열 쓰기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 저장소(repo)에서 배열 읽기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),S=new ws({props:{title:"인증",local:"authentication",headingTag:"h2"}}),H=new z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),Y=new Ks({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/guides/hf_file_system.md"}}),{c(){h=p("meta"),W=a(),D=p("p"),P=a(),c(d.$$.fragment),K=a(),c(u.$$.fragment),ss=a(),f=p("p"),f.innerHTML=Fs,ls=a(),c(T.$$.fragment),ts=a(),c(j.$$.fragment),es=a(),Q=p("p"),Q.innerHTML=Zs,as=a(),C=p("p"),C.innerHTML=_s,ns=a(),c(w.$$.fragment),ps=a(),V=p("p"),V.innerHTML=Es,is=a(),c(R.$$.fragment),ms=a(),k=p("p"),k.innerHTML=Gs,cs=a(),b=p("p"),b.innerHTML=$s,Us=a(),B=p("ul"),I=p("li"),O=p("p"),O.innerHTML=Ss,Vs=a(),c(F.$$.fragment),os=a(),Z=p("p"),Z.innerHTML=Xs,Ms=a(),J=p("ul"),_=p("li"),q=p("p"),q.innerHTML=vs,Rs=a(),c(E.$$.fragment),ks=a(),G=p("li"),x=p("p"),x.innerHTML=Hs,bs=a(),c($.$$.fragment),ys=a(),c(S.$$.fragment),rs=a(),X=p("p"),X.innerHTML=Ns,gs=a(),v=p("p"),v.innerHTML=Ys,hs=a(),c(H.$$.fragment),Js=a(),N=p("p"),N.textContent=As,ds=a(),c(Y.$$.fragment),us=a(),L=p("p"),this.h()},l(s){const l=Ws("svelte-u9bgzb",document.head);h=i(l,"META",{name:!0,content:!0}),l.forEach(t),W=n(s),D=i(s,"P",{}),A(D).forEach(t),P=n(s),U(d.$$.fragment,s),K=n(s),U(u.$$.fragment,s),ss=n(s),f=i(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-pii8ry"&&(f.innerHTML=Fs),ls=n(s),U(T.$$.fragment,s),ts=n(s),U(j.$$.fragment,s),es=n(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-zykbtb"&&(Q.innerHTML=Zs),as=n(s),C=i(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1xn3eh"&&(C.innerHTML=_s),ns=n(s),U(w.$$.fragment,s),ps=n(s),V=i(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1luew8i"&&(V.innerHTML=Es),is=n(s),U(R.$$.fragment,s),ms=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1re6aja"&&(k.innerHTML=Gs),cs=n(s),b=i(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1b272al"&&(b.innerHTML=$s),Us=n(s),B=i(s,"UL",{});var Bs=A(B);I=i(Bs,"LI",{});var Ts=A(I);O=i(Ts,"P",{"data-svelte-h":!0}),m(O)!=="svelte-g8f620"&&(O.innerHTML=Ss),Vs=n(Ts),U(F.$$.fragment,Ts),Ts.forEach(t),Bs.forEach(t),os=n(s),Z=i(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-z2k9op"&&(Z.innerHTML=Xs),Ms=n(s),J=i(s,"UL",{});var js=A(J);_=i(js,"LI",{});var Qs=A(_);q=i(Qs,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1273hrm"&&(q.innerHTML=vs),Rs=n(Qs),U(E.$$.fragment,Qs),Qs.forEach(t),ks=n(js),G=i(js,"LI",{});var Cs=A(G);x=i(Cs,"P",{"data-svelte-h":!0}),m(x)!=="svelte-vh1ech"&&(x.innerHTML=Hs),bs=n(Cs),U($.$$.fragment,Cs),Cs.forEach(t),js.forEach(t),ys=n(s),U(S.$$.fragment,s),rs=n(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1jjcoki"&&(X.innerHTML=Ns),gs=n(s),v=i(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1u7kq91"&&(v.innerHTML=Ys),hs=n(s),U(H.$$.fragment,s),Js=n(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1jdbq9m"&&(N.textContent=As),ds=n(s),U(Y.$$.fragment,s),us=n(s),L=i(s,"P",{}),A(L).forEach(t),this.h()},h(){Os(h,"name","hf:doc:metadata"),Os(h,"content",ll)},m(s,l){g(document.head,h),e(s,W,l),e(s,D,l),e(s,P,l),o(d,s,l),e(s,K,l),o(u,s,l),e(s,ss,l),e(s,f,l),e(s,ls,l),o(T,s,l),e(s,ts,l),o(j,s,l),e(s,es,l),e(s,Q,l),e(s,as,l),e(s,C,l),e(s,ns,l),o(w,s,l),e(s,ps,l),e(s,V,l),e(s,is,l),o(R,s,l),e(s,ms,l),e(s,k,l),e(s,cs,l),e(s,b,l),e(s,Us,l),e(s,B,l),g(B,I),g(I,O),g(I,Vs),o(F,I,null),e(s,os,l),e(s,Z,l),e(s,Ms,l),e(s,J,l),g(J,_),g(_,q),g(_,Rs),o(E,_,null),g(J,ks),g(J,G),g(G,x),g(G,bs),o($,G,null),e(s,ys,l),o(S,s,l),e(s,rs,l),e(s,X,l),e(s,gs,l),e(s,v,l),e(s,hs,l),o(H,s,l),e(s,Js,l),e(s,N,l),e(s,ds,l),o(Y,s,l),e(s,us,l),e(s,L,l),fs=!0},p:xs,i(s){fs||(M(d.$$.fragment,s),M(u.$$.fragment,s),M(T.$$.fragment,s),M(j.$$.fragment,s),M(w.$$.fragment,s),M(R.$$.fragment,s),M(F.$$.fragment,s),M(E.$$.fragment,s),M($.$$.fragment,s),M(S.$$.fragment,s),M(H.$$.fragment,s),M(Y.$$.fragment,s),fs=!0)},o(s){y(d.$$.fragment,s),y(u.$$.fragment,s),y(T.$$.fragment,s),y(j.$$.fragment,s),y(w.$$.fragment,s),y(R.$$.fragment,s),y(F.$$.fragment,s),y(E.$$.fragment,s),y($.$$.fragment,s),y(S.$$.fragment,s),y(H.$$.fragment,s),y(Y.$$.fragment,s),fs=!1},d(s){s&&(t(W),t(D),t(P),t(K),t(ss),t(f),t(ls),t(ts),t(es),t(Q),t(as),t(C),t(ns),t(ps),t(V),t(is),t(ms),t(k),t(cs),t(b),t(Us),t(B),t(os),t(Z),t(Ms),t(J),t(ys),t(rs),t(X),t(gs),t(v),t(hs),t(Js),t(N),t(ds),t(us),t(L)),t(h),r(d,s),r(u,s),r(T,s),r(j,s),r(w,s),r(R,s),r(F),r(E),r($),r(S,s),r(H,s),r(Y,s)}}}const ll='{"title":"Hugging Face Hub에서 파일 시스템 API를 통해 상호작용하기","local":"interact-with-the-hub-through-the-filesystem-api","sections":[{"title":"사용법","local":"usage","sections":[],"depth":2},{"title":"통합","local":"integrations","sections":[],"depth":2},{"title":"인증","local":"authentication","sections":[],"depth":2}],"depth":1}';function tl(Is){return zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Ds{constructor(h){super(),Ls(this,h,tl,sl,qs,{})}}export{il as component};
