import{s as ns,n as ss,o as as}from"../chunks/scheduler.0cf4ef2e.js";import{S as ts,i as ls,e as p,s as t,c as g,h as ps,a as i,d as s,b as l,f as es,g as r,j as c,k as _e,l as is,m as a,n as o,t as h,o as u,p as f}from"../chunks/index.abc433bf.js";import{C as cs,H as d,E as gs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f7de33ce.js";import{C as m}from"../chunks/CodeBlock.abc7ded2.js";function rs(wn){let j,be,Me,Ue,b,xe,U,$e,x,Tn=`추론 엔드포인트는 Hugging Face가 관리하는 전용 및 자동 확장 인프라에 <code>transformers</code>, <code>sentence-transformers</code> 및 <code>diffusers</code> 모델을 쉽게 배포할 수 있는 안전한 프로덕션 솔루션을 제공합니다. 추론 엔드포인트는 <a href="https://huggingface.co/models" rel="nofollow">Hub</a>의 모델로 구축됩니다.
이 가이드에서는 <code>huggingface_hub</code>를 사용하여 프로그래밍 방식으로 추론 엔드포인트를 관리하는 방법을 배웁니다. 추론 엔드포인트 제품 자체에 대한 자세한 내용은 <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">공식 문서</a>를 참조하세요.`,we,$,kn='이 가이드에서는 <code>huggingface_hub</code>가 올바르게 설치 및 로그인되어 있다고 가정합니다. 아직 그렇지 않은 경우 <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">빠른 시작 가이드</a>를 참조하세요. 추론 엔드포인트 API를 지원하는 최소 버전은 <code>v0.19.0</code>입니다.',Te,w,ke,T,Cn='첫 번째 단계는 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>를 사용하여 추론 엔드포인트를 생성하는 것입니다:',Ce,k,Ie,C,In='예시에서는 <code>&quot;my-endpoint-name&quot;</code>라는 <code>protected</code> 추론 엔드포인트를 생성하여 <code>text-generation</code>을 위한 <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a>를 제공합니다. <code>protected</code> 추론 엔드포인트 API에 액세스하려면 토큰이 필요합니다. 또한 벤더, 지역, 액셀러레이터, 인스턴스 유형, 크기와 같은 하드웨어 요구 사항을 구성하기 위한 추가 정보를 제공해야 합니다. 사용 가능한 리소스 목록은 <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">여기</a>에서 확인할 수 있습니다. 또한 <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">웹 인터페이스</a>를 사용하여 편리하게 수동으로 추론 엔드포인트를 생성할 수 있습니다. 고급 설정 및 사용법에 대한 자세한 내용은 <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">이 가이드</a>를 참조하세요.',Je,I,Jn='<a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>에서 반환된 값은 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> 개체입니다:',Ee,J,Ze,E,En="이것은 엔드포인트에 대한 정보를 저장하는 데이터클래스입니다. <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code> 등과 같은 중요한 속성에 접근할 수 있습니다. 필요한 경우 <code>endpoint.raw</code>를 통해 서버로부터의 원시 응답에도 접근할 수 있습니다.",We,Z,Zn='추론 엔드포인트가 생성되면 <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">개인 대시보드</a>에서 확인할 수 있습니다.',qe,W,Wn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',ve,q,He,v,qn='기본적으로 추론 엔드포인트는 Hugging Face에서 제공하는 도커 이미지로 구축됩니다. 그러나 <code>custom_image</code> 매개변수를 사용하여 모든 도커 이미지를 지정할 수 있습니다. 일반적인 사용 사례는 <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> 프레임워크를 사용하여 LLM을 실행하는 것입니다. 다음과 같이 수행할 수 있습니다:',Qe,H,Ae,Q,vn='<code>custom_image</code>에 전달할 값은 도커 컨테이너의 URL과 이를 실행하기 위한 구성이 포함된 딕셔너리입니다. 자세한 내용은 <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aendpoint/create_endpoint" rel="nofollow">Swagger 문서</a>를 참조하세요.',Be,A,Le,B,Hn='경우에 따라 이전에 생성한 추론 엔드포인트를 관리해야 할 수 있습니다. 이름을 알고 있는 경우 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>를 사용하여 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> 개체를 가져올 수 있습니다. 또는 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a>를 사용하여 모든 추론 엔드포인트 리스트를 검색할 수 있습니다. 두 메소드 모두 선택적 <code>namespace</code> 매개변수를 허용합니다. 속해 있는 조직의 <code>namespace</code>를 설정할 수 있습니다. 그렇지 않으면 기본적으로 사용자 이름이 사용됩니다.',Ve,L,Xe,V,Ge,X,Qn='이 가이드의 나머지 부분에서는 <code>endpoint</code>라는 이름의 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> 객체를 가지고 있다고 가정합니다. 엔드포인트에 <code>status</code> 속성이 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a> 유형이라는 것을 알 수 있었습니다. 추론 엔드포인트가 배포되고 접근 가능하면 상태가 <code>&quot;running&quot;</code>이 되고 <code>url</code> 속성이 설정됩니다:',Ne,G,Ye,N,An='<code>추론 엔드포인트가 &quot;running&quot;</code> 상태에 도달하기 전에 일반적으로 <code>&quot;initializing&quot;</code> 또는 <code>&quot;pending&quot;</code> 단계를 거칩니다. <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>를 실행하여 엔드포인트의 새로운 상태를 가져올 수 있습니다. <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>의 다른 메소드와 마찬가지로 이 메소드는 서버에 요청을 하며, <code>endpoint</code>의 내부 속성이 변경됩니다:',Re,Y,Se,R,Bn='추론 엔드포인트가 실행될 때까지 기다리면서 상태를 가져오는 대신 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>를 직접 호출할 수 있습니다. 이 헬퍼는 <code>timeout</code>과 <code>fetch_every</code> 매개변수를 입력으로 받아 (초 단위) 추론 엔드포인트가 배포될 때까지 스레드를 차단합니다. 기본값은 각각 <code>None</code>(제한 시간 없음)과 <code>5</code>초입니다.',ze,S,Fe,z,Ln="<code>timeout</code>이 설정되어 있고 추론 엔드포인트를 불러오는 데 너무 오래 걸리면, <code>InferenceEndpointTimeoutError</code> 제한 시간 초과 오류가 발생합니다.",Pe,F,Ke,P,Vn="추론 엔드포인트가 실행되면, 마침내 추론을 실행할 수 있습니다!",De,K,Xn='<a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>에는 각각 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>와 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>를 반환하는 <code>client</code>와 <code>async_client</code> 속성이 있습니다.',Oe,D,en,O,Gn='추론 엔드포인트가 실행 중이 아니면 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> 오류가 발생합니다:',nn,ee,sn,ne,Nn='<a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>를 사용하는 방법에 대한 자세한 내용은 <a href="../guides/inference">추론 가이드</a>를 참조하세요.',an,se,tn,ae,Yn="이제 추론 엔드포인트를 생성하고 추론을 실행하는 방법을 살펴보았으니, 라이프사이클을 관리하는 방법을 살펴봅시다.",ln,M,Rn='<p>이 섹션에서는 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> 및 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a> 등의 메소드를 살펴볼 것입니다. 모든 메소드는 편의를 위해 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>에 추가된 별칭입니다. 원한다면 <code>HfApi</code>에 정의된 일반 메소드 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a> 및 <a href="/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>를 사용할 수도 있습니다.</p>',pn,te,cn,le,Sn='추론 엔드포인트를 사용하지 않을 때 비용을 절감하기 위해 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>를 사용하여 일시 중지하거나 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>를 사용하여 0으로 스케일링할 수 있습니다.',gn,y,zn='<p><em>일시 중지</em> 또는 <em>0으로 스케일링</em>된 추론 엔드포인트는 비용이 들지 않습니다. 이 두 가지의 차이점은 <em>일시 중지</em> 엔드포인트는 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>를 사용하여 명시적으로 <em>재개</em>해야 한다는 것입니다. 반대로 <em>0으로 스케일링</em>된 엔드포인트는 추론 호출이 있으면 추가 콜드 스타트 지연과 함께 자동으로 시작됩니다. 추론 엔드포인트는 일정 기간 비활성화된 후 자동으로 0으로 스케일링되도록 구성할 수도 있습니다.</p>',rn,pe,on,ie,hn,ce,Fn='경우에 따라 새로운 엔드포인트를 생성하지 않고 추론 엔드포인트를 업데이트하고 싶을 수 있습니다. 호스팅된 모델이나 모델 실행에 필요한 하드웨어 요구 사항을 업데이트할 수 있습니다. 이렇게 하려면 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>를 사용합니다:',un,ge,fn,re,mn,oe,Pn="마지막으로 더 이상 추론 엔드포인트를 사용하지 않을 경우, <code>~InferenceEndpoint.delete()</code>를 호출하기만 하면 됩니다.",dn,_,Kn="<p>이것은 돌이킬 수 없는 작업이며, 구성, 로그 및 사용 메트릭을 포함한 엔드포인트를 완전히 제거합니다. 삭제된 추론 엔드포인트는 복원할 수 없습니다.</p>",jn,he,Mn,ue,Dn="추론 엔드포인트의 일반적인 사용 사례는 한 번에 여러 개의 작업을 처리하여 인프라 비용을 제한하는 것입니다. 이 가이드에서 본 것을 사용하여 이 프로세스를 자동화할 수 있습니다:",yn,fe,_n,me,On="또는 추론 엔드포인트가 이미 존재하고 일시 중지된 경우:",bn,de,Un,je,xn,ye,$n;return b=new cs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new d({props:{title:"추론 엔드포인트",local:"inference-endpoints",headingTag:"h1"}}),w=new d({props:{title:"추론 엔드포인트 생성",local:"create-an-inference-endpoint",headingTag:"h2"}}),k=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),J=new m({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),q=new d({props:{title:"사용자 정의 이미지 사용",local:"using-a-custom-image",headingTag:"h4"}}),H=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># TGI에서 Zephyr-7b-beta를 실행하는 추론 엔드포인트 시작하기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)`,wrap:!1}}),A=new d({props:{title:"기존 추론 엔드포인트 가져오기 또는 리스트 조회",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),L=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># 엔드포인트 개체 가져오기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 조직의 모든 추론 엔드포인트 나열</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># 사용자가 속해있는 모든 조직의 엔드포인트 나열</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),V=new d({props:{title:"배포 상태 확인",local:"check-deployment-status",headingTag:"h2"}}),G=new m({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),Y=new m({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),S=new m({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># 엔드포인트 보류</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 10초 대기 =&gt; InferenceEndpointTimeoutError 발생</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># 추가 대기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),F=new d({props:{title:"추론 실행",local:"run-inference",headingTag:"h2"}}),D=new m({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># 텍스트 생성 작업 실행:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># 비동기 컨텍스트에서도 마찬가지로 실행:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),ee=new m({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),se=new d({props:{title:"라이프사이클 관리",local:"manage-lifecycle",headingTag:"h2"}}),te=new d({props:{title:"일시 중지 또는 0으로 확장",local:"pause-or-scale-to-zero",headingTag:"h3"}}),pe=new m({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># 엔드포인트 일시중지 및 재시작</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># 0으로 스케일링</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># 엔드포인트는 &#x27;running&#x27;은 아니지만 URL�을 가지고 있으며 첫 번째 호출 시 다시 시작됩니다.</span>`,wrap:!1}}),ie=new d({props:{title:"모델 또는 하드웨어 요구 사항 업데이트",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),ge=new m({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMng0JTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMik=",highlighted:`<span class="hljs-comment"># 타겟 모델 변경</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 복제본 갯수 업데이트</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># 더 큰 인스턴스로 업데이트</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;x4&quot;</span>, instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),re=new d({props:{title:"엔드포인트 삭제",local:"delete-the-endpoint",headingTag:"h3"}}),he=new d({props:{title:"엔드 투 엔드 예제 an-end-to-end-example",local:"엔드-투-엔드-예제-an-end-to-end-example",headingTag:"h2"}}),fe=new m({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># 엔드포인트 시작 + 초기화될 때까지 대기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># 추론 실행</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># 비동기 추론 실행</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># 엔드포인트 중지</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),de=new m({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># 엔드포인트 가져오기 + 초기화될 때까지 대기</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># 추론 실행</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># 엔드포인트 중지</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),je=new gs({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/guides/inference_endpoints.md"}}),{c(){j=p("meta"),be=t(),Me=p("p"),Ue=t(),g(b.$$.fragment),xe=t(),g(U.$$.fragment),$e=t(),x=p("p"),x.innerHTML=Tn,we=t(),$=p("p"),$.innerHTML=kn,Te=t(),g(w.$$.fragment),ke=t(),T=p("p"),T.innerHTML=Cn,Ce=t(),g(k.$$.fragment),Ie=t(),C=p("p"),C.innerHTML=In,Je=t(),I=p("p"),I.innerHTML=Jn,Ee=t(),g(J.$$.fragment),Ze=t(),E=p("p"),E.innerHTML=En,We=t(),Z=p("p"),Z.innerHTML=Zn,qe=t(),W=p("p"),W.innerHTML=Wn,ve=t(),g(q.$$.fragment),He=t(),v=p("p"),v.innerHTML=qn,Qe=t(),g(H.$$.fragment),Ae=t(),Q=p("p"),Q.innerHTML=vn,Be=t(),g(A.$$.fragment),Le=t(),B=p("p"),B.innerHTML=Hn,Ve=t(),g(L.$$.fragment),Xe=t(),g(V.$$.fragment),Ge=t(),X=p("p"),X.innerHTML=Qn,Ne=t(),g(G.$$.fragment),Ye=t(),N=p("p"),N.innerHTML=An,Re=t(),g(Y.$$.fragment),Se=t(),R=p("p"),R.innerHTML=Bn,ze=t(),g(S.$$.fragment),Fe=t(),z=p("p"),z.innerHTML=Ln,Pe=t(),g(F.$$.fragment),Ke=t(),P=p("p"),P.textContent=Vn,De=t(),K=p("p"),K.innerHTML=Xn,Oe=t(),g(D.$$.fragment),en=t(),O=p("p"),O.innerHTML=Gn,nn=t(),g(ee.$$.fragment),sn=t(),ne=p("p"),ne.innerHTML=Nn,an=t(),g(se.$$.fragment),tn=t(),ae=p("p"),ae.textContent=Yn,ln=t(),M=p("blockquote"),M.innerHTML=Rn,pn=t(),g(te.$$.fragment),cn=t(),le=p("p"),le.innerHTML=Sn,gn=t(),y=p("blockquote"),y.innerHTML=zn,rn=t(),g(pe.$$.fragment),on=t(),g(ie.$$.fragment),hn=t(),ce=p("p"),ce.innerHTML=Fn,un=t(),g(ge.$$.fragment),fn=t(),g(re.$$.fragment),mn=t(),oe=p("p"),oe.innerHTML=Pn,dn=t(),_=p("blockquote"),_.innerHTML=Kn,jn=t(),g(he.$$.fragment),Mn=t(),ue=p("p"),ue.textContent=Dn,yn=t(),g(fe.$$.fragment),_n=t(),me=p("p"),me.textContent=On,bn=t(),g(de.$$.fragment),Un=t(),g(je.$$.fragment),xn=t(),ye=p("p"),this.h()},l(e){const n=ps("svelte-u9bgzb",document.head);j=i(n,"META",{name:!0,content:!0}),n.forEach(s),be=l(e),Me=i(e,"P",{}),es(Me).forEach(s),Ue=l(e),r(b.$$.fragment,e),xe=l(e),r(U.$$.fragment,e),$e=l(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-ah66md"&&(x.innerHTML=Tn),we=l(e),$=i(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1ql8zue"&&($.innerHTML=kn),Te=l(e),r(w.$$.fragment,e),ke=l(e),T=i(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-pg39oe"&&(T.innerHTML=Cn),Ce=l(e),r(k.$$.fragment,e),Ie=l(e),C=i(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1aqjns7"&&(C.innerHTML=In),Je=l(e),I=i(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-ency85"&&(I.innerHTML=Jn),Ee=l(e),r(J.$$.fragment,e),Ze=l(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-qy7mei"&&(E.innerHTML=En),We=l(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-q97gnz"&&(Z.innerHTML=Zn),qe=l(e),W=i(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1tajtyl"&&(W.innerHTML=Wn),ve=l(e),r(q.$$.fragment,e),He=l(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-52wlj1"&&(v.innerHTML=qn),Qe=l(e),r(H.$$.fragment,e),Ae=l(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-kvtuxg"&&(Q.innerHTML=vn),Be=l(e),r(A.$$.fragment,e),Le=l(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1jnz33l"&&(B.innerHTML=Hn),Ve=l(e),r(L.$$.fragment,e),Xe=l(e),r(V.$$.fragment,e),Ge=l(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-oxbzmc"&&(X.innerHTML=Qn),Ne=l(e),r(G.$$.fragment,e),Ye=l(e),N=i(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-epjlbw"&&(N.innerHTML=An),Re=l(e),r(Y.$$.fragment,e),Se=l(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-2hymbx"&&(R.innerHTML=Bn),ze=l(e),r(S.$$.fragment,e),Fe=l(e),z=i(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1su15dj"&&(z.innerHTML=Ln),Pe=l(e),r(F.$$.fragment,e),Ke=l(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-mbyh0u"&&(P.textContent=Vn),De=l(e),K=i(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-s186xe"&&(K.innerHTML=Xn),Oe=l(e),r(D.$$.fragment,e),en=l(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1h8mo84"&&(O.innerHTML=Gn),nn=l(e),r(ee.$$.fragment,e),sn=l(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1hx2b0s"&&(ne.innerHTML=Nn),an=l(e),r(se.$$.fragment,e),tn=l(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-d4vepm"&&(ae.textContent=Yn),ln=l(e),M=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-8zt5sg"&&(M.innerHTML=Rn),pn=l(e),r(te.$$.fragment,e),cn=l(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1hd00xr"&&(le.innerHTML=Sn),gn=l(e),y=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(y)!=="svelte-19y94d6"&&(y.innerHTML=zn),rn=l(e),r(pe.$$.fragment,e),on=l(e),r(ie.$$.fragment,e),hn=l(e),ce=i(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-dzaol2"&&(ce.innerHTML=Fn),un=l(e),r(ge.$$.fragment,e),fn=l(e),r(re.$$.fragment,e),mn=l(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-16aox72"&&(oe.innerHTML=Pn),dn=l(e),_=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-1i16qbl"&&(_.innerHTML=Kn),jn=l(e),r(he.$$.fragment,e),Mn=l(e),ue=i(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-4lg1fr"&&(ue.textContent=Dn),yn=l(e),r(fe.$$.fragment,e),_n=l(e),me=i(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-5upsam"&&(me.textContent=On),bn=l(e),r(de.$$.fragment,e),Un=l(e),r(je.$$.fragment,e),xn=l(e),ye=i(e,"P",{}),es(ye).forEach(s),this.h()},h(){_e(j,"name","hf:doc:metadata"),_e(j,"content",os),_e(M,"class","tip"),_e(y,"class","tip"),_e(_,"class","warning")},m(e,n){is(document.head,j),a(e,be,n),a(e,Me,n),a(e,Ue,n),o(b,e,n),a(e,xe,n),o(U,e,n),a(e,$e,n),a(e,x,n),a(e,we,n),a(e,$,n),a(e,Te,n),o(w,e,n),a(e,ke,n),a(e,T,n),a(e,Ce,n),o(k,e,n),a(e,Ie,n),a(e,C,n),a(e,Je,n),a(e,I,n),a(e,Ee,n),o(J,e,n),a(e,Ze,n),a(e,E,n),a(e,We,n),a(e,Z,n),a(e,qe,n),a(e,W,n),a(e,ve,n),o(q,e,n),a(e,He,n),a(e,v,n),a(e,Qe,n),o(H,e,n),a(e,Ae,n),a(e,Q,n),a(e,Be,n),o(A,e,n),a(e,Le,n),a(e,B,n),a(e,Ve,n),o(L,e,n),a(e,Xe,n),o(V,e,n),a(e,Ge,n),a(e,X,n),a(e,Ne,n),o(G,e,n),a(e,Ye,n),a(e,N,n),a(e,Re,n),o(Y,e,n),a(e,Se,n),a(e,R,n),a(e,ze,n),o(S,e,n),a(e,Fe,n),a(e,z,n),a(e,Pe,n),o(F,e,n),a(e,Ke,n),a(e,P,n),a(e,De,n),a(e,K,n),a(e,Oe,n),o(D,e,n),a(e,en,n),a(e,O,n),a(e,nn,n),o(ee,e,n),a(e,sn,n),a(e,ne,n),a(e,an,n),o(se,e,n),a(e,tn,n),a(e,ae,n),a(e,ln,n),a(e,M,n),a(e,pn,n),o(te,e,n),a(e,cn,n),a(e,le,n),a(e,gn,n),a(e,y,n),a(e,rn,n),o(pe,e,n),a(e,on,n),o(ie,e,n),a(e,hn,n),a(e,ce,n),a(e,un,n),o(ge,e,n),a(e,fn,n),o(re,e,n),a(e,mn,n),a(e,oe,n),a(e,dn,n),a(e,_,n),a(e,jn,n),o(he,e,n),a(e,Mn,n),a(e,ue,n),a(e,yn,n),o(fe,e,n),a(e,_n,n),a(e,me,n),a(e,bn,n),o(de,e,n),a(e,Un,n),o(je,e,n),a(e,xn,n),a(e,ye,n),$n=!0},p:ss,i(e){$n||(h(b.$$.fragment,e),h(U.$$.fragment,e),h(w.$$.fragment,e),h(k.$$.fragment,e),h(J.$$.fragment,e),h(q.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(L.$$.fragment,e),h(V.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(te.$$.fragment,e),h(pe.$$.fragment,e),h(ie.$$.fragment,e),h(ge.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(de.$$.fragment,e),h(je.$$.fragment,e),$n=!0)},o(e){u(b.$$.fragment,e),u(U.$$.fragment,e),u(w.$$.fragment,e),u(k.$$.fragment,e),u(J.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(A.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(te.$$.fragment,e),u(pe.$$.fragment,e),u(ie.$$.fragment,e),u(ge.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(de.$$.fragment,e),u(je.$$.fragment,e),$n=!1},d(e){e&&(s(be),s(Me),s(Ue),s(xe),s($e),s(x),s(we),s($),s(Te),s(ke),s(T),s(Ce),s(Ie),s(C),s(Je),s(I),s(Ee),s(Ze),s(E),s(We),s(Z),s(qe),s(W),s(ve),s(He),s(v),s(Qe),s(Ae),s(Q),s(Be),s(Le),s(B),s(Ve),s(Xe),s(Ge),s(X),s(Ne),s(Ye),s(N),s(Re),s(Se),s(R),s(ze),s(Fe),s(z),s(Pe),s(Ke),s(P),s(De),s(K),s(Oe),s(en),s(O),s(nn),s(sn),s(ne),s(an),s(tn),s(ae),s(ln),s(M),s(pn),s(cn),s(le),s(gn),s(y),s(rn),s(on),s(hn),s(ce),s(un),s(fn),s(mn),s(oe),s(dn),s(_),s(jn),s(Mn),s(ue),s(yn),s(_n),s(me),s(bn),s(Un),s(xn),s(ye)),s(j),f(b,e),f(U,e),f(w,e),f(k,e),f(J,e),f(q,e),f(H,e),f(A,e),f(L,e),f(V,e),f(G,e),f(Y,e),f(S,e),f(F,e),f(D,e),f(ee,e),f(se,e),f(te,e),f(pe,e),f(ie,e),f(ge,e),f(re,e),f(he,e),f(fe,e),f(de,e),f(je,e)}}}const os='{"title":"추론 엔드포인트","local":"inference-endpoints","sections":[{"title":"추론 엔드포인트 생성","local":"create-an-inference-endpoint","sections":[{"title":"사용자 정의 이미지 사용","local":"using-a-custom-image","sections":[],"depth":4},{"title":"기존 추론 엔드포인트 가져오기 또는 리스트 조회","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"배포 상태 확인","local":"check-deployment-status","sections":[],"depth":2},{"title":"추론 실행","local":"run-inference","sections":[],"depth":2},{"title":"라이프사이클 관리","local":"manage-lifecycle","sections":[{"title":"일시 중지 또는 0으로 확장","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"모델 또는 하드웨어 요구 사항 업데이트","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"엔드포인트 삭제","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"엔드 투 엔드 예제 an-end-to-end-example","local":"엔드-투-엔드-예제-an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function hs(wn){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends ts{constructor(j){super(),ls(this,j,hs,rs,ns,{})}}export{js as component};
