# 컬렉션 관리[[managing-collections]]

Hub에서 Space를 관리하는 메소드에 대한 자세한 설명은 [HfApi](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi) 페이지를 확인하세요.

- 컬렉션 내용 가져오기: [get_collection()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_collection)
- 새로운 컬렉션 생성: [create_collection()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_collection)
- 컬렉션 업데이트: [update_collection_metadata()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.update_collection_metadata)
- 컬렉션 삭제: [delete_collection()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_collection)
- 컬렉션에 항목 추가: [add_collection_item()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.add_collection_item)
- 컬렉션의 항목 업데이트: [update_collection_item()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.update_collection_item)
- 컬렉션에서 항목 제거: [delete_collection_item()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_collection_item)


### Collection[[huggingface_hub.Collection]][[huggingface_hub.Collection]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.Collection</name><anchor>huggingface_hub.Collection</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1181</source><parameters>[{"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **slug** (`str`) --
  Slug of the collection. E.g. `"TheBloke/recent-models-64f9a55bb3115b4f513ec026"`.
- **title** (`str`) --
  Title of the collection. E.g. `"Recent models"`.
- **owner** (`str`) --
  Owner of the collection. E.g. `"TheBloke"`.
- **items** (`list[CollectionItem]`) --
  List of items in the collection.
- **last_updated** (`datetime`) --
  Date of the last update of the collection.
- **position** (`int`) --
  Position of the collection in the list of collections of the owner.
- **private** (`bool`) --
  Whether the collection is private or not.
- **theme** (`str`) --
  Theme of the collection. E.g. `"green"`.
- **upvotes** (`int`) --
  Number of upvotes of the collection.
- **description** (`str`, *optional*) --
  Description of the collection, as plain text.
- **url** (`str`) --
  (property) URL of the collection on the Hub.</paramsdesc><paramgroups>0</paramgroups></docstring>

Contains information about a Collection on the Hub.




</div>

### CollectionItem[[huggingface_hub.CollectionItem]][[huggingface_hub.CollectionItem]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.CollectionItem</name><anchor>huggingface_hub.CollectionItem</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_api.py#L1136</source><parameters>[{"name": "_id", "val": ": str"}, {"name": "id", "val": ": str"}, {"name": "type", "val": ": CollectionItemType_T"}, {"name": "position", "val": ": int"}, {"name": "note", "val": ": Optional[dict] = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **item_object_id** (`str`) --
  Unique ID of the item in the collection.
- **item_id** (`str`) --
  ID of the underlying object on the Hub. Can be either a repo_id, a paper id or a collection slug.
  e.g. `"jbilcke-hf/ai-comic-factory"`, `"2307.09288"`, `"celinah/cerebras-function-calling-682607169c35fbfa98b30b9a"`.
- **item_type** (`str`) --
  Type of the underlying object. Can be one of `"model"`, `"dataset"`, `"space"`, `"paper"` or `"collection"`.
- **position** (`int`) --
  Position of the item in the collection.
- **note** (`str`, *optional*) --
  Note associated with the item, as plain text.</paramsdesc><paramgroups>0</paramgroups></docstring>

Contains information about an item of a Collection (model, dataset, Space, paper or collection).




</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/collections.md" />