# 파일 시스템 API[[filesystem-api]]

[HfFileSystem](/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem) 클래스는 [`fsspec`](https://filesystem-spec.readthedocs.io/en/latest/)을 기반으로 Hugging Face Hub에 Python 파일 인터페이스를 제공합니다.

## [HfFileSystem](Hf파일시스템)[[huggingface_hub.HfFileSystem]]

[HfFileSystem](/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem)은 [`fsspec`](https://filesystem-spec.readthedocs.io/en/latest/)을 기반으로 하므로 제공되는 대부분의 API와 호환됩니다. 자세한 내용은 [가이드](../guides/hf_file_system) 및 fsspec의 [API 레퍼런스](https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem)를 확인하세요.

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.HfFileSystem</name><anchor>huggingface_hub.HfFileSystem</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L59</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **token** (`str` or `bool`, *optional*) --
  A valid user access token (string). Defaults to the locally saved
  token, which is the recommended method for authentication (see
  https://huggingface.co/docs/huggingface_hub/quick-start#authentication).
  To disable authentication, pass `False`.
- **endpoint** (`str`, *optional*) --
  Endpoint of the Hub. Defaults to <https://huggingface.co>.</paramsdesc><paramgroups>0</paramgroups></docstring>

Access a remote Hugging Face Hub repository as if were a local file system.

> [!WARNING]
> [HfFileSystem](/docs/huggingface_hub/main/ko/package_reference/hf_file_system#huggingface_hub.HfFileSystem) provides fsspec compatibility, which is useful for libraries that require it (e.g., reading
>     Hugging Face datasets directly with `pandas`). However, it introduces additional overhead due to this compatibility
>     layer. For better performance and reliability, it's recommended to use `HfApi` methods when possible.



<ExampleCodeBlock anchor="huggingface_hub.HfFileSystem.example">

Usage:

```python
>>> from huggingface_hub import HfFileSystem

>>> fs = HfFileSystem()

>>> # List files
>>> fs.glob("my-username/my-model/*.bin")
['my-username/my-model/pytorch_model.bin']
>>> fs.ls("datasets/my-username/my-dataset", detail=False)
['datasets/my-username/my-dataset/.gitattributes', 'datasets/my-username/my-dataset/README.md', 'datasets/my-username/my-dataset/data.json']

>>> # Read/write files
>>> with fs.open("my-username/my-model/pytorch_model.bin") as f:
...     data = f.read()
>>> with fs.open("my-username/my-model/pytorch_model.bin", "wb") as f:
...     f.write(data)
```

</ExampleCodeBlock>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>huggingface_hub.HfFileSystem.__init__</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L100</source><parameters>[{"name": "*args", "val": ""}, {"name": "endpoint", "val": ": typing.Optional[str] = None"}, {"name": "token", "val": ": typing.Union[bool, str, NoneType] = None"}, {"name": "block_size", "val": ": typing.Optional[int] = None"}, {"name": "**storage_options", "val": ""}]</parameters></docstring>


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>resolve_path</name><anchor>huggingface_hub.HfFileSystem.resolve_path</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L141</source><parameters>[{"name": "path", "val": ": str"}, {"name": "revision", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **path** (`str`) --
  Path to resolve.
- **revision** (`str`, *optional*) --
  The revision of the repo to resolve. Defaults to the revision specified in the path.</paramsdesc><paramgroups>0</paramgroups><rettype>`HfFileSystemResolvedPath`</rettype><retdesc>Resolved path information containing `repo_type`, `repo_id`, `revision` and `path_in_repo`.</retdesc><raises>- ``ValueError`` -- 
  If path contains conflicting revision information.
- ``NotImplementedError`` -- 
  If trying to list repositories.</raises><raisederrors>``ValueError`` or ``NotImplementedError``</raisederrors></docstring>

Resolve a Hugging Face file system path into its components.












</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>ls</name><anchor>huggingface_hub.HfFileSystem.ls</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L341</source><parameters>[{"name": "path", "val": ": str"}, {"name": "detail", "val": ": bool = True"}, {"name": "refresh", "val": ": bool = False"}, {"name": "revision", "val": ": typing.Optional[str] = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **path** (`str`) --
  Path to the directory.
- **detail** (`bool`, *optional*) --
  If True, returns a list of dictionaries containing file information. If False,
  returns a list of file paths. Defaults to True.
- **refresh** (`bool`, *optional*) --
  If True, bypass the cache and fetch the latest data. Defaults to False.
- **revision** (`str`, *optional*) --
  The git revision to list from.</paramsdesc><paramgroups>0</paramgroups><rettype>`list[Union[str, dict[str, Any]]]`</rettype><retdesc>List of file paths (if detail=False) or list of file information
dictionaries (if detail=True).</retdesc></docstring>

List the contents of a directory.

For more details, refer to [fsspec documentation](https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.ls).

> [!WARNING]
> Note: When possible, use `HfApi.list_repo_tree()` for better performance.








</div></div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/hf_file_system.md" />