# 추론 엔드포인트 [[inference-endpoints]]

Hugging Face가 관리하는 추론 엔드포인트는 우리가 모델을 쉽고 안전하게 배포할 수 있게 해주는 도구입니다. 이러한 추론 엔드포인트는 [Hub](https://huggingface.co/models)에 있는 모델을 기반으로 설계되었습니다. 이 문서는 `huggingface_hub`와 추론 엔드포인트 통합에 관한 참조 페이지이며, 더욱 자세한 정보는 [공식 문서](https://huggingface.co/docs/inference-endpoints/index)를 통해 확인할 수 있습니다.

> [!TIP]
> 'huggingface_hub'를 사용하여 추론 엔드포인트를 프로그래밍 방식으로 관리하는 방법을 알고 싶다면, [관련 가이드](../guides/inference_endpoints)를 확인해 보세요.

추론 엔드포인트는 API로 쉽게 접근할 수 있습니다. 이 엔드포인트들은 [Swagger](https://api.endpoints.huggingface.cloud/)를 통해 문서화되어 있고, [InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint) 클래스는 이 API를 사용해 만든 간단한 래퍼입니다.

## 매소드 [[methods]]

다음과 같은 추론 엔드포인트의 기능이 [HfApi](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi)안에 구현되어 있습니다:

- [get_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint)와 [list_inference_endpoints()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints)를 사용해 엔드포인트 정보를 조회할 수 있습니다.
- [create_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint), [update_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint), [delete_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint)로 엔드포인트를 배포하고 관리할 수 있습니다.
- [pause_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint)와 [resume_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint)로 엔드포인트를 잠시 멈추거나 다시 시작할 수 있습니다.
- [scale_to_zero_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint)로 엔드포인트의 복제본을 0개로 설정할 수 있습니다.

## InferenceEndpoint [[huggingface_hub.InferenceEndpoint]][[huggingface_hub.InferenceEndpoint]]

기본 데이터 클래스는 [InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint)입니다. 여기에는 구성 및 현재 상태를 가지고 있는 배포된 `InferenceEndpoint`에 대한 정보가 포함되어 있습니다. 배포 후에는 [InferenceEndpoint.client](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.client)와 [InferenceEndpoint.async_client](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.async_client)를 사용해 엔드포인트에서 추론 작업을 할 수 있고, 이때 [InferenceClient](/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient)와 [AsyncInferenceClient](/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.AsyncInferenceClient) 객체를 반환합니다.

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.InferenceEndpoint</name><anchor>huggingface_hub.InferenceEndpoint</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L38</source><parameters>[{"name": "namespace", "val": ": str"}, {"name": "raw", "val": ": dict"}, {"name": "_token", "val": ": typing.Union[str, bool, NoneType]"}, {"name": "_api", "val": ": HfApi"}]</parameters><paramsdesc>- **name** (`str`) --
  The unique name of the Inference Endpoint.
- **namespace** (`str`) --
  The namespace where the Inference Endpoint is located.
- **repository** (`str`) --
  The name of the model repository deployed on this Inference Endpoint.
- **status** ([InferenceEndpointStatus](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus)) --
  The current status of the Inference Endpoint.
- **url** (`str`, *optional*) --
  The URL of the Inference Endpoint, if available. Only a deployed Inference Endpoint will have a URL.
- **framework** (`str`) --
  The machine learning framework used for the model.
- **revision** (`str`) --
  The specific model revision deployed on the Inference Endpoint.
- **task** (`str`) --
  The task associated with the deployed model.
- **created_at** (`datetime.datetime`) --
  The timestamp when the Inference Endpoint was created.
- **updated_at** (`datetime.datetime`) --
  The timestamp of the last update of the Inference Endpoint.
- **type** ([InferenceEndpointType](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointType)) --
  The type of the Inference Endpoint (public, protected, private).
- **raw** (`dict`) --
  The raw dictionary data returned from the API.
- **token** (`str` or `bool`, *optional*) --
  Authentication token for the Inference Endpoint, if set when requesting the API. Will default to the
  locally saved token if not provided. Pass `token=False` if you don't want to send your token to the server.</paramsdesc><paramgroups>0</paramgroups></docstring>

Contains information about a deployed Inference Endpoint.



<ExampleCodeBlock anchor="huggingface_hub.InferenceEndpoint.example">

Example:
```python
>>> from huggingface_hub import get_inference_endpoint
>>> endpoint = get_inference_endpoint("my-text-to-image")
>>> endpoint
InferenceEndpoint(name='my-text-to-image', ...)

# Get status
>>> endpoint.status
'running'
>>> endpoint.url
'https://my-text-to-image.region.vendor.endpoints.huggingface.cloud'

# Run inference
>>> endpoint.client.text_to_image(...)

# Pause endpoint to save $$$
>>> endpoint.pause()

# ...
# Resume and wait for deployment
>>> endpoint.resume()
>>> endpoint.wait()
>>> endpoint.client.text_to_image(...)
```

</ExampleCodeBlock>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_raw</name><anchor>huggingface_hub.InferenceEndpoint.from_raw</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L121</source><parameters>[{"name": "raw", "val": ": dict"}, {"name": "namespace", "val": ": str"}, {"name": "token", "val": ": typing.Union[str, bool, NoneType] = None"}, {"name": "api", "val": ": typing.Optional[ForwardRef('HfApi')] = None"}]</parameters></docstring>
Initialize object from raw dictionary.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>client</name><anchor>huggingface_hub.InferenceEndpoint.client</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L140</source><parameters>[]</parameters><rettype>[InferenceClient](/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient)</rettype><retdesc>an inference client pointing to the deployed endpoint.</retdesc><raises>- [InferenceEndpointError](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError) -- If the Inference Endpoint is not yet deployed.</raises><raisederrors>[InferenceEndpointError](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError)</raisederrors></docstring>
Returns a client to make predictions on this Inference Endpoint.










</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>async_client</name><anchor>huggingface_hub.InferenceEndpoint.async_client</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L162</source><parameters>[]</parameters><rettype>[AsyncInferenceClient](/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.AsyncInferenceClient)</rettype><retdesc>an asyncio-compatible inference client pointing to the deployed endpoint.</retdesc><raises>- [InferenceEndpointError](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError) -- If the Inference Endpoint is not yet deployed.</raises><raisederrors>[InferenceEndpointError](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError)</raisederrors></docstring>
Returns a client to make predictions on this Inference Endpoint.










</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>delete</name><anchor>huggingface_hub.InferenceEndpoint.delete</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L385</source><parameters>[]</parameters></docstring>
Delete the Inference Endpoint.

This operation is not reversible. If you don't want to be charged for an Inference Endpoint, it is preferable
to pause it with [InferenceEndpoint.pause()](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause) or scale it to zero with [InferenceEndpoint.scale_to_zero()](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero).

This is an alias for [HfApi.delete_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint).


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>fetch</name><anchor>huggingface_hub.InferenceEndpoint.fetch</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L237</source><parameters>[]</parameters><rettype>[InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint)</rettype><retdesc>the same Inference Endpoint, mutated in place with the latest data.</retdesc></docstring>
Fetch latest information about the Inference Endpoint.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>pause</name><anchor>huggingface_hub.InferenceEndpoint.pause</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L328</source><parameters>[]</parameters><rettype>[InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint)</rettype><retdesc>the same Inference Endpoint, mutated in place with the latest data.</retdesc></docstring>
Pause the Inference Endpoint.

A paused Inference Endpoint will not be charged. It can be resumed at any time using [InferenceEndpoint.resume()](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume).
This is different from scaling the Inference Endpoint to zero with [InferenceEndpoint.scale_to_zero()](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero), which
would be automatically restarted when a request is made to it.

This is an alias for [HfApi.pause_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint). The current object is mutated in place with the
latest data from the server.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>resume</name><anchor>huggingface_hub.InferenceEndpoint.resume</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L346</source><parameters>[{"name": "running_ok", "val": ": bool = True"}]</parameters><paramsdesc>- **running_ok** (`bool`, *optional*) --
  If `True`, the method will not raise an error if the Inference Endpoint is already running. Defaults to
  `True`.</paramsdesc><paramgroups>0</paramgroups><rettype>[InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint)</rettype><retdesc>the same Inference Endpoint, mutated in place with the latest data.</retdesc></docstring>
Resume the Inference Endpoint.

This is an alias for [HfApi.resume_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint). The current object is mutated in place with the
latest data from the server.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_to_zero</name><anchor>huggingface_hub.InferenceEndpoint.scale_to_zero</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L367</source><parameters>[]</parameters><rettype>[InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint)</rettype><retdesc>the same Inference Endpoint, mutated in place with the latest data.</retdesc></docstring>
Scale Inference Endpoint to zero.

An Inference Endpoint scaled to zero will not be charged. It will be resumed on the next request to it, with a
cold start delay. This is different from pausing the Inference Endpoint with [InferenceEndpoint.pause()](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause), which
would require a manual resume with [InferenceEndpoint.resume()](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume).

This is an alias for [HfApi.scale_to_zero_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint). The current object is mutated in place with the
latest data from the server.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>update</name><anchor>huggingface_hub.InferenceEndpoint.update</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L248</source><parameters>[{"name": "accelerator", "val": ": typing.Optional[str] = None"}, {"name": "instance_size", "val": ": typing.Optional[str] = None"}, {"name": "instance_type", "val": ": typing.Optional[str] = None"}, {"name": "min_replica", "val": ": typing.Optional[int] = None"}, {"name": "max_replica", "val": ": typing.Optional[int] = None"}, {"name": "scale_to_zero_timeout", "val": ": typing.Optional[int] = None"}, {"name": "repository", "val": ": typing.Optional[str] = None"}, {"name": "framework", "val": ": typing.Optional[str] = None"}, {"name": "revision", "val": ": typing.Optional[str] = None"}, {"name": "task", "val": ": typing.Optional[str] = None"}, {"name": "custom_image", "val": ": typing.Optional[dict] = None"}, {"name": "secrets", "val": ": typing.Optional[dict[str, str]] = None"}]</parameters><paramsdesc>- **accelerator** (`str`, *optional*) --
  The hardware accelerator to be used for inference (e.g. `"cpu"`).
- **instance_size** (`str`, *optional*) --
  The size or type of the instance to be used for hosting the model (e.g. `"x4"`).
- **instance_type** (`str`, *optional*) --
  The cloud instance type where the Inference Endpoint will be deployed (e.g. `"intel-icl"`).
- **min_replica** (`int`, *optional*) --
  The minimum number of replicas (instances) to keep running for the Inference Endpoint.
- **max_replica** (`int`, *optional*) --
  The maximum number of replicas (instances) to scale to for the Inference Endpoint.
- **scale_to_zero_timeout** (`int`, *optional*) --
  The duration in minutes before an inactive endpoint is scaled to zero.

- **repository** (`str`, *optional*) --
  The name of the model repository associated with the Inference Endpoint (e.g. `"gpt2"`).
- **framework** (`str`, *optional*) --
  The machine learning framework used for the model (e.g. `"custom"`).
- **revision** (`str`, *optional*) --
  The specific model revision to deploy on the Inference Endpoint (e.g. `"6c0e6080953db56375760c0471a8c5f2929baf11"`).
- **task** (`str`, *optional*) --
  The task on which to deploy the model (e.g. `"text-classification"`).
- **custom_image** (`dict`, *optional*) --
  A custom Docker image to use for the Inference Endpoint. This is useful if you want to deploy an
  Inference Endpoint running on the `text-generation-inference` (TGI) framework (see examples).
- **secrets** (`dict[str, str]`, *optional*) --
  Secret values to inject in the container environment.</paramsdesc><paramgroups>0</paramgroups><rettype>[InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint)</rettype><retdesc>the same Inference Endpoint, mutated in place with the latest data.</retdesc></docstring>
Update the Inference Endpoint.

This method allows the update of either the compute configuration, the deployed model, or both. All arguments are
optional but at least one must be provided.

This is an alias for [HfApi.update_inference_endpoint()](/docs/huggingface_hub/main/ko/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint). The current object is mutated in place with the
latest data from the server.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>wait</name><anchor>huggingface_hub.InferenceEndpoint.wait</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L184</source><parameters>[{"name": "timeout", "val": ": typing.Optional[int] = None"}, {"name": "refresh_every", "val": ": int = 5"}]</parameters><paramsdesc>- **timeout** (`int`, *optional*) --
  The maximum time to wait for the Inference Endpoint to be deployed, in seconds. If `None`, will wait
  indefinitely.
- **refresh_every** (`int`, *optional*) --
  The time to wait between each fetch of the Inference Endpoint status, in seconds. Defaults to 5s.</paramsdesc><paramgroups>0</paramgroups><rettype>[InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint)</rettype><retdesc>the same Inference Endpoint, mutated in place with the latest data.</retdesc><raises>- [InferenceEndpointError](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError) -- 
  If the Inference Endpoint ended up in a failed state.
- `InferenceEndpointTimeoutError` -- 
  If the Inference Endpoint is not deployed after `timeout` seconds.</raises><raisederrors>[InferenceEndpointError](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError) or `InferenceEndpointTimeoutError`</raisederrors></docstring>
Wait for the Inference Endpoint to be deployed.

Information from the server will be fetched every 1s. If the Inference Endpoint is not deployed after `timeout`
seconds, a `InferenceEndpointTimeoutError` will be raised. The [InferenceEndpoint](/docs/huggingface_hub/main/ko/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint) will be mutated in place with the latest
data.












</div></div>

## InferenceEndpointStatus [[huggingface_hub.InferenceEndpointStatus]][[huggingface_hub.InferenceEndpointStatus]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.InferenceEndpointStatus</name><anchor>huggingface_hub.InferenceEndpointStatus</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L20</source><parameters>[{"name": "value", "val": ""}, {"name": "names", "val": " = None"}, {"name": "module", "val": " = None"}, {"name": "qualname", "val": " = None"}, {"name": "type", "val": " = None"}, {"name": "start", "val": " = 1"}]</parameters></docstring>
An enumeration.

</div>

## InferenceEndpointType [[huggingface_hub.InferenceEndpointType]][[huggingface_hub.InferenceEndpointType]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.InferenceEndpointType</name><anchor>huggingface_hub.InferenceEndpointType</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L31</source><parameters>[{"name": "value", "val": ""}, {"name": "names", "val": " = None"}, {"name": "module", "val": " = None"}, {"name": "qualname", "val": " = None"}, {"name": "type", "val": " = None"}, {"name": "start", "val": " = 1"}]</parameters></docstring>
An enumeration.

</div>

## InferenceEndpointError [[huggingface_hub.InferenceEndpointError]][[huggingface_hub.InferenceEndpointError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.InferenceEndpointError</name><anchor>huggingface_hub.InferenceEndpointError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L98</source><parameters>""</parameters></docstring>
Generic exception when dealing with Inference Endpoints.

</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/inference_endpoints.md" />