# 유틸리티[[utilities]]

## 로깅 구성[[huggingface_hub.utils.logging.get_verbosity]][[huggingface_hub.utils.logging.get_verbosity]]

`huggingface_hub` 패키지는 패키지 로그 레벨을 제어하기 위한 `logging` 유틸리티를 제공합니다. 
다음과 같이 가져올 수 있습니다:

```py
from huggingface_hub import logging
```

그런 다음, 로그의 출력 수를 업데이트하기 위해 로그 레벨을 정의할 수 있습니다:

```python
from huggingface_hub import logging

logging.set_verbosity_error()
logging.set_verbosity_warning()
logging.set_verbosity_info()
logging.set_verbosity_debug()

logging.set_verbosity(...)
```

로그 레벨은 다음과 같이 이해하면 됩니다:

- `error`: 오류 또는 예기치 않은 동작으로 이어질 수 있는 결정적인 로그만 표시합니다.
- `warning`:  결정적이진 않지만 의도치 않은 동작을 초래할 수 있는 로그를 표시합니다. 또한 중요한 정보를 포함한 로그도 표시될 수 있습니다.
- `info`: 하부에서 무슨 일이 일어나고 있는지에 대한 자세한 로그를 포함하여 대부분의 로그를 표시합니다. 무언가 예상치 못한 방식으로 동작하는 경우, 더 많은 정보를 얻기 위해 verbosity 단계로 전환하는 것이 좋습니다.
- `debug`: 하부에서 정확히 무슨 일이 일어나고 있는지를 추적하는 데 사용될 수 있는 일부 내부 로그를 포함하여 모든 로그를 표시합니다.

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.get_verbosity</name><anchor>huggingface_hub.utils.logging.get_verbosity</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L105</source><parameters>[]</parameters><retdesc>Logging level, e.g., `huggingface_hub.logging.DEBUG` and
`huggingface_hub.logging.INFO`.</retdesc></docstring>
Return the current level for the HuggingFace Hub's root logger.



> [!TIP]
> HuggingFace Hub has following logging levels:
>
> - `huggingface_hub.logging.CRITICAL`, `huggingface_hub.logging.FATAL`
> - `huggingface_hub.logging.ERROR`
> - `huggingface_hub.logging.WARNING`, `huggingface_hub.logging.WARN`
> - `huggingface_hub.logging.INFO`
> - `huggingface_hub.logging.DEBUG`


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.set_verbosity</name><anchor>huggingface_hub.utils.logging.set_verbosity</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L124</source><parameters>[{"name": "verbosity", "val": ": int"}]</parameters><paramsdesc>- **verbosity** (`int`) --
  Logging level, e.g., `huggingface_hub.logging.DEBUG` and
  `huggingface_hub.logging.INFO`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the level for the HuggingFace Hub's root logger.




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.set_verbosity_info</name><anchor>huggingface_hub.utils.logging.set_verbosity_info</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L136</source><parameters>[]</parameters></docstring>

Sets the verbosity to `logging.INFO`.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.set_verbosity_debug</name><anchor>huggingface_hub.utils.logging.set_verbosity_debug</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L150</source><parameters>[]</parameters></docstring>

Sets the verbosity to `logging.DEBUG`.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.set_verbosity_warning</name><anchor>huggingface_hub.utils.logging.set_verbosity_warning</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L143</source><parameters>[]</parameters></docstring>

Sets the verbosity to `logging.WARNING`.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.set_verbosity_error</name><anchor>huggingface_hub.utils.logging.set_verbosity_error</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L157</source><parameters>[]</parameters></docstring>

Sets the verbosity to `logging.ERROR`.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.disable_propagation</name><anchor>huggingface_hub.utils.logging.disable_propagation</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L164</source><parameters>[]</parameters></docstring>

Disable propagation of the library log outputs. Note that log propagation is
disabled by default.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.enable_propagation</name><anchor>huggingface_hub.utils.logging.enable_propagation</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L172</source><parameters>[]</parameters></docstring>

Enable propagation of the library log outputs. Please disable the
HuggingFace Hub's default handler to prevent double logging if the root
logger has been configured.


</div>

### 리포지토리별 도우미 메소드[[huggingface_hub.utils.logging.get_logger]][[huggingface_hub.utils.logging.get_logger]]

아래 제공된 메소드들은 `huggingface_hub` 라이브러리 모듈을 수정할 때 관련이 있습니다. `huggingface_hub`를 사용하고 해당 모듈을 수정하지 않는 경우에는 사용할 필요가 없습니다.

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.logging.get_logger</name><anchor>huggingface_hub.utils.logging.get_logger</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/logging.py#L80</source><parameters>[{"name": "name", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **name** (`str`, *optional*) --
  The name of the logger to get, usually the filename</paramsdesc><paramgroups>0</paramgroups></docstring>

Returns a logger with the specified name. This function is not supposed
to be directly accessed by library users.



<ExampleCodeBlock anchor="huggingface_hub.utils.logging.get_logger.example">

Example:

```python
>>> from huggingface_hub import get_logger

>>> logger = get_logger(__file__)
>>> logger.set_verbosity_info()
```

</ExampleCodeBlock>


</div>

## 프로그레스 바 구성하기[[configure-progress-bars]]

프로그레스 바는 긴 시간이 걸리는 작업을 실행하는 동안 정보를 표시하는 유용한 도구입니다(예시로 파일을 다운로드하거나 업로드하는 등). `huggingface_hub`는 라이브러리 전체에서 일관된 방식으로 프로그레스 바를 표시하기 위한 `tqdm` 래퍼를 제공합니다.

기본적으로 프로그레스 바가 활성화되어 있습니다. `HF_HUB_DISABLE_PROGRESS_BARS` 환경 변수를 설정하여 전역적으로 비활성화할 수 있습니다. 또한 [enable_progress_bars()](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.utils.enable_progress_bars)와 [disable_progress_bars()](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.utils.disable_progress_bars)를 사용하여 프로그레스 바를 개별적으로 활성화 또는 비활성화할 수도 있습니다. 만약 환경 변수가 설정되어 있다면, 환경 변수가 도우미에서 우선 순위를 가집니다.


```py
>>> from huggingface_hub import snapshot_download
>>> from huggingface_hub.utils import are_progress_bars_disabled, disable_progress_bars, enable_progress_bars

>>> # 전역적으로 프로그레스 바를 비활성화합니다.
>>> disable_progress_bars()

>>> # 프로그레스 바가 표시되지 않습니다!
>>> snapshot_download("gpt2")

>>> are_progress_bars_disabled()
True

>>> # 다시 프로그레스 바가 활성화됩니다
>>> enable_progress_bars()
```

### are_progress_bars_disabled[[huggingface_hub.utils.are_progress_bars_disabled]][[huggingface_hub.utils.are_progress_bars_disabled]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.are_progress_bars_disabled</name><anchor>huggingface_hub.utils.are_progress_bars_disabled</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/tqdm.py#L172</source><parameters>[{"name": "name", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **name** (`str`, *optional*) --
  The group name to check; if None, checks the global setting.</paramsdesc><paramgroups>0</paramgroups><rettype>`bool`</rettype><retdesc>True if progress bars are disabled, False otherwise.</retdesc></docstring>

Check if progress bars are disabled globally or for a specific group.

This function returns whether progress bars are disabled for a given group or globally.
It checks the `HF_HUB_DISABLE_PROGRESS_BARS` environment variable first, then the programmatic
settings.








</div>

### disable_progress_bars[[huggingface_hub.utils.disable_progress_bars]][[huggingface_hub.utils.disable_progress_bars]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.disable_progress_bars</name><anchor>huggingface_hub.utils.disable_progress_bars</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/tqdm.py#L108</source><parameters>[{"name": "name", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **name** (`str`, *optional*) --
  The name of the group for which to disable the progress bars. If None,
  progress bars are disabled globally.</paramsdesc><paramgroups>0</paramgroups><raises>- ``Warning`` -- If the environment variable precludes changes.</raises><raisederrors>``Warning``</raisederrors></docstring>

Disable progress bars either globally or for a specified group.

This function updates the state of progress bars based on a group name.
If no group name is provided, all progress bars are disabled. The operation
respects the `HF_HUB_DISABLE_PROGRESS_BARS` environment variable's setting.








</div>

### enable_progress_bars[huggingface_hub.utils.enable_progress_bars]][[huggingface_hub.utils.enable_progress_bars]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.enable_progress_bars</name><anchor>huggingface_hub.utils.enable_progress_bars</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/tqdm.py#L140</source><parameters>[{"name": "name", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **name** (`str`, *optional*) --
  The name of the group for which to enable the progress bars. If None,
  progress bars are enabled globally.</paramsdesc><paramgroups>0</paramgroups><raises>- ``Warning`` -- If the environment variable precludes changes.</raises><raisederrors>``Warning``</raisederrors></docstring>

Enable progress bars either globally or for a specified group.

This function sets the progress bars to enabled for the specified group or globally
if no group is specified. The operation is subject to the `HF_HUB_DISABLE_PROGRESS_BARS`
environment setting.








</div>

## HTTP 오류 다루기[[handle-http-errors]]

`huggingface_hub`는 서버에서 반환된 추가 정보로 `requests`에서 발생한 `HTTPError`를 세분화하기 위해 자체 HTTP 오류를 정의합니다.

### 예외 발생[[huggingface_hub.utils.hf_raise_for_status]][[huggingface_hub.hf_raise_for_status]]

[hf_raise_for_status()](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.hf_raise_for_status)는 Hub에 대한 모든 요청에서 "상태를 확인하고 예외를 발생시키는" 중앙 메소드로 사용됩니다. 이 메서드는 기본 `requests.raise_for_status`를 감싸서 추가 정보를 제공합니다. 발생된 모든 `HTTPError`는 `HfHubHTTPError`로 변환됩니다.

```py
import requests
from huggingface_hub.utils import hf_raise_for_status, HfHubHTTPError

response = requests.post(...)
try:
    hf_raise_for_status(response)
except HfHubHTTPError as e:
    print(str(e)) # 형식화된 메시지
    e.request_id, e.server_message # 서버에서 반환된 세부 정보

    # 오류 메시지를 발생시킬 때 추가 정보를 포함하여 완성합니다
    e.append_to_message("\n`create_commit` expects the repository to exist.")
    raise
```

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.hf_raise_for_status</name><anchor>huggingface_hub.hf_raise_for_status</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_http.py#L516</source><parameters>[{"name": "response", "val": ": Response"}, {"name": "endpoint_name", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **response** (`Response`) --
  Response from the server.
- **endpoint_name** (`str`, *optional*) --
  Name of the endpoint that has been called. If provided, the error message will be more complete.</paramsdesc><paramgroups>0</paramgroups></docstring>

Internal version of `response.raise_for_status()` that will refine a potential HTTPError.
Raised exception will be an instance of [HfHubHTTPError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError).

This helper is meant to be the unique method to raise_for_status when making a call to the Hugging Face Hub.



> [!WARNING]
> Raises when the request has failed:
>
>     - [RepositoryNotFoundError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RepositoryNotFoundError)
>         If the repository to download from cannot be found. This may be because it
>         doesn't exist, because `repo_type` is not set correctly, or because the repo
>         is `private` and you do not have access.
>     - [GatedRepoError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.GatedRepoError)
>         If the repository exists but is gated and the user is not on the authorized
>         list.
>     - [RevisionNotFoundError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.RevisionNotFoundError)
>         If the repository exists but the revision couldn't be found.
>     - [EntryNotFoundError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.EntryNotFoundError)
>         If the repository exists but the entry (e.g. the requested file) couldn't be
>         find.
>     - [BadRequestError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.BadRequestError)
>         If request failed with a HTTP 400 BadRequest error.
>     - [HfHubHTTPError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HfHubHTTPError)
>         If request failed for a reason not listed above.


</div>

### HTTP 오류[[http-errors]]

여기에는 `huggingface_hub`에서 발생하는 HTTP 오류 목록이 있습니다.

#### HfHubHTTPError[[huggingface_hub.errors.HfHubHTTPError]][[huggingface_hub.errors.HfHubHTTPError]]

`HfHubHTTPError`는 HF Hub HTTP 오류에 대한 부모 클래스입니다. 이 클래스는 서버 응답을 구문 분석하고 오류 메시지를 형식화하여 사용자에게 가능한 많은 정보를 제공합니다.

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.HfHubHTTPError</name><anchor>huggingface_hub.errors.HfHubHTTPError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L40</source><parameters>[{"name": "message", "val": ": str"}, {"name": "response", "val": ": Response"}, {"name": "server_message", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

HTTPError to inherit from for any custom HTTP Error raised in HF Hub.

Any HTTPError is converted at least into a `HfHubHTTPError`. If some information is
sent back by the server, it will be added to the error message.

Added details:
- Request id from "X-Request-Id" header if exists. If not, fallback to "X-Amzn-Trace-Id" header if exists.
- Server error message from the header "X-Error-Message".
- Server error message if we can found one in the response body.

<ExampleCodeBlock anchor="huggingface_hub.errors.HfHubHTTPError.example">

Example:
```py
    import httpx
    from huggingface_hub.utils import get_session, hf_raise_for_status, HfHubHTTPError

    response = get_session().post(...)
    try:
        hf_raise_for_status(response)
    except HfHubHTTPError as e:
        print(str(e)) # formatted message
        e.request_id, e.server_message # details returned by server

        # Complete the error message with additional information once it's raised
        e.append_to_message("
ate_commit` expects the repository to exist.")
        raise
```

</ExampleCodeBlock>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>append_to_message</name><anchor>huggingface_hub.errors.HfHubHTTPError.append_to_message</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L83</source><parameters>[{"name": "additional_message", "val": ": str"}]</parameters></docstring>
Append additional information to the `HfHubHTTPError` initial message.

</div></div>

#### RepositoryNotFoundError[[huggingface_hub.errors.RepositoryNotFoundError]][[huggingface_hub.errors.RepositoryNotFoundError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.RepositoryNotFoundError</name><anchor>huggingface_hub.errors.RepositoryNotFoundError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L177</source><parameters>[{"name": "message", "val": ": str"}, {"name": "response", "val": ": Response"}, {"name": "server_message", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

Raised when trying to access a hf.co URL with an invalid repository name, or
with a private repo name the user does not have access to.

<ExampleCodeBlock anchor="huggingface_hub.errors.RepositoryNotFoundError.example">

Example:

```py
>>> from huggingface_hub import model_info
>>> model_info("<non_existent_repository>")
(...)
huggingface_hub.errors.RepositoryNotFoundError: 401 Client Error. (Request ID: PvMw_VjBMjVdMz53WKIzP)

Repository Not Found for url: https://huggingface.co/api/models/%3Cnon_existent_repository%3E.
Please make sure you specified the correct `repo_id` and `repo_type`.
If the repo is private, make sure you are authenticated.
Invalid username or password.
```

</ExampleCodeBlock>


</div>

#### GatedRepoError[[huggingface_hub.errors.GatedRepoError]][[huggingface_hub.errors.GatedRepoError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.GatedRepoError</name><anchor>huggingface_hub.errors.GatedRepoError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L198</source><parameters>[{"name": "message", "val": ": str"}, {"name": "response", "val": ": Response"}, {"name": "server_message", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

Raised when trying to access a gated repository for which the user is not on the
authorized list.

Note: derives from `RepositoryNotFoundError` to ensure backward compatibility.

<ExampleCodeBlock anchor="huggingface_hub.errors.GatedRepoError.example">

Example:

```py
>>> from huggingface_hub import model_info
>>> model_info("<gated_repository>")
(...)
huggingface_hub.errors.GatedRepoError: 403 Client Error. (Request ID: ViT1Bf7O_026LGSQuVqfa)

Cannot access gated repo for url https://huggingface.co/api/models/ardent-figment/gated-model.
Access to model ardent-figment/gated-model is restricted and you are not in the authorized list.
Visit https://huggingface.co/ardent-figment/gated-model to ask for access.
```

</ExampleCodeBlock>


</div>

#### RevisionNotFoundError[[huggingface_hub.errors.RevisionNotFoundError]][[huggingface_hub.errors.RevisionNotFoundError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.RevisionNotFoundError</name><anchor>huggingface_hub.errors.RevisionNotFoundError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L241</source><parameters>[{"name": "message", "val": ": str"}, {"name": "response", "val": ": Response"}, {"name": "server_message", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

Raised when trying to access a hf.co URL with a valid repository but an invalid
revision.

<ExampleCodeBlock anchor="huggingface_hub.errors.RevisionNotFoundError.example">

Example:

```py
>>> from huggingface_hub import hf_hub_download
>>> hf_hub_download('bert-base-cased', 'config.json', revision='<non-existent-revision>')
(...)
huggingface_hub.errors.RevisionNotFoundError: 404 Client Error. (Request ID: Mwhe_c3Kt650GcdKEFomX)

Revision Not Found for url: https://huggingface.co/bert-base-cased/resolve/%3Cnon-existent-revision%3E/config.json.
```

</ExampleCodeBlock>


</div>

#### BadRequestError[[huggingface_hub.errors.BadRequestError]][[huggingface_hub.errors.BadRequestError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.BadRequestError</name><anchor>huggingface_hub.errors.BadRequestError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L316</source><parameters>[{"name": "message", "val": ": str"}, {"name": "response", "val": ": Response"}, {"name": "server_message", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

Raised by `hf_raise_for_status` when the server returns a HTTP 400 error.

<ExampleCodeBlock anchor="huggingface_hub.errors.BadRequestError.example">

Example:

```py
>>> resp = httpx.post("hf.co/api/check", ...)
>>> hf_raise_for_status(resp, endpoint_name="check")
huggingface_hub.errors.BadRequestError: Bad request for check endpoint: {details} (Request ID: XXX)
```

</ExampleCodeBlock>


</div>

#### EntryNotFoundError[[huggingface_hub.errors.EntryNotFoundError]][[huggingface_hub.errors.EntryNotFoundError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.EntryNotFoundError</name><anchor>huggingface_hub.errors.EntryNotFoundError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L260</source><parameters>""</parameters></docstring>

Raised when entry not found, either locally or remotely.

<ExampleCodeBlock anchor="huggingface_hub.errors.EntryNotFoundError.example">

Example:

```py
>>> from huggingface_hub import hf_hub_download
>>> hf_hub_download('bert-base-cased', '<non-existent-file>')
(...)
huggingface_hub.errors.RemoteEntryNotFoundError (...)
>>> hf_hub_download('bert-base-cased', '<non-existent-file>', local_files_only=True)
(...)
huggingface_hub.utils.errors.LocalEntryNotFoundError (...)
```

</ExampleCodeBlock>


</div>

#### RemoteEntryNotFoundError[[huggingface_hub.errors.RemoteEntryNotFoundError]][[huggingface_hub.errors.RemoteEntryNotFoundError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.RemoteEntryNotFoundError</name><anchor>huggingface_hub.errors.RemoteEntryNotFoundError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L278</source><parameters>[{"name": "message", "val": ": str"}, {"name": "response", "val": ": Response"}, {"name": "server_message", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

Raised when trying to access a hf.co URL with a valid repository and revision
but an invalid filename.

<ExampleCodeBlock anchor="huggingface_hub.errors.RemoteEntryNotFoundError.example">

Example:

```py
>>> from huggingface_hub import hf_hub_download
>>> hf_hub_download('bert-base-cased', '<non-existent-file>')
(...)
huggingface_hub.errors.EntryNotFoundError: 404 Client Error. (Request ID: 53pNl6M0MxsnG5Sw8JA6x)

Entry Not Found for url: https://huggingface.co/bert-base-cased/resolve/main/%3Cnon-existent-file%3E.
```

</ExampleCodeBlock>


</div>

#### LocalEntryNotFoundError[[huggingface_hub.errors.LocalEntryNotFoundError]][[huggingface_hub.errors.LocalEntryNotFoundError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.LocalEntryNotFoundError</name><anchor>huggingface_hub.errors.LocalEntryNotFoundError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L296</source><parameters>[{"name": "message", "val": ": str"}]</parameters></docstring>

Raised when trying to access a file or snapshot that is not on the disk when network is
disabled or unavailable (connection issue). The entry may exist on the Hub.

<ExampleCodeBlock anchor="huggingface_hub.errors.LocalEntryNotFoundError.example">

Example:

```py
>>> from huggingface_hub import hf_hub_download
>>> hf_hub_download('bert-base-cased', '<non-cached-file>',  local_files_only=True)
(...)
huggingface_hub.errors.LocalEntryNotFoundError: Cannot find the requested files in the disk cache and outgoing traffic has been disabled. To enable hf.co look-ups and downloads online, set 'local_files_only' to False.
```

</ExampleCodeBlock>


</div>

#### OfflineModeIsEnabledd[[huggingface_hub.errors.OfflineModeIsEnabled]][[huggingface_hub.errors.OfflineModeIsEnabled]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.OfflineModeIsEnabled</name><anchor>huggingface_hub.errors.OfflineModeIsEnabled</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L36</source><parameters>""</parameters></docstring>
Raised when a request is made but `HF_HUB_OFFLINE=1` is set as environment variable.

</div>

## 원격 측정[[huggingface_hub.utils.send_telemetry]][[huggingface_hub.utils.send_telemetry]]

`huggingface_hub`는 원격 측정 데이터를 보내는 도우미가 포함되어 있습니다. 이 정보는 문제를 디버깅하고 새로운 기능을 우선적으로 처리하는 데 도움이 됩니다. 사용자는 `HF_HUB_DISABLE_TELEMETRY=1` 환경 변수를 설정하여 언제든지 원격 측정 수집을 비활성화할 수 있습니다. 또한 오프라인 모드에서도 (즉, HF_HUB_OFFLINE=1로 설정된 경우) 원격 측정이 비활성화됩니다.

서드 파티 라이브러리의 유지 관리자인 경우, 원격 측정 데이터를 보내는 것은 `send_telemetry`를 호출하는 것만큼 간단합니다. 사용자에게 가능한 영향을 최소화하기 위해 데이터는 별도의 스레드에서 전송됩니다.

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.send_telemetry</name><anchor>huggingface_hub.utils.send_telemetry</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_telemetry.py#L20</source><parameters>[{"name": "topic", "val": ": str"}, {"name": "library_name", "val": ": typing.Optional[str] = None"}, {"name": "library_version", "val": ": typing.Optional[str] = None"}, {"name": "user_agent", "val": ": typing.Union[dict, str, NoneType] = None"}]</parameters><paramsdesc>- **topic** (`str`) --
  Name of the topic that is monitored. The topic is directly used to build the URL. If you want to monitor
  subtopics, just use "/" separation. Examples: "gradio", "transformers/examples",...
- **library_name** (`str`, *optional*) --
  The name of the library that is making the HTTP request. Will be added to the user-agent header.
- **library_version** (`str`, *optional*) --
  The version of the library that is making the HTTP request. Will be added to the user-agent header.
- **user_agent** (`str`, `dict`, *optional*) --
  The user agent info in the form of a dictionary or a single string. It will be completed with information about the installed packages.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sends telemetry that helps track usage of different HF libraries.

This usage data helps us debug issues and prioritize new features. However, we understand that not everyone wants
to share additional information, and we respect your privacy. You can disable telemetry collection by setting the
`HF_HUB_DISABLE_TELEMETRY=1` as environment variable. Telemetry is also disabled in offline mode (i.e. when setting
`HF_HUB_OFFLINE=1`).

Telemetry collection is run in a separate thread to minimize impact for the user.



<ExampleCodeBlock anchor="huggingface_hub.utils.send_telemetry.example">

Example:
```py
>>> from huggingface_hub.utils import send_telemetry

# Send telemetry without library information
>>> send_telemetry("ping")

# Send telemetry to subtopic with library information
>>> send_telemetry("gradio/local_link", library_name="gradio", library_version="3.22.1")

# Send telemetry with additional data
>>> send_telemetry(
...     topic="examples",
...     library_name="transformers",
...     library_version="4.26.0",
...     user_agent={"pipeline": "text_classification", "framework": "flax"},
... )
```

</ExampleCodeBlock>


</div>

## 검증기[[validators]]

`huggingface_hub`에는 메소드 인수를 자동으로 유효성 검사하는 사용자 정의 검증기가 포함되어 있습니다. 이 유효성 검사는 타입 힌트를 검증하는 데 [Pydantic](https://pydantic-docs.helpmanual.io/)의 작업을 참고하여 구현되었지만, 기능은 더 제한적입니다.

### 일반 데코레이터[[generic-decorator]]

[validate_hf_hub_args()](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.utils.validate_hf_hub_args)는 `huggingface_hub`의 네이밍을 따르는 인수를 갖는 메소드를 캡슐화하는 일반적인 데코레이터입니다. 기본적으로 구현된 검증기가 있는 모든 인수가 유효성 검사됩니다.

입력이 유효하지 않은 경우 [HFValidationError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HFValidationError)이 발생합니다. 첫 번째 유효하지 않은 값만 오류를 발생시키고 유효성 검사 프로세스를 중지합니다.

사용법:

```py
>>> from huggingface_hub.utils import validate_hf_hub_args

>>> @validate_hf_hub_args
... def my_cool_method(repo_id: str):
...     print(repo_id)

>>> my_cool_method(repo_id="valid_repo_id")
valid_repo_id

>>> my_cool_method("other..repo..id")
huggingface_hub.utils._validators.HFValidationError: Cannot have -- or .. in repo_id: 'other..repo..id'.

>>> my_cool_method(repo_id="other..repo..id")
huggingface_hub.utils._validators.HFValidationError: Cannot have -- or .. in repo_id: 'other..repo..id'.
```

#### validate_hf_hub_args[[huggingface_hub.utils.validate_hf_hub_args]][[huggingface_hub.utils.validate_hf_hub_args]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.validate_hf_hub_args</name><anchor>huggingface_hub.utils.validate_hf_hub_args</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_validators.py#L42</source><parameters>[{"name": "fn", "val": ": ~CallableT"}]</parameters><raises>- [HFValidationError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HFValidationError) -- 
  If an input is not valid.</raises><raisederrors>[HFValidationError](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.errors.HFValidationError)</raisederrors></docstring>
Validate values received as argument for any public method of `huggingface_hub`.

The goal of this decorator is to harmonize validation of arguments reused
everywhere. By default, all defined validators are tested.

Validators:
- [validate_repo_id()](/docs/huggingface_hub/main/ko/package_reference/utilities#huggingface_hub.utils.validate_repo_id): `repo_id` must be `"repo_name"`
  or `"namespace/repo_name"`. Namespace is a username or an organization.
- `~utils.smoothly_deprecate_legacy_arguments`: Ignore `proxies` when downloading files (should be set globally).

<ExampleCodeBlock anchor="huggingface_hub.utils.validate_hf_hub_args.example">

Example:
```py
>>> from huggingface_hub.utils import validate_hf_hub_args

>>> @validate_hf_hub_args
... def my_cool_method(repo_id: str):
...     print(repo_id)

>>> my_cool_method(repo_id="valid_repo_id")
valid_repo_id

>>> my_cool_method("other..repo..id")
huggingface_hub.utils._validators.HFValidationError: Cannot have -- or .. in repo_id: 'other..repo..id'.

>>> my_cool_method(repo_id="other..repo..id")
huggingface_hub.utils._validators.HFValidationError: Cannot have -- or .. in repo_id: 'other..repo..id'.
```

</ExampleCodeBlock>






</div>

#### HFValidationError[[huggingface_hub.utils.HFValidationError]][[huggingface_hub.errors.HFValidationError]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.errors.HFValidationError</name><anchor>huggingface_hub.errors.HFValidationError</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L153</source><parameters>""</parameters></docstring>
Generic exception thrown by `huggingface_hub` validators.

Inherits from [`ValueError`](https://docs.python.org/3/library/exceptions.html#ValueError).


</div>

### Argument validators[[argument-validators]]

검증기는 개별적으로도 사용할 수 있습니다. 다음은 검증할 수 있는 모든 인수 목록입니다.

#### repo_id[[huggingface_hub.utils.validate_repo_id]][[huggingface_hub.utils.validate_repo_id]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.utils.validate_repo_id</name><anchor>huggingface_hub.utils.validate_repo_id</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/utils/_validators.py#L94</source><parameters>[{"name": "repo_id", "val": ": str"}]</parameters></docstring>
Validate `repo_id` is valid.

This is not meant to replace the proper validation made on the Hub but rather to
avoid local inconsistencies whenever possible (example: passing `repo_type` in the
`repo_id` is forbidden).

Rules:
- Between 1 and 96 characters.
- Either "repo_name" or "namespace/repo_name"
- [a-zA-Z0-9] or "-", "_", "."
- "--" and ".." are forbidden

Valid: `"foo"`, `"foo/bar"`, `"123"`, `"Foo-BAR_foo.bar123"`

Not valid: `"datasets/foo/bar"`, `".repo_id"`, `"foo--bar"`, `"foo.git"`

<ExampleCodeBlock anchor="huggingface_hub.utils.validate_repo_id.example">

Example:
```py
>>> from huggingface_hub.utils import validate_repo_id
>>> validate_repo_id(repo_id="valid_repo_id")
>>> validate_repo_id(repo_id="other..repo..id")
huggingface_hub.utils._validators.HFValidationError: Cannot have -- or .. in repo_id: 'other..repo..id'.
```

</ExampleCodeBlock>

Discussed in https://github.com/huggingface/huggingface_hub/issues/1008.
In moon-landing (internal repository):
- https://github.com/huggingface/moon-landing/blob/main/server/lib/Names.ts#L27
- https://github.com/huggingface/moon-landing/blob/main/server/views/components/NewRepoForm/NewRepoForm.svelte#L138


</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/utilities.md" />