# 웹훅 서버[[webhooks-server]]

웹훅은 MLOps 관련 기능의 기반이 됩니다. 이를 통해 특정 저장소의 새로운 변경 사항을 수신하거나, 관심 있는 특정 사용자/조직에 속한 모든 저장소의 변경 사항을 받아볼 수 있습니다.
Huggingface Hub의 웹훅에 대해 더 자세히 알아보려면 이 [가이드](https://huggingface.co/docs/hub/webhooks)를 읽어보세요.

> [!TIP]
> 웹훅 서버를 설정하고 Space로 배포하는 방법은 이 단계별 [가이드](../guides/webhooks_server)를 확인하세요.

> [!WARNING]
> 이 기능은 실험적인 기능입니다. 본 API는 현재 개선 작업 중이며, 향후 사전 통지 없이 주요 변경 사항이 도입될 수 있음을 의미합니다. `requirements`에서 `huggingface_hub`의 버전을 고정하는 것을 권장합니다. 참고로 실험적 기능을 사용하면 경고가 트리거 됩니다. 이 경고 트리거를 비활성화 시키길 원한다면 환경변수 `HF_HUB_DISABLE_EXPERIMENTAL_WARNING=1`를 설정하세요.

## 서버[[server]]
여기서 서버는 하나의 [Gradio](https://gradio.app/) 앱을 의미합니다. Gradio에는 사용자 또는 사용자에게 지침을 표시하는 UI와 웹훅을 수신하기 위한 API가 있습니다. 웹훅 엔드포인트를 구현하는 것은 함수에 데코레이터를 추가하는 것만큼 간단합니다. 서버를 Space에 배포하기 전에 Gradio 터널을 사용하여 웹훅을 머신으로 리디렉션하여 디버깅할 수 있습니다.

### WebhooksServer[[huggingface_hub.WebhooksServer]][[huggingface_hub.WebhooksServer]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.WebhooksServer</name><anchor>huggingface_hub.WebhooksServer</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_server.py#L43</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **ui** (`gradio.Blocks`, optional) --
  A Gradio UI instance to be used as the Space landing page. If `None`, a UI displaying instructions
  about the configured webhooks is created.
- **webhook_secret** (`str`, optional) --
  A secret key to verify incoming webhook requests. You can set this value to any secret you want as long as
  you also configure it in your [webhooks settings panel](https://huggingface.co/settings/webhooks). You
  can also set this value as the `WEBHOOK_SECRET` environment variable. If no secret is provided, the
  webhook endpoints are opened without any security.</paramsdesc><paramgroups>0</paramgroups></docstring>

The [WebhooksServer()](/docs/huggingface_hub/main/ko/package_reference/webhooks_server#huggingface_hub.WebhooksServer) class lets you create an instance of a Gradio app that can receive Huggingface webhooks.
These webhooks can be registered using the `add_webhook()` decorator. Webhook endpoints are added to
the app as a POST endpoint to the FastAPI router. Once all the webhooks are registered, the `launch` method has to be
called to start the app.

It is recommended to accept [WebhookPayload](/docs/huggingface_hub/main/ko/package_reference/webhooks_server#huggingface_hub.WebhookPayload) as the first argument of the webhook function. It is a Pydantic
model that contains all the information about the webhook event. The data will be parsed automatically for you.

Check out the [webhooks guide](../guides/webhooks_server) for a step-by-step tutorial on how to set up your
WebhooksServer and deploy it on a Space.

> [!WARNING]
> `WebhooksServer` is experimental. Its API is subject to change in the future.

> [!WARNING]
> You must have `gradio` installed to use `WebhooksServer` (`pip install --upgrade gradio`).



<ExampleCodeBlock anchor="huggingface_hub.WebhooksServer.example">

Example:

```python
import gradio as gr
from huggingface_hub import WebhooksServer, WebhookPayload

with gr.Blocks() as ui:
    ...

app = WebhooksServer(ui=ui, webhook_secret="my_secret_key")

@app.add_webhook("/say_hello")
async def hello(payload: WebhookPayload):
    return {"message": "hello"}

app.launch()
```

</ExampleCodeBlock>


</div>

### @webhook_endpoint[[huggingface_hub.webhook_endpoint]][[huggingface_hub.webhook_endpoint]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>huggingface_hub.webhook_endpoint</name><anchor>huggingface_hub.webhook_endpoint</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_server.py#L226</source><parameters>[{"name": "path", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **path** (`str`, optional) --
  The URL path to register the webhook function. If not provided, the function name will be used as the path.
  In any case, all webhooks are registered under `/webhooks`.</paramsdesc><paramgroups>0</paramgroups></docstring>
Decorator to start a [WebhooksServer()](/docs/huggingface_hub/main/ko/package_reference/webhooks_server#huggingface_hub.WebhooksServer) and register the decorated function as a webhook endpoint.

This is a helper to get started quickly. If you need more flexibility (custom landing page or webhook secret),
you can use [WebhooksServer()](/docs/huggingface_hub/main/ko/package_reference/webhooks_server#huggingface_hub.WebhooksServer) directly. You can register multiple webhook endpoints (to the same server) by using
this decorator multiple times.

Check out the [webhooks guide](../guides/webhooks_server) for a step-by-step tutorial on how to set up your
server and deploy it on a Space.

> [!WARNING]
> `webhook_endpoint` is experimental. Its API is subject to change in the future.

> [!WARNING]
> You must have `gradio` installed to use `webhook_endpoint` (`pip install --upgrade gradio`).



Examples:
The default usage is to register a function as a webhook endpoint. The function name will be used as the path.
The server will be started automatically at exit (i.e. at the end of the script).

<ExampleCodeBlock anchor="huggingface_hub.webhook_endpoint.example">

```python
from huggingface_hub import webhook_endpoint, WebhookPayload

@webhook_endpoint
async def trigger_training(payload: WebhookPayload):
    if payload.repo.type == "dataset" and payload.event.action == "update":
        # Trigger a training job if a dataset is updated
        ...

# Server is automatically started at the end of the script.
```

</ExampleCodeBlock>

Advanced usage: register a function as a webhook endpoint and start the server manually. This is useful if you
are running it in a notebook.

<ExampleCodeBlock anchor="huggingface_hub.webhook_endpoint.example-2">

```python
from huggingface_hub import webhook_endpoint, WebhookPayload

@webhook_endpoint
async def trigger_training(payload: WebhookPayload):
    if payload.repo.type == "dataset" and payload.event.action == "update":
        # Trigger a training job if a dataset is updated
        ...

# Start the server manually
trigger_training.launch()
```

</ExampleCodeBlock>


</div>

## 페이로드[[huggingface_hub.WebhookPayload]][[huggingface_hub.WebhookPayload]]

[WebhookPayload](/docs/huggingface_hub/main/ko/package_reference/webhooks_server#huggingface_hub.WebhookPayload)는 웹훅의 페이로드를 포함하는 기본 데이터 구조입니다. 이것은 `pydantic` 클래스로서 FastAPI에서 매우 쉽게 사용할 수 있습니다. 즉 WebhookPayload를 웹후크 엔드포인트에 매개변수로 전달하면 자동으로 유효성이 검사되고 파이썬 객체로 파싱됩니다.

웹훅 페이로드에 대한 자세한 사항은 이 [가이드](https://huggingface.co/docs/hub/webhooks#webhook-payloads)를 참고하세요.

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayload</name><anchor>huggingface_hub.WebhookPayload</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L130</source><parameters>[{"name": "event", "val": ": WebhookPayloadEvent"}, {"name": "repo", "val": ": WebhookPayloadRepo"}, {"name": "discussion", "val": ": typing.Optional[huggingface_hub._webhooks_payload.WebhookPayloadDiscussion] = None"}, {"name": "comment", "val": ": typing.Optional[huggingface_hub._webhooks_payload.WebhookPayloadComment] = None"}, {"name": "webhook", "val": ": WebhookPayloadWebhook"}, {"name": "movedTo", "val": ": typing.Optional[huggingface_hub._webhooks_payload.WebhookPayloadMovedTo] = None"}, {"name": "updatedRefs", "val": ": typing.Optional[list[huggingface_hub._webhooks_payload.WebhookPayloadUpdatedRef]] = None"}]</parameters></docstring>


</div>

### WebhookPayload[[huggingface_hub.WebhookPayload]][[huggingface_hub.WebhookPayload]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayload</name><anchor>huggingface_hub.WebhookPayload</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L130</source><parameters>[{"name": "event", "val": ": WebhookPayloadEvent"}, {"name": "repo", "val": ": WebhookPayloadRepo"}, {"name": "discussion", "val": ": typing.Optional[huggingface_hub._webhooks_payload.WebhookPayloadDiscussion] = None"}, {"name": "comment", "val": ": typing.Optional[huggingface_hub._webhooks_payload.WebhookPayloadComment] = None"}, {"name": "webhook", "val": ": WebhookPayloadWebhook"}, {"name": "movedTo", "val": ": typing.Optional[huggingface_hub._webhooks_payload.WebhookPayloadMovedTo] = None"}, {"name": "updatedRefs", "val": ": typing.Optional[list[huggingface_hub._webhooks_payload.WebhookPayloadUpdatedRef]] = None"}]</parameters></docstring>


</div>

### WebhookPayloadComment[[huggingface_hub.WebhookPayloadComment]][[huggingface_hub.WebhookPayloadComment]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadComment</name><anchor>huggingface_hub.WebhookPayloadComment</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L95</source><parameters>[{"name": "id", "val": ": str"}, {"name": "author", "val": ": ObjectId"}, {"name": "hidden", "val": ": bool"}, {"name": "content", "val": ": typing.Optional[str] = None"}, {"name": "url", "val": ": WebhookPayloadUrl"}]</parameters></docstring>


</div>

### WebhookPayloadDiscussion[[huggingface_hub.WebhookPayloadDiscussion]][[huggingface_hub.WebhookPayloadDiscussion]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadDiscussion</name><anchor>huggingface_hub.WebhookPayloadDiscussion</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L102</source><parameters>[{"name": "id", "val": ": str"}, {"name": "num", "val": ": int"}, {"name": "author", "val": ": ObjectId"}, {"name": "url", "val": ": WebhookPayloadUrl"}, {"name": "title", "val": ": str"}, {"name": "isPullRequest", "val": ": bool"}, {"name": "status", "val": ": typing.Literal['closed', 'draft', 'open', 'merged']"}, {"name": "changes", "val": ": typing.Optional[huggingface_hub._webhooks_payload.WebhookPayloadDiscussionChanges] = None"}, {"name": "pinned", "val": ": typing.Optional[bool] = None"}]</parameters></docstring>


</div>

### WebhookPayloadDiscussionChanges[[huggingface_hub.WebhookPayloadDiscussionChanges]][[huggingface_hub.WebhookPayloadDiscussionChanges]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadDiscussionChanges</name><anchor>huggingface_hub.WebhookPayloadDiscussionChanges</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L90</source><parameters>[{"name": "base", "val": ": str"}, {"name": "mergeCommitId", "val": ": typing.Optional[str] = None"}]</parameters></docstring>


</div>

### WebhookPayloadEvent[[huggingface_hub.WebhookPayloadEvent]][[huggingface_hub.WebhookPayloadEvent]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadEvent</name><anchor>huggingface_hub.WebhookPayloadEvent</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L85</source><parameters>[{"name": "action", "val": ": typing.Literal['create', 'delete', 'move', 'update']"}, {"name": "scope", "val": ": str"}]</parameters></docstring>


</div>

### WebhookPayloadMovedTo[[huggingface_hub.WebhookPayloadMovedTo]][[huggingface_hub.WebhookPayloadMovedTo]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadMovedTo</name><anchor>huggingface_hub.WebhookPayloadMovedTo</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L76</source><parameters>[{"name": "name", "val": ": str"}, {"name": "owner", "val": ": ObjectId"}]</parameters></docstring>


</div>

### WebhookPayloadRepo[[huggingface_hub.WebhookPayloadRepo]][[huggingface_hub.WebhookPayloadRepo]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadRepo</name><anchor>huggingface_hub.WebhookPayloadRepo</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L113</source><parameters>[{"name": "id", "val": ": str"}, {"name": "owner", "val": ": ObjectId"}, {"name": "head_sha", "val": ": typing.Optional[str] = None"}, {"name": "name", "val": ": str"}, {"name": "private", "val": ": bool"}, {"name": "subdomain", "val": ": typing.Optional[str] = None"}, {"name": "tags", "val": ": typing.Optional[list[str]] = None"}, {"name": "type", "val": ": typing.Literal['dataset', 'model', 'space']"}, {"name": "url", "val": ": WebhookPayloadUrl"}]</parameters></docstring>


</div>

### WebhookPayloadUrl[[huggingface_hub.WebhookPayloadUrl]][[huggingface_hub.WebhookPayloadUrl]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadUrl</name><anchor>huggingface_hub.WebhookPayloadUrl</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L71</source><parameters>[{"name": "web", "val": ": str"}, {"name": "api", "val": ": typing.Optional[str] = None"}]</parameters></docstring>


</div>

### WebhookPayloadWebhook[[huggingface_hub.WebhookPayloadWebhook]][[huggingface_hub.WebhookPayloadWebhook]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class huggingface_hub.WebhookPayloadWebhook</name><anchor>huggingface_hub.WebhookPayloadWebhook</anchor><source>https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_webhooks_payload.py#L81</source><parameters>[{"name": "id", "val": ": str"}, {"name": "version", "val": ": typing.Literal[3]"}]</parameters></docstring>


</div>

<EditOnGithub source="https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/webhooks_server.md" />