import{s as ie,n as me,o as de}from"../chunks/scheduler.12fdeddc.js";import{S as pe,i as oe,g as h,s as a,r as i,A as re,h as M,f as s,c as n,j as ae,u as m,x as u,k as ne,y as he,a as l,v as d,d as p,t as o,w as r}from"../chunks/index.88dae322.js";import{C as y}from"../chunks/CodeBlock.8e54a086.js";import{H as g,E as Me}from"../chunks/getInferenceSnippets.06fe9bcd.js";function ue(Lt){let w,lt,et,at,b,nt,c,St='<a href="https://apple.github.io/embedding-atlas/" rel="nofollow">Embedding Atlas</a> is an interactive visualization tool for exploring large embedding spaces. It enables you to visualize, cross-filter, and search embeddings alongside associated metadata, helping you understand patterns and relationships in high-dimensional data. All computation happens in your computer, ensuring your data remains private and secure.',it,f,mt,J,Nt="<li><strong>Interactive exploration</strong>: Navigate through millions of embeddings with smooth, responsive visualization</li> <li><strong>Browser-based computation</strong>: Compute embeddings and projections locally without sending data to external servers</li> <li><strong>Cross-filtering</strong>: Link and filter data across multiple metadata columns</li> <li><strong>Search capabilities</strong>: Find similar data points to a given query or existing item</li> <li><strong>Multiple integration options</strong>: Use via command line, Jupyter widgets, or web interface</li>",dt,$,pt,T,At="First, install Embedding Atlas:",ot,Z,rt,U,zt='If you plan to load private datasets from the Hugging Face Hub, you’ll also need to <a href="/docs/huggingface_hub/quick-start#login">login with your Hugging Face account</a>:',ht,j,Mt,G,ut,I,_t="Embedding Atlas provides seamless integration with the Hugging Face Hub, allowing you to visualize embeddings from any dataset directly.",gt,W,yt,R,qt="The simplest way to visualize a Hugging Face dataset is through the command line interface. Try it with the IMDB dataset:",wt,C,bt,k,Pt="For your own datasets, use the same pattern:",ct,X,ft,B,Jt,x,Dt="You can also use Embedding Atlas in Jupyter notebooks for interactive exploration:",$t,F,Tt,E,Kt="For your own datasets:",Zt,v,Ut,Y,jt,V,Ot="If you have datasets with pre-computed embeddings, you can load them directly:",Gt,Q,It,H,Wt,L,te='Embedding Atlas uses <a href="https://huggingface.co/sentence-transformers" rel="nofollow">SentenceTransformers</a> by default but supports custom embedding models:',Rt,S,Ct,N,kt,A,ee="Fine-tune the dimensionality reduction for your specific use case:",Xt,z,Bt,_,xt,q,Ft,P,se="Visualize and explore text corpora to identify clusters, outliers, and patterns:",Et,D,vt,K,Yt,O,le='<li><a href="https://github.com/apple/embedding-atlas" rel="nofollow">Embedding Atlas GitHub Repository</a></li> <li><a href="https://apple.github.io/embedding-atlas/" rel="nofollow">Official Documentation</a></li> <li><a href="https://apple.github.io/embedding-atlas/upload/" rel="nofollow">Interactive Demo</a></li> <li><a href="https://apple.github.io/embedding-atlas/tool.html" rel="nofollow">Command Line Reference</a></li>',Vt,tt,Qt,st,Ht;return b=new g({props:{title:"Embedding Atlas",local:"embedding-atlas",headingTag:"h1"}}),f=new g({props:{title:"Key Features",local:"key-features",headingTag:"h2"}}),$=new g({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),Z=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGVtYmVkZGluZy1hdGxhcw==",highlighted:"pip install embedding-atlas",wrap:!1}}),j=new y({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:"hf auth login",wrap:!1}}),G=new g({props:{title:"Loading Datasets from the Hub",local:"loading-datasets-from-the-hub",headingTag:"h2"}}),W=new g({props:{title:"Using the Command Line",local:"using-the-command-line",headingTag:"h3"}}),C=new y({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMElNREIlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMEh1YiUwQWVtYmVkZGluZy1hdGxhcyUyMHN0YW5mb3JkbmxwJTJGaW1kYiUwQSUwQSUyMyUyMFNwZWNpZnklMjB0aGUlMjB0ZXh0JTIwY29sdW1uJTIwZm9yJTIwZW1iZWRkaW5nJTIwY29tcHV0YXRpb24lMEFlbWJlZGRpbmctYXRsYXMlMjBzdGFuZm9yZG5scCUyRmltZGIlMjAtLXRleHQlMjAlMjJ0ZXh0JTIyJTBBJTBBJTIzJTIwTG9hZCUyMG9ubHklMjBhJTIwc2FtcGxlJTIwZm9yJTIwZmFzdGVyJTIwZXhwbG9yYXRpb24lMEFlbWJlZGRpbmctYXRsYXMlMjBzdGFuZm9yZG5scCUyRmltZGIlMjAtLXRleHQlMjAlMjJ0ZXh0JTIyJTIwLS1zYW1wbGUlMjA1MDAw",highlighted:`<span class="hljs-comment"># Load the IMDB dataset from the Hub</span>
embedding-atlas stanfordnlp/imdb

<span class="hljs-comment"># Specify the text column for embedding computation</span>
embedding-atlas stanfordnlp/imdb --text <span class="hljs-string">&quot;text&quot;</span>

<span class="hljs-comment"># Load only a sample for faster exploration</span>
embedding-atlas stanfordnlp/imdb --text <span class="hljs-string">&quot;text&quot;</span> --sample 5000`,wrap:!1}}),X=new y({props:{code:"JTIzJTIwTG9hZCUyMHlvdXIlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMEh1YiUwQWVtYmVkZGluZy1hdGxhcyUyMHVzZXJuYW1lJTJGZGF0YXNldC1uYW1lJTBBJTBBJTIzJTIwTG9hZCUyMG11bHRpcGxlJTIwc3BsaXRzJTBBZW1iZWRkaW5nLWF0bGFzJTIwdXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjAtLXNwbGl0JTIwdHJhaW4lMjAtLXNwbGl0JTIwdGVzdCUwQSUwQSUyMyUyMFNwZWNpZnklMjBjdXN0b20lMjB0ZXh0JTIwY29sdW1uJTBBZW1iZWRkaW5nLWF0bGFzJTIwdXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjAtLXRleHQlMjAlMjJjb250ZW50JTIy",highlighted:`<span class="hljs-comment"># Load your dataset from the Hub</span>
embedding-atlas username/dataset-name

<span class="hljs-comment"># Load multiple splits</span>
embedding-atlas username/dataset-name --<span class="hljs-built_in">split</span> train --<span class="hljs-built_in">split</span> <span class="hljs-built_in">test</span>

<span class="hljs-comment"># Specify custom text column</span>
embedding-atlas username/dataset-name --text <span class="hljs-string">&quot;content&quot;</span>`,wrap:!1}}),B=new g({props:{title:"Using Python and Jupyter",local:"using-python-and-jupyter",headingTag:"h3"}}),F=new y({props:{code:"ZnJvbSUyMGVtYmVkZGluZ19hdGxhcy53aWRnZXQlMjBpbXBvcnQlMjBFbWJlZGRpbmdBdGxhc1dpZGdldCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwSU1EQiUyMGRhdGFzZXQlMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lNUIlM0E1MDAwJTVEJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjB0byUyMHBhbmRhcyUyMERhdGFGcmFtZSUwQWRmJTIwJTNEJTIwZGF0YXNldC50b19wYW5kYXMoKSUwQSUwQSUyMyUyMENyZWF0ZSUyMGludGVyYWN0aXZlJTIwd2lkZ2V0JTBBd2lkZ2V0JTIwJTNEJTIwRW1iZWRkaW5nQXRsYXNXaWRnZXQoZGYpJTBBd2lkZ2V0",highlighted:`<span class="hljs-keyword">from</span> embedding_atlas.widget <span class="hljs-keyword">import</span> EmbeddingAtlasWidget
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># Load the IMDB dataset from Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train[:5000]&quot;</span>)

<span class="hljs-comment"># Convert to pandas DataFrame</span>
df = dataset.to_pandas()

<span class="hljs-comment"># Create interactive widget</span>
widget = EmbeddingAtlasWidget(df)
widget`,wrap:!1}}),v=new y({props:{code:"ZnJvbSUyMGVtYmVkZGluZ19hdGxhcy53aWRnZXQlMjBpbXBvcnQlMjBFbWJlZGRpbmdBdGxhc1dpZGdldCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEElMjMlMjBMb2FkJTIweW91ciUyMGRhdGFzZXQlMjBmcm9tJTIwdGhlJTIwSHViJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ1c2VybmFtZSUyRmRhdGFzZXQtbmFtZSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGYlMjAlM0QlMjBkYXRhc2V0LnRvX3BhbmRhcygpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwaW50ZXJhY3RpdmUlMjB3aWRnZXQlMEF3aWRnZXQlMjAlM0QlMjBFbWJlZGRpbmdBdGxhc1dpZGdldChkZiklMEF3aWRnZXQ=",highlighted:`<span class="hljs-keyword">from</span> embedding_atlas.widget <span class="hljs-keyword">import</span> EmbeddingAtlasWidget
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># Load your dataset from the Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;username/dataset-name&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
df = dataset.to_pandas()

<span class="hljs-comment"># Create interactive widget</span>
widget = EmbeddingAtlasWidget(df)
widget`,wrap:!1}}),Y=new g({props:{title:"Working with Pre-computed Embeddings",local:"working-with-pre-computed-embeddings",headingTag:"h3"}}),Q=new y({props:{code:"JTIzJTIwTG9hZCUyMGRhdGFzZXQlMjB3aXRoJTIwcHJlLWNvbXB1dGVkJTIwY29vcmRpbmF0ZXMlMEFlbWJlZGRpbmctYXRsYXMlMjB1c2VybmFtZSUyRmRhdGFzZXQtbmFtZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0teCUyMCUyMmVtYmVkZGluZ194JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS15JTIwJTIyZW1iZWRkaW5nX3klMjIlMEElMEElMjMlMjBMb2FkJTIwd2l0aCUyMHByZS1jb21wdXRlZCUyMG5lYXJlc3QlMjBuZWlnaGJvcnMlMEFlbWJlZGRpbmctYXRsYXMlMjB1c2VybmFtZSUyRmRhdGFzZXQtbmFtZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbmVpZ2hib3JzJTIwJTIybmVpZ2hib3JzX2NvbHVtbiUyMg==",highlighted:`<span class="hljs-comment"># Load dataset with pre-computed coordinates</span>
embedding-atlas username/dataset-name \\
    --x <span class="hljs-string">&quot;embedding_x&quot;</span> \\
    --y <span class="hljs-string">&quot;embedding_y&quot;</span>

<span class="hljs-comment"># Load with pre-computed nearest neighbors</span>
embedding-atlas username/dataset-name \\
    --neighbors <span class="hljs-string">&quot;neighbors_column&quot;</span>`,wrap:!1}}),H=new g({props:{title:"Customizing Embeddings",local:"customizing-embeddings",headingTag:"h2"}}),S=new y({props:{code:"JTIzJTIwVXNlJTIwYSUyMHNwZWNpZmljJTIwZW1iZWRkaW5nJTIwbW9kZWwlMEFlbWJlZGRpbmctYXRsYXMlMjBzdGFuZm9yZG5scCUyRmltZGIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRleHQlMjAlMjJ0ZXh0JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbCUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmFsbC1NaW5pTE0tTDYtdjIlMjIlMEElMEElMjMlMjBGb3IlMjBtb2RlbHMlMjByZXF1aXJpbmclMjByZW1vdGUlMjBjb2RlJTIwZXhlY3V0aW9uJTBBZW1iZWRkaW5nLWF0bGFzJTIwdXNlcm5hbWUlMkZkYXRhc2V0LW5hbWUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsJTIwJTIyY3VzdG9tJTJGbW9kZWwlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRydXN0LXJlbW90ZS1jb2Rl",highlighted:`<span class="hljs-comment"># Use a specific embedding model</span>
embedding-atlas stanfordnlp/imdb \\
    --text <span class="hljs-string">&quot;text&quot;</span> \\
    --model <span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>

<span class="hljs-comment"># For models requiring remote code execution</span>
embedding-atlas username/dataset-name \\
    --model <span class="hljs-string">&quot;custom/model&quot;</span> \\
    --trust-remote-code`,wrap:!1}}),N=new g({props:{title:"UMAP Projection Parameters",local:"umap-projection-parameters",headingTag:"h3"}}),z=new y({props:{code:"ZW1iZWRkaW5nLWF0bGFzJTIwc3RhbmZvcmRubHAlMkZpbWRiJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZXh0JTIwJTIydGV4dCUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdW1hcC1uLW5laWdoYm9ycyUyMDMwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS11bWFwLW1pbi1kaXN0JTIwMC4xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS11bWFwLW1ldHJpYyUyMCUyMmNvc2luZSUyMg==",highlighted:`embedding-atlas stanfordnlp/imdb \\
    --text <span class="hljs-string">&quot;text&quot;</span> \\
    --umap-n-neighbors 30 \\
    --umap-min-dist 0.1 \\
    --umap-metric <span class="hljs-string">&quot;cosine&quot;</span>`,wrap:!1}}),_=new g({props:{title:"Use Cases",local:"use-cases",headingTag:"h2"}}),q=new g({props:{title:"Exploring Text Datasets",local:"exploring-text-datasets",headingTag:"h3"}}),D=new y({props:{code:"ZnJvbSUyMGVtYmVkZGluZ19hdGxhcy53aWRnZXQlMjBpbXBvcnQlMjBFbWJlZGRpbmdBdGxhc1dpZGdldCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHBhbmRhcyUyMGFzJTIwcGQlMEElMEElMjMlMjBMb2FkJTIwYSUyMHRleHQlMjBjbGFzc2lmaWNhdGlvbiUyMGRhdGFzZXQlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lNUIlM0E1MDAwJTVEJTIyKSUwQWRmJTIwJTNEJTIwZGF0YXNldC50b19wYW5kYXMoKSUwQSUwQSUyMyUyMFZpc3VhbGl6ZSUyMHdpdGglMjBtZXRhZGF0YSUwQXdpZGdldCUyMCUzRCUyMEVtYmVkZGluZ0F0bGFzV2lkZ2V0KGRmKSUwQXdpZGdldA==",highlighted:`<span class="hljs-keyword">from</span> embedding_atlas.widget <span class="hljs-keyword">import</span> EmbeddingAtlasWidget
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># Load a text classification dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train[:5000]&quot;</span>)
df = dataset.to_pandas()

<span class="hljs-comment"># Visualize with metadata</span>
widget = EmbeddingAtlasWidget(df)
widget`,wrap:!1}}),K=new g({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),tt=new Me({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-embedding-atlas.md"}}),{c(){w=h("meta"),lt=a(),et=h("p"),at=a(),i(b.$$.fragment),nt=a(),c=h("p"),c.innerHTML=St,it=a(),i(f.$$.fragment),mt=a(),J=h("ul"),J.innerHTML=Nt,dt=a(),i($.$$.fragment),pt=a(),T=h("p"),T.textContent=At,ot=a(),i(Z.$$.fragment),rt=a(),U=h("p"),U.innerHTML=zt,ht=a(),i(j.$$.fragment),Mt=a(),i(G.$$.fragment),ut=a(),I=h("p"),I.textContent=_t,gt=a(),i(W.$$.fragment),yt=a(),R=h("p"),R.textContent=qt,wt=a(),i(C.$$.fragment),bt=a(),k=h("p"),k.textContent=Pt,ct=a(),i(X.$$.fragment),ft=a(),i(B.$$.fragment),Jt=a(),x=h("p"),x.textContent=Dt,$t=a(),i(F.$$.fragment),Tt=a(),E=h("p"),E.textContent=Kt,Zt=a(),i(v.$$.fragment),Ut=a(),i(Y.$$.fragment),jt=a(),V=h("p"),V.textContent=Ot,Gt=a(),i(Q.$$.fragment),It=a(),i(H.$$.fragment),Wt=a(),L=h("p"),L.innerHTML=te,Rt=a(),i(S.$$.fragment),Ct=a(),i(N.$$.fragment),kt=a(),A=h("p"),A.textContent=ee,Xt=a(),i(z.$$.fragment),Bt=a(),i(_.$$.fragment),xt=a(),i(q.$$.fragment),Ft=a(),P=h("p"),P.textContent=se,Et=a(),i(D.$$.fragment),vt=a(),i(K.$$.fragment),Yt=a(),O=h("ul"),O.innerHTML=le,Vt=a(),i(tt.$$.fragment),Qt=a(),st=h("p"),this.h()},l(t){const e=re("svelte-u9bgzb",document.head);w=M(e,"META",{name:!0,content:!0}),e.forEach(s),lt=n(t),et=M(t,"P",{}),ae(et).forEach(s),at=n(t),m(b.$$.fragment,t),nt=n(t),c=M(t,"P",{"data-svelte-h":!0}),u(c)!=="svelte-mrn9r"&&(c.innerHTML=St),it=n(t),m(f.$$.fragment,t),mt=n(t),J=M(t,"UL",{"data-svelte-h":!0}),u(J)!=="svelte-73za94"&&(J.innerHTML=Nt),dt=n(t),m($.$$.fragment,t),pt=n(t),T=M(t,"P",{"data-svelte-h":!0}),u(T)!=="svelte-1joi0rv"&&(T.textContent=At),ot=n(t),m(Z.$$.fragment,t),rt=n(t),U=M(t,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1egbv1g"&&(U.innerHTML=zt),ht=n(t),m(j.$$.fragment,t),Mt=n(t),m(G.$$.fragment,t),ut=n(t),I=M(t,"P",{"data-svelte-h":!0}),u(I)!=="svelte-9xii3i"&&(I.textContent=_t),gt=n(t),m(W.$$.fragment,t),yt=n(t),R=M(t,"P",{"data-svelte-h":!0}),u(R)!=="svelte-j25ai4"&&(R.textContent=qt),wt=n(t),m(C.$$.fragment,t),bt=n(t),k=M(t,"P",{"data-svelte-h":!0}),u(k)!=="svelte-13a5k6t"&&(k.textContent=Pt),ct=n(t),m(X.$$.fragment,t),ft=n(t),m(B.$$.fragment,t),Jt=n(t),x=M(t,"P",{"data-svelte-h":!0}),u(x)!=="svelte-v5uk2v"&&(x.textContent=Dt),$t=n(t),m(F.$$.fragment,t),Tt=n(t),E=M(t,"P",{"data-svelte-h":!0}),u(E)!=="svelte-ns27sh"&&(E.textContent=Kt),Zt=n(t),m(v.$$.fragment,t),Ut=n(t),m(Y.$$.fragment,t),jt=n(t),V=M(t,"P",{"data-svelte-h":!0}),u(V)!=="svelte-8tnn7v"&&(V.textContent=Ot),Gt=n(t),m(Q.$$.fragment,t),It=n(t),m(H.$$.fragment,t),Wt=n(t),L=M(t,"P",{"data-svelte-h":!0}),u(L)!=="svelte-179n53n"&&(L.innerHTML=te),Rt=n(t),m(S.$$.fragment,t),Ct=n(t),m(N.$$.fragment,t),kt=n(t),A=M(t,"P",{"data-svelte-h":!0}),u(A)!=="svelte-1rifzsh"&&(A.textContent=ee),Xt=n(t),m(z.$$.fragment,t),Bt=n(t),m(_.$$.fragment,t),xt=n(t),m(q.$$.fragment,t),Ft=n(t),P=M(t,"P",{"data-svelte-h":!0}),u(P)!=="svelte-13e91m8"&&(P.textContent=se),Et=n(t),m(D.$$.fragment,t),vt=n(t),m(K.$$.fragment,t),Yt=n(t),O=M(t,"UL",{"data-svelte-h":!0}),u(O)!=="svelte-r7p0k9"&&(O.innerHTML=le),Vt=n(t),m(tt.$$.fragment,t),Qt=n(t),st=M(t,"P",{}),ae(st).forEach(s),this.h()},h(){ne(w,"name","hf:doc:metadata"),ne(w,"content",ge)},m(t,e){he(document.head,w),l(t,lt,e),l(t,et,e),l(t,at,e),d(b,t,e),l(t,nt,e),l(t,c,e),l(t,it,e),d(f,t,e),l(t,mt,e),l(t,J,e),l(t,dt,e),d($,t,e),l(t,pt,e),l(t,T,e),l(t,ot,e),d(Z,t,e),l(t,rt,e),l(t,U,e),l(t,ht,e),d(j,t,e),l(t,Mt,e),d(G,t,e),l(t,ut,e),l(t,I,e),l(t,gt,e),d(W,t,e),l(t,yt,e),l(t,R,e),l(t,wt,e),d(C,t,e),l(t,bt,e),l(t,k,e),l(t,ct,e),d(X,t,e),l(t,ft,e),d(B,t,e),l(t,Jt,e),l(t,x,e),l(t,$t,e),d(F,t,e),l(t,Tt,e),l(t,E,e),l(t,Zt,e),d(v,t,e),l(t,Ut,e),d(Y,t,e),l(t,jt,e),l(t,V,e),l(t,Gt,e),d(Q,t,e),l(t,It,e),d(H,t,e),l(t,Wt,e),l(t,L,e),l(t,Rt,e),d(S,t,e),l(t,Ct,e),d(N,t,e),l(t,kt,e),l(t,A,e),l(t,Xt,e),d(z,t,e),l(t,Bt,e),d(_,t,e),l(t,xt,e),d(q,t,e),l(t,Ft,e),l(t,P,e),l(t,Et,e),d(D,t,e),l(t,vt,e),d(K,t,e),l(t,Yt,e),l(t,O,e),l(t,Vt,e),d(tt,t,e),l(t,Qt,e),l(t,st,e),Ht=!0},p:me,i(t){Ht||(p(b.$$.fragment,t),p(f.$$.fragment,t),p($.$$.fragment,t),p(Z.$$.fragment,t),p(j.$$.fragment,t),p(G.$$.fragment,t),p(W.$$.fragment,t),p(C.$$.fragment,t),p(X.$$.fragment,t),p(B.$$.fragment,t),p(F.$$.fragment,t),p(v.$$.fragment,t),p(Y.$$.fragment,t),p(Q.$$.fragment,t),p(H.$$.fragment,t),p(S.$$.fragment,t),p(N.$$.fragment,t),p(z.$$.fragment,t),p(_.$$.fragment,t),p(q.$$.fragment,t),p(D.$$.fragment,t),p(K.$$.fragment,t),p(tt.$$.fragment,t),Ht=!0)},o(t){o(b.$$.fragment,t),o(f.$$.fragment,t),o($.$$.fragment,t),o(Z.$$.fragment,t),o(j.$$.fragment,t),o(G.$$.fragment,t),o(W.$$.fragment,t),o(C.$$.fragment,t),o(X.$$.fragment,t),o(B.$$.fragment,t),o(F.$$.fragment,t),o(v.$$.fragment,t),o(Y.$$.fragment,t),o(Q.$$.fragment,t),o(H.$$.fragment,t),o(S.$$.fragment,t),o(N.$$.fragment,t),o(z.$$.fragment,t),o(_.$$.fragment,t),o(q.$$.fragment,t),o(D.$$.fragment,t),o(K.$$.fragment,t),o(tt.$$.fragment,t),Ht=!1},d(t){t&&(s(lt),s(et),s(at),s(nt),s(c),s(it),s(mt),s(J),s(dt),s(pt),s(T),s(ot),s(rt),s(U),s(ht),s(Mt),s(ut),s(I),s(gt),s(yt),s(R),s(wt),s(bt),s(k),s(ct),s(ft),s(Jt),s(x),s($t),s(Tt),s(E),s(Zt),s(Ut),s(jt),s(V),s(Gt),s(It),s(Wt),s(L),s(Rt),s(Ct),s(kt),s(A),s(Xt),s(Bt),s(xt),s(Ft),s(P),s(Et),s(vt),s(Yt),s(O),s(Vt),s(Qt),s(st)),s(w),r(b,t),r(f,t),r($,t),r(Z,t),r(j,t),r(G,t),r(W,t),r(C,t),r(X,t),r(B,t),r(F,t),r(v,t),r(Y,t),r(Q,t),r(H,t),r(S,t),r(N,t),r(z,t),r(_,t),r(q,t),r(D,t),r(K,t),r(tt,t)}}}const ge='{"title":"Embedding Atlas","local":"embedding-atlas","sections":[{"title":"Key Features","local":"key-features","sections":[],"depth":2},{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Loading Datasets from the Hub","local":"loading-datasets-from-the-hub","sections":[{"title":"Using the Command Line","local":"using-the-command-line","sections":[],"depth":3},{"title":"Using Python and Jupyter","local":"using-python-and-jupyter","sections":[],"depth":3},{"title":"Working with Pre-computed Embeddings","local":"working-with-pre-computed-embeddings","sections":[],"depth":3}],"depth":2},{"title":"Customizing Embeddings","local":"customizing-embeddings","sections":[{"title":"UMAP Projection Parameters","local":"umap-projection-parameters","sections":[],"depth":3}],"depth":2},{"title":"Use Cases","local":"use-cases","sections":[{"title":"Exploring Text Datasets","local":"exploring-text-datasets","sections":[],"depth":3}],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function ye(Lt){return de(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Je extends pe{constructor(w){super(),oe(this,w,ye,ue,ie,{})}}export{Je as component};
