import{s as Xe,o as _e,n as Be}from"../chunks/scheduler.12fdeddc.js";import{S as Ge,i as ke,g as p,s as l,r,A as qe,h as i,f as t,c as n,j as Ze,u as o,x as c,k as $e,y as Ye,a as s,v as m,d as h,t as d,w as u}from"../chunks/index.88dae322.js";import{T as Ce}from"../chunks/Tip.64e66512.js";import{C as w}from"../chunks/CodeBlock.8e54a086.js";import{H as oa,E as We}from"../chunks/getInferenceSnippets.06fe9bcd.js";function Re(da){let y,f=`Content defined chunking (CDC) makes the Parquet writer chunk the data pages in a way that makes duplicate data chunked and compressed identically.
Without CDC, the pages are arbitrarily chunked and therefore duplicate data are impossible to detect because of compression.
Thanks to CDC, Parquet uploads and downloads from Hugging Face are faster, since duplicate data are uploaded or downloaded only once.`;return{c(){y=p("p"),y.textContent=f},l(M){y=i(M,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1lm4lrw"&&(y.textContent=f)},m(M,ma){s(M,y,ma)},p:Be,d(M){M&&t(y)}}}function Ve(da){let y,f,M,ma,T,ua,g,le=`<a href="https://github.com/apache/arrow" rel="nofollow">Arrow</a> is a columnar format and a toolbox for fast data interchange and in-memory analytics.
Since PyArrow supports <a href="https://filesystem-spec.readthedocs.io" rel="nofollow">fsspec</a> to read and write remote data, you can use the Hugging Face paths (<a href="/docs/huggingface_hub/guides/hf_file_system#integrations"><code>hf://</code></a>) to read and write data on the Hub.
It is especially useful for <a href="https://parquet.apache.org/" rel="nofollow">Parquet</a> data, since Parquet is the most common file format on Hugging Face.
Indeed, Parquet is particularly efficient thanks to its structure, typing, metadata and compression.`,ca,j,ya,b,ne="You can load data from local files or from remote storage like Hugging Face Datasets. PyArrow supports many formats including CSV, JSON and more importantly Parquet:",wa,U,Ma,I,pe='To load a file from Hugging Face, the path needs to start with <code>hf://</code>. For example, the path to the <a href="https://huggingface.co/datasets/stanfordnlp/imdb" rel="nofollow">stanfordnlp/imdb</a> dataset repository is <code>hf://datasets/stanfordnlp/imdb</code>. The dataset on Hugging Face contains multiple Parquet files. The Parquet file format is designed to make reading and writing data frames efficient, and to make sharing data across data analysis languages easy. Here is how to load the file <code>plain_text/train-00000-of-00001.parquet</code> as a pyarrow Table (it requires <code>pyarrow&gt;=21.0</code>):',Ja,Z,fa,$,ie="If you don’t want to load the full Parquet data, you can get the Parquet metadata or load row group by row group instead:",Ta,X,ga,_,re='For more information on the Hugging Face paths and how they are implemented, please refer to the <a href="/docs/huggingface_hub/guides/hf_file_system">the client library’s documentation on the HfFileSystem</a>.',ja,B,ba,G,oe="You can save a pyarrow Table using <code>pyarrow.parquet.write_table</code> to a local file or to Hugging Face directly.",Ua,k,me='To save the Table on Hugging Face, you first need to <a href="/docs/huggingface_hub/quick-start#login">Login with your Hugging Face account</a>, for example using:',Ia,q,Za,Y,he='Then you can <a href="/docs/huggingface_hub/quick-start#create-a-repository">create a dataset repository</a>, for example using:',$a,C,Xa,W,de='Finally, you can use <a href="/docs/huggingface_hub/guides/hf_file_system#integrations">Hugging Face paths</a> in PyArrow:',_a,R,Ba,V,ue="We use <code>use_content_defined_chunking=True</code> to enable faster uploads and downloads from Hugging Face thanks to Xet deduplication (it requires <code>pyarrow&gt;=21.0</code>).",Ga,J,ka,F,ce='Find more information about Xet <a href="https://huggingface.co/join/xet" rel="nofollow">here</a>.',qa,x,Ya,v,ye="You can load a folder with a metadata file containing a field for the names or paths to the images, structured like this:",Ca,E,Wa,H,we="You can iterate on the images paths like this:",Ra,S,Va,Q,Me='Since the dataset is in a <a href="https://huggingface.co/docs/hub/en/datasets-image#additional-columns" rel="nofollow">supported structure</a> (a <code>metadata.parquet</code> file with a <code>file_name</code> field), you can save this dataset to Hugging Face and the Dataset Viewer shows both the metadata and images.',Fa,N,xa,A,va,z,Je="PyArrow has a binary type which allows to have the images bytes in Arrow tables. Therefore it enables saving the dataset as one single Parquet file containing both the images (bytes and path) and the samples metadata:",Ea,L,Ha,P,fe="Setting the Image type in the Arrow schema metadata allows other libraries and the Hugging Face Dataset Viewer to know that “image” contains images and not just binary data.",Sa,K,Qa,D,Te="You can load a folder with a metadata file containing a field for the names or paths to the audios, structured like this:",Na,O,Aa,aa,ge="You can iterate on the audios paths like this:",za,ea,La,ta,je='Since the dataset is in a <a href="https://huggingface.co/docs/hub/en/datasets-audio#additional-columns" rel="nofollow">supported structure</a> (a <code>metadata.parquet</code> file with a <code>file_name</code> field), you can save it to Hugging Face, and the Hub Dataset Viewer shows both the metadata and audio.',Pa,sa,Ka,la,Da,na,be="PyArrow has a binary type which allows for having audio bytes in Arrow tables. Therefore, it enables saving the dataset as one single Parquet file containing both the audio (bytes and path) and the samples metadata:",Oa,pa,ae,ia,Ue="Setting the Audio type in the Arrow schema metadata enables other libraries and the Hugging Face Dataset Viewer to recognise that “audio” contains audio data, not just binary data.",ee,ra,te,ha,se;return T=new oa({props:{title:"PyArrow",local:"pyarrow",headingTag:"h1"}}),j=new oa({props:{title:"Load a Table",local:"load-a-table",headingTag:"h2"}}),U=new w({props:{code:"aW1wb3J0JTIwcHlhcnJvdy5wYXJxdWV0JTIwYXMlMjBwcSUwQXRhYmxlJTIwJTNEJTIwcHEucmVhZF90YWJsZSglMjJwYXRoJTJGdG8lMkZkYXRhLnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyarrow.parquet <span class="hljs-keyword">as</span> pq
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pq.read_table(<span class="hljs-string">&quot;path/to/data.parquet&quot;</span>)`,wrap:!1}}),Z=new w({props:{code:"aW1wb3J0JTIwcHlhcnJvdy5wYXJxdWV0JTIwYXMlMjBwcSUwQXRhYmxlJTIwJTNEJTIwcHEucmVhZF90YWJsZSglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGc3RhbmZvcmRubHAlMkZpbWRiJTJGcGxhaW5fdGV4dCUyRnRyYWluLTAwMDAwLW9mLTAwMDAxLnBhcnF1ZXQlMjIpJTBBdGFibGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyarrow.parquet <span class="hljs-keyword">as</span> pq
<span class="hljs-meta">&gt;&gt;&gt; </span>table = pq.read_table(<span class="hljs-string">&quot;hf://datasets/stanfordnlp/imdb/plain_text/train-00000-of-00001.parquet&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>table
pyarrow.Table
text: string
label: int64
----
text: [[<span class="hljs-string">&quot;I rented I AM CURIOUS-YELLOW from my video store because of all the controversy that surrounded it (... 1542 chars omitted)&quot;</span>, ...],...,[..., <span class="hljs-string">&quot;The story centers around Barry McKenzie who must go to England if he wishes to claim his inheritan (... 221 chars omitted)&quot;</span>]]
label: [[<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,...,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>,<span class="hljs-number">0</span>],...,[<span class="hljs-number">1</span>,<span class="hljs-number">1</span>,<span class="hljs-number">1</span>,<span class="hljs-number">1</span>,<span class="hljs-number">1</span>,...,<span class="hljs-number">1</span>,<span class="hljs-number">1</span>,<span class="hljs-number">1</span>,<span class="hljs-number">1</span>,<span class="hljs-number">1</span>]]`,wrap:!1}}),X=new w({props:{code:"aW1wb3J0JTIwcHlhcnJvdy5wYXJxdWV0JTIwYXMlMjBwcSUwQXBmJTIwJTNEJTIwcHEuUGFycXVldEZpbGUoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnN0YW5mb3JkbmxwJTJGaW1kYiUyRnBsYWluX3RleHQlMkZ0cmFpbi0wMDAwMC1vZi0wMDAwMS5wYXJxdWV0JTIyKSUwQXBmLm1ldGFkYXRhJTBBZm9yJTIwaSUyMGluJTIwcGYubnVtX3Jvd19ncm91cHMlM0ElMEElMjAlMjAlMjAlMjB0YWJsZSUyMCUzRCUyMHBmLnJlYWRfcm93X2dyb3VwKGkpJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pyarrow.parquet <span class="hljs-keyword">as</span> pq
<span class="hljs-meta">&gt;&gt;&gt; </span>pf = pq.ParquetFile(<span class="hljs-string">&quot;hf://datasets/stanfordnlp/imdb/plain_text/train-00000-of-00001.parquet&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pf.metadata
&lt;pyarrow._parquet.FileMetaData <span class="hljs-built_in">object</span> at <span class="hljs-number">0x1171b4090</span>&gt;
  created_by: parquet-cpp-arrow version <span class="hljs-number">12.0</span><span class="hljs-number">.0</span>
  num_columns: <span class="hljs-number">2</span>
  num_rows: <span class="hljs-number">25000</span>
  num_row_groups: <span class="hljs-number">25</span>
  format_version: <span class="hljs-number">2.6</span>
  serialized_size: <span class="hljs-number">62036</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> pf.num_row_groups:
<span class="hljs-meta">... </span>    table = pf.read_row_group(i)
<span class="hljs-meta">... </span>    ...`,wrap:!1}}),B=new oa({props:{title:"Save a Table",local:"save-a-table",headingTag:"h2"}}),q=new w({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:'<span class="hljs-attribute">hf auth login</span>',wrap:!1}}),C=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBSGZBcGkoKS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9kYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

HfApi().create_repo(repo_id=<span class="hljs-string">&quot;username/my_dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),R=new w({props:{code:"aW1wb3J0JTIwcHlhcnJvdy5wYXJxdWV0JTIwYXMlMjBwcSUwQSUwQXBxLndyaXRlX3RhYmxlKHRhYmxlJTJDJTIwJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRmltZGIucGFycXVldCUyMiUyQyUyMHVzZV9jb250ZW50X2RlZmluZWRfY2h1bmtpbmclM0RUcnVlKSUwQSUwQSUyMyUyMG9yJTIwd3JpdGUlMjBpbiUyMHNlcGFyYXRlJTIwZmlsZXMlMjBpZiUyMHRoZSUyMGRhdGFzZXQlMjBoYXMlMjB0cmFpbiUyRnZhbGlkYXRpb24lMkZ0ZXN0JTIwc3BsaXRzJTBBcHEud3JpdGVfdGFibGUodGFibGVfdHJhaW4lMkMlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdHJhaW4ucGFycXVldCUyMiUyQyUyMHVzZV9jb250ZW50X2RlZmluZWRfY2h1bmtpbmclM0RUcnVlKSUwQXBxLndyaXRlX3RhYmxlKHRhYmxlX3ZhbGlkJTJDJTIwJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRnZhbGlkYXRpb24ucGFycXVldCUyMiUyQyUyMHVzZV9jb250ZW50X2RlZmluZWRfY2h1bmtpbmclM0RUcnVlKSUwQXBxLndyaXRlX3RhYmxlKHRhYmxlX3Rlc3QlMjAlMkMlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdGVzdC5wYXJxdWV0JTIyJTJDJTIwdXNlX2NvbnRlbnRfZGVmaW5lZF9jaHVua2luZyUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> pyarrow.parquet <span class="hljs-keyword">as</span> pq

pq.write_table(table, <span class="hljs-string">&quot;hf://datasets/username/my_dataset/imdb.parquet&quot;</span>, use_content_defined_chunking=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># or write in separate files if the dataset has train/validation/test splits</span>
pq.write_table(table_train, <span class="hljs-string">&quot;hf://datasets/username/my_dataset/train.parquet&quot;</span>, use_content_defined_chunking=<span class="hljs-literal">True</span>)
pq.write_table(table_valid, <span class="hljs-string">&quot;hf://datasets/username/my_dataset/validation.parquet&quot;</span>, use_content_defined_chunking=<span class="hljs-literal">True</span>)
pq.write_table(table_test , <span class="hljs-string">&quot;hf://datasets/username/my_dataset/test.parquet&quot;</span>, use_content_defined_chunking=<span class="hljs-literal">True</span>)`,wrap:!1}}),J=new Ce({props:{$$slots:{default:[Re]},$$scope:{ctx:da}}}),x=new oa({props:{title:"Use Images",local:"use-images",headingTag:"h2"}}),E=new w({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`Example <span class="hljs-number">1</span>:            Example <span class="hljs-number">2</span>:
folder/               folder/
├── metadata<span class="hljs-selector-class">.parquet</span>  ├── metadata<span class="hljs-selector-class">.parquet</span>
├── img000<span class="hljs-selector-class">.png</span>        └── images
├── img001<span class="hljs-selector-class">.png</span>            ├── img000<span class="hljs-selector-class">.png</span>
...                       ...
└── imgNNN<span class="hljs-selector-class">.png</span>            └── imgNNN.png`,wrap:!1}}),S=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwcHlhcnJvdyUyMGFzJTIwcHElMEElMEFmb2xkZXJfcGF0aCUyMCUzRCUyMFBhdGgoJTIycGF0aCUyRnRvJTJGZm9sZGVyJTIyKSUwQXRhYmxlJTIwJTNEJTIwcHEucmVhZF90YWJsZShmb2xkZXJfcGF0aCUyMCUyQiUyMCUyMm1ldGFkYXRhLnBhcnF1ZXQlMjIpJTBBZm9yJTIwZmlsZV9uYW1lJTIwaW4lMjB0YWJsZSU1QiUyMmZpbGVfbmFtZSUyMiU1RC50b19weWxpc3QoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX3BhdGglMjAlM0QlMjBmb2xkZXJfcGF0aCUyMCUyRiUyMGZpbGVfbmFtZSUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pq

folder_path = Path(<span class="hljs-string">&quot;path/to/folder&quot;</span>)
table = pq.read_table(folder_path + <span class="hljs-string">&quot;metadata.parquet&quot;</span>)
<span class="hljs-keyword">for</span> file_name <span class="hljs-keyword">in</span> table[<span class="hljs-string">&quot;file_name&quot;</span>].to_pylist():
    image_path = folder_path / file_name
    ...`,wrap:!1}}),N=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZm9sZGVyX3BhdGglMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9pbWFnZV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()

api.upload_folder(
    folder_path=folder_path,
    repo_id=<span class="hljs-string">&quot;username/my_image_dataset&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),A=new oa({props:{title:"Embed Images inside Parquet",local:"embed-images-inside-parquet",headingTag:"h3"}}),L=new w({props:{code:"aW1wb3J0JTIwcHlhcnJvdyUyMGFzJTIwcGElMEFpbXBvcnQlMjBweWFycm93LnBhcnF1ZXQlMjBhcyUyMHBxJTBBJTBBJTIzJTIwRW1iZWQlMjB0aGUlMjBpbWFnZSUyMGJ5dGVzJTIwaW4lMjBBcnJvdyUwQWltYWdlX2FycmF5JTIwJTNEJTIwcGEuYXJyYXkoJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYnl0ZXMlMjIlM0ElMjAoZm9sZGVyX3BhdGglMjAlMkYlMjBmaWxlX25hbWUpLnJlYWRfYnl0ZXMoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjBmaWxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBmaWxlX25hbWUlMjBpbiUyMHRhYmxlJTVCJTIyZmlsZV9uYW1lJTIyJTVELnRvX3B5bGlzdCgpJTBBJTVEKSUwQXRhYmxlLmFwcGVuZF9jb2x1bW4oJTIyaW1hZ2UlMjIlMkMlMjBpbWFnZV9hcnJheSklMEElMEElMjMlMjAoT3B0aW9uYWwpJTIwU2V0JTIwdGhlJTIwSEYlMjBJbWFnZSUyMHR5cGUlMjBmb3IlMjB0aGUlMjBEYXRhc2V0JTIwVmlld2VyJTIwYW5kJTIwdGhlJTIwJTYwZGF0YXNldHMlNjAlMjBsaWJyYXJ5JTBBZmVhdHVyZXMlMjAlM0QlMjAlN0IlMjJpbWFnZSUyMiUzQSUyMCU3QiUyMl90eXBlJTIyJTNBJTIwJTIySW1hZ2UlMjIlN0QlN0QlMjAlMjAlMjMlMjBvciUyMHVzaW5nJTIwZGF0YXNldHMuRmVhdHVyZXMoLi4uKS50b19kaWN0KCklMEFzY2hlbWFfbWV0YWRhdGElMjAlM0QlMjAlN0IlMjJodWdnaW5nZmFjZSUyMiUzQSUyMCU3QiUyMmRhdGFzZXRfaW5mbyUyMiUzQSUyMCU3QiUyMmZlYXR1cmVzJTIyJTNBJTIwZmVhdHVyZXMlN0QlN0QlN0QlMEF0YWJsZSUyMCUzRCUyMHRhYmxlLnJlcGxhY2Vfc2NoZW1hX21ldGFkYXRhKHNjaGVtYV9tZXRhZGF0YSklMEElMEElMjMlMjBTYXZlJTIwdG8lMjBQYXJxdWV0JTBBJTIzJTIwKE9wdGlvbmFsKSUyMHdpdGglMjB1c2VfY29udGVudF9kZWZpbmVkX2NodW5raW5nJTIwZm9yJTIwZmFzdGVyJTIwdXBsb2FkcyUyMGFuZCUyMGRvd25sb2FkcyUwQXBxLndyaXRlX3RhYmxlKHRhYmxlJTJDJTIwJTIyZGF0YS5wYXJxdWV0JTIyJTJDJTIwdXNlX2NvbnRlbnRfZGVmaW5lZF9jaHVua2luZyUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pa
<span class="hljs-keyword">import</span> pyarrow.parquet <span class="hljs-keyword">as</span> pq

<span class="hljs-comment"># Embed the image bytes in Arrow</span>
image_array = pa.array([
    {
        <span class="hljs-string">&quot;bytes&quot;</span>: (folder_path / file_name).read_bytes(),
        <span class="hljs-string">&quot;path&quot;</span>: file_name,
    }
    <span class="hljs-keyword">for</span> file_name <span class="hljs-keyword">in</span> table[<span class="hljs-string">&quot;file_name&quot;</span>].to_pylist()
])
table.append_column(<span class="hljs-string">&quot;image&quot;</span>, image_array)

<span class="hljs-comment"># (Optional) Set the HF Image type for the Dataset Viewer and the \`datasets\` library</span>
features = {<span class="hljs-string">&quot;image&quot;</span>: {<span class="hljs-string">&quot;_type&quot;</span>: <span class="hljs-string">&quot;Image&quot;</span>}}  <span class="hljs-comment"># or using datasets.Features(...).to_dict()</span>
schema_metadata = {<span class="hljs-string">&quot;huggingface&quot;</span>: {<span class="hljs-string">&quot;dataset_info&quot;</span>: {<span class="hljs-string">&quot;features&quot;</span>: features}}}
table = table.replace_schema_metadata(schema_metadata)

<span class="hljs-comment"># Save to Parquet</span>
<span class="hljs-comment"># (Optional) with use_content_defined_chunking for faster uploads and downloads</span>
pq.write_table(table, <span class="hljs-string">&quot;data.parquet&quot;</span>, use_content_defined_chunking=<span class="hljs-literal">True</span>)`,wrap:!1}}),K=new oa({props:{title:"Use Audios",local:"use-audios",headingTag:"h2"}}),O=new w({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`Example <span class="hljs-number">1</span>:            Example <span class="hljs-number">2</span>:
folder/               folder/
├── metadata<span class="hljs-selector-class">.parquet</span>  ├── metadata<span class="hljs-selector-class">.parquet</span>
├── rec000<span class="hljs-selector-class">.wav</span>        └── audios
├── rec001<span class="hljs-selector-class">.wav</span>            ├── rec000<span class="hljs-selector-class">.wav</span>
...                       ...
└── recNNN<span class="hljs-selector-class">.wav</span>            └── recNNN.wav`,wrap:!1}}),ea=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwcHlhcnJvdyUyMGFzJTIwcHElMEElMEFmb2xkZXJfcGF0aCUyMCUzRCUyMFBhdGgoJTIycGF0aCUyRnRvJTJGZm9sZGVyJTIyKSUwQXRhYmxlJTIwJTNEJTIwcHEucmVhZF90YWJsZShmb2xkZXJfcGF0aCUyMCUyQiUyMCUyMm1ldGFkYXRhLnBhcnF1ZXQlMjIpJTBBZm9yJTIwZmlsZV9uYW1lJTIwaW4lMjB0YWJsZSU1QiUyMmZpbGVfbmFtZSUyMiU1RC50b19weWxpc3QoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvX3BhdGglMjAlM0QlMjBmb2xkZXJfcGF0aCUyMCUyRiUyMGZpbGVfbmFtZSUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pq

folder_path = Path(<span class="hljs-string">&quot;path/to/folder&quot;</span>)
table = pq.read_table(folder_path + <span class="hljs-string">&quot;metadata.parquet&quot;</span>)
<span class="hljs-keyword">for</span> file_name <span class="hljs-keyword">in</span> table[<span class="hljs-string">&quot;file_name&quot;</span>].to_pylist():
    audio_path = folder_path / file_name
    ...`,wrap:!1}}),sa=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZm9sZGVyX3BhdGglMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9hdWRpb19kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi()

api.upload_folder(
    folder_path=folder_path,
    repo_id=<span class="hljs-string">&quot;username/my_audio_dataset&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),la=new oa({props:{title:"Embed Audio inside Parquet",local:"embed-audio-inside-parquet",headingTag:"h3"}}),pa=new w({props:{code:"aW1wb3J0JTIwcHlhcnJvdyUyMGFzJTIwcGElMEFpbXBvcnQlMjBweWFycm93LnBhcnF1ZXQlMjBhcyUyMHBxJTBBJTBBJTIzJTIwRW1iZWQlMjB0aGUlMjBhdWRpbyUyMGJ5dGVzJTIwaW4lMjBBcnJvdyUwQWF1ZGlvX2FycmF5JTIwJTNEJTIwcGEuYXJyYXkoJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYnl0ZXMlMjIlM0ElMjAoZm9sZGVyX3BhdGglMjAlMkYlMjBmaWxlX25hbWUpLnJlYWRfYnl0ZXMoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjBmaWxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBmaWxlX25hbWUlMjBpbiUyMHRhYmxlJTVCJTIyZmlsZV9uYW1lJTIyJTVELnRvX3B5bGlzdCgpJTBBJTVEKSUwQXRhYmxlLmFwcGVuZF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBhdWRpb19hcnJheSklMEElMEElMjMlMjAoT3B0aW9uYWwpJTIwU2V0JTIwdGhlJTIwSEYlMjBBdWRpbyUyMHR5cGUlMjBmb3IlMjB0aGUlMjBEYXRhc2V0JTIwVmlld2VyJTIwYW5kJTIwdGhlJTIwJTYwZGF0YXNldHMlNjAlMjBsaWJyYXJ5JTBBZmVhdHVyZXMlMjAlM0QlMjAlN0IlMjJhdWRpbyUyMiUzQSUyMCU3QiUyMl90eXBlJTIyJTNBJTIwJTIyQXVkaW8lMjIlN0QlN0QlMjAlMjAlMjMlMjBvciUyMHVzaW5nJTIwZGF0YXNldHMuRmVhdHVyZXMoLi4uKS50b19kaWN0KCklMEFzY2hlbWFfbWV0YWRhdGElMjAlM0QlMjAlN0IlMjJodWdnaW5nZmFjZSUyMiUzQSUyMCU3QiUyMmRhdGFzZXRfaW5mbyUyMiUzQSUyMCU3QiUyMmZlYXR1cmVzJTIyJTNBJTIwZmVhdHVyZXMlN0QlN0QlN0QlMEF0YWJsZSUyMCUzRCUyMHRhYmxlLnJlcGxhY2Vfc2NoZW1hX21ldGFkYXRhKHNjaGVtYV9tZXRhZGF0YSklMEElMEElMjMlMjBTYXZlJTIwdG8lMjBQYXJxdWV0JTBBJTIzJTIwKE9wdGlvbmFsKSUyMHdpdGglMjB1c2VfY29udGVudF9kZWZpbmVkX2NodW5raW5nJTIwZm9yJTIwZmFzdGVyJTIwdXBsb2FkcyUyMGFuZCUyMGRvd25sb2FkcyUwQXBxLndyaXRlX3RhYmxlKHRhYmxlJTJDJTIwJTIyZGF0YS5wYXJxdWV0JTIyJTJDJTIwdXNlX2NvbnRlbnRfZGVmaW5lZF9jaHVua2luZyUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pa
<span class="hljs-keyword">import</span> pyarrow.parquet <span class="hljs-keyword">as</span> pq

<span class="hljs-comment"># Embed the audio bytes in Arrow</span>
audio_array = pa.array([
    {
        <span class="hljs-string">&quot;bytes&quot;</span>: (folder_path / file_name).read_bytes(),
        <span class="hljs-string">&quot;path&quot;</span>: file_name,
    }
    <span class="hljs-keyword">for</span> file_name <span class="hljs-keyword">in</span> table[<span class="hljs-string">&quot;file_name&quot;</span>].to_pylist()
])
table.append_column(<span class="hljs-string">&quot;audio&quot;</span>, audio_array)

<span class="hljs-comment"># (Optional) Set the HF Audio type for the Dataset Viewer and the \`datasets\` library</span>
features = {<span class="hljs-string">&quot;audio&quot;</span>: {<span class="hljs-string">&quot;_type&quot;</span>: <span class="hljs-string">&quot;Audio&quot;</span>}}  <span class="hljs-comment"># or using datasets.Features(...).to_dict()</span>
schema_metadata = {<span class="hljs-string">&quot;huggingface&quot;</span>: {<span class="hljs-string">&quot;dataset_info&quot;</span>: {<span class="hljs-string">&quot;features&quot;</span>: features}}}
table = table.replace_schema_metadata(schema_metadata)

<span class="hljs-comment"># Save to Parquet</span>
<span class="hljs-comment"># (Optional) with use_content_defined_chunking for faster uploads and downloads</span>
pq.write_table(table, <span class="hljs-string">&quot;data.parquet&quot;</span>, use_content_defined_chunking=<span class="hljs-literal">True</span>)`,wrap:!1}}),ra=new We({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-pyarrow.md"}}),{c(){y=p("meta"),f=l(),M=p("p"),ma=l(),r(T.$$.fragment),ua=l(),g=p("p"),g.innerHTML=le,ca=l(),r(j.$$.fragment),ya=l(),b=p("p"),b.textContent=ne,wa=l(),r(U.$$.fragment),Ma=l(),I=p("p"),I.innerHTML=pe,Ja=l(),r(Z.$$.fragment),fa=l(),$=p("p"),$.textContent=ie,Ta=l(),r(X.$$.fragment),ga=l(),_=p("p"),_.innerHTML=re,ja=l(),r(B.$$.fragment),ba=l(),G=p("p"),G.innerHTML=oe,Ua=l(),k=p("p"),k.innerHTML=me,Ia=l(),r(q.$$.fragment),Za=l(),Y=p("p"),Y.innerHTML=he,$a=l(),r(C.$$.fragment),Xa=l(),W=p("p"),W.innerHTML=de,_a=l(),r(R.$$.fragment),Ba=l(),V=p("p"),V.innerHTML=ue,Ga=l(),r(J.$$.fragment),ka=l(),F=p("p"),F.innerHTML=ce,qa=l(),r(x.$$.fragment),Ya=l(),v=p("p"),v.textContent=ye,Ca=l(),r(E.$$.fragment),Wa=l(),H=p("p"),H.textContent=we,Ra=l(),r(S.$$.fragment),Va=l(),Q=p("p"),Q.innerHTML=Me,Fa=l(),r(N.$$.fragment),xa=l(),r(A.$$.fragment),va=l(),z=p("p"),z.textContent=Je,Ea=l(),r(L.$$.fragment),Ha=l(),P=p("p"),P.textContent=fe,Sa=l(),r(K.$$.fragment),Qa=l(),D=p("p"),D.textContent=Te,Na=l(),r(O.$$.fragment),Aa=l(),aa=p("p"),aa.textContent=ge,za=l(),r(ea.$$.fragment),La=l(),ta=p("p"),ta.innerHTML=je,Pa=l(),r(sa.$$.fragment),Ka=l(),r(la.$$.fragment),Da=l(),na=p("p"),na.textContent=be,Oa=l(),r(pa.$$.fragment),ae=l(),ia=p("p"),ia.textContent=Ue,ee=l(),r(ra.$$.fragment),te=l(),ha=p("p"),this.h()},l(a){const e=qe("svelte-u9bgzb",document.head);y=i(e,"META",{name:!0,content:!0}),e.forEach(t),f=n(a),M=i(a,"P",{}),Ze(M).forEach(t),ma=n(a),o(T.$$.fragment,a),ua=n(a),g=i(a,"P",{"data-svelte-h":!0}),c(g)!=="svelte-56vgn"&&(g.innerHTML=le),ca=n(a),o(j.$$.fragment,a),ya=n(a),b=i(a,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1263bgm"&&(b.textContent=ne),wa=n(a),o(U.$$.fragment,a),Ma=n(a),I=i(a,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1othel7"&&(I.innerHTML=pe),Ja=n(a),o(Z.$$.fragment,a),fa=n(a),$=i(a,"P",{"data-svelte-h":!0}),c($)!=="svelte-u7zvq0"&&($.textContent=ie),Ta=n(a),o(X.$$.fragment,a),ga=n(a),_=i(a,"P",{"data-svelte-h":!0}),c(_)!=="svelte-smuvdf"&&(_.innerHTML=re),ja=n(a),o(B.$$.fragment,a),ba=n(a),G=i(a,"P",{"data-svelte-h":!0}),c(G)!=="svelte-15a6az3"&&(G.innerHTML=oe),Ua=n(a),k=i(a,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1c59jr5"&&(k.innerHTML=me),Ia=n(a),o(q.$$.fragment,a),Za=n(a),Y=i(a,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1cj3kqp"&&(Y.innerHTML=he),$a=n(a),o(C.$$.fragment,a),Xa=n(a),W=i(a,"P",{"data-svelte-h":!0}),c(W)!=="svelte-110fpi"&&(W.innerHTML=de),_a=n(a),o(R.$$.fragment,a),Ba=n(a),V=i(a,"P",{"data-svelte-h":!0}),c(V)!=="svelte-cz486o"&&(V.innerHTML=ue),Ga=n(a),o(J.$$.fragment,a),ka=n(a),F=i(a,"P",{"data-svelte-h":!0}),c(F)!=="svelte-10e2td"&&(F.innerHTML=ce),qa=n(a),o(x.$$.fragment,a),Ya=n(a),v=i(a,"P",{"data-svelte-h":!0}),c(v)!=="svelte-i1x932"&&(v.textContent=ye),Ca=n(a),o(E.$$.fragment,a),Wa=n(a),H=i(a,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1wo91tc"&&(H.textContent=we),Ra=n(a),o(S.$$.fragment,a),Va=n(a),Q=i(a,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-17xhcwl"&&(Q.innerHTML=Me),Fa=n(a),o(N.$$.fragment,a),xa=n(a),o(A.$$.fragment,a),va=n(a),z=i(a,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1ypsa1z"&&(z.textContent=Je),Ea=n(a),o(L.$$.fragment,a),Ha=n(a),P=i(a,"P",{"data-svelte-h":!0}),c(P)!=="svelte-snsv43"&&(P.textContent=fe),Sa=n(a),o(K.$$.fragment,a),Qa=n(a),D=i(a,"P",{"data-svelte-h":!0}),c(D)!=="svelte-14ssghx"&&(D.textContent=Te),Na=n(a),o(O.$$.fragment,a),Aa=n(a),aa=i(a,"P",{"data-svelte-h":!0}),c(aa)!=="svelte-9uthgh"&&(aa.textContent=ge),za=n(a),o(ea.$$.fragment,a),La=n(a),ta=i(a,"P",{"data-svelte-h":!0}),c(ta)!=="svelte-gmhdi8"&&(ta.innerHTML=je),Pa=n(a),o(sa.$$.fragment,a),Ka=n(a),o(la.$$.fragment,a),Da=n(a),na=i(a,"P",{"data-svelte-h":!0}),c(na)!=="svelte-1w1yrqx"&&(na.textContent=be),Oa=n(a),o(pa.$$.fragment,a),ae=n(a),ia=i(a,"P",{"data-svelte-h":!0}),c(ia)!=="svelte-i7mbpg"&&(ia.textContent=Ue),ee=n(a),o(ra.$$.fragment,a),te=n(a),ha=i(a,"P",{}),Ze(ha).forEach(t),this.h()},h(){$e(y,"name","hf:doc:metadata"),$e(y,"content",Fe)},m(a,e){Ye(document.head,y),s(a,f,e),s(a,M,e),s(a,ma,e),m(T,a,e),s(a,ua,e),s(a,g,e),s(a,ca,e),m(j,a,e),s(a,ya,e),s(a,b,e),s(a,wa,e),m(U,a,e),s(a,Ma,e),s(a,I,e),s(a,Ja,e),m(Z,a,e),s(a,fa,e),s(a,$,e),s(a,Ta,e),m(X,a,e),s(a,ga,e),s(a,_,e),s(a,ja,e),m(B,a,e),s(a,ba,e),s(a,G,e),s(a,Ua,e),s(a,k,e),s(a,Ia,e),m(q,a,e),s(a,Za,e),s(a,Y,e),s(a,$a,e),m(C,a,e),s(a,Xa,e),s(a,W,e),s(a,_a,e),m(R,a,e),s(a,Ba,e),s(a,V,e),s(a,Ga,e),m(J,a,e),s(a,ka,e),s(a,F,e),s(a,qa,e),m(x,a,e),s(a,Ya,e),s(a,v,e),s(a,Ca,e),m(E,a,e),s(a,Wa,e),s(a,H,e),s(a,Ra,e),m(S,a,e),s(a,Va,e),s(a,Q,e),s(a,Fa,e),m(N,a,e),s(a,xa,e),m(A,a,e),s(a,va,e),s(a,z,e),s(a,Ea,e),m(L,a,e),s(a,Ha,e),s(a,P,e),s(a,Sa,e),m(K,a,e),s(a,Qa,e),s(a,D,e),s(a,Na,e),m(O,a,e),s(a,Aa,e),s(a,aa,e),s(a,za,e),m(ea,a,e),s(a,La,e),s(a,ta,e),s(a,Pa,e),m(sa,a,e),s(a,Ka,e),m(la,a,e),s(a,Da,e),s(a,na,e),s(a,Oa,e),m(pa,a,e),s(a,ae,e),s(a,ia,e),s(a,ee,e),m(ra,a,e),s(a,te,e),s(a,ha,e),se=!0},p(a,[e]){const Ie={};e&2&&(Ie.$$scope={dirty:e,ctx:a}),J.$set(Ie)},i(a){se||(h(T.$$.fragment,a),h(j.$$.fragment,a),h(U.$$.fragment,a),h(Z.$$.fragment,a),h(X.$$.fragment,a),h(B.$$.fragment,a),h(q.$$.fragment,a),h(C.$$.fragment,a),h(R.$$.fragment,a),h(J.$$.fragment,a),h(x.$$.fragment,a),h(E.$$.fragment,a),h(S.$$.fragment,a),h(N.$$.fragment,a),h(A.$$.fragment,a),h(L.$$.fragment,a),h(K.$$.fragment,a),h(O.$$.fragment,a),h(ea.$$.fragment,a),h(sa.$$.fragment,a),h(la.$$.fragment,a),h(pa.$$.fragment,a),h(ra.$$.fragment,a),se=!0)},o(a){d(T.$$.fragment,a),d(j.$$.fragment,a),d(U.$$.fragment,a),d(Z.$$.fragment,a),d(X.$$.fragment,a),d(B.$$.fragment,a),d(q.$$.fragment,a),d(C.$$.fragment,a),d(R.$$.fragment,a),d(J.$$.fragment,a),d(x.$$.fragment,a),d(E.$$.fragment,a),d(S.$$.fragment,a),d(N.$$.fragment,a),d(A.$$.fragment,a),d(L.$$.fragment,a),d(K.$$.fragment,a),d(O.$$.fragment,a),d(ea.$$.fragment,a),d(sa.$$.fragment,a),d(la.$$.fragment,a),d(pa.$$.fragment,a),d(ra.$$.fragment,a),se=!1},d(a){a&&(t(f),t(M),t(ma),t(ua),t(g),t(ca),t(ya),t(b),t(wa),t(Ma),t(I),t(Ja),t(fa),t($),t(Ta),t(ga),t(_),t(ja),t(ba),t(G),t(Ua),t(k),t(Ia),t(Za),t(Y),t($a),t(Xa),t(W),t(_a),t(Ba),t(V),t(Ga),t(ka),t(F),t(qa),t(Ya),t(v),t(Ca),t(Wa),t(H),t(Ra),t(Va),t(Q),t(Fa),t(xa),t(va),t(z),t(Ea),t(Ha),t(P),t(Sa),t(Qa),t(D),t(Na),t(Aa),t(aa),t(za),t(La),t(ta),t(Pa),t(Ka),t(Da),t(na),t(Oa),t(ae),t(ia),t(ee),t(te),t(ha)),t(y),u(T,a),u(j,a),u(U,a),u(Z,a),u(X,a),u(B,a),u(q,a),u(C,a),u(R,a),u(J,a),u(x,a),u(E,a),u(S,a),u(N,a),u(A,a),u(L,a),u(K,a),u(O,a),u(ea,a),u(sa,a),u(la,a),u(pa,a),u(ra,a)}}}const Fe='{"title":"PyArrow","local":"pyarrow","sections":[{"title":"Load a Table","local":"load-a-table","sections":[],"depth":2},{"title":"Save a Table","local":"save-a-table","sections":[],"depth":2},{"title":"Use Images","local":"use-images","sections":[{"title":"Embed Images inside Parquet","local":"embed-images-inside-parquet","sections":[],"depth":3}],"depth":2},{"title":"Use Audios","local":"use-audios","sections":[{"title":"Embed Audio inside Parquet","local":"embed-audio-inside-parquet","sections":[],"depth":3}],"depth":2}],"depth":1}';function xe(da){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ne extends Ge{constructor(y){super(),ke(this,y,xe,Ve,Xe,{})}}export{Ne as component};
