import{s as sn,o as ln,n as xt}from"../chunks/scheduler.2427eaa0.js";import{S as an,i as nn,g as i,s as a,r as M,A as pn,h as p,f as s,c as n,j as tn,u,x as o,k as kt,y as on,a as l,v as c,d as y,t as h,w as d}from"../chunks/index.cf54e274.js";import{T as $t}from"../chunks/Tip.ba8beabf.js";import{C as f}from"../chunks/CodeBlock.1a8c1d5b.js";import{H as J,E as rn}from"../chunks/getInferenceSnippets.1f5c51db.js";function Mn(j){let r,U="-Want to be listed as an Inference Provider on the Hugging Face Hub? Let’s get in touch!",m,T,I='Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.';return{c(){r=i("p"),r.textContent=U,m=a(),T=i("p"),T.innerHTML=I},l(w){r=p(w,"P",{"data-svelte-h":!0}),o(r)!=="svelte-vc2pa5"&&(r.textContent=U),m=n(w),T=p(w,"P",{"data-svelte-h":!0}),o(T)!=="svelte-blyh6f"&&(T.innerHTML=I)},m(w,g){l(w,r,g),l(w,m,g),l(w,T,g)},p:xt,d(w){w&&(s(r),s(m),s(T))}}}function un(j){let r,U='If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.';return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-90vl22"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:xt,d(m){m&&s(r)}}}function cn(j){let r,U=`Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.`;return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-19q0jcc"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:xt,d(m){m&&s(r)}}}function yn(j){let r,U="To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your company, and upgrade it to a Team or Enterprise plan.";return{c(){r=i("p"),r.textContent=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1by8rua"&&(r.textContent=U)},m(m,T){l(m,r,T)},p:xt,d(m){m&&s(r)}}}function hn(j){let r,U='Important: Make sure that the JS client library can handle LoRA weights for your provider. Check out <a href="https://github.com/huggingface/huggingface.js/blob/904964c9f8cd10ed67114ccb88b9028e89fd6cad/packages/inference/src/providers/fal-ai.ts#L78-L124" rel="nofollow">fal’s implementation</a> for more details.';return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-1c6mi2m"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:xt,d(m){m&&s(r)}}}function dn(j){let r,U="This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.";return{c(){r=i("p"),r.textContent=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-94fcay"&&(r.textContent=U)},m(m,T){l(m,r,T)},p:xt,d(m){m&&s(r)}}}function mn(j){let r,U="Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.";return{c(){r=i("p"),r.innerHTML=U},l(m){r=p(m,"P",{"data-svelte-h":!0}),o(r)!=="svelte-33g0sl"&&(r.innerHTML=U)},m(m,T){l(m,r,T)},p:xt,d(m){m&&s(r)}}}function Jn(j){let r,U,m,T,I,w,g,qt,H,Zl="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",Bt,G,Rl='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',Ht,_,Gt,C,_t,Z,Sl=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,Zt,R,Wl=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,Rt,S,St,W,Vl=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,Wt,b,Xl='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',Vt,V,Ql='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',Xt,v,Qt,X,Yt,Q,Yl=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,Et,Y,El=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,Ft,E,Fl='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',Pt,F,Nt,P,Pl="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",zt,N,Lt,z,Nl="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",Dt,L,Ot,D,zl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",Kt,O,Ll='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',es,K,Dl='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',ts,ee,ss,te,Ol='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. You will need to add your provider to the <code>INFERENCE_PROVIDERS</code> list as well in <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/types.ts" rel="nofollow">packages/inference/src/types.ts</a>. Please try to respect alphabetical order.',ls,se,Kl='Update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/README.md" rel="nofollow">README.md</a> in the <code>packages/inference</code> directory to include your provider in the list of supported providers and the list of supported models links.',as,le,ns,ae,ea="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",is,ne,ta="First step is to use the Model Mapping API to register which HF models are supported.",ps,$,os,ie,rs,pe,Ms,oe,sa="Create a new mapping item, with the following body (JSON-encoded):",us,re,cs,Me,la=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different. In general, we encourage you to use the HF model ids on your side as well, but this is up to you).</li>`,ys,ue,aa="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",hs,ce,ds,ye,na=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,ms,he,Js,de,ia="The endpoint validates that:",Us,me,pa=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>After the mapping creation (asynchronously) we automatically test whether the Partner API correctly handles huggingface.js/inference calls for the relevant task, ensuring the API specifications are valid. See the <a href="#automatic-validation">Automatic validation</a> section below.</li>`,Ts,Je,js,Ue,oa=`We also support mapping HF models based on their <code>tags</code>. Using tag filters, you can automatically map multiple HF models to a single inference endpoint on your side.
For example, any model tagged with both <code>lora</code> and <code>base_model:adapter:black-forest-labs/FLUX.1-dev</code> can be mapped to your Flux-dev LoRA inference endpoint.`,ws,x,fs,Te,ra="The API is as follows:",gs,je,Is,we,Ma="Create a new mapping item, with the following body (JSON-encoded):",Cs,fe,bs,ge,ua=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>tags</code> is the set of model tags to match. For example, to match all LoRAs of Flux, you can use: <code>[&quot;lora&quot;, &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot;]</code></li> <li><code>providerModel</code> is the model ID on your side (can be the same or different from the HF model ID).</li> <li><code>adapterType</code> is a literal value that helps client libraries interpret how to call your API. The only supported value at the moment is <code>&quot;lora&quot;</code>.</li>`,vs,Ie,ca="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",$s,Ce,xs,be,As,ve,ya=`Where <code>mapping ID</code> is the mapping’s <code>_id</code> field obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,ks,$e,qs,xe,ha="Call this HTTP PUT endpoint:",Bs,Ae,Hs,ke,da="With the following body (JSON-encoded):",Gs,qe,_s,Be,ma=`Where <code>mapping ID</code> is the mapping’s <code>_id</code> field obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,Zs,He,Rs,Ge,Ss,_e,Ja="This gets all mapping items from the DB. For clarity, the output is grouped by task.",Ws,A,Vs,Ze,Ua="Here is an example of response:",Xs,Re,Qs,Se,Ys,We,Ta="Once a mapping is created through the API, Hugging Face performs periodic automated tests to ensure the mapped endpoint functions correctly.",Es,Ve,ja="Each model is tested every 6 hours by making API calls to your service. If the test is successful, the model remains active and continues to be tested periodically. However, if the test fails (e.g., your service returns an HTTP error status during an inference request), the provider will be temporarily removed from the list of active providers.",Fs,k,wa='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-dark.png"/></picture>',Ps,Xe,fa="A failed mapping undergoes retesting every hour. Additionally, updating the status of a model mapping triggers an immediate validation test.",Ns,Qe,ga="The validation process checks the following:",zs,Ye,Ia="<li>The Inference API is reachable, and the HTTP call succeeds.</li> <li>The output format is compatible with the Hugging Face JavaScript Inference Client.</li> <li>Latency requirements are met:<ul><li>For conversational and text models: under 5 seconds (time to first token in streaming mode).</li> <li>For other tasks: under 30 seconds.</li></ul></li>",Ls,Ee,Ca="For large language models (LLMs), additional behavioral tests are conducted:",Ds,Fe,ba="<li>Tool calling support.</li> <li>Structured output support.</li>",Os,Pe,va="These tests involve sending specific inference requests to the model and verifying that the responses meet the expected format.",Ks,Ne,el,ze,$a=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing">pricing page</a>.`,tl,q,xa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',sl,Le,Aa=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,ll,De,al,Oe,ka=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.
The authentication system should be the same as your Inference service; for example, a bearer token.`,nl,Ke,il,et,qa=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,pl,tt,ol,st,rl,lt,Ba="We require the price to be a <strong>non-negative integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",Ml,at,ul,nt,Ha=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,cl,it,Ga="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",yl,pt,_a="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",hl,ot,dl,rt,ml,B,Jl,Mt,Ul,ut,Za="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",Tl,ct,Ra="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",jl,yt,Sa="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",wl,ht,Wa="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",fl,dt,gl,mt,Il,Jt,Va='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',Cl,Ut,bl,Tt,Xa='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',vl,jt,$l,wt,Qa="Create a dedicated documentation page for your provider within the Hugging Face documentation. This page should contain a concise description of your provider services, highlight the benefits for users, set expectations regarding performance or features, and include any relevant details such as pricing models or data retention policies. Essentially, provide any information that would be valuable to end users.",xl,ft,Ya="Here’s how to add your documentation page:",Al,gt,Ea='<li>Provide Your Logo: You can send your logo files (separate light and dark mode versions) directly to us. This is often the simplest way. Alternatively, if you prefer, you can open a PR in the <a href="https://huggingface.co/datasets/huggingface/documentation-images/tree/main/inference-providers/logos" rel="nofollow">huggingface/documentation-images</a> repository. If you choose to open a PR:<ul><li>Logos must be in <code>.png</code> format.</li> <li>Name them <code>{provider-name}-light.png</code> and <code>{provider-name}-dark.png</code>.</li> <li>Please ping <code>@Wauplin</code> and <code>@celinah</code> on the PR.</li></ul></li> <li>Create the Documentation File:<ul><li>Use an existing provider page as a template. For example, check out the template for <a href="https://github.com/huggingface/hub-docs/blob/main/scripts/inference-providers/templates/providers/fal-ai.handlebars" rel="nofollow">Fal AI</a>.</li> <li>The file should be located under <code>scripts/inference-providers/templates/providers/{your-provider-name}.handlebars</code>.</li></ul></li> <li>Submit the Documentation PR:<ul><li>Add your new <code>{provider-name}.handlebars</code> file.</li> <li>Update the <a href="./index#partners">partners table</a> to include your company or product.</li> <li>Update the <code>_toctree.yml</code> file in the <code>docs/inference-providers/</code> directory to include your new documentation page in the “Providers” section, maintaining alphabetical order.</li> <li>Update the <code>scripts/inference-providers/scripts/generate.ts</code> file to include your provider in the <code>PROVIDERS_HUB_ORGS</code> and <code>PROVIDERS_URLS</code> constants, maintaining alphabetical order.</li> <li>Run <code>pnpm install</code> (if you haven’t already) and then <code>pnpm run generate</code> at the root of the <code>scripts/inference-providers</code> repository to generate the documentation.</li> <li>Commit all your changes, including the manually edited files (provider page, <code>_toctree.yml</code>, partners table) and the files generated by the script.</li> <li>When you open the PR, please ping @Wauplin, @SBrandeis, @julien-c, and @hanouticelina for a review. If you need any assistance with these steps, please reach out – we’re here to help you!</li></ul></li>',kl,It,ql,Ct,Fa="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",Bl,bt,Pa="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",Hl,vt,Gl,At,_l;return I=new J({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),g=new $t({props:{$$slots:{default:[Mn]},$$scope:{ctx:j}}}),_=new J({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),C=new $t({props:{$$slots:{default:[un]},$$scope:{ctx:j}}}),S=new J({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),v=new $t({props:{$$slots:{default:[cn]},$$scope:{ctx:j}}}),X=new J({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),F=new J({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),N=new J({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),L=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),ee=new J({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),le=new J({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),$=new $t({props:{$$slots:{default:[yn]},$$scope:{ctx:j}}}),ie=new J({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),pe=new f({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),re=new f({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ce=new J({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),he=new J({props:{title:"Validation",local:"validation",headingTag:"h4"}}),Je=new J({props:{title:"Using a tag-filter to map several HF models to a single inference endpoint",local:"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint",headingTag:"h3"}}),x=new $t({props:{$$slots:{default:[hn]},$$scope:{ctx:j}}}),je=new f({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),fe=new f({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnRhZy1maWx0ZXIlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJXaWRnZXRUeXBlJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCJTIyc3RyaW5nJTIyJTVEJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjBhbnklMjBIRiUyMG1vZGVsJTIwd2l0aCUyMGFsbCUyMG9mJTIwdGhvc2UlMjB0YWdzJTIwd2lsbCUyMGJlJTIwbWFwcGVkJTIwdG8lMjBwcm92aWRlck1vZGVsJTBBJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJNb2RlbCUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUyMCUyRiUyRiUyMHJlcXVpcmVkJTNBJTIwdGhlJTIwcGFydG5lcidzJTIwJTIybW9kZWwlMjBpZCUyMiUyMGkuZS4lMjBpZCUyMG9uJTIweW91ciUyMHNpZGUlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyVHlwZSUyMiUzQSUyMCUyMmxvcmElMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMG9ubHklMjAlMjJsb3JhJTIyJTIwaXMlMjBzdXBwb3J0ZWQlMjBhdCUyMHRoZSUyMG1vbWVudCUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tag-filter&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: any HF model with all of those tags will be mapped to providerModel</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: only &quot;lora&quot; is supported at the moment</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ce=new J({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),be=new f({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RA==",highlighted:"DELETE /api/partners/{provider}/models/{mapping ID}",wrap:!1}}),$e=new J({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),Ae=new f({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RCUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/{mapping ID}/status",wrap:!1}}),qe=new f({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIybGl2ZSUyMiUyMCU3QyUyMCUyMnN0YWdpbmclMjIlMjAlMkYlMkYlMjBUaGUlMjBuZXclMjBzdGF0dXMlMkMlMjBvbmUlMjBvZiUyMCUyMnN0YWdpbmclMjIlMjBvciUyMCUyMmxpdmUlMjIlMEElN0QlMjAlMjAlMjA=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),He=new J({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),Ge=new f({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),A=new $t({props:{warning:!0,$$slots:{default:[dn]},$$scope:{ctx:j}}}),Re=new f({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;tag-filter=base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0,lora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sdxl-lora-mutualized&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
                <span class="hljs-string">&quot;base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-string">&quot;lora&quot;</span>
            <span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Se=new J({props:{title:"Automatic validation",local:"automatic-validation",headingTag:"h3"}}),Ne=new J({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),De=new J({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),Ke=new f({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQXV0aG9yaXphdGlvbiUzQSUyMCU3QmF1dGhlbnRpY2F0aW9uJTIwaW5mbyUyMC0lMjBlZyUyMCUyMkJlYXJlciUyMHRva2VuJTIyJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Authorization</span><span class="hljs-punctuation">: </span>{authentication info - eg &quot;Bearer token&quot;}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),tt=new f({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),st=new J({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),at=new J({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),ot=new f({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),rt=new J({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),B=new $t({props:{$$slots:{default:[mn]},$$scope:{ctx:j}}}),Mt=new J({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),dt=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),mt=new J({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),Ut=new J({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),jt=new J({props:{title:"6. Add provider documentation",local:"6-add-provider-documentation",headingTag:"h2"}}),It=new J({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),vt=new rn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){r=i("meta"),U=a(),m=i("p"),T=a(),M(I.$$.fragment),w=a(),M(g.$$.fragment),qt=a(),H=i("p"),H.textContent=Zl,Bt=a(),G=i("ol"),G.innerHTML=Rl,Ht=a(),M(_.$$.fragment),Gt=a(),M(C.$$.fragment),_t=a(),Z=i("p"),Z.innerHTML=Sl,Zt=a(),R=i("p"),R.textContent=Wl,Rt=a(),M(S.$$.fragment),St=a(),W=i("p"),W.innerHTML=Vl,Wt=a(),b=i("div"),b.innerHTML=Xl,Vt=a(),V=i("p"),V.innerHTML=Ql,Xt=a(),M(v.$$.fragment),Qt=a(),M(X.$$.fragment),Yt=a(),Q=i("p"),Q.textContent=Yl,Et=a(),Y=i("p"),Y.textContent=El,Ft=a(),E=i("p"),E.innerHTML=Fl,Pt=a(),M(F.$$.fragment),Nt=a(),P=i("p"),P.textContent=Pl,zt=a(),M(N.$$.fragment),Lt=a(),z=i("p"),z.innerHTML=Nl,Dt=a(),M(L.$$.fragment),Ot=a(),D=i("p"),D.innerHTML=zl,Kt=a(),O=i("p"),O.innerHTML=Ll,es=a(),K=i("p"),K.innerHTML=Dl,ts=a(),M(ee.$$.fragment),ss=a(),te=i("p"),te.innerHTML=Ol,ls=a(),se=i("p"),se.innerHTML=Kl,as=a(),M(le.$$.fragment),ns=a(),ae=i("p"),ae.textContent=ea,is=a(),ne=i("p"),ne.textContent=ta,ps=a(),M($.$$.fragment),os=a(),M(ie.$$.fragment),rs=a(),M(pe.$$.fragment),Ms=a(),oe=i("p"),oe.textContent=sa,us=a(),M(re.$$.fragment),cs=a(),Me=i("ul"),Me.innerHTML=la,ys=a(),ue=i("p"),ue.textContent=aa,hs=a(),M(ce.$$.fragment),ds=a(),ye=i("p"),ye.innerHTML=na,ms=a(),M(he.$$.fragment),Js=a(),de=i("p"),de.textContent=ia,Us=a(),me=i("ul"),me.innerHTML=pa,Ts=a(),M(Je.$$.fragment),js=a(),Ue=i("p"),Ue.innerHTML=oa,ws=a(),M(x.$$.fragment),fs=a(),Te=i("p"),Te.textContent=ra,gs=a(),M(je.$$.fragment),Is=a(),we=i("p"),we.textContent=Ma,Cs=a(),M(fe.$$.fragment),bs=a(),ge=i("ul"),ge.innerHTML=ua,vs=a(),Ie=i("p"),Ie.textContent=ca,$s=a(),M(Ce.$$.fragment),xs=a(),M(be.$$.fragment),As=a(),ve=i("p"),ve.innerHTML=ya,ks=a(),M($e.$$.fragment),qs=a(),xe=i("p"),xe.textContent=ha,Bs=a(),M(Ae.$$.fragment),Hs=a(),ke=i("p"),ke.textContent=da,Gs=a(),M(qe.$$.fragment),_s=a(),Be=i("p"),Be.innerHTML=ma,Zs=a(),M(He.$$.fragment),Rs=a(),M(Ge.$$.fragment),Ss=a(),_e=i("p"),_e.textContent=Ja,Ws=a(),M(A.$$.fragment),Vs=a(),Ze=i("p"),Ze.textContent=Ua,Xs=a(),M(Re.$$.fragment),Qs=a(),M(Se.$$.fragment),Ys=a(),We=i("p"),We.textContent=Ta,Es=a(),Ve=i("p"),Ve.textContent=ja,Fs=a(),k=i("div"),k.innerHTML=wa,Ps=a(),Xe=i("p"),Xe.textContent=fa,Ns=a(),Qe=i("p"),Qe.textContent=ga,zs=a(),Ye=i("ul"),Ye.innerHTML=Ia,Ls=a(),Ee=i("p"),Ee.textContent=Ca,Ds=a(),Fe=i("ul"),Fe.innerHTML=ba,Os=a(),Pe=i("p"),Pe.textContent=va,Ks=a(),M(Ne.$$.fragment),el=a(),ze=i("p"),ze.innerHTML=$a,tl=a(),q=i("div"),q.innerHTML=xa,sl=a(),Le=i("p"),Le.textContent=Aa,ll=a(),M(De.$$.fragment),al=a(),Oe=i("p"),Oe.textContent=ka,nl=a(),M(Ke.$$.fragment),il=a(),et=i("p"),et.textContent=qa,pl=a(),M(tt.$$.fragment),ol=a(),M(st.$$.fragment),rl=a(),lt=i("p"),lt.innerHTML=Ba,Ml=a(),M(at.$$.fragment),ul=a(),nt=i("p"),nt.textContent=Ha,cl=a(),it=i("p"),it.innerHTML=Ga,yl=a(),pt=i("p"),pt.innerHTML=_a,hl=a(),M(ot.$$.fragment),dl=a(),M(rt.$$.fragment),ml=a(),M(B.$$.fragment),Jl=a(),M(Mt.$$.fragment),Ul=a(),ut=i("p"),ut.innerHTML=Za,Tl=a(),ct=i("p"),ct.innerHTML=Ra,jl=a(),yt=i("p"),yt.textContent=Sa,wl=a(),ht=i("p"),ht.textContent=Wa,fl=a(),M(dt.$$.fragment),gl=a(),M(mt.$$.fragment),Il=a(),Jt=i("ul"),Jt.innerHTML=Va,Cl=a(),M(Ut.$$.fragment),bl=a(),Tt=i("ul"),Tt.innerHTML=Xa,vl=a(),M(jt.$$.fragment),$l=a(),wt=i("p"),wt.textContent=Qa,xl=a(),ft=i("p"),ft.textContent=Ya,Al=a(),gt=i("ul"),gt.innerHTML=Ea,kl=a(),M(It.$$.fragment),ql=a(),Ct=i("p"),Ct.innerHTML=Fa,Bl=a(),bt=i("p"),bt.innerHTML=Pa,Hl=a(),M(vt.$$.fragment),Gl=a(),At=i("p"),this.h()},l(e){const t=pn("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(s),U=n(e),m=p(e,"P",{}),tn(m).forEach(s),T=n(e),u(I.$$.fragment,e),w=n(e),u(g.$$.fragment,e),qt=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-eo2v07"&&(H.textContent=Zl),Bt=n(e),G=p(e,"OL",{"data-svelte-h":!0}),o(G)!=="svelte-8emskd"&&(G.innerHTML=Rl),Ht=n(e),u(_.$$.fragment,e),Gt=n(e),u(C.$$.fragment,e),_t=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-iwney4"&&(Z.innerHTML=Sl),Zt=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1xoupob"&&(R.textContent=Wl),Rt=n(e),u(S.$$.fragment,e),St=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-hjt0h1"&&(W.innerHTML=Vl),Wt=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1cxy3tx"&&(b.innerHTML=Xl),Vt=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-vmhaok"&&(V.innerHTML=Ql),Xt=n(e),u(v.$$.fragment,e),Qt=n(e),u(X.$$.fragment,e),Yt=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-epfhsj"&&(Q.textContent=Yl),Et=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-n5dyw"&&(Y.textContent=El),Ft=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-qm2nt8"&&(E.innerHTML=Fl),Pt=n(e),u(F.$$.fragment,e),Nt=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-aqaw0f"&&(P.textContent=Pl),zt=n(e),u(N.$$.fragment,e),Lt=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ccsiy1"&&(z.innerHTML=Nl),Dt=n(e),u(L.$$.fragment,e),Ot=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-qutua8"&&(D.innerHTML=zl),Kt=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-uj5o95"&&(O.innerHTML=Ll),es=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1ozzcb1"&&(K.innerHTML=Dl),ts=n(e),u(ee.$$.fragment,e),ss=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-dq2kwm"&&(te.innerHTML=Ol),ls=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-kajnqt"&&(se.innerHTML=Kl),as=n(e),u(le.$$.fragment,e),ns=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1vjzmk"&&(ae.textContent=ea),is=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1147onl"&&(ne.textContent=ta),ps=n(e),u($.$$.fragment,e),os=n(e),u(ie.$$.fragment,e),rs=n(e),u(pe.$$.fragment,e),Ms=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-f1hll8"&&(oe.textContent=sa),us=n(e),u(re.$$.fragment,e),cs=n(e),Me=p(e,"UL",{"data-svelte-h":!0}),o(Me)!=="svelte-ul55gk"&&(Me.innerHTML=la),ys=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-khk897"&&(ue.textContent=aa),hs=n(e),u(ce.$$.fragment,e),ds=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1avk6lq"&&(ye.innerHTML=na),ms=n(e),u(he.$$.fragment,e),Js=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-pwj71q"&&(de.textContent=ia),Us=n(e),me=p(e,"UL",{"data-svelte-h":!0}),o(me)!=="svelte-gmdx7h"&&(me.innerHTML=pa),Ts=n(e),u(Je.$$.fragment,e),js=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1s9oaze"&&(Ue.innerHTML=oa),ws=n(e),u(x.$$.fragment,e),fs=n(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-m8oll3"&&(Te.textContent=ra),gs=n(e),u(je.$$.fragment,e),Is=n(e),we=p(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-f1hll8"&&(we.textContent=Ma),Cs=n(e),u(fe.$$.fragment,e),bs=n(e),ge=p(e,"UL",{"data-svelte-h":!0}),o(ge)!=="svelte-amxywc"&&(ge.innerHTML=ua),vs=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-khk897"&&(Ie.textContent=ca),$s=n(e),u(Ce.$$.fragment,e),xs=n(e),u(be.$$.fragment,e),As=n(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1wwgzam"&&(ve.innerHTML=ya),ks=n(e),u($e.$$.fragment,e),qs=n(e),xe=p(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-18yjufw"&&(xe.textContent=ha),Bs=n(e),u(Ae.$$.fragment,e),Hs=n(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1ar1qn2"&&(ke.textContent=da),Gs=n(e),u(qe.$$.fragment,e),_s=n(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1wwgzam"&&(Be.innerHTML=ma),Zs=n(e),u(He.$$.fragment,e),Rs=n(e),u(Ge.$$.fragment,e),Ss=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-16sv3hm"&&(_e.textContent=Ja),Ws=n(e),u(A.$$.fragment,e),Vs=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1ovcz13"&&(Ze.textContent=Ua),Xs=n(e),u(Re.$$.fragment,e),Qs=n(e),u(Se.$$.fragment,e),Ys=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-aop9q6"&&(We.textContent=Ta),Es=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-11lkosy"&&(Ve.textContent=ja),Fs=n(e),k=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-32c4s1"&&(k.innerHTML=wa),Ps=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1s4io98"&&(Xe.textContent=fa),Ns=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-2tk9q6"&&(Qe.textContent=ga),zs=n(e),Ye=p(e,"UL",{"data-svelte-h":!0}),o(Ye)!=="svelte-1t9sco3"&&(Ye.innerHTML=Ia),Ls=n(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-kzwdhh"&&(Ee.textContent=Ca),Ds=n(e),Fe=p(e,"UL",{"data-svelte-h":!0}),o(Fe)!=="svelte-ao16pi"&&(Fe.innerHTML=ba),Os=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1rp1v84"&&(Pe.textContent=va),Ks=n(e),u(Ne.$$.fragment,e),el=n(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-lf5sv5"&&(ze.innerHTML=$a),tl=n(e),q=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(q)!=="svelte-1roilif"&&(q.innerHTML=xa),sl=n(e),Le=p(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1072wo1"&&(Le.textContent=Aa),ll=n(e),u(De.$$.fragment,e),al=n(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-ogq2gt"&&(Oe.textContent=ka),nl=n(e),u(Ke.$$.fragment,e),il=n(e),et=p(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-krncuc"&&(et.textContent=qa),pl=n(e),u(tt.$$.fragment,e),ol=n(e),u(st.$$.fragment,e),rl=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-bpbibl"&&(lt.innerHTML=Ba),Ml=n(e),u(at.$$.fragment,e),ul=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-speu7d"&&(nt.textContent=Ha),cl=n(e),it=p(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-13ler1d"&&(it.innerHTML=Ga),yl=n(e),pt=p(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-ub059v"&&(pt.innerHTML=_a),hl=n(e),u(ot.$$.fragment,e),dl=n(e),u(rt.$$.fragment,e),ml=n(e),u(B.$$.fragment,e),Jl=n(e),u(Mt.$$.fragment,e),Ul=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-102eqn3"&&(ut.innerHTML=Za),Tl=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-lavds"&&(ct.innerHTML=Ra),jl=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-f0qt8k"&&(yt.textContent=Sa),wl=n(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-w9ft7n"&&(ht.textContent=Wa),fl=n(e),u(dt.$$.fragment,e),gl=n(e),u(mt.$$.fragment,e),Il=n(e),Jt=p(e,"UL",{"data-svelte-h":!0}),o(Jt)!=="svelte-117ozzs"&&(Jt.innerHTML=Va),Cl=n(e),u(Ut.$$.fragment,e),bl=n(e),Tt=p(e,"UL",{"data-svelte-h":!0}),o(Tt)!=="svelte-vl7c7p"&&(Tt.innerHTML=Xa),vl=n(e),u(jt.$$.fragment,e),$l=n(e),wt=p(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-ccionj"&&(wt.textContent=Qa),xl=n(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1dt3smc"&&(ft.textContent=Ya),Al=n(e),gt=p(e,"UL",{"data-svelte-h":!0}),o(gt)!=="svelte-1n9xyev"&&(gt.innerHTML=Ea),kl=n(e),u(It.$$.fragment,e),ql=n(e),Ct=p(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1yfr1yr"&&(Ct.innerHTML=Fa),Bl=n(e),bt=p(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1duzsqa"&&(bt.innerHTML=Pa),Hl=n(e),u(vt.$$.fragment,e),Gl=n(e),At=p(e,"P",{}),tn(At).forEach(s),this.h()},h(){kt(r,"name","hf:doc:metadata"),kt(r,"content",Un),kt(b,"class","flex justify-center"),kt(k,"class","flex justify-center"),kt(q,"class","flex justify-center")},m(e,t){on(document.head,r),l(e,U,t),l(e,m,t),l(e,T,t),c(I,e,t),l(e,w,t),c(g,e,t),l(e,qt,t),l(e,H,t),l(e,Bt,t),l(e,G,t),l(e,Ht,t),c(_,e,t),l(e,Gt,t),c(C,e,t),l(e,_t,t),l(e,Z,t),l(e,Zt,t),l(e,R,t),l(e,Rt,t),c(S,e,t),l(e,St,t),l(e,W,t),l(e,Wt,t),l(e,b,t),l(e,Vt,t),l(e,V,t),l(e,Xt,t),c(v,e,t),l(e,Qt,t),c(X,e,t),l(e,Yt,t),l(e,Q,t),l(e,Et,t),l(e,Y,t),l(e,Ft,t),l(e,E,t),l(e,Pt,t),c(F,e,t),l(e,Nt,t),l(e,P,t),l(e,zt,t),c(N,e,t),l(e,Lt,t),l(e,z,t),l(e,Dt,t),c(L,e,t),l(e,Ot,t),l(e,D,t),l(e,Kt,t),l(e,O,t),l(e,es,t),l(e,K,t),l(e,ts,t),c(ee,e,t),l(e,ss,t),l(e,te,t),l(e,ls,t),l(e,se,t),l(e,as,t),c(le,e,t),l(e,ns,t),l(e,ae,t),l(e,is,t),l(e,ne,t),l(e,ps,t),c($,e,t),l(e,os,t),c(ie,e,t),l(e,rs,t),c(pe,e,t),l(e,Ms,t),l(e,oe,t),l(e,us,t),c(re,e,t),l(e,cs,t),l(e,Me,t),l(e,ys,t),l(e,ue,t),l(e,hs,t),c(ce,e,t),l(e,ds,t),l(e,ye,t),l(e,ms,t),c(he,e,t),l(e,Js,t),l(e,de,t),l(e,Us,t),l(e,me,t),l(e,Ts,t),c(Je,e,t),l(e,js,t),l(e,Ue,t),l(e,ws,t),c(x,e,t),l(e,fs,t),l(e,Te,t),l(e,gs,t),c(je,e,t),l(e,Is,t),l(e,we,t),l(e,Cs,t),c(fe,e,t),l(e,bs,t),l(e,ge,t),l(e,vs,t),l(e,Ie,t),l(e,$s,t),c(Ce,e,t),l(e,xs,t),c(be,e,t),l(e,As,t),l(e,ve,t),l(e,ks,t),c($e,e,t),l(e,qs,t),l(e,xe,t),l(e,Bs,t),c(Ae,e,t),l(e,Hs,t),l(e,ke,t),l(e,Gs,t),c(qe,e,t),l(e,_s,t),l(e,Be,t),l(e,Zs,t),c(He,e,t),l(e,Rs,t),c(Ge,e,t),l(e,Ss,t),l(e,_e,t),l(e,Ws,t),c(A,e,t),l(e,Vs,t),l(e,Ze,t),l(e,Xs,t),c(Re,e,t),l(e,Qs,t),c(Se,e,t),l(e,Ys,t),l(e,We,t),l(e,Es,t),l(e,Ve,t),l(e,Fs,t),l(e,k,t),l(e,Ps,t),l(e,Xe,t),l(e,Ns,t),l(e,Qe,t),l(e,zs,t),l(e,Ye,t),l(e,Ls,t),l(e,Ee,t),l(e,Ds,t),l(e,Fe,t),l(e,Os,t),l(e,Pe,t),l(e,Ks,t),c(Ne,e,t),l(e,el,t),l(e,ze,t),l(e,tl,t),l(e,q,t),l(e,sl,t),l(e,Le,t),l(e,ll,t),c(De,e,t),l(e,al,t),l(e,Oe,t),l(e,nl,t),c(Ke,e,t),l(e,il,t),l(e,et,t),l(e,pl,t),c(tt,e,t),l(e,ol,t),c(st,e,t),l(e,rl,t),l(e,lt,t),l(e,Ml,t),c(at,e,t),l(e,ul,t),l(e,nt,t),l(e,cl,t),l(e,it,t),l(e,yl,t),l(e,pt,t),l(e,hl,t),c(ot,e,t),l(e,dl,t),c(rt,e,t),l(e,ml,t),c(B,e,t),l(e,Jl,t),c(Mt,e,t),l(e,Ul,t),l(e,ut,t),l(e,Tl,t),l(e,ct,t),l(e,jl,t),l(e,yt,t),l(e,wl,t),l(e,ht,t),l(e,fl,t),c(dt,e,t),l(e,gl,t),c(mt,e,t),l(e,Il,t),l(e,Jt,t),l(e,Cl,t),c(Ut,e,t),l(e,bl,t),l(e,Tt,t),l(e,vl,t),c(jt,e,t),l(e,$l,t),l(e,wt,t),l(e,xl,t),l(e,ft,t),l(e,Al,t),l(e,gt,t),l(e,kl,t),c(It,e,t),l(e,ql,t),l(e,Ct,t),l(e,Bl,t),l(e,bt,t),l(e,Hl,t),c(vt,e,t),l(e,Gl,t),l(e,At,t),_l=!0},p(e,[t]){const Na={};t&2&&(Na.$$scope={dirty:t,ctx:e}),g.$set(Na);const za={};t&2&&(za.$$scope={dirty:t,ctx:e}),C.$set(za);const La={};t&2&&(La.$$scope={dirty:t,ctx:e}),v.$set(La);const Da={};t&2&&(Da.$$scope={dirty:t,ctx:e}),$.$set(Da);const Oa={};t&2&&(Oa.$$scope={dirty:t,ctx:e}),x.$set(Oa);const Ka={};t&2&&(Ka.$$scope={dirty:t,ctx:e}),A.$set(Ka);const en={};t&2&&(en.$$scope={dirty:t,ctx:e}),B.$set(en)},i(e){_l||(y(I.$$.fragment,e),y(g.$$.fragment,e),y(_.$$.fragment,e),y(C.$$.fragment,e),y(S.$$.fragment,e),y(v.$$.fragment,e),y(X.$$.fragment,e),y(F.$$.fragment,e),y(N.$$.fragment,e),y(L.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y($.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(x.$$.fragment,e),y(je.$$.fragment,e),y(fe.$$.fragment,e),y(Ce.$$.fragment,e),y(be.$$.fragment,e),y($e.$$.fragment,e),y(Ae.$$.fragment,e),y(qe.$$.fragment,e),y(He.$$.fragment,e),y(Ge.$$.fragment,e),y(A.$$.fragment,e),y(Re.$$.fragment,e),y(Se.$$.fragment,e),y(Ne.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(tt.$$.fragment,e),y(st.$$.fragment,e),y(at.$$.fragment,e),y(ot.$$.fragment,e),y(rt.$$.fragment,e),y(B.$$.fragment,e),y(Mt.$$.fragment,e),y(dt.$$.fragment,e),y(mt.$$.fragment,e),y(Ut.$$.fragment,e),y(jt.$$.fragment,e),y(It.$$.fragment,e),y(vt.$$.fragment,e),_l=!0)},o(e){h(I.$$.fragment,e),h(g.$$.fragment,e),h(_.$$.fragment,e),h(C.$$.fragment,e),h(S.$$.fragment,e),h(v.$$.fragment,e),h(X.$$.fragment,e),h(F.$$.fragment,e),h(N.$$.fragment,e),h(L.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h($.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(Je.$$.fragment,e),h(x.$$.fragment,e),h(je.$$.fragment,e),h(fe.$$.fragment,e),h(Ce.$$.fragment,e),h(be.$$.fragment,e),h($e.$$.fragment,e),h(Ae.$$.fragment,e),h(qe.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),h(A.$$.fragment,e),h(Re.$$.fragment,e),h(Se.$$.fragment,e),h(Ne.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(B.$$.fragment,e),h(Mt.$$.fragment,e),h(dt.$$.fragment,e),h(mt.$$.fragment,e),h(Ut.$$.fragment,e),h(jt.$$.fragment,e),h(It.$$.fragment,e),h(vt.$$.fragment,e),_l=!1},d(e){e&&(s(U),s(m),s(T),s(w),s(qt),s(H),s(Bt),s(G),s(Ht),s(Gt),s(_t),s(Z),s(Zt),s(R),s(Rt),s(St),s(W),s(Wt),s(b),s(Vt),s(V),s(Xt),s(Qt),s(Yt),s(Q),s(Et),s(Y),s(Ft),s(E),s(Pt),s(Nt),s(P),s(zt),s(Lt),s(z),s(Dt),s(Ot),s(D),s(Kt),s(O),s(es),s(K),s(ts),s(ss),s(te),s(ls),s(se),s(as),s(ns),s(ae),s(is),s(ne),s(ps),s(os),s(rs),s(Ms),s(oe),s(us),s(cs),s(Me),s(ys),s(ue),s(hs),s(ds),s(ye),s(ms),s(Js),s(de),s(Us),s(me),s(Ts),s(js),s(Ue),s(ws),s(fs),s(Te),s(gs),s(Is),s(we),s(Cs),s(bs),s(ge),s(vs),s(Ie),s($s),s(xs),s(As),s(ve),s(ks),s(qs),s(xe),s(Bs),s(Hs),s(ke),s(Gs),s(_s),s(Be),s(Zs),s(Rs),s(Ss),s(_e),s(Ws),s(Vs),s(Ze),s(Xs),s(Qs),s(Ys),s(We),s(Es),s(Ve),s(Fs),s(k),s(Ps),s(Xe),s(Ns),s(Qe),s(zs),s(Ye),s(Ls),s(Ee),s(Ds),s(Fe),s(Os),s(Pe),s(Ks),s(el),s(ze),s(tl),s(q),s(sl),s(Le),s(ll),s(al),s(Oe),s(nl),s(il),s(et),s(pl),s(ol),s(rl),s(lt),s(Ml),s(ul),s(nt),s(cl),s(it),s(yl),s(pt),s(hl),s(dl),s(ml),s(Jl),s(Ul),s(ut),s(Tl),s(ct),s(jl),s(yt),s(wl),s(ht),s(fl),s(gl),s(Il),s(Jt),s(Cl),s(bl),s(Tt),s(vl),s($l),s(wt),s(xl),s(ft),s(Al),s(gt),s(kl),s(ql),s(Ct),s(Bl),s(bt),s(Hl),s(Gl),s(At)),s(r),d(I,e),d(g,e),d(_,e),d(C,e),d(S,e),d(v,e),d(X,e),d(F,e),d(N,e),d(L,e),d(ee,e),d(le,e),d($,e),d(ie,e),d(pe,e),d(re,e),d(ce,e),d(he,e),d(Je,e),d(x,e),d(je,e),d(fe,e),d(Ce,e),d(be,e),d($e,e),d(Ae,e),d(qe,e),d(He,e),d(Ge,e),d(A,e),d(Re,e),d(Se,e),d(Ne,e),d(De,e),d(Ke,e),d(tt,e),d(st,e),d(at,e),d(ot,e),d(rt,e),d(B,e),d(Mt,e),d(dt,e),d(mt,e),d(Ut,e),d(jt,e),d(It,e),d(vt,e)}}}const Un='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Using a tag-filter to map several HF models to a single inference endpoint","local":"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint","sections":[],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3},{"title":"Automatic validation","local":"automatic-validation","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"6. Add provider documentation","local":"6-add-provider-documentation","sections":[],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function Tn(j){return ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cn extends an{constructor(r){super(),nn(this,r,Tn,Jn,sn,{})}}export{Cn as component};
