import{s as Oe,o as lt,n as Al}from"../chunks/scheduler.2427eaa0.js";import{S as et,i as tt,g as i,s as M,r as w,A as st,h as p,f as t,c as a,j as ce,u as T,x as J,k as Ke,y as Ce,a as s,v as j,d as o,t as U,w as r}from"../chunks/index.cf54e274.js";import{T as gl}from"../chunks/Tip.ba8beabf.js";import{C as h}from"../chunks/CodeBlock.1a8c1d5b.js";import{H as G,E as Mt}from"../chunks/getInferenceSnippets.1f5c51db.js";function at(C){let n,u='TL;DR - this guide will show you how to build an AI image editor with Gradio and Inference Providers, just like <a href="https://huggingface.co/spaces/Qwen/Qwen-Image-Edit" rel="nofollow">this one</a>.';return{c(){n=i("p"),n.innerHTML=u},l(y){n=p(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-p6q67c"&&(n.innerHTML=u)},m(y,m){s(y,n,m)},p:Al,d(y){y&&t(n)}}}function nt(C){let n,u='This guide assumes you have a Hugging Face account. If you don’t have one, you can create one for free at <a href="https://huggingface.co" rel="nofollow">huggingface.co</a>.';return{c(){n=i("p"),n.innerHTML=u},l(y){n=p(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-al0ebp"&&(n.innerHTML=u)},m(y,m){s(y,n,m)},p:Al,d(y){y&&t(n)}}}function it(C){let n,u='We’re using <code>uv</code> because it’s a fast Python package manager that handles dependency resolution and virtual environment management automatically. It’s much faster than pip and provides better dependency resolution. If you’re not familiar with <code>uv</code>, check it out <a href="https://docs.astral.sh/uv/" rel="nofollow">here</a>.';return{c(){n=i("p"),n.innerHTML=u},l(y){n=p(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-10qfhud"&&(n.innerHTML=u)},m(y,m){s(y,n,m)},p:Al,d(y){y&&t(n)}}}function pt(C){let n,u="We’re using the <code>fal-ai</code> provider with the <code>Qwen/Qwen-Image-Edit</code> model. The fal-ai provider offers fast inference times, perfect for interactive applications.",y,m,g="However, you can experiment with different providers for various performance characteristics:",A,d,k;return d=new h({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KHByb3ZpZGVyJTNEJTIycmVwbGljYXRlJTIyJTJDJTIwYXBpX2tleSUzRG9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQocHJvdmlkZXIlM0QlMjJhdXRvJTIyJTJDJTIwYXBpX2tleSUzRG9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCklMjAlMjAlMjMlMjBBdXRvbWF0aWMlMjBzZWxlY3Rpb24=",highlighted:`client = InferenceClient(provider=<span class="hljs-string">&quot;replicate&quot;</span>, api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>])
client = InferenceClient(provider=<span class="hljs-string">&quot;auto&quot;</span>, api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>])  <span class="hljs-comment"># Automatic selection</span>`,wrap:!1}}),{c(){n=i("p"),n.innerHTML=u,y=M(),m=i("p"),m.textContent=g,A=M(),w(d.$$.fragment)},l(I){n=p(I,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1fognct"&&(n.innerHTML=u),y=a(I),m=p(I,"P",{"data-svelte-h":!0}),J(m)!=="svelte-1abjc87"&&(m.textContent=g),A=a(I),T(d.$$.fragment,I)},m(I,c){s(I,n,c),s(I,y,c),s(I,m,c),s(I,A,c),j(d,I,c),k=!0},p:Al,i(I){k||(o(d.$$.fragment,I),k=!0)},o(I){U(d.$$.fragment,I),k=!1},d(I){I&&(t(n),t(y),t(m),t(A)),r(d,I)}}}function yt(C){let n,u="The <code>uv export</code> command ensures that your Space will use the exact same dependency versions that you tested locally, preventing deployment issues caused by version mismatches.";return{c(){n=i("p"),n.innerHTML=u},l(y){n=p(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1ouf1uu"&&(n.innerHTML=u)},m(y,m){s(y,n,m)},p:Al,d(y){y&&t(n)}}}function Jt(C){let n,u,y,m,g,A,d,k='In this guide, we’ll build an AI-powered image editor that lets users upload images and edit them using natural language prompts. This project demonstrates how to combine Inference Providers with image-to-image models like <a href="https://huggingface.co/Qwen/Qwen-Image-Edit" rel="nofollow">Qwen’s Image Edit</a> and <a href="https://huggingface.co/black-forest-labs/FLUX.1-Kontext-dev" rel="nofollow">Black Forest Labs’ Flux Kontext</a>.',I,c,he="Our app will:",Bl,$,ge="<li><strong>Accept image uploads</strong> through a web interface</li> <li><strong>Process natural language prompts</strong> editing instructions like “Turn the cat into a tiger”</li> <li><strong>Transform images</strong> using Qwen Image Edit or FLUX.1 Kontext</li> <li><strong>Display results</strong> in a Gradio interface</li>",fl,B,bl,v,Zl,Q,Ae="Before we start coding, authenticate with Hugging Face using your token:",Wl,X,El,f,Gl,R,Be='When you set this environment variable, it handles authentication automatically for all your inference calls. You can generate a token from <a href="https://huggingface.co/settings/tokens/new?ownUserPermissions=inference.serverless.write&amp;tokenType=fineGrained" rel="nofollow">your settings page</a>.',kl,S,$l,_,fe="Create a new project directory and initialize it with uv:",vl,H,Ql,V,be="This creates a basic project structure with a <code>pyproject.toml</code> file. Now add the required dependencies:",Xl,q,Rl,F,Ze="The dependencies are now installed and ready to use! Also, <code>uv</code> will maintain the <code>pyproject.toml</code> file for you as you add dependencies.",Sl,b,_l,x,Hl,Y,We="Now let’s create the main logic for our application - the image editing function that transforms images using AI.",Vl,N,Ee="Create <code>main.py</code> then import the necessary libraries and instantiate the InferenceClient. We’re using the <code>fal-ai</code> provider for fast image processing, but other providers like <code>replicate</code> are also available.",ql,z,Fl,L,Ge="Now let’s create the image editing function. This function takes an input image and a prompt, and returns an edited image. We also want to handle errors gracefully and return the original image if there’s an error, so our UI always shows something.",xl,P,Yl,Z,Nl,D,zl,K,ke="Now let’s build a simple user-friendly interface using Gradio.",Ll,O,Pl,ll,$e="In this app we’ll use some practical Gradio features to make a user-friendly app",Dl,el,ve="<li>We’ll use blocks to create a two column layout with the image upload and the edited image.</li> <li>We’ll drop some markdown into to explain what the app does.</li> <li>And, we’ll use <code>gr.Examples</code> to show some example inputs to give the user some inspiration.</li>",Kl,tl,Qe="Finally, add the launch configuration at the end of <code>main.py</code>:",Ol,sl,le,Ml,Xe="Now run your application:",ee,al,te,nl,Re="Your app will launch locally at <code>http://localhost:7860</code> and Gradio will also provide a public shareable link!",se,il,Me,W,Cl,Se="<strong>📋 Click to view the complete main.py file</strong>",de,pl,ae,yl,ne,Jl,_e="Let’s deploy our app to Hugging Face Spaces.",ie,wl,He="First, we will export our dependencies to a requirements file.",pe,Tl,ye,jl,Ve="This creates a <code>requirements.txt</code> file with all your project dependencies and their exact versions from the lockfile.",Je,E,we,ol,qe="Now you can deploy to Spaces:",Te,Ul,Fe='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Gradio SDK</strong> and make it public</li> <li><strong>Upload your files</strong>: Upload <code>main.py</code>, <code>requirements.txt</code>, and any example images</li> <li><strong>Add your token</strong>: In Space settings, add <code>HF_TOKEN</code> as a secret</li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',je,rl,oe,Il,xe="Congratulations! You’ve created a production-ready AI image editor. Now that you have a working image editor, here are some ideas to extend it:",Ue,ml,Ye="<li><strong>Batch processing</strong>: Edit multiple images at once</li> <li><strong>Object removal</strong>: Remove unwanted objects from images</li> <li><strong>Provider comparison</strong>: Benchmark different providers for your use case</li>",re,ul,Ne="Happy building! And remember to share your app with the community on the Hub.",Ie,dl,me,hl,ue;return g=new G({props:{title:"Building an AI Image Editor with Gradio and Inference Providers",local:"building-an-ai-image-editor-with-gradio-and-inference-providers",headingTag:"h1"}}),B=new gl({props:{$$slots:{default:[at]},$$scope:{ctx:C}}}),v=new G({props:{title:"Step 1: Set Up Authentication",local:"step-1-set-up-authentication",headingTag:"h2"}}),X=new h({props:{code:"JTIzJTIwR2V0JTIweW91ciUyMHRva2VuJTIwZnJvbSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzZXR0aW5ncyUyRnRva2VucyUwQWV4cG9ydCUyMEhGX1RPS0VOJTNEJTIyeW91cl90b2tlbl9oZXJlJTIy",highlighted:`<span class="hljs-comment"># Get your token from https://huggingface.co/settings/tokens</span>
<span class="hljs-built_in">export</span> HF_TOKEN=<span class="hljs-string">&quot;your_token_here&quot;</span>`,wrap:!1}}),f=new gl({props:{$$slots:{default:[nt]},$$scope:{ctx:C}}}),S=new G({props:{title:"Step 2: Project Setup",local:"step-2-project-setup",headingTag:"h2"}}),H=new h({props:{code:"bWtkaXIlMjBpbWFnZS1lZGl0b3ItYXBwJTBBY2QlMjBpbWFnZS1lZGl0b3ItYXBwJTBBdXYlMjBpbml0",highlighted:`<span class="hljs-built_in">mkdir</span> image-editor-app
<span class="hljs-built_in">cd</span> image-editor-app
uv init`,wrap:!1}}),q=new h({props:{code:"dXYlMjBhZGQlMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjM0LjQlMjBncmFkaW8lM0UlM0Q1LjAuMCUyMHBpbGxvdyUzRSUzRDExLjMuMA==",highlighted:"uv add huggingface-hub&gt;=0.34.4 gradio&gt;=5.0.0 pillow&gt;=11.3.0",wrap:!1}}),b=new gl({props:{$$slots:{default:[it]},$$scope:{ctx:C}}}),x=new G({props:{title:"Step 3: Build the Core Image Editing Function",local:"step-3-build-the-core-image-editing-function",headingTag:"h2"}}),z=new h({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWltcG9ydCUyMGlvJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGNsaWVudCUyMHdpdGglMjBmYWwtYWklMjBwcm92aWRlciUyMGZvciUyMGZhc3QlMjBpbWFnZSUyMHByb2Nlc3NpbmclMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJmYWwtYWklMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">import</span> io

<span class="hljs-comment"># Initialize the client with fal-ai provider for fast image processing</span>
client = InferenceClient(
    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
    api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>],
)`,wrap:!1}}),P=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, prompt</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Edit an image using the given prompt.
    
    Args:
        input_image: PIL Image object from Gradio
        prompt: String prompt for image editing
    
    Returns:
        PIL Image object (edited image)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> input_image <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> prompt <span class="hljs-keyword">or</span> prompt.strip() == <span class="hljs-string">&quot;&quot;</span>:
        <span class="hljs-keyword">return</span> input_image
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Convert PIL Image to bytes</span>
        img_bytes = io.BytesIO()
        input_image.save(img_bytes, <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;PNG&quot;</span>)
        img_bytes = img_bytes.getvalue()
        
        <span class="hljs-comment"># Use the image_to_image method with Qwen&#x27;s image editing model</span>
        edited_image = client.image_to_image(
            img_bytes,
            prompt=prompt.strip(),
            model=<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>,
        )
        
        <span class="hljs-keyword">return</span> edited_image
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error editing image: <span class="hljs-subst">{e}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> input_image`,wrap:!1}}),Z=new gl({props:{$$slots:{default:[pt]},$$scope:{ctx:C}}}),D=new G({props:{title:"Step 4: Create the Gradio Interface",local:"step-4-create-the-gradio-interface",headingTag:"h2"}}),O=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># Create the Gradio interface</span>
<span class="hljs-keyword">with</span> gr.Blocks(title=<span class="hljs-string">&quot;Image Editor&quot;</span>, theme=gr.themes.Soft()) <span class="hljs-keyword">as</span> interface:
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
        # 🎨 AI Image Editor
        Upload an image and describe how you want to edit it using natural language!
        &quot;&quot;&quot;</span>
    )

    <span class="hljs-keyword">with</span> gr.Row():
        <span class="hljs-keyword">with</span> gr.Column():
            input_image = gr.Image(label=<span class="hljs-string">&quot;Upload Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)
            prompt = gr.Textbox(
                label=<span class="hljs-string">&quot;Edit Prompt&quot;</span>,
                placeholder=<span class="hljs-string">&quot;Describe how you want to edit the image...&quot;</span>,
                lines=<span class="hljs-number">2</span>,
            )
            edit_btn = gr.Button(<span class="hljs-string">&quot;✨ Edit Image&quot;</span>, variant=<span class="hljs-string">&quot;primary&quot;</span>, size=<span class="hljs-string">&quot;lg&quot;</span>)

        <span class="hljs-keyword">with</span> gr.Column():
            output_image = gr.Image(label=<span class="hljs-string">&quot;Edited Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)

    <span class="hljs-comment"># Example images and prompts</span>
    <span class="hljs-keyword">with</span> gr.Row():
        gr.Examples(
            examples=[
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Turn the cat into a tiger&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Make it look like a watercolor painting&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Change the background to a forest&quot;</span>],
            ],
            inputs=[input_image, prompt],
            outputs=output_image,
            fn=edit_image,
            cache_examples=<span class="hljs-literal">False</span>,
        )

    <span class="hljs-comment"># Event handlers</span>
    edit_btn.click(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)

    <span class="hljs-comment"># Allow Enter key to trigger editing</span>
    prompt.submit(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)`,wrap:!1}}),sl=new h({props:{code:"aWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwaW50ZXJmYWNlLmxhdW5jaCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaGFyZSUzRFRydWUlMkMlMjAlMjAlMjMlMjBDcmVhdGVzJTIwYSUyMHB1YmxpYyUyMGxpbmslMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZXJ2ZXJfbmFtZSUzRCUyMjAuMC4wLjAlMjIlMkMlMjAlMjAlMjMlMjBBbGxvdyUyMGV4dGVybmFsJTIwYWNjZXNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VydmVyX3BvcnQlM0Q3ODYwJTJDJTIwJTIwJTIzJTIwRGVmYXVsdCUyMEdyYWRpbyUyMHBvcnQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaG93X2Vycm9yJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMFNob3clMjBlcnJvcnMlMjBpbiUyMHRoZSUyMGludGVyZmFjZSUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    interface.launch(
        share=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Creates a public link</span>
        server_name=<span class="hljs-string">&quot;0.0.0.0&quot;</span>,  <span class="hljs-comment"># Allow external access</span>
        server_port=<span class="hljs-number">7860</span>,  <span class="hljs-comment"># Default Gradio port</span>
        show_error=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Show errors in the interface</span>
    )`,wrap:!1}}),al=new h({props:{code:"cHl0aG9uJTIwbWFpbi5weQ==",highlighted:"python main.py",wrap:!1}}),il=new G({props:{title:"Complete Working Code",local:"complete-working-code",headingTag:"h2"}}),pl=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> io

<span class="hljs-comment"># Initialize the client</span>
client = InferenceClient(
    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
    api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>],
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, prompt</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Edit an image using the given prompt.
    
    Args:
        input_image: PIL Image object from Gradio
        prompt: String prompt for image editing
    
    Returns:
        PIL Image object (edited image)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> input_image <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> prompt <span class="hljs-keyword">or</span> prompt.strip() == <span class="hljs-string">&quot;&quot;</span>:
        <span class="hljs-keyword">return</span> input_image
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Convert PIL Image to bytes</span>
        img_bytes = io.BytesIO()
        input_image.save(img_bytes, <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;PNG&quot;</span>)
        img_bytes = img_bytes.getvalue()
        
        <span class="hljs-comment"># Use the image_to_image method</span>
        edited_image = client.image_to_image(
            img_bytes,
            prompt=prompt.strip(),
            model=<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>,
        )
        
        <span class="hljs-keyword">return</span> edited_image
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error editing image: <span class="hljs-subst">{e}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> input_image

<span class="hljs-comment"># Create Gradio interface</span>
<span class="hljs-keyword">with</span> gr.Blocks(title=<span class="hljs-string">&quot;Image Editor&quot;</span>, theme=gr.themes.Soft()) <span class="hljs-keyword">as</span> interface:
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
        # 🎨 AI Image Editor
        Upload an image and describe how you want to edit it using natural language!
        &quot;&quot;&quot;</span>
    )

    <span class="hljs-keyword">with</span> gr.Row():
        <span class="hljs-keyword">with</span> gr.Column():
            input_image = gr.Image(label=<span class="hljs-string">&quot;Upload Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)
            prompt = gr.Textbox(
                label=<span class="hljs-string">&quot;Edit Prompt&quot;</span>,
                placeholder=<span class="hljs-string">&quot;Describe how you want to edit the image...&quot;</span>,
                lines=<span class="hljs-number">2</span>,
            )
            edit_btn = gr.Button(<span class="hljs-string">&quot;✨ Edit Image&quot;</span>, variant=<span class="hljs-string">&quot;primary&quot;</span>, size=<span class="hljs-string">&quot;lg&quot;</span>)

        <span class="hljs-keyword">with</span> gr.Column():
            output_image = gr.Image(label=<span class="hljs-string">&quot;Edited Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)

    <span class="hljs-comment"># Example images and prompts</span>
    <span class="hljs-keyword">with</span> gr.Row():
        gr.Examples(
            examples=[
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Turn the cat into a tiger&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Make it look like a watercolor painting&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Change the background to a forest&quot;</span>],
            ],
            inputs=[input_image, prompt],
            outputs=output_image,
            fn=edit_image,
            cache_examples=<span class="hljs-literal">False</span>,
        )

    <span class="hljs-comment"># Event handlers</span>
    edit_btn.click(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)

    <span class="hljs-comment"># Allow Enter key to trigger editing</span>
    prompt.submit(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    interface.launch(
        share=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Creates a public link</span>
        server_name=<span class="hljs-string">&quot;0.0.0.0&quot;</span>,  <span class="hljs-comment"># Allow external access</span>
        server_port=<span class="hljs-number">7860</span>,  <span class="hljs-comment"># Default Gradio port</span>
        show_error=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Show errors in the interface</span>
    )`,wrap:!1}}),yl=new G({props:{title:"Deploy on Hugging Face Spaces",local:"deploy-on-hugging-face-spaces",headingTag:"h2"}}),Tl=new h({props:{code:"dXYlMjBleHBvcnQlMjAtLWZvcm1hdCUyMHJlcXVpcmVtZW50cy10eHQlMjAtLW91dHB1dC1maWxlJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:'uv <span class="hljs-built_in">export</span> --format requirements-txt --output-file requirements.txt',wrap:!1}}),E=new gl({props:{$$slots:{default:[yt]},$$scope:{ctx:C}}}),rl=new G({props:{title:"Next Steps",local:"next-steps",headingTag:"h1"}}),dl=new Mt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/guides/image-editor.md"}}),{c(){n=i("meta"),u=M(),y=i("p"),m=M(),w(g.$$.fragment),A=M(),d=i("p"),d.innerHTML=k,I=M(),c=i("p"),c.textContent=he,Bl=M(),$=i("ol"),$.innerHTML=ge,fl=M(),w(B.$$.fragment),bl=M(),w(v.$$.fragment),Zl=M(),Q=i("p"),Q.textContent=Ae,Wl=M(),w(X.$$.fragment),El=M(),w(f.$$.fragment),Gl=M(),R=i("p"),R.innerHTML=Be,kl=M(),w(S.$$.fragment),$l=M(),_=i("p"),_.textContent=fe,vl=M(),w(H.$$.fragment),Ql=M(),V=i("p"),V.innerHTML=be,Xl=M(),w(q.$$.fragment),Rl=M(),F=i("p"),F.innerHTML=Ze,Sl=M(),w(b.$$.fragment),_l=M(),w(x.$$.fragment),Hl=M(),Y=i("p"),Y.textContent=We,Vl=M(),N=i("p"),N.innerHTML=Ee,ql=M(),w(z.$$.fragment),Fl=M(),L=i("p"),L.textContent=Ge,xl=M(),w(P.$$.fragment),Yl=M(),w(Z.$$.fragment),Nl=M(),w(D.$$.fragment),zl=M(),K=i("p"),K.textContent=ke,Ll=M(),w(O.$$.fragment),Pl=M(),ll=i("p"),ll.textContent=$e,Dl=M(),el=i("ul"),el.innerHTML=ve,Kl=M(),tl=i("p"),tl.innerHTML=Qe,Ol=M(),w(sl.$$.fragment),le=M(),Ml=i("p"),Ml.textContent=Xe,ee=M(),w(al.$$.fragment),te=M(),nl=i("p"),nl.innerHTML=Re,se=M(),w(il.$$.fragment),Me=M(),W=i("details"),Cl=i("summary"),Cl.innerHTML=Se,de=M(),w(pl.$$.fragment),ae=M(),w(yl.$$.fragment),ne=M(),Jl=i("p"),Jl.textContent=_e,ie=M(),wl=i("p"),wl.textContent=He,pe=M(),w(Tl.$$.fragment),ye=M(),jl=i("p"),jl.innerHTML=Ve,Je=M(),w(E.$$.fragment),we=M(),ol=i("p"),ol.textContent=qe,Te=M(),Ul=i("ol"),Ul.innerHTML=Fe,je=M(),w(rl.$$.fragment),oe=M(),Il=i("p"),Il.textContent=xe,Ue=M(),ml=i("ul"),ml.innerHTML=Ye,re=M(),ul=i("p"),ul.textContent=Ne,Ie=M(),w(dl.$$.fragment),me=M(),hl=i("p"),this.h()},l(l){const e=st("svelte-u9bgzb",document.head);n=p(e,"META",{name:!0,content:!0}),e.forEach(t),u=a(l),y=p(l,"P",{}),ce(y).forEach(t),m=a(l),T(g.$$.fragment,l),A=a(l),d=p(l,"P",{"data-svelte-h":!0}),J(d)!=="svelte-1lwj79"&&(d.innerHTML=k),I=a(l),c=p(l,"P",{"data-svelte-h":!0}),J(c)!=="svelte-5khb3j"&&(c.textContent=he),Bl=a(l),$=p(l,"OL",{"data-svelte-h":!0}),J($)!=="svelte-1tdc6o3"&&($.innerHTML=ge),fl=a(l),T(B.$$.fragment,l),bl=a(l),T(v.$$.fragment,l),Zl=a(l),Q=p(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-tq00s0"&&(Q.textContent=Ae),Wl=a(l),T(X.$$.fragment,l),El=a(l),T(f.$$.fragment,l),Gl=a(l),R=p(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-7lseeu"&&(R.innerHTML=Be),kl=a(l),T(S.$$.fragment,l),$l=a(l),_=p(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-10bv6uk"&&(_.textContent=fe),vl=a(l),T(H.$$.fragment,l),Ql=a(l),V=p(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-j4q1gw"&&(V.innerHTML=be),Xl=a(l),T(q.$$.fragment,l),Rl=a(l),F=p(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-lfv1uk"&&(F.innerHTML=Ze),Sl=a(l),T(b.$$.fragment,l),_l=a(l),T(x.$$.fragment,l),Hl=a(l),Y=p(l,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-gq6411"&&(Y.textContent=We),Vl=a(l),N=p(l,"P",{"data-svelte-h":!0}),J(N)!=="svelte-lqetpu"&&(N.innerHTML=Ee),ql=a(l),T(z.$$.fragment,l),Fl=a(l),L=p(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-pkwggc"&&(L.textContent=Ge),xl=a(l),T(P.$$.fragment,l),Yl=a(l),T(Z.$$.fragment,l),Nl=a(l),T(D.$$.fragment,l),zl=a(l),K=p(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1ifovm8"&&(K.textContent=ke),Ll=a(l),T(O.$$.fragment,l),Pl=a(l),ll=p(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-p4zrwe"&&(ll.textContent=$e),Dl=a(l),el=p(l,"UL",{"data-svelte-h":!0}),J(el)!=="svelte-10pi7wb"&&(el.innerHTML=ve),Kl=a(l),tl=p(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-3szit3"&&(tl.innerHTML=Qe),Ol=a(l),T(sl.$$.fragment,l),le=a(l),Ml=p(l,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-d2kn7k"&&(Ml.textContent=Xe),ee=a(l),T(al.$$.fragment,l),te=a(l),nl=p(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-17a15t8"&&(nl.innerHTML=Re),se=a(l),T(il.$$.fragment,l),Me=a(l),W=p(l,"DETAILS",{});var cl=ce(W);Cl=p(cl,"SUMMARY",{"data-svelte-h":!0}),J(Cl)!=="svelte-n96not"&&(Cl.innerHTML=Se),de=a(cl),T(pl.$$.fragment,cl),cl.forEach(t),ae=a(l),T(yl.$$.fragment,l),ne=a(l),Jl=p(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-1spby4r"&&(Jl.textContent=_e),ie=a(l),wl=p(l,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-xvxsbj"&&(wl.textContent=He),pe=a(l),T(Tl.$$.fragment,l),ye=a(l),jl=p(l,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-ni8320"&&(jl.innerHTML=Ve),Je=a(l),T(E.$$.fragment,l),we=a(l),ol=p(l,"P",{"data-svelte-h":!0}),J(ol)!=="svelte-l20dtq"&&(ol.textContent=qe),Te=a(l),Ul=p(l,"OL",{"data-svelte-h":!0}),J(Ul)!=="svelte-1pxk9y6"&&(Ul.innerHTML=Fe),je=a(l),T(rl.$$.fragment,l),oe=a(l),Il=p(l,"P",{"data-svelte-h":!0}),J(Il)!=="svelte-1urmb67"&&(Il.textContent=xe),Ue=a(l),ml=p(l,"UL",{"data-svelte-h":!0}),J(ml)!=="svelte-g1f6dz"&&(ml.innerHTML=Ye),re=a(l),ul=p(l,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-1xr8bs4"&&(ul.textContent=Ne),Ie=a(l),T(dl.$$.fragment,l),me=a(l),hl=p(l,"P",{}),ce(hl).forEach(t),this.h()},h(){Ke(n,"name","hf:doc:metadata"),Ke(n,"content",wt)},m(l,e){Ce(document.head,n),s(l,u,e),s(l,y,e),s(l,m,e),j(g,l,e),s(l,A,e),s(l,d,e),s(l,I,e),s(l,c,e),s(l,Bl,e),s(l,$,e),s(l,fl,e),j(B,l,e),s(l,bl,e),j(v,l,e),s(l,Zl,e),s(l,Q,e),s(l,Wl,e),j(X,l,e),s(l,El,e),j(f,l,e),s(l,Gl,e),s(l,R,e),s(l,kl,e),j(S,l,e),s(l,$l,e),s(l,_,e),s(l,vl,e),j(H,l,e),s(l,Ql,e),s(l,V,e),s(l,Xl,e),j(q,l,e),s(l,Rl,e),s(l,F,e),s(l,Sl,e),j(b,l,e),s(l,_l,e),j(x,l,e),s(l,Hl,e),s(l,Y,e),s(l,Vl,e),s(l,N,e),s(l,ql,e),j(z,l,e),s(l,Fl,e),s(l,L,e),s(l,xl,e),j(P,l,e),s(l,Yl,e),j(Z,l,e),s(l,Nl,e),j(D,l,e),s(l,zl,e),s(l,K,e),s(l,Ll,e),j(O,l,e),s(l,Pl,e),s(l,ll,e),s(l,Dl,e),s(l,el,e),s(l,Kl,e),s(l,tl,e),s(l,Ol,e),j(sl,l,e),s(l,le,e),s(l,Ml,e),s(l,ee,e),j(al,l,e),s(l,te,e),s(l,nl,e),s(l,se,e),j(il,l,e),s(l,Me,e),s(l,W,e),Ce(W,Cl),Ce(W,de),j(pl,W,null),s(l,ae,e),j(yl,l,e),s(l,ne,e),s(l,Jl,e),s(l,ie,e),s(l,wl,e),s(l,pe,e),j(Tl,l,e),s(l,ye,e),s(l,jl,e),s(l,Je,e),j(E,l,e),s(l,we,e),s(l,ol,e),s(l,Te,e),s(l,Ul,e),s(l,je,e),j(rl,l,e),s(l,oe,e),s(l,Il,e),s(l,Ue,e),s(l,ml,e),s(l,re,e),s(l,ul,e),s(l,Ie,e),j(dl,l,e),s(l,me,e),s(l,hl,e),ue=!0},p(l,[e]){const cl={};e&2&&(cl.$$scope={dirty:e,ctx:l}),B.$set(cl);const ze={};e&2&&(ze.$$scope={dirty:e,ctx:l}),f.$set(ze);const Le={};e&2&&(Le.$$scope={dirty:e,ctx:l}),b.$set(Le);const Pe={};e&2&&(Pe.$$scope={dirty:e,ctx:l}),Z.$set(Pe);const De={};e&2&&(De.$$scope={dirty:e,ctx:l}),E.$set(De)},i(l){ue||(o(g.$$.fragment,l),o(B.$$.fragment,l),o(v.$$.fragment,l),o(X.$$.fragment,l),o(f.$$.fragment,l),o(S.$$.fragment,l),o(H.$$.fragment,l),o(q.$$.fragment,l),o(b.$$.fragment,l),o(x.$$.fragment,l),o(z.$$.fragment,l),o(P.$$.fragment,l),o(Z.$$.fragment,l),o(D.$$.fragment,l),o(O.$$.fragment,l),o(sl.$$.fragment,l),o(al.$$.fragment,l),o(il.$$.fragment,l),o(pl.$$.fragment,l),o(yl.$$.fragment,l),o(Tl.$$.fragment,l),o(E.$$.fragment,l),o(rl.$$.fragment,l),o(dl.$$.fragment,l),ue=!0)},o(l){U(g.$$.fragment,l),U(B.$$.fragment,l),U(v.$$.fragment,l),U(X.$$.fragment,l),U(f.$$.fragment,l),U(S.$$.fragment,l),U(H.$$.fragment,l),U(q.$$.fragment,l),U(b.$$.fragment,l),U(x.$$.fragment,l),U(z.$$.fragment,l),U(P.$$.fragment,l),U(Z.$$.fragment,l),U(D.$$.fragment,l),U(O.$$.fragment,l),U(sl.$$.fragment,l),U(al.$$.fragment,l),U(il.$$.fragment,l),U(pl.$$.fragment,l),U(yl.$$.fragment,l),U(Tl.$$.fragment,l),U(E.$$.fragment,l),U(rl.$$.fragment,l),U(dl.$$.fragment,l),ue=!1},d(l){l&&(t(u),t(y),t(m),t(A),t(d),t(I),t(c),t(Bl),t($),t(fl),t(bl),t(Zl),t(Q),t(Wl),t(El),t(Gl),t(R),t(kl),t($l),t(_),t(vl),t(Ql),t(V),t(Xl),t(Rl),t(F),t(Sl),t(_l),t(Hl),t(Y),t(Vl),t(N),t(ql),t(Fl),t(L),t(xl),t(Yl),t(Nl),t(zl),t(K),t(Ll),t(Pl),t(ll),t(Dl),t(el),t(Kl),t(tl),t(Ol),t(le),t(Ml),t(ee),t(te),t(nl),t(se),t(Me),t(W),t(ae),t(ne),t(Jl),t(ie),t(wl),t(pe),t(ye),t(jl),t(Je),t(we),t(ol),t(Te),t(Ul),t(je),t(oe),t(Il),t(Ue),t(ml),t(re),t(ul),t(Ie),t(me),t(hl)),t(n),r(g,l),r(B,l),r(v,l),r(X,l),r(f,l),r(S,l),r(H,l),r(q,l),r(b,l),r(x,l),r(z,l),r(P,l),r(Z,l),r(D,l),r(O,l),r(sl,l),r(al,l),r(il,l),r(pl),r(yl,l),r(Tl,l),r(E,l),r(rl,l),r(dl,l)}}}const wt='{"title":"Building an AI Image Editor with Gradio and Inference Providers","local":"building-an-ai-image-editor-with-gradio-and-inference-providers","sections":[{"title":"Step 1: Set Up Authentication","local":"step-1-set-up-authentication","sections":[],"depth":2},{"title":"Step 2: Project Setup","local":"step-2-project-setup","sections":[],"depth":2},{"title":"Step 3: Build the Core Image Editing Function","local":"step-3-build-the-core-image-editing-function","sections":[],"depth":2},{"title":"Step 4: Create the Gradio Interface","local":"step-4-create-the-gradio-interface","sections":[],"depth":2},{"title":"Complete Working Code","local":"complete-working-code","sections":[],"depth":2},{"title":"Deploy on Hugging Face Spaces","local":"deploy-on-hugging-face-spaces","sections":[],"depth":2}],"depth":1}';function Tt(C){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends et{constructor(n){super(),tt(this,n,Tt,Jt,Oe,{})}}export{mt as component};
