import{s as po,o as uo,n as Ue}from"../chunks/scheduler.18a86fab.js";import{S as fo,i as go,g as d,s as a,r as m,A as _o,h as c,f as n,c as s,j as oe,u as p,x as M,k as Z,y as l,a as i,v as u,d as f,t as g,w as _}from"../chunks/index.98837b22.js";import{T as ho}from"../chunks/Tip.77304350.js";import{D as ue}from"../chunks/Docstring.6758ea23.js";import{C as Qe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as mo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as me}from"../chunks/Heading.7e7e0c5b.js";import{E as bo}from"../chunks/index.499f366c.js";function yo(I){let t,b;return t=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvaGVyZTJNb2RlbCUyQyUyMENvaGVyZTJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ29oZXJlJTIwTmV4dG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDb2hlcmUyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwQ29oZXJlMiUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMENvaGVyZTJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Cohere2Model, Cohere2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Cohere Nextmodel configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Cohere2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Cohere2 configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Cohere2Model(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(t.$$.fragment)},l(r){p(t.$$.fragment,r)},m(r,y){u(t,r,y),b=!0},p:Ue,i(r){b||(f(t.$$.fragment,r),b=!0)},o(r){g(t.$$.fragment,r),b=!1},d(r){_(t,r)}}}function Mo(I){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(r){t=c(r,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(r,y){i(r,t,y)},p:Ue,d(r){r&&n(t)}}}function To(I){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(r){t=c(r,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(r,y){i(r,t,y)},p:Ue,d(r){r&&n(t)}}}function wo(I){let t,b="Example:",r,y,x;return y=new Qe({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDb2hlcmUyRm9yQ2F1c2FsTE0lMEElMEElM0UlM0UlMjBtb2RlbCUyMCUzRCUyMENvaGVyZTJGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyQ29oZXJlMkZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyKSUwQSUzRSUzRSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvaGVyZTJGb3JBSSUyRmM0YWktY29tbWFuZC1yLXYwMSUyMiklMEElMEElM0UlM0UlMjBwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQSUzRSUzRSUyMGlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUzRSUzRSUyMCUyMyUyMEdlbmVyYXRlJTBBJTNFJTNFJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEElM0UlM0UlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQlMEElMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiU1Q25JJ20lMjBub3QlMjBjb25zY2lvdXMlMkMlMjBidXQlMjBJJTIwY2FuJTIwdGFsayUyMHRvJTIweW91LiUyMg==",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Cohere2ForCausalLM

&gt;&gt; model = Cohere2ForCausalLM.from_pretrained(<span class="hljs-string">&quot;Cohere2ForAI/c4ai-command-r-v01&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Cohere2ForAI/c4ai-command-r-v01&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){t=d("p"),t.textContent=b,r=a(),m(y.$$.fragment)},l(h){t=c(h,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=b),r=s(h),p(y.$$.fragment,h)},m(h,$){i(h,t,$),i(h,r,$),u(y,h,$),x=!0},p:Ue,i(h){x||(f(y.$$.fragment,h),x=!0)},o(h){g(y.$$.fragment,h),x=!1},d(h){h&&(n(t),n(r)),_(y,h)}}}function Co(I){let t,b,r,y,x,h,$,Se='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',fe,R,ge,P,Ye='<a href="https://cohere.com/blog/command-r7b" rel="nofollow">C4AI Command R7B</a> is an open weights research release of a 7B billion parameter model developed by Cohere and Cohere For AI. It has advanced capabilities optimized for various use cases, including reasoning, summarization, question answering, and code. The model is trained to perform sophisticated tasks including Retrieval Augmented Generation (RAG) and tool use. The model also has powerful agentic capabilities that can use and combine multiple tools over multiple steps to accomplish more difficult tasks. It obtains top performance on enterprise-relevant code use cases. C4AI Command R7B is a multilingual model trained on 23 languages.',_e,q,De="The model features three layers with sliding window attention (window size 4096) and ROPE for efficient local context modeling and relative positional encoding. A fourth layer uses global attention without positional embeddings, enabling unrestricted token interactions across the entire sequence.",be,G,Oe="The model has been trained on 23 languages: English, French, Spanish, Italian, German, Portuguese, Japanese, Korean, Arabic, Chinese, Russian, Polish, Turkish, Vietnamese, Dutch, Czech, Indonesian, Ukrainian, Romanian, Greek, Hindi, Hebrew, and Persian.",ye,X,Me,V,Ke="The model and tokenizer can be loaded via:",Te,A,we,N,Ce,C,H,je,te,eo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereModel">CohereModel</a>. It is used to instantiate an Cohere
model according to the specified arguments, defining the model architecture.`,Fe,ne,oo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">CohereForAI/c4ai-command-r-v01</a> model.`,We,F,ve,Q,ke,T,S,Be,ae,to="The bare Cohere2 Model outputting raw hidden-states without any specific head on top.",Le,se,no=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ee,re,ao=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ze,U,Y,Re,ie,so='The <a href="/docs/transformers/main/en/model_doc/cohere2#transformers.Cohere2Model">Cohere2Model</a> forward method, overrides the <code>__call__</code> special method.',Pe,W,xe,D,$e,w,O,qe,le,ro="The Cohere2 Model for causal language modeling.",Ge,de,io=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xe,ce,lo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ve,z,K,Ae,he,co='The <a href="/docs/transformers/main/en/model_doc/cohere2#transformers.Cohere2ForCausalLM">Cohere2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Ne,B,He,L,ze,ee,Je,pe,Ie;return x=new me({props:{title:"Cohere",local:"cohere",headingTag:"h1"}}),R=new me({props:{title:"Overview",local:"overview",headingTag:"h2"}}),X=new me({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),A=new Qe({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXI3Yi0xMi0yMDI0JTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwRm9ybWF0JTIwbWVzc2FnZSUyMHdpdGglMjB0aGUlMjBjb21tYW5kLXIlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjMlMkMlMEEpJTBBJTBBZ2VuX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbl90b2tlbnMlNUIwJTVEKSUwQXByaW50KGdlbl90ZXh0KQ==",highlighted:`<span class="hljs-comment"># pip install transformers</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r7b-12-2024&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># Format message with the command-r chat template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]
input_ids = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

gen_tokens = model.generate(
    input_ids,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.3</span>,
)

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),N=new me({props:{title:"Cohere2Config",local:"transformers.Cohere2Config",headingTag:"h2"}}),H=new ue({props:{name:"class transformers.Cohere2Config",anchor:"transformers.Cohere2Config",parameters:[{name:"vocab_size",val:" = 256000"},{name:"hidden_size",val:" = 8192"},{name:"intermediate_size",val:" = 22528"},{name:"logit_scale",val:" = 0.0625"},{name:"num_hidden_layers",val:" = 40"},{name:"num_attention_heads",val:" = 64"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 8192"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 5"},{name:"eos_token_id",val:" = 255001"},{name:"tie_word_embeddings",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"sliding_window",val:" = 4096"},{name:"sliding_window_pattern",val:" = 4"},{name:"cache_implementation",val:" = 'hybrid'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Cohere2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256000) &#x2014;
Vocabulary size of the Cohere model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/cohere#transformers.CohereModel">CohereModel</a>`,name:"vocab_size"},{anchor:"transformers.Cohere2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Cohere2Config.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 22528) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Cohere2Config.logit_scale",description:`<strong>logit_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0625) &#x2014;
The scaling factor for the output logits.`,name:"logit_scale"},{anchor:"transformers.Cohere2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 40) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.Cohere2Config.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.Cohere2Config.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Cohere2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Cohere2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Cohere2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Cohere2Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.Cohere2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Cohere2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.Cohere2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.Cohere2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 255001) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.Cohere2Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.Cohere2Config.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Cohere2Config.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.Cohere2Config.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.Cohere2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Cohere2Config.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Size of the sliding window attention context.`,name:"sliding_window"},{anchor:"transformers.Cohere2Config.sliding_window_pattern",description:`<strong>sliding_window_pattern</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Pattern for the sliding window attention.`,name:"sliding_window_pattern"},{anchor:"transformers.Cohere2Config.cache_implementation",description:"<strong>cache_implementation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;hybrid&quot;</code>) &#x2014; the cache type to be used with <code>generate</code>.",name:"cache_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere2/configuration_cohere2.py#L26"}}),F=new mo({props:{anchor:"transformers.Cohere2Config.example",$$slots:{default:[yo]},$$scope:{ctx:I}}}),Q=new me({props:{title:"Cohere2Model",local:"transformers.Cohere2Model",headingTag:"h2"}}),S=new ue({props:{name:"class transformers.Cohere2Model",anchor:"transformers.Cohere2Model",parameters:[{name:"config",val:": Cohere2Config"}],parametersDescription:[{anchor:"transformers.Cohere2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/cohere2#transformers.Cohere2Config">Cohere2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere2/modeling_cohere2.py#L412"}}),Y=new ue({props:{name:"forward",anchor:"transformers.Cohere2Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.HybridCache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.Cohere2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Cohere2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Cohere2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Cohere2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.HybridCache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Cohere2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Cohere2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Cohere2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Cohere2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Cohere2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere2/modeling_cohere2.py#L436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/cohere2#transformers.Cohere2Config"
>Cohere2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),W=new ho({props:{$$slots:{default:[Mo]},$$scope:{ctx:I}}}),D=new me({props:{title:"Cohere2ForCausalLM",local:"transformers.Cohere2ForCausalLM",headingTag:"h2"}}),O=new ue({props:{name:"class transformers.Cohere2ForCausalLM",anchor:"transformers.Cohere2ForCausalLM",parameters:[{name:"config",val:": Cohere2Config"}],parametersDescription:[{anchor:"transformers.Cohere2ForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/cohere2#transformers.Cohere2Config">Cohere2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere2/modeling_cohere2.py#L632"}}),K=new ue({props:{name:"forward",anchor:"transformers.Cohere2ForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.cohere2.modeling_cohere2.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Cohere2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Cohere2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Cohere2ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Cohere2ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Cohere2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Cohere2ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Cohere2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Cohere2ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Cohere2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Cohere2ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Cohere2ForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere2/modeling_cohere2.py#L667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/cohere2#transformers.Cohere2Config"
>Cohere2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new ho({props:{$$slots:{default:[To]},$$scope:{ctx:I}}}),L=new mo({props:{anchor:"transformers.Cohere2ForCausalLM.forward.example",$$slots:{default:[wo]},$$scope:{ctx:I}}}),ee=new bo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/cohere2.md"}}),{c(){t=d("meta"),b=a(),r=d("p"),y=a(),m(x.$$.fragment),h=a(),$=d("div"),$.innerHTML=Se,fe=a(),m(R.$$.fragment),ge=a(),P=d("p"),P.innerHTML=Ye,_e=a(),q=d("p"),q.textContent=De,be=a(),G=d("p"),G.textContent=Oe,ye=a(),m(X.$$.fragment),Me=a(),V=d("p"),V.textContent=Ke,Te=a(),m(A.$$.fragment),we=a(),m(N.$$.fragment),Ce=a(),C=d("div"),m(H.$$.fragment),je=a(),te=d("p"),te.innerHTML=eo,Fe=a(),ne=d("p"),ne.innerHTML=oo,We=a(),m(F.$$.fragment),ve=a(),m(Q.$$.fragment),ke=a(),T=d("div"),m(S.$$.fragment),Be=a(),ae=d("p"),ae.textContent=to,Le=a(),se=d("p"),se.innerHTML=no,Ee=a(),re=d("p"),re.innerHTML=ao,Ze=a(),U=d("div"),m(Y.$$.fragment),Re=a(),ie=d("p"),ie.innerHTML=so,Pe=a(),m(W.$$.fragment),xe=a(),m(D.$$.fragment),$e=a(),w=d("div"),m(O.$$.fragment),qe=a(),le=d("p"),le.textContent=ro,Ge=a(),de=d("p"),de.innerHTML=io,Xe=a(),ce=d("p"),ce.innerHTML=lo,Ve=a(),z=d("div"),m(K.$$.fragment),Ae=a(),he=d("p"),he.innerHTML=co,Ne=a(),m(B.$$.fragment),He=a(),m(L.$$.fragment),ze=a(),m(ee.$$.fragment),Je=a(),pe=d("p"),this.h()},l(e){const o=_o("svelte-u9bgzb",document.head);t=c(o,"META",{name:!0,content:!0}),o.forEach(n),b=s(e),r=c(e,"P",{}),oe(r).forEach(n),y=s(e),p(x.$$.fragment,e),h=s(e),$=c(e,"DIV",{class:!0,"data-svelte-h":!0}),M($)!=="svelte-b95w5j"&&($.innerHTML=Se),fe=s(e),p(R.$$.fragment,e),ge=s(e),P=c(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1jrlw4j"&&(P.innerHTML=Ye),_e=s(e),q=c(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-i5btjr"&&(q.textContent=De),be=s(e),G=c(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1wvvmby"&&(G.textContent=Oe),ye=s(e),p(X.$$.fragment,e),Me=s(e),V=c(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-etm0qg"&&(V.textContent=Ke),Te=s(e),p(A.$$.fragment,e),we=s(e),p(N.$$.fragment,e),Ce=s(e),C=c(e,"DIV",{class:!0});var J=oe(C);p(H.$$.fragment,J),je=s(J),te=c(J,"P",{"data-svelte-h":!0}),M(te)!=="svelte-nh18gt"&&(te.innerHTML=eo),Fe=s(J),ne=c(J,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1or3tcf"&&(ne.innerHTML=oo),We=s(J),p(F.$$.fragment,J),J.forEach(n),ve=s(e),p(Q.$$.fragment,e),ke=s(e),T=c(e,"DIV",{class:!0});var v=oe(T);p(S.$$.fragment,v),Be=s(v),ae=c(v,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-12njgno"&&(ae.textContent=to),Le=s(v),se=c(v,"P",{"data-svelte-h":!0}),M(se)!=="svelte-6pahdo"&&(se.innerHTML=no),Ee=s(v),re=c(v,"P",{"data-svelte-h":!0}),M(re)!=="svelte-hswkmf"&&(re.innerHTML=ao),Ze=s(v),U=c(v,"DIV",{class:!0});var j=oe(U);p(Y.$$.fragment,j),Re=s(j),ie=c(j,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1fu147f"&&(ie.innerHTML=so),Pe=s(j),p(W.$$.fragment,j),j.forEach(n),v.forEach(n),xe=s(e),p(D.$$.fragment,e),$e=s(e),w=c(e,"DIV",{class:!0});var k=oe(w);p(O.$$.fragment,k),qe=s(k),le=c(k,"P",{"data-svelte-h":!0}),M(le)!=="svelte-fnxhv1"&&(le.textContent=ro),Ge=s(k),de=c(k,"P",{"data-svelte-h":!0}),M(de)!=="svelte-6pahdo"&&(de.innerHTML=io),Xe=s(k),ce=c(k,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-hswkmf"&&(ce.innerHTML=lo),Ve=s(k),z=c(k,"DIV",{class:!0});var E=oe(z);p(K.$$.fragment,E),Ae=s(E),he=c(E,"P",{"data-svelte-h":!0}),M(he)!=="svelte-167o9jz"&&(he.innerHTML=co),Ne=s(E),p(B.$$.fragment,E),He=s(E),p(L.$$.fragment,E),E.forEach(n),k.forEach(n),ze=s(e),p(ee.$$.fragment,e),Je=s(e),pe=c(e,"P",{}),oe(pe).forEach(n),this.h()},h(){Z(t,"name","hf:doc:metadata"),Z(t,"content",vo),Z($,"class","flex flex-wrap space-x-1"),Z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,t),i(e,b,o),i(e,r,o),i(e,y,o),u(x,e,o),i(e,h,o),i(e,$,o),i(e,fe,o),u(R,e,o),i(e,ge,o),i(e,P,o),i(e,_e,o),i(e,q,o),i(e,be,o),i(e,G,o),i(e,ye,o),u(X,e,o),i(e,Me,o),i(e,V,o),i(e,Te,o),u(A,e,o),i(e,we,o),u(N,e,o),i(e,Ce,o),i(e,C,o),u(H,C,null),l(C,je),l(C,te),l(C,Fe),l(C,ne),l(C,We),u(F,C,null),i(e,ve,o),u(Q,e,o),i(e,ke,o),i(e,T,o),u(S,T,null),l(T,Be),l(T,ae),l(T,Le),l(T,se),l(T,Ee),l(T,re),l(T,Ze),l(T,U),u(Y,U,null),l(U,Re),l(U,ie),l(U,Pe),u(W,U,null),i(e,xe,o),u(D,e,o),i(e,$e,o),i(e,w,o),u(O,w,null),l(w,qe),l(w,le),l(w,Ge),l(w,de),l(w,Xe),l(w,ce),l(w,Ve),l(w,z),u(K,z,null),l(z,Ae),l(z,he),l(z,Ne),u(B,z,null),l(z,He),u(L,z,null),i(e,ze,o),u(ee,e,o),i(e,Je,o),i(e,pe,o),Ie=!0},p(e,[o]){const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),F.$set(J);const v={};o&2&&(v.$$scope={dirty:o,ctx:e}),W.$set(v);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),B.$set(j);const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),L.$set(k)},i(e){Ie||(f(x.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(A.$$.fragment,e),f(N.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(Q.$$.fragment,e),f(S.$$.fragment,e),f(Y.$$.fragment,e),f(W.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(ee.$$.fragment,e),Ie=!0)},o(e){g(x.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g(A.$$.fragment,e),g(N.$$.fragment,e),g(H.$$.fragment,e),g(F.$$.fragment,e),g(Q.$$.fragment,e),g(S.$$.fragment,e),g(Y.$$.fragment,e),g(W.$$.fragment,e),g(D.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(B.$$.fragment,e),g(L.$$.fragment,e),g(ee.$$.fragment,e),Ie=!1},d(e){e&&(n(b),n(r),n(y),n(h),n($),n(fe),n(ge),n(P),n(_e),n(q),n(be),n(G),n(ye),n(Me),n(V),n(Te),n(we),n(Ce),n(C),n(ve),n(ke),n(T),n(xe),n($e),n(w),n(ze),n(Je),n(pe)),n(t),_(x,e),_(R,e),_(X,e),_(A,e),_(N,e),_(H),_(F),_(Q,e),_(S),_(Y),_(W),_(D,e),_(O),_(K),_(B),_(L),_(ee,e)}}}const vo='{"title":"Cohere","local":"cohere","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Cohere2Config","local":"transformers.Cohere2Config","sections":[],"depth":2},{"title":"Cohere2Model","local":"transformers.Cohere2Model","sections":[],"depth":2},{"title":"Cohere2ForCausalLM","local":"transformers.Cohere2ForCausalLM","sections":[],"depth":2}],"depth":1}';function ko(I){return uo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wo extends fo{constructor(t){super(),go(this,t,ko,Co,po,{})}}export{Wo as component};
