import{s as jt,z as Jt,o as vt,n as nt}from"../chunks/scheduler.18a86fab.js";import{S as $t,i as Ut,g as r,s as a,r as g,A as Ct,h as p,f as n,c as o,j as fe,u as f,x as m,k as C,y as c,a as s,v as u,d as y,t as b,w as _}from"../chunks/index.98837b22.js";import{T as kt}from"../chunks/Tip.77304350.js";import{D as He}from"../chunks/Docstring.6758ea23.js";import{C as Fe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Tt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as R}from"../chunks/Heading.7e7e0c5b.js";import{E as Wt}from"../chunks/index.499f366c.js";function Bt(k){let i,J="Example:",d,h,w;return h=new Fe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoQW55dGhpbmdDb25maWclMkMlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERlcHRoQW55dGhpbmclMjBzbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZXB0aEFueXRoaW5nQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwRGVwdGhBbnl0aGluZyUyMHNtYWxsJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthAnythingConfig, DepthAnythingForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthAnythingConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthAnythingForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=r("p"),i.textContent=J,d=a(),g(h.$$.fragment)},l(l){i=p(l,"P",{"data-svelte-h":!0}),m(i)!=="svelte-11lpom8"&&(i.textContent=J),d=o(l),f(h.$$.fragment,l)},m(l,M){s(l,i,M),s(l,d,M),u(h,l,M),w=!0},p:nt,i(l){w||(y(h.$$.fragment,l),w=!0)},o(l){b(h.$$.fragment,l),w=!1},d(l){l&&(n(i),n(d)),_(h,l)}}}function Zt(k){let i,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=r("p"),i.innerHTML=J},l(d){i=p(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fincs2"&&(i.innerHTML=J)},m(d,h){s(d,i,h)},p:nt,d(d){d&&n(i)}}}function Gt(k){let i,J="Examples:",d,h,w;return h=new Fe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXBvc3RfcHJvY2Vzc2VkX291dHB1dCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZGVwdGhfZXN0aW1hdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcHJlZGljdGVkX2RlcHRoJTIwKiUyMDI1NSUyMCUyRiUyMHByZWRpY3RlZF9kZXB0aC5tYXgoKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){i=r("p"),i.textContent=J,d=a(),g(h.$$.fragment)},l(l){i=p(l,"P",{"data-svelte-h":!0}),m(i)!=="svelte-kvfsh7"&&(i.textContent=J),d=o(l),f(h.$$.fragment,l)},m(l,M){s(l,i,M),s(l,d,M),u(h,l,M),w=!0},p:nt,i(l){w||(y(h.$$.fragment,l),w=!0)},o(l){b(h.$$.fragment,l),w=!1},d(l){l&&(n(i),n(d)),_(h,l)}}}function Dt(k){let i,J,d,h,w,l,M,ye,x,st='Depth Anything V2 was introduced in <a href="https://arxiv.org/abs/2406.09414" rel="nofollow">the paper of the same name</a> by Lihe Yang et al. It uses the same architecture as the original <a href="depth_anything">Depth Anything model</a>, but uses synthetic data and a larger capacity teacher model to achieve much finer and robust depth predictions.',be,E,at="The abstract from the paper is the following:",_e,I,ot="<em>This work presents Depth Anything V2. Without pursuing fancy techniques, we aim to reveal crucial findings to pave the way towards building a powerful monocular depth estimation model. Notably, compared with V1, this version produces much finer and more robust depth predictions through three key practices: 1) replacing all labeled real images with synthetic images, 2) scaling up the capacity of our teacher model, and 3) teaching student models via the bridge of large-scale pseudo-labeled real images. Compared with the latest models built on Stable Diffusion, our models are significantly more efficient (more than 10x faster) and more accurate. We offer models of different scales (ranging from 25M to 1.3B params) to support extensive scenarios. Benefiting from their strong generalization capability, we fine-tune them with metric depth labels to obtain our metric depth models. In addition to our models, considering the limited diversity and frequent noise in current test sets, we construct a versatile evaluation benchmark with precise annotations and diverse scenes to facilitate future research.</em>",we,W,lt,Me,V,it='Depth Anything overview. Taken from the <a href="https://arxiv.org/abs/2401.10891">original paper</a>.',Te,z,rt=`The Depth Anything models were contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/DepthAnything/Depth-Anything-V2" rel="nofollow">here</a>.`,je,H,Je,F,pt="There are 2 main ways to use Depth Anything V2: either using the pipeline API, which abstracts away all the complexity for you, or by using the <code>DepthAnythingForDepthEstimation</code> class yourself.",ve,N,$e,X,ht="The pipeline allows to use the model in a few lines of code:",Ue,L,Ce,Y,ke,S,ct="If you want to do the pre- and post-processing yourself, here’s how to do that:",We,P,Be,q,Ze,Q,dt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Depth Anything.",Ge,K,mt='<li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li> <li><a href="https://huggingface.co/spaces/depth-anything/Depth-Anything-V2" rel="nofollow">Depth Anything V2 demo</a>.</li> <li>A notebook showcasing inference with <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Depth%20Anything/Predicting_depth_in_an_image_with_Depth_Anything.ipynb" rel="nofollow">here</a>. 🌎</li> <li><a href="https://huggingface.co/apple/coreml-depth-anything-v2-small" rel="nofollow">Core ML conversion of the <code>small</code> variant for use on Apple Silicon</a>.</li>',De,O,gt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ae,ee,Re,T,te,Ne,re,ft=`This is the configuration class to store the configuration of a <code>DepthAnythingModel</code>. It is used to instantiate a DepthAnything
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DepthAnything
<a href="https://huggingface.co/LiheYoung/depth-anything-small-hf" rel="nofollow">LiheYoung/depth-anything-small-hf</a> architecture.`,Xe,pe,ut=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Le,B,Ye,Z,ne,Se,he,yt=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,xe,se,Ee,j,ae,Pe,ce,bt="Depth Anything Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",qe,de,_t=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qe,me,wt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ke,U,oe,Oe,ge,Mt='The <a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',et,G,tt,D,Ie,le,Ve,ue,ze;return w=new R({props:{title:"Depth Anything V2",local:"depth-anything-v2",headingTag:"h1"}}),M=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new R({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),N=new R({props:{title:"Pipeline API",local:"pipeline-api",headingTag:"h3"}}),L=new Fe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBsb2FkJTIwcGlwZSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGVwdGgtYW55dGhpbmclMkZEZXB0aC1Bbnl0aGluZy1WMi1TbWFsbC1oZiUyMiklMEElMEElMjMlMjBsb2FkJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTVCJTIyZGVwdGglMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load pipe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),Y=new R({props:{title:"Using the model yourself",local:"using-the-model-yourself",headingTag:"h3"}}),P=new Fe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLVNtYWxsLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLVNtYWxsLWhmJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGludGVycG9sYXRlJTIwdG8lMjBvcmlnaW5hbCUyMHNpemUlMjBhbmQlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19kZXB0aF9lc3RpbWF0aW9uKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlM0QlNUIoaW1hZ2UuaGVpZ2h0JTJDJTIwaW1hZ2Uud2lkdGgpJTVEJTJDJTBBKSUwQSUwQXByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMHBvc3RfcHJvY2Vzc2VkX291dHB1dCU1QjAlNUQlNUIlMjJwcmVkaWN0ZWRfZGVwdGglMjIlNUQlMEFkZXB0aCUyMCUzRCUyMChwcmVkaWN0ZWRfZGVwdGglMjAtJTIwcHJlZGljdGVkX2RlcHRoLm1pbigpKSUyMCUyRiUyMChwcmVkaWN0ZWRfZGVwdGgubWF4KCklMjAtJTIwcHJlZGljdGVkX2RlcHRoLm1pbigpKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyMColMjAyNTUlMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShkZXB0aC5hc3R5cGUoJTIydWludDglMjIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size and visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (predicted_depth - predicted_depth.<span class="hljs-built_in">min</span>()) / (predicted_depth.<span class="hljs-built_in">max</span>() - predicted_depth.<span class="hljs-built_in">min</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy() * <span class="hljs-number">255</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),q=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ee=new R({props:{title:"DepthAnythingConfig",local:"transformers.DepthAnythingConfig",headingTag:"h2"}}),te=new He({props:{name:"class transformers.DepthAnythingConfig",anchor:"transformers.DepthAnythingConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"patch_size",val:" = 14"},{name:"initializer_range",val:" = 0.02"},{name:"reassemble_hidden_size",val:" = 384"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [48, 96, 192, 384]"},{name:"fusion_hidden_size",val:" = 64"},{name:"head_in_index",val:" = -1"},{name:"head_hidden_size",val:" = 32"},{name:"depth_estimation_type",val:" = 'relative'"},{name:"max_depth",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>is_hybrid</code> is <code>True</code> or in case you want to
leverage the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> API.`,name:"backbone_config"},{anchor:"transformers.DepthAnythingConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DepthAnythingConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DepthAnythingConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DepthAnythingConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DepthAnythingConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size of the patches to extract from the backbone features.`,name:"patch_size"},{anchor:"transformers.DepthAnythingConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthAnythingConfig.reassemble_hidden_size",description:`<strong>reassemble_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the reassemble layers.`,name:"reassemble_hidden_size"},{anchor:"transformers.DepthAnythingConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DepthAnythingConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[48, 96, 192, 384]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DepthAnythingConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthAnythingConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the depth estimation head.`,name:"head_in_index"},{anchor:"transformers.DepthAnythingConfig.head_hidden_size",description:`<strong>head_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of output channels in the second convolution of the depth estimation head.`,name:"head_hidden_size"},{anchor:"transformers.DepthAnythingConfig.depth_estimation_type",description:`<strong>depth_estimation_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relative&quot;</code>) &#x2014;
The type of depth estimation to use. Can be one of <code>[&quot;relative&quot;, &quot;metric&quot;]</code>.`,name:"depth_estimation_type"},{anchor:"transformers.DepthAnythingConfig.max_depth",description:`<strong>max_depth</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The maximum depth to use for the &#x201C;metric&#x201D; depth estimation head. 20 should be used for indoor models
and 80 for outdoor models. For &#x201C;relative&#x201D; depth estimation, this value is ignored.`,name:"max_depth"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L28"}}),B=new Tt({props:{anchor:"transformers.DepthAnythingConfig.example",$$slots:{default:[Bt]},$$scope:{ctx:k}}}),ne=new He({props:{name:"to_dict",anchor:"transformers.DepthAnythingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L154"}}),se=new R({props:{title:"DepthAnythingForDepthEstimation",local:"transformers.DepthAnythingForDepthEstimation",headingTag:"h2"}}),ae=new He({props:{name:"class transformers.DepthAnythingForDepthEstimation",anchor:"transformers.DepthAnythingForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L326"}}),oe=new He({props:{name:"forward",anchor:"transformers.DepthAnythingForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L344",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_anything#transformers.DepthAnythingConfig"
>DepthAnythingConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new kt({props:{$$slots:{default:[Zt]},$$scope:{ctx:k}}}),D=new Tt({props:{anchor:"transformers.DepthAnythingForDepthEstimation.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:k}}}),le=new Wt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_anything_v2.md"}}),{c(){i=r("meta"),J=a(),d=r("p"),h=a(),g(w.$$.fragment),l=a(),g(M.$$.fragment),ye=a(),x=r("p"),x.innerHTML=st,be=a(),E=r("p"),E.textContent=at,_e=a(),I=r("p"),I.innerHTML=ot,we=a(),W=r("img"),Me=a(),V=r("small"),V.innerHTML=it,Te=a(),z=r("p"),z.innerHTML=rt,je=a(),g(H.$$.fragment),Je=a(),F=r("p"),F.innerHTML=pt,ve=a(),g(N.$$.fragment),$e=a(),X=r("p"),X.textContent=ht,Ue=a(),g(L.$$.fragment),Ce=a(),g(Y.$$.fragment),ke=a(),S=r("p"),S.textContent=ct,We=a(),g(P.$$.fragment),Be=a(),g(q.$$.fragment),Ze=a(),Q=r("p"),Q.textContent=dt,Ge=a(),K=r("ul"),K.innerHTML=mt,De=a(),O=r("p"),O.textContent=gt,Ae=a(),g(ee.$$.fragment),Re=a(),T=r("div"),g(te.$$.fragment),Ne=a(),re=r("p"),re.innerHTML=ft,Xe=a(),pe=r("p"),pe.innerHTML=ut,Le=a(),g(B.$$.fragment),Ye=a(),Z=r("div"),g(ne.$$.fragment),Se=a(),he=r("p"),he.innerHTML=yt,xe=a(),g(se.$$.fragment),Ee=a(),j=r("div"),g(ae.$$.fragment),Pe=a(),ce=r("p"),ce.textContent=bt,qe=a(),de=r("p"),de.innerHTML=_t,Qe=a(),me=r("p"),me.innerHTML=wt,Ke=a(),U=r("div"),g(oe.$$.fragment),Oe=a(),ge=r("p"),ge.innerHTML=Mt,et=a(),g(G.$$.fragment),tt=a(),g(D.$$.fragment),Ie=a(),g(le.$$.fragment),Ve=a(),ue=r("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(n),J=o(e),d=p(e,"P",{}),fe(d).forEach(n),h=o(e),f(w.$$.fragment,e),l=o(e),f(M.$$.fragment,e),ye=o(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-bx62jk"&&(x.innerHTML=st),be=o(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-vfdo9a"&&(E.textContent=at),_e=o(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1ybeoq5"&&(I.innerHTML=ot),we=o(e),W=p(e,"IMG",{src:!0,alt:!0,width:!0}),Me=o(e),V=p(e,"SMALL",{"data-svelte-h":!0}),m(V)!=="svelte-1ldczql"&&(V.innerHTML=it),Te=o(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-hg4duy"&&(z.innerHTML=rt),je=o(e),f(H.$$.fragment,e),Je=o(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1ct8de3"&&(F.innerHTML=pt),ve=o(e),f(N.$$.fragment,e),$e=o(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1yjxirq"&&(X.textContent=ht),Ue=o(e),f(L.$$.fragment,e),Ce=o(e),f(Y.$$.fragment,e),ke=o(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-12aulqw"&&(S.textContent=ct),We=o(e),f(P.$$.fragment,e),Be=o(e),f(q.$$.fragment,e),Ze=o(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-msamn6"&&(Q.textContent=dt),Ge=o(e),K=p(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-1wj402w"&&(K.innerHTML=mt),De=o(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1xesile"&&(O.textContent=gt),Ae=o(e),f(ee.$$.fragment,e),Re=o(e),T=p(e,"DIV",{class:!0});var v=fe(T);f(te.$$.fragment,v),Ne=o(v),re=p(v,"P",{"data-svelte-h":!0}),m(re)!=="svelte-30ivap"&&(re.innerHTML=ft),Xe=o(v),pe=p(v,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-o55m63"&&(pe.innerHTML=ut),Le=o(v),f(B.$$.fragment,v),Ye=o(v),Z=p(v,"DIV",{class:!0});var ie=fe(Z);f(ne.$$.fragment,ie),Se=o(ie),he=p(ie,"P",{"data-svelte-h":!0}),m(he)!=="svelte-f91b28"&&(he.innerHTML=yt),ie.forEach(n),v.forEach(n),xe=o(e),f(se.$$.fragment,e),Ee=o(e),j=p(e,"DIV",{class:!0});var $=fe(j);f(ae.$$.fragment,$),Pe=o($),ce=p($,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1lyww6q"&&(ce.textContent=bt),qe=o($),de=p($,"P",{"data-svelte-h":!0}),m(de)!=="svelte-6pahdo"&&(de.innerHTML=_t),Qe=o($),me=p($,"P",{"data-svelte-h":!0}),m(me)!=="svelte-hswkmf"&&(me.innerHTML=wt),Ke=o($),U=p($,"DIV",{class:!0});var A=fe(U);f(oe.$$.fragment,A),Oe=o(A),ge=p(A,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-tvw6fn"&&(ge.innerHTML=Mt),et=o(A),f(G.$$.fragment,A),tt=o(A),f(D.$$.fragment,A),A.forEach(n),$.forEach(n),Ie=o(e),f(le.$$.fragment,e),Ve=o(e),ue=p(e,"P",{}),fe(ue).forEach(n),this.h()},h(){C(i,"name","hf:doc:metadata"),C(i,"content",At),Jt(W.src,lt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_anything_overview.jpg")||C(W,"src",lt),C(W,"alt","drawing"),C(W,"width","600"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,i),s(e,J,t),s(e,d,t),s(e,h,t),u(w,e,t),s(e,l,t),u(M,e,t),s(e,ye,t),s(e,x,t),s(e,be,t),s(e,E,t),s(e,_e,t),s(e,I,t),s(e,we,t),s(e,W,t),s(e,Me,t),s(e,V,t),s(e,Te,t),s(e,z,t),s(e,je,t),u(H,e,t),s(e,Je,t),s(e,F,t),s(e,ve,t),u(N,e,t),s(e,$e,t),s(e,X,t),s(e,Ue,t),u(L,e,t),s(e,Ce,t),u(Y,e,t),s(e,ke,t),s(e,S,t),s(e,We,t),u(P,e,t),s(e,Be,t),u(q,e,t),s(e,Ze,t),s(e,Q,t),s(e,Ge,t),s(e,K,t),s(e,De,t),s(e,O,t),s(e,Ae,t),u(ee,e,t),s(e,Re,t),s(e,T,t),u(te,T,null),c(T,Ne),c(T,re),c(T,Xe),c(T,pe),c(T,Le),u(B,T,null),c(T,Ye),c(T,Z),u(ne,Z,null),c(Z,Se),c(Z,he),s(e,xe,t),u(se,e,t),s(e,Ee,t),s(e,j,t),u(ae,j,null),c(j,Pe),c(j,ce),c(j,qe),c(j,de),c(j,Qe),c(j,me),c(j,Ke),c(j,U),u(oe,U,null),c(U,Oe),c(U,ge),c(U,et),u(G,U,null),c(U,tt),u(D,U,null),s(e,Ie,t),u(le,e,t),s(e,Ve,t),s(e,ue,t),ze=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),B.$set(v);const ie={};t&2&&(ie.$$scope={dirty:t,ctx:e}),G.$set(ie);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),D.$set($)},i(e){ze||(y(w.$$.fragment,e),y(M.$$.fragment,e),y(H.$$.fragment,e),y(N.$$.fragment,e),y(L.$$.fragment,e),y(Y.$$.fragment,e),y(P.$$.fragment,e),y(q.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(B.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(G.$$.fragment,e),y(D.$$.fragment,e),y(le.$$.fragment,e),ze=!0)},o(e){b(w.$$.fragment,e),b(M.$$.fragment,e),b(H.$$.fragment,e),b(N.$$.fragment,e),b(L.$$.fragment,e),b(Y.$$.fragment,e),b(P.$$.fragment,e),b(q.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(B.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(oe.$$.fragment,e),b(G.$$.fragment,e),b(D.$$.fragment,e),b(le.$$.fragment,e),ze=!1},d(e){e&&(n(J),n(d),n(h),n(l),n(ye),n(x),n(be),n(E),n(_e),n(I),n(we),n(W),n(Me),n(V),n(Te),n(z),n(je),n(Je),n(F),n(ve),n($e),n(X),n(Ue),n(Ce),n(ke),n(S),n(We),n(Be),n(Ze),n(Q),n(Ge),n(K),n(De),n(O),n(Ae),n(Re),n(T),n(xe),n(Ee),n(j),n(Ie),n(Ve),n(ue)),n(i),_(w,e),_(M,e),_(H,e),_(N,e),_(L,e),_(Y,e),_(P,e),_(q,e),_(ee,e),_(te),_(B),_(ne),_(se,e),_(ae),_(oe),_(G),_(D),_(le,e)}}}const At='{"title":"Depth Anything V2","local":"depth-anything-v2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Pipeline API","local":"pipeline-api","sections":[],"depth":3},{"title":"Using the model yourself","local":"using-the-model-yourself","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthAnythingConfig","local":"transformers.DepthAnythingConfig","sections":[],"depth":2},{"title":"DepthAnythingForDepthEstimation","local":"transformers.DepthAnythingForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Rt(k){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends $t{constructor(i){super(),Ut(this,i,Rt,Dt,jt,{})}}export{Xt as component};
