import{s as ys,o as vs,n as X}from"../chunks/scheduler.18a86fab.js";import{S as Ts,i as ws,g as l,s,r as u,A as ks,h as d,f as o,c as a,j as Z,u as f,x as c,k as j,l as Ms,y as p,a as n,v as g,d as _,t as b,w as M}from"../chunks/index.98837b22.js";import{T as Gt}from"../chunks/Tip.77304350.js";import{D as N}from"../chunks/Docstring.6758ea23.js";import{C as Jt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Wt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as V}from"../chunks/Heading.7e7e0c5b.js";import{E as xs}from"../chunks/index.499f366c.js";function Cs(w){let i,v='It is designed for intermediate use. We strongly recommend using the original <a href="https://github.com/kyutai-labs/moshi" rel="nofollow">implementation</a> to infer the model in real-time streaming.';return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1l3jd0r"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function $s(w){let i,v="The original model is synchronized text with audio by padding the text in between each token enunciation.",m,h,y="To follow the example of the following image, <code>&quot;Hello, I&#39;m Moshi&quot;</code> could be transformed to <code>&quot;Hello,&lt;pad&gt;&lt;unk&gt;I&#39;m Moshi&quot;</code>.";return{c(){i=l("p"),i.textContent=v,m=s(),h=l("p"),h.innerHTML=y},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1se1hi6"&&(i.textContent=v),m=a(r),h=d(r,"P",{"data-svelte-h":!0}),c(h)!=="svelte-nhkay6"&&(h.innerHTML=y)},m(r,T){n(r,i,T),n(r,m,T),n(r,h,T)},p:X,d(r){r&&(o(i),o(m),o(h))}}}function zs(w){let i,v="Example:",m,h,y;return h=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNb3NoaUNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBKSUwQSUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNb3NoaUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBrbWhmJTJGaGYtbW9zaGlrbyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTW9zaGlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBJTBBJTIzJTIwU2F2aW5nJTIwdGhlJTIwbW9kZWwlMkMlMjBpbmNsdWRpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyKSUwQSUwQSUyMyUyMGxvYWRpbmclMjBtb2RlbCUyMGFuZCUyMGNvbmZpZyUyMGZyb20lMjBwcmV0cmFpbmVkJTIwZm9sZGVyJTBBbW9zaGlfY29uZmlnJTIwJTNEJTIwTW9zaGlDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyKSUwQW1vZGVsJTIwJTNEJTIwTW9zaGlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmttaGYlMkZoZi1tb3NoaWtvJTIyJTJDJTIwY29uZmlnJTNEbW9zaGlfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MoshiConfig,
<span class="hljs-meta">... </span>    MoshiForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoshiConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MoshiForConditionalGeneration (with random weights) from the kmhf/hf-moshiko style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>moshi_config = MoshiConfig.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>, config=moshi_config)`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function js(w){let i,v="Example:",m,h,y;return h=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNb3NoaURlcHRoQ29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwTW9zaGlEZXB0aERlY29kZXIlMkMlMEEpJTBBJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME1vc2hpRGVwdGhDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNb3NoaURlcHRoRGVjb2RlciUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwa21oZiUyRmhmLW1vc2hpa28lMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1vc2hpRGVwdGhEZWNvZGVyKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MoshiDepthConfig,
<span class="hljs-meta">... </span>    MoshiDepthDecoder,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoshiDepthConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MoshiDepthDecoder (with random weights) from the kmhf/hf-moshiko style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiDepthDecoder(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function Js(w){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function Fs(w){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function Gs(w){let i,v="Example:",m,h,y;return h=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNb3NoaUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBNb3NoaUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwZmF2b3JpdGUlMjBjb25kaW1lbnQlM0YlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MoshiForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForCausalLM.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;What is your favorite condiment?&quot;</span>`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function Ws(w){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=l("p"),i.innerHTML=v},l(m){i=d(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(m,h){n(m,i,h)},p:X,d(m){m&&o(i)}}}function Zs(w){let i,v="Examples:",m,h,y;return h=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJrbWhmJTJGaGYtbW9zaGlrbyUyMiklMEFpbnB1dHMlMjAlM0QlMjBtb3NoaS5nZXRfdW5jb25kaXRpb25hbF9pbnB1dHMoKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwKS5sb2dpdHMlMEFsb2dpdHMuc2hhcGUlMjAlMjAlMjMlMjAoYnN6JTJDJTIwc2VxX2xlbiUyQyUyMHRleHRfdm9jYWJfc2l6ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = moshi.get_unconditional_inputs()

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, ).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz, seq_len, text_vocab_size)</span>
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">32000</span>])`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-kvfsh7"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function Ls(w){let i,v="Example:",m,h,y;return h=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vc2hpRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNb3NoaUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIya21oZiUyRmhmLW1vc2hpa28tcHl0b3JjaC1iZjE2JTIyKSUwQSUwQSUyMyUyMGdldCUyMHRoZSUyMHVuY29uZGl0aW9uYWwlMjAob3IlMjAnbnVsbCcpJTIwaW5wdXRzJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyMG1vZGVsLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBYXVkaW9fc2FtcGxlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdW5jb25kaXRpb25hbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoshiForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;kmhf/hf-moshiko-pytorch-bf16&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the unconditional (or &#x27;null&#x27;) inputs for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = model.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_samples = model.generate(**unconditional_inputs, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=l("p"),i.textContent=v,m=s(),u(h.$$.fragment)},l(r){i=d(r,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11lpom8"&&(i.textContent=v),m=a(r),f(h.$$.fragment,r)},m(r,T){n(r,i,T),n(r,m,T),g(h,r,T),y=!0},p:X,i(r){y||(_(h.$$.fragment,r),y=!0)},o(r){b(h.$$.fragment,r),y=!1},d(r){r&&(o(i),o(m)),M(h,r)}}}function Is(w){let i,v,m,h,y,r,T,_n='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Zt,ie,Lt,re,bn='The Moshi model was proposed in <a href="https://kyutai.org/Moshi.pdf" rel="nofollow">Moshi: a speech-text foundation model for real-time dialogue</a> by Alexandre Défossez, Laurent Mazaré, Manu Orsini, Amélie Royer, Patrick Pérez, Hervé Jégou, Edouard Grave and Neil Zeghidour.',It,le,Mn="Moshi is a speech-text foundation model that casts spoken dialogue as speech-to-speech generation. Starting from a text language model backbone, Moshi generates speech as tokens from the residual quantizer of a neural audio codec, while modeling separately its own speech and that of the user into parallel streams. This allows for the removal of explicit speaker turns, and the modeling of arbitrary conversational dynamics. Moshi also predicts time-aligned text tokens as a prefix to audio tokens. This “Inner Monologue” method significantly improves the linguistic quality of generated speech and provides streaming speech recognition and text-to-speech. As a result, Moshi is the first real-time full-duplex spoken large language model, with a theoretical latency of 160ms, 200ms in practice.",Ut,D,yn='<img src="https://huggingface.co/datasets/ylacombe/benchmark-comparison/resolve/main/moshi_architecture.png"/>',Ht,de,vn="The abstract from the paper is the following:",Bt,ce,Tn="<em>We introduce Moshi, a speech-text foundation model and full-duplex spoken dialogue framework. Current systems for spoken dialogue rely on pipelines of independent components, namely voice activity detection, speech recognition, textual dialogue and text-to-speech. Such frameworks cannot emulate the experience of real conversations. First, their complexity induces a latency of several seconds between interactions. Second, text being the intermediate modality for dialogue, non-linguistic information that modifies meaning— such as emotion or non-speech sounds— is lost in the interaction. Finally, they rely on a segmentation into speaker turns, which does not take into account overlapping speech, interruptions and interjections. Moshi solves these independent issues altogether by casting spoken dialogue as speech-to-speech generation. Starting from a text language model backbone, Moshi generates speech as tokens from the residual quantizer of a neural audio codec, while modeling separately its own speech and that of the user into parallel streams. This allows for the removal of explicit speaker turns, and the modeling of arbitrary conversational dynamics. We moreover extend the hierarchical semantic-to-acoustic token generation of previous work to first predict time-aligned text tokens as a prefix to audio tokens. Not only this “Inner Monologue” method significantly improves the linguistic quality of generated speech, but we also illustrate how it can provide streaming speech recognition and text-to-speech. Our resulting model is the first real-time full-duplex spoken large language model, with a theoretical latency of 160ms, 200ms in practice, and is available at github.com/kyutai-labs/moshi.</em>",Nt,he,wn="Moshi deals with 3 streams of information:",qt,me,kn="<li>The user’s audio</li> <li>Moshi’s audio</li> <li>Moshi’s textual output</li>",Rt,pe,xn=`Similarly to <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">~MusicgenModel</a>, audio is represented with audio codebooks, which can be interpreted like tokens. The main difference between text tokens and audio codebooks is that audio codebooks introduce an additional dimension of information.
Text tokens are typically of dim <code>(batch_size, sequence_length)</code> but audio tokens are of dim <code>(batch_size, num_codebooks, sequence_length)</code>.`,Vt,ue,Cn="Moshi’s made of 3 components:",Xt,fe,$n="<strong>1. The main decoder (Helium in the paper)</strong>",Pt,ge,zn='It corresponds to <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForCausalLM">MoshiForCausalLM</a>. It is strictly a classic text LLM, that uses an architecture similar to <code>~GemmaForCausalLM</code>. In other words, it takes text tokens, embeds them, pass them through the decoder and a language head, to get text logits.',Dt,_e,jn="<strong>2. The depth decoder</strong>",Et,be,Jn="On its own, it’s also a classic LLM, but this time, instead of generating over the time dimension, it generates over the codebook dimension.",Yt,Me,Fn="It also means that its context length is <code>num_codebooks</code>, thus it can’t generate more than <code>num_codebooks</code>.",St,ye,Gn="Note that each timestamp - i.e each codebook - gets its own set of Linear Layers and Embeddings.",At,ve,Wn='<strong>3. <a href="/docs/transformers/main/en/model_doc/mimi#transformers.MimiModel">MimiModel</a></strong>',Ot,Te,Zn='It’s the audio encoder from Kyutai, that has recently been integrated to transformers, which is used to “tokenize” audio. It has the same use that <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">~EncodecModel</a> has in <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">~MusicgenModel</a>.',Qt,we,Kt,ke,Ln="The original checkpoints can be converted using the conversion script <code>src/transformers/models/moshi/convert_moshi_transformers.py</code>",eo,xe,to,Ce,In="This implementation has two main aims:",oo,$e,Un="<li>quickly test model generation by simplifying the original API</li> <li>simplify training. A training guide will come soon, but user contributions are welcomed!</li>",no,E,so,ze,Hn="<strong>1. Model generation</strong>",ao,je,Bn="Moshi is a streaming auto-regressive model with two streams of audio. To put it differently, one audio stream corresponds to what the model said/will say and the other audio stream corresponds to what the user said/will say.",io,Je,Nn='<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.generate">MoshiForConditionalGeneration.generate()</a> thus needs 3 inputs:',ro,Fe,qn="<li><code>input_ids</code> - corresponding to the text token history</li> <li><code>moshi_input_values</code> or <code>moshi_audio_codes</code>- corresponding to the model audio history</li> <li><code>user_input_values</code> or <code>user_audio_codes</code> - corresponding to the user audio history</li>",lo,Ge,Rn="These three inputs must be synchronized. Meaning that their lengths must correspond to the same number of tokens.",co,We,Vn="You can dynamically use the 3 inputs depending on what you want to test:",ho,Ze,Xn="<li>Simply check the model response to an user prompt - in that case, <code>input_ids</code> can be filled with pad tokens and <code>user_input_values</code> can be a zero tensor of the same shape than the user prompt.</li> <li>Test more complex behaviour - in that case, you must be careful about how the input tokens are synchronized with the audios.</li>",mo,Y,po,S,Pn='<img src="https://huggingface.co/datasets/ylacombe/benchmark-comparison/resolve/main/moshi_text_sync.png"/>',uo,Le,Dn='<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.generate">MoshiForConditionalGeneration.generate()</a> then auto-regressively feeds to itself its own audio stream, but since it doesn’t have access to the user input stream while using <code>transformers</code>, it will thus <strong>assume that the user is producing blank audio</strong>.',fo,Ie,go,Ue,En="<strong>2. Model training</strong>",_o,He,Yn="Most of the work has to be done during data creation/pre-processing, because of the need to align/synchronize streams.",bo,Be,Sn='Once it’s done, you can simply forward <code>text_labels</code> and <code>audio_labels</code> to <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration.forward">MoshiForConditionalGeneration.forward()</a>, alongside the usual inputs, to get the model loss.',Mo,Ne,An="A training guide will come soon, but user contributions are welcomed!",yo,qe,vo,Re,On="<li><p>The input streams are embedded and combined into <code>inputs_embeds</code>.</p></li> <li><p><code>inputs_embeds</code> is passed through the main decoder, which processes it like a normal LLM would.</p></li> <li><p>The main decoder outputs <code>text logits</code> but also its <code>last hidden state</code> which is called <code>temporal context</code> in the paper.</p></li> <li><p>The depth decoder switches the dimension on which we forward / generate (codebooks instead of time). It uses the token generated from <code>text logits</code>  and the <code>temporal context</code> to auto-regressively generate audio codebooks.</p></li>",To,Ve,Qn='This model was contributed by <a href="https://huggingface.co/ylacombe" rel="nofollow">Yoach Lacombe (ylacombe)</a>.',wo,Xe,Kn='The original code can be found <a href="https://github.com/kyutai-labs/moshi" rel="nofollow">here</a>.',ko,Pe,xo,C,De,Uo,ct,es=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiModel">MoshiModel</a>. It is used to instantiate a
Moshi model according to the specified arguments, defining the audio encoder, Moshi depth decoder and Moshi decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the Moshiko model,
e.g. <a href="https://huggingface.co/kmhf/hf-moshiko" rel="nofollow">kmhf/hf-moshiko</a>`,Ho,ht,ts=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Bo,A,No,O,Ee,qo,mt,os='Instantiate a <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a> (or a derived class) from an audio encoder configuration.',Co,Ye,$o,J,Se,Ro,pt,ns=`This is the configuration class to store the configuration of a <code>MoshiDepthDecoder</code>. It is used to instantiate a
Moshi depth decoder model according to the specified arguments, defining the Moshi depth decoder config.`,Vo,ut,ss=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xo,Q,zo,Ae,jo,$,Oe,Po,ft,as="The bare Moshi Model outputting raw hidden-states without any specific head on top.",Do,gt,is=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Eo,_t,rs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Yo,q,Qe,So,bt,ls='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiModel">MoshiModel</a> forward method, overrides the <code>__call__</code> special method.',Ao,K,Jo,Ke,Fo,z,et,Oo,Mt,ds="The Moshi decoder model with a text language modelling head on top. Only usable for text.",Qo,yt,cs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ko,vt,hs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,en,L,tt,tn,Tt,ms='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForCausalLM">MoshiForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',on,ee,nn,te,Go,ot,Wo,k,nt,sn,wt,ps="The original Moshi model with an audio encoder, a Moshi depth decoder and a Moshi decoder, for speech-to-speech.",an,kt,us=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,rn,xt,fs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ln,I,st,dn,Ct,gs='The <a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForConditionalGeneration">MoshiForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',cn,oe,hn,ne,mn,se,at,pn,$t,_s="Generates sequences of text token ids and audio tokens ids.",un,R,it,fn,zt,bs=`Helper function to get null inputs for unconditional generation, enabling the model to be used without the
feature extractor or tokenizer.`,gn,ae,Zo,rt,Lo,Ft,Io;return y=new V({props:{title:"Moshi",local:"moshi",headingTag:"h1"}}),ie=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),we=new V({props:{title:"Tips:",local:"tips",headingTag:"h2"}}),xe=new V({props:{title:"How to use the model:",local:"how-to-use-the-model",headingTag:"h3"}}),E=new Gt({props:{$$slots:{default:[Cs]},$$scope:{ctx:w}}}),Y=new Gt({props:{$$slots:{default:[$s]},$$scope:{ctx:w}}}),Ie=new Jt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch, math
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoshiForConditionalGeneration, AutoFeatureExtractor, AutoTokenizer


<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_dummy = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;kyutai/moshiko-pytorch-bf16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;kyutai/moshiko-pytorch-bf16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dtype = torch.bfloat16

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare user input audio </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>librispeech_dummy = librispeech_dummy.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=feature_extractor.sampling_rate))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_sample = librispeech_dummy[-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>user_input_values = feature_extractor(raw_audio=audio_sample, sampling_rate=feature_extractor.sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=device, dtype=dtype)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare moshi input values - we suppose moshi didn&#x27;t say anything while the user spoke</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>moshi_input_values = torch.zeros_like(user_input_values.input_values)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare moshi input ids - we suppose moshi didn&#x27;t say anything while the user spoke</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_tokens = math.ceil(moshi_input_values.shape[-<span class="hljs-number">1</span>] * waveform_to_token_ratio)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((<span class="hljs-number">1</span>, num_tokens), device=device, dtype=torch.int64) * tokenizer.encode(<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate 25 new tokens (around 2s of audio)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(input_ids=input_ids, user_input_values=user_input_values.input_values, moshi_input_values=moshi_input_values, max_new_tokens=<span class="hljs-number">25</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text_tokens = output.sequences
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_waveforms = output.audio_sequences`,wrap:!1}}),qe=new V({props:{title:"How does the model forward the inputs / generate:",local:"how-does-the-model-forward-the-inputs--generate",headingTag:"h3"}}),Pe=new V({props:{title:"MoshiConfig",local:"transformers.MoshiConfig",headingTag:"h2"}}),De=new N({props:{name:"class transformers.MoshiConfig",anchor:"transformers.MoshiConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"audio_vocab_size",val:" = None"},{name:"max_position_embeddings",val:" = 3000"},{name:"rope_theta",val:" = 10000.0"},{name:"hidden_act",val:" = 'silu'"},{name:"head_dim",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"sliding_window",val:" = 3000"},{name:"attention_dropout",val:" = 0.0"},{name:"ffn_dim",val:" = 22528"},{name:"rms_norm_eps",val:" = 1e-08"},{name:"num_codebooks",val:" = 8"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the MoshiDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MoshiDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MoshiConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the layers and the pooler layer of the main decoder.`,name:"hidden_size"},{anchor:"transformers.MoshiConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MoshiConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the main decoder block.`,name:"num_attention_heads"},{anchor:"transformers.MoshiConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.MoshiConfig.audio_vocab_size",description:`<strong>audio_vocab_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Vocabulary size of the audio part of model. Defines the number of different tokens that can be
represented by the <code>audio_codes</code> passed when calling the Moshi models.`,name:"audio_vocab_size"},{anchor:"transformers.MoshiConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 3000) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MoshiConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.MoshiConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.MoshiConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>hidden_size // num_attention_heads</code>) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.MoshiConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoshiConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MoshiConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 3000) &#x2014;
Sliding window attention window size. If not specified, will default to <code>3000</code>.`,name:"sliding_window"},{anchor:"transformers.MoshiConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoshiConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 22528) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the main decoder block. Must be even.`,name:"ffn_dim"},{anchor:"transformers.MoshiConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-08) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.MoshiConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of audio codebooks for each audio channels.`,name:"num_codebooks"},{anchor:"transformers.MoshiConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.MoshiConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:<ul>
<li><strong>audio_encoder_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>depth__config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the depth decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L149"}}),A=new Wt({props:{anchor:"transformers.MoshiConfig.example",$$slots:{default:[zs]},$$scope:{ctx:w}}}),Ee=new N({props:{name:"from_audio_encoder_config",anchor:"transformers.MoshiConfig.from_audio_encoder_config",parameters:[{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L314",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a></p>
`}}),Ye=new V({props:{title:"MoshiDepthConfig",local:"transformers.MoshiDepthConfig",headingTag:"h2"}}),Se=new N({props:{name:"class transformers.MoshiDepthConfig",anchor:"transformers.MoshiDepthConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 1024"},{name:"input_size",val:" = 4096"},{name:"num_hidden_layers",val:" = 6"},{name:"num_attention_heads",val:" = 16"},{name:"num_key_value_heads",val:" = None"},{name:"audio_vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 9"},{name:"hidden_act",val:" = 'silu'"},{name:"head_dim",val:" = None"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"sliding_window",val:" = 8"},{name:"attention_dropout",val:" = 0.0"},{name:"ffn_dim",val:" = 5632"},{name:"rms_norm_eps",val:" = 1e-08"},{name:"num_codebooks",val:" = 8"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiDepthConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the MoshiDepthDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MoshiDepthDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MoshiDepthConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer of the depth decoder.`,name:"hidden_size"},{anchor:"transformers.MoshiDepthConfig.input_size",description:`<strong>input_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the input hidden states. Used to connect the main decoder to the depth decoder.`,name:"input_size"},{anchor:"transformers.MoshiDepthConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of depth decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MoshiDepthConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the depth decoder block.`,name:"num_attention_heads"},{anchor:"transformers.MoshiDepthConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.MoshiDepthConfig.audio_vocab_size",description:`<strong>audio_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the audio part of model. Defines the number of different tokens that can be
represented by the <code>audio_codes</code> passed when calling the Moshi models.`,name:"audio_vocab_size"},{anchor:"transformers.MoshiDepthConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 9) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MoshiDepthConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the depth decoder.`,name:"hidden_act"},{anchor:"transformers.MoshiDepthConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>hidden_size // num_attention_heads</code>) &#x2014;
The attention head dimension.`,name:"head_dim"},{anchor:"transformers.MoshiDepthConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoshiDepthConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MoshiDepthConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Sliding window attention window size. If not specified, will default to <code>8</code>.`,name:"sliding_window"},{anchor:"transformers.MoshiDepthConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoshiDepthConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 5632) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the depth decoder block. Must be even.`,name:"ffn_dim"},{anchor:"transformers.MoshiDepthConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-08) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.MoshiDepthConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of audio codebooks for each audio channels.`,name:"num_codebooks"},{anchor:"transformers.MoshiDepthConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.MoshiDepthConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:<ul>
<li><strong>audio_encoder_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/configuration_moshi.py#L25"}}),Q=new Wt({props:{anchor:"transformers.MoshiDepthConfig.example",$$slots:{default:[js]},$$scope:{ctx:w}}}),Ae=new V({props:{title:"MoshiModel",local:"transformers.MoshiModel",headingTag:"h2"}}),Oe=new N({props:{name:"class transformers.MoshiModel",anchor:"transformers.MoshiModel",parameters:[{name:"config",val:": MoshiConfig"}],parametersDescription:[{anchor:"transformers.MoshiModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1244"}}),Qe=new N({props:{name:"forward",anchor:"transformers.MoshiModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoshiModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MoshiModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MoshiModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoshiModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoshiModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new Gt({props:{$$slots:{default:[Js]},$$scope:{ctx:w}}}),Ke=new V({props:{title:"MoshiForCausalLM",local:"transformers.MoshiForCausalLM",headingTag:"h2"}}),et=new N({props:{name:"class transformers.MoshiForCausalLM",anchor:"transformers.MoshiForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MoshiForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiForCausalLM">MoshiForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1550"}}),tt=new N({props:{name:"forward",anchor:"transformers.MoshiForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MoshiForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MoshiForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoshiForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoshiForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MoshiForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.MoshiForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1586",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.moshi.modeling_moshi.MoshiCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.moshi.modeling_moshi.MoshiCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new Gt({props:{$$slots:{default:[Fs]},$$scope:{ctx:w}}}),te=new Wt({props:{anchor:"transformers.MoshiForCausalLM.forward.example",$$slots:{default:[Gs]},$$scope:{ctx:w}}}),ot=new V({props:{title:"MoshiForConditionalGeneration",local:"transformers.MoshiForConditionalGeneration",headingTag:"h2"}}),nt=new N({props:{name:"class transformers.MoshiForConditionalGeneration",anchor:"transformers.MoshiForConditionalGeneration",parameters:[{name:"config",val:": MoshiConfig"}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig">MoshiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1690"}}),st=new N({props:{name:"forward",anchor:"transformers.MoshiForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"user_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"user_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"moshi_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"moshi_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"text_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"audio_labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MoshiForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MoshiForConditionalGeneration.forward.user_input_values",description:`<strong>user_input_values</strong> (<code>torch.FloatTensor</code> <code>of shape </code>(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;
The audio waveforms used as audio user prompt for the generation.`,name:"user_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.user_audio_codes",description:`<strong>user_audio_codes</strong> (<code>torch.Tensor</code> <code>of shape </code>(batch_size, num_codebooks, sequence_length), <em>optional</em>) &#x2014;
The audio codes used as audio user prompt for the generation. Has priority over <code>user_input_values</code> and represents the audio &#x201C;tokens&#x201D; of <code>user_input_values</code> once passed through the audio encoder.`,name:"user_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.forward.moshi_input_values",description:`<strong>moshi_input_values</strong> (<code>torch.FloatTensor</code> <code>of shape </code>(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;
The audio waveforms used as audio Moshi prompt for the generation.`,name:"moshi_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.moshi_audio_codes",description:`<strong>moshi_audio_codes</strong> (<code>torch.Tensor</code> <code>of shape </code>(batch_size, num_codebooks, sequence_length), <em>optional</em>) &#x2014;
The audio codes used as audio Moshi prompt for the generation. Has priority over <code>moshi_input_values</code> and represents the audio &#x201C;tokens&#x201D; of <code>moshi_input_values</code> once passed through the audio encoder.`,name:"moshi_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoshiForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>input_ids</code> and <code>inputs_embeds</code> are both unset, <code>inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForConditionalGeneration.forward.text_labels",description:`<strong>text_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for text language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"text_labels"},{anchor:"transformers.MoshiForConditionalGeneration.forward.audio_labels",description:`<strong>audio_labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_codebooks, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.audio_vocab_size]</code>`,name:"audio_labels"},{anchor:"transformers.MoshiForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoshiForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoshiForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoshiForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L1726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moshi#transformers.MoshiConfig"
>MoshiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Gt({props:{$$slots:{default:[Ws]},$$scope:{ctx:w}}}),ne=new Wt({props:{anchor:"transformers.MoshiForConditionalGeneration.forward.example",$$slots:{default:[Zs]},$$scope:{ctx:w}}}),at=new N({props:{name:"generate",anchor:"transformers.MoshiForConditionalGeneration.generate",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"user_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"user_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"moshi_input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"moshi_audio_codes",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_audio_waveforms",val:": typing.Optional[bool] = True"},{name:"return_audio_codes",val:": typing.Optional[bool] = None"},{name:"concat_unconditional_inputs",val:": typing.Optional[bool] = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.generate.input_ids",description:"<strong>input_ids</strong> (<code>torch.Tensor </code>of shape `(batch_size, sequence_length), <em>optional</em>) &#x2014;\nThe sequence used as a text prompt for the generation.",name:"input_ids"},{anchor:"transformers.MoshiForConditionalGeneration.generate.user_input_values",description:"<strong>user_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio user prompt for the generation.",name:"user_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.generate.user_audio_codes",description:"<strong>user_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio user prompt for the generation. Has priority over </code>user_input_values<code>and represents the audio &quot;tokens&quot; of</code>user_input_values` once passed through the audio encoder.",name:"user_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.moshi_input_values",description:"<strong>moshi_input_values</strong> (<code>torch.Tensor </code>of shape `(batch_size, 1, audio_sequence_length), <em>optional</em>) &#x2014;\nThe audio waveforms used as audio Moshi prompt for the generation.",name:"moshi_input_values"},{anchor:"transformers.MoshiForConditionalGeneration.generate.moshi_audio_codes",description:"<strong>moshi_audio_codes</strong> (<code>torch.Tensor </code>of shape <code>(batch_size, num_codebooks, sequence_length), *optional*) -- The audio codes used as audio Moshi prompt for the generation. Has priority over </code>moshi_input_values<code>and represents the audio &quot;tokens&quot; of</code>moshi_input_values` once passed through the audio encoder.",name:"moshi_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> and the audio inputs you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert the inputs into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MoshiForConditionalGeneration.generate.return_audio_waveforms",description:`<strong>return_audio_waveforms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>False</code>, won&#x2019;t generate the audio waveforms.`,name:"return_audio_waveforms"},{anchor:"transformers.MoshiForConditionalGeneration.generate.return_audio_codes",description:`<strong>return_audio_codes</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, will also returns the generated audio codes, i.e the intermediate audio &#x201C;tokens&#x201D; which transforms to <code>audio_sequences</code> once passed through the audio decoder.`,name:"return_audio_codes"},{anchor:"transformers.MoshiForConditionalGeneration.generate.concat_unconditional_inputs",description:`<strong>concat_unconditional_inputs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>False</code>, won&#x2019;t concatenate initial audio and text tokens.`,name:"concat_unconditional_inputs"},{anchor:"transformers.MoshiForConditionalGeneration.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Remaining dictionary of keyword arguments that are passed to the <code>generate</code> method. Refers to the
original <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow"><code>generate</code> docstrings</a>
for more information on how to use them.
Note that keywords with a <em>depth_</em> prefix will be input for the <code>generate</code> method of the
depth decoder. Otherwise, the latter will use its default generation config.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L2031",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>MoshiConditionalGenerationGenerateOutput</code></p>
`}}),it=new N({props:{name:"get_unconditional_inputs",anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs",parameters:[{name:"num_samples",val:" = 1"}],parametersDescription:[{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.num_samples",description:`<strong>num_samples</strong> (int, <em>optional</em>) &#x2014;
Number of audio samples to unconditionally generate.`,name:"num_samples"},{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.max_new_tokens",description:`<strong>max_new_tokens</strong> (int, <em>optional</em>) &#x2014;
Number of tokens to generate for each sample. More tokens means longer audio samples, at the expense of
longer inference (since more audio tokens need to be generated per sample).`,name:"max_new_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moshi/modeling_moshi.py#L2493"}}),ae=new Wt({props:{anchor:"transformers.MoshiForConditionalGeneration.get_unconditional_inputs.example",$$slots:{default:[Ls]},$$scope:{ctx:w}}}),rt=new xs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/moshi.md"}}),{c(){i=l("meta"),v=s(),m=l("p"),h=s(),u(y.$$.fragment),r=s(),T=l("div"),T.innerHTML=_n,Zt=s(),u(ie.$$.fragment),Lt=s(),re=l("p"),re.innerHTML=bn,It=s(),le=l("p"),le.textContent=Mn,Ut=s(),D=l("div"),D.innerHTML=yn,Ht=s(),de=l("p"),de.textContent=vn,Bt=s(),ce=l("p"),ce.innerHTML=Tn,Nt=s(),he=l("p"),he.textContent=wn,qt=s(),me=l("ol"),me.innerHTML=kn,Rt=s(),pe=l("p"),pe.innerHTML=xn,Vt=s(),ue=l("p"),ue.textContent=Cn,Xt=s(),fe=l("p"),fe.innerHTML=$n,Pt=s(),ge=l("p"),ge.innerHTML=zn,Dt=s(),_e=l("p"),_e.innerHTML=jn,Et=s(),be=l("p"),be.textContent=Jn,Yt=s(),Me=l("p"),Me.innerHTML=Fn,St=s(),ye=l("p"),ye.textContent=Gn,At=s(),ve=l("p"),ve.innerHTML=Wn,Ot=s(),Te=l("p"),Te.innerHTML=Zn,Qt=s(),u(we.$$.fragment),Kt=s(),ke=l("p"),ke.innerHTML=Ln,eo=s(),u(xe.$$.fragment),to=s(),Ce=l("p"),Ce.textContent=In,oo=s(),$e=l("ol"),$e.innerHTML=Un,no=s(),u(E.$$.fragment),so=s(),ze=l("p"),ze.innerHTML=Hn,ao=s(),je=l("p"),je.textContent=Bn,io=s(),Je=l("p"),Je.innerHTML=Nn,ro=s(),Fe=l("ol"),Fe.innerHTML=qn,lo=s(),Ge=l("p"),Ge.textContent=Rn,co=s(),We=l("p"),We.textContent=Vn,ho=s(),Ze=l("ol"),Ze.innerHTML=Xn,mo=s(),u(Y.$$.fragment),po=s(),S=l("div"),S.innerHTML=Pn,uo=s(),Le=l("p"),Le.innerHTML=Dn,fo=s(),u(Ie.$$.fragment),go=s(),Ue=l("p"),Ue.innerHTML=En,_o=s(),He=l("p"),He.textContent=Yn,bo=s(),Be=l("p"),Be.innerHTML=Sn,Mo=s(),Ne=l("p"),Ne.textContent=An,yo=s(),u(qe.$$.fragment),vo=s(),Re=l("ol"),Re.innerHTML=On,To=s(),Ve=l("p"),Ve.innerHTML=Qn,wo=s(),Xe=l("p"),Xe.innerHTML=Kn,ko=s(),u(Pe.$$.fragment),xo=s(),C=l("div"),u(De.$$.fragment),Uo=s(),ct=l("p"),ct.innerHTML=es,Ho=s(),ht=l("p"),ht.innerHTML=ts,Bo=s(),u(A.$$.fragment),No=s(),O=l("div"),u(Ee.$$.fragment),qo=s(),mt=l("p"),mt.innerHTML=os,Co=s(),u(Ye.$$.fragment),$o=s(),J=l("div"),u(Se.$$.fragment),Ro=s(),pt=l("p"),pt.innerHTML=ns,Vo=s(),ut=l("p"),ut.innerHTML=ss,Xo=s(),u(Q.$$.fragment),zo=s(),u(Ae.$$.fragment),jo=s(),$=l("div"),u(Oe.$$.fragment),Po=s(),ft=l("p"),ft.textContent=as,Do=s(),gt=l("p"),gt.innerHTML=is,Eo=s(),_t=l("p"),_t.innerHTML=rs,Yo=s(),q=l("div"),u(Qe.$$.fragment),So=s(),bt=l("p"),bt.innerHTML=ls,Ao=s(),u(K.$$.fragment),Jo=s(),u(Ke.$$.fragment),Fo=s(),z=l("div"),u(et.$$.fragment),Oo=s(),Mt=l("p"),Mt.textContent=ds,Qo=s(),yt=l("p"),yt.innerHTML=cs,Ko=s(),vt=l("p"),vt.innerHTML=hs,en=s(),L=l("div"),u(tt.$$.fragment),tn=s(),Tt=l("p"),Tt.innerHTML=ms,on=s(),u(ee.$$.fragment),nn=s(),u(te.$$.fragment),Go=s(),u(ot.$$.fragment),Wo=s(),k=l("div"),u(nt.$$.fragment),sn=s(),wt=l("p"),wt.textContent=ps,an=s(),kt=l("p"),kt.innerHTML=us,rn=s(),xt=l("p"),xt.innerHTML=fs,ln=s(),I=l("div"),u(st.$$.fragment),dn=s(),Ct=l("p"),Ct.innerHTML=gs,cn=s(),u(oe.$$.fragment),hn=s(),u(ne.$$.fragment),mn=s(),se=l("div"),u(at.$$.fragment),pn=s(),$t=l("p"),$t.textContent=_s,un=s(),R=l("div"),u(it.$$.fragment),fn=s(),zt=l("p"),zt.textContent=bs,gn=s(),u(ae.$$.fragment),Zo=s(),u(rt.$$.fragment),Lo=s(),Ft=l("p"),this.h()},l(e){const t=ks("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(o),v=a(e),m=d(e,"P",{}),Z(m).forEach(o),h=a(e),f(y.$$.fragment,e),r=a(e),T=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-b95w5j"&&(T.innerHTML=_n),Zt=a(e),f(ie.$$.fragment,e),Lt=a(e),re=d(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1ram3sl"&&(re.innerHTML=bn),It=a(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-10cdxpm"&&(le.textContent=Mn),Ut=a(e),D=d(e,"DIV",{style:!0,"data-svelte-h":!0}),c(D)!=="svelte-mbh6d3"&&(D.innerHTML=yn),Ht=a(e),de=d(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-vfdo9a"&&(de.textContent=vn),Bt=a(e),ce=d(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-ffvq6r"&&(ce.innerHTML=Tn),Nt=a(e),he=d(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-4ue2cs"&&(he.textContent=wn),qt=a(e),me=d(e,"OL",{"data-svelte-h":!0}),c(me)!=="svelte-1jvfsgp"&&(me.innerHTML=kn),Rt=a(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1ml9jf7"&&(pe.innerHTML=xn),Vt=a(e),ue=d(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-14liuk7"&&(ue.textContent=Cn),Xt=a(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-p16krn"&&(fe.innerHTML=$n),Pt=a(e),ge=d(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1q2q7g4"&&(ge.innerHTML=zn),Dt=a(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-mrya4j"&&(_e.innerHTML=jn),Et=a(e),be=d(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-1rssv50"&&(be.textContent=Jn),Yt=a(e),Me=d(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-17ugm1v"&&(Me.innerHTML=Fn),St=a(e),ye=d(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1omq70l"&&(ye.textContent=Gn),At=a(e),ve=d(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-17ls77v"&&(ve.innerHTML=Wn),Ot=a(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-133xg3y"&&(Te.innerHTML=Zn),Qt=a(e),f(we.$$.fragment,e),Kt=a(e),ke=d(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-w8i26r"&&(ke.innerHTML=Ln),eo=a(e),f(xe.$$.fragment,e),to=a(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1bexf7"&&(Ce.textContent=In),oo=a(e),$e=d(e,"OL",{"data-svelte-h":!0}),c($e)!=="svelte-pl202q"&&($e.innerHTML=Un),no=a(e),f(E.$$.fragment,e),so=a(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-29ux01"&&(ze.innerHTML=Hn),ao=a(e),je=d(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1qxprua"&&(je.textContent=Bn),io=a(e),Je=d(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-rsiv03"&&(Je.innerHTML=Nn),ro=a(e),Fe=d(e,"OL",{"data-svelte-h":!0}),c(Fe)!=="svelte-1h129yn"&&(Fe.innerHTML=qn),lo=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-mxzqdb"&&(Ge.textContent=Rn),co=a(e),We=d(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-u8oyt7"&&(We.textContent=Vn),ho=a(e),Ze=d(e,"OL",{"data-svelte-h":!0}),c(Ze)!=="svelte-1171zt7"&&(Ze.innerHTML=Xn),mo=a(e),f(Y.$$.fragment,e),po=a(e),S=d(e,"DIV",{style:!0,"data-svelte-h":!0}),c(S)!=="svelte-1tji7z9"&&(S.innerHTML=Pn),uo=a(e),Le=d(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-kta7w9"&&(Le.innerHTML=Dn),fo=a(e),f(Ie.$$.fragment,e),go=a(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1byzz9w"&&(Ue.innerHTML=En),_o=a(e),He=d(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-2rjz94"&&(He.textContent=Yn),bo=a(e),Be=d(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-78mjvt"&&(Be.innerHTML=Sn),Mo=a(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-nu560a"&&(Ne.textContent=An),yo=a(e),f(qe.$$.fragment,e),vo=a(e),Re=d(e,"OL",{"data-svelte-h":!0}),c(Re)!=="svelte-sd14aa"&&(Re.innerHTML=On),To=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-xte361"&&(Ve.innerHTML=Qn),wo=a(e),Xe=d(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-ow5c16"&&(Xe.innerHTML=Kn),ko=a(e),f(Pe.$$.fragment,e),xo=a(e),C=d(e,"DIV",{class:!0});var F=Z(C);f(De.$$.fragment,F),Uo=a(F),ct=d(F,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-1bo9y8q"&&(ct.innerHTML=es),Ho=a(F),ht=d(F,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-o55m63"&&(ht.innerHTML=ts),Bo=a(F),f(A.$$.fragment,F),No=a(F),O=d(F,"DIV",{class:!0});var lt=Z(O);f(Ee.$$.fragment,lt),qo=a(lt),mt=d(lt,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-1i23l1v"&&(mt.innerHTML=os),lt.forEach(o),F.forEach(o),Co=a(e),f(Ye.$$.fragment,e),$o=a(e),J=d(e,"DIV",{class:!0});var U=Z(J);f(Se.$$.fragment,U),Ro=a(U),pt=d(U,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-1o2zxrk"&&(pt.innerHTML=ns),Vo=a(U),ut=d(U,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-o55m63"&&(ut.innerHTML=ss),Xo=a(U),f(Q.$$.fragment,U),U.forEach(o),zo=a(e),f(Ae.$$.fragment,e),jo=a(e),$=d(e,"DIV",{class:!0});var G=Z($);f(Oe.$$.fragment,G),Po=a(G),ft=d(G,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-15qar0w"&&(ft.textContent=as),Do=a(G),gt=d(G,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-6pahdo"&&(gt.innerHTML=is),Eo=a(G),_t=d(G,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-hswkmf"&&(_t.innerHTML=rs),Yo=a(G),q=d(G,"DIV",{class:!0});var P=Z(q);f(Qe.$$.fragment,P),So=a(P),bt=d(P,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-te41l3"&&(bt.innerHTML=ls),Ao=a(P),f(K.$$.fragment,P),P.forEach(o),G.forEach(o),Jo=a(e),f(Ke.$$.fragment,e),Fo=a(e),z=d(e,"DIV",{class:!0});var W=Z(z);f(et.$$.fragment,W),Oo=a(W),Mt=d(W,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-1e5bx3"&&(Mt.textContent=ds),Qo=a(W),yt=d(W,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-6pahdo"&&(yt.innerHTML=cs),Ko=a(W),vt=d(W,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-hswkmf"&&(vt.innerHTML=hs),en=a(W),L=d(W,"DIV",{class:!0});var H=Z(L);f(tt.$$.fragment,H),tn=a(H),Tt=d(H,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-2k89wz"&&(Tt.innerHTML=ms),on=a(H),f(ee.$$.fragment,H),nn=a(H),f(te.$$.fragment,H),H.forEach(o),W.forEach(o),Go=a(e),f(ot.$$.fragment,e),Wo=a(e),k=d(e,"DIV",{class:!0});var x=Z(k);f(nt.$$.fragment,x),sn=a(x),wt=d(x,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-iq4c1a"&&(wt.textContent=ps),an=a(x),kt=d(x,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-6pahdo"&&(kt.innerHTML=us),rn=a(x),xt=d(x,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-hswkmf"&&(xt.innerHTML=fs),ln=a(x),I=d(x,"DIV",{class:!0});var B=Z(I);f(st.$$.fragment,B),dn=a(B),Ct=d(B,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-10ij2kh"&&(Ct.innerHTML=gs),cn=a(B),f(oe.$$.fragment,B),hn=a(B),f(ne.$$.fragment,B),B.forEach(o),mn=a(x),se=d(x,"DIV",{class:!0});var dt=Z(se);f(at.$$.fragment,dt),pn=a(dt),$t=d(dt,"P",{"data-svelte-h":!0}),c($t)!=="svelte-8p80bg"&&($t.textContent=_s),dt.forEach(o),un=a(x),R=d(x,"DIV",{class:!0});var jt=Z(R);f(it.$$.fragment,jt),fn=a(jt),zt=d(jt,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-99wdq5"&&(zt.textContent=bs),gn=a(jt),f(ae.$$.fragment,jt),jt.forEach(o),x.forEach(o),Zo=a(e),f(rt.$$.fragment,e),Lo=a(e),Ft=d(e,"P",{}),Z(Ft).forEach(o),this.h()},h(){j(i,"name","hf:doc:metadata"),j(i,"content",Us),j(T,"class","flex flex-wrap space-x-1"),Ms(D,"text-align","center"),Ms(S,"text-align","center"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,i),n(e,v,t),n(e,m,t),n(e,h,t),g(y,e,t),n(e,r,t),n(e,T,t),n(e,Zt,t),g(ie,e,t),n(e,Lt,t),n(e,re,t),n(e,It,t),n(e,le,t),n(e,Ut,t),n(e,D,t),n(e,Ht,t),n(e,de,t),n(e,Bt,t),n(e,ce,t),n(e,Nt,t),n(e,he,t),n(e,qt,t),n(e,me,t),n(e,Rt,t),n(e,pe,t),n(e,Vt,t),n(e,ue,t),n(e,Xt,t),n(e,fe,t),n(e,Pt,t),n(e,ge,t),n(e,Dt,t),n(e,_e,t),n(e,Et,t),n(e,be,t),n(e,Yt,t),n(e,Me,t),n(e,St,t),n(e,ye,t),n(e,At,t),n(e,ve,t),n(e,Ot,t),n(e,Te,t),n(e,Qt,t),g(we,e,t),n(e,Kt,t),n(e,ke,t),n(e,eo,t),g(xe,e,t),n(e,to,t),n(e,Ce,t),n(e,oo,t),n(e,$e,t),n(e,no,t),g(E,e,t),n(e,so,t),n(e,ze,t),n(e,ao,t),n(e,je,t),n(e,io,t),n(e,Je,t),n(e,ro,t),n(e,Fe,t),n(e,lo,t),n(e,Ge,t),n(e,co,t),n(e,We,t),n(e,ho,t),n(e,Ze,t),n(e,mo,t),g(Y,e,t),n(e,po,t),n(e,S,t),n(e,uo,t),n(e,Le,t),n(e,fo,t),g(Ie,e,t),n(e,go,t),n(e,Ue,t),n(e,_o,t),n(e,He,t),n(e,bo,t),n(e,Be,t),n(e,Mo,t),n(e,Ne,t),n(e,yo,t),g(qe,e,t),n(e,vo,t),n(e,Re,t),n(e,To,t),n(e,Ve,t),n(e,wo,t),n(e,Xe,t),n(e,ko,t),g(Pe,e,t),n(e,xo,t),n(e,C,t),g(De,C,null),p(C,Uo),p(C,ct),p(C,Ho),p(C,ht),p(C,Bo),g(A,C,null),p(C,No),p(C,O),g(Ee,O,null),p(O,qo),p(O,mt),n(e,Co,t),g(Ye,e,t),n(e,$o,t),n(e,J,t),g(Se,J,null),p(J,Ro),p(J,pt),p(J,Vo),p(J,ut),p(J,Xo),g(Q,J,null),n(e,zo,t),g(Ae,e,t),n(e,jo,t),n(e,$,t),g(Oe,$,null),p($,Po),p($,ft),p($,Do),p($,gt),p($,Eo),p($,_t),p($,Yo),p($,q),g(Qe,q,null),p(q,So),p(q,bt),p(q,Ao),g(K,q,null),n(e,Jo,t),g(Ke,e,t),n(e,Fo,t),n(e,z,t),g(et,z,null),p(z,Oo),p(z,Mt),p(z,Qo),p(z,yt),p(z,Ko),p(z,vt),p(z,en),p(z,L),g(tt,L,null),p(L,tn),p(L,Tt),p(L,on),g(ee,L,null),p(L,nn),g(te,L,null),n(e,Go,t),g(ot,e,t),n(e,Wo,t),n(e,k,t),g(nt,k,null),p(k,sn),p(k,wt),p(k,an),p(k,kt),p(k,rn),p(k,xt),p(k,ln),p(k,I),g(st,I,null),p(I,dn),p(I,Ct),p(I,cn),g(oe,I,null),p(I,hn),g(ne,I,null),p(k,mn),p(k,se),g(at,se,null),p(se,pn),p(se,$t),p(k,un),p(k,R),g(it,R,null),p(R,fn),p(R,zt),p(R,gn),g(ae,R,null),n(e,Zo,t),g(rt,e,t),n(e,Lo,t),n(e,Ft,t),Io=!0},p(e,[t]){const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),E.$set(F);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),Y.$set(lt);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),A.$set(U);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),Q.$set(G);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),K.$set(P);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),ee.$set(W);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),te.$set(H);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),oe.$set(x);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),ne.$set(B);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),ae.$set(dt)},i(e){Io||(_(y.$$.fragment,e),_(ie.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_(E.$$.fragment,e),_(Y.$$.fragment,e),_(Ie.$$.fragment,e),_(qe.$$.fragment,e),_(Pe.$$.fragment,e),_(De.$$.fragment,e),_(A.$$.fragment,e),_(Ee.$$.fragment,e),_(Ye.$$.fragment,e),_(Se.$$.fragment,e),_(Q.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Qe.$$.fragment,e),_(K.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(st.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(at.$$.fragment,e),_(it.$$.fragment,e),_(ae.$$.fragment,e),_(rt.$$.fragment,e),Io=!0)},o(e){b(y.$$.fragment,e),b(ie.$$.fragment,e),b(we.$$.fragment,e),b(xe.$$.fragment,e),b(E.$$.fragment,e),b(Y.$$.fragment,e),b(Ie.$$.fragment,e),b(qe.$$.fragment,e),b(Pe.$$.fragment,e),b(De.$$.fragment,e),b(A.$$.fragment,e),b(Ee.$$.fragment,e),b(Ye.$$.fragment,e),b(Se.$$.fragment,e),b(Q.$$.fragment,e),b(Ae.$$.fragment,e),b(Oe.$$.fragment,e),b(Qe.$$.fragment,e),b(K.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(st.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(at.$$.fragment,e),b(it.$$.fragment,e),b(ae.$$.fragment,e),b(rt.$$.fragment,e),Io=!1},d(e){e&&(o(v),o(m),o(h),o(r),o(T),o(Zt),o(Lt),o(re),o(It),o(le),o(Ut),o(D),o(Ht),o(de),o(Bt),o(ce),o(Nt),o(he),o(qt),o(me),o(Rt),o(pe),o(Vt),o(ue),o(Xt),o(fe),o(Pt),o(ge),o(Dt),o(_e),o(Et),o(be),o(Yt),o(Me),o(St),o(ye),o(At),o(ve),o(Ot),o(Te),o(Qt),o(Kt),o(ke),o(eo),o(to),o(Ce),o(oo),o($e),o(no),o(so),o(ze),o(ao),o(je),o(io),o(Je),o(ro),o(Fe),o(lo),o(Ge),o(co),o(We),o(ho),o(Ze),o(mo),o(po),o(S),o(uo),o(Le),o(fo),o(go),o(Ue),o(_o),o(He),o(bo),o(Be),o(Mo),o(Ne),o(yo),o(vo),o(Re),o(To),o(Ve),o(wo),o(Xe),o(ko),o(xo),o(C),o(Co),o($o),o(J),o(zo),o(jo),o($),o(Jo),o(Fo),o(z),o(Go),o(Wo),o(k),o(Zo),o(Lo),o(Ft)),o(i),M(y,e),M(ie,e),M(we,e),M(xe,e),M(E,e),M(Y,e),M(Ie,e),M(qe,e),M(Pe,e),M(De),M(A),M(Ee),M(Ye,e),M(Se),M(Q),M(Ae,e),M(Oe),M(Qe),M(K),M(Ke,e),M(et),M(tt),M(ee),M(te),M(ot,e),M(nt),M(st),M(oe),M(ne),M(at),M(it),M(ae),M(rt,e)}}}const Us='{"title":"Moshi","local":"moshi","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Tips:","local":"tips","sections":[{"title":"How to use the model:","local":"how-to-use-the-model","sections":[],"depth":3},{"title":"How does the model forward the inputs / generate:","local":"how-does-the-model-forward-the-inputs--generate","sections":[],"depth":3}],"depth":2},{"title":"MoshiConfig","local":"transformers.MoshiConfig","sections":[],"depth":2},{"title":"MoshiDepthConfig","local":"transformers.MoshiDepthConfig","sections":[],"depth":2},{"title":"MoshiModel","local":"transformers.MoshiModel","sections":[],"depth":2},{"title":"MoshiForCausalLM","local":"transformers.MoshiForCausalLM","sections":[],"depth":2},{"title":"MoshiForConditionalGeneration","local":"transformers.MoshiForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Hs(w){return vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends Ts{constructor(i){super(),ws(this,i,Hs,Is,ys,{})}}export{Es as component};
