import{s as ta,o as na,n as jt}from"../chunks/scheduler.18a86fab.js";import{S as oa,i as sa,g as r,s,r as u,A as aa,h as l,f as n,c as a,j as x,u as p,x as m,k as U,y as c,a as o,v as h,d as g,t as f,w as y}from"../chunks/index.98837b22.js";import{T as Oo}from"../chunks/Tip.77304350.js";import{D as I}from"../chunks/Docstring.6758ea23.js";import{C as k}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as fo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as w}from"../chunks/Heading.7e7e0c5b.js";import{E as ra}from"../chunks/index.499f366c.js";function la(j){let i,T="Example:",M,_,b;return _=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IlMEElMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMiklMEElMEElMjMlMjBnZXQlMjB0aGUlMjB1bmNvbmRpdGlvbmFsJTIwKG9yJTIwJ251bGwnKSUyMGlucHV0cyUyMGZvciUyMHRoZSUyMG1vZGVsJTBBcHJvY2Vzc29yJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQXVuY29uZGl0aW9uYWxfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBJTBBYXVkaW9fc2FtcGxlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdW5jb25kaXRpb25hbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration, MusicgenMelodyProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the unconditional (or &#x27;null&#x27;) inputs for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MusicgenMelodyProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = processor.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_samples = model.generate(**unconditional_inputs, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=r("p"),i.textContent=T,M=s(),u(_.$$.fragment)},l(d){i=l(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-11lpom8"&&(i.textContent=T),M=a(d),p(_.$$.fragment,d)},m(d,v){o(d,i,v),o(d,M,v),h(_,d,v),b=!0},p:jt,i(d){b||(g(_.$$.fragment,d),b=!0)},o(d){f(_.$$.fragment,d),b=!1},d(d){d&&(n(i),n(M)),y(_,d)}}}function ia(j){let i,T="Example:",M,_,b;return _=new k({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MusicgenMelodyConfig,
<span class="hljs-meta">... </span>    MusicgenMelodyDecoderConfig,
<span class="hljs-meta">... </span>    T5Config,
<span class="hljs-meta">... </span>    EncodecConfig,
<span class="hljs-meta">... </span>    MusicgenMelodyForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing text encoder, audio encoder, and decoder model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_config = T5Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_encoder_config = EncodecConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = MusicgenMelodyDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MusicgenMelodyConfig.from_sub_models_config(
<span class="hljs-meta">... </span>    text_encoder_config, audio_encoder_config, decoder_config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MusicgenMelodyForConditionalGeneration (with random weights) from the facebook/musicgen-melody style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text_encoder = model.config.text_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_audio_encoder = model.config.audio_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>musicgen_melody_config = MusicgenMelodyConfig.from_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>, config=musicgen_melody_config)`,wrap:!1}}),{c(){i=r("p"),i.textContent=T,M=s(),u(_.$$.fragment)},l(d){i=l(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-11lpom8"&&(i.textContent=T),M=a(d),p(_.$$.fragment,d)},m(d,v){o(d,i,v),o(d,M,v),h(_,d,v),b=!0},p:jt,i(d){b||(g(_.$$.fragment,d),b=!0)},o(d){f(_.$$.fragment,d),b=!1},d(d){d&&(n(i),n(M)),y(_,d)}}}function da(j){let i,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=r("p"),i.innerHTML=T},l(M){i=l(M,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fincs2"&&(i.innerHTML=T)},m(M,_){o(M,i,_)},p:jt,d(M){M&&n(i)}}}function ca(j){let i,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=r("p"),i.innerHTML=T},l(M){i=l(M,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fincs2"&&(i.innerHTML=T)},m(M,_){o(M,i,_)},p:jt,d(M){M&&n(i)}}}function ma(j){let i,T="Example:",M,_,b;return _=new k({props:{code:"",highlighted:"",wrap:!1}}),{c(){i=r("p"),i.textContent=T,M=s(),u(_.$$.fragment)},l(d){i=l(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-11lpom8"&&(i.textContent=T),M=a(d),p(_.$$.fragment,d)},m(d,v){o(d,i,v),o(d,M,v),h(_,d,v),b=!0},p:jt,i(d){b||(g(_.$$.fragment,d),b=!0)},o(d){f(_.$$.fragment,d),b=!1},d(d){d&&(n(i),n(M)),y(_,d)}}}function ua(j){let i,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=r("p"),i.innerHTML=T},l(M){i=l(M,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fincs2"&&(i.innerHTML=T)},m(M,_){o(M,i,_)},p:jt,d(M){M&&n(i)}}}function pa(j){let i,T="Examples:",M,_,b;return _=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjI4MHMlMjBwb3AlMjB0cmFjayUyMHdpdGglMjBiYXNzeSUyMGRydW1zJTIwYW5kJTIwc3ludGglMjIlMkMlMjAlMjI5MHMlMjByb2NrJTIwc29uZyUyMHdpdGglMjBsb3VkJTIwZ3VpdGFycyUyMGFuZCUyMGhlYXZ5JTIwZHJ1bXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBJTBBcGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcucGFkX3Rva2VuX2lkJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwdG9yY2gub25lcygoaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjAlNUQlMjAqJTIwbW9kZWwuZGVjb2Rlci5udW1fY29kZWJvb2tzJTJDJTIwMSklMkMlMjBkdHlwZSUzRHRvcmNoLmxvbmcpJTBBJTIwJTIwJTIwJTIwKiUyMHBhZF90b2tlbl9pZCUwQSklMEElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpLmxvZ2l0cyUwQWxvZ2l0cy5zaGFwZSUyMCUyMCUyMyUyMChic3olMjAqJTIwbnVtX2NvZGVib29rcyUyQyUyMGVuY29kZXJfbGVuJTIwJTJCJTIwdGd0X2xlbiUyQyUyMHZvY2FiX3NpemUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pad_token_id = model.generation_config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = (
<span class="hljs-meta">... </span>    torch.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>] * model.decoder.num_codebooks, <span class="hljs-number">1</span>), dtype=torch.long)
<span class="hljs-meta">... </span>    * pad_token_id
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, decoder_input_ids=decoder_input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz * num_codebooks, encoder_len + tgt_len, vocab_size)</span>
torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">249</span>, <span class="hljs-number">2048</span>])`,wrap:!1}}),{c(){i=r("p"),i.textContent=T,M=s(),u(_.$$.fragment)},l(d){i=l(d,"P",{"data-svelte-h":!0}),m(i)!=="svelte-kvfsh7"&&(i.textContent=T),M=a(d),p(_.$$.fragment,d)},m(d,v){o(d,i,v),o(d,M,v),h(_,d,v),b=!0},p:jt,i(d){b||(g(_.$$.fragment,d),b=!0)},o(d){f(_.$$.fragment,d),b=!1},d(d){d&&(n(i),n(M)),y(_,d)}}}function ha(j){let i,T,M,_,b,d,v,Ko='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',At,se,Ot,ae,es='The MusicGen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi and Alexandre Défossez.',Kt,re,ts="MusicGen Melody is a single stage auto-regressive Transformer model capable of generating high-quality music samples conditioned on text descriptions or audio prompts. The text descriptions are passed through a frozen text encoder model to obtain a sequence of hidden-state representations. MusicGen is then trained to predict discrete audio tokens, or <em>audio codes</em>, conditioned on these hidden-states. These audio tokens are then decoded using an audio compression model, such as EnCodec, to recover the audio waveform.",en,le,ns="Through an efficient token interleaving pattern, MusicGen does not require a self-supervised semantic representation of the text/audio prompts, thus eliminating the need to cascade multiple models to predict a set of codebooks (e.g. hierarchically or upsampling). Instead, it is able to generate all the codebooks in a single forward pass.",tn,ie,os="The abstract from the paper is the following:",nn,de,ss="<em>We tackle the task of conditional music generation. We introduce MusicGen, a single Language Model (LM) that operates over several streams of compressed discrete music representation, i.e., tokens. Unlike prior work, MusicGen is comprised of a single-stage transformer LM together with efficient token interleaving patterns, which eliminates the need for cascading several models, e.g., hierarchically or upsampling. Following this approach, we demonstrate how MusicGen can generate high-quality samples, while being conditioned on textual description or melodic features, allowing better controls over the generated output. We conduct extensive empirical evaluation, considering both automatic and human studies, showing the proposed approach is superior to the evaluated baselines on a standard text-to-music benchmark. Through ablation studies, we shed light over the importance of each of the components comprising MusicGen.</em>",on,ce,as='This model was contributed by <a href="https://huggingface.co/ylacombe" rel="nofollow">ylacombe</a>. The original code can be found <a href="https://github.com/facebookresearch/audiocraft" rel="nofollow">here</a>. The pre-trained checkpoints can be found on the <a href="https://huggingface.co/models?sort=downloads&amp;search=facebook%2Fmusicgen" rel="nofollow">Hugging Face Hub</a>.',sn,me,an,ue,rs="There are two key differences with MusicGen:",rn,pe,ls='<li>The audio prompt is used here as a conditional signal for the generated audio sample, whereas it’s used for audio continuation in <a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>.</li> <li>Conditional text and audio signals are concatenated to the decoder’s hidden states instead of being used as a cross-attention signal, as in MusicGen.</li>',ln,he,dn,ge,is="MusicGen Melody is compatible with two generation modes: greedy and sampling. In practice, sampling leads to significantly better results than greedy, thus we encourage sampling mode to be used where possible. Sampling is enabled by default, and can be explicitly specified by setting <code>do_sample=True</code> in the call to <code>MusicgenMelodyForConditionalGeneration.generate()</code>, or by overriding the model’s generation config (see below).",cn,fe,ds="Transformers supports both mono (1-channel) and stereo (2-channel) variants of MusicGen Melody. The mono channel versions generate a single set of codebooks. The stereo versions generate 2 sets of codebooks, 1 for each channel (left/right), and each set of codebooks is decoded independently through the audio compression model. The audio streams for each channel are combined to give the final stereo output.",mn,ye,un,Me,cs='The model can generate an audio sample conditioned on a text and an audio prompt through use of the <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor">MusicgenMelodyProcessor</a> to pre-process the inputs.',pn,_e,ms="In the following examples, we load an audio file using the 🤗 Datasets library, which can be pip installed through the command below:",hn,be,gn,Te,us="The audio file we are about to use is loaded as follows:",fn,ve,yn,we,ps='The audio prompt should ideally be free of the low-frequency signals usually produced by instruments such as drums and bass. The <a href="https://github.com/adefossez/demucs/tree/main" rel="nofollow">Demucs</a> model can be used to separate vocals and other signals from the drums and bass components.',Mn,ke,hs='If you wish to use Demucs, you first need to follow the installation steps <a href="https://github.com/adefossez/demucs/tree/main?tab=readme-ov-file#for-musicians" rel="nofollow">here</a> before using the following snippet:',_n,je,bn,Je,gs="You can then use the following snippet to generate music:",Tn,Ce,vn,Ze,fs="You can also pass the audio signal directly without using Demucs, although the quality of the generation will probably be degraded:",wn,$e,kn,Ue,ys="The audio outputs are a three-dimensional Torch tensor of shape <code>(batch_size, num_channels, sequence_length)</code>. To listen to the generated audio samples, you can either play them in an ipynb notebook:",jn,xe,Jn,Ge,Ms="Or save them as a <code>.wav</code> file using a third-party library, e.g. <code>soundfile</code>:",Cn,We,Zn,Fe,$n,Ve,_s='The same <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor">MusicgenMelodyProcessor</a> can be used to pre-process a text-only prompt.',Un,ze,xn,Ne,bs="The <code>guidance_scale</code> is used in classifier free guidance (CFG), setting the weighting between the conditional logits (which are predicted from the text prompts) and the unconditional logits (which are predicted from an unconditional or ‘null’ prompt). Higher guidance scale encourages the model to generate samples that are more closely linked to the input prompt, usually at the expense of poorer audio quality. CFG is enabled by setting <code>guidance_scale &gt; 1</code>. For best results, use <code>guidance_scale=3</code> (default).",Gn,Ie,Ts="You can also generate in batch:",Wn,Be,Fn,Re,Vn,Xe,vs='The inputs for unconditional (or ‘null’) generation can be obtained through the method <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor.get_unconditional_inputs">MusicgenMelodyProcessor.get_unconditional_inputs()</a>:',zn,He,Nn,Ee,In,qe,ws="The default parameters that control the generation process, such as sampling, guidance scale and number of generated tokens, can be found in the model’s generation config, and updated as desired:",Bn,Ye,Rn,Le,ks="Note that any arguments passed to the generate method will <strong>supersede</strong> those in the generation config, so setting <code>do_sample=False</code> in the call to generate will supersede the setting of <code>model.generation_config.do_sample</code> in the generation config.",Xn,Qe,Hn,Se,js="The MusicGen model can be de-composed into three distinct stages:",En,Pe,Js="<li>Text encoder: maps the text inputs to a sequence of hidden-state representations. The pre-trained MusicGen models use a frozen text encoder from either T5 or Flan-T5.</li> <li>MusicGen Melody decoder: a language model (LM) that auto-regressively generates audio tokens (or codes) conditional on the encoder hidden-state representations</li> <li>Audio decoder: used to recover the audio waveform from the audio tokens predicted by the decoder.</li>",qn,De,Cs='Thus, the MusicGen model can either be used as a standalone decoder model, corresponding to the class <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a>, or as a composite model that includes the text encoder and audio encoder, corresponding to the class <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a>. If only the decoder needs to be loaded from the pre-trained checkpoint, it can be loaded by first specifying the correct config, or be accessed through the <code>.decoder</code> attribute of the composite model:',Yn,Ae,Ln,Oe,Zs='Since the text encoder and audio encoder models are frozen during training, the MusicGen decoder <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> can be trained standalone on a dataset of encoder hidden-states and audio codes. For inference, the trained decoder can be combined with the frozen text encoder and audio encoder to recover the composite <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a> model.',Qn,Ke,Sn,et,$s='<li>After downloading the original checkpoints from <a href="https://github.com/facebookresearch/audiocraft/blob/main/docs/MUSICGEN.md#importing--exporting-models" rel="nofollow">here</a>, you can convert them using the <strong>conversion script</strong> available at <code>src/transformers/models/musicgen_melody/convert_musicgen_melody_transformers.py</code> with the following command:</li>',Pn,tt,Dn,nt,Us="Tips:",An,ot,xs="<li>MusicGen is trained on the 32kHz checkpoint of Encodec. You should ensure you use a compatible version of the Encodec model.</li> <li>Sampling mode tends to deliver better results than greedy - you can toggle sampling with the variable <code>do_sample</code> in the call to <code>MusicgenMelodyForConditionalGeneration.generate()</code></li>",On,st,Kn,B,at,yo,Jt,Gs=`This is the configuration class to store the configuration of an <code>MusicgenMelodyDecoder</code>. It is used to instantiate a
Musicgen Melody decoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Musicgen Melody
<a href="https://huggingface.co/facebook/musicgen-melody" rel="nofollow">facebook/musicgen-melody</a> architecture.`,Mo,Ct,Ws=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,eo,rt,to,G,lt,_o,Zt,Fs=`Constructs a MusicGen Melody processor which wraps a Wav2Vec2 feature extractor - for raw audio waveform processing - and a T5 tokenizer into a single processor
class.`,bo,$t,Vs=`<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a> and <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>. See
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor.decode">decode()</a> for more information.`,To,H,it,vo,Ut,zs=`Helper function to get null inputs for unconditional generation, enabling the model to be used without the
feature extractor or tokenizer.`,wo,S,no,dt,oo,W,ct,ko,xt,Ns="Constructs a MusicgenMelody feature extractor.",jo,Gt,Is=`This feature extractor inherits from <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> which contains
most of the main methods. Users should refer to this superclass for more information regarding those methods.`,Jo,Wt,Bs=`This class extracts chroma features from audio processed by <a href="https://github.com/adefossez/demucs/tree/main" rel="nofollow">Demucs</a> or
directly from raw audio waveform.`,so,mt,ao,J,ut,Co,Ft,Rs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyModel">MusicgenMelodyModel</a>. It is used to instantiate a
Musicgen Melody model according to the specified arguments, defining the text encoder, audio encoder and Musicgen Melody decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the Musicgen Melody
<a href="https://huggingface.co/facebook/musicgen-melody" rel="nofollow">facebook/musicgen-melody</a> architecture.`,Zo,Vt,Xs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,$o,P,Uo,D,pt,xo,zt,Hs=`Instantiate a <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a> (or a derived class) from text encoder, audio encoder and decoder
configurations.`,ro,ht,lo,C,gt,Go,Nt,Es="The bare Musicgen Melody Model outputting raw hidden-states without any specific head on top.",Wo,It,qs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Fo,Bt,Ys=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Vo,E,ft,zo,Rt,Ls='The <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyModel">MusicgenMelodyModel</a> forward method, overrides the <code>__call__</code> special method.',No,A,io,yt,co,Z,Mt,Io,Xt,Qs="The Musicgen Melody decoder model with a language modelling head on top.",Bo,Ht,Ss=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ro,Et,Ps=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Xo,z,_t,Ho,qt,Ds='The <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Eo,O,qo,K,mo,bt,uo,$,Tt,Yo,Yt,As="The Musicgen Melody Model for token generation conditioned on other modalities (e.g. image-text-to-text generation).",Lo,Lt,Os=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qo,Qt,Ks=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,So,N,vt,Po,St,ea='The <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Do,ee,Ao,te,po,wt,ho,Dt,go;return b=new w({props:{title:"MusicGen Melody",local:"musicgen-melody",headingTag:"h1"}}),se=new w({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new w({props:{title:"Difference with MusicGen",local:"difference-with-musicgen",headingTag:"h2"}}),he=new w({props:{title:"Generation",local:"generation",headingTag:"h2"}}),ye=new w({props:{title:"Audio Conditional Generation",local:"audio-conditional-generation",headingTag:"h4"}}),be=new k({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyU1QmF1ZGlvJTVE",highlighted:`pip <span class="hljs-keyword">install</span> --upgrade pip
pip <span class="hljs-keyword">install</span> datasets[audio]`,wrap:!1}}),ve=new k({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYW5jaGl0LWdhbmRoaSUyRmd0emFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGRhdGFzZXQpKSU1QiUyMmF1ZGlvJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]`,wrap:!1}}),je=new k({props:{code:"ZnJvbSUyMGRlbXVjcyUyMGltcG9ydCUyMHByZXRyYWluZWQlMEFmcm9tJTIwZGVtdWNzLmFwcGx5JTIwaW1wb3J0JTIwYXBwbHlfbW9kZWwlMEFmcm9tJTIwZGVtdWNzLmF1ZGlvJTIwaW1wb3J0JTIwY29udmVydF9hdWRpbyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTBBd2F2JTIwJTNEJTIwdG9yY2gudGVuc29yKHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEKS50byh0b3JjaC5mbG9hdDMyKSUwQSUwQWRlbXVjcyUyMCUzRCUyMHByZXRyYWluZWQuZ2V0X21vZGVsKCdodGRlbXVjcycpJTBBJTBBd2F2JTIwJTNEJTIwY29udmVydF9hdWRpbyh3YXYlNUJOb25lJTVEJTJDJTIwc2FtcGxlJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUyMGRlbXVjcy5zYW1wbGVyYXRlJTJDJTIwZGVtdWNzLmF1ZGlvX2NoYW5uZWxzKSUwQXdhdiUyMCUzRCUyMGFwcGx5X21vZGVsKGRlbXVjcyUyQyUyMHdhdiU1Qk5vbmUlNUQp",highlighted:`<span class="hljs-keyword">from</span> demucs <span class="hljs-keyword">import</span> pretrained
<span class="hljs-keyword">from</span> demucs.apply <span class="hljs-keyword">import</span> apply_model
<span class="hljs-keyword">from</span> demucs.audio <span class="hljs-keyword">import</span> convert_audio
<span class="hljs-keyword">import</span> torch


wav = torch.tensor(sample[<span class="hljs-string">&quot;array&quot;</span>]).to(torch.float32)

demucs = pretrained.get_model(<span class="hljs-string">&#x27;htdemucs&#x27;</span>)

wav = convert_audio(wav[<span class="hljs-literal">None</span>], sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>], demucs.samplerate, demucs.audio_channels)
wav = apply_model(demucs, wav[<span class="hljs-literal">None</span>])`,wrap:!1}}),Ce=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHdhdiUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RkZW11Y3Muc2FtcGxlcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjI4MHMlMjBibHVlcyUyMHRyYWNrJTIwd2l0aCUyMGdyb292eSUyMHNheG9waG9uZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=wav,
<span class="hljs-meta">... </span>    sampling_rate=demucs.samplerate,
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),$e=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=sample[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),xe=new k({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyLnNhbXBsaW5nX3JhdGUlMEFBdWRpbyhhdWRpb192YWx1ZXMlNUIwJTVELm51bXB5KCklMkMlMjByYXRlJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sampling_rate = model.config.audio_encoder.sampling_rate
Audio(audio_values[<span class="hljs-number">0</span>].numpy(), rate=sampling_rate)`,wrap:!1}}),We=new k({props:{code:"aW1wb3J0JTIwc291bmRmaWxlJTIwYXMlMjBzZiUwQSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBtb2RlbC5jb25maWcuYXVkaW9fZW5jb2Rlci5zYW1wbGluZ19yYXRlJTBBc2Yud3JpdGUoJTIybXVzaWNnZW5fb3V0LndhdiUyMiUyQyUyMGF1ZGlvX3ZhbHVlcyU1QjAlNUQuVC5udW1weSgpJTJDJTIwc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = model.config.audio_encoder.sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>sf.write(<span class="hljs-string">&quot;musicgen_out.wav&quot;</span>, audio_values[<span class="hljs-number">0</span>].T.numpy(), sampling_rate)`,wrap:!1}}),Fe=new w({props:{title:"Text-only Conditional Generation",local:"text-only-conditional-generation",headingTag:"h3"}}),ze=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwcG9wJTIwdHJhY2slMjB3aXRoJTIwYmFzc3klMjBkcnVtcyUyMGFuZCUyMHN5bnRoJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWF1ZGlvX3ZhbHVlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Be=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQSUyMyUyMHRha2UlMjB0aGUlMjBmaXJzdCUyMHF1YXJ0ZXIlMjBvZiUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTBBc2FtcGxlXzElMjAlM0QlMjBzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCU1QiUzQSUyMGxlbihzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCklMjAlMkYlMkYlMjA0JTVEJTBBJTBBJTIzJTIwdGFrZSUyMHRoZSUyMGZpcnN0JTIwaGFsZiUyMG9mJTIwdGhlJTIwYXVkaW8lMjBzYW1wbGUlMEFzYW1wbGVfMiUyMCUzRCUyMHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTVCJTNBJTIwbGVuKHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEKSUyMCUyRiUyRiUyMDIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwYXVkaW8lM0QlNUJzYW1wbGVfMSUyQyUyMHNhbXBsZV8yJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlMkMlMjAlMjI5MHMlMjByb2NrJTIwc29uZyUyMHdpdGglMjBsb3VkJTIwZ3VpdGFycyUyMGFuZCUyMGhlYXZ5JTIwZHJ1bXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first quarter of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_1 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_2 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=[sample_1, sample_2],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Re=new w({props:{title:"Unconditional Generation",local:"unconditional-generation",headingTag:"h3"}}),He=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IlMEElMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMiklMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyME11c2ljZ2VuTWVsb2R5UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMikuZ2V0X3VuY29uZGl0aW9uYWxfaW5wdXRzKG51bV9zYW1wbGVzJTNEMSklMEElMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKnVuY29uZGl0aW9uYWxfaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration, MusicgenMelodyProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = MusicgenMelodyProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**unconditional_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ee=new w({props:{title:"Generation Configuration",local:"generation-configuration",headingTag:"h3"}}),Ye=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBJTBBJTIzJTIwaW5zcGVjdCUyMHRoZSUyMGRlZmF1bHQlMjBnZW5lcmF0aW9uJTIwY29uZmlnJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWclMEElMEElMjMlMjBpbmNyZWFzZSUyMHRoZSUyMGd1aWRhbmNlJTIwc2NhbGUlMjB0byUyMDQuMCUwQW1vZGVsLmdlbmVyYXRpb25fY29uZmlnLmd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwNC4wJTBBJTBBJTIzJTIwZGVjcmVhc2UlMjB0aGUlMjBtYXglMjBsZW5ndGglMjB0byUyMDI1NiUyMHRva2VucyUwQW1vZGVsLmdlbmVyYXRpb25fY29uZmlnLm1heF9sZW5ndGglMjAlM0QlMjAyNTY=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inspect the default generation config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># increase the guidance scale to 4.0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.guidance_scale = <span class="hljs-number">4.0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decrease the max length to 256 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.max_length = <span class="hljs-number">256</span>`,wrap:!1}}),Qe=new w({props:{title:"Model Structure",local:"model-structure",headingTag:"h2"}}),Ae=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBNdXNpY2dlbk1lbG9keUZvckNhdXNhbExNJTJDJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMjMlMjBPcHRpb24lMjAxJTNBJTIwZ2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMGFuZCUyMHBhc3MlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQlNjAlMEFkZWNvZGVyX2NvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKS5kZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyJTJDJTIwKipkZWNvZGVyX2NvbmZpZy50b19kaWN0KCkpJTBBJTBBJTIzJTIwT3B0aW9uJTIwMiUzQSUyMGxvYWQlMjB0aGUlMjBlbnRpcmUlMjBjb21wb3NpdGUlMjBtb2RlbCUyQyUyMGJ1dCUyMG9ubHklMjByZXR1cm4lMjB0aGUlMjBkZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMikuZGVjb2Rlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, MusicgenMelodyForCausalLM, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 1: get decoder config and pass to \`.from_pretrained\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).decoder
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenMelodyForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>, **decoder_config.to_dict())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 2: load the entire composite model, but only return the decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).decoder`,wrap:!1}}),Ke=new w({props:{title:"Checkpoint Conversion",local:"checkpoint-conversion",headingTag:"h2"}}),tt=new k({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbXVzaWNnZW5fbWVsb2R5JTJGY29udmVydF9tdXNpY2dlbl9tZWxvZHlfdHJhbnNmb3JtZXJzLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50JTNEJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIlMjAtLXB5dG9yY2hfZHVtcF9mb2xkZXIlMjAlMkZvdXRwdXQlMkZwYXRoJTIw",highlighted:`python src/transformers/models/musicgen_melody/convert_musicgen_melody_transformers.py \\
    --checkpoint=<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span> --pytorch_dump_folder /output/path `,wrap:!1}}),st=new w({props:{title:"MusicgenMelodyDecoderConfig",local:"transformers.MusicgenMelodyDecoderConfig",headingTag:"h2"}}),at=new I({props:{name:"class transformers.MusicgenMelodyDecoderConfig",anchor:"transformers.MusicgenMelodyDecoderConfig",parameters:[{name:"vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 2048"},{name:"num_hidden_layers",val:" = 24"},{name:"ffn_dim",val:" = 4096"},{name:"num_attention_heads",val:" = 16"},{name:"layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"hidden_size",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"initializer_factor",val:" = 0.02"},{name:"scale_embedding",val:" = False"},{name:"num_codebooks",val:" = 4"},{name:"audio_channels",val:" = 1"},{name:"pad_token_id",val:" = 2048"},{name:"bos_token_id",val:" = 2048"},{name:"eos_token_id",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyDecoderConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the MusicgenMelodyDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MusicgenMelodyDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MusicgenMelodyDecoderConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MusicgenMelodyDecoderConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer block.`,name:"ffn_dim"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer block.`,name:"num_attention_heads"},{anchor:"transformers.MusicgenMelodyDecoderConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"layerdrop"},{anchor:"transformers.MusicgenMelodyDecoderConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyDecoderConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MusicgenMelodyDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MusicgenMelodyDecoderConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, text_encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.MusicgenMelodyDecoderConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(hidden_size).`,name:"scale_embedding"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of parallel codebooks forwarded to the model.`,name:"num_codebooks"},{anchor:"transformers.MusicgenMelodyDecoderConfig.audio_channels",description:`<strong>audio_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of audio channels used by the model (either mono or stereo). Stereo models generate a separate
audio stream for the left/right output channels. Mono models generate a single audio stream output.`,name:"audio_channels"},{anchor:"transformers.MusicgenMelodyDecoderConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014; The id of the <em>beginning-of-sequence</em> token.",name:"bos_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.eos_token_id",description:"<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>end-of-sequence</em> token.",name:"eos_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.tie_word_embeddings",description:"<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to tie word embeddings with the text encoder.",name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L25"}}),rt=new w({props:{title:"MusicgenMelodyProcessor",local:"transformers.MusicgenMelodyProcessor",headingTag:"h2"}}),lt=new I({props:{name:"class transformers.MusicgenMelodyProcessor",anchor:"transformers.MusicgenMelodyProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>MusicgenMelodyFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MusicgenMelodyProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/processing_musicgen_melody.py#L28"}}),it=new I({props:{name:"get_unconditional_inputs",anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs",parameters:[{name:"num_samples",val:" = 1"},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs.num_samples",description:`<strong>num_samples</strong> (int, <em>optional</em>) &#x2014;
Number of audio samples to unconditionally generate.`,name:"num_samples"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/processing_musicgen_melody.py#L153"}}),S=new fo({props:{anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs.example",$$slots:{default:[la]},$$scope:{ctx:j}}}),dt=new w({props:{title:"MusicgenMelodyFeatureExtractor",local:"transformers.MusicgenMelodyFeatureExtractor",headingTag:"h2"}}),ct=new I({props:{name:"class transformers.MusicgenMelodyFeatureExtractor",anchor:"transformers.MusicgenMelodyFeatureExtractor",parameters:[{name:"feature_size",val:" = 12"},{name:"sampling_rate",val:" = 32000"},{name:"hop_length",val:" = 4096"},{name:"chunk_length",val:" = 30"},{name:"n_fft",val:" = 16384"},{name:"num_chroma",val:" = 12"},{name:"padding_value",val:" = 0.0"},{name:"return_attention_mask",val:" = False"},{name:"stem_indices",val:" = [3, 2]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyFeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The feature dimension of the extracted features.`,name:"feature_size"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.hop_length",description:`<strong>hop_length</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Length of the overlapping windows for the STFT used to obtain the Mel Frequency coefficients.`,name:"hop_length"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.chunk_length",description:`<strong>chunk_length</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
The maximum number of chunks of <code>sampling_rate</code> samples used to trim and pad longer or shorter audio
sequences.`,name:"chunk_length"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.n_fft",description:`<strong>n_fft</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Size of the Fourier transform.`,name:"n_fft"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.num_chroma",description:`<strong>num_chroma</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of chroma bins to use.`,name:"num_chroma"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Padding value used to pad the audio.`,name:"padding_value"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return the attention mask. Can be overwritten when calling the feature extractor.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>For Whisper models, <code>attention_mask</code> should always be passed for batched inference, to avoid subtle
bugs.</p>

					</div>`,name:"return_attention_mask"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.stem_indices",description:`<strong>stem_indices</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 2]</code>) &#x2014;
Stem channels to extract if demucs outputs are passed.`,name:"stem_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/feature_extraction_musicgen_melody.py#L40"}}),mt=new w({props:{title:"MusicgenMelodyConfig",local:"transformers.MusicgenMelodyConfig",headingTag:"h2"}}),ut=new I({props:{name:"class transformers.MusicgenMelodyConfig",anchor:"transformers.MusicgenMelodyConfig",parameters:[{name:"num_chroma",val:" = 12"},{name:"chroma_length",val:" = 235"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyConfig.num_chroma",description:"<strong>num_chroma</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014; Number of chroma bins to use.",name:"num_chroma"},{anchor:"transformers.MusicgenMelodyConfig.chroma_length",description:`<strong>chroma_length</strong> (<code>int</code>, <em>optional</em>, defaults to 235) &#x2014;
Maximum chroma duration if audio is used to condition the model. Corresponds to the maximum duration used during training.`,name:"chroma_length"},{anchor:"transformers.MusicgenMelodyConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>text_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the text encoder config.</li>
<li><strong>audio_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L137"}}),P=new fo({props:{anchor:"transformers.MusicgenMelodyConfig.example",$$slots:{default:[ia]},$$scope:{ctx:j}}}),pt=new I({props:{name:"from_sub_models_config",anchor:"transformers.MusicgenMelodyConfig.from_sub_models_config",parameters:[{name:"text_encoder_config",val:": PretrainedConfig"},{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": MusicgenMelodyDecoderConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L232",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a></p>
`}}),ht=new w({props:{title:"MusicgenMelodyModel",local:"transformers.MusicgenMelodyModel",headingTag:"h2"}}),gt=new I({props:{name:"class transformers.MusicgenMelodyModel",anchor:"transformers.MusicgenMelodyModel",parameters:[{name:"config",val:": MusicgenMelodyDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyDecoderConfig">MusicgenMelodyDecoderConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L890"}}),ft=new I({props:{name:"forward",anchor:"transformers.MusicgenMelodyModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states representing the concatenation of the text encoder output and the processed audio encoder output.
Used as a conditional signal and will thus be concatenated to the projected <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on conditional hidden states. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L908",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Oo({props:{$$slots:{default:[da]},$$scope:{ctx:j}}}),yt=new w({props:{title:"MusicgenMelodyForCausalLM",local:"transformers.MusicgenMelodyForCausalLM",headingTag:"h2"}}),Mt=new I({props:{name:"class transformers.MusicgenMelodyForCausalLM",anchor:"transformers.MusicgenMelodyForCausalLM",parameters:[{name:"config",val:": MusicgenMelodyDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyDecoderConfig">MusicgenMelodyDecoderConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L988"}}),_t=new I({props:{name:"forward",anchor:"transformers.MusicgenMelodyForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states representing the concatenation of the text encoder output and the processed audio encoder output.
Used as a conditional signal and will thus be concatenated to the projected <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on conditional hidden states. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1026",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of conditional hidden-states representing the concatenation of the projected text encoder output and the projected audio encoder output.
Used as a conditional signal.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Oo({props:{$$slots:{default:[ca]},$$scope:{ctx:j}}}),K=new fo({props:{anchor:"transformers.MusicgenMelodyForCausalLM.forward.example",$$slots:{default:[ma]},$$scope:{ctx:j}}}),bt=new w({props:{title:"MusicgenMelodyForConditionalGeneration",local:"transformers.MusicgenMelodyForConditionalGeneration",headingTag:"h2"}}),Tt=new I({props:{name:"class transformers.MusicgenMelodyForConditionalGeneration",anchor:"transformers.MusicgenMelodyForConditionalGeneration",parameters:[{name:"config",val:": MusicgenMelodyConfig = None"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"audio_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"decoder",val:": typing.Optional[transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyForCausalLM] = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.text_encoder",description:`<strong>text_encoder</strong> (<code>~modeling_utils.PreTrainedModel</code>, <em>optional</em>) &#x2014;
The text encoder model that encodes text into hidden states for conditioning.`,name:"text_encoder"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.audio_encoder",description:`<strong>audio_encoder</strong> (<code>~modeling_utils.PreTrainedModel</code>, <em>optional</em>) &#x2014;
The audio encoder model that encodes audio into hidden states for conditioning.`,name:"audio_encoder"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.decoder",description:`<strong>decoder</strong> (<code>~models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyForCausalLM</code>, <em>optional</em>) &#x2014;
The decoder model that generates audio tokens based on conditioning signals.`,name:"decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1483"}}),vt=new I({props:{name:"forward",anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_sequence_length, num_chroma)</code>) &#x2014;
Input audio features.
This should be returned by the <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a> class that you can also
retrieve from <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a>. See <code>MusicgenMelodyFeatureExtractor.__call__()</code> for details.`,name:"input_features"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>decoder_input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>decoder_input_ids</code>.</p>

					</div>`,name:"decoder_input_ids"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of conditional hidden-states representing the concatenation of the projected text encoder output and the projected audio encoder output.
Used as a conditional signal and will thus be concatenated to the projected <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1803",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of conditional hidden-states representing the concatenation of the projected text encoder output and the projected audio encoder output.
Used as a conditional signal.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new Oo({props:{$$slots:{default:[ua]},$$scope:{ctx:j}}}),te=new fo({props:{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.example",$$slots:{default:[pa]},$$scope:{ctx:j}}}),wt=new ra({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/musicgen_melody.md"}}),{c(){i=r("meta"),T=s(),M=r("p"),_=s(),u(b.$$.fragment),d=s(),v=r("div"),v.innerHTML=Ko,At=s(),u(se.$$.fragment),Ot=s(),ae=r("p"),ae.innerHTML=es,Kt=s(),re=r("p"),re.innerHTML=ts,en=s(),le=r("p"),le.textContent=ns,tn=s(),ie=r("p"),ie.textContent=os,nn=s(),de=r("p"),de.innerHTML=ss,on=s(),ce=r("p"),ce.innerHTML=as,sn=s(),u(me.$$.fragment),an=s(),ue=r("p"),ue.textContent=rs,rn=s(),pe=r("ol"),pe.innerHTML=ls,ln=s(),u(he.$$.fragment),dn=s(),ge=r("p"),ge.innerHTML=is,cn=s(),fe=r("p"),fe.textContent=ds,mn=s(),u(ye.$$.fragment),un=s(),Me=r("p"),Me.innerHTML=cs,pn=s(),_e=r("p"),_e.textContent=ms,hn=s(),u(be.$$.fragment),gn=s(),Te=r("p"),Te.textContent=us,fn=s(),u(ve.$$.fragment),yn=s(),we=r("p"),we.innerHTML=ps,Mn=s(),ke=r("p"),ke.innerHTML=hs,_n=s(),u(je.$$.fragment),bn=s(),Je=r("p"),Je.textContent=gs,Tn=s(),u(Ce.$$.fragment),vn=s(),Ze=r("p"),Ze.textContent=fs,wn=s(),u($e.$$.fragment),kn=s(),Ue=r("p"),Ue.innerHTML=ys,jn=s(),u(xe.$$.fragment),Jn=s(),Ge=r("p"),Ge.innerHTML=Ms,Cn=s(),u(We.$$.fragment),Zn=s(),u(Fe.$$.fragment),$n=s(),Ve=r("p"),Ve.innerHTML=_s,Un=s(),u(ze.$$.fragment),xn=s(),Ne=r("p"),Ne.innerHTML=bs,Gn=s(),Ie=r("p"),Ie.textContent=Ts,Wn=s(),u(Be.$$.fragment),Fn=s(),u(Re.$$.fragment),Vn=s(),Xe=r("p"),Xe.innerHTML=vs,zn=s(),u(He.$$.fragment),Nn=s(),u(Ee.$$.fragment),In=s(),qe=r("p"),qe.textContent=ws,Bn=s(),u(Ye.$$.fragment),Rn=s(),Le=r("p"),Le.innerHTML=ks,Xn=s(),u(Qe.$$.fragment),Hn=s(),Se=r("p"),Se.textContent=js,En=s(),Pe=r("ol"),Pe.innerHTML=Js,qn=s(),De=r("p"),De.innerHTML=Cs,Yn=s(),u(Ae.$$.fragment),Ln=s(),Oe=r("p"),Oe.innerHTML=Zs,Qn=s(),u(Ke.$$.fragment),Sn=s(),et=r("ul"),et.innerHTML=$s,Pn=s(),u(tt.$$.fragment),Dn=s(),nt=r("p"),nt.textContent=Us,An=s(),ot=r("ul"),ot.innerHTML=xs,On=s(),u(st.$$.fragment),Kn=s(),B=r("div"),u(at.$$.fragment),yo=s(),Jt=r("p"),Jt.innerHTML=Gs,Mo=s(),Ct=r("p"),Ct.innerHTML=Ws,eo=s(),u(rt.$$.fragment),to=s(),G=r("div"),u(lt.$$.fragment),_o=s(),Zt=r("p"),Zt.textContent=Fs,bo=s(),$t=r("p"),$t.innerHTML=Vs,To=s(),H=r("div"),u(it.$$.fragment),vo=s(),Ut=r("p"),Ut.textContent=zs,wo=s(),u(S.$$.fragment),no=s(),u(dt.$$.fragment),oo=s(),W=r("div"),u(ct.$$.fragment),ko=s(),xt=r("p"),xt.textContent=Ns,jo=s(),Gt=r("p"),Gt.innerHTML=Is,Jo=s(),Wt=r("p"),Wt.innerHTML=Bs,so=s(),u(mt.$$.fragment),ao=s(),J=r("div"),u(ut.$$.fragment),Co=s(),Ft=r("p"),Ft.innerHTML=Rs,Zo=s(),Vt=r("p"),Vt.innerHTML=Xs,$o=s(),u(P.$$.fragment),Uo=s(),D=r("div"),u(pt.$$.fragment),xo=s(),zt=r("p"),zt.innerHTML=Hs,ro=s(),u(ht.$$.fragment),lo=s(),C=r("div"),u(gt.$$.fragment),Go=s(),Nt=r("p"),Nt.textContent=Es,Wo=s(),It=r("p"),It.innerHTML=qs,Fo=s(),Bt=r("p"),Bt.innerHTML=Ys,Vo=s(),E=r("div"),u(ft.$$.fragment),zo=s(),Rt=r("p"),Rt.innerHTML=Ls,No=s(),u(A.$$.fragment),io=s(),u(yt.$$.fragment),co=s(),Z=r("div"),u(Mt.$$.fragment),Io=s(),Xt=r("p"),Xt.textContent=Qs,Bo=s(),Ht=r("p"),Ht.innerHTML=Ss,Ro=s(),Et=r("p"),Et.innerHTML=Ps,Xo=s(),z=r("div"),u(_t.$$.fragment),Ho=s(),qt=r("p"),qt.innerHTML=Ds,Eo=s(),u(O.$$.fragment),qo=s(),u(K.$$.fragment),mo=s(),u(bt.$$.fragment),uo=s(),$=r("div"),u(Tt.$$.fragment),Yo=s(),Yt=r("p"),Yt.textContent=As,Lo=s(),Lt=r("p"),Lt.innerHTML=Os,Qo=s(),Qt=r("p"),Qt.innerHTML=Ks,So=s(),N=r("div"),u(vt.$$.fragment),Po=s(),St=r("p"),St.innerHTML=ea,Do=s(),u(ee.$$.fragment),Ao=s(),u(te.$$.fragment),po=s(),u(wt.$$.fragment),ho=s(),Dt=r("p"),this.h()},l(e){const t=aa("svelte-u9bgzb",document.head);i=l(t,"META",{name:!0,content:!0}),t.forEach(n),T=a(e),M=l(e,"P",{}),x(M).forEach(n),_=a(e),p(b.$$.fragment,e),d=a(e),v=l(e,"DIV",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-b95w5j"&&(v.innerHTML=Ko),At=a(e),p(se.$$.fragment,e),Ot=a(e),ae=l(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-78c2gt"&&(ae.innerHTML=es),Kt=a(e),re=l(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-12yjb0l"&&(re.innerHTML=ts),en=a(e),le=l(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-fd8as4"&&(le.textContent=ns),tn=a(e),ie=l(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-vfdo9a"&&(ie.textContent=os),nn=a(e),de=l(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1ivrrzt"&&(de.innerHTML=ss),on=a(e),ce=l(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1hq1neg"&&(ce.innerHTML=as),sn=a(e),p(me.$$.fragment,e),an=a(e),ue=l(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1uncox0"&&(ue.textContent=rs),rn=a(e),pe=l(e,"OL",{"data-svelte-h":!0}),m(pe)!=="svelte-18htd4w"&&(pe.innerHTML=ls),ln=a(e),p(he.$$.fragment,e),dn=a(e),ge=l(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1ftnanv"&&(ge.innerHTML=is),cn=a(e),fe=l(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1csutn1"&&(fe.textContent=ds),mn=a(e),p(ye.$$.fragment,e),un=a(e),Me=l(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-10ek10q"&&(Me.innerHTML=cs),pn=a(e),_e=l(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-13qa4g8"&&(_e.textContent=ms),hn=a(e),p(be.$$.fragment,e),gn=a(e),Te=l(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-z5hgod"&&(Te.textContent=us),fn=a(e),p(ve.$$.fragment,e),yn=a(e),we=l(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1qlcazm"&&(we.innerHTML=ps),Mn=a(e),ke=l(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-3ul8a2"&&(ke.innerHTML=hs),_n=a(e),p(je.$$.fragment,e),bn=a(e),Je=l(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-j9yyu1"&&(Je.textContent=gs),Tn=a(e),p(Ce.$$.fragment,e),vn=a(e),Ze=l(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1ogs8cb"&&(Ze.textContent=fs),wn=a(e),p($e.$$.fragment,e),kn=a(e),Ue=l(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1i3bavh"&&(Ue.innerHTML=ys),jn=a(e),p(xe.$$.fragment,e),Jn=a(e),Ge=l(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1so91jo"&&(Ge.innerHTML=Ms),Cn=a(e),p(We.$$.fragment,e),Zn=a(e),p(Fe.$$.fragment,e),$n=a(e),Ve=l(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-re3xvv"&&(Ve.innerHTML=_s),Un=a(e),p(ze.$$.fragment,e),xn=a(e),Ne=l(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1hk6jop"&&(Ne.innerHTML=bs),Gn=a(e),Ie=l(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-nxh1r8"&&(Ie.textContent=Ts),Wn=a(e),p(Be.$$.fragment,e),Fn=a(e),p(Re.$$.fragment,e),Vn=a(e),Xe=l(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-mlnl2q"&&(Xe.innerHTML=vs),zn=a(e),p(He.$$.fragment,e),Nn=a(e),p(Ee.$$.fragment,e),In=a(e),qe=l(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1osihnc"&&(qe.textContent=ws),Bn=a(e),p(Ye.$$.fragment,e),Rn=a(e),Le=l(e,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-j9qxmb"&&(Le.innerHTML=ks),Xn=a(e),p(Qe.$$.fragment,e),Hn=a(e),Se=l(e,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-52mell"&&(Se.textContent=js),En=a(e),Pe=l(e,"OL",{"data-svelte-h":!0}),m(Pe)!=="svelte-1cudh7l"&&(Pe.innerHTML=Js),qn=a(e),De=l(e,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1rq1sbs"&&(De.innerHTML=Cs),Yn=a(e),p(Ae.$$.fragment,e),Ln=a(e),Oe=l(e,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-hyjder"&&(Oe.innerHTML=Zs),Qn=a(e),p(Ke.$$.fragment,e),Sn=a(e),et=l(e,"UL",{"data-svelte-h":!0}),m(et)!=="svelte-111jn6u"&&(et.innerHTML=$s),Pn=a(e),p(tt.$$.fragment,e),Dn=a(e),nt=l(e,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-axv494"&&(nt.textContent=Us),An=a(e),ot=l(e,"UL",{"data-svelte-h":!0}),m(ot)!=="svelte-43b5cf"&&(ot.innerHTML=xs),On=a(e),p(st.$$.fragment,e),Kn=a(e),B=l(e,"DIV",{class:!0});var L=x(B);p(at.$$.fragment,L),yo=a(L),Jt=l(L,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1is1y2l"&&(Jt.innerHTML=Gs),Mo=a(L),Ct=l(L,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-o55m63"&&(Ct.innerHTML=Ws),L.forEach(n),eo=a(e),p(rt.$$.fragment,e),to=a(e),G=l(e,"DIV",{class:!0});var R=x(G);p(lt.$$.fragment,R),_o=a(R),Zt=l(R,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-1eghntb"&&(Zt.textContent=Fs),bo=a(R),$t=l(R,"P",{"data-svelte-h":!0}),m($t)!=="svelte-5ej9zd"&&($t.innerHTML=Vs),To=a(R),H=l(R,"DIV",{class:!0});var Q=x(H);p(it.$$.fragment,Q),vo=a(Q),Ut=l(Q,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-99wdq5"&&(Ut.textContent=zs),wo=a(Q),p(S.$$.fragment,Q),Q.forEach(n),R.forEach(n),no=a(e),p(dt.$$.fragment,e),oo=a(e),W=l(e,"DIV",{class:!0});var X=x(W);p(ct.$$.fragment,X),ko=a(X),xt=l(X,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-avkweo"&&(xt.textContent=Ns),jo=a(X),Gt=l(X,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-3gz575"&&(Gt.innerHTML=Is),Jo=a(X),Wt=l(X,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-ffxp6h"&&(Wt.innerHTML=Bs),X.forEach(n),so=a(e),p(mt.$$.fragment,e),ao=a(e),J=l(e,"DIV",{class:!0});var F=x(J);p(ut.$$.fragment,F),Co=a(F),Ft=l(F,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-1szg2e3"&&(Ft.innerHTML=Rs),Zo=a(F),Vt=l(F,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-o55m63"&&(Vt.innerHTML=Xs),$o=a(F),p(P.$$.fragment,F),Uo=a(F),D=l(F,"DIV",{class:!0});var kt=x(D);p(pt.$$.fragment,kt),xo=a(kt),zt=l(kt,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-fqk2bf"&&(zt.innerHTML=Hs),kt.forEach(n),F.forEach(n),ro=a(e),p(ht.$$.fragment,e),lo=a(e),C=l(e,"DIV",{class:!0});var V=x(C);p(gt.$$.fragment,V),Go=a(V),Nt=l(V,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-11dv3o9"&&(Nt.textContent=Es),Wo=a(V),It=l(V,"P",{"data-svelte-h":!0}),m(It)!=="svelte-6pahdo"&&(It.innerHTML=qs),Fo=a(V),Bt=l(V,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-hswkmf"&&(Bt.innerHTML=Ys),Vo=a(V),E=l(V,"DIV",{class:!0});var Pt=x(E);p(ft.$$.fragment,Pt),zo=a(Pt),Rt=l(Pt,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-b9g5ur"&&(Rt.innerHTML=Ls),No=a(Pt),p(A.$$.fragment,Pt),Pt.forEach(n),V.forEach(n),io=a(e),p(yt.$$.fragment,e),co=a(e),Z=l(e,"DIV",{class:!0});var q=x(Z);p(Mt.$$.fragment,q),Io=a(q),Xt=l(q,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-1m1my0b"&&(Xt.textContent=Qs),Bo=a(q),Ht=l(q,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-6pahdo"&&(Ht.innerHTML=Ss),Ro=a(q),Et=l(q,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-hswkmf"&&(Et.innerHTML=Ps),Xo=a(q),z=l(q,"DIV",{class:!0});var ne=x(z);p(_t.$$.fragment,ne),Ho=a(ne),qt=l(ne,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-383y17"&&(qt.innerHTML=Ds),Eo=a(ne),p(O.$$.fragment,ne),qo=a(ne),p(K.$$.fragment,ne),ne.forEach(n),q.forEach(n),mo=a(e),p(bt.$$.fragment,e),uo=a(e),$=l(e,"DIV",{class:!0});var Y=x($);p(Tt.$$.fragment,Y),Yo=a(Y),Yt=l(Y,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-cu8u01"&&(Yt.textContent=As),Lo=a(Y),Lt=l(Y,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-6pahdo"&&(Lt.innerHTML=Os),Qo=a(Y),Qt=l(Y,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-hswkmf"&&(Qt.innerHTML=Ks),So=a(Y),N=l(Y,"DIV",{class:!0});var oe=x(N);p(vt.$$.fragment,oe),Po=a(oe),St=l(oe,"P",{"data-svelte-h":!0}),m(St)!=="svelte-1b6bgmb"&&(St.innerHTML=ea),Do=a(oe),p(ee.$$.fragment,oe),Ao=a(oe),p(te.$$.fragment,oe),oe.forEach(n),Y.forEach(n),po=a(e),p(wt.$$.fragment,e),ho=a(e),Dt=l(e,"P",{}),x(Dt).forEach(n),this.h()},h(){U(i,"name","hf:doc:metadata"),U(i,"content",ga),U(v,"class","flex flex-wrap space-x-1"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,i),o(e,T,t),o(e,M,t),o(e,_,t),h(b,e,t),o(e,d,t),o(e,v,t),o(e,At,t),h(se,e,t),o(e,Ot,t),o(e,ae,t),o(e,Kt,t),o(e,re,t),o(e,en,t),o(e,le,t),o(e,tn,t),o(e,ie,t),o(e,nn,t),o(e,de,t),o(e,on,t),o(e,ce,t),o(e,sn,t),h(me,e,t),o(e,an,t),o(e,ue,t),o(e,rn,t),o(e,pe,t),o(e,ln,t),h(he,e,t),o(e,dn,t),o(e,ge,t),o(e,cn,t),o(e,fe,t),o(e,mn,t),h(ye,e,t),o(e,un,t),o(e,Me,t),o(e,pn,t),o(e,_e,t),o(e,hn,t),h(be,e,t),o(e,gn,t),o(e,Te,t),o(e,fn,t),h(ve,e,t),o(e,yn,t),o(e,we,t),o(e,Mn,t),o(e,ke,t),o(e,_n,t),h(je,e,t),o(e,bn,t),o(e,Je,t),o(e,Tn,t),h(Ce,e,t),o(e,vn,t),o(e,Ze,t),o(e,wn,t),h($e,e,t),o(e,kn,t),o(e,Ue,t),o(e,jn,t),h(xe,e,t),o(e,Jn,t),o(e,Ge,t),o(e,Cn,t),h(We,e,t),o(e,Zn,t),h(Fe,e,t),o(e,$n,t),o(e,Ve,t),o(e,Un,t),h(ze,e,t),o(e,xn,t),o(e,Ne,t),o(e,Gn,t),o(e,Ie,t),o(e,Wn,t),h(Be,e,t),o(e,Fn,t),h(Re,e,t),o(e,Vn,t),o(e,Xe,t),o(e,zn,t),h(He,e,t),o(e,Nn,t),h(Ee,e,t),o(e,In,t),o(e,qe,t),o(e,Bn,t),h(Ye,e,t),o(e,Rn,t),o(e,Le,t),o(e,Xn,t),h(Qe,e,t),o(e,Hn,t),o(e,Se,t),o(e,En,t),o(e,Pe,t),o(e,qn,t),o(e,De,t),o(e,Yn,t),h(Ae,e,t),o(e,Ln,t),o(e,Oe,t),o(e,Qn,t),h(Ke,e,t),o(e,Sn,t),o(e,et,t),o(e,Pn,t),h(tt,e,t),o(e,Dn,t),o(e,nt,t),o(e,An,t),o(e,ot,t),o(e,On,t),h(st,e,t),o(e,Kn,t),o(e,B,t),h(at,B,null),c(B,yo),c(B,Jt),c(B,Mo),c(B,Ct),o(e,eo,t),h(rt,e,t),o(e,to,t),o(e,G,t),h(lt,G,null),c(G,_o),c(G,Zt),c(G,bo),c(G,$t),c(G,To),c(G,H),h(it,H,null),c(H,vo),c(H,Ut),c(H,wo),h(S,H,null),o(e,no,t),h(dt,e,t),o(e,oo,t),o(e,W,t),h(ct,W,null),c(W,ko),c(W,xt),c(W,jo),c(W,Gt),c(W,Jo),c(W,Wt),o(e,so,t),h(mt,e,t),o(e,ao,t),o(e,J,t),h(ut,J,null),c(J,Co),c(J,Ft),c(J,Zo),c(J,Vt),c(J,$o),h(P,J,null),c(J,Uo),c(J,D),h(pt,D,null),c(D,xo),c(D,zt),o(e,ro,t),h(ht,e,t),o(e,lo,t),o(e,C,t),h(gt,C,null),c(C,Go),c(C,Nt),c(C,Wo),c(C,It),c(C,Fo),c(C,Bt),c(C,Vo),c(C,E),h(ft,E,null),c(E,zo),c(E,Rt),c(E,No),h(A,E,null),o(e,io,t),h(yt,e,t),o(e,co,t),o(e,Z,t),h(Mt,Z,null),c(Z,Io),c(Z,Xt),c(Z,Bo),c(Z,Ht),c(Z,Ro),c(Z,Et),c(Z,Xo),c(Z,z),h(_t,z,null),c(z,Ho),c(z,qt),c(z,Eo),h(O,z,null),c(z,qo),h(K,z,null),o(e,mo,t),h(bt,e,t),o(e,uo,t),o(e,$,t),h(Tt,$,null),c($,Yo),c($,Yt),c($,Lo),c($,Lt),c($,Qo),c($,Qt),c($,So),c($,N),h(vt,N,null),c(N,Po),c(N,St),c(N,Do),h(ee,N,null),c(N,Ao),h(te,N,null),o(e,po,t),h(wt,e,t),o(e,ho,t),o(e,Dt,t),go=!0},p(e,[t]){const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),S.$set(L);const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),P.$set(R);const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),A.$set(Q);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),O.$set(X);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),K.$set(F);const kt={};t&2&&(kt.$$scope={dirty:t,ctx:e}),ee.$set(kt);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),te.$set(V)},i(e){go||(g(b.$$.fragment,e),g(se.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(We.$$.fragment,e),g(Fe.$$.fragment,e),g(ze.$$.fragment,e),g(Be.$$.fragment,e),g(Re.$$.fragment,e),g(He.$$.fragment,e),g(Ee.$$.fragment,e),g(Ye.$$.fragment,e),g(Qe.$$.fragment,e),g(Ae.$$.fragment,e),g(Ke.$$.fragment,e),g(tt.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(S.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(mt.$$.fragment,e),g(ut.$$.fragment,e),g(P.$$.fragment,e),g(pt.$$.fragment,e),g(ht.$$.fragment,e),g(gt.$$.fragment,e),g(ft.$$.fragment,e),g(A.$$.fragment,e),g(yt.$$.fragment,e),g(Mt.$$.fragment,e),g(_t.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(bt.$$.fragment,e),g(Tt.$$.fragment,e),g(vt.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(wt.$$.fragment,e),go=!0)},o(e){f(b.$$.fragment,e),f(se.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(xe.$$.fragment,e),f(We.$$.fragment,e),f(Fe.$$.fragment,e),f(ze.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(Ke.$$.fragment,e),f(tt.$$.fragment,e),f(st.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(lt.$$.fragment,e),f(it.$$.fragment,e),f(S.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(mt.$$.fragment,e),f(ut.$$.fragment,e),f(P.$$.fragment,e),f(pt.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(ft.$$.fragment,e),f(A.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(_t.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(bt.$$.fragment,e),f(Tt.$$.fragment,e),f(vt.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(wt.$$.fragment,e),go=!1},d(e){e&&(n(T),n(M),n(_),n(d),n(v),n(At),n(Ot),n(ae),n(Kt),n(re),n(en),n(le),n(tn),n(ie),n(nn),n(de),n(on),n(ce),n(sn),n(an),n(ue),n(rn),n(pe),n(ln),n(dn),n(ge),n(cn),n(fe),n(mn),n(un),n(Me),n(pn),n(_e),n(hn),n(gn),n(Te),n(fn),n(yn),n(we),n(Mn),n(ke),n(_n),n(bn),n(Je),n(Tn),n(vn),n(Ze),n(wn),n(kn),n(Ue),n(jn),n(Jn),n(Ge),n(Cn),n(Zn),n($n),n(Ve),n(Un),n(xn),n(Ne),n(Gn),n(Ie),n(Wn),n(Fn),n(Vn),n(Xe),n(zn),n(Nn),n(In),n(qe),n(Bn),n(Rn),n(Le),n(Xn),n(Hn),n(Se),n(En),n(Pe),n(qn),n(De),n(Yn),n(Ln),n(Oe),n(Qn),n(Sn),n(et),n(Pn),n(Dn),n(nt),n(An),n(ot),n(On),n(Kn),n(B),n(eo),n(to),n(G),n(no),n(oo),n(W),n(so),n(ao),n(J),n(ro),n(lo),n(C),n(io),n(co),n(Z),n(mo),n(uo),n($),n(po),n(ho),n(Dt)),n(i),y(b,e),y(se,e),y(me,e),y(he,e),y(ye,e),y(be,e),y(ve,e),y(je,e),y(Ce,e),y($e,e),y(xe,e),y(We,e),y(Fe,e),y(ze,e),y(Be,e),y(Re,e),y(He,e),y(Ee,e),y(Ye,e),y(Qe,e),y(Ae,e),y(Ke,e),y(tt,e),y(st,e),y(at),y(rt,e),y(lt),y(it),y(S),y(dt,e),y(ct),y(mt,e),y(ut),y(P),y(pt),y(ht,e),y(gt),y(ft),y(A),y(yt,e),y(Mt),y(_t),y(O),y(K),y(bt,e),y(Tt),y(vt),y(ee),y(te),y(wt,e)}}}const ga='{"title":"MusicGen Melody","local":"musicgen-melody","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Difference with MusicGen","local":"difference-with-musicgen","sections":[],"depth":2},{"title":"Generation","local":"generation","sections":[{"title":"Audio Conditional Generation","local":"audio-conditional-generation","sections":[],"depth":4},{"title":"Text-only Conditional Generation","local":"text-only-conditional-generation","sections":[],"depth":3},{"title":"Unconditional Generation","local":"unconditional-generation","sections":[],"depth":3},{"title":"Generation Configuration","local":"generation-configuration","sections":[],"depth":3}],"depth":2},{"title":"Model Structure","local":"model-structure","sections":[],"depth":2},{"title":"Checkpoint Conversion","local":"checkpoint-conversion","sections":[],"depth":2},{"title":"MusicgenMelodyDecoderConfig","local":"transformers.MusicgenMelodyDecoderConfig","sections":[],"depth":2},{"title":"MusicgenMelodyProcessor","local":"transformers.MusicgenMelodyProcessor","sections":[],"depth":2},{"title":"MusicgenMelodyFeatureExtractor","local":"transformers.MusicgenMelodyFeatureExtractor","sections":[],"depth":2},{"title":"MusicgenMelodyConfig","local":"transformers.MusicgenMelodyConfig","sections":[],"depth":2},{"title":"MusicgenMelodyModel","local":"transformers.MusicgenMelodyModel","sections":[],"depth":2},{"title":"MusicgenMelodyForCausalLM","local":"transformers.MusicgenMelodyForCausalLM","sections":[],"depth":2},{"title":"MusicgenMelodyForConditionalGeneration","local":"transformers.MusicgenMelodyForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function fa(j){return na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ja extends oa{constructor(i){super(),sa(this,i,fa,ha,ta,{})}}export{ja as component};
