import{s as yn,z as wn,o as vn,n as ie}from"../chunks/scheduler.18a86fab.js";import{S as Rn,i as xn,g as d,s,r as h,A as Dn,h as l,f as o,c as a,j as D,u as g,x as T,k as R,y as i,a as c,v as f,d as u,t as _,w as b}from"../chunks/index.98837b22.js";import{T as Wo}from"../chunks/Tip.77304350.js";import{D as $}from"../chunks/Docstring.6758ea23.js";import{C as _t}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as yt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{P as Mn}from"../chunks/PipelineTag.7749150e.js";import{H as Z}from"../chunks/Heading.7e7e0c5b.js";import{E as jn}from"../chunks/index.499f366c.js";function Cn(x){let r,w="Examples:",p,m,y;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJURGV0ckNvbmZpZyUyQyUyMFJURGV0ck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFJULURFVFIlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFJURGV0ckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBSVERldHJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RTDetrConfig, RTDetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a RT-DETR configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = RTDetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RTDetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,p=s(),h(m.$$.fragment)},l(n){r=l(n,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(n),g(m.$$.fragment,n)},m(n,v){c(n,r,v),c(n,p,v),f(m,n,v),y=!0},p:ie,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){_(m.$$.fragment,n),y=!1},d(n){n&&(o(r),o(p)),b(m,n)}}}function zn(x){let r,w="Example:",p,m,y;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJURGV0clJlc05ldENvbmZpZyUyQyUyMFJURGV0clJlc25ldEJhY2tib25lJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFJlc05ldCUyMHJlc25ldC01MCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBSVERldHJSZXNOZXRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwcmVzbmV0LTUwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBSVERldHJSZXNuZXRCYWNrYm9uZShjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RTDetrResNetConfig, RTDetrResnetBackbone

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ResNet resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = RTDetrResNetConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RTDetrResnetBackbone(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,p=s(),h(m.$$.fragment)},l(n){r=l(n,"P",{"data-svelte-h":!0}),T(r)!=="svelte-11lpom8"&&(r.textContent=w),p=a(n),g(m.$$.fragment,n)},m(n,v){c(n,r,v),c(n,p,v),f(m,n,v),y=!0},p:ie,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){_(m.$$.fragment,n),y=!1},d(n){n&&(o(r),o(p)),b(m,n)}}}function $n(x){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=w},l(p){r=l(p,"P",{"data-svelte-h":!0}),T(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(p,m){c(p,r,m)},p:ie,d(p){p&&o(r)}}}function In(x){let r,w="Examples:",p,m,y;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFJURGV0ck1vZGVsJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJQZWtpbmdVJTJGcnRkZXRyX3I1MHZkJTIyKSUwQW1vZGVsJTIwJTNEJTIwUlREZXRyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlBla2luZ1UlMkZydGRldHJfcjUwdmQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, RTDetrModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RTDetrModel.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,p=s(),h(m.$$.fragment)},l(n){r=l(n,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(n),g(m.$$.fragment,n)},m(n,v){c(n,r,v),c(n,p,v),f(m,n,v),y=!0},p:ie,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){_(m.$$.fragment,n),y=!1},d(n){n&&(o(r),o(p)),b(m,n)}}}function kn(x){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=w},l(p){r=l(p,"P",{"data-svelte-h":!0}),T(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(p,m){c(p,r,m)},p:ie,d(p){p&&o(r)}}}function Un(x){let r,w="Examples:",p,m,y;return m=new _t({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RTDetrImageProcessor, RTDetrForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = RTDetrImageProcessor.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RTDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">80</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = outputs.pred_boxes
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(boxes.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected sofa <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.97</span> at location [<span class="hljs-number">0.14</span>, <span class="hljs-number">0.38</span>, <span class="hljs-number">640.13</span>, <span class="hljs-number">476.21</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.96</span> at location [<span class="hljs-number">343.38</span>, <span class="hljs-number">24.28</span>, <span class="hljs-number">640.14</span>, <span class="hljs-number">371.5</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.958</span> at location [<span class="hljs-number">13.23</span>, <span class="hljs-number">54.18</span>, <span class="hljs-number">318.98</span>, <span class="hljs-number">472.22</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.951</span> at location [<span class="hljs-number">40.11</span>, <span class="hljs-number">73.44</span>, <span class="hljs-number">175.96</span>, <span class="hljs-number">118.48</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.924</span> at location [<span class="hljs-number">333.73</span>, <span class="hljs-number">76.58</span>, <span class="hljs-number">369.97</span>, <span class="hljs-number">186.99</span>]`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,p=s(),h(m.$$.fragment)},l(n){r=l(n,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(n),g(m.$$.fragment,n)},m(n,v){c(n,r,v),c(n,p,v),f(m,n,v),y=!0},p:ie,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){_(m.$$.fragment,n),y=!1},d(n){n&&(o(r),o(p)),b(m,n)}}}function Jn(x){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=w},l(p){r=l(p,"P",{"data-svelte-h":!0}),T(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(p,m){c(p,r,m)},p:ie,d(p){p&&o(r)}}}function Fn(x){let r,w="Examples:",p,m,y;return m=new _t({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJURGV0clJlc05ldENvbmZpZyUyQyUyMFJURGV0clJlc05ldEJhY2tib25lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb25maWclMjAlM0QlMjBSVERldHJSZXNOZXRDb25maWcoKSUwQW1vZGVsJTIwJTNEJTIwUlREZXRyUmVzTmV0QmFja2JvbmUoY29uZmlnKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzKSUwQSUwQWZlYXR1cmVfbWFwcyUyMCUzRCUyMG91dHB1dHMuZmVhdHVyZV9tYXBzJTBBbGlzdChmZWF0dXJlX21hcHMlNUItMSU1RC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RTDetrResNetConfig, RTDetrResNetBackbone
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>config = RTDetrResNetConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RTDetrResNetBackbone(config)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(pixel_values)

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_maps = outputs.feature_maps
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(feature_maps[-<span class="hljs-number">1</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){r=d("p"),r.textContent=w,p=s(),h(m.$$.fragment)},l(n){r=l(n,"P",{"data-svelte-h":!0}),T(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(n),g(m.$$.fragment,n)},m(n,v){c(n,r,v),c(n,p,v),f(m,n,v),y=!0},p:ie,i(n){y||(u(m.$$.fragment,n),y=!0)},o(n){_(m.$$.fragment,n),y=!1},d(n){n&&(o(r),o(p)),b(m,n)}}}function Nn(x){let r,w,p,m,y,n,v,Bo='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',wt,ce,vt,de,Zo='The RT-DETR model was proposed in <a href="https://arxiv.org/abs/2304.08069" rel="nofollow">DETRs Beat YOLOs on Real-time Object Detection</a> by Wenyu Lv, Yian Zhao, Shangliang Xu, Jinman Wei, Guanzhong Wang, Cheng Cui, Yuning Du, Qingqing Dang, Yi Liu.',Rt,le,Eo="RT-DETR is an object detection model that stands for “Real-Time DEtection Transformer.” This model is designed to perform object detection tasks with a focus on achieving real-time performance while maintaining high accuracy. Leveraging the transformer architecture, which has gained significant popularity in various fields of deep learning, RT-DETR processes images to identify and locate multiple objects within them.",xt,me,Lo="The abstract from the paper is the following:",Dt,pe,Vo="<em>Recently, end-to-end transformer-based detectors (DETRs) have achieved remarkable performance. However, the issue of the high computational cost of DETRs has not been effectively addressed, limiting their practical application and preventing them from fully exploiting the benefits of no post-processing, such as non-maximum suppression (NMS). In this paper, we first analyze the influence of NMS in modern real-time object detectors on inference speed, and establish an end-to-end speed benchmark. To avoid the inference delay caused by NMS, we propose a Real-Time DEtection TRansformer (RT-DETR), the first real-time end-to-end object detector to our best knowledge. Specifically, we design an efficient hybrid encoder to efficiently process multi-scale features by decoupling the intra-scale interaction and cross-scale fusion, and propose IoU-aware query selection to improve the initialization of object queries. In addition, our proposed detector supports flexibly adjustment of the inference speed by using different decoder layers without the need for retraining, which facilitates the practical application of real-time object detectors. Our RT-DETR-L achieves 53.0% AP on COCO val2017 and 114 FPS on T4 GPU, while RT-DETR-X achieves 54.8% AP and 74 FPS, outperforming all YOLO detectors of the same scale in both speed and accuracy. Furthermore, our RT-DETR-R50 achieves 53.1% AP and 108 FPS, outperforming DINO-Deformable-DETR-R50 by 2.2% AP in accuracy and by about 21 times in FPS.</em>",Mt,H,Ho,jt,he,So='RT-DETR performance relative to YOLO models. Taken from the <a href="https://arxiv.org/abs/2304.08069">original paper.</a>',Ct,ge,Go='The model version was contributed by <a href="https://huggingface.co/rafaelpadilla" rel="nofollow">rafaelpadilla</a> and <a href="https://github.com/SangbumChoi" rel="nofollow">sangbumchoi</a>. The original code can be found <a href="https://github.com/lyuwenyu/RT-DETR/" rel="nofollow">here</a>.',zt,fe,$t,ue,Oo="Initially, an image is processed using a pre-trained convolutional neural network, specifically a Resnet-D variant as referenced in the original code. This network extracts features from the final three layers of the architecture. Following this, a hybrid encoder is employed to convert the multi-scale features into a sequential array of image features. Then, a decoder, equipped with auxiliary prediction heads is used to refine the object queries. This process facilitates the direct generation of bounding boxes, eliminating the need for any additional post-processing to acquire the logits and coordinates for the bounding boxes.",It,_e,kt,be,Ut,Te,Ao="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with RT-DETR.",Jt,ye,Ft,we,Qo='<li>Scripts for finetuning <a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrForObjectDetection">RTDetrForObjectDetection</a> with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/object-detection" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a>.</li> <li>Notebooks regarding inference and fine-tuning RT-DETR on a custom dataset can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/RT-DETR" rel="nofollow">here</a>. 🌎</li>',Nt,ve,qt,M,Re,eo,Oe,Yo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrModel">RTDetrModel</a>. It is used to instantiate a
RT-DETR model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the RT-DETR
<a href="https://huggingface.co/PekingU/rtdetr_r50vd" rel="nofollow">PekingU/rtdetr_r50vd</a> architecture.`,to,Ae,Xo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,oo,S,no,G,xe,so,Qe,Ko=`Instantiate a <a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrConfig">RTDetrConfig</a> (or a derived class) from a pre-trained backbone model configuration and DETR model
configuration.`,Pt,De,Wt,I,Me,ao,Ye,en=`This is the configuration class to store the configuration of a <code>RTDetrResnetBackbone</code>. It is used to instantiate an
ResNet model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the ResNet
<a href="https://huggingface.co/microsoft/resnet-50" rel="nofollow">microsoft/resnet-50</a> architecture.`,ro,Xe,tn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,io,O,Bt,je,Zt,k,Ce,co,Ke,on="Constructs a RT-DETR image processor.",lo,A,ze,mo,et,nn="Preprocess an image or a batch of images so that it can be used by the model.",po,Q,$e,ho,tt,sn=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Et,Ie,Lt,U,ke,go,ot,an="Constructs a fast Rt Detr image processor.",fo,nt,Ue,uo,Y,Je,_o,st,rn=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Vt,Fe,Ht,j,Ne,bo,at,cn="RT-DETR Model (consisting of a backbone and encoder-decoder) outputting raw hidden states without any head on top.",To,rt,dn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,yo,it,ln=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,wo,F,qe,vo,ct,mn='The <a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrModel">RTDetrModel</a> forward method, overrides the <code>__call__</code> special method.',Ro,X,xo,K,St,Pe,Gt,C,We,Do,dt,pn=`RT-DETR Model (consisting of a backbone and encoder-decoder) outputting bounding boxes and logits to be further
decoded into scores and classes.`,Mo,lt,hn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jo,mt,gn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Co,N,Be,zo,pt,fn='The <a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrForObjectDetection">RTDetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',$o,ee,Io,te,Ot,Ze,At,z,Ee,ko,ht,un="ResNet backbone, to be used with frameworks like RTDETR.",Uo,gt,_n=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Jo,ft,bn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Fo,q,Le,No,ut,Tn='The <a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrResNetBackbone">RTDetrResNetBackbone</a> forward method, overrides the <code>__call__</code> special method.',qo,oe,Po,ne,Qt,Ve,Yt,bt,Xt;return y=new Z({props:{title:"RT-DETR",local:"rt-detr",headingTag:"h1"}}),ce=new Z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),fe=new Z({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),_e=new _t({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBSVERldHJGb3JPYmplY3REZXRlY3Rpb24lMkMlMjBSVERldHJJbWFnZVByb2Nlc3NvciUwQSUwQXVybCUyMCUzRCUyMCdodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJyUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMFJURGV0ckltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJQZWtpbmdVJTJGcnRkZXRyX3I1MHZkJTIyKSUwQW1vZGVsJTIwJTNEJTIwUlREZXRyRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJQZWtpbmdVJTJGcnRkZXRyX3I1MHZkJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFyZXN1bHRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19vYmplY3RfZGV0ZWN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0b3JjaC50ZW5zb3IoJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCklMkMlMjB0aHJlc2hvbGQlM0QwLjMpJTBBJTBBZm9yJTIwcmVzdWx0JTIwaW4lMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwc2NvcmUlMkMlMjBsYWJlbF9pZCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdCU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdCU1QiUyMmxhYmVscyUyMiU1RCUyQyUyMHJlc3VsdCU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlJTJDJTIwbGFiZWwlMjAlM0QlMjBzY29yZS5pdGVtKCklMkMlMjBsYWJlbF9pZC5pdGVtKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3glMjAlM0QlMjAlNUJyb3VuZChpJTJDJTIwMiklMjBmb3IlMjBpJTIwaW4lMjBib3gudG9saXN0KCklNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJTdCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwlNUQlN0QlM0ElMjAlN0JzY29yZSUzQS4yZiU3RCUyMCU3QmJveCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RTDetrForObjectDetection, RTDetrImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = RTDetrImageProcessor.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RTDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, target_sizes=torch.tensor([(image.height, image.width)]), threshold=<span class="hljs-number">0.3</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> results:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, label_id, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;labels&quot;</span>], result[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>        score, label = score.item(), label_id.item()
<span class="hljs-meta">... </span>        box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{model.config.id2label[label]}</span>: <span class="hljs-subst">{score:<span class="hljs-number">.2</span>f}</span> <span class="hljs-subst">{box}</span>&quot;</span>)
sofa: <span class="hljs-number">0.97</span> [<span class="hljs-number">0.14</span>, <span class="hljs-number">0.38</span>, <span class="hljs-number">640.13</span>, <span class="hljs-number">476.21</span>]
cat: <span class="hljs-number">0.96</span> [<span class="hljs-number">343.38</span>, <span class="hljs-number">24.28</span>, <span class="hljs-number">640.14</span>, <span class="hljs-number">371.5</span>]
cat: <span class="hljs-number">0.96</span> [<span class="hljs-number">13.23</span>, <span class="hljs-number">54.18</span>, <span class="hljs-number">318.98</span>, <span class="hljs-number">472.22</span>]
remote: <span class="hljs-number">0.95</span> [<span class="hljs-number">40.11</span>, <span class="hljs-number">73.44</span>, <span class="hljs-number">175.96</span>, <span class="hljs-number">118.48</span>]
remote: <span class="hljs-number">0.92</span> [<span class="hljs-number">333.73</span>, <span class="hljs-number">76.58</span>, <span class="hljs-number">369.97</span>, <span class="hljs-number">186.99</span>]`,wrap:!1}}),be=new Z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ye=new Mn({props:{pipeline:"object-detection"}}),ve=new Z({props:{title:"RTDetrConfig",local:"transformers.RTDetrConfig",headingTag:"h2"}}),Re=new $({props:{name:"class transformers.RTDetrConfig",anchor:"transformers.RTDetrConfig",parameters:[{name:"initializer_range",val:" = 0.01"},{name:"initializer_bias_prior_prob",val:" = None"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"batch_norm_eps",val:" = 1e-05"},{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"freeze_backbone_batch_norms",val:" = True"},{name:"backbone_kwargs",val:" = None"},{name:"encoder_hidden_dim",val:" = 256"},{name:"encoder_in_channels",val:" = [512, 1024, 2048]"},{name:"feat_strides",val:" = [8, 16, 32]"},{name:"encoder_layers",val:" = 1"},{name:"encoder_ffn_dim",val:" = 1024"},{name:"encoder_attention_heads",val:" = 8"},{name:"dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"encode_proj_layers",val:" = [2]"},{name:"positional_encoding_temperature",val:" = 10000"},{name:"encoder_activation_function",val:" = 'gelu'"},{name:"activation_function",val:" = 'silu'"},{name:"eval_size",val:" = None"},{name:"normalize_before",val:" = False"},{name:"hidden_expansion",val:" = 1.0"},{name:"d_model",val:" = 256"},{name:"num_queries",val:" = 300"},{name:"decoder_in_channels",val:" = [256, 256, 256]"},{name:"decoder_ffn_dim",val:" = 1024"},{name:"num_feature_levels",val:" = 3"},{name:"decoder_n_points",val:" = 4"},{name:"decoder_layers",val:" = 6"},{name:"decoder_attention_heads",val:" = 8"},{name:"decoder_activation_function",val:" = 'relu'"},{name:"attention_dropout",val:" = 0.0"},{name:"num_denoising",val:" = 100"},{name:"label_noise_ratio",val:" = 0.5"},{name:"box_noise_scale",val:" = 1.0"},{name:"learn_initial_query",val:" = False"},{name:"anchor_image_size",val:" = None"},{name:"disable_custom_kernels",val:" = True"},{name:"with_box_refine",val:" = True"},{name:"is_encoder_decoder",val:" = True"},{name:"matcher_alpha",val:" = 0.25"},{name:"matcher_gamma",val:" = 2.0"},{name:"matcher_class_cost",val:" = 2.0"},{name:"matcher_bbox_cost",val:" = 5.0"},{name:"matcher_giou_cost",val:" = 2.0"},{name:"use_focal_loss",val:" = True"},{name:"auxiliary_loss",val:" = True"},{name:"focal_loss_alpha",val:" = 0.75"},{name:"focal_loss_gamma",val:" = 2.0"},{name:"weight_loss_vfl",val:" = 1.0"},{name:"weight_loss_bbox",val:" = 5.0"},{name:"weight_loss_giou",val:" = 2.0"},{name:"eos_coefficient",val:" = 0.0001"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RTDetrConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.RTDetrConfig.initializer_bias_prior_prob",description:`<strong>initializer_bias_prior_prob</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The prior probability used by the bias initializer to initialize biases for <code>enc_score_head</code> and <code>class_embed</code>.
If <code>None</code>, <code>prior_prob</code> computed as <code>prior_prob = 1 / (num_labels + 1)</code> while initializing model weights.`,name:"initializer_bias_prior_prob"},{anchor:"transformers.RTDetrConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.RTDetrConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the batch normalization layers.`,name:"batch_norm_eps"},{anchor:"transformers.RTDetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>RTDetrResNetConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.RTDetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.RTDetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.RTDetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.RTDetrConfig.freeze_backbone_batch_norms",description:`<strong>freeze_backbone_batch_norms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to freeze the batch normalization layers in the backbone.`,name:"freeze_backbone_batch_norms"},{anchor:"transformers.RTDetrConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.RTDetrConfig.encoder_hidden_dim",description:`<strong>encoder_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers in hybrid encoder.`,name:"encoder_hidden_dim"},{anchor:"transformers.RTDetrConfig.encoder_in_channels",description:`<strong>encoder_in_channels</strong> (<code>list</code>, <em>optional</em>, defaults to <code>[512, 1024, 2048]</code>) &#x2014;
Multi level features input for encoder.`,name:"encoder_in_channels"},{anchor:"transformers.RTDetrConfig.feat_strides",description:`<strong>feat_strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 16, 32]</code>) &#x2014;
Strides used in each feature map.`,name:"feat_strides"},{anchor:"transformers.RTDetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Total of layers to be used by the encoder.`,name:"encoder_layers"},{anchor:"transformers.RTDetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.RTDetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.RTDetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The ratio for all dropout layers.`,name:"dropout"},{anchor:"transformers.RTDetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.RTDetrConfig.encode_proj_layers",description:`<strong>encode_proj_layers</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
Indexes of the projected layers to be used in the encoder.`,name:"encode_proj_layers"},{anchor:"transformers.RTDetrConfig.positional_encoding_temperature",description:`<strong>positional_encoding_temperature</strong> (<code>int</code>, <em>optional</em>, defaults to 10000) &#x2014;
The temperature parameter used to create the positional encodings.`,name:"positional_encoding_temperature"},{anchor:"transformers.RTDetrConfig.encoder_activation_function",description:`<strong>encoder_activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"encoder_activation_function"},{anchor:"transformers.RTDetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the general layer. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.RTDetrConfig.eval_size",description:`<strong>eval_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>) &#x2014;
Height and width used to computes the effective height and width of the position embeddings after taking
into account the stride.`,name:"eval_size"},{anchor:"transformers.RTDetrConfig.normalize_before",description:`<strong>normalize_before</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Determine whether to apply layer normalization in the transformer encoder layer before self-attention and
feed-forward modules.`,name:"normalize_before"},{anchor:"transformers.RTDetrConfig.hidden_expansion",description:`<strong>hidden_expansion</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Expansion ratio to enlarge the dimension size of RepVGGBlock and CSPRepLayer.`,name:"hidden_expansion"},{anchor:"transformers.RTDetrConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers exclude hybrid encoder.`,name:"d_model"},{anchor:"transformers.RTDetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
Number of object queries.`,name:"num_queries"},{anchor:"transformers.RTDetrConfig.decoder_in_channels",description:`<strong>decoder_in_channels</strong> (<code>list</code>, <em>optional</em>, defaults to <code>[256, 256, 256]</code>) &#x2014;
Multi level features dimension for decoder`,name:"decoder_in_channels"},{anchor:"transformers.RTDetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.RTDetrConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input feature levels.`,name:"num_feature_levels"},{anchor:"transformers.RTDetrConfig.decoder_n_points",description:`<strong>decoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the decoder.`,name:"decoder_n_points"},{anchor:"transformers.RTDetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.RTDetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.RTDetrConfig.decoder_activation_function",description:`<strong>decoder_activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"decoder_activation_function"},{anchor:"transformers.RTDetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.RTDetrConfig.num_denoising",description:`<strong>num_denoising</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The total number of denoising tasks or queries to be used for contrastive denoising.`,name:"num_denoising"},{anchor:"transformers.RTDetrConfig.label_noise_ratio",description:`<strong>label_noise_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The fraction of denoising labels to which random noise should be added.`,name:"label_noise_ratio"},{anchor:"transformers.RTDetrConfig.box_noise_scale",description:`<strong>box_noise_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Scale or magnitude of noise to be added to the bounding boxes.`,name:"box_noise_scale"},{anchor:"transformers.RTDetrConfig.learn_initial_query",description:`<strong>learn_initial_query</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Indicates whether the initial query embeddings for the decoder should be learned during training`,name:"learn_initial_query"},{anchor:"transformers.RTDetrConfig.anchor_image_size",description:`<strong>anchor_image_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>) &#x2014;
Height and width of the input image used during evaluation to generate the bounding box anchors. If None, automatic generate anchor is applied.`,name:"anchor_image_size"},{anchor:"transformers.RTDetrConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable custom kernels.`,name:"disable_custom_kernels"},{anchor:"transformers.RTDetrConfig.with_box_refine",description:`<strong>with_box_refine</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply iterative bounding box refinement, where each decoder layer refines the bounding boxes
based on the predictions from the previous layer.`,name:"with_box_refine"},{anchor:"transformers.RTDetrConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the architecture has an encoder decoder structure.`,name:"is_encoder_decoder"},{anchor:"transformers.RTDetrConfig.matcher_alpha",description:`<strong>matcher_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Parameter alpha used by the Hungarian Matcher.`,name:"matcher_alpha"},{anchor:"transformers.RTDetrConfig.matcher_gamma",description:`<strong>matcher_gamma</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Parameter gamma used by the Hungarian Matcher.`,name:"matcher_gamma"},{anchor:"transformers.RTDetrConfig.matcher_class_cost",description:`<strong>matcher_class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The relative weight of the class loss used by the Hungarian Matcher.`,name:"matcher_class_cost"},{anchor:"transformers.RTDetrConfig.matcher_bbox_cost",description:`<strong>matcher_bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The relative weight of the bounding box loss used by the Hungarian Matcher.`,name:"matcher_bbox_cost"},{anchor:"transformers.RTDetrConfig.matcher_giou_cost",description:`<strong>matcher_giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The relative weight of the giou loss of used by the Hungarian Matcher.`,name:"matcher_giou_cost"},{anchor:"transformers.RTDetrConfig.use_focal_loss",description:`<strong>use_focal_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Parameter informing if focal focal should be used.`,name:"use_focal_loss"},{anchor:"transformers.RTDetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.RTDetrConfig.focal_loss_alpha",description:`<strong>focal_loss_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Parameter alpha used to compute the focal loss.`,name:"focal_loss_alpha"},{anchor:"transformers.RTDetrConfig.focal_loss_gamma",description:`<strong>focal_loss_gamma</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Parameter gamma used to compute the focal loss.`,name:"focal_loss_gamma"},{anchor:"transformers.RTDetrConfig.weight_loss_vfl",description:`<strong>weight_loss_vfl</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Relative weight of the varifocal loss in the object detection loss.`,name:"weight_loss_vfl"},{anchor:"transformers.RTDetrConfig.weight_loss_bbox",description:`<strong>weight_loss_bbox</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"weight_loss_bbox"},{anchor:"transformers.RTDetrConfig.weight_loss_giou",description:`<strong>weight_loss_giou</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"weight_loss_giou"},{anchor:"transformers.RTDetrConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0001) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/configuration_rt_detr.py#L27"}}),S=new yt({props:{anchor:"transformers.RTDetrConfig.example",$$slots:{default:[Cn]},$$scope:{ctx:x}}}),xe=new $({props:{name:"from_backbone_configs",anchor:"transformers.RTDetrConfig.from_backbone_configs",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RTDetrConfig.from_backbone_configs.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/configuration_rt_detr.py#L346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrConfig"
>RTDetrConfig</a></p>
`}}),De=new Z({props:{title:"RTDetrResNetConfig",local:"transformers.RTDetrResNetConfig",headingTag:"h2"}}),Me=new $({props:{name:"class transformers.RTDetrResNetConfig",anchor:"transformers.RTDetrResNetConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"embedding_size",val:" = 64"},{name:"hidden_sizes",val:" = [256, 512, 1024, 2048]"},{name:"depths",val:" = [3, 4, 6, 3]"},{name:"layer_type",val:" = 'bottleneck'"},{name:"hidden_act",val:" = 'relu'"},{name:"downsample_in_first_stage",val:" = False"},{name:"downsample_in_bottleneck",val:" = False"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RTDetrResNetConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.RTDetrResNetConfig.embedding_size",description:`<strong>embedding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality (hidden size) for the embedding layer.`,name:"embedding_size"},{anchor:"transformers.RTDetrResNetConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 512, 1024, 2048]</code>) &#x2014;
Dimensionality (hidden size) at each stage.`,name:"hidden_sizes"},{anchor:"transformers.RTDetrResNetConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 4, 6, 3]</code>) &#x2014;
Depth (number of layers) for each stage.`,name:"depths"},{anchor:"transformers.RTDetrResNetConfig.layer_type",description:`<strong>layer_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;bottleneck&quot;</code>) &#x2014;
The layer to use, it can be either <code>&quot;basic&quot;</code> (used for smaller models, like resnet-18 or resnet-34) or
<code>&quot;bottleneck&quot;</code> (used for larger models like resnet-50 and above).`,name:"layer_type"},{anchor:"transformers.RTDetrResNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function in each block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code>
are supported.`,name:"hidden_act"},{anchor:"transformers.RTDetrResNetConfig.downsample_in_first_stage",description:`<strong>downsample_in_first_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the first stage will downsample the inputs using a <code>stride</code> of 2.`,name:"downsample_in_first_stage"},{anchor:"transformers.RTDetrResNetConfig.downsample_in_bottleneck",description:`<strong>downsample_in_bottleneck</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the first conv 1x1 in ResNetBottleNeckLayer will downsample the inputs using a <code>stride</code> of 2.`,name:"downsample_in_bottleneck"},{anchor:"transformers.RTDetrResNetConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_features"},{anchor:"transformers.RTDetrResNetConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/configuration_rt_detr_resnet.py#L25"}}),O=new yt({props:{anchor:"transformers.RTDetrResNetConfig.example",$$slots:{default:[zn]},$$scope:{ctx:x}}}),je=new Z({props:{title:"RTDetrImageProcessor",local:"transformers.RTDetrImageProcessor",headingTag:"h2"}}),Ce=new $({props:{name:"class transformers.RTDetrImageProcessor",anchor:"transformers.RTDetrImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.image_utils.AnnotationFormat] = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = False"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_annotations",val:": bool = True"},{name:"do_pad",val:": bool = False"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RTDetrImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.RTDetrImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.RTDetrImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 640, &quot;width&quot;: 640}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.RTDetrImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.RTDetrImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.RTDetrImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.RTDetrImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.RTDetrImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.RTDetrImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.RTDetrImageProcessor.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.RTDetrImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.RTDetrImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/image_processing_rt_detr.py#L383"}}),ze=new $({props:{name:"preprocess",anchor:"transformers.RTDetrImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"annotations",val:": typing.Union[dict[str, typing.Union[int, str, list[dict]]], typing.List[dict[str, typing.Union[int, str, list[dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": typing.Optional[bool] = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"do_convert_annotations",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.image_utils.AnnotationFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"}],parametersDescription:[{anchor:"transformers.RTDetrImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.RTDetrImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.RTDetrImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.RTDetrImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.RTDetrImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.RTDetrImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.RTDetrImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.RTDetrImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.RTDetrImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.RTDetrImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.RTDetrImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.RTDetrImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.RTDetrImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.RTDetrImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code>, padding will be applied to the bottom and right of
the image with zeros. If <code>pad_size</code> is provided, the image will be padded to the specified
dimensions. Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.RTDetrImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.RTDetrImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.RTDetrImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.RTDetrImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.RTDetrImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/image_processing_rt_detr.py#L782"}}),$e=new $({props:{name:"post_process_object_detection",anchor:"transformers.RTDetrImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"},{name:"use_focal_loss",val:": bool = True"}],parametersDescription:[{anchor:"transformers.RTDetrImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.RTDetrImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.RTDetrImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.RTDetrImageProcessor.post_process_object_detection.use_focal_loss",description:`<strong>use_focal_loss</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
Variable informing if the focal loss was used to predict the outputs. If <code>True</code>, a sigmoid is applied
to compute the scores of each detection, otherwise, a softmax function is used.`,name:"use_focal_loss"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/image_processing_rt_detr.py#L1029",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ie=new Z({props:{title:"RTDetrImageProcessorFast",local:"transformers.RTDetrImageProcessorFast",headingTag:"h2"}}),ke=new $({props:{name:"class transformers.RTDetrImageProcessorFast",anchor:"transformers.RTDetrImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.rt_detr.image_processing_rt_detr_fast.RTDetrFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.RTDetrImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.RTDetrImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 640, &apos;width&apos;: 640}</code>):
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.RTDetrImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.RTDetrImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.RTDetrImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.RTDetrImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.RTDetrImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.RTDetrImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.RTDetrImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.RTDetrImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.RTDetrImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.RTDetrImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.RTDetrImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.RTDetrImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.RTDetrImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.RTDetrImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.RTDetrImageProcessorFast.format",description:`<strong>format</strong> (<code>Union[str, ~image_utils.AnnotationFormat, NoneType]</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.RTDetrImageProcessorFast.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the RT_DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.RTDetrImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.RTDetrImageProcessorFast.pad_size",description:"<strong>pad_size</strong> (<code>Dict[str, int]</code>, int]<code>, *optional*) -- The size </code>{&#x201C;height&#x201D;: int, &#x201C;width&#x201D; int}<code>to pad the images to. Must be larger than any image size provided for preprocessing. If</code>pad_size` is not provided, images will be padded to the largest\nheight and width in the batch.",name:"pad_size"},{anchor:"transformers.RTDetrImageProcessorFast.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/image_processing_rt_detr_fast.py#L144"}}),Ue=new $({props:{name:"preprocess",anchor:"transformers.RTDetrImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"annotations",val:": typing.Union[dict[str, typing.Union[int, str, list[dict]]], typing.List[dict[str, typing.Union[int, str, list[dict]]]], NoneType] = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.rt_detr.image_processing_rt_detr_fast.RTDetrFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.RTDetrImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, list[&apos;PIL.Image.Image&apos;], list[numpy.ndarray], list[&apos;torch.Tensor&apos;]]</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.annotations",description:`<strong>annotations</strong> (<code>Union[dict[str, Union[int, str, list[dict]]], List[dict[str, Union[int, str, list[dict]]]], NoneType]</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>Union[str, pathlib.Path, NoneType]</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.format",description:`<strong>format</strong> (<code>Union[str, ~image_utils.AnnotationFormat, NoneType]</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the RT_DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.pad_size",description:"<strong>pad_size</strong> (<code>Dict[str, int]</code>, int]<code>, *optional*) -- The size </code>{&#x201C;height&#x201D;: int, &#x201C;width&#x201D; int}<code>to pad the images to. Must be larger than any image size provided for preprocessing. If</code>pad_size` is not provided, images will be padded to the largest\nheight and width in the batch.",name:"pad_size"},{anchor:"transformers.RTDetrImageProcessorFast.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/image_processing_rt_detr_fast.py#L380",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),Je=new $({props:{name:"post_process_object_detection",anchor:"transformers.RTDetrImageProcessorFast.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"},{name:"use_focal_loss",val:": bool = True"}],parametersDescription:[{anchor:"transformers.RTDetrImageProcessorFast.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.RTDetrImageProcessorFast.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.RTDetrImageProcessorFast.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.RTDetrImageProcessorFast.post_process_object_detection.use_focal_loss",description:`<strong>use_focal_loss</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
Variable informing if the focal loss was used to predict the outputs. If <code>True</code>, a sigmoid is applied
to compute the scores of each detection, otherwise, a softmax function is used.`,name:"use_focal_loss"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/image_processing_rt_detr_fast.py#L514",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Fe=new Z({props:{title:"RTDetrModel",local:"transformers.RTDetrModel",headingTag:"h2"}}),Ne=new $({props:{name:"class transformers.RTDetrModel",anchor:"transformers.RTDetrModel",parameters:[{name:"config",val:": RTDetrConfig"}],parametersDescription:[{anchor:"transformers.RTDetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrConfig">RTDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/modeling_rt_detr.py#L1505"}}),qe=new $({props:{name:"forward",anchor:"transformers.RTDetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RTDetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.RTDetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.RTDetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.RTDetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.RTDetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.RTDetrModel.forward.labels",description:`<strong>labels</strong> (<code>List[dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"},{anchor:"transformers.RTDetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.RTDetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RTDetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/modeling_rt_detr.py#L1627",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.rt_detr.modeling_rt_detr.RTDetrModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrConfig"
>RTDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, sequence_length, config.num_labels)</code>) — Stacked intermediate logits (logits of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_queries, num_queries)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the weighted
average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>enc_topk_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Predicted bounding boxes scores where the top <code>config.two_stage_num_proposals</code> scoring bounding boxes are
picked as region proposals in the encoder stage. Output of bounding box binary classification (i.e.
foreground and background).</li>
<li><strong>enc_topk_bboxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>) — Logits of predicted bounding boxes coordinates in the encoder stage.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.two_stage_num_proposals</code> scoring bounding boxes are
picked as region proposals in the first stage. Output of bounding box binary classification (i.e.
foreground and background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
<li><strong>denoising_meta_values</strong> (<code>dict</code>) — Extra dictionary for the denoising related values</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.rt_detr.modeling_rt_detr.RTDetrModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Wo({props:{$$slots:{default:[$n]},$$scope:{ctx:x}}}),K=new yt({props:{anchor:"transformers.RTDetrModel.forward.example",$$slots:{default:[In]},$$scope:{ctx:x}}}),Pe=new Z({props:{title:"RTDetrForObjectDetection",local:"transformers.RTDetrForObjectDetection",headingTag:"h2"}}),We=new $({props:{name:"class transformers.RTDetrForObjectDetection",anchor:"transformers.RTDetrForObjectDetection",parameters:[{name:"config",val:": RTDetrConfig"}],parametersDescription:[{anchor:"transformers.RTDetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrConfig">RTDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/modeling_rt_detr.py#L1850"}}),Be=new $({props:{name:"forward",anchor:"transformers.RTDetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**loss_kwargs",val:""}],parametersDescription:[{anchor:"transformers.RTDetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.RTDetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.RTDetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.RTDetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.RTDetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.RTDetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"},{anchor:"transformers.RTDetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.RTDetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RTDetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/modeling_rt_detr.py#L1895",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.rt_detr.modeling_rt_detr.RTDetrObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrConfig"
>RTDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized (absolute) bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, config.num_labels)</code>) — Stacked intermediate logits (logits of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>intermediate_predicted_corners</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate predicted corners (predicted corners of each layer of the decoder).</li>
<li><strong>initial_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked initial reference points (initial reference points of each layer of the decoder).</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_queries, num_queries)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the weighted
average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_queries, num_heads, 4, 4)</code>.
Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>enc_topk_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the encoder.</li>
<li><strong>enc_topk_bboxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the encoder.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.two_stage_num_proposals</code> scoring bounding boxes are
picked as region proposals in the first stage. Output of bounding box binary classification (i.e.
foreground and background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.with_box_refine=True</code> and <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
<li><strong>denoising_meta_values</strong> (<code>dict</code>) — Extra dictionary for the denoising related values</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.rt_detr.modeling_rt_detr.RTDetrObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new Wo({props:{$$slots:{default:[kn]},$$scope:{ctx:x}}}),te=new yt({props:{anchor:"transformers.RTDetrForObjectDetection.forward.example",$$slots:{default:[Un]},$$scope:{ctx:x}}}),Ze=new Z({props:{title:"RTDetrResNetBackbone",local:"transformers.RTDetrResNetBackbone",headingTag:"h2"}}),Ee=new $({props:{name:"class transformers.RTDetrResNetBackbone",anchor:"transformers.RTDetrResNetBackbone",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RTDetrResNetBackbone.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrResNetBackbone">RTDetrResNetBackbone</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/modeling_rt_detr_resnet.py#L320"}}),Le=new $({props:{name:"forward",anchor:"transformers.RTDetrResNetBackbone.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RTDetrResNetBackbone.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.RTDetrResNetBackbone.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RTDetrResNetBackbone.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/rt_detr/modeling_rt_detr_resnet.py#L337",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.BackboneOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/rt_detr#transformers.RTDetrResNetConfig"
>RTDetrResNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>feature_maps</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Feature maps of the stages.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code> or <code>(batch_size, num_channels, height, width)</code>,
depending on the backbone.</p>
<p>Hidden-states of the model at the output of each stage plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Only applicable if the backbone uses attention.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.BackboneOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Wo({props:{$$slots:{default:[Jn]},$$scope:{ctx:x}}}),ne=new yt({props:{anchor:"transformers.RTDetrResNetBackbone.forward.example",$$slots:{default:[Fn]},$$scope:{ctx:x}}}),Ve=new jn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/rt_detr.md"}}),{c(){r=d("meta"),w=s(),p=d("p"),m=s(),h(y.$$.fragment),n=s(),v=d("div"),v.innerHTML=Bo,wt=s(),h(ce.$$.fragment),vt=s(),de=d("p"),de.innerHTML=Zo,Rt=s(),le=d("p"),le.textContent=Eo,xt=s(),me=d("p"),me.textContent=Lo,Dt=s(),pe=d("p"),pe.innerHTML=Vo,Mt=s(),H=d("img"),jt=s(),he=d("small"),he.innerHTML=So,Ct=s(),ge=d("p"),ge.innerHTML=Go,zt=s(),h(fe.$$.fragment),$t=s(),ue=d("p"),ue.textContent=Oo,It=s(),h(_e.$$.fragment),kt=s(),h(be.$$.fragment),Ut=s(),Te=d("p"),Te.textContent=Ao,Jt=s(),h(ye.$$.fragment),Ft=s(),we=d("ul"),we.innerHTML=Qo,Nt=s(),h(ve.$$.fragment),qt=s(),M=d("div"),h(Re.$$.fragment),eo=s(),Oe=d("p"),Oe.innerHTML=Yo,to=s(),Ae=d("p"),Ae.innerHTML=Xo,oo=s(),h(S.$$.fragment),no=s(),G=d("div"),h(xe.$$.fragment),so=s(),Qe=d("p"),Qe.innerHTML=Ko,Pt=s(),h(De.$$.fragment),Wt=s(),I=d("div"),h(Me.$$.fragment),ao=s(),Ye=d("p"),Ye.innerHTML=en,ro=s(),Xe=d("p"),Xe.innerHTML=tn,io=s(),h(O.$$.fragment),Bt=s(),h(je.$$.fragment),Zt=s(),k=d("div"),h(Ce.$$.fragment),co=s(),Ke=d("p"),Ke.textContent=on,lo=s(),A=d("div"),h(ze.$$.fragment),mo=s(),et=d("p"),et.textContent=nn,po=s(),Q=d("div"),h($e.$$.fragment),ho=s(),tt=d("p"),tt.innerHTML=sn,Et=s(),h(Ie.$$.fragment),Lt=s(),U=d("div"),h(ke.$$.fragment),go=s(),ot=d("p"),ot.textContent=an,fo=s(),nt=d("div"),h(Ue.$$.fragment),uo=s(),Y=d("div"),h(Je.$$.fragment),_o=s(),st=d("p"),st.innerHTML=rn,Vt=s(),h(Fe.$$.fragment),Ht=s(),j=d("div"),h(Ne.$$.fragment),bo=s(),at=d("p"),at.textContent=cn,To=s(),rt=d("p"),rt.innerHTML=dn,yo=s(),it=d("p"),it.innerHTML=ln,wo=s(),F=d("div"),h(qe.$$.fragment),vo=s(),ct=d("p"),ct.innerHTML=mn,Ro=s(),h(X.$$.fragment),xo=s(),h(K.$$.fragment),St=s(),h(Pe.$$.fragment),Gt=s(),C=d("div"),h(We.$$.fragment),Do=s(),dt=d("p"),dt.textContent=pn,Mo=s(),lt=d("p"),lt.innerHTML=hn,jo=s(),mt=d("p"),mt.innerHTML=gn,Co=s(),N=d("div"),h(Be.$$.fragment),zo=s(),pt=d("p"),pt.innerHTML=fn,$o=s(),h(ee.$$.fragment),Io=s(),h(te.$$.fragment),Ot=s(),h(Ze.$$.fragment),At=s(),z=d("div"),h(Ee.$$.fragment),ko=s(),ht=d("p"),ht.textContent=un,Uo=s(),gt=d("p"),gt.innerHTML=_n,Jo=s(),ft=d("p"),ft.innerHTML=bn,Fo=s(),q=d("div"),h(Le.$$.fragment),No=s(),ut=d("p"),ut.innerHTML=Tn,qo=s(),h(oe.$$.fragment),Po=s(),h(ne.$$.fragment),Qt=s(),h(Ve.$$.fragment),Yt=s(),bt=d("p"),this.h()},l(e){const t=Dn("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(o),w=a(e),p=l(e,"P",{}),D(p).forEach(o),m=a(e),g(y.$$.fragment,e),n=a(e),v=l(e,"DIV",{class:!0,"data-svelte-h":!0}),T(v)!=="svelte-13t8s2t"&&(v.innerHTML=Bo),wt=a(e),g(ce.$$.fragment,e),vt=a(e),de=l(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-1yfzr01"&&(de.innerHTML=Zo),Rt=a(e),le=l(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-67mmxr"&&(le.textContent=Eo),xt=a(e),me=l(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-vfdo9a"&&(me.textContent=Lo),Dt=a(e),pe=l(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-chb4tq"&&(pe.innerHTML=Vo),Mt=a(e),H=l(e,"IMG",{src:!0,alt:!0,width:!0}),jt=a(e),he=l(e,"SMALL",{"data-svelte-h":!0}),T(he)!=="svelte-65rcyn"&&(he.innerHTML=So),Ct=a(e),ge=l(e,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-11gjoxn"&&(ge.innerHTML=Go),zt=a(e),g(fe.$$.fragment,e),$t=a(e),ue=l(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1sjqpnj"&&(ue.textContent=Oo),It=a(e),g(_e.$$.fragment,e),kt=a(e),g(be.$$.fragment,e),Ut=a(e),Te=l(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-1csorfr"&&(Te.textContent=Ao),Jt=a(e),g(ye.$$.fragment,e),Ft=a(e),we=l(e,"UL",{"data-svelte-h":!0}),T(we)!=="svelte-1ehyuv1"&&(we.innerHTML=Qo),Nt=a(e),g(ve.$$.fragment,e),qt=a(e),M=l(e,"DIV",{class:!0});var J=D(M);g(Re.$$.fragment,J),eo=a(J),Oe=l(J,"P",{"data-svelte-h":!0}),T(Oe)!=="svelte-hidy8l"&&(Oe.innerHTML=Yo),to=a(J),Ae=l(J,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-o55m63"&&(Ae.innerHTML=Xo),oo=a(J),g(S.$$.fragment,J),no=a(J),G=l(J,"DIV",{class:!0});var He=D(G);g(xe.$$.fragment,He),so=a(He),Qe=l(He,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-1sokc5t"&&(Qe.innerHTML=Ko),He.forEach(o),J.forEach(o),Pt=a(e),g(De.$$.fragment,e),Wt=a(e),I=l(e,"DIV",{class:!0});var P=D(I);g(Me.$$.fragment,P),ao=a(P),Ye=l(P,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-1hca96c"&&(Ye.innerHTML=en),ro=a(P),Xe=l(P,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-o55m63"&&(Xe.innerHTML=tn),io=a(P),g(O.$$.fragment,P),P.forEach(o),Bt=a(e),g(je.$$.fragment,e),Zt=a(e),k=l(e,"DIV",{class:!0});var W=D(k);g(Ce.$$.fragment,W),co=a(W),Ke=l(W,"P",{"data-svelte-h":!0}),T(Ke)!=="svelte-16mm49e"&&(Ke.textContent=on),lo=a(W),A=l(W,"DIV",{class:!0});var Se=D(A);g(ze.$$.fragment,Se),mo=a(Se),et=l(Se,"P",{"data-svelte-h":!0}),T(et)!=="svelte-jgz2ra"&&(et.textContent=nn),Se.forEach(o),po=a(W),Q=l(W,"DIV",{class:!0});var Ge=D(Q);g($e.$$.fragment,Ge),ho=a(Ge),tt=l(Ge,"P",{"data-svelte-h":!0}),T(tt)!=="svelte-1w2swp4"&&(tt.innerHTML=sn),Ge.forEach(o),W.forEach(o),Et=a(e),g(Ie.$$.fragment,e),Lt=a(e),U=l(e,"DIV",{class:!0});var B=D(U);g(ke.$$.fragment,B),go=a(B),ot=l(B,"P",{"data-svelte-h":!0}),T(ot)!=="svelte-ckrhd"&&(ot.textContent=an),fo=a(B),nt=l(B,"DIV",{class:!0});var Tt=D(nt);g(Ue.$$.fragment,Tt),Tt.forEach(o),uo=a(B),Y=l(B,"DIV",{class:!0});var Kt=D(Y);g(Je.$$.fragment,Kt),_o=a(Kt),st=l(Kt,"P",{"data-svelte-h":!0}),T(st)!=="svelte-1w2swp4"&&(st.innerHTML=rn),Kt.forEach(o),B.forEach(o),Vt=a(e),g(Fe.$$.fragment,e),Ht=a(e),j=l(e,"DIV",{class:!0});var E=D(j);g(Ne.$$.fragment,E),bo=a(E),at=l(E,"P",{"data-svelte-h":!0}),T(at)!=="svelte-121t6ur"&&(at.textContent=cn),To=a(E),rt=l(E,"P",{"data-svelte-h":!0}),T(rt)!=="svelte-6pahdo"&&(rt.innerHTML=dn),yo=a(E),it=l(E,"P",{"data-svelte-h":!0}),T(it)!=="svelte-hswkmf"&&(it.innerHTML=ln),wo=a(E),F=l(E,"DIV",{class:!0});var se=D(F);g(qe.$$.fragment,se),vo=a(se),ct=l(se,"P",{"data-svelte-h":!0}),T(ct)!=="svelte-19uske1"&&(ct.innerHTML=mn),Ro=a(se),g(X.$$.fragment,se),xo=a(se),g(K.$$.fragment,se),se.forEach(o),E.forEach(o),St=a(e),g(Pe.$$.fragment,e),Gt=a(e),C=l(e,"DIV",{class:!0});var L=D(C);g(We.$$.fragment,L),Do=a(L),dt=l(L,"P",{"data-svelte-h":!0}),T(dt)!=="svelte-xszdn5"&&(dt.textContent=pn),Mo=a(L),lt=l(L,"P",{"data-svelte-h":!0}),T(lt)!=="svelte-6pahdo"&&(lt.innerHTML=hn),jo=a(L),mt=l(L,"P",{"data-svelte-h":!0}),T(mt)!=="svelte-hswkmf"&&(mt.innerHTML=gn),Co=a(L),N=l(L,"DIV",{class:!0});var ae=D(N);g(Be.$$.fragment,ae),zo=a(ae),pt=l(ae,"P",{"data-svelte-h":!0}),T(pt)!=="svelte-jpiudh"&&(pt.innerHTML=fn),$o=a(ae),g(ee.$$.fragment,ae),Io=a(ae),g(te.$$.fragment,ae),ae.forEach(o),L.forEach(o),Ot=a(e),g(Ze.$$.fragment,e),At=a(e),z=l(e,"DIV",{class:!0});var V=D(z);g(Ee.$$.fragment,V),ko=a(V),ht=l(V,"P",{"data-svelte-h":!0}),T(ht)!=="svelte-1gnnp7k"&&(ht.textContent=un),Uo=a(V),gt=l(V,"P",{"data-svelte-h":!0}),T(gt)!=="svelte-6pahdo"&&(gt.innerHTML=_n),Jo=a(V),ft=l(V,"P",{"data-svelte-h":!0}),T(ft)!=="svelte-hswkmf"&&(ft.innerHTML=bn),Fo=a(V),q=l(V,"DIV",{class:!0});var re=D(q);g(Le.$$.fragment,re),No=a(re),ut=l(re,"P",{"data-svelte-h":!0}),T(ut)!=="svelte-co88g7"&&(ut.innerHTML=Tn),qo=a(re),g(oe.$$.fragment,re),Po=a(re),g(ne.$$.fragment,re),re.forEach(o),V.forEach(o),Qt=a(e),g(Ve.$$.fragment,e),Yt=a(e),bt=l(e,"P",{}),D(bt).forEach(o),this.h()},h(){R(r,"name","hf:doc:metadata"),R(r,"content",qn),R(v,"class","flex flex-wrap space-x-1"),wn(H.src,Ho="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/rt_detr_overview.png")||R(H,"src",Ho),R(H,"alt","drawing"),R(H,"width","600"),R(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,r),c(e,w,t),c(e,p,t),c(e,m,t),f(y,e,t),c(e,n,t),c(e,v,t),c(e,wt,t),f(ce,e,t),c(e,vt,t),c(e,de,t),c(e,Rt,t),c(e,le,t),c(e,xt,t),c(e,me,t),c(e,Dt,t),c(e,pe,t),c(e,Mt,t),c(e,H,t),c(e,jt,t),c(e,he,t),c(e,Ct,t),c(e,ge,t),c(e,zt,t),f(fe,e,t),c(e,$t,t),c(e,ue,t),c(e,It,t),f(_e,e,t),c(e,kt,t),f(be,e,t),c(e,Ut,t),c(e,Te,t),c(e,Jt,t),f(ye,e,t),c(e,Ft,t),c(e,we,t),c(e,Nt,t),f(ve,e,t),c(e,qt,t),c(e,M,t),f(Re,M,null),i(M,eo),i(M,Oe),i(M,to),i(M,Ae),i(M,oo),f(S,M,null),i(M,no),i(M,G),f(xe,G,null),i(G,so),i(G,Qe),c(e,Pt,t),f(De,e,t),c(e,Wt,t),c(e,I,t),f(Me,I,null),i(I,ao),i(I,Ye),i(I,ro),i(I,Xe),i(I,io),f(O,I,null),c(e,Bt,t),f(je,e,t),c(e,Zt,t),c(e,k,t),f(Ce,k,null),i(k,co),i(k,Ke),i(k,lo),i(k,A),f(ze,A,null),i(A,mo),i(A,et),i(k,po),i(k,Q),f($e,Q,null),i(Q,ho),i(Q,tt),c(e,Et,t),f(Ie,e,t),c(e,Lt,t),c(e,U,t),f(ke,U,null),i(U,go),i(U,ot),i(U,fo),i(U,nt),f(Ue,nt,null),i(U,uo),i(U,Y),f(Je,Y,null),i(Y,_o),i(Y,st),c(e,Vt,t),f(Fe,e,t),c(e,Ht,t),c(e,j,t),f(Ne,j,null),i(j,bo),i(j,at),i(j,To),i(j,rt),i(j,yo),i(j,it),i(j,wo),i(j,F),f(qe,F,null),i(F,vo),i(F,ct),i(F,Ro),f(X,F,null),i(F,xo),f(K,F,null),c(e,St,t),f(Pe,e,t),c(e,Gt,t),c(e,C,t),f(We,C,null),i(C,Do),i(C,dt),i(C,Mo),i(C,lt),i(C,jo),i(C,mt),i(C,Co),i(C,N),f(Be,N,null),i(N,zo),i(N,pt),i(N,$o),f(ee,N,null),i(N,Io),f(te,N,null),c(e,Ot,t),f(Ze,e,t),c(e,At,t),c(e,z,t),f(Ee,z,null),i(z,ko),i(z,ht),i(z,Uo),i(z,gt),i(z,Jo),i(z,ft),i(z,Fo),i(z,q),f(Le,q,null),i(q,No),i(q,ut),i(q,qo),f(oe,q,null),i(q,Po),f(ne,q,null),c(e,Qt,t),f(Ve,e,t),c(e,Yt,t),c(e,bt,t),Xt=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),S.$set(J);const He={};t&2&&(He.$$scope={dirty:t,ctx:e}),O.$set(He);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),X.$set(P);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),K.$set(W);const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),ee.$set(Se);const Ge={};t&2&&(Ge.$$scope={dirty:t,ctx:e}),te.$set(Ge);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),oe.$set(B);const Tt={};t&2&&(Tt.$$scope={dirty:t,ctx:e}),ne.$set(Tt)},i(e){Xt||(u(y.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Re.$$.fragment,e),u(S.$$.fragment,e),u(xe.$$.fragment,e),u(De.$$.fragment,e),u(Me.$$.fragment,e),u(O.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(ze.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(ke.$$.fragment,e),u(Ue.$$.fragment,e),u(Je.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(qe.$$.fragment,e),u(X.$$.fragment,e),u(K.$$.fragment,e),u(Pe.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(Ze.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(oe.$$.fragment,e),u(ne.$$.fragment,e),u(Ve.$$.fragment,e),Xt=!0)},o(e){_(y.$$.fragment,e),_(ce.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(Re.$$.fragment,e),_(S.$$.fragment,e),_(xe.$$.fragment,e),_(De.$$.fragment,e),_(Me.$$.fragment,e),_(O.$$.fragment,e),_(je.$$.fragment,e),_(Ce.$$.fragment,e),_(ze.$$.fragment,e),_($e.$$.fragment,e),_(Ie.$$.fragment,e),_(ke.$$.fragment,e),_(Ue.$$.fragment,e),_(Je.$$.fragment,e),_(Fe.$$.fragment,e),_(Ne.$$.fragment,e),_(qe.$$.fragment,e),_(X.$$.fragment,e),_(K.$$.fragment,e),_(Pe.$$.fragment,e),_(We.$$.fragment,e),_(Be.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(Ze.$$.fragment,e),_(Ee.$$.fragment,e),_(Le.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(Ve.$$.fragment,e),Xt=!1},d(e){e&&(o(w),o(p),o(m),o(n),o(v),o(wt),o(vt),o(de),o(Rt),o(le),o(xt),o(me),o(Dt),o(pe),o(Mt),o(H),o(jt),o(he),o(Ct),o(ge),o(zt),o($t),o(ue),o(It),o(kt),o(Ut),o(Te),o(Jt),o(Ft),o(we),o(Nt),o(qt),o(M),o(Pt),o(Wt),o(I),o(Bt),o(Zt),o(k),o(Et),o(Lt),o(U),o(Vt),o(Ht),o(j),o(St),o(Gt),o(C),o(Ot),o(At),o(z),o(Qt),o(Yt),o(bt)),o(r),b(y,e),b(ce,e),b(fe,e),b(_e,e),b(be,e),b(ye,e),b(ve,e),b(Re),b(S),b(xe),b(De,e),b(Me),b(O),b(je,e),b(Ce),b(ze),b($e),b(Ie,e),b(ke),b(Ue),b(Je),b(Fe,e),b(Ne),b(qe),b(X),b(K),b(Pe,e),b(We),b(Be),b(ee),b(te),b(Ze,e),b(Ee),b(Le),b(oe),b(ne),b(Ve,e)}}}const qn='{"title":"RT-DETR","local":"rt-detr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"RTDetrConfig","local":"transformers.RTDetrConfig","sections":[],"depth":2},{"title":"RTDetrResNetConfig","local":"transformers.RTDetrResNetConfig","sections":[],"depth":2},{"title":"RTDetrImageProcessor","local":"transformers.RTDetrImageProcessor","sections":[],"depth":2},{"title":"RTDetrImageProcessorFast","local":"transformers.RTDetrImageProcessorFast","sections":[],"depth":2},{"title":"RTDetrModel","local":"transformers.RTDetrModel","sections":[],"depth":2},{"title":"RTDetrForObjectDetection","local":"transformers.RTDetrForObjectDetection","sections":[],"depth":2},{"title":"RTDetrResNetBackbone","local":"transformers.RTDetrResNetBackbone","sections":[],"depth":2}],"depth":1}';function Pn(x){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class On extends Rn{constructor(r){super(),xn(this,r,Pn,Nn,yn,{})}}export{On as component};
