import{s as Po,o as Vo,n as ot}from"../chunks/scheduler.18a86fab.js";import{S as Xo,i as Oo,g as i,s as r,r as u,A as Ao,h as d,f as o,c as s,j as z,u as f,x as m,k as S,y as n,a as c,v as g,d as _,t as T,w}from"../chunks/index.98837b22.js";import{T as ho}from"../chunks/Tip.77304350.js";import{D as H}from"../chunks/Docstring.6758ea23.js";import{C as po}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as mo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as N}from"../chunks/Heading.7e7e0c5b.js";import{E as Do}from"../chunks/index.499f366c.js";function Yo(C){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(h){a=d(h,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(h,p){c(h,a,p)},p:ot,d(h){h&&o(a)}}}function Qo(C){let a,b="Example:",h,p,y;return p=new po({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnN3aXRjaC1iYXNlLTglMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGc3dpdGNoLWJhc2UtOCUyMiklMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJTdHVkaWVzJTIwc2hvdyUyMHRoYXQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBJTBBJTIzJTIwcHJlcHJvY2VzcyUzQSUyMFByZXBlbmQlMjBkZWNvZGVyX2lucHV0X2lkcyUyMHdpdGglMjBzdGFydCUyMHRva2VuJTIwd2hpY2glMjBpcyUyMHBhZCUyMHRva2VuJTIwZm9yJTIwU3dpdGNoVHJhbnNmb3JtZXJzTW9kZWwuJTBBJTIzJTIwVGhpcyUyMGlzJTIwbm90JTIwbmVlZGVkJTIwZm9yJTIwdG9yY2gncyUyMFN3aXRjaFRyYW5zZm9ybWVyc0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyMGFzJTIwaXQlMjBkb2VzJTIwdGhpcyUyMGludGVybmFsbHklMjB1c2luZyUyMGxhYmVscyUyMGFyZy4lMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMG1vZGVsLl9zaGlmdF9yaWdodChkZWNvZGVyX2lucHV0X2lkcyklMEElMEElMjMlMjBmb3J3YXJkJTIwcGFzcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersModel.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for SwitchTransformersModel.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s SwitchTransformersForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,h=r(),u(p.$$.fragment)},l(l){a=d(l,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=b),h=s(l),f(p.$$.fragment,l)},m(l,M){c(l,a,M),c(l,h,M),g(p,l,M),y=!0},p:ot,i(l){y||(_(p.$$.fragment,l),y=!0)},o(l){T(p.$$.fragment,l),y=!1},d(l){l&&(o(a),o(h)),w(p,l)}}}function Ko(C){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(h){a=d(h,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(h,p){c(h,a,p)},p:ot,d(h){h&&o(a)}}}function en(C){let a,b="Examples:",h,p,y;return p=new po({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpdGNoVHJhbnNmb3JtZXJzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQSUwQSUyMyUyMHRyYWluaW5nJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMCUzQ2V4dHJhX2lkXzAlM0UlMjB3YWxrcyUyMGluJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHBhcmslMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyJTNDZXh0cmFfaWRfMCUzRSUyMGN1dGUlMjBkb2clMjAlM0NleHRyYV9pZF8xJTNFJTIwdGhlJTIwJTNDZXh0cmFfaWRfMiUzRSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBJTIzJTIwaW5mZXJlbmNlJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMnN1bW1hcml6ZSUzQSUyMHN0dWRpZXMlMjBoYXZlJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzKSUwQSUyMyUyMC4lMjBUbyUyQyUyMGxldCVFMiU4MCU5OXMlMjBzYXklMjB5b3UlMjBoYXZlJTIwYSUyMGRvZy4lMjBUbyUyMHN1bW1hcml6ZSUzQSUwQSUyMyUyMFNpbmNlJTIwdGhlJTIwbW9kZWwlMjBoYXMlMjBiZWVuJTIwdHJhaW5lZCUyMG9uJTIwTUxNJTJDJTIwdGhpcyUyMHdpbGwlMjBvdXRwdXQlMjBnaWJiZXJpc2g=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;summarize: studies have shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># . To, let’s say you have a dog. To summarize:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since the model has been trained on MLM, this will output gibberish</span>`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,h=r(),u(p.$$.fragment)},l(l){a=d(l,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=b),h=s(l),f(p.$$.fragment,l)},m(l,M){c(l,a,M),c(l,h,M),g(p,l,M),y=!0},p:ot,i(l){y||(_(p.$$.fragment,l),y=!0)},o(l){T(p.$$.fragment,l),y=!1},d(l){l&&(o(a),o(h)),w(p,l)}}}function tn(C){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(h){a=d(h,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(h,p){c(h,a,p)},p:ot,d(h){h&&o(a)}}}function on(C){let a,b="Example:",h,p,y;return p=new po({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTd2l0Y2hUcmFuc2Zvcm1lcnNFbmNvZGVyTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpdGNoVHJhbnNmb3JtZXJzRW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZzd2l0Y2gtYmFzZS04JTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJTdHVkaWVzJTIwaGF2ZSUyMGJlZW4lMjBzaG93biUyMHRoYXQlMjBvd25pbmclMjBhJTIwZG9nJTIwaXMlMjBnb29kJTIwZm9yJTIweW91JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkuaW5wdXRfaWRzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dF9pZHMpJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SwitchTransformersEncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwitchTransformersEncoderModel.from_pretrained(<span class="hljs-string">&quot;google/switch-base-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,h=r(),u(p.$$.fragment)},l(l){a=d(l,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=b),h=s(l),f(p.$$.fragment,l)},m(l,M){c(l,a,M),c(l,h,M),g(p,l,M),y=!0},p:ot,i(l){y||(_(p.$$.fragment,l),y=!0)},o(l){T(p.$$.fragment,l),y=!1},d(l){l&&(o(a),o(h)),w(p,l)}}}function nn(C){let a,b,h,p,y,l,M,uo='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',rt,ne,st,re,fo='The SwitchTransformers model was proposed in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity</a> by William Fedus, Barret Zoph, Noam Shazeer.',at,se,go=`The Switch Transformer model uses a sparse T5 encoder-decoder architecture, where the MLP are replaced by a Mixture of Experts (MoE). A routing mechanism (top 1 in this case) associates each token to one of the expert, where each expert is a dense MLP. While switch transformers have a lot more weights than their equivalent dense models, the sparsity allows better scaling and better finetuning performance at scale.
During a forward pass, only a fraction of the weights are used. The routing mechanism allows the model to select relevant weights on the fly which increases the model capacity without increasing the number of operations.`,it,ae,_o="The abstract from the paper is the following:",dt,ie,To="<em>In deep learning, models typically reuse the same parameters for all inputs. Mixture of Experts (MoE) defies this and instead selects different parameters for each incoming example. The result is a sparsely-activated model — with outrageous numbers of parameters — but a constant computational cost. However, despite several notable successes of MoE, widespread adoption has been hindered by complexity, communication costs and training instability — we address these with the Switch Transformer. We simplify the MoE routing algorithm and design intuitive improved models with reduced communication and computational costs. Our proposed training techniques help wrangle the instabilities and we show large sparse models may be trained, for the first time, with lower precision (bfloat16) formats. We design models based off T5-Base and T5-Large to obtain up to 7x increases in pre-training speed with the same computational resources. These improvements extend into multilingual settings where we measure gains over the mT5-Base version across all 101 languages. Finally, we advance the current scale of language models by pre-training up to trillion parameter models on the “Colossal Clean Crawled Corpus” and achieve a 4x speedup over the T5-XXL model.</em>",ct,de,wo=`This model was contributed by <a href="https://huggingface.co/ybelkada" rel="nofollow">Younes Belkada</a> and <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>.
The original code can be found <a href="https://github.com/google/flaxformer/tree/main/flaxformer/architectures/moe" rel="nofollow">here</a>.`,lt,ce,ht,le,bo='<li>SwitchTransformers uses the <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>, which can be loaded directly from each model’s repository.</li> <li>The released weights are pretrained on English <a href="https://moon-ci-docs.huggingface.co/docs/transformers/pr_19323/en/glossary#general-terms" rel="nofollow">Masked Language Modeling</a> task, and should be finetuned.</li>',mt,he,pt,me,yo='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',ut,pe,ft,q,ue,zt,Je,Mo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a>. It is used to
instantiate a SwitchTransformers model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the
SwitchTransformers <a href="https://huggingface.co/google/switch-base-8" rel="nofollow">google/switch-base-8</a> architecture.`,Ft,Ie,vo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,gt,fe,_t,v,ge,Ut,He,ko="Router using tokens choose top-1 experts assignment.",jt,qe,xo=`This router uses the same mechanism as in Switch Transformer (<a href="https://arxiv.org/abs/2101.03961" rel="nofollow">https://arxiv.org/abs/2101.03961</a>) and V-MoE
(<a href="https://arxiv.org/abs/2106.05974" rel="nofollow">https://arxiv.org/abs/2106.05974</a>): tokens choose their top experts. Items are sorted by router_probs and then
routed to their choice of expert until the expert’s expert_capacity is reached. <strong>There is no guarantee that each
token is processed by an expert</strong>, or that each expert receives at least one token.`,Jt,X,_e,It,Re,$o="Computes router probabilities from input hidden states.",Ht,G,Te,qt,Ze,So=`Generic forward function for every Router class. Each Router expects to have the same input hidden states
(<code>hidden_states</code>) corresponding to the hidden states for each token, the <code>expert_capacity</code> corresponding to the
number of tokens the Router will send to each expert, some Routers can send up to few tokens to each expert.`,Rt,Ge,Co=`Each Router works as the following: it expects the hidden states for each token, gets the <code>router_probs</code> and
<code>router_logits</code> from the <code>router_weights</code>. This will assign for each token, the raw probability to be assigned
to an expert. Then each Router class will have to define its own <code>_compute_routing_instructions</code>.`,Tt,we,wt,R,be,Zt,Ee,zo="Implementation of the Switch Transformers Sparse MLP module.",Gt,U,ye,Et,We,Fo="Hold on, this will be slightly tricky to understand In the correct order, a MoE layer does the following:",Wt,Be,Uo=`1- Gets the <code>router_mask</code> from the router. The shape of the mask is <code>(batch_size, sequence_length, num_expert)</code>
and corresponds to the argmax of the <code>router_probs</code>. The probabilities are needed in the computation of the
hidden states : they are broadcasted to the hidden states values (can be interpreted as a scaling factor).`,Bt,Ne,jo=`2- Dispatch the tokens to its associated experts. We do a classic for loop over the experts and assign for each
expert the corresponding hidden states.`,bt,Me,yt,k,ve,Nt,Le,Jo="The bare Switch Transformers Model outputting raw hidden-states without any specific head on top.",Lt,Pe,Io=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pt,Ve,Ho=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Vt,j,ke,Xt,Xe,qo='The <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a> forward method, overrides the <code>__call__</code> special method.',Ot,O,At,A,Mt,xe,vt,x,$e,Dt,Oe,Ro="SWITCH_TRANSFORMERS Model with a <code>language modeling</code> head on top.",Yt,Ae,Zo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qt,De,Go=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Kt,J,Se,eo,Ye,Eo='The <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersForConditionalGeneration">SwitchTransformersForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',to,D,oo,Y,kt,Ce,xt,$,ze,no,Qe,Wo="The bare SWITCH_TRANSFORMERS Model transformer outputting encoder’s raw hidden-states without any specific head",ro,Ke,Bo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,so,et,No=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ao,I,Fe,io,tt,Lo='The <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersEncoderModel">SwitchTransformersEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',co,Q,lo,K,$t,Ue,St,nt,Ct;return y=new N({props:{title:"SwitchTransformers",local:"switchtransformers",headingTag:"h1"}}),ne=new N({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ce=new N({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),he=new N({props:{title:"Resources",local:"resources",headingTag:"h2"}}),pe=new N({props:{title:"SwitchTransformersConfig",local:"transformers.SwitchTransformersConfig",headingTag:"h2"}}),ue=new H({props:{name:"class transformers.SwitchTransformersConfig",anchor:"transformers.SwitchTransformersConfig",parameters:[{name:"vocab_size",val:" = 32128"},{name:"d_model",val:" = 768"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 2048"},{name:"expert_capacity",val:" = 64"},{name:"num_layers",val:" = 12"},{name:"num_sparse_encoder_layers",val:" = 3"},{name:"num_decoder_layers",val:" = 12"},{name:"num_sparse_decoder_layers",val:" = 3"},{name:"num_heads",val:" = 12"},{name:"num_experts",val:" = 8"},{name:"router_bias",val:" = False"},{name:"router_jitter_noise",val:" = 0.01"},{name:"router_dtype",val:" = 'float32'"},{name:"router_ignore_padding_tokens",val:" = False"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"router_z_loss_coef",val:" = 0.001"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"initializer_factor",val:" = 1.0"},{name:"dense_act_fn",val:" = 'relu'"},{name:"is_encoder_decoder",val:" = True"},{name:"add_router_probs",val:" = False"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SwitchTransformersConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32128) &#x2014;
Vocabulary size of the SwitchTransformers model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersModel">SwitchTransformersModel</a>.`,name:"vocab_size"},{anchor:"transformers.SwitchTransformersConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.SwitchTransformersConfig.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. <code>d_kv</code> has to be equal to <code>d_model // num_heads</code>.`,name:"d_kv"},{anchor:"transformers.SwitchTransformersConfig.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Size of the intermediate feed forward layer in each <code>SwitchTransformersBlock</code>.`,name:"d_ff"},{anchor:"transformers.SwitchTransformersConfig.expert_capacity",description:`<strong>expert_capacity</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of tokens that can be stored in each expert. If set to 1, the model will behave like a regular
Transformer.`,name:"expert_capacity"},{anchor:"transformers.SwitchTransformersConfig.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of dense hidden layers in the Transformer encoder layer.`,name:"num_layers"},{anchor:"transformers.SwitchTransformersConfig.num_sparse_encoder_layers",description:`<strong>num_sparse_encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of sparse (MoE) dense hidden layers in the Transformer encoder layer.`,name:"num_sparse_encoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_sparse_decoder_layers",description:`<strong>num_sparse_decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of sparse (MoE) dense hidden layers in the Transformer decoder layer.`,name:"num_sparse_decoder_layers"},{anchor:"transformers.SwitchTransformersConfig.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.SwitchTransformersConfig.num_experts",description:`<strong>num_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of experts for each SwitchTransformer layer.`,name:"num_experts"},{anchor:"transformers.SwitchTransformersConfig.router_bias",description:`<strong>router_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a bias to the router.`,name:"router_bias"},{anchor:"transformers.SwitchTransformersConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
Amount of noise to add to the router.`,name:"router_jitter_noise"},{anchor:"transformers.SwitchTransformersConfig.router_dtype",description:`<strong>router_dtype</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;float32&quot;</code>) &#x2014;
The <code>dtype</code> used for the routers. It is preferable to keep the <code>dtype</code> to <code>&quot;float32&quot;</code> as specified in the
<em>selective precision</em> discussion in <a href="https://arxiv.org/abs/2101.03961" rel="nofollow">the paper</a>.`,name:"router_dtype"},{anchor:"transformers.SwitchTransformersConfig.router_ignore_padding_tokens",description:`<strong>router_ignore_padding_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to ignore padding tokens when routing.`,name:"router_ignore_padding_tokens"},{anchor:"transformers.SwitchTransformersConfig.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.SwitchTransformersConfig.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.SwitchTransformersConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.SwitchTransformersConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SwitchTransformersConfig.router_z_loss_coef",description:`<strong>router_z_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The z loss factor for the total loss.`,name:"router_z_loss_coef"},{anchor:"transformers.SwitchTransformersConfig.router_aux_loss_coef",description:`<strong>router_aux_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The aux loss factor for the total loss.`,name:"router_aux_loss_coef"},{anchor:"transformers.SwitchTransformersConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.SwitchTransformersConfig.dense_act_fn",description:`<strong>dense_act_fn</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>. SwitchTransformersv1.1
uses the <code>&quot;gated-gelu&quot;</code> feed forward projection. Original SwitchTransformers uses <code>&quot;relu&quot;</code>.`,name:"dense_act_fn"},{anchor:"transformers.SwitchTransformersConfig.add_router_probs",description:`<strong>add_router_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to output router probabilities to compute router auxiliary loss.`,name:"add_router_probs"},{anchor:"transformers.SwitchTransformersConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/configuration_switch_transformers.py#L24"}}),fe=new N({props:{title:"SwitchTransformersTop1Router",local:"transformers.SwitchTransformersTop1Router",headingTag:"h2"}}),ge=new H({props:{name:"class transformers.SwitchTransformersTop1Router",anchor:"transformers.SwitchTransformersTop1Router",parameters:[{name:"config",val:": SwitchTransformersConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L124"}}),_e=new H({props:{name:"_compute_router_probabilities",anchor:"transformers.SwitchTransformersTop1Router._compute_router_probabilities",parameters:[{name:"hidden_states",val:": Tensor"}],parametersDescription:[{anchor:"transformers.SwitchTransformersTop1Router._compute_router_probabilities.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>) &#x2014;
(batch_size, sequence_length, hidden_dim) from which router probabilities are computed.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Tensor of shape (batch_size, sequence_length, num_experts) corresponding to the probabilities for each
token and expert. Used for routing tokens to experts.
router_logits (<code>torch.Tensor</code>):
Logits tensor of shape (batch_size, sequence_length, num_experts) corresponding to raw router logits.
This is used later for computing router z-loss.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>router_probabilities (<code>torch.Tensor</code>)</p>
`}}),Te=new H({props:{name:"forward",anchor:"transformers.SwitchTransformersTop1Router.forward",parameters:[{name:"hidden_states",val:": Tensor"}],parametersDescription:[{anchor:"transformers.SwitchTransformersTop1Router.forward.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>)  &#x2014;
[num_groups, tokens_per_group, hidden_dim] inputs to send to experts.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L185",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Tuple[<code>torch.Tensor</code>, <code>torch.Tensor</code>, <code>torch.Tensor</code>] Tuple containing the expert index, the router probs
and the router logits. The router probabilities and logits are required to compute the loss.</p>
`}}),we=new N({props:{title:"SwitchTransformersSparseMLP",local:"transformers.SwitchTransformersSparseMLP",headingTag:"h2"}}),be=new H({props:{name:"class transformers.SwitchTransformersSparseMLP",anchor:"transformers.SwitchTransformersSparseMLP",parameters:[{name:"config",val:": SwitchTransformersConfig"},{name:"expert_class",val:": Module = <class 'transformers.models.switch_transformers.modeling_switch_transformers.SwitchTransformersDenseActDense'>"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L269"}}),ye=new H({props:{name:"forward",anchor:"transformers.SwitchTransformersSparseMLP.forward",parameters:[{name:"hidden_states",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L284"}}),Me=new N({props:{title:"SwitchTransformersModel",local:"transformers.SwitchTransformersModel",headingTag:"h2"}}),ve=new H({props:{name:"class transformers.SwitchTransformersModel",anchor:"transformers.SwitchTransformersModel",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1261"}}),ke=new H({props:{name:"forward",anchor:"transformers.SwitchTransformersModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>SWITCH_TRANSFORMERS uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.SwitchTransformersModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.SwitchTransformersModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SwitchTransformersModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SwitchTransformersModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SwitchTransformersModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SwitchTransformersModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwitchTransformersModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1313",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.Seq2SeqMoEModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>encoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the encoder model, useful to compute the auxiliary loss and the z_loss for the sparse
modules.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.Seq2SeqMoEModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new ho({props:{$$slots:{default:[Yo]},$$scope:{ctx:C}}}),A=new mo({props:{anchor:"transformers.SwitchTransformersModel.forward.example",$$slots:{default:[Qo]},$$scope:{ctx:C}}}),xe=new N({props:{title:"SwitchTransformersForConditionalGeneration",local:"transformers.SwitchTransformersForConditionalGeneration",headingTag:"h2"}}),$e=new H({props:{name:"class transformers.SwitchTransformersForConditionalGeneration",anchor:"transformers.SwitchTransformersForConditionalGeneration",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1472"}}),Se=new H({props:{name:"forward",anchor:"transformers.SwitchTransformersForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = True"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>SWITCH_TRANSFORMERS uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[Tuple[torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1534",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.Seq2SeqMoEOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>decoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the decoder model, useful to compute the auxiliary loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>encoder_router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_logits=True</code> is passed or when <code>config.add_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Router logits of the encoder model, useful to compute the auxiliary loss and z_loss for Mixture of Experts
models.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.Seq2SeqMoEOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new ho({props:{$$slots:{default:[Ko]},$$scope:{ctx:C}}}),Y=new mo({props:{anchor:"transformers.SwitchTransformersForConditionalGeneration.forward.example",$$slots:{default:[en]},$$scope:{ctx:C}}}),Ce=new N({props:{title:"SwitchTransformersEncoderModel",local:"transformers.SwitchTransformersEncoderModel",headingTag:"h2"}}),ze=new H({props:{name:"class transformers.SwitchTransformersEncoderModel",anchor:"transformers.SwitchTransformersEncoderModel",parameters:[{name:"config",val:": SwitchTransformersConfig"}],parametersDescription:[{anchor:"transformers.SwitchTransformersEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig">SwitchTransformersConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1797"}}),Fe=new H({props:{name:"forward",anchor:"transformers.SwitchTransformersEncoderModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwitchTransformersEncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. SWITCH_TRANSFORMERS is a model with relative position
embeddings so you should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./switch_transformers#training">SWITCH_TRANSFORMERS
Training</a>.`,name:"input_ids"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.SwitchTransformersEncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/switch_transformers/modeling_switch_transformers.py#L1842",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoEModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/switch_transformers#transformers.SwitchTransformersConfig"
>SwitchTransformersConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>router_probs</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router probabilities that are computed by MoE routers, these terms are used to compute the auxiliary
loss and the z_loss for Mixture of Experts models.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoEModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new ho({props:{$$slots:{default:[tn]},$$scope:{ctx:C}}}),K=new mo({props:{anchor:"transformers.SwitchTransformersEncoderModel.forward.example",$$slots:{default:[on]},$$scope:{ctx:C}}}),Ue=new Do({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/switch_transformers.md"}}),{c(){a=i("meta"),b=r(),h=i("p"),p=r(),u(y.$$.fragment),l=r(),M=i("div"),M.innerHTML=uo,rt=r(),u(ne.$$.fragment),st=r(),re=i("p"),re.innerHTML=fo,at=r(),se=i("p"),se.textContent=go,it=r(),ae=i("p"),ae.textContent=_o,dt=r(),ie=i("p"),ie.innerHTML=To,ct=r(),de=i("p"),de.innerHTML=wo,lt=r(),u(ce.$$.fragment),ht=r(),le=i("ul"),le.innerHTML=bo,mt=r(),u(he.$$.fragment),pt=r(),me=i("ul"),me.innerHTML=yo,ut=r(),u(pe.$$.fragment),ft=r(),q=i("div"),u(ue.$$.fragment),zt=r(),Je=i("p"),Je.innerHTML=Mo,Ft=r(),Ie=i("p"),Ie.innerHTML=vo,gt=r(),u(fe.$$.fragment),_t=r(),v=i("div"),u(ge.$$.fragment),Ut=r(),He=i("p"),He.textContent=ko,jt=r(),qe=i("p"),qe.innerHTML=xo,Jt=r(),X=i("div"),u(_e.$$.fragment),It=r(),Re=i("p"),Re.textContent=$o,Ht=r(),G=i("div"),u(Te.$$.fragment),qt=r(),Ze=i("p"),Ze.innerHTML=So,Rt=r(),Ge=i("p"),Ge.innerHTML=Co,Tt=r(),u(we.$$.fragment),wt=r(),R=i("div"),u(be.$$.fragment),Zt=r(),Ee=i("p"),Ee.textContent=zo,Gt=r(),U=i("div"),u(ye.$$.fragment),Et=r(),We=i("p"),We.textContent=Fo,Wt=r(),Be=i("p"),Be.innerHTML=Uo,Bt=r(),Ne=i("p"),Ne.textContent=jo,bt=r(),u(Me.$$.fragment),yt=r(),k=i("div"),u(ve.$$.fragment),Nt=r(),Le=i("p"),Le.textContent=Jo,Lt=r(),Pe=i("p"),Pe.innerHTML=Io,Pt=r(),Ve=i("p"),Ve.innerHTML=Ho,Vt=r(),j=i("div"),u(ke.$$.fragment),Xt=r(),Xe=i("p"),Xe.innerHTML=qo,Ot=r(),u(O.$$.fragment),At=r(),u(A.$$.fragment),Mt=r(),u(xe.$$.fragment),vt=r(),x=i("div"),u($e.$$.fragment),Dt=r(),Oe=i("p"),Oe.innerHTML=Ro,Yt=r(),Ae=i("p"),Ae.innerHTML=Zo,Qt=r(),De=i("p"),De.innerHTML=Go,Kt=r(),J=i("div"),u(Se.$$.fragment),eo=r(),Ye=i("p"),Ye.innerHTML=Eo,to=r(),u(D.$$.fragment),oo=r(),u(Y.$$.fragment),kt=r(),u(Ce.$$.fragment),xt=r(),$=i("div"),u(ze.$$.fragment),no=r(),Qe=i("p"),Qe.textContent=Wo,ro=r(),Ke=i("p"),Ke.innerHTML=Bo,so=r(),et=i("p"),et.innerHTML=No,ao=r(),I=i("div"),u(Fe.$$.fragment),io=r(),tt=i("p"),tt.innerHTML=Lo,co=r(),u(Q.$$.fragment),lo=r(),u(K.$$.fragment),$t=r(),u(Ue.$$.fragment),St=r(),nt=i("p"),this.h()},l(e){const t=Ao("svelte-u9bgzb",document.head);a=d(t,"META",{name:!0,content:!0}),t.forEach(o),b=s(e),h=d(e,"P",{}),z(h).forEach(o),p=s(e),f(y.$$.fragment,e),l=s(e),M=d(e,"DIV",{class:!0,"data-svelte-h":!0}),m(M)!=="svelte-13t8s2t"&&(M.innerHTML=uo),rt=s(e),f(ne.$$.fragment,e),st=s(e),re=d(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-qxeocr"&&(re.innerHTML=fo),at=s(e),se=d(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1klyz3l"&&(se.textContent=go),it=s(e),ae=d(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-vfdo9a"&&(ae.textContent=_o),dt=s(e),ie=d(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-ev6w2b"&&(ie.innerHTML=To),ct=s(e),de=d(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-ks65n9"&&(de.innerHTML=wo),lt=s(e),f(ce.$$.fragment,e),ht=s(e),le=d(e,"UL",{"data-svelte-h":!0}),m(le)!=="svelte-1kdqw69"&&(le.innerHTML=bo),mt=s(e),f(he.$$.fragment,e),pt=s(e),me=d(e,"UL",{"data-svelte-h":!0}),m(me)!=="svelte-6ej6p2"&&(me.innerHTML=yo),ut=s(e),f(pe.$$.fragment,e),ft=s(e),q=d(e,"DIV",{class:!0});var L=z(q);f(ue.$$.fragment,L),zt=s(L),Je=d(L,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-mvsiw6"&&(Je.innerHTML=Mo),Ft=s(L),Ie=d(L,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-o55m63"&&(Ie.innerHTML=vo),L.forEach(o),gt=s(e),f(fe.$$.fragment,e),_t=s(e),v=d(e,"DIV",{class:!0});var F=z(v);f(ge.$$.fragment,F),Ut=s(F),He=d(F,"P",{"data-svelte-h":!0}),m(He)!=="svelte-12fm05d"&&(He.textContent=ko),jt=s(F),qe=d(F,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-14tpjgc"&&(qe.innerHTML=xo),Jt=s(F),X=d(F,"DIV",{class:!0});var je=z(X);f(_e.$$.fragment,je),It=s(je),Re=d(je,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-jnjz7k"&&(Re.textContent=$o),je.forEach(o),Ht=s(F),G=d(F,"DIV",{class:!0});var P=z(G);f(Te.$$.fragment,P),qt=s(P),Ze=d(P,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-wi3ols"&&(Ze.innerHTML=So),Rt=s(P),Ge=d(P,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1xte4m0"&&(Ge.innerHTML=Co),P.forEach(o),F.forEach(o),Tt=s(e),f(we.$$.fragment,e),wt=s(e),R=d(e,"DIV",{class:!0});var V=z(R);f(be.$$.fragment,V),Zt=s(V),Ee=d(V,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-1avy50b"&&(Ee.textContent=zo),Gt=s(V),U=d(V,"DIV",{class:!0});var Z=z(U);f(ye.$$.fragment,Z),Et=s(Z),We=d(Z,"P",{"data-svelte-h":!0}),m(We)!=="svelte-a1z96i"&&(We.textContent=Fo),Wt=s(Z),Be=d(Z,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1mybtpr"&&(Be.innerHTML=Uo),Bt=s(Z),Ne=d(Z,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1n21hyz"&&(Ne.textContent=jo),Z.forEach(o),V.forEach(o),bt=s(e),f(Me.$$.fragment,e),yt=s(e),k=d(e,"DIV",{class:!0});var E=z(k);f(ve.$$.fragment,E),Nt=s(E),Le=d(E,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-wxp7du"&&(Le.textContent=Jo),Lt=s(E),Pe=d(E,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-6pahdo"&&(Pe.innerHTML=Io),Pt=s(E),Ve=d(E,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-hswkmf"&&(Ve.innerHTML=Ho),Vt=s(E),j=d(E,"DIV",{class:!0});var ee=z(j);f(ke.$$.fragment,ee),Xt=s(ee),Xe=d(ee,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-876sfu"&&(Xe.innerHTML=qo),Ot=s(ee),f(O.$$.fragment,ee),At=s(ee),f(A.$$.fragment,ee),ee.forEach(o),E.forEach(o),Mt=s(e),f(xe.$$.fragment,e),vt=s(e),x=d(e,"DIV",{class:!0});var W=z(x);f($e.$$.fragment,W),Dt=s(W),Oe=d(W,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-yohvjb"&&(Oe.innerHTML=Ro),Yt=s(W),Ae=d(W,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-6pahdo"&&(Ae.innerHTML=Zo),Qt=s(W),De=d(W,"P",{"data-svelte-h":!0}),m(De)!=="svelte-hswkmf"&&(De.innerHTML=Go),Kt=s(W),J=d(W,"DIV",{class:!0});var te=z(J);f(Se.$$.fragment,te),eo=s(te),Ye=d(te,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-31wyrk"&&(Ye.innerHTML=Eo),to=s(te),f(D.$$.fragment,te),oo=s(te),f(Y.$$.fragment,te),te.forEach(o),W.forEach(o),kt=s(e),f(Ce.$$.fragment,e),xt=s(e),$=d(e,"DIV",{class:!0});var B=z($);f(ze.$$.fragment,B),no=s(B),Qe=d(B,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-15ds7q4"&&(Qe.textContent=Wo),ro=s(B),Ke=d(B,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-6pahdo"&&(Ke.innerHTML=Bo),so=s(B),et=d(B,"P",{"data-svelte-h":!0}),m(et)!=="svelte-hswkmf"&&(et.innerHTML=No),ao=s(B),I=d(B,"DIV",{class:!0});var oe=z(I);f(Fe.$$.fragment,oe),io=s(oe),tt=d(oe,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-1e2s0e4"&&(tt.innerHTML=Lo),co=s(oe),f(Q.$$.fragment,oe),lo=s(oe),f(K.$$.fragment,oe),oe.forEach(o),B.forEach(o),$t=s(e),f(Ue.$$.fragment,e),St=s(e),nt=d(e,"P",{}),z(nt).forEach(o),this.h()},h(){S(a,"name","hf:doc:metadata"),S(a,"content",rn),S(M,"class","flex flex-wrap space-x-1"),S(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){n(document.head,a),c(e,b,t),c(e,h,t),c(e,p,t),g(y,e,t),c(e,l,t),c(e,M,t),c(e,rt,t),g(ne,e,t),c(e,st,t),c(e,re,t),c(e,at,t),c(e,se,t),c(e,it,t),c(e,ae,t),c(e,dt,t),c(e,ie,t),c(e,ct,t),c(e,de,t),c(e,lt,t),g(ce,e,t),c(e,ht,t),c(e,le,t),c(e,mt,t),g(he,e,t),c(e,pt,t),c(e,me,t),c(e,ut,t),g(pe,e,t),c(e,ft,t),c(e,q,t),g(ue,q,null),n(q,zt),n(q,Je),n(q,Ft),n(q,Ie),c(e,gt,t),g(fe,e,t),c(e,_t,t),c(e,v,t),g(ge,v,null),n(v,Ut),n(v,He),n(v,jt),n(v,qe),n(v,Jt),n(v,X),g(_e,X,null),n(X,It),n(X,Re),n(v,Ht),n(v,G),g(Te,G,null),n(G,qt),n(G,Ze),n(G,Rt),n(G,Ge),c(e,Tt,t),g(we,e,t),c(e,wt,t),c(e,R,t),g(be,R,null),n(R,Zt),n(R,Ee),n(R,Gt),n(R,U),g(ye,U,null),n(U,Et),n(U,We),n(U,Wt),n(U,Be),n(U,Bt),n(U,Ne),c(e,bt,t),g(Me,e,t),c(e,yt,t),c(e,k,t),g(ve,k,null),n(k,Nt),n(k,Le),n(k,Lt),n(k,Pe),n(k,Pt),n(k,Ve),n(k,Vt),n(k,j),g(ke,j,null),n(j,Xt),n(j,Xe),n(j,Ot),g(O,j,null),n(j,At),g(A,j,null),c(e,Mt,t),g(xe,e,t),c(e,vt,t),c(e,x,t),g($e,x,null),n(x,Dt),n(x,Oe),n(x,Yt),n(x,Ae),n(x,Qt),n(x,De),n(x,Kt),n(x,J),g(Se,J,null),n(J,eo),n(J,Ye),n(J,to),g(D,J,null),n(J,oo),g(Y,J,null),c(e,kt,t),g(Ce,e,t),c(e,xt,t),c(e,$,t),g(ze,$,null),n($,no),n($,Qe),n($,ro),n($,Ke),n($,so),n($,et),n($,ao),n($,I),g(Fe,I,null),n(I,io),n(I,tt),n(I,co),g(Q,I,null),n(I,lo),g(K,I,null),c(e,$t,t),g(Ue,e,t),c(e,St,t),c(e,nt,t),Ct=!0},p(e,[t]){const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),O.$set(L);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),A.$set(F);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),D.$set(je);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),Y.$set(P);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),Q.$set(V);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),K.$set(Z)},i(e){Ct||(_(y.$$.fragment,e),_(ne.$$.fragment,e),_(ce.$$.fragment,e),_(he.$$.fragment,e),_(pe.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(ve.$$.fragment,e),_(ke.$$.fragment,e),_(O.$$.fragment,e),_(A.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(Se.$$.fragment,e),_(D.$$.fragment,e),_(Y.$$.fragment,e),_(Ce.$$.fragment,e),_(ze.$$.fragment,e),_(Fe.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(Ue.$$.fragment,e),Ct=!0)},o(e){T(y.$$.fragment,e),T(ne.$$.fragment,e),T(ce.$$.fragment,e),T(he.$$.fragment,e),T(pe.$$.fragment,e),T(ue.$$.fragment,e),T(fe.$$.fragment,e),T(ge.$$.fragment,e),T(_e.$$.fragment,e),T(Te.$$.fragment,e),T(we.$$.fragment,e),T(be.$$.fragment,e),T(ye.$$.fragment,e),T(Me.$$.fragment,e),T(ve.$$.fragment,e),T(ke.$$.fragment,e),T(O.$$.fragment,e),T(A.$$.fragment,e),T(xe.$$.fragment,e),T($e.$$.fragment,e),T(Se.$$.fragment,e),T(D.$$.fragment,e),T(Y.$$.fragment,e),T(Ce.$$.fragment,e),T(ze.$$.fragment,e),T(Fe.$$.fragment,e),T(Q.$$.fragment,e),T(K.$$.fragment,e),T(Ue.$$.fragment,e),Ct=!1},d(e){e&&(o(b),o(h),o(p),o(l),o(M),o(rt),o(st),o(re),o(at),o(se),o(it),o(ae),o(dt),o(ie),o(ct),o(de),o(lt),o(ht),o(le),o(mt),o(pt),o(me),o(ut),o(ft),o(q),o(gt),o(_t),o(v),o(Tt),o(wt),o(R),o(bt),o(yt),o(k),o(Mt),o(vt),o(x),o(kt),o(xt),o($),o($t),o(St),o(nt)),o(a),w(y,e),w(ne,e),w(ce,e),w(he,e),w(pe,e),w(ue),w(fe,e),w(ge),w(_e),w(Te),w(we,e),w(be),w(ye),w(Me,e),w(ve),w(ke),w(O),w(A),w(xe,e),w($e),w(Se),w(D),w(Y),w(Ce,e),w(ze),w(Fe),w(Q),w(K),w(Ue,e)}}}const rn='{"title":"SwitchTransformers","local":"switchtransformers","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SwitchTransformersConfig","local":"transformers.SwitchTransformersConfig","sections":[],"depth":2},{"title":"SwitchTransformersTop1Router","local":"transformers.SwitchTransformersTop1Router","sections":[],"depth":2},{"title":"SwitchTransformersSparseMLP","local":"transformers.SwitchTransformersSparseMLP","sections":[],"depth":2},{"title":"SwitchTransformersModel","local":"transformers.SwitchTransformersModel","sections":[],"depth":2},{"title":"SwitchTransformersForConditionalGeneration","local":"transformers.SwitchTransformersForConditionalGeneration","sections":[],"depth":2},{"title":"SwitchTransformersEncoderModel","local":"transformers.SwitchTransformersEncoderModel","sections":[],"depth":2}],"depth":1}';function sn(C){return Vo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fn extends Xo{constructor(a){super(),Oo(this,a,sn,nn,Po,{})}}export{fn as component};
