import{s as PZ,o as AZ,n as J}from"../chunks/scheduler.18a86fab.js";import{S as OZ,i as KZ,g as o,s as a,r as m,A as eC,h as l,f as n,c as r,j as T,u as g,x as y,k as M,y as t,a as p,v as h,d as u,t as f,w as b}from"../chunks/index.98837b22.js";import{T as Gs}from"../chunks/Tip.77304350.js";import{D as v}from"../chunks/Docstring.6758ea23.js";import{C as U}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Z}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ne}from"../chunks/Heading.7e7e0c5b.js";import{E as tC}from"../chunks/index.499f366c.js";function sC($){let i,j=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){i=o("p"),i.innerHTML=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-nbt45a"&&(i.innerHTML=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function nC($){let i,j=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){i=o("p"),i.innerHTML=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1uojnuk"&&(i.innerHTML=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function aC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function rC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function oC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function lC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbW1lbmRzJTIwdXNpbmclMjAlNjBlcHNpbG9uX2N1dG9mZiU2MCUyMHZhbHVlcyUyMGJldHdlZW4lMjAzZS00JTIwYW5kJTIwOWUtNCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBlcHNpbG9uX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recommends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function iC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbW1lbmRzJTIwdXNpbmclMjAlNjBldGFfY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjB0byUyMDRlLTMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZXRhX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recommends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function cC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function dC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function pC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function mC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function gC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function hC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function uC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function fC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MG1pbl9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MG1pbl9wJTYwJTIwaW4lMjB0aGUlMjAwLjAxLTAuMiUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtaW5fcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`min_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`min_p\` in the 0.01-0.2 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, min_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function bC($){let i,j=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){i=o("p"),i.innerHTML=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-15bvr1j"&&(i.innerHTML=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function _C($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function yC($){let i,j=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){i=o("p"),i.innerHTML=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-5zfsi9"&&(i.innerHTML=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function TC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function MC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can constrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function vC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFJlcGV0aXRpb25QZW5hbHR5TG9naXRzUHJvY2Vzc29yJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbml6ZXIlMjBmb3IlMjBpdCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJJ20lMjBub3QlMjBnb2luZyUyMHRvJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBUaGlzJTIwc2hvd3MlMjBhJTIwbm9ybWFsJTIwZ2VuZXJhdGUlMjB3aXRob3V0JTIwYW55JTIwc3BlY2lmaWMlMjBwYXJhbWV0ZXJzJTBBc3VtbWFyeV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKHN1bW1hcnlfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBUaGlzJTIwZ2VuZXJhdGVzJTIwYSUyMHBlbmFsdHklMjBmb3IlMjByZXBlYXRlZCUyMHRva2VucyUwQXBlbmFsaXplZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJlcGV0aXRpb25fcGVuYWx0eSUzRDEuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKHBlbmFsaXplZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdlJTIwY2FuJTIwYWxzbyUyMGV4Y2x1ZGUlMjB0aGUlMjBpbnB1dCUyMHByb21wdCUyMGJ5JTIwY3JlYXRpbmclMjBhbiUyMGluc3RhbmNlJTIwb2YlMjB0aGlzJTIwY2xhc3MlMEElMjMlMjB3aXRoJTIwYSUyMCU2MHByb21wdF9pZ25vcmVfbGVuZ3RoJTYwJTIwYW5kJTIwcGFzc2luZyUyMGl0JTIwYXMlMjBhJTIwY3VzdG9tJTIwbG9naXQlMjBwcm9jZXNzb3IlMEFyZXBfcGVuX3Byb2Nlc3NvciUyMCUzRCUyMFJlcGV0aXRpb25QZW5hbHR5TG9naXRzUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHBlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfaWdub3JlX2xlbmd0aCUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC5zaGFwZSU1Qi0xJTVEJTBBKSUwQXBlbmFsaXplZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGxvZ2l0c19wcm9jZXNzb3IlM0QlNUJyZXBfcGVuX3Byb2Nlc3NvciU1RCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKHBlbmFsaXplZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, RepetitionPenaltyLogitsProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also exclude the input prompt by creating an instance of this class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a \`prompt_ignore_length\` and passing it as a custom logit processor</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>rep_pen_processor = RepetitionPenaltyLogitsProcessor(
<span class="hljs-meta">... </span>    penalty=<span class="hljs-number">1.1</span>,
<span class="hljs-meta">... </span>    prompt_ignore_length=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, logits_processor=[rep_pen_processor])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to have to go through a lot of things, <span class="hljs-keyword">and</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function wC($){let i,j=`At a token-level, biasing a word is different from biasing a word with a space before it. If you want to bias
“foo” mid-sentence, you’ll likely want to add a prefix space and bias ” foo” instead. Check the tokenizer section
of our NLP course to find out why: <a href="https://huggingface.co/learn/nlp-course/chapter2/4?fw=pt" rel="nofollow">https://huggingface.co/learn/nlp-course/chapter2/4?fw=pt</a>`;return{c(){i=o("p"),i.innerHTML=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1tichf6"&&(i.innerHTML=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function kC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald John Trump Sr.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># IMPORTANT: Remember our tip about adding spaces before words to bias them correctly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [[get_tokens(<span class="hljs-string">&quot;Trump&quot;</span>), -<span class="hljs-number">10.0</span>],]  <span class="hljs-comment"># will fail to apply bias</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>, sequence_bias=sequence_bias
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald John Trump Sr.

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [[get_tokens(<span class="hljs-string">&quot; Trump&quot;</span>), -<span class="hljs-number">10.0</span>],]  <span class="hljs-comment"># will work</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>, sequence_bias=sequence_bias
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald John Harper. He

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations. This technique</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># is also more effective when paired up with beam search.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [[get_tokens(<span class="hljs-string">&quot; Donald Duck&quot;</span>), <span class="hljs-number">10.0</span>],]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">False</span>, sequence_bias=sequence_bias
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck. He <span class="hljs-keyword">is</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function jC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function $C($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function JC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function xC($){let i,j=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){i=o("p"),i.innerHTML=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1byeoum"&&(i.innerHTML=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function UC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function ZC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function CC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function WC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function IC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function BC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function zC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya2luZ0NvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm9ybWFsJTIwZ2VuZXJhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdhdGVybWFya2VkJTIwZ2VuZXJhdGlvbiUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMGNvbnRleHRfd2lkdGglM0QyJTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHRvJTIwZGV0ZWN0JTIwd2F0ZXJtYXJrZWQlMjB0ZXh0JTIwdXNlJTIwdGhlJTIwV2F0ZXJtYXJrRGV0ZWN0b3IlMjBjbGFzcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBXYXRlcm1hcmtEZXRlY3RvciUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRCUyMHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX3ByZWRzJTIwJTNEJTIwZGV0ZWN0b3Iob3V0KSUwQWRldGVjdGlvbl9wcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob are&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># normal generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both in the same room.\\n\\n&quot;I\\&#x27;m not sure if you\\&#x27;re&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># watermarked generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, context_width=<span class="hljs-number">2</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], watermarking_config=watermarking_config, max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both still alive and well and the story is pretty much a one-hour adventure&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to detect watermarked text use the WatermarkDetector class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WatermarkDetector
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config= watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds = detector(out)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds
array([ <span class="hljs-literal">True</span>])`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function VC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBiaWdnZXN0JTIwc3RhdGVzJTIwaW4lMjB0aGUlMjBVU0ElMjBieSUyMGxhbmQlMjBhcmVhJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBQYXNzaW5nJTIwb25lJTIwb3IlMjBtb3JlJTIwc3RvcCUyMHN0cmluZ3MlMjB3aWxsJTIwaGFsdCUyMGdlbmVyYXRpb24lMjBhZnRlciUyMHRob3NlJTIwc3RyaW5ncyUyMGFyZSUyMGVtaXR0ZWQlMEElMjMlMjBOb3RlJTIwdGhhdCUyMGdlbmVyYXRpbmclMjB3aXRoJTIwc3RvcCUyMHN0cmluZ3MlMjByZXF1aXJlcyUyMHlvdSUyMHRvJTIwcGFzcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHN0b3Bfc3RyaW5ncyUzRCU1QiUyMlRleGFzJTIyJTVEJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX291dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The biggest states in the USA by land area:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas
- California

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Passing one or more stop strings will halt generation after those strings are emitted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that generating with stop strings requires you to pass the tokenizer too</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, stop_strings=[<span class="hljs-string">&quot;Texas&quot;</span>], tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function GC($){let i,j;return i=new U({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){m(i.$$.fragment)},l(_){g(i.$$.fragment,_)},m(_,d){h(i,_,d),j=!0},p:J,i(_){j||(u(i.$$.fragment,_),j=!0)},o(_){f(i.$$.fragment,_),j=!1},d(_){b(i,_)}}}function FC($){let i,j="The API for the streamer classes is still under development and may change in the future.";return{c(){i=o("p"),i.textContent=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function XC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function RC($){let i,j="The API for the streamer classes is still under development and may change in the future.";return{c(){i=o("p"),i.textContent=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function LC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function NC($){let i,j="The API for the streamer classes is still under development and may change in the future.";return{c(){i=o("p"),i.textContent=j},l(_){i=l(_,"P",{"data-svelte-h":!0}),y(i)!=="svelte-gv2g1g"&&(i.textContent=j)},m(_,d){p(_,i,d)},p:J,d(_){_&&n(i)}}}function SC($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEFzeW5jVGV4dEl0ZXJhdG9yU3RyZWFtZXIlMEFmcm9tJTIwdGhyZWFkaW5nJTIwaW1wb3J0JTIwVGhyZWFkJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBYXN5bmMlMjBkZWYlMjBtYWluKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBJbXBvcnRhbnQlM0ElMjBBc3luY1RleHRJdGVyYXRvclN0cmVhbWVyJTIwbXVzdCUyMGJlJTIwaW5pdGlhbGl6ZWQlMjBpbnNpZGUlMjBhJTIwY29yb3V0aW5lISUwQSUyMCUyMCUyMCUyMHN0cmVhbWVyJTIwJTNEJTIwQXN5bmNUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQSUyMCUyMCUyMCUyMHRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQSUyMCUyMCUyMCUyMHRocmVhZC5zdGFydCgpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjBhc3luYyUyMGZvciUyMG5ld190ZXh0JTIwaW4lMjBzdHJlYW1lciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRlZF90ZXh0JTIwJTJCJTNEJTIwbmV3X3RleHQlMEElMjAlMjAlMjAlMjBwcmludChnZW5lcmF0ZWRfdGV4dCklMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, AsyncTextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Important: AsyncTextIteratorStreamer must be initialized inside a coroutine!</span>
<span class="hljs-meta">... </span>    streamer = AsyncTextIteratorStreamer(tok)
<span class="hljs-meta">... </span>    generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">... </span>    thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">... </span>    thread.start()
<span class="hljs-meta">... </span>    generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>        generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-meta">&gt;&gt;&gt; </span>asyncio.run(main())
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function EC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMER5bmFtaWNDYWNoZSgpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
DynamicCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function HC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMHF1YW50byUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBRdWFudG9RdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0KSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFF1YW50b1F1YW50aXplZENhY2hlKGNhY2hlX2NvbmZpZyUzRGNhY2hlX2NvbmZpZyklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install quanto first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, QuantoQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = QuantoQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
QuantoQuantizedCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function qC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMGhxcSUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBIUVFRdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0JTJDJTIwYXhpc19rZXklM0QxJTJDJTIwYXhpc192YWx1ZSUzRDEpJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSFFRUXVhbnRpemVkQ2FjaGUoY2FjaGVfY29uZmlnJTNEY2FjaGVfY29uZmlnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install hqq first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HQQQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>, axis_key=<span class="hljs-number">1</span>, axis_value=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HQQQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HQQQuantizedCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function QC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNpbmtDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNpbmtDYWNoZSh3aW5kb3dfbGVuZ3RoJTNEMjU2JTJDJTIwbnVtX3NpbmtfdG9rZW5zJTNENCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SinkCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function DC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBMbGFtYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU3RhdGljQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwbWF4X2JhdGNoX3NpemUlM0QxJTJDJTIwbWF4X2NhY2hlX2xlbiUzRG1heF9nZW5lcmF0ZWRfbGVuZ3RoJTJDJTIwZGV2aWNlJTNEbW9kZWwuZGV2aWNlJTJDJTIwZHR5cGUlM0Rtb2RlbC5kdHlwZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Llama&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = StaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
StaticCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function YC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyME9mZmxvYWRlZFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMEdQVDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME9mZmxvYWRlZFN0YXRpY0NhY2hlKGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMG1heF9iYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFwYXN0X2t2X2xlbmd0aCUyMCUzRCUyMG91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, OffloadedStaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is GPT2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = OffloadedStaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_kv_length = outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function PC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEh5YnJpZENhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMi0yYiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTJiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBHZW1tYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSHlicmlkQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwbWF4X2JhdGNoX3NpemUlM0QxJTJDJTIwbWF4X2NhY2hlX2xlbiUzRG1heF9nZW5lcmF0ZWRfbGVuZ3RoJTJDJTIwZGV2aWNlJTNEbW9kZWwuZGV2aWNlJTJDJTIwZHR5cGUlM0Rtb2RlbC5kdHlwZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HybridCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Gemma&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HybridCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HybridCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function AC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNsaWRpbmdXaW5kb3dDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjMlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyME1pc3RyYWwlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNsaWRpbmdXaW5kb3dDYWNoZShjb25maWclM0Rtb2RlbC5jb25maWclMkMlMjBtYXhfYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SlidingWindowCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mistral&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SlidingWindowCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SlidingWindowCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function OC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUyQyUyMEVuY29kZXJEZWNvZGVyQ2FjaGUlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTNEWU9VUi1BVURJTyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGNhY2hlJTIwY2xhc3NlcyUyMGZvciUyMGVuY29kZXIlMjBhbmQlMjBkZWNvZGVyJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXNlbGZfYXR0ZW50aW9uX2NhY2hlJTIwJTNEJTIwRHluYW1pY0NhY2hlKCklMEFjcm9zc19hdHRlbnRpb25fY2FjaGUlMjAlM0QlMjBEeW5hbWljQ2FjaGUoKSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMEVuY29kZXJEZWNvZGVyQ2FjaGUoc2VsZl9hdHRlbnRpb25fY2FjaGUlMkMlMjBjcm9zc19hdHRlbnRpb25fY2FjaGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForCausalLM, DynamicCache, EncoderDecoderCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=YOUR-AUDIO, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare cache classes for encoder and decoder and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>self_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>cross_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = EncoderDecoderCache(self_attention_cache, cross_attention_cache)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
EncoderDecoderCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function KC($){let i,j="Example:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYUZvckNhdXNhbExNJTJDJTIwTWFtYmFDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBNYW1iYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME1hbWJhQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwbWF4X2JhdGNoX3NpemUlM0QxJTJDJTIwZGV2aWNlJTNEbW9kZWwuZGV2aWNlJTJDJTIwZHR5cGUlM0Rtb2RlbC5kdHlwZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForCausalLM, MambaCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mamba&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = MambaCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values
MambaCache()`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11lpom8"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function eW($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvay5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2suZW9zX3Rva2VuX2lkJTBBdG9rLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMmxlZnQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjBhJTIwbG9uZyUyMHN0b3J5JTIyJTJDJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjBhcmUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfbGVuJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMEElMEElMjMlMjBmaXJzdCUyMGdlbmVyYXRlJTIwdGV4dCUyMHdpdGglMjB3YXRlcm1hcmslMjBhbmQlMjB3aXRob3V0JTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFdhdGVybWFya2luZ0NvbmZpZyhiaWFzJTNEMi41JTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjBub3clMjB3ZSUyMGNhbiUyMGluc3RhbnRpYXRlJTIwdGhlJTIwZGV0ZWN0b3IlMjBhbmQlMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMEFkZXRlY3RvciUyMCUzRCUyMFdhdGVybWFya0RldGVjdG9yKG1vZGVsX2NvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMGRldmljZSUzRCUyMmNwdSUyMiUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnKSUwQWRldGVjdGlvbl9vdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3RvcihvdXRfd2F0ZXJtYXJrZWQlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0X3dhdGVybWFya2VkLnByZWRpY3Rpb24lMEElMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># first generate text with watermark and without</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_watermarked = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now we can instantiate the detector and check the generated text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked = detector(out_watermarked, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">False</span>,  <span class="hljs-literal">False</span>])`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function tW($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function sW($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTIwQmF5ZXNpYW5EZXRlY3Rvck1vZGVsJTJDJTIwU3ludGhJRFRleHRXYXRlcm1hcmtMb2dpdHNQcm9jZXNzb3IlMkMlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yJTBBKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBkZXRlY3Rvci4lMjBTZWUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy1yZXNlYXJjaC1wcm9qZWN0cyUyRnRyZWUlMkZtYWluJTJGc3ludGhpZF90ZXh0JTIwZm9yJTIwdHJhaW5pbmclMjBhJTIwZGV0ZWN0b3IuJTBBZGV0ZWN0b3JfbW9kZWwlMjAlM0QlMjBCYXllc2lhbkRldGVjdG9yTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmpvYW9nYW50ZSUyRmR1bW15X3N5bnRoaWRfZGV0ZWN0b3IlMjIpJTBBbG9naXRzX3Byb2Nlc3NvciUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJrTG9naXRzUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCoqZGV0ZWN0b3JfbW9kZWwuY29uZmlnLndhdGVybWFya2luZ19jb25maWclMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoZGV0ZWN0b3JfbW9kZWwuY29uZmlnLm1vZGVsX25hbWUpJTBBZGV0ZWN0b3IlMjAlM0QlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yKGRldGVjdG9yX21vZGVsJTJDJTIwbG9naXRzX3Byb2Nlc3NvciUyQyUyMHRva2VuaXplciklMEElMEElMjMlMjBUZXN0JTIwd2hldGhlciUyMGElMjBjZXJ0YWluJTIwc3RyaW5nJTIwaXMlMjB3YXRlcm1hcmtlZCUwQXRlc3RfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjBpbnB1dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaXNfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3Rvcih0ZXN0X2lucHV0LmlucHV0X2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer, BayesianDetectorModel, SynthIDTextWatermarkLogitsProcessor, SynthIDTextWatermarkDetector
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the detector. See https://github.com/huggingface/transformers-research-projects/tree/main/synthid_text for training a detector.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector_model = BayesianDetectorModel.from_pretrained(<span class="hljs-string">&quot;joaogante/dummy_synthid_detector&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = SynthIDTextWatermarkLogitsProcessor(
<span class="hljs-meta">... </span>    **detector_model.config.watermarking_config, device=<span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(detector_model.config.model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = SynthIDTextWatermarkDetector(detector_model, logits_processor, tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Test whether a certain string is watermarked</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_input = tokenizer([<span class="hljs-string">&quot;This is a test input&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>is_watermarked = detector(test_input.input_ids)`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function nW($){let i,j="Examples:",_,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMENvbXBpbGVDb25maWclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInKS5jdWRhKCklMEElMEElMjMlMjBBdXRvbWF0aWMlMjBjb21waWxlJTIwY29uZmlndXJhdGlvbiUyQyUyMHVzZWQlMjB3aXRoJTIwc3RhdGljJTIwY2FjaGUlMEFjb21waWxlX2NvbmZpZyUyMCUzRCUyMENvbXBpbGVDb25maWcoZHluYW1pYyUzRFRydWUpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjBzdGF0aWMlMjBjYWNoZSUyMGFuZCUyMGNvbXBpbGUlMjBjb25maWclMEFpbnB1dCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGVyZSUyQyUyMGhvdyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmN1ZGEoKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyJTJDJTIwY29tcGlsZV9jb25maWclM0Rjb21waWxlX2NvbmZpZyUwQSklMEFvdXRwdXRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, CompileConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>).cuda()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Automatic compile configuration, used with static cache</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compile_config = CompileConfig(dynamic=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with static cache and compile config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = tokenizer.encode(<span class="hljs-string">&quot;Hello there, how&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).cuda()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span>, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">300</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>, compile_config=compile_config
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_text = tokenizer.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=o("p"),i.textContent=j,_=a(),m(d.$$.fragment)},l(s){i=l(s,"P",{"data-svelte-h":!0}),y(i)!=="svelte-kvfsh7"&&(i.textContent=j),_=r(s),g(d.$$.fragment,s)},m(s,k){p(s,i,k),p(s,_,k),h(d,s,k),w=!0},p:J,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(i),n(_)),b(d,s)}}}function aW($){let i,j,_,d,w,s,k,_$='This page lists all the utility functions used by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',sb,qa,nb,Qa,y$=`The output of <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,ab,Da,T$="Here’s an example:",rb,Ya,ob,Pa,M$=`The <code>generation_output</code> object is a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,lb,Aa,v$="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",ib,Oa,w$=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,cb,Ka,k$=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,db,er,j$=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,pb,tr,mb,sr,$$="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",gb,nr,J$=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,hb,ar,x$="We document here all output types.",ub,rr,fb,us,or,GT,ud,U$="Outputs of decoder-only generation models, when using non-beam methods.",bb,fs,lr,FT,fd,Z$="Outputs of encoder-decoder generation models, when using non-beam methods.",_b,bs,ir,XT,bd,C$="Outputs of decoder-only generation models, when using beam methods.",yb,_s,cr,RT,_d,W$="Outputs of encoder-decoder generation models, when using beam methods.",Tb,dr,Mb,ys,pr,LT,yd,I$=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,vb,Ts,mr,NT,Td,B$="Base class for outputs of decoder-only generation models using greedy search.",wb,Ms,gr,ST,Md,z$=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,kb,vs,hr,ET,vd,V$="Base class for outputs of decoder-only generation models using sampling.",jb,ws,ur,HT,wd,G$=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,$b,ks,fr,qT,kd,F$="Base class for outputs of decoder-only generation models using beam search.",Jb,js,br,QT,jd,X$=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,xb,$s,_r,DT,$d,R$="Base class for outputs of decoder-only generation models using beam sample.",Ub,Js,yr,YT,Jd,L$=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Zb,xs,Tr,PT,xd,N$="Base class for outputs of decoder-only generation models using contrastive search.",Cb,Mr,Wb,nt,vr,AT,Ud,S$="Flax Base class for outputs of decoder-only generation models using sampling.",OT,Fs,wr,KT,Zd,E$="“Returns a new object replacing the specified fields with new values.",Ib,at,kr,eM,Cd,H$="Flax Base class for outputs of decoder-only generation models using greedy search.",tM,Xs,jr,sM,Wd,q$="“Returns a new object replacing the specified fields with new values.",Bb,rt,$r,nM,Id,Q$="Flax Base class for outputs of decoder-only generation models using greedy search.",aM,Rs,Jr,rM,Bd,D$="“Returns a new object replacing the specified fields with new values.",zb,xr,Vb,Ur,Y$=`A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,Gb,Zr,Fb,je,Cr,oM,zd,P$='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',lM,Ls,iM,Vd,Wr,Xb,N,Ir,cM,Gd,A$=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,dM,Fd,O$='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',pM,Ns,mM,Ss,gM,Xd,Br,Rb,ae,zr,hM,Rd,K$=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,uM,Ld,e0=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,fM,Es,bM,Nd,Vr,Lb,re,Gr,_M,Sd,t0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,yM,Ed,s0=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,TM,Hs,MM,Hd,Fr,Nb,$e,Xr,vM,qd,n0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,wM,qs,kM,Qd,Rr,Sb,Je,Lr,jM,Dd,a0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsProcessor</code> to work.`,$M,Qs,JM,Yd,Nr,Eb,xe,Sr,xM,Pd,r0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,UM,Ds,ZM,Ad,Er,Hb,Ue,Hr,CM,Od,o0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,WM,Ys,IM,Kd,qr,qb,Ze,Qr,BM,ep,l0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',zM,Ps,VM,tp,Dr,Qb,S,Yr,GM,sp,i0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',FM,np,c0=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,XM,ap,d0=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,RM,As,LM,rp,Pr,Db,Ce,Ar,NM,op,p0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,SM,lp,m0=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,EM,ip,Or,Yb,We,Kr,HM,cp,g0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,qM,Os,QM,dp,eo,Pb,ot,to,DM,pp,h0="Abstract base class for all logit processors that can be applied during generation.",YM,mp,so,Ab,lt,no,PM,gp,u0=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to the
inputs.`,AM,hp,ao,Ob,Ie,ro,OM,up,f0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,KM,Ks,ev,fp,oo,Kb,Be,lo,tv,bp,b0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,sv,en,nv,_p,io,e_,E,co,av,yp,_0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs min-p, i.e. keeps all tokens that are above a minimum probability, scaled by the
probability of the most likely token. As a result, the filter becomes more aggressive in the presence of
high-probability tokens, which is a sign of a confident output that we shouldn’t deviate from.`,rv,Tp,y0=`Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a>. Used as an alternative to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,ov,Mp,T0='Created by @menhguin and @kalomaze (github handles). Code adapted from <a href="https://github.com/oobabooga/text-generation-webui/pull/4449/files" rel="nofollow">this external PR</a>',lv,tn,iv,vp,po,t_,oe,mo,cv,wp,M0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',dv,sn,pv,nn,mv,kp,go,s_,le,ho,gv,jp,v0=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,hv,an,uv,rn,fv,$p,uo,n_,ze,fo,bv,Jp,w0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,_v,on,yv,xp,bo,a_,ie,_o,Tv,Up,k0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt
by default.`,Mv,Zp,j0=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,vv,ln,wv,Cp,yo,r_,ce,To,kv,Wp,$0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,jv,cn,$v,dn,Jv,Ip,Mo,o_,Ve,vo,xv,Bp,J0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the beginning. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,Uv,pn,Zv,zp,wo,l_,Ge,ko,Cv,Vp,x0=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,Wv,mn,Iv,Gp,jo,i_,F,$o,Bv,Fp,U0=`Logits processor that implements watermarking techniques for text generation models.
This class facilitates the application of SynthID text watermarking, a method for embedding imperceptible signals
into generated text to aid in detecting synthetic content. It operates by subtly manipulating the probabilities of
token selection during text generation in a manner that can be reliably recovered later for verification.`,zv,Xp,Z0="Key Features:",Vv,Rp,C0=`<li><p><strong>State Management:</strong> Maintains internal state to track token sequences and generate watermarking keys
dynamically.</p></li> <li><p><strong>Key Generation:</strong> Computes hashes based on token sequences and watermarking parameters to create unique keys
for each position.</p></li> <li><p><strong>G-Value Sampling:</strong> Employs a pre-computed sampling table to sample watermarking values (g-values) based on
the generated keys.</p></li> <li><p><strong>Score Adjustment:</strong> Applies calculated g-values to modify token probabilities during generation, embedding the
watermark.</p></li> <li><p><strong>Context Repetition Handling:</strong> Incorporates logic to avoid watermarking tokens in repeated contexts,
preserving naturalness.</p></li> <li><p><strong>EOS Token Masking:</strong> Supports masking end-of-sentence tokens to prevent their inclusion in watermarking
calculations.</p></li> <li><p><strong>Utility Functions:</strong> Provides functions to compute g-values directly, check for context repetition, create
EOS token masks, and estimate expected mean g-values.</p></li>`,Gv,Lp,W0='Refer to paper url: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a> for more details around this.',Fv,gn,Xv,Np,Jo,c_,de,xo,Rv,Sp,I0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,Lv,hn,Nv,un,Sv,Ep,Uo,d_,Fe,Zo,Ev,Hp,B0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used
together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,Hv,fn,qv,qp,Co,p_,Xe,Wo,Qv,Qp,z0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.
Often used together with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,Dv,bn,Yv,Dp,Io,m_,pe,Bo,Pv,Yp,V0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens
whose log probability is close to the entropy of the token probability distribution. This means that the most
likely tokens may be discarded in the process.`,Av,Pp,G0='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',Ov,_n,Kv,Ap,zo,g_,me,Vo,ew,Op,F0=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,tw,Kp,X0='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',sw,yn,nw,em,Go,h_,ge,Fo,aw,tm,R0=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,rw,sm,L0='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',ow,Tn,lw,nm,Xo,u_,H,Ro,iw,am,N0=`Logits processor for watermarking generated text. The processor modifies model output scores by adding a small bias to
randomized set of “green” tokens before generating the next token. “Green” tokens selection process depends on the
<code>seeding_scheme</code> used. The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,cw,rm,S0='The text generated by this <code>LogitsProcessor</code> can be detected using <code>WatermarkDetector</code>. See <a href="/docs/transformers/main/en/internal/generation_utils#transformers.WatermarkDetector.__call__"><strong>call</strong>()</a> for details,',dw,om,E0='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',pw,Mn,mw,lm,Lo,f_,No,b_,it,So,gw,im,H0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',hw,cm,Eo,__,ct,Ho,uw,dm,q0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',fw,pm,qo,y_,dt,Qo,bw,mm,Q0=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,_w,gm,Do,T_,pt,Yo,yw,hm,D0="Abstract base class for all logit processors that can be applied during generation.",Tw,vn,Po,Mw,um,Y0="TF method for processing logits.",M_,mt,Ao,vw,fm,P0=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,ww,bm,Oo,v_,gt,Ko,kw,_m,A0="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",jw,wn,el,$w,ym,O0="TF method for warping logits.",w_,ht,tl,Jw,Tm,K0='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',xw,Mm,sl,k_,ut,nl,Uw,vm,eJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Zw,wm,al,j_,ft,rl,Cw,km,tJ=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Ww,jm,ol,$_,bt,ll,Iw,$m,sJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',Bw,Jm,il,J_,_t,cl,zw,xm,nJ=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the beginning of the generation.`,Vw,Um,dl,x_,yt,pl,Gw,Zm,aJ=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,Fw,Cm,ml,U_,Tt,gl,Xw,Wm,rJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Rw,Im,hl,Z_,Mt,ul,Lw,Bm,oJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Nw,zm,fl,C_,vt,bl,Sw,Vm,lJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',Ew,Gm,_l,W_,yl,I_,wt,Tl,Hw,Fm,iJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',qw,Xm,Ml,B_,kt,vl,Qw,Rm,cJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Dw,Lm,wl,z_,jt,kl,Yw,Nm,dJ=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,Pw,Sm,jl,V_,$t,$l,Aw,Em,pJ="Abstract base class for all logit processors that can be applied during generation.",Ow,kn,Jl,Kw,Hm,mJ="Flax method for processing logits.",G_,Jt,xl,e2,qm,gJ=`This class can be used to create a list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,t2,Qm,Ul,F_,xt,Zl,s2,Dm,hJ="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",n2,jn,Cl,a2,Ym,uJ="Flax method for warping logits.",X_,Ut,Wl,r2,Pm,fJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',o2,Am,Il,R_,Zt,Bl,l2,Om,bJ=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
beginning of the generation.`,i2,Km,zl,L_,Ct,Vl,c2,eg,_J=`<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,d2,tg,Gl,N_,Wt,Fl,p2,sg,yJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',m2,ng,Xl,S_,It,Rl,g2,ag,TJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',h2,rg,Ll,E_,Bt,Nl,u2,og,MJ='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',f2,lg,Sl,H_,zt,El,b2,ig,vJ=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,_2,cg,Hl,q_,ql,Q_,Ql,wJ='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',D_,Re,Dl,y2,dg,kJ="Abstract base class for all stopping criteria that can be applied during generation.",T2,pg,jJ="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",M2,mg,Yl,Y_,Us,Pl,v2,gg,Al,P_,Vt,Ol,w2,hg,$J=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,k2,ug,Kl,A_,Gt,ei,j2,fg,JJ=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,$2,bg,ti,O_,x,si,J2,_g,xJ=`This class can be used to stop generation whenever specific string sequences are generated. It preprocesses
the strings together with the tokenizer vocab to find positions where tokens can validly complete the stop strings.`,x2,yg,UJ=`Generation is stopped as soon as a token is generated that completes any of the stop strings.
We want to catch any instance in which the stop string would be present in the decoded output, which means
we must also catch cases with “overhangs” off one or both ends. To make this more concrete, for the stop string
“stop”, any of the following token sequences would trigger the match:`,U2,Tg,ZJ="<li>[“st”, “op”]</li> <li>[“stop”]</li> <li>[“st”, “opera”]</li> <li>[“sto”, “pper”]</li> <li>[“las”, “topper”]</li> <li>[“s”, “to”, “pped”]</li>",Z2,Mg,CJ=`Note that a match will only be triggered if the stop string is at the end of the generated sequence. In other
words, these sequences will not trigger a match:`,C2,vg,WJ="<li>[“stop”, “at”]</li> <li>[“st”, “op”, “at”]</li> <li>[“st”, “opera”, “tion”]</li>",W2,wg,IJ=`The reason these are not a match is that the stop string does not overlap with the final token. If you can remove
one or more tokens from the end of the sequence without destroying the stop string, then this criterion will not
match that stop string. This is by design; because this check is run after each token is generated, we can’t miss a
valid stop string if one is generated, but we don’t want to halt generation just because the stop string exists
somewhere in the past input_ids.`,I2,kg,BJ=`How is the match actually performed, though? We do it in quite a confusing way, because we want the entire match
process to be compilable with Torch or XLA, which means we cannot use standard string methods. However, it is possible,
with some work, to do string matching with pure tensor operations. We’ll begin by describing the algorithm we use
with standard string operations, and then at the end we’ll explain how this is converted to pure tensor operations.`,B2,jg,zJ=`The key to the algorithm is an observation: Because the stop string must overlap with the end of the token sequence, we can start at
the end of the sequence and work backwards. Specifically, we check that there is an overlap between the start of
the final token and the end of the stop_string, or to put it another way, stop_string[-i:] == token[:i] for
some i > 0. If you look at the positive examples above, you’ll see the last token in all of them fulfills this
property:`,z2,$g,VJ="<li>[“st”, “op”] (overlap is “op”, overlap length == 2)</li> <li>[“stop”]  (overlap is “stop”, overlap length == 4)</li> <li>[“st”, “opera”]  (overlap is “op”, overlap length == 2)</li> <li>[“sto”, “pper”]  (overlap is “p”, overlap length == 1)</li> <li>[“las”, “topper”]  (overlap is “top”, overlap length == 3)</li> <li>[“s”, “to”, “pped”]  (overlap is “p”, overlap length == 1)</li>",V2,Jg,GJ=`It’s impossible to construct a matching sequence that does not have this property (feel free to verify this
yourself). However, although this overlap between the start of the final token and the end of the stop string is
necessary for a match, it is not sufficient. We also need to check that the rest of the token sequence is
consistent with the stop string.`,G2,xg,FJ=`How do we do that? Let’s use [“s”, “to”, “pped”] as an example. We know that the final token, “pped”, has an
overlap of 1 with the stop string, “stop”. We then go back to the previous token, “to”. Since we have already
matched 1 character from the stop string, the remainder to check is “sto”. We check that the next token “to”
matches the end of the remainder, which it does. We have now matched 3 characters from the stop string, and the
remainder to match is “s”. We go back to the previous token again, which is also “s”. This is a match, and so
we have matched the entire stop string.`,F2,Ug,XJ=`How does it work when the tokens run off the start of the stop string, though? Let’s consider the example of
[“las”, “topper”]. The final token, “topper”, has an overlap of 3 with the stop string, “stop”. Therefore,
the remaining stop string to match is “s”. We go back to the previous token, “las”. Because the remainder to
match is just “s”, with length 1, we consider only the final 1 character from the token, which is “s”. This
matches the stop string, and so the entire string is matched.`,X2,Zg,RJ=`How do we compute these matches with tensor operations, though? Simply: we efficiently precompute the necessary
information for all tokens! For every token, we compute:`,R2,Cg,LJ="<li>Its overlap with the end of the stop string, if any</li> <li>The positions inside the stop string where the token matches, including matches that run off the start.</li> <li>The total length of the token</li>",L2,Wg,NJ=`For example, for the token “pped”, we would compute an end overlap of 1, no internal matching positions,
and a length of 4. For the token “to”, we would compute no end overlap, a single internal matching position
of 1 (counting from the end), and a length of 2. For the token “s”, we would compute no end overlap,
a single internal matching position of 3 (again counting from the end) and a length of 1.`,N2,Ig,SJ=`As long as we have this information, we can execute the algorithm above without any string comparison
operations. We simply perform the following steps:`,S2,Bg,EJ="<li>Check if the final token has an end-overlap with the start string</li> <li>Continue backwards, keeping track of how much of the stop string we’ve matched so far</li> <li>At each point, check if the next token has the current position as one of its valid positions</li> <li>Continue until either a match fails, or we completely match the whole stop string</li>",E2,zg,HJ=`Again, consider [“s”, “to”, “pped”] as an example. “pped” has an end overlap of 1, so we can begin a match.
We have matched 1 character so far, so we check that the next token “to”, has 1 as a valid position (again,
counting from the end). It does, so we add the length of “to” to our position tracker. We have now matched
3 characters, so we check that the next token “s” has 3 as a valid position. It does, so we add its length
to the position tracker. The position tracker is now 4, which is the length of the stop string. We have matched the
entire stop string.`,H2,Vg,qJ=`In the second case, [“las”, “topper”], “topper” has an end overlap of 3, so we can begin a match. We have
matched 3 characters so far, so we check that the next token “las” has 3 as a valid position. It does, because we
allow tokens to match positions that run off the start of the stop string. We add its length to the position
tracker. The position tracker is now 6, which is greater than the length of the stop string! Don’t panic, though -
this also counts as a match of the stop string. We have matched the entire stop string.`,q2,$n,Q2,Gg,ni,K_,Ft,ai,D2,Fg,QJ=`This class can be used to stop generation whenever the “end-of-sequence” token is generated.
By default, it uses the <code>model.generation_config.eos_token_id</code>.`,Y2,Xg,ri,ey,oi,ty,li,DJ='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',sy,W,ii,P2,Rg,YJ=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,A2,Lg,PJ="All classes that inherit Constraint must follow the requirement that",O2,Jn,K2,Ng,AJ="will always terminate (halt).",ek,xn,ci,tk,Sg,OJ="When called, returns the token(s) that would take this constraint one step closer to being fulfilled.",sk,Un,di,nk,Eg,KJ="Creates a new instance of this constraint.",ak,Zn,pi,rk,Hg,ex="Reads in a token and returns whether it creates progress.",ok,Cn,mi,lk,qg,tx="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",ik,Wn,gi,ck,Qg,sx=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,dk,In,hi,pk,Dg,nx="Tests whether this constraint has been properly defined.",mk,ss,ui,gk,Yg,ax=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,hk,Pg,rx=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,ny,Zs,fi,uk,Ag,ox='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',ay,Cs,bi,fk,Og,lx='A special <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',ry,Le,_i,bk,Kg,ix="A class for beam scorers to track its progress through a list of constraints.",_k,K,yi,yk,eh,cx=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,Tk,th,dx=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,Mk,sh,px="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",vk,nh,mx=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,wk,ah,gx=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,kk,Bn,Ti,jk,rh,hx="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",oy,Mi,ly,Ne,vi,$k,oh,ux=`Abstract base class for all beam scorers that are used for <code>~PreTrainedModel.beam_search</code> and
<code>~PreTrainedModel.beam_sample</code>.`,Jk,lh,wi,xk,ih,ki,iy,q,ji,Uk,ch,fx='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',Zk,dh,bx=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,Ck,ph,_x=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,Wk,mh,$i,Ik,gh,Ji,cy,Se,xi,Bk,hh,yx='<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',zk,uh,Ui,Vk,fh,Zi,dy,Ci,py,X,Wi,Gk,bh,Tx="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",Fk,zn,Xk,Vn,Rk,Gn,Ii,Lk,_h,Mx="Flushes any remaining cache and prints a newline to stdout.",Nk,Fn,Bi,Sk,yh,vx="Prints the new text to stdout. If the stream is ending, also prints a newline.",Ek,Xn,zi,Hk,Th,wx="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",my,he,Vi,qk,Mh,kx=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from accessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Qk,Rn,Dk,Ln,Yk,Nn,Gi,Pk,vh,jx="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",gy,ue,Fi,Ak,wh,$x=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an async iterator.
This is useful for applications that benefit from accessing the generated text asynchronously (e.g. in an
interactive Gradio demo).`,Ok,Sn,Kk,En,e1,Hn,Xi,t1,kh,Jx="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",hy,Ri,uy,Xt,Li,s1,jh,xx="Base, abstract class for all caches. The actual data structure is specific to each subclass.",n1,qn,Ni,a1,$h,Ux="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",fy,Rt,Si,r1,Jh,Zx="Base class for cache configs",o1,Qn,Ei,l1,xh,Cx=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,by,Lt,Hi,i1,Uh,Wx="Configuration class for quantized cache settings.",c1,Dn,qi,d1,Zh,Ix="Validates if the arguments passed are correct",_y,B,Qi,p1,Ch,Bx="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",m1,Wh,zx=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,g1,Yn,h1,Pn,Di,u1,Ih,Vx="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",f1,An,Yi,b1,Bh,Gx="Returns the sequence length of the cached states. A layer index can be optionally passed.",_1,On,Pi,y1,zh,Fx="Reorders the cache for beam search, given the selected beam indices.",T1,Kn,Ai,M1,Vh,Xx=`Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format. Used for
backward compatibility.`,v1,ea,Oi,w1,Gh,Rx=`Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>. Used for
backward compatibility.`,yy,Q,Ki,k1,Fh,Lx=`A quantizer cache similar to what is described in the <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache paper</a>.
It allows the model to generate longer sequence length without allocating too much memory for Key and Value cache by applying quantization.`,j1,Xh,Nx=`The cache has two types of storage, one for original precision and one for the quantized cache. A <code>residual length</code> is set as a maximum capacity for the
original precision cache. When the length goes beyond maximum capacity, the original precision cache is discarded and moved into the quantized cache. The
quantization is done per-channel with a set <code>q_group_size</code> for both Keys and Values, in contrast to what was described in the paper.`,$1,Rh,Sx=`It stores Keys and Values a list of quantized tensors (tuples in case we need to store metadata), one for each layer. Additionally, it stores the Key and
Value in original precision states as a list of tensors, one for each layer. The size of each tensor
is <code>[batch_size, num_heads, seq_len - residual_length, head_dim]</code>`,J1,Lh,ec,x1,ta,tc,U1,Nh,Ex="Returns the sequence length of the cached states. A layer index can be optionally passed.",Ty,Nt,sc,Z1,Sh,Hx="Quantized Cache class that uses <code>quanto</code> as a backend to perform quantization. Current implementation supports <code>int2</code> and <code>int4</code> dtypes only.",C1,sa,My,St,nc,W1,Eh,qx="Quantized Cache class that uses <code>HQQ</code> as a backend to perform quantization. Current implementation supports <code>int2</code>, <code>int4</code>, <code>int8</code> dtypes.",I1,na,vy,z,ac,B1,Hh,Qx="Deprecated.",z1,qh,Dx=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,V1,Qh,Yx=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,G1,aa,F1,ra,rc,X1,Dh,Px="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",R1,oa,oc,L1,Yh,Ax="Returns the sequence length of the cached states. A layer index can be optionally passed.",N1,la,lc,S1,Ph,Ox="Reorders the cache for beam search, given the selected beam indices.",wy,D,ic,E1,Ah,Kx=`A drop-in replacement for DynamicCache that conserves accelerator(GPU, XPU) memory at the expense of more CPU memory.
Useful for generating from models with very long context.`,H1,Oh,eU=`In addition to the default accelerator stream, where all forward() computations happen,
this class uses another stream, the prefetch stream, which it creates itself.
Since scheduling of operations on separate streams happens independently, this class uses
the prefetch stream to asynchronously prefetch the KV cache of layer k+1 when layer k is executing.
The movement of the layer k-1 cache to the CPU is handled by the default stream as a simple way to
ensure the eviction is scheduled after all computations on that cache are finished.`,q1,ia,cc,Q1,Kh,tU="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",D1,ca,dc,Y1,eu,sU="Starts prefetching the next layer cache",P1,da,pc,A1,tu,nU="Moves the previous layer cache to the CPU",ky,Y,mc,O1,su,aU="Static Cache class to be used with <code>torch.compile(model)</code> and <code>torch.export()</code>.",K1,pa,ej,ma,gc,tj,nu,rU=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,sj,ga,hc,nj,au,oU="Returns the sequence length of the cached states that were seen by the model.",aj,ha,uc,rj,ru,lU="Resets the cache values while preserving the objects",jy,P,fc,oj,ou,iU=`Static cache class to be used with <code>torch.compile(model)</code> that offloads to the CPU or
another device.`,lj,ua,ij,fa,bc,cj,lu,cU=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,dj,ba,_c,pj,iu,dU="Returns the sequence length of the cached states that were seen by the model.",mj,_a,yc,gj,cu,pU="Resets the cache values while preserving the objects.",$y,A,Tc,hj,du,mU=`Hybrid Cache class to be used with <code>torch.compile</code> for models that alternate between a local sliding window
attention and global attention in every other layer (originally implemented for Gemma2).
Under the hood, Hybrid Cache leverages [“SlidingWindowCache”] for sliding window attention and [“StaticCache”]
for global attention.For more information, see the documentation of each subcomponent cache class.`,uj,ya,fj,pu,Mc,bj,mu,vc,_j,Ta,wc,yj,gu,gU="Resets the cache values while preserving the objects",Jy,V,kc,Tj,hu,hU=`Sliding Window Cache class to be used with <code>torch.compile</code> for models like Mistral that support sliding window attention.
Every time when we try to update the cache, we compute the <code>indices</code> based on <code>cache_position &gt;= self.config.sliding_window - 1</code>,
if true(which means the cache can not hold all the old key value states and new states together because of the sliding window constraint),
we need to do a cycle shift based on <code>indices</code> to replace the oldest states by the new key value states passed in.`,Mj,uu,uU="The <code>to_shift</code> is only true once we are above sliding_window. Thus with <code>sliding_window==64</code>:",vj,fu,fU=`indices = (slicing + to_shift[-1].int()-1) % self.config.sliding_window
tensor([ 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63,  0])`,wj,bu,bU="We overwrite the cache using these, then we always write at cache_position (clamped to <code>sliding_window</code>)",kj,Ma,jj,_u,jc,$j,yu,$c,xy,G,Jc,Jj,Tu,_U=`Base, abstract class for all encoder-decoder caches. Can be used to hold combinations of self-attention and
cross-attention caches.`,xj,va,Uj,wa,xc,Zj,Mu,yU="Returns the sequence length of the cached states. A layer index can be optionally passed.",Cj,ka,Uc,Wj,vu,TU="Converts the <code>EncoderDecoderCache</code> instance into its equivalent in the legacy cache format.",Ij,ja,Zc,Bj,wu,MU="Converts a cache in the legacy cache format into an equivalent <code>EncoderDecoderCache</code>.",zj,ku,Cc,Vj,$a,Wc,Gj,ju,vU="Reorders the cache for beam search, given the selected beam indices.",Uy,O,Ic,Fj,$u,wU="Cache for mamba model which does not have attention mechanism and key value states.",Xj,Ja,Rj,Ju,Bc,Lj,xu,zc,Nj,Uu,Vc,Zy,Gc,Cy,fe,Fc,Sj,Zu,kU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,Ej,Cu,jU="Accepts the following keys:",Hj,Wu,$U=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,qj,xa,Xc,Qj,Iu,JU="Call self as a function.",Wy,be,Rc,Dj,Bu,xU=`Detector for detection of watermark generated text. The detector needs to be given the exact same settings that were
given during text generation to replicate the watermark greenlist generation and so detect the watermark. This includes
the correct device that was used during text generation, the correct watermarking arguments and the correct tokenizer vocab size.
The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Yj,zu,UU='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',Pj,Ua,Aj,Za,Lc,Oj,Vu,ZU="ma",Iy,Et,Nc,Kj,Gu,CU=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>. It is used to
instantiate a Bayesian Detector model according to the specified arguments.`,e$,Fu,WU=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,By,R,Sc,t$,Xu,IU="Bayesian classifier for watermark detection.",s$,Ru,BU=`This detector uses Bayes’ rule to compute a watermarking score, which is the sigmoid of the log of ratio of the
posterior probabilities P(watermarked|g_values) and P(unwatermarked|g_values). Please see the section on
BayesianScore in the paper for further details.
Paper URL: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a>`,n$,Lu,zU=`Note that this detector only works with non-distortionary Tournament-based watermarking using the Bernoulli(0.5)
g-value distribution.`,a$,Nu,VU=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,r$,Su,GU=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,o$,Ca,Ec,l$,Eu,FU="Computes the watermarked posterior P(watermarked|g_values).",zy,Ht,Hc,i$,Hu,XU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">this paper</a> for more details on the arguments.`,c$,Wa,Vy,_e,qc,d$,qu,RU="SynthID text watermark detector class.",p$,Qu,LU=`This class has to be initialized with the trained bayesian detector module check script
in examples/synthid_text/detector_training.py for example in training/saving/loading this
detector module. The folder also showcases example use case of this detector.`,m$,Ia,g$,Du,Qc,Gy,Dc,Fy,Ee,Yc,h$,Yu,NU=`Class that holds arguments relative to <code>torch.compile</code> behavior, when using automatic compilation in <code>generate</code>.
See <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> for more details on the arguments.`,u$,Ba,f$,za,Pc,b$,Pu,SU="Call self as a function.",Xy,Ac,Ry,Gf,Ly;return w=new ne({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),qa=new ne({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Ya=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),tr=new U({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),rr=new ne({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),or=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L134"}}),lr=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L170"}}),ir=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L218"}}),cr=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L262"}}),dr=new ne({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),pr=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L85"}}),mr=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L57"}}),gr=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L155"}}),hr=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L127"}}),ur=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L232"}}),fr=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L197"}}),br=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L317"}}),_r=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L282"}}),yr=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L393"}}),Tr=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L366"}}),Mr=new ne({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),vr=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": typing.Optional[jax.Array] = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L69"}}),wr=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),kr=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": typing.Optional[jax.Array] = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L55"}}),jr=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),$r=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": typing.Optional[jax.Array] = None"},{name:"scores",val:": typing.Optional[jax.Array] = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L83"}}),Jr=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),xr=new ne({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Zr=new ne({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),Cr=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2142"}}),Ls=new Gs({props:{warning:!0,$$slots:{default:[sC]},$$scope:{ctx:$}}}),Wr=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2171"}}),Ir=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2078"}}),Ns=new Gs({props:{warning:!0,$$slots:{default:[nC]},$$scope:{ctx:$}}}),Ss=new Z({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[aC]},$$scope:{ctx:$}}}),Br=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zr=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L987"}}),Es=new Z({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[rC]},$$scope:{ctx:$}}}),Vr=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1036",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Gr=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L368"}}),Hs=new Z({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[oC]},$$scope:{ctx:$}}}),Fr=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L412",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xr=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L708"}}),qs=new Z({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[lC]},$$scope:{ctx:$}}}),Rr=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L763",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lr=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"},{anchor:"transformers.EtaLogitsWarper.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L777"}}),Qs=new Z({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[iC]},$$scope:{ctx:$}}}),Nr=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L846",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Sr=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1654"}}),Ds=new Z({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[cC]},$$scope:{ctx:$}}}),Er=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1740",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Hr=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1532"}}),Ys=new Z({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[dC]},$$scope:{ctx:$}}}),qr=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1567",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qr=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1577"}}),Ps=new Z({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[pC]},$$scope:{ctx:$}}}),Dr=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1623",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Yr=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1396"}}),As=new Z({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[mC]},$$scope:{ctx:$}}}),Pr=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1483",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ar=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1633"}}),Or=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1642",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Kr=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1755"}}),Os=new Z({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[gC]},$$scope:{ctx:$}}}),eo=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1786",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L45"}}),so=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),no=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L55"}}),ao=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L62",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ro=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L93"}}),Ks=new Z({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[hC]},$$scope:{ctx:$}}}),oo=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L154"}}),en=new Z({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[uC]},$$scope:{ctx:$}}}),io=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L214",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),co=new v({props:{name:"class transformers.MinPLogitsWarper",anchor:"transformers.MinPLogitsWarper",parameters:[{name:"min_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.MinPLogitsWarper.min_p",description:`<strong>min_p</strong> (<code>float</code>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.MinPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.MinPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L543"}}),tn=new Z({props:{anchor:"transformers.MinPLogitsWarper.example",$$slots:{default:[fC]},$$scope:{ctx:$}}}),po=new v({props:{name:"__call__",anchor:"transformers.MinPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L600"}}),mo=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>, <em>optional</em>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1233"}}),sn=new Gs({props:{$$slots:{default:[bC]},$$scope:{ctx:$}}}),nn=new Z({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[_C]},$$scope:{ctx:$}}}),go=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ho=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L928"}}),an=new Gs({props:{$$slots:{default:[yC]},$$scope:{ctx:$}}}),rn=new Z({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[TC]},$$scope:{ctx:$}}}),uo=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L975",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1324"}}),on=new Z({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[MC]},$$scope:{ctx:$}}}),bo=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1375",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_o=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"prompt_ignore_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.prompt_ignore_length",description:`<strong>prompt_ignore_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The original input ids sequence length, which if provided, will not be used in the penalty calculation.`,name:"prompt_ignore_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L292"}}),ln=new Z({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[vC]},$$scope:{ctx:$}}}),yo=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L354",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),To=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.List[typing.List[typing.Union[typing.List[int], float]]]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>List[List[Union[List[int], float]]]</code>) &#x2014;
List of lists that maps a sequence of tokens to its bias term (e.g. <code>[[[10, 45], -2.0], [[64], -7.5]]</code>). Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1056"}}),cn=new Gs({props:{$$slots:{default:[wC]},$$scope:{ctx:$}}}),dn=new Z({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[kC]},$$scope:{ctx:$}}}),Mo=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vo=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1792"}}),pn=new Z({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[jC]},$$scope:{ctx:$}}}),wo=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1834",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ko=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1845"}}),mn=new Z({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[$C]},$$scope:{ctx:$}}}),jo=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1877",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.SynthIDTextWatermarkLogitsProcessor",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"sampling_table_size",val:": int"},{name:"sampling_table_seed",val:": int"},{name:"context_history_size",val:": int"},{name:"device",val:": device"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Device to use.`,name:"device"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2525"}}),gn=new Z({props:{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.example",$$slots:{default:[JC]},$$scope:{ctx:$}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2663",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L226"}}),hn=new Gs({props:{$$slots:{default:[xC]},$$scope:{ctx:$}}}),un=new Z({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[UC]},$$scope:{ctx:$}}}),Uo=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L286",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zo=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L490"}}),fn=new Z({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[ZC]},$$scope:{ctx:$}}}),Co=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L534",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wo=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L423"}}),bn=new Z({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[CC]},$$scope:{ctx:$}}}),Io=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L474",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bo=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L620"}}),_n=new Z({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[WC]},$$scope:{ctx:$}}}),zo=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L684",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Vo=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2187"}}),yn=new Z({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[IC]},$$scope:{ctx:$}}}),Go=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2293"}}),Fo=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": typing.Optional[int] = None"},{name:"_detect_timestamp_from_logprob",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1885"}}),Tn=new Z({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[BC]},$$scope:{ctx:$}}}),Xo=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ro=new v({props:{name:"class transformers.WatermarkLogitsProcessor",anchor:"transformers.WatermarkLogitsProcessor",parameters:[{name:"vocab_size",val:""},{name:"device",val:""},{name:"greenlist_ratio",val:": float = 0.25"},{name:"bias",val:": float = 2.0"},{name:"hashing_key",val:": int = 15485863"},{name:"seeding_scheme",val:": str = 'lefthash'"},{name:"context_width",val:": int = 1"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>) &#x2014;
The model tokenizer&#x2019;s vocab_size. Used to calculate &#x201C;green&#x201D; tokens ratio.`,name:"vocab_size"},{anchor:"transformers.WatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device where model is allocated.`,name:"device"},{anchor:"transformers.WatermarkLogitsProcessor.greenlist_ratio",description:`<strong>greenlist_ratio</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 0.25) &#x2014;
The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.`,name:"greenlist_ratio"},{anchor:"transformers.WatermarkLogitsProcessor.bias",description:`<strong>bias</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 2.0) &#x2014;
The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Consider lowering the
<code>bias</code> if the text generation quality degrades. Recommended values are in the
range of [0.5, 2.0]. Defaults to 2.0.`,name:"bias"},{anchor:"transformers.WatermarkLogitsProcessor.hashing_key",description:`<strong>hashing_key</strong> (<code>int</code>, optional, <em>optional</em>, defaults to 15485863) &#x2014;
Key used for hashing. If you deploy this watermark, we advise using another private key.
Defaults to 15485863 (the millionth prime).`,name:"hashing_key"},{anchor:"transformers.WatermarkLogitsProcessor.seeding_scheme",description:`<strong>seeding_scheme</strong> (<code>str</code>, optional, <em>optional</em>, defaults to <code>&quot;lefthash&quot;</code>) &#x2014;
The seeding scheme used for selecting &#x201C;green&#x201D; tokens. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"seeding_scheme"},{anchor:"transformers.WatermarkLogitsProcessor.context_width",description:`<strong>context_width</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of previous tokens to use when setting the seed.`,name:"context_width"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2352"}}),Mn=new Z({props:{anchor:"transformers.WatermarkLogitsProcessor.example",$$slots:{default:[zC]},$$scope:{ctx:$}}}),Lo=new v({props:{name:"__call__",anchor:"transformers.WatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2474",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),No=new ne({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),So=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L448"}}),Eo=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L462"}}),Ho=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L478"}}),qo=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L495"}}),Qo=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L563"}}),Do=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L579"}}),Yo=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L53"}}),Po=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ao=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L75"}}),Oo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ko=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L64"}}),el=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),tl=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L202"}}),sl=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L228"}}),nl=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L288"}}),al=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L367"}}),rl=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L388"}}),ol=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L427"}}),ll=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L238"}}),il=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L280"}}),cl=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L511"}}),dl=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L522"}}),pl=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L541"}}),ml=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L548"}}),gl=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L98"}}),hl=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L113"}}),ul=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L118"}}),fl=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L138"}}),bl=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L146"}}),_l=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L170"}}),yl=new ne({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Tl=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L195"}}),Ml=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L207"}}),vl=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L217"}}),wl=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L232"}}),kl=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L316"}}),jl=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L338"}}),$l=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L51"}}),Jl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xl=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L73"}}),Ul=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zl=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L62"}}),Cl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wl=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L242"}}),Il=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L263"}}),Bl=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L272"}}),zl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L289"}}),Vl=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L297"}}),Gl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L310"}}),Fl=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L96"}}),Xl=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L111"}}),Rl=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L160"}}),Ll=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L180"}}),Nl=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L116"}}),Sl=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L140"}}),El=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L364"}}),Hl=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L398"}}),ql=new ne({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Dl=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L46"}}),Yl=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Pl=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L496"}}),Al=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L497",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ol=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L58"}}),Kl=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L74",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),ei=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L87"}}),ti=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L104",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),si=new v({props:{name:"class transformers.StopStringCriteria",anchor:"transformers.StopStringCriteria",parameters:[{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"stop_strings",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"transformers.StopStringCriteria.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The model&#x2019;s associated tokenizer (necessary to extract vocab and tokenize the termination sequences)`,name:"tokenizer"},{anchor:"transformers.StopStringCriteria.stop_strings",description:`<strong>stop_strings</strong> (<code>Union[str, List[str]]</code>) &#x2014;
A list of strings that should end generation. If a string is passed, it will be treated like a
list with a single element.`,name:"stop_strings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L110"}}),$n=new Z({props:{anchor:"transformers.StopStringCriteria.example",$$slots:{default:[VC]},$$scope:{ctx:$}}}),ni=new v({props:{name:"__call__",anchor:"transformers.StopStringCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StopStringCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StopStringCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StopStringCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L389",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),ai=new v({props:{name:"class transformers.EosTokenCriteria",anchor:"transformers.EosTokenCriteria",parameters:[{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L451"}}),ri=new v({props:{name:"__call__",anchor:"transformers.EosTokenCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EosTokenCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.EosTokenCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L468",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),oi=new ne({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),ii=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L5"}}),Jn=new Z({props:{anchor:"transformers.Constraint.example",$$slots:{default:[GC]},$$scope:{ctx:$}}}),ci=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>A single token ID (int) that advances the constraint, or</li>
<li>A list of token IDs that could advance the constraint</li>
<li>None if the constraint is completed or cannot be advanced</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids (Union[int, List[int], None])</p>
`}}),di=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],parametersDescription:[{anchor:"transformers.Constraint.copy.stateful(bool)",description:"<strong>stateful(<code>bool</code>)</strong> &#x2014; Whether to not only copy the constraint for new instance, but also its state.",name:"stateful(bool)"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),pi=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L63"}}),mi=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L107"}}),gi=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L97"}}),hi=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L24"}}),ui=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],parametersDescription:[{anchor:"transformers.Constraint.update.token_id(int)",description:`<strong>token_id(<code>int</code>)</strong> &#x2014;
The id of a newly generated token in the beam search.`,name:"token_id(int)"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),fi=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L132"}}),bi=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L264"}}),_i=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L354"}}),yi=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L386"}}),Ti=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L421"}}),Mi=new ne({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),vi=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L91"}}),wi=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>~PreTrainedModel.group_beam_search</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),ki=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),ji=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L123"}}),$i=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L215"}}),Ji=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L320"}}),xi=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L419"}}),Ui=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Zi=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L813"}}),Ci=new ne({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),Wi=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": 'AutoTokenizer'"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L41"}}),zn=new Gs({props:{warning:!0,$$slots:{default:[FC]},$$scope:{ctx:$}}}),Vn=new Z({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[XC]},$$scope:{ctx:$}}}),Ii=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L119"}}),Bi=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L133"}}),zi=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L85"}}),Vi=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": 'AutoTokenizer'"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L162"}}),Rn=new Gs({props:{warning:!0,$$slots:{default:[RC]},$$scope:{ctx:$}}}),Ln=new Z({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[LC]},$$scope:{ctx:$}}}),Gi=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L216"}}),Fi=new v({props:{name:"class transformers.AsyncTextIteratorStreamer",anchor:"transformers.AsyncTextIteratorStreamer",parameters:[{name:"tokenizer",val:": 'AutoTokenizer'"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.AsyncTextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.AsyncTextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.AsyncTextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.AsyncTextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L233",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>TimeoutError</code> — If token generation time exceeds timeout value.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>TimeoutError</code></p>
`}}),Sn=new Gs({props:{warning:!0,$$slots:{default:[NC]},$$scope:{ctx:$}}}),En=new Z({props:{anchor:"transformers.AsyncTextIteratorStreamer.example",$$slots:{default:[SC]},$$scope:{ctx:$}}}),Xi=new v({props:{name:"on_finalized_text",anchor:"transformers.AsyncTextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L296"}}),Ri=new ne({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),Li=new v({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L24"}}),Ni=new v({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L34",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Si=new v({props:{name:"class transformers.CacheConfig",anchor:"transformers.CacheConfig",parameters:[{name:"cache_implementation",val:": None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L102"}}),Ei=new v({props:{name:"update",anchor:"transformers.CacheConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CacheConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L176",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Hi=new v({props:{name:"class transformers.QuantizedCacheConfig",anchor:"transformers.QuantizedCacheConfig",parameters:[{name:"backend",val:": str = 'quanto'"},{name:"nbits",val:": typing.Optional[int] = 4"},{name:"axis_key",val:": typing.Optional[int] = 0"},{name:"axis_value",val:": typing.Optional[int] = 0"},{name:"q_group_size",val:": typing.Optional[int] = 64"},{name:"residual_length",val:": typing.Optional[int] = 128"},{name:"compute_dtype",val:": typing.Optional[torch.dtype] = torch.float16"},{name:"device",val:": typing.Optional[str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.QuantizedCacheConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quanto&quot;</code>) &#x2014;
Backend to use when performing quantization, Can be one of [<code>quanto</code>, <code>HQQ</code>]`,name:"backend"},{anchor:"transformers.QuantizedCacheConfig.nbits",description:`<strong>nbits</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits, can be 2 or 4 for the <code>quanto</code> backend and one of [1, 2, 3, 4, 8] for the <code>HQQ</code> backend. Defaults to 2.`,name:"nbits"},{anchor:"transformers.QuantizedCacheConfig.axis_key",description:`<strong>axis_key</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the key tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_key"},{anchor:"transformers.QuantizedCacheConfig.axis_value",description:`<strong>axis_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the value tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_value"},{anchor:"transformers.QuantizedCacheConfig.q_group_size",description:`<strong>q_group_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the quantization group, should be a divisor of the model&#x2019;s hidden dimension.
Defaults to 64.`,name:"q_group_size"},{anchor:"transformers.QuantizedCacheConfig.residual_length",description:`<strong>residual_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 128) &#x2014;
Length of the residual cache which will always be stored in original precision.
Defaults to 128.`,name:"residual_length"},{anchor:"transformers.QuantizedCacheConfig.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The default dtype used for computations in the model. Keys and Values will be cast to this dtype after dequantization.`,name:"compute_dtype"},{anchor:"transformers.QuantizedCacheConfig.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
Device on which to perform computations, should be same as the model&#x2019;s device.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L199"}}),qi=new v({props:{name:"validate",anchor:"transformers.QuantizedCacheConfig.validate",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L245"}}),Qi=new v({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[{name:"_distributed_cache_data",val:": typing.Optional[typing.Iterable] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L338"}}),Yn=new Z({props:{anchor:"transformers.DynamicCache.example",$$slots:{default:[EC]},$$scope:{ctx:$}}}),Di=new v({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L405",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Yi=new v({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L452"}}),Pi=new v({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L80"}}),Ai=new v({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L467"}}),Oi=new v({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor, torch.FloatTensor]]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L475"}}),Ki=new v({props:{name:"class transformers.QuantizedCache",anchor:"transformers.QuantizedCache",parameters:[{name:"cache_config",val:": QuantizedCacheConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L734"}}),ec=new v({props:{name:"update",anchor:"transformers.QuantizedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L763"}}),tc=new v({props:{name:"get_seq_length",anchor:"transformers.QuantizedCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L806"}}),sc=new v({props:{name:"class transformers.QuantoQuantizedCache",anchor:"transformers.QuantoQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.QuantoQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L824"}}),sa=new Z({props:{anchor:"transformers.QuantoQuantizedCache.example",$$slots:{default:[HC]},$$scope:{ctx:$}}}),nc=new v({props:{name:"class transformers.HQQQuantizedCache",anchor:"transformers.HQQQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.HQQQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L890"}}),na=new Z({props:{anchor:"transformers.HQQQuantizedCache.example",$$slots:{default:[qC]},$$scope:{ctx:$}}}),ac=new v({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L954"}}),aa=new Z({props:{anchor:"transformers.SinkCache.example",$$slots:{default:[QC]},$$scope:{ctx:$}}}),rc=new v({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1055",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),oc=new v({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1043"}}),lc=new v({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L80"}}),ic=new v({props:{name:"class transformers.OffloadedCache",anchor:"transformers.OffloadedCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L603"}}),cc=new v({props:{name:"update",anchor:"transformers.OffloadedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>OffloadedCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L687",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),dc=new v({props:{name:"prefetch_layer",anchor:"transformers.OffloadedCache.prefetch_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L634"}}),pc=new v({props:{name:"evict_previous_layer",anchor:"transformers.OffloadedCache.evict_previous_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L647"}}),mc=new v({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str, NoneType] = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.StaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used. If you are manually setting the batch size, make sure to take into account the
number of beams if you are running beam search`,name:"max_batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. If you&#x2019;re using more than 1 computation device, you
should pass the <code>layer_device_map</code> argument instead.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.StaticCache.layer_device_map",description:`<strong>layer_device_map</strong> (<code>Optional[Dict[int, Union[str, torch.device, int]]]]</code>, <em>optional</em>) &#x2014;
Mapping between the layers and its device. This is required when you are manually initializing the cache
and the model is split between different gpus. You can know which layers mapped to which device by
checking the associated device_map: <code>model.hf_device_map</code>.`,name:"layer_device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1152"}}),pa=new Z({props:{anchor:"transformers.StaticCache.example",$$slots:{default:[DC]},$$scope:{ctx:$}}}),gc=new v({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> needs the <code>cache_position</code> input
to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1240",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),hc=new v({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1290"}}),uc=new v({props:{name:"reset",anchor:"transformers.StaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1300"}}),fc=new v({props:{name:"class transformers.OffloadedStaticCache",anchor:"transformers.OffloadedStaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": typing.Optional[int]"},{name:"device",val:": typing.Union[str, torch.device]"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"},{name:"offload_device",val:": typing.Union[str, torch.device] = device(type='cpu')"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.config",description:`<strong>config</strong> (\`PretrainedConfig) &#x2014;
The configuration file defining the shape-related attributes required to initialize
the static cache.`,name:"config"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>) &#x2014;
The device on which the cache should be initialized. If you&#x2019;re using more than 1 computation device, you
should pass the <code>layer_device_map</code> argument instead.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
The default <code>dtype</code> to use when initializing the cache.`,name:"dtype"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>, defaults to <code>cpu</code>) &#x2014;
The device to offload to. Defaults to CPU.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.layer_device_map",description:`<strong>layer_device_map</strong> (<code>Dict[int, Union[str, torch.device, int]]</code>, <em>optional</em>) &#x2014;
Mapping between the layers and its device. This is required when you are manually initializing the cache
and the model is split between different gpus. You can know which layers mapped to which device by
checking the associated device_map: <code>model.hf_device_map</code>.`,name:"layer_device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2235"}}),ua=new Z({props:{anchor:"transformers.OffloadedStaticCache.example",$$slots:{default:[YC]},$$scope:{ctx:$}}}),bc=new v({props:{name:"update",anchor:"transformers.OffloadedStaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedStaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedStaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedStaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments for the cache subclass. The <code>OffloadedStaticCache</code> needs the
<code>cache_position</code> input to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2346",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),_c=new v({props:{name:"get_seq_length",anchor:"transformers.OffloadedStaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2429"}}),yc=new v({props:{name:"reset",anchor:"transformers.OffloadedStaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2440"}}),Tc=new v({props:{name:"class transformers.HybridCache",anchor:"transformers.HybridCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str, NoneType] = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.HybridCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.HybridCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"max_batch_size"},{anchor:"transformers.HybridCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.HybridCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. If you&#x2019;re using more than 1 computation device, you
should pass the <code>layer_device_map</code> argument instead.`,name:"device"},{anchor:"transformers.HybridCache.dtype",description:`<strong>dtype</strong> (torch.dtype, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.HybridCache.layer_device_map",description:`<strong>layer_device_map</strong> (<code>Optional[Dict[int, Union[str, torch.device, int]]]]</code>, <em>optional</em>) &#x2014;
Mapping between the layers and its device. This is required when you are manually initializing the cache
and the model is split between different gpus. You can know which layers mapped to which device by
checking the associated device_map: <code>model.hf_device_map</code>.`,name:"layer_device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1624"}}),ya=new Z({props:{anchor:"transformers.HybridCache.example",$$slots:{default:[PC]},$$scope:{ctx:$}}}),Mc=new v({props:{name:"update",anchor:"transformers.HybridCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1765"}}),vc=new v({props:{name:"get_seq_length",anchor:"transformers.HybridCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1807"}}),wc=new v({props:{name:"reset",anchor:"transformers.HybridCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1818"}}),kc=new v({props:{name:"class transformers.SlidingWindowCache",anchor:"transformers.SlidingWindowCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str, NoneType] = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.SlidingWindowCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.SlidingWindowCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"max_batch_size"},{anchor:"transformers.SlidingWindowCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.SlidingWindowCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. If you&#x2019;re using more than 1 computation device, you
should pass the <code>layer_device_map</code> argument instead.`,name:"device"},{anchor:"transformers.SlidingWindowCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.SlidingWindowCache.layer_device_map",description:`<strong>layer_device_map</strong> (<code>Optional[Dict[int, Union[str, torch.device, int]]]]</code>, <em>optional</em>) &#x2014;
Mapping between the layers and its device. This is required when you are manually initializing the cache
and the model is split between different gpus. You can know which layers mapped to which device by
checking the associated device_map: <code>model.hf_device_map</code>.`,name:"layer_device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1308"}}),Ma=new Z({props:{anchor:"transformers.SlidingWindowCache.example",$$slots:{default:[AC]},$$scope:{ctx:$}}}),jc=new v({props:{name:"update",anchor:"transformers.SlidingWindowCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1391"}}),$c=new v({props:{name:"reset",anchor:"transformers.SlidingWindowCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1445"}}),Jc=new v({props:{name:"class transformers.EncoderDecoderCache",anchor:"transformers.EncoderDecoderCache",parameters:[{name:"self_attention_cache",val:": Cache"},{name:"cross_attention_cache",val:": Cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1452"}}),va=new Z({props:{anchor:"transformers.EncoderDecoderCache.example",$$slots:{default:[OC]},$$scope:{ctx:$}}}),xc=new v({props:{name:"get_seq_length",anchor:"transformers.EncoderDecoderCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1541"}}),Uc=new v({props:{name:"to_legacy_cache",anchor:"transformers.EncoderDecoderCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1510"}}),Zc=new v({props:{name:"from_legacy_cache",anchor:"transformers.EncoderDecoderCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1522"}}),Cc=new v({props:{name:"reset",anchor:"transformers.EncoderDecoderCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1546"}}),Wc=new v({props:{name:"reorder_cache",anchor:"transformers.EncoderDecoderCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L1561"}}),Ic=new v({props:{name:"class transformers.MambaCache",anchor:"transformers.MambaCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"dtype",val:": dtype = torch.float16"},{name:"device",val:": typing.Union[torch.device, str, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MambaCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.MambaCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used. Note that a new instance must be instantiated if a smaller batch size is used.`,name:"max_batch_size"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.MambaCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2135"}}),Ja=new Z({props:{anchor:"transformers.MambaCache.example",$$slots:{default:[KC]},$$scope:{ctx:$}}}),Bc=new v({props:{name:"update_conv_state",anchor:"transformers.MambaCache.update_conv_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_conv_state",val:": Tensor"},{name:"cache_position",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2207"}}),zc=new v({props:{name:"update_ssm_state",anchor:"transformers.MambaCache.update_ssm_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_ssm_state",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2224"}}),Vc=new v({props:{name:"reset",anchor:"transformers.MambaCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/cache_utils.py#L2228"}}),Gc=new ne({props:{title:"Watermark Utils",local:"transformers.WatermarkingConfig",headingTag:"h2"}}),Fc=new v({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": typing.Optional[float] = 0.25"},{name:"bias",val:": typing.Optional[float] = 2.0"},{name:"hashing_key",val:": typing.Optional[int] = 15485863"},{name:"seeding_scheme",val:": typing.Optional[str] = 'lefthash'"},{name:"context_width",val:": typing.Optional[int] = 1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1423"}}),Xc=new v({props:{name:"__call__",anchor:"transformers.WatermarkingConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Rc=new v({props:{name:"class transformers.WatermarkDetector",anchor:"transformers.WatermarkDetector",parameters:[{name:"model_config",val:": PretrainedConfig"},{name:"device",val:": str"},{name:"watermarking_config",val:": typing.Union[transformers.generation.configuration_utils.WatermarkingConfig, typing.Dict]"},{name:"ignore_repeated_ngrams",val:": bool = False"},{name:"max_cache_size",val:": int = 128"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to get model specific arguments used when generating.`,name:"model_config"},{anchor:"transformers.WatermarkDetector.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device which was used during watermarked text generation.`,name:"device"},{anchor:"transformers.WatermarkDetector.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>Dict</code>]) &#x2014;
The exact same watermarking config and arguments used when generating text.`,name:"watermarking_config"},{anchor:"transformers.WatermarkDetector.ignore_repeated_ngrams",description:`<strong>ignore_repeated_ngrams</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to count every unique ngram only once or not.`,name:"ignore_repeated_ngrams"},{anchor:"transformers.WatermarkDetector.max_cache_size",description:`<strong>max_cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The max size to be used for LRU caching of seeding/sampling algorithms called for every token.`,name:"max_cache_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L73"}}),Ua=new Z({props:{anchor:"transformers.WatermarkDetector.example",$$slots:{default:[eW]},$$scope:{ctx:$}}}),Lc=new v({props:{name:"__call__",anchor:"transformers.WatermarkDetector.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"z_threshold",val:": float = 3.0"},{name:"return_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The watermark generated text. It is advised to remove the prompt, which can affect the detection.`,name:"input_ids"},{anchor:"transformers.WatermarkDetector.__call__.z_threshold",description:`<strong>z_threshold</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>3.0</code>) &#x2014;
Changing this threshold will change the sensitivity of the detector. Higher z threshold gives less
sensitivity and vice versa for lower z threshold.`,name:"z_threshold"},{anchor:"transformers.WatermarkDetector.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>,  <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return <code>~generation.WatermarkDetectorOutput</code> or not. If not it will return boolean predictions,`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>WatermarkDetectorOutput</code>
if <code>return_dict=True</code> otherwise a <code>np.array</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WatermarkDetectorOutput</code> or <code>np.array</code></p>
`}}),Nc=new v({props:{name:"class transformers.BayesianDetectorConfig",anchor:"transformers.BayesianDetectorConfig",parameters:[{name:"watermarking_depth",val:": typing.Optional[int] = None"},{name:"base_rate",val:": float = 0.5"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorConfig.watermarking_depth",description:`<strong>watermarking_depth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of tournament layers.`,name:"watermarking_depth"},{anchor:"transformers.BayesianDetectorConfig.base_rate",description:`<strong>base_rate</strong> (<code>float1</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Prior probability P(w) that a text is watermarked.`,name:"base_rate"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L245"}}),Sc=new v({props:{name:"class transformers.BayesianDetectorModel",anchor:"transformers.BayesianDetectorModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorConfig">BayesianDetectorConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L352"}}),Ec=new v({props:{name:"forward",anchor:"transformers.BayesianDetectorModel.forward",parameters:[{name:"g_values",val:": Tensor"},{name:"mask",val:": Tensor"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"loss_batch_weight",val:" = 1"},{name:"return_dict",val:" = False"}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.forward.g_values",description:`<strong>g_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_len, watermarking_depth, ...)</code>) &#x2014;
g-values (with values 0 or 1)`,name:"g_values"},{anchor:"transformers.BayesianDetectorModel.forward.mask",description:`<strong>mask</strong> &#x2014;
A binary array shape [batch_size, seq_len] indicating which g-values should be used. g-values with mask
value 0 are discarded.`,name:"mask"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L438",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>p(watermarked | g_values), of shape [batch_size].</p>
`}}),Hc=new v({props:{name:"class transformers.SynthIDTextWatermarkingConfig",anchor:"transformers.SynthIDTextWatermarkingConfig",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"context_history_size",val:": int = 1024"},{name:"sampling_table_seed",val:": int = 0"},{name:"sampling_table_size",val:": int = 65536"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkingConfig.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkingConfig.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkingConfig.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkingConfig.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1501"}}),Wa=new Z({props:{anchor:"transformers.SynthIDTextWatermarkingConfig.example",$$slots:{default:[tW]},$$scope:{ctx:$}}}),qc=new v({props:{name:"class transformers.SynthIDTextWatermarkDetector",anchor:"transformers.SynthIDTextWatermarkDetector",parameters:[{name:"detector_module",val:": BayesianDetectorModel"},{name:"logits_processor",val:": SynthIDTextWatermarkLogitsProcessor"},{name:"tokenizer",val:": typing.Any"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkDetector.detector_module",description:`<strong>detector_module</strong> (<a href="/docs/transformers/main/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>) &#x2014;
Bayesian detector module object initialized with parameters.
Check <a href="https://github.com/huggingface/transformers-research-projects/tree/main/synthid_text" rel="nofollow">https://github.com/huggingface/transformers-research-projects/tree/main/synthid_text</a> for usage.`,name:"detector_module"},{anchor:"transformers.SynthIDTextWatermarkDetector.logits_processor",description:`<strong>logits_processor</strong> (<code>SynthIDTextWatermarkLogitsProcessor</code>) &#x2014;
The logits processor used for watermarking.`,name:"logits_processor"},{anchor:"transformers.SynthIDTextWatermarkDetector.tokenizer",description:`<strong>tokenizer</strong> (<code>Any</code>) &#x2014;
The tokenizer used for the model.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L482"}}),Ia=new Z({props:{anchor:"transformers.SynthIDTextWatermarkDetector.example",$$slots:{default:[sW]},$$scope:{ctx:$}}}),Qc=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkDetector.__call__",parameters:[{name:"tokenized_outputs",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/watermarking.py#L529"}}),Dc=new ne({props:{title:"Compile Utils",local:"transformers.CompileConfig",headingTag:"h2"}}),Yc=new v({props:{name:"class transformers.CompileConfig",anchor:"transformers.CompileConfig",parameters:[{name:"fullgraph",val:": bool = True"},{name:"dynamic",val:": typing.Optional[bool] = None"},{name:"backend",val:": typing.Union[str, typing.Callable] = 'inductor'"},{name:"mode",val:": str = 'reduce-overhead'"},{name:"options",val:": typing.Optional[dict] = None"}],parametersDescription:[{anchor:"transformers.CompileConfig.fullgraph",description:`<strong>fullgraph</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>True</code>, requires that the whole forward be capturable in a single graph.`,name:"fullgraph"},{anchor:"transformers.CompileConfig.dynamic",description:`<strong>dynamic</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>) &#x2014;
Whether to try to use dynamic shape graphs.`,name:"dynamic"},{anchor:"transformers.CompileConfig.backend",description:`<strong>backend</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;inductor&quot;</code>) &#x2014;
Backend to be used.`,name:"backend"},{anchor:"transformers.CompileConfig.mode",description:`<strong>mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;reduce-overhead&quot;</code>) &#x2014;
Controls balance between performance and overhead.`,name:"mode"},{anchor:"transformers.CompileConfig.options",description:`<strong>options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary of options to pass to the backend.`,name:"options"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1591"}}),Ba=new Z({props:{anchor:"transformers.CompileConfig.example",$$slots:{default:[nW]},$$scope:{ctx:$}}}),Pc=new v({props:{name:"__call__",anchor:"transformers.CompileConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ac=new tC({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/generation_utils.md"}}),{c(){i=o("meta"),j=a(),_=o("p"),d=a(),m(w.$$.fragment),s=a(),k=o("p"),k.innerHTML=_$,sb=a(),m(qa.$$.fragment),nb=a(),Qa=o("p"),Qa.innerHTML=y$,ab=a(),Da=o("p"),Da.textContent=T$,rb=a(),m(Ya.$$.fragment),ob=a(),Pa=o("p"),Pa.innerHTML=M$,lb=a(),Aa=o("ul"),Aa.innerHTML=v$,ib=a(),Oa=o("p"),Oa.innerHTML=w$,cb=a(),Ka=o("p"),Ka.innerHTML=k$,db=a(),er=o("p"),er.innerHTML=j$,pb=a(),m(tr.$$.fragment),mb=a(),sr=o("p"),sr.innerHTML=$$,gb=a(),nr=o("p"),nr.innerHTML=J$,hb=a(),ar=o("p"),ar.textContent=x$,ub=a(),m(rr.$$.fragment),fb=a(),us=o("div"),m(or.$$.fragment),GT=a(),ud=o("p"),ud.textContent=U$,bb=a(),fs=o("div"),m(lr.$$.fragment),FT=a(),fd=o("p"),fd.textContent=Z$,_b=a(),bs=o("div"),m(ir.$$.fragment),XT=a(),bd=o("p"),bd.textContent=C$,yb=a(),_s=o("div"),m(cr.$$.fragment),RT=a(),_d=o("p"),_d.textContent=W$,Tb=a(),m(dr.$$.fragment),Mb=a(),ys=o("div"),m(pr.$$.fragment),LT=a(),yd=o("p"),yd.textContent=I$,vb=a(),Ts=o("div"),m(mr.$$.fragment),NT=a(),Td=o("p"),Td.textContent=B$,wb=a(),Ms=o("div"),m(gr.$$.fragment),ST=a(),Md=o("p"),Md.textContent=z$,kb=a(),vs=o("div"),m(hr.$$.fragment),ET=a(),vd=o("p"),vd.textContent=V$,jb=a(),ws=o("div"),m(ur.$$.fragment),HT=a(),wd=o("p"),wd.textContent=G$,$b=a(),ks=o("div"),m(fr.$$.fragment),qT=a(),kd=o("p"),kd.textContent=F$,Jb=a(),js=o("div"),m(br.$$.fragment),QT=a(),jd=o("p"),jd.textContent=X$,xb=a(),$s=o("div"),m(_r.$$.fragment),DT=a(),$d=o("p"),$d.textContent=R$,Ub=a(),Js=o("div"),m(yr.$$.fragment),YT=a(),Jd=o("p"),Jd.textContent=L$,Zb=a(),xs=o("div"),m(Tr.$$.fragment),PT=a(),xd=o("p"),xd.textContent=N$,Cb=a(),m(Mr.$$.fragment),Wb=a(),nt=o("div"),m(vr.$$.fragment),AT=a(),Ud=o("p"),Ud.textContent=S$,OT=a(),Fs=o("div"),m(wr.$$.fragment),KT=a(),Zd=o("p"),Zd.textContent=E$,Ib=a(),at=o("div"),m(kr.$$.fragment),eM=a(),Cd=o("p"),Cd.textContent=H$,tM=a(),Xs=o("div"),m(jr.$$.fragment),sM=a(),Wd=o("p"),Wd.textContent=q$,Bb=a(),rt=o("div"),m($r.$$.fragment),nM=a(),Id=o("p"),Id.textContent=Q$,aM=a(),Rs=o("div"),m(Jr.$$.fragment),rM=a(),Bd=o("p"),Bd.textContent=D$,zb=a(),m(xr.$$.fragment),Vb=a(),Ur=o("p"),Ur.innerHTML=Y$,Gb=a(),m(Zr.$$.fragment),Fb=a(),je=o("div"),m(Cr.$$.fragment),oM=a(),zd=o("p"),zd.innerHTML=P$,lM=a(),m(Ls.$$.fragment),iM=a(),Vd=o("div"),m(Wr.$$.fragment),Xb=a(),N=o("div"),m(Ir.$$.fragment),cM=a(),Gd=o("p"),Gd.innerHTML=A$,dM=a(),Fd=o("p"),Fd.innerHTML=O$,pM=a(),m(Ns.$$.fragment),mM=a(),m(Ss.$$.fragment),gM=a(),Xd=o("div"),m(Br.$$.fragment),Rb=a(),ae=o("div"),m(zr.$$.fragment),hM=a(),Rd=o("p"),Rd.innerHTML=K$,uM=a(),Ld=o("p"),Ld.textContent=e0,fM=a(),m(Es.$$.fragment),bM=a(),Nd=o("div"),m(Vr.$$.fragment),Lb=a(),re=o("div"),m(Gr.$$.fragment),_M=a(),Sd=o("p"),Sd.innerHTML=t0,yM=a(),Ed=o("p"),Ed.textContent=s0,TM=a(),m(Hs.$$.fragment),MM=a(),Hd=o("div"),m(Fr.$$.fragment),Nb=a(),$e=o("div"),m(Xr.$$.fragment),vM=a(),qd=o("p"),qd.innerHTML=n0,wM=a(),m(qs.$$.fragment),kM=a(),Qd=o("div"),m(Rr.$$.fragment),Sb=a(),Je=o("div"),m(Lr.$$.fragment),jM=a(),Dd=o("p"),Dd.innerHTML=a0,$M=a(),m(Qs.$$.fragment),JM=a(),Yd=o("div"),m(Nr.$$.fragment),Eb=a(),xe=o("div"),m(Sr.$$.fragment),xM=a(),Pd=o("p"),Pd.innerHTML=r0,UM=a(),m(Ds.$$.fragment),ZM=a(),Ad=o("div"),m(Er.$$.fragment),Hb=a(),Ue=o("div"),m(Hr.$$.fragment),CM=a(),Od=o("p"),Od.innerHTML=o0,WM=a(),m(Ys.$$.fragment),IM=a(),Kd=o("div"),m(qr.$$.fragment),qb=a(),Ze=o("div"),m(Qr.$$.fragment),BM=a(),ep=o("p"),ep.innerHTML=l0,zM=a(),m(Ps.$$.fragment),VM=a(),tp=o("div"),m(Dr.$$.fragment),Qb=a(),S=o("div"),m(Yr.$$.fragment),GM=a(),sp=o("p"),sp.innerHTML=i0,FM=a(),np=o("p"),np.innerHTML=c0,XM=a(),ap=o("p"),ap.innerHTML=d0,RM=a(),m(As.$$.fragment),LM=a(),rp=o("div"),m(Pr.$$.fragment),Db=a(),Ce=o("div"),m(Ar.$$.fragment),NM=a(),op=o("p"),op.innerHTML=p0,SM=a(),lp=o("p"),lp.innerHTML=m0,EM=a(),ip=o("div"),m(Or.$$.fragment),Yb=a(),We=o("div"),m(Kr.$$.fragment),HM=a(),cp=o("p"),cp.innerHTML=g0,qM=a(),m(Os.$$.fragment),QM=a(),dp=o("div"),m(eo.$$.fragment),Pb=a(),ot=o("div"),m(to.$$.fragment),DM=a(),pp=o("p"),pp.textContent=h0,YM=a(),mp=o("div"),m(so.$$.fragment),Ab=a(),lt=o("div"),m(no.$$.fragment),PM=a(),gp=o("p"),gp.innerHTML=u0,AM=a(),hp=o("div"),m(ao.$$.fragment),Ob=a(),Ie=o("div"),m(ro.$$.fragment),OM=a(),up=o("p"),up.innerHTML=f0,KM=a(),m(Ks.$$.fragment),ev=a(),fp=o("div"),m(oo.$$.fragment),Kb=a(),Be=o("div"),m(lo.$$.fragment),tv=a(),bp=o("p"),bp.innerHTML=b0,sv=a(),m(en.$$.fragment),nv=a(),_p=o("div"),m(io.$$.fragment),e_=a(),E=o("div"),m(co.$$.fragment),av=a(),yp=o("p"),yp.innerHTML=_0,rv=a(),Tp=o("p"),Tp.innerHTML=y0,ov=a(),Mp=o("p"),Mp.innerHTML=T0,lv=a(),m(tn.$$.fragment),iv=a(),vp=o("div"),m(po.$$.fragment),t_=a(),oe=o("div"),m(mo.$$.fragment),cv=a(),wp=o("p"),wp.innerHTML=M0,dv=a(),m(sn.$$.fragment),pv=a(),m(nn.$$.fragment),mv=a(),kp=o("div"),m(go.$$.fragment),s_=a(),le=o("div"),m(ho.$$.fragment),gv=a(),jp=o("p"),jp.innerHTML=v0,hv=a(),m(an.$$.fragment),uv=a(),m(rn.$$.fragment),fv=a(),$p=o("div"),m(uo.$$.fragment),n_=a(),ze=o("div"),m(fo.$$.fragment),bv=a(),Jp=o("p"),Jp.innerHTML=w0,_v=a(),m(on.$$.fragment),yv=a(),xp=o("div"),m(bo.$$.fragment),a_=a(),ie=o("div"),m(_o.$$.fragment),Tv=a(),Up=o("p"),Up.innerHTML=k0,Mv=a(),Zp=o("p"),Zp.innerHTML=j0,vv=a(),m(ln.$$.fragment),wv=a(),Cp=o("div"),m(yo.$$.fragment),r_=a(),ce=o("div"),m(To.$$.fragment),kv=a(),Wp=o("p"),Wp.innerHTML=$0,jv=a(),m(cn.$$.fragment),$v=a(),m(dn.$$.fragment),Jv=a(),Ip=o("div"),m(Mo.$$.fragment),o_=a(),Ve=o("div"),m(vo.$$.fragment),xv=a(),Bp=o("p"),Bp.innerHTML=J0,Uv=a(),m(pn.$$.fragment),Zv=a(),zp=o("div"),m(wo.$$.fragment),l_=a(),Ge=o("div"),m(ko.$$.fragment),Cv=a(),Vp=o("p"),Vp.innerHTML=x0,Wv=a(),m(mn.$$.fragment),Iv=a(),Gp=o("div"),m(jo.$$.fragment),i_=a(),F=o("div"),m($o.$$.fragment),Bv=a(),Fp=o("p"),Fp.textContent=U0,zv=a(),Xp=o("p"),Xp.textContent=Z0,Vv=a(),Rp=o("ul"),Rp.innerHTML=C0,Gv=a(),Lp=o("p"),Lp.innerHTML=W0,Fv=a(),m(gn.$$.fragment),Xv=a(),Np=o("div"),m(Jo.$$.fragment),c_=a(),de=o("div"),m(xo.$$.fragment),Rv=a(),Sp=o("p"),Sp.innerHTML=I0,Lv=a(),m(hn.$$.fragment),Nv=a(),m(un.$$.fragment),Sv=a(),Ep=o("div"),m(Uo.$$.fragment),d_=a(),Fe=o("div"),m(Zo.$$.fragment),Ev=a(),Hp=o("p"),Hp.innerHTML=B0,Hv=a(),m(fn.$$.fragment),qv=a(),qp=o("div"),m(Co.$$.fragment),p_=a(),Xe=o("div"),m(Wo.$$.fragment),Qv=a(),Qp=o("p"),Qp.innerHTML=z0,Dv=a(),m(bn.$$.fragment),Yv=a(),Dp=o("div"),m(Io.$$.fragment),m_=a(),pe=o("div"),m(Bo.$$.fragment),Pv=a(),Yp=o("p"),Yp.innerHTML=V0,Av=a(),Pp=o("p"),Pp.innerHTML=G0,Ov=a(),m(_n.$$.fragment),Kv=a(),Ap=o("div"),m(zo.$$.fragment),g_=a(),me=o("div"),m(Vo.$$.fragment),ew=a(),Op=o("p"),Op.innerHTML=F0,tw=a(),Kp=o("p"),Kp.innerHTML=X0,sw=a(),m(yn.$$.fragment),nw=a(),em=o("div"),m(Go.$$.fragment),h_=a(),ge=o("div"),m(Fo.$$.fragment),aw=a(),tm=o("p"),tm.innerHTML=R0,rw=a(),sm=o("p"),sm.innerHTML=L0,ow=a(),m(Tn.$$.fragment),lw=a(),nm=o("div"),m(Xo.$$.fragment),u_=a(),H=o("div"),m(Ro.$$.fragment),iw=a(),am=o("p"),am.innerHTML=N0,cw=a(),rm=o("p"),rm.innerHTML=S0,dw=a(),om=o("p"),om.innerHTML=E0,pw=a(),m(Mn.$$.fragment),mw=a(),lm=o("div"),m(Lo.$$.fragment),f_=a(),m(No.$$.fragment),b_=a(),it=o("div"),m(So.$$.fragment),gw=a(),im=o("p"),im.innerHTML=H0,hw=a(),cm=o("div"),m(Eo.$$.fragment),__=a(),ct=o("div"),m(Ho.$$.fragment),uw=a(),dm=o("p"),dm.innerHTML=q0,fw=a(),pm=o("div"),m(qo.$$.fragment),y_=a(),dt=o("div"),m(Qo.$$.fragment),bw=a(),mm=o("p"),mm.innerHTML=Q0,_w=a(),gm=o("div"),m(Do.$$.fragment),T_=a(),pt=o("div"),m(Yo.$$.fragment),yw=a(),hm=o("p"),hm.textContent=D0,Tw=a(),vn=o("div"),m(Po.$$.fragment),Mw=a(),um=o("p"),um.textContent=Y0,M_=a(),mt=o("div"),m(Ao.$$.fragment),vw=a(),fm=o("p"),fm.innerHTML=P0,ww=a(),bm=o("div"),m(Oo.$$.fragment),v_=a(),gt=o("div"),m(Ko.$$.fragment),kw=a(),_m=o("p"),_m.textContent=A0,jw=a(),wn=o("div"),m(el.$$.fragment),$w=a(),ym=o("p"),ym.textContent=O0,w_=a(),ht=o("div"),m(tl.$$.fragment),Jw=a(),Tm=o("p"),Tm.innerHTML=K0,xw=a(),Mm=o("div"),m(sl.$$.fragment),k_=a(),ut=o("div"),m(nl.$$.fragment),Uw=a(),vm=o("p"),vm.innerHTML=eJ,Zw=a(),wm=o("div"),m(al.$$.fragment),j_=a(),ft=o("div"),m(rl.$$.fragment),Cw=a(),km=o("p"),km.innerHTML=tJ,Ww=a(),jm=o("div"),m(ol.$$.fragment),$_=a(),bt=o("div"),m(ll.$$.fragment),Iw=a(),$m=o("p"),$m.innerHTML=sJ,Bw=a(),Jm=o("div"),m(il.$$.fragment),J_=a(),_t=o("div"),m(cl.$$.fragment),zw=a(),xm=o("p"),xm.innerHTML=nJ,Vw=a(),Um=o("div"),m(dl.$$.fragment),x_=a(),yt=o("div"),m(pl.$$.fragment),Gw=a(),Zm=o("p"),Zm.innerHTML=aJ,Fw=a(),Cm=o("div"),m(ml.$$.fragment),U_=a(),Tt=o("div"),m(gl.$$.fragment),Xw=a(),Wm=o("p"),Wm.innerHTML=rJ,Rw=a(),Im=o("div"),m(hl.$$.fragment),Z_=a(),Mt=o("div"),m(ul.$$.fragment),Lw=a(),Bm=o("p"),Bm.innerHTML=oJ,Nw=a(),zm=o("div"),m(fl.$$.fragment),C_=a(),vt=o("div"),m(bl.$$.fragment),Sw=a(),Vm=o("p"),Vm.innerHTML=lJ,Ew=a(),Gm=o("div"),m(_l.$$.fragment),W_=a(),m(yl.$$.fragment),I_=a(),wt=o("div"),m(Tl.$$.fragment),Hw=a(),Fm=o("p"),Fm.innerHTML=iJ,qw=a(),Xm=o("div"),m(Ml.$$.fragment),B_=a(),kt=o("div"),m(vl.$$.fragment),Qw=a(),Rm=o("p"),Rm.innerHTML=cJ,Dw=a(),Lm=o("div"),m(wl.$$.fragment),z_=a(),jt=o("div"),m(kl.$$.fragment),Yw=a(),Nm=o("p"),Nm.innerHTML=dJ,Pw=a(),Sm=o("div"),m(jl.$$.fragment),V_=a(),$t=o("div"),m($l.$$.fragment),Aw=a(),Em=o("p"),Em.textContent=pJ,Ow=a(),kn=o("div"),m(Jl.$$.fragment),Kw=a(),Hm=o("p"),Hm.textContent=mJ,G_=a(),Jt=o("div"),m(xl.$$.fragment),e2=a(),qm=o("p"),qm.innerHTML=gJ,t2=a(),Qm=o("div"),m(Ul.$$.fragment),F_=a(),xt=o("div"),m(Zl.$$.fragment),s2=a(),Dm=o("p"),Dm.textContent=hJ,n2=a(),jn=o("div"),m(Cl.$$.fragment),a2=a(),Ym=o("p"),Ym.textContent=uJ,X_=a(),Ut=o("div"),m(Wl.$$.fragment),r2=a(),Pm=o("p"),Pm.innerHTML=fJ,o2=a(),Am=o("div"),m(Il.$$.fragment),R_=a(),Zt=o("div"),m(Bl.$$.fragment),l2=a(),Om=o("p"),Om.innerHTML=bJ,i2=a(),Km=o("div"),m(zl.$$.fragment),L_=a(),Ct=o("div"),m(Vl.$$.fragment),c2=a(),eg=o("p"),eg.innerHTML=_J,d2=a(),tg=o("div"),m(Gl.$$.fragment),N_=a(),Wt=o("div"),m(Fl.$$.fragment),p2=a(),sg=o("p"),sg.innerHTML=yJ,m2=a(),ng=o("div"),m(Xl.$$.fragment),S_=a(),It=o("div"),m(Rl.$$.fragment),g2=a(),ag=o("p"),ag.innerHTML=TJ,h2=a(),rg=o("div"),m(Ll.$$.fragment),E_=a(),Bt=o("div"),m(Nl.$$.fragment),u2=a(),og=o("p"),og.innerHTML=MJ,f2=a(),lg=o("div"),m(Sl.$$.fragment),H_=a(),zt=o("div"),m(El.$$.fragment),b2=a(),ig=o("p"),ig.innerHTML=vJ,_2=a(),cg=o("div"),m(Hl.$$.fragment),q_=a(),m(ql.$$.fragment),Q_=a(),Ql=o("p"),Ql.innerHTML=wJ,D_=a(),Re=o("div"),m(Dl.$$.fragment),y2=a(),dg=o("p"),dg.textContent=kJ,T2=a(),pg=o("p"),pg.innerHTML=jJ,M2=a(),mg=o("div"),m(Yl.$$.fragment),Y_=a(),Us=o("div"),m(Pl.$$.fragment),v2=a(),gg=o("div"),m(Al.$$.fragment),P_=a(),Vt=o("div"),m(Ol.$$.fragment),w2=a(),hg=o("p"),hg.innerHTML=$J,k2=a(),ug=o("div"),m(Kl.$$.fragment),A_=a(),Gt=o("div"),m(ei.$$.fragment),j2=a(),fg=o("p"),fg.innerHTML=JJ,$2=a(),bg=o("div"),m(ti.$$.fragment),O_=a(),x=o("div"),m(si.$$.fragment),J2=a(),_g=o("p"),_g.textContent=xJ,x2=a(),yg=o("p"),yg.textContent=UJ,U2=a(),Tg=o("ul"),Tg.innerHTML=ZJ,Z2=a(),Mg=o("p"),Mg.textContent=CJ,C2=a(),vg=o("ul"),vg.innerHTML=WJ,W2=a(),wg=o("p"),wg.textContent=IJ,I2=a(),kg=o("p"),kg.textContent=BJ,B2=a(),jg=o("p"),jg.textContent=zJ,z2=a(),$g=o("ul"),$g.innerHTML=VJ,V2=a(),Jg=o("p"),Jg.textContent=GJ,G2=a(),xg=o("p"),xg.textContent=FJ,F2=a(),Ug=o("p"),Ug.textContent=XJ,X2=a(),Zg=o("p"),Zg.textContent=RJ,R2=a(),Cg=o("ul"),Cg.innerHTML=LJ,L2=a(),Wg=o("p"),Wg.textContent=NJ,N2=a(),Ig=o("p"),Ig.textContent=SJ,S2=a(),Bg=o("ul"),Bg.innerHTML=EJ,E2=a(),zg=o("p"),zg.textContent=HJ,H2=a(),Vg=o("p"),Vg.textContent=qJ,q2=a(),m($n.$$.fragment),Q2=a(),Gg=o("div"),m(ni.$$.fragment),K_=a(),Ft=o("div"),m(ai.$$.fragment),D2=a(),Fg=o("p"),Fg.innerHTML=QJ,Y2=a(),Xg=o("div"),m(ri.$$.fragment),ey=a(),m(oi.$$.fragment),ty=a(),li=o("p"),li.innerHTML=DJ,sy=a(),W=o("div"),m(ii.$$.fragment),P2=a(),Rg=o("p"),Rg.textContent=YJ,A2=a(),Lg=o("p"),Lg.textContent=PJ,O2=a(),m(Jn.$$.fragment),K2=a(),Ng=o("p"),Ng.textContent=AJ,ek=a(),xn=o("div"),m(ci.$$.fragment),tk=a(),Sg=o("p"),Sg.textContent=OJ,sk=a(),Un=o("div"),m(di.$$.fragment),nk=a(),Eg=o("p"),Eg.textContent=KJ,ak=a(),Zn=o("div"),m(pi.$$.fragment),rk=a(),Hg=o("p"),Hg.textContent=ex,ok=a(),Cn=o("div"),m(mi.$$.fragment),lk=a(),qg=o("p"),qg.innerHTML=tx,ik=a(),Wn=o("div"),m(gi.$$.fragment),ck=a(),Qg=o("p"),Qg.textContent=sx,dk=a(),In=o("div"),m(hi.$$.fragment),pk=a(),Dg=o("p"),Dg.textContent=nx,mk=a(),ss=o("div"),m(ui.$$.fragment),gk=a(),Yg=o("p"),Yg.innerHTML=ax,hk=a(),Pg=o("p"),Pg.textContent=rx,ny=a(),Zs=o("div"),m(fi.$$.fragment),uk=a(),Ag=o("p"),Ag.innerHTML=ox,ay=a(),Cs=o("div"),m(bi.$$.fragment),fk=a(),Og=o("p"),Og.innerHTML=lx,ry=a(),Le=o("div"),m(_i.$$.fragment),bk=a(),Kg=o("p"),Kg.textContent=ix,_k=a(),K=o("div"),m(yi.$$.fragment),yk=a(),eh=o("p"),eh.textContent=cx,Tk=a(),th=o("p"),th.innerHTML=dx,Mk=a(),sh=o("p"),sh.innerHTML=px,vk=a(),nh=o("p"),nh.innerHTML=mx,wk=a(),ah=o("p"),ah.textContent=gx,kk=a(),Bn=o("div"),m(Ti.$$.fragment),jk=a(),rh=o("p"),rh.textContent=hx,oy=a(),m(Mi.$$.fragment),ly=a(),Ne=o("div"),m(vi.$$.fragment),$k=a(),oh=o("p"),oh.innerHTML=ux,Jk=a(),lh=o("div"),m(wi.$$.fragment),xk=a(),ih=o("div"),m(ki.$$.fragment),iy=a(),q=o("div"),m(ji.$$.fragment),Uk=a(),ch=o("p"),ch.innerHTML=fx,Zk=a(),dh=o("p"),dh.innerHTML=bx,Ck=a(),ph=o("p"),ph.innerHTML=_x,Wk=a(),mh=o("div"),m($i.$$.fragment),Ik=a(),gh=o("div"),m(Ji.$$.fragment),cy=a(),Se=o("div"),m(xi.$$.fragment),Bk=a(),hh=o("p"),hh.innerHTML=yx,zk=a(),uh=o("div"),m(Ui.$$.fragment),Vk=a(),fh=o("div"),m(Zi.$$.fragment),dy=a(),m(Ci.$$.fragment),py=a(),X=o("div"),m(Wi.$$.fragment),Gk=a(),bh=o("p"),bh.textContent=Tx,Fk=a(),m(zn.$$.fragment),Xk=a(),m(Vn.$$.fragment),Rk=a(),Gn=o("div"),m(Ii.$$.fragment),Lk=a(),_h=o("p"),_h.textContent=Mx,Nk=a(),Fn=o("div"),m(Bi.$$.fragment),Sk=a(),yh=o("p"),yh.textContent=vx,Ek=a(),Xn=o("div"),m(zi.$$.fragment),Hk=a(),Th=o("p"),Th.textContent=wx,my=a(),he=o("div"),m(Vi.$$.fragment),qk=a(),Mh=o("p"),Mh.textContent=kx,Qk=a(),m(Rn.$$.fragment),Dk=a(),m(Ln.$$.fragment),Yk=a(),Nn=o("div"),m(Gi.$$.fragment),Pk=a(),vh=o("p"),vh.textContent=jx,gy=a(),ue=o("div"),m(Fi.$$.fragment),Ak=a(),wh=o("p"),wh.textContent=$x,Ok=a(),m(Sn.$$.fragment),Kk=a(),m(En.$$.fragment),e1=a(),Hn=o("div"),m(Xi.$$.fragment),t1=a(),kh=o("p"),kh.textContent=Jx,hy=a(),m(Ri.$$.fragment),uy=a(),Xt=o("div"),m(Li.$$.fragment),s1=a(),jh=o("p"),jh.textContent=xx,n1=a(),qn=o("div"),m(Ni.$$.fragment),a1=a(),$h=o("p"),$h.innerHTML=Ux,fy=a(),Rt=o("div"),m(Si.$$.fragment),r1=a(),Jh=o("p"),Jh.textContent=Zx,o1=a(),Qn=o("div"),m(Ei.$$.fragment),l1=a(),xh=o("p"),xh.innerHTML=Cx,by=a(),Lt=o("div"),m(Hi.$$.fragment),i1=a(),Uh=o("p"),Uh.textContent=Wx,c1=a(),Dn=o("div"),m(qi.$$.fragment),d1=a(),Zh=o("p"),Zh.textContent=Ix,_y=a(),B=o("div"),m(Qi.$$.fragment),p1=a(),Ch=o("p"),Ch.textContent=Bx,m1=a(),Wh=o("p"),Wh.innerHTML=zx,g1=a(),m(Yn.$$.fragment),h1=a(),Pn=o("div"),m(Di.$$.fragment),u1=a(),Ih=o("p"),Ih.innerHTML=Vx,f1=a(),An=o("div"),m(Yi.$$.fragment),b1=a(),Bh=o("p"),Bh.textContent=Gx,_1=a(),On=o("div"),m(Pi.$$.fragment),y1=a(),zh=o("p"),zh.textContent=Fx,T1=a(),Kn=o("div"),m(Ai.$$.fragment),M1=a(),Vh=o("p"),Vh.innerHTML=Xx,v1=a(),ea=o("div"),m(Oi.$$.fragment),w1=a(),Gh=o("p"),Gh.innerHTML=Rx,yy=a(),Q=o("div"),m(Ki.$$.fragment),k1=a(),Fh=o("p"),Fh.innerHTML=Lx,j1=a(),Xh=o("p"),Xh.innerHTML=Nx,$1=a(),Rh=o("p"),Rh.innerHTML=Sx,J1=a(),Lh=o("div"),m(ec.$$.fragment),x1=a(),ta=o("div"),m(tc.$$.fragment),U1=a(),Nh=o("p"),Nh.textContent=Ex,Ty=a(),Nt=o("div"),m(sc.$$.fragment),Z1=a(),Sh=o("p"),Sh.innerHTML=Hx,C1=a(),m(sa.$$.fragment),My=a(),St=o("div"),m(nc.$$.fragment),W1=a(),Eh=o("p"),Eh.innerHTML=qx,I1=a(),m(na.$$.fragment),vy=a(),z=o("div"),m(ac.$$.fragment),B1=a(),Hh=o("p"),Hh.textContent=Qx,z1=a(),qh=o("p"),qh.innerHTML=Dx,V1=a(),Qh=o("p"),Qh.innerHTML=Yx,G1=a(),m(aa.$$.fragment),F1=a(),ra=o("div"),m(rc.$$.fragment),X1=a(),Dh=o("p"),Dh.innerHTML=Px,R1=a(),oa=o("div"),m(oc.$$.fragment),L1=a(),Yh=o("p"),Yh.textContent=Ax,N1=a(),la=o("div"),m(lc.$$.fragment),S1=a(),Ph=o("p"),Ph.textContent=Ox,wy=a(),D=o("div"),m(ic.$$.fragment),E1=a(),Ah=o("p"),Ah.textContent=Kx,H1=a(),Oh=o("p"),Oh.textContent=eU,q1=a(),ia=o("div"),m(cc.$$.fragment),Q1=a(),Kh=o("p"),Kh.innerHTML=tU,D1=a(),ca=o("div"),m(dc.$$.fragment),Y1=a(),eu=o("p"),eu.textContent=sU,P1=a(),da=o("div"),m(pc.$$.fragment),A1=a(),tu=o("p"),tu.textContent=nU,ky=a(),Y=o("div"),m(mc.$$.fragment),O1=a(),su=o("p"),su.innerHTML=aU,K1=a(),m(pa.$$.fragment),ej=a(),ma=o("div"),m(gc.$$.fragment),tj=a(),nu=o("p"),nu.innerHTML=rU,sj=a(),ga=o("div"),m(hc.$$.fragment),nj=a(),au=o("p"),au.textContent=oU,aj=a(),ha=o("div"),m(uc.$$.fragment),rj=a(),ru=o("p"),ru.textContent=lU,jy=a(),P=o("div"),m(fc.$$.fragment),oj=a(),ou=o("p"),ou.innerHTML=iU,lj=a(),m(ua.$$.fragment),ij=a(),fa=o("div"),m(bc.$$.fragment),cj=a(),lu=o("p"),lu.innerHTML=cU,dj=a(),ba=o("div"),m(_c.$$.fragment),pj=a(),iu=o("p"),iu.textContent=dU,mj=a(),_a=o("div"),m(yc.$$.fragment),gj=a(),cu=o("p"),cu.textContent=pU,$y=a(),A=o("div"),m(Tc.$$.fragment),hj=a(),du=o("p"),du.innerHTML=mU,uj=a(),m(ya.$$.fragment),fj=a(),pu=o("div"),m(Mc.$$.fragment),bj=a(),mu=o("div"),m(vc.$$.fragment),_j=a(),Ta=o("div"),m(wc.$$.fragment),yj=a(),gu=o("p"),gu.textContent=gU,Jy=a(),V=o("div"),m(kc.$$.fragment),Tj=a(),hu=o("p"),hu.innerHTML=hU,Mj=a(),uu=o("p"),uu.innerHTML=uU,vj=a(),fu=o("p"),fu.textContent=fU,wj=a(),bu=o("p"),bu.innerHTML=bU,kj=a(),m(Ma.$$.fragment),jj=a(),_u=o("div"),m(jc.$$.fragment),$j=a(),yu=o("div"),m($c.$$.fragment),xy=a(),G=o("div"),m(Jc.$$.fragment),Jj=a(),Tu=o("p"),Tu.textContent=_U,xj=a(),m(va.$$.fragment),Uj=a(),wa=o("div"),m(xc.$$.fragment),Zj=a(),Mu=o("p"),Mu.textContent=yU,Cj=a(),ka=o("div"),m(Uc.$$.fragment),Wj=a(),vu=o("p"),vu.innerHTML=TU,Ij=a(),ja=o("div"),m(Zc.$$.fragment),Bj=a(),wu=o("p"),wu.innerHTML=MU,zj=a(),ku=o("div"),m(Cc.$$.fragment),Vj=a(),$a=o("div"),m(Wc.$$.fragment),Gj=a(),ju=o("p"),ju.textContent=vU,Uy=a(),O=o("div"),m(Ic.$$.fragment),Fj=a(),$u=o("p"),$u.textContent=wU,Xj=a(),m(Ja.$$.fragment),Rj=a(),Ju=o("div"),m(Bc.$$.fragment),Lj=a(),xu=o("div"),m(zc.$$.fragment),Nj=a(),Uu=o("div"),m(Vc.$$.fragment),Zy=a(),m(Gc.$$.fragment),Cy=a(),fe=o("div"),m(Fc.$$.fragment),Sj=a(),Zu=o("p"),Zu.innerHTML=kU,Ej=a(),Cu=o("p"),Cu.textContent=jU,Hj=a(),Wu=o("ul"),Wu.innerHTML=$U,qj=a(),xa=o("div"),m(Xc.$$.fragment),Qj=a(),Iu=o("p"),Iu.textContent=JU,Wy=a(),be=o("div"),m(Rc.$$.fragment),Dj=a(),Bu=o("p"),Bu.innerHTML=xU,Yj=a(),zu=o("p"),zu.innerHTML=UU,Pj=a(),m(Ua.$$.fragment),Aj=a(),Za=o("div"),m(Lc.$$.fragment),Oj=a(),Vu=o("p"),Vu.textContent=ZU,Iy=a(),Et=o("div"),m(Nc.$$.fragment),Kj=a(),Gu=o("p"),Gu.innerHTML=CU,e$=a(),Fu=o("p"),Fu.innerHTML=WU,By=a(),R=o("div"),m(Sc.$$.fragment),t$=a(),Xu=o("p"),Xu.textContent=IU,s$=a(),Ru=o("p"),Ru.innerHTML=BU,n$=a(),Lu=o("p"),Lu.textContent=zU,a$=a(),Nu=o("p"),Nu.innerHTML=VU,r$=a(),Su=o("p"),Su.innerHTML=GU,o$=a(),Ca=o("div"),m(Ec.$$.fragment),l$=a(),Eu=o("p"),Eu.textContent=FU,zy=a(),Ht=o("div"),m(Hc.$$.fragment),i$=a(),Hu=o("p"),Hu.innerHTML=XU,c$=a(),m(Wa.$$.fragment),Vy=a(),_e=o("div"),m(qc.$$.fragment),d$=a(),qu=o("p"),qu.textContent=RU,p$=a(),Qu=o("p"),Qu.textContent=LU,m$=a(),m(Ia.$$.fragment),g$=a(),Du=o("div"),m(Qc.$$.fragment),Gy=a(),m(Dc.$$.fragment),Fy=a(),Ee=o("div"),m(Yc.$$.fragment),h$=a(),Yu=o("p"),Yu.innerHTML=NU,u$=a(),m(Ba.$$.fragment),f$=a(),za=o("div"),m(Pc.$$.fragment),b$=a(),Pu=o("p"),Pu.textContent=SU,Xy=a(),m(Ac.$$.fragment),Ry=a(),Gf=o("p"),this.h()},l(e){const c=eC("svelte-u9bgzb",document.head);i=l(c,"META",{name:!0,content:!0}),c.forEach(n),j=r(e),_=l(e,"P",{}),T(_).forEach(n),d=r(e),g(w.$$.fragment,e),s=r(e),k=l(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1bcp7t6"&&(k.innerHTML=_$),sb=r(e),g(qa.$$.fragment,e),nb=r(e),Qa=l(e,"P",{"data-svelte-h":!0}),y(Qa)!=="svelte-18ep3y6"&&(Qa.innerHTML=y$),ab=r(e),Da=l(e,"P",{"data-svelte-h":!0}),y(Da)!=="svelte-wwwyth"&&(Da.textContent=T$),rb=r(e),g(Ya.$$.fragment,e),ob=r(e),Pa=l(e,"P",{"data-svelte-h":!0}),y(Pa)!=="svelte-1xs4157"&&(Pa.innerHTML=M$),lb=r(e),Aa=l(e,"UL",{"data-svelte-h":!0}),y(Aa)!=="svelte-1arpy9m"&&(Aa.innerHTML=v$),ib=r(e),Oa=l(e,"P",{"data-svelte-h":!0}),y(Oa)!=="svelte-xh59rv"&&(Oa.innerHTML=w$),cb=r(e),Ka=l(e,"P",{"data-svelte-h":!0}),y(Ka)!=="svelte-rqavqw"&&(Ka.innerHTML=k$),db=r(e),er=l(e,"P",{"data-svelte-h":!0}),y(er)!=="svelte-qr02he"&&(er.innerHTML=j$),pb=r(e),g(tr.$$.fragment,e),mb=r(e),sr=l(e,"P",{"data-svelte-h":!0}),y(sr)!=="svelte-114v74y"&&(sr.innerHTML=$$),gb=r(e),nr=l(e,"P",{"data-svelte-h":!0}),y(nr)!=="svelte-13knclg"&&(nr.innerHTML=J$),hb=r(e),ar=l(e,"P",{"data-svelte-h":!0}),y(ar)!=="svelte-gz8gow"&&(ar.textContent=x$),ub=r(e),g(rr.$$.fragment,e),fb=r(e),us=l(e,"DIV",{class:!0});var Oc=T(us);g(or.$$.fragment,Oc),GT=r(Oc),ud=l(Oc,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-k7oes3"&&(ud.textContent=U$),Oc.forEach(n),bb=r(e),fs=l(e,"DIV",{class:!0});var Kc=T(fs);g(lr.$$.fragment,Kc),FT=r(Kc),fd=l(Kc,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-111f3sj"&&(fd.textContent=Z$),Kc.forEach(n),_b=r(e),bs=l(e,"DIV",{class:!0});var ed=T(bs);g(ir.$$.fragment,ed),XT=r(ed),bd=l(ed,"P",{"data-svelte-h":!0}),y(bd)!=="svelte-1j3b9cp"&&(bd.textContent=C$),ed.forEach(n),yb=r(e),_s=l(e,"DIV",{class:!0});var td=T(_s);g(cr.$$.fragment,td),RT=r(td),_d=l(td,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-16r5px1"&&(_d.textContent=W$),td.forEach(n),Tb=r(e),g(dr.$$.fragment,e),Mb=r(e),ys=l(e,"DIV",{class:!0});var sd=T(ys);g(pr.$$.fragment,sd),LT=r(sd),yd=l(sd,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-1bnrp61"&&(yd.textContent=I$),sd.forEach(n),vb=r(e),Ts=l(e,"DIV",{class:!0});var nd=T(Ts);g(mr.$$.fragment,nd),NT=r(nd),Td=l(nd,"P",{"data-svelte-h":!0}),y(Td)!=="svelte-fenhkk"&&(Td.textContent=B$),nd.forEach(n),wb=r(e),Ms=l(e,"DIV",{class:!0});var ad=T(Ms);g(gr.$$.fragment,ad),ST=r(ad),Md=l(ad,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-1dqtgq4"&&(Md.textContent=z$),ad.forEach(n),kb=r(e),vs=l(e,"DIV",{class:!0});var rd=T(vs);g(hr.$$.fragment,rd),ET=r(rd),vd=l(rd,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-10orfv5"&&(vd.textContent=V$),rd.forEach(n),jb=r(e),ws=l(e,"DIV",{class:!0});var od=T(ws);g(ur.$$.fragment,od),HT=r(od),wd=l(od,"P",{"data-svelte-h":!0}),y(wd)!=="svelte-jg8udg"&&(wd.textContent=G$),od.forEach(n),$b=r(e),ks=l(e,"DIV",{class:!0});var ld=T(ks);g(fr.$$.fragment,ld),qT=r(ld),kd=l(ld,"P",{"data-svelte-h":!0}),y(kd)!=="svelte-1i40667"&&(kd.textContent=F$),ld.forEach(n),Jb=r(e),js=l(e,"DIV",{class:!0});var id=T(js);g(br.$$.fragment,id),QT=r(id),jd=l(id,"P",{"data-svelte-h":!0}),y(jd)!=="svelte-n5fi8x"&&(jd.textContent=X$),id.forEach(n),xb=r(e),$s=l(e,"DIV",{class:!0});var cd=T($s);g(_r.$$.fragment,cd),DT=r(cd),$d=l(cd,"P",{"data-svelte-h":!0}),y($d)!=="svelte-h5pj3l"&&($d.textContent=R$),cd.forEach(n),Ub=r(e),Js=l(e,"DIV",{class:!0});var dd=T(Js);g(yr.$$.fragment,dd),YT=r(dd),Jd=l(dd,"P",{"data-svelte-h":!0}),y(Jd)!=="svelte-b9zq6n"&&(Jd.textContent=L$),dd.forEach(n),Zb=r(e),xs=l(e,"DIV",{class:!0});var pd=T(xs);g(Tr.$$.fragment,pd),PT=r(pd),xd=l(pd,"P",{"data-svelte-h":!0}),y(xd)!=="svelte-pru3ks"&&(xd.textContent=N$),pd.forEach(n),Cb=r(e),g(Mr.$$.fragment,e),Wb=r(e),nt=l(e,"DIV",{class:!0});var Ws=T(nt);g(vr.$$.fragment,Ws),AT=r(Ws),Ud=l(Ws,"P",{"data-svelte-h":!0}),y(Ud)!=="svelte-qoov36"&&(Ud.textContent=S$),OT=r(Ws),Fs=l(Ws,"DIV",{class:!0});var md=T(Fs);g(wr.$$.fragment,md),KT=r(md),Zd=l(md,"P",{"data-svelte-h":!0}),y(Zd)!=="svelte-5ihtpa"&&(Zd.textContent=E$),md.forEach(n),Ws.forEach(n),Ib=r(e),at=l(e,"DIV",{class:!0});var Is=T(at);g(kr.$$.fragment,Is),eM=r(Is),Cd=l(Is,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-1tz7qrd"&&(Cd.textContent=H$),tM=r(Is),Xs=l(Is,"DIV",{class:!0});var gd=T(Xs);g(jr.$$.fragment,gd),sM=r(gd),Wd=l(gd,"P",{"data-svelte-h":!0}),y(Wd)!=="svelte-5ihtpa"&&(Wd.textContent=q$),gd.forEach(n),Is.forEach(n),Bb=r(e),rt=l(e,"DIV",{class:!0});var Bs=T(rt);g($r.$$.fragment,Bs),nM=r(Bs),Id=l(Bs,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-1tz7qrd"&&(Id.textContent=Q$),aM=r(Bs),Rs=l(Bs,"DIV",{class:!0});var hd=T(Rs);g(Jr.$$.fragment,hd),rM=r(hd),Bd=l(hd,"P",{"data-svelte-h":!0}),y(Bd)!=="svelte-5ihtpa"&&(Bd.textContent=D$),hd.forEach(n),Bs.forEach(n),zb=r(e),g(xr.$$.fragment,e),Vb=r(e),Ur=l(e,"P",{"data-svelte-h":!0}),y(Ur)!=="svelte-1mhr04t"&&(Ur.innerHTML=Y$),Gb=r(e),g(Zr.$$.fragment,e),Fb=r(e),je=l(e,"DIV",{class:!0});var qt=T(je);g(Cr.$$.fragment,qt),oM=r(qt),zd=l(qt,"P",{"data-svelte-h":!0}),y(zd)!=="svelte-r0ppk6"&&(zd.innerHTML=P$),lM=r(qt),g(Ls.$$.fragment,qt),iM=r(qt),Vd=l(qt,"DIV",{class:!0});var Ff=T(Vd);g(Wr.$$.fragment,Ff),Ff.forEach(n),qt.forEach(n),Xb=r(e),N=l(e,"DIV",{class:!0});var ye=T(N);g(Ir.$$.fragment,ye),cM=r(ye),Gd=l(ye,"P",{"data-svelte-h":!0}),y(Gd)!=="svelte-3t2r7l"&&(Gd.innerHTML=A$),dM=r(ye),Fd=l(ye,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-lu7kru"&&(Fd.innerHTML=O$),pM=r(ye),g(Ns.$$.fragment,ye),mM=r(ye),g(Ss.$$.fragment,ye),gM=r(ye),Xd=l(ye,"DIV",{class:!0});var Xf=T(Xd);g(Br.$$.fragment,Xf),Xf.forEach(n),ye.forEach(n),Rb=r(e),ae=l(e,"DIV",{class:!0});var He=T(ae);g(zr.$$.fragment,He),hM=r(He),Rd=l(He,"P",{"data-svelte-h":!0}),y(Rd)!=="svelte-jnv1x5"&&(Rd.innerHTML=K$),uM=r(He),Ld=l(He,"P",{"data-svelte-h":!0}),y(Ld)!=="svelte-mpy00q"&&(Ld.textContent=e0),fM=r(He),g(Es.$$.fragment,He),bM=r(He),Nd=l(He,"DIV",{class:!0});var Rf=T(Nd);g(Vr.$$.fragment,Rf),Rf.forEach(n),He.forEach(n),Lb=r(e),re=l(e,"DIV",{class:!0});var qe=T(re);g(Gr.$$.fragment,qe),_M=r(qe),Sd=l(qe,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-hixi53"&&(Sd.innerHTML=t0),yM=r(qe),Ed=l(qe,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-3qpgm7"&&(Ed.textContent=s0),TM=r(qe),g(Hs.$$.fragment,qe),MM=r(qe),Hd=l(qe,"DIV",{class:!0});var Lf=T(Hd);g(Fr.$$.fragment,Lf),Lf.forEach(n),qe.forEach(n),Nb=r(e),$e=l(e,"DIV",{class:!0});var Qt=T($e);g(Xr.$$.fragment,Qt),vM=r(Qt),qd=l(Qt,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-y33f0y"&&(qd.innerHTML=n0),wM=r(Qt),g(qs.$$.fragment,Qt),kM=r(Qt),Qd=l(Qt,"DIV",{class:!0});var Nf=T(Qd);g(Rr.$$.fragment,Nf),Nf.forEach(n),Qt.forEach(n),Sb=r(e),Je=l(e,"DIV",{class:!0});var Dt=T(Je);g(Lr.$$.fragment,Dt),jM=r(Dt),Dd=l(Dt,"P",{"data-svelte-h":!0}),y(Dd)!=="svelte-erurzh"&&(Dd.innerHTML=a0),$M=r(Dt),g(Qs.$$.fragment,Dt),JM=r(Dt),Yd=l(Dt,"DIV",{class:!0});var Sf=T(Yd);g(Nr.$$.fragment,Sf),Sf.forEach(n),Dt.forEach(n),Eb=r(e),xe=l(e,"DIV",{class:!0});var Yt=T(xe);g(Sr.$$.fragment,Yt),xM=r(Yt),Pd=l(Yt,"P",{"data-svelte-h":!0}),y(Pd)!=="svelte-zac23"&&(Pd.innerHTML=r0),UM=r(Yt),g(Ds.$$.fragment,Yt),ZM=r(Yt),Ad=l(Yt,"DIV",{class:!0});var Ef=T(Ad);g(Er.$$.fragment,Ef),Ef.forEach(n),Yt.forEach(n),Hb=r(e),Ue=l(e,"DIV",{class:!0});var Pt=T(Ue);g(Hr.$$.fragment,Pt),CM=r(Pt),Od=l(Pt,"P",{"data-svelte-h":!0}),y(Od)!=="svelte-1xemmef"&&(Od.innerHTML=o0),WM=r(Pt),g(Ys.$$.fragment,Pt),IM=r(Pt),Kd=l(Pt,"DIV",{class:!0});var Hf=T(Kd);g(qr.$$.fragment,Hf),Hf.forEach(n),Pt.forEach(n),qb=r(e),Ze=l(e,"DIV",{class:!0});var At=T(Ze);g(Qr.$$.fragment,At),BM=r(At),ep=l(At,"P",{"data-svelte-h":!0}),y(ep)!=="svelte-1ideb0b"&&(ep.innerHTML=l0),zM=r(At),g(Ps.$$.fragment,At),VM=r(At),tp=l(At,"DIV",{class:!0});var qf=T(tp);g(Dr.$$.fragment,qf),qf.forEach(n),At.forEach(n),Qb=r(e),S=l(e,"DIV",{class:!0});var Te=T(S);g(Yr.$$.fragment,Te),GM=r(Te),sp=l(Te,"P",{"data-svelte-h":!0}),y(sp)!=="svelte-gr8gnh"&&(sp.innerHTML=i0),FM=r(Te),np=l(Te,"P",{"data-svelte-h":!0}),y(np)!=="svelte-1b0c3nk"&&(np.innerHTML=c0),XM=r(Te),ap=l(Te,"P",{"data-svelte-h":!0}),y(ap)!=="svelte-2fpu88"&&(ap.innerHTML=d0),RM=r(Te),g(As.$$.fragment,Te),LM=r(Te),rp=l(Te,"DIV",{class:!0});var Qf=T(rp);g(Pr.$$.fragment,Qf),Qf.forEach(n),Te.forEach(n),Db=r(e),Ce=l(e,"DIV",{class:!0});var Ot=T(Ce);g(Ar.$$.fragment,Ot),NM=r(Ot),op=l(Ot,"P",{"data-svelte-h":!0}),y(op)!=="svelte-19509do"&&(op.innerHTML=p0),SM=r(Ot),lp=l(Ot,"P",{"data-svelte-h":!0}),y(lp)!=="svelte-1v3r596"&&(lp.innerHTML=m0),EM=r(Ot),ip=l(Ot,"DIV",{class:!0});var Df=T(ip);g(Or.$$.fragment,Df),Df.forEach(n),Ot.forEach(n),Yb=r(e),We=l(e,"DIV",{class:!0});var Kt=T(We);g(Kr.$$.fragment,Kt),HM=r(Kt),cp=l(Kt,"P",{"data-svelte-h":!0}),y(cp)!=="svelte-1e7zhts"&&(cp.innerHTML=g0),qM=r(Kt),g(Os.$$.fragment,Kt),QM=r(Kt),dp=l(Kt,"DIV",{class:!0});var Yf=T(dp);g(eo.$$.fragment,Yf),Yf.forEach(n),Kt.forEach(n),Pb=r(e),ot=l(e,"DIV",{class:!0});var zs=T(ot);g(to.$$.fragment,zs),DM=r(zs),pp=l(zs,"P",{"data-svelte-h":!0}),y(pp)!=="svelte-y1kta5"&&(pp.textContent=h0),YM=r(zs),mp=l(zs,"DIV",{class:!0});var Pf=T(mp);g(so.$$.fragment,Pf),Pf.forEach(n),zs.forEach(n),Ab=r(e),lt=l(e,"DIV",{class:!0});var Vs=T(lt);g(no.$$.fragment,Vs),PM=r(Vs),gp=l(Vs,"P",{"data-svelte-h":!0}),y(gp)!=="svelte-1atbpnp"&&(gp.innerHTML=u0),AM=r(Vs),hp=l(Vs,"DIV",{class:!0});var Af=T(hp);g(ao.$$.fragment,Af),Af.forEach(n),Vs.forEach(n),Ob=r(e),Ie=l(e,"DIV",{class:!0});var es=T(Ie);g(ro.$$.fragment,es),OM=r(es),up=l(es,"P",{"data-svelte-h":!0}),y(up)!=="svelte-1qtsa3r"&&(up.innerHTML=f0),KM=r(es),g(Ks.$$.fragment,es),ev=r(es),fp=l(es,"DIV",{class:!0});var Of=T(fp);g(oo.$$.fragment,Of),Of.forEach(n),es.forEach(n),Kb=r(e),Be=l(e,"DIV",{class:!0});var ts=T(Be);g(lo.$$.fragment,ts),tv=r(ts),bp=l(ts,"P",{"data-svelte-h":!0}),y(bp)!=="svelte-1xxt5g1"&&(bp.innerHTML=b0),sv=r(ts),g(en.$$.fragment,ts),nv=r(ts),_p=l(ts,"DIV",{class:!0});var Kf=T(_p);g(io.$$.fragment,Kf),Kf.forEach(n),ts.forEach(n),e_=r(e),E=l(e,"DIV",{class:!0});var Me=T(E);g(co.$$.fragment,Me),av=r(Me),yp=l(Me,"P",{"data-svelte-h":!0}),y(yp)!=="svelte-8qu6y3"&&(yp.innerHTML=_0),rv=r(Me),Tp=l(Me,"P",{"data-svelte-h":!0}),y(Tp)!=="svelte-19dc1me"&&(Tp.innerHTML=y0),ov=r(Me),Mp=l(Me,"P",{"data-svelte-h":!0}),y(Mp)!=="svelte-1fvwhfn"&&(Mp.innerHTML=T0),lv=r(Me),g(tn.$$.fragment,Me),iv=r(Me),vp=l(Me,"DIV",{class:!0});var eb=T(vp);g(po.$$.fragment,eb),eb.forEach(n),Me.forEach(n),t_=r(e),oe=l(e,"DIV",{class:!0});var Qe=T(oe);g(mo.$$.fragment,Qe),cv=r(Qe),wp=l(Qe,"P",{"data-svelte-h":!0}),y(wp)!=="svelte-1j8exuv"&&(wp.innerHTML=M0),dv=r(Qe),g(sn.$$.fragment,Qe),pv=r(Qe),g(nn.$$.fragment,Qe),mv=r(Qe),kp=l(Qe,"DIV",{class:!0});var tb=T(kp);g(go.$$.fragment,tb),tb.forEach(n),Qe.forEach(n),s_=r(e),le=l(e,"DIV",{class:!0});var ns=T(le);g(ho.$$.fragment,ns),gv=r(ns),jp=l(ns,"P",{"data-svelte-h":!0}),y(jp)!=="svelte-1oiukny"&&(jp.innerHTML=v0),hv=r(ns),g(an.$$.fragment,ns),uv=r(ns),g(rn.$$.fragment,ns),fv=r(ns),$p=l(ns,"DIV",{class:!0});var EU=T($p);g(uo.$$.fragment,EU),EU.forEach(n),ns.forEach(n),n_=r(e),ze=l(e,"DIV",{class:!0});var Va=T(ze);g(fo.$$.fragment,Va),bv=r(Va),Jp=l(Va,"P",{"data-svelte-h":!0}),y(Jp)!=="svelte-8lc5bj"&&(Jp.innerHTML=w0),_v=r(Va),g(on.$$.fragment,Va),yv=r(Va),xp=l(Va,"DIV",{class:!0});var HU=T(xp);g(bo.$$.fragment,HU),HU.forEach(n),Va.forEach(n),a_=r(e),ie=l(e,"DIV",{class:!0});var as=T(ie);g(_o.$$.fragment,as),Tv=r(as),Up=l(as,"P",{"data-svelte-h":!0}),y(Up)!=="svelte-72j9x5"&&(Up.innerHTML=k0),Mv=r(as),Zp=l(as,"P",{"data-svelte-h":!0}),y(Zp)!=="svelte-qhda5i"&&(Zp.innerHTML=j0),vv=r(as),g(ln.$$.fragment,as),wv=r(as),Cp=l(as,"DIV",{class:!0});var qU=T(Cp);g(yo.$$.fragment,qU),qU.forEach(n),as.forEach(n),r_=r(e),ce=l(e,"DIV",{class:!0});var rs=T(ce);g(To.$$.fragment,rs),kv=r(rs),Wp=l(rs,"P",{"data-svelte-h":!0}),y(Wp)!=="svelte-wdblk4"&&(Wp.innerHTML=$0),jv=r(rs),g(cn.$$.fragment,rs),$v=r(rs),g(dn.$$.fragment,rs),Jv=r(rs),Ip=l(rs,"DIV",{class:!0});var QU=T(Ip);g(Mo.$$.fragment,QU),QU.forEach(n),rs.forEach(n),o_=r(e),Ve=l(e,"DIV",{class:!0});var Ga=T(Ve);g(vo.$$.fragment,Ga),xv=r(Ga),Bp=l(Ga,"P",{"data-svelte-h":!0}),y(Bp)!=="svelte-1br5lku"&&(Bp.innerHTML=J0),Uv=r(Ga),g(pn.$$.fragment,Ga),Zv=r(Ga),zp=l(Ga,"DIV",{class:!0});var DU=T(zp);g(wo.$$.fragment,DU),DU.forEach(n),Ga.forEach(n),l_=r(e),Ge=l(e,"DIV",{class:!0});var Fa=T(Ge);g(ko.$$.fragment,Fa),Cv=r(Fa),Vp=l(Fa,"P",{"data-svelte-h":!0}),y(Vp)!=="svelte-kp6ubc"&&(Vp.innerHTML=x0),Wv=r(Fa),g(mn.$$.fragment,Fa),Iv=r(Fa),Gp=l(Fa,"DIV",{class:!0});var YU=T(Gp);g(jo.$$.fragment,YU),YU.forEach(n),Fa.forEach(n),i_=r(e),F=l(e,"DIV",{class:!0});var ve=T(F);g($o.$$.fragment,ve),Bv=r(ve),Fp=l(ve,"P",{"data-svelte-h":!0}),y(Fp)!=="svelte-1rvhp9l"&&(Fp.textContent=U0),zv=r(ve),Xp=l(ve,"P",{"data-svelte-h":!0}),y(Xp)!=="svelte-1adc5s0"&&(Xp.textContent=Z0),Vv=r(ve),Rp=l(ve,"UL",{"data-svelte-h":!0}),y(Rp)!=="svelte-eq22a7"&&(Rp.innerHTML=C0),Gv=r(ve),Lp=l(ve,"P",{"data-svelte-h":!0}),y(Lp)!=="svelte-1mgc9mo"&&(Lp.innerHTML=W0),Fv=r(ve),g(gn.$$.fragment,ve),Xv=r(ve),Np=l(ve,"DIV",{class:!0});var PU=T(Np);g(Jo.$$.fragment,PU),PU.forEach(n),ve.forEach(n),c_=r(e),de=l(e,"DIV",{class:!0});var os=T(de);g(xo.$$.fragment,os),Rv=r(os),Sp=l(os,"P",{"data-svelte-h":!0}),y(Sp)!=="svelte-1l8rgx"&&(Sp.innerHTML=I0),Lv=r(os),g(hn.$$.fragment,os),Nv=r(os),g(un.$$.fragment,os),Sv=r(os),Ep=l(os,"DIV",{class:!0});var AU=T(Ep);g(Uo.$$.fragment,AU),AU.forEach(n),os.forEach(n),d_=r(e),Fe=l(e,"DIV",{class:!0});var Xa=T(Fe);g(Zo.$$.fragment,Xa),Ev=r(Xa),Hp=l(Xa,"P",{"data-svelte-h":!0}),y(Hp)!=="svelte-1g5adob"&&(Hp.innerHTML=B0),Hv=r(Xa),g(fn.$$.fragment,Xa),qv=r(Xa),qp=l(Xa,"DIV",{class:!0});var OU=T(qp);g(Co.$$.fragment,OU),OU.forEach(n),Xa.forEach(n),p_=r(e),Xe=l(e,"DIV",{class:!0});var Ra=T(Xe);g(Wo.$$.fragment,Ra),Qv=r(Ra),Qp=l(Ra,"P",{"data-svelte-h":!0}),y(Qp)!=="svelte-1patzqj"&&(Qp.innerHTML=z0),Dv=r(Ra),g(bn.$$.fragment,Ra),Yv=r(Ra),Dp=l(Ra,"DIV",{class:!0});var KU=T(Dp);g(Io.$$.fragment,KU),KU.forEach(n),Ra.forEach(n),m_=r(e),pe=l(e,"DIV",{class:!0});var ls=T(pe);g(Bo.$$.fragment,ls),Pv=r(ls),Yp=l(ls,"P",{"data-svelte-h":!0}),y(Yp)!=="svelte-wob73k"&&(Yp.innerHTML=V0),Av=r(ls),Pp=l(ls,"P",{"data-svelte-h":!0}),y(Pp)!=="svelte-1qmimno"&&(Pp.innerHTML=G0),Ov=r(ls),g(_n.$$.fragment,ls),Kv=r(ls),Ap=l(ls,"DIV",{class:!0});var eZ=T(Ap);g(zo.$$.fragment,eZ),eZ.forEach(n),ls.forEach(n),g_=r(e),me=l(e,"DIV",{class:!0});var is=T(me);g(Vo.$$.fragment,is),ew=r(is),Op=l(is,"P",{"data-svelte-h":!0}),y(Op)!=="svelte-1dewsn6"&&(Op.innerHTML=F0),tw=r(is),Kp=l(is,"P",{"data-svelte-h":!0}),y(Kp)!=="svelte-5qs7tv"&&(Kp.innerHTML=X0),sw=r(is),g(yn.$$.fragment,is),nw=r(is),em=l(is,"DIV",{class:!0});var tZ=T(em);g(Go.$$.fragment,tZ),tZ.forEach(n),is.forEach(n),h_=r(e),ge=l(e,"DIV",{class:!0});var cs=T(ge);g(Fo.$$.fragment,cs),aw=r(cs),tm=l(cs,"P",{"data-svelte-h":!0}),y(tm)!=="svelte-laa6zp"&&(tm.innerHTML=R0),rw=r(cs),sm=l(cs,"P",{"data-svelte-h":!0}),y(sm)!=="svelte-qmmn5t"&&(sm.innerHTML=L0),ow=r(cs),g(Tn.$$.fragment,cs),lw=r(cs),nm=l(cs,"DIV",{class:!0});var sZ=T(nm);g(Xo.$$.fragment,sZ),sZ.forEach(n),cs.forEach(n),u_=r(e),H=l(e,"DIV",{class:!0});var De=T(H);g(Ro.$$.fragment,De),iw=r(De),am=l(De,"P",{"data-svelte-h":!0}),y(am)!=="svelte-1722u08"&&(am.innerHTML=N0),cw=r(De),rm=l(De,"P",{"data-svelte-h":!0}),y(rm)!=="svelte-1yjxylt"&&(rm.innerHTML=S0),dw=r(De),om=l(De,"P",{"data-svelte-h":!0}),y(om)!=="svelte-y9hsik"&&(om.innerHTML=E0),pw=r(De),g(Mn.$$.fragment,De),mw=r(De),lm=l(De,"DIV",{class:!0});var nZ=T(lm);g(Lo.$$.fragment,nZ),nZ.forEach(n),De.forEach(n),f_=r(e),g(No.$$.fragment,e),b_=r(e),it=l(e,"DIV",{class:!0});var Au=T(it);g(So.$$.fragment,Au),gw=r(Au),im=l(Au,"P",{"data-svelte-h":!0}),y(im)!=="svelte-1r9g8lr"&&(im.innerHTML=H0),hw=r(Au),cm=l(Au,"DIV",{class:!0});var aZ=T(cm);g(Eo.$$.fragment,aZ),aZ.forEach(n),Au.forEach(n),__=r(e),ct=l(e,"DIV",{class:!0});var Ou=T(ct);g(Ho.$$.fragment,Ou),uw=r(Ou),dm=l(Ou,"P",{"data-svelte-h":!0}),y(dm)!=="svelte-1o8otjv"&&(dm.innerHTML=q0),fw=r(Ou),pm=l(Ou,"DIV",{class:!0});var rZ=T(pm);g(qo.$$.fragment,rZ),rZ.forEach(n),Ou.forEach(n),y_=r(e),dt=l(e,"DIV",{class:!0});var Ku=T(dt);g(Qo.$$.fragment,Ku),bw=r(Ku),mm=l(Ku,"P",{"data-svelte-h":!0}),y(mm)!=="svelte-1557waw"&&(mm.innerHTML=Q0),_w=r(Ku),gm=l(Ku,"DIV",{class:!0});var oZ=T(gm);g(Do.$$.fragment,oZ),oZ.forEach(n),Ku.forEach(n),T_=r(e),pt=l(e,"DIV",{class:!0});var ef=T(pt);g(Yo.$$.fragment,ef),yw=r(ef),hm=l(ef,"P",{"data-svelte-h":!0}),y(hm)!=="svelte-y1kta5"&&(hm.textContent=D0),Tw=r(ef),vn=l(ef,"DIV",{class:!0});var Ny=T(vn);g(Po.$$.fragment,Ny),Mw=r(Ny),um=l(Ny,"P",{"data-svelte-h":!0}),y(um)!=="svelte-5aspnb"&&(um.textContent=Y0),Ny.forEach(n),ef.forEach(n),M_=r(e),mt=l(e,"DIV",{class:!0});var tf=T(mt);g(Ao.$$.fragment,tf),vw=r(tf),fm=l(tf,"P",{"data-svelte-h":!0}),y(fm)!=="svelte-wv649x"&&(fm.innerHTML=P0),ww=r(tf),bm=l(tf,"DIV",{class:!0});var lZ=T(bm);g(Oo.$$.fragment,lZ),lZ.forEach(n),tf.forEach(n),v_=r(e),gt=l(e,"DIV",{class:!0});var sf=T(gt);g(Ko.$$.fragment,sf),kw=r(sf),_m=l(sf,"P",{"data-svelte-h":!0}),y(_m)!=="svelte-th82mu"&&(_m.textContent=A0),jw=r(sf),wn=l(sf,"DIV",{class:!0});var Sy=T(wn);g(el.$$.fragment,Sy),$w=r(Sy),ym=l(Sy,"P",{"data-svelte-h":!0}),y(ym)!=="svelte-hcoglc"&&(ym.textContent=O0),Sy.forEach(n),sf.forEach(n),w_=r(e),ht=l(e,"DIV",{class:!0});var nf=T(ht);g(tl.$$.fragment,nf),Jw=r(nf),Tm=l(nf,"P",{"data-svelte-h":!0}),y(Tm)!=="svelte-d6heh3"&&(Tm.innerHTML=K0),xw=r(nf),Mm=l(nf,"DIV",{class:!0});var iZ=T(Mm);g(sl.$$.fragment,iZ),iZ.forEach(n),nf.forEach(n),k_=r(e),ut=l(e,"DIV",{class:!0});var af=T(ut);g(nl.$$.fragment,af),Uw=r(af),vm=l(af,"P",{"data-svelte-h":!0}),y(vm)!=="svelte-gt0dvy"&&(vm.innerHTML=eJ),Zw=r(af),wm=l(af,"DIV",{class:!0});var cZ=T(wm);g(al.$$.fragment,cZ),cZ.forEach(n),af.forEach(n),j_=r(e),ft=l(e,"DIV",{class:!0});var rf=T(ft);g(rl.$$.fragment,rf),Cw=r(rf),km=l(rf,"P",{"data-svelte-h":!0}),y(km)!=="svelte-e8ez2m"&&(km.innerHTML=tJ),Ww=r(rf),jm=l(rf,"DIV",{class:!0});var dZ=T(jm);g(ol.$$.fragment,dZ),dZ.forEach(n),rf.forEach(n),$_=r(e),bt=l(e,"DIV",{class:!0});var of=T(bt);g(ll.$$.fragment,of),Iw=r(of),$m=l(of,"P",{"data-svelte-h":!0}),y($m)!=="svelte-1sr1lwj"&&($m.innerHTML=sJ),Bw=r(of),Jm=l(of,"DIV",{class:!0});var pZ=T(Jm);g(il.$$.fragment,pZ),pZ.forEach(n),of.forEach(n),J_=r(e),_t=l(e,"DIV",{class:!0});var lf=T(_t);g(cl.$$.fragment,lf),zw=r(lf),xm=l(lf,"P",{"data-svelte-h":!0}),y(xm)!=="svelte-4hf1vm"&&(xm.innerHTML=nJ),Vw=r(lf),Um=l(lf,"DIV",{class:!0});var mZ=T(Um);g(dl.$$.fragment,mZ),mZ.forEach(n),lf.forEach(n),x_=r(e),yt=l(e,"DIV",{class:!0});var cf=T(yt);g(pl.$$.fragment,cf),Gw=r(cf),Zm=l(cf,"P",{"data-svelte-h":!0}),y(Zm)!=="svelte-a554sd"&&(Zm.innerHTML=aJ),Fw=r(cf),Cm=l(cf,"DIV",{class:!0});var gZ=T(Cm);g(ml.$$.fragment,gZ),gZ.forEach(n),cf.forEach(n),U_=r(e),Tt=l(e,"DIV",{class:!0});var df=T(Tt);g(gl.$$.fragment,df),Xw=r(df),Wm=l(df,"P",{"data-svelte-h":!0}),y(Wm)!=="svelte-m0ovbw"&&(Wm.innerHTML=rJ),Rw=r(df),Im=l(df,"DIV",{class:!0});var hZ=T(Im);g(hl.$$.fragment,hZ),hZ.forEach(n),df.forEach(n),Z_=r(e),Mt=l(e,"DIV",{class:!0});var pf=T(Mt);g(ul.$$.fragment,pf),Lw=r(pf),Bm=l(pf,"P",{"data-svelte-h":!0}),y(Bm)!=="svelte-v0j3k9"&&(Bm.innerHTML=oJ),Nw=r(pf),zm=l(pf,"DIV",{class:!0});var uZ=T(zm);g(fl.$$.fragment,uZ),uZ.forEach(n),pf.forEach(n),C_=r(e),vt=l(e,"DIV",{class:!0});var mf=T(vt);g(bl.$$.fragment,mf),Sw=r(mf),Vm=l(mf,"P",{"data-svelte-h":!0}),y(Vm)!=="svelte-1kdstb"&&(Vm.innerHTML=lJ),Ew=r(mf),Gm=l(mf,"DIV",{class:!0});var fZ=T(Gm);g(_l.$$.fragment,fZ),fZ.forEach(n),mf.forEach(n),W_=r(e),g(yl.$$.fragment,e),I_=r(e),wt=l(e,"DIV",{class:!0});var gf=T(wt);g(Tl.$$.fragment,gf),Hw=r(gf),Fm=l(gf,"P",{"data-svelte-h":!0}),y(Fm)!=="svelte-115xumf"&&(Fm.innerHTML=iJ),qw=r(gf),Xm=l(gf,"DIV",{class:!0});var bZ=T(Xm);g(Ml.$$.fragment,bZ),bZ.forEach(n),gf.forEach(n),B_=r(e),kt=l(e,"DIV",{class:!0});var hf=T(kt);g(vl.$$.fragment,hf),Qw=r(hf),Rm=l(hf,"P",{"data-svelte-h":!0}),y(Rm)!=="svelte-nirf9f"&&(Rm.innerHTML=cJ),Dw=r(hf),Lm=l(hf,"DIV",{class:!0});var _Z=T(Lm);g(wl.$$.fragment,_Z),_Z.forEach(n),hf.forEach(n),z_=r(e),jt=l(e,"DIV",{class:!0});var uf=T(jt);g(kl.$$.fragment,uf),Yw=r(uf),Nm=l(uf,"P",{"data-svelte-h":!0}),y(Nm)!=="svelte-klyckq"&&(Nm.innerHTML=dJ),Pw=r(uf),Sm=l(uf,"DIV",{class:!0});var yZ=T(Sm);g(jl.$$.fragment,yZ),yZ.forEach(n),uf.forEach(n),V_=r(e),$t=l(e,"DIV",{class:!0});var ff=T($t);g($l.$$.fragment,ff),Aw=r(ff),Em=l(ff,"P",{"data-svelte-h":!0}),y(Em)!=="svelte-y1kta5"&&(Em.textContent=pJ),Ow=r(ff),kn=l(ff,"DIV",{class:!0});var Ey=T(kn);g(Jl.$$.fragment,Ey),Kw=r(Ey),Hm=l(Ey,"P",{"data-svelte-h":!0}),y(Hm)!=="svelte-1l17mwc"&&(Hm.textContent=mJ),Ey.forEach(n),ff.forEach(n),G_=r(e),Jt=l(e,"DIV",{class:!0});var bf=T(Jt);g(xl.$$.fragment,bf),e2=r(bf),qm=l(bf,"P",{"data-svelte-h":!0}),y(qm)!=="svelte-8dgktv"&&(qm.innerHTML=gJ),t2=r(bf),Qm=l(bf,"DIV",{class:!0});var TZ=T(Qm);g(Ul.$$.fragment,TZ),TZ.forEach(n),bf.forEach(n),F_=r(e),xt=l(e,"DIV",{class:!0});var _f=T(xt);g(Zl.$$.fragment,_f),s2=r(_f),Dm=l(_f,"P",{"data-svelte-h":!0}),y(Dm)!=="svelte-th82mu"&&(Dm.textContent=hJ),n2=r(_f),jn=l(_f,"DIV",{class:!0});var Hy=T(jn);g(Cl.$$.fragment,Hy),a2=r(Hy),Ym=l(Hy,"P",{"data-svelte-h":!0}),y(Ym)!=="svelte-1tcb5cf"&&(Ym.textContent=uJ),Hy.forEach(n),_f.forEach(n),X_=r(e),Ut=l(e,"DIV",{class:!0});var yf=T(Ut);g(Wl.$$.fragment,yf),r2=r(yf),Pm=l(yf,"P",{"data-svelte-h":!0}),y(Pm)!=="svelte-18yq2lb"&&(Pm.innerHTML=fJ),o2=r(yf),Am=l(yf,"DIV",{class:!0});var MZ=T(Am);g(Il.$$.fragment,MZ),MZ.forEach(n),yf.forEach(n),R_=r(e),Zt=l(e,"DIV",{class:!0});var Tf=T(Zt);g(Bl.$$.fragment,Tf),l2=r(Tf),Om=l(Tf,"P",{"data-svelte-h":!0}),y(Om)!=="svelte-kcnm7b"&&(Om.innerHTML=bJ),i2=r(Tf),Km=l(Tf,"DIV",{class:!0});var vZ=T(Km);g(zl.$$.fragment,vZ),vZ.forEach(n),Tf.forEach(n),L_=r(e),Ct=l(e,"DIV",{class:!0});var Mf=T(Ct);g(Vl.$$.fragment,Mf),c2=r(Mf),eg=l(Mf,"P",{"data-svelte-h":!0}),y(eg)!=="svelte-vt3rxp"&&(eg.innerHTML=_J),d2=r(Mf),tg=l(Mf,"DIV",{class:!0});var wZ=T(tg);g(Gl.$$.fragment,wZ),wZ.forEach(n),Mf.forEach(n),N_=r(e),Wt=l(e,"DIV",{class:!0});var vf=T(Wt);g(Fl.$$.fragment,vf),p2=r(vf),sg=l(vf,"P",{"data-svelte-h":!0}),y(sg)!=="svelte-15abw8y"&&(sg.innerHTML=yJ),m2=r(vf),ng=l(vf,"DIV",{class:!0});var kZ=T(ng);g(Xl.$$.fragment,kZ),kZ.forEach(n),vf.forEach(n),S_=r(e),It=l(e,"DIV",{class:!0});var wf=T(It);g(Rl.$$.fragment,wf),g2=r(wf),ag=l(wf,"P",{"data-svelte-h":!0}),y(ag)!=="svelte-1oo0biz"&&(ag.innerHTML=TJ),h2=r(wf),rg=l(wf,"DIV",{class:!0});var jZ=T(rg);g(Ll.$$.fragment,jZ),jZ.forEach(n),wf.forEach(n),E_=r(e),Bt=l(e,"DIV",{class:!0});var kf=T(Bt);g(Nl.$$.fragment,kf),u2=r(kf),og=l(kf,"P",{"data-svelte-h":!0}),y(og)!=="svelte-1j5ogr1"&&(og.innerHTML=MJ),f2=r(kf),lg=l(kf,"DIV",{class:!0});var $Z=T(lg);g(Sl.$$.fragment,$Z),$Z.forEach(n),kf.forEach(n),H_=r(e),zt=l(e,"DIV",{class:!0});var jf=T(zt);g(El.$$.fragment,jf),b2=r(jf),ig=l(jf,"P",{"data-svelte-h":!0}),y(ig)!=="svelte-1sygpwz"&&(ig.innerHTML=vJ),_2=r(jf),cg=l(jf,"DIV",{class:!0});var JZ=T(cg);g(Hl.$$.fragment,JZ),JZ.forEach(n),jf.forEach(n),q_=r(e),g(ql.$$.fragment,e),Q_=r(e),Ql=l(e,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-vfaqvb"&&(Ql.innerHTML=wJ),D_=r(e),Re=l(e,"DIV",{class:!0});var La=T(Re);g(Dl.$$.fragment,La),y2=r(La),dg=l(La,"P",{"data-svelte-h":!0}),y(dg)!=="svelte-rfvu1k"&&(dg.textContent=kJ),T2=r(La),pg=l(La,"P",{"data-svelte-h":!0}),y(pg)!=="svelte-e1lytz"&&(pg.innerHTML=jJ),M2=r(La),mg=l(La,"DIV",{class:!0});var xZ=T(mg);g(Yl.$$.fragment,xZ),xZ.forEach(n),La.forEach(n),Y_=r(e),Us=l(e,"DIV",{class:!0});var qy=T(Us);g(Pl.$$.fragment,qy),v2=r(qy),gg=l(qy,"DIV",{class:!0});var UZ=T(gg);g(Al.$$.fragment,UZ),UZ.forEach(n),qy.forEach(n),P_=r(e),Vt=l(e,"DIV",{class:!0});var $f=T(Vt);g(Ol.$$.fragment,$f),w2=r($f),hg=l($f,"P",{"data-svelte-h":!0}),y(hg)!=="svelte-4hfu96"&&(hg.innerHTML=$J),k2=r($f),ug=l($f,"DIV",{class:!0});var ZZ=T(ug);g(Kl.$$.fragment,ZZ),ZZ.forEach(n),$f.forEach(n),A_=r(e),Gt=l(e,"DIV",{class:!0});var Jf=T(Gt);g(ei.$$.fragment,Jf),j2=r(Jf),fg=l(Jf,"P",{"data-svelte-h":!0}),y(fg)!=="svelte-q5v59n"&&(fg.innerHTML=JJ),$2=r(Jf),bg=l(Jf,"DIV",{class:!0});var CZ=T(bg);g(ti.$$.fragment,CZ),CZ.forEach(n),Jf.forEach(n),O_=r(e),x=l(e,"DIV",{class:!0});var C=T(x);g(si.$$.fragment,C),J2=r(C),_g=l(C,"P",{"data-svelte-h":!0}),y(_g)!=="svelte-1rue44"&&(_g.textContent=xJ),x2=r(C),yg=l(C,"P",{"data-svelte-h":!0}),y(yg)!=="svelte-we1k7h"&&(yg.textContent=UJ),U2=r(C),Tg=l(C,"UL",{"data-svelte-h":!0}),y(Tg)!=="svelte-1f6ppg"&&(Tg.innerHTML=ZJ),Z2=r(C),Mg=l(C,"P",{"data-svelte-h":!0}),y(Mg)!=="svelte-1uu68ip"&&(Mg.textContent=CJ),C2=r(C),vg=l(C,"UL",{"data-svelte-h":!0}),y(vg)!=="svelte-izl8df"&&(vg.innerHTML=WJ),W2=r(C),wg=l(C,"P",{"data-svelte-h":!0}),y(wg)!=="svelte-hoqys0"&&(wg.textContent=IJ),I2=r(C),kg=l(C,"P",{"data-svelte-h":!0}),y(kg)!=="svelte-1a9fclk"&&(kg.textContent=BJ),B2=r(C),jg=l(C,"P",{"data-svelte-h":!0}),y(jg)!=="svelte-15ntb9y"&&(jg.textContent=zJ),z2=r(C),$g=l(C,"UL",{"data-svelte-h":!0}),y($g)!=="svelte-vv46ly"&&($g.innerHTML=VJ),V2=r(C),Jg=l(C,"P",{"data-svelte-h":!0}),y(Jg)!=="svelte-1owyk1q"&&(Jg.textContent=GJ),G2=r(C),xg=l(C,"P",{"data-svelte-h":!0}),y(xg)!=="svelte-wt8oc0"&&(xg.textContent=FJ),F2=r(C),Ug=l(C,"P",{"data-svelte-h":!0}),y(Ug)!=="svelte-ws21yj"&&(Ug.textContent=XJ),X2=r(C),Zg=l(C,"P",{"data-svelte-h":!0}),y(Zg)!=="svelte-l6qxzs"&&(Zg.textContent=RJ),R2=r(C),Cg=l(C,"UL",{"data-svelte-h":!0}),y(Cg)!=="svelte-p67cyh"&&(Cg.innerHTML=LJ),L2=r(C),Wg=l(C,"P",{"data-svelte-h":!0}),y(Wg)!=="svelte-1fg1xi2"&&(Wg.textContent=NJ),N2=r(C),Ig=l(C,"P",{"data-svelte-h":!0}),y(Ig)!=="svelte-1e0ripw"&&(Ig.textContent=SJ),S2=r(C),Bg=l(C,"UL",{"data-svelte-h":!0}),y(Bg)!=="svelte-1v088e0"&&(Bg.innerHTML=EJ),E2=r(C),zg=l(C,"P",{"data-svelte-h":!0}),y(zg)!=="svelte-be7vix"&&(zg.textContent=HJ),H2=r(C),Vg=l(C,"P",{"data-svelte-h":!0}),y(Vg)!=="svelte-1xhdoom"&&(Vg.textContent=qJ),q2=r(C),g($n.$$.fragment,C),Q2=r(C),Gg=l(C,"DIV",{class:!0});var WZ=T(Gg);g(ni.$$.fragment,WZ),WZ.forEach(n),C.forEach(n),K_=r(e),Ft=l(e,"DIV",{class:!0});var xf=T(Ft);g(ai.$$.fragment,xf),D2=r(xf),Fg=l(xf,"P",{"data-svelte-h":!0}),y(Fg)!=="svelte-1t19wr8"&&(Fg.innerHTML=QJ),Y2=r(xf),Xg=l(xf,"DIV",{class:!0});var IZ=T(Xg);g(ri.$$.fragment,IZ),IZ.forEach(n),xf.forEach(n),ey=r(e),g(oi.$$.fragment,e),ty=r(e),li=l(e,"P",{"data-svelte-h":!0}),y(li)!=="svelte-1fq8mcp"&&(li.innerHTML=DJ),sy=r(e),W=l(e,"DIV",{class:!0});var I=T(W);g(ii.$$.fragment,I),P2=r(I),Rg=l(I,"P",{"data-svelte-h":!0}),y(Rg)!=="svelte-1kh5y5v"&&(Rg.textContent=YJ),A2=r(I),Lg=l(I,"P",{"data-svelte-h":!0}),y(Lg)!=="svelte-1ygkifj"&&(Lg.textContent=PJ),O2=r(I),g(Jn.$$.fragment,I),K2=r(I),Ng=l(I,"P",{"data-svelte-h":!0}),y(Ng)!=="svelte-7kbd1a"&&(Ng.textContent=AJ),ek=r(I),xn=l(I,"DIV",{class:!0});var Qy=T(xn);g(ci.$$.fragment,Qy),tk=r(Qy),Sg=l(Qy,"P",{"data-svelte-h":!0}),y(Sg)!=="svelte-163x237"&&(Sg.textContent=OJ),Qy.forEach(n),sk=r(I),Un=l(I,"DIV",{class:!0});var Dy=T(Un);g(di.$$.fragment,Dy),nk=r(Dy),Eg=l(Dy,"P",{"data-svelte-h":!0}),y(Eg)!=="svelte-dtkk01"&&(Eg.textContent=KJ),Dy.forEach(n),ak=r(I),Zn=l(I,"DIV",{class:!0});var Yy=T(Zn);g(pi.$$.fragment,Yy),rk=r(Yy),Hg=l(Yy,"P",{"data-svelte-h":!0}),y(Hg)!=="svelte-11pa7k0"&&(Hg.textContent=ex),Yy.forEach(n),ok=r(I),Cn=l(I,"DIV",{class:!0});var Py=T(Cn);g(mi.$$.fragment,Py),lk=r(Py),qg=l(Py,"P",{"data-svelte-h":!0}),y(qg)!=="svelte-57vcuk"&&(qg.innerHTML=tx),Py.forEach(n),ik=r(I),Wn=l(I,"DIV",{class:!0});var Ay=T(Wn);g(gi.$$.fragment,Ay),ck=r(Ay),Qg=l(Ay,"P",{"data-svelte-h":!0}),y(Qg)!=="svelte-e342dt"&&(Qg.textContent=sx),Ay.forEach(n),dk=r(I),In=l(I,"DIV",{class:!0});var Oy=T(In);g(hi.$$.fragment,Oy),pk=r(Oy),Dg=l(Oy,"P",{"data-svelte-h":!0}),y(Dg)!=="svelte-vbd5xj"&&(Dg.textContent=nx),Oy.forEach(n),mk=r(I),ss=l(I,"DIV",{class:!0});var Uf=T(ss);g(ui.$$.fragment,Uf),gk=r(Uf),Yg=l(Uf,"P",{"data-svelte-h":!0}),y(Yg)!=="svelte-1c2dshy"&&(Yg.innerHTML=ax),hk=r(Uf),Pg=l(Uf,"P",{"data-svelte-h":!0}),y(Pg)!=="svelte-1qvu1un"&&(Pg.textContent=rx),Uf.forEach(n),I.forEach(n),ny=r(e),Zs=l(e,"DIV",{class:!0});var Ky=T(Zs);g(fi.$$.fragment,Ky),uk=r(Ky),Ag=l(Ky,"P",{"data-svelte-h":!0}),y(Ag)!=="svelte-1rymat9"&&(Ag.innerHTML=ox),Ky.forEach(n),ay=r(e),Cs=l(e,"DIV",{class:!0});var eT=T(Cs);g(bi.$$.fragment,eT),fk=r(eT),Og=l(eT,"P",{"data-svelte-h":!0}),y(Og)!=="svelte-1obuarm"&&(Og.innerHTML=lx),eT.forEach(n),ry=r(e),Le=l(e,"DIV",{class:!0});var Na=T(Le);g(_i.$$.fragment,Na),bk=r(Na),Kg=l(Na,"P",{"data-svelte-h":!0}),y(Kg)!=="svelte-rxlesw"&&(Kg.textContent=ix),_k=r(Na),K=l(Na,"DIV",{class:!0});var Ye=T(K);g(yi.$$.fragment,Ye),yk=r(Ye),eh=l(Ye,"P",{"data-svelte-h":!0}),y(eh)!=="svelte-15hhlou"&&(eh.textContent=cx),Tk=r(Ye),th=l(Ye,"P",{"data-svelte-h":!0}),y(th)!=="svelte-e6h4hs"&&(th.innerHTML=dx),Mk=r(Ye),sh=l(Ye,"P",{"data-svelte-h":!0}),y(sh)!=="svelte-1w36vm3"&&(sh.innerHTML=px),vk=r(Ye),nh=l(Ye,"P",{"data-svelte-h":!0}),y(nh)!=="svelte-1niq0qw"&&(nh.innerHTML=mx),wk=r(Ye),ah=l(Ye,"P",{"data-svelte-h":!0}),y(ah)!=="svelte-af4g6f"&&(ah.textContent=gx),Ye.forEach(n),kk=r(Na),Bn=l(Na,"DIV",{class:!0});var tT=T(Bn);g(Ti.$$.fragment,tT),jk=r(tT),rh=l(tT,"P",{"data-svelte-h":!0}),y(rh)!=="svelte-eab6jp"&&(rh.textContent=hx),tT.forEach(n),Na.forEach(n),oy=r(e),g(Mi.$$.fragment,e),ly=r(e),Ne=l(e,"DIV",{class:!0});var Sa=T(Ne);g(vi.$$.fragment,Sa),$k=r(Sa),oh=l(Sa,"P",{"data-svelte-h":!0}),y(oh)!=="svelte-1fikjzl"&&(oh.innerHTML=ux),Jk=r(Sa),lh=l(Sa,"DIV",{class:!0});var BZ=T(lh);g(wi.$$.fragment,BZ),BZ.forEach(n),xk=r(Sa),ih=l(Sa,"DIV",{class:!0});var zZ=T(ih);g(ki.$$.fragment,zZ),zZ.forEach(n),Sa.forEach(n),iy=r(e),q=l(e,"DIV",{class:!0});var Pe=T(q);g(ji.$$.fragment,Pe),Uk=r(Pe),ch=l(Pe,"P",{"data-svelte-h":!0}),y(ch)!=="svelte-1lvowm"&&(ch.innerHTML=fx),Zk=r(Pe),dh=l(Pe,"P",{"data-svelte-h":!0}),y(dh)!=="svelte-19qrwo1"&&(dh.innerHTML=bx),Ck=r(Pe),ph=l(Pe,"P",{"data-svelte-h":!0}),y(ph)!=="svelte-l79sbt"&&(ph.innerHTML=_x),Wk=r(Pe),mh=l(Pe,"DIV",{class:!0});var VZ=T(mh);g($i.$$.fragment,VZ),VZ.forEach(n),Ik=r(Pe),gh=l(Pe,"DIV",{class:!0});var GZ=T(gh);g(Ji.$$.fragment,GZ),GZ.forEach(n),Pe.forEach(n),cy=r(e),Se=l(e,"DIV",{class:!0});var Ea=T(Se);g(xi.$$.fragment,Ea),Bk=r(Ea),hh=l(Ea,"P",{"data-svelte-h":!0}),y(hh)!=="svelte-cvew4t"&&(hh.innerHTML=yx),zk=r(Ea),uh=l(Ea,"DIV",{class:!0});var FZ=T(uh);g(Ui.$$.fragment,FZ),FZ.forEach(n),Vk=r(Ea),fh=l(Ea,"DIV",{class:!0});var XZ=T(fh);g(Zi.$$.fragment,XZ),XZ.forEach(n),Ea.forEach(n),dy=r(e),g(Ci.$$.fragment,e),py=r(e),X=l(e,"DIV",{class:!0});var we=T(X);g(Wi.$$.fragment,we),Gk=r(we),bh=l(we,"P",{"data-svelte-h":!0}),y(bh)!=="svelte-5jvlz5"&&(bh.textContent=Tx),Fk=r(we),g(zn.$$.fragment,we),Xk=r(we),g(Vn.$$.fragment,we),Rk=r(we),Gn=l(we,"DIV",{class:!0});var sT=T(Gn);g(Ii.$$.fragment,sT),Lk=r(sT),_h=l(sT,"P",{"data-svelte-h":!0}),y(_h)!=="svelte-10d94rs"&&(_h.textContent=Mx),sT.forEach(n),Nk=r(we),Fn=l(we,"DIV",{class:!0});var nT=T(Fn);g(Bi.$$.fragment,nT),Sk=r(nT),yh=l(nT,"P",{"data-svelte-h":!0}),y(yh)!=="svelte-tm945r"&&(yh.textContent=vx),nT.forEach(n),Ek=r(we),Xn=l(we,"DIV",{class:!0});var aT=T(Xn);g(zi.$$.fragment,aT),Hk=r(aT),Th=l(aT,"P",{"data-svelte-h":!0}),y(Th)!=="svelte-1i1356p"&&(Th.textContent=wx),aT.forEach(n),we.forEach(n),my=r(e),he=l(e,"DIV",{class:!0});var ds=T(he);g(Vi.$$.fragment,ds),qk=r(ds),Mh=l(ds,"P",{"data-svelte-h":!0}),y(Mh)!=="svelte-1dgaa64"&&(Mh.textContent=kx),Qk=r(ds),g(Rn.$$.fragment,ds),Dk=r(ds),g(Ln.$$.fragment,ds),Yk=r(ds),Nn=l(ds,"DIV",{class:!0});var rT=T(Nn);g(Gi.$$.fragment,rT),Pk=r(rT),vh=l(rT,"P",{"data-svelte-h":!0}),y(vh)!=="svelte-16i5iz"&&(vh.textContent=jx),rT.forEach(n),ds.forEach(n),gy=r(e),ue=l(e,"DIV",{class:!0});var ps=T(ue);g(Fi.$$.fragment,ps),Ak=r(ps),wh=l(ps,"P",{"data-svelte-h":!0}),y(wh)!=="svelte-wtlxwr"&&(wh.textContent=$x),Ok=r(ps),g(Sn.$$.fragment,ps),Kk=r(ps),g(En.$$.fragment,ps),e1=r(ps),Hn=l(ps,"DIV",{class:!0});var oT=T(Hn);g(Xi.$$.fragment,oT),t1=r(oT),kh=l(oT,"P",{"data-svelte-h":!0}),y(kh)!=="svelte-16i5iz"&&(kh.textContent=Jx),oT.forEach(n),ps.forEach(n),hy=r(e),g(Ri.$$.fragment,e),uy=r(e),Xt=l(e,"DIV",{class:!0});var Zf=T(Xt);g(Li.$$.fragment,Zf),s1=r(Zf),jh=l(Zf,"P",{"data-svelte-h":!0}),y(jh)!=="svelte-15qehu2"&&(jh.textContent=xx),n1=r(Zf),qn=l(Zf,"DIV",{class:!0});var lT=T(qn);g(Ni.$$.fragment,lT),a1=r(lT),$h=l(lT,"P",{"data-svelte-h":!0}),y($h)!=="svelte-dfcv5s"&&($h.innerHTML=Ux),lT.forEach(n),Zf.forEach(n),fy=r(e),Rt=l(e,"DIV",{class:!0});var Cf=T(Rt);g(Si.$$.fragment,Cf),r1=r(Cf),Jh=l(Cf,"P",{"data-svelte-h":!0}),y(Jh)!=="svelte-1sqibp"&&(Jh.textContent=Zx),o1=r(Cf),Qn=l(Cf,"DIV",{class:!0});var iT=T(Qn);g(Ei.$$.fragment,iT),l1=r(iT),xh=l(iT,"P",{"data-svelte-h":!0}),y(xh)!=="svelte-n0rwld"&&(xh.innerHTML=Cx),iT.forEach(n),Cf.forEach(n),by=r(e),Lt=l(e,"DIV",{class:!0});var Wf=T(Lt);g(Hi.$$.fragment,Wf),i1=r(Wf),Uh=l(Wf,"P",{"data-svelte-h":!0}),y(Uh)!=="svelte-157zylv"&&(Uh.textContent=Wx),c1=r(Wf),Dn=l(Wf,"DIV",{class:!0});var cT=T(Dn);g(qi.$$.fragment,cT),d1=r(cT),Zh=l(cT,"P",{"data-svelte-h":!0}),y(Zh)!=="svelte-15juztn"&&(Zh.textContent=Ix),cT.forEach(n),Wf.forEach(n),_y=r(e),B=l(e,"DIV",{class:!0});var L=T(B);g(Qi.$$.fragment,L),p1=r(L),Ch=l(L,"P",{"data-svelte-h":!0}),y(Ch)!=="svelte-11w7j52"&&(Ch.textContent=Bx),m1=r(L),Wh=l(L,"P",{"data-svelte-h":!0}),y(Wh)!=="svelte-1f9j82e"&&(Wh.innerHTML=zx),g1=r(L),g(Yn.$$.fragment,L),h1=r(L),Pn=l(L,"DIV",{class:!0});var dT=T(Pn);g(Di.$$.fragment,dT),u1=r(dT),Ih=l(dT,"P",{"data-svelte-h":!0}),y(Ih)!=="svelte-dfcv5s"&&(Ih.innerHTML=Vx),dT.forEach(n),f1=r(L),An=l(L,"DIV",{class:!0});var pT=T(An);g(Yi.$$.fragment,pT),b1=r(pT),Bh=l(pT,"P",{"data-svelte-h":!0}),y(Bh)!=="svelte-1nftdf9"&&(Bh.textContent=Gx),pT.forEach(n),_1=r(L),On=l(L,"DIV",{class:!0});var mT=T(On);g(Pi.$$.fragment,mT),y1=r(mT),zh=l(mT,"P",{"data-svelte-h":!0}),y(zh)!=="svelte-114iuj0"&&(zh.textContent=Fx),mT.forEach(n),T1=r(L),Kn=l(L,"DIV",{class:!0});var gT=T(Kn);g(Ai.$$.fragment,gT),M1=r(gT),Vh=l(gT,"P",{"data-svelte-h":!0}),y(Vh)!=="svelte-dst59w"&&(Vh.innerHTML=Xx),gT.forEach(n),v1=r(L),ea=l(L,"DIV",{class:!0});var hT=T(ea);g(Oi.$$.fragment,hT),w1=r(hT),Gh=l(hT,"P",{"data-svelte-h":!0}),y(Gh)!=="svelte-15y4kd1"&&(Gh.innerHTML=Rx),hT.forEach(n),L.forEach(n),yy=r(e),Q=l(e,"DIV",{class:!0});var Ae=T(Q);g(Ki.$$.fragment,Ae),k1=r(Ae),Fh=l(Ae,"P",{"data-svelte-h":!0}),y(Fh)!=="svelte-1x0oesy"&&(Fh.innerHTML=Lx),j1=r(Ae),Xh=l(Ae,"P",{"data-svelte-h":!0}),y(Xh)!=="svelte-2ai6qp"&&(Xh.innerHTML=Nx),$1=r(Ae),Rh=l(Ae,"P",{"data-svelte-h":!0}),y(Rh)!=="svelte-18fduhd"&&(Rh.innerHTML=Sx),J1=r(Ae),Lh=l(Ae,"DIV",{class:!0});var RZ=T(Lh);g(ec.$$.fragment,RZ),RZ.forEach(n),x1=r(Ae),ta=l(Ae,"DIV",{class:!0});var uT=T(ta);g(tc.$$.fragment,uT),U1=r(uT),Nh=l(uT,"P",{"data-svelte-h":!0}),y(Nh)!=="svelte-1nftdf9"&&(Nh.textContent=Ex),uT.forEach(n),Ae.forEach(n),Ty=r(e),Nt=l(e,"DIV",{class:!0});var If=T(Nt);g(sc.$$.fragment,If),Z1=r(If),Sh=l(If,"P",{"data-svelte-h":!0}),y(Sh)!=="svelte-pjm1pe"&&(Sh.innerHTML=Hx),C1=r(If),g(sa.$$.fragment,If),If.forEach(n),My=r(e),St=l(e,"DIV",{class:!0});var Bf=T(St);g(nc.$$.fragment,Bf),W1=r(Bf),Eh=l(Bf,"P",{"data-svelte-h":!0}),y(Eh)!=="svelte-api7s7"&&(Eh.innerHTML=qx),I1=r(Bf),g(na.$$.fragment,Bf),Bf.forEach(n),vy=r(e),z=l(e,"DIV",{class:!0});var ee=T(z);g(ac.$$.fragment,ee),B1=r(ee),Hh=l(ee,"P",{"data-svelte-h":!0}),y(Hh)!=="svelte-17e1m2l"&&(Hh.textContent=Qx),z1=r(ee),qh=l(ee,"P",{"data-svelte-h":!0}),y(qh)!=="svelte-ldcea6"&&(qh.innerHTML=Dx),V1=r(ee),Qh=l(ee,"P",{"data-svelte-h":!0}),y(Qh)!=="svelte-1f9j82e"&&(Qh.innerHTML=Yx),G1=r(ee),g(aa.$$.fragment,ee),F1=r(ee),ra=l(ee,"DIV",{class:!0});var fT=T(ra);g(rc.$$.fragment,fT),X1=r(fT),Dh=l(fT,"P",{"data-svelte-h":!0}),y(Dh)!=="svelte-dfcv5s"&&(Dh.innerHTML=Px),fT.forEach(n),R1=r(ee),oa=l(ee,"DIV",{class:!0});var bT=T(oa);g(oc.$$.fragment,bT),L1=r(bT),Yh=l(bT,"P",{"data-svelte-h":!0}),y(Yh)!=="svelte-1nftdf9"&&(Yh.textContent=Ax),bT.forEach(n),N1=r(ee),la=l(ee,"DIV",{class:!0});var _T=T(la);g(lc.$$.fragment,_T),S1=r(_T),Ph=l(_T,"P",{"data-svelte-h":!0}),y(Ph)!=="svelte-114iuj0"&&(Ph.textContent=Ox),_T.forEach(n),ee.forEach(n),wy=r(e),D=l(e,"DIV",{class:!0});var Oe=T(D);g(ic.$$.fragment,Oe),E1=r(Oe),Ah=l(Oe,"P",{"data-svelte-h":!0}),y(Ah)!=="svelte-bc0na4"&&(Ah.textContent=Kx),H1=r(Oe),Oh=l(Oe,"P",{"data-svelte-h":!0}),y(Oh)!=="svelte-1e0ffze"&&(Oh.textContent=eU),q1=r(Oe),ia=l(Oe,"DIV",{class:!0});var yT=T(ia);g(cc.$$.fragment,yT),Q1=r(yT),Kh=l(yT,"P",{"data-svelte-h":!0}),y(Kh)!=="svelte-dfcv5s"&&(Kh.innerHTML=tU),yT.forEach(n),D1=r(Oe),ca=l(Oe,"DIV",{class:!0});var TT=T(ca);g(dc.$$.fragment,TT),Y1=r(TT),eu=l(TT,"P",{"data-svelte-h":!0}),y(eu)!=="svelte-t93z5n"&&(eu.textContent=sU),TT.forEach(n),P1=r(Oe),da=l(Oe,"DIV",{class:!0});var MT=T(da);g(pc.$$.fragment,MT),A1=r(MT),tu=l(MT,"P",{"data-svelte-h":!0}),y(tu)!=="svelte-1rjgo2n"&&(tu.textContent=nU),MT.forEach(n),Oe.forEach(n),ky=r(e),Y=l(e,"DIV",{class:!0});var Ke=T(Y);g(mc.$$.fragment,Ke),O1=r(Ke),su=l(Ke,"P",{"data-svelte-h":!0}),y(su)!=="svelte-1atvuc"&&(su.innerHTML=aU),K1=r(Ke),g(pa.$$.fragment,Ke),ej=r(Ke),ma=l(Ke,"DIV",{class:!0});var vT=T(ma);g(gc.$$.fragment,vT),tj=r(vT),nu=l(vT,"P",{"data-svelte-h":!0}),y(nu)!=="svelte-vi6d54"&&(nu.innerHTML=rU),vT.forEach(n),sj=r(Ke),ga=l(Ke,"DIV",{class:!0});var wT=T(ga);g(hc.$$.fragment,wT),nj=r(wT),au=l(wT,"P",{"data-svelte-h":!0}),y(au)!=="svelte-14hqs6n"&&(au.textContent=oU),wT.forEach(n),aj=r(Ke),ha=l(Ke,"DIV",{class:!0});var kT=T(ha);g(uc.$$.fragment,kT),rj=r(kT),ru=l(kT,"P",{"data-svelte-h":!0}),y(ru)!=="svelte-135okg0"&&(ru.textContent=lU),kT.forEach(n),Ke.forEach(n),jy=r(e),P=l(e,"DIV",{class:!0});var et=T(P);g(fc.$$.fragment,et),oj=r(et),ou=l(et,"P",{"data-svelte-h":!0}),y(ou)!=="svelte-t1noj8"&&(ou.innerHTML=iU),lj=r(et),g(ua.$$.fragment,et),ij=r(et),fa=l(et,"DIV",{class:!0});var jT=T(fa);g(bc.$$.fragment,jT),cj=r(jT),lu=l(jT,"P",{"data-svelte-h":!0}),y(lu)!=="svelte-vi6d54"&&(lu.innerHTML=cU),jT.forEach(n),dj=r(et),ba=l(et,"DIV",{class:!0});var $T=T(ba);g(_c.$$.fragment,$T),pj=r($T),iu=l($T,"P",{"data-svelte-h":!0}),y(iu)!=="svelte-14hqs6n"&&(iu.textContent=dU),$T.forEach(n),mj=r(et),_a=l(et,"DIV",{class:!0});var JT=T(_a);g(yc.$$.fragment,JT),gj=r(JT),cu=l(JT,"P",{"data-svelte-h":!0}),y(cu)!=="svelte-oxae9u"&&(cu.textContent=pU),JT.forEach(n),et.forEach(n),$y=r(e),A=l(e,"DIV",{class:!0});var tt=T(A);g(Tc.$$.fragment,tt),hj=r(tt),du=l(tt,"P",{"data-svelte-h":!0}),y(du)!=="svelte-vsrfl3"&&(du.innerHTML=mU),uj=r(tt),g(ya.$$.fragment,tt),fj=r(tt),pu=l(tt,"DIV",{class:!0});var LZ=T(pu);g(Mc.$$.fragment,LZ),LZ.forEach(n),bj=r(tt),mu=l(tt,"DIV",{class:!0});var NZ=T(mu);g(vc.$$.fragment,NZ),NZ.forEach(n),_j=r(tt),Ta=l(tt,"DIV",{class:!0});var xT=T(Ta);g(wc.$$.fragment,xT),yj=r(xT),gu=l(xT,"P",{"data-svelte-h":!0}),y(gu)!=="svelte-135okg0"&&(gu.textContent=gU),xT.forEach(n),tt.forEach(n),Jy=r(e),V=l(e,"DIV",{class:!0});var te=T(V);g(kc.$$.fragment,te),Tj=r(te),hu=l(te,"P",{"data-svelte-h":!0}),y(hu)!=="svelte-16jubgm"&&(hu.innerHTML=hU),Mj=r(te),uu=l(te,"P",{"data-svelte-h":!0}),y(uu)!=="svelte-437xch"&&(uu.innerHTML=uU),vj=r(te),fu=l(te,"P",{"data-svelte-h":!0}),y(fu)!=="svelte-1qvpx79"&&(fu.textContent=fU),wj=r(te),bu=l(te,"P",{"data-svelte-h":!0}),y(bu)!=="svelte-dhmy5x"&&(bu.innerHTML=bU),kj=r(te),g(Ma.$$.fragment,te),jj=r(te),_u=l(te,"DIV",{class:!0});var SZ=T(_u);g(jc.$$.fragment,SZ),SZ.forEach(n),$j=r(te),yu=l(te,"DIV",{class:!0});var EZ=T(yu);g($c.$$.fragment,EZ),EZ.forEach(n),te.forEach(n),xy=r(e),G=l(e,"DIV",{class:!0});var se=T(G);g(Jc.$$.fragment,se),Jj=r(se),Tu=l(se,"P",{"data-svelte-h":!0}),y(Tu)!=="svelte-biazxg"&&(Tu.textContent=_U),xj=r(se),g(va.$$.fragment,se),Uj=r(se),wa=l(se,"DIV",{class:!0});var UT=T(wa);g(xc.$$.fragment,UT),Zj=r(UT),Mu=l(UT,"P",{"data-svelte-h":!0}),y(Mu)!=="svelte-1nftdf9"&&(Mu.textContent=yU),UT.forEach(n),Cj=r(se),ka=l(se,"DIV",{class:!0});var ZT=T(ka);g(Uc.$$.fragment,ZT),Wj=r(ZT),vu=l(ZT,"P",{"data-svelte-h":!0}),y(vu)!=="svelte-7yi3e7"&&(vu.innerHTML=TU),ZT.forEach(n),Ij=r(se),ja=l(se,"DIV",{class:!0});var CT=T(ja);g(Zc.$$.fragment,CT),Bj=r(CT),wu=l(CT,"P",{"data-svelte-h":!0}),y(wu)!=="svelte-1tx1mox"&&(wu.innerHTML=MU),CT.forEach(n),zj=r(se),ku=l(se,"DIV",{class:!0});var HZ=T(ku);g(Cc.$$.fragment,HZ),HZ.forEach(n),Vj=r(se),$a=l(se,"DIV",{class:!0});var WT=T($a);g(Wc.$$.fragment,WT),Gj=r(WT),ju=l(WT,"P",{"data-svelte-h":!0}),y(ju)!=="svelte-114iuj0"&&(ju.textContent=vU),WT.forEach(n),se.forEach(n),Uy=r(e),O=l(e,"DIV",{class:!0});var st=T(O);g(Ic.$$.fragment,st),Fj=r(st),$u=l(st,"P",{"data-svelte-h":!0}),y($u)!=="svelte-plgsbf"&&($u.textContent=wU),Xj=r(st),g(Ja.$$.fragment,st),Rj=r(st),Ju=l(st,"DIV",{class:!0});var qZ=T(Ju);g(Bc.$$.fragment,qZ),qZ.forEach(n),Lj=r(st),xu=l(st,"DIV",{class:!0});var QZ=T(xu);g(zc.$$.fragment,QZ),QZ.forEach(n),Nj=r(st),Uu=l(st,"DIV",{class:!0});var DZ=T(Uu);g(Vc.$$.fragment,DZ),DZ.forEach(n),st.forEach(n),Zy=r(e),g(Gc.$$.fragment,e),Cy=r(e),fe=l(e,"DIV",{class:!0});var ms=T(fe);g(Fc.$$.fragment,ms),Sj=r(ms),Zu=l(ms,"P",{"data-svelte-h":!0}),y(Zu)!=="svelte-8pa9bo"&&(Zu.innerHTML=kU),Ej=r(ms),Cu=l(ms,"P",{"data-svelte-h":!0}),y(Cu)!=="svelte-1wzt57b"&&(Cu.textContent=jU),Hj=r(ms),Wu=l(ms,"UL",{"data-svelte-h":!0}),y(Wu)!=="svelte-vgskhd"&&(Wu.innerHTML=$U),qj=r(ms),xa=l(ms,"DIV",{class:!0});var IT=T(xa);g(Xc.$$.fragment,IT),Qj=r(IT),Iu=l(IT,"P",{"data-svelte-h":!0}),y(Iu)!=="svelte-1eed40t"&&(Iu.textContent=JU),IT.forEach(n),ms.forEach(n),Wy=r(e),be=l(e,"DIV",{class:!0});var gs=T(be);g(Rc.$$.fragment,gs),Dj=r(gs),Bu=l(gs,"P",{"data-svelte-h":!0}),y(Bu)!=="svelte-17osgxw"&&(Bu.innerHTML=xU),Yj=r(gs),zu=l(gs,"P",{"data-svelte-h":!0}),y(zu)!=="svelte-y9hsik"&&(zu.innerHTML=UU),Pj=r(gs),g(Ua.$$.fragment,gs),Aj=r(gs),Za=l(gs,"DIV",{class:!0});var BT=T(Za);g(Lc.$$.fragment,BT),Oj=r(BT),Vu=l(BT,"P",{"data-svelte-h":!0}),y(Vu)!=="svelte-8xv78e"&&(Vu.textContent=ZU),BT.forEach(n),gs.forEach(n),Iy=r(e),Et=l(e,"DIV",{class:!0});var zf=T(Et);g(Nc.$$.fragment,zf),Kj=r(zf),Gu=l(zf,"P",{"data-svelte-h":!0}),y(Gu)!=="svelte-1fls76z"&&(Gu.innerHTML=CU),e$=r(zf),Fu=l(zf,"P",{"data-svelte-h":!0}),y(Fu)!=="svelte-o55m63"&&(Fu.innerHTML=WU),zf.forEach(n),By=r(e),R=l(e,"DIV",{class:!0});var ke=T(R);g(Sc.$$.fragment,ke),t$=r(ke),Xu=l(ke,"P",{"data-svelte-h":!0}),y(Xu)!=="svelte-ti06z9"&&(Xu.textContent=IU),s$=r(ke),Ru=l(ke,"P",{"data-svelte-h":!0}),y(Ru)!=="svelte-vwtjd"&&(Ru.innerHTML=BU),n$=r(ke),Lu=l(ke,"P",{"data-svelte-h":!0}),y(Lu)!=="svelte-m9ljkx"&&(Lu.textContent=zU),a$=r(ke),Nu=l(ke,"P",{"data-svelte-h":!0}),y(Nu)!=="svelte-6pahdo"&&(Nu.innerHTML=VU),r$=r(ke),Su=l(ke,"P",{"data-svelte-h":!0}),y(Su)!=="svelte-hswkmf"&&(Su.innerHTML=GU),o$=r(ke),Ca=l(ke,"DIV",{class:!0});var zT=T(Ca);g(Ec.$$.fragment,zT),l$=r(zT),Eu=l(zT,"P",{"data-svelte-h":!0}),y(Eu)!=="svelte-1pf58kz"&&(Eu.textContent=FU),zT.forEach(n),ke.forEach(n),zy=r(e),Ht=l(e,"DIV",{class:!0});var Vf=T(Ht);g(Hc.$$.fragment,Vf),i$=r(Vf),Hu=l(Vf,"P",{"data-svelte-h":!0}),y(Hu)!=="svelte-1hdm2wz"&&(Hu.innerHTML=XU),c$=r(Vf),g(Wa.$$.fragment,Vf),Vf.forEach(n),Vy=r(e),_e=l(e,"DIV",{class:!0});var hs=T(_e);g(qc.$$.fragment,hs),d$=r(hs),qu=l(hs,"P",{"data-svelte-h":!0}),y(qu)!=="svelte-8dvois"&&(qu.textContent=RU),p$=r(hs),Qu=l(hs,"P",{"data-svelte-h":!0}),y(Qu)!=="svelte-1xpqz8m"&&(Qu.textContent=LU),m$=r(hs),g(Ia.$$.fragment,hs),g$=r(hs),Du=l(hs,"DIV",{class:!0});var YZ=T(Du);g(Qc.$$.fragment,YZ),YZ.forEach(n),hs.forEach(n),Gy=r(e),g(Dc.$$.fragment,e),Fy=r(e),Ee=l(e,"DIV",{class:!0});var Ha=T(Ee);g(Yc.$$.fragment,Ha),h$=r(Ha),Yu=l(Ha,"P",{"data-svelte-h":!0}),y(Yu)!=="svelte-1q732ae"&&(Yu.innerHTML=NU),u$=r(Ha),g(Ba.$$.fragment,Ha),f$=r(Ha),za=l(Ha,"DIV",{class:!0});var VT=T(za);g(Pc.$$.fragment,VT),b$=r(VT),Pu=l(VT,"P",{"data-svelte-h":!0}),y(Pu)!=="svelte-1eed40t"&&(Pu.textContent=SU),VT.forEach(n),Ha.forEach(n),Xy=r(e),g(Ac.$$.fragment,e),Ry=r(e),Gf=l(e,"P",{}),T(Gf).forEach(n),this.h()},h(){M(i,"name","hf:doc:metadata"),M(i,"content",rW),M(us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ad,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Np,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(em,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Um,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Im,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Am,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Km,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ng,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ug,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ss,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ih,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(uh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(An,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(On,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ea,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ra,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(la,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ia,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ca,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ma,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ga,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ha,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ba,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ta,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ka,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ja,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ku,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ju,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Uu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xa,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Za,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ca,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Du,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(za,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,i),p(e,j,c),p(e,_,c),p(e,d,c),h(w,e,c),p(e,s,c),p(e,k,c),p(e,sb,c),h(qa,e,c),p(e,nb,c),p(e,Qa,c),p(e,ab,c),p(e,Da,c),p(e,rb,c),h(Ya,e,c),p(e,ob,c),p(e,Pa,c),p(e,lb,c),p(e,Aa,c),p(e,ib,c),p(e,Oa,c),p(e,cb,c),p(e,Ka,c),p(e,db,c),p(e,er,c),p(e,pb,c),h(tr,e,c),p(e,mb,c),p(e,sr,c),p(e,gb,c),p(e,nr,c),p(e,hb,c),p(e,ar,c),p(e,ub,c),h(rr,e,c),p(e,fb,c),p(e,us,c),h(or,us,null),t(us,GT),t(us,ud),p(e,bb,c),p(e,fs,c),h(lr,fs,null),t(fs,FT),t(fs,fd),p(e,_b,c),p(e,bs,c),h(ir,bs,null),t(bs,XT),t(bs,bd),p(e,yb,c),p(e,_s,c),h(cr,_s,null),t(_s,RT),t(_s,_d),p(e,Tb,c),h(dr,e,c),p(e,Mb,c),p(e,ys,c),h(pr,ys,null),t(ys,LT),t(ys,yd),p(e,vb,c),p(e,Ts,c),h(mr,Ts,null),t(Ts,NT),t(Ts,Td),p(e,wb,c),p(e,Ms,c),h(gr,Ms,null),t(Ms,ST),t(Ms,Md),p(e,kb,c),p(e,vs,c),h(hr,vs,null),t(vs,ET),t(vs,vd),p(e,jb,c),p(e,ws,c),h(ur,ws,null),t(ws,HT),t(ws,wd),p(e,$b,c),p(e,ks,c),h(fr,ks,null),t(ks,qT),t(ks,kd),p(e,Jb,c),p(e,js,c),h(br,js,null),t(js,QT),t(js,jd),p(e,xb,c),p(e,$s,c),h(_r,$s,null),t($s,DT),t($s,$d),p(e,Ub,c),p(e,Js,c),h(yr,Js,null),t(Js,YT),t(Js,Jd),p(e,Zb,c),p(e,xs,c),h(Tr,xs,null),t(xs,PT),t(xs,xd),p(e,Cb,c),h(Mr,e,c),p(e,Wb,c),p(e,nt,c),h(vr,nt,null),t(nt,AT),t(nt,Ud),t(nt,OT),t(nt,Fs),h(wr,Fs,null),t(Fs,KT),t(Fs,Zd),p(e,Ib,c),p(e,at,c),h(kr,at,null),t(at,eM),t(at,Cd),t(at,tM),t(at,Xs),h(jr,Xs,null),t(Xs,sM),t(Xs,Wd),p(e,Bb,c),p(e,rt,c),h($r,rt,null),t(rt,nM),t(rt,Id),t(rt,aM),t(rt,Rs),h(Jr,Rs,null),t(Rs,rM),t(Rs,Bd),p(e,zb,c),h(xr,e,c),p(e,Vb,c),p(e,Ur,c),p(e,Gb,c),h(Zr,e,c),p(e,Fb,c),p(e,je,c),h(Cr,je,null),t(je,oM),t(je,zd),t(je,lM),h(Ls,je,null),t(je,iM),t(je,Vd),h(Wr,Vd,null),p(e,Xb,c),p(e,N,c),h(Ir,N,null),t(N,cM),t(N,Gd),t(N,dM),t(N,Fd),t(N,pM),h(Ns,N,null),t(N,mM),h(Ss,N,null),t(N,gM),t(N,Xd),h(Br,Xd,null),p(e,Rb,c),p(e,ae,c),h(zr,ae,null),t(ae,hM),t(ae,Rd),t(ae,uM),t(ae,Ld),t(ae,fM),h(Es,ae,null),t(ae,bM),t(ae,Nd),h(Vr,Nd,null),p(e,Lb,c),p(e,re,c),h(Gr,re,null),t(re,_M),t(re,Sd),t(re,yM),t(re,Ed),t(re,TM),h(Hs,re,null),t(re,MM),t(re,Hd),h(Fr,Hd,null),p(e,Nb,c),p(e,$e,c),h(Xr,$e,null),t($e,vM),t($e,qd),t($e,wM),h(qs,$e,null),t($e,kM),t($e,Qd),h(Rr,Qd,null),p(e,Sb,c),p(e,Je,c),h(Lr,Je,null),t(Je,jM),t(Je,Dd),t(Je,$M),h(Qs,Je,null),t(Je,JM),t(Je,Yd),h(Nr,Yd,null),p(e,Eb,c),p(e,xe,c),h(Sr,xe,null),t(xe,xM),t(xe,Pd),t(xe,UM),h(Ds,xe,null),t(xe,ZM),t(xe,Ad),h(Er,Ad,null),p(e,Hb,c),p(e,Ue,c),h(Hr,Ue,null),t(Ue,CM),t(Ue,Od),t(Ue,WM),h(Ys,Ue,null),t(Ue,IM),t(Ue,Kd),h(qr,Kd,null),p(e,qb,c),p(e,Ze,c),h(Qr,Ze,null),t(Ze,BM),t(Ze,ep),t(Ze,zM),h(Ps,Ze,null),t(Ze,VM),t(Ze,tp),h(Dr,tp,null),p(e,Qb,c),p(e,S,c),h(Yr,S,null),t(S,GM),t(S,sp),t(S,FM),t(S,np),t(S,XM),t(S,ap),t(S,RM),h(As,S,null),t(S,LM),t(S,rp),h(Pr,rp,null),p(e,Db,c),p(e,Ce,c),h(Ar,Ce,null),t(Ce,NM),t(Ce,op),t(Ce,SM),t(Ce,lp),t(Ce,EM),t(Ce,ip),h(Or,ip,null),p(e,Yb,c),p(e,We,c),h(Kr,We,null),t(We,HM),t(We,cp),t(We,qM),h(Os,We,null),t(We,QM),t(We,dp),h(eo,dp,null),p(e,Pb,c),p(e,ot,c),h(to,ot,null),t(ot,DM),t(ot,pp),t(ot,YM),t(ot,mp),h(so,mp,null),p(e,Ab,c),p(e,lt,c),h(no,lt,null),t(lt,PM),t(lt,gp),t(lt,AM),t(lt,hp),h(ao,hp,null),p(e,Ob,c),p(e,Ie,c),h(ro,Ie,null),t(Ie,OM),t(Ie,up),t(Ie,KM),h(Ks,Ie,null),t(Ie,ev),t(Ie,fp),h(oo,fp,null),p(e,Kb,c),p(e,Be,c),h(lo,Be,null),t(Be,tv),t(Be,bp),t(Be,sv),h(en,Be,null),t(Be,nv),t(Be,_p),h(io,_p,null),p(e,e_,c),p(e,E,c),h(co,E,null),t(E,av),t(E,yp),t(E,rv),t(E,Tp),t(E,ov),t(E,Mp),t(E,lv),h(tn,E,null),t(E,iv),t(E,vp),h(po,vp,null),p(e,t_,c),p(e,oe,c),h(mo,oe,null),t(oe,cv),t(oe,wp),t(oe,dv),h(sn,oe,null),t(oe,pv),h(nn,oe,null),t(oe,mv),t(oe,kp),h(go,kp,null),p(e,s_,c),p(e,le,c),h(ho,le,null),t(le,gv),t(le,jp),t(le,hv),h(an,le,null),t(le,uv),h(rn,le,null),t(le,fv),t(le,$p),h(uo,$p,null),p(e,n_,c),p(e,ze,c),h(fo,ze,null),t(ze,bv),t(ze,Jp),t(ze,_v),h(on,ze,null),t(ze,yv),t(ze,xp),h(bo,xp,null),p(e,a_,c),p(e,ie,c),h(_o,ie,null),t(ie,Tv),t(ie,Up),t(ie,Mv),t(ie,Zp),t(ie,vv),h(ln,ie,null),t(ie,wv),t(ie,Cp),h(yo,Cp,null),p(e,r_,c),p(e,ce,c),h(To,ce,null),t(ce,kv),t(ce,Wp),t(ce,jv),h(cn,ce,null),t(ce,$v),h(dn,ce,null),t(ce,Jv),t(ce,Ip),h(Mo,Ip,null),p(e,o_,c),p(e,Ve,c),h(vo,Ve,null),t(Ve,xv),t(Ve,Bp),t(Ve,Uv),h(pn,Ve,null),t(Ve,Zv),t(Ve,zp),h(wo,zp,null),p(e,l_,c),p(e,Ge,c),h(ko,Ge,null),t(Ge,Cv),t(Ge,Vp),t(Ge,Wv),h(mn,Ge,null),t(Ge,Iv),t(Ge,Gp),h(jo,Gp,null),p(e,i_,c),p(e,F,c),h($o,F,null),t(F,Bv),t(F,Fp),t(F,zv),t(F,Xp),t(F,Vv),t(F,Rp),t(F,Gv),t(F,Lp),t(F,Fv),h(gn,F,null),t(F,Xv),t(F,Np),h(Jo,Np,null),p(e,c_,c),p(e,de,c),h(xo,de,null),t(de,Rv),t(de,Sp),t(de,Lv),h(hn,de,null),t(de,Nv),h(un,de,null),t(de,Sv),t(de,Ep),h(Uo,Ep,null),p(e,d_,c),p(e,Fe,c),h(Zo,Fe,null),t(Fe,Ev),t(Fe,Hp),t(Fe,Hv),h(fn,Fe,null),t(Fe,qv),t(Fe,qp),h(Co,qp,null),p(e,p_,c),p(e,Xe,c),h(Wo,Xe,null),t(Xe,Qv),t(Xe,Qp),t(Xe,Dv),h(bn,Xe,null),t(Xe,Yv),t(Xe,Dp),h(Io,Dp,null),p(e,m_,c),p(e,pe,c),h(Bo,pe,null),t(pe,Pv),t(pe,Yp),t(pe,Av),t(pe,Pp),t(pe,Ov),h(_n,pe,null),t(pe,Kv),t(pe,Ap),h(zo,Ap,null),p(e,g_,c),p(e,me,c),h(Vo,me,null),t(me,ew),t(me,Op),t(me,tw),t(me,Kp),t(me,sw),h(yn,me,null),t(me,nw),t(me,em),h(Go,em,null),p(e,h_,c),p(e,ge,c),h(Fo,ge,null),t(ge,aw),t(ge,tm),t(ge,rw),t(ge,sm),t(ge,ow),h(Tn,ge,null),t(ge,lw),t(ge,nm),h(Xo,nm,null),p(e,u_,c),p(e,H,c),h(Ro,H,null),t(H,iw),t(H,am),t(H,cw),t(H,rm),t(H,dw),t(H,om),t(H,pw),h(Mn,H,null),t(H,mw),t(H,lm),h(Lo,lm,null),p(e,f_,c),h(No,e,c),p(e,b_,c),p(e,it,c),h(So,it,null),t(it,gw),t(it,im),t(it,hw),t(it,cm),h(Eo,cm,null),p(e,__,c),p(e,ct,c),h(Ho,ct,null),t(ct,uw),t(ct,dm),t(ct,fw),t(ct,pm),h(qo,pm,null),p(e,y_,c),p(e,dt,c),h(Qo,dt,null),t(dt,bw),t(dt,mm),t(dt,_w),t(dt,gm),h(Do,gm,null),p(e,T_,c),p(e,pt,c),h(Yo,pt,null),t(pt,yw),t(pt,hm),t(pt,Tw),t(pt,vn),h(Po,vn,null),t(vn,Mw),t(vn,um),p(e,M_,c),p(e,mt,c),h(Ao,mt,null),t(mt,vw),t(mt,fm),t(mt,ww),t(mt,bm),h(Oo,bm,null),p(e,v_,c),p(e,gt,c),h(Ko,gt,null),t(gt,kw),t(gt,_m),t(gt,jw),t(gt,wn),h(el,wn,null),t(wn,$w),t(wn,ym),p(e,w_,c),p(e,ht,c),h(tl,ht,null),t(ht,Jw),t(ht,Tm),t(ht,xw),t(ht,Mm),h(sl,Mm,null),p(e,k_,c),p(e,ut,c),h(nl,ut,null),t(ut,Uw),t(ut,vm),t(ut,Zw),t(ut,wm),h(al,wm,null),p(e,j_,c),p(e,ft,c),h(rl,ft,null),t(ft,Cw),t(ft,km),t(ft,Ww),t(ft,jm),h(ol,jm,null),p(e,$_,c),p(e,bt,c),h(ll,bt,null),t(bt,Iw),t(bt,$m),t(bt,Bw),t(bt,Jm),h(il,Jm,null),p(e,J_,c),p(e,_t,c),h(cl,_t,null),t(_t,zw),t(_t,xm),t(_t,Vw),t(_t,Um),h(dl,Um,null),p(e,x_,c),p(e,yt,c),h(pl,yt,null),t(yt,Gw),t(yt,Zm),t(yt,Fw),t(yt,Cm),h(ml,Cm,null),p(e,U_,c),p(e,Tt,c),h(gl,Tt,null),t(Tt,Xw),t(Tt,Wm),t(Tt,Rw),t(Tt,Im),h(hl,Im,null),p(e,Z_,c),p(e,Mt,c),h(ul,Mt,null),t(Mt,Lw),t(Mt,Bm),t(Mt,Nw),t(Mt,zm),h(fl,zm,null),p(e,C_,c),p(e,vt,c),h(bl,vt,null),t(vt,Sw),t(vt,Vm),t(vt,Ew),t(vt,Gm),h(_l,Gm,null),p(e,W_,c),h(yl,e,c),p(e,I_,c),p(e,wt,c),h(Tl,wt,null),t(wt,Hw),t(wt,Fm),t(wt,qw),t(wt,Xm),h(Ml,Xm,null),p(e,B_,c),p(e,kt,c),h(vl,kt,null),t(kt,Qw),t(kt,Rm),t(kt,Dw),t(kt,Lm),h(wl,Lm,null),p(e,z_,c),p(e,jt,c),h(kl,jt,null),t(jt,Yw),t(jt,Nm),t(jt,Pw),t(jt,Sm),h(jl,Sm,null),p(e,V_,c),p(e,$t,c),h($l,$t,null),t($t,Aw),t($t,Em),t($t,Ow),t($t,kn),h(Jl,kn,null),t(kn,Kw),t(kn,Hm),p(e,G_,c),p(e,Jt,c),h(xl,Jt,null),t(Jt,e2),t(Jt,qm),t(Jt,t2),t(Jt,Qm),h(Ul,Qm,null),p(e,F_,c),p(e,xt,c),h(Zl,xt,null),t(xt,s2),t(xt,Dm),t(xt,n2),t(xt,jn),h(Cl,jn,null),t(jn,a2),t(jn,Ym),p(e,X_,c),p(e,Ut,c),h(Wl,Ut,null),t(Ut,r2),t(Ut,Pm),t(Ut,o2),t(Ut,Am),h(Il,Am,null),p(e,R_,c),p(e,Zt,c),h(Bl,Zt,null),t(Zt,l2),t(Zt,Om),t(Zt,i2),t(Zt,Km),h(zl,Km,null),p(e,L_,c),p(e,Ct,c),h(Vl,Ct,null),t(Ct,c2),t(Ct,eg),t(Ct,d2),t(Ct,tg),h(Gl,tg,null),p(e,N_,c),p(e,Wt,c),h(Fl,Wt,null),t(Wt,p2),t(Wt,sg),t(Wt,m2),t(Wt,ng),h(Xl,ng,null),p(e,S_,c),p(e,It,c),h(Rl,It,null),t(It,g2),t(It,ag),t(It,h2),t(It,rg),h(Ll,rg,null),p(e,E_,c),p(e,Bt,c),h(Nl,Bt,null),t(Bt,u2),t(Bt,og),t(Bt,f2),t(Bt,lg),h(Sl,lg,null),p(e,H_,c),p(e,zt,c),h(El,zt,null),t(zt,b2),t(zt,ig),t(zt,_2),t(zt,cg),h(Hl,cg,null),p(e,q_,c),h(ql,e,c),p(e,Q_,c),p(e,Ql,c),p(e,D_,c),p(e,Re,c),h(Dl,Re,null),t(Re,y2),t(Re,dg),t(Re,T2),t(Re,pg),t(Re,M2),t(Re,mg),h(Yl,mg,null),p(e,Y_,c),p(e,Us,c),h(Pl,Us,null),t(Us,v2),t(Us,gg),h(Al,gg,null),p(e,P_,c),p(e,Vt,c),h(Ol,Vt,null),t(Vt,w2),t(Vt,hg),t(Vt,k2),t(Vt,ug),h(Kl,ug,null),p(e,A_,c),p(e,Gt,c),h(ei,Gt,null),t(Gt,j2),t(Gt,fg),t(Gt,$2),t(Gt,bg),h(ti,bg,null),p(e,O_,c),p(e,x,c),h(si,x,null),t(x,J2),t(x,_g),t(x,x2),t(x,yg),t(x,U2),t(x,Tg),t(x,Z2),t(x,Mg),t(x,C2),t(x,vg),t(x,W2),t(x,wg),t(x,I2),t(x,kg),t(x,B2),t(x,jg),t(x,z2),t(x,$g),t(x,V2),t(x,Jg),t(x,G2),t(x,xg),t(x,F2),t(x,Ug),t(x,X2),t(x,Zg),t(x,R2),t(x,Cg),t(x,L2),t(x,Wg),t(x,N2),t(x,Ig),t(x,S2),t(x,Bg),t(x,E2),t(x,zg),t(x,H2),t(x,Vg),t(x,q2),h($n,x,null),t(x,Q2),t(x,Gg),h(ni,Gg,null),p(e,K_,c),p(e,Ft,c),h(ai,Ft,null),t(Ft,D2),t(Ft,Fg),t(Ft,Y2),t(Ft,Xg),h(ri,Xg,null),p(e,ey,c),h(oi,e,c),p(e,ty,c),p(e,li,c),p(e,sy,c),p(e,W,c),h(ii,W,null),t(W,P2),t(W,Rg),t(W,A2),t(W,Lg),t(W,O2),h(Jn,W,null),t(W,K2),t(W,Ng),t(W,ek),t(W,xn),h(ci,xn,null),t(xn,tk),t(xn,Sg),t(W,sk),t(W,Un),h(di,Un,null),t(Un,nk),t(Un,Eg),t(W,ak),t(W,Zn),h(pi,Zn,null),t(Zn,rk),t(Zn,Hg),t(W,ok),t(W,Cn),h(mi,Cn,null),t(Cn,lk),t(Cn,qg),t(W,ik),t(W,Wn),h(gi,Wn,null),t(Wn,ck),t(Wn,Qg),t(W,dk),t(W,In),h(hi,In,null),t(In,pk),t(In,Dg),t(W,mk),t(W,ss),h(ui,ss,null),t(ss,gk),t(ss,Yg),t(ss,hk),t(ss,Pg),p(e,ny,c),p(e,Zs,c),h(fi,Zs,null),t(Zs,uk),t(Zs,Ag),p(e,ay,c),p(e,Cs,c),h(bi,Cs,null),t(Cs,fk),t(Cs,Og),p(e,ry,c),p(e,Le,c),h(_i,Le,null),t(Le,bk),t(Le,Kg),t(Le,_k),t(Le,K),h(yi,K,null),t(K,yk),t(K,eh),t(K,Tk),t(K,th),t(K,Mk),t(K,sh),t(K,vk),t(K,nh),t(K,wk),t(K,ah),t(Le,kk),t(Le,Bn),h(Ti,Bn,null),t(Bn,jk),t(Bn,rh),p(e,oy,c),h(Mi,e,c),p(e,ly,c),p(e,Ne,c),h(vi,Ne,null),t(Ne,$k),t(Ne,oh),t(Ne,Jk),t(Ne,lh),h(wi,lh,null),t(Ne,xk),t(Ne,ih),h(ki,ih,null),p(e,iy,c),p(e,q,c),h(ji,q,null),t(q,Uk),t(q,ch),t(q,Zk),t(q,dh),t(q,Ck),t(q,ph),t(q,Wk),t(q,mh),h($i,mh,null),t(q,Ik),t(q,gh),h(Ji,gh,null),p(e,cy,c),p(e,Se,c),h(xi,Se,null),t(Se,Bk),t(Se,hh),t(Se,zk),t(Se,uh),h(Ui,uh,null),t(Se,Vk),t(Se,fh),h(Zi,fh,null),p(e,dy,c),h(Ci,e,c),p(e,py,c),p(e,X,c),h(Wi,X,null),t(X,Gk),t(X,bh),t(X,Fk),h(zn,X,null),t(X,Xk),h(Vn,X,null),t(X,Rk),t(X,Gn),h(Ii,Gn,null),t(Gn,Lk),t(Gn,_h),t(X,Nk),t(X,Fn),h(Bi,Fn,null),t(Fn,Sk),t(Fn,yh),t(X,Ek),t(X,Xn),h(zi,Xn,null),t(Xn,Hk),t(Xn,Th),p(e,my,c),p(e,he,c),h(Vi,he,null),t(he,qk),t(he,Mh),t(he,Qk),h(Rn,he,null),t(he,Dk),h(Ln,he,null),t(he,Yk),t(he,Nn),h(Gi,Nn,null),t(Nn,Pk),t(Nn,vh),p(e,gy,c),p(e,ue,c),h(Fi,ue,null),t(ue,Ak),t(ue,wh),t(ue,Ok),h(Sn,ue,null),t(ue,Kk),h(En,ue,null),t(ue,e1),t(ue,Hn),h(Xi,Hn,null),t(Hn,t1),t(Hn,kh),p(e,hy,c),h(Ri,e,c),p(e,uy,c),p(e,Xt,c),h(Li,Xt,null),t(Xt,s1),t(Xt,jh),t(Xt,n1),t(Xt,qn),h(Ni,qn,null),t(qn,a1),t(qn,$h),p(e,fy,c),p(e,Rt,c),h(Si,Rt,null),t(Rt,r1),t(Rt,Jh),t(Rt,o1),t(Rt,Qn),h(Ei,Qn,null),t(Qn,l1),t(Qn,xh),p(e,by,c),p(e,Lt,c),h(Hi,Lt,null),t(Lt,i1),t(Lt,Uh),t(Lt,c1),t(Lt,Dn),h(qi,Dn,null),t(Dn,d1),t(Dn,Zh),p(e,_y,c),p(e,B,c),h(Qi,B,null),t(B,p1),t(B,Ch),t(B,m1),t(B,Wh),t(B,g1),h(Yn,B,null),t(B,h1),t(B,Pn),h(Di,Pn,null),t(Pn,u1),t(Pn,Ih),t(B,f1),t(B,An),h(Yi,An,null),t(An,b1),t(An,Bh),t(B,_1),t(B,On),h(Pi,On,null),t(On,y1),t(On,zh),t(B,T1),t(B,Kn),h(Ai,Kn,null),t(Kn,M1),t(Kn,Vh),t(B,v1),t(B,ea),h(Oi,ea,null),t(ea,w1),t(ea,Gh),p(e,yy,c),p(e,Q,c),h(Ki,Q,null),t(Q,k1),t(Q,Fh),t(Q,j1),t(Q,Xh),t(Q,$1),t(Q,Rh),t(Q,J1),t(Q,Lh),h(ec,Lh,null),t(Q,x1),t(Q,ta),h(tc,ta,null),t(ta,U1),t(ta,Nh),p(e,Ty,c),p(e,Nt,c),h(sc,Nt,null),t(Nt,Z1),t(Nt,Sh),t(Nt,C1),h(sa,Nt,null),p(e,My,c),p(e,St,c),h(nc,St,null),t(St,W1),t(St,Eh),t(St,I1),h(na,St,null),p(e,vy,c),p(e,z,c),h(ac,z,null),t(z,B1),t(z,Hh),t(z,z1),t(z,qh),t(z,V1),t(z,Qh),t(z,G1),h(aa,z,null),t(z,F1),t(z,ra),h(rc,ra,null),t(ra,X1),t(ra,Dh),t(z,R1),t(z,oa),h(oc,oa,null),t(oa,L1),t(oa,Yh),t(z,N1),t(z,la),h(lc,la,null),t(la,S1),t(la,Ph),p(e,wy,c),p(e,D,c),h(ic,D,null),t(D,E1),t(D,Ah),t(D,H1),t(D,Oh),t(D,q1),t(D,ia),h(cc,ia,null),t(ia,Q1),t(ia,Kh),t(D,D1),t(D,ca),h(dc,ca,null),t(ca,Y1),t(ca,eu),t(D,P1),t(D,da),h(pc,da,null),t(da,A1),t(da,tu),p(e,ky,c),p(e,Y,c),h(mc,Y,null),t(Y,O1),t(Y,su),t(Y,K1),h(pa,Y,null),t(Y,ej),t(Y,ma),h(gc,ma,null),t(ma,tj),t(ma,nu),t(Y,sj),t(Y,ga),h(hc,ga,null),t(ga,nj),t(ga,au),t(Y,aj),t(Y,ha),h(uc,ha,null),t(ha,rj),t(ha,ru),p(e,jy,c),p(e,P,c),h(fc,P,null),t(P,oj),t(P,ou),t(P,lj),h(ua,P,null),t(P,ij),t(P,fa),h(bc,fa,null),t(fa,cj),t(fa,lu),t(P,dj),t(P,ba),h(_c,ba,null),t(ba,pj),t(ba,iu),t(P,mj),t(P,_a),h(yc,_a,null),t(_a,gj),t(_a,cu),p(e,$y,c),p(e,A,c),h(Tc,A,null),t(A,hj),t(A,du),t(A,uj),h(ya,A,null),t(A,fj),t(A,pu),h(Mc,pu,null),t(A,bj),t(A,mu),h(vc,mu,null),t(A,_j),t(A,Ta),h(wc,Ta,null),t(Ta,yj),t(Ta,gu),p(e,Jy,c),p(e,V,c),h(kc,V,null),t(V,Tj),t(V,hu),t(V,Mj),t(V,uu),t(V,vj),t(V,fu),t(V,wj),t(V,bu),t(V,kj),h(Ma,V,null),t(V,jj),t(V,_u),h(jc,_u,null),t(V,$j),t(V,yu),h($c,yu,null),p(e,xy,c),p(e,G,c),h(Jc,G,null),t(G,Jj),t(G,Tu),t(G,xj),h(va,G,null),t(G,Uj),t(G,wa),h(xc,wa,null),t(wa,Zj),t(wa,Mu),t(G,Cj),t(G,ka),h(Uc,ka,null),t(ka,Wj),t(ka,vu),t(G,Ij),t(G,ja),h(Zc,ja,null),t(ja,Bj),t(ja,wu),t(G,zj),t(G,ku),h(Cc,ku,null),t(G,Vj),t(G,$a),h(Wc,$a,null),t($a,Gj),t($a,ju),p(e,Uy,c),p(e,O,c),h(Ic,O,null),t(O,Fj),t(O,$u),t(O,Xj),h(Ja,O,null),t(O,Rj),t(O,Ju),h(Bc,Ju,null),t(O,Lj),t(O,xu),h(zc,xu,null),t(O,Nj),t(O,Uu),h(Vc,Uu,null),p(e,Zy,c),h(Gc,e,c),p(e,Cy,c),p(e,fe,c),h(Fc,fe,null),t(fe,Sj),t(fe,Zu),t(fe,Ej),t(fe,Cu),t(fe,Hj),t(fe,Wu),t(fe,qj),t(fe,xa),h(Xc,xa,null),t(xa,Qj),t(xa,Iu),p(e,Wy,c),p(e,be,c),h(Rc,be,null),t(be,Dj),t(be,Bu),t(be,Yj),t(be,zu),t(be,Pj),h(Ua,be,null),t(be,Aj),t(be,Za),h(Lc,Za,null),t(Za,Oj),t(Za,Vu),p(e,Iy,c),p(e,Et,c),h(Nc,Et,null),t(Et,Kj),t(Et,Gu),t(Et,e$),t(Et,Fu),p(e,By,c),p(e,R,c),h(Sc,R,null),t(R,t$),t(R,Xu),t(R,s$),t(R,Ru),t(R,n$),t(R,Lu),t(R,a$),t(R,Nu),t(R,r$),t(R,Su),t(R,o$),t(R,Ca),h(Ec,Ca,null),t(Ca,l$),t(Ca,Eu),p(e,zy,c),p(e,Ht,c),h(Hc,Ht,null),t(Ht,i$),t(Ht,Hu),t(Ht,c$),h(Wa,Ht,null),p(e,Vy,c),p(e,_e,c),h(qc,_e,null),t(_e,d$),t(_e,qu),t(_e,p$),t(_e,Qu),t(_e,m$),h(Ia,_e,null),t(_e,g$),t(_e,Du),h(Qc,Du,null),p(e,Gy,c),h(Dc,e,c),p(e,Fy,c),p(e,Ee,c),h(Yc,Ee,null),t(Ee,h$),t(Ee,Yu),t(Ee,u$),h(Ba,Ee,null),t(Ee,f$),t(Ee,za),h(Pc,za,null),t(za,b$),t(za,Pu),p(e,Xy,c),h(Ac,e,c),p(e,Ry,c),p(e,Gf,c),Ly=!0},p(e,[c]){const Oc={};c&2&&(Oc.$$scope={dirty:c,ctx:e}),Ls.$set(Oc);const Kc={};c&2&&(Kc.$$scope={dirty:c,ctx:e}),Ns.$set(Kc);const ed={};c&2&&(ed.$$scope={dirty:c,ctx:e}),Ss.$set(ed);const td={};c&2&&(td.$$scope={dirty:c,ctx:e}),Es.$set(td);const sd={};c&2&&(sd.$$scope={dirty:c,ctx:e}),Hs.$set(sd);const nd={};c&2&&(nd.$$scope={dirty:c,ctx:e}),qs.$set(nd);const ad={};c&2&&(ad.$$scope={dirty:c,ctx:e}),Qs.$set(ad);const rd={};c&2&&(rd.$$scope={dirty:c,ctx:e}),Ds.$set(rd);const od={};c&2&&(od.$$scope={dirty:c,ctx:e}),Ys.$set(od);const ld={};c&2&&(ld.$$scope={dirty:c,ctx:e}),Ps.$set(ld);const id={};c&2&&(id.$$scope={dirty:c,ctx:e}),As.$set(id);const cd={};c&2&&(cd.$$scope={dirty:c,ctx:e}),Os.$set(cd);const dd={};c&2&&(dd.$$scope={dirty:c,ctx:e}),Ks.$set(dd);const pd={};c&2&&(pd.$$scope={dirty:c,ctx:e}),en.$set(pd);const Ws={};c&2&&(Ws.$$scope={dirty:c,ctx:e}),tn.$set(Ws);const md={};c&2&&(md.$$scope={dirty:c,ctx:e}),sn.$set(md);const Is={};c&2&&(Is.$$scope={dirty:c,ctx:e}),nn.$set(Is);const gd={};c&2&&(gd.$$scope={dirty:c,ctx:e}),an.$set(gd);const Bs={};c&2&&(Bs.$$scope={dirty:c,ctx:e}),rn.$set(Bs);const hd={};c&2&&(hd.$$scope={dirty:c,ctx:e}),on.$set(hd);const qt={};c&2&&(qt.$$scope={dirty:c,ctx:e}),ln.$set(qt);const Ff={};c&2&&(Ff.$$scope={dirty:c,ctx:e}),cn.$set(Ff);const ye={};c&2&&(ye.$$scope={dirty:c,ctx:e}),dn.$set(ye);const Xf={};c&2&&(Xf.$$scope={dirty:c,ctx:e}),pn.$set(Xf);const He={};c&2&&(He.$$scope={dirty:c,ctx:e}),mn.$set(He);const Rf={};c&2&&(Rf.$$scope={dirty:c,ctx:e}),gn.$set(Rf);const qe={};c&2&&(qe.$$scope={dirty:c,ctx:e}),hn.$set(qe);const Lf={};c&2&&(Lf.$$scope={dirty:c,ctx:e}),un.$set(Lf);const Qt={};c&2&&(Qt.$$scope={dirty:c,ctx:e}),fn.$set(Qt);const Nf={};c&2&&(Nf.$$scope={dirty:c,ctx:e}),bn.$set(Nf);const Dt={};c&2&&(Dt.$$scope={dirty:c,ctx:e}),_n.$set(Dt);const Sf={};c&2&&(Sf.$$scope={dirty:c,ctx:e}),yn.$set(Sf);const Yt={};c&2&&(Yt.$$scope={dirty:c,ctx:e}),Tn.$set(Yt);const Ef={};c&2&&(Ef.$$scope={dirty:c,ctx:e}),Mn.$set(Ef);const Pt={};c&2&&(Pt.$$scope={dirty:c,ctx:e}),$n.$set(Pt);const Hf={};c&2&&(Hf.$$scope={dirty:c,ctx:e}),Jn.$set(Hf);const At={};c&2&&(At.$$scope={dirty:c,ctx:e}),zn.$set(At);const qf={};c&2&&(qf.$$scope={dirty:c,ctx:e}),Vn.$set(qf);const Te={};c&2&&(Te.$$scope={dirty:c,ctx:e}),Rn.$set(Te);const Qf={};c&2&&(Qf.$$scope={dirty:c,ctx:e}),Ln.$set(Qf);const Ot={};c&2&&(Ot.$$scope={dirty:c,ctx:e}),Sn.$set(Ot);const Df={};c&2&&(Df.$$scope={dirty:c,ctx:e}),En.$set(Df);const Kt={};c&2&&(Kt.$$scope={dirty:c,ctx:e}),Yn.$set(Kt);const Yf={};c&2&&(Yf.$$scope={dirty:c,ctx:e}),sa.$set(Yf);const zs={};c&2&&(zs.$$scope={dirty:c,ctx:e}),na.$set(zs);const Pf={};c&2&&(Pf.$$scope={dirty:c,ctx:e}),aa.$set(Pf);const Vs={};c&2&&(Vs.$$scope={dirty:c,ctx:e}),pa.$set(Vs);const Af={};c&2&&(Af.$$scope={dirty:c,ctx:e}),ua.$set(Af);const es={};c&2&&(es.$$scope={dirty:c,ctx:e}),ya.$set(es);const Of={};c&2&&(Of.$$scope={dirty:c,ctx:e}),Ma.$set(Of);const ts={};c&2&&(ts.$$scope={dirty:c,ctx:e}),va.$set(ts);const Kf={};c&2&&(Kf.$$scope={dirty:c,ctx:e}),Ja.$set(Kf);const Me={};c&2&&(Me.$$scope={dirty:c,ctx:e}),Ua.$set(Me);const eb={};c&2&&(eb.$$scope={dirty:c,ctx:e}),Wa.$set(eb);const Qe={};c&2&&(Qe.$$scope={dirty:c,ctx:e}),Ia.$set(Qe);const tb={};c&2&&(tb.$$scope={dirty:c,ctx:e}),Ba.$set(tb)},i(e){Ly||(u(w.$$.fragment,e),u(qa.$$.fragment,e),u(Ya.$$.fragment,e),u(tr.$$.fragment,e),u(rr.$$.fragment,e),u(or.$$.fragment,e),u(lr.$$.fragment,e),u(ir.$$.fragment,e),u(cr.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(hr.$$.fragment,e),u(ur.$$.fragment,e),u(fr.$$.fragment,e),u(br.$$.fragment,e),u(_r.$$.fragment,e),u(yr.$$.fragment,e),u(Tr.$$.fragment,e),u(Mr.$$.fragment,e),u(vr.$$.fragment,e),u(wr.$$.fragment,e),u(kr.$$.fragment,e),u(jr.$$.fragment,e),u($r.$$.fragment,e),u(Jr.$$.fragment,e),u(xr.$$.fragment,e),u(Zr.$$.fragment,e),u(Cr.$$.fragment,e),u(Ls.$$.fragment,e),u(Wr.$$.fragment,e),u(Ir.$$.fragment,e),u(Ns.$$.fragment,e),u(Ss.$$.fragment,e),u(Br.$$.fragment,e),u(zr.$$.fragment,e),u(Es.$$.fragment,e),u(Vr.$$.fragment,e),u(Gr.$$.fragment,e),u(Hs.$$.fragment,e),u(Fr.$$.fragment,e),u(Xr.$$.fragment,e),u(qs.$$.fragment,e),u(Rr.$$.fragment,e),u(Lr.$$.fragment,e),u(Qs.$$.fragment,e),u(Nr.$$.fragment,e),u(Sr.$$.fragment,e),u(Ds.$$.fragment,e),u(Er.$$.fragment,e),u(Hr.$$.fragment,e),u(Ys.$$.fragment,e),u(qr.$$.fragment,e),u(Qr.$$.fragment,e),u(Ps.$$.fragment,e),u(Dr.$$.fragment,e),u(Yr.$$.fragment,e),u(As.$$.fragment,e),u(Pr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(Os.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(so.$$.fragment,e),u(no.$$.fragment,e),u(ao.$$.fragment,e),u(ro.$$.fragment,e),u(Ks.$$.fragment,e),u(oo.$$.fragment,e),u(lo.$$.fragment,e),u(en.$$.fragment,e),u(io.$$.fragment,e),u(co.$$.fragment,e),u(tn.$$.fragment,e),u(po.$$.fragment,e),u(mo.$$.fragment,e),u(sn.$$.fragment,e),u(nn.$$.fragment,e),u(go.$$.fragment,e),u(ho.$$.fragment,e),u(an.$$.fragment,e),u(rn.$$.fragment,e),u(uo.$$.fragment,e),u(fo.$$.fragment,e),u(on.$$.fragment,e),u(bo.$$.fragment,e),u(_o.$$.fragment,e),u(ln.$$.fragment,e),u(yo.$$.fragment,e),u(To.$$.fragment,e),u(cn.$$.fragment,e),u(dn.$$.fragment,e),u(Mo.$$.fragment,e),u(vo.$$.fragment,e),u(pn.$$.fragment,e),u(wo.$$.fragment,e),u(ko.$$.fragment,e),u(mn.$$.fragment,e),u(jo.$$.fragment,e),u($o.$$.fragment,e),u(gn.$$.fragment,e),u(Jo.$$.fragment,e),u(xo.$$.fragment,e),u(hn.$$.fragment,e),u(un.$$.fragment,e),u(Uo.$$.fragment,e),u(Zo.$$.fragment,e),u(fn.$$.fragment,e),u(Co.$$.fragment,e),u(Wo.$$.fragment,e),u(bn.$$.fragment,e),u(Io.$$.fragment,e),u(Bo.$$.fragment,e),u(_n.$$.fragment,e),u(zo.$$.fragment,e),u(Vo.$$.fragment,e),u(yn.$$.fragment,e),u(Go.$$.fragment,e),u(Fo.$$.fragment,e),u(Tn.$$.fragment,e),u(Xo.$$.fragment,e),u(Ro.$$.fragment,e),u(Mn.$$.fragment,e),u(Lo.$$.fragment,e),u(No.$$.fragment,e),u(So.$$.fragment,e),u(Eo.$$.fragment,e),u(Ho.$$.fragment,e),u(qo.$$.fragment,e),u(Qo.$$.fragment,e),u(Do.$$.fragment,e),u(Yo.$$.fragment,e),u(Po.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(al.$$.fragment,e),u(rl.$$.fragment,e),u(ol.$$.fragment,e),u(ll.$$.fragment,e),u(il.$$.fragment,e),u(cl.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(gl.$$.fragment,e),u(hl.$$.fragment,e),u(ul.$$.fragment,e),u(fl.$$.fragment,e),u(bl.$$.fragment,e),u(_l.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ml.$$.fragment,e),u(vl.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u(jl.$$.fragment,e),u($l.$$.fragment,e),u(Jl.$$.fragment,e),u(xl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(Cl.$$.fragment,e),u(Wl.$$.fragment,e),u(Il.$$.fragment,e),u(Bl.$$.fragment,e),u(zl.$$.fragment,e),u(Vl.$$.fragment,e),u(Gl.$$.fragment,e),u(Fl.$$.fragment,e),u(Xl.$$.fragment,e),u(Rl.$$.fragment,e),u(Ll.$$.fragment,e),u(Nl.$$.fragment,e),u(Sl.$$.fragment,e),u(El.$$.fragment,e),u(Hl.$$.fragment,e),u(ql.$$.fragment,e),u(Dl.$$.fragment,e),u(Yl.$$.fragment,e),u(Pl.$$.fragment,e),u(Al.$$.fragment,e),u(Ol.$$.fragment,e),u(Kl.$$.fragment,e),u(ei.$$.fragment,e),u(ti.$$.fragment,e),u(si.$$.fragment,e),u($n.$$.fragment,e),u(ni.$$.fragment,e),u(ai.$$.fragment,e),u(ri.$$.fragment,e),u(oi.$$.fragment,e),u(ii.$$.fragment,e),u(Jn.$$.fragment,e),u(ci.$$.fragment,e),u(di.$$.fragment,e),u(pi.$$.fragment,e),u(mi.$$.fragment,e),u(gi.$$.fragment,e),u(hi.$$.fragment,e),u(ui.$$.fragment,e),u(fi.$$.fragment,e),u(bi.$$.fragment,e),u(_i.$$.fragment,e),u(yi.$$.fragment,e),u(Ti.$$.fragment,e),u(Mi.$$.fragment,e),u(vi.$$.fragment,e),u(wi.$$.fragment,e),u(ki.$$.fragment,e),u(ji.$$.fragment,e),u($i.$$.fragment,e),u(Ji.$$.fragment,e),u(xi.$$.fragment,e),u(Ui.$$.fragment,e),u(Zi.$$.fragment,e),u(Ci.$$.fragment,e),u(Wi.$$.fragment,e),u(zn.$$.fragment,e),u(Vn.$$.fragment,e),u(Ii.$$.fragment,e),u(Bi.$$.fragment,e),u(zi.$$.fragment,e),u(Vi.$$.fragment,e),u(Rn.$$.fragment,e),u(Ln.$$.fragment,e),u(Gi.$$.fragment,e),u(Fi.$$.fragment,e),u(Sn.$$.fragment,e),u(En.$$.fragment,e),u(Xi.$$.fragment,e),u(Ri.$$.fragment,e),u(Li.$$.fragment,e),u(Ni.$$.fragment,e),u(Si.$$.fragment,e),u(Ei.$$.fragment,e),u(Hi.$$.fragment,e),u(qi.$$.fragment,e),u(Qi.$$.fragment,e),u(Yn.$$.fragment,e),u(Di.$$.fragment,e),u(Yi.$$.fragment,e),u(Pi.$$.fragment,e),u(Ai.$$.fragment,e),u(Oi.$$.fragment,e),u(Ki.$$.fragment,e),u(ec.$$.fragment,e),u(tc.$$.fragment,e),u(sc.$$.fragment,e),u(sa.$$.fragment,e),u(nc.$$.fragment,e),u(na.$$.fragment,e),u(ac.$$.fragment,e),u(aa.$$.fragment,e),u(rc.$$.fragment,e),u(oc.$$.fragment,e),u(lc.$$.fragment,e),u(ic.$$.fragment,e),u(cc.$$.fragment,e),u(dc.$$.fragment,e),u(pc.$$.fragment,e),u(mc.$$.fragment,e),u(pa.$$.fragment,e),u(gc.$$.fragment,e),u(hc.$$.fragment,e),u(uc.$$.fragment,e),u(fc.$$.fragment,e),u(ua.$$.fragment,e),u(bc.$$.fragment,e),u(_c.$$.fragment,e),u(yc.$$.fragment,e),u(Tc.$$.fragment,e),u(ya.$$.fragment,e),u(Mc.$$.fragment,e),u(vc.$$.fragment,e),u(wc.$$.fragment,e),u(kc.$$.fragment,e),u(Ma.$$.fragment,e),u(jc.$$.fragment,e),u($c.$$.fragment,e),u(Jc.$$.fragment,e),u(va.$$.fragment,e),u(xc.$$.fragment,e),u(Uc.$$.fragment,e),u(Zc.$$.fragment,e),u(Cc.$$.fragment,e),u(Wc.$$.fragment,e),u(Ic.$$.fragment,e),u(Ja.$$.fragment,e),u(Bc.$$.fragment,e),u(zc.$$.fragment,e),u(Vc.$$.fragment,e),u(Gc.$$.fragment,e),u(Fc.$$.fragment,e),u(Xc.$$.fragment,e),u(Rc.$$.fragment,e),u(Ua.$$.fragment,e),u(Lc.$$.fragment,e),u(Nc.$$.fragment,e),u(Sc.$$.fragment,e),u(Ec.$$.fragment,e),u(Hc.$$.fragment,e),u(Wa.$$.fragment,e),u(qc.$$.fragment,e),u(Ia.$$.fragment,e),u(Qc.$$.fragment,e),u(Dc.$$.fragment,e),u(Yc.$$.fragment,e),u(Ba.$$.fragment,e),u(Pc.$$.fragment,e),u(Ac.$$.fragment,e),Ly=!0)},o(e){f(w.$$.fragment,e),f(qa.$$.fragment,e),f(Ya.$$.fragment,e),f(tr.$$.fragment,e),f(rr.$$.fragment,e),f(or.$$.fragment,e),f(lr.$$.fragment,e),f(ir.$$.fragment,e),f(cr.$$.fragment,e),f(dr.$$.fragment,e),f(pr.$$.fragment,e),f(mr.$$.fragment,e),f(gr.$$.fragment,e),f(hr.$$.fragment,e),f(ur.$$.fragment,e),f(fr.$$.fragment,e),f(br.$$.fragment,e),f(_r.$$.fragment,e),f(yr.$$.fragment,e),f(Tr.$$.fragment,e),f(Mr.$$.fragment,e),f(vr.$$.fragment,e),f(wr.$$.fragment,e),f(kr.$$.fragment,e),f(jr.$$.fragment,e),f($r.$$.fragment,e),f(Jr.$$.fragment,e),f(xr.$$.fragment,e),f(Zr.$$.fragment,e),f(Cr.$$.fragment,e),f(Ls.$$.fragment,e),f(Wr.$$.fragment,e),f(Ir.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(Br.$$.fragment,e),f(zr.$$.fragment,e),f(Es.$$.fragment,e),f(Vr.$$.fragment,e),f(Gr.$$.fragment,e),f(Hs.$$.fragment,e),f(Fr.$$.fragment,e),f(Xr.$$.fragment,e),f(qs.$$.fragment,e),f(Rr.$$.fragment,e),f(Lr.$$.fragment,e),f(Qs.$$.fragment,e),f(Nr.$$.fragment,e),f(Sr.$$.fragment,e),f(Ds.$$.fragment,e),f(Er.$$.fragment,e),f(Hr.$$.fragment,e),f(Ys.$$.fragment,e),f(qr.$$.fragment,e),f(Qr.$$.fragment,e),f(Ps.$$.fragment,e),f(Dr.$$.fragment,e),f(Yr.$$.fragment,e),f(As.$$.fragment,e),f(Pr.$$.fragment,e),f(Ar.$$.fragment,e),f(Or.$$.fragment,e),f(Kr.$$.fragment,e),f(Os.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(so.$$.fragment,e),f(no.$$.fragment,e),f(ao.$$.fragment,e),f(ro.$$.fragment,e),f(Ks.$$.fragment,e),f(oo.$$.fragment,e),f(lo.$$.fragment,e),f(en.$$.fragment,e),f(io.$$.fragment,e),f(co.$$.fragment,e),f(tn.$$.fragment,e),f(po.$$.fragment,e),f(mo.$$.fragment,e),f(sn.$$.fragment,e),f(nn.$$.fragment,e),f(go.$$.fragment,e),f(ho.$$.fragment,e),f(an.$$.fragment,e),f(rn.$$.fragment,e),f(uo.$$.fragment,e),f(fo.$$.fragment,e),f(on.$$.fragment,e),f(bo.$$.fragment,e),f(_o.$$.fragment,e),f(ln.$$.fragment,e),f(yo.$$.fragment,e),f(To.$$.fragment,e),f(cn.$$.fragment,e),f(dn.$$.fragment,e),f(Mo.$$.fragment,e),f(vo.$$.fragment,e),f(pn.$$.fragment,e),f(wo.$$.fragment,e),f(ko.$$.fragment,e),f(mn.$$.fragment,e),f(jo.$$.fragment,e),f($o.$$.fragment,e),f(gn.$$.fragment,e),f(Jo.$$.fragment,e),f(xo.$$.fragment,e),f(hn.$$.fragment,e),f(un.$$.fragment,e),f(Uo.$$.fragment,e),f(Zo.$$.fragment,e),f(fn.$$.fragment,e),f(Co.$$.fragment,e),f(Wo.$$.fragment,e),f(bn.$$.fragment,e),f(Io.$$.fragment,e),f(Bo.$$.fragment,e),f(_n.$$.fragment,e),f(zo.$$.fragment,e),f(Vo.$$.fragment,e),f(yn.$$.fragment,e),f(Go.$$.fragment,e),f(Fo.$$.fragment,e),f(Tn.$$.fragment,e),f(Xo.$$.fragment,e),f(Ro.$$.fragment,e),f(Mn.$$.fragment,e),f(Lo.$$.fragment,e),f(No.$$.fragment,e),f(So.$$.fragment,e),f(Eo.$$.fragment,e),f(Ho.$$.fragment,e),f(qo.$$.fragment,e),f(Qo.$$.fragment,e),f(Do.$$.fragment,e),f(Yo.$$.fragment,e),f(Po.$$.fragment,e),f(Ao.$$.fragment,e),f(Oo.$$.fragment,e),f(Ko.$$.fragment,e),f(el.$$.fragment,e),f(tl.$$.fragment,e),f(sl.$$.fragment,e),f(nl.$$.fragment,e),f(al.$$.fragment,e),f(rl.$$.fragment,e),f(ol.$$.fragment,e),f(ll.$$.fragment,e),f(il.$$.fragment,e),f(cl.$$.fragment,e),f(dl.$$.fragment,e),f(pl.$$.fragment,e),f(ml.$$.fragment,e),f(gl.$$.fragment,e),f(hl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(bl.$$.fragment,e),f(_l.$$.fragment,e),f(yl.$$.fragment,e),f(Tl.$$.fragment,e),f(Ml.$$.fragment,e),f(vl.$$.fragment,e),f(wl.$$.fragment,e),f(kl.$$.fragment,e),f(jl.$$.fragment,e),f($l.$$.fragment,e),f(Jl.$$.fragment,e),f(xl.$$.fragment,e),f(Ul.$$.fragment,e),f(Zl.$$.fragment,e),f(Cl.$$.fragment,e),f(Wl.$$.fragment,e),f(Il.$$.fragment,e),f(Bl.$$.fragment,e),f(zl.$$.fragment,e),f(Vl.$$.fragment,e),f(Gl.$$.fragment,e),f(Fl.$$.fragment,e),f(Xl.$$.fragment,e),f(Rl.$$.fragment,e),f(Ll.$$.fragment,e),f(Nl.$$.fragment,e),f(Sl.$$.fragment,e),f(El.$$.fragment,e),f(Hl.$$.fragment,e),f(ql.$$.fragment,e),f(Dl.$$.fragment,e),f(Yl.$$.fragment,e),f(Pl.$$.fragment,e),f(Al.$$.fragment,e),f(Ol.$$.fragment,e),f(Kl.$$.fragment,e),f(ei.$$.fragment,e),f(ti.$$.fragment,e),f(si.$$.fragment,e),f($n.$$.fragment,e),f(ni.$$.fragment,e),f(ai.$$.fragment,e),f(ri.$$.fragment,e),f(oi.$$.fragment,e),f(ii.$$.fragment,e),f(Jn.$$.fragment,e),f(ci.$$.fragment,e),f(di.$$.fragment,e),f(pi.$$.fragment,e),f(mi.$$.fragment,e),f(gi.$$.fragment,e),f(hi.$$.fragment,e),f(ui.$$.fragment,e),f(fi.$$.fragment,e),f(bi.$$.fragment,e),f(_i.$$.fragment,e),f(yi.$$.fragment,e),f(Ti.$$.fragment,e),f(Mi.$$.fragment,e),f(vi.$$.fragment,e),f(wi.$$.fragment,e),f(ki.$$.fragment,e),f(ji.$$.fragment,e),f($i.$$.fragment,e),f(Ji.$$.fragment,e),f(xi.$$.fragment,e),f(Ui.$$.fragment,e),f(Zi.$$.fragment,e),f(Ci.$$.fragment,e),f(Wi.$$.fragment,e),f(zn.$$.fragment,e),f(Vn.$$.fragment,e),f(Ii.$$.fragment,e),f(Bi.$$.fragment,e),f(zi.$$.fragment,e),f(Vi.$$.fragment,e),f(Rn.$$.fragment,e),f(Ln.$$.fragment,e),f(Gi.$$.fragment,e),f(Fi.$$.fragment,e),f(Sn.$$.fragment,e),f(En.$$.fragment,e),f(Xi.$$.fragment,e),f(Ri.$$.fragment,e),f(Li.$$.fragment,e),f(Ni.$$.fragment,e),f(Si.$$.fragment,e),f(Ei.$$.fragment,e),f(Hi.$$.fragment,e),f(qi.$$.fragment,e),f(Qi.$$.fragment,e),f(Yn.$$.fragment,e),f(Di.$$.fragment,e),f(Yi.$$.fragment,e),f(Pi.$$.fragment,e),f(Ai.$$.fragment,e),f(Oi.$$.fragment,e),f(Ki.$$.fragment,e),f(ec.$$.fragment,e),f(tc.$$.fragment,e),f(sc.$$.fragment,e),f(sa.$$.fragment,e),f(nc.$$.fragment,e),f(na.$$.fragment,e),f(ac.$$.fragment,e),f(aa.$$.fragment,e),f(rc.$$.fragment,e),f(oc.$$.fragment,e),f(lc.$$.fragment,e),f(ic.$$.fragment,e),f(cc.$$.fragment,e),f(dc.$$.fragment,e),f(pc.$$.fragment,e),f(mc.$$.fragment,e),f(pa.$$.fragment,e),f(gc.$$.fragment,e),f(hc.$$.fragment,e),f(uc.$$.fragment,e),f(fc.$$.fragment,e),f(ua.$$.fragment,e),f(bc.$$.fragment,e),f(_c.$$.fragment,e),f(yc.$$.fragment,e),f(Tc.$$.fragment,e),f(ya.$$.fragment,e),f(Mc.$$.fragment,e),f(vc.$$.fragment,e),f(wc.$$.fragment,e),f(kc.$$.fragment,e),f(Ma.$$.fragment,e),f(jc.$$.fragment,e),f($c.$$.fragment,e),f(Jc.$$.fragment,e),f(va.$$.fragment,e),f(xc.$$.fragment,e),f(Uc.$$.fragment,e),f(Zc.$$.fragment,e),f(Cc.$$.fragment,e),f(Wc.$$.fragment,e),f(Ic.$$.fragment,e),f(Ja.$$.fragment,e),f(Bc.$$.fragment,e),f(zc.$$.fragment,e),f(Vc.$$.fragment,e),f(Gc.$$.fragment,e),f(Fc.$$.fragment,e),f(Xc.$$.fragment,e),f(Rc.$$.fragment,e),f(Ua.$$.fragment,e),f(Lc.$$.fragment,e),f(Nc.$$.fragment,e),f(Sc.$$.fragment,e),f(Ec.$$.fragment,e),f(Hc.$$.fragment,e),f(Wa.$$.fragment,e),f(qc.$$.fragment,e),f(Ia.$$.fragment,e),f(Qc.$$.fragment,e),f(Dc.$$.fragment,e),f(Yc.$$.fragment,e),f(Ba.$$.fragment,e),f(Pc.$$.fragment,e),f(Ac.$$.fragment,e),Ly=!1},d(e){e&&(n(j),n(_),n(d),n(s),n(k),n(sb),n(nb),n(Qa),n(ab),n(Da),n(rb),n(ob),n(Pa),n(lb),n(Aa),n(ib),n(Oa),n(cb),n(Ka),n(db),n(er),n(pb),n(mb),n(sr),n(gb),n(nr),n(hb),n(ar),n(ub),n(fb),n(us),n(bb),n(fs),n(_b),n(bs),n(yb),n(_s),n(Tb),n(Mb),n(ys),n(vb),n(Ts),n(wb),n(Ms),n(kb),n(vs),n(jb),n(ws),n($b),n(ks),n(Jb),n(js),n(xb),n($s),n(Ub),n(Js),n(Zb),n(xs),n(Cb),n(Wb),n(nt),n(Ib),n(at),n(Bb),n(rt),n(zb),n(Vb),n(Ur),n(Gb),n(Fb),n(je),n(Xb),n(N),n(Rb),n(ae),n(Lb),n(re),n(Nb),n($e),n(Sb),n(Je),n(Eb),n(xe),n(Hb),n(Ue),n(qb),n(Ze),n(Qb),n(S),n(Db),n(Ce),n(Yb),n(We),n(Pb),n(ot),n(Ab),n(lt),n(Ob),n(Ie),n(Kb),n(Be),n(e_),n(E),n(t_),n(oe),n(s_),n(le),n(n_),n(ze),n(a_),n(ie),n(r_),n(ce),n(o_),n(Ve),n(l_),n(Ge),n(i_),n(F),n(c_),n(de),n(d_),n(Fe),n(p_),n(Xe),n(m_),n(pe),n(g_),n(me),n(h_),n(ge),n(u_),n(H),n(f_),n(b_),n(it),n(__),n(ct),n(y_),n(dt),n(T_),n(pt),n(M_),n(mt),n(v_),n(gt),n(w_),n(ht),n(k_),n(ut),n(j_),n(ft),n($_),n(bt),n(J_),n(_t),n(x_),n(yt),n(U_),n(Tt),n(Z_),n(Mt),n(C_),n(vt),n(W_),n(I_),n(wt),n(B_),n(kt),n(z_),n(jt),n(V_),n($t),n(G_),n(Jt),n(F_),n(xt),n(X_),n(Ut),n(R_),n(Zt),n(L_),n(Ct),n(N_),n(Wt),n(S_),n(It),n(E_),n(Bt),n(H_),n(zt),n(q_),n(Q_),n(Ql),n(D_),n(Re),n(Y_),n(Us),n(P_),n(Vt),n(A_),n(Gt),n(O_),n(x),n(K_),n(Ft),n(ey),n(ty),n(li),n(sy),n(W),n(ny),n(Zs),n(ay),n(Cs),n(ry),n(Le),n(oy),n(ly),n(Ne),n(iy),n(q),n(cy),n(Se),n(dy),n(py),n(X),n(my),n(he),n(gy),n(ue),n(hy),n(uy),n(Xt),n(fy),n(Rt),n(by),n(Lt),n(_y),n(B),n(yy),n(Q),n(Ty),n(Nt),n(My),n(St),n(vy),n(z),n(wy),n(D),n(ky),n(Y),n(jy),n(P),n($y),n(A),n(Jy),n(V),n(xy),n(G),n(Uy),n(O),n(Zy),n(Cy),n(fe),n(Wy),n(be),n(Iy),n(Et),n(By),n(R),n(zy),n(Ht),n(Vy),n(_e),n(Gy),n(Fy),n(Ee),n(Xy),n(Ry),n(Gf)),n(i),b(w,e),b(qa,e),b(Ya,e),b(tr,e),b(rr,e),b(or),b(lr),b(ir),b(cr),b(dr,e),b(pr),b(mr),b(gr),b(hr),b(ur),b(fr),b(br),b(_r),b(yr),b(Tr),b(Mr,e),b(vr),b(wr),b(kr),b(jr),b($r),b(Jr),b(xr,e),b(Zr,e),b(Cr),b(Ls),b(Wr),b(Ir),b(Ns),b(Ss),b(Br),b(zr),b(Es),b(Vr),b(Gr),b(Hs),b(Fr),b(Xr),b(qs),b(Rr),b(Lr),b(Qs),b(Nr),b(Sr),b(Ds),b(Er),b(Hr),b(Ys),b(qr),b(Qr),b(Ps),b(Dr),b(Yr),b(As),b(Pr),b(Ar),b(Or),b(Kr),b(Os),b(eo),b(to),b(so),b(no),b(ao),b(ro),b(Ks),b(oo),b(lo),b(en),b(io),b(co),b(tn),b(po),b(mo),b(sn),b(nn),b(go),b(ho),b(an),b(rn),b(uo),b(fo),b(on),b(bo),b(_o),b(ln),b(yo),b(To),b(cn),b(dn),b(Mo),b(vo),b(pn),b(wo),b(ko),b(mn),b(jo),b($o),b(gn),b(Jo),b(xo),b(hn),b(un),b(Uo),b(Zo),b(fn),b(Co),b(Wo),b(bn),b(Io),b(Bo),b(_n),b(zo),b(Vo),b(yn),b(Go),b(Fo),b(Tn),b(Xo),b(Ro),b(Mn),b(Lo),b(No,e),b(So),b(Eo),b(Ho),b(qo),b(Qo),b(Do),b(Yo),b(Po),b(Ao),b(Oo),b(Ko),b(el),b(tl),b(sl),b(nl),b(al),b(rl),b(ol),b(ll),b(il),b(cl),b(dl),b(pl),b(ml),b(gl),b(hl),b(ul),b(fl),b(bl),b(_l),b(yl,e),b(Tl),b(Ml),b(vl),b(wl),b(kl),b(jl),b($l),b(Jl),b(xl),b(Ul),b(Zl),b(Cl),b(Wl),b(Il),b(Bl),b(zl),b(Vl),b(Gl),b(Fl),b(Xl),b(Rl),b(Ll),b(Nl),b(Sl),b(El),b(Hl),b(ql,e),b(Dl),b(Yl),b(Pl),b(Al),b(Ol),b(Kl),b(ei),b(ti),b(si),b($n),b(ni),b(ai),b(ri),b(oi,e),b(ii),b(Jn),b(ci),b(di),b(pi),b(mi),b(gi),b(hi),b(ui),b(fi),b(bi),b(_i),b(yi),b(Ti),b(Mi,e),b(vi),b(wi),b(ki),b(ji),b($i),b(Ji),b(xi),b(Ui),b(Zi),b(Ci,e),b(Wi),b(zn),b(Vn),b(Ii),b(Bi),b(zi),b(Vi),b(Rn),b(Ln),b(Gi),b(Fi),b(Sn),b(En),b(Xi),b(Ri,e),b(Li),b(Ni),b(Si),b(Ei),b(Hi),b(qi),b(Qi),b(Yn),b(Di),b(Yi),b(Pi),b(Ai),b(Oi),b(Ki),b(ec),b(tc),b(sc),b(sa),b(nc),b(na),b(ac),b(aa),b(rc),b(oc),b(lc),b(ic),b(cc),b(dc),b(pc),b(mc),b(pa),b(gc),b(hc),b(uc),b(fc),b(ua),b(bc),b(_c),b(yc),b(Tc),b(ya),b(Mc),b(vc),b(wc),b(kc),b(Ma),b(jc),b($c),b(Jc),b(va),b(xc),b(Uc),b(Zc),b(Cc),b(Wc),b(Ic),b(Ja),b(Bc),b(zc),b(Vc),b(Gc,e),b(Fc),b(Xc),b(Rc),b(Ua),b(Lc),b(Nc),b(Sc),b(Ec),b(Hc),b(Wa),b(qc),b(Ia),b(Qc),b(Dc,e),b(Yc),b(Ba),b(Pc),b(Ac,e)}}}const rW='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2},{"title":"Watermark Utils","local":"transformers.WatermarkingConfig","sections":[],"depth":2},{"title":"Compile Utils","local":"transformers.CompileConfig","sections":[],"depth":2}],"depth":1}';function oW($){return AZ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class uW extends OZ{constructor(i){super(),KZ(this,i,oW,aW,PZ,{})}}export{uW as component};
