import{s as Ne,o as Xe,n as fe}from"../chunks/scheduler.18a86fab.js";import{S as He,i as Pe,g as c,s as r,r as v,A as Ae,h as m,f as d,c as l,j as te,u as w,x as _,k as q,y as a,a as g,v as j,d as J,t as U,w as V}from"../chunks/index.98837b22.js";import{T as ze}from"../chunks/Tip.77304350.js";import{D as oe}from"../chunks/Docstring.6758ea23.js";import{C as Ve}from"../chunks/CodeBlock.8d0c2e8a.js";import{F as Le,M as Fe}from"../chunks/Markdown.ae01904b.js";import{E as Ee}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as he}from"../chunks/Heading.7e7e0c5b.js";import{E as Ye}from"../chunks/index.499f366c.js";function Qe(z){let t,i="Examples:",e,o,p;return o=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVENvbmZpZyUyQyUyMEJlcnRDb25maWclMkMlMjBWaXNpb25UZXh0RHVhbEVuY29kZXJDb25maWclMkMlMjBWaXNpb25UZXh0RHVhbEVuY29kZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBCRVJUJTIwYW5kJTIwVmlUJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ192aXNpb24lMjAlM0QlMjBWaVRDb25maWcoKSUwQWNvbmZpZ190ZXh0JTIwJTNEJTIwQmVydENvbmZpZygpJTBBJTBBY29uZmlnJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyQ29uZmlnLmZyb21fdmlzaW9uX3RleHRfY29uZmlncyhjb25maWdfdmlzaW9uJTJDJTIwY29uZmlnX3RleHQlMkMlMjBwcm9qZWN0aW9uX2RpbSUzRDUxMiklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQkVSVCUyMGFuZCUyMFZpVCUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUwQW1vZGVsJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyTW9kZWwoY29uZmlnJTNEY29uZmlnKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ192aXNpb24lMjAlM0QlMjBtb2RlbC5jb25maWcudmlzaW9uX2NvbmZpZyUwQWNvbmZpZ190ZXh0JTIwJTNEJTIwbW9kZWwuY29uZmlnLnRleHRfY29uZmlnJTBBJTBBJTIzJTIwU2F2aW5nJTIwdGhlJTIwbW9kZWwlMkMlMjBpbmNsdWRpbmclMjBpdHMlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnZpdC1iZXJ0JTIyKSUwQSUwQSUyMyUyMGxvYWRpbmclMjBtb2RlbCUyMGFuZCUyMGNvbmZpZyUyMGZyb20lMjBwcmV0cmFpbmVkJTIwZm9sZGVyJTBBdmlzaW9uX3RleHRfY29uZmlnJTIwJTNEJTIwVmlzaW9uVGV4dER1YWxFbmNvZGVyQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJ2aXQtYmVydCUyMiklMEFtb2RlbCUyMCUzRCUyMFZpc2lvblRleHREdWFsRW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ2aXQtYmVydCUyMiUyQyUyMGNvbmZpZyUzRHZpc2lvbl90ZXh0X2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTConfig, BertConfig, VisionTextDualEncoderConfig, VisionTextDualEncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BERT and ViT configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = ViTConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = BertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = VisionTextDualEncoderConfig.from_vision_text_configs(config_vision, config_text, projection_dim=<span class="hljs-number">512</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BERT and ViT model (with random weights)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = model.config.vision_config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = model.config.text_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_text_config = VisionTextDualEncoderConfig.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>, config=vision_text_config)`,wrap:!1}}),{c(){t=c("p"),t.textContent=i,e=r(),v(o.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-kvfsh7"&&(t.textContent=i),e=l(s),w(o.$$.fragment,s)},m(s,E){g(s,t,E),g(s,e,E),j(o,s,E),p=!0},p:fe,i(s){p||(J(o.$$.fragment,s),p=!0)},o(s){U(o.$$.fragment,s),p=!1},d(s){s&&(d(t),d(e)),V(o,s)}}}function Se(z){let t,i=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=i},l(e){t=m(e,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=i)},m(e,o){g(e,t,o)},p:fe,d(e){e&&d(t)}}}function qe(z){let t,i="Examples:",e,o,p;return o=new Ve({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    VisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>    return_loss=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits_per_image = outputs.loss, outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=i,e=r(),v(o.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-kvfsh7"&&(t.textContent=i),e=l(s),w(o.$$.fragment,s)},m(s,E){g(s,t,E),g(s,e,E),j(o,s,E),p=!0},p:fe,i(s){p||(J(o.$$.fragment,s),p=!0)},o(s){U(o.$$.fragment,s),p=!1},d(s){s&&(d(t),d(e)),V(o,s)}}}function Oe(z){let t,i,e,o,p,s,E="The bare Vision Text Dual Encoder Model outputting raw hidden-states without any specific head on top.",S,F,H=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,P,k,ne=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,A,y,L,Y,Z,O='The <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',$,h,N,B,D;return t=new he({props:{title:"VisionTextDualEncoderModel",local:"transformers.VisionTextDualEncoderModel",headingTag:"h2"}}),o=new oe({props:{name:"class transformers.VisionTextDualEncoderModel",anchor:"transformers.VisionTextDualEncoderModel",parameters:[{name:"config",val:": typing.Optional[transformers.models.vision_text_dual_encoder.configuration_vision_text_dual_encoder.VisionTextDualEncoderConfig] = None"},{name:"vision_model",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"text_model",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a>, <em>optional</em>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.VisionTextDualEncoderModel.vision_model",description:`<strong>vision_model</strong> (<code>~modeling_utils.PreTrainedModel</code>) &#x2014;
The vision model to use.`,name:"vision_model"},{anchor:"transformers.VisionTextDualEncoderModel.text_model",description:`<strong>text_model</strong> (<code>~modeling_utils.PreTrainedModel</code>) &#x2014;
The text model to use.`,name:"text_model"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/modeling_vision_text_dual_encoder.py#L45"}}),L=new oe({props:{name:"forward",anchor:"transformers.VisionTextDualEncoderModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"return_loss",val:": typing.Optional[bool] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VisionTextDualEncoderModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VisionTextDualEncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.VisionTextDualEncoderModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VisionTextDualEncoderModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.VisionTextDualEncoderModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.VisionTextDualEncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VisionTextDualEncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VisionTextDualEncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/modeling_vision_text_dual_encoder.py#L187",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_clip.CLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel"
>CLIPTextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModel"
>CLIPVisionModel</a>.</li>
<li><strong>text_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel"
>CLIPTextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModel"
>CLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_clip.CLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),h=new ze({props:{$$slots:{default:[Se]},$$scope:{ctx:z}}}),B=new Ee({props:{anchor:"transformers.VisionTextDualEncoderModel.forward.example",$$slots:{default:[qe]},$$scope:{ctx:z}}}),{c(){v(t.$$.fragment),i=r(),e=c("div"),v(o.$$.fragment),p=r(),s=c("p"),s.textContent=E,S=r(),F=c("p"),F.innerHTML=H,P=r(),k=c("p"),k.innerHTML=ne,A=r(),y=c("div"),v(L.$$.fragment),Y=r(),Z=c("p"),Z.innerHTML=O,$=r(),v(h.$$.fragment),N=r(),v(B.$$.fragment),this.h()},l(T){w(t.$$.fragment,T),i=l(T),e=m(T,"DIV",{class:!0});var b=te(e);w(o.$$.fragment,b),p=l(b),s=m(b,"P",{"data-svelte-h":!0}),_(s)!=="svelte-1bevpiv"&&(s.textContent=E),S=l(b),F=m(b,"P",{"data-svelte-h":!0}),_(F)!=="svelte-6pahdo"&&(F.innerHTML=H),P=l(b),k=m(b,"P",{"data-svelte-h":!0}),_(k)!=="svelte-hswkmf"&&(k.innerHTML=ne),A=l(b),y=m(b,"DIV",{class:!0});var f=te(y);w(L.$$.fragment,f),Y=l(f),Z=m(f,"P",{"data-svelte-h":!0}),_(Z)!=="svelte-s9aulj"&&(Z.innerHTML=O),$=l(f),w(h.$$.fragment,f),N=l(f),w(B.$$.fragment,f),f.forEach(d),b.forEach(d),this.h()},h(){q(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(T,b){j(t,T,b),g(T,i,b),g(T,e,b),j(o,e,null),a(e,p),a(e,s),a(e,S),a(e,F),a(e,P),a(e,k),a(e,A),a(e,y),j(L,y,null),a(y,Y),a(y,Z),a(y,$),j(h,y,null),a(y,N),j(B,y,null),D=!0},p(T,b){const f={};b&2&&(f.$$scope={dirty:b,ctx:T}),h.$set(f);const X={};b&2&&(X.$$scope={dirty:b,ctx:T}),B.$set(X)},i(T){D||(J(t.$$.fragment,T),J(o.$$.fragment,T),J(L.$$.fragment,T),J(h.$$.fragment,T),J(B.$$.fragment,T),D=!0)},o(T){U(t.$$.fragment,T),U(o.$$.fragment,T),U(L.$$.fragment,T),U(h.$$.fragment,T),U(B.$$.fragment,T),D=!1},d(T){T&&(d(i),d(e)),V(t,T),V(o),V(L),V(h),V(B)}}}function Ke(z){let t,i;return t=new Fe({props:{$$slots:{default:[Oe]},$$scope:{ctx:z}}}),{c(){v(t.$$.fragment)},l(e){w(t.$$.fragment,e)},m(e,o){j(t,e,o),i=!0},p(e,o){const p={};o&2&&(p.$$scope={dirty:o,ctx:e}),t.$set(p)},i(e){i||(J(t.$$.fragment,e),i=!0)},o(e){U(t.$$.fragment,e),i=!1},d(e){V(t,e)}}}function et(z){let t,i=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=i},l(e){t=m(e,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=i)},m(e,o){g(e,t,o)},p:fe,d(e){e&&d(t)}}}function tt(z){let t,i="Examples:",e,o,p;return o=new Ve({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    FlaxVisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcesor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxVisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;np&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxVisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = jax.nn.softmax(logits_per_image, axis=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=i,e=r(),v(o.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-kvfsh7"&&(t.textContent=i),e=l(s),w(o.$$.fragment,s)},m(s,E){g(s,t,E),g(s,e,E),j(o,s,E),p=!0},p:fe,i(s){p||(J(o.$$.fragment,s),p=!0)},o(s){U(o.$$.fragment,s),p=!1},d(s){s&&(d(t),d(e)),V(o,s)}}}function nt(z){let t,i,e,o,p,s,E=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,S,F,H=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvement
on new zero-shot vision tasks such as image classification or retrieval.`,P,k,ne=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,A,y,L=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Y,Z,O=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it
as a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,$,h,N="Finally, this model supports inherent JAX features such as:",B,D,T='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',b,f,X,R,Q,u='The <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.FlaxVisionTextDualEncoderModel">FlaxVisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',M,G,K,se,le;return t=new he({props:{title:"FlaxVisionTextDualEncoderModel",local:"transformers.FlaxVisionTextDualEncoderModel",headingTag:"h2"}}),o=new oe({props:{name:"class transformers.FlaxVisionTextDualEncoderModel",anchor:"transformers.FlaxVisionTextDualEncoderModel",parameters:[{name:"config",val:": VisionTextDualEncoderConfig"},{name:"input_shape",val:": typing.Optional[typing.Tuple] = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxVisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/modeling_flax_vision_text_dual_encoder.py#L218"}}),X=new oe({props:{name:"__call__",anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__",parameters:[{name:"input_ids",val:""},{name:"pixel_values",val:""},{name:"attention_mask",val:" = None"},{name:"position_ids",val:" = None"},{name:"token_type_ids",val:" = None"},{name:"params",val:": typing.Optional[dict] = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7f9d10350ee0> = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.input_ids",description:`<strong>input_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.position_ids",description:`<strong>position_ids</strong> (<code>numpy.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/modeling_flax_vision_text_dual_encoder.py#L269",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_flax_clip.FlaxCLIPOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>logits_per_image:(<code>jnp.ndarray</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>jnp.ndarray</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>jnp.ndarray</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel"
>FlaxCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>jnp.ndarray</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPVisionModel"
>FlaxCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>FlaxBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel"
>FlaxCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>FlaxBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPVisionModel"
>FlaxCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_flax_clip.FlaxCLIPOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new ze({props:{$$slots:{default:[et]},$$scope:{ctx:z}}}),se=new Ee({props:{anchor:"transformers.FlaxVisionTextDualEncoderModel.__call__.example",$$slots:{default:[tt]},$$scope:{ctx:z}}}),{c(){v(t.$$.fragment),i=r(),e=c("div"),v(o.$$.fragment),p=r(),s=c("p"),s.innerHTML=E,S=r(),F=c("p"),F.innerHTML=H,P=r(),k=c("p"),k.textContent=ne,A=r(),y=c("p"),y.innerHTML=L,Y=r(),Z=c("p"),Z.innerHTML=O,$=r(),h=c("p"),h.textContent=N,B=r(),D=c("ul"),D.innerHTML=T,b=r(),f=c("div"),v(X.$$.fragment),R=r(),Q=c("p"),Q.innerHTML=u,M=r(),v(G.$$.fragment),K=r(),v(se.$$.fragment),this.h()},l(I){w(t.$$.fragment,I),i=l(I),e=m(I,"DIV",{class:!0});var C=te(e);w(o.$$.fragment,C),p=l(C),s=m(C,"P",{"data-svelte-h":!0}),_(s)!=="svelte-chn06i"&&(s.innerHTML=E),S=l(C),F=m(C,"P",{"data-svelte-h":!0}),_(F)!=="svelte-1isi1un"&&(F.innerHTML=H),P=l(C),k=m(C,"P",{"data-svelte-h":!0}),_(k)!=="svelte-c2j1l6"&&(k.textContent=ne),A=l(C),y=m(C,"P",{"data-svelte-h":!0}),_(y)!=="svelte-6pahdo"&&(y.innerHTML=L),Y=l(C),Z=m(C,"P",{"data-svelte-h":!0}),_(Z)!=="svelte-1c8n49f"&&(Z.innerHTML=O),$=l(C),h=m(C,"P",{"data-svelte-h":!0}),_(h)!=="svelte-1pplc4a"&&(h.textContent=N),B=l(C),D=m(C,"UL",{"data-svelte-h":!0}),_(D)!=="svelte-1w7z84m"&&(D.innerHTML=T),b=l(C),f=m(C,"DIV",{class:!0});var W=te(f);w(X.$$.fragment,W),R=l(W),Q=m(W,"P",{"data-svelte-h":!0}),_(Q)!=="svelte-9mjtg1"&&(Q.innerHTML=u),M=l(W),w(G.$$.fragment,W),K=l(W),w(se.$$.fragment,W),W.forEach(d),C.forEach(d),this.h()},h(){q(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(I,C){j(t,I,C),g(I,i,C),g(I,e,C),j(o,e,null),a(e,p),a(e,s),a(e,S),a(e,F),a(e,P),a(e,k),a(e,A),a(e,y),a(e,Y),a(e,Z),a(e,$),a(e,h),a(e,B),a(e,D),a(e,b),a(e,f),j(X,f,null),a(f,R),a(f,Q),a(f,M),j(G,f,null),a(f,K),j(se,f,null),le=!0},p(I,C){const W={};C&2&&(W.$$scope={dirty:C,ctx:I}),G.$set(W);const ae={};C&2&&(ae.$$scope={dirty:C,ctx:I}),se.$set(ae)},i(I){le||(J(t.$$.fragment,I),J(o.$$.fragment,I),J(X.$$.fragment,I),J(G.$$.fragment,I),J(se.$$.fragment,I),le=!0)},o(I){U(t.$$.fragment,I),U(o.$$.fragment,I),U(X.$$.fragment,I),U(G.$$.fragment,I),U(se.$$.fragment,I),le=!1},d(I){I&&(d(i),d(e)),V(t,I),V(o),V(X),V(G),V(se)}}}function st(z){let t,i;return t=new Fe({props:{$$slots:{default:[nt]},$$scope:{ctx:z}}}),{c(){v(t.$$.fragment)},l(e){w(t.$$.fragment,e)},m(e,o){j(t,e,o),i=!0},p(e,o){const p={};o&2&&(p.$$scope={dirty:o,ctx:e}),t.$set(p)},i(e){i||(J(t.$$.fragment,e),i=!0)},o(e){U(t.$$.fragment,e),i=!1},d(e){V(t,e)}}}function ot(z){let t,i=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=i},l(e){t=m(e,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=i)},m(e,o){g(e,t,o)},p:fe,d(e){e&&d(t)}}}function at(z){let t,i="Examples:",e,o,p;return o=new Ve({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    TFVisionTextDualEncoderModel,
<span class="hljs-meta">... </span>    VisionTextDualEncoderProcessor,
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VisionTextDualEncoderProcessor(image_processor, tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFVisionTextDualEncoderModel.from_vision_text_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># contrastive training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>urls = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://farm3.staticflickr.com/2674/5850229113_4fe05d5265_z.jpg&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw) <span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> urls]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=images, return_tensors=<span class="hljs-string">&quot;np&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    input_ids=inputs.input_ids,
<span class="hljs-meta">... </span>    attention_mask=inputs.attention_mask,
<span class="hljs-meta">... </span>    pixel_values=inputs.pixel_values,
<span class="hljs-meta">... </span>    return_loss=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits_per_image = outputs.loss, outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save and load from pretrained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFVisionTextDualEncoderModel.from_pretrained(<span class="hljs-string">&quot;vit-bert&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = tf.nn.softmax(logits_per_image, axis=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=i,e=r(),v(o.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),_(t)!=="svelte-kvfsh7"&&(t.textContent=i),e=l(s),w(o.$$.fragment,s)},m(s,E){g(s,t,E),g(s,e,E),j(o,s,E),p=!0},p:fe,i(s){p||(J(o.$$.fragment,s),p=!0)},o(s){U(o.$$.fragment,s),p=!1},d(s){s&&(d(t),d(e)),V(o,s)}}}function rt(z){let t,i,e,o,p,s,E=`This class can be used to initialize a vision-text dual encoder model with any pretrained vision autoencoding model
as the vision encoder and any pretrained text model as the text encoder. The vision and text encoders are loaded
via the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method. The projection layers are automatically added to the model and
should be fine-tuned on a downstream task, like contrastive image-text modeling.`,S,F,H=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvement
on new zero-shot vision tasks such as image classification or retrieval.`,P,k,ne=`After such a Vision-Text-Dual-Encoder model has been trained/fine-tuned, it can be saved/loaded just like any other
models (see the examples for more information).`,A,y,L=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Y,Z,O=`This model is also a Keras <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">Model</a> subclass. Use it as a
regular Keras Model and refer to the TF documentation for all matter related to general usage and behavior.`,$,h,N,B,D,T='The <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.TFVisionTextDualEncoderModel">TFVisionTextDualEncoderModel</a> forward method, overrides the <code>__call__</code> special method.',b,f,X,R,Q;return t=new he({props:{title:"TFVisionTextDualEncoderModel",local:"transformers.TFVisionTextDualEncoderModel",headingTag:"h2"}}),o=new oe({props:{name:"class transformers.TFVisionTextDualEncoderModel",anchor:"transformers.TFVisionTextDualEncoderModel",parameters:[{name:"config",val:": Optional[VisionTextDualEncoderConfig] = None"},{name:"vision_model",val:": Optional[TFPreTrainedModel] = None"},{name:"text_model",val:": Optional[TFPreTrainedModel] = None"}],parametersDescription:[{anchor:"transformers.TFVisionTextDualEncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vision-encoder-decoder#transformers.VisionEncoderDecoderConfig">VisionEncoderDecoderConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/modeling_tf_vision_text_dual_encoder.py#L173"}}),N=new oe({props:{name:"call",anchor:"transformers.TFVisionTextDualEncoderModel.call",parameters:[{name:"input_ids",val:": tf.Tensor | None = None"},{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"return_loss",val:": Optional[bool] = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFVisionTextDualEncoderModel.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
an image processor (e.g. if you use ViT as the encoder, you should use <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>). See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFVisionTextDualEncoderModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/modeling_tf_vision_text_dual_encoder.py#L345",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clip.modeling_tf_clip.TFCLIPOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image:(<code>tf.Tensor</code></strong> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text:(<code>tf.Tensor</code></strong> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds(<code>tf.Tensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.TFCLIPTextModel"
>TFCLIPTextModel</a>.</li>
<li><strong>image_embeds(<code>tf.Tensor</code></strong> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/main/en/model_doc/clip#transformers.TFCLIPVisionModel"
>TFCLIPVisionModel</a>.</li>
<li><strong>text_model_output(<code>~modeling_tf_utils.TFBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.TFCLIPTextModel"
>TFCLIPTextModel</a>.</li>
<li><strong>vision_model_output(<code>~modeling_tf_utils.TFBaseModelOutputWithPooling</code>):</strong>
The output of the <a
  href="/docs/transformers/main/en/model_doc/clip#transformers.TFCLIPVisionModel"
>TFCLIPVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clip.modeling_tf_clip.TFCLIPOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),f=new ze({props:{$$slots:{default:[ot]},$$scope:{ctx:z}}}),R=new Ee({props:{anchor:"transformers.TFVisionTextDualEncoderModel.call.example",$$slots:{default:[at]},$$scope:{ctx:z}}}),{c(){v(t.$$.fragment),i=r(),e=c("div"),v(o.$$.fragment),p=r(),s=c("p"),s.innerHTML=E,S=r(),F=c("p"),F.innerHTML=H,P=r(),k=c("p"),k.textContent=ne,A=r(),y=c("p"),y.innerHTML=L,Y=r(),Z=c("p"),Z.innerHTML=O,$=r(),h=c("div"),v(N.$$.fragment),B=r(),D=c("p"),D.innerHTML=T,b=r(),v(f.$$.fragment),X=r(),v(R.$$.fragment),this.h()},l(u){w(t.$$.fragment,u),i=l(u),e=m(u,"DIV",{class:!0});var M=te(e);w(o.$$.fragment,M),p=l(M),s=m(M,"P",{"data-svelte-h":!0}),_(s)!=="svelte-chn06i"&&(s.innerHTML=E),S=l(M),F=m(M,"P",{"data-svelte-h":!0}),_(F)!=="svelte-1isi1un"&&(F.innerHTML=H),P=l(M),k=m(M,"P",{"data-svelte-h":!0}),_(k)!=="svelte-c2j1l6"&&(k.textContent=ne),A=l(M),y=m(M,"P",{"data-svelte-h":!0}),_(y)!=="svelte-1qaxm70"&&(y.innerHTML=L),Y=l(M),Z=m(M,"P",{"data-svelte-h":!0}),_(Z)!=="svelte-y4ylu0"&&(Z.innerHTML=O),$=l(M),h=m(M,"DIV",{class:!0});var G=te(h);w(N.$$.fragment,G),B=l(G),D=m(G,"P",{"data-svelte-h":!0}),_(D)!=="svelte-zdzw37"&&(D.innerHTML=T),b=l(G),w(f.$$.fragment,G),X=l(G),w(R.$$.fragment,G),G.forEach(d),M.forEach(d),this.h()},h(){q(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(u,M){j(t,u,M),g(u,i,M),g(u,e,M),j(o,e,null),a(e,p),a(e,s),a(e,S),a(e,F),a(e,P),a(e,k),a(e,A),a(e,y),a(e,Y),a(e,Z),a(e,$),a(e,h),j(N,h,null),a(h,B),a(h,D),a(h,b),j(f,h,null),a(h,X),j(R,h,null),Q=!0},p(u,M){const G={};M&2&&(G.$$scope={dirty:M,ctx:u}),f.$set(G);const K={};M&2&&(K.$$scope={dirty:M,ctx:u}),R.$set(K)},i(u){Q||(J(t.$$.fragment,u),J(o.$$.fragment,u),J(N.$$.fragment,u),J(f.$$.fragment,u),J(R.$$.fragment,u),Q=!0)},o(u){U(t.$$.fragment,u),U(o.$$.fragment,u),U(N.$$.fragment,u),U(f.$$.fragment,u),U(R.$$.fragment,u),Q=!1},d(u){u&&(d(i),d(e)),V(t,u),V(o),V(N),V(f),V(R)}}}function lt(z){let t,i;return t=new Fe({props:{$$slots:{default:[rt]},$$scope:{ctx:z}}}),{c(){v(t.$$.fragment)},l(e){w(t.$$.fragment,e)},m(e,o){j(t,e,o),i=!0},p(e,o){const p={};o&2&&(p.$$scope={dirty:o,ctx:e}),t.$set(p)},i(e){i||(J(t.$$.fragment,e),i=!0)},o(e){U(t.$$.fragment,e),i=!1},d(e){V(t,e)}}}function it(z){let t,i,e,o,p,s,E,S=`<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat&amp;logo=tensorflow&amp;logoColor=white"/> <img alt="Flax" src="https://img.shields.io/badge/Flax-29a79b.svg?style=flat&amp;logo=data:image/png;base64,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
"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>`,F,H,P,k,ne=`The <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> can be used to initialize a vision-text dual encoder model with
any pretrained vision autoencoding model as the vision encoder (<em>e.g.</em> <a href="vit">ViT</a>, <a href="beit">BEiT</a>, <a href="deit">DeiT</a>) and any pretrained text autoencoding model as the text encoder (<em>e.g.</em> <a href="roberta">RoBERTa</a>, <a href="bert">BERT</a>). Two projection layers are added on top of both the vision and text encoder to project the output embeddings
to a shared latent space. The projection layers are randomly initialized so the model should be fine-tuned on a
downstream task. This model can be used to align the vision-text embeddings using CLIP like contrastive image-text
training and then can be used for zero-shot vision tasks such image-classification or retrieval.`,A,y,L=`In <a href="https://arxiv.org/abs/2111.07991" rel="nofollow">LiT: Zero-Shot Transfer with Locked-image Text Tuning</a> it is shown how
leveraging pre-trained (locked/frozen) image and text model for contrastive learning yields significant improvement on
new zero-shot vision tasks such as image classification or retrieval.`,Y,Z,O,$,h,N,B,D=`<a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> is the configuration class to store the configuration of a
<a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a>. It is used to instantiate <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderModel">VisionTextDualEncoderModel</a> model according to the
specified arguments, defining the text model and vision model configs.`,T,b,f=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,X,R,Q,u,M,G,K,se=`Instantiate a <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig">VisionTextDualEncoderConfig</a> (or a derived class) from text model configuration and vision
model configuration.`,le,I,C,W,ae,Ie,Te,Ge=`Constructs a VisionTextDualEncoder processor which wraps an image processor and a tokenizer into a single
processor.`,Ce,Me,Be=`<a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor">VisionTextDualEncoderProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>.
See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderProcessor.decode">decode()</a> for more
information.`,ke,ie,me,Ze,_e,De=`This method forwards all its arguments to VisionTextDualEncoderTokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer to the docstring of this method for more information.`,$e,de,pe,We,ye,Re=`This method forwards all its arguments to VisionTextDualEncoderTokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>.
Please refer to the docstring of this method for more information.`,xe,ce,ve,ue,we,be,je;return p=new he({props:{title:"VisionTextDualEncoder",local:"visiontextdualencoder",headingTag:"h1"}}),H=new he({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Z=new he({props:{title:"VisionTextDualEncoderConfig",local:"transformers.VisionTextDualEncoderConfig",headingTag:"h2"}}),h=new oe({props:{name:"class transformers.VisionTextDualEncoderConfig",anchor:"transformers.VisionTextDualEncoderConfig",parameters:[{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.VisionTextDualEncoderConfig.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The initial value of the <em>logit_scale</em> parameter. Default is used as per the original CLIP implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.VisionTextDualEncoderConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/configuration_vision_text_dual_encoder.py#L34"}}),R=new Ee({props:{anchor:"transformers.VisionTextDualEncoderConfig.example",$$slots:{default:[Qe]},$$scope:{ctx:z}}}),M=new oe({props:{name:"from_vision_text_configs",anchor:"transformers.VisionTextDualEncoderConfig.from_vision_text_configs",parameters:[{name:"vision_config",val:": PretrainedConfig"},{name:"text_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/configuration_vision_text_dual_encoder.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/vision-text-dual-encoder#transformers.VisionTextDualEncoderConfig"
>VisionTextDualEncoderConfig</a></p>
`}}),I=new he({props:{title:"VisionTextDualEncoderProcessor",local:"transformers.VisionTextDualEncoderProcessor",headingTag:"h2"}}),ae=new oe({props:{name:"class transformers.VisionTextDualEncoderProcessor",anchor:"transformers.VisionTextDualEncoderProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VisionTextDualEncoderProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VisionTextDualEncoderProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L31"}}),me=new oe({props:{name:"batch_decode",anchor:"transformers.VisionTextDualEncoderProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L140"}}),pe=new oe({props:{name:"decode",anchor:"transformers.VisionTextDualEncoderProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vision_text_dual_encoder/processing_vision_text_dual_encoder.py#L147"}}),ce=new Le({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[lt],tensorflow:[st],pytorch:[Ke]},$$scope:{ctx:z}}}),ue=new Ye({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/vision-text-dual-encoder.md"}}),{c(){t=c("meta"),i=r(),e=c("p"),o=r(),v(p.$$.fragment),s=r(),E=c("div"),E.innerHTML=S,F=r(),v(H.$$.fragment),P=r(),k=c("p"),k.innerHTML=ne,A=r(),y=c("p"),y.innerHTML=L,Y=r(),v(Z.$$.fragment),O=r(),$=c("div"),v(h.$$.fragment),N=r(),B=c("p"),B.innerHTML=D,T=r(),b=c("p"),b.innerHTML=f,X=r(),v(R.$$.fragment),Q=r(),u=c("div"),v(M.$$.fragment),G=r(),K=c("p"),K.innerHTML=se,le=r(),v(I.$$.fragment),C=r(),W=c("div"),v(ae.$$.fragment),Ie=r(),Te=c("p"),Te.textContent=Ge,Ce=r(),Me=c("p"),Me.innerHTML=Be,ke=r(),ie=c("div"),v(me.$$.fragment),Ze=r(),_e=c("p"),_e.innerHTML=De,$e=r(),de=c("div"),v(pe.$$.fragment),We=r(),ye=c("p"),ye.innerHTML=Re,xe=r(),v(ce.$$.fragment),ve=r(),v(ue.$$.fragment),we=r(),be=c("p"),this.h()},l(n){const x=Ae("svelte-u9bgzb",document.head);t=m(x,"META",{name:!0,content:!0}),x.forEach(d),i=l(n),e=m(n,"P",{}),te(e).forEach(d),o=l(n),w(p.$$.fragment,n),s=l(n),E=m(n,"DIV",{class:!0,"data-svelte-h":!0}),_(E)!=="svelte-1g3vp04"&&(E.innerHTML=S),F=l(n),w(H.$$.fragment,n),P=l(n),k=m(n,"P",{"data-svelte-h":!0}),_(k)!=="svelte-r47qr2"&&(k.innerHTML=ne),A=l(n),y=m(n,"P",{"data-svelte-h":!0}),_(y)!=="svelte-8axln3"&&(y.innerHTML=L),Y=l(n),w(Z.$$.fragment,n),O=l(n),$=m(n,"DIV",{class:!0});var ee=te($);w(h.$$.fragment,ee),N=l(ee),B=m(ee,"P",{"data-svelte-h":!0}),_(B)!=="svelte-ylxtr1"&&(B.innerHTML=D),T=l(ee),b=m(ee,"P",{"data-svelte-h":!0}),_(b)!=="svelte-o55m63"&&(b.innerHTML=f),X=l(ee),w(R.$$.fragment,ee),Q=l(ee),u=m(ee,"DIV",{class:!0});var ge=te(u);w(M.$$.fragment,ge),G=l(ge),K=m(ge,"P",{"data-svelte-h":!0}),_(K)!=="svelte-1ngjjy6"&&(K.innerHTML=se),ge.forEach(d),ee.forEach(d),le=l(n),w(I.$$.fragment,n),C=l(n),W=m(n,"DIV",{class:!0});var re=te(W);w(ae.$$.fragment,re),Ie=l(re),Te=m(re,"P",{"data-svelte-h":!0}),_(Te)!=="svelte-c5g5w0"&&(Te.textContent=Ge),Ce=l(re),Me=m(re,"P",{"data-svelte-h":!0}),_(Me)!=="svelte-11h3bf1"&&(Me.innerHTML=Be),ke=l(re),ie=m(re,"DIV",{class:!0});var Je=te(ie);w(me.$$.fragment,Je),Ze=l(Je),_e=m(Je,"P",{"data-svelte-h":!0}),_(_e)!=="svelte-1y9kyj2"&&(_e.innerHTML=De),Je.forEach(d),$e=l(re),de=m(re,"DIV",{class:!0});var Ue=te(de);w(pe.$$.fragment,Ue),We=l(Ue),ye=m(Ue,"P",{"data-svelte-h":!0}),_(ye)!=="svelte-6oxe0s"&&(ye.innerHTML=Re),Ue.forEach(d),re.forEach(d),xe=l(n),w(ce.$$.fragment,n),ve=l(n),w(ue.$$.fragment,n),we=l(n),be=m(n,"P",{}),te(be).forEach(d),this.h()},h(){q(t,"name","hf:doc:metadata"),q(t,"content",dt),q(E,"class","flex flex-wrap space-x-1"),q(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),q(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(n,x){a(document.head,t),g(n,i,x),g(n,e,x),g(n,o,x),j(p,n,x),g(n,s,x),g(n,E,x),g(n,F,x),j(H,n,x),g(n,P,x),g(n,k,x),g(n,A,x),g(n,y,x),g(n,Y,x),j(Z,n,x),g(n,O,x),g(n,$,x),j(h,$,null),a($,N),a($,B),a($,T),a($,b),a($,X),j(R,$,null),a($,Q),a($,u),j(M,u,null),a(u,G),a(u,K),g(n,le,x),j(I,n,x),g(n,C,x),g(n,W,x),j(ae,W,null),a(W,Ie),a(W,Te),a(W,Ce),a(W,Me),a(W,ke),a(W,ie),j(me,ie,null),a(ie,Ze),a(ie,_e),a(W,$e),a(W,de),j(pe,de,null),a(de,We),a(de,ye),g(n,xe,x),j(ce,n,x),g(n,ve,x),j(ue,n,x),g(n,we,x),g(n,be,x),je=!0},p(n,[x]){const ee={};x&2&&(ee.$$scope={dirty:x,ctx:n}),R.$set(ee);const ge={};x&2&&(ge.$$scope={dirty:x,ctx:n}),ce.$set(ge)},i(n){je||(J(p.$$.fragment,n),J(H.$$.fragment,n),J(Z.$$.fragment,n),J(h.$$.fragment,n),J(R.$$.fragment,n),J(M.$$.fragment,n),J(I.$$.fragment,n),J(ae.$$.fragment,n),J(me.$$.fragment,n),J(pe.$$.fragment,n),J(ce.$$.fragment,n),J(ue.$$.fragment,n),je=!0)},o(n){U(p.$$.fragment,n),U(H.$$.fragment,n),U(Z.$$.fragment,n),U(h.$$.fragment,n),U(R.$$.fragment,n),U(M.$$.fragment,n),U(I.$$.fragment,n),U(ae.$$.fragment,n),U(me.$$.fragment,n),U(pe.$$.fragment,n),U(ce.$$.fragment,n),U(ue.$$.fragment,n),je=!1},d(n){n&&(d(i),d(e),d(o),d(s),d(E),d(F),d(P),d(k),d(A),d(y),d(Y),d(O),d($),d(le),d(C),d(W),d(xe),d(ve),d(we),d(be)),d(t),V(p,n),V(H,n),V(Z,n),V(h),V(R),V(M),V(I,n),V(ae),V(me),V(pe),V(ce,n),V(ue,n)}}}const dt='{"title":"VisionTextDualEncoder","local":"visiontextdualencoder","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"VisionTextDualEncoderConfig","local":"transformers.VisionTextDualEncoderConfig","sections":[],"depth":2},{"title":"VisionTextDualEncoderProcessor","local":"transformers.VisionTextDualEncoderProcessor","sections":[],"depth":2},{"title":"VisionTextDualEncoderModel","local":"transformers.VisionTextDualEncoderModel","sections":[],"depth":2},{"title":"FlaxVisionTextDualEncoderModel","local":"transformers.FlaxVisionTextDualEncoderModel","sections":[],"depth":2},{"title":"TFVisionTextDualEncoderModel","local":"transformers.TFVisionTextDualEncoderModel","sections":[],"depth":2}],"depth":1}';function ct(z){return Xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends He{constructor(t){super(),Pe(this,t,ct,it,Ne,{})}}export{yt as component};
