import{s as es,o as ts,n as xe}from"../chunks/scheduler.18a86fab.js";import{S as ss,i as ns,g as i,s as o,r as f,A as as,h as d,f as s,c as l,j as k,u as g,x as h,k as G,y as p,a,v as u,d as M,t as y,w as _}from"../chunks/index.98837b22.js";import{T as Vt}from"../chunks/Tip.77304350.js";import{D as Te}from"../chunks/Docstring.6758ea23.js";import{C as rt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Zt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as z}from"../chunks/Heading.7e7e0c5b.js";import{E as os}from"../chunks/index.499f366c.js";function ls(U){let n,T="Example:",c,m,b;return m=new rt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdml0Q29uZmlnJTJDJTIwVml2aXRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaVZpVCUyMGdvb2dsZSUyRnZpdml0LWItMTZ4Mi1raW5ldGljczQwMCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBWaXZpdENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZ2aXZpdC1iLTE2eDIta2luZXRpY3M0MDAlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpdml0TW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitConfig, VivitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ViViT google/vivit-b-16x2-kinetics400 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VivitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the google/vivit-b-16x2-kinetics400 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=i("p"),n.textContent=T,c=o(),f(m.$$.fragment)},l(r){n=d(r,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=T),c=l(r),g(m.$$.fragment,r)},m(r,w){a(r,n,w),a(r,c,w),u(m,r,w),b=!0},p:xe,i(r){b||(M(m.$$.fragment,r),b=!0)},o(r){y(m.$$.fragment,r),b=!1},d(r){r&&(s(n),s(c)),_(m,r)}}}function rs(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=i("p"),n.innerHTML=T},l(c){n=d(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(c,m){a(c,n,m)},p:xe,d(c){c&&s(n)}}}function is(U){let n,T="Examples:",c,m,b;return m=new rt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitImageProcessor, VivitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 32 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">32</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container=container, indices=indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VivitImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitModel.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3137</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){n=i("p"),n.textContent=T,c=o(),f(m.$$.fragment)},l(r){n=d(r,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=T),c=l(r),g(m.$$.fragment,r)},m(r,w){a(r,n,w),a(r,c,w),u(m,r,w),b=!0},p:xe,i(r){b||(M(m.$$.fragment,r),b=!0)},o(r){y(m.$$.fragment,r),b=!1},d(r){r&&(s(n),s(c)),_(m,r)}}}function ds(U){let n,T=`Note that it’s possible to fine-tune ViT on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){n=i("p"),n.innerHTML=T},l(c){n=d(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-111lhr1"&&(n.innerHTML=T)},m(c,m){a(c,n,m)},p:xe,d(c){c&&s(n)}}}function cs(U){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=i("p"),n.innerHTML=T},l(c){n=d(c,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(c,m){a(c,n,m)},p:xe,d(c){c&&s(n)}}}function ps(U){let n,T="Examples:",c,m,b;return m=new rt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitImageProcessor, VivitForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 32 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">32</span>, frame_sample_rate=<span class="hljs-number">4</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container=container, indices=indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VivitImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
LABEL_116`,wrap:!1}}),{c(){n=i("p"),n.textContent=T,c=o(),f(m.$$.fragment)},l(r){n=d(r,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=T),c=l(r),g(m.$$.fragment,r)},m(r,w){a(r,n,w),a(r,c,w),u(m,r,w),b=!0},p:xe,i(r){b||(M(m.$$.fragment,r),b=!0)},o(r){y(m.$$.fragment,r),b=!1},d(r){r&&(s(n),s(c)),_(m,r)}}}function ms(U){let n,T,c,m,b,r,w,Bt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',$e,Q,ke,L,Wt=`The Vivit model was proposed in <a href="https://arxiv.org/abs/2103.15691" rel="nofollow">ViViT: A Video Vision Transformer</a> by Anurag Arnab, Mostafa Dehghani, Georg Heigold, Chen Sun, Mario Lučić, Cordelia Schmid.
The paper proposes one of the first successful pure-transformer based set of models for video understanding.`,ze,P,xt="The abstract from the paper is the following:",Re,H,Gt="<em>We present pure-transformer based models for video classification, drawing upon the recent success of such models in image classification. Our model extracts spatio-temporal tokens from the input video, which are then encoded by a series of transformer layers. In order to handle the long sequences of tokens encountered in video, we propose several, efficient variants of our model which factorise the spatial- and temporal-dimensions of the input. Although transformer-based models are known to only be effective when large training datasets are available, we show how we can effectively regularise the model during training and leverage pretrained image models to be able to train on comparatively small datasets. We conduct thorough ablation studies, and achieve state-of-the-art results on multiple video classification benchmarks including Kinetics 400 and 600, Epic Kitchens, Something-Something v2 and Moments in Time, outperforming prior methods based on deep 3D convolutional networks.</em>",Ae,D,$t='This model was contributed by <a href="https://huggingface.co/jegormeister" rel="nofollow">jegormeister</a>. The original code (written in JAX) can be found <a href="https://github.com/google-research/scenic/tree/main/scenic/projects/vivit" rel="nofollow">here</a>.',Ne,q,Fe,K,kt=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Ee,O,zt=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,Xe,ee,Se,te,Rt="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",Ye,se,At="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>google/vivit-b-16x2-kinetics400</code> model, we saw the following speedups during inference.",Qe,ne,Le,ae,Nt='<thead><tr><th align="right">num_training_steps</th> <th align="right">batch_size</th> <th align="right">is cuda</th> <th align="right">Speedup (%)</th> <th align="right">Eager peak mem (MB)</th> <th align="right">sdpa peak mem (MB)</th> <th align="right">Mem saving (%)</th></tr></thead> <tbody><tr><td align="right">100</td> <td align="right">1</td> <td align="right">True</td> <td align="right">7.122</td> <td align="right">2575.28</td> <td align="right">5932.54</td> <td align="right">130.364</td></tr></tbody>',Pe,oe,He,le,Ft="<thead><tr><th>num_batches</th> <th>batch_size</th> <th>is cuda</th> <th>is half</th> <th>Speedup (%)</th> <th>Mem eager (MB)</th> <th>Mem BT (MB)</th> <th>Mem saved (%)</th></tr></thead> <tbody><tr><td>20</td> <td>1</td> <td>True</td> <td>False</td> <td>15.422</td> <td>715.807</td> <td>317.079</td> <td>125.75</td></tr> <tr><td>20</td> <td>2</td> <td>True</td> <td>False</td> <td>17.146</td> <td>1234.75</td> <td>447.175</td> <td>176.122</td></tr> <tr><td>20</td> <td>4</td> <td>True</td> <td>False</td> <td>18.093</td> <td>2275.82</td> <td>709.864</td> <td>220.6</td></tr> <tr><td>20</td> <td>8</td> <td>True</td> <td>False</td> <td>19.284</td> <td>4358.19</td> <td>1233.24</td> <td>253.393</td></tr></tbody>",De,re,qe,C,ie,it,be,Et=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitModel">VivitModel</a>. It is used to instantiate a ViViT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the ViViT
<a href="https://huggingface.co/google/vivit-b-16x2-kinetics400" rel="nofollow">google/vivit-b-16x2-kinetics400</a> architecture.`,dt,we,Xt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ct,R,Ke,de,Oe,B,ce,pt,je,St="Constructs a Vivit image processor.",mt,A,pe,ht,ve,Yt="Preprocess an image or batch of images.",et,me,tt,v,he,ft,Je,Qt="The bare Vivit Model outputting raw hidden-states without any specific head on top.",gt,Ue,Lt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ut,Ce,Pt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Mt,V,fe,yt,Ie,Ht='The <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> forward method, overrides the <code>__call__</code> special method.',_t,N,Tt,F,st,ge,nt,j,ue,bt,Ve,Dt=`ViViT Transformer model with a video classification head on top (a linear layer on top of the final hidden state of the
[CLS] token) e.g. for Kinetics-400.`,wt,E,jt,Ze,qt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vt,Be,Kt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jt,Z,Me,Ut,We,Ot='The <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitForVideoClassification">VivitForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',Ct,X,It,S,at,ye,ot,Ge,lt;return b=new z({props:{title:"Video Vision Transformer (ViViT)",local:"video-vision-transformer-vivit",headingTag:"h1"}}),Q=new z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new z({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),ee=new rt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdml0TW9kZWwlMEFtb2RlbCUyMCUzRCUyMFZpdml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdml0LWItMTZ4Mi1raW5ldGljczQwMCUyMiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJzZHBhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQS4uLg==",highlighted:`from transformers import VivitModel
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">VivitModel</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>
...`,wrap:!1}}),ne=new z({props:{title:"Training",local:"training",headingTag:"h3"}}),oe=new z({props:{title:"Inference",local:"inference",headingTag:"h3"}}),re=new z({props:{title:"VivitConfig",local:"transformers.VivitConfig",headingTag:"h2"}}),ie=new Te({props:{name:"class transformers.VivitConfig",anchor:"transformers.VivitConfig",parameters:[{name:"image_size",val:" = 224"},{name:"num_frames",val:" = 32"},{name:"tubelet_size",val:" = [2, 16, 16]"},{name:"num_channels",val:" = 3"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu_fast'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"qkv_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VivitConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.VivitConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.VivitConfig.tubelet_size",description:`<strong>tubelet_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 16, 16]</code>) &#x2014;
The size (resolution) of each tubelet.`,name:"tubelet_size"},{anchor:"transformers.VivitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.VivitConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.VivitConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.VivitConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.VivitConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.VivitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_fast&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code>, <code>&quot;gelu_fast&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.VivitConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.VivitConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.VivitConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VivitConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.VivitConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/configuration_vivit.py#L24"}}),R=new Zt({props:{anchor:"transformers.VivitConfig.example",$$slots:{default:[ls]},$$scope:{ctx:U}}}),de=new z({props:{title:"VivitImageProcessor",local:"transformers.VivitImageProcessor",headingTag:"h2"}}),ce=new Te({props:{name:"class transformers.VivitImageProcessor",anchor:"transformers.VivitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00784313725490196"},{name:"offset",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VivitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VivitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 256}</code>):
Size of the output image after resizing. The shortest edge of the image will be resized to
<code>size[&quot;shortest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overridden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VivitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VivitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VivitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.VivitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VivitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/127.5</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VivitImageProcessor.offset",description:`<strong>offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to scale the image in both negative and positive directions. Can be overridden by the <code>offset</code> in
the <code>preprocess</code> method.`,name:"offset"},{anchor:"transformers.VivitImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VivitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VivitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/image_processing_vivit.py#L66"}}),pe=new Te({props:{name:"preprocess",anchor:"transformers.VivitImageProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"offset",val:": typing.Optional[bool] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VivitImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>ImageInput</code>) &#x2014;
Video frames to preprocess. Expects a single or batch of video frames with pixel values ranging from 0
to 255. If passing in frames with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VivitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VivitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.VivitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VivitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.VivitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.VivitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between <code>[-1 - 1]</code> if <code>offset</code> is <code>True</code>, <code>[0, 1]</code> otherwise.`,name:"do_rescale"},{anchor:"transformers.VivitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VivitImageProcessor.preprocess.offset",description:`<strong>offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.offset</code>) &#x2014;
Whether to scale the image in both negative and positive directions.`,name:"offset"},{anchor:"transformers.VivitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VivitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.VivitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.VivitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VivitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VivitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/image_processing_vivit.py#L289"}}),me=new z({props:{title:"VivitModel",local:"transformers.VivitModel",headingTag:"h2"}}),he=new Te({props:{name:"class transformers.VivitModel",anchor:"transformers.VivitModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.VivitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitModel">VivitModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.VivitModel.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a pooling layer`,name:"add_pooling_layer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L480"}}),fe=new Te({props:{name:"forward",anchor:"transformers.VivitModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VivitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VivitModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VivitModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VivitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VivitModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.VivitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig"
>VivitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new Vt({props:{$$slots:{default:[rs]},$$scope:{ctx:U}}}),F=new Zt({props:{anchor:"transformers.VivitModel.forward.example",$$slots:{default:[is]},$$scope:{ctx:U}}}),ge=new z({props:{title:"VivitForVideoClassification",local:"transformers.VivitForVideoClassification",headingTag:"h2"}}),ue=new Te({props:{name:"class transformers.VivitForVideoClassification",anchor:"transformers.VivitForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VivitForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitForVideoClassification">VivitForVideoClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L632"}}),E=new Vt({props:{$$slots:{default:[ds]},$$scope:{ctx:U}}}),Me=new Te({props:{name:"forward",anchor:"transformers.VivitForVideoClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VivitForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VivitForVideoClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VivitForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.VivitForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VivitForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VivitForVideoClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.VivitForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig"
>VivitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Vt({props:{$$slots:{default:[cs]},$$scope:{ctx:U}}}),S=new Zt({props:{anchor:"transformers.VivitForVideoClassification.forward.example",$$slots:{default:[ps]},$$scope:{ctx:U}}}),ye=new os({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/vivit.md"}}),{c(){n=i("meta"),T=o(),c=i("p"),m=o(),f(b.$$.fragment),r=o(),w=i("div"),w.innerHTML=Bt,$e=o(),f(Q.$$.fragment),ke=o(),L=i("p"),L.innerHTML=Wt,ze=o(),P=i("p"),P.textContent=xt,Re=o(),H=i("p"),H.innerHTML=Gt,Ae=o(),D=i("p"),D.innerHTML=$t,Ne=o(),f(q.$$.fragment),Fe=o(),K=i("p"),K.innerHTML=kt,Ee=o(),O=i("p"),O.innerHTML=zt,Xe=o(),f(ee.$$.fragment),Se=o(),te=i("p"),te.innerHTML=Rt,Ye=o(),se=i("p"),se.innerHTML=At,Qe=o(),f(ne.$$.fragment),Le=o(),ae=i("table"),ae.innerHTML=Nt,Pe=o(),f(oe.$$.fragment),He=o(),le=i("table"),le.innerHTML=Ft,De=o(),f(re.$$.fragment),qe=o(),C=i("div"),f(ie.$$.fragment),it=o(),be=i("p"),be.innerHTML=Et,dt=o(),we=i("p"),we.innerHTML=Xt,ct=o(),f(R.$$.fragment),Ke=o(),f(de.$$.fragment),Oe=o(),B=i("div"),f(ce.$$.fragment),pt=o(),je=i("p"),je.textContent=St,mt=o(),A=i("div"),f(pe.$$.fragment),ht=o(),ve=i("p"),ve.textContent=Yt,et=o(),f(me.$$.fragment),tt=o(),v=i("div"),f(he.$$.fragment),ft=o(),Je=i("p"),Je.textContent=Qt,gt=o(),Ue=i("p"),Ue.innerHTML=Lt,ut=o(),Ce=i("p"),Ce.innerHTML=Pt,Mt=o(),V=i("div"),f(fe.$$.fragment),yt=o(),Ie=i("p"),Ie.innerHTML=Ht,_t=o(),f(N.$$.fragment),Tt=o(),f(F.$$.fragment),st=o(),f(ge.$$.fragment),nt=o(),j=i("div"),f(ue.$$.fragment),bt=o(),Ve=i("p"),Ve.textContent=Dt,wt=o(),f(E.$$.fragment),jt=o(),Ze=i("p"),Ze.innerHTML=qt,vt=o(),Be=i("p"),Be.innerHTML=Kt,Jt=o(),Z=i("div"),f(Me.$$.fragment),Ut=o(),We=i("p"),We.innerHTML=Ot,Ct=o(),f(X.$$.fragment),It=o(),f(S.$$.fragment),at=o(),f(ye.$$.fragment),ot=o(),Ge=i("p"),this.h()},l(e){const t=as("svelte-u9bgzb",document.head);n=d(t,"META",{name:!0,content:!0}),t.forEach(s),T=l(e),c=d(e,"P",{}),k(c).forEach(s),m=l(e),g(b.$$.fragment,e),r=l(e),w=d(e,"DIV",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-b95w5j"&&(w.innerHTML=Bt),$e=l(e),g(Q.$$.fragment,e),ke=l(e),L=d(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1dq9qfe"&&(L.innerHTML=Wt),ze=l(e),P=d(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-vfdo9a"&&(P.textContent=xt),Re=l(e),H=d(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1lz2sl9"&&(H.innerHTML=Gt),Ae=l(e),D=d(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-jnd3xg"&&(D.innerHTML=$t),Ne=l(e),g(q.$$.fragment,e),Fe=l(e),K=d(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-1cid2pe"&&(K.innerHTML=kt),Ee=l(e),O=d(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1x11lxg"&&(O.innerHTML=zt),Xe=l(e),g(ee.$$.fragment,e),Se=l(e),te=d(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-djb2w0"&&(te.innerHTML=Rt),Ye=l(e),se=d(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-51m2p5"&&(se.innerHTML=At),Qe=l(e),g(ne.$$.fragment,e),Le=l(e),ae=d(e,"TABLE",{"data-svelte-h":!0}),h(ae)!=="svelte-v3fx1h"&&(ae.innerHTML=Nt),Pe=l(e),g(oe.$$.fragment,e),He=l(e),le=d(e,"TABLE",{"data-svelte-h":!0}),h(le)!=="svelte-1ia57i7"&&(le.innerHTML=Ft),De=l(e),g(re.$$.fragment,e),qe=l(e),C=d(e,"DIV",{class:!0});var W=k(C);g(ie.$$.fragment,W),it=l(W),be=d(W,"P",{"data-svelte-h":!0}),h(be)!=="svelte-mpth5h"&&(be.innerHTML=Et),dt=l(W),we=d(W,"P",{"data-svelte-h":!0}),h(we)!=="svelte-o55m63"&&(we.innerHTML=Xt),ct=l(W),g(R.$$.fragment,W),W.forEach(s),Ke=l(e),g(de.$$.fragment,e),Oe=l(e),B=d(e,"DIV",{class:!0});var $=k(B);g(ce.$$.fragment,$),pt=l($),je=d($,"P",{"data-svelte-h":!0}),h(je)!=="svelte-imia5q"&&(je.textContent=St),mt=l($),A=d($,"DIV",{class:!0});var _e=k(A);g(pe.$$.fragment,_e),ht=l(_e),ve=d(_e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1x3yxsa"&&(ve.textContent=Yt),_e.forEach(s),$.forEach(s),et=l(e),g(me.$$.fragment,e),tt=l(e),v=d(e,"DIV",{class:!0});var I=k(v);g(he.$$.fragment,I),ft=l(I),Je=d(I,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-ra9dyy"&&(Je.textContent=Qt),gt=l(I),Ue=d(I,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-6pahdo"&&(Ue.innerHTML=Lt),ut=l(I),Ce=d(I,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-hswkmf"&&(Ce.innerHTML=Pt),Mt=l(I),V=d(I,"DIV",{class:!0});var x=k(V);g(fe.$$.fragment,x),yt=l(x),Ie=d(x,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-lvjixl"&&(Ie.innerHTML=Ht),_t=l(x),g(N.$$.fragment,x),Tt=l(x),g(F.$$.fragment,x),x.forEach(s),I.forEach(s),st=l(e),g(ge.$$.fragment,e),nt=l(e),j=d(e,"DIV",{class:!0});var J=k(j);g(ue.$$.fragment,J),bt=l(J),Ve=d(J,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-1vvfjf6"&&(Ve.textContent=Dt),wt=l(J),g(E.$$.fragment,J),jt=l(J),Ze=d(J,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-6pahdo"&&(Ze.innerHTML=qt),vt=l(J),Be=d(J,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-hswkmf"&&(Be.innerHTML=Kt),Jt=l(J),Z=d(J,"DIV",{class:!0});var Y=k(Z);g(Me.$$.fragment,Y),Ut=l(Y),We=d(Y,"P",{"data-svelte-h":!0}),h(We)!=="svelte-gnp77j"&&(We.innerHTML=Ot),Ct=l(Y),g(X.$$.fragment,Y),It=l(Y),g(S.$$.fragment,Y),Y.forEach(s),J.forEach(s),at=l(e),g(ye.$$.fragment,e),ot=l(e),Ge=d(e,"P",{}),k(Ge).forEach(s),this.h()},h(){G(n,"name","hf:doc:metadata"),G(n,"content",hs),G(w,"class","flex flex-wrap space-x-1"),G(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,n),a(e,T,t),a(e,c,t),a(e,m,t),u(b,e,t),a(e,r,t),a(e,w,t),a(e,$e,t),u(Q,e,t),a(e,ke,t),a(e,L,t),a(e,ze,t),a(e,P,t),a(e,Re,t),a(e,H,t),a(e,Ae,t),a(e,D,t),a(e,Ne,t),u(q,e,t),a(e,Fe,t),a(e,K,t),a(e,Ee,t),a(e,O,t),a(e,Xe,t),u(ee,e,t),a(e,Se,t),a(e,te,t),a(e,Ye,t),a(e,se,t),a(e,Qe,t),u(ne,e,t),a(e,Le,t),a(e,ae,t),a(e,Pe,t),u(oe,e,t),a(e,He,t),a(e,le,t),a(e,De,t),u(re,e,t),a(e,qe,t),a(e,C,t),u(ie,C,null),p(C,it),p(C,be),p(C,dt),p(C,we),p(C,ct),u(R,C,null),a(e,Ke,t),u(de,e,t),a(e,Oe,t),a(e,B,t),u(ce,B,null),p(B,pt),p(B,je),p(B,mt),p(B,A),u(pe,A,null),p(A,ht),p(A,ve),a(e,et,t),u(me,e,t),a(e,tt,t),a(e,v,t),u(he,v,null),p(v,ft),p(v,Je),p(v,gt),p(v,Ue),p(v,ut),p(v,Ce),p(v,Mt),p(v,V),u(fe,V,null),p(V,yt),p(V,Ie),p(V,_t),u(N,V,null),p(V,Tt),u(F,V,null),a(e,st,t),u(ge,e,t),a(e,nt,t),a(e,j,t),u(ue,j,null),p(j,bt),p(j,Ve),p(j,wt),u(E,j,null),p(j,jt),p(j,Ze),p(j,vt),p(j,Be),p(j,Jt),p(j,Z),u(Me,Z,null),p(Z,Ut),p(Z,We),p(Z,Ct),u(X,Z,null),p(Z,It),u(S,Z,null),a(e,at,t),u(ye,e,t),a(e,ot,t),a(e,Ge,t),lt=!0},p(e,[t]){const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),R.$set(W);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),N.$set($);const _e={};t&2&&(_e.$$scope={dirty:t,ctx:e}),F.$set(_e);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),E.$set(I);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),X.$set(x);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),S.$set(J)},i(e){lt||(M(b.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(ie.$$.fragment,e),M(R.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(N.$$.fragment,e),M(F.$$.fragment,e),M(ge.$$.fragment,e),M(ue.$$.fragment,e),M(E.$$.fragment,e),M(Me.$$.fragment,e),M(X.$$.fragment,e),M(S.$$.fragment,e),M(ye.$$.fragment,e),lt=!0)},o(e){y(b.$$.fragment,e),y(Q.$$.fragment,e),y(q.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(ie.$$.fragment,e),y(R.$$.fragment,e),y(de.$$.fragment,e),y(ce.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(N.$$.fragment,e),y(F.$$.fragment,e),y(ge.$$.fragment,e),y(ue.$$.fragment,e),y(E.$$.fragment,e),y(Me.$$.fragment,e),y(X.$$.fragment,e),y(S.$$.fragment,e),y(ye.$$.fragment,e),lt=!1},d(e){e&&(s(T),s(c),s(m),s(r),s(w),s($e),s(ke),s(L),s(ze),s(P),s(Re),s(H),s(Ae),s(D),s(Ne),s(Fe),s(K),s(Ee),s(O),s(Xe),s(Se),s(te),s(Ye),s(se),s(Qe),s(Le),s(ae),s(Pe),s(He),s(le),s(De),s(qe),s(C),s(Ke),s(Oe),s(B),s(et),s(tt),s(v),s(st),s(nt),s(j),s(at),s(ot),s(Ge)),s(n),_(b,e),_(Q,e),_(q,e),_(ee,e),_(ne,e),_(oe,e),_(re,e),_(ie),_(R),_(de,e),_(ce),_(pe),_(me,e),_(he),_(fe),_(N),_(F),_(ge,e),_(ue),_(E),_(Me),_(X),_(S),_(ye,e)}}}const hs='{"title":"Video Vision Transformer (ViViT)","local":"video-vision-transformer-vivit","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"VivitConfig","local":"transformers.VivitConfig","sections":[],"depth":2},{"title":"VivitImageProcessor","local":"transformers.VivitImageProcessor","sections":[],"depth":2},{"title":"VivitModel","local":"transformers.VivitModel","sections":[],"depth":2},{"title":"VivitForVideoClassification","local":"transformers.VivitForVideoClassification","sections":[],"depth":2}],"depth":1}';function fs(U){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends ss{constructor(n){super(),ns(this,n,fs,ms,es,{})}}export{js as component};
