import{s as Bs,n as Es,o as Vs}from"../chunks/scheduler.18a86fab.js";import{S as Zs,i as Ds,g as M,s as a,r as j,A as xs,h as p,f as e,c as t,j as Ns,u as y,x as i,k as Qs,l as Js,y as Ws,a as n,v as c,d as o,t as r,w as J}from"../chunks/index.98837b22.js";import{C as v}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as Rs}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as vs}from"../chunks/Heading.7e7e0c5b.js";import{E as Ls}from"../chunks/index.499f366c.js";function zs(ms){let m,$,L,_,w,G,U,S,h,us="Keypoint detection identifies and locates specific points of interest within an image. These keypoints, also known as landmarks, represent meaningful features of objects, such as facial features or object parts. These models take an image input and return the following outputs:",H,b,Ts="<li><strong>Keypoints and Scores</strong>: Points of interest and their confidence scores.</li> <li><strong>Descriptors</strong>: A representation of the image region surrounding each keypoint, capturing its texture, gradient, orientation and other properties.</li>",X,C,ws="In this guide, we will show how to extract keypoints from images.",F,A,Us='For this tutorial, we will use <a href="./model_doc/superpoint.md">SuperPoint</a>, a foundation model for keypoint detection.',Y,d,K,I,hs="Let’s test the model on the images below.",q,u,bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="Bee" style="height: 200px; object-fit: contain; margin-right: 10px;"/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png" alt="Cats" style="height: 200px; object-fit: contain;"/>',P,g,O,k,Cs="We can now process our inputs and infer.",ss,f,ls,N,As="The model output has relative keypoints, descriptors, masks and scores for each item in the batch. The mask highlights areas of the image where keypoints are present.",es,Q,ns,B,ds="To plot actual keypoints in the image, we need to postprocess the output. To do so, we have to pass the actual image sizes to <code>post_process_keypoint_detection</code> along with outputs.",as,E,ts,V,Is="The outputs are now a list of dictionaries where each dictionary is a processed output of keypoints, scores and descriptors.",Ms,Z,ps,D,gs="We can use these to plot the keypoints.",is,x,js,W,ks="Below you can see the outputs.",ys,T,fs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee_keypoint.png" alt="Bee" style="height: 200px; object-fit: contain; margin-right: 10px;"/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats_keypoint.png" alt="Cats" style="height: 200px; object-fit: contain;"/>',cs,R,os,z,rs;return w=new vs({props:{title:"Keypoint Detection",local:"keypoint-detection",headingTag:"h1"}}),U=new Rs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/keypoint_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/keypoint_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/keypoint_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/keypoint_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/keypoint_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/keypoint_detection.ipynb"}]}}),d=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWFnaWMtbGVhcC1jb21tdW5pdHklMkZzdXBlcnBvaW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3VwZXJQb2ludEZvcktleXBvaW50RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)`,wrap:!1}}),g=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMGN2MiUwQSUwQSUwQXVybF9pbWFnZV8xJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlXzElMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfaW1hZ2VfMSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEF1cmxfaW1hZ2VfMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTBBaW1hZ2VfMiUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybF9pbWFnZV8yJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1QmltYWdlXzElMkMlMjBpbWFnZV8yJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> cv2


url_image_1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_1, stream=<span class="hljs-literal">True</span>).raw)
url_image_2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_2, stream=<span class="hljs-literal">True</span>).raw)

images = [image_1, image_2]`,wrap:!1}}),f=new v({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQ3JldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSUyQyUyMG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`inputs = processor(images,return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, model.dtype)
outputs = model(**inputs)`,wrap:!1}}),Q=new v({props:{code:"U3VwZXJQb2ludEtleXBvaW50RGVzY3JpcHRpb25PdXRwdXQobG9zcyUzRE5vbmUlMkMlMjBrZXlwb2ludHMlM0R0ZW5zb3IoJTVCJTVCJTVCMC4wNDM3JTJDJTIwMC4wMTY3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC4wNjg4JTJDJTIwMC4wMTY3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC4wMTcyJTJDJTIwMC4wMTg4JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTg0JTJDJTIwMC45ODEyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC42OTUzJTJDJTIwMC45ODEyJTVEJTVEJTVEKSUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjb3JlcyUzRHRlbnNvciglNUIlNUIwLjAwNTYlMkMlMjAwLjAwNTMlMkMlMjAwLjAwNzklMkMlMjAlMjAuLi4lMkMlMjAwLjAxMjUlMkMlMjAwLjA1MzklMkMlMjAwLjAzNzclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAyMDYlMkMlMjAwLjAwNTglMkMlMjAwLjAwNjUlMkMlMjAlMjAuLi4lMkMlMjAwLjAwMDAlMkMlMjAwLjAwMDAlMkMlMjAwLjAwMDAlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBncmFkX2ZuJTNEJTNDQ29weVNsaWNlcyUzRSklMkMlMjBkZXNjcmlwdG9ycyUzRHRlbnNvciglNUIlNUIlNUItMC4wODA3JTJDJTIwJTIwMC4wMTE0JTJDJTIwLTAuMTIxMCUyQyUyMCUyMC4uLiUyQyUyMC0wLjExMjIlMkMlMjAlMjAwLjA4OTklMkMlMjAlMjAwLjAzNTclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUItMC4wODA3JTJDJTIwJTIwMC4wMTE0JTJDJTIwLTAuMTIxMCUyQyUyMCUyMC4uLiUyQyUyMC0wLjExMjIlMkMlMjAlMjAwLjA4OTklMkMlMjAlMjAwLjAzNTclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUItMC4wODA3JTJDJTIwJTIwMC4wMTE0JTJDJTIwLTAuMTIxMCUyQyUyMCUyMC4uLiUyQyUyMC0wLjExMjIlMkMlMjAlMjAwLjA4OTklMkMlMjAlMjAwLjAzNTclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBncmFkX2ZuJTNEJTNDQ29weVNsaWNlcyUzRSklMkMlMjBtYXNrJTNEdGVuc29yKCU1QiU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMCUyMC4uLiUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMCUyMC4uLiUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCU1RCUyQyUyMGR0eXBlJTNEdG9yY2guaW50MzIpJTJDJTIwaGlkZGVuX3N0YXRlcyUzRE5vbmUp",highlighted:`SuperPointKeypointDescriptionOutput(loss=<span class="hljs-literal">None</span>, keypoints=tensor([[[<span class="hljs-number">0.0437</span>, <span class="hljs-number">0.0167</span>],
         [<span class="hljs-number">0.0688</span>, <span class="hljs-number">0.0167</span>],
         [<span class="hljs-number">0.0172</span>, <span class="hljs-number">0.0188</span>],
         ...,
         [<span class="hljs-number">0.5984</span>, <span class="hljs-number">0.9812</span>],
         [<span class="hljs-number">0.6953</span>, <span class="hljs-number">0.9812</span>]]]), 
         scores=tensor([[<span class="hljs-number">0.0056</span>, <span class="hljs-number">0.0053</span>, <span class="hljs-number">0.0079</span>,  ..., <span class="hljs-number">0.0125</span>, <span class="hljs-number">0.0539</span>, <span class="hljs-number">0.0377</span>],
        [<span class="hljs-number">0.0206</span>, <span class="hljs-number">0.0058</span>, <span class="hljs-number">0.0065</span>,  ..., <span class="hljs-number">0.0000</span>, <span class="hljs-number">0.0000</span>, <span class="hljs-number">0.0000</span>]],
       grad_fn=&lt;CopySlices&gt;), descriptors=tensor([[[-<span class="hljs-number">0.0807</span>,  <span class="hljs-number">0.0114</span>, -<span class="hljs-number">0.1210</span>,  ..., -<span class="hljs-number">0.1122</span>,  <span class="hljs-number">0.0899</span>,  <span class="hljs-number">0.0357</span>],
         [-<span class="hljs-number">0.0807</span>,  <span class="hljs-number">0.0114</span>, -<span class="hljs-number">0.1210</span>,  ..., -<span class="hljs-number">0.1122</span>,  <span class="hljs-number">0.0899</span>,  <span class="hljs-number">0.0357</span>],
         [-<span class="hljs-number">0.0807</span>,  <span class="hljs-number">0.0114</span>, -<span class="hljs-number">0.1210</span>,  ..., -<span class="hljs-number">0.1122</span>,  <span class="hljs-number">0.0899</span>,  <span class="hljs-number">0.0357</span>],
         ...],
       grad_fn=&lt;CopySlices&gt;), mask=tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]], dtype=torch.int32), hidden_states=<span class="hljs-literal">None</span>)`,wrap:!1}}),E=new v({props:{code:"aW1hZ2Vfc2l6ZXMlMjAlM0QlMjAlNUIoaW1hZ2Uuc2l6ZSU1QjElNUQlMkMlMjBpbWFnZS5zaXplJTVCMCU1RCklMjBmb3IlMjBpbWFnZSUyMGluJTIwaW1hZ2VzJTVEJTBBb3V0cHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfa2V5cG9pbnRfZGV0ZWN0aW9uKG91dHB1dHMlMkMlMjBpbWFnZV9zaXplcyk=",highlighted:`image_sizes = [(image.size[<span class="hljs-number">1</span>], image.size[<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
outputs = processor.post_process_keypoint_detection(outputs, image_sizes)`,wrap:!1}}),Z=new v({props:{code:"JTVCJTdCJ2tleXBvaW50cyclM0ElMjB0ZW5zb3IoJTVCJTVCJTIwMjI2JTJDJTIwJTIwJTIwNTclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMjAzNTYlMkMlMjAlMjAlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMCUyMDg5JTJDJTIwJTIwJTIwNjQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIzNjA0JTJDJTIwMzM5MSU1RCU1RCUyQyUyMGR0eXBlJTNEdG9yY2guaW50MzIpJTJDJTBBJTIwJTIwJ3Njb3JlcyclM0ElMjB0ZW5zb3IoJTVCMC4wMDU2JTJDJTIwMC4wMDUzJTJDJTIwLi4uJTVEJTJDJTIwZ3JhZF9mbiUzRCUzQ0luZGV4QmFja3dhcmQwJTNFKSUyQyUwQSUyMCUyMCdkZXNjcmlwdG9ycyclM0ElMjB0ZW5zb3IoJTVCJTVCLTAuMDgwNyUyQyUyMCUyMDAuMDExNCUyQyUyMC0wLjEyMTAlMkMlMjAlMjAuLi4lMkMlMjAtMC4xMTIyJTJDJTIwJTIwMC4wODk5JTJDJTIwJTIwMC4wMzU3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCLTAuMDgwNyUyQyUyMCUyMDAuMDExNCUyQyUyMC0wLjEyMTAlMkMlMjAlMjAuLi4lMkMlMjAtMC4xMTIyJTJDJTIwJTIwMC4wODk5JTJDJTIwJTIwMC4wMzU3JTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3JhZF9mbiUzRCUzQ0luZGV4QmFja3dhcmQwJTNFKSU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QidrZXlwb2ludHMnJTNBJTIwdGVuc29yKCU1QiU1QiUyMDQ2JTJDJTIwJTIwJTIwNiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMDc4JTJDJTIwJTIwJTIwNiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjQyMiUyQyUyMCUyMCUyMDYlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIyMDYlMkMlMjA0MDQlNUQlNUQlMkMlMjBkdHlwZSUzRHRvcmNoLmludDMyKSUyQyUwQSUyMCUyMCdzY29yZXMnJTNBJTIwdGVuc29yKCU1QjAuMDIwNiUyQyUyMDAuMDA1OCUyQyUyMDAuMDA2NSUyQyUyMDAuMDA1MyUyQyUyMDAuMDA3MCUyQyUyMC4uLiUyQ2dyYWRfZm4lM0QlM0NJbmRleEJhY2t3YXJkMCUzRSklMkMlMEElMjAlMjAnZGVzY3JpcHRvcnMnJTNBJTIwdGVuc29yKCU1QiU1Qi0wLjA1MjUlMkMlMjAlMjAwLjA3MjYlMkMlMjAlMjAwLjAyNzAlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjAzODklMkMlMjAtMC4wMTg5JTJDJTIwLTAuMDIxMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0wLjA1MjUlMkMlMjAlMjAwLjA3MjYlMkMlMjAlMjAwLjAyNzAlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjAzODklMkMlMjAtMC4wMTg5JTJDJTIwLTAuMDIxMSU1RCU3RCU1RA==",highlighted:`[{<span class="hljs-string">&#x27;keypoints&#x27;</span>: tensor([[ <span class="hljs-number">226</span>,   <span class="hljs-number">57</span>],
          [ <span class="hljs-number">356</span>,   <span class="hljs-number">57</span>],
          [  <span class="hljs-number">89</span>,   <span class="hljs-number">64</span>],
          ...,
          [<span class="hljs-number">3604</span>, <span class="hljs-number">3391</span>]], dtype=torch.int32),
  <span class="hljs-string">&#x27;scores&#x27;</span>: tensor([<span class="hljs-number">0.0056</span>, <span class="hljs-number">0.0053</span>, ...], grad_fn=&lt;IndexBackward0&gt;),
  <span class="hljs-string">&#x27;descriptors&#x27;</span>: tensor([[-<span class="hljs-number">0.0807</span>,  <span class="hljs-number">0.0114</span>, -<span class="hljs-number">0.1210</span>,  ..., -<span class="hljs-number">0.1122</span>,  <span class="hljs-number">0.0899</span>,  <span class="hljs-number">0.0357</span>],
          [-<span class="hljs-number">0.0807</span>,  <span class="hljs-number">0.0114</span>, -<span class="hljs-number">0.1210</span>,  ..., -<span class="hljs-number">0.1122</span>,  <span class="hljs-number">0.0899</span>,  <span class="hljs-number">0.0357</span>]],
         grad_fn=&lt;IndexBackward0&gt;)},
    {<span class="hljs-string">&#x27;keypoints&#x27;</span>: tensor([[ <span class="hljs-number">46</span>,   <span class="hljs-number">6</span>],
          [ <span class="hljs-number">78</span>,   <span class="hljs-number">6</span>],
          [<span class="hljs-number">422</span>,   <span class="hljs-number">6</span>],
          [<span class="hljs-number">206</span>, <span class="hljs-number">404</span>]], dtype=torch.int32),
  <span class="hljs-string">&#x27;scores&#x27;</span>: tensor([<span class="hljs-number">0.0206</span>, <span class="hljs-number">0.0058</span>, <span class="hljs-number">0.0065</span>, <span class="hljs-number">0.0053</span>, <span class="hljs-number">0.0070</span>, ...,grad_fn=&lt;IndexBackward0&gt;),
  <span class="hljs-string">&#x27;descriptors&#x27;</span>: tensor([[-<span class="hljs-number">0.0525</span>,  <span class="hljs-number">0.0726</span>,  <span class="hljs-number">0.0270</span>,  ...,  <span class="hljs-number">0.0389</span>, -<span class="hljs-number">0.0189</span>, -<span class="hljs-number">0.0211</span>],
          [-<span class="hljs-number">0.0525</span>,  <span class="hljs-number">0.0726</span>,  <span class="hljs-number">0.0270</span>,  ...,  <span class="hljs-number">0.0389</span>, -<span class="hljs-number">0.0189</span>, -<span class="hljs-number">0.0211</span>]}]`,wrap:!1}}),x=new v({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGltYWdlcykpJTNBJTBBJTIwJTIwa2V5cG9pbnRzJTIwJTNEJTIwb3V0cHV0cyU1QmklNUQlNUIlMjJrZXlwb2ludHMlMjIlNUQlMEElMjAlMjBzY29yZXMlMjAlM0QlMjBvdXRwdXRzJTVCaSU1RCU1QiUyMnNjb3JlcyUyMiU1RCUwQSUyMCUyMGRlc2NyaXB0b3JzJTIwJTNEJTIwb3V0cHV0cyU1QmklNUQlNUIlMjJkZXNjcmlwdG9ycyUyMiU1RCUwQSUyMCUyMGtleXBvaW50cyUyMCUzRCUyMG91dHB1dHMlNUJpJTVEJTVCJTIya2V5cG9pbnRzJTIyJTVELmRldGFjaCgpLm51bXB5KCklMEElMjAlMjBzY29yZXMlMjAlM0QlMjBvdXRwdXRzJTVCaSU1RCU1QiUyMnNjb3JlcyUyMiU1RC5kZXRhY2goKS5udW1weSgpJTBBJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZXMlNUJpJTVEJTBBJTIwJTIwaW1hZ2Vfd2lkdGglMkMlMjBpbWFnZV9oZWlnaHQlMjAlM0QlMjBpbWFnZS5zaXplJTBBJTBBJTIwJTIwcGx0LmF4aXMoJ29mZicpJTBBJTIwJTIwcGx0Lmltc2hvdyhpbWFnZSklMEElMjAlMjBwbHQuc2NhdHRlciglMEElMjAlMjAlMjAlMjAlMjAlMjBrZXlwb2ludHMlNUIlM0ElMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwa2V5cG9pbnRzJTVCJTNBJTJDJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHMlM0RzY29yZXMlMjAqJTIwMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYyUzRCdjeWFuJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFscGhhJTNEMC40JTBBJTIwJTIwKSUwQSUyMCUyMHBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(images)):
  keypoints = outputs[i][<span class="hljs-string">&quot;keypoints&quot;</span>]
  scores = outputs[i][<span class="hljs-string">&quot;scores&quot;</span>]
  descriptors = outputs[i][<span class="hljs-string">&quot;descriptors&quot;</span>]
  keypoints = outputs[i][<span class="hljs-string">&quot;keypoints&quot;</span>].detach().numpy()
  scores = outputs[i][<span class="hljs-string">&quot;scores&quot;</span>].detach().numpy()
  image = images[i]
  image_width, image_height = image.size

  plt.axis(<span class="hljs-string">&#x27;off&#x27;</span>)
  plt.imshow(image)
  plt.scatter(
      keypoints[:, <span class="hljs-number">0</span>],
      keypoints[:, <span class="hljs-number">1</span>],
      s=scores * <span class="hljs-number">100</span>,
      c=<span class="hljs-string">&#x27;cyan&#x27;</span>,
      alpha=<span class="hljs-number">0.4</span>
  )
  plt.show()`,wrap:!1}}),R=new Ls({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/keypoint_detection.md"}}),{c(){m=M("meta"),$=a(),L=M("p"),_=a(),j(w.$$.fragment),G=a(),j(U.$$.fragment),S=a(),h=M("p"),h.textContent=us,H=a(),b=M("ul"),b.innerHTML=Ts,X=a(),C=M("p"),C.textContent=ws,F=a(),A=M("p"),A.innerHTML=Us,Y=a(),j(d.$$.fragment),K=a(),I=M("p"),I.textContent=hs,q=a(),u=M("div"),u.innerHTML=bs,P=a(),j(g.$$.fragment),O=a(),k=M("p"),k.textContent=Cs,ss=a(),j(f.$$.fragment),ls=a(),N=M("p"),N.textContent=As,es=a(),j(Q.$$.fragment),ns=a(),B=M("p"),B.innerHTML=ds,as=a(),j(E.$$.fragment),ts=a(),V=M("p"),V.textContent=Is,Ms=a(),j(Z.$$.fragment),ps=a(),D=M("p"),D.textContent=gs,is=a(),j(x.$$.fragment),js=a(),W=M("p"),W.textContent=ks,ys=a(),T=M("div"),T.innerHTML=fs,cs=a(),j(R.$$.fragment),os=a(),z=M("p"),this.h()},l(s){const l=xs("svelte-u9bgzb",document.head);m=p(l,"META",{name:!0,content:!0}),l.forEach(e),$=t(s),L=p(s,"P",{}),Ns(L).forEach(e),_=t(s),y(w.$$.fragment,s),G=t(s),y(U.$$.fragment,s),S=t(s),h=p(s,"P",{"data-svelte-h":!0}),i(h)!=="svelte-ldm9pw"&&(h.textContent=us),H=t(s),b=p(s,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-1thyc59"&&(b.innerHTML=Ts),X=t(s),C=p(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-th3u1i"&&(C.textContent=ws),F=t(s),A=p(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1xv3qq4"&&(A.innerHTML=Us),Y=t(s),y(d.$$.fragment,s),K=t(s),I=p(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-tdrc12"&&(I.textContent=hs),q=t(s),u=p(s,"DIV",{style:!0,"data-svelte-h":!0}),i(u)!=="svelte-jde2l9"&&(u.innerHTML=bs),P=t(s),y(g.$$.fragment,s),O=t(s),k=p(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1uih3t1"&&(k.textContent=Cs),ss=t(s),y(f.$$.fragment,s),ls=t(s),N=p(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1c8r0oi"&&(N.textContent=As),es=t(s),y(Q.$$.fragment,s),ns=t(s),B=p(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-ee9vxe"&&(B.innerHTML=ds),as=t(s),y(E.$$.fragment,s),ts=t(s),V=p(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1lhl3a"&&(V.textContent=Is),Ms=t(s),y(Z.$$.fragment,s),ps=t(s),D=p(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1tjla8l"&&(D.textContent=gs),is=t(s),y(x.$$.fragment,s),js=t(s),W=p(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1dcx6hk"&&(W.textContent=ks),ys=t(s),T=p(s,"DIV",{style:!0,"data-svelte-h":!0}),i(T)!=="svelte-5cde1n"&&(T.innerHTML=fs),cs=t(s),y(R.$$.fragment,s),os=t(s),z=p(s,"P",{}),Ns(z).forEach(e),this.h()},h(){Qs(m,"name","hf:doc:metadata"),Qs(m,"content",$s),Js(u,"display","flex"),Js(u,"align-items","center"),Js(T,"display","flex"),Js(T,"align-items","center")},m(s,l){Ws(document.head,m),n(s,$,l),n(s,L,l),n(s,_,l),c(w,s,l),n(s,G,l),c(U,s,l),n(s,S,l),n(s,h,l),n(s,H,l),n(s,b,l),n(s,X,l),n(s,C,l),n(s,F,l),n(s,A,l),n(s,Y,l),c(d,s,l),n(s,K,l),n(s,I,l),n(s,q,l),n(s,u,l),n(s,P,l),c(g,s,l),n(s,O,l),n(s,k,l),n(s,ss,l),c(f,s,l),n(s,ls,l),n(s,N,l),n(s,es,l),c(Q,s,l),n(s,ns,l),n(s,B,l),n(s,as,l),c(E,s,l),n(s,ts,l),n(s,V,l),n(s,Ms,l),c(Z,s,l),n(s,ps,l),n(s,D,l),n(s,is,l),c(x,s,l),n(s,js,l),n(s,W,l),n(s,ys,l),n(s,T,l),n(s,cs,l),c(R,s,l),n(s,os,l),n(s,z,l),rs=!0},p:Es,i(s){rs||(o(w.$$.fragment,s),o(U.$$.fragment,s),o(d.$$.fragment,s),o(g.$$.fragment,s),o(f.$$.fragment,s),o(Q.$$.fragment,s),o(E.$$.fragment,s),o(Z.$$.fragment,s),o(x.$$.fragment,s),o(R.$$.fragment,s),rs=!0)},o(s){r(w.$$.fragment,s),r(U.$$.fragment,s),r(d.$$.fragment,s),r(g.$$.fragment,s),r(f.$$.fragment,s),r(Q.$$.fragment,s),r(E.$$.fragment,s),r(Z.$$.fragment,s),r(x.$$.fragment,s),r(R.$$.fragment,s),rs=!1},d(s){s&&(e($),e(L),e(_),e(G),e(S),e(h),e(H),e(b),e(X),e(C),e(F),e(A),e(Y),e(K),e(I),e(q),e(u),e(P),e(O),e(k),e(ss),e(ls),e(N),e(es),e(ns),e(B),e(as),e(ts),e(V),e(Ms),e(ps),e(D),e(is),e(js),e(W),e(ys),e(T),e(cs),e(os),e(z)),e(m),J(w,s),J(U,s),J(d,s),J(g,s),J(f,s),J(Q,s),J(E,s),J(Z,s),J(x,s),J(R,s)}}}const $s='{"title":"Keypoint Detection","local":"keypoint-detection","sections":[],"depth":1}';function _s(ms){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends Zs{constructor(m){super(),Ds(this,m,_s,zs,Bs,{})}}export{Ks as component};
